function RenderQuestionnaire(options) {

    i18n = eqspI18nRenderQuestionnaire;

    if (!options.DisplayMode) options.DisplayMode = "run";

    var self = this;

    this.ExtendedQuestionsData = {};

    const setFancybox = function () {
        document.querySelectorAll('.passing__text img').forEach(function (image) {
            const src = image.getAttribute('src');
            console.log(src);
            $(image).wrap(`<a href="${src}" data-fancybox></a>`);
            $('a[data-fancybox]').fancybox();
        });
    };

    var questionsOrder = [];

    function updateNavigationHighlight(selector, attribute, value) {
        $(selector).removeClass('btn--run-primary');
        $(selector).find(`button[data-${attribute}id="${value}"]`).addClass('btn--run-primary');
    }

    function handleAjaxSuccess(response, questionId) {
        $("#wrapper").html("");
        options.QuestionRenderer.RenderQuestionData(response.QuestionData, self.ExtendedQuestionsData);

        if (response.RandomOrder && $("span.badge")) {
            $("span.badge").remove();
        }

        $("#answered").html(response.Total);

        renderNavigationButtons(questionId, response);

        setFancybox();

        Preloader.DisableLoader(".passing");
    }

    function renderNavigationButtons(questionId, response) {
        const firstQuestionId = questionsOrder[0];
        const lastQuestionId = questionsOrder[questionsOrder.length - 1];
        const currentId = questionsOrder.indexOf(questionId);
        const isQuestionnaire = options.Type === "questionnaire";
        const isTest = options.Type === "test";
        const enableBack = !options.IsQuestionLogic && options.EnableBackButton;
        const enableSkip = !options.IsQuestionLogic && options.EnableSkipButton && !response.QuestionData.IsRequired;

        //$("#wrapper").html("");
        if (questionId === firstQuestionId) {
            $("#wrapper").append(`<button class="show_question_save btn btn-sm btn--run-primary nav_button" data-questionid="${questionsOrder[1]}">${i18n.button_Next}</button>`);
            if (enableSkip) {
                $("#wrapper").append(`<button class="show_question_skip btn btn-sm btn--run-default nav_button" data-questionid="${questionsOrder[1]}">${i18n.button_Skip}</button>`);
            }
        } else if (questionId === lastQuestionId) {
            if (enableBack && lastQuestionId !== firstQuestionId) {
                $("#wrapper").append(`<button class="show_question_save btn btn-sm btn--run-default nav_button" data-questionid="${questionsOrder[currentId - 1]}">${i18n.button_Back}</button>`);
            }
            $("#wrapper").append(`<button class="show_question_save btn btn-sm btn--run-primary nav_button" data-questionid="finish">${i18n.button_End}</button>`);
        } else {
            if (enableBack) {
                $("#wrapper").append(`<button class="show_question_save btn btn-sm btn--run-default nav_button" data-questionid="${questionsOrder[currentId - 1]}">${i18n.button_Back}</button>`);
            }
            $("#wrapper").append(`<button class="show_question_save btn btn-sm btn--run-primary nav_button" data-questionid="${questionsOrder[currentId + 1]}">${i18n.button_Next}</button>`);
            if (enableSkip) {
                $("#wrapper").append(`<button class="show_question_skip btn btn-sm btn--run-default nav_button" data-questionid="${questionsOrder[currentId + 1]}">${i18n.button_Skip}</button>`);
            }
        }
    }

    this.loadQuestionData = function (questionId, orderId) {
        Preloader.EnableLoader(".passing");

        updateNavigationHighlight("#navigation", "question", questionId);

        $.ajax({
            url: options.DisplayMode === "run" ? "/api/run/loadquestiondata" : "/api/preview/loadquestiondata",
            type: "get",
            data: {
                questionId: questionId || "first",
                respondentId: options.RespondentId,
                questionnaireId: options.QuestionnaireId
            },
            success: function (response) {
                handleAjaxSuccess(response, questionId);
            }
        });
    }

    this.RenderQuestionnaireQuestionMode = function () {
        $.ajax({
            url: options.DisplayMode === "run" ? "/api/run/getquestionsnavigations" : "/api/preview/getquestionsnavigations",
            type: "get",
            data: {
                respondentId: options.RespondentId,
                questionnaireId: options.QuestionnaireId
            },
            success: function (data) {
                if (data instanceof Array && data.length === 0) {
                    if (Notification.ShowError) {
                        Notification.ShowError(i18n.alert_NoQuestions)
                    };

                    Preloader.DisableLoader(".passing");
                    return;
                }

                Array.prototype.push.apply(questionsOrder, data);

                questionsOrder.forEach((questionId, index) => {
                    $("#navigation").append(`<button class="show_question_save nav_button btn btn-sm btn--run-default" data-orderid="${index + 1}" data-questionid="${questionId}">${index + 1}</button>`);
                });

                self.loadQuestionData(questionsOrder[0], 1);
            }
        });
    }

    if (options.ViewMode === "pages") {
        this.loadPageData = function (pageId) {
            pageId = parseInt(pageId);
            Preloader.EnableLoader(".passing");

            $("#navigation .btn--run-primary").removeClass('btn--run-primary');
            $("#navigation").find('button[data-pageid="' + pageId + '"]').addClass('btn--run-primary');

            $("#wrapper").html("");

            $.ajax({
                url: options.DisplayMode == "run" ? "/api/run/loadpagedata" : "/api/preview/loadpagedata",
                type: "get",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    pageId: pageId,
                    respondentId: options.RespondentId
                },
                success: function (questionsData) {
                    Preloader.DisableLoader(".passing");

                    if (questionsData instanceof Array && questionsData.length == 0 && options.PageCount == 1) {
                        if (Notification.ShowError) Notification.ShowError(i18n.alert_NoQuestions);
                        Preloader.DisableLoader(".passing");
                        return;
                    }

                    for (var i = 0; i < questionsData.length; i++) {
                        options.QuestionRenderer.RenderQuestionData(questionsData[i], self.ExtendedQuestionsData);
                    }

                    //next button
                    if (options.Type == "questionnaire") {
                        switch (+pageId) {
                            case options.PageCount:
                                if (!options.IsPageLogic && options.EnableBackButton && pageId > 1) { $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId - 1) + '">' + i18n.button_Back + '</button>'); }
                                $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="finish">' + i18n.button_End + '</button>');
                                break;
                            case 1:
                                $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="2">' + i18n.button_Next + '</button>');
                                if (!options.IsPageLogic && options.EnableSkipButton /*is skip enabled*/) { $("#wrapper").append('<button class="show_page_skip btn btn-sm btn--run-default nav_button" data-pageid="2">' + i18n.button_Skip + '</button>'); }
                                break;
                            default:
                                if (!options.IsPageLogic && options.EnableBackButton) { $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId - 1) + '">' + i18n.button_Back + '</button>'); }
                                $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="' + (pageId + 1) + '">' + i18n.button_Next + '</button>');
                                if (!options.IsPageLogic && options.EnableSkipButton /*is skip enabled*/) { $("#wrapper").append('<button class="show_page_skip btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId + 1) + '">' + i18n.button_Skip + '</button>'); }
                        }
                    }
                    if (options.Type == "test") {
                        switch (+pageId) {
                            case options.PageCount:
                                if (options.ShowAnswersWithMessages) $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="finish">' + i18n.button_Next + '</button>');
                                else {
                                    if (options.EnableBackButton && pageId > 1) $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId - 1) + '">' + i18n.button_Back + '</button>');
                                    $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="finish">' + i18n.button_End + '</button>');
                                }
                                break;
                            case 1:
                                if (options.ShowAnswersWithMessages) $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="2">' + i18n.button_Next + '</button>');
                                else {
                                    $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="2">' + i18n.button_Next + '</button>');
                                    if (options.EnableSkipButton /*is skip enabled*/) $("#wrapper").append('<button class="show_page_skip btn btn-sm btn--run-default nav_button" data-pageid="2">' + i18n.button_Skip + '</button>');
                                }
                                break;
                            default:
                                if (options.ShowAnswersWithMessages) $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary  nav_button" data-pageid="' + (pageId + 1) + '">' + i18n.button_Next + '</button>');
                                else {
                                    if (options.EnableBackButton) $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId - 1) + '">' + i18n.button_Back + '</button>');
                                    $("#wrapper").append('<button class="show_page_save btn btn-sm btn--run-primary nav_button" data-pageid="' + (pageId + 1) + '">' + i18n.button_Next + '</button>');
                                    if (options.EnableSkipButton /*is skip enabled*/) $("#wrapper").append('<button class="show_page_skip btn btn-sm btn--run-default nav_button" data-pageid="' + (pageId + 1) + '">' + i18n.button_Skip + '</button>');
                                }
                        }
                    }

                    setFancybox();
                }
            });
        }

        this.RenderQuestionnairePageMode = function () {
            if ((!options.IsPageLogic && options.Type == "questionnaire") || (!options.ShowAnswersWithMessages && options.Type == "test")) {
                for (var i = 1; i <= options.PageCount; i++) {
                    $("#navigation").append('<button class="show_page_save nav_button btn btn-sm btn--run-default" data-pageid="' + i + '">' + i + '</button>');
                }
            }

            self.loadPageData(1);
        }
    }

    if (options.ViewMode === "all") {
        this.RenderQuestionnaireAllMode = function () {

            Preloader.EnableLoader(".passing");

            //load all data
            $.ajax({
                url: options.DisplayMode == "run" ? "/api/run/getalldata" : "/api/preview/getalldata",
                type: "get",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    respondentId: options.RespondentId
                },
                success: function (allData) {
                    Preloader.DisableLoader(".passing");

                    if (allData instanceof Array && allData.length == 0) {
                        if (Notification.ShowError) Notification.ShowError(i18n.alert_NoQuestions);
                        Preloader.DisableLoader(".passing");
                        return;
                    }

                    allData.forEach((val, ind) => {
                        options.QuestionRenderer.RenderQuestionData(allData[ind], self.ExtendedQuestionsData);
                    });

                    //next button
                    $("#wrapper").append('<button class="all_save btn btn-sm btn--run-primary" data-questionid="finish">' + i18n.button_Next + '</button>');

                    setFancybox();
                }
            });
        }
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //EXTENDED FUSS
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    $("body").on("click", ".add_record", function (e) {
        e.preventDefault();

        const questionContainer = $(this).closest('.question_wrapper');
        const questionId = questionContainer.data("questionid");
        $(".secon_add_record").css("display", "block");

        function renderRecord(recordId) {
            const editorContainer = questionContainer.find('.record_editor');
            editorContainer.html("").addClass('record_editor_framed');

            const recordsContainer = questionContainer.find(".records");
            const recordContainer = $(`
                <div class="record_container" data-recordid="${recordId}" style="order:${recordId}">
                    <span class="mx-3">${i18n.label_NewRecord}</span>
                    <button type="button" class="record_edit btn btn-sm btn-sm--square btn-primary ml-1 my-3" title="${i18n.tooltip_EditRecord}">
                        <span class="fas fa-pencil-alt"></span>
                    </button>
                    <button type="button" class="record_remove btn btn-sm btn-sm--square btn-danger ml-1 my-3" title="${i18n.tooltip_RemoveRecord}">
                        <span class="fas fa-trash"></span>
                    </button>
                </div>
            `);

            recordsContainer.append(recordContainer);

            options.QuestionRenderer.renderRecordNameInput(editorContainer, null);

            if (Array.isArray(self.ExtendedQuestionsData[questionId])) {
                self.ExtendedQuestionsData[questionId].forEach(question => {
                    const renderFunctions = {
                        extended_multy: options.QuestionRenderer.renderExtendedMulty,
                        extended_dropdown: options.QuestionRenderer.renderExtendedDropdown,
                        extended_file: options.QuestionRenderer.renderExtendedFile,
                        extended_input: options.QuestionRenderer.renderExtendedInput
                    };

                    const renderFunction = renderFunctions[question.Type];
                    if (renderFunction) {
                        renderFunction(editorContainer, question);
                    }
                });
            }

            options.QuestionRenderer.renderSaveRecord(editorContainer, recordId);
        }

        if (options.DisplayMode != "run") {
            renderRecord(0);
        } else {
            $.ajax({
                url: '/api/run/createrecord',
                type: 'post',
                data: {
                    questionId: questionId,
                    respondentId: options.RespondentId,
                    questionnaireId: options.QuestionnaireId,
                    __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
                },
                success: function (recordId) {
                    renderRecord(recordId);
                }
            });
        }

        return false;
    });
}
