
let IS_MOBILE = false;

if (!String.prototype.startsWith) {
    String.prototype.startsWith = function (searchString, position) {
        position = position || 0;
        return this.substr(position, searchString.length) === searchString;
    };
}

function Run(options, isPreview = false) {
    var i18n = eqspI18nRun;

    var timeoutTimer;

    if (options.Countdown && options.Type == "test") {
        var endtime = new Date().setMinutes(new Date().getMinutes() + options.Countdown);
        initializeClock(endtime);
    }

    var QuestionRenderer = new RenderQuestions($("#wrapper"), options.ShowOrderId);

    var QuestionnaireRenderer = new RenderQuestionnaire({
        ViewMode: options.ViewMode,
        RespondentId: options.RespondentId,
        QuestionnaireId: options.QuestionnaireId,
        Type: options.Type,
        IsQuestionLogic: options.IsQuestionLogic,
        IsPageLogic: options.IsPageLogic,
        ShowAnswersWithMessages: options.ShowAnswersWithMessages,
        EnableBackButton: options.EnableBackButton,
        EnableSkipButton: options.EnableSkipButton,
        PageCount: options.PageCount,
        PhoneSignatureEnabled: options.PhoneSignatureEnabled,
        EmailSignatureEnabled: options.EmailSignatureEnabled,
        QuestionRenderer: QuestionRenderer,
        MaxFileSize: options.MaxFileSize
    });

    if (options.Embedded) {
        if (MutationObserver) {
            var observer = new MutationObserver(UpdateIframeHeight);
            observer.observe(document.getElementsByClassName("runForm")[0], {
                subtree: true,
                attributes: false,
                childList: true,
                characterData: true
            });
        } else {
            if (window.addEventListener) {
                window.addEventListener("DOMSubtreeModified", UpdateIframeHeight);
            } else {
                window.attachEvent("DOMSubtreeModified", UpdateIframeHeight);
            }
        }

        setInterval(function () {
            UpdateIframeHeight();
        }, 500);
    }


    async function Finish(type) {
        Preloader.EnableLoader(".passing");
        clearInterval(timeoutTimer);

        if ((options.EmailSignatureEnabled || options.PhoneSignatureEnabled) && (type !== "disqualificate")) {
            redirectToSignResults(type);
            return;
        }

        try {
            const response = await finishQuestionnaire(type);
            handleFinishResponse(response);
        } catch (error) {
            console.error("Error during finish:", error);
            Notification.ShowError("An error occurred while finishing the questionnaire.");
        } finally {
            Preloader.DisableLoader(".passing");
        }
    }

    function redirectToSignResults(type) {
        const params = new URLSearchParams({
            questionnaireId: options.QuestionnaireId,
            respondentId: options.RespondentId,
            type: type,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            embedded: options.Embedded,
            isMobile: IS_MOBILE
        });
        window.location = `/signresults?${params.toString()}`;
    }

    async function finishQuestionnaire(type) {
        var questionId = $('.question_wrapper[data-questionid]').data("questionid");
        const response = await $.ajax({
            url: "/api/finish",
            type: "post",
            data: {
                questionnaireId: options.QuestionnaireId,
                respondentId: options.RespondentId,
                endType: type,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                lastQuestionId: questionId
            }
        });
        return response;
    }

    function handleFinishResponse(response) {
        window.onbeforeunload = null;

        if (response === "end" && IS_MOBILE === true) {
            window.location = `/end/${options.QuestionnaireId}/true`;
            return;
        }

        if (response === 'unansweredQuestions') {
            handleUnansweredQuestions();
            return;
        }

        const baseUrl = options.Embedded ? "/embedded" : "";
        window.location = `${baseUrl}/${response}/${options.QuestionnaireId}${options.Embedded ? "/" + options.RespondentId : ""}`;
    }

    async function handleUnansweredQuestions() {
        try {
            var questionId = $('.question_wrapper[data-questionid]').data("questionid");
            const response = await $.ajax({
                url: "/api/finish/getunansweredhandlinglogic",
                type: "GET",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    respondentId: options.RespondentId,
                    questionId: questionId
                }
            });

            if (response.UnansweredQuestions && response.UnansweredQuestions.length > 0) {
                const errorMessage = buildErrorMessage(response);
                displayUnansweredMessage(errorMessage);

                if (response.RedirectToFirst) {
                    const firstUnanswered = response.UnansweredQuestions[0];
                    redirectToUnanswered(response.ViewMode, firstUnanswered.QuestionId, firstUnanswered.PageId, QuestionnaireRenderer);
                }
            }
        } catch (error) {
            console.error("Error handling unanswered questions:", error);
            Notification.ShowError("An error occurred while processing unanswered questions.");
        }
    }

    function buildErrorMessage(response) {
        let errorMessage = i18n.can_not_skip_requiredQuestions_page;

        if (response.ShowPositions) {
            errorMessage += ": " + (response.ViewMode !== "pages"
                ? buildQuestionPositionsMessage(response.UnansweredQuestions)
                : buildPagedPositionsMessage(response.UnansweredQuestions));
        }

        return errorMessage;
    }

    function buildQuestionPositionsMessage(unansweredQuestions) {
        return unansweredQuestions
            .map(q => q.Position)
            .sort((a, b) => a - b)
            .join(', ');
    }

    function buildPagedPositionsMessage(unansweredQuestions) {
        const pageGroups = unansweredQuestions.reduce((groups, q) => {
            (groups[q.PageId] = groups[q.PageId] || []).push(q.Position);
            return groups;
        }, {});

        return Object.entries(pageGroups)
            .map(([pageId, positions]) => `Страница ${pageId}, вопросы: ${positions.join(', ')}`)
            .join('\n');
    }

    function displayUnansweredMessage(message) {
        $("#unanswered_questions_message").remove();
        $("#navigation").after(`<div id='unanswered_questions_message'>${message}</div>`);
        Notification.ShowError(message);
    }

    function PreviewFinish(type) {
        window.location = "/api/preview/finish?questionnaireId=" + options.QuestionnaireId + "&endType=" + type;
    }

    function GetResultFormData(questions, isPreview) {

        var results = [];

        questions.forEach(function (question) {
            var jqQuestion = $(question);
            results.push(GetAnswer(jqQuestion));
        });

        $('.question_wrapper[data-questionid]').removeClass("required");

        let reducedValue = results.reduce(function (result, item) {
            if (item && (item.required || item.invalid)) {
                $('.question_wrapper[data-questionid="' + item.questionId + '"]').addClass("required");
                return result + 1;
            }
            return result;
        }, 0)

        if (reducedValue != 0) return;

        var sendObject = new FormData();
        sendObject.append("respondentId", options.RespondentId);
        sendObject.append("__RequestVerificationToken", $('#secret_form input[name="__RequestVerificationToken"]').val());
        sendObject.append("isPreview", isPreview);
        sendObject.append("type", options.Type);

        options.Type != "test" ?
            sendObject.append("mode", options.ViewMode) :
            sendObject.append("showAnswersWithMessages", options.ShowAnswersWithMessages);

        results.forEach(function (result) {
            if (result) sendObject.append(result.questionId, result.answer);
        });


        return sendObject;

    }

    function BindFunctionToSaveQuestion(e) {
        e.preventDefault();

        if ($(this).hasClass('no-active')) {
            $("body").one("click", ".show_question_save", BindFunctionToSaveQuestion);
            return;
        }

        if (options.Type == "test") {
            var requiredQstns = $(this).closest('.passing').find('div.question_wrapper[data-isrequired="true"]');
            if (requiredQstns.length > 0) {
                for (var i = 0; i < requiredQstns.length; i++) {
                    switch ($(requiredQstns[i]).attr('data-questiontype')) {
                        case "test_open":
                            var val = $(requiredQstns[i]).find('textarea').val().trim();

                            if (!val) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy_undefined":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single_undefined":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                    }
                }
                for (var i = 0; i < requiredQstns.length; i++) {
                    if ($(requiredQstns[i]).hasClass('required')) {
                        var controls = $('.nav_button').not($(this));
                        DisableControls();
                        $("body").one("click", ".show_question_save", BindFunctionToSaveQuestion);
                        return;
                        break;
                    }
                }
            }
        }

        var nextQuestionId = $(this).data("questionid");
        var questionContainer = $("#wrapper .question_wrapper").first().toArray();
        var nextOrderId = $(this).data("orderid");

        Preloader.EnableLoader(".passing");
        var sendObject = GetResultFormData(questionContainer, isPreview);

        if (!(sendObject instanceof FormData)) {
            if ($('div.question_wrapper.required').length > 0) {
                scrollToRequiredQuestion();
            }

            Preloader.DisableLoader(".passing");
            $("body").one("click", ".show_question_save", BindFunctionToSaveQuestion);
            return;
        }

        let url = GetDataUrl(isPreview, options.Type);

        $.ajax({
            url: url,
            type: "post",
            data: sendObject,
            processData: false,
            contentType: false,
            success: function (data) {
                Preloader.DisableLoader(".passing");

                if (data.ShowMessages) {
                    $(".show_question_save").removeClass('show_question_save').addClass('show_question_skip');
                    $('.show_question_skip[data-questionid="finish"]').html(i18n.button_End);
                    $('.show_question_skip[data-questionid!="finish"]').html(i18n.button_Next);
                    if (data.Messages.length == 0) {
                        $(".show_question_skip").trigger("click");
                    } else {
                        var hasMessege = false;
                        for (var i = 0; i < data.Messages.length; i++) {
                            if (data.Messages[i].Message != null) {
                                hasMessege = true;
                                break;
                            }
                        }
                        if (!hasMessege) {
                            $(".show_question_skip").trigger("click");
                        } else {
                            ShowMessages(data);
                        }

                    }
                    return;
                }

                if (data.startsWith("toquestion:")) QuestionnaireRenderer.loadQuestionData(data.substring(data.indexOf(":") + 1));

                switch (data) {
                    case "timeout":
                        isPreview ? PreviewFinish("timeout") : Finish("timeout");
                        break;
                    case "start":
                        window.onbeforeunload = null;
                        window.location = (options.Embedded ? "/embedded" : "") + "/start/" + options.QuestionnaireId;
                        break;
                    case "disqualificate":
                        isPreview ? PreviewFinish("disqualificate") : Finish("disqualificate");
                        break;
                    case "end":
                        isPreview ? PreviewFinish("end") : Finish("end");
                        break;
                    case "none":
                        if (nextQuestionId == "finish") {
                            isPreview ? PreviewFinish("end") : Finish("end");
                            return;
                        }
                        QuestionnaireRenderer.loadQuestionData(nextQuestionId, nextOrderId);
                        break;
                    default:

                }

            },
            complete: function (data) {
                $("body").one("click", ".show_question_save", BindFunctionToSaveQuestion);
            }
        })

    }

    function BindFunctionToSaveQuestionPage(e) {
        e.preventDefault();

        if ($(this).hasClass('no-active')) {
            $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
            return;
        }

        if (options.Type == "test") {
            var requiredQstns = $(this).closest('.passing').find('div.question_wrapper[data-isrequired="true"]');
            if (requiredQstns.length > 0) {
                for (var i = 0; i < requiredQstns.length; i++) {
                    switch ($(requiredQstns[i]).attr('data-questiontype')) {
                        case "test_open":
                            var val = $(requiredQstns[i]).find('textarea').val().trim();

                            if (!val) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy_undefined":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single_undefined":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                    }
                }
                for (var i = 0; i < requiredQstns.length; i++) {
                    if ($(requiredQstns[i]).hasClass('required')) {
                        var controls = $('.nav_button').not($(this));
                        DisableControls();
                        $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
                        return;
                        break;
                    }
                }
            }
        }

        var pageToShow = $(this).data("pageid");

        var questions = $("#wrapper").find("div.question_wrapper").toArray();
        Preloader.EnableLoader(".passing");

        var sendObject = GetResultFormData(questions, isPreview);

        if (!(sendObject instanceof FormData)) {
            if ($('div.question_wrapper.required').length > 0) {
                scrollToRequiredQuestion();
            }

            Preloader.DisableLoader(".passing");
            $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
            return;
        }

        let url = GetDataUrl(isPreview, options.Type);

        $.ajax({
            url: url,
            type: "post",
            data: sendObject,
            processData: false,
            contentType: false,
            success: function (data) {
                Preloader.DisableLoader(".passing");

                if (data.ShowMessages) {
                    $(".show_page_save").removeClass('show_page_save').addClass('show_page_skip');
                    $('.show_page_skip[data-pageid="finish"]').html(i18n.button_End);
                    $('.show_page_skip[data-pageid!="finish"]').html(i18n.button_Next);
                    if (data.Messages.length == 0) {
                        $(".show_page_skip").trigger("click");
                    } else {
                        var hasMessege = false;
                        for (var i = 0; i < data.Messages.length; i++) {
                            if (data.Messages[i].Message != null) {
                                hasMessege = true;
                                break;
                            }
                        }
                        if (!hasMessege) {
                            $(".show_question_skip").trigger("click");
                        } else {
                            ShowMessages(data);
                        }

                    }
                    return;
                }

                if (data.startsWith("topage:")) QuestionnaireRenderer.loadPageData(data.substring(data.indexOf(":") + 1));

                switch (data) {
                    case "timeout":
                        isPreview ? PreviewFinish("timeout") : Finish("timeout");
                        break;
                    case "start":
                        window.onbeforeunload = null;
                        window.location = (options.Embedded ? "/embedded" : "") + "/start/" + options.QuestionnaireId;
                        break;
                    case "disqualificate":
                        isPreview ? PreviewFinish("disqualificate") : Finish("disqualificate");
                        break;
                    case "end":
                        isPreview ? PreviewFinish("end") : Finish("end");
                        break;
                    case "none":
                        if (pageToShow == "finish") {
                            isPreview ? PreviewFinish("end") : Finish("end");
                            return;
                        }
                        QuestionnaireRenderer.loadPageData(pageToShow);
                        break;
                    default:

                }

            },
            complete: function (data) {
                $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
            }
        });
    }

    function BindFunctionToSaveQuestionAll(e) {
        e.preventDefault();

        if ($(this).hasClass('no-active')) {
            $("body").one("click", ".all_save", BindFunctionToSaveQuestionAll);
            return;
        }

        if (options.Type == "test") {
            var requiredQstns = $(this).closest('#wrapper').find('div.question_wrapper[data-isrequired="true"]');
            if (requiredQstns.length > 0) {
                for (var i = 0; i < requiredQstns.length; i++) {
                    switch ($(requiredQstns[i]).attr('data-questiontype')) {
                        case "test_open":
                            var val = $(requiredQstns[i]).find('textarea').val().trim();

                            if (!val) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_multy_undefined":
                            var vals = $(requiredQstns[i]).find('input[type="checkbox"]:checked');
                            if (!vals.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                        case "test_single_undefined":
                            var val = $(requiredQstns[i]).find('input[type="radio"]:checked');
                            if (!val.length) {
                                $(requiredQstns[i]).addClass('required');
                                continue;
                            }
                            break;
                    }
                }
                for (var i = 0; i < requiredQstns.length; i++) {
                    if ($(requiredQstns[i]).hasClass('required')) {
                        $("body").one("click", ".all_save", BindFunctionToSaveQuestionAll);
                        return;
                        break;
                    }
                }
            }
        }

        var questions = $("#wrapper").find("div.question_wrapper").toArray();
        Preloader.EnableLoader(".passing");

        var sendObject = GetResultFormData(questions, isPreview);

        if (!(sendObject instanceof FormData)) {
            if ($('div.question_wrapper.required').length > 0) {
                scrollToRequiredQuestion();
            }

            Preloader.DisableLoader(".passing");
            $("body").one("click", ".all_save", BindFunctionToSaveQuestionAll);
            return;
        }

        let url = GetDataUrl(isPreview, options.Type);

        $.ajax({
            url: url,
            type: "post",
            data: sendObject,
            processData: false,
            contentType: false,
            success: function (data) {
                Preloader.DisableLoader(".passing");

                if (data.ShowMessages) {
                    $(".all_save").removeClass('all_save').addClass('all_skip').html(i18n.button_End);
                    $('.show_page_skip[data-pageid="finish"]').html(i18n.button_End);
                    $('.show_page_skip[data-pageid!="finish"]').html(i18n.button_Next);
                    if (data.Messages.length == 0) {
                        $(".show_question_skip").trigger("click");
                    } else {
                        var hasMessege = false;
                        for (var i = 0; i < data.Messages.length; i++) {
                            if (data.Messages[i].Message != null) {
                                hasMessege = true;
                                break;
                            }
                        }
                        if (!hasMessege) {
                            $(".show_question_skip").trigger("click");
                        } else {
                            ShowMessages(data);
                        }

                    }
                    return;
                }


                switch (data) {
                    case "timeout":
                        isPreview ? PreviewFinish("timeout") : Finish("timeout");
                        break;
                    case "disqualificate":
                        isPreview ? PreviewFinish("disqualificate") : Finish("disqualificate");
                        break;
                    default:
                        isPreview ? PreviewFinish("end") : Finish("end");
                }
            },
            complete: function (data) {
                $("body").one("click", ".all_save", BindFunctionToSaveQuestionAll);
            }
        });
    }

    function GetAnswer(jqQuestionWrapper) {
        const questionType = jqQuestionWrapper.data("questiontype");
        const answerHandlers = {
            "questionnaire_single": GetRespondentAnswerQSingle,
            "questionnaire_textblock": GetRespondentAnswerQTextblock,
            "questionnaire_multy": GetRespondentAnswerQMulty,
            "questionnaire_matrix": GetRespondentAnswerQMatrix,
            "questionnaire_file": GetRespondentAnswerQFile,
            "questionnaire_table": GetRespondentAnswerQTable,
            "questionnaire_extended": GetExtendedQuestionRecordInfo,
            "questionnaire_autocomplete": GetRespondentAnswerQAutocomplete,
            "questionnaire_input": GetRespondentAnswerQInput,
            "questionnaire_dadatainput": GetRespondentAnswerQDaDataInput,
            "questionnaire_dropdown": GetRespondentAnswerQDropdown,
            "questionnaire_scale": GetRespondentAnswerQScale,
            "test_scale": GetRespondentAnswerQScale,
            "questionnaire_nps": GetRespondentAnswerQNps,
            "questionnaire_rating": GetRespondentAnswerQRating,
            "test_single_undefined": GetRespondentAnswerTSingle,
            "test_single": GetRespondentAnswerTSingle,
            "test_multy_undefined": GetRespondentAnswerTMulty,
            "test_multy": GetRespondentAnswerTMulty,
            "test_open": GetRespondentAnswerTOpen,
            "test_table": GetRespondentAnswerTTable,
            "questionnaire_date": GetRespondentAnswerQDate,
            "questionnaire_scale_two_slide": GetRespondentAnswerQScaleWithTwoSliders,
            "questionnaire_spreadsheet": GetRespondentAnswerQSpreadsheet
        };

        const handler = answerHandlers[questionType];
        return handler ? handler(jqQuestionWrapper) : undefined;
    }

    function scrollToRequiredQuestion() {
        var scrollToNode = document.querySelectorAll('div.question_wrapper.required')[0];
        window.scrollTo(scrollToNode.offsetLeft, scrollToNode.offsetTop);

        let minchecked = scrollToNode.getAttribute("data-minchecked");
        let maxchecked = scrollToNode.getAttribute("data-maxchecked");

        if (minchecked == undefined && maxchecked == undefined) {
            var phoneNumberElement = scrollToNode.querySelector('.PhoneNumber');

            if (scrollToNode && scrollToNode.getAttribute('invalid') === 'invalid') {
                Notification.ShowError(i18n.input_is_invalid, " ", 2000);
            }else {
            Notification.ShowError(i18n.can_not_skip_requiredQuestions_page, " ", 2000);
        }
    }
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //QUESTIONS VIEW MODE
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    if (options.ViewMode === "questions") {
        setupQuestionMode();
    } else if (options.ViewMode === "pages") {
        setupPageMode();
    } else if (options.ViewMode === "all") {
        setupAllMode();
    }

    function setupQuestionMode() {
        QuestionnaireRenderer.RenderQuestionnaireQuestionMode();
        $("body").on("click", ".show_question_skip", handleQuestionSkip);
        $("body").one("click", ".show_question_save", BindFunctionToSaveQuestion);
    }

    function setupPageMode() {
        QuestionnaireRenderer.RenderQuestionnairePageMode();
        $("body").on("click", ".show_page_skip", handlePageSkip);
        $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
    }

    function setupAllMode() {
        QuestionnaireRenderer.RenderQuestionnaireAllMode();
        $("body").one("click", ".all_save", BindFunctionToSaveQuestionAll);
        $("body").on("click", ".all_skip", () => isPreview ? PreviewFinish("end") : Finish("end"));
    }

    function handleQuestionSkip(e) {
        e.preventDefault();
        if ($(this).hasClass('no-active')) {
            $("body").one("click", ".show_question_skip", BindFunctionToSaveQuestion);
            return;
        }
        if (!validateRequiredQuestions(this, 'question')) return;
        processSkip(this, 'question');
    }

    function handlePageSkip(e) {
        e.preventDefault();
        if ($(this).hasClass('no-active')) {
            $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
            return;
        }
        if (!validateRequiredQuestions(this, 'page')) return;
        processSkip(this, 'page');
    }

    function validateRequiredQuestions(element, mode) {
        if (options.Type === "test") {
            const requiredQstns = $(element).closest('#wrapper').find('div.question_wrapper[data-isrequired="true"]');
            if (requiredQstns.length > 0 && !validateTestQuestions(requiredQstns)) {
                if (mode === 'page') $("body").one("click", ".show_page_save", BindFunctionToSaveQuestionPage);
                return false;
            }
        }

        const questions = mode === 'question' ?
            $("#wrapper .question_wrapper").first().toArray() :
            $("#wrapper").find("div.question_wrapper").toArray();

        const sendObject = GetResultFormData(questions, isPreview);
        if (!(sendObject instanceof FormData)) {
            if ($('div.question_wrapper.required').length > 0) {
                scrollToRequiredQuestion();
            }
            return false;
        }

        const requiredQuestions = $(element).closest('#wrapper').find('div.question_wrapper[data-isrequired="true"]');
        if (requiredQuestions.length !== 0 && options.Type !== "test") {
            if (mode === 'page') {
                Notification.ShowError(i18n.can_not_skip_requiredQuestions_page, " ", 2000);
            } else {
                scrollToRequiredQuestion();
            }
            return false;
        }

        return true;
    }

    function processSkip(element, mode) {
        if ($(element).data(mode + 'id') === "finish") {
            isPreview ? PreviewFinish("end") : Finish("end");
            return;
        }

        if (mode === 'question') {
            const nextQuestionId = $(element).data("questionid");
            const nextOrderId = $(element).data("orderid");
            QuestionnaireRenderer.loadQuestionData(nextQuestionId, nextOrderId);
        } else {
            QuestionnaireRenderer.loadPageData($(element).data("pageid"));
        }
    }

    function validateTestQuestions(requiredQstns) {
        for (let i = 0; i < requiredQstns.length; i++) {
            const qstn = $(requiredQstns[i]);
            const type = qstn.attr('data-questiontype');
            let isValid = false;

            switch (type) {
                case "test_open":
                    isValid = qstn.find('textarea').val().trim() !== "";
                    break;
                case "test_multy":
                case "test_multy_undefined":
                    isValid = qstn.find('input[type="checkbox"]:checked').length > 0;
                    break;
                case "test_single":
                case "test_single_undefined":
                    isValid = qstn.find('input[type="radio"]:checked').length > 0;
                    break;
            }

            if (!isValid) {
                qstn.addClass('required');
                return false;
            }
        }
        return true;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //GET ANSWERS
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Helper functions
    function handleInputValidation(input, isRequired) {
        const questionWrapper = input.closest('.question_wrapper[data-questionid]');
        const questionId = questionWrapper.attr('data-questionid');

        if (isRequired) {
            if (input.val().trim() === "") {
                questionWrapper.addClass("required");
            } else {
                questionWrapper.removeClass("required");
            }
        } else {
            questionWrapper.removeClass("required");
        }
    }

    function handleDaDataInputValidation(input, isRequired) {
        const questionWrapper = input.closest('.question_wrapper[data-questionid]');
        const questionId = questionWrapper.attr('data-questionid');
        var inputData = $(document.getElementById("DaDataInput_" + questionId)).data("kendoAutoComplete");

        if (isRequired) {
            if (inputData.value().trim() === "") {
                questionWrapper.addClass("required");
            } else {
                questionWrapper.removeClass("required");
            }
        } else {
            questionWrapper.removeClass("required");
        }
    }

    function handleUserOptionInput(input) {
        const questionId = input.attr('name');
        const container = input.closest(`.question_wrapper[data-questionid="${questionId}"]`);
        const questionType = container.attr('data-questiontype');
        const isRequired = container.attr('data-isrequired') === 'true';

        if (input.val().trim() === "") {
            handleEmptyUserOption(container, questionType, isRequired);
        } else {
            handleFilledUserOption(container);
        }
    }

    function handleEmptyUserOption(container, questionType, isRequired) {
        switch (questionType) {
            case 'questionnaire_multy':
                handleMultyEmptyUserOption(container, isRequired);
                break;
            case 'questionnaire_single':
                handleSingleEmptyUserOption(container, isRequired);
                break;
            case 'questionnaire_dropdown':
                handleDropdownEmptyUserOption(container, isRequired);
                break;
        }
    }

    function handleFilledUserOption(container) {
        container.removeClass("required");
        EnableControls();
        if ($('.passing').find('div.required').length !== 0) {
            DisableControls();
        }
    }

    function handleMultyEmptyUserOption(container, isRequired) {
        const checkedOptions = container.find('input[type="checkbox"][data-answeroptionid!="useroption"]:checked').length;
        if (!isRequired || checkedOptions > 0) {
            container.removeClass("required");
            EnableControls();
        } else {
            container.addClass("required");
            DisableControls();
        }
    }

    function handleSingleEmptyUserOption(container, isRequired) {
        if (!isRequired || container.find('input[type="radio"]').is(":checked")) {
            container.removeClass("required");
            EnableControls();
        } else {
            container.addClass("required");
            DisableControls();
        }
    }

    function handleDropdownEmptyUserOption(container, isRequired) {
        if (!isRequired || container.find('select').val() !== "useroption") {
            container.removeClass("required");
            EnableControls();
        } else {
            container.addClass("required");
            DisableControls();
        }
    }

    // Event handlers
    $("body").on("input", '.question_wrapper[data-questiontype="questionnaire_input"] input.form-control[type="text"][name], input.form-control.numberinput, input.form-control.onlyInt, input.form-control.moreZero, input.form-control.moreZeroWithZero, input.form-control.lessZero, input.form-control.lessZeroWithZero, input.form-control.withOutZero, input.form-control.numberRange, input.form-control.URL, input.form-control.maskedtextbox, input.form-control.emailinput, input.form-control.IPv4, input.form-control.IPv6, input.form-control.CreditCard, input.form-control.ISBN, .question_wrapper[data-questiontype="questionnaire_input"] textarea.form-control', function () {
        const isRequired = $(this).closest('.question_wrapper[data-questionid]').attr("data-isrequired") === "true";
        handleInputValidation($(this), isRequired);
    });

    $("body").on("input", '.question_wrapper[data-questiontype="questionnaire_dadatainput"]', function () {
        const isRequired = $(this).closest('.question_wrapper[data-questionid]').attr("data-isrequired") === "true";
        handleDaDataInputValidation($(this), isRequired);
    });

    $("body").on("input", 'input[type="text"][name][data-useroption="useroption"]', function () {
        handleUserOptionInput($(this));
    });

    $("body").on("input", '.question_wrapper[data-questiontype="test_open"] textarea', function () {
        const questionId = $(this).attr("name");
        const container = $('.question_wrapper[data-questionid="' + questionId + '"]');
        const isRequired = $(container).data("isrequired");

        if (isRequired) {
            if ($(this).val()) {
                $(container).removeClass('required');
                EnableControls();
            } else {
                $(container).addClass('required');
                DisableControls();
            }
        }
    });
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Helper functions
    const updateControlState = () => {
        $('.passing').find('div.required').length !== 0 ? DisableControls() : EnableControls();
    };

    const handleInputChange = (questionType, inputType) => {
        $("body").on("change", `.question_wrapper[data-questiontype="${questionType}"] input[type="${inputType}"][name]`, function () {
            const $input = $(this);
            const questionId = $input.attr("name");
            const $questionWrapper = $(`.question_wrapper[data-questionid="${questionId}"]`);
            const isRequired = $questionWrapper.data("isrequired");
            const isChecked = $input.is(":checked");

            if (isRequired) {
                $questionWrapper.toggleClass('required', !isChecked);
                isChecked ? EnableControls() : DisableControls();
            }

            if ($('.question_wrapper').length > 1) {
                updateControlState();
            }
        });
    };

    // Event handlers
    handleInputChange("questionnaire_single", "radio");
    handleInputChange("test_single", "radio");
    handleInputChange("test_multy", "checkbox");

    $("body").on("change", 'select[name]', function () {
        const $select = $(this);
        const questionId = $select.attr("name");
        const $textInput = $(`input[type="text"][name="${questionId}"]`);
        const $questionWrapper = $(`.question_wrapper[data-questionid="${questionId}"]`);
        const isUserOption = $select.val().trim() === "useroption";

        isUserOption ? handleUserOption($textInput, $questionWrapper) : handleOtherOption($textInput, $questionWrapper);

        if ($('.question_wrapper').length > 1) {
            updateControlState();
        }
    });

    $("body").on("change", '.question_wrapper[data-questiontype="questionnaire_multy"] input[type="checkbox"][name]', function (e) {

        var questionId = $(this).attr("name");


        if ($(this).data("answeroptionid") == "useroption") {

            if ($(this).is(":checked")) {
                $('input[type="text"][name="' + questionId + '"]').val("");
                $('input[type="text"][name="' + questionId + '"]').removeAttr("readonly");
                if ($('input[type = "text"][name="' + questionId + '"][data-useroption]').val().trim() == "") {
                    if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"][data-answeroptionid!="useroption"]').filter(':checked').length != 0) {
                        $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                        EnableControls();
                        if ($('*').find('.question_wrapper').length > 1) {
                            if ($('.passing').find('div.required').length != 0) {
                                DisableControls();
                            } else {
                                EnableControls();
                            }
                        }
                    } else {
                        if (!($('.question_wrapper[data-questionid="' + questionId + '"]')[0].hasAttribute('data-isrequired'))) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                            DisableControls();
                        }
                    }
                }
                else {
                    if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"][data-answeroptionid!="useroption"]').filter(':checked').length != 0) {
                        $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                        EnableControls();
                        if ($('*').find('.question_wrapper').length > 1) {
                            if ($('.passing').find('div.required').length != 0) {
                                DisableControls();
                            } else {
                                EnableControls();
                            }
                        }
                    } else {
                        if (!($('.question_wrapper[data-questionid="' + questionId + '"]')[0].hasAttribute('data-isrequired'))) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                            DisableControls();
                        }
                    }
                }
            } else {
                $('input[type="text"][name="' + questionId + '"]').val("");
                $('input[type="text"][name="' + questionId + '"]').attr("readonly", "readonly");
                $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                EnableControls();
                if ($('*').find('.question_wrapper').length > 1) {
                    if ($('.passing').find('div.required').length != 0) {
                        DisableControls();
                    } else {
                        EnableControls();
                    }
                }
            }
        }
        else {
            if ($(this).is(":checked")) {
                if ($('input[type="checkbox"][name="' + questionId + '"][data-answeroptionid="useroption"]').is(':checked')) {
                    if ($('input[type = "text"][name="' + questionId + '"][data-useroption]').val().trim() == "") {
                        if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"][data-answeroptionid!="useroption"]').filter(':checked').length != 0) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            if (!($('.question_wrapper[data-questionid="' + questionId + '"]')[0].hasAttribute('data-isrequired'))) {
                                $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                                EnableControls();
                                if ($('*').find('.question_wrapper').length > 1) {
                                    if ($('.passing').find('div.required').length != 0) {
                                        DisableControls();
                                    } else {
                                        EnableControls();
                                    }
                                }
                            } else {
                                $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                                DisableControls();
                            }
                        }
                    }
                    else {
                        if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"][data-answeroptionid!="useroption"]').filter(':checked').length != 0) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                            DisableControls();
                        }
                    }
                }
                else {
                    $('input[type="text"][name="' + questionId + '"]').val("");
                    $('input[type="text"][name="' + questionId + '"]').attr("readonly", "readonly");
                    $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                    EnableControls();
                    if ($('*').find('.question_wrapper').length > 1) {
                        if ($('.passing').find('div.required').length != 0) {
                            DisableControls();
                        } else {
                            EnableControls();
                        }
                    }
                }
            } else {
                if ($('input[type="checkbox"][name="' + questionId + '"][data-answeroptionid="useroption"]').is(':checked')) {
                    if ($('input[type = "text"][name="' + questionId + '"][data-useroption]').val().trim() == "") {
                        if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"][data-answeroptionid!="useroption"]').filter(':checked').length != 0) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            if (!($('.question_wrapper[data-questionid="' + questionId + '"]')[0].hasAttribute('data-isrequired'))) {
                                $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                                EnableControls();
                                if ($('*').find('.question_wrapper').length > 1) {
                                    if ($('.passing').find('div.required').length != 0) {
                                        DisableControls();
                                    } else {
                                        EnableControls();
                                    }
                                }
                            } else {
                                $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                                DisableControls();
                            }
                        }
                    }
                    else {
                        if ($('.question_wrapper[data-questionid="' + questionId + '"]').find('input[type="checkbox"]').filter(':checked').length != 0) {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                            EnableControls();
                            if ($('*').find('.question_wrapper').length > 1) {
                                if ($('.passing').find('div.required').length != 0) {
                                    DisableControls();
                                } else {
                                    EnableControls();
                                }
                            }
                        } else {
                            $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                            DisableControls();
                        }
                    }
                }
                else {
                    $('input[type="text"][name="' + questionId + '"]').val("");
                    $('input[type="text"][name="' + questionId + '"]').attr("readonly", "readonly");
                    $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                    EnableControls();
                    if ($('*').find('.question_wrapper').length > 1) {
                        if ($('.passing').find('div.required').length != 0) {
                            DisableControls();
                        } else {
                            EnableControls();
                        }
                    }
                }
            }

        }
    });

    $("body").on("change", '.question_wrapper[data-questiontype="questionnaire_single"] input[type="radio"][name]', function (e) {
        //console.log("change");
        var questionId = $(this).attr("name");

        if ($(this).data("answeroptionid") == "useroption" && $(this).is(":checked")) {
            $('input[type="text"][name="' + questionId + '"]').removeAttr("readonly");
            $('input[type="text"][name="' + questionId + '"]').val("");
            if ($('input[type = "text"][name="' + questionId + '"][data-useroption]').val().trim() == "") {
                if (!($('.question_wrapper[data-questionid="' + questionId + '"]')[0].hasAttribute('data-isrequired'))) {
                    $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                    EnableControls();
                    if ($('*').find('.question_wrapper').length > 1) {
                        if ($('.passing').find('div.required').length != 0) {
                            DisableControls();
                        } else {
                            EnableControls();
                        }
                    }
                } else {
                    $('.question_wrapper[data-questionid="' + questionId + '"]').addClass("required");
                    DisableControls();
                }
            }
            else {
                $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
                EnableControls();
                if ($('*').find('.question_wrapper').length > 1) {
                    if ($('.passing').find('div.required').length != 0) {
                        DisableControls();
                    } else {
                        EnableControls();
                    }
                }
            }
        } else {
            $('input[type="text"][name="' + questionId + '"]').val("");
            $('input[type="text"][name="' + questionId + '"]').attr("readonly", "readonly");
            $('.question_wrapper[data-questionid="' + questionId + '"]').removeClass("required");
            EnableControls();
            if ($('*').find('.question_wrapper').length > 1) {
                if ($('.passing').find('div.required').length != 0) {
                    DisableControls();
                } else {
                    EnableControls();
                }
            }
        }

    });


    $("body").on("change", '.extended_question_wrapper input[type="radio"]', function () {
        const $container = $(this).closest(".question_wrapper");
        const $rows = $container.find('.extended_question_wrapper');
        const checkedCount = $rows.find('input[type="radio"]:checked').length;
        const isRequired = $container.data("isrequired");

        handleExtendedQuestionChange($container, $rows, checkedCount, isRequired);
    });

    $("body").on("change", ".question_file", function () {
        if (!this.files[0]) return false;

        const file = this.files[0];
        const $container = $(this).closest('div.question_wrapper');
        const $extendedQuestion = $container.closest('[data-questiontype=questionnaire_extended]');
        const allowedTypes = $(this).data('allowedtypes').toLowerCase().split(',').map(x => x.trim());
        const maxFileSize = parseInt($container.attr('data-maxfilesize'), 10);

        handleFileUpload(file, $container, $extendedQuestion, allowedTypes, maxFileSize, this);
    });

    // Helper functions implementations
    function handleUserOption($textInput, $questionWrapper) {
        $textInput.removeAttr("readonly").val("");
        const userOptionValue = $textInput.filter('[data-useroption]').val().trim();
        const isRequired = $questionWrapper.data("isrequired");

        if (userOptionValue === "" && isRequired) {
            $questionWrapper.addClass("required");
            DisableControls();
        } else {
            $questionWrapper.removeClass("required");
            EnableControls();
        }
    }

    function handleOtherOption($textInput, $questionWrapper) {
        $textInput.val("").attr("readonly", "readonly");
        $questionWrapper.removeClass("required");
        EnableControls();
    }

    function handleCheckboxChange($checkbox, $questionWrapper, $userOptionInput, $otherCheckboxes, isUserOption) {
        if (isUserOption) {
            $checkbox.is(":checked") ? $userOptionInput.val("").removeAttr("readonly") : $userOptionInput.val("").attr("readonly", "readonly");
        } else if (!$checkbox.is(":checked") && $otherCheckboxes.filter(':checked').length === 0) {
            $(`input[type="checkbox"][name="${$checkbox.attr("name")}"][data-answeroptionid="useroption"]`).prop('checked', false);
            $userOptionInput.val("").attr("readonly", "readonly");
        }

        updateQuestionState($questionWrapper, $userOptionInput, $otherCheckboxes);
    }

    function updateQuestionState($questionWrapper, $userOptionInput, $otherCheckboxes) {
        const isUserOptionChecked = $questionWrapper.find('input[type="checkbox"][data-answeroptionid="useroption"]').is(':checked');
        const isOtherOptionChecked = $otherCheckboxes.filter(':checked').length > 0;
        const isUserOptionFilled = $userOptionInput.val().trim() !== "";
        const isRequired = $questionWrapper.data("isrequired");

        if (isUserOptionChecked && !isUserOptionFilled && !isOtherOptionChecked && isRequired) {
            $questionWrapper.addClass("required");
            DisableControls();
        } else {
            $questionWrapper.removeClass("required");
            EnableControls();
        }

        if ($('.question_wrapper').length > 1) {
            updateControlState();
        }
    }

    function handleExtendedQuestionChange($container, $rows, checkedCount, isRequired) {
        if (isRequired) {
            if ($rows.length === checkedCount) {
                $container.removeClass("required");
                EnableControls();
                if ($('.question_wrapper').length > 1) {
                    updateControlState();
                }
            } else {
                $container.addClass("required");
                DisableControls();
            }
        } else {
            EnableControls();
        }
    }

    function handleFileUpload(file, $container, $extendedQuestion, allowedTypes, maxFileSize, inputElement) {
        const fileType = file.name.split('.').pop().toLowerCase();
        const isValidType = !["bat", "exe", "dll"].includes(fileType) && allowedTypes.includes(fileType);
        const isValidSize = file.size <= maxFileSize;

        if (isValidType && isValidSize) {
            updateFileUploadUI($container, $extendedQuestion, true);
        } else {
            const errorMessage = !isValidType ? i18n.file_Incorrectet_type : i18n.message_fileLimitSize;
            updateFileUploadUI($container, $extendedQuestion, false, errorMessage, inputElement);
        }
    }

    function updateFileUploadUI($container, $extendedQuestion, isValid, errorMessage = '', inputElement = null) {
        const $fileInfo = $container.find('.file_info');
        const $invalidText = $container.find('span.invalid_text');

        if (isValid) {
            $invalidText.text('');
            $container.removeAttr("invalid").removeClass("required");
            $extendedQuestion.removeAttr('invalid').removeClass('required');
        } else {
            Notification.ShowError(errorMessage);
            if (inputElement) {
                inputElement.value = "";
                inputElement.nextSibling.innerHTML = i18n.file_Not_selected;
            }
            $fileInfo.remove();

            $container.attr("invalid", "invalid").addClass("required");
            $extendedQuestion.attr('invalid', 'invalid').addClass('required');

            if ($invalidText.length) {
                $invalidText.text(errorMessage);
            } else {
                $('<span>').addClass('invalid_text').text(errorMessage).appendTo($container);
            }
        }
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    // NPS Option Handling
    $("body").on("click", ".nps_option", handleNpsOptionClick);

    function handleNpsOptionClick() {
        const $this = $(this);
        const questionId = $this.closest('div.question_wrapper').attr('data-questionid');
        const $wrapper = $this.closest(`div.question_wrapper[data-questionid="${questionId}"]`);
        const $selected = $(`.nps-selected[name="${questionId}"]`);
        const isRequired = $wrapper.attr('data-isrequired') === 'true';

        if ($selected.length && !$this.hasClass('nps-selected')) {
            updateNpsSelection($selected, $this);
        } else {
            toggleNpsSelection($this);
        }

        updateRequiredStatus(isRequired, $(`.nps-selected[name="${questionId}"]`), $wrapper);
    }

    function updateNpsSelection($oldSelection, $newSelection) {
        $oldSelection.removeClass('nps-selected btn--run-primary');
        $newSelection.addClass('nps-selected btn--run-primary');
    }

    function toggleNpsSelection($option) {
        $option.toggleClass('nps-selected btn--run-primary btn--run-default');
    }

    // Rating Option Handling
    $("body").on("click", ".rating_option:not(.less-min-value)", handleRatingOptionClick);

    function handleRatingOptionClick() {
        const $this = $(this);
        const questionId = $this.closest('div.question_wrapper').attr('data-questionid');
        const $wrapper = $this.closest(`div.question_wrapper[data-questionid="${questionId}"]`);
        const $selected = $(`.rating-selected[name="${questionId}"]`);
        const isRequired = $wrapper.attr('data-isrequired') === 'true';

        if ($selected.length && !$this.hasClass('rating-selected')) {
            updateRatingSelection($selected, $this);
        } else {
            toggleRatingSelection($this, $wrapper);
        }

        const selectedValue = parseFloat($(`.rating-selected[name="${questionId}"]`).attr('data-optionvalue'));
        updateVisibleRatings(questionId, selectedValue);

        updateRequiredStatus(isRequired, $(`.rating-selected[name="${questionId}"]`), $wrapper);
    }

    function updateRatingSelection($oldSelection, $newSelection) {
        $oldSelection.removeClass('rating-selected');
        $newSelection.addClass('rating-selected');
    }

    function toggleRatingSelection($option, $wrapper) {
        $option.toggleClass('rating-selected');

        $wrapper.find('.previously_selected').last().addClass('rating-selected');
    }

    function updateVisibleRatings(questionId, selectedValue) {
        $(`.rating_option[name="${questionId}"]`).removeClass("visible-rating-selected");
        for (let i = 1; i < selectedValue; i++) {
            $(`.rating_option[data-optionvalue="${i}"][name="${questionId}"]`).addClass("visible-rating-selected");
        }
    }

    // Common Functions
    function updateRequiredStatus(isRequired, $selected, $wrapper) {
        if (isRequired) {
            if ($selected.length) {
                $wrapper.removeClass('required');
                EnableControls();
            } else {
                $wrapper.addClass('required');
                DisableControls();
            }
        } else {
            $wrapper.removeClass('required');
            EnableControls();
        }
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $("body").on("click", ".passing button.btn", function (e) {
        const containers = $('div.question_wrapper');
        const isPageViewMode = containers.length > 1;

        if (isPageViewMode) {
            const firstInvalidQuestion = $('div.question_wrapper.required:first');
            if (firstInvalidQuestion.length) {
                $('html, body').animate({ scrollTop: firstInvalidQuestion.offset().top }, 300);
            }
        }

        return false;
    });

    $("body").on("click", ".delete_uploaded_file", function (e) {
        const container = $(this).closest(".question_wrapper");
        container.find("label").text("");
        container.attr("data-filedeleted", "1");
        container.find(".file_info").remove();
        return false;
    });

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Record Edit Functionality
    $("body").on("click", ".record_edit", function (e) {
        const recordId = $(this).closest('.record_container').data('recordid');
        const questionContainer = $(this).closest('.question_wrapper');

        $.get('/api/run/getrecord', { recordId }, data => {
            handleRecordEditSuccess(data, questionContainer, recordId);
        });

        return false;
    });

    // Record Remove Functionality
    $("body").on("click", ".record_remove", function () {
        const recordContainer = $(this).closest('.record_container');
        const recordId = recordContainer.data('recordid');

        $.post('/api/run/removerecord', {
            recordId,
            respondentId: options.RespondentId,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
        }, () => {
            handleRecordRemoveSuccess($(this), recordId, recordContainer);
        });
    });

    // Cancel Record Edit
    $("body").on("click", ".cancel_record_edit", function (e) {
        const editorContainer = $(this).closest('.record_editor');
        editorContainer.html("").removeClass('record_editor_framed');
        return false;
    });

    // Save Record
    $("body").on("click", ".save_record", function (e) {
        e.preventDefault();
        const editorContainer = $(this).closest('.record_editor');
        const recordId = $(this).data('recordid');

        if (!validateRecordName(editorContainer)) return;

        Preloader.EnableLoader(".record_editor");

        const extendedQuestions = editorContainer.find(".extended_question_wrapper").toArray();
        const results = processExtendedQuestions(extendedQuestions);

        if (!validateResults(results)) {
            Preloader.DisableLoader(".record_editor");
            return;
        }

        const sendObject = createFormData(editorContainer, recordId, results);

        $.ajax({
            url: "/api/run/saverecorddata",
            type: "post",
            data: sendObject,
            processData: false,
            contentType: false,
            success: data => handleSaveSuccess(data, recordId, editorContainer)
        });
    });

    // Helper Functions
    function handleRecordEditSuccess(data, questionContainer, recordId) {
        const editorContainer = getEditorContainer(questionContainer);
        const questionId = questionContainer.data("questionid");

        renderRecordEditor(editorContainer, data, questionId, recordId);
    }

    function getEditorContainer(questionContainer) {
        const editorContainer = questionContainer.find('.record_editor');
        editorContainer.html("").toggleClass('record_editor_framed', editorContainer.html() === "");
        return editorContainer;
    }

    function renderRecordEditor(editorContainer, data, questionId, recordId) {
        QuestionRenderer.renderRecordNameInput(editorContainer, data.Name);

        const givenAnswers = createGivenAnswersMap(data.GivenAnswers);
        renderExtendedQuestions(editorContainer, questionId, givenAnswers);

        editorContainer.css("order", recordId + 1);
        QuestionRenderer.renderSaveRecord(editorContainer, recordId);
    }

    function createGivenAnswersMap(givenAnswers) {
        return givenAnswers.reduce((map, answer) => {
            map[answer.ExtendedQuestionId] = {
                RespondentExtendedAnswerId: answer.RespondentExtendedAnswerId,
                AnswerId: answer.AnswerId,
                AnswerValue: answer.AnswerValue
            };
            return map;
        }, {});
    }

    function renderExtendedQuestions(editorContainer, questionId, givenAnswers) {
        const extendedQuestions = QuestionnaireRenderer.ExtendedQuestionsData[questionId];
        if (Array.isArray(extendedQuestions)) {
            extendedQuestions.forEach(question => {
                renderExtendedQuestion(editorContainer, question, givenAnswers[question.ExtendedQuestionId]);
            });
        }
    }

    function renderExtendedQuestion(editorContainer, question, givenAnswer) {
        const renderFunctions = {
            "extended_multy": QuestionRenderer.renderExtendedMulty,
            "extended_dropdown": QuestionRenderer.renderExtendedDropdown,
            "extended_file": QuestionRenderer.renderExtendedFile,
            "extended_input": QuestionRenderer.renderExtendedInput
        };

        const renderFunction = renderFunctions[question.Type];
        if (renderFunction) {
            renderFunction(editorContainer, question, givenAnswer);
        }
    }

    function handleRecordRemoveSuccess(element, recordId, recordContainer) {
        const editorContainer = element.closest('.question_wrapper').find(".record_editor_framed");
        if (editorContainer.length && editorContainer.find(`.save_record[data-recordid="${recordId}"]`).length) {
            editorContainer.html("").removeClass("record_editor_framed");
        }
        record_id--;
        recordContainer.remove();

        if (element.closest('.question_wrapper').find(".record_container").length === 1) {
            $(".secon_add_record").hide();
        }
    }

    function validateRecordName(editorContainer) {
        const recordNameInput = editorContainer.find('input[name="recordName"]');
        const recordNameRequired = editorContainer.find(".record_name_required");

        if (!recordNameInput.val()) {
            recordNameRequired.show();
            return false;
        }

        recordNameRequired.hide();
        return true;
    }

    function processExtendedQuestions(extendedQuestions) {
        return extendedQuestions.map(container => {
            const $container = $(container);
            const extendedQuestionId = $container.data("extendedquestionid");
            const res = GetExtendedQuestionInfoObject($container);
            const questionType = $container.data('questiontype');

            const processFunctions = {
                "extended_dropdown": processDropdown,
                "extended_multy": processMultiSelect,
                "extended_input": processInput,
                "extended_file": processFile
            };

            const processFunction = processFunctions[questionType];
            return processFunction ? processFunction($container, res, extendedQuestionId) : null;
        }).filter(Boolean);
    }

    function processDropdown($container, res, extendedQuestionId) {
        const select = $(`select[name="${extendedQuestionId}"]`);
        if (select.val() === "noanswer") {
            return $container.data("respondentextendedanswerid") !== 0 ? { ...res, extendedQuestionInfo: res.extendedQuestionInfo + ":toremove" } : null;
        }
        return { ...res, answer: select.val() };
    }

    function processMultiSelect($container, res) {
        const checked = $container.find("input:checked").toArray();
        if (!checked.length) {
            return $container.data("respondentextendedanswerid") !== 0 ? { ...res, extendedQuestionInfo: res.extendedQuestionInfo + ":toremove" } : null;
        }
        const answerIds = checked.map(item => $(item).data("extendedansweroptionid")).join(",");
        return { ...res, answer: answerIds };
    }

    function processInput($container, res, extendedQuestionId) {
        if ($container.attr("invalid")) {
            return { invalid: true, extendedQuestionId };
        }

        const value = getInputValue($container, extendedQuestionId);
        if (!value) {
            return $container.data("respondentextendedanswerid") !== 0 ? { ...res, extendedQuestionInfo: res.extendedQuestionInfo + ":toremove" } : null;
        }
        return { ...res, answer: value };
    }

    function getInputValue($container, extendedQuestionId) {
        const inputType = $container.data("inputtype");
        const inputSelectors = {
            "date": () => $container.find(`input[name="${extendedQuestionId}"]`).data("kendoDatePicker").element[0].value,
            "textarea": () => $container.find(`textarea[name="${extendedQuestionId}"]`).val(),
            "default": () => $container.find(`input[name="${extendedQuestionId}"]`).val()
        };

        return (inputSelectors[inputType] || inputSelectors.default)();
    }

    function processFile($container, res, extendedQuestionId) {
        const fileInput = $(`input[type="file"][name="${extendedQuestionId}"]`);
        if (!fileInput.val()) {
            return $container.data("filedeleted") ? { ...res, extendedQuestionInfo: res.extendedQuestionInfo + ":toremove" } : null;
        }
        return { ...res, answer: fileInput[0].files[0] };
    }

    function validateResults(results) {
        $('.extended_question_wrapper[data-extendedquestionid]').removeClass("required");
        const invalidCount = results.reduce((count, item) => {
            if (item && item.invalid) {
                $(`.extended_question_wrapper[data-extendedquestionid="${item.extendedQuestionId}"]`).addClass("required");
                return count + 1;
            }
            return count;
        }, 0);
        return invalidCount === 0;
    }

    function createFormData(editorContainer, recordId, results) {
        const sendObject = new FormData();
        sendObject.append("respondentId", options.RespondentId);
        sendObject.append("recordId", recordId);
        sendObject.append("recordName", editorContainer.find('input[name="recordName"]').val());
        sendObject.append("__RequestVerificationToken", $('#secret_form input[name="__RequestVerificationToken"]').val());

        results.forEach(result => {
            if (result) sendObject.append(result.extendedQuestionInfo, result.answer);
        });

        return sendObject;
    }

    function handleSaveSuccess(data, recordId, editorContainer) {
        Preloader.DisableLoader(".record_editor");
        updateRecordName(recordId, data);
        const questionsHtml = generateQuestionsHtml(editorContainer);
        updateRecordContainer(recordId, questionsHtml);
        resetEditorContainer(editorContainer);
    }

    function updateRecordName(recordId, newName) {
        $(`.record_container[data-recordid="${recordId}"]`).find("span.record_name").html(newName);
    }

    function generateQuestionsHtml(editorContainer) {
        const questions = editorContainer.find(".extended_question_wrapper");
        let questionsHtml = "<div class='local_container'>";

        questions.each(function () {
            const $question = $(this);
            const questionText = $question.find("p").length ? $question.find("p")[0].innerHTML : " ";
            questionsHtml += `<div class='questions_side'>${questionText}</div><div class='answers_side'>`;

            if ($question.find("input[type='checkbox']").length) {
                questionsHtml += generateCheckboxHtml($question);
            } else if ($question.find("input[type='file']").length) {
                questionsHtml += $question.find("input").val().replace(/^.*[\\\/]/, '');
            } else {
                questionsHtml += GetAnswerText($question.find(".form-control")[0]);
            }

            questionsHtml += "</div>";
        });

        return questionsHtml + "</div>";
    }

    function generateCheckboxHtml($question) {
        return $question.find("input:checked").map(function () {
            return `<div class='answers_many'>${$(this).parent().find(".custom-control-label").html()}</div>`;
        }).get().join("");
    }

    function updateRecordContainer(recordId, questionsHtml) {
        const $recordContainer = $(`.record_container[data-recordid="${recordId}"]`);
        $recordContainer.find(".local_container").remove();
        $recordContainer.append(questionsHtml);
    }

    function resetEditorContainer(editorContainer) {
        editorContainer.html("").removeClass('record_editor_framed');
    }


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Helper function to validate input and update UI
    function validateInput(input, isValidFunc, errorMessage) {
        const container = input.closest('div.question_wrapper');
        const value = input.val().trim();
        const isValid = isValidFunc(value);

        container.toggleClass("invalid", !isValid);
        container.find(".invalid_text").html(isValid ? "" : errorMessage);
        container.toggleClass("required", !isValid);
        container.attr("invalid", isValid ? null : "invalid");

        return isValid;
    }

    // Helper function to prevent 'e' input in number fields
    function preventExponentialNotation(input) {
        input.on("keydown", function (e) {
            if (e.key === 'e') {
                e.preventDefault();
            }
        });
    }

    // Generic blur event handler
    function handleBlur(selector, validationFunc, errorMessage) {
        $("body").on("blur", selector, function () {
            const input = $(this);
            validateInput(input, validationFunc, errorMessage);
        });
    }

    // Specific validation functions
    const isValidEmail = email => /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/.test(email);
    const validateTime = time => time === "" || /^([01]\d|2[0-3]):([0-5]\d):([0-5]\d)$/.test(time);
    const IsInt = value => /^-?\d+$/.test(value);

    // Attach event handlers
    handleBlur('.question_wrapper[data-questiontype="questionnaire_autocomplete"] input[type="text"]',
        value => value !== '' || !$(this).closest('div.question_wrapper').attr('data-isrequired'),
        i18n.message_RequiredField
    );

    handleBlur('input.form-control.PhoneNumber',
        value => value !== '' || !$(this).closest('.question_wrapper[data-questionid]').attr("data-isrequired"),
        i18n.message_RequiredField
    );

    handleBlur(".numberinput", value => value === "" || !isNaN(parseFloat(value)), i18n.message_IncorrectNumber);
    handleBlur(".emailinput", isValidEmail, i18n.message_IncorrectEmail);
    handleBlur(".time", validateTime, i18n.message_IncorrectData);

    // Number validation handlers
    const numberValidators = {
        ".moreZero": value => value !== "" && parseFloat(value) > 0,
        ".moreZeroInt": value => value !== "" && parseInt(value, 10) > 0 && Number.isInteger(parseFloat(value)),
        ".lessZero": value => value !== "" && parseFloat(value) < 0,
        ".lessZeroInt": value => value !== "" && parseInt(value, 10) < 0 && Number.isInteger(parseFloat(value)),
        ".moreZeroWithZero": value => value !== "" && parseFloat(value) >= 0,
        ".moreZeroWithZeroInt": value => value !== "" && parseInt(value, 10) >= 0 && Number.isInteger(parseFloat(value)),
        ".lessZeroWithZero": value => value === "" || parseFloat(value) <= 0,
        ".lessZeroWithZeroInt": value => value === "" || (parseFloat(value) <= 0 && Number.isInteger(parseFloat(value))),
        ".withOutZero": value => parseFloat(value) !== 0 && !isNaN(parseFloat(value)),
        ".withOutZeroInt": value => parseFloat(value) !== 0 && IsInt(value),
        ".onlyInt": IsInt
    };

    Object.entries(numberValidators).forEach(([selector, validator]) => {
        handleBlur(selector, validator, i18n.message_IncorrectData);
        $("body").on("keydown", selector, preventExponentialNotation);
    });

    // Range validation handlers
    $("body").on("blur", ".numberRange, .intRange", function () {
        const input = $(this);
        const from = parseFloat(input.data('from'));
        const to = parseFloat(input.data('to'));
        const value = parseFloat(input.val());
        const isValid = !isNaN(value) && value >= from && value <= to;

        validateInput(input, () => isValid, i18n.message_IncorrectNumberRange);
    });

    // Special format validation handlers
    const formatValidators = {
        ".URL": /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&//=]*)/,
        ".IPv4": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
        ".IPv6": /^(?:(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(?:ffff(?::0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/,
        ".CreditCard": /^[0-9]{4}[\s-]?[0-9]{4}[\s-]?[0-9]{4}[\s-]?[0-9]{4}$/,
        ".ISBN": /^(?:ISBN(?:-1[03])?:?)?(?=[0-9X]{10}$|(?=(?:[0-9]+[-]){3})[-0-9X]{13}$|97[89][0-9]{10}$|(?=(?:[0-9]+[-]){4})[-0-9]{17}$)(?:97[89][-]?)?[0-9]{1,5}[-]?[0-9]+[-]?[0-9]+[-]?[0-9X]$/
    };

    const formatErrorMessages = {
        ".URL": i18n.message_IncorrectUrl,
        ".IPv4": i18n.message_IncorrectIpv4,
        ".IPv6": i18n.message_IncorrectIpv6,
        ".CreditCard": i18n.message_IncorrectCreditCard,
        ".ISBN": i18n.message_IncorrectISBN
    };

    Object.entries(formatValidators).forEach(([selector, pattern]) => {
        handleBlur(selector, value => value === "" || pattern.test(value), formatErrorMessages[selector]);
    });
}
