﻿/// <reference path="confirmation.js" />
;

var teamplates;
//////////////////////////////////////////////////////////////////
//tinymce initializer
//////////////////////////////////////////////////////////////////
function createTinyMCE(options, func /*selector, isInline, height, userFolder, valid_children*/) {
    if (!window.tinymce) return;

    if (options.AllowTeamplates) {
        if (teamplates !== undefined) {
            for (var i = 0; i < teamplates.length; i++) {
                teamplates[i].value = teamplates[i].Body;
                teamplates[i].text = teamplates[i].Name;
                teamplates[i].type = 'choiceitem';
            }
        }

        tinymce.init({
            selector: options.selector,
            convert_urls: false,
            relative_urls: false,
            remove_script_host: false,
            readonly: options.readonly || 0,
            inline: options.isInline || false,
            height: options.height || 150,
            skin: 'oxide',
            language: (function (eqspCulture) { return eqspCulture.replace('-', '_') })(eqspCulture),
            invalid_elements: 'input,textarea,button,form',
            extended_valid_elements: options.isScriptAllowed ? "script[type|src|charset]" : null,
            toolbar: 'undo redo | styleselect forecolor backcolor removeformat | alignleft aligncenter alignright alignjustify | bullist numlist | tFormula | link ' +
            (options.DisableMedia ? '' : 'image media') + ' | code | fullscreen | customTemplates',
            plugins: [
                'code fullscreen media link image textpattern tFormula'
            ],
            external_plugins: {
                'tFormula': '/static/lib/tFormula/plugin.js',
            },
            contextmenu: "",
            menubar: false,
            valid_children:  options.valid_children || '',
            file_picker_callback: function (callback, value, type) {
                switch (type.filetype) {
                    case "media":
                        var fileBrowser = ShowFileBrowser("media", options, { open: "70000", close: "10003" });
                        var catalog = "/media/";
                        break;

                    case "image":
                        var fileBrowser = ShowFileBrowser("images", options, { open: "70000", close: "10003" });
                        var catalog = "/images/";
                        break;

                    case "file":
                        var fileBrowser = ShowFileBrowser("files", options, { open: "70000", close: "10003" });
                        var catalog = "/other/";
                        break;

                    default:
                        break;
                }

                fileBrowser.browser.bind("apply", function (e) {
                    //console.log(e);
                    var filename = "/files/" + (options.isNews ? "news/" + options.userFolder : options.userFolder)
                        + catalog + (e.sender._path == "/" ? "" : e.sender._path) + $("#window #browser").find(".k-selected").find(".k-file-name").html();

                    $(".tox-dialog__content-js .tox-textfield[type='url']").val(filename);

                    fileBrowser.window.close();
                });
            },
            setup: function (editor) {
                editor.on('init', function () {
                        this.getDoc().body.style.fontSize = '14px';
                        this.getDoc().body.style.fontFamily = 'Arial';
                    }),
                    editor.ui.registry.addSplitButton('customTemplates', {
                        text: 'Шаблон',
                        tooltip: 'Вставить пользовательский шаблон',
                        //icon: 'template',
                        onAction: function () {
                            editor.insertContent(teamplates[0].value)
                        },
                        onItemAction: function (api, value) {
                            editor.insertContent(value);
                        },
                        fetch: function (callback) {
                            callback(teamplates);
                        },
                    }
                )
            },
        });
    }
    else {
        tinymce.init({
            selector: options.selector,
            convert_urls: false,
            relative_urls: false,
            remove_script_host: false,
            inline: options.isInline || false,
            readonly: options.readonly || 0,
            height: options.height || 150,
            skin: 'oxide',
            language: (function (eqspCulture) { return eqspCulture.replace('-', '_') })(eqspCulture),
            invalid_elements: 'input,textarea,button,form',
            extended_valid_elements: options.isScriptAllowed ? "script[type|src|charset]" : null,
            toolbar: 'undo redo | styleselect forecolor backcolor removeformat | alignleft aligncenter alignright alignjustify | bullist numlist | tFormula | link ' +
            (options.DisableMedia ? '' : 'image media') + ' | code | fullscreen | customTemplates',
            plugins: [
                'code fullscreen media link image textpattern tFormula'
            ],
            external_plugins: {
                'tFormula': '/static/lib/tFormula/plugin.js',
            },
            contextmenu: "",
            menubar: false,
            valid_children:  options.valid_children || '',
            file_picker_callback: function (callback, value, type) {
                switch (type.filetype) {
                    case "media":
                        var fileBrowser = ShowFileBrowser("media", options, { open: "70000", close: "10003" });
                        var catalog = "/media/";
                        break;

                    case "image":
                        var fileBrowser = ShowFileBrowser("images", options, { open: "70000", close: "10003" });
                        var catalog = "/images/";
                        break;

                    case "file":
                        var fileBrowser = ShowFileBrowser("files", options, { open: "70000", close: "10003" });
                        var catalog = "/other/";
                        break;

                    default:
                        break;
                }

                fileBrowser.browser.bind("apply", function (e) {
                    //console.log(e);
                    var filename = "/files/" + (options.isNews ? "news/" + options.userFolder : options.userFolder)
                        + catalog + (e.sender._path == "/" ? "" : e.sender._path) + $(".k-window .k-listview .k-selected").find(".k-file-name").html();

                    $(".tox-dialog__content-js .tox-textfield[type='url']").val(filename);

                    fileBrowser.window.close();
                });
            },
            setup: function (editor) {
                editor.on('init', function () {
                    this.getDoc().body.style.fontSize = '14px';
                    this.getDoc().body.style.fontFamily = 'Arial';
                });
            }
        });
    }
};
