﻿;

var Preloader = (function () {

    if(Preloader) return Preloader;

    var _preloaders = {};
    var returnObject = Object.create(null);

    returnObject.EnableLoader = function (containerSelector) {
        var $container = $(containerSelector);
        var oldPosition = $container.css("position");

        $container.css("position", "relative");
        $container.append('<div class="preloader__background">');
        $container.append('<div class="preloader__spinner">');

        _preloaders[containerSelector] = {
            position: oldPosition
        };
    }

    returnObject.DisableLoader = function (containerSelector) {
        if (!_preloaders[containerSelector]) return;

        var $container = $(containerSelector);
        $container.find("div.preloader__background").remove();
        $container.find("div.preloader__spinner").remove();

        $container.css("position", _preloaders[containerSelector].position);

        _preloaders[containerSelector] = null;
    }
    return returnObject;
})();
