CREATE OR REPLACE FUNCTION strip_tags(TEXT) RETURNS TEXT AS $$
    SELECT regexp_replace($1, '<[^>]*>', '', 'g')
$$ LANGUAGE SQL;


CREATE OR REPLACE VIEW public."RespondentAnswers_Single" AS 
 SELECT total_single."Id",
    total_single."RespondentId",
    strip_tags(total_single."QuestionText") as "QuestionText",
    total_single."Points",
    total_single."Date",
    strip_tags(total_single."AnswerValue")as "AnswerValue",
    total_single."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%single%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text) total_single
  ORDER BY total_single."RespondentId", total_single."AnswerValue";

  -- View: public."RespondentAnswersReview_Multy"

-- DROP VIEW public."RespondentAnswersReview_Multy";

CREATE OR REPLACE VIEW public."RespondentAnswersReview_Multy" AS 
 SELECT aom."QuestionId" AS "Id",
    strip_tags( string_agg(aom."AnswerValue", ', '::text))  AS "AnswerValue",
    aom."Points",
    aom."QuestionId",
    aom."RespondentId",
    aom."Date",
    aom."ExpertComment"::text,
    strip_tags( aom."QuestionText") as "QuestionText",
    aom."QuestionnaireId",
    aom."QuestionId"::text AS "Unique"
   FROM ( SELECT respanswers."Id",
            respanswers."AnswerId",
            ao."Text" AS "AnswerValue",
            respanswers."Points",
            respanswers."QuestionId",
            respanswers."RespondentId",
            respanswers."Date",
            respanswers.rownumber,
            ao."Message" AS "ExpertComment",
            respanswers."QuestionText",
            respanswers."QuestionnaireId"
           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                    ra."AnswerValue",
                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                    ra."Points",
                    ra."QuestionId",
                    ra."RespondentId",
                    ra."Date",
                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                    ra."ExpertComment",
                    ra."Text" AS "QuestionText",
                    ra."QuestionnaireId"
                   FROM ( SELECT ra_1."Id",
                            ''::text AS "AnswerValue",
                            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                            ra_1."Points",
                            ra_1."QuestionId",
                            ra_1."RespondentId",
                            ra_1."Date",
                            row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                            '' AS "ExpertComment",
                            q."Text",
                            q."QuestionnaireId"
                           FROM "RespondentAnswers" ra_1
                             JOIN "Questions" q ON q."Id" = ra_1."QuestionId"
                          WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
             JOIN "AnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId";
