CREATE OR REPLACE VIEW public."RespondentAnswersReviewStimulsoftWithTable" AS 
 SELECT array_to_string(array_agg(agg."AnswerValue"), '</br>'::text) AS "AnswerValue",
    agg."RespondentId",
    agg."QuestionnaireId",
    agg."ParentQuestionId" AS "QuestionId",
    agg."Points"
   FROM ( SELECT array_to_string(array_agg((((('<div>'::text || ex."QuestionText") || '<p>'::text) || ex."AnswerValue") || '</p>'::text) || '</div>'::text), '</br>'::text) AS "AnswerValue",
            ex."RespondentId",
            ex."QuestionnaireId",
            ex."RecordId",
            ex."ParentQuestionId",
            ex."Points"
           FROM ( SELECT ra."ExtendedQuestionId" AS "Id",
                    ra."AnswerValue",
                    0 AS "Points",
                    ra."ExtendedQuestionId",
                    ra."RespondentId",
                    ra."Date",
                    ''::text AS "ExpertComment",
                    q."Text" AS "QuestionText",
                    qq."QuestionnaireId",
                    ra."RecordId",
                    q."ParentQuestionId"
                   FROM "RespondentExtendedAnswersView" ra
                     JOIN "ExtendedQuestions" q ON q."Id" = ra."ExtendedQuestionId"
                     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
                  WHERE ra."AnswerValue" <> ''::text
                UNION
                 SELECT aom."QuestionId" AS "Id",
                    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
                    aom."Points",
                    aom."QuestionId" AS "ExtendedQuestionId",
                    aom."RespondentId",
                    aom."Date",
                    aom."ExpertComment",
                    aom."QuestionText",
                    aom."QuestionnaireId",
                    aom."RecordId",
                    aom."ParentQuestionId"
                   FROM ( SELECT respanswers."Id",
                            respanswers."AnswerId",
                            ao."Text" AS "AnswerValue",
                            respanswers."Points",
                            respanswers."QuestionId",
                            respanswers."RespondentId",
                            respanswers."Date",
                            respanswers.rownumber,
                            respanswers."ExpertComment",
                            respanswers."QuestionText",
                            respanswers."QuestionnaireId",
                            respanswers."RecordId",
                            respanswers."ParentQuestionId"
                           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                                    ra."AnswerValue",
                                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                                    ra."Points",
                                    ra."ExtendedQuestionId" AS "QuestionId",
                                    ra."RespondentId",
                                    ra."Date",
                                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                                    ra."ExpertComment",
                                    ra."Text" AS "QuestionText",
                                    ra."QuestionnaireId",
                                    ra."RecordId",
                                    ra."ParentQuestionId"
                                   FROM ( SELECT ra_1."Id",
    ''::text AS "AnswerValue",
    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
    0 AS "Points",
    ra_1."ExtendedQuestionId",
    ra_1."RespondentId",
    ra_1."Date",
    row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
    ''::text AS "ExpertComment",
    q."Text",
    qq."QuestionnaireId",
    ra_1."RecordId",
    q."ParentQuestionId"
   FROM "RespondentExtendedAnswersView" ra_1
     JOIN "ExtendedQuestions" q ON q."Id" = ra_1."ExtendedQuestionId"
     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
  WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
                             JOIN "ExtendedAnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
                  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId", aom."RecordId", aom."ParentQuestionId") ex
          GROUP BY ex."RespondentId", ex."QuestionnaireId", ex."RecordId", ex."ParentQuestionId", ex."Points") agg
  GROUP BY agg."RespondentId", agg."QuestionnaireId", agg."ParentQuestionId",agg."Points"
UNION ALL
 SELECT ravs."AnswerValue",
    ravs."RespondentId",
    ravs."QuestionnaireId",
    ravs."QuestionId",
    ravs."Points"
   FROM "RespondentAnswersReviewStimulsoft" ravs
UNION ALL
 SELECT ram."AnswerValue",
    ram."RespondentId",
    q."QuestionnaireId",
    ram."QuestionId",
    ram."Points"
   FROM "RespondentAnswers_Matrix" ram
     JOIN "Questions" q ON q."Id" = ram."QuestionId";