;
function Constructor(options) {

    let i18n = eqspI18nConstrictor;

    let timeout;

    function Delay(fn, data, delay = 500) {
        const delayedFn = () => {
            fn(data);
            timeout = null;
        };

        if (timeout) {
            clearTimeout(timeout);
        }

        timeout = setTimeout(delayedFn, delay);
    }

    window.onbeforeunload = function (e) {
        if (timeout) {
            //Notification.ShowError("Выполняется сохранение данных! Повторите попытку позднее");
            return false;
        }

    }; 
    //parse file extension
    String.prototype.replaceAll = function (what, to) {
        var res = "";
        for (var i = 0; i < this.length; i++) {
            if (this[i] == what) res += to;
            else res += this[i];
        }
        return res;
    }

    if (!String.prototype.startsWith) {
        Object.defineProperty(String.prototype, 'startsWith', {
            enumerable: false,
            configurable: false,
            writable: false,
            value: function (searchString, position) {
                position = position || 0;
                return this.lastIndexOf(searchString, position) === position;
            }
        });
    }

    (function ($) {
        $(document).ready(function () {
            const pageContentContainer = document.querySelector("#page_content");
            const pageContentScrollbar = new PerfectScrollbar(pageContentContainer, {
                wheelSpeed: 0.3,
            });

            pageContentScrollbar.update();
        });
    })(jQuery);

    function inputValid() {
        $("input[name='Weight']").on("change", function () {
            const value = $(this).val();
            const isValidInteger = /^-?\d+$/.test(value);
            if (!isValidInteger) {
                $(this).val("0");
            }
        });
    }

    function errorMessage(message) {
        $(".scale_validation_message").text(message);
        Notification.ShowError(message);
    }

    function createQuestionErrorsTemplate(errors) {
        const createErrorListItems = (errors) => errors.map(error => `<li>${error}.</li>`).join('');

        const template = `
            <div class="accordion border-x border-top rounded mb-3">
                <div class="card shadow-none border-bottom">
                    <div class="card-header py-0 overflow-hidden" id="question-errors">
                        <button class="btn btn-link text-decoration-none btn-block py-2 px-0 text-left" data-toggle="collapse" data-target="#collapse-question-errors" aria-expanded="false" aria-controls="collapse-question-errors">
                            <span class="fas fa-caret-right accordion-icon mr-3" data-fa-transform="shrink-2"></span>
                            <span class="font-weight-medium text-sans-serif text-danger">
                                <span class="fas fa-exclamation-circle"></span>
                                ${i18n.text_QuestionErrors}
                            </span>
                        </button>
                    </div>
                    <div class="collapse show" id="collapse-question-errors" aria-labelledby="question-errors">
                        <div class="card-body pt-2">
                            <div class="constructor-errors pl-4">
                                <div class="bs-callout bs-callout--danger">
                                    <ol class="fs--1">
                                        ${createErrorListItems(errors)}
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`;

        return template;
    }

    function updateQuestionState(questionId, isValid, validationData = null) {
        const questionWrapper = $(`.question_wrapper[data-questionid='${questionId}']`);
        const errorsContainer = $("#question_validation_messages");
        const questionItem = questionWrapper.find(".question-item");

        errorsContainer.empty();

        if (isValid) {
            questionItem.removeClass("border-danger");
        } else {
            const errors = validationData.ValidationErrors;
            const template = createQuestionErrorsTemplate(errors);
            errorsContainer.append(template);
            questionItem.addClass("border-danger");
        }
    }

    function setValidQuestionState(questionId) {
        updateQuestionState(questionId, true);
    }

    function setInvalidQuestionState(questionId, questionValidationData) {
        updateQuestionState(questionId, false, questionValidationData);
    }

    function getQuestionDescriptionString(type, text) {
        const questionTypes = {
            'questionnaire_scale_two_slide': i18n.name_QScale_twoSlider,
            'questionnaire_date': i18n.name_QDate,
            'questionnaire_textblock': i18n.name_Qtextblock,
            'questionnaire_single': i18n.name_QSingle,
            'questionnaire_table': i18n.name_QTable,
            'questionnaire_multy': i18n.name_QMulty,
            'questionnaire_input': i18n.name_QInput,
            'questionnaire_dadatainput': i18n.name_QDaDataInput,
            'questionnaire_spreadsheet': i18n.name_QSpreadsheet,
            'questionnaire_dropdown': i18n.name_QDropdown,
            'questionnaire_scale': i18n.name_QScale,
            'questionnaire_nps': i18n.name_QNps,
            'questionnaire_rating': i18n.name_QRating,
            'questionnaire_file': i18n.name_QFile,
            'test_single': i18n.name_TSingle,
            'test_table': i18n.name_TTable,
            'test_multy': i18n.name_TMulty,
            'test_open': i18n.name_TOpen,
            'questionnaire_autocomplete': i18n.name_QAutocomlete,
            'questionnaire_extended': i18n.name_QExtended,
            'questionnaire_matrix': i18n.name_QMatrix,
            'test_single_undefined': i18n.name_TSingleUndefined,
            'test_multy_undefined': i18n.name_TMultyUndefined,
            'test_scale': i18n.name_TScale
        };

        const typeName = questionTypes[type] || '';
        const questionStr = `<span class="fs--1"><b class="d-block">${typeName}</b>`;

        return hasObservableContent(text)
            ? `${questionStr} ${textize(text)}</span>`
            : `${questionStr}</span>`;
    }

    function truncateText(text, maxLength = 100) {
        if (!text) return "";
        const truncated = text.substr(0, maxLength);
        return truncated + (text.length > maxLength ? "..." : "");
    }

    function textize(markup, length = 100) {
        if (!markup) return "";
        const textContent = $(markup).text();
        return truncateText(textContent, length);
    }

    function textizeHTML(markup, length = 100) {
        if (!markup) return "";
        const stripTags = markup.replace(/<\/?[^>]+>/g, "");
        const escapeSlashes = stripTags.replace(/\//g, "\\/");
        return truncateText(escapeSlashes, length);
    }

    function switchEditorOn(button) {
        if (tinymce.editors.length === 1) {
            const container = $(tinymce.editors[0].editorContainer).closest(".item_container");
            saveText(container);
        }

        const editorElemId = `#${button.closest(".item_container").find("div.editor_container").first().attr("id")}`;

        createTinyMCE({
            selector: editorElemId,
            userFolder: options.UserFolder
        });

        button.removeClass('edit_text btn-falcon-primary')
            .addClass('save_text btn-success')
            .html(`<span class="fas fa-check mr-1"></span>${i18n.button_Save}`);
    }

    function switchEditorOff(button) {
        button.removeClass('btn-success');
        const container = button.closest(".item_container");
        saveText(container);
    }

    function hasObservableContent(htmlString) {
        const content = $(htmlString);
        const hasMediaContent = content.find("img, video, audio").length > 0;
        const hasTextContent = content.text().trim() !== "";
        return hasMediaContent || hasTextContent;
    }

    function saveText(container) {
        const property = container.data("textpropertyname") || "Text";
        const itemId = container.data("itemid");
        const itemType = container.data("itemtype");
        const text = tinymce.editors[0].getContent();

        const data = {
            Id: itemId,
            ItemType: itemType,
            PropertyName: property,
            Value: text,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };

        Delay(SaveProperty, data);

        if (itemType === "question") {
            updateQuestionInList(itemId, text);
        }

        tinymce.editors[0].destroy();

        $(".save_text")
            .removeClass('save_text')
            .addClass('edit_text btn-falcon-primary')
            .html(`<span class="fas fa-pencil-alt mr-1"></span>${i18n.button_Edit}`);
    }

    function preventNonNumericalInput(event) {
        const keyCode = event.which || event.keyCode;
        const charStr = String.fromCharCode(keyCode);
        const isNumeric = /^[0-9]+$/.test(charStr);

        if (!isNumeric) {
            event.preventDefault();
        }
    }

    function rerenderQuestions() {
        $("#questions").html("");
        loadQuestions();
    }

    function toggleDropzone() {
        const hasQuestions = $("#questions .question_wrapper").length > 0;
        $("#page_content .dropzone").toggle(!hasQuestions);
    }

    function setOverflow(thisObj, overflowState) {
        var DElTop = thisObj.offset().top + thisObj.outerHeight(),
            DElHeight = thisObj.find(".dropdown-menu").outerHeight(),
            DParTop = thisObj.closest(".card").offset().top,
            DParHeight = thisObj.closest(".card").outerHeight(),
            DElPosition = DElTop + DElHeight,
            DParPosition = DParTop + DParHeight;

        if (DElPosition > DParPosition) {
            thisObj.closest(".card").css("overflow", overflowState);
        }
    }

    function SaveProperty(data, notify = true) {
        const ajaxOptions = {
            url: "/api/constructor/save-item",
            type: "POST",
            data: data,
            error: function (error) {
                if (notify) {
                    defaultErrorHandler(error);
                }
            },
            success: function () {
                if (notify) {
                    Notification.ShowSuccess(i18n.alert_ChangesSaved);
                }
                const questionId = $(".item_container[data-itemtype='question']").data("itemid");
                updateQuestionValidationState(questionId);
            }
        };

        sendAjaxWithQuestionnaireId(ajaxOptions);
    }

    function SaveDateValue(e) {
        const data = {
            Id: $(".item_container").data('itemid'),
            ItemType: "question",
            PropertyName: e.element.attr('name'),
            Value: e.element.val(),
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };
        SaveProperty(data);
    }

    function updateQuestionValidationState(questionId) {
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/checkquestion",
            type: "GET",
            data: {
                "questionId": questionId
            },
            success: (questionValidationData) => {
                if (!questionValidationData.IsValid) {
                    let errorsContainer = $("#question_validation_messages");
                    setInvalidQuestionState(questionId, questionValidationData);
                }
                else {
                    setValidQuestionState(questionId)
                }
            }
        })
    }

    function sendAjaxWithQuestionnaireId(ajaxOptionsObject) {
        ajaxOptionsObject.beforeSend = function (xhr) {
            xhr.setRequestHeader('X-QuestionnaireId', options.QuestionnaireId);
        };

        $.ajax(ajaxOptionsObject);
    }

    function renderThen(append, questionId, data) {
        append.find('input[name="questionId"]').val(questionId);

        renderPageJumpOptions(append, data);
        renderQuestionJumpOptions(append, data);
    }

    function renderPageJumpOptions(append, data) {
        const pagestojumpSelect = append.find("#pagestojump");
        if (data.maxPage !== 0) {
            for (let i = 1; i <= data.maxPage; i++) {
                if (i === data.currentPage) continue;
                pagestojumpSelect.append(`<option value="${i}">${i}</option>`);
            }
        } else {
            append.find("#pagestojump").closest("div").remove();
        }
    }

    function renderQuestionJumpOptions(append, data) {
        const questionstojumpSelect = append.find("#questionstojump");
        if (data.questions.length > 0) {
            data.questions.forEach(question => {
                questionstojumpSelect.append(`<option value="${question.Id}">${question.OrderId}${getLogicOptionText(question.Text)}</option>`);
            });
        } else {
            append.find("#questionstojump").closest("div").remove();
        }
    }

    function loadFiles(container, files) {
        if (files != undefined)
            for (var i = 0; i < files.length; i++) {
                addFile(container, files[i].Id, files[i].Type, files[i].Name, files[i].Path);
            }
    }

    function defaultErrorHandler(data) {
        if (data.responseText == "edit_non-draft_restriction") {
            Notification.ShowError(i18n.alert_EditRestrict);
            return;
        }
        if (data.responseText == "access_restriction") {
            window.location = options.PageURL;
            return;
        }
        Notification.ShowError(i18n.alert_UnknownError);
    }

    function updateQuestionInList(questionId, text) {
        var wrapper = $("#questions").find('.question_wrapper[data-questionid="' + questionId + '"]');
        var type = wrapper.data("type");
        wrapper.find(".title").html(getQuestionDescriptionString(type, text));
    }

    function createQuestion(isNew, title, type, id, orderId, isrequired, haslogic, manualExpertise, isValid) {
        const question_content = $($("#question_template").html());

        question_content.attr({
            "data-questionid": id,
            "data-type": type
        });

        if (!isNew) {
            question_content.find(".badge-order").html(orderId);
        }

        if (!isValid) {
            question_content.find(".question-item").addClass("border-danger");
        }

        const displayElements = {
            isrequired: ".isrequired",
            haslogic: ".haslogic",
            manualExpertise: ".manualexpertize"
        };

        Object.entries(displayElements).forEach(([key, selector]) => {
            if (eval(key)) {
                question_content.find(selector).css('display', 'inline-block');
            }
        });

        question_content.find(".title").html(getQuestionDescriptionString(type, title));

        if (isNew) return question_content;

        question_content.appendTo("#questions");

        setupDropdownBehavior();
        setupNumberInputBehavior();
    }

    function setupDropdownBehavior() {
        $("#page_content .dropdown-menu, #props_content .dropdown-menu").parent().on({
            "show.bs.dropdown": function (event) {
                setOverflow($(this), "visible");
            },
            "hide.bs.dropdown": function (event) {
                setOverflow($(this), "hidden");
            }
        });
    }

    function setupNumberInputBehavior() {
        $(".js-number-input").keypress(function (e) {
            preventNonNumericalInput(e);
        });
    }

    function saveSort(that, cancelSorting) {
        const sortData = Array.from(that[0].childNodes)
            .map((item, index) => `${$(item).data("questionid")}=${index + 1 + options.MaxOrderId}`)
            .join(";");

        if (sortData) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/savesort",
                method: "POST",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    sort: sortData
                },
                error: handleSortError.bind(null, cancelSorting),
                success: updateOrderBadges.bind(null, that)
            });
        }
    }

    function handleSortError(cancelSorting, data) {
        cancelSorting();
        if (data.responseText === "logic_restriction") {
            Notification.ShowError(i18n.alert_QuestionMoveLogicRestrict);
        } else {
            defaultErrorHandler(data);
        }
        Preloader.DisableLoader("#page_content");
    }

    function updateOrderBadges(that) {
        $(that[0].childNodes).each((index, item) => {
            $(item).find(".badge-order").html(index + 1 + options.MaxOrderId);
        });
        Preloader.DisableLoader("#page_content");
    }

    function saveOptionSort(that, cancelSorting) {
        const sortData = that.find(".option_wrapper")
            .map(function (index, item) {
                const optionId = $(item).data("optionid") || $(item).data("itemid");
                return `${optionId}=${index + 1}`;
            })
            .get()
            .join(";");

        if (sortData) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/saveoptionsort",
                method: "POST",
                data: {
                    sort: sortData,
                    questionnaireId: options.QuestionnaireId
                },
                success: function () {
                    that.find(".option_wrapper").each(function (index, item) {
                        $(item).find(".badge-order").html(index + 1);
                    });
                },
                error: function (data) {
                    cancelSorting();
                    defaultErrorHandler(data);
                }
            });
        }
    }

    function loadQuestions() {
        Preloader.EnableLoader("#page_content");
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestions",
            method: "get",
            data: {
                questionnaireId: options.QuestionnaireId,
                pageId: options.Page
            },
            success: function (data) {
                data.forEach(question => {
                    createQuestion(
                        false,
                        question.Title,
                        question.Type,
                        question.Id,
                        question.OrderId,
                        question.IsRequired,
                        question.HasLogic,
                        question.ManualExpertise,
                        question.IsValid
                    );
                });
                Preloader.DisableLoader("#page_content");
                toggleDropzone();
            },
            error: function (error) {
                console.error("Error loading questions:", error);
                Preloader.DisableLoader("#page_content");
            }
        });
    }

    function makeOptionsSortable(wrapper) {
        wrapper.sortable({
            handle: "div.handle",
            placeholder: "option_placeholder",
            axis: "y",
            containment: "body",
            scroll: false,
            tolerance: "pointer",
            sort: function (event, ui) {
                const $target = $(event.target);
                if (!/html|body/i.test($target.offsetParent()[0].tagName)) {
                    const top = event.pageY - $target.offsetParent().offset().top - (ui.helper.outerHeight(true) / 2);
                    ui.helper.css({ 'top': top + 'px' });
                }
            },
            start: function (event, ui) {
                ui.placeholder.height(ui.item.height());
            },
            update: function (event, ui) {
                const that = $(this);
                const cancelSorting = () => wrapper.sortable("cancel");
                saveOptionSort(that, cancelSorting);
            }
        });
    }

    function saveScaleValues(e) {
        try {
            const item_container = $(e.currentTarget).closest('div.item_container');
            const id = item_container.data("itemid");
            const type = item_container.data("itemtype");

            const min = parseFloat($("#ScaleMin").val().replace(",", "."));
            const max = parseFloat($("#ScaleMax").val().replace(",", "."));
            const step = parseFloat($("#ScaleStep").val().replace(",", "."));

            if (!validateScaleInputs(min, max, step)) {
                return;
            }

            const countStep = (max - min) / step;

            if (!validateStepCount(countStep)) {
                return;
            }

            saveScaleProperty("ScaleMin", $("#ScaleMin").val(), id, type);
            saveScaleProperty("ScaleMax", $("#ScaleMax").val(), id, type);
            saveScaleProperty("ScaleStep", $("#ScaleStep").val(), id, type);

            if (options.QuestionnaireType === "test") {
                const rightAnswer = parseFloat($('#RightAnswer').val().replace(",", "."));
                saveScaleProperty("RightAnswer", $('#RightAnswer').val(), id, type);
            }

        } catch (error) {
            errorMessage(i18n.errorMessage_notAllFieldsAreFilled);
        }
    }

    function validateScaleInputs(min, max, step) {
        if (isNaN(step)) {
            Notification.ShowError(i18n.errorMessage_stepIsNaN);
            return false;
        }

        if (step === 0) {
            Notification.ShowError(i18n.errorMessage_stepEqualsZero);
            return false;
        }

        if (!max && max !== 0 || !min && min !== 0 || !step) {
            return false;
        }

        if (min < -100) {
            $("#ScaleMin").val(0);
        }

        if (min > 100 && min > max) {
            $("#ScaleMin").val(max - 1);
        }

        if (min > max) {
            Notification.ShowError(i18n.errorMessageMaxLessMin);
            return false;
        }

        return true;
    }

    function validateStepCount(countStep) {
        if (countStep < 1) {
            errorMessage(i18n.errorMessageMaxMixlessStep);
            return false;
        }

        if (countStep > 100) {
            errorMessage(i18n.errorMessage_notLessThanHundred);
            return false;
        }

        if (countStep * 10 % 10 !== 0) {
            errorMessage(i18n.errorMessageMaxUnreachable);
            return false;
        }

        $(".scale_validation_message")[0].textContent = "";
        return true;
    }

    function saveScaleProperty(propertyName, value, id, type) {
        const data = {
            Id: id,
            ItemType: type,
            PropertyName: propertyName,
            Value: value,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };
        SaveProperty(data, propertyName === "ScaleStep");
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    function validateRightAnswer(min, max) {
        const rightAnswer = parseFloat($('input[name="RightAnswer"]').val());

        if (isNaN(rightAnswer)) {
            return false;
        }

        if (rightAnswer < min || rightAnswer > max) {
            const newRightAnswer = (max + min) / 2;
            $('input[name="RightAnswer"]').val(newRightAnswer.toFixed(2));
        }

        return true;
    }

    function validateQuestionnaireMulty() {
        const minCheckedCount = parseInt($(".item_container").find('input[name="MinCheckedCount"]').val());
        const maxCheckedCount = parseInt($(".item_container").find('input[name="MaxCheckedCount"]').val());
        let optionsCount = $(".questionnaire_multy_options_wrapper .option_wrapper").length;

        if ($("input[name=AllowUserOption]:checked").length === 1) {
            optionsCount++;
        }

        const validationMessages = {
            minGreaterThanCount: i18n.errormessage_MultyMinGtCount,
            maxGreaterThanCount: i18n.errormessage_MultyMaxGtCount2,
            maxLessThanMin: i18n.errormessage_MultyMaxGtMin
        };

        const validationChecks = [
            { condition: minCheckedCount !== 0 && minCheckedCount > optionsCount, message: validationMessages.minGreaterThanCount },
            { condition: maxCheckedCount !== 0 && maxCheckedCount > optionsCount, message: validationMessages.maxGreaterThanCount },
            { condition: maxCheckedCount !== 0 && minCheckedCount !== 0 && maxCheckedCount < minCheckedCount, message: validationMessages.maxLessThanMin },
            { condition: minCheckedCount > maxCheckedCount, message: validationMessages.maxLessThanMin },
            { condition: maxCheckedCount > optionsCount, message: validationMessages.maxGreaterThanCount }
        ];

        for (const check of validationChecks) {
            if (check.condition) {
                $("span.checked_count_validation_message").html(check.message);
                Notification.ShowError(check.message);
                return false;
            }
        }

        $("span.checked_count_validation_message").html("");
        return true;
    }

    function validateQuestionnaireScale() {
        const min = parseFloat($(".item_container").find('input[name="ScaleMin"]').val().replace(',', '.'));
        const max = parseFloat($(".item_container").find('input[name="ScaleMax"]').val().replace(',', '.'));

        if (isNaN(min)) {
            $(".item_container").find('input[name="ScaleMin"]').val(0);
        }
        if (isNaN(max)) {
            $(".item_container").find('input[name="ScaleMax"]').val(10);
        }

        if (max < min) {
            showScaleValidationError(i18n.errormessage_ScaleMaxLtMin);
            return false;
        }
        if (max === min) {
            showScaleValidationError(i18n.errormessage_ScaleMaxEqMin);
            return false;
        }

        $("span.scale_validation_message").html("");
        return true;
    }

    function showScaleValidationError(message) {
        $("span.scale_validation_message").html(message);
        Notification.ShowError(message);
    }

    function validateQuestionnaireFile(container) {
        const fileExtensions = container.find('input[name="FileExtensions"]').val();

        if (!fileExtensions) return true;
        if (fileExtensions === "") {
            showFileValidationError(i18n.errormessage_FileNoExtensions);
            return false;
        }

        const invalidChars = ['<', '>', '(', ')', '?', '.', ';'];
        if (invalidChars.some(char => fileExtensions.includes(char))) {
            showFileValidationError(i18n.errormessage_FileIncorrectFormatList);
            return false;
        }

        $("span.file_validation_message").html("");
        return true;
    }

    function showFileValidationError(message) {
        $("span.file_validation_message").html(message);
        Notification.ShowError(message);
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    function showQuestionnaireMatrixQuestion(questionId, question_wrapper) {
        const editorTemplate = $("#questionnaire_matrix_editor_template").html();
        $(editorTemplate).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getmatrixdata",
            type: "GET",
            data: { questionId },
            success: function (data) {
                populateMatrixQuestionData(questionId, data);
                setupMatrixQuestionUI(questionId, data);
                handleMatrixQuestionLogic(questionId, data);
                handleMatrixQuestionFiles(questionId, data);
                populateMatrixQuestionOptions(data);

                makeChildQuestionsSortable($(".questionnaire_extended_child_questions_wrapper"));

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function populateMatrixQuestionData(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
        $('input[name="Weight"]').val(data.Weight);

        if (data.IsAnswerRequired) {
            $('input[name="IsAnswerRequired"]').attr("checked", "checked");
            $('.question_wrapper[data-questionid="' + questionId + '"]').find('.IsAnswerRequired').css('display', 'inline-block');
        }

        if (data.ManualExpertise) {
            $('input[name="ManualExpertise"]').attr("checked", "checked");
        }
    }

    function setupMatrixQuestionUI(questionId, data) {
        $('.add_logic_withoptions_matrix').attr('data-questionid', questionId);
        $("#props_wrapper").find(".child_question_option").attr("data-questionid", questionId);
        $("#props_wrapper").find(".add_option_matrix_string").attr("data-questionid", questionId).attr("data-questiontype", "questionnaire_matrix");
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "questionnaire_matrix");
        $("#props_wrapper").find(".add_matrix_string_multiline").attr("data-questionid", questionId);
        $("#props_wrapper").find(".add_matrix_column_multiline").attr("data-questionid", questionId);
    }

    function handleMatrixQuestionLogic(questionId, data) {
        addLogic($(".add_logic_number"), questionId, data.Logics);
    }

    function handleMatrixQuestionFiles(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateMatrixQuestionOptions(data) {
        data.ExtendedQuestions.forEach(question => addMatrixString(false, question));
        data.AnswerOptions.forEach(option => addMatrixColumnShow(false, option));
    }

    function showQuestionnaireTextblock(questionId, question_wrapper) {
        $($("#questionnaire_textblock_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairesingleprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                populateQuestionData_textblock(questionId, data);
                setupQuestionUI_textblock(questionId, data);
                handleQuestionLogic_textblock(questionId, data);
                handleQuestionFiles_textblock(questionId, data);
                populateQuestionOptions_textblock(data);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function populateQuestionData_textblock(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);

        setCheckboxState_textblock('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_textblock('ManualExpertise', data.ManualExpertise);
        setCheckboxState_textblock('AllowUserOption', data.AllowUserOption);
        setCheckboxState_textblock('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_textblock('Numbering', data.Numbering === "true");
    }

    function setCheckboxState_textblock(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function setupQuestionUI_textblock(questionId, data) {
        $("#props_wrapper").find(".add_option")
            .attr("data-questionid", questionId)
            .attr("data-questiontype", "questionnaire_single");
    }

    function handleQuestionLogic_textblock(questionId, data) {
        addLogic($(".add_logic_withoptions"), questionId, data.Logics);
    }

    function handleQuestionFiles_textblock(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateQuestionOptions_textblock(data) {
        data.AnswerOptions.forEach(option => {
            addQuestionnaireSingleOption(false, option.Id, option.Text, option.OrderId, option.Files, option.Weight);
        });
        makeOptionsSortable($(".questionnaire_single_options_wrapper"));
    }

    function showQuestionnaireSingleQuestion(questionId, question_wrapper) {
        $($("#questionnaire_single_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairesingleprops",
            type: "GET",
            data: { questionId: questionId },
            success: function (data) {
                populateQuestionData_single(questionId, data);
                setupQuestionUI_single(questionId);
                handleQuestionLogic_single(questionId, data);
                handleQuestionFiles_single(questionId, data);
                populateQuestionOptions_single(data);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        });
    }

    function populateQuestionData_single(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);

        setCheckboxState_single('ManualExpertise', data.ManualExpertise);
        setCheckboxState_single('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_single('AllowUserOption', data.AllowUserOption);
        setCheckboxState_single('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_single('Numbering', data.Numbering === "true");
    }

    function setCheckboxState_single(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function setupQuestionUI_single(questionId) {
        $("#props_wrapper").find(".add_option")
            .attr("data-questionid", questionId)
            .attr("data-questiontype", "questionnaire_single");
        $("#props_wrapper").find(".add_single_multiline").attr("data-questionid", questionId);
    }

    function handleQuestionLogic_single(questionId, data) {
        addLogic($(".add_logic_withoptions"), questionId, data.Logics);
    }

    function handleQuestionFiles_single(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateQuestionOptions_single(data) {
        data.AnswerOptions.forEach(option => {
            addQuestionnaireSingleOption(false, option.Id, option.Text, option.OrderId, option.Files, option.Weight);
        });
        makeOptionsSortable($(".questionnaire_single_options_wrapper"));
    }

    function showQuestionnaireMultyQuestion(questionId, question_wrapper) {
        $($("#questionnaire_multy_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairemultyprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                populateQuestionData_multy(questionId, data);
                setupQuestionUI_multy(questionId);
                handleQuestionLogic_multy(questionId, data);
                handleQuestionFiles_multy(questionId, data);
                populateQuestionOptions_multy(data);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        });
    }

    function populateQuestionData_multy(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);

        setCheckboxState_multy('ManualExpertise', data.ManualExpertise);
        setCheckboxState_multy('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_multy('AllowUserOption', data.AllowUserOption);
        setCheckboxState_multy('AnswersRandomOrder', data.AnswersRandomOrder);

        $('input[name="MaxCheckedCount"]').val(data.MaxCheckedCount);
        $('input[name="MinCheckedCount"]').val(data.MinCheckedCount);
    }

    function setCheckboxState_multy(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function setupQuestionUI_multy(questionId) {
        $("#props_wrapper").find(".add_multy_multiline").attr("data-questionid", questionId);
        $("#props_wrapper").find(".add_option")
            .attr("data-questionid", questionId)
            .attr("data-questiontype", "questionnaire_multy");
    }

    function handleQuestionLogic_multy(questionId, data) {
        addLogic($(".add_logic_withoptions"), questionId, data.Logics);
    }

    function handleQuestionFiles_multy(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateQuestionOptions_multy(data) {
        data.AnswerOptions.forEach(option => {
            addQuestionnaireMultyOption(false, option.Id, option.Text, option.OrderId, option.Files, option.Weight);
        });
        makeOptionsSortable($(".questionnaire_multy_options_wrapper"));
    }

    function showQuestionnaireDateQuestion(questionId, question_wrapper) {
        $("#props_wrapper").append($("#questions_teamplate_date").html());
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairedateprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                setupDateQuestionUI_date(questionId, data);
                setupDatePickers_date(data);
                setupInputTypeHandlers_date();
                populateQuestionData_date(questionId, data);
                handleQuestionLogic_date(questionId, data);
                handleQuestionFiles_date(questionId, data);
                finishSetup_date(data);
            }
        });
    }

    function setupDateQuestionUI_date(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
        $('input[name="Weight"]').val(data.Weight);
        setCheckboxState_date('ManualExpertise', data.ManualExpertise);
    }

    function setupDatePickers_date(data) {
        const max = parseDateOrDefault_date(data.MaxDate, [31, 12, 2099]);
        const min = parseDateOrDefault_date(data.MinDate, [1, 1, 1990]);
        const maxScale = parseDateOrDefault_date(data.MaxDateScale, [31, 12, 2099]);
        const minScale = parseDateOrDefault_date(data.MinDateScale, [1, 1, 1990]);
        setupRegularDatePickers_date(min, max);
        setupBetweenDatePickers_date(minScale, maxScale);
    }

    function setupRegularDatePickers_date(min, max) {
        setupRegularDatePicker_date($("#nomore"), max);
        setupRegularDatePicker_date($("#noless"), min);
    }

    function setupRegularDatePicker_date(datePicker, value) {
        datePicker.kendoDatePicker({
            format: "dd.MM.yyyy",
            change: function () { SaveDateValue(this); },
            value: new Date(value[2], value[1] - 1, value[0]),
        });
        datePicker.attr("readonly", true).closest("span.k-datepicker").hide();

    }

    function setupBetweenDatePickers_date(min, max) {
        setupBetweenDatePicker_date('#between_min', min, max, true);
        setupBetweenDatePicker_date('#between_max', max, min, false);
    }

    function setupBetweenDatePicker_date(selector, value, limit, isMin) {
        $(selector).kendoDatePicker({
            format: "dd.MM.yyyy",
            change: function () {
                const otherPicker = isMin ? "#between_max" : "#between_min";
                const datePicker = $(otherPicker).data('kendoDatePicker');
                const newLimit = this.element[0].value.split('.');
                datePicker[isMin ? 'min' : 'max'](new Date(newLimit[2], newLimit[1] - 1, newLimit[0]));
                SaveDateValue(this);
            },
            value: new Date(value[2], value[1] - 1, value[0]),
            [isMin ? 'max' : 'min']: new Date(limit[2], limit[1] - 1, limit[0])
        }).attr('readonly', true).closest('span.k-datepicker').hide();
    }

    function setupInputTypeHandlers_date() {
        const inputTypes = ['notLess', 'notMore', 'date', 'dateandtime', 'time', 'between'];
        inputTypes.forEach(type => {
            $("body").on("click", `input:radio[value='${type}'][name='InputType']`, function () {
                handleInputTypeChange_date(type);
            });
        });
    }

    function handleInputTypeChange_date(type) {
        const datePickers = [$("#nomore"), $('#noless'), $('#between_min'), $('#between_max')];
        datePickers.forEach(date => date.closest('span.k-datepicker').hide());

        if (type === 'notLess' || type === 'notMore') {
            const element = type === 'notLess' ? $("#noless") : $("#nomore");
            const defaultDate = type === 'notLess' ? new Date(1990, 0, 1) : new Date(2099, 0, 1);
            const date = kendo.toString(kendo.parseDate(element.data("kendoDatePicker").options.value), 'dd.MM.yyyy') || kendo.toString(kendo.parseDate(defaultDate), 'dd.MM.yyyy');
            showDatePicker_date(element, datePickers.filter(x => x[0].id !== element[0].id), date);
            element.trigger('click');
        } else if (type === 'between') {
            $("#between_min, #between_max").closest("span.k-datepicker").show();
            const minDate = kendo.toString(kendo.parseDate($("#between_min").data("kendoDatePicker").options.value), 'dd.MM.yyyy') || kendo.toString(kendo.parseDate(new Date(1990, 0, 1)), 'dd.MM.yyyy');
            const maxDate = kendo.toString(kendo.parseDate($("#between_max").data("kendoDatePicker").options.value), 'dd.MM.yyyy') || kendo.toString(kendo.parseDate(new Date(2099, 0, 1)), 'dd.MM.yyyy');
            $("#between_min").val(minDate);
            $("#between_max").val(maxDate);
        }
    }

    function populateQuestionData_date(questionId, data) {
        $(`input[name="InputType"][value="${data.InputType}"]`).attr("checked", "checked");
        setCheckboxState_date('IsAnswerRequired', data.IsAnswerRequired);
        handleInputTypeChange_date(data.InputType);
    }

    function handleQuestionLogic_date(questionId, data) {
        renderAppropriateLogicButton(data.InputType, questionId);
        addLogic($("#add_logic_changable_button"), questionId, data.Logics);
    }

    function handleQuestionFiles_date(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function finishSetup_date(data) {
        Preloader.DisableLoader("#props_content");
        if (data.IsAnswerRequired) {
            $('.question_wrapper[data-questionid="' + $('input[name="QuestionId"]').val() + '"]')
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
        $("[data-toggle='tooltip']").tooltip();
    }

    function showDatePicker_date(show, hide, data) {
        if (show) {
            show.closest("span.k-datepicker").show();
            if (data) {
                show.val(data);
            }
        }
        if (Array.isArray(hide)) {
            hide.forEach(x => {
                x.val("");
                x.closest("span.k-datepicker").hide();
            });
        }
    }

    function setCheckboxState_date(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function parseDateOrDefault_date(date, defaultDate) {
        return date && date !== "" ? date.split('.') : defaultDate;
    }

    function showQuestionnaireDaDataInputQuestion(questionId, question_wrapper) {
        const propsWrapper = $("#props_wrapper");
        propsWrapper.append($("#questionnaire_dadata_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairedadatainputprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                const itemContainer = $(".item_container");
                itemContainer.attr("data-itemid", questionId);

                const questionText = $("div.question_text");
                questionText.html(data.Text).attr("id", `editor_${questionId}`);

                setCheckboxState_input('ManualExpertise', data.ManualExpertise);
                $("input[name='Weight']").val(data.Weight);

                setInputType_dadatainput(data);
                setDropdownList_dadatainput(data);
                setAnswerRequired_input(data, questionId);

                $('input[name="QuestionId"]').val(questionId);

                addLogic($("#add_logic_changable_button"), questionId, data.Logics);

                setupFileUpload_input(questionId);
                loadFiles($(`.files_wrapper[data-id="${questionId}"]`), data.Files);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function setDropdownList_dadatainput(data) {
        $("#DaData_input").kendoDropDownList({
            dataSource: {
                transport: {
                    read: {
                        url: "/api/dadataSuggestions/getsuggestiontypes",
                        type: "GET",
                        dataType: "json"
                    }
                }
            },
            dataTextField: "Label",
            dataValueField: "Name",
            select: function (e) {
                const item_container = $(this).closest('div.item_container');
                const id = item_container.data("itemid");
                const type = item_container.data("itemtype");
                const propertyName = $(this).attr("name");

                const data = {
                    Id: id,
                    ItemType: type,
                    PropertyName: propertyName,
                    Value: e.dataValueField,
                    __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                    questionnaireId: options.QuestionnaireId
                };
                Delay(SaveProperty, data, 300);

            }
        });
        var dropdownlist = $("#DaData_input").data("kendoDropDownList");
        dropdownlist.value(data.DaDataInputType);
    }

    function setInputType_dadatainput(data) {
        $(`option[name="DaDataInputTypeOption"][value="${data.DaDataInputType}"]`).prop("selected", true);
    }

    function showQuestionnaireInputQuestion(questionId, question_wrapper) {
        const propsWrapper = $("#props_wrapper");
        propsWrapper.append($("#questionnaire_input_editor_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnaireinputprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                const itemContainer = $(".item_container");
                itemContainer.attr("data-itemid", questionId);

                const questionText = $("div.question_text");
                questionText.html(data.Text).attr("id", `editor_${questionId}`);

                setCheckboxState_input('ManualExpertise', data.ManualExpertise);
                $("input[name='Weight']").val(data.Weight);

                setInputTypeAndMask_input(data);
                setFromToValues_input(data);
                setAnswerRequired_input(data, questionId);

                $('input[name="QuestionId"]').val(questionId);

                renderAppropriateLogicButton(data.InputType, questionId);
                addLogic($("#add_logic_changable_button"), questionId, data.Logics);

                setupFileUpload_input(questionId);
                loadFiles($(`.files_wrapper[data-id="${questionId}"]`), data.Files);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function showQuestionnaireSpreadsheetQuestion(questionId, question_wrapper) {
        const propsWrapper = $("#props_wrapper");
        propsWrapper.append($("#questionnaire_spreadsheet_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairespreadsheetprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                $("#props_content .constructor__editor-inner").addClass("constructor__editor-inner--spreadsheet");

                const itemContainer = $(".item_container");
                itemContainer.attr("data-itemid", questionId);

                const questionText = $("div.question_text");
                questionText.html(data.Text).attr("id", `editor_${questionId}`);

                setCheckboxState_input('ManualExpertise', data.ManualExpertise);
                $("input[name='Weight']").val(data.Weight);

                $('input[name="QuestionId"]').val(questionId);

                setupFileUpload_input(questionId);
                loadFiles($(`.files_wrapper[data-id="${questionId}"]`), data.Files);

                createNumericTextboxSpreadsheet(data);
                setSpreadSheet(data);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function setSpreadSheet(data) {
        if (data.SpreadsheetConfigurationJson) {
            setNumericTextboxSpreadsheetValues(data.SpreadsheetRowsCount, data.SpreadsheetColumnsCount);
        }
        var rowsCount = $("#spreadsheetRowsCount").val();
        var colsCount = $("#spreadsheetColumnsCount").val();
        var questionId = $(".item_container[data-itemtype='question']").data("itemid");
        var spreadsheet = ($("#spreadSheet").kendoSpreadsheet({
            toolbar: {
                home: [
                    {
                        type: "button",
                        text: "Во весь экран",
                        togglable: true,
                        icon: "border-radius",
                        click: function () {
                            if (document.fullscreenElement) {
                                document.exitFullscreen();
                            } else {
                                $("#spreadSheet").get(0).requestFullscreen();
                            }
                        }
                    },
                    "undo",
                    "redo",
                    "exportAs",
                    ["cut", "copy", "paste"],
                    "alignment",
                    "textWrap",
                    "fontSize", "fontFamily",
                    ["bold", "italic", "underline"],
                    "backgroundColor",
                    "textColor",
                    "borders",
                ],
            },
            pdf: {
                area: "sheet"
            },
            excelExport: function (e) {
                e.workbook.fileName = e.workbook.activeSheet + ".xlsx";
            },
            excelImport: function (e) {
                e.deferred.then(function () {
                    var maxRowsCount = 0;
                    var maxColsCount = 0;
                    var sheets = e.sender.sheets();
                    rowsCount = $("#spreadsheetRowsCount").val();
                    colsCount = $("#spreadsheetColumnsCount").val();
                    sheets.forEach(sheet => {
                        var currentRowsCount = sheet._rows._count;
                        var currentColsCount = sheet._columns._count;
                        if (currentRowsCount > rowsCount || currentColsCount > colsCount) {
                            maxRowsCount = rowsCount;
                            maxColsCount = colsCount;
                            $("<div></div>").kendoDialog({
                                width: "400px",
                                title: "Подтверждение",
                                content: i18n.message_tooBigSpreadsheetSize,
                                actions: [
                                    {
                                        text: "OK", primary: true, action: function () {
                                        }
                                    }
                                ],
                                closable: false
                            }).data("kendoDialog").open();
                            return;
                        }
                        if (currentRowsCount > maxRowsCount) {
                            maxRowsCount = currentRowsCount;
                        }
                        if (currentColsCount > maxColsCount) {
                            maxColsCount = currentColsCount;
                        }
                    });
                    sheets.forEach(sheet => {
                        sheet.resize(maxRowsCount, maxColsCount);
                    });
                    setNumericTextboxSpreadsheetValues(maxRowsCount, maxColsCount);
                });
            },
            rows: rowsCount,
            columns: colsCount,
            selectSheet: function (e) {
                var sheet = e.sheet;
                var rowCount = $("#spreadsheetRowsCount").val();
                var colCount = $("#spreadsheetColumnsCount").val();
                sheet.resize(rowCount, colCount);
            },
            renameSheet: function (e) {

            }
        })).data('kendoSpreadsheet');
        if (data.SpreadsheetConfigurationJson) {
            spreadsheet.fromJSON(JSON.parse(data.SpreadsheetConfigurationJson));
        }
        document.querySelectorAll('[data-dialog="insertImage"]').forEach(el => el.remove());
    };

    function countSelectedCells(range) {
        var cellsCount = 0;
        if (!range.refs) {
            if (range.topLeft) {
                cellsCount += (range.bottomRight.row - range.topLeft.row + 1) * (range.bottomRight.col - range.topLeft.col + 1);
            }
            else {
                cellsCount++;
            }
        }
        else {
            range.refs.forEach((element) => {
                if (element.topLeft) {
                    cellsCount += (element.bottomRight.row - element.topLeft.row + 1) * (element.bottomRight.col - element.topLeft.col + 1);
                }
                else {
                    cellsCount++;
                }
            });
        }
        return cellsCount;
    };

    function changeColorSpreadsheetSelectedCells(color) {
        var spreadsheet = $("#spreadSheet").data("kendoSpreadsheet");
        var questionId = $(".item_container[data-itemtype='question']").data("itemid");
        if (spreadsheet) {
            var sheet = spreadsheet.activeSheet();
            var selection = sheet.selection();
            $.ajax({
                url: "/api/constructor/changecellscolorspreadsheet",
                data: {
                    configuration: JSON.stringify(spreadsheet),
                    selection: JSON.stringify(selection),
                    backgroundColor: color
                },
                type: "post",
                success: function (data) {
                    spreadsheet.fromJSON(JSON.parse(data));
                },
                error: function (data) {
                    if (data.responseJSON && data.responseJSON.Value) {
                        Notification.ShowError(data.responseJSON.Value);
                        return;
                    }
                    defaultErrorHandler(data);
                }
            });
        }
    };

    function changeSpreadsheetSize() {
        const rowsElement = $('#spreadsheetRowsCount');
        const colsElement = $('#spreadsheetColumnsCount');
        if (rowsElement !== undefined && colsElement !== undefined) {
            var spreadsheet = $("#spreadSheet").data("kendoSpreadsheet");
            var questionId = $(".item_container[data-itemtype='question']").data("itemid");
            spreadsheet.sheets().forEach(function (sheet) {
                sheet.resize(rowsElement.val(), colsElement.val());
            });
            var analiticsCells = getSpreadsheetAnaliticsCells();
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/savespreadsheetsize",
                type: "POST",
                data: {
                    "analiticsCells": analiticsCells,
                    "options": JSON.stringify(spreadsheet),
                    "questionnaireId": options.QuestionnaireId,
                    "questionId": questionId,
                    "rowsCount": rowsElement.val(),
                    "colsCount": colsElement.val()
                },
                error: function (data) {
                    if (data.responseJSON && data.responseJSON.Value) {
                        Notification.ShowError(data.responseJSON.Value);
                        return;
                    }
                    defaultErrorHandler(data);
                },
                success: function (data) {
                    Notification.ShowSuccess(i18n.alert_ChangesSaved);
                    updateQuestionValidationState(questionId);
                }
            });
        };
    };

    function createNumericTextboxSpreadsheet(data) {
        $('#spreadsheetRowsCount').on("change", function () {
            const value = $(this).val();
            const isValidInteger = /^-?\d+$/.test(value);
            const maxValue = 2000;

            if (!isValidInteger || value > maxValue) {
                $(this).val(maxValue);
            }

            changeSpreadsheetSize();
        });
        $('#spreadsheetColumnsCount').on("change", function () {
            const value = $(this).val();
            const isValidInteger = /^-?\d+$/.test(value);
            const maxValue = 100;

            if (!isValidInteger || value > maxValue) {
                $(this).val(maxValue);
            }

            changeSpreadsheetSize();
        });

        if (data.SpreadsheetConfigurationJson) {
            setNumericTextboxSpreadsheetValues(data.SpreadsheetRowsCount, data.SpreadsheetColumnsCount);
        }
    }

    function setNumericTextboxSpreadsheetValues(rowsCount, colsCount) {
        $('#spreadsheetRowsCount').val(rowsCount);
        $('#spreadsheetColumnsCount').val(colsCount);
    }

    function getSpreadsheetAnaliticsCells() {
        var spreadsheet = $("#spreadSheet").data("kendoSpreadsheet");
        let analiticsCells = "";
        let sheets = spreadsheet.sheets();

        function columnToLetter(column) {
            let letter = "";
            while (column >= 0) {
                letter = String.fromCharCode((column % 26) + 65) + letter;
                column = Math.floor(column / 26) - 1;
            }
            return letter;
        }

        var sheetIndex = 0;
        sheets.forEach(sheet => {
            let rowCount = sheet._rows._count;
            let colCount = sheet._columns._count;

            for (let row = 0; row < rowCount; row++) {
                for (let col = 0; col < colCount; col++) {
                    let cellRange = sheet.range(row, col);

                    if (cellRange && (cellRange.background() === "#f5f5dc" || cellRange.background() === 'beige')) {
                        let columnLetter = columnToLetter(col);
                        let excelCell = `${columnLetter}${row + 1}`;
                        analiticsCells += `Sheet${sheetIndex}_${excelCell}|`;
                    }
                }
            }
            sheetIndex += 1;
        });
        return analiticsCells.replace(/\|$/, "");
    };

    function setCheckboxState_input(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function setInputTypeAndMask_input(data) {
        $(`input[name="InputType"][value="${data.InputType}"]`).prop("checked", true);
        if (data.InputType === "inputMask") {
            const maskInput = $('input[name="InputMask"]');
            maskInput.prop("readonly", false).val(data.InputMask);
        }
    }

    function setFromToValues_input(data) {
        ['from', 'to'].forEach(field => {
            const element = $(`#${data.InputType}_${field}`);
            element.prop("readonly", false).val(data[field.charAt(0).toUpperCase() + field.slice(1)]);
        });
    }

    function setAnswerRequired_input(data, questionId) {
        if (data.IsAnswerRequired) {
            setCheckboxState_input('IsAnswerRequired', true);
            $(`.question_wrapper[data-questionid="${questionId}"] .IsAnswerRequired`).css('display', 'inline-block');
        }
    }

    function setupFileUpload_input(questionId) {
        $(".add_files.question_files, .files_wrapper.question_files").attr({
            "data-id": questionId,
            "data-type": "question"
        });
    }

    function showQuestionnaireDropdownQuestion(questionId, question_wrapper) {
        $($("#questionnaire_dropdown_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairedropdownprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                populateQuestionData_dropdown(questionId, data);
                setupQuestionUI_dropdown(questionId);
                handleQuestionLogic_dropdown(questionId, data);
                handleQuestionFiles_dropdown(questionId, data);
                populateQuestionOptions_dropdown(data);

                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function populateQuestionData_dropdown(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);

        setCheckboxState_dropdown('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_dropdown('ManualExpertise', data.ManualExpertise);
        setCheckboxState_dropdown('AllowUserOption', data.AllowUserOption);
        setCheckboxState_dropdown('AnswersRandomOrder', data.AnswersRandomOrder);
    }

    function setCheckboxState_dropdown(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function setupQuestionUI_dropdown(questionId) {
        $("#props_wrapper").find(".add_option")
            .attr("data-questionid", questionId)
            .attr("data-questiontype", "questionnaire_dropdown");
        $("#props_wrapper").find(".add_dropdown_multiline").attr("data-questionid", questionId);
    }

    function handleQuestionLogic_dropdown(questionId, data) {
        addLogic($(".add_logic_withoptions"), questionId, data.Logics);
    }

    function handleQuestionFiles_dropdown(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateQuestionOptions_dropdown(data) {
        data.AnswerOptions.forEach(option => {
            addQuestionnaireDropdownOption(false, option.Id, option.Text, option.OrderId, option.Weight);
        });
        makeOptionsSortable($(".questionnaire_dropdown_options_wrapper"));
    }

    function showQuestionnaireTableOption(questionId, question_wrapper) {
        $("#props_wrapper").append($("#questionnaire_table_editor_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairetableprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                setupQuestionUI_table(questionId, data);
                populateQuestionData_table(questionId, data);
                handleQuestionLogic_table(questionId, data);
                handleQuestionFiles_table(questionId, data);
                populateQuestionOptions_table(data);
                finishSetup_table();
            }
        });
    }

    function setupQuestionUI_table(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $("#props_wrapper").find(".add_option")
            .attr("data-questionid", questionId)
            .attr("data-questiontype", "questionnaire_table");
    }

    function populateQuestionData_table(questionId, data) {
        $('input[name="QuestionId"]').val(questionId);
        setCheckboxState_table('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_table('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_table('ManualExpertise', data.ManualExpertise);
        $("input[name='Weight']").val(data.Weight);
    }

    function setCheckboxState_table(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function handleQuestionLogic_table(questionId, data) {
        addLogic($(".add_logic_withoptions"), questionId, data.Logics);
    }

    function handleQuestionFiles_table(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function populateQuestionOptions_table(data) {
        data.AnswerOptions.forEach(option => {
            addQuestionnaireTableOption(false, option.Id, option.TextA, option.TextB, option.OrderId, option.Files, option.Weight);
        });
        makeOptionsSortable($(".questionnaire_table_options_wrapper"));
    }

    function finishSetup_table() {
        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
        inputValid();
    }

    function showQuestionnaireNpsQuestion(questionId, question_wrapper) {
        $("#props_wrapper").append($("#questionnaire_nps_editor_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairenpsprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                setupQuestionUI_nps(questionId, data);
                populateQuestionData_nps(questionId, data);
                handleQuestionLogic_nps(questionId, data);
                handleQuestionFiles_nps(questionId, data);
                finishSetup_nps();
            }
        });
    }

    function setupQuestionUI_nps(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
    }

    function populateQuestionData_nps(questionId, data) {
        $('input[name="QuestionId"]').val(questionId);
        setCheckboxState_nps('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_nps('ManualExpertise', data.ManualExpertise);
        $("input[name='Weight']").val(data.Weight);
        $('input[name="ScaleMinText"]').val(data.ScaleMinText);
        $('input[name="ScaleMaxText"]').val(data.ScaleMaxText);
    }

    function setCheckboxState_nps(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function handleQuestionLogic_nps(questionId, data) {
        addLogic($(".add_logic_number"), questionId, data.Logics);
    }

    function handleQuestionFiles_nps(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function finishSetup_nps() {
        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
    }

    function showQuestionnaireRatingQuestion(questionId, question_wrapper) {
        $("#props_wrapper").append($("#questionnaire_rating_editor_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnaireratingprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                setupQuestionUI_rating(questionId, data);
                populateQuestionData_rating(questionId, data);
                handleQuestionLogic_rating(questionId, data);
                handleQuestionFiles_rating(questionId, data);
                setupQuestionSkin_rating(data);
                finishSetup_rating();
            }
        });
    }

    function setupQuestionUI_rating(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
    }

    function populateQuestionData_rating(questionId, data) {
        $('input[name="QuestionId"]').val(questionId);
        setCheckboxState_rating('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_rating('ManualExpertise', data.ManualExpertise);
        $("input[name='Weight']").val(data.Weight);
        $('input[name="ScaleMinText"]').val(data.ScaleMinText);
        $('input[name="ScaleMaxText"]').val(data.ScaleMaxText);
        $('input[name="ScaleMin"]').val(data.ScaleMin);
        $('input[name="ScaleMax"]').val(data.ScaleMax);
    }

    function setCheckboxState_rating(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function handleQuestionLogic_rating(questionId, data) {
        addLogic($(".add_logic_number"), questionId, data.Logics);
    }

    function handleQuestionFiles_rating(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupQuestionSkin_rating(data) {
        const skinInput = data.Skin ?
            $(`input.change_question_skin[type="radio"]#${data.Skin}`) :
            $('input.change_question_skin[type="radio"]:first');
        skinInput.prop("checked", true);
    }

    function finishSetup_rating() {
        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
    }

    function showQuestionnaireAutocompleteQuestion(questionId, question_wrapper) {
        $("#props_wrapper").append($("#questionnaire_autocomplete_editor_template").html());

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnaireautocompleteprops",
            type: "GET",
            data: { questionId },
            success: function (data) {
                setupQuestionUI_autocomplete(questionId, data);
                populateQuestionData_autocomplete(data);
                handleQuestionLogic_autocomplete(questionId, data);
                handleQuestionFiles_autocomplete(questionId, data);
                setupAnswerOptions_autocomplete(questionId, data);
                finishSetup_autocomplete();
            }
        });
    }

    function setupQuestionUI_autocomplete(questionId, data) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
    }

    function populateQuestionData_autocomplete(data) {
        $('input[name="QuestionId"]').val(data.Id);
        setCheckboxState_autocomplete('ManualExpertise', data.ManualExpertise);
        setCheckboxState_autocomplete('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_autocomplete('AllowUserOption', data.AllowUserOption);
    }

    function setCheckboxState_autocomplete(name, isChecked) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${$('input[name="QuestionId"]').val()}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function handleQuestionLogic_autocomplete(questionId, data) {
        addLogic($(".add_logic_string"), questionId, data.Logics);
    }

    function handleQuestionFiles_autocomplete(questionId, data) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAnswerOptions_autocomplete(questionId, data) {
        const addOptionBtn = $("#props_wrapper").find(".add_option");
        addOptionBtn.attr("data-questionid", questionId).attr("data-questiontype", "questionnaire_autocomplete");

        $("#props_wrapper").find(".add_autocomplete_multiline").attr("data-questionid", questionId);

        data.AnswerOptions.forEach(option => {
            addQuestionnaireAutocompleteOption(false, option.Id, option.Text, option.Weight);
        });

        makeOptionsSortable($(".questionnaire_autocomplete_options_wrapper"));
    }

    function finishSetup_autocomplete() {
        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
    }

    function showQuestionnaireFileQuestion(questionId, question_wrapper) {
        const propsWrapper = $("#props_wrapper");
        propsWrapper.append($("#questionnaire_file_editor_template").html());

        setupNumberInput_file();
        setupMultiSelects_file(questionId);
        loadSelectedFileTypesAndFormats_file(questionId);
        loadQuestionProperties_file(questionId);

        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
    }

    function setupNumberInput_file() {
        $("input.only_numbers").on("keydown", function (e) {
            if (['e', 'E', '-', '+'].includes(e.key)) {
                e.preventDefault();
            }
        });
    }

    function setupMultiSelects_file(questionId) {
        setupMultiSelect_file("#multiSelectFileType", "/api/fileformat/getalltypes", questionId);
        setupMultiSelect_file("#multiSelectFileFormats", "/api/filetypes/getallformats", questionId);

        $("#multiSelectFileFormats, #multiSelectFileType").data("kendoMultiSelect").bind("deselect", function (e) {
            if ($(this.element).val().length === 1) {
                e.preventDefault();
            }
        });
    }

    function setupMultiSelect_file(selector, url, questionId) {
        $(selector).attr("questionId", questionId);
        $(selector).kendoMultiSelect({
            autoClose: false,
            dataSource: new kendo.data.DataSource({
                transport: {
                    read: {
                        url: url,
                        data: { questionId: questionId },
                        type: "post",
                    }
                }
            })
        });
    }

    function loadSelectedFileTypesAndFormats_file(questionId) {
        $.ajax({
            url: "/api/filetypesformats/selectedfiletypesformats",
            data: { questionId: questionId },
            type: "post",
            success: function (data) {
                if (data[0] && data[1]) {
                    $("#multiSelectFileType").data("kendoMultiSelect").value(data[0].split(","));

                    const fileFormatsDataSource = new kendo.data.DataSource({
                        transport: {
                            read: {
                                url: "/api/filetypes/getFileFormats?fileTypes=" + data[0],
                                type: "GET",
                            }
                        }
                    });

                    const multiSelectFileFormats = $("#multiSelectFileFormats").data("kendoMultiSelect");
                    multiSelectFileFormats.setDataSource(fileFormatsDataSource);
                    multiSelectFileFormats.value(data[1].split(", "));
                }
            }
        });
    }

    function loadQuestionProperties_file(questionId) {
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairefileprops",
            type: "GET",
            data: { questionId: questionId },
            success: function (data) {
                populateQuestionData_file(data, questionId);
                setupLogicAndFiles_file(data, questionId);
            }
        });
    }

    function populateQuestionData_file(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);

        setCheckboxState_file('IsAnswerRequired', data.IsAnswerRequired, questionId);
        setCheckboxState_file('ManualExpertise', data.ManualExpertise);

        $('input[name="Weight"]').val(data.Weight);
        $('input[name="QuestionId"]').val(questionId);
        $('input[name="FileExtensions"]').val(data.FileExtensions);
        $("input[name='MaxFileSize']").val(parseInt(data.MaxFileSize));
        $("select[name='StorageUnit']").val(data.MaxFileSize.substring(data.MaxFileSize.indexOf(" ") + 1));
    }

    function setCheckboxState_file(name, isChecked, questionId) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${questionId}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function setupLogicAndFiles_file(data, questionId) {
        addLogic($(".add_logic_no_options"), questionId, data.Logics);

        const filesWrapper = $(".add_files.question_files, .files_wrapper.question_files");
        filesWrapper.attr("data-id", questionId);
        $(".add_files.question_files").attr("data-type", "question");
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function showQuestionnaireScaleQuestion(questionId, question_wrapper) {
        $($("#questionnaire_scale_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getquestionnairescaleprops",
            type: "GET",
            data: { questionId: questionId },
            success: function (data) {
                populateQuestionData_scale(data, questionId);
                setupScaleInputs_scale(data);
                setupLogicAndFiles_scale(data, questionId);
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function showTestScaleQuestion(questionId, question_wrapper) {
        $($("#test_scale_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestscaleprops",
            type: "GET",
            data: { questionId: questionId },
            success: function (data) {
                populateQuestionData_scale(data, questionId);
                setupScaleInputs_scale(data);
                setupTestScaleSpecificInputs_scale(data);
                setupFiles_scale(data, questionId);
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
            }
        });
    }

    function populateQuestionData_scale(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
        $('input[name="Weight"]').val(data.Weight);
        setCheckboxState_scale('IsAnswerRequired', data.IsAnswerRequired, questionId);
        setCheckboxState_scale('ManualExpertise', data.ManualExpertise);
    }

    function setupScaleInputs_scale(data) {
        $('input[name="ScaleMin"]').val(data.ScaleMin);
        $('input[name="ScaleMax"]').val(data.ScaleMax);
        $('input[name="ScaleStep"]').val(data.ScaleStep);
        $('input[name="ScaleMinText"]').val(data.ScaleMinText);
        $('input[name="ScaleMaxText"]').val(data.ScaleMaxText);
    }

    function setupTestScaleSpecificInputs_scale(data) {
        $('textarea[name="ScaleMinText"]').val(data.ScaleMinText);
        $('textarea[name="ScaleMaxText"]').val(data.ScaleMaxText);
        $("input[name='RightAnswer']").val(data.RightAnswer);
    }

    function setupLogicAndFiles_scale(data, questionId) {
        addLogic($(".add_logic_number"), questionId, data.Logics);
        setupFiles_scale(data, questionId);
    }

    function setupFiles_scale(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setCheckboxState_scale(name, isChecked, questionId) {
        const checkbox = $(`input[name="${name}"]`);
        checkbox.prop("checked", isChecked);
        if (name === 'IsAnswerRequired' && isChecked) {
            $(`.question_wrapper[data-questionid="${questionId}"]`)
                .find('.IsAnswerRequired').css('display', 'inline-block');
        }
    }

    function showTestSingleQuestion(questionId, question_wrapper) {
        $($("#test_single_editor_template").html()).appendTo("#props_wrapper"); //show main editor

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestsingleprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testsingle(data, questionId);
                setupAnswerOptions_testsingle(data, questionId);
                setupFiles_testsingle(data, questionId);
                setupAdditionalProperties_testsingle(data, questionId);

                makeOptionsSortable($(".test_single_options_wrapper"));
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testsingle(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
        $('input[name="Weight"]').val(data.Weight);
        setCheckboxState_testsingle('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_testsingle('ManualExpertise', data.ManualExpertise);
        setCheckboxState_testsingle('AnswersRandomOrder', data.AnswersRandomOrder);
    }

    function setupAnswerOptions_testsingle(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_single");
        data.AnswerOptions.forEach(option => {
            addTestSingleOption(false, option.Id, option.Text, option.IsTrueAnswer,
                option.OrderId, option.Message, option.Files, option.Weight);
        });
    }

    function setupFiles_testsingle(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAdditionalProperties_testsingle(data, questionId) {
        // Add any additional setup here if needed
    }

    function setCheckboxState_testsingle(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function showTestSingleUndefinedQuestion(questionId, question_wrapper) {
        $($("#test_single_undefined_editor_template").html()).appendTo("#props_wrapper"); //show main editor
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestsingleundefinedprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testsingleundefined(data, questionId);
                setupAnswerOptions_testsingleundefined(data, questionId);
                setupFiles_testsingleundefined(data, questionId);
                setupAdditionalProperties_testsingleundefined(data, questionId);

                makeOptionsSortable($(".test_single_undefined_options_wrapper"));
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testsingleundefined(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
        setCheckboxState_testsingleundefined('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_testsingleundefined('ManualExpertise', data.ManualExpertise);
        setCheckboxState_testsingleundefined('AnswersRandomOrder', data.AnswersRandomOrder);
    }

    function setupAnswerOptions_testsingleundefined(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_single_undefined");
        data.AnswerOptions.forEach(option => {
            addTestSingleUndefinedOption(false, option.Id, option.Text, option.IsTrueAnswer,
                option.OrderId, option.Message, option.Files, option.Weight);
        });
    }

    function setupFiles_testsingleundefined(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAdditionalProperties_testsingleundefined(data, questionId) {
        // Add any additional setup here if needed
    }

    function setCheckboxState_testsingleundefined(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function showTestTableQuestion(questionId, question_wrapper) {
        $($("#test_table_editor_template").html()).appendTo("#props_wrapper"); //show main editor
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettesttableprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testtable(data, questionId);
                setupAnswerOptions_testtable(data, questionId);
                setupFiles_testtable(data, questionId);
                setupAdditionalProperties_testtable(data);

                makeOptionsSortable($(".test_table_options_wrapper"));
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testtable(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        setCheckboxState_testtable('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_testtable('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_testtable('ManualExpertise', data.ManualExpertise);
    }

    function setupAnswerOptions_testtable(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_table");
        data.AnswerOptions.forEach(option => {
            addTestTableOption(false, option.Id, option.TextA, option.TextB,
                option.Weight, option.OrderId, option.Message, option.Files,
                option.TableWrongMessage);
        });
    }

    function setupFiles_testtable(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAdditionalProperties_testtable(data) {
        // Add any additional setup here if needed
    }

    function setCheckboxState_testtable(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function showTestMultyQuestion(questionId, question_wrapper) {
        $($("#test_multy_editor_template").html()).appendTo("#props_wrapper"); //show main editor

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestmultyprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testmulty(data, questionId);
                setupAnswerOptions_testmulty(data, questionId);
                setupFiles_testmulty(data, questionId);
                setupAdditionalProperties_testmulty(data);

                makeOptionsSortable($(".test_multy_options_wrapper"));
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testmulty(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        setCheckboxState_testmulty('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_testmulty('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_testmulty('ManualExpertise', data.ManualExpertise);
    }

    function setupAnswerOptions_testmulty(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_multy");
        data.AnswerOptions.forEach(option => {
            addTestMultyOption(false, option.Id, option.Text, option.IsTrueAnswer, option.Weight,
                option.OrderId, option.Message, option.Files);
        });
    }

    function setupFiles_testmulty(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAdditionalProperties_testmulty(data) {
        // Add any additional setup here if needed
    }

    function setCheckboxState_testmulty(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function showTestMultyUndefinedQuestion(questionId, question_wrapper) {
        $($("#test_multy_undefined_editor_template").html()).appendTo("#props_wrapper"); //show main editor

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestmultyundefinedprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testmultyundefined(data, questionId);
                setupAnswerOptions_testmultyundefined(data, questionId);
                setupFiles_testmultyundefined(data, questionId);
                setupAdditionalProperties_testmultyundefined(data);

                makeOptionsSortable($(".test_multy_undefined_options_wrapper"));
                Preloader.DisableLoader("#props_content");
                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testmultyundefined(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        setCheckboxState_testmultyundefined('AnswersRandomOrder', data.AnswersRandomOrder);
        setCheckboxState_testmultyundefined('IsAnswerRequired', data.IsAnswerRequired);
        setCheckboxState_testmultyundefined('ManualExpertise', data.ManualExpertise);
    }

    function setupAnswerOptions_testmultyundefined(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_multy_undefined");
        data.AnswerOptions.forEach(option => {
            addTestMultyUndefinedOption(false, option.Id, option.Text, option.IsTrueAnswer, option.Weight,
                option.OrderId, option.Message, option.Files);
        });
    }

    function setupFiles_testmultyundefined(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAdditionalProperties_testmultyundefined(data) {
        // Add any additional setup here if needed
    }

    function setCheckboxState_testmultyundefined(name, isChecked) {
        $(`input[name="${name}"]`).prop("checked", isChecked);
    }

    function showTestOpenQuestion(questionId, question_wrapper) {
        $($("#test_open_editor_template").html()).appendTo("#props_wrapper"); //show main editor
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/gettestopenprops",
            type: "GET",
            data: {
                questionId: questionId
            },
            success: function (data) {
                populateQuestionData_testopen(data, questionId);
                setupWrongMessage_testopen(data, questionId);
                setupCheckboxes_testopen(data);
                setupFiles_testopen(data, questionId);
                setupAnswerOptions_testopen(data, questionId);

                makeOptionsSortable($(".test_open_options_wrapper"));
                Preloader.DisableLoader("#props_content");

                $("[data-toggle='tooltip']").tooltip();
                inputValid();
            }
        })
    }

    function populateQuestionData_testopen(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
    }

    function setupWrongMessage_testopen(data, questionId) {
        $("button.open_wrong_message_btn").attr("data-questionid", questionId);
        var shortText = $(data.OpenWrongMessage).text();
        $("span.open_wrong_message_short").html(shortText.substr(0, 100) + (shortText.length > 100 ? "..." : ""));
        $("span.open_wrong_message_full").html(data.OpenWrongMessage);
    }

    function setupCheckboxes_testopen(data) {
        $(".item_container").find('input[type="checkbox"][name="IsAnswerRequired"]').prop("checked", data.IsAnswerRequired);
        $(".item_container").find('input[type="checkbox"][name="ManualExpertise"]').prop("checked", data.ManualExpertise);
    }

    function setupFiles_testopen(data, questionId) {
        $(".add_files.question_files").attr("data-id", questionId).attr("data-type", "question");
        $(".files_wrapper.question_files").attr("data-id", questionId);
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function setupAnswerOptions_testopen(data, questionId) {
        $("#props_wrapper").find(".add_option").attr("data-questionid", questionId).attr("data-questiontype", "test_open");
        data.AnswerOptions.forEach(option => {
            addTestOpenOption(false, option.Id, option.Text, option.Weight, option.Message, option.OrderId);
        });
    }


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    function showHideExtendedAdditionalButton() {
        $('.item_container[data-itemtype="extended_question"]').each(function () {
            const additionalButton = $(this).find(".questionnaire_additional_addbutton_extended_multy");
            if ($(this).find($('.extended_option_container')).length === 0) {
                additionalButton.addClass("d-none");
            } else {
                additionalButton.removeClass("d-none");
            }
        });
    }

    function showQuestionnaireExtendedQuestion(questionId, question_wrapper) {
        $($("#questionnaire_extended_editor_template").html()).appendTo("#props_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getextendeddata",
            type: "GET",
            data: { questionId },
            success: function (data) {
                populateQuestionData_extendedquestion(data, questionId);
                setupCheckboxes_extendedquestion(data);
                setupFiles_extendedquestion(data, questionId);
                renderExtendedQuestions_extendedquestion(data.ExtendedQuestions);

                if (data.ExtendedQuestions.length > 0) {
                    $("#extended_options_content1").show();
                }

                setupChildQuestions_extendedquestion(questionId);
                finishSetup_extendedquestion();
            }
        });
    }

    function populateQuestionData_extendedquestion(data, questionId) {
        $(".item_container").attr("data-itemid", questionId);
        $("div.question_text").html(data.Text).attr("id", "editor_" + questionId);
        $('input[name="QuestionId"]').val(questionId);
    }

    function setupCheckboxes_extendedquestion(data) {
        $('input[name="IsAnswerRequired"]').prop("checked", data.IsAnswerRequired);
        $('input[name="ManualExpertise"]').prop("checked", data.ManualExpertise);
    }

    function setupFiles_extendedquestion(data, questionId) {
        $(".add_files.question_files, .files_wrapper.question_files").attr("data-id", questionId);
        $(".add_files.question_files").attr("data-type", "question");
        loadFiles($('.files_wrapper[data-id="' + questionId + '"]'), data.Files);
    }

    function renderExtendedQuestions_extendedquestion(extendedQuestions) {
        extendedQuestions.forEach(question => {
            switch (question.Type) {
                case "extended_dropdown":
                case "extended_multy":
                    addExtendedDropdownMulty(question);
                    break;
                case "extended_input":
                    addExtendedInput(question);
                    break;
                case "extended_file":
                    addExtendedFile(question);
                    setupFileMultiSelects_extendedquestion(question.Id);
                    break;
            }
        });
    }

    function setupFileMultiSelects_extendedquestion(questionId) {
        setupMultiSelect_extendedquestion("#multiSelectFileType_" + questionId, "/api/fileformat/getalltypes", questionId);
        setupMultiSelect_extendedquestion("#multiSelectFileFormats_" + questionId, "/api/extendedFileTypesFormats/getAllFormats", questionId);
    }

    function setupMultiSelect_extendedquestion(selector, url, questionId) {
        if (!$(selector).data("kendoMultiSelect")) {
            $(selector).kendoMultiSelect({
                autoClose: false,
                dataSource: new kendo.data.DataSource({
                    transport: {
                        read: {
                            url: url,
                            data: { questionId },
                            type: "post"
                        }
                    }
                })
            });
        }
    }

    function setupChildQuestions_extendedquestion(questionId) {
        $("#props_wrapper").find(".child_question_option").attr("data-questionid", questionId);
        makeChildQuestionsSortable($(".questionnaire_extended_child_questions_wrapper"));
    }

    function finishSetup_extendedquestion() {
        Preloader.DisableLoader("#props_content");
        $("[data-toggle='tooltip']").tooltip();
    }

    function addExtendedDropdownMulty(data) {
        const questionContainer = $(`<div class="extended_question_container" data-extendedquestionid="${data.Id}">`);

        questionContainer.append($("#extended_dropdownmulty_template").html());

        questionContainer.find(".item_container").attr("data-itemid", data.Id);
        questionContainer.find(".extended_question_text")
            .html(data.Text)
            .attr("id", `extended_question_text_editor_${data.Id}`);
        questionContainer.find(".badge-order").html(data.OrderId);
        questionContainer.find(".extended_question_type").html(data.Type === "extended_multy" ? i18n.name_QMulty : i18n.name_QDropdown);
        questionContainer.find('.remove_extended_question_form input[name="ExtendedQuestionId"]').val(data.Id);
        questionContainer.find('input[name="OptionId"]').val(data.Id);

        if (data.ExtendedAnswerOptions && data.ExtendedAnswerOptions.length) {
            data.ExtendedAnswerOptions.forEach(option => {
                addExtendedOptions(questionContainer.find(".extended_options_wrapper"), option);
            });
        }

        makeExtendedAnswerOptionsSortable(questionContainer.find(".extended_options_wrapper"));
        $(".questionnaire_extended_child_questions_wrapper").append(questionContainer);

        showHideExtendedAdditionalButton();
        saveExtendedQuestionsSort($(".questionnaire_extended_child_questions_wrapper"));
        handleTextHelperBtnClick();
    }

    function addExtendedInput(data) {
        const questionContainer = $(`<div class="extended_question_container" data-extendedquestionid="${data.Id}">`);
        const template = $("#extended_input_template").html();
        questionContainer.append(template);

        questionContainer.find(".item_container").attr("data-itemid", data.Id);
        questionContainer.find(".extended_question_text")
            .html(data.Text)
            .attr("id", `extended_question_text_editor_${data.Id}`);
        questionContainer.find(".badge-order").html(data.OrderId);
        questionContainer.find('.remove_extended_question_form input[name="ExtendedQuestionId"]').val(data.Id);
        questionContainer.find('input[name="OptionId"]').val(data.Id);

        const inputTypeRadio = questionContainer.find('input[name="InputType"]');
        inputTypeRadio.attr({
            "name": `InputType_` + data.Id,
            "data-propertyname": "InputType"
        });
        inputTypeRadio.filter(`[value="${data.InputType}"]`).prop("checked", true);

        if (data.InputType === "input") {
            const inputMask = questionContainer.find('input[name="InputMask"]');
            inputMask.val(data.InputMask).prop("readonly", false);
        }

        $(".questionnaire_extended_child_questions_wrapper").append(questionContainer);

        handleTextHelperBtnClick();
    }

    function addExtendedFile(data) {
        const questionContainer = $(`<div class="extended_question_container" data-extendedquestionid="${data.Id}">`);
        const template = $("#extended_file_template").html();
        questionContainer.append(template);

        questionContainer.find('input[name="OptionId"]').val(data.Id);
        questionContainer.find(".item_container").attr("data-itemid", data.Id);
        questionContainer.find(".extended_question_text")
            .html(data.Text)
            .attr("id", `extended_question_text_editor_${data.Id}`);
        questionContainer.find(".badge-order").html(data.OrderId);
        questionContainer.find('.remove_extended_question_form input[name="ExtendedQuestionId"]').val(data.Id);

        if (data.FileExtensions !== null) {
            questionContainer.find('input[name="FileExtensions"]').val(data.FileExtensions);
        }

        $(".questionnaire_extended_child_questions_wrapper").append(questionContainer);

        initializeFileQuestion_extendedfile(data.Id);
        setupFileTypeAndFormatSelects_extendedfile(data.Id);
        setupEventListeners_extendedfile(data.Id);

        $("#file_size_" + data.Id).val(parseInt(data.MaxFileSize));
        $("#selectFormats_" + data.Id).val(data.MaxFileSize.split(" ")[1]);

        handleTextHelperBtnClick();

        function initializeFileQuestion_extendedfile(questionId) {
            const container = $(`.extended_question_container[data-extendedquestionid='${questionId}']`);
            container.find("select.multiSelectFileFormats").attr("id", `multiSelectFileFormats_${questionId}`);
            container.find("select.multiSelectFileType").attr("id", `multiSelectFileType_${questionId}`);
            container.find(".selectFormats").attr("id", `selectFormats_${questionId}`);
            container.find(".file_size").attr("id", `file_size_${questionId}`);

            if ($("input.only_numbers")[0]) {
                $("input.only_numbers")[0].addEventListener("keydown", function (e) {
                    if (['e', 'E', '-', '+'].includes(e.key)) {
                        e.preventDefault();
                    }
                });
            }
        }

        function setupFileTypeAndFormatSelects_extendedfile(questionId) {
            setupMultiSelect_extendedfile(`#multiSelectFileType_${questionId}`, "/api/fileformat/getalltypes", { questionId });
            setupMultiSelect_extendedfile(`#multiSelectFileFormats_${questionId}`, "/api/extendedFileTypesFormats/getAllFormats", { extendedQuestionId: questionId });

            $.ajax({
                url: "/api/extendedfiletypesformats/selectedfiletypesformats",
                data: { questionId },
                type: "post",
                success: function (data) {
                    if (data[0] && data[1]) {
                        $(`#multiSelectFileType_${questionId}`).data("kendoMultiSelect").value(data[0].split(","));
                        updateFileFormatsDataSource_extendedfile(questionId, data[0]);
                        $(`#multiSelectFileFormats_${questionId}`).data("kendoMultiSelect").value(data[1].split(", "));
                    }
                }
            });
        }

        function setupMultiSelect_extendedfile(selector, url, data) {
            $(selector).kendoMultiSelect({
                autoClose: false,
                dataSource: new kendo.data.DataSource({
                    transport: {
                        read: {
                            url: url,
                            data: data,
                            type: "post"
                        }
                    }
                }),
            }).data("kendoMultiSelect").bind("deselect", function (e) {
                if ($(selector).val().length === 1) {
                    e.preventDefault();
                }
            });
        }

        function updateFileFormatsDataSource_extendedfile(questionId, fileTypes) {
            const dataSource = new kendo.data.DataSource({
                transport: {
                    read: {
                        url: `/api/filetypes/getFileFormats?fileTypes=${fileTypes}`,
                        type: "GET",
                    }
                }
            });
            $(`#multiSelectFileFormats_${questionId}`).data("kendoMultiSelect").setDataSource(dataSource);
        }

        function setupEventListeners_extendedfile(questionId) {
            $("body").on("change", `#multiSelectFileType_${questionId}`, function () {
                const types = $(this).data("kendoMultiSelect").value();
                $.ajax({
                    url: "/api/allowFileformatsbyquestion/getUpdates",
                    data: { types, questionId },
                    type: "post",
                    success: function (data) {
                        updateFileFormatsSelect_extendedfile(questionId, data);
                    }
                });
            });

            $("body").on("change", `#multiSelectFileFormats_${questionId}`, function () {
                const selectedFormats = $(this).data("kendoMultiSelect").value();
                if (selectedFormats.length !== 0) {
                    saveProperty_extendedfile({
                        Id: questionId,
                        ItemType: "extended_question",
                        PropertyName: "FileExtensions",
                        Value: selectedFormats.join(", "),
                        __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                        questionnaireId: options.QuestionnaireId
                    });
                } else {
                    Notification.ShowError(i18n.errorMessage_inputFileExtensions);
                }
            });
        }

        function updateFileFormatsSelect_extendedfile(questionId, data) {
            const formatsMultiSelect = $(`#multiSelectFileFormats_${questionId}`).data("kendoMultiSelect");
            formatsMultiSelect.setDataSource(new kendo.data.DataSource({ data }));
            if (formatsMultiSelect.value().length === 0) {
                formatsMultiSelect.value(data[0]);
            }
            saveProperty_extendedfile({
                Id: questionId,
                ItemType: "extended_question",
                PropertyName: "FileExtensions",
                Value: formatsMultiSelect.value().join(", "),
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            });
        }

        function saveProperty_extendedfile(data) {
            Delay(SaveProperty, data, 300);
        }
    }

    function addExtendedOptions(where, data) {
        const answerOptionContainer = $(`<div class="extended_option_container" data-extendedansweroption="${data.Id}">`);
        const optionTemplate = $("#extended_option_template").html();
        answerOptionContainer.append(optionTemplate);

        answerOptionContainer.find(".item_container").attr("data-itemid", data.Id);
        answerOptionContainer.find('input[name="Text"]').val(data.Text);
        answerOptionContainer.find('.badge-option-order').html(data.OrderId);
        answerOptionContainer.find('.remove_extended_option_form input[name="ExtendedOptionId"]').val(data.Id);

        where.append(answerOptionContainer);

        showHideExtendedAdditionalButton();
        handleTextHelperBtnClick();
    }

    function makeExtendedAnswerOptionsSortable(container) {
        //сделать возможность сортировки вопросов в таблице
        container.sortable({
            handle: "div.option-handle",
            placeholder: "extended_placeholder",
            axis: "y",
            update: function (event, ui) {
                var that = $(this);
                saveExtendedAnswerOptionsSort(that);
            }
        });
    }

    function makeChildQuestionsSortable(container) {
        container.sortable({
            handle: "div.handle",
            placeholder: "extended_placeholder",
            axis: "y",
            update: function (event, ui) {
                saveExtendedQuestionsSort($(this));
            }
        });
    }

    function changeOptionsVisibleOrder(data) {
        data.forEach(option => {
            const selector = `.option_wrapper[data-itemId='${option.Id}'], .option_wrapper[data-extendedquestionid='${option.Id}']`;
            const badgeSpan = $(selector).find('.badge-order');

            if (badgeSpan.length) {
                badgeSpan.val(option.OrderId).text(option.OrderId);
            }
        });
    }

    function saveMatrixExtendedQuestionsSort(that) {

        const sortData = Array.from(that[0].childNodes)
            .map((item, index) => `${$(item).data("extendedquestionid")}=${index + 1}`)
            .join(";");

        if (sortData) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/saveextendedquestionssort",
                method: "POST",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    sort: sortData
                },
                error: function (data) {
                    console.error("Error saving extended question sort:", data);
                    defaultErrorHandler(data);
                },
                success: function () {
                    Array.from(that[0].childNodes).forEach((item, index) => {
                        $(item).find(".badge-order").text(index + 1);
                    });
                }
            });
        }

    }

    function saveExtendedQuestionsSort(that) {

        const sortData = Array.from(that[0].childNodes)
            .map((item, index) => `${$(item).data("extendedquestionid")}=${index + 1}`)
            .join(";");

        if (sortData) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/saveextendedquestionssort",
                method: "POST",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    sort: sortData
                },
                error: function (data) {
                    console.error("Error saving extended question sort:", data);
                },
                success: function () {
                    Array.from(that[0].childNodes).forEach((item, index) => {
                        $(item).find(".badge-order").text(index + 1);
                    });
                }
            });
        }

    }

    function saveExtendedAnswerOptionsSort(that) {

        const sortData = Array.from(that[0].childNodes)
            .map((item, index) => `${$(item).data("extendedansweroption")}=${index + 1}`)
            .join(";");

        if (sortData) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/saveextendedansweroptionssort",
                method: "POST",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    sort: sortData
                },
                error: function (data) {
                    console.error("Error saving extended answer options sort:", data);
                },
                success: function () {
                    Array.from(that[0].childNodes).forEach((item, index) => {
                        $(item).find(".badge-option-order").text(index + 1);
                    });
                }
            });
        }

    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    function showLogicWithOptionsDialog(questionId, data) {
        const append = $($("#logic_template").html());

        renderThen(append, questionId, data);

        const select_answeroptions = append.find("#select_answeroptions");
        const notselect_answeroptions = append.find("#notselect_answeroptions");

        data.answerOptions.forEach(option => {
            const optionHtml = `<option value="${option.Id}">${option.OrderId}${getLogicOptionText(option.Text)}</option>`;
            select_answeroptions.append(optionHtml);
            notselect_answeroptions.append(optionHtml);
        });

        select_answeroptions.prop("disabled", true);
        notselect_answeroptions.prop("disabled", true);
        append.find("#questionstojump").prop("disabled", true);

        append.find('input[type="radio"][name="when"]').first().prop("checked", true);
        append.find('input[type="radio"][name="then"]').first().prop("checked", true);

        $("body").append(append);
    }

    function showLogicWithOptionsMatrix(questionId, data) {
        const append = $($("#matrix_logic_template").html());

        renderThen(append, questionId, data);

        const select_answeroptions = append.find("#select_answeroptions");
        const questions = append.find("#innerquestions");
        const notselect_answeroptions = append.find("#notselect_answeroptions");

        data.answerOptions.forEach(option => {
            const optionHtml = `<option value="${option.Id}">${option.OrderId}${getLogicOptionText(option.Text)}</option>`;
            select_answeroptions.append(optionHtml);
            notselect_answeroptions.append(optionHtml);
        });

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getmatrixdata",
            type: "GET",
            data: { questionId },
            success: function (response) {
                response.ExtendedQuestions.forEach(question => {
                    questions.append(`<option value="${question.Id}">${question.OrderId}${getLogicOptionText(question.Text)}</option>`);
                });
            }
        });

        append.find('input[type="radio"][name="when"]').first().prop("checked", true);
        append.find('input[type="radio"][name="then"]').first().prop("checked", true);
        append.find("#questionstojump").prop("disabled", true);

        notselect_answeroptions.prop("disabled", true);

        $("body").append(append);
    }

    function showLogicDialog(questionId, data, logicType) {
        const templateId = `#logic_${logicType}_template`;
        const append = $($(templateId).html());

        renderThen(append, questionId, data);

        append.find('input[type="radio"][name="when"]').first().prop("checked", true);
        append.find('input[type="radio"][name="then"]').first().prop("checked", true);
        append.find("#questionstojump").prop("disabled", true);

        $("body").append(append);
    }

    function showLogicStringDialog(questionId, data) {
        showLogicDialog(questionId, data, "string");
    }

    function showLogicNumberDialog(questionId, data) {
        showLogicDialog(questionId, data, "number");
    }

    function showLogicDateDialog(questionId, data) {
        showLogicDialog(questionId, data, "date");
    }

    function showLogicNoOptionsDialog(questionId, data) {
        showLogicDialog(questionId, data, "no_options");
    }

    function DateRenderAppropriateLogicButton(type, questionId) {
        const button = $('<button>', {
            class: 'btn btn-falcon-primary btn-sm',
            id: 'add_logic_changable_button',
            html: '<span class="fas fa-plus-circle mr-1"></span>' + i18n.button_AddLogic
        });

        const dateTypes = ['date', 'dateandtime', 'notLess', 'notMore', 'time'];
        if (dateTypes.includes(type)) {
            button.addClass('add_logic_date');
        }

        button.attr('data-questionid', questionId);

        $('#add_logic_changable_button').replaceWith(button);
    }

    function renderAppropriateLogicButton(type, questionId) {
        const button = $('<button>', {
            class: 'btn btn-falcon-primary btn-sm',
            id: 'add_logic_changable_button',
            html: '<span class="fas fa-plus-circle mr-1"></span>' + i18n.button_AddLogic
        });

        const logicTypes = {
            string: ['input', 'inputMask', 'textarea', 'email', 'url'],
            number: [
                'number', 'withoutzero', 'intwithoutzero', 'morezero', 'lesszero',
                'morezeroWithZero', 'lesszeroWithZero', 'intlesszeroWithZero', 'intlesszero',
                'numberRange', 'intRange', 'OnlyInt', 'intmorezeroWithZero', 'intmorezero',
                'numberOfThePhone', 'numberCreditCard', 'ISBN', 'ipv4', 'ipv6'
            ],
            time: ['time']
        };

        for (const [logicType, types] of Object.entries(logicTypes)) {
            if (types.includes(type)) {
                button.addClass(`add_logic_${logicType}`);
                break;
            }
        }

        button.attr('data-questionid', questionId);
        $('#add_logic_changable_button').replaceWith(button);
    }

    function addLogic(button, questionId, logics) {
        button.attr("data-questionid", questionId);
        var logicContainer = $(".logics");

        for (var i = 0; i < logics.length; i++) {
            logicContainer.append('<div><a data-logicid="' + logics[i].Id + '"><span class="remove_logic fas fa-times constructor__remove-icon" title="' + i18n.tooltip_remove_logic + '"></span></a><span>' + logics[i].Text + '</span></div>');
        }


        handleTextHelperBtnClick();
    }

    function getLogicOptionText(text) {
        if (!text) return "";
        var cleanText = textizeHTML(text, 50);
        if (!cleanText) cleanText = text;
        return " - " + cleanText;
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    function addFile(container, id, type, name, path) {
        container.append('<div class="file_wrapper"><a><span class="fas fa-times remove_file mr-2 constructor__remove-icon" data-filetype="' + type +
            '" data-fileid="' + id + '"></span></a><a class="fs--1" href="' + path + '" target="_blank">' + name + '</a></div>');
    }

    function addMatrixString(isNew, data) {
        const questionContainer = $('<div>', {
            class: 'option_wrapper',
            'data-extendedquestionid': data.Id
        });

        const template = $("#questionnaire_matrix_editor_string_template").html();
        questionContainer.append(template);

        questionContainer.find(".item_container").attr("data-itemid", data.Id);
        questionContainer.find(".extended_question_text")
            .html(data.Text)
            .attr("id", `extended_question_text_editor_${data.Id}`);
        questionContainer.find(".badge-order").html(data.OrderId);
        questionContainer.find('input[name="OptionId"]').val(data.Id);

        $(".questionnaire_additional_addbutton_matrix_string").removeClass("d-none");
        $(".questionnaire_extended_child_questions_wrapper").append(questionContainer);

        handleTextHelperBtnClick();
    }

    function addMatrixColumnShow(isNew, data) {
        const template = $("#questionnaire_matrix_editor_column_template").html();
        const $append = $(template);
        const $itemContainer = $append.find(".item_container");
        const $saveBtn = $append.find(".save_questionnaire_autocomplete_option_btn");
        const $removeForm = $append.find('.remove_option_form');
        const $textInput = $append.find('input[name="Text"]');

        $itemContainer.attr("data-itemid", data.Id);
        $saveBtn.attr("data-openoptionid", data.Id);
        $removeForm.find('input[name="OptionId"]').val(data.Id);

        if (!isNew && data.Text) {
            $textInput.val(data.Text);
        }

        $(".questionnaire_additional_addbutton_matrix_column").removeClass("d-none");
        $(".questionnaire_autocomplete_options_wrapper").append($append);

        handleTextHelperBtnClick();
    }

    function addMatrixColumn(isNew, data) {
        const template = $("#questionnaire_matrix_editor_column_template").html();
        const $append = $(template);
        const $itemContainer = $append.find(".item_container");
        const $saveBtn = $append.find(".save_questionnaire_autocomplete_option_btn");
        const $removeForm = $append.find('.remove_option_form');
        const $textInput = $append.find('input[name="Text"]');

        const id = isNew ? data : data.Id;

        $itemContainer.attr("data-itemid", id);
        $saveBtn.attr("data-openoptionid", id);
        $removeForm.find('input[name="OptionId"]').val(id);

        if (!isNew && data.Text) {
            $textInput.val(data.Text);
        }

        $(".questionnaire_additional_addbutton_matrix_column").removeClass("d-none");
        $(".questionnaire_autocomplete_options_wrapper").append($append);

        handleTextHelperBtnClick();
    }

    function addQuestionnaireSingleOption(isNew, id, text, orderId, files, weight = 0) {
        const append = $($("#questionnaire_single_option_template").html());
        const optionWrapper = append.find(".option_wrapper");
        const itemContainer = append.find(".item_container");
        const optionTextEditor = append.find(".option_text_editor");
        const weightInput = append.find('input[name="Weight"]');

        optionWrapper.attr("data-optionid", id);
        itemContainer.attr("data-itemid", id);

        append.find('input[name="AnswerOptionId"]').val(id);
        optionTextEditor.attr("id", `editor_${id}`);

        append.find(".save_questionnaire_single_option_btn").attr("data-optionid", id);
        append.find('.remove_option_form input[name="OptionId"]').val(id);
        append.find(".badge-order").html(orderId);

        if (!isNew) {
            optionTextEditor.html(text);
            weightInput.attr("value", weight);
        } else {
            weightInput.attr("value", 0);
        }

        const fileElements = append.find(".add_files.answeroption_files, .files_wrapper.answeroption_files");
        fileElements.attr("data-id", id);
        fileElements.filter(".add_files").attr("data-type", "answeroption");

        $(".questionnaire_single_options_wrapper").append(append.html());
        $(".questionnaire_additional_addbutton_table").css('display', 'inline-block');
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        handleTextHelperBtnClick();
    }

    function addQuestionnaireTableOption(isNew, id, textA, textB, orderId, files, weight = 0) {
        const append = $($("#questionnaire_table_option_template").html());
        const optionWrapper = append.find(".option_wrapper");
        const itemContainer = append.find(".item_container");
        const optionTextAEditor = append.find(".option_textA_editor");
        const optionTextBEditor = append.find(".option_textB_editor");
        const weightInput = append.find("input[name='Weight']");

        optionWrapper.attr("data-optionid", id);
        itemContainer.attr({
            "data-itemid": id,
            "data-itemtype": "answeroption"
        });

        append.find('input[name="AnswerOptionId"]').val(id);
        optionTextAEditor.attr("id", `editorA_${id}`);
        optionTextBEditor.attr("id", `editorB_${id}`);

        append.find(".save_questionnaire_table_option_btn").attr("data-optionid", id);
        append.find('.remove_option_form input[name="OptionId"]').val(id);
        append.find(".badge-order").html(orderId);

        if (!isNew) {
            optionTextAEditor.html(textA);
            optionTextBEditor.html(textB);
            weightInput.attr("value", weight);
        } else {
            weightInput.attr("value", 0);
        }

        const fileElements = append.find(".add_files.answeroption_files, .files_wrapper.answeroption_files");
        fileElements.attr("data-id", id);
        fileElements.filter(".add_files").attr("data-type", "answeroption");

        $(".questionnaire_table_options_wrapper").append(append.html());
        $(".questionnaire_additional_addbutton_table").css('display', 'inline-block');
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        handleTextHelperBtnClick();
    }

    function addQuestionnaireDropdownOption(isNew, id, text, orderId, weight = 0) {
        const append = $($("#questionnaire_dropdown_option_template").html());
        const optionWrapper = append.find(".option_wrapper");
        const itemContainer = append.find(".item_container");
        const textInput = append.find('input[name="Text"]');
        const weightInput = append.find("input[name='Weight']");

        optionWrapper.attr("data-optionid", id);
        itemContainer.attr("data-itemid", id);

        append.find('input[name="AnswerOptionId"]').val(id);
        append.find(".save_questionnaire_dropdown_option_btn").attr("data-optionid", id);
        append.find('.remove_option_form input[name="OptionId"]').val(id);
        append.find(".badge-order").html(orderId);

        if (!isNew) {
            textInput.attr("value", text);
            weightInput.attr('value', weight);
        } else {
            weightInput.attr('value', 0);
        }

        $(".questionnaire_dropdown_options_wrapper").append(append.html());
        $(".questionnaire_additional_addbutton_table").css('display', 'inline-block');

        inputValid(id);
        handleTextHelperBtnClick();
    }

    function addQuestionnaireMultyOption(isNew, id, text, orderId, files, weight = 0) {
        const template = $("#questionnaire_multy_option_template").html();
        const $append = $(template);

        $append.find(".option_wrapper").attr("data-optionid", id);
        $append.find(".item_container").attr("data-itemid", id);
        $append.find('input[name="AnswerOptionId"]').val(id);
        $append.find("input[name='Text']").attr("id", `editor_${id}`);
        $append.find(".save_questionnaire_multy_option_btn").attr("data-optionid", id);
        $append.find('.remove_option_form input[name="OptionId"]').val(id);
        $append.find(".badge-order").html(orderId);

        $append.find(".add_files.answeroption_files, .files_wrapper.answeroption_files")
            .attr("data-id", id)
            .filter(".add_files")
            .attr("data-type", "answeroption");

        $append.find("input[name='Weight']").attr("value", isNew ? 0 : weight);

        $(".questionnaire_multy_options_wrapper").append($append.html());
        $(".questionnaire_additional_addbutton_multy").css('display', 'inline-block');

        if (text != null) {
            $(`#editor_${id}`).val(text);
        }

        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);
        handleTextHelperBtnClick();
    }

    function addQuestionnaireAutocompleteOption(isNew, id, text, weight = 0) {
        const template = $("#questionnaire_autocomplete_option_template").html();
        const $option = $(template);

        $option.find(".item_container").attr("data-itemid", id);
        $option.find(".save_questionnaire_autocomplete_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);

        if (!isNew) {
            $option.find('input[name="Text"]').val(text);
            $option.find('input[name="Weight"]').val(weight);
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        inputValid(id);

        $(".questionnaire_autocomplete_options_wrapper").append($option);
        $(".questionnaire_additional_addbutton_autocomplete").show();
        handleTextHelperBtnClick();
    }

    function addTestSingleOption(isNew, id, text, isTrue, orderId, message, files, weight) {
        const $template = $("#test_single_option_template");
        const $option = $($template.html());

        $option.find(".option_wrapper").attr("data-optionid", id);
        $option.find(".item_container").attr("data-itemid", id);
        $option.find('input[name="AnswerOptionId"]').val(id);
        $option.find(".option_text_editor").attr("id", `editor_${id}`);
        $option.find(".save_test_single_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find(".option_text_editor").html(text);
            $option.find('input[name="IsTrueAnswer"]').prop("checked", isTrue);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
            $option.find('input[name="Weight"]').val(weight);
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $option.find(".add_files.answeroption_files, .files_wrapper.answeroption_files")
            .attr("data-id", id)
            .filter(".add_files")
            .attr("data-type", "answeroption");

        $(".test_single_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        handleTextHelperBtnClick();
    }

    function addTestSingleUndefinedOption(isNew, id, text, isTrue, orderId, message, files, weight) {
        const $template = $("#test_single_undefined_option_template");
        const $option = $($template.html());

        $option.find(".option_wrapper").attr("data-optionid", id);
        $option.find(".item_container").attr("data-itemid", id);
        $option.find('input[name="AnswerOptionId"]').val(id);
        $option.find(".option_text_editor").attr("id", `editor_${id}`);
        $option.find(".save_test_single_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find(".option_text_editor").html(text);
            $option.find('input[name="IsTrueAnswer"]').prop("checked", isTrue);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
            $option.find('input[name="Weight"]').val(weight);
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $option.find(".add_files.answeroption_files, .files_wrapper.answeroption_files")
            .attr("data-id", id)
            .filter(".add_files")
            .attr("data-type", "answeroption");

        $(".test_single_undefined_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        $("[data-toggle='tooltip']").tooltip();
        handleTextHelperBtnClick();
    }

    function addTestTableOption(isNew, id, textA, textB, weight, orderId, message, files, wrongmessage) {
        const $option = $($("#test_table_option_template").html());
        const $optionWrapper = $option.find(".option_wrapper");
        const $itemContainer = $option.find(".item_container");

        $optionWrapper.attr("data-optionid", id);
        $itemContainer.attr("data-itemid", id);

        $option.find(".option_textA_editor").attr("id", `editorA_${id}`);
        $option.find(".option_textB_editor").attr("id", `editorB_${id}`);
        $option.find(".save_test_table_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn, .option_wrong_table_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find(".option_textA_editor").html(textA);
            $option.find(".option_textB_editor").html(textB);
            $option.find('input[name="Weight"]').val(weight);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
            $option.find('.option_wrong_table_message_full').html(wrongmessage);
            $option.find('.option_wrong_table_message_short').html(textize(wrongmessage));
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $option.find(".add_files.answeroption_files")
            .attr({
                "data-id": id,
                "data-type": "answeroption"
            });
        $option.find(".files_wrapper.answeroption_files").attr("data-id", id);

        $(".test_table_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        $("[data-toggle='tooltip']").tooltip();
        handleTextHelperBtnClick();
    }

    function addTestMultyOption(isNew, id, text, isTrue, weight, orderId, message, files) {
        const $option = $($("#test_multy_option_template").html());
        const $optionWrapper = $option.find(".option_wrapper");
        const $itemContainer = $option.find(".item_container");

        $optionWrapper.attr("data-optionid", id);
        $itemContainer.attr("data-itemid", id);

        $option.find('input[name="AnswerOptionId"]').val(id);
        $option.find(".option_text_editor").attr("id", `editor_${id}`);
        $option.find(".save_test_multy_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find(".option_text_editor").html(text);
            $option.find('input[name="IsTrueAnswer"]').prop("checked", isTrue);
            $option.find('input[name="Weight"]').val(weight);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $option.find(".add_files.answeroption_files")
            .attr({
                "data-id": id,
                "data-type": "answeroption"
            });
        $option.find(".files_wrapper.answeroption_files").attr("data-id", id);

        $(".test_multy_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        $("[data-toggle='tooltip']").tooltip();
        handleTextHelperBtnClick();
    }

    function addTestMultyUndefinedOption(isNew, id, text, isTrue, weight, orderId, message, files) {
        const $option = $($("#test_multy_undefined_option_template").html());
        const $itemContainer = $option.find(".item_container");
        const $optionWrapper = $option.find(".option_wrapper");

        $itemContainer.attr("data-itemid", id);
        $optionWrapper.attr("data-optionid", id);

        $option.find('input[name="AnswerOptionId"]').val(id);
        $option.find(".option_text_editor").attr("id", `editor_${id}`);
        $option.find(".save_test_multy_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find(".option_text_editor").html(text);
            $option.find('input[name="IsTrueAnswer"]').prop("checked", isTrue);
            $option.find('input[name="Weight"]').val(weight);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $option.find(".add_files.answeroption_files")
            .attr({
                "data-id": id,
                "data-type": "answeroption"
            });
        $option.find(".files_wrapper.answeroption_files").attr("data-id", id);

        $(".test_multy_undefined_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();
        loadFiles($(`.files_wrapper[data-id="${id}"]`), files);

        $("[data-toggle='tooltip']").tooltip();
        handleTextHelperBtnClick();
    }

    function addTestOpenOption(isNew, id, text, weight, message, orderId) {
        const $option = $($("#test_open_option_template").html());
        const $itemContainer = $option.find(".item_container");
        const $optionWrapper = $option.find(".option_wrapper");

        $optionWrapper.attr("data-optionid", id);
        $itemContainer.attr("data-itemid", id);

        $option.find(".save_test_open_option_btn").attr("data-openoptionid", id);
        $option.find('.remove_option_form input[name="OptionId"]').val(id);
        $option.find(".badge-order").html(orderId);
        $option.find(".option_message_btn").attr("data-optionid", id);

        if (!isNew) {
            $option.find('input[name="Text"]').val(text);
            $option.find('input[name="Weight"]').val(weight);
            $option.find('.option_message_full').html(message);
            $option.find('.option_message_short').html(textize(message));
        } else {
            $option.find('input[name="Weight"]').val(0);
        }

        $(".test_open_options_wrapper").append($option);
        $(".test_additional_addbutton_single").show();

        $("[data-toggle='tooltip']").tooltip();
        handleTextHelperBtnClick();
    }


    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $('.questions-types__item').each(function () {
        $(this).hover(function () {
            $(this).find('.questions-types__popover').addClass('questions-types__popover--visible');
        }, function () {
            $(this).find('.questions-types__popover').removeClass('questions-types__popover--visible');
        });

        $('.ui-draggable-dragging').find('.questions-types__popover').removeClass('questions-types__popover--visible');
    });

    $(".question_option").draggable({
        revert: "invalid",
        helper: "clone",
        connectToSortable: "#questions",
        containment: ".content",
        scroll: false,
    });

    $("<ul>").attr("id", "questions").appendTo("#questions-containment");

    $("#questions").sortable({
        placeholder: "question_placeholder",
        handle: "div.handle",
        tolerance: "intersect",
        containment: "#questions-containment",
        scroll: false,
        axis: "y",
        change: function (e, ui) {

        },
        sort: function (event, ui) {

            $(ui.item).css("opacity", "0.85");
            ui.placeholder.height(ui.helper.outerHeight());

            var h = ui.helper.outerHeight(true),
                elem = $("#page_content"),
                elemHeight = elem.height(),
                moveBy = $("#page_content .question_wrapper").outerHeight(true) * 3,
                mouseCoordsY = event.pageY - elem.offset().top;

            var $target = $(event.target);
            if (!/html|body/i.test($target.offsetParent()[0].tagName)) {
                var top = event.pageY - $target.offsetParent().offset().top - (ui.helper.outerHeight(true) / 2);
                ui.helper.css({ 'top': top + 'px' });
            }

        },
        start: function (event, ui) {

        },
        //////////////////////////////////////////////////////////////////
        //create question by drag'n'drop
        //////////////////////////////////////////////////////////////////
        stop: function (event, ui) {
            $(ui.item).css("opacity", "1");
            if (ui.item.hasClass("question_option")) {
                Preloader.EnableLoader("#page_content");

                var text = $(ui.item).data("questiontype"); //ui.item.context
                var that = $(this);

                $(ui.item).addClass("tmp");

                sendAjaxWithQuestionnaireId({
                    url: "/api/constructor/createquestion",
                    method: "POST",
                    data: {
                        type: text,
                        questionnaireId: options.QuestionnaireId, //"@Model.Id",
                        page: options.Page //"@Model.Page"
                    },
                    success: function (data) {
                        ui.item.replaceWith(createQuestion(true, "", text, data));
                        $('.question_wrapper[data-questionid="' + data + '"] .edit_button').trigger("click");
                        saveSort(that);
                        toggleDropzone();

                        $(".js-number-input").keypress(function (e) {
                            preventNonNumericalInput(e);
                        });
                    },
                    error: function (data) {
                        $(".tmp").remove();
                        Preloader.DisableLoader("#page_content");
                        if (data.responseText === "available_in_older_versions") {
                            Notification.ShowError(i18n.errorMessage_available_in_older_versions);
                            return;
                        }
                        if (data.responseText === "cannot_add_question_to_page") {
                            Notification.ShowError(i18n.errorMessage_cannotAddQuestionToPage);
                            return;
                        }
                        if (data.responseText === "no_dadata_settings") {
                            Notification.ShowError(i18n.errorMessage_no_dadata_settings);
                            return;
                        }
                        defaultErrorHandler(data);
                    }
                });
            };
        },
        update: function (event, ui) {
            if (!ui.item.hasClass("question_option")) {
                Preloader.EnableLoader("#page_content");

                var cancelSorting = function () {
                    return $("#questions").sortable("cancel");
                };

                var that = $(this);
                saveSort(that, cancelSorting);
            }
        }
    }).disableSelection();

    $("#page_content .dropdown-menu, #props_content .dropdown-menu").parent().on("show.bs.dropdown", function (event) {
        setOverflow($(this), "visible");

    });

    $("#page_content .dropdown-menu, #props_content .dropdown-menu").parent().on("hide.bs.dropdown", function (event) {
        setOverflow($(this), "hidden");
    });

    $(".constructor__pages-list").sortable({
        placeholder: "page_placeholder",
        stop: function (event, ui) {
            var that = $(this);
            var oldIndex = $(ui.item).find("a").html();
            var newIndex = ui.item.index() + 1;

            if (oldIndex != newIndex) {
                sendAjaxWithQuestionnaireId({
                    url: "/api/constructor/movepage",
                    type: "post",
                    data: {
                        questionnaireId: options.QuestionnaireId, //"@Model.Id",
                        oldIndex: oldIndex,
                        newIndex: newIndex
                    },
                    error: function (data) {
                        if (data.responseText == "logic_restriction") {
                            Notification.ShowError(i18n.alert_PageMoveLogicRestrict);
                            $(".constructor__pages-list").sortable("cancel");
                            return;
                        }
                        defaultErrorHandler(data);
                        $(".constructor__pages-list").sortable("cancel");
                    },
                    success: function (data) {
                        window.location = data //"@Url.Action("Constructor", new { questionnaireId = Model.Id, pageId =Model.Page})";

                    }
                });
            }
        }
    })

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $("body").on("submit", ".remove_page", function (e) {
        const form = $(this);

        Confirmation.IfConfirmed({
            message: i18n.confirm_AreYouSure
        }, function () {
            sendAjaxWithQuestionnaireId({
                url: form.attr("action"),
                method: "post",
                data: form.serialize(),
                success: function (data) {
                    window.location = data;
                },
                error: function (response) {
                    const errorMessages = {
                        "logic_restriction": i18n.alert_PageRemoveLogicRestrict,
                        "inactive": i18n.errorMessage_cannotRemovePageInactive,
                        "non_draft": i18n.errorMessage_editRestricted
                    };

                    const errorMessage = errorMessages[response.responseText];
                    if (errorMessage) {
                        Notification.ShowError(errorMessage);
                    } else {
                        defaultErrorHandler(response);
                    }
                }
            });
        });

        return false;
    })

    $("body").on("submit", ".remove_option_form", function (e) {
        e.preventDefault();

        const form = $(this);
        const wrapper = $("div[class$='_options_wrapper ui-sortable']");
        const data = form.serialize() + "&questionnaireId=" + options.QuestionnaireId;

        const removeOption = () => {
            sendAjaxWithQuestionnaireId({
                method: "post",
                url: form.attr('action'),
                data: data,
                error: function (data, message, xhr) {
                    if (xhr.responseText === "logic_restriction") {
                        Notification.ShowError(i18n.alert_AnswerOptionRemoveLogicRestrict);
                        return;
                    }
                    defaultErrorHandler(data);
                },
                success: function (data) {
                    const $itemContainer = $(".item_container");
                    const $optionsWrapper = $(".js-options_wrapper");
                    const $extendedChildQuestionsWrapper = $(".questionnaire_extended_child_questions_wrapper");
                    const $autocompleteOptionsWrapper = $(".questionnaire_autocomplete_options_wrapper");

                    form.closest(".option_wrapper").remove();
                    saveOptionSort(wrapper);
                    changeOptionsVisibleOrder(data);

                    const updateCheckedCount = (propertyName) => {
                        const count = +$itemContainer.find(`input[name="${propertyName}"]`).val();
                        const optionsCount = $(".questionnaire_multy_options_wrapper .option_wrapper").length;

                        if (count >= optionsCount) {
                            $(`#${propertyName}`).val(optionsCount);
                            SaveProperty({
                                Id: $itemContainer.find('input[name=QuestionId]').val(),
                                ItemType: "question",
                                PropertyName: propertyName,
                                Value: optionsCount,
                                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                                questionnaireId: options.QuestionnaireId
                            });
                        }
                    };

                    updateCheckedCount("MinCheckedCount");
                    updateCheckedCount("MaxCheckedCount");

                    const hideButtonIfNoOptions = ($wrapper, $button) => {
                        if ($wrapper.find(".option_wrapper").length === 0) {
                            $button.addClass("d-none");
                        }
                    };

                    hideButtonIfNoOptions($optionsWrapper, $(".js-additional-addbutton"));
                    hideButtonIfNoOptions($extendedChildQuestionsWrapper, $(".questionnaire_additional_addbutton_matrix_string"));
                    hideButtonIfNoOptions($autocompleteOptionsWrapper, $(".questionnaire_additional_addbutton_matrix_column"));

                    updateQuestionValidationState($itemContainer.data("itemid"));
                },
            });
        };

        Confirmation.IfConfirmed({ message: i18n.confirm_AreYouSure }, removeOption);
    });

    $("body").on("submit", ".remove_extended_question_form, .remove_matrixstring_question_form, .remove_extended_option_form", function (e) {
        e.preventDefault();

        const $this = $(this);
        const container = $this.closest('.extended_question_container, .option_wrapper, .extended_option_container');
        const questionnaireId = options.QuestionnaireId;
        const formData = $this.serialize() + `&questionnaireId=${questionnaireId}`;
        const url = $this.attr('action');

        const removeItem = () => {
            sendAjaxWithQuestionnaireId({
                method: "post",
                url: url,
                data: formData,
                error: defaultErrorHandler,
                success: () => {
                    container.remove();

                    if ($this.hasClass('remove_extended_question_form') || $this.hasClass('remove_matrixstring_question_form')) {
                        saveExtendedQuestionsSort($(".questionnaire_extended_child_questions_wrapper"));
                    } else if ($this.hasClass('remove_extended_option_form')) {
                        saveExtendedAnswerOptionsSort($this.closest('.extended_options_wrapper'));
                        showHideExtendedAdditionalButton();
                    }

                    const questionId = $(".item_container").data("itemid");
                    updateQuestionValidationState(questionId);
                },
            });
        };

        Confirmation.IfConfirmed({
            message: i18n.confirm_AreYouSure
        }, removeItem);

        return false;
    });

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $("body").on("dblclick", ".question_option, .child_question_option", function (e) {
        const $this = $(this);
        const type = $this.data("questiontype");
        const isChildQuestion = $this.hasClass("child_question_option");

        const data = {
            type: type,
            questionnaireId: options.QuestionnaireId
        };

        if (isChildQuestion) {
            data.parentQuestionId = $this.data("questionid");
        } else {
            data.page = options.Page;
        }

        const url = isChildQuestion ? "/api/constructor/createextendedquestion" : "/api/constructor/createquestion";

        Preloader.EnableLoader("#page_content");

        sendAjaxWithQuestionnaireId({
            url: url,
            method: "POST",
            data: data,
            success: function (response) {
                if (isChildQuestion) {
                    handleChildQuestionCreation(type, response);
                } else {
                    handleMainQuestionCreation(type, response);
                }
            },
            error: function (error) {
                Preloader.DisableLoader("#page_content");
                handleError(error, isChildQuestion);
            }
        });
    });

    function handleMainQuestionCreation(type, data) {
        $("#questions").append(createQuestion(true, "", type, data));
        $(`.question_wrapper[data-questionid="${data}"] .edit_button`).trigger("click");
        saveSort($("#questions"));
        toggleDropzone();

        $(".js-number-input").keypress(function (e) {
            preventNonNumericalInput(e);
        });
    }

    function handleChildQuestionCreation(type, data) {
        const addFunctions = {
            "extended_dropdown": addExtendedDropdownMulty,
            "extended_multy": addExtendedDropdownMulty,
            "extended_input": addExtendedInput,
            "extended_file": addExtendedFile
        };

        if (addFunctions[type]) {
            addFunctions[type](data);
        }

        saveExtendedQuestionsSort($(".questionnaire_extended_child_questions_wrapper"));
        $("[data-toggle='tooltip']").tooltip();
        $("#extended_options_content1").css("display", "block");
        updateQuestionValidationState(data.ParentQuestionId);
        Preloader.DisableLoader("#page_content");

    }

    function handleError(error, isChildQuestion) {
        if (error.responseText === "available_in_older_versions") {
            Notification.ShowError(i18n.errorMessage_available_in_older_versions);
        } else if (error.responseText === "no_dadata_settings") {
            Notification.ShowError(i18n.errorMessage_no_dadata_settings);
        } else if (!isChildQuestion && error.responseText === "cannot_add_question_to_page") {
            Notification.ShowError(i18n.errorMessage_cannotAddQuestionToPage);
        } else {
            defaultErrorHandler(error);
        }
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    $("#close-properties").on("click", function () {
        const $propsContent = $("#props_content");
        $propsContent.removeClass("visible").addClass("invisible");
        $propsContent.find(".constructor__editor-inner").removeClass("constructor__editor-inner--spreadsheet");
        rerenderQuestions();
    });

    /*matrix*/
    $("body").on("click", ".add_matrix_column_multiline", function (e) {
        e.preventDefault();
        $("#matrixcolumn_multiline_options").remove();
        const $template = $("#add_matrix_column_multiline_template");
        const $append = $($template.html());
        const questionId = $(this).data("questionid");

        $append.find("#add_matrix_column_multiline_options").attr("data-questionid", questionId);
        $("body").append($append);

        $("#matrixcolumn_multiline_options").kendoWindow({
            modal: true,
            pinned: true,
            width: 500,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", "#add_matrix_column_multiline_options", function (e) {
        e.preventDefault();
        const $matrixColumnOptions = $("#matrixcolumn_multiline_options");
        const textOptions = $("#matrixcolumn_multiline_options_textarea").val();
        const questionId = $(this).data("questionid");

        const showProgress = (show) => kendo.ui.progress($matrixColumnOptions, show);
        const closeWindow = () => $matrixColumnOptions.data("kendoWindow").close();

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/adddropdownmultilineoptions",
            type: "post",
            data: {
                questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: () => {
                closeWindow();
                showProgress(false);
            },
            success: (data) => {
                data.forEach(item => {
                    addMatrixColumn(false, {
                        Id: item.Id,
                        Text: item.Text,
                        OrderId: item.OrderId
                    });
                });
                closeWindow();
                showProgress(false);
            }
        });

    });

    $("body").on("click", ".add_matrix_string_multiline", function (e) {
        e.preventDefault();
        $("#matrixcolumn_multiline_options").remove();
        const questionId = $(this).data("questionid");
        const $template = $($("#add_matrix_string_multiline_template").html());

        $template.find("#add_matrix_string_multiline_options").attr("data-questionid", questionId);
        $("body").append($template);

        $("#matrixcolumn_multiline_options").kendoWindow({
            modal: true,
            pinned: true,
            width: 500,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", "#add_matrix_string_multiline_options", function (e) {
        e.preventDefault();
        const textOptions = $("#matrixcolumn_multiline_options_textarea").val();
        const questionId = $(this).data("questionid");
        const $matrixColumnOptions = $("#matrixcolumn_multiline_options");

        const showProgress = (show) => kendo.ui.progress($matrixColumnOptions, show);
        const closeWindow = () => $matrixColumnOptions.data("kendoWindow").close();

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/addmatrixstringmultyline",
            type: "post",
            data: {
                questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: () => {
                closeWindow();
                showProgress(false);
            },
            success: (data) => {
                data.forEach(item => {
                    addMatrixString(false, {
                        Id: item.Id,
                        Text: item.Text,
                        OrderId: item.OrderId
                    });
                });
                closeWindow();
                showProgress(false);
            }
        });

    });
    /*end matrix*/

    $("body").on("click", ".copy_button:not(.disabled)", function (e) {

        Preloader.EnableLoader("#page_content");
        var questionId = $(this).closest(".question_wrapper").data("questionid");
        var button = $(this);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/copyquestion",
            method: "POST",
            data: {
                questionnaireId: options.QuestionnaireId, //"@Model.Id",
                questionId: questionId
            },
            success: function (data) {
                createQuestion(false, data.Title, data.Type, data.Id, data.OrderId, data.IsRequired, data.HasLogic, data.ManualExpertise, data.IsValid);
                Preloader.DisableLoader("#page_content");
            },
            error: function () {
                Preloader.DisableLoader("#page_content");
                Notification.ShowError(i18n.alert_CopyQuestionnaire);
                return;
            }
        });

    })

    $("body").on("click", ".question_move_to_page_btn", function (e) {
        e.preventDefault();
        Preloader.EnableLoader("#page_content");

        const $dropdown = $(this).closest(".dropdown-menu");
        const $questionWrapper = $(this).closest(".question_wrapper");
        const questionId = $questionWrapper.data("questionid");
        const pageToMoveTo = $dropdown.find("input").val();

        const moveQuestion = () => {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/movequestiontopage",
                method: "POST",
                data: { questionId, pageToMoveTo, questionnaireId: options.QuestionnaireId },
                success: handleMoveSuccess,
                error: handleMoveError
            });
        };

        const handleMoveSuccess = (data) => {
            if (pageToMoveTo < (+options.Page)) options.MaxOrderId++;
            $("#questions").empty();
            loadQuestions();
            toggleDropzone();
        };

        const handleMoveError = (data) => {
            Preloader.DisableLoader("#page_content");

            if (pageToMoveTo === (+options.Page)) {
                Notification.ShowError(i18n.errorMessage_cannotAddQuestionToPage);
            } else if (data.responseText === "logic_restriction") {
                Notification.ShowError(i18n.alert_QuestionMoveLogicRestrict);
            } else if (data.responseText === "cannot_add_question_to_page") {
                Notification.ShowError(i18n.errorMessage_cannotAddQuestionToPage);
            } else {
                defaultErrorHandler(data);
            }
        };

        moveQuestion();
    })

    $("body").on("click", ".remove_button", function (e) {
        const $questionWrapper = $(this).closest(".question_wrapper");
        const questionId = $questionWrapper.data("questionid");

        const handleConfirmation = () => {
            Preloader.EnableLoader("#page_content");
            deleteQuestion(questionId);
        };

        const deleteQuestion = (id) => {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/deletequestion",
                method: "POST",
                data: {
                    questionnaireId: options.QuestionnaireId,
                    questionId: id
                },
                success: handleDeleteSuccess,
                error: handleDeleteError
            });
        };

        const handleDeleteSuccess = () => {
            $questionWrapper.remove();
            saveSort($("#questions").sortable());
            updatePropertiesPanel(questionId);
            Preloader.DisableLoader("#page_content");
            toggleDropzone();
        };

        const updatePropertiesPanel = (id) => {
            const $propsWrapper = $("#props_wrapper");
            if ($propsWrapper.find(`div[data-itemtype="question"][data-itemid="${id}"]`).length) {
                $propsWrapper.html("");
                $("#close-properties").trigger('click');
            }
        };

        const handleDeleteError = (data) => {
            $(".tmp").remove();
            Preloader.DisableLoader("#page_content");

            if (data.responseText === "logic_restriction") {
                Notification.ShowError(i18n.alert_QuestionRemoveLogicRestrict);
            } else {
                defaultErrorHandler(data);
            }
        };

        Confirmation.IfConfirmed({
            message: i18n.confirm_AreYouSure
        }, handleConfirmation);

    })

    $("body").on("click", ".js-page-move-after-page-btn", function (e) {
        const oldIndex = $(".constructor__pages-list").find("li.current-page").data("page");
        const newIndex = $(e.currentTarget).parent().find("input").val();

        if (oldIndex === +newIndex || newIndex === "") {
            if (newIndex === "") {
                Notification.ShowError(i18n.errorMessage_cannotMovePageToEmptyPage);
                return;
            }
            Notification.ShowError(i18n.errorMessage_cannotMovePageToPage);
            return;
        }

        const movePageData = {
            questionnaireId: options.QuestionnaireId,
            oldIndex: oldIndex,
            newIndex: newIndex
        };

        const handleMovePageSuccess = (data) => {
            window.location = data;
        };

        const handleMovePageError = (error) => {
            if (error.responseText === "logic_restriction") {
                Notification.ShowError(i18n.alert_PageMoveLogicRestrict);
            } else {
                defaultErrorHandler(error);
            }
            $(".constructor__pages-list").sortable("cancel");
        };

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/movepage",
            type: "post",
            data: movePageData,
            success: handleMovePageSuccess,
            error: handleMovePageError
        });
    });

    $("body").on("click", ".edit_text", function (e) {
        e.preventDefault();
        switchEditorOn($(this));
    });

    $("body").on("click", ".save_text", function (e) {
        e.preventDefault();
        switchEditorOff($(this));
    });

    $("body").on("click", ".edit_button", function (e) {
        const $questionWrapper = $(this).closest('.question_wrapper');
        const questionId = $questionWrapper.data("questionid");
        const type = $questionWrapper.data("type");

        // Reset background and destroy TinyMCE editors
        $(".question_wrapper").css("background", "white");
        $questionWrapper.css("background", "#ebf6ff");
        tinymce.editors.forEach(editor => editor.destroy());

        // Show properties content
        const $propsContent = $("#props_content");
        $propsContent.removeClass("invisible").addClass("visible").css("visibility", "visible");
        $propsContent.find(".constructor__editor-inner").removeClass("constructor__editor-inner--spreadsheet");

        // Clear and prepare properties wrapper
        $("#props_wrapper").empty();
        Preloader.EnableLoader("#props_content");

        // Function to show question based on type
        const showQuestion = {
            questionnaire_date: showQuestionnaireDateQuestion,
            questionnaire_textblock: showQuestionnaireTextblock,
            questionnaire_single: showQuestionnaireSingleQuestion,
            questionnaire_table: showQuestionnaireTableOption,
            questionnaire_multy: showQuestionnaireMultyQuestion,
            questionnaire_input: showQuestionnaireInputQuestion,
            questionnaire_dadatainput: showQuestionnaireDaDataInputQuestion,
            questionnaire_spreadsheet: showQuestionnaireSpreadsheetQuestion,
            questionnaire_dropdown: showQuestionnaireDropdownQuestion,
            questionnaire_scale: showQuestionnaireScaleQuestion,
            questionnaire_scale_two_slide: showQuestionnaireScaleQuestion,
            questionnaire_nps: showQuestionnaireNpsQuestion,
            questionnaire_rating: showQuestionnaireRatingQuestion,
            questionnaire_file: showQuestionnaireFileQuestion,
            questionnaire_autocomplete: showQuestionnaireAutocompleteQuestion,
            questionnaire_extended: showQuestionnaireExtendedQuestion,
            questionnaire_matrix: showQuestionnaireMatrixQuestion,
            test_single: showTestSingleQuestion,
            test_table: showTestTableQuestion,
            test_multy: showTestMultyQuestion,
            test_open: showTestOpenQuestion,
            test_single_undefined: showTestSingleUndefinedQuestion,
            test_multy_undefined: showTestMultyUndefinedQuestion,
            test_scale: showTestScaleQuestion
        };

        if (showQuestion[type]) {
            showQuestion[type](questionId, $questionWrapper);
        }

        // Set up scrollbar
        const htmlNode = document.querySelector("html");
        const questionEditorNode = htmlNode.querySelector("#props_content .card");
        const propsContentScrollbar = new PerfectScrollbar(questionEditorNode, { wheelSpeed: 0.3 });

        $(questionEditorNode).on("ps-scroll-y", () => $("[data-toggle='tooltip']").tooltip("hide"));
        propsContentScrollbar.update();

        // Scroll to appropriate position
        if (screen.width > 991) {
            htmlNode.scrollTop = 90;
            questionEditorNode.scrollTop = 0;
        } else {
            $(htmlNode).scrollTop($propsContent.offset().top);
        }

        // Set up dropdown menu behavior
        $("#page_content .dropdown-menu, #props_content .dropdown-menu").parent().on("show.bs.dropdown", function () {
            setOverflow($(this), "visible");
        }).on("hide.bs.dropdown", function () {
            setOverflow($(this), "hidden");
        });

        // Final touches
        handleTextHelperBtnClick();
        inputValid();
        updateQuestionValidationState(questionId);
    })

    $("body").on("click", ".add_option_matrix_string", function (e) {
        e.preventDefault();
        const type = $(this).data("questiontype");
        const parentQuestionId = $(this).data("questionid");

        const handleSuccess = (data) => {
            $("[data-toggle='tooltip']").tooltip();
            addMatrixString(true, data);
            saveMatrixExtendedQuestionsSort($(".questionnaire_extended_child_questions_wrapper"));
            const questionId = $(".item_container").data("itemid");
            updateQuestionValidationState(questionId);
        };

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/creatematrixstring",
            method: "POST",
            data: {
                parentQuestionId,
                type,
                questionnaireId: options.QuestionnaireId
            },
            success: handleSuccess,
            error: defaultErrorHandler
        });
    })

    $("body").on("click", ".add_option_matrix_column", function (e) {
        e.preventDefault();
        const type = $(this).data("questiontype");
        const questionId = $(this).data("questionid");

        const handleSuccess = (data) => {
            $("[data-toggle='tooltip']").tooltip();
            $("body").scrollTop($(`div[data-itemid="${data}"]`).offset().top);
            addMatrixColumn(true, data);
            saveOptionSort($(".questionnaire_multy_options_wrapper"));
            const itemQuestionId = $(".item_container").data("itemid");
            updateQuestionValidationState(itemQuestionId);
        };

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/creatematrixcolumn",
            method: "POST",
            data: {
                questionId,
                type,
                questionnaireId: options.QuestionnaireId
            },
            success: handleSuccess,
            error: defaultErrorHandler
        });
    })

    $("body").on("click", ".add_option", function (e) {
        e.preventDefault();
        const type = $(this).data("questiontype");
        const questionId = $(this).data("questionid");

        const handleSuccess = (data) => {
            $("[data-toggle='tooltip']").tooltip();

            const addOptionFunctions = {
                "questionnaire_textblock": addQuestionnaireSingleOption,
                "questionnaire_single": addQuestionnaireSingleOption,
                "questionnaire_table": addQuestionnaireTableOption,
                "questionnaire_multy": addQuestionnaireMultyOption,
                "questionnaire_dropdown": addQuestionnaireDropdownOption,
                "test_single": addTestSingleOption,
                "test_table": addTestTableOption,
                "test_multy": addTestMultyOption,
                "test_open": (isNew, data) => addTestOpenOption(isNew, data, "", 0),
                "questionnaire_matrix": addMatrixColumn,
                "questionnaire_autocomplete": addQuestionnaireAutocompleteOption,
                "test_single_undefined": addTestSingleUndefinedOption,
                "test_multy_undefined": addTestMultyUndefinedOption
            };

            if (addOptionFunctions[type]) {
                addOptionFunctions[type](true, data);
                const optionsWrapper = `.${type}_options_wrapper`;
                saveOptionSort($(optionsWrapper));
            }

            updateMinMaxCheckedCount();
            updateAdditionalAddButton();
            inputValid();

            const questionId = $(".item_container").data("itemid");
            updateQuestionValidationState(questionId);
        };

        const updateMinMaxCheckedCount = () => {
            const $container = $(".item_container");
            const optionsCount = $(".questionnaire_multy_options_wrapper .option_wrapper").length;
            const updateCount = (selector, value) => {
                $container.find(`input[name="${selector}"]`).val(value);
                SaveProperty({
                    Id: $container.find('input[name=QuestionId]').val(),
                    ItemType: "question",
                    PropertyName: selector,
                    Value: value,
                    __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                    questionnaireId: options.QuestionnaireId
                });
            };

            let minCheckedCount = +$container.find('input[name="MinCheckedCount"]').val();
            let maxCheckedCount = +$container.find('input[name="MaxCheckedCount"]').val();

            if (minCheckedCount >= optionsCount) {
                updateCount("MinCheckedCount", optionsCount);
            }
            if (maxCheckedCount < optionsCount) {
                updateCount("MaxCheckedCount", optionsCount);
            }
        };

        const updateAdditionalAddButton = () => {
            const indOptionsCount = $(".js-options_wrapper .option_wrapper").length;
            if (indOptionsCount !== 0) {
                $(".js-additional-addbutton").removeClass("d-none");
            }
        };

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/createoption",
            method: "POST",
            data: {
                questionId,
                type,
                questionnaireId: options.QuestionnaireId
            },
            success: handleSuccess,
            error: defaultErrorHandler
        });

    })

    $("body").on("click", '.extended_question_container .extended-input-type', function (e) {
        var container = $(this).closest('.extended_question_container');
        if ($(this).val() == "input" && $(this).is(':checked')) {
            container.find('input[name="InputMask"]').removeAttr('readonly');
        }
        else {
            container.find('input[name="InputMask"]').attr('readonly', 'readonly');
        }
    });

    $("body").on("click", ".add_extended_option", function (e) {
        const $container = $(this).closest('.extended_question_container');
        const extendedQuestionId = $container.data("extendedquestionid");
        const $optionWrapper = $container.find(".extended_options_wrapper");

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/createextendedoption",
            method: "POST",
            data: {
                extendedQuestionId,
                questionnaireId: options.QuestionnaireId,
            },
            success: (data) => {
                addExtendedOptions($optionWrapper, data);
                saveExtendedAnswerOptionsSort($optionWrapper);
            },
            error: defaultErrorHandler
        });
    });

    $("body").on("click", ".add_extended_multiline", function (e) {
        e.preventDefault();
        $("#extended_multiline_options").remove();
        const $extendedQuestionContainer = $(this).closest(".extended_question_container");
        const extendedQuestionId = $extendedQuestionContainer.data("extendedquestionid");

        const $optionsTemplate = $("#extended_multiline_options_template");
        const $optionsContent = $($optionsTemplate.html());

        $optionsContent.find("#add_extended_multiline_options").attr("data-extendedquestionid", extendedQuestionId);
        $("body").append($optionsContent);

        $("#extended_multiline_options").kendoWindow({
            modal: true,
            width: 500,
            pinned: true,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", "#add_extended_multiline_options", function (e) {
        e.preventDefault();
        const $extendedMultilineOptions = $("#extended_multiline_options");
        const textOptions = $("#extended_multiline_options_textarea", $extendedMultilineOptions).val();
        const extendedQuestionId = $(this).data("extendedquestionid");
        const parentQuestionId = $(".item_container").data("itemid");
        const $optionsWrapper = $(`.extended_question_container[data-extendedquestionid="${extendedQuestionId}"] .extended_options_wrapper`);

        const showProgress = (show) => kendo.ui.progress($extendedMultilineOptions, show);
        const closeWindow = () => $extendedMultilineOptions.data("kendoWindow").close();

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/addextendedmultilineoptions",
            type: "post",
            data: {
                extendedQuestionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: () => {
                closeWindow();
                showProgress(false);
            },
            success: (data) => {
                data.forEach(item => addExtendedOptions($optionsWrapper, item));
                closeWindow();
                showProgress(false);
                updateQuestionValidationState(parentQuestionId);
            }
        });

    });

    $("body").on("click", "#cancel_extended_multiline_options", function () {
        $("#extended_multiline_options").data("kendoWindow").close();
    });

    $("body").on("click", '.save_questionnaire_input_form input[name="InputType"]', function (e) {
        if ($(this).val() == "input" && $(this).is(':checked'))
            $('input[name="InputMask"]').removeAttr('readonly');
        else
            $('input[name="InputMask"]').attr('readonly', 'readonly');
    });

    $("body").on("click", ".add_single_multiline", function (e) {
        e.preventDefault();
        const questionId = $(this).data("questionid");
        const $append = $($("#single_multiline_options_template").html());
        $append.find("#add_single_multiline_options").attr("data-questionid", questionId);
        $("body").append($append);

        $("#dropdown_multiline_options").kendoWindow({
            modal: true,
            pinned: true,
            width: 500,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions,
            close: () => {
                $("#dropdown_multiline_options").data("kendoWindow").destroy();
            }
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", ".add_multy_multiline", function (e) {
        e.preventDefault();
        const questionId = $(this).data("questionid");
        const $append = $($("#multy_multiline_options_template").html());
        $append.find("#add_multy_multiline_options").attr("data-questionid", questionId);
        $("body").append($append);

        $("#dropdown_multiline_options").kendoWindow({
            modal: true,
            pinned: true,
            width: 500,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions,
            close: () => {
                $("#dropdown_multiline_options").data("kendoWindow").destroy();
            }
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", ".add_dropdown_multiline", function (e) {
        e.preventDefault();
        const questionId = $(this).data("questionid");
        const $append = $($("#dropdown_multiline_options_template").html());
        $append.find("#add_dropdown_multiline_options").attr("data-questionid", questionId);
        $("body").append($append);

        $("#dropdown_multiline_options").kendoWindow({
            modal: true,
            pinned: true,
            width: 500,
            height: 430,
            title: i18n.windowtitle_AddMultilineOptions,
            close: () => {
                $("#dropdown_multiline_options").data("kendoWindow").destroy();
            }
        }).data("kendoWindow").center().open();
    });

    $("body").on("click", "#add_dropdown_multiline_options", function (e) {
        e.preventDefault();
        const textOptions = $("#dropdown_multiline_options #multiline_options_textarea").val();
        const questionId = $(this).data("questionid");
        const $dropdownMultilineOptions = $("#dropdown_multiline_options");

        const showProgress = (show) => {
            kendo.ui.progress($dropdownMultilineOptions, show);
        };

        const closeWindow = () => {
            $dropdownMultilineOptions.data("kendoWindow").close();
        };

        const handleSuccess = (data) => {
            data.forEach(item => {
                addQuestionnaireDropdownOption(false, item.Id, item.Text, item.OrderId);
            });
            closeWindow();
            showProgress(false);
        };

        const handleError = () => {
            closeWindow();
            showProgress(false);
        };

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/adddropdownmultilineoptions",
            type: "post",
            data: {
                questionId: questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: handleError,
            success: handleSuccess
        });

    });

    $("body").on("click", "#add_single_multiline_options", function (e) {
        e.preventDefault();
        const textOptions = $("#dropdown_multiline_options #multiline_options_textarea").val();
        const questionId = $(this).data("questionid");
        const $dropdownMultilineOptions = $("#dropdown_multiline_options");

        const showProgress = (show) => {
            kendo.ui.progress($dropdownMultilineOptions, show);
        };

        const closeWindow = () => {
            $dropdownMultilineOptions.data("kendoWindow").close();
        };

        const handleSuccess = (data) => {
            data.forEach(item => {
                addQuestionnaireSingleOption(false, item.Id, item.Text, item.OrderId);
            });
            closeWindow();
            showProgress(false);
            updateQuestionValidationState(questionId);
        };

        const handleError = () => {
            closeWindow();
            showProgress(false);
        };

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/adddropdownmultilineoptions",
            type: "post",
            data: {
                questionId: questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: handleError,
            success: handleSuccess
        });

    });

    $("body").on("click", "#add_multy_multiline_options", function (e) {
        e.preventDefault();
        const textOptions = $("#dropdown_multiline_options #multiline_options_textarea").val();
        const questionId = $(this).data("questionid");
        const $dropdownMultilineOptions = $("#dropdown_multiline_options");

        const showProgress = (show) => {
            kendo.ui.progress($dropdownMultilineOptions, show);
        };

        const closeWindow = () => {
            $dropdownMultilineOptions.data("kendoWindow").close();
        };

        const handleSuccess = (data) => {
            data.forEach(item => {
                addQuestionnaireMultyOption(false, item.Id, item.Text, item.OrderId);
            });
            closeWindow();
            showProgress(false);
        };

        const handleError = () => {
            closeWindow();
            showProgress(false);
        };

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/adddropdownmultilineoptions",
            type: "post",
            data: {
                questionId: questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: handleError,
            success: handleSuccess
        });

    });

    $("body").on("click", "#cancel_dropdown_multiline_options", function () {
        $("#dropdown_multiline_options").data("kendoWindow").close();
    });

    $("#props_wrapper").on("click", 'input[type="radio"][name="IsTrueAnswer"]', function (e) {
        $(this).attr("checked", "checked");
        $('#props_wrapper input[name="IsTrueAnswer"]').not($(this)).removeAttr("checked");

    })

    $("body").on("click", ".add_autocomplete_multiline", function (e) {
        e.preventDefault();
        const appendTemplate = $("#autocomplete_multiline_options_template").html();
        const $append = $(appendTemplate);
        $append.find("#add_autocomplete_multiline_options").attr("data-questionid", $(this).data("questionid"));
        $("body").append($append);

        const $autocompleteMultilineOptions = $("#autocomplete_multiline_options");
        $autocompleteMultilineOptions.kendoWindow({
            modal: true,
            width: 500,
            pinned: true,
            title: i18n.windowtitle_AddMultilineOptions,
            open: function () {
                $(this.element).closest(".k-window").css('transform', 'translateY(-50%) !important');
            },
            close: function () {
                $autocompleteMultilineOptions.data("kendoWindow").destroy();
            }
        });

        const kendoWindow = $autocompleteMultilineOptions.data("kendoWindow");
        kendoWindow.center().open();
    });

    $("body").on("click", "#add_autocomplete_multiline_options", function (e) {
        e.preventDefault();
        const $autocompleteMultilineOptions = $("#autocomplete_multiline_options");
        const textOptions = $autocompleteMultilineOptions.find("#multiline_options_textarea").val();
        const questionId = $(this).data("questionid");

        const showProgress = (show) => kendo.ui.progress($autocompleteMultilineOptions, show);
        const closeWindow = () => $autocompleteMultilineOptions.data("kendoWindow").close();

        showProgress(true);

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/addautocompletemultilineoptions",
            type: "post",
            data: {
                questionId,
                questionnaireId: options.QuestionnaireId,
                text: textOptions,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val()
            },
            error: () => {
                closeWindow();
                showProgress(false);
            },
            success: (data) => {
                data.forEach(({ Id, Text }) => addQuestionnaireAutocompleteOption(false, Id, Text));
                closeWindow();
                showProgress(false);
            }
        });

    });

    $("body").on("click", "#cancel_autocomplete_multiline_options", function () {
        if ($("#autocomplete_multiline_options").data("kendoWindow") != undefined) {
            $("#autocomplete_multiline_options").data("kendoWindow").close();
        } else {
            $("#matrixcolumn_multiline_options").data("kendoWindow").close();
        }
    });

    $("body").on("click", "#cancel_question_logic_btn", function (e) {
        $("#logic_wrapper").data("kendoWindow").close();
    });

    $("body").on("click", "#add_question_logic_btn", function (e) {

        const when = $('input[name="when"]:checked').val();
        const then = $('input[name="then"]:checked').val();
        const questionId = $('#props_content').find('button[data-questionid]').attr('data-questionid');

        $('.question_wrapper[data-questionid="' + questionId + '"]').find('.haslogic').attr('style', 'display:inline-block');

        const data = {
            when,
            then,
            __RequestVerificationToken: $(this).find('input[name="__RequestVerificationToken"]').val(),
            questionId: $("#add_question_logic_form").find('input[name="questionId"]').val(),
            QuestionnaireId: options.QuestionnaireId
        };

        const handleWhenLogic = () => {
            switch (when) {
                case "select":
                case "notselect":
                    const selectElement = when === "select" ? $("#select_answeroptions") : $("#notselect_answeroptions");
                    if (selectElement.children().length === 0 || selectElement.val() === null) {
                        Notification.ShowError(i18n.alert_LogicSelectHasntOptions);
                        return false;
                    }
                    data.select = selectElement.val();
                    data.selectNo = selectElement.find('option:selected').html();
                    break;
                case "string":
                case "number":
                    data.Operation = $("#input_operations").val();
                    data.EvaluatedValue = when === "number" ? +$("#input_value").val() : $("#input_value").val();
                    break;
                case "date":
                    const date = $("#input_value").data("kendoDatePicker").value();
                    data.Operation = $("#input_operations").val();
                    data.EvaluatedValue = `${date.getFullYear()}-${date.getMonth() + 1}-${date.getDate()}`;
                    break;
            }
            return true;
        };

        const handleThenLogic = () => {
            switch (then) {
                case "topage":
                    data.to = $("#pagestojump").val();
                    if ($("#pagestojump").children().length === 0 || !data.to) {
                        Notification.ShowError(i18n.alert_LogicThenToPageHasntOptions);
                        return false;
                    }
                    break;
                case "toquestion":
                    data.to = $("#questionstojump").val();
                    data.toQuestionNo = $('#questionstojump option:selected').html();
                    if ($("#questionstojump").children().length === 0 || !data.to || !data.toQuestionNo) {
                        Notification.ShowError(i18n.alert_LogicThenToQuestionHasntOptions);
                        return false;
                    }
                    break;
            }
            return true;
        };

        if (!handleWhenLogic() || !handleThenLogic()) {
            return false;
        }

        sendAjaxWithQuestionnaireId({
            method: "post",
            url: $("#add_question_logic_form").attr("action"),
            data: data,
            error: function (data) {
                const errorMessages = {
                    "double_logic": i18n.alert_LogicDoubleRule,
                    "empty_value": i18n.alert_LogicEmptyValue,
                    "logics_conflict": i18n.alert_LogicConflictsWithAnother
                };
                const errorMessage = errorMessages[data.responseText];
                if (errorMessage) {
                    Notification.ShowError(errorMessage);
                } else {
                    defaultErrorHandler(data);
                }
            },
            success: function (data) {
                const logicWrapper = $("#logic_wrapper");
                logicWrapper.data("kendoWindow").close();
                logicWrapper.html("").remove();

                $(".logics").append(`
                    <div>
                        <a data-logicid="${data.Id}">
                            <span class="remove_logic fas fa-times constructor__remove-icon" title="${i18n.tooltip_remove_logic}"></span>
                        </a>
                        <span>${data.Text}</span>
                    </div>
                `);
            }
        });

        return false;

    });

    $("body").on("click", ".remove_logic", function (e) {

        const questionId = $('#props_content').find('button[data-questionid]').attr('data-questionid');
        const logicId = $(this).closest("a").data("logicid");

        Confirmation.IfConfirmed({
            message: i18n.confirm_AreYouSure
        }, function () {
            const logics = $('.logics').find('.remove_logic');
            if (logics.length === 1) {
                $('.item_container[data-itemid="' + questionId + '"]')
                    .find('input[type="checkbox"][name="IsAnswerRequired"]')
                    .prop('disabled', false);
            }

            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/removelogic",
                type: "post",
                data: {
                    logicId: logicId,
                    questionnaireId: options.QuestionnaireId
                },
                dataType: 'json',
                success: function (data) {
                    $('.logics a[data-logicid="' + logicId + '"]').closest("div").remove();
                    $('.question_wrapper[data-questionid="' + questionId + '"]')
                        .find('.haslogic')
                        .toggle(!!data);
                },
                error: defaultErrorHandler
            });
        });

        return false;
    });

    $("body").on("click", ".add_logic_withoptions", function (e) {
        const questionId = $(this).data("questionid");

        function handleLogicOptionsSuccess(data) {
            showLogicWithOptionsDialog(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: function () {
                    const $inputElements = $("#input_operations, #input_value");
                    $inputElements.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputElements.prop('disabled', this.value !== 'string');
                    });
                },
                modal: true,
                width: 400,
                pinned: true,
                title: i18n.windowtitle_AddLogic,
                close: function () {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        }

        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/getlogicoptions",
            type: "GET",
            data: { questionId },
            success: handleLogicOptionsSuccess
        });
    });

    $("body").on("click", "input[type='radio'][name='when']", (e) => {

        switch (e.currentTarget.value) {
            case "select":
                $("#select_answeroptions").prop("disabled", false);
                $("#notselect_answeroptions").prop("disabled", true);
                break;
            case "notselect":
                $("#notselect_answeroptions").prop("disabled", false);
                $("#select_answeroptions").prop("disabled", true);
                break
            default:
                $("#select_answeroptions").prop("disabled", true);
                $("#notselect_answeroptions").prop("disabled", true);
                break;
        }
    })

    $("body").on("click", "input[type='radio'][name='then']", (e) => {

        switch (e.currentTarget.value) {
            case "toquestion":
                $("#questionstojump").prop("disabled", false);
                $("#pagestojump").prop("disabled", true);
                break;
            case "topage":
                $("#pagestojump").prop("disabled", false);
                $("#questionstojump").prop("disabled", true);
                break;
            default:
                $("#pagestojump").prop("disabled", true);
                $("#questionstojump").prop("disabled", true);
                break;
        }
    })

    $("body").on("click", "#add_matrix_logic_btn", function () {
        const questionId = $('#props_content').find('button[data-questionid]').attr('data-questionid');
        const when = $('input[name="when"]:checked').val();
        const then = $('input[name="then"]:checked').val();

        const saveRequiredProperty = () => {
            const data = {
                Id: $(".item_container").attr('data-itemid'),
                ItemType: "question",
                PropertyName: "IsAnswerRequired",
                Value: true,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            };
            SaveProperty(data);
        };

        const getLogicData = () => {
            const data = {
                when,
                then,
                __RequestVerificationToken: $(this).find('input[name="__RequestVerificationToken"]').val(),
                questionId: $("#add_question_logic_form").find('input[name="questionId"]').val(),
                QuestionnaireId: options.QuestionnaireId
            };

            if (when === "select" || when === "notselect" || when === "notanswered") {
                const selectElement = when === "select" ? $("#select_answeroptions") : $("#notselect_answeroptions");
                if (!selectElement.val()) {
                    Notification.ShowError(i18n.alert_LogicEmptyValue);
                    return null;
                }
                data.when += ":" + $('#innerquestions').val();
                data.select = selectElement.val();
                data.selectNo = selectElement.find('option:selected').html();
            }

            if (then === "topage") {
                data.to = $("#pagestojump").val();
            } else if (then === "toquestion") {
                data.to = $("#questionstojump").val();
                data.toQuestionNo = $('#questionstojump option:selected').html();
            }

            return data;
        };

        const sendLogicData = (data) => {
            sendAjaxWithQuestionnaireId({
                method: "post",
                url: $("#add_question_logic_form").attr("action"),
                data: data,
                error: function (response) {
                    if (response.responseText === "double_logic") {
                        Notification.ShowError(i18n.alert_LogicDoubleRule);
                    } else if (response.responseText === "empty_value") {
                        Notification.ShowError(i18n.alert_LogicEmptyValue);
                    } else {
                        defaultErrorHandler(response);
                    }
                },
                success: function (data) {
                    $('.question_wrapper[data-questionid="' + questionId + '"]').find('.haslogic').attr('style', 'display:inline-block');
                    $("#logic_wrapper").data("kendoWindow").close();
                    $("#logic_wrapper").html("").remove();
                    $(".logics").append(`<div><a data-logicid="${data.Id}"><span class="remove_logic fas fa-times constructor__remove-icon" title="${i18n.tooltip_remove_logic}"></span></a><span>${data.Text}</span></div>`);
                }
            });
        };

        saveRequiredProperty();
        const logicData = getLogicData();
        if (logicData) {
            sendLogicData(logicData);
        }

        return false;

    });

    $("body").on("click", ".add_logic_withoptions_matrix", function (e) {
        const questionId = $(this).data("questionid");
        const getLogicOptions = () => {
            return sendAjaxWithQuestionnaireId({
                url: "/api/constructor/getlogicoptions",
                type: "GET",
                data: { questionId },
                success: setupLogicWindow,
                error: defaultErrorHandler
            });
        };

        const setupLogicWindow = (data) => {
            showLogicWithOptionsMatrix(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: () => {
                    const $inputs = $("#input_operations, #input_value");
                    $inputs.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputs.prop('disabled', this.value !== 'string');
                    });
                },
                modal: true,
                width: 400,
                pinned: true,
                title: i18n.windowtitle_AddLogic,
                close: () => {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        getLogicOptions();
    });

    $("body").on("click", ".add_logic_string", function (e) {
        const questionId = $(this).data("questionid");
        const getLogicOptions = () => {
            return sendAjaxWithQuestionnaireId({
                url: "/api/constructor/getlogicoptions",
                type: "GET",
                data: { questionId },
                success: setupLogicWindow,
                error: defaultErrorHandler
            });
        };

        const setupLogicWindow = (data) => {
            showLogicStringDialog(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: () => {
                    const $inputs = $("#input_operations, #input_value");
                    $inputs.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputs.prop('disabled', this.value !== 'string');
                    });
                },
                modal: true,
                pinned: true,
                width: 480,
                title: i18n.windowtitle_AddLogic,
                close: () => {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        getLogicOptions();
    });

    $("body").on("click", ".add_logic_number", function (e) {
        const questionId = $(this).data("questionid");
        const getLogicOptions = () => {
            return sendAjaxWithQuestionnaireId({
                url: "/api/constructor/getlogicoptions",
                type: "GET",
                data: { questionId },
                success: setupLogicWindow,
                error: defaultErrorHandler
            });
        };

        const setupLogicWindow = (data) => {
            showLogicNumberDialog(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: () => {
                    const $inputs = $("#input_operations, #input_value");
                    $inputs.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputs.prop('disabled', this.value !== 'number');
                    });
                },
                modal: true,
                width: 430,
                pinned: true,
                title: i18n.windowtitle_AddLogic,
                close: () => {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        getLogicOptions();
    });

    $("body").on("click", ".add_logic_date", function (e) {
        const questionId = $(this).data("questionid");
        const getLogicOptions = () => {
            return sendAjaxWithQuestionnaireId({
                url: "/api/constructor/getlogicoptions",
                type: "GET",
                data: { questionId },
                success: setupLogicWindow,
                error: defaultErrorHandler
            });
        };

        const setupLogicWindow = (data) => {
            showLogicDateDialog(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: () => {
                    const $inputs = $("#input_operations, #input_value");
                    $inputs.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputs.prop('disabled', this.value !== 'string');
                    });
                },
                modal: true,
                width: 430,
                pinned: true,
                title: i18n.windowtitle_AddLogic,
                close: () => {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();

            $("#input_value").kendoDatePicker({
                value: new Date()
            }).closest(".k-datepicker").css("width", "196px");
        };

        getLogicOptions();
    });

    $("body").on("click", ".add_logic_no_options", function (e) {
        const questionId = $(this).data("questionid");
        const getLogicOptions = () => {
            return sendAjaxWithQuestionnaireId({
                url: "/api/constructor/getlogicoptions",
                type: "GET",
                data: { questionId },
                success: setupLogicWindow,
                error: defaultErrorHandler
            });
        };

        const setupLogicWindow = (data) => {
            showLogicNoOptionsDialog(questionId, data);

            $("#logic_wrapper").kendoWindow({
                open: () => {
                    const $inputs = $("#input_operations, #input_value");
                    $inputs.prop('disabled', true);

                    $('input[type=radio][name=when]').change(function () {
                        $inputs.prop('disabled', this.value !== 'string');
                    });
                },
                modal: true,
                width: 400,
                pinned: true,
                title: i18n.windowtitle_AddLogic,
                close: () => {
                    $("#logic_wrapper").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        getLogicOptions();
    });

    $("body").on("click", ".open_wrong_message_btn", function (e) {
        const appendMessageWindow = () => {
            const $append = $($("#message_window_template").html());
            $append.find("button#save_message").attr("data-questionid", $(this).data("questionid"));

            const fullText = $(".open_wrong_message_full").html();
            $append.find("#message_editor").html(fullText);

            $("body").append($append);
        };

        const setupKendoWindow = () => {
            $("#message_window").kendoWindow({
                modal: true,
                width: 620,
                height: 430,
                pinned: true,
                title: i18n.windowtitle_MessageText,
                close: function () {
                    if (tinymce.get("message_editor")) {
                        tinymce.get("message_editor").destroy();
                    }
                    $("#message_window").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        const initTinyMCE = () => {
            createTinyMCE({
                selector: "#message_editor",
                isInline: false,
                height: 180,
                userFolder: options.UserFolder
            });
        };

        appendMessageWindow();
        setupKendoWindow();
        initTinyMCE();


    });

    $("body").on("click", ".option_message_btn, .option_wrong_table_message_btn", function (e) {
        const appendMessageWindow = () => {
            const $append = $($("#message_window_template").html());
            const optionId = $(this).data("optionid");
            $append.find("button#save_message").attr("data-optionid", optionId);

            const isWrongTableMessage = $(this).hasClass("option_wrong_table_message_btn");
            const messageSelector = isWrongTableMessage ? ".option_wrong_table_message_full" : ".option_message_full";

            if (isWrongTableMessage) {
                $append.find("button#save_message").attr("data-messagetype", "wrong");
            }

            const fullText = $(this).closest(".option_wrapper").find(messageSelector).html();
            $append.find("#message_editor").html(fullText);

            $("body").append($append);
        };

        const setupKendoWindow = () => {
            $("#message_window").kendoWindow({
                modal: true,
                pinned: true,
                width: 620,
                height: 430,
                resizable: false,
                title: i18n.windowtitle_MessageText,
                close: function () {
                    if (tinymce.get("message_editor")) {
                        tinymce.get("message_editor").destroy();
                    }
                    $("#message_window").data("kendoWindow").destroy();
                }
            }).data("kendoWindow").center().open();
        };

        const initTinyMCE = () => {
            createTinyMCE({
                selector: "#message_editor",
                ui_container: '.k-window',
                isInline: false,
                height: 180,
                userFolder: options.UserFolder
            });
        };

        appendMessageWindow();
        setupKendoWindow();
        initTinyMCE();
    });

    $("body").on("click", "#save_message", function (e) {
        const $window = $(this).closest(".k-window");
        Preloader.EnableLoader($window);

        tinymce.get("message_editor").destroy();

        const $messageWindow = $(this).closest("div#message_window");
        const message = $messageWindow.find("#message_editor").html();
        const questionId = $(this).data("questionid");
        const optionId = $(this).data("optionid");

        if (questionId) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/saveopenwrongmessage",
                type: "post",
                data: {
                    questionId: questionId,
                    message: message,
                    questionnaireId: options.QuestionnaireId
                },
                success: function (data) {
                    Preloader.DisableLoader($(this).closest(".k-window"));
                    $("span.open_wrong_message_full").html(message);
                    $("span.open_wrong_message_short").html(textize(message));

                    $("#message_window").data("kendoWindow").close();

                    $("#message_window").html("");
                    $("#message_window").remove();

                },
                error: function (data) {
                    Preloader.DisableLoader($(this).closest(".k-window"));
                    defaultErrorHandler(data);
                }
            });
        }


        if (optionId) {
            var url = "/api/constructor/saveoptionmessage";

            var isTableWrong = $(this).data("messagetype") === "wrong";
            if (isTableWrong) {
                url = "/api/constructor/saveoptionmessage?isWrong=true";
            }

            sendAjaxWithQuestionnaireId({
                url: url,
                type: "post",
                data: {
                    optionId: optionId,
                    message: message,
                    questionnaireId: options.QuestionnaireId
                },
                success: function (data) {
                    var wrapper = $('button.option_message_btn[data-optionid="' + optionId + '"]').closest(".option_wrapper");

                    if (isTableWrong) {
                        wrapper.find(".option_wrong_table_message_full").html(message);
                        wrapper.find(".option_wrong_table_message_short").html(textize(message));
                    } else {
                        wrapper.find(".option_message_full").html(message);
                        wrapper.find(".option_message_short").html(textize(message));
                    }

                    $("#message_window").data("kendoWindow").close();
                },
                error: function (data) {
                    defaultErrorHandler(data);
                    $("#message_window").data("kendoWindow").close();
                }
            });
        }

    });

    $("body").on("click", "#cancel_message", function (e) {
        $("#message_window").data("kendoWindow").close();
    });

    $("body").on("click", ".remove_file", function (e) {
        e.preventDefault();

        const fileId = $(this).data("fileid");
        const fileType = $(this).data("filetype");
        const $fileWrapper = $(this).closest('div.file_wrapper');



        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/removefile",
            type: "POST",
            data: {
                id: fileId,
                type: fileType,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            },
            success: function () {
                $fileWrapper.remove();
            },
            error: defaultErrorHandler
        });


    });

    $("body").on("click", ".add_files", function () {
        const type = $(this).data("type");
        const id = $(this).data("id");

        const fileBrowser = ShowFileBrowser("other", { userFolder: options.UserFolder });

        fileBrowser.browser.bind("apply", function (e) {
            const filename = $(".k-window .k-listview .k-selected").find(".k-file-name").html();
            const path = `/files/${options.UserFolder}/other/${e.sender._path === "/" ? "" : e.sender._path}${filename}`;

            const data = {
                id,
                type,
                name: filename,
                path,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            };

            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/addfile",
                type: "POST",
                data,
                error: defaultErrorHandler,
                success: function (responseData) {
                    addFile($(`.files_wrapper[data-id="${id}"]`), responseData, type, filename, path);
                    fileBrowser.window.close();
                }
            });
        });

        const setTitle = (selector, title) => $(selector).attr("title", title);

        setTitle("button.k-button.k-button-icon>span.k-icon.k-i-folder-add", i18n.filebrowser_createFolder);
        setTitle("div.k-window-actions>a", i18n.filebrowser_close);
        setTitle("button.k-button.k-button-icon>span.k-icon.k-i-close", i18n.filebrowser_remove);
    });

    $("body").on("click", ".save_scaleData", function (e) {
        saveScaleValues(e);
    });

    $("body").on("click", ".save_MinMaxChecked", function (e) {
        const isValid = validateQuestionnaireMulty();

        if (isValid) {
            const item_container = $(e.currentTarget).closest('div.item_container');
            const id = item_container.data("itemid");
            const type = item_container.data("itemtype");
            const minCheckedCount = +$(".item_container").find('input[name="MinCheckedCount"]').val();
            const maxCheckedCount = +$(".item_container").find('input[name="MaxCheckedCount"]').val();
            const token = $('#secret_form input[name="__RequestVerificationToken"]').val();

            const createPropertyData = (propertyName, value) => ({
                Id: id,
                ItemType: type,
                PropertyName: propertyName,
                Value: value,
                __RequestVerificationToken: token,
                questionnaireId: options.QuestionnaireId
            });

            SaveProperty(createPropertyData("MinCheckedCount", minCheckedCount), false);
            SaveProperty(createPropertyData("MaxCheckedCount", maxCheckedCount));
        }
    });

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    $("body").on("change", ".changable_input", function (e) {
        const item_container = $(this).closest('div.item_container');
        const id = item_container.data("itemid");
        const type = item_container.data("itemtype");
        var propertyName = $(this).data("propertyname");
        if (!propertyName) {
            propertyName = $(this).attr("name");
        }
        const questionType = $('.question_wrapper[data-questionid="' + id + '"]').attr('data-type');

        if (!propertyName) return;

        const propertyHandlers = {
            "InputType_": () => "InputType",
            "ScaleMin": () => validateQuestionnaireScale() ? "ScaleMin" : null,
            "ScaleMax": () => validateQuestionnaireScale() ? "ScaleMax" : null,
            "FileExtensions": () => validateQuestionnaireFile(item_container) ? "FileExtensions" : null,
            "MinDate": () => handleDateValidation(questionType, "MinDate"),
            "MaxDate": () => handleDateValidation(questionType, "MaxDate"),
            "MinDateScale": () => handleDateValidation(questionType, "MinDateScale"),
            "MaxDateScale": () => handleDateValidation(questionType, "MaxDateScale"),
            "From": () => handleRangeValidation($(this)),
            "To": () => handleRangeValidation($(this))
        };

        const actualPropertyName = propertyHandlers[propertyName] ? propertyHandlers[propertyName]() : propertyName;
        if (!actualPropertyName) return;

        if (propertyName === "ScaleMax") {

            const value = getValue($(".item_container").find('input[name="ScaleMin"]'), "ScaleMin");
            if (value === null) return;
            handleScaleProperty(id, type, "ScaleMin", value);
        } else if (propertyName === "ScaleMin") {

            const value = getValue($(".item_container").find('input[name="ScaleMax"]'), "ScaleMax");
            if (value === null) return;
            handleScaleProperty(id, type, "ScaleMax", value);
        }

        const value = getValue($(this), actualPropertyName);
        if (value === null) return;

        const delay = ["radio", "checkbox"].includes($(this).attr("type")) ? 150 : 300;

        if (["ScaleMin", "ScaleMax"].includes(actualPropertyName)) {
            handleScaleProperty(id, type, actualPropertyName, value);
        } else {
            const data = {
                Id: id,
                ItemType: type,
                PropertyName: actualPropertyName,
                Value: value,
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            };
            Delay(SaveProperty, data, delay);
        }

        function handleDateValidation(questionType, propertyName) {
            if (questionType === 'questionnaire_date') {
                const [minDay, minMonth, minYear] = $("#between_min").val().split('.');
                const [maxDay, maxMonth, maxYear] = $("#between_max").val().split('.');
                const minDate = new Date(minYear, minMonth - 1, minDay);
                const maxDate = new Date(maxYear, maxMonth - 1, maxDay);
                if (minDate.getTime() > maxDate.getTime()) {
                    Notification.ShowError(i18n.errorMessage_beginDatapickerGreatThanEnd);
                    return null;
                }
            }
            return propertyName;
        }

        function handleRangeValidation(element) {
            const wrapper = element.closest("div.range_group");
            const fromValue = parseInt(wrapper.find('[id*=from]').val()) || 0;
            const toValue = parseInt(wrapper.find('[id*=to]').val()) || 10;
            wrapper.find('[id*=from]').val(fromValue);
            wrapper.find('[id*=to]').val(toValue);
            if (fromValue > toValue) {
                Notification.ShowError(i18n.errorMessage_lowerBoundBiggerThanUpperBound);
                return null;
            }
            return element.attr("name");
        }

        function getValue(element, propertyName) {
            if (element.attr("type") === "checkbox") {
                return element.is(':checked').toString();
            }
            if (["MaxFileSize", "StorageUnit"].includes(propertyName)) {
                const file_size = propertyName === "MaxFileSize" ? element.val() : element.parent().parent().find('[name=MaxFileSize]').val();
                const unit = propertyName === "StorageUnit" ? element.val() : element.parent().parent().find('[name=StorageUnit]').val();
                if (file_size < 0) {
                    Notification.ShowError("Размер файла не может быть отрицательным");
                    return null;
                }
                return `${file_size} ${unit}`;
            }
            if (element.attr("type") === "number" && element.val() === "") {
                return "0";
            }
            if (propertyName === "FileExtensions") {
                return element.val().replaceAll(" ", "").toLowerCase();
            }
            return element.val();
        }

        function handleScaleProperty(id, type, propertyName, value) {
            const data = {
                Id: id,
                ItemType: type,
                PropertyName: propertyName,
                Value: value || (propertyName === "ScaleMin" ? "0" : "1"),
                __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                questionnaireId: options.QuestionnaireId
            };
            SaveProperty(data);
        }
    });

    $("body").on("click", "#saveSheetsButton", function (e) {
        var spreadsheet = $("#spreadSheet").data("kendoSpreadsheet");
        let sheets = spreadsheet.sheets();
        sheets.forEach(sheet => {
            sheet.select("A1");
        });
        spreadsheet.activeSheet(sheets[0]);
        var analiticsCells = getSpreadsheetAnaliticsCells();
        var questionId = $(".item_container[data-itemtype='question']").data("itemid");
        var spreadsheetJson = JSON.stringify(spreadsheet);
        const blob = new Blob([spreadsheetJson], { type: 'application/json' });
        const formData = new FormData();
        formData.append('file', blob, 'data.json');
        formData.append("questionId", questionId);
        formData.append("analiticsCells", analiticsCells);
        formData.append("questionnaireId", options.QuestionnaireId);
        sendAjaxWithQuestionnaireId({
            url: "/api/constructor/savespreadsheetoptions",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            error: function (data) {
                if (data.responseJSON && data.responseJSON.Value) {
                    Notification.ShowError(data.responseJSON.Value);
                    return;
                }
                defaultErrorHandler(data);
            },
            success: function (data) {
                Notification.ShowSuccess(i18n.alert_ChangesSaved);
                updateQuestionValidationState(questionId);
            }
        });
    });

    $("body").on("click", "#cellsAvailabilityChangeButton", function (e) {
        var spreadsheet = $("#spreadSheet").data("kendoSpreadsheet");
        var range = spreadsheet.activeSheet().selection();
        var enabled = range.enable();

        if (enabled === null) {
            enabled = true;
        }

        range.enable(!enabled);
    });

    $("body").on("click", "#addAnaliticsCells", function (e) {
        Preloader.EnableLoader("#props_content");
        changeColorSpreadsheetSelectedCells("beige");
        Preloader.DisableLoader("#props_content");
    });

    $("body").on("click", "#removeAnaliticsCells", function (e) {
        Preloader.EnableLoader("#props_content");
        changeColorSpreadsheetSelectedCells("white");
        Preloader.DisableLoader("#props_content");
    });

    $("body").on("change", ".changable_input_testsingletrueanswer", function (e) {
        var item_container = $(this).closest('div.item_container');

        var id = item_container.data("itemid");
        var type = item_container.data("itemtype");
        var propertyName = $(this).attr("name");

        value = "true";

        var data = {
            Id: id,
            ItemType: type,
            PropertyName: propertyName,
            Value: value,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };

        Delay(function (data) {
            sendAjaxWithQuestionnaireId({
                url: "/api/constructor/savetestsingletrueanswer",
                type: "POST",
                data: data,
                error: function (data) {
                    defaultErrorHandler(data);
                },
                success: function (data) {
                    Notification.ShowSuccess(i18n.alert_ChangesSaved);
                }
            });
        }, data, 300);

    });

    $("body").on("change", ".change_question_skin", function () {
        var value = $(this).attr("id");
        var id = $(this).closest(".form-horizontal.item_container").attr("data-itemid");

        var data = {
            Id: id,
            ItemType: "question",
            PropertyName: "Skin",
            Value: value,
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };

        SaveProperty(data);

    });

    $("body").on("change", ".matrix_logic_option", function () {
        var value = $(this).val();

        switch (value) {

            case "select":
                $('#select_answeroptions').removeAttr('disabled');
                $('#notselect_answeroptions').attr('disabled', true);
                break;
            case "notselect":
                $('#notselect_answeroptions').removeAttr('disabled');
                $('#select_answeroptions').attr('disabled', true);
                break;
        }

    });

    $("body").on("change", 'input[type="checkbox"][name="ManualExpertise"]', function (e) {
        const $checkbox = $(this);
        const $itemContainer = $checkbox.closest('div.item_container');
        const questionId = $itemContainer.attr('data-itemid');
        const $manualExpertise = $(`.question_wrapper[data-questionid="${questionId}"]`).find('.manualexpertize');

        $manualExpertise.toggle($checkbox.is(':checked'));
    });

    $("body").on("change", 'input[type="checkbox"][name="IsAnswerRequired"]', function (e) {

        const $checkbox = $(this);
        const $itemContainer = $checkbox.closest('div.item_container');
        const questionId = $itemContainer.attr('data-itemid');
        const $requiredMark = $(`.question_wrapper[data-questionid="${questionId}"]`).find('.isrequired');

        $requiredMark.toggle($checkbox.is(':checked'));
    });

    $("body").on("change", 'input[name="MinCheckedCount"], input[name="MaxCheckedCount"]', function () {
        var val = $(this).val();
        $(this).val(Math.round(val));
    });

    $("body").on("change", 'input[name="InputType"]', function (e) {
        var questionId = $(this).closest("div[data-itemtype='question']").data("itemid");
        var inputValue = $(this).val();
        var maskInput = $('input[name="InputMask"]');
        var fromInput = $('#from');
        var toInput = $('#to');

        function toggleReadonly(element, condition) {
            element.attr('readonly', !condition);
        }

        toggleReadonly(maskInput, inputValue === "inputMask");
        toggleReadonly(fromInput, inputValue === "numberRange");
        toggleReadonly(toInput, inputValue === "numberRange");

        if (inputValue === "inputMask") {
            DateRenderAppropriateLogicButton(inputValue, questionId);
        } else {
            renderAppropriateLogicButton(inputValue, questionId);
        }
    });

    $('body').on("change", "[name='InputType']", function (e) {
        const value = $(e.currentTarget).val();
        const isRangeType = ["numberRange", "intRange"].includes(value);

        $('input[type="number"][name!="Weight"]').attr("readonly", "readonly");

        function toggleRangeInputs(type, isEnabled) {
            $(`#${type}_from, #${type}_to`).attr("readonly", !isEnabled);
        }

        function transferValues(fromType, toType) {
            [`from`, `to`].forEach(suffix => {
                const val = $(`#${fromType}_${suffix}`).val();
                $(`#${toType}_${suffix}`).val(val);
                $(`#${fromType}_${suffix}`).val("");
            });
        }

        if (isRangeType) {
            toggleRangeInputs(value, true);

            if (value === "numberRange") {
                transferValues("intRange", "numberRange");
            } else if (value === "intRange") {
                transferValues("numberRange", "intRange");
            }
        } else {
            ["intRange", "numberRange"].forEach(type => {
                toggleRangeInputs(type, false);
                $(`#${type}_from, #${type}_to`).val("");
            });
        }

    });

    $("body").on("change", "#multiSelectFileType", function (e) {
        const multiSelect = $("#multiSelectFileType").data("kendoMultiSelect");
        const questionId = $("#multiSelectFileType").attr("questionId");
        const selectedTypes = multiSelect.value();

        if (selectedTypes.length === 0) {
            Notification.ShowError(i18n.errorMessage_inputFileExtensions);
            return;
        }

        $.ajax({
            url: "/api/allowFileformatsbyquestion/getUpdates",
            data: {
                types: selectedTypes,
                questionId: questionId
            },
            type: "post",
            success: function (data) {
                const formatsMultiSelect = $("#multiSelectFileFormats").data("kendoMultiSelect");
                const dataSource = new kendo.data.DataSource({ data: data });
                dataSource.read();
                formatsMultiSelect.setDataSource(dataSource);

                if (formatsMultiSelect.value().length === 0) {
                    formatsMultiSelect.value(data[0]);
                }

                const selectedFormats = formatsMultiSelect.value();

                const propertyData = {
                    Id: questionId,
                    ItemType: "question",
                    PropertyName: "FileExtensions",
                    Value: selectedFormats.join(", "),
                    __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
                    questionnaireId: options.QuestionnaireId
                };

                Delay(SaveProperty, propertyData, 300);
            },
            error: function (xhr, status, error) {
                console.error("Error updating file formats:", error);
                Notification.ShowError(i18n.errorMessage_updateFileFormats);
            }
        });
    });

    $("body").on("change", "#multiSelectFileFormats", function (e) {
        const multiSelectFileFormats = $("#multiSelectFileFormats").data("kendoMultiSelect");
        const selectedFormats = multiSelectFileFormats.value();
        const questionId = $("#multiSelectFileType").attr("questionId");

        if (selectedFormats.length === 0) {
            Notification.ShowError(i18n.errorMessage_inputFileExtensions);
            return;
        }

        const data = {
            Id: questionId,
            ItemType: "question",
            PropertyName: "FileExtensions",
            Value: selectedFormats.join(", "),
            __RequestVerificationToken: $('#secret_form input[name="__RequestVerificationToken"]').val(),
            questionnaireId: options.QuestionnaireId
        };

        Delay(SaveProperty, data, 300);
    });

    loadQuestions();

}