﻿const userEditorTemplate = `<div id="taskForm" class="k-form">
        <div class="mb-3">
            <label for="title" class="form-label">Заголовок</label>
            <input type="text" id="title" class="form-control k-textbox" required/>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Описание</label>
            <textarea id="description" class="form-control k-textarea"></textarea>
        </div>

        <div class="row dates-wrapper">
            <div class="col-md-6 col-lg-4 order-lg-2">
                <div class="mb-3">
                    <label for="start_date" class="form-label">Дата начала</label>
                    <input id="start_date" class="form-control"/>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 order-lg-2">
                <div class="mb-3">
                    <label for="end_date" class="form-label">Дата окончания</label>
                    <input id="end_date" class="form-control"/>
                </div>
            </div>
        </div>
    </div>`;

function OpenUserTaskEditWindow(task, refreshSourceFunc = null) {
    let editDialog = $("<div id='task-editor-window'></div>").kendoDialog({
        modal: true,
        pinned: true,
        visible: false,
        height: "670px",
        buttonLayout: "normal",
        content: kendo.template(userEditorTemplate),
        open: function (e) {
            let dialog = e.sender;

            let titleInput = dialog.element.find("#title");
            let descriptionEditor = dialog.element.find("#description").data("kendoEditor");
            let startDatePicker = dialog.element.find("#start_date").data("kendoDateTimePicker");
            let endDatePicker = dialog.element.find("#end_date").data("kendoDateTimePicker");

            if (task) {
                //заполнить поля
                titleInput.val(task?.Title);
                descriptionEditor.value(task?.Description);
                startDatePicker.value(task?.StartDate);
                endDatePicker.value(task?.EndDate);

                //если привязана к анкете не нужно редактирование дат
                if (task.QuestionnaireId != null) {
                    $(".dates-wrapper").hide();
                }
            }
            else {
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                const nextWeek = new Date();
                nextWeek.setHours(0, 0, 0, 0);
                nextWeek.setDate(today.getDate() + 7);

                startDatePicker.value(today);
                endDatePicker.value(nextWeek);
            }
        },
        close: function () {
            if (refreshSourceFunc != null || refreshSourceFunc !== undefined) {
                refreshSourceFunc();
            }
            $("#task-editor-window").remove();
        },
        actions: [
            {
                text: "Сохранить",
                action: function (e) {

                    let newTask = {
                        Title: $("#title").val(),
                        StartDate: $("#start_date").data("kendoDateTimePicker").value(),
                        EndDate: $("#end_date").data("kendoDateTimePicker").value()
                    }

                    let validationResult = ValidateTaskForUser(newTask);

                    if (!validationResult.isValid) {

                        Notification.ShowError(validationResult.error);

                        return false;
                    }

                    let taskData = new FormData();

                    taskData.append("Title", $("#title").val());
                    taskData.append("Description", $("#description").data("kendoEditor").value());
                    taskData.append("StartDate", FormatDate($("#start_date").data("kendoDateTimePicker").value()));
                    taskData.append("EndDate", FormatDate($("#end_date").data("kendoDateTimePicker").value()));
                    taskData.append("Assignment", '1');

                    let url;
                    if (task != null) {
                        url = "/api/user-tasks/update";

                        taskData.append("Id", task.Id);
                        taskData.append("QuestionnaireId", task.QuestionnaireId);

                    } else {
                        url = "/api/user-tasks/create";
                    }

                    $.ajax({
                        url: url,
                        dataType: "json",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: taskData,
                        complete: function (response) {
                            if (response.status === 200) {
                                if (refreshSourceFunc != null || refreshSourceFunc !== undefined) {
                                    refreshSourceFunc();
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    })

                    return true;
                },
                primary: true
            },
            {
                text: "Отмена"
            }
        ],
    }).data("kendoDialog");

    $("#description").kendoEditor({
        tools: [
            "undo",
            "redo",
            {
                name: "fontName",
                items: [
                    { text: "Andale Mono", value: "\"Andale Mono\"" },
                    { text: "Arial", value: "Arial" },
                    { text: "Arial Black", value: "\"Arial Black\"" },
                    { text: "Book Antiqua", value: "\"Book Antiqua\"" },
                    { text: "Comic Sans MS", value: "\"Comic Sans MS\"" },
                    { text: "Courier New", value: "\"Courier New\"" },
                    { text: "Georgia", value: "Georgia" },
                    { text: "Helvetica", value: "Helvetica" },
                    { text: "Impact", value: "Impact" },
                    { text: "Symbol", value: "Symbol" },
                    { text: "Tahoma", value: "Tahoma" },
                    { text: "Terminal", value: "Terminal" },
                    { text: "Times New Roman", value: "\"Times New Roman\"" },
                    { text: "Trebuchet MS", value: "\"Trebuchet MS\"" },
                    { text: "Verdana", value: "Verdana" },
                ]
            },
            "fontSize",
            "bold",
            "italic",
            "underline",
            "backColor",
            "foreColor",
            "insertUnorderedList",
            "justifyLeft",
            "justifyCenter",
            "justifyRight",
            "formatting",
            "createLink",
            "unlink",
            "insertImage",
            "tableWizard",
            "tableProperties",
            "tableCellProperties",
            "createTable",
            "addRowAbove",
            "addRowBelow",
            "addColumnLeft",
            "addColumnRight",
            "deleteRow",
            "deleteColumn",
            "mergeCellsHorizontally",
            "mergeCellsVertically",
            "splitCellHorizontally",
            "splitCellVertically",
            "tableAlignLeft",
            "tableAlignCenter",
            "tableAlignRight"
        ]
    });

    $("#start_date").kendoDateTimePicker({});

    $("#end_date").kendoDateTimePicker({});

    editDialog.title(task == null ? "Создать задачу" : "Редактировать задачу");
    editDialog.open();
}

function ValidateTaskForUser(task) {
    if (!task.Title || task.Title.trim() === '') {
        return {isValid: false, error: 'Заголовок задачи отсутствует'};
    }

    if (!task.StartDate || !task.EndDate) {
        return {isValid: false, error: 'Даты начала и/или окончания отсутствуют'};
    }

    const startDate = new Date(task.StartDate);
    const endDate = new Date(task.EndDate);

    if (isNaN(startDate.getTime()) || isNaN(endDate.getTime())) {
        return {isValid: false, error: 'Некорректный формат дат'};
    }

    if (endDate < startDate) {
        return {isValid: false, error: 'Дата окончания не может быть раньше даты начала'};
    }

    return {isValid: true};
}

function FormatDate(timeStamp) {
    let date = new Date(timeStamp);
    return date.toLocaleString();
}
