var i18n = {
    "ru-RU": {
        button_SelectFile:"Выбрать файл",
        label_FileUnselected:"Файл не выбран",
        button_Copied:"Скопировано",
        btn_text_helper_hide:"Свернуть подсказку",
        btn_text_helper_expand:"Развернуть подсказку",
    },
    "en-US": {
        button_SelectFile:"Select file",
        label_FileUnselected:"File is not specified",
        button_Copied:"Copied",
        btn_text_helper_hide:"Hide tooltip",
        btn_text_helper_expand:"Expand tooltip",
    }
};

const handleTextHelperBtnClick = function() {
    $('.question-text-helper-button').click(function() {
        $(this).next().collapse('toggle');
    });

    $('.constructor__text-helper-content').on('show.bs.collapse', function () {
        $(this).prev().text(i18n[eqspCulture].btn_text_helper_hide);
    });

    $('.constructor__text-helper-content').on('hide.bs.collapse', function () {
        $(this).prev().text(i18n[eqspCulture].btn_text_helper_expand);
    });
};

jQuery(document).ready(function () {
    $(".full-screen").closest("body,html").css("overflow","hidden");

	$("input[type='checkbox'].js-ui-input").wrap("<label class='ui-label'></label>");
	$("input[type='radio'].js-ui-input").wrap("<label class='ui-label'></label>");
	$("input[type='file'].js-ui-input").wrap("<label class='ui-file'></label>");
	$('.ui-label').append('<span></span>');
	// $('.ui-file').append("<a class='btn btn-default ui-file-btn'><i class='fa fa-upload m-r-5' aria-hidden='true'></i>"+
    // i18n[eqspCulture].button_SelectFile+"</a><span id='input_file_value' class='m-l-10 m-r-10'>"+i18n[eqspCulture].label_FileUnselected+"</span>");
	// $("input[type='file']").change(function(){
	// 	$fileInputValue = $(this).val().split('\\').pop();
	// 	$('#input_file_value').text($fileInputValue);
	// });

    $(".diagram-property").each(function(){
        $(this).find(".btn-group").click(function () {
          $(this).parent().find(".btn-group").removeClass("active");
          $(this).addClass("active");
        });
        $(".reset-button").click(function () {
            $(this).parent().find(".btn-group").removeClass("active");
        });
    });

    //$(".second-buttons-group").each(function(){
    //    $(this).find(".input-button-holder").click(function () {
    //      $(this).parent().find(".btn-group").removeClass("active");
    //      $(this).find(".btn-group").addClass("active");
    //    });
    //});

    //$(".pages_holder .dropdown .btn.dropdown-toggle").text($(".pages li a[style='background:#C5C5C5']").text());
    //$(".pages_holder .dropdown .btn.dropdown-toggle").val($(".pages li a[style='background:#C5C5C5']").text());

    //$(".mainTab .dropdown .btn.dropdown-toggle").text($(".mainTab .nav-tabs > li.active .menu-item-name").text());
    //$(".mainTab .dropdown .btn.dropdown-toggle").val($(".mainTab .nav-tabs > li.active .menu-item-name").text());

    $(".k-tabstrip-wrapper .dropdown .btn.dropdown-toggle").text($(".k-tabstrip-wrapper .dropdown-menu li.k-active .k-link").text());
    $(".k-tabstrip-wrapper .dropdown .btn.dropdown-toggle").val($(".k-tabstrip-wrapper .dropdown-menu li.k-active .k-link").text());



    $(".dropdown-menu").on('click', 'li', function () {
        $(".dropdown .btn.dropdown-toggle").text($(this).text());
        $(".dropdown .btn.dropdown-toggle").val($(this).text());
    });

    $("#Category").change(function(){
        $(".category-name").text(': '+$('#Category option:selected').text());
    });

    /*show and hide password*/
    $(".js-toggle-visibility-btn").click(function () {
        const input = $(this).parent().parent().find(".js-toggle-visibility-input");
        const showIcon = $(this).find(".js-show-icon");
        const hideIcon = $(this).find(".js-hide-icon");

        if (input.attr("type") === "password") {
            input.attr("type", "text");
            showIcon.toggleClass("d-none");
            hideIcon.toggleClass("d-none");
        } else {
            input.attr("type", "password");
            showIcon.toggleClass("d-none");
            hideIcon.toggleClass("d-none");
        }
    });

    copyToClipboard();
    handleTextHelperBtnClick();

    var $affixElement = $('div[data-spy="affix"]');
    $affixElement.width($affixElement.parent().width());
    $(window).resize(function () {
      $affixElement.width($affixElement.parent().width());
    });
});

const copyToClipboard = function () {
    $('.copy-btn').not('.copy-btn-hidden').on('click', function () {
        var element = $(this).find('span');
        var oldText = element.text();

        element.text(i18n[eqspCulture].button_Copied);
        var copyText = setInterval(function () {
            element.text(oldText);
        }, 3000);
        new Clipboard('.copy-btn');
    });

    $('.copy-btn.copy-btn-hidden').on('click', function(){
        var element = $(this).find('span');
        var oldText = element.text();

        element.text(i18n[eqspCulture].button_Copied);
        var copyText = setInterval(function () {
            element.text(oldText);
        }, 3000);
        var inputhidden = $(this).next();
        new Clipboard('.copy-btn', {
                text: function (trigger) {
                    return inputhidden.val();
                }
        });
    });
};

if ($.fancybox) {
    $.fancybox.defaults.i18n.ru = {
        CLOSE: "Закрыть",
        NEXT: "След.",
        PREV: "Пред.",
        ERROR: "Запрашиваемый контент не может быть загружен. Пожалуйста, попробуйте позже.",
        PLAY_START: "Начать слайдшоу",
        PLAY_STOP: "Пауза",
        FULL_SCREEN: "На весь экран",
        THUMBS: "Миниатюры",
        DOWNLOAD: "Скачать",
        SHARE: "Поделиться",
        ZOOM: "Увеличить"
    };
}

// on top scroller
$(document).ready(function () {
    window.onscroll = function () {
        var windowHeight = $(window).height();
        var scrollHeight = $(document).scrollTop();

        if ((scrollHeight + windowHeight) > windowHeight) {
            $('.on-top-scroller').removeClass("d-none");
        } else {
            $('.on-top-scroller').addClass("d-none");
        }
    }
});
