﻿
CREATE OR REPLACE FUNCTION public.accessrights_getgrouppedaccessrightsbyuser(
    itemid uuid,
    userid uuid)
    RETURNS TABLE("CanRead" boolean, "CanUpdate" boolean, "CanDelete" boolean)
    LANGUAGE 'sql'

    COST 100
    VOLATILE
    ROWS 1000
AS $BODY$

SELECT
       ar."CanRead",
       ar."CanUpdate",
       ar."CanDelete"

FROM public."AccessRights" ar
         LEFT JOIN public."AspNetUsers" u ON u."Id"::uuid = ar."UserId" and ar."UserId"::uuid = userid
         LEFT JOIN public."AspNetUserRoles" ur on ur."UserId"::uuid = userid and ur."RoleId"::uuid = ar."RoleId"
         LEFT JOIN public."AspNetRoles" roles on roles."Id"::uuid = ar."RoleId"
         LEFT JOIN public."AspNetUsers" u2 on u2."Id" = ur."UserId"

WHERE ar."ObjectId" = itemid
  AND (
        (
            ar."RoleId" = '00000000-0000-0000-0000-000000000000'
             AND ar."UserId"= userid
        )
        OR
        (roles."NormalizedName" = 'UNAUTHORIZEDUSERS')
        OR
        (
            roles."NormalizedName" = 'REGISTEREDUSERS'
                and u2."IsEnabled" = true and u2."EmailConfirmed" = true
        )
        OR
        (
            roles."NormalizedName" <> 'REGISTEREDUSERS'
                and u2."IsEnabled" = true and u2."EmailConfirmed" = true
        )
    )

$BODY$;
