create table if not exists  "RespondentExtendedAnswersView"
as 
SELECT rea."Id",
    unnest(string_to_array(rea."AnswerId", ','::text)) AS "AnswerId",
    rea."AnswerValue",
    rea."Date",
    rea."ExtendedQuestionId",
    rer."RespondentId",
    rer."Id" AS "RecordId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rer."Id" = rea."RecordId"
  WHERE rea."AnswerValue" IS NULL 
UNION ALL
 SELECT rea."Id",
    rea."AnswerId",
    rea."AnswerValue",
    rea."Date",
    rea."ExtendedQuestionId",
    rer."RespondentId",
    rer."Id" AS "RecordId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rer."Id" = rea."RecordId"
  WHERE rea."AnswerValue" IS NOT NULL ;
---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentAnswersView"
 AS
 SELECT ra1."Id",
    ra1."AnswerValue",
    ra1."AnswerId",
    ra1."Points",
    ra1."QuestionId",
    ra1."RespondentId",
    ra1."Date",
    ra1."UserOwnAnswer",
    ra1.rownumber
   FROM ( SELECT ra."Id",
            ra."AnswerValue",
            ''::text AS "AnswerId",
            ra."Points",
            ra."QuestionId",
            ra."RespondentId",
            ra."Date",
            ra."UserOwnAnswer",
            row_number() OVER (ORDER BY ra."Id") AS rownumber
           FROM "RespondentAnswers" ra
          WHERE ra."AnswerValue" <> ''::text
        UNION ALL
         SELECT ra."Id",
            ra."AnswerValue",
            unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
            ra."Points",
            ra."QuestionId",
            ra."RespondentId",
            ra."Date",
            ra."UserOwnAnswer",
            row_number() OVER (ORDER BY ra."Id") AS rownumber
           FROM ( SELECT ra_1."Id",
                    ''::text AS "AnswerValue",
                    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                    ra_1."Points",
                    ra_1."QuestionId",
                    ra_1."RespondentId",
                    ra_1."Date",
                    ra_1."UserOwnAnswer",
                    row_number() OVER (ORDER BY ra_1."Id") AS rownumber
                   FROM "RespondentAnswers" ra_1
                  WHERE ra_1."AnswerId" <> ''::text) ra) ra1
  WHERE (ra1."AnswerId" <> ''::text OR ra1."AnswerValue" <> ''::text);
  ---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentAnswersTableQuestionView"
 AS
 SELECT ra."Id",
    ''::text AS "AnswerValue",
    unnest(string_to_array(ra."AnswerId", '='::text)) AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM ( SELECT ra_1."Id",
            ''::text AS "AnswerValue",
            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
            ra_1."Points",
            ra_1."QuestionId",
            ra_1."RespondentId",
            ra_1."Date",
            row_number() OVER (ORDER BY ra_1."Id") AS rownumber
           FROM ( SELECT ra_2."Id",
                    ra_2."AnswerId",
                    ''::text AS "AnswerValue",
                    ra_2."Points",
                    ra_2."QuestionId",
                    ra_2."RespondentId",
                    ra_2."Date",
                    row_number() OVER (ORDER BY ra_2."Id") AS rownumber
                   FROM "RespondentAnswers" ra_2
                  WHERE ra_2."AnswerId" ~~ '%;%'::text) ra_1
          WHERE ra_1."AnswerId" <> ''::text) ra;
  ---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentAnswersReview_Table"
 AS
 SELECT aotr."QuestionId" AS "Id",
    string_agg(aotr."AnswerValue", '</br>'::text) AS "AnswerValue",
    aotr."Points",
    aotr."QuestionId",
    aotr."RespondentId",
    aotr."Date",
    aotr."ExpertComment",
    aotr."QuestionText",
    aotr."QuestionnaireId",
    aotr."QuestionId"::text AS "Unique"
   FROM ( SELECT aot."Id",
            string_agg(aot."AnswerValue", ' - '::text) AS "AnswerValue",
            aot."Points",
            aot."QuestionId",
            aot."RespondentId",
            aot."Date",
            aot.rownumber,
            aot."ExpertComment",
            aot."QuestionText",
            aot."QuestionnaireId"
           FROM ( SELECT tablesanswers."Id",
                    tablesanswers."AnswerId",
                        CASE
                            WHEN ao."TextA" IS NULL THEN ao2."TextB"
                            ELSE ao."TextA"
                        END AS "AnswerValue",
                    tablesanswers."Points",
                    tablesanswers."QuestionId",
                    tablesanswers."RespondentId",
                    tablesanswers."Date",
                    tablesanswers.rownumber,
                        CASE
                            WHEN ao."Message" IS NULL THEN ao2."Message"
                            ELSE ao."Message"
                        END AS "ExpertComment",
                    tablesanswers."QuestionText",
                    tablesanswers."QuestionnaireId"
                   FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                            ra."AnswerValue",
                            unnest(string_to_array(ra."AnswerId", '='::text)) AS "AnswerId",
                            ra."Points",
                            ra."QuestionId",
                            ra."RespondentId",
                            ra."Date",
                            row_number() OVER (ORDER BY ra."Id") AS rownumber,
                            ra."ExpertComment",
                            ra."Text" AS "QuestionText",
                            ra."QuestionnaireId"
                           FROM ( SELECT ra_1."Id",
                                    ''::text AS "AnswerValue",
                                    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                                    ra_1."Points",
                                    ra_1."QuestionId",
                                    ra_1."RespondentId",
                                    ra_1."Date",
                                    row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                                    ''::text AS "ExpertComment",
                                    q."Text",
                                    q."QuestionnaireId"
                                   FROM "RespondentAnswers" ra_1
                                     JOIN "Questions" q ON q."Id" = ra_1."QuestionId"
                                  WHERE ra_1."AnswerId" <> ''::text AND ra_1."AnswerId" ~~ (('%'::text || '='::text) || '%'::text)) ra) tablesanswers
                     LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = tablesanswers."AnswerId"
                     LEFT JOIN "AnswerOptions" ao2 ON ao2."PublicBId" = tablesanswers."AnswerId") aot
          GROUP BY aot."Id", aot."Points", aot."QuestionId", aot."RespondentId", aot."Date", aot.rownumber, aot."ExpertComment", aot."QuestionText", aot."QuestionnaireId"
          ORDER BY aot.rownumber) aotr	 
  GROUP BY aotr."QuestionId", aotr."Points", aotr."RespondentId", aotr."Date", aotr."ExpertComment", aotr."QuestionText", aotr."QuestionnaireId";
 ---------------------------------------------------------------------------------------------------------------------------------
 
 CREATE table  if not exists  public."RespondentAnswersReview_Simple"
 AS
 SELECT ra."QuestionId" AS "Id",
    ra."AnswerValue",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    ''::text AS "ExpertComment",
    q."Text" AS "QuestionText",
    q."QuestionnaireId",
    ra."QuestionId"::text AS "Unique"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE ra."AnswerValue" <> ''::text;
  ---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentAnswersReview_Multy"
 AS
 SELECT aom."QuestionId" AS "Id",
    strip_tags(string_agg(aom."AnswerValue", ', '::text)) AS "AnswerValue",
    aom."Points",
    aom."QuestionId",
    aom."RespondentId",
    aom."Date",
    aom."ExpertComment",
    strip_tags(aom."QuestionText") AS "QuestionText",
    aom."QuestionnaireId",
    aom."QuestionId"::text AS "Unique"
   FROM ( SELECT respanswers."Id",
            respanswers."AnswerId",
            ao."Text" AS "AnswerValue",
            respanswers."Points",
            respanswers."QuestionId",
            respanswers."RespondentId",
            respanswers."Date",
            respanswers.rownumber,
            ao."Message" AS "ExpertComment",
            respanswers."QuestionText",
            respanswers."QuestionnaireId"
           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                    ra."AnswerValue",
                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                    ra."Points",
                    ra."QuestionId",
                    ra."RespondentId",
                    ra."Date",
                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                    ra."ExpertComment",
                    ra."Text" AS "QuestionText",
                    ra."QuestionnaireId"
                   FROM ( SELECT ra_1."Id",
                            ''::text AS "AnswerValue",
                            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                            ra_1."Points",
                            ra_1."QuestionId",
                            ra_1."RespondentId",
                            ra_1."Date",
                            row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                            ''::text AS "ExpertComment",
                            q."Text",
                            q."QuestionnaireId"
                           FROM "RespondentAnswers" ra_1
                             JOIN "Questions" q ON q."Id" = ra_1."QuestionId"
                          WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
             JOIN "AnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId";
  ---------------------------------------------------------------------------------------------------------------------------------  
 CREATE table if not exists  public."RespondentAnswersReview_Extended"
 AS
 SELECT ra."ExtendedQuestionId" AS "Id",
    ra."AnswerValue",
    0 AS "Points",
    ra."ExtendedQuestionId",
    ra."RespondentId",
    ra."Date",
    ''::text AS "ExpertComment",
    q."Text" AS "QuestionText",
    qq."QuestionnaireId",
    ra."ExtendedQuestionId"::text || ra."RecordId"::text AS "Unique"
   FROM "RespondentExtendedAnswersView" ra
     JOIN "ExtendedQuestions" q ON q."Id" = ra."ExtendedQuestionId"
     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
  WHERE ra."AnswerValue" <> ''::text
UNION
 SELECT aom."QuestionId" AS "Id",
    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
    aom."Points",
    aom."QuestionId" AS "ExtendedQuestionId",
    aom."RespondentId",
    aom."Date",
    aom."ExpertComment",
    aom."QuestionText",
    aom."QuestionnaireId",
    aom."QuestionId"::text || aom."RecordId"::text AS "Unique"
   FROM ( SELECT respanswers."Id",
            respanswers."AnswerId",
            ao."Text" AS "AnswerValue",
            respanswers."Points",
            respanswers."QuestionId",
            respanswers."RespondentId",
            respanswers."Date",
            respanswers.rownumber,
            respanswers."ExpertComment",
            respanswers."QuestionText",
            respanswers."QuestionnaireId",
            respanswers."RecordId"
           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                    ra."AnswerValue",
                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                    ra."Points",
                    ra."ExtendedQuestionId" AS "QuestionId",
                    ra."RespondentId",
                    ra."Date",
                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                    ra."ExpertComment",
                    ra."Text" AS "QuestionText",
                    ra."QuestionnaireId",
                    ra."RecordId"
                   FROM ( SELECT ra_1."Id",
                            ''::text AS "AnswerValue",
                            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                            0 AS "Points",
                            ra_1."ExtendedQuestionId",
                            ra_1."RespondentId",
                            ra_1."Date",
                            row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                            ''::text AS "ExpertComment",
                            q."Text",
                            qq."QuestionnaireId",
                            ra_1."RecordId"
                           FROM "RespondentExtendedAnswersView" ra_1
                             JOIN "ExtendedQuestions" q ON q."Id" = ra_1."ExtendedQuestionId"
                             JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
                          WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
             JOIN "ExtendedAnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId", aom."RecordId";
   ---------------------------------------------------------------------------------------------------------------------------------  
CREATE table if not exists  public."RespondentAnswersReviewStimulsoft"
 AS
 SELECT "RespondentAnswersReview_Simple"."Id",
    "RespondentAnswersReview_Simple"."AnswerValue",
    "RespondentAnswersReview_Simple"."Points",
    "RespondentAnswersReview_Simple"."QuestionId",
    "RespondentAnswersReview_Simple"."RespondentId",
    "RespondentAnswersReview_Simple"."Date",
    "RespondentAnswersReview_Simple"."ExpertComment",
    "RespondentAnswersReview_Simple"."QuestionText",
    "RespondentAnswersReview_Simple"."QuestionnaireId"
   FROM "RespondentAnswersReview_Simple"
UNION ALL
 SELECT "RespondentAnswersReview_Multy"."Id",
    "RespondentAnswersReview_Multy"."AnswerValue",
    "RespondentAnswersReview_Multy"."Points",
    "RespondentAnswersReview_Multy"."QuestionId",
    "RespondentAnswersReview_Multy"."RespondentId",
    "RespondentAnswersReview_Multy"."Date",
    "RespondentAnswersReview_Multy"."ExpertComment",
    "RespondentAnswersReview_Multy"."QuestionText",
    "RespondentAnswersReview_Multy"."QuestionnaireId"
   FROM "RespondentAnswersReview_Multy"
UNION ALL
 SELECT "RespondentAnswersReview_Table"."Id",
    "RespondentAnswersReview_Table"."AnswerValue",
    "RespondentAnswersReview_Table"."Points",
    "RespondentAnswersReview_Table"."QuestionId",
    "RespondentAnswersReview_Table"."RespondentId",
    "RespondentAnswersReview_Table"."Date",
    "RespondentAnswersReview_Table"."ExpertComment",
    "RespondentAnswersReview_Table"."QuestionText",
    "RespondentAnswersReview_Table"."QuestionnaireId"
   FROM "RespondentAnswersReview_Table";
---------------------------------------------------------------------------------------------------------------------------------  
CREATE table if not exists  public."RespondentAnswers_Matrix"
 AS
 SELECT total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    array_to_string(array_agg(total_drop."AnswerValue"), '</br>'::text) AS "AnswerValue",
    total_drop."QuestionId",
	total_drop."Date"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            0 AS "Points",
            ra."Date",
            (eq."Text" || '-'::text) || ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentMatrixAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerOptionId"::text
             JOIN "ExtendedQuestions" eq ON eq."Id" = ra."ExtendedQuestionId"
          WHERE q."Type" ~~ '%matrix%'::text
          ORDER BY ra.*, ra."RespondentId", eq."OrderId") total_drop
  GROUP BY total_drop."RespondentId", total_drop."QuestionText", total_drop."Points", total_drop."QuestionId",total_drop."Date";   
---------------------------------------------------------------------------------------------------------------------------------  
CREATE table if not exists  public."RespondentAnswersReviewStimulsoftWithTable"
 AS
 SELECT array_to_string(array_agg(agg."AnswerValue"), '</br>'::text) AS "AnswerValue",
    agg."RespondentId",
    agg."QuestionnaireId",
    agg."ParentQuestionId" AS "QuestionId",
    agg."Points",
	agg."Date"
   FROM ( SELECT array_to_string(array_agg((((('<div>'::text || ex."QuestionText") || '<p>'::text) || ex."AnswerValue") || '</p>'::text) || '</div>'::text), '</br>'::text) AS "AnswerValue",
            ex."RespondentId",
            ex."QuestionnaireId",
            ex."RecordId",
            ex."ParentQuestionId",
            ex."Points",
		 ex."Date"
           FROM ( SELECT ra."ExtendedQuestionId" AS "Id",
                    ra."AnswerValue",
                    0 AS "Points",
                    ra."ExtendedQuestionId",
                    ra."RespondentId",
                    ra."Date",
                    ''::text AS "ExpertComment",
                    q."Text" AS "QuestionText",
                    qq."QuestionnaireId",
                    ra."RecordId",
                    q."ParentQuestionId"
                   FROM "RespondentExtendedAnswersView" ra
                     JOIN "ExtendedQuestions" q ON q."Id" = ra."ExtendedQuestionId"
                     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
                  WHERE ra."AnswerValue" <> ''::text
                UNION
                 SELECT aom."QuestionId" AS "Id",
                    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
                    aom."Points",
                    aom."QuestionId" AS "ExtendedQuestionId",
                    aom."RespondentId",
                    aom."Date",
                    aom."ExpertComment",
                    aom."QuestionText",
                    aom."QuestionnaireId",
                    aom."RecordId",
                    aom."ParentQuestionId"
                   FROM ( SELECT respanswers."Id",
                            respanswers."AnswerId",
                            ao."Text" AS "AnswerValue",
                            respanswers."Points",
                            respanswers."QuestionId",
                            respanswers."RespondentId",
                            respanswers."Date",
                            respanswers.rownumber,
                            respanswers."ExpertComment",
                            respanswers."QuestionText",
                            respanswers."QuestionnaireId",
                            respanswers."RecordId",
                            respanswers."ParentQuestionId"
                           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                                    ra."AnswerValue",
                                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                                    ra."Points",
                                    ra."ExtendedQuestionId" AS "QuestionId",
                                    ra."RespondentId",
                                    ra."Date",
                                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                                    ra."ExpertComment",
                                    ra."Text" AS "QuestionText",
                                    ra."QuestionnaireId",
                                    ra."RecordId",
                                    ra."ParentQuestionId"
                                   FROM ( SELECT ra_1."Id",
    ''::text AS "AnswerValue",
    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
    0 AS "Points",
    ra_1."ExtendedQuestionId",
    ra_1."RespondentId",
    ra_1."Date",
    row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
    ''::text AS "ExpertComment",
    q."Text",
    qq."QuestionnaireId",
    ra_1."RecordId",
    q."ParentQuestionId"
   FROM "RespondentExtendedAnswersView" ra_1
     JOIN "ExtendedQuestions" q ON q."Id" = ra_1."ExtendedQuestionId"
     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
  WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
                             JOIN "ExtendedAnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
                  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId", aom."RecordId", aom."ParentQuestionId") ex
          GROUP BY ex."RespondentId", ex."QuestionnaireId", ex."RecordId", ex."ParentQuestionId", ex."Points", ex."Date") agg
  GROUP BY agg."RespondentId", agg."QuestionnaireId", agg."ParentQuestionId", agg."Points", agg."Date"
UNION ALL
 SELECT ravs."AnswerValue",
    ravs."RespondentId",
    ravs."QuestionnaireId",
    ravs."QuestionId",
    ravs."Points",
	ravs."Date"
   FROM "RespondentAnswersReviewStimulsoft" ravs
UNION ALL
 SELECT ram."AnswerValue",
    ram."RespondentId",
    q."QuestionnaireId",
    ram."QuestionId",
    ram."Points",
	ram."Date"
   FROM "RespondentAnswers_Matrix" ram
     JOIN "Questions" q ON q."Id" = ram."QuestionId";
---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentAnswers_Single"
 AS
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    ao."Text" AS "AnswerValue",
    ra."AnswerId",
    ''::text AS "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
     JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
  WHERE q."Type" ~~ '%single%'::text
UNION
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    ra."AnswerValue",
    ra."AnswerId",
    ra."AnswerValue" AS "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text;
  ---------------------------------------------------------------------------------------------------------------------------------  
CREATE table if not exists  public."RespondentAnswers_Multy"
 AS
 SELECT total_multy."Id",
    total_multy."RespondentId",
    total_multy."QuestionText",
    total_multy."Points",
    total_multy."Date",
    total_multy."AnswerValue",
    total_multy."AnswerId",
    total_multy."UserOwnAnswer",
    total_multy."QuestionId"
   FROM ( SELECT multy."Id",
            multy."RespondentId",
            q."Text" AS "QuestionText",
            multy."Points",
            multy."Date",
            ao."Text" AS "AnswerValue",
            multy."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM ( SELECT ra_split."Id",
                    ra_split."RespondentId",
                    ra_split."QuestionId",
                    ra_split."Points",
                    ra_split."Date",
                    ra_split."AnswerId",
                    ra_split."AnswerValue"
                   FROM ( SELECT ra_m."Id",
                            ra_m."RespondentId",
                            ra_m."QuestionId",
                            ra_m."Points",
                            ra_m."Date",
                            unnest(string_to_array(ra_m."AnswerId", ','::text)) AS "AnswerId",
                            ra_m."AnswerValue"
                           FROM ( SELECT ra."Id",
                                    ra."RespondentId",
                                    ra."QuestionId",
                                    ra."Points",
                                    ra."Date",
                                    ra."AnswerId",
                                    ra."AnswerValue"
                                   FROM "RespondentAnswers" ra
                                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                                  WHERE q_1."Type" ~~ '%multy%'::text) ra_m) ra_split
                  WHERE ra_split."AnswerId" <> ''::text) multy
             JOIN "Questions" q ON q."Id" = multy."QuestionId"
             LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = multy."AnswerId"
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ''::text AS "AnswerId",
            ra."AnswerValue" AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%multy%'::text AND ra."AnswerValue" <> ''::text) total_multy;
---------------------------------------------------------------------------------------------------------------------------------  
CREATE Table if not exists  public."RespondentAnswers_Inputs"
 AS
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    ra."AnswerValue",
    ra."AnswerId",
    ''::text AS "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" !~~ '%single%'::text AND q."Type" !~~ '%file%'::text AND q."Type" !~~ '%multy%'::text AND q."Type" !~~ '%table%'::text AND q."Type" !~~ '%dropdown%'::text AND q."Type" !~~ '%extended%'::text;
---------------------------------------------------------------------------------------------------------------------------------  
CREATE Table if not exists  public."RespondentAnswers_Files"
 AS
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    '/answerfiles/'::text || ra."AnswerValue" AS "AnswerValue",
    ra."AnswerId",
    ''::text AS "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" ~~ '%file%'::text;
---------------------------------------------------------------------------------------------------------------------------------  
CREATE Table if not exists  public."RespondentAnswers_Dropdown"
 AS
 SELECT total_drop."Id",
    total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    total_drop."Date",
    total_drop."AnswerValue",
    total_drop."AnswerId",
    total_drop."UserOwnAnswer",
    total_drop."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%dropdown%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."AnswerValue" AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%dropdown%'::text AND ra."AnswerValue" <> ''::text) total_drop
  ORDER BY total_drop."RespondentId", total_drop."AnswerValue"; 
 ---------------------------------------------------------------------------------------------------------------------------------  
CREATE Table if not exists  public."Respondents_Answers"
AS
 SELECT total."Id",
    total."RespondentId",
    strip_tags(total."QuestionText") AS "QuestionText",
    total."Points",
    total."Date",
    strip_tags(total."AnswerValue") AS "AnswerValue",
    total."AnswerId",
    total."UserOwnAnswer",
    total."QuestionId"
   FROM ( SELECT "RespondentAnswers_Single"."Id",
            "RespondentAnswers_Single"."RespondentId",
            "RespondentAnswers_Single"."QuestionText",
            "RespondentAnswers_Single"."Points",
            "RespondentAnswers_Single"."Date",
            "RespondentAnswers_Single"."AnswerValue",
            "RespondentAnswers_Single"."AnswerId",
            "RespondentAnswers_Single"."UserOwnAnswer",
            "RespondentAnswers_Single"."QuestionId"
           FROM "RespondentAnswers_Single"
        UNION
         SELECT "RespondentAnswers_Multy"."Id",
            "RespondentAnswers_Multy"."RespondentId",
            "RespondentAnswers_Multy"."QuestionText",
            "RespondentAnswers_Multy"."Points",
            "RespondentAnswers_Multy"."Date",
            "RespondentAnswers_Multy"."AnswerValue",
            "RespondentAnswers_Multy"."AnswerId",
            "RespondentAnswers_Multy"."UserOwnAnswer",
            "RespondentAnswers_Multy"."QuestionId"
           FROM "RespondentAnswers_Multy"
        UNION
         SELECT "RespondentAnswers_Dropdown"."Id",
            "RespondentAnswers_Dropdown"."RespondentId",
            "RespondentAnswers_Dropdown"."QuestionText",
            "RespondentAnswers_Dropdown"."Points",
            "RespondentAnswers_Dropdown"."Date",
            "RespondentAnswers_Dropdown"."AnswerValue",
            "RespondentAnswers_Dropdown"."AnswerId",
            "RespondentAnswers_Dropdown"."UserOwnAnswer",
            "RespondentAnswers_Dropdown"."QuestionId"
           FROM "RespondentAnswers_Dropdown"
        UNION
         SELECT "RespondentAnswers_Files"."Id",
            "RespondentAnswers_Files"."RespondentId",
            "RespondentAnswers_Files"."QuestionText",
            "RespondentAnswers_Files"."Points",
            "RespondentAnswers_Files"."Date",
            "RespondentAnswers_Files"."AnswerValue",
            "RespondentAnswers_Files"."AnswerId",
            "RespondentAnswers_Files"."UserOwnAnswer",
            "RespondentAnswers_Files"."QuestionId"
           FROM "RespondentAnswers_Files"
        UNION
         SELECT "RespondentAnswers_Inputs"."Id",
            "RespondentAnswers_Inputs"."RespondentId",
            "RespondentAnswers_Inputs"."QuestionText",
            "RespondentAnswers_Inputs"."Points",
            "RespondentAnswers_Inputs"."Date",
            "RespondentAnswers_Inputs"."AnswerValue",
            "RespondentAnswers_Inputs"."AnswerId",
            "RespondentAnswers_Inputs"."UserOwnAnswer",
            "RespondentAnswers_Inputs"."QuestionId"
           FROM "RespondentAnswers_Inputs") total
  ORDER BY total."RespondentId", total."AnswerValue"; 
---------------------------------------------------------------------------------------------------------------------------------
CREATE table if not exists  public."RespondentExtendedAnswers_Files"
 AS
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    rea."AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
  WHERE eq."Type" ~~ '%file%'::text;
---------------------------------------------------------------------------------------------------------------------------------
CREATE table  if not exists public."RespondentExtendedAnswers_Inputs"
 AS
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    rea."AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
  WHERE eq."Type" ~~ '%input%'::text; 
---------------------------------------------------------------------------------------------------------------------------------
CREATE Table if not exists  public."RespondentExtendedAnswers_Multy"
 AS
 SELECT table_multy."Id",
    table_multy."RecordId",
    table_multy."RecordName",
    table_multy."RespondentId",
    table_multy."Date",
    eao."Text" AS "AnswerValue",
    table_multy."ParentQuestionText",
    table_multy."ParentQuestionId",
    table_multy."QuestionText",
    table_multy."QuestionId"
   FROM ( SELECT rea."Id",
            rea."RecordId",
            rer."Name" AS "RecordName",
            rer."RespondentId",
            rea."Date",
            unnest(string_to_array(rea."AnswerId", ','::text)) AS "AnswerId",
            q."Text" AS "ParentQuestionText",
            eq."ParentQuestionId",
            eq."Text" AS "QuestionText",
            eq."Id" AS "QuestionId"
           FROM "RespondentExtendedAnswers" rea
             JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
             JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
             JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
          WHERE eq."Type" ~~ '%multy%'::text) table_multy
     JOIN "ExtendedAnswerOptions" eao ON eao."Id"::text = table_multy."AnswerId";	 
---------------------------------------------------------------------------------------------------------------------------------
---что-то странное с удалением, но должно работать
CREATE  Table if not exists  public."RespondentExtendedAnswers_Single"
 AS
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    eao."Text" AS "AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
     JOIN "ExtendedAnswerOptions" eao ON eao."Id"::text = rea."AnswerId"
  WHERE eq."Type" ~~ '%dropdown%'::text;
---------------------------------------------------------------------------------------------------------------------------------
CREATE  Table if not exists  public."Respondents_ExtendedAnswers"
AS
 SELECT total."Id",
    total."RecordId",
    total."RecordName",
    total."RespondentId",
    total."Date",
    total."AnswerValue",
    strip_tags(total."ParentQuestionText") AS "ParentQuestionText",
    total."ParentQuestionId",
    strip_tags(total."QuestionText") AS "QuestionText",
    total."QuestionId"
   FROM ( SELECT "RespondentExtendedAnswers_Inputs"."Id",
            "RespondentExtendedAnswers_Inputs"."RecordId",
            "RespondentExtendedAnswers_Inputs"."RecordName",
            "RespondentExtendedAnswers_Inputs"."RespondentId",
            "RespondentExtendedAnswers_Inputs"."Date",
            "RespondentExtendedAnswers_Inputs"."AnswerValue",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionText",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionId",
            "RespondentExtendedAnswers_Inputs"."QuestionText",
            "RespondentExtendedAnswers_Inputs"."QuestionId"
           FROM "RespondentExtendedAnswers_Inputs"
        UNION
         SELECT "RespondentExtendedAnswers_Files"."Id",
            "RespondentExtendedAnswers_Files"."RecordId",
            "RespondentExtendedAnswers_Files"."RecordName",
            "RespondentExtendedAnswers_Files"."RespondentId",
            "RespondentExtendedAnswers_Files"."Date",
            "RespondentExtendedAnswers_Files"."AnswerValue",
            "RespondentExtendedAnswers_Files"."ParentQuestionText",
            "RespondentExtendedAnswers_Files"."ParentQuestionId",
            "RespondentExtendedAnswers_Files"."QuestionText",
            "RespondentExtendedAnswers_Files"."QuestionId"
           FROM "RespondentExtendedAnswers_Files"
        UNION
         SELECT "RespondentExtendedAnswers_Multy"."Id",
            "RespondentExtendedAnswers_Multy"."RecordId",
            "RespondentExtendedAnswers_Multy"."RecordName",
            "RespondentExtendedAnswers_Multy"."RespondentId",
            "RespondentExtendedAnswers_Multy"."Date",
            "RespondentExtendedAnswers_Multy"."AnswerValue",
            "RespondentExtendedAnswers_Multy"."ParentQuestionText",
            "RespondentExtendedAnswers_Multy"."ParentQuestionId",
            "RespondentExtendedAnswers_Multy"."QuestionText",
            "RespondentExtendedAnswers_Multy"."QuestionId"
           FROM "RespondentExtendedAnswers_Multy"
        UNION
         SELECT "RespondentExtendedAnswers_Single"."Id",
            "RespondentExtendedAnswers_Single"."RecordId",
            "RespondentExtendedAnswers_Single"."RecordName",
            "RespondentExtendedAnswers_Single"."RespondentId",
            "RespondentExtendedAnswers_Single"."Date",
            "RespondentExtendedAnswers_Single"."AnswerValue",
            "RespondentExtendedAnswers_Single"."ParentQuestionText",
            "RespondentExtendedAnswers_Single"."ParentQuestionId",
            "RespondentExtendedAnswers_Single"."QuestionText",
            "RespondentExtendedAnswers_Single"."QuestionId"
           FROM "RespondentExtendedAnswers_Single") total
  ORDER BY total."RespondentId", total."RecordId", total."AnswerValue";  
---------------------------------------------------------------------------------------------------------------------------------
CREATE Table if not exists  public."RespondentAnswers_Match"
AS
 SELECT match."Id",
    match."RespondentId",
    q."Text" AS "QuestionText",
    match."Points",
    match."Date",
    ao1."TextA" AS "LeftSide",
    ao2."TextB" AS "RightSide",
    q."Id" AS "QuestionId"
   FROM ( SELECT ra_split."Id",
            ra_split."RespondentId",
            ra_split."QuestionId",
            ra_split."Points",
            ra_split."Date",
            split_part(ra_split."AnswerId", '='::text, 1) AS "LeftPart",
            split_part(ra_split."AnswerId", '='::text, 2) AS "RigthPart"
           FROM ( SELECT ra."Id",
                    ra."RespondentId",
                    ra."QuestionId",
                    ra."Points",
                    ra."Date",
                    unnest(string_to_array(ra."AnswerId", ';'::text)) AS "AnswerId"
                   FROM "RespondentAnswers" ra
                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                  WHERE q_1."Type" ~~ '%table%'::text) ra_split
          WHERE ra_split."AnswerId" <> ''::text) match
     JOIN "AnswerOptions" ao1 ON ao1."Id"::text = match."LeftPart"
     JOIN "AnswerOptions" ao2 ON ao2."PublicBId" = match."RigthPart"
     JOIN "Questions" q ON q."Id" = match."QuestionId";
---------------------------------------------------------------------------------------------------------------------------------
CREATE Table if not exists  public."RespondentMatrixAnswersView"
AS
 SELECT rma."Id",
    rma."QuestionId"::text AS "QuestionId",
    rma."ExtendedQuestionId"::text AS "ExtendedQuestionId",
    rma."AnswerOptionId"::text AS "AnswerOptionId",
    rma."RespondentId",
    rma."Date",
    strip_tags(q."Text") AS "ParentQuestionText",
    strip_tags(eq."Text") AS "QuestionText",
    strip_tags(ao."Text") AS "AnswerText"
   FROM "RespondentMatrixAnswers" rma
     JOIN "Questions" q ON rma."QuestionId" = q."Id"
     JOIN "ExtendedQuestions" eq ON rma."ExtendedQuestionId" = eq."Id"
     JOIN "AnswerOptions" ao ON rma."AnswerOptionId" = ao."Id";
--------------------------------------------------------------------------------------------------------------------------------- 