﻿CREATE OR REPLACE VIEW public."RespondentAnswers_Dropdown" AS 
 SELECT total_drop."Id",
    total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    total_drop."Date",
    total_drop."AnswerValue",
    total_drop."AnswerId",
    total_drop."UserOwnAnswer",
    total_drop."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%dropdown%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%dropdown%'::text AND ra."AnswerValue" <> ''::text) total_drop
  ORDER BY total_drop."RespondentId", total_drop."AnswerValue";

  CREATE OR REPLACE VIEW public."RespondentAnswers_Multy" AS 
 SELECT total_multy."Id",
    total_multy."RespondentId",
    total_multy."QuestionText",
    total_multy."Points",
    total_multy."Date",
    total_multy."AnswerValue",
    total_multy."AnswerId",
    total_multy."UserOwnAnswer",
    total_multy."QuestionId"
   FROM ( SELECT multy."Id",
            multy."RespondentId",
            q."Text" AS "QuestionText",
            multy."Points",
            multy."Date",
            ao."Text" AS "AnswerValue",
            multy."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM ( SELECT ra_split."Id",
                    ra_split."RespondentId",
                    ra_split."QuestionId",
                    ra_split."Points",
                    ra_split."Date",
                    ra_split."AnswerId",
                    ra_split."AnswerValue"
                   FROM ( SELECT ra_m."Id",
                            ra_m."RespondentId",
                            ra_m."QuestionId",
                            ra_m."Points",
                            ra_m."Date",
                            unnest(string_to_array(ra_m."AnswerId", ','::text)) AS "AnswerId",
                            ra_m."AnswerValue"
                           FROM ( SELECT ra."Id",
                                    ra."RespondentId",
                                    ra."QuestionId",
                                    ra."Points",
                                    ra."Date",
                                    ra."AnswerId",
                                    ra."AnswerValue"
                                   FROM "RespondentAnswers" ra
                                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                                  WHERE q_1."Type" ~~ '%multy%'::text) ra_m) ra_split
                  WHERE ra_split."AnswerId" <> ''::text) multy
             JOIN "Questions" q ON q."Id" = multy."QuestionId"
             LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = multy."AnswerId"
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ''::text AS "AnswerId",
            ra."UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%multy%'::text AND ra."AnswerValue" <> ''::text) total_multy
  ORDER BY total_multy."RespondentId", total_multy."AnswerValue";
CREATE OR REPLACE VIEW public."RespondentAnswers_Single" AS 
 SELECT total_single."Id",
    total_single."RespondentId",
    strip_tags(total_single."QuestionText") AS "QuestionText",
    total_single."Points",
    total_single."Date",
    strip_tags(total_single."AnswerValue") AS "AnswerValue",
    total_single."AnswerId",
    total_single."UserOwnAnswer",
    total_single."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%single%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text) total_single
  ORDER BY total_single."RespondentId", total_single."AnswerValue";