DROP VIEW public."RespondentAnswersView" CASCADE;
CREATE OR REPLACE VIEW public."RespondentAnswersView" AS 
select * from  (SELECT ra."Id",
    ra."AnswerValue",
    ''::text AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date", 
    ra."UserOwnAnswer",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM "RespondentAnswers" ra
  WHERE ra."AnswerValue" <> ''::text
UNION ALL
 SELECT ra."Id",
    ra."AnswerValue",
    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    ra."UserOwnAnswer",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM ( SELECT ra_1."Id",
            ''::text AS "AnswerValue",
            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
            ra_1."Points",
            ra_1."QuestionId",
            ra_1."RespondentId",
            ra_1."Date",
            ra_1."UserOwnAnswer",
            row_number() OVER (ORDER BY ra_1."Id") AS rownumber
           FROM "RespondentAnswers" ra_1
          WHERE ra_1."AnswerId" <> ''::text) ra) ra1
where ra1."AnswerId" <>'' or ra1."AnswerValue"<>'';