﻿function DisableControls() {
    $('button[data-pageid]').addClass('no-active');
    $('button[data-questionid]').addClass('no-active');
}

function EnableControls() {
    $('button[data-pageid]').removeClass('no-active');
    $('button[data-questionid]').removeClass('no-active');
}

function IsInt(value) {
    return value % 1 == 0;
}

function checkDate(elem) {
    var container = elem.closest('div.question_wrapper');
    var pattern = /^([0-9]{2}).([0-9]{2}).([0-9]{4})$/;
    if (elem.val() != "" && !elem.val().match(pattern)) {
        container.addClass("required");
        container.find(".invalid_text").html(eqspI18nRun.message_IncorrectDate);
    } else {
        container.removeAttr("invalid");
        container.find(".invalid_text").html("");
        container.removeClass("required");
    }
}

function GetAnswerText(container) {
    if (container.selectedIndex != undefined)
        return container.options[container.selectedIndex].text;
    else
        if ($(container).find("input").data("kendoMaskedTextBox") != undefined)
            return $(container).find("input").data("kendoMaskedTextBox").value()
    if ($(container).find("input").data("kendoDatePicker") != undefined)
        return $(container).find("input").data("kendoDatePicker").element[0].value;
    else
        return $(container).val();
}

function GetExtendedQuestionInfoObject(questionContainer) {
    var extendedQuestionId = questionContainer.data("extendedquestionid");
    var type = questionContainer.data("questiontype");
    var respondentAnswerId = questionContainer.data("respondentextendedanswerid");
    return {
        extendedQuestionInfo: extendedQuestionId + ":" + type + ":" + respondentAnswerId
    };
}

function GetQuestionInfoObject(questionContainer) {
    var questionId = questionContainer.data("questionid");
    var type = questionContainer.data("questiontype");
    var respondentAnswerId = questionContainer.data("respondentanswerid");
    return {
        questionId: questionId + ":" + type + ":" + respondentAnswerId
    };
}

function GetExtendedQuestionRecordInfo(questionContainer) {
    var res = GetQuestionInfoObject(questionContainer);

    var questionId = questionContainer.data("questionid");
    var checked = questionContainer.find(".record_container:has(.local_container)");
    if (!checked.length) {
        if (questionContainer.data("isrequired"))
            return {
                required: true,
                questionId: questionId
            }
        else {
            res.questionId += ":notanswered";
            return res;
        }
    }
}

function ShowMessages(data) {
    for (var i = 0; i < data.Messages.length; i++) {
        switch (data.Messages[i].Type) {
            case "test_table":
                var wrapperA = $('li[data-aoptionid="' + data.Messages[i].AnswerOptionsId + '"]');
                var wrapperB = $('li[data-boptionid="' + data.Messages[i].AnswerOptionBId + '"]');
                if (data.Messages[i].IsTrue) {
                    wrapperA.addClass("true_answer");
                    wrapperB.addClass("true_answer");
                    wrapperA.next(".message").addClass('true_answer_msg');
                    ($('<div class="message true_answer_msg">').html(data.Messages[i].Message)).insertAfter(wrapperB);
                } else {
                    wrapperA.addClass("false_answer");
                    wrapperB.addClass("false_answer");
                    wrapperA.next(".message").addClass('false_answer_msg');
                    ($('<div class="message false_answer_msg">').html(data.Messages[i].Message)).insertAfter(wrapperB);
                }
                wrapperA.next(".message").html(data.Messages[i].Message);
                wrapperB.find(".sortable_handle_wrapper").removeClass("sortable_handle_wrapper");
                wrapperB.find(".sortable_handle").remove();
                break;
            case "test_single":
            case "test_multy":
            case "test_single_undefined":
                var wrapper = $(".answer_option_wrapper_" + data.Messages[i].AnswerOptionsId);
                var questionWrapper = $('.question_wrapper[data-questionid="' + data.Messages[i].QuestionId + '"]');
                if (questionWrapper.data("isundefined") === true) {
                    wrapper.addClass("given_answer");
                } else {
                    wrapper.addClass(data.Messages[i].IsTrue ? "true_answer" : "false_answer").find(".message").addClass(data.Messages[i].IsTrue ? "true_answer_msg" : "false_answer_msg");
                }
                wrapper.find(".message").html(data.Messages[i].Message);

                disableInputs(wrapper.parent());

                break;
            case "test_multy_undefined":
                var wrapper = $(".answer_option_wrapper_" + data.Messages[i].AnswerOptionsId);
                var questionWrapper = $('.question_wrapper[data-questionid="' + data.Messages[i].QuestionId + '"]');
                if (questionWrapper.data("isundefined") === true) {
                    wrapper.addClass("given_answer");
                } else {
                    wrapper.addClass(data.Messages[i].IsTrue ? "true_answer" : "").find(".message").addClass(data.Messages[i].IsTrue ? "true_answer_msg" : "");
                }
                wrapper.find(".message").html(data.Messages[i].Message);

                disableInputs(wrapper.parent());

                break;
            case "test_open":
                var textarea = $('textarea[name="' + data.Messages[i].QuestionId + '"]');
                textarea.addClass(data.Messages[i].IsTrue ? "true_answer" : "false_answer");
                textarea.closest('.question_wrapper').find(".message")
                    .addClass(data.Messages[i].IsTrue ? "true_answer_msg" : "false_answer_msg").html(data.Messages[i].Message);
                textarea.prop("disabled", true);
                break;
        }

        $('.question_wrapper[data-questionid="' + data.Messages[i].QuestionId + '"]').removeClass('required');
    }
}

function disableInputs(inputsContainer) {
    inputsContainer.find("input").toArray().forEach(x => {
        $(x).prop("disabled", true);
    })
}

function redirectToUnanswered(mode, questionId, pageId, QuestionnaireRenderer) {

    if (mode == "all") {
        $([document.documentElement, document.body]).animate(
            {
                scrollTop: $(".question_wrapper[data-questionid='" + questionId + "']").offset().top
            },
            2000
        )
    }
    else if (mode == "questions") {
        QuestionnaireRenderer.loadQuestionData(questionId);
    }
    else if (mode == "pages") {
        QuestionnaireRenderer.loadPageData(pageId);
    }
}

function GetDataUrl(isPreview, type) {

    if (isPreview) {
        return "/api/run/previewrun";
    }
    else if (type == 'test') {
        return "/api/run/savetestdata";
    }
    else if (type == "questionnaire") {
        return "/api/run/savequestionnairedata";
    }
}

function UpdateIframeHeight() {
    var parentWindow = window.top;
    if (parentWindow) {
        var height = document.getElementsByClassName("runForm")[0].scrollHeight + 6 + 'px';
        if (!UpdateIframeHeight.oldHeight || UpdateIframeHeight.oldHeight != height) {
            UpdateIframeHeight.oldHeight = height;
            parentWindow.postMessage(height, "*");
        }
    }
}

function getTimeRemaining(endtime) {
    var t = endtime - Date.parse(new Date());
    var seconds = Math.floor((t / 1000) % 60);
    var minutes = Math.floor((t / 1000 / 60) % 60);
    var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
    return {
        'total': t,
        'hours': hours,
        'minutes': minutes,
        'seconds': seconds
    };
}

function initializeClock(endtime) {
    function updateClock() {
        var t = getTimeRemaining(endtime);

        $(".countdown_hours").html(('0' + t.hours).slice(-2));
        $(".countdown_minutes").html(('0' + t.minutes).slice(-2));
        $(".countdown_seconds").html(('0' + t.seconds).slice(-2));

        if (t.total < 1000) {
            clearInterval(timeoutTimer);
            isPreview ? PreviewFinish("timeout") : Finish("timeout");
        }
    }

    updateClock();
    timeoutTimer = setInterval(updateClock, 1000);
}
