﻿function GetRespondentAnswerTTable(questionContainer) {
    return getRespondentAnswer_test(questionContainer, 'TTable');
}

function GetRespondentAnswerTOpen(questionContainer) {
    return getRespondentAnswer_test(questionContainer, 'TOpen');
}

function GetRespondentAnswerTMulty(questionContainer) {
    return getRespondentAnswer_test(questionContainer, 'TMulty');
}

function GetRespondentAnswerTSingle(questionContainer) {
    return getRespondentAnswer_test(questionContainer, 'TSingle');
}

function getRespondentAnswer_test(questionContainer, type) {
    const questionId = questionContainer.data("questionid");
    const isRequired = questionContainer.data("isrequired");
    const res = GetQuestionInfoObject(questionContainer);
    
    const handlers = {
        TTable: () => {
            const As = $(`ul#As_${questionId} li`).toArray();
            const Bs = $(`ul#Bs_${questionId} li`).toArray();
            return As.reduce((result, currentItem, i) => 
                result + `${$(currentItem).data("aoptionid")}=${$(Bs[i]).data("boptionid")};`, "");
        },
        TOpen: () => {
            const value = questionContainer.find(`textarea[name="${questionId}"]`).val();
            if (!value) {
                if (typeof options !== 'undefined' && options.ShowAnswersWithMessages && isRequired) {
                    return { required: true, questionId };
                }
                if (questionContainer.data("respondentanswerid") != 0) {
                    res.questionId += ":toremove";
                    return res;
                }
                return;
            }
            return value;
        },
        TMulty: () => {
            const checked = questionContainer.find(".options_container input[data-answeroptionid]:checked").toArray();
            if (!checked.length) {
                if (typeof options !== 'undefined' && options.ShowAnswersWithMessages && isRequired) {
                    return { required: true, questionId };
                }
                if (questionContainer.data("respondentanswerid") != 0) {
                    res.questionId += ":toremove";
                    return res;
                }
                return;
            }
            return checked.map(item => $(item).data("answeroptionid")).join(",");
        },
        TSingle: () => {
            const checked = questionContainer.find(".options_container input[data-answeroptionid]:checked");
            if (!checked.length && typeof options !== 'undefined') {
                if (options && options.ShowAnswersWithMessages && isRequired) {
                    return { required: true, questionId };
                }
                return;
            }
            return checked.data("answeroptionid");
        }
    };

    const answer = handlers[type]();
    if (answer === undefined) return;
    
    res.answer = answer;
    return res;
}

