﻿const ManagerTaskInfoTemplate = `<div class="k-form">
        <div>
            <span class="font-weight-bold">Создана:</span>
            <span id="info-creation-date"></span>
        </div>
        <div>
            <span class="font-weight-bold">Дата начала:</span>
            <span id="info-start-date"></span>
        </div>
        <div>
            <span class="font-weight-bold">Дата окончания:</span>
            <span id="info-end-date"></span>
        </div>
        <div>
            <span class="font-weight-bold">Автор:</span>
            <span id="info-creator"></span>
        </div>

         <div class="font-weight-bold d-sm-flex align-items-center mb-1 info-status-wrapper">
            <span class="mr-2">Состояние:</span>
            <input id="info-status" />
        </div>

        <div>
            <span class="font-weight-bold">Описание:</span>
            <span id="info-description"></span>
        </div>

        <div class = "roles-info-wrapper">
            <span class="font-weight-bold">Назначенные роли:</span>
            <span id="info-role_names"></span>
        </div>

        <div class = "questionnaire-info-wrapper">
            <span class="font-weight-bold">Прикрепленная анкета/тест:</span>
            <span id="info-questionnaire"></span>
        </div>

        <div class="mt-3" id="children-container">
            <div class="accordion border-x border-top rounded">
                <div class="card shadow-none border-bottom">
                <div class="card-header py-0 overflow-hidden" id="headingTasks">
                    <button class="btn btn-link text-decoration-none btn-block py-2 px-0 text-left" type="button" data-toggle="collapse" data-target="\\\\#collapseTasks" aria-expanded="true" aria-controls="collapseTasks">
                    <span class="fas fa-caret-right accordion-icon mr-3" data-fa-transform="shrink-2"></span>
                    <span class="font-weight-medium text-sans-serif text-900">Назначенные задачи</span>
                    </button>
                </div>

                <div class="collapse" id="collapseTasks" aria-labelledby="headingTasks">
                    <div class="card-body p-0 pt-2">
                    <div id="children-tasks"></div>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>`;

const childrenTemplate = `<div class="m-3 pb-3 border-bottom border-200">
        <span title="Состояние" class="mb-1 text-lowercase badge badge-soft-#: GetColor(StringifyStatus) #">#: LocalizedStatus #</span>
        <div class=""><span class="font-weight-semi-bold">Назначено:</span> #: AssigneeUserName #</div>
        <div class="fs--1"><span class="font-weight-semi-bold">Создана:</span> #: kendo.toString(new Date(CreationDate), "dd.MM.yyyy HH:mm") #</div>
        <div class="fs--1"><span class="font-weight-semi-bold">Дата начала:</span> #: kendo.toString(new Date(StartDate), "dd.MM.yyyy HH:mm") #</div>
        <div class="mb-2 fs--1"><span class="font-weight-semi-bold">Дата окончания:</span> #: kendo.toString(new Date(EndDate), "dd.MM.yyyy HH:mm") #</div>

        <a class="btn btn-falcon-primary px-2 k-button-icontext k-grid-edit-command btn-sm edit-child" data-id="#: Id#"><span class="fas fa-pen"></span></a>
        <a class="btn btn-falcon-info px-2 k-button-icontext k-grid-info-command btn-sm info-child" data-id="#: Id#"><span class="fas fa-info-circle"></span></a>
    </div>`;

function ShowManagerTaskInfo(taskId, refreshSourceFunc = null) {
    let dialog = $("<div id='manager-task_info'></div>").kendoDialog({
        modal: true,
        pinned: true,
        visible: false,
        size: "medium",
        height: 500,
        content: kendo.template(ManagerTaskInfoTemplate),
        open: function () {
            $("#children-container").hide();

            $.ajax({
                url: "/api/user-tasks/task-info?taskId=" + taskId,
                type: "GET",
                dataType: "json",
                success: function (task) {
                    dialog.title(task.Title);

                    $("#info-description").html(task.Description);
                    $("#info-creation-date").html(kendo.toString(new Date(task.CreationDate), "dd.MM.yyyy HH:mm"));
                    $("#info-start-date").html(kendo.toString(new Date(task.StartDate), "dd.MM.yyyy HH:mm"));
                    $("#info-end-date").html(kendo.toString(new Date(task.EndDate), "dd.MM.yyyy HH:mm"));
                    $("#info-creator").html(task.CreatorUserName);
                    $("#info-status").data("kendoDropDownList").value(task.Status);

                    if (task.QuestionnaireId) {
                        var link = $('<a>', {
                           text: task.QuestionnaireName,
                           href: '/start/' + task.QuestionnaireId,
                           target: '_blank'
                        });
                        $("#info-questionnaire").html(link);
                    }
                    else {
                        $(".questionnaire-info-wrapper").hide();
                    }

                    if (task.AssignedRoles.length) {
                        let roleNames = task.AssignedRoles.join(", ");
                        var span = $('<span>', { text: roleNames });
                        $("#info-role_names").html(span);
                    }
                    else {
                        $(".roles-info-wrapper").hide();
                    }
                }
            });
        },
        close: function () {
            $("#manager-task_info").remove();
            if (refreshSourceFunc) {
                refreshSourceFunc();
            }
        }
    }).data("kendoDialog");

    $("#info-status").kendoDropDownList({
        dataSource: [
            {text: "Активная", value: "0",},
            {text: "Завершенная", value: "1",}
        ],
        dataTextField: "text",
        dataValueField: "value",
        change: function (e) {
            let status = this.value();

            //Проверка на сроки выполнения
            const dateString = $("#info-start-date").html();
            const [datePart, timePart] = dateString.split(' ');
            const [day, month, year] = datePart.split('.').map(Number);
            const [hours, minutes] = timePart.split(':').map(Number);
            const startDate = new Date(year, month - 1, day, hours, minutes);
            const now = new Date();
            if (status == '1' && startDate > now) {
                Notification.ShowError("Нельзя завершить задачу раньше начала срока выполнения");
                this.value('0');
            }
            else {
                ChangeStatus(taskId, status);
            }

        }
    });

    $("#children-tasks").kendoListView({
        dataSource: {
            transport: {
                read: {
                    url: "/api/user-tasks/children-tasks?parentTaskId=" + taskId,
                    type: "GET",
                    dataType: "json",
                    complete: function (e) {
                        if (e.responseJSON.length != 0) {
                            $("#children-container").show();
                        }
                        if (e.status != 200) {
                            failedServerQuery();
                        }
                    }
                }
            }
        },
        bordered: false,
        template: kendo.template(childrenTemplate),
        dataBound: function () {
            $(".edit-child").click(function () {
                var id = $(this).data("id");
                var task = GetChildTask(id);
                OpenUserTaskEditWindow(task, function () {
                    $("#children-tasks").data("kendoListView").dataSource.read();
                });
            });
            $(".info-child").click(function () {
                var id = $(this).data("id");
                ShowUserTaskInfo(id, function () {
                    $("#children-tasks").data("kendoListView").dataSource.read();
                })
            });
        }
    });

    function ChangeStatus(taskId, status) {
        $.ajax({
            url: "/api/user-tasks/change-status?userTaskId=" + taskId + "&status=" + status,
            type: "POST",
            dataType: "json",
            complete: function (response) {
                if (response.status === 200) {
                    if (refreshSourceFunc !== null || refreshSourceFunc != undefined) {
                        refreshSourceFunc();
                    }

                    Notification.ShowSuccess("Успешно");
                } else {
                    Notification.ShowError("Ошибка!");
                }
            }
        })
    }
    dialog.open();
}

function GetChildTask(taskId) {
    var task;
    $.ajax({
        url: "/api/user-tasks/task?taskId=" + taskId,
        type: "GET",
        dataType: "json",
        async: false,
        success: function (responseTask) {
            task = responseTask;
        }
    });
    return task;
}

function GetColor(status) {
    switch (status) {
        case "completed":
            return "success";
        case "active":
            return "primary";
        case "overdue":
            return "danger";
        default:
            return "secondary";
    }
}
