let connect = null;
let isBlocked = true;

function hubConnect(url, handlerName, handlerBehavior, onCloseHandler, connectionLifetime) {
    if (typeof handlerBehavior !== 'function') {
        console.error('parameter "handlerBehavior" is not a function');
        return;
    }

    var connection = new signalR.HubConnectionBuilder()
        .withUrl(url)
        .configureLogging(signalR.LogLevel.None)
        .build();

    connection.serverTimeoutInMilliseconds = connectionLifetime;

    connection.on(handlerName, handlerBehavior);
    connection.onclose(onCloseHandler);

    connection.start();

    if (url === "/hubs/last-activity") {
        connect = connection;
    }
}

function CreateLastActivityConnection() {

    var lastActivityHandler = {
        name: "UpdateUserActivity",
        handle: () => {
            
        },
        onclose: (error) => {
            if (error) {
                console.error(error);
            }
        }
    }
    const url = "/hubs/last-activity";
    const connectionLifetime = 5 * 60 * 1000;

    hubConnect(url, lastActivityHandler.name, lastActivityHandler.handle, lastActivityHandler.onclose, connectionLifetime);
}
function UpdateLastActivity() {

    if (isBlocked) {
        isBlocked = false;
        setTimeout(() => {
            isBlocked = true;
        }, 30000);
    } else {
        return;
    }

    if (connect.q === "Connected") {
        connect.invoke("UpdateActivity").catch(err => console.error("Invoke error:", err));
    }
}
