﻿;

//требует кендо и джейкуареи

var Confirmation = (function(culture) {

    if (!window.kendo) return;

    var returnObject = Object.create(null);

    var eqspI18nCofirmation = {
        "ru-RU": {
            windowheader_Default: "Подтвердите действие",
            button_OK: "ОК",
            button_Cancel: "Отмена"
        },
        "en-US": {
            windowheader_Default: "Confirm the action",
            button_OK: "OK",
            button_Cancel: "Cancel"
        }
    };

    //создаем разметку
    function init() {
        if ($("#confirmation_template").length == 0) {
            var confirmation_wrapper = $('<script type="text/html" id="confirmation_template">' +
                '<div id="confirmation_wrapper">' +
                '<div class="message"></div>' +
                '<div style="margin-top:10px;" class="text-right">' +
                '<button class="btn btn-success btn-sm confirmation_ok">' + eqspI18nCofirmation[culture].button_OK + '</button>\n' +
                '<button class="btn btn-light btn-sm confirmation_cancel">' + eqspI18nCofirmation[culture].button_Cancel + '</button>' +
                '</div>' +
                '</div>' +
                '</script>');

            $("body").append(confirmation_wrapper);
        }
    }

    function showConfirmationWindow(message, title, height) {

        var dfd = new $.Deferred();
        var result = false;

        var append = $($("#confirmation_template").html());
        append.find(".message").html(message);

        $("body").append(append);

        $("#confirmation_wrapper").kendoWindow({
            modal: true,
            width: 320,
            //height: height || 85,
            title: title || eqspI18nCofirmation[culture].windowheader_Default,
            close: function(e) {
                this.destroy();
                dfd.resolve(result);
            }
        }).data("kendoWindow").center().open();

        $('#confirmation_wrapper .confirmation_cancel').click(function() {
            $('#confirmation_wrapper').data('kendoWindow').close();
            $('.k-window .k-overlay').remove();
        });

        $('#confirmation_wrapper .confirmation_ok').click(function() {
            result = true;
            $('#confirmation_wrapper').data('kendoWindow').close();
            $('.k-window .k-overlay').remove();
        });

        return dfd.promise();
    };

    returnObject.IfConfirmed = function(options, fn) {
        init();
        $.when(showConfirmationWindow(options.message, options.title, options.height)).then(function(confirmed) {
            if (confirmed) {
                fn();
            }
        })
    }

    return returnObject;

})(eqspCulture)