/**
 * Kendo UI v2024.4.1112 (http://www.telerik.com/kendo-ui)
 * Copyright 2024 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("kendo.data.js"),require("kendo.draganddrop.js"),require("kendo.userevents.js"),require("kendo.mobile.scroller.js"),require("kendo.core.js"),require("kendo.dataviz.core.js"),require("kendo.drawing.js"),require("kendo.toolbar.js"),require("kendo.editable.js"),require("kendo.window.js"),require("kendo.dropdownlist.js"),require("kendo.dataviz.themes.js"),require("kendo.html.button.js")):"function"==typeof define&&define.amd?define(["exports","kendo.data","kendo.draganddrop","kendo.userevents","kendo.mobile.scroller","kendo.core.min","kendo.dataviz.core","kendo.drawing","kendo.toolbar","kendo.editable","kendo.window","kendo.dropdownlist","kendo.dataviz.themes","kendo.html.button"],e):e(((t="undefined"!=typeof globalThis?globalThis:t||self).kendo=t.kendo||{},t.kendo._globals=t.kendo._globals||{},t.kendo._globals.DatavizDiagram={}))}(this,(function(t){!function(t){var e=window.kendo,i=e.dataviz.diagram={},n=e.deepExtend,o=Array.isArray,s={};n(s,{isNearZero:function(t){return Math.abs(t)<1e-6},isDefined:function(t){return void 0!==t},isUndefined:function(t){return null==t},isObject:function(t){return t===Object(t)},has:function(t,e){return Object.hasOwnProperty.call(t,e)},isString:function(t){return"[object String]"==Object.prototype.toString.call(t)},isBoolean:function(t){return"[object Boolean]"==Object.prototype.toString.call(t)},isType:function(t,e){return Object.prototype.toString.call(t)=="[object "+e+"]"},isNumber:function(t){return!isNaN(parseFloat(t))&&isFinite(t)},isEmpty:function(t){if(null===t)return!0;if(o(t)||s.isString(t))return 0===t.length;for(var e in t)if(s.has(t,e))return!1;return!0},simpleExtend:function(t,e){if(s.isObject(e))for(var i in e)t[i]=e[i]},initArray:function(t,e){for(var i=[],n=0;n<t;++n)i[n]=e;return i},serializePoints:function(t){for(var e=[],i=0;i<t.length;i++){var n=t[i];e.push(n.x+";"+n.y)}return e.join(";")},deserializePoints:function(t){var e=t.split(";"),n=[];if(e.length%2!=0)throw"Not an array of points.";for(var o=0;o<e.length;o+=2)n.push(new i.Point(parseInt(e[o],10),parseInt(e[o+1],10)));return n},randomInteger:function(t,e){return parseInt(Math.floor(Math.random()*e)+t,10)},DFT:function(t,e){if(e(t),t.childNodes)for(var i=0;i<t.childNodes.length;i++){var n=t.childNodes[i];this.DFT(n,e)}},getMatrixAngle:function(t){return null===t||0===t.d?0:180*Math.atan2(t.b,t.d)/Math.PI},getMatrixScaling:function(t){return[Math.sqrt(t.a*t.a+t.c*t.c),Math.sqrt(t.b*t.b+t.d*t.d)]}}),s.sign=function(t){return t?t<0?-1:1:0},s.findAngle=function(t,e){return 180*function(t,e){if(t==e)return 0;var i=e.x-t.x,n=t.y-e.y,o=Math.atan(i/n);return n>=0?i<0?o+2*Math.PI:o:o+Math.PI}(t,e)/Math.PI},s.forEach=function(t,e,i){for(var n=0;n<t.length;n++)e.call(i,t[n],n,t)},s.any=function(t,e){for(var i=0;i<t.length;++i)if(e(t[i]))return t[i];return null},s.remove=function(t,e){for(var i;-1!==(i=s.indexOf(t,e));)t.splice(i,1);return t},s.contains=function(t,e){return-1!==s.indexOf(t,e)},s.indexOf=function(e,i){return t.inArray(i,e)},s.fold=function(t,e,i,n){for(var o=arguments.length>2,s=0;s<t.length;s++){var r=t[s];o?i=e.call(n,i,r,s,t):(i=r,o=!0)}if(!o)throw"Reduce of empty array with no initial value";return i},s.find=function(t,e,i){var n;return s.any(t,(function(t,o,s){return!!e.call(i,t,o,s)&&(n=t,!0)})),n},s.first=function(t,e,i){return 0===t.length?null:s.isUndefined(e)?t[0]:s.find(t,e,i)},s.insert=function(t,e,i){return t.splice(i,0,e),t},s.all=function(t,e,i){for(var n,o=!0,s=0;s<t.length&&(n=t[s],o=o&&e.call(i,n,s,t));s++);return o},s.clear=function(t){t.splice(0,t.length)},s.bisort=function(t,e,i){if(s.isUndefined(t))throw"First array is not specified.";if(s.isUndefined(e))throw"Second array is not specified.";if(t.length!=e.length)throw"The two arrays should have equal length";var n,o=[];for(n=0;n<t.length;n++)o.push({x:t[n],y:e[n]});for(s.isUndefined(i)?o.sort((function(t,e){return t.x-e.x})):o.sort((function(t,e){return i(t.x,e.x)})),s.clear(t),s.clear(e),n=0;n<o.length;n++)t.push(o[n].x),e.push(o[n].y)},s.addRange=function(t,e){t.push.apply(t,e)};var r=function(t){return-Math.cos(t*Math.PI)/2+.5},a=e.Class.extend({init:function(){this.adapters=[],this.target=0,this.tick=0,this.interval=20,this.duration=800,this.lastTime=null,this.handlers=[];var t=this;this.transition=r,this.timerDelegate=function(){t.onTimerEvent()}},addAdapter:function(t){this.adapters.push(t)},onComplete:function(t){this.handlers.push(t)},removeHandler:function(e){this.handlers=t.grep(this.handlers,(function(t){return t!==e}))},trigger:function(){var t=this;this.handlers&&s.forEach(this.handlers,(function(e){return e.call(null!==t.caller?t.caller:t)}))},onStep:function(){},seekTo:function(t){this.seekFromTo(this.tick,t)},seekFromTo:function(t,e){this.target=Math.max(0,Math.min(1,e)),this.tick=Math.max(0,Math.min(1,t)),this.lastTime=(new Date).getTime(),this.intervalId||(this.intervalId=window.setInterval(this.timerDelegate,this.interval))},stop:function(){this.intervalId&&(window.clearInterval(this.intervalId),this.intervalId=null,this.trigger())},play:function(t){0!==this.adapters.length&&(null!==t&&(this.caller=t),this.initState(),this.seekFromTo(0,1))},reverse:function(){this.seekFromTo(1,0)},initState:function(){if(0!==this.adapters.length)for(var t=0;t<this.adapters.length;t++)this.adapters[t].initState()},propagate:function(){for(var t=this.transition(this.tick),e=0;e<this.adapters.length;e++)this.adapters[e].update(t)},onTimerEvent:function(){var t=(new Date).getTime(),e=t-this.lastTime;this.lastTime=t;var i=e/this.duration*(this.tick<this.target?1:-1);Math.abs(i)>=Math.abs(this.tick-this.target)?this.tick=this.target:this.tick+=i;try{this.propagate()}finally{this.onStep.call(this),this.target==this.tick&&this.stop()}}});e.deepExtend(i,{init:function(t){e.init(t,i.ui)},Utils:s,Range:function(t,e,i){if(void 0===t||void 0===e)return[];if(i&&s.sign(e-t)!=s.sign(i))throw"The sign of the increment should allow to reach the stop-value.";if(t=t||0,((e=e||t)-t)/(i=i||1)==1/0)throw"Infinite range defined.";var n,o=[],r=-1,a=function(t){for(var e=1;t*e%1;)e*=10;return e}(Math.abs(i));if(i*=a,(t*=a)>(e*=a)&&i>0&&(i=-i),i<0)for(;(n=t+i*++r)>=e;)o.push(n/a);else for(;(n=t+i*++r)<=e;)o.push(n/a);return o},Ticker:a})}(window.kendo.jQuery),function(t){var e=window.kendo,i=e.dataviz.diagram,n=e.Class,o=e.deepExtend,s=i.Utils,r=e.geometry.Point,a=e.isFunction,h=s.contains,c=t.map;class d extends r{constructor(t,e){super(t,e)}clone(){return new d(this.x,this.y)}plus(t){return new d(this.x+t.x,this.y+t.y)}minus(t){return new d(this.x-t.x,this.y-t.y)}offset(t){return new d(this.x-t,this.y-t)}times(t){return new d(this.x*t,this.y*t)}normalize(){return 0===this.length()?new d:this.times(1/this.length())}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}toString(){return"("+this.x+","+this.y+")"}lengthSquared(){return this.x*this.x+this.y*this.y}middleOf(t,e){return new d(e.x-t.x,e.y-t.y).times(.5).plus(t)}toPolar(t){var e=1;t&&(e=180/Math.PI);var i=Math.atan2(Math.abs(this.y),Math.abs(this.x)),n=Math.PI/2,o=this.length();if(0===this.x){if(0===this.y)return new v(0,0);if(this.y>0)return new v(o,e*n);if(this.y<0)return new v(o,3*e*n)}else if(this.x>0){if(0===this.y)return new v(o,0);if(this.y>0)return new v(o,e*i);if(this.y<0)return new v(o,e*(4*n-i))}else{if(0===this.y)return new v(o,2*n);if(this.y>0)return new v(o,e*(2*n-i));if(this.y<0)return new v(o,e*(2*n+i))}}isOnLine(t,e){if(t.x>e.x){var i=e;e=t,t=i}var n,o,s=new u(t.x,t.y).inflate(3,3),r=new u(e.x,e.y).inflate(3,3);return!!s.union(r).contains(this)&&(t.x===e.x||t.y===e.y||(t.y<e.y?(n=s.x+(r.x-s.x)*(this.y-(s.y+s.height))/(r.y+r.height-(s.y+s.height)),o=s.x+s.width+(r.x+r.width-(s.x+s.width))*(this.y-s.y)/(r.y-s.y)):(n=s.x+(r.x-s.x)*(this.y-s.y)/(r.y-s.y),o=s.x+s.width+(r.x+r.width-(s.x+s.width))*(this.y-(s.y+s.height))/(r.y+r.height-(s.y+s.height))),this.x>n&&this.x<o))}parse(t){var e=t.slice(1,t.length-1).split(","),i=parseInt(e[0],10),n=parseInt(e[1],10);if(!isNaN(i)&&!isNaN(n))return new d(i,n)}}var l=n.extend({init:function(t,e,i){this.point=t,this.left=e,this.right=i}}),u=n.extend({init:function(t,e,i,n){this.x=t||0,this.y=e||0,this.width=i||0,this.height=n||0},contains:function(t){return t.x>=this.x&&t.x<=this.x+this.width&&t.y>=this.y&&t.y<=this.y+this.height},inflate:function(t,e){return undefined===e&&(e=t),this.x-=t,this.y-=e,this.width+=2*t+1,this.height+=2*e+1,this},offset:function(t,e){var i=t,n=e;return t instanceof d&&(i=t.x,n=t.y),this.x+=i,this.y+=n,this},union:function(t){var e=Math.min(this.x,t.x),i=Math.min(this.y,t.y),n=Math.max(this.x+this.width,t.x+t.width),o=Math.max(this.y+this.height,t.y+t.height);return new u(e,i,n-e,o-i)},center:function(){return new d(this.x+this.width/2,this.y+this.height/2)},top:function(){return new d(this.x+this.width/2,this.y)},right:function(){return new d(this.x+this.width,this.y+this.height/2)},bottom:function(){return new d(this.x+this.width/2,this.y+this.height)},left:function(){return new d(this.x,this.y+this.height/2)},topLeft:function(){return new d(this.x,this.y)},topRight:function(){return new d(this.x+this.width,this.y)},bottomLeft:function(){return new d(this.x,this.y+this.height)},bottomRight:function(){return new d(this.x+this.width,this.y+this.height)},clone:function(){return new u(this.x,this.y,this.width,this.height)},isEmpty:function(){return!this.width&&!this.height},equals:function(t){return this.x===t.x&&this.y===t.y&&this.width===t.width&&this.height===t.height},rotatedBounds:function(t){var e=this.clone(),i=this.rotatedPoints(t),n=i[0],o=i[1],s=i[2],r=i[3];return e.x=Math.min(s.x,n.x,o.x,r.x),e.y=Math.min(s.y,n.y,o.y,r.y),e.width=Math.max(s.x,n.x,o.x,r.x)-e.x,e.height=Math.max(s.y,n.y,o.y,r.y)-e.y,e},rotatedPoints:function(t){var e=this,i=e.center(),n=e.bottomRight().rotate(t,i);return[e.topLeft().rotate(t,i),e.topRight().rotate(t,i),n,e.bottomLeft().rotate(t,i)]},toString:function(t){return t=t||" ",this.x+t+this.y+t+this.width+t+this.height},scale:function(t,e,i,n,o){var s=this.topLeft(),r=this.center();s.rotate(o,r).rotate(o,n);var a=i.minus(s),h=new d(a.x*t,a.y*e),c=a.minus(h);(s=s.plus(c)).rotate(o,n).rotate(o,r),this.x=s.x,this.y=s.y,this.width*=t,this.height*=e},zoom:function(t){return this.x*=t,this.y*=t,this.width*=t,this.height*=t,this},overlaps:function(t){var e=this.bottomRight(),i=t.bottomRight();return!(e.x<t.x||e.y<t.y||i.x<this.x||i.y<this.y)}}),f=n.extend({init:function(t,e){this.width=t,this.height=e}});function p(t,e,i,n,o){var s=(e.x-t.x)*(n.y-i.y)-(e.y-t.y)*(n.x-i.x);if(r=s,!(Math.abs(r)<1e-6)){var r,a=((t.y-i.y)*(n.x-i.x)-(t.x-i.x)*(n.y-i.y))/s,h=((t.y-i.y)*(e.x-t.x)-(t.x-i.x)*(e.y-t.y))/s;if(!o||!(a<0||a>1||h<0||h>1))return new d(t.x+a*(e.x-t.x),t.y+a*(e.y-t.y))}}f.prototype.Empty=new f(0,0),u.toRect=function(t){return t instanceof u||(t=new u(t.x,t.y,t.width,t.height)),t},u.empty=function(){return new u(0,0,0,0)},u.fromPoints=function(t,e){if(isNaN(t.x)||isNaN(t.y)||isNaN(e.x)||isNaN(e.y))throw"Some values are NaN.";return new u(Math.min(t.x,e.x),Math.min(t.y,e.y),Math.abs(t.x-e.x),Math.abs(t.y-e.y))};var g={lines:function(t,e,i,n){return p(t,e,i,n)},segments:function(t,e,i,n){return p(t,e,i,n,!0)},rectWithLine:function(t,e,i){return g.segments(e,i,t.topLeft(),t.topRight())||g.segments(e,i,t.topRight(),t.bottomRight())||g.segments(e,i,t.bottomLeft(),t.bottomRight())||g.segments(e,i,t.topLeft(),t.bottomLeft())},rects:function(t,e,i){var n=e.topLeft(),o=e.topRight(),s=e.bottomLeft(),r=e.bottomRight(),a=e.center();i&&(n=n.rotate(i,a),o=o.rotate(i,a),s=s.rotate(i,a),r=r.rotate(i,a));var h=t.contains(n)||t.contains(o)||t.contains(s)||t.contains(r)||g.rectWithLine(t,n,o)||g.rectWithLine(t,n,s)||g.rectWithLine(t,o,r)||g.rectWithLine(t,s,r);if(!h){if(n=t.topLeft(),o=t.topRight(),s=t.bottomLeft(),r=t.bottomRight(),i){var c=360-i;n=n.rotate(c,a),o=o.rotate(c,a),s=s.rotate(c,a),r=r.rotate(c,a)}h=e.contains(n)||e.contains(o)||e.contains(s)||e.contains(r)}return h}},m=n.extend({init:function(t){this.container=u.toRect(t)},align:function(t,e){for(var i=e.toLowerCase().split(" "),n=0;n<i.length;n++)t=this._singleAlign(t,i[n]);return t},_singleAlign:function(t,e){return a(this[e])?this[e](t):t},left:function(t){return this._align(t,this._left)},center:function(t){return this._align(t,this._center)},right:function(t){return this._align(t,this._right)},stretch:function(t){return this._align(t,this._stretch)},top:function(t){return this._align(t,this._top)},middle:function(t){return this._align(t,this._middle)},bottom:function(t){return this._align(t,this._bottom)},_left:function(t,e){e.x=t.x},_center:function(t,e){e.x=(t.width-e.width)/2||0},_right:function(t,e){e.x=t.width-e.width},_top:function(t,e){e.y=t.y},_middle:function(t,e){e.y=(t.height-e.height)/2||0},_bottom:function(t,e){e.y=t.height-e.height},_stretch:function(t,e){e.x=0,e.y=0,e.height=t.height,e.width=t.width},_align:function(t,e){return t=u.toRect(t),e(this.container,t),t}}),v=n.extend({init:function(t,e){this.r=t,this.angle=e}}),_=n.extend({init:function(t,e,i,n,o,s){this.a=t||0,this.b=e||0,this.c=i||0,this.d=n||0,this.e=o||0,this.f=s||0},plus:function(t){this.a+=t.a,this.b+=t.b,this.c+=t.c,this.d+=t.d,this.e+=t.e,this.f+=t.f},minus:function(t){this.a-=t.a,this.b-=t.b,this.c-=t.c,this.d-=t.d,this.e-=t.e,this.f-=t.f},times:function(t){return new _(this.a*t.a+this.c*t.b,this.b*t.a+this.d*t.b,this.a*t.c+this.c*t.d,this.b*t.c+this.d*t.d,this.a*t.e+this.c*t.f+this.e,this.b*t.e+this.d*t.f+this.f)},apply:function(t){return new d(this.a*t.x+this.c*t.y+this.e,this.b*t.x+this.d*t.y+this.f)},applyRect:function(t){return u.fromPoints(this.apply(t.topLeft()),this.apply(t.bottomRight()))},toString:function(){return"matrix("+this.a+" "+this.b+" "+this.c+" "+this.d+" "+this.e+" "+this.f+")"}});o(_,{fromSVGMatrix:function(t){var e=new _;return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e.e=t.e,e.f=t.f,e},fromMatrixVector:function(t){var e=new _;return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e.e=t.e,e.f=t.f,e},fromList:function(t){if(6!==t.length)throw"The given list should consist of six elements.";var e=new _;return e.a=t[0],e.b=t[1],e.c=t[2],e.d=t[3],e.e=t[4],e.f=t[5],e},translation:function(t,e){var i=new _;return i.a=1,i.b=0,i.c=0,i.d=1,i.e=t,i.f=e,i},unit:function(){return new _(1,0,0,1,0,0)},rotation:function(t,e,i){var n=new _;return n.a=Math.cos(t*Math.PI/180),n.b=Math.sin(t*Math.PI/180),n.c=-n.b,n.d=n.a,n.e=e-e*n.a+i*n.b||0,n.f=i-i*n.a-e*n.b||0,n},scaling:function(t,e){var i=new _;return i.a=t,i.b=0,i.c=0,i.d=e,i.e=0,i.f=0,i},parse:function(t){var e,i;if(t){if("matrix"===(t=t.trim()).slice(0,6).toLowerCase()){if(6===(e=(i=t.slice(7,t.length-1).trim()).split(",")).length)return _.fromList(c(e,(function(t){return parseFloat(t)})));if(6===(e=i.split(" ")).length)return _.fromList(c(e,(function(t){return parseFloat(t)})))}if("("===t.slice(0,1)&&")"===t.slice(t.length-1)&&(t=t.substr(1,t.length-1)),t.indexOf(",")>0&&6===(e=t.split(",")).length)return _.fromList(c(e,(function(t){return parseFloat(t)})));if(t.indexOf(" ")>0&&6===(e=t.split(" ")).length)return _.fromList(c(e,(function(t){return parseFloat(t)})))}return e}});var y=n.extend({init:function(t,e,i,n,o,s){this.a=t||0,this.b=e||0,this.c=i||0,this.d=n||0,this.e=o||0,this.f=s||0},fromMatrix:function(t){var e=new y;return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e.e=t.e,e.f=t.f,e}});function w(t){s.isUndefined(t)&&(t=10);for(var e="",i="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",n=t;n>0;--n)e+=i.charAt(Math.round(61*Math.random()));return e}var x={_distanceToLineSquared:function(t,e,i){function n(t,e){return(t.x-e.x)*(t.x-e.x)+(t.y-e.y)*(t.y-e.y)}if(e===i)return n(t,e);var o=i.x-e.x,s=i.y-e.y,r=(t.x-e.x)*o+(t.y-e.y)*s;return r<0?n(e,t):(r=(i.x-t.x)*o+(i.y-t.y)*s)<0?n(i,t):(r=(i.x-t.x)*s-(i.y-t.y)*o)*r/(o*o+s*s)},distanceToLine:function(t,e,i){return Math.sqrt(this._distanceToLineSquared(t,e,i))},distanceToPolyline:function(t,e){var i=Number.MAX_VALUE;if(s.isUndefined(e)||0===e.length)return Number.MAX_VALUE;for(var n=0;n<e.length-1;n++){var o=e[n],r=e[n+1],a=this._distanceToLineSquared(t,o,r);a<i&&(i=a)}return Math.sqrt(i)}},b=e.Class.extend({init:function(){this._buckets=[],this.length=0},add:function(t,e){var i=this._createGetBucket(t);return s.isDefined(e)&&(i.value=e),i},get:function(t){return this._bucketExists(t)?this._createGetBucket(t):null},set:function(t,e){this.add(t,e)},containsKey:function(t){return this._bucketExists(t)},remove:function(t){if(this._bucketExists(t)){var e=this._hash(t);return delete this._buckets[e],this.length--,t}},forEach:function(t){for(var e=this._hashes(),i=0,n=e.length;i<n;i++){var o=e[i],r=this._buckets[o];s.isUndefined(r)||t(r)}},clone:function(){for(var t=new b,e=this._hashes(),i=0,n=e.length;i<n;i++){var o=e[i],r=this._buckets[o];s.isUndefined(r)||t.add(r.key,r.value)}return t},_hashes:function(){var t=[];for(var e in this._buckets)this._buckets.hasOwnProperty(e)&&t.push(e);return t},_bucketExists:function(t){var e=this._hash(t);return s.isDefined(this._buckets[e])},_createGetBucket:function(t){var e=this._hash(t),i=this._buckets[e];return s.isUndefined(i)&&(i={key:t},this._buckets[e]=i,this.length++),i},_hash:function(t){if(s.isNumber(t))return t;if(s.isString(t))return this._hashString(t);if(s.isObject(t))return this._objectHashId(t);throw"Unsupported key type."},_hashString:function(t){var e=0;if(0===t.length)return e;for(var i=0;i<t.length;i++){e=32*e-e+t.charCodeAt(i)}return e},_objectHashId:function(t){var e=t._hashId;return s.isUndefined(e)&&(e=w(),t._hashId=e),e}}),C=e.Observable.extend({init:function(t){if(e.Observable.fn.init.call(this),this._hashTable=new b,this.length=0,s.isDefined(t))if(Array.isArray(t))for(var i=0;i<t.length;i++)this.add(t[i]);else t.forEach((function(t,e){this.add(t,e)}),this)},add:function(t,e){var i=this._hashTable.get(t);i||(i=this._hashTable.add(t),this.length++,this.trigger("changed")),i.value=e},set:function(t,e){this.add(t,e)},get:function(t){var e=this._hashTable.get(t);if(e)return e.value;throw new Error("Cannot find key "+t)},containsKey:function(t){return this._hashTable.containsKey(t)},remove:function(t){if(this.containsKey(t))return this.trigger("changed"),this.length--,this._hashTable.remove(t)},forEach:function(t,e){this._hashTable.forEach((function(i){t.call(e,i.key,i.value)}))},forEachValue:function(t,e){this._hashTable.forEach((function(i){t.call(e,i.value)}))},forEachKey:function(t,e){this._hashTable.forEach((function(i){t.call(e,i.key)}))},keys:function(){var t=[];return this.forEachKey((function(e){t.push(e)})),t}}),S=e.Class.extend({init:function(){this._tail=null,this._head=null,this.length=0},enqueue:function(t){var e={value:t,next:null};this._head?(this._tail.next=e,this._tail=this._tail.next):(this._head=e,this._tail=this._head),this.length++},dequeue:function(){if(this.length<1)throw new Error("The queue is empty.");var t=this._head.value;return this._head=this._head.next,this.length--,t},contains:function(t){for(var e=this._head;e;){if(e.value===t)return!0;e=e.next}return!1}}),k=e.Observable.extend({init:function(t){e.Observable.fn.init.call(this),this._hashTable=new b,this.length=0,s.isDefined(t)&&(t instanceof b?t.forEach((function(t){this.add(t)})):t instanceof C&&t.forEach((function(t,e){this.add({key:t,value:e})}),this))},contains:function(t){return this._hashTable.containsKey(t)},add:function(t){this._hashTable.get(t)||(this._hashTable.add(t,t),this.length++,this.trigger("changed"))},get:function(t){return this.contains(t)?this._hashTable.get(t).value:null},hash:function(t){return this._hashTable._hash(t)},remove:function(t){this.contains(t)&&(this._hashTable.remove(t),this.length--,this.trigger("changed"))},forEach:function(t,e){this._hashTable.forEach((function(e){t(e.value)}),e)},toArray:function(){var t=[];return this.forEach((function(e){t.push(e)})),t}}),T=e.Class.extend({init:function(t,e){if(this.links=[],this.outgoing=[],this.incoming=[],this.weight=1,s.isDefined(t)?this.id=t:this.id=w(),s.isDefined(e)){this.associatedShape=e;var i=e.bounds();this.width=i.width,this.height=i.height,this.x=i.x,this.y=i.y}else this.associatedShape=null;this.data=null,this.type="Node",this.shortForm="Node '"+this.id+"'",this.isVirtual=!1},isIsolated:function(){return s.isEmpty(this.links)},bounds:function(t){if(!s.isDefined(t))return new i.Rect(this.x,this.y,this.width,this.height);this.x=t.x,this.y=t.y,this.width=t.width,this.height=t.height},isLinkedTo:function(t){var e=this;return s.any(e.links,(function(i){return i.getComplement(e)===t}))},getChildren:function(){if(0===this.outgoing.length)return[];for(var t=[],e=0,i=this.outgoing.length;e<i;e++){var n=this.outgoing[e];t.push(n.getComplement(this))}return t},getParents:function(){if(0===this.incoming.length)return[];for(var t=[],e=0,i=this.incoming.length;e<i;e++){var n=this.incoming[e];t.push(n.getComplement(this))}return t},clone:function(){var t=new T;return s.isDefined(this.weight)&&(t.weight=this.weight),s.isDefined(this.balance)&&(t.balance=this.balance),s.isDefined(this.owner)&&(t.owner=this.owner),t.associatedShape=this.associatedShape,t.x=this.x,t.y=this.y,t.width=this.width,t.height=this.height,t},adjacentTo:function(t){return null!==this.isLinkedTo(t)},removeLink:function(t){t.source===this&&(s.remove(this.links,t),s.remove(this.outgoing,t),t.source=null),t.target===this&&(s.remove(this.links,t),s.remove(this.incoming,t),t.target=null)},hasLinkTo:function(t){return s.any(this.outgoing,(function(e){return e.target===t}))},degree:function(){return this.links.length},incidentWith:function(t){return h(this.links,t)},getLinksWith:function(t){return s.all(this.links,(function(e){return e.getComplement(this)===t}),this)},getNeighbors:function(){var t=[];return s.forEach(this.incoming,(function(e){t.push(e.getComplement(this))}),this),s.forEach(this.outgoing,(function(e){t.push(e.getComplement(this))}),this),t}}),M=e.Class.extend({init:function(t,e,i,n){if(s.isUndefined(t))throw"The source of the new link is not set.";if(s.isUndefined(e))throw"The target of the new link is not set.";var o,r;o=s.isString(t)?new T(t):t,r=s.isString(e)?new T(e):e,this.source=o,this.target=r,this.source.links.push(this),this.target.links.push(this),this.source.outgoing.push(this),this.target.incoming.push(this),s.isDefined(i)?this.id=i:this.id=w(),s.isDefined(n)?this.associatedConnection=n:this.associatedConnection=null,this.type="Link",this.shortForm="Link '"+this.source.id+"->"+this.target.id+"'"},getComplement:function(t){if(this.source!==t&&this.target!==t)throw"The given node is not incident with this link.";return this.source===t?this.target:this.source},getCommonNode:function(t){return this.source===t.source||this.source===t.target?this.source:this.target===t.source||this.target===t.target?this.target:null},isBridging:function(t,e){return this.source===t&&this.target===e||this.source===e&&this.target===t},getNodes:function(){return[this.source,this.target]},incidentWith:function(t){return this.source===t||this.target===t},adjacentTo:function(t){return h(this.source.links,t)||h(this.target.links,t)},changeSource:function(t){s.remove(this.source.links,this),s.remove(this.source.outgoing,this),t.links.push(this),t.outgoing.push(this),this.source=t},changeTarget:function(t){s.remove(this.target.links,this),s.remove(this.target.incoming,this),t.links.push(this),t.incoming.push(this),this.target=t},changesNodes:function(t,e){this.source===t?this.changeSource(e):this.target===t&&this.changeTarget(e)},reverse:function(){var t=this.source,e=this.target;return this.source=e,s.remove(t.outgoing,this),this.source.outgoing.push(this),this.target=t,s.remove(e.incoming,this),this.target.incoming.push(this),this},directTo:function(t){if(this.source!==t&&this.target!==t)throw"The given node is not incident with this link.";this.target!==t&&this.reverse()},createReverseEdge:function(){var t=this.clone();return t.reverse(),t.reversed=!0,t},clone:function(){return new M(this.source,this.target)}}),D=e.Class.extend({init:function(t){this.links=[],this.nodes=[],this._nodeMap=new C,this.diagram=null,this._root=null,s.isDefined(t)?s.isString(t)?this.id=t:(this.diagram=t,this.id=t.id):this.id=w(),this.bounds=new u,this._hasCachedRelationships=!1,this.type="Graph"},cacheRelationships:function(t){if(s.isUndefined(t)&&(t=!1),!this._hasCachedRelationships||t){for(var e=0,i=this.nodes.length;e<i;e++){var n=this.nodes[e];n.children=this.getChildren(n),n.parents=this.getParents(n)}this._hasCachedRelationships=!0}},assignLevels:function(t,e,i){if(!t)throw"Start node not specified.";s.isUndefined(e)&&(e=0),this.cacheRelationships(),s.isUndefined(i)&&(i=new C,s.forEach(this.nodes,(function(t){i.add(t,!1)}))),i.set(t,!0),t.level=e;for(var n=t.children,o=0,r=n.length;o<r;o++){var a=n[o];a&&!i.get(a)&&this.assignLevels(a,e+1,i)}},root:function(t){if(s.isUndefined(t)){if(this._root)return this._root;var e=s.first(this.nodes,(function(t){return 0===t.incoming.length}));return e||s.first(this.nodes)}this._root=t},getConnectedComponents:function(){this.componentIndex=0,this.setItemIndices();for(var t=s.initArray(this.nodes.length,-1),e=0;e<this.nodes.length;e++)-1===t[e]&&(this._collectConnectedNodes(t,e),this.componentIndex++);var i,n=[];for(i=0;i<this.componentIndex;++i)n[i]=new D;for(i=0;i<t.length;++i){n[t[i]].addNodeAndOutgoings(this.nodes[i])}return n.sort((function(t,e){return e.nodes.length-t.nodes.length})),n},_collectConnectedNodes:function(t,e){t[e]=this.componentIndex;var i=this.nodes[e];s.forEach(i.links,(function(e){var n=e.getComplement(i).index;-1===t[n]&&this._collectConnectedNodes(t,n)}),this)},calcBounds:function(){if(this.isEmpty())return this.bounds=new u,this.bounds;for(var t=null,e=0,i=this.nodes.length;e<i;e++){var n=this.nodes[e];t=t?t.union(n.bounds()):n.bounds()}return this.bounds=t,this.bounds},getSpanningTree:function(t){var e,i,n=new D,o=new C;n.root=t.clone(),n.root.level=0,n.root.id=t.id,o.add(t,n.root),t.level=0;var r=[],a=[];n._addNode(n.root),r.push(t),a.push(t);for(var c=1;a.length>0;)for(var d=a.pop(),l=0;l<d.links.length;l++){var u=d.links[l].getComplement(d);if(!h(r,u)){u.level=d.level+1,c<u.level+1&&(c=u.level+1),h(a,u)||a.push(u),h(r,u)||r.push(u),o.containsKey(d)?e=o.get(d):((e=d.clone()).level=d.level,e.id=d.id,o.add(d,e)),o.containsKey(u)?i=o.get(u):((i=u.clone()).level=u.level,i.id=u.id,o.add(u,i));var f=new M(e,i);n.addLink(f)}}for(var p=[],g=0;g<c;g++)p.push([]);return s.forEach(n.nodes,(function(t){p[t.level].push(t)})),n.treeLevels=p,n.cacheRelationships(),n},takeRandomNode:function(e,i){if(s.isUndefined(e)&&(e=[]),s.isUndefined(i)&&(i=4),0===this.nodes.length)return null;if(1===this.nodes.length)return h(e,this.nodes[0])?null:this.nodes[0];var n=t.grep(this.nodes,(function(t){return!h(e,t)&&t.degree()<=i}));return s.isEmpty(n)?null:n[s.randomInteger(0,n.length)]},isEmpty:function(){return s.isEmpty(this.nodes)},isHealthy:function(){return s.all(this.links,(function(t){return h(this.nodes,t.source)&&h(this.nodes,t.target)}),this)},getParents:function(t){if(!this.hasNode(t))throw"The given node is not part of this graph.";return t.getParents()},getChildren:function(t){if(!this.hasNode(t))throw"The given node is not part of this graph.";return t.getChildren()},addLink:function(t,e,i){if(s.isUndefined(t))throw"The source of the link is not defined.";if(s.isUndefined(e)){if(s.isDefined(t.type)&&"Link"===t.type)return void this.addExistingLink(t);throw"The target of the link is not defined."}var n=this.getNode(t);s.isUndefined(n)&&(n=this.addNode(t));var o=this.getNode(e);s.isUndefined(o)&&(o=this.addNode(e));var r=new M(n,o);return s.isDefined(i)&&(r.owner=i),this.links.push(r),r},removeAllLinks:function(){for(;this.links.length>0;){var t=this.links[0];this.removeLink(t)}},addExistingLink:function(t){if(!this.hasLink(t)){if(this.links.push(t),this.hasNode(t.source.id)){var e=this.getNode(t.source.id);t.changeSource(e)}else this.addNode(t.source);if(this.hasNode(t.target.id)){var i=this.getNode(t.target.id);t.changeTarget(i)}else this.addNode(t.target)}},hasLink:function(t){if(s.isString(t))return s.any(this.links,(function(e){return e.id===t}));if("Link"===t.type)return h(this.links,t);throw"The given object is neither an identifier nor a Link."},getNode:function(t){var e=t.id||t;if(this._nodeMap.containsKey(e))return this._nodeMap.get(e)},hasNode:function(t){var e=t.id||t;return this._nodeMap.containsKey(e)},_addNode:function(t){this.nodes.push(t),this._nodeMap.add(t.id,t)},_removeNode:function(t){s.remove(this.nodes,t),this._nodeMap.remove(t.id)},removeNode:function(t){var e=t;if(s.isString(t)&&(e=this.getNode(t)),!s.isDefined(e))throw"The identifier should be a Node or the Id (string) of a node.";var i=e.links;e.links=[];for(var n=0,o=i.length;n<o;n++){var r=i[n];this.removeLink(r)}this._removeNode(e)},areConnected:function(t,e){return s.any(this.links,(function(i){return i.source==t&&i.target==e||i.source==e&&i.target==t}))},removeLink:function(t){s.remove(this.links,t),s.remove(t.source.outgoing,t),s.remove(t.source.links,t),s.remove(t.target.incoming,t),s.remove(t.target.links,t)},addNode:function(t,e,i){var n=null;if(!s.isDefined(t))throw"No Node or identifier for a new Node is given.";if(s.isString(t)){if(this.hasNode(t))return this.getNode(t);n=new T(t)}else{if(this.hasNode(t))return this.getNode(t);n=t}return s.isDefined(e)&&n.bounds(e),s.isDefined(i)&&(n.owner=i),this._addNode(n),n},addNodeAndOutgoings:function(t){this.hasNode(t)||this._addNode(t);var e=t.outgoing;t.outgoing=[],s.forEach(e,(function(t){this.addExistingLink(t)}),this)},setItemIndices:function(){var t;for(t=0;t<this.nodes.length;++t)this.nodes[t].index=t;for(t=0;t<this.links.length;++t)this.links[t].index=t},clone:function(t){var e=new D,i=s.isDefined(t)&&!0===t;i&&(e.nodeMap=new C,e.linkMap=new C);var n=new C;return s.forEach(this.nodes,(function(t){var o=t.clone();n.set(t,o),e._addNode(o),i&&e.nodeMap.set(o,t)})),s.forEach(this.links,(function(t){if(n.containsKey(t.source)&&n.containsKey(t.target)){var o=e.addLink(n.get(t.source),n.get(t.target));i&&e.linkMap.set(o,t)}})),e},linearize:function(t){return D.Utils.linearize(this,t)},depthFirstTraversal:function(t,e){if(s.isUndefined(t))throw"You need to supply a starting node.";if(s.isUndefined(e))throw"You need to supply an action.";if(!this.hasNode(t))throw"The given start-node is not part of this graph";var i=this.getNode(t);this._dftIterator(i,e,[])},_dftIterator:function(t,e,i){e(t),i.push(t);for(var n=t.getChildren(),o=0,s=n.length;o<s;o++){var r=n[o];h(i,r)||this._dftIterator(r,e,i)}},breadthFirstTraversal:function(t,e){if(s.isUndefined(t))throw"You need to supply a starting node.";if(s.isUndefined(e))throw"You need to supply an action.";if(!this.hasNode(t))throw"The given start-node is not part of this graph";var i=this.getNode(t),n=new S,o=[];for(n.enqueue(i);n.length>0;){var r=n.dequeue();e(r),o.push(r);for(var a=r.getChildren(),c=0,d=a.length;c<d;c++){var l=a[c];h(o,l)||h(n,l)||n.enqueue(l)}}},_stronglyConnectedComponents:function(t,e,i,n,o,s,r){i.add(e,r),n.add(e,r),r++,s.push(e);for(var a,c=e.getChildren(),d=0,l=c.length;d<l;d++)a=c[d],i.containsKey(a)?h(s,a)&&n.add(e,Math.min(n.get(e),i.get(a))):(this._stronglyConnectedComponents(t,a,i,n,o,s,r),n.add(e,Math.min(n.get(e),n.get(a))));if(n.get(e)===i.get(e)){var u=[];do{a=s.pop(),u.push(a)}while(a!==e);(!t||u.length>1)&&o.push(u)}},findCycles:function(t){s.isUndefined(t)&&(t=!0);for(var e=new C,i=new C,n=[],o=[],r=0,a=this.nodes.length;r<a;r++){var h=this.nodes[r];e.containsKey(h)||this._stronglyConnectedComponents(t,h,e,i,n,o,0)}return n},isAcyclic:function(){return s.isEmpty(this.findCycles())},isSubGraph:function(t){var e=t.linearize(),i=this.linearize();return s.all(e,(function(t){return h(i,t)}))},makeAcyclic:function(){if(this.isEmpty()||this.nodes.length<=1||this.links.length<=1)return[];if(2==this.nodes.length){var t=[];if(this.links.length>1)for(var e=this.links[0].source,i=0,n=this.links.length;i<n;i++){var o=this.links[i];if(o.source!=e){var r=o.reverse();t.push(r)}}return t}var a=this.clone(!0),h=this.nodes.length,c=new C,d=function(t){return 0===t.outgoing.length?2-h:0===t.incoming.length?h-2:t.outgoing.length-t.incoming.length},l=function(t,e){var i=d(t);e.containsKey(i)||e.set(i,[]),e.get(i).push(t)};s.forEach(a.nodes,(function(t){l(t,c)}));for(var u=[],f=[];a.nodes.length>0;){var p,g,m;if(c.containsKey(2-h))for(var v=c.get(2-h);v.length>0;){g=v.pop();for(var _=0;_<g.links.length;_++){var y=g.links[_];p=y.getComplement(g),m=d(p),s.remove(c.get(m),p),p.removeLink(y),l(p,c)}a._removeNode(g),f.unshift(g)}if(c.containsKey(h-2))for(var w=c.get(h-2);w.length>0;){p=w.pop();for(var x=0;x<p.links.length;x++){var b=p.links[x];g=b.getComplement(p),m=d(g),s.remove(c.get(m),g),g.removeLink(b),l(g,c)}u.push(p),a._removeNode(p)}if(a.nodes.length>0)for(var S=h-3;S>2-h;S--)if(c.containsKey(S)&&c.get(S).length>0){for(var k=c.get(S).pop(),T=0;T<k.links.length;T++){var M=k.links[T],D=M.getComplement(k);m=d(D),s.remove(c.get(m),D),D.removeLink(M),l(D,c)}u.push(k),a._removeNode(k);break}}u=u.concat(f);for(var I=new C,P=0;P<this.nodes.length;P++)I.set(a.nodeMap.get(u[P]),P);var L=[];return s.forEach(this.links,(function(t){I.get(t.source)>I.get(t.target)&&(t.reverse(),L.push(t))})),L}});D.Predefined={EightGraph:function(){return D.Utils.parse(["1->2","2->3","3->4","4->1","3->5","5->6","6->7","7->3"])},Mindmap:function(){return D.Utils.parse(["0->1","0->2","0->3","0->4","0->5","1->6","1->7","7->8","2->9","9->10","9->11","3->12","12->13","13->14","4->15","4->16","15->17","15->18","18->19","18->20","14->21","14->22","5->23","23->24","23->25","6->26"])},ThreeGraph:function(){return D.Utils.parse(["1->2","2->3","3->1"])},BinaryTree:function(t){return s.isUndefined(t)&&(t=5),D.Utils.createBalancedTree(t,2)},Linear:function(t){return s.isUndefined(t)&&(t=10),D.Utils.createBalancedTree(t,1)},Tree:function(t,e){return D.Utils.createBalancedTree(t,e)},Forest:function(t,e,i){return D.Utils.createBalancedForest(t,e,i)},Workflow:function(){return D.Utils.parse(["0->1","1->2","2->3","1->4","4->3","3->5","5->6","6->3","6->7","5->4"])},Grid:function(t,e){var n=new i.Graph;if(t<=0&&e<=0)return n;for(var o=0;o<t+1;o++)for(var s=null,r=0;r<e+1;r++){var a=new T(o.toString()+"."+r.toString());if(n.addNode(a),s&&n.addLink(s,a),o>0){var h=n.getNode((o-1).toString()+"."+r.toString());n.addLink(h,a)}s=a}return n}},D.Utils={parse:function(t){for(var n,o=new i.Graph,r=t.slice(),a=0,h=r.length;a<h;a++){var c=r[a];if(s.isString(c)){if(c.indexOf("->")<0)throw"The link should be specified as 'a->b'.";var d=c.split("->");if(2!=d.length)throw"The link should be specified as 'a->b'.";n=new M(d[0],d[1]),o.addLink(n)}if(s.isObject(c)){if(!n)throw"Specification found before Link definition.";e.deepExtend(n,c)}}return o},linearize:function(t,e){if(s.isUndefined(t))throw"Expected an instance of a Graph object in slot one.";s.isUndefined(e)&&(e=!1);for(var i=[],n=0,o=t.links.length;n<o;n++){var r=t.links[n];i.push(r.source.id+"->"+r.target.id),e&&i.push({id:r.id})}return i},_addShape:function(t,i,n,o){return s.isUndefined(i)&&(i=new d(0,0)),s.isUndefined(n)&&(n=w()),o=e.deepExtend({width:20,height:20,id:n,radius:10,fill:"#778899",data:"circle",undoable:!1,x:i.x,y:i.y},o),t.addShape(o)},_addConnection:function(t,e,i,n){return t.connect(e,i,n)},createDiagramFromGraph:function(t,i,n,o){if(s.isUndefined(t))throw"The diagram surface is undefined.";if(s.isUndefined(i))throw"No graph specification defined.";s.isUndefined(n)&&(n=!0),s.isUndefined(o)&&(o=!1);for(var r,a,h=t.element.clientWidth||200,c=t.element.clientHeight||200,l=[],f=0,p=i.nodes.length;f<p;f++){var g=(r=i.nodes[f]).position;s.isUndefined(g)&&(g=s.isDefined(r.x)&&s.isDefined(r.y)?new d(r.x,r.y):new d(s.randomInteger(10,h-20),s.randomInteger(10,c-20)));var m={};"0"===r.id||o&&e.deepExtend(m,{width:150*Math.random()+20,height:80*Math.random()+50,data:"rectangle",fill:{color:"#778899"}});var v=(a=this._addShape(t,g,r.id,m)).bounds();s.isDefined(v)&&(r.x=v.x,r.y=v.y,r.width=v.width,r.height=v.height),l[r.id]=a}for(var _=0;_<i.links.length;_++){var y=i.links[_],w=l[y.source.id];if(!s.isUndefined(w)){var x=l[y.target.id];s.isUndefined(x)||this._addConnection(t,w,x,{id:y.id})}}if(n){new t.SpringLayout(t).layoutGraph(i,{limitToView:!1});for(var b=0;b<i.nodes.length;b++)(a=l[(r=i.nodes[b]).id]).bounds(new u(r.x,r.y,r.width,r.height))}},createBalancedTree:function(t,e){s.isUndefined(t)&&(t=3),s.isUndefined(e)&&(e=3);var n,o=new i.Graph,r=-1,a=[];if(t<=0||e<=0)return o;var h=new T((++r).toString());o.addNode(h),o.root=h,a.push(h);for(var c=0;c<t;c++){n=[];for(var d=0;d<a.length;d++)for(var l=a[d],u=0;u<e;u++){var f=new T((++r).toString());o.addLink(l,f),n.push(f)}a=n}return o},createBalancedForest:function(t,e,n){s.isUndefined(t)&&(t=3),s.isUndefined(e)&&(e=3),s.isUndefined(n)&&(n=5);var o,r=new i.Graph,a=-1,h=[];if(t<=0||e<=0||n<=0)return r;for(var c=0;c<n;c++){var d=new T((++a).toString());r.addNode(d),h=[d];for(var l=0;l<t;l++){o=[];for(var u=0;u<h.length;u++)for(var f=h[u],p=0;p<e;p++){var g=new T((++a).toString());r.addLink(f,g),o.push(g)}h=o}}return r},createRandomConnectedGraph:function(t,e,n){s.isUndefined(t)&&(t=40),s.isUndefined(e)&&(e=4),s.isUndefined(n)&&(n=!1);var o=new i.Graph,r=-1;if(t<=0)return o;var a=new T((++r).toString());if(o.addNode(a),1===t)return o;if(t>1){for(var h=1;h<t;h++){var c=o.takeRandomNode([],e);if(!c)break;var d=o.addNode(h.toString());o.addLink(c,d)}if(!n&&t>1)for(var l=s.randomInteger(1,t),u=0;u<l;u++){var f=o.takeRandomNode([],e),p=o.takeRandomNode([],e);f&&p&&!o.areConnected(f,p)&&o.addLink(f,p)}return o}},randomDiagram:function(t,i,n,o,s){var r=e.dataviz.diagram.Graph.Utils.createRandomConnectedGraph(i,n,o);D.Utils.createDiagramFromGraph(t,r,!1,s)}},e.deepExtend(i,{init:function(t){e.init(t,i.ui)},Point:d,Intersect:g,Geometry:x,Rect:u,Size:f,RectAlign:m,Matrix:_,MatrixVector:y,normalVariable:function(t,e){var i,n,o;do{o=(i=2*Math.random()-1)*i+(n=2*Math.random()-1)*n}while(!o||o>1);return t+e*i*Math.sqrt(-2*Math.log(o)/o)},randomId:w,Dictionary:C,HashTable:b,Queue:S,Set:k,Node:T,Link:M,Graph:D,PathDefiner:l})}(window.kendo.jQuery),function(t,e){var i=window.kendo,n=i.dataviz.diagram,o=i.Class,s=i.deepExtend,r=n.Point,a=n.Rect,h=n.Matrix,c=n.Utils,d=c.isNumber,l=c.isString,u=n.MatrixVector,f=i.geometry,p=i.drawing,g=p.util.defined,m=t.inArray,v="transparent",_={none:"none",arrowStart:"ArrowStart",filledCircle:"FilledCircle",arrowEnd:"ArrowEnd"},y="start",w="end",x="width",b="height";function C(t,e){for(var i,n,o=this.options,s=!1,r=0;r<e.length;r++)i=t[n=e[r]],d(i)&&o[n]!==i&&(o[n]=i,s=!0);return s}n.Markers=_;var S=o.extend({init:function(t,e){this.x=t,this.y=e},toMatrix:function(){return h.scaling(this.x,this.y)},toString:function(){return i.format("scale({0},{1})",this.x,this.y)},invert:function(){return new S(1/this.x,1/this.y)}}),k=o.extend({init:function(t,e){this.x=t,this.y=e},toMatrixVector:function(){return new u(0,0,0,0,this.x,this.y)},toMatrix:function(){return h.translation(this.x,this.y)},toString:function(){return i.format("translate({0},{1})",this.x,this.y)},plus:function(t){this.x+=t.x,this.y+=t.y},times:function(t){this.x*=t,this.y*=t},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},normalize:function(){0!==this.Length&&this.times(1/this.length())},invert:function(){return new k(-this.x,-this.y)}}),T=o.extend({init:function(t,e,i){this.x=e||0,this.y=i||0,this.angle=t},toString:function(){return this.x&&this.y?i.format("rotate({0},{1},{2})",this.angle,this.x,this.y):i.format("rotate({0})",this.angle)},toMatrix:function(){return h.rotation(this.angle,this.x,this.y)},center:function(){return new r(this.x,this.y)},invert:function(){return new T(360-this.angle,this.x,this.y)}});T.ZERO=new T(0),T.create=function(t){return new T(t.angle,t.x,t.y)},T.parse=function(t){var e=t.slice(1,t.length-1).split(","),i=e[0],n=e[1],o=e[2];return new T(i,n,o)};var M=o.extend({init:function(t,i,n,o,s,r){this.translate=new k(t,i),n!==e&&o!==e&&(this.scale=new S(n,o)),s!==e&&(this.rotate=r?new T(s,r.x,r.y):new T(s))},toString:function(){var t=function(t){return t?t.toString():""};return t(this.translate)+t(this.rotate)+t(this.scale)},render:function(t){t._transform=this,t._renderTransform()},toMatrix:function(){var t=h.unit();return this.translate&&(t=t.times(this.translate.toMatrix())),this.rotate&&(t=t.times(this.rotate.toMatrix())),this.scale&&(t=t.times(this.scale.toMatrix())),t},invert:function(){var t=this.rotate?this.rotate.invert():e,i=t?t.toMatrix():h.unit(),n=this.scale?this.scale.invert():e,o=n?n.toMatrix():h.unit(),s=new r(-this.translate.x,-this.translate.y);s=i.times(o).apply(s);var a=new k(s.x,s.y),c=new M;return c.translate=a,c.rotate=t,c.scale=n,c}}),D={_setScale:function(){var t=this.options,e=this._originWidth,i=this._originHeight,n=t.width/e,o=t.height/i;d(n)||(n=1),d(o)||(o=1),this._transform.scale=new S(n,o)},_setTranslate:function(){var t=this.options,e=t.x||0,i=t.y||0;this._transform.translate=new k(e,i)},_initSize:function(){var t=this.options,e=!1;!1!==t.autoSize&&(g(t.width)||g(t.height))&&(this._measure(!0),this._setScale(),e=!0),(g(t.x)||g(t.y))&&(this._setTranslate(),e=!0),e&&this._renderTransform()},_updateSize:function(t){var e=!1;return!1!==this.options.autoSize&&this._diffNumericOptions(t,[x,b])&&(e=!0,this._measure(!0),this._setScale()),this._diffNumericOptions(t,["x","y"])&&(e=!0,this._setTranslate()),e&&this._renderTransform(),e}},I=o.extend({init:function(t){var e=this;e.options=s({},e.options,t),e.id=e.options.id,e._originSize=a.empty(),e._transform=new M},visible:function(t){return this.drawingContainer().visible(t)},redraw:function(t){t&&t.id&&(this.id=t.id)},position:function(t,e){var i=this.options;if(!g(t))return new r(i.x,i.y);g(e)?(i.x=t,i.y=e):t instanceof r&&(i.x=t.x,i.y=t.y),this._transform.translate=new k(i.x,i.y),this._renderTransform()},rotate:function(t,e){return g(t)&&(this._transform.rotate=new T(t,e.x,e.y),this._renderTransform()),this._transform.rotate||T.ZERO},drawingContainer:function(){return this.drawingElement},_renderTransform:function(){var t=this._transform.toMatrix();this.drawingContainer().transform(new f.Matrix(t.a,t.b,t.c,t.d,t.e,t.f))},_hover:function(){},_diffNumericOptions:C,_measure:function(t){var e;if(!this._measured||t){var i=this._boundingBox()||new f.Rect,n=i.topLeft();e=new a(n.x,n.y,i.width(),i.height()),this._originSize=e,this._originWidth=e.width,this._originHeight=e.height,this._measured=!0}else e=this._originSize;return e},_boundingBox:function(){return this.drawingElement.rawBBox()}}),P=I.extend({init:function(t){I.fn.init.call(this,t),(t=this.options).fill=W(t.fill),t.stroke=W(t.stroke)},options:{stroke:{color:"gray",width:1},fill:{color:v}},fill:function(t,e){this._fill({color:j(t),opacity:e})},stroke:function(t,e,i){this._stroke({color:j(t),width:e,opacity:i})},redraw:function(t){if(t){var e=t.stroke,i=t.fill;e&&this._stroke(W(e)),i&&this._fill(W(i)),I.fn.redraw.call(this,t)}},_hover:function(t){var e=this.drawingElement,i=this.options,n=i.hover;if(n&&n.fill){var o=t?W(n.fill):i.fill;e.fill(o.color,o.opacity)}},_stroke:function(t){var e=this.options;s(e,{stroke:t});var i=null;(t=e.stroke).width>0&&(i={color:t.color,width:t.width,opacity:t.opacity,dashType:t.dashType}),this.drawingElement.options.set("stroke",i)},_fill:function(t){var e=this.options;s(e,{fill:t||{}});var i=e.fill;if(i.gradient){var n=i.gradient,o="radial"===n.type?p.RadialGradient:p.LinearGradient;this.drawingElement.fill(new o(n))}else this.drawingElement.fill(i.color,i.opacity)}}),L=P.extend({init:function(t){t=this._textColor(t),P.fn.init.call(this,t),this._font(),this._initText(),this._initSize()},options:{fontSize:15,fontFamily:"sans-serif",stroke:{width:0},fill:{color:"black"},autoSize:!0},_initText:function(){var t=this.options;this.drawingElement=new p.Text(g(t.text)?t.text:"",new f.Point,{font:t.font}),this._fill(),this._stroke()},_textColor:function(t){return t&&t.color&&(t=s({},t,{fill:{color:t.color}})),t},_font:function(){var t=this.options;if(t.fontFamily&&g(t.fontSize)){var e=[];t.fontStyle&&e.push(t.fontStyle),t.fontWeight&&e.push(t.fontWeight),e.push(t.fontSize+(d(t.fontSize)?"px":"")),e.push(t.fontFamily),t.font=e.join(" ")}else delete t.font},content:function(t){return this.drawingElement.content(t)},redraw:function(t){if(t){var e=!1,i=this.options;t=this._textColor(t),P.fn.redraw.call(this,t),(t.fontFamily||g(t.fontSize)||t.fontStyle||t.fontWeight)&&(s(i,{fontFamily:t.fontFamily,fontSize:t.fontSize,fontStyle:t.fontStyle,fontWeight:t.fontWeight}),this._font(),this.drawingElement.options.set("font",i.font),e=!0),t.text&&(this.content(t.text),e=!0),!this._updateSize(t)&&e&&this._initSize()}}});s(L.fn,D);var E=P.extend({init:function(t){P.fn.init.call(this,t),this._initPath(),this._setPosition()},_setPosition:function(){var t=this.options,e=t.x,i=t.y;(g(e)||g(i))&&this.position(e||0,i||0)},redraw:function(t){t&&(P.fn.redraw.call(this,t),this._diffNumericOptions(t,[x,b])&&this._drawPath(),this._diffNumericOptions(t,["x","y"])&&this._setPosition())},_initPath:function(){var t=this.options;this.drawingElement=new p.Path({stroke:t.stroke,closed:!0}),this._fill(),this._drawPath()},_drawPath:function(){var t=this.drawingElement,e=K(this.options),i=e.width,n=e.height;t.segments.elements([X(0,0),X(i,0),X(i,n),X(0,n)])}}),z=P.extend({init:function(t){P.fn.init.call(this,t);var e=this.options.anchor;this.anchor=new f.Point(e.x,e.y),this.createElement()},options:{stroke:{color:v,width:0},fill:{color:"black"}},_transformToPath:function(t,e){var i=e.transform();return t&&i&&(t=t.transformCopy(i)),t},redraw:function(t){t&&(t.position&&(this.options.position=t.position),P.fn.redraw.call(this,t))}}),B=z.extend({options:{radius:4,anchor:{x:0,y:0}},createElement:function(){var t=this.options;this.drawingElement=new p.Circle(new f.Circle(this.anchor,t.radius),{fill:t.fill,stroke:t.stroke})},positionMarker:function(t){var e,i,n=this.options.position,o=t.segments;(e=n==y?o[0]:o[o.length-1])&&(i=this._transformToPath(e.anchor(),t),this.drawingElement.transform(f.transform().translate(i.x,i.y)))}}),R=z.extend({options:{path:"M 0 0 L 10 5 L 0 10 L 3 5 z",anchor:{x:10,y:5}},createElement:function(){var t=this.options;this.drawingElement=p.Path.parse(t.path,{fill:t.fill,stroke:t.stroke})},positionMarker:function(t){var e,i,n,o,s=this._linePoints(t),r=s.start,a=s.end,h=f.transform();if(r&&h.rotate((e=r,n=(i=a).x-e.x,o=i.y-e.y,p.util.deg(Math.atan2(o,n))),a),a){var c=this.anchor,d=a.clone().translate(-c.x,-c.y);h.translate(d.x,d.y)}this.drawingElement.transform(h)},_linePoints:function(t){var e,i,n,o=this.options,s=t.segments;if(o.position==y){if(n=s[0]){i=n.anchor(),e=n.controlOut();var r=s[1];!e&&r&&(e=r.anchor())}}else if(n=s[s.length-1]){i=n.anchor(),e=n.controlIn();var a=s[s.length-2];!e&&a&&(e=a.anchor())}if(i)return{start:this._transformToPath(e,t),end:this._transformToPath(i,t)}}}),N={_getPath:function(t){var e=this.drawingElement;if(e instanceof p.MultiPath&&(e=t==y?e.paths[0]:e.paths[e.paths.length-1]),e&&e.segments.length)return e},_normalizeMarkerOptions:function(t){var e=t.startCap,i=t.endCap;l(e)&&(t.startCap={type:e}),l(i)&&(t.endCap={type:i})},_removeMarker:function(t){var e=this._markers[t];e&&(this.drawingContainer().remove(e.drawingElement),delete this._markers[t])},_createMarkers:function(){var t=this.options;this._normalizeMarkerOptions(t),this._markers={},this._markers[y]=this._createMarker(t.startCap,y),this._markers[w]=this._createMarker(t.endCap,w)},_createMarker:function(t,e){var i,n,o=(t||{}).type,r=this._getPath(e);if(r)return o==_.filledCircle?i=B:o==_.arrowStart||o==_.arrowEnd?i=R:this._removeMarker(e),i?((n=new i(s({},t,{position:e}))).positionMarker(r),this.drawingContainer().append(n.drawingElement),n):void 0;this._removeMarker(e)},_positionMarker:function(t){var e=this._markers[t];if(e){var i=this._getPath(t);i?e.positionMarker(i):this._removeMarker(t)}},_capMap:{start:"startCap",end:"endCap"},_redrawMarker:function(t,e,i){this._normalizeMarkerOptions(i);var n=this.options,o=this._capMap[e],r=(n[o]||{}).type,a=i[o],h=!1;return a?(n[o]=s({},n[o],a),a.type&&r!=a.type?(this._removeMarker(e),this._markers[e]=this._createMarker(n[o],e),h=!0):this._markers[e]&&this._markers[e].redraw(a)):t&&!this._markers[e]&&n[o]&&(this._markers[e]=this._createMarker(n[o],e),h=!0),h},_redrawMarkers:function(t,e){!this._redrawMarker(t,y,e)&&t&&this._positionMarker(y),!this._redrawMarker(t,w,e)&&t&&this._positionMarker(w)}},A=P.extend({init:function(t){P.fn.init.call(this,t),this.container=new p.Group,this._createElements(),this._initSize()},options:{autoSize:!0},drawingContainer:function(){return this.container},data:function(t){var e=this.options;if(!t)return e.data;e.data!=t&&(e.data=t,this._setData(t),this._initSize(),this._redrawMarkers(!0,{}))},redraw:function(t){if(t){P.fn.redraw.call(this,t);var e=this.options,i=t.data;g(i)&&e.data!=i?(e.data=i,this._setData(i),this._updateSize(t)||this._initSize(),this._redrawMarkers(!0,t)):(this._updateSize(t),this._redrawMarkers(!1,t))}},_createElements:function(){var t=this.options;this.drawingElement=p.Path.parse(t.data||"",{stroke:t.stroke}),this._fill(),this.container.append(this.drawingElement),this._createMarkers()},_setData:function(t){var e=this.drawingElement,i=p.Path.parse(t||""),n=i.paths.slice(0);i.paths.elements([]),e.paths.elements(n)}});s(A.fn,D),s(A.fn,N);var O=P.extend({init:function(t){P.fn.init.call(this,t),this.container=new p.Group,this._initPath(),this._createMarkers()},drawingContainer:function(){return this.container},redraw:function(t){if(t){var e=(t=t||{}).from,i=t.to;e&&(this.options.from=e),i&&(this.options.to=i),e||i?(this._drawPath(),this._redrawMarkers(!0,t)):this._redrawMarkers(!1,t),P.fn.redraw.call(this,t)}},_initPath:function(){var t=this.options,e=this.drawingElement=new p.Path({stroke:t.stroke});this._fill(),this._drawPath(),this.container.append(e)},_drawPath:function(){var t=this.options,e=this.drawingElement,i=t.from||new r,n=t.to||new r;e.segments.elements([X(i.x,i.y),X(n.x,n.y)])}});s(O.fn,N);var U=P.extend({init:function(t){P.fn.init.call(this,t),this.container=new p.Group,this._initPath(),this._createMarkers()},drawingContainer:function(){return this.container},points:function(t){var e=this.options;if(!t)return e.points;e.points=t,this._updatePath()},redraw:function(t){if(t){var e=t.points;P.fn.redraw.call(this,t),e&&this._pointsDiffer(e)?(this.points(e),this._redrawMarkers(!0,t)):this._redrawMarkers(!1,t)}},_initPath:function(){var t=this.options;this.drawingElement=new p.Path({stroke:t.stroke}),this._fill(),this.container.append(this.drawingElement),t.points&&this._updatePath()},_pointsDiffer:function(t){var e=this.options.points,i=e.length!==t.length;if(!i)for(var n=0;n<t.length;n++)if(e[n].x!==t[n].x||e[n].y!==t[n].y){i=!0;break}return i},_updatePath:function(){for(var t,e=this.drawingElement,i=this.options.points,n=[],o=0;o<i.length;o++)t=i[o],n.push(X(t.x,t.y));e.segments.elements(n)},options:{points:[]}});s(U.fn,N);var V=I.extend({init:function(t){I.fn.init.call(this,t),this._initImage()},redraw:function(t){t&&(t.source&&this.drawingElement.src(t.source),this._diffNumericOptions(t,[x,b,"x","y"])&&this.drawingElement.rect(this._rect()),I.fn.redraw.call(this,t))},_initImage:function(){var t=this.options,e=this._rect();this.drawingElement=new p.Image(t.source,e,{})},_rect:function(){var t=K(this.options),e=new f.Point(t.x,t.y),i=new f.Size(t.width,t.height);return new f.Rect(e,i)}}),H=I.extend({init:function(t){this.children=[],I.fn.init.call(this,t),this.drawingElement=new p.Group,this._initSize()},options:{autoSize:!1},append:function(t){this.drawingElement.append(t.drawingContainer()),this.children.push(t),this._childrenChange=!0},remove:function(t){this._remove(t)&&(this._childrenChange=!0)},_remove:function(t){var e=m(t,this.children);if(e>=0)return this.drawingElement.removeAt(e),this.children.splice(e,1),!0},clear:function(){this.drawingElement.clear(),this.children=[],this._childrenChange=!0},toFront:function(t){for(var e,i=0;i<t.length;i++)e=t[i],this._remove(e)&&this.append(e)},toBack:function(t){this._reorderChildren(t,0)},toIndex:function(t,e){this._reorderChildren(t,e)},_reorderChildren:function(t,e){var i,n,o,s,r,a=this.drawingElement,h=a.children.slice(0),c=this.children,l=d(e);for(i=0;i<t.length;i++)s=(r=t[i]).drawingContainer(),(n=m(r,c))>=0&&(h.splice(n,1),c.splice(n,1),o=l?e:e[i],h.splice(o,0,s),c.splice(o,0,r));a.clear(),a.append.apply(a,h)},redraw:function(t){t&&(this._childrenChange?(this._childrenChange=!1,this._updateSize(t)||this._initSize()):this._updateSize(t),I.fn.redraw.call(this,t))},_boundingBox:function(){for(var t,e,i,n=this.children,o=0;o<n.length;o++)(e=n[o]).visible()&&!1!==e._includeInBBox&&(i=e.drawingContainer().clippedBBox(null))&&(t=t?f.Rect.union(t,i):i);return t}});s(H.fn,D);var F=H.extend({init:function(t,e){this.children=[],I.fn.init.call(this,e),this.drawingElement=new p.Layout(Y(t),e),this._initSize()},rect:function(t){if(t)this.drawingElement.rect(Y(t));else{var e=this.drawingElement.rect();if(e)return new a(e.origin.x,e.origin.y,e.size.width,e.size.height)}},reflow:function(){this.drawingElement.reflow()},redraw:function(t){i.deepExtend(this.drawingElement.options,t),H.fn.redraw.call(this,t)}}),G=P.extend({init:function(t){P.fn.init.call(this,t),this._initCircle(),this._initSize()},redraw:function(t){if(t){var e=this.options;t.center&&(s(e,{center:t.center}),this._center.move(e.center.x,e.center.y)),this._diffNumericOptions(t,["radius"])&&this._circle.setRadius(e.radius),this._updateSize(t),P.fn.redraw.call(this,t)}},_initCircle:function(){var t=this.options,e=t.width,i=t.height,n=t.radius;g(n)||(g(e)||(e=i),g(i)||(i=e),t.radius=n=Math.min(e,i)/2);var o=t.center||{x:n,y:n};this._center=new f.Point(o.x,o.y),this._circle=new f.Circle(this._center,n),this.drawingElement=new p.Circle(this._circle,{stroke:t.stroke}),this._fill()}});s(G.fn,D);var q=o.extend({init:function(t,e){e=e||{},this.element=t,this.surface=p.Surface.create(t,e),i.isFunction(this.surface.translate)&&(this.translate=this._translate),this.drawingElement=new p.Group,this._viewBox=new a(0,0,e.width,e.height),this.size(this._viewBox)},bounds:function(){var t=this.drawingElement.clippedBBox();return new a(0,0,t.width(),t.height())},size:function(t){var e=this._viewBox;return g(t)&&(e.width=t.width,e.height=t.height,this.surface.setSize(t)),{width:e.width,height:e.height}},_translate:function(t,e){var i=this._viewBox;return g(t)&&g(e)&&(i.x=t,i.y=e,this.surface.translate({x:t,y:e})),{x:i.x,y:i.y}},draw:function(){this.surface.draw(this.drawingElement)},append:function(t){return this.drawingElement.append(t.drawingContainer()),this},remove:function(t){this.drawingElement.remove(t.drawingContainer())},insertBefore:function(){},clear:function(){this.drawingElement.clear()},destroy:function(e){this.surface.destroy(),e&&t(this.element).remove()}});function K(t){return{x:t.x||0,y:t.y||0,width:t.width||0,height:t.height||0}}function W(t){if(t){var e=t;return l(e)&&(e={color:e}),e.color&&(e.color=j(e.color)),e}}function j(t){return t!=v?new p.Color(t).toHex():t}function X(t,e){return new f.Segment(new f.Point(t,e))}function Y(t){if(t)return new f.Rect([t.x,t.y],[t.width,t.height])}i.deepExtend(n,{init:function(t){i.init(t,n.ui)},diffNumericOptions:C,Element:I,Scale:S,Translation:k,Rotation:T,Circle:G,Group:H,Rectangle:E,Canvas:q,Path:A,Layout:F,Line:O,MarkerBase:z,ArrowMarker:R,CircleMarker:B,Polyline:U,CompositeTransform:M,TextBlock:L,Image:V,VisualBase:P})}(window.kendo.jQuery),function(t,e){var i=window.kendo,n=i.dataviz.diagram,o=i.Class,s=n.Group,r=n.Rect,a=n.Rectangle,h=n.Utils,c=h.isUndefined,d=n.Point,l=n.Circle,u=n.Ticker,f=i.deepExtend,p=i.ui.Movable,g=i.drawing.util,m=g.defined,v=t.inArray,_={arrow:"default",grip:"pointer",cross:"pointer",add:"pointer",move:"move",select:"pointer",south:"s-resize",east:"e-resize",west:"w-resize",north:"n-resize",rowresize:"row-resize",colresize:"col-resize"},y=10,w="Auto",x="Top",b="Right",C="Left",S="Bottom",k="dragStart",T="drag",M="dragEnd",D="itemBoundsChange",I="transparent",P="rotated",L="target",E={"-1":"source",1:L};n.Cursors=_;var z=i.Class.extend({init:function(t){this.layoutState=t,this.diagram=t.diagram},initState:function(){this.froms=[],this.tos=[],this.subjects=[],this.layoutState.nodeMap.forEach((function(t,e){var i=this.diagram.getShapeById(t);i&&(this.subjects.push(i),this.froms.push(i.bounds().topLeft()),this.tos.push(e.topLeft()))}),this)},update:function(t){if(!(this.subjects.length<=0))for(var e=0;e<this.subjects.length;e++)this.subjects[e].position(new d(this.froms[e].x+(this.tos[e].x-this.froms[e].x)*t,this.froms[e].y+(this.tos[e].y-this.froms[e].y)*t))}}),B=o.extend({init:function(t,e,i){c(i)?this.animate=!1:this.animate=i,this._initialState=t,this._finalState=e,this.title="Diagram layout"},undo:function(){this.setState(this._initialState)},redo:function(){this.setState(this._finalState)},setState:function(t){var e=t.diagram;if(this.animate){t.linkMap.forEach((function(t,i){var n=e.getShapeById(t);n.visible(!1),n&&n.points(i)}));var i=new u;i.addAdapter(new z(t)),i.onComplete((function(){t.linkMap.forEach((function(t){e.getShapeById(t).visible(!0)}))})),i.play()}else t.nodeMap.forEach((function(t,i){var n=e.getShapeById(t);n&&n.position(i.topLeft())})),t.linkMap.forEach((function(t,i){var n=e.getShapeById(t);n&&n.points(i)}))}}),R=o.extend({init:function(t){this.units=[],this.title="Composite unit",t!==e&&this.units.push(t)},add:function(t){this.units.push(t)},undo:function(){for(var t=0;t<this.units.length;t++)this.units[t].undo()},redo:function(){for(var t=0;t<this.units.length;t++)this.units[t].redo()}}),N=o.extend({init:function(t,e,i){this.item=t,this._redoSource=e,this._redoTarget=i,m(e)&&(this._undoSource=t.source()),m(i)&&(this._undoTarget=t.target()),this.title="Connection Editing"},undo:function(){this._undoSource!==e&&this.item._updateConnector(this._undoSource,"source"),this._undoTarget!==e&&this.item._updateConnector(this._undoTarget,"target"),this.item.updateModel()},redo:function(){this._redoSource!==e&&this.item._updateConnector(this._redoSource,"source"),this._redoTarget!==e&&this.item._updateConnector(this._redoTarget,"target"),this.item.updateModel()}}),A=o.extend({init:function(t,e,i){this.item=t,this._undoSource=e,this._undoTarget=i,this._redoSource=t.source(),this._redoTarget=t.target(),this.title="Connection Editing"},undo:function(){this.item._updateConnector(this._undoSource,"source"),this.item._updateConnector(this._undoTarget,"target"),this.item.updateModel()},redo:function(){this.item._updateConnector(this._redoSource,"source"),this.item._updateConnector(this._redoTarget,"target"),this.item.updateModel()}}),O=o.extend({init:function(t){this.connection=t,this.diagram=t.diagram,this.targetConnector=t.targetConnector,this.title="Delete connection"},undo:function(){this.diagram._addConnection(this.connection,!1)},redo:function(){this.diagram.remove(this.connection,!1)}}),U=o.extend({init:function(t){this.shape=t,this.diagram=t.diagram,this.title="Deletion"},undo:function(){this.diagram._addShape(this.shape,!1),this.shape.select(!1)},redo:function(){this.shape.select(!1),this.diagram.remove(this.shape,!1)}}),V=o.extend({init:function(t,e,i){this.shapes=t,this.undoStates=e,this.title="Transformation",this.redoStates=[],this.adorner=i;for(var n=0;n<this.shapes.length;n++){var o=this.shapes[n];this.redoStates.push(o.bounds())}},undo:function(){for(var t=0;t<this.shapes.length;t++){var e=this.shapes[t];e.bounds(this.undoStates[t]),e.hasOwnProperty("layout")&&e.layout(e,this.redoStates[t],this.undoStates[t]),e.updateModel()}this.adorner&&(this.adorner.refreshBounds(),this.adorner.refresh())},redo:function(){for(var t=0;t<this.shapes.length;t++){var e=this.shapes[t];e.bounds(this.redoStates[t]),e.hasOwnProperty("layout")&&e.layout(e,this.undoStates[t],this.redoStates[t]),e.updateModel()}this.adorner&&(this.adorner.refreshBounds(),this.adorner.refresh())}}),H=o.extend({init:function(t,e){this.connection=t,this.diagram=e,this.title="New connection"},undo:function(){this.diagram.remove(this.connection,!1)},redo:function(){this.diagram._addConnection(this.connection,!1)}}),F=o.extend({init:function(t,e){this.shape=t,this.diagram=e,this.title="New shape"},undo:function(){this.diagram.deselect(),this.diagram.remove(this.shape,!1)},redo:function(){this.diagram._addShape(this.shape,!1)}}),G=o.extend({init:function(t,e,i){this.initial=t,this.finalPos=e,this.diagram=i,this.title="Pan Unit"},undo:function(){this.diagram.pan(this.initial)},redo:function(){this.diagram.pan(this.finalPos)}}),q=o.extend({init:function(t,e,i){this.shapes=e,this.undoRotates=i,this.title="Rotation",this.redoRotates=[],this.redoAngle=t._angle,this.adorner=t,this.center=t._innerBounds.center();for(var n=0;n<this.shapes.length;n++){var o=this.shapes[n];this.redoRotates.push(o.rotate().angle)}},undo:function(){var t,e;for(t=0;t<this.shapes.length;t++)(e=this.shapes[t]).rotate(this.undoRotates[t],this.center,!1),e.hasOwnProperty("layout")&&e.layout(e),e.updateModel();this.adorner&&(this.adorner._initialize(),this.adorner.refresh())},redo:function(){var t,e;for(t=0;t<this.shapes.length;t++)(e=this.shapes[t]).rotate(this.redoRotates[t],this.center,!1),e.hasOwnProperty("layout")&&e.layout(e),e.updateModel();this.adorner&&(this.adorner._initialize(),this.adorner.refresh())}}),K=o.extend({init:function(t,e,i){this.diagram=t,this.indices=i,this.items=e,this.title="Rotate Unit"},undo:function(){this.diagram._toIndex(this.items,this.indices)},redo:function(){this.diagram.toFront(this.items,!1)}}),W=o.extend({init:function(t,e,i){this.diagram=t,this.indices=i,this.items=e,this.title="Rotate Unit"},undo:function(){this.diagram._toIndex(this.items,this.indices)},redo:function(){this.diagram.toBack(this.items,!1)}}),j=i.Observable.extend({init:function(t){i.Observable.fn.init.call(this,t),this.bind(this.events,t),this.stack=[],this.index=0,this.capacity=100},events:["undone","redone"],begin:function(){this.composite=new R},cancel:function(){this.composite=e},commit:function(t){this.composite.units.length>0&&this._restart(this.composite,t),this.composite=e},addCompositeItem:function(t){this.composite?this.composite.add(t):this.add(t)},add:function(t,e){this._restart(t,e)},pop:function(){this.index>0&&(this.stack.pop(),this.index--)},count:function(){return this.stack.length},undo:function(){this.index>0&&(this.index--,this.stack[this.index].undo(),this.trigger("undone"))},redo:function(){this.stack.length>0&&this.index<this.stack.length&&(this.stack[this.index].redo(),this.index++,this.trigger("redone"))},_restart:function(t,e){this.stack.splice(this.index,this.stack.length-this.index),this.stack.push(t),!1!==e?this.redo():this.index++,this.stack.length>this.capacity&&(this.stack.splice(0,this.stack.length-this.capacity),this.index=this.capacity)},clear:function(){this.stack=[],this.index=0}}),X=o.extend({init:function(t){this.toolService=t},start:function(){},move:function(){},end:function(){},tryActivate:function(){return!1},getCursor:function(){return _.arrow}}),Y=X.extend({init:function(e){var n=this,o=i.support.mobileOS?.93:.9;X.fn.init.call(n,e);var s=n.toolService.diagram,r=s.canvas,a=s.scroller=n.scroller=t(s.scrollable).kendoMobileScroller({friction:o,velocityMultiplier:5,mousewheelScrolling:!1,zoom:!1,scroll:n._move.bind(n)}).data("kendoMobileScroller");r.translate&&(n.movableCanvas=new p(r.element));var h=function(t,e,i){t.makeVirtual(),t.virtualSize(e||-2e4,i||2e4)};h(a.dimensions.x),h(a.dimensions.y),a.disable()},tryActivate:function(t,e){var i=this.toolService,n=i.diagram.options.pannable,o=e.ctrlKey;return m(n.key)&&(o=n.key&&"none"!=n.key?e[n.key+"Key"]:ft(e)&&!m(i.hoveredItem)),!1!==n&&o&&!m(i.hoveredAdorner)&&!m(i._hoveredConnector)},start:function(){this.scroller.enable()},move:function(){},_move:function(t){var e=this.toolService.diagram,i=e.canvas,n=new d(t.scrollLeft,t.scrollTop);i.translate?(e._storePan(n.times(-1)),this.movableCanvas.moveTo(n),i.translate(n.x,n.y)):n=n.plus(e._pan.times(-1)),e.trigger("pan",{pan:n})},end:function(){this.scroller.disable()},getCursor:function(){return _.move}}),J=o.extend({init:function(t){this.toolService=t},tryActivate:function(){return!0},start:function(t,e){var i=this.toolService,n=i.diagram,o=i.hoveredItem;o&&(i.selectSingle(o,e),o.adorner&&(this.adorner=o.adorner,this.handle=this.adorner._hitTest(t))),this.handle||(this.handle=n._resizingAdorner._hitTest(t),this.handle&&(this.adorner=n._resizingAdorner)),this.adorner&&(this.adorner.isDragHandle(this.handle)&&n.trigger(k,{shapes:this.adorner.shapes,connections:[]})?(i.startPoint=t,i.end(t)):this.adorner.start(t))},move:function(t){this.adorner&&(this.adorner.move(this.handle,t),this.adorner.isDragHandle(this.handle)&&this.toolService.diagram.trigger(T,{shapes:this.adorner.shapes,connections:[]}))},end:function(){var t,i=this.toolService.diagram,n=this.adorner;n&&(n.isDragHandle(this.handle)&&i.trigger(M,{shapes:n.shapes,connections:[]})?n.cancel():(t=n.stop())&&i.undoRedoService.add(t,!1)),this.adorner=e,this.handle=e},getCursor:function(t){return this.toolService.hoveredItem?this.toolService.hoveredItem._getCursor(t):_.arrow}}),Q=o.extend({init:function(t){this.toolService=t},tryActivate:function(t,e){var i=this.toolService,n=i.diagram.options.selectable,o=n&&!1!==n.multiple;return o&&(o=n.key&&"none"!=n.key?e[n.key+"Key"]:ft(e)),o&&!m(i.hoveredItem)&&!m(i.hoveredAdorner)},start:function(t){var e=this.toolService.diagram;e.deselect(),e.selector.start(t)},move:function(t){this.toolService.diagram.selector.move(t)},end:function(t,e){var i=this.toolService.diagram,n=this.toolService.hoveredItem,o=i.selector.bounds();n&&n.isSelected||e.ctrlKey||i.deselect(),o.isEmpty()||i.selectArea(o),i.selector.end()},getCursor:function(){return _.arrow}}),Z=o.extend({init:function(t){this.toolService=t,this.type="ConnectionTool"},tryActivate:function(){return this.toolService._hoveredConnector},start:function(t,e){var i=this.toolService,n=i.diagram,o=i._hoveredConnector,s=n._createConnection({},o._c,t);ut(s)&&!n.trigger(k,{shapes:[],connections:[s],connectionHandle:L})&&n._addConnection(s)?(i._connectionManipulation(s,o._c.shape,!0),i._removeHover(),i.selectSingle(i.activeConnection,e),"touchmove"==e.type&&(n._cachedTouchTarget=o.visual)):(s.source(null),i.end(t))},move:function(t){var e=this.toolService,i=e.activeConnection;return i.target(t),e.diagram.trigger(T,{shapes:[],connections:[i],connectionHandle:L}),!0},end:function(t){var e,i=this.toolService,o=i.diagram,s=i.activeConnection,r=i.hoveredItem,a=i._hoveredConnector,h=o._cachedTouchTarget;s&&(e=a&&a._c!=s.sourceConnector?a._c:r&&r instanceof n.Shape?r.getConnector(w)||r.getConnector(t):t,s.target(e),o.trigger(M,{shapes:[],connections:[s],connectionHandle:L})?(o.remove(s,!1),o.undoRedoService.pop()):(s.updateModel(),o._syncConnectionChanges()),i._connectionManipulation(),h&&(o._connectorsAdorner.visual.remove(h),o._cachedTouchTarget=null))},getCursor:function(){return _.arrow}}),$=o.extend({init:function(t){this.toolService=t,this.type="ConnectionTool"},tryActivate:function(t,e){var i=this.toolService,n=i.diagram.options.selectable,o=i.hoveredItem,s=!1!==n&&o&&o.path&&!(o.isSelected&&e.ctrlKey);return s&&(this._c=o),s},start:function(t,e){var i=this.toolService,n=this._c;i.selectSingle(n,e);var o,s,r=n.adorner;r&&(o=r._hitTest(t),s=E[o]),ut(n)&&r&&!i.diagram.trigger(k,{shapes:[],connections:[n],connectionHandle:s})?(this.handle=o,this.handleName=s,r.start(t)):(i.startPoint=t,i.end(t))},move:function(t){var e=this._c.adorner;if(ut(this._c)&&e)return e.move(this.handle,t),this.toolService.diagram.trigger(T,{shapes:[],connections:[this._c],connectionHandle:this.handleName}),!0},end:function(t){var e=this._c,i=e.adorner,n=this.toolService.diagram;if(i&&ut(e)){var o=i.stop(t);n.trigger(M,{shapes:[],connections:[e],connectionHandle:this.handleName})?o.undo():(n.undoRedoService.add(o,!1),e.updateModel(),n._syncConnectionChanges())}},getCursor:function(){return _.move}});function tt(t,e){return e.charCodeAt(0)==t||e.toUpperCase().charCodeAt(0)==t}var et=o.extend({init:function(t){this.diagram=t,this.tools=[new Y(this),new $(this),new Z(this),new Q(this),new J(this)],this.activeTool=e},start:function(t,e){return e=f({},e),this.activeTool&&this.activeTool.end(t,e),this._updateHoveredItem(t),this._activateTool(t,e),this.activeTool.start(t,e),this._updateCursor(t),this.diagram.focus(),this.diagram.canvas.surface.suspendTracking(),this.startPoint=t,!0},move:function(t,e){e=f({},e);var i=!0;return this.activeTool&&(i=this.activeTool.move(t,e)),i&&this._updateHoveredItem(t),this._updateCursor(t),!0},end:function(t,i){return i=f({},i),this.activeTool&&this.activeTool.end(t,i),this.diagram.canvas.surface.resumeTracking(),this.activeTool=e,this._updateCursor(t),!0},keyDown:function(t,e){var i=this.diagram;if(!(e=f({ctrlKey:!1,metaKey:!1,altKey:!1},e)).ctrlKey&&!e.metaKey||e.altKey){if(46===t||8===t){var n=this.diagram._triggerRemove(i.select());return n.length&&(this.diagram.remove(n,!0),this.diagram._syncChanges(),this.diagram._destroyToolBar()),!0}if(27===t)return this._discardNewConnection(),i.deselect(),i._destroyToolBar(),!0}else{if(tt(t,"a"))return i.selectAll(),i._destroyToolBar(),!0;if(tt(t,"z"))return i.undo(),i._destroyToolBar(),!0;if(tt(t,"y"))return i.redo(),i._destroyToolBar(),!0;tt(t,"c")?(i.copy(),i._destroyToolBar()):tt(t,"x")?(i.cut(),i._destroyToolBar()):tt(t,"v")?(i.paste(),i._destroyToolBar()):tt(t,"l")?(i.layout(),i._destroyToolBar()):tt(t,"d")&&(i._destroyToolBar(),i.copy(),i.paste())}},wheel:function(t,e){var n=this.diagram,o=e.delta,s=n.zoom(),r=n.options,a=r.zoomRate,h={point:t,meta:e,zoom:s};if(!n.trigger("zoomStart",h))return o<0?s+=a:s-=a,s=i.drawing.util.round(Math.max(r.zoomMin,Math.min(r.zoomMax,s)),2),h.zoom=s,n.zoom(s,h),n.trigger("zoomEnd",h),!0},setTool:function(t,e){t.toolService=this,this.tools[e]=t},selectSingle:function(t,e){var i=this.diagram,n=i.options.selectable;if(n&&!t.isSelected&&!1!==t.options.selectable){var o=e.ctrlKey&&!1!==n.multiple;i.select(t,{addToSelection:o})}},_discardNewConnection:function(){this.newConnection&&(this.diagram.remove(this.newConnection),this.newConnection=e)},_activateTool:function(t,e){for(var i=0;i<this.tools.length;i++){var n=this.tools[i];if(n.tryActivate(t,e)){this.activeTool=n;break}}},_updateCursor:function(t){var e=this.diagram.element,i=this.activeTool?this.activeTool.getCursor(t):this.hoveredAdorner?this.hoveredAdorner._getCursor(t):this.hoveredItem?this.hoveredItem._getCursor(t):_.arrow;e.css({cursor:i})},_connectionManipulation:function(t,i,n){this.activeConnection=t,this.disabledShape=i,this.newConnection=n?this.activeConnection:e},_updateHoveredItem:function(t){var i=this._hitTest(t),n=this.diagram;i==this.hoveredItem||this.disabledShape&&i==this.disabledShape||(this.hoveredItem&&(n.trigger("mouseLeave",{item:this.hoveredItem}),this.hoveredItem._hover(!1)),i&&i.options.enable?(n.trigger("mouseEnter",{item:i}),this.hoveredItem=i,this.hoveredItem._hover(!0)):this.hoveredItem=e)},_removeHover:function(){this.hoveredItem&&(this.hoveredItem._hover(!1),this.hoveredItem=e)},_hitTest:function(t){var i,o,s,r=this.diagram;if(this._hoveredConnector&&(this._hoveredConnector._hover(!1),this._hoveredConnector=e),r._connectorsAdorner._visible&&(i=r._connectorsAdorner._hitTest(t)))return i;if(i=this.diagram._resizingAdorner._hitTest(t)){if(this.hoveredAdorner=r._resizingAdorner,0!==i.x||0!==i.y)return;i=e}else this.hoveredAdorner=e;if(!this.activeTool||"ConnectionTool"!==this.activeTool.type){var a=[];for(s=0;s<r._selectedItems.length;s++)(o=r._selectedItems[s])instanceof n.Connection&&a.push(o);i=this._hitTestItems(a,t)}return i||this._hitTestElements(t)},_hitTestElements:function(t){var e,i=this.diagram,n=this._hitTestItems(i.shapes,t),o=this._hitTestItems(i.connections,t);if((!this.activeTool||"ConnectionTool"!=this.activeTool.type)&&n&&o&&!function(t,e){for(var i,n,o,s=0;s<t.connectors.length;s++)if(n=(i=t.connectors[s]).position(),(o=new r(n.x,n.y)).inflate(y,y),o.contains(e))return i}(n,t)){var s=i.mainLayer;e=v(n.visual,s.children)>v(o.visual,s.children)?n:o}return e||n||o},_hitTestItems:function(t,e){var i,n;for(i=t.length-1;i>=0;i--)if(n=t[i]._hitTest(e))return n}}),it=i.Class.extend({init:function(){}}),nt=it.extend({init:function(t){it.fn.init.call(this),this.connection=t},hitTest:function(t){return!!this.getBounds().inflate(y).contains(t)&&n.Geometry.distanceToPolyline(t,this.connection.allPoints())<y},getBounds:function(){for(var t=this.connection.allPoints(),e=t[0],i=t[t.length-1],n=Math.max(e.x,i.x),o=Math.min(e.x,i.x),s=Math.min(e.y,i.y),a=Math.max(e.y,i.y),h=1;h<t.length-1;++h)n=Math.max(n,t[h].x),o=Math.min(o,t[h].x),s=Math.min(s,t[h].y),a=Math.max(a,t[h].y);return new r(o,s,n-o,a-s)}}),ot=nt.extend({init:function(t){nt.fn.init.call(this),this.connection=t},route:function(){}}),st=nt.extend({SAME_SIDE_DISTANCE_RATIO:5,init:function(t){nt.fn.init.call(this),this.connection=t},routePoints:function(t,e,i,n){return i&&n?this._connectorPoints(t,e,i,n):this._floatingPoints(t,e,i)},route:function(){var t=this.connection._resolvedSourceConnector,e=this.connection._resolvedTargetConnector,i=this.connection.sourcePoint(),n=this.connection.targetPoint(),o=this.routePoints(i,n,t,e);this.connection.points(o)},_connectorSides:[{name:"Top",axis:"y",boundsPoint:"topLeft",secondarySign:1},{name:"Left",axis:"x",boundsPoint:"topLeft",secondarySign:1},{name:"Bottom",axis:"y",boundsPoint:"bottomRight",secondarySign:-1},{name:"Right",axis:"x",boundsPoint:"bottomRight",secondarySign:-1}],_connectorSide:function(t,e){for(var i,n,o,s,r=t.position(),a=t.shape.bounds(P),h={topLeft:a.topLeft(),bottomRight:a.bottomRight()},c=this._connectorSides,d=g.MAX_NUM,l=0;l<c.length;l++)o=(s=c[l]).axis,(i=Math.round(Math.abs(r[o]-h[s.boundsPoint][o])))<d?(d=i,n=s):i===d&&(r[o]-e[o])*s.secondarySign>(r[n.axis]-e[n.axis])*n.secondarySign&&(n=s);return n.name},_sameSideDistance:function(t){var e=t.shape.bounds(P);return Math.min(e.width,e.height)/this.SAME_SIDE_DISTANCE_RATIO},_connectorPoints:function(t,e,i,n){var o,s,r=this._connectorSide(i,e),a=this._connectorSide(n,t),h=e.x-t.x,c=e.y-t.y,l=this._sameSideDistance(i),u=[];return r===x||r==S?a==x||a==S?r==a?(s=r==x?Math.min(t.y,e.y)-l:Math.max(t.y,e.y)+l,u=[new d(t.x,s),new d(e.x,s)]):u=[new d(t.x,t.y+c/2),new d(e.x,t.y+c/2)]:u=[new d(t.x,e.y)]:a==C||a==b?r==a?(o=r==C?Math.min(t.x,e.x)-l:Math.max(t.x,e.x)+l,u=[new d(o,t.y),new d(o,e.y)]):u=[new d(t.x+h/2,t.y),new d(t.x+h/2,t.y+c)]:u=[new d(e.x,t.y)],u},_floatingPoints:function(t,e,i){for(var n,o,s=i?this._connectorSide(i,e):null,r=this._startHorizontal(t,e,s),a=[t,t,e,e],h=e.x-t.x,c=e.y-t.y,l=a.length,u=1;u<l-1;++u)r?u%2!=0?(n=h/(l/2),o=0):(n=0,o=c/((l-1)/2)):u%2!=0?(n=0,o=c/(l/2)):(n=h/((l-1)/2),o=0),a[u]=new d(a[u-1].x+n,a[u-1].y+o);return u--,a[l-2]=r&&u%2!=0||!r&&u%2==0?new d(a[l-1].x,a[l-2].y):new d(a[l-2].x,a[l-1].y),[a[1],a[2]]},_startHorizontal:function(t,e,i){return null!==i&&(i===b||i===C)||Math.abs(t.x-e.x)>Math.abs(t.y-e.y)}}),rt=o.extend({init:function(t,e){var i=this;i.diagram=t,i.options=f({},i.options,e),i.visual=new s,i.diagram._adorners.push(i)},refresh:function(){}}),at=rt.extend({init:function(t,e){var i,n=this;n.connection=t,i=n.connection.diagram,n._ts=i.toolService,rt.fn.init.call(n,i,e);var o=n.connection.sourcePoint(),s=n.connection.targetPoint();n.spVisual=new l(f(n.options.handles,{center:o})),n.epVisual=new l(f(n.options.handles,{center:s})),n.visual.append(n.spVisual),n.visual.append(n.epVisual)},options:{handles:{}},_getCursor:function(){return _.move},start:function(t){switch(this.handle=this._hitTest(t),this.startPoint=t,this._initialSource=this.connection.source(),this._initialTarget=this.connection.target(),this.handle){case-1:this.connection.targetConnector&&this._ts._connectionManipulation(this.connection,this.connection.targetConnector.shape);break;case 1:this.connection.sourceConnector&&this._ts._connectionManipulation(this.connection,this.connection.sourceConnector.shape)}},move:function(t,e){switch(t){case-1:this.connection.source(e);break;case 1:this.connection.target(e);break;default:var i=e.minus(this.startPoint);this.startPoint=e,this.connection.sourceConnector||this.connection.source(this.connection.sourcePoint().plus(i)),this.connection.targetConnector||this.connection.target(this.connection.targetPoint().plus(i))}return this.refresh(),!0},stop:function(t){var i,o=this.diagram.toolService,s=o.hoveredItem;return i=o._hoveredConnector?o._hoveredConnector._c:s&&s instanceof n.Shape?s.getConnector(w)||s.getConnector(t):t,-1===this.handle?this.connection.source(i):1===this.handle&&this.connection.target(i),this.handle=e,this._ts._connectionManipulation(),new A(this.connection,this._initialSource,this._initialTarget)},_hitTest:function(t){var e=this.connection.sourcePoint(),i=this.connection.targetPoint(),n=this.options.handles.width/2+y,o=this.options.handles.height/2+y,s=e.distanceTo(t),a=i.distanceTo(t),h=new r(e.x,e.y).inflate(n,o).contains(t),c=new r(i.x,i.y).inflate(n,o).contains(t),d=0;return h&&(!c||s<a)?d=-1:c&&(!h||a<s)&&(d=1),d},refresh:function(){this.spVisual.redraw({center:this.diagram.modelToLayer(this.connection.sourcePoint())}),this.epVisual.redraw({center:this.diagram.modelToLayer(this.connection.targetPoint())})}}),ht=rt.extend({init:function(t,e){var i=this;rt.fn.init.call(i,t,e),i._refreshHandler=function(t){t.item==i.shape&&i.refresh()}},show:function(t){var e,i,n,o=this;for(o._visible=!0,o.shape=t,o.diagram.bind(D,o._refreshHandler),e=t.connectors.length,o.connectors=[],o._clearVisual(),i=0;i<e;i++)n=new lt(t.connectors[i]),o.connectors.push(n),o.visual.append(n.visual);o.visual.visible(!0),o.refresh()},_clearVisual:function(){var t=this;t.diagram._cachedTouchTarget?t._keepCachedTouchTarget():t.visual.clear()},_keepCachedTouchTarget:function(){for(var t=this,e=t.visual.children,i=e.length,n=v(t.diagram._cachedTouchTarget,e),o=i-1;o>=0;o--)o!=n&&t.visual.remove(e[o])},destroy:function(){var t=this;t.diagram.unbind(D,t._refreshHandler),t.shape=e,t._visible=e,t.visual.visible(!1)},_hitTest:function(t){var e,i;for(i=0;i<this.connectors.length;i++)if((e=this.connectors[i])._hitTest(t)){e._hover(!0),this.diagram.toolService._hoveredConnector=e;break}},refresh:function(){if(this.shape){var e=this.shape.bounds();e=this.diagram.modelToLayer(e),this.visual.position(e.topLeft()),t.each(this.connectors,(function(){this.refresh()}))}}});var ct=rt.extend({init:function(t,e){var i=this;rt.fn.init.call(i,t,e),i._manipulating=!1,i.map=[],i.shapes=[],i._initSelection(),i._createHandles(),i.redraw(),i.diagram.bind("select",(function(t){i._initialize(t.selected)})),i._refreshHandler=function(){i._internalChange||(i.refreshBounds(),i.refresh())},i._rotatedHandler=function(){1==i.shapes.length&&(i._angle=i.shapes[0].rotate().angle),i._refreshHandler()},i.diagram.bind(D,i._refreshHandler).bind("itemRotate",i._rotatedHandler),i.refreshBounds(),i.refresh()},options:{handles:{fill:{color:"#fff"},stroke:{color:"#282828"},height:7,width:7,hover:{fill:{color:"#282828"},stroke:{color:"#282828"}}},selectable:{stroke:{color:"#778899",width:1,dashType:"dash"},fill:{color:I}},offset:10},_initSelection:function(){var t=this,e=t.diagram.options.selectable,i=f({},t.options.selectable,e);t.rect=new a(i),t.visual.append(t.rect)},_resizable:function(){return this.options.editable&&!1!==this.options.editable.resize},_handleOptions:function(){return(this.options.editable.resize||{}).handles||this.options.handles},_createHandles:function(){var t,e,i,n;if(this._resizable())for(t=this._handleOptions(),n=-1;n<=1;n++)for(i=-1;i<=1;i++)0===n&&0===i||((e=new a(t)).drawingElement._hover=this._hover.bind(this),this.map.push({x:n,y:i,visual:e}),this.visual.append(e))},bounds:function(t){if(!t)return this._bounds;this._innerBounds=t.clone(),this._bounds=this.diagram.modelToLayer(t).inflate(this.options.offset,this.options.offset)},_hitTest:function(t){var e,i,n,o,s=this.diagram.modelToLayer(t),r=this.map.length;if(this._angle&&(s=s.clone().rotate(this._angle,this._bounds.center())),this._resizable())for(e=0;e<r;e++)if(o=this.map[e],i=new d(o.x,o.y),(n=this._getHandleBounds(i)).offset(this._bounds.x,this._bounds.y),n.contains(s))return i;if(this._bounds.contains(s))return new d(0,0)},_getHandleBounds:function(t){if(this._resizable()){var e=this._handleOptions(),i=e.width,n=e.height,o=new r(0,0,i,n);return t.x<0?o.x=-i/2:0===t.x?o.x=Math.floor(this._bounds.width/2)-i/2:t.x>0&&(o.x=this._bounds.width+1-i/2),t.y<0?o.y=-n/2:0===t.y?o.y=Math.floor(this._bounds.height/2)-n/2:t.y>0&&(o.y=this._bounds.height+1-n/2),o}},_getCursor:function(t){var e=this._hitTest(t);if(e&&e.x>=-1&&e.x<=1&&e.y>=-1&&e.y<=1&&this._resizable()){var i=this._angle;if(i&&(e.rotate(i,new d(0,0)),e=new d(Math.round(e.x),Math.round(e.y))),-1==e.x&&-1==e.y)return"nw-resize";if(1==e.x&&1==e.y)return"se-resize";if(-1==e.x&&1==e.y)return"sw-resize";if(1==e.x&&-1==e.y)return"ne-resize";if(0===e.x&&-1==e.y)return"n-resize";if(0===e.x&&1==e.y)return"s-resize";if(1==e.x&&0===e.y)return"e-resize";if(-1==e.x&&0===e.y)return"w-resize"}return this._manipulating?_.move:_.select},_initialize:function(){var t,e,i=this,o=i.diagram.select();for(i.shapes=[],t=0;t<o.length;t++)(e=o[t])instanceof n.Shape&&(i.shapes.push(e),e._rotationOffset=new d);i._angle=1==i.shapes.length?i.shapes[0].rotate().angle:0,i._startAngle=i._angle,i._rotates(),i._positions(),i.refreshBounds(),i.refresh(),i.redraw()},_rotates:function(){var t,e,i=this;for(i.initialRotates=[],t=0;t<i.shapes.length;t++)e=i.shapes[t],i.initialRotates.push(e.rotate().angle)},_positions:function(){var t,e,i=this;for(i.initialStates=[],t=0;t<i.shapes.length;t++)e=i.shapes[t],i.initialStates.push(e.bounds())},_hover:function(t,e){if(this._resizable()){var i=this._handleOptions(),n=i.hover,o=i.stroke,s=i.fill;t&&h.isDefined(n.stroke)&&(o=f({},o,n.stroke)),t&&h.isDefined(n.fill)&&(s=n.fill),e.stroke(o.color,o.width,o.opacity),e.fill(s.color,s.opacity)}},start:function(t){this._sp=t,this._cp=t,this._lp=t,this._manipulating=!0,this._internalChange=!0,this.shapeStates=[];for(var e=0;e<this.shapes.length;e++){var i=this.shapes[e];this.shapeStates.push(i.bounds())}},redraw:function(){var t,e=this._resizable();for(t=0;t<this.map.length;t++)this.map[t].visual.visible(e)},angle:function(t){return m(t)&&(this._angle=t),this._angle},rotate:function(){var t=this._innerBounds.center(),e=this.angle();this._internalChange=!0;for(var i=0;i<this.shapes.length;i++){var n=this.shapes[i];e=(e+this.initialRotates[i]-this._startAngle)%360,n.rotate(e,t)}this.refresh()},move:function(t,e){var i,n,o,s,a,c,l,u,f,p,g,m=new d,v=new d,_=0;if(-2===t.y&&-1===t.x){for(s=this._innerBounds.center(),this._angle=this._truncateAngle(h.findAngle(s,e)),c=0;c<this.shapes.length;c++)a=this.shapes[c],l=(this._angle+this.initialRotates[c]-this._startAngle)%360,a.rotate(l,s),a.hasOwnProperty("layout")&&a.layout(a),this._rotating=!0;this.refresh()}else{if(this.shouldSnap()){var y=this._truncateDistance(e.minus(this._lp));if(0===y.x&&0===y.y)return void(this._cp=e);i=y,this._lp=new d(this._lp.x+y.x,this._lp.y+y.y)}else i=e.minus(this._cp);for(this.isDragHandle(t)?(v=m=i,n=!0):(this._angle&&i.rotate(this._angle,new d(0,0)),-1==t.x?m.x=i.x:1==t.x&&(v.x=i.x),-1==t.y?m.y=i.y:1==t.y&&(v.y=i.y)),n||(f=function(t,e){var i;return-1==t.x&&-1==t.y?i=e.bottomRight():1==t.x&&1==t.y?i=e.topLeft():-1==t.x&&1==t.y?i=e.topRight():1==t.x&&-1==t.y?i=e.bottomLeft():0===t.x&&-1==t.y?i=e.bottom():0===t.x&&1==t.y?i=e.top():1==t.x&&0===t.y?i=e.left():-1==t.x&&0===t.y&&(i=e.right()),i}(t,this._innerBounds),p=(this._innerBounds.width+i.x*t.x)/this._innerBounds.width,g=(this._innerBounds.height+i.y*t.y)/this._innerBounds.height),c=0;c<this.shapes.length;c++){if(o=(a=this.shapes[c]).bounds(),n){if(!ut(a))continue;u=this._displaceBounds(o,m,v,n)}else{(u=o.clone()).scale(p,g,f,this._innerBounds.center(),a.rotate().angle);var w=u.center();w.rotate(-this._angle,o.center()),u=new r(w.x-u.width/2,w.y-u.height/2,u.width,u.height)}if(u.width>=a.options.minWidth&&u.height>=a.options.minHeight){var x=o;a.bounds(u),a.hasOwnProperty("layout")&&a.layout(a,x,u),x.width===u.width&&x.height===u.height||a.rotate(a.rotate().angle),_+=1}}_&&(_==c?(u=this._displaceBounds(this._innerBounds,m,v,n),this.bounds(u)):this.refreshBounds(),this.refresh()),this._positions()}this._cp=e},isDragHandle:function(t){return 0===t.x&&0===t.y},cancel:function(){for(var t=this.shapes,i=this.shapeStates,n=0;n<t.length;n++)t[n].bounds(i[n]);this.refreshBounds(),this.refresh(),this._manipulating=e,this._internalChange=e,this._rotating=e},_truncatePositionToGuides:function(t){return this.diagram.ruler?this.diagram.ruler.truncatePositionToGuides(t):t},_truncateSizeToGuides:function(t){return this.diagram.ruler?this.diagram.ruler.truncateSizeToGuides(t):t},_truncateAngle:function(t){var e=this.snapOptions(),i=Math.max(e.angle||10,5);return e?Math.floor(t%360/i)*i:t%360},_truncateDistance:function(t){if(t instanceof n.Point)return new n.Point(this._truncateDistance(t.x),this._truncateDistance(t.y));var e=this.snapOptions()||{},i=Math.max(e.size||10,5);return e?Math.floor(t/i)*i:t},snapOptions:function(){return((this.diagram.options.editable||{}).drag||{}).snap||{}},shouldSnap:function(){var t=this.diagram.options.editable,e=(t||{}).drag,i=(e||{}).snap;return!1!==t&&!1!==e&&!1!==i},_displaceBounds:function(t,e,i,n){var o,s=t.topLeft().plus(e),a=t.bottomRight().plus(i),h=r.fromPoints(s,a);return n||((o=h.center()).rotate(t.center(),-this._angle),h=new r(o.x-h.width/2,o.y-h.height/2,h.width,h.height)),h},stop:function(){var t,i,n;if(this._cp!=this._sp)if(this._rotating)t=new q(this,this.shapes,this.initialRotates),this._rotating=!1;else if(this._diffStates()){if(this.diagram.ruler)for(i=0;i<this.shapes.length;i++){var o=(n=this.shapes[i]).bounds();o=this._truncateSizeToGuides(this._truncatePositionToGuides(o)),n.bounds(o),this.refreshBounds(),this.refresh()}for(i=0;i<this.shapes.length;i++)(n=this.shapes[i]).updateModel();t=new V(this.shapes,this.shapeStates,this),this.diagram._syncShapeChanges()}return this._manipulating=e,this._internalChange=e,this._rotating=e,t},_diffStates:function(){for(var t=this.shapes,e=this.shapeStates,i=0;i<t.length;i++)if(!t[i].bounds().equals(e[i]))return!0;return!1},refreshBounds:function(){var t=1==this.shapes.length?this.shapes[0].bounds().clone():this.diagram.boundingBox(this.shapes,!0);this.bounds(t)},refresh:function(){var e,i,n=this;if(this.shapes.length>0){i=this.bounds(),this.visual.visible(!0),this.visual.position(i.topLeft()),t.each(this.map,(function(){e=n._getHandleBounds(new d(this.x,this.y)),this.visual.position(e.topLeft())})),this.visual.position(i.topLeft());var o=new d(i.width/2,i.height/2);if(this.visual.rotate(this._angle,o),this.rect.redraw({width:i.width,height:i.height}),this.rotationThumb){var s=this.options.editable.rotate.thumb;this._rotationThumbBounds=new r(i.center().x,i.y+s.y,0,0).inflate(s.width),this.rotationThumb.redraw({x:i.width/2-s.width/2})}}else this.visual.visible(!1)}}),dt=o.extend({init:function(t){var e=t.options.selectable;this.options=f({},this.options,e),this.visual=new a(this.options),this.diagram=t},options:{stroke:{color:"#778899",width:1,dashType:"dash"},fill:{color:I}},start:function(t){this._sp=this._ep=t,this.refresh(),this.diagram._adorn(this,!0)},end:function(){this._sp=this._ep=e,this.diagram._adorn(this,!1)},bounds:function(t){return t&&(this._bounds=t),this._bounds},move:function(t){this._ep=t,this.refresh()},refresh:function(){if(this._sp){var t=r.fromPoints(this.diagram.modelToLayer(this._sp),this.diagram.modelToLayer(this._ep));this.bounds(r.fromPoints(this._sp,this._ep)),this.visual.position(t.topLeft()),this.visual.redraw({height:t.height+1,width:t.width+1})}}}),lt=o.extend({init:function(t){this.options=f({},t.options),this._c=t,this.visual=new l(this.options),this.refresh()},_hover:function(t){var e=this.options,i=e.hover,n=e.stroke,o=e.fill;t&&h.isDefined(i.stroke)&&(n=f({},n,i.stroke)),t&&h.isDefined(i.fill)&&(o=i.fill),this.visual.redraw({stroke:n,fill:o})},refresh:function(){var t=this._c.shape.diagram.modelToView(this._c.position()),e=t.minus(this._c.shape.bounds("transformed").topLeft()),i=new r(t.x,t.y,0,0);i.inflate(this.options.width/2,this.options.height/2),this._visualBounds=i,this.visual.redraw({center:new d(e.x,e.y)})},_hitTest:function(t){var e=this._c.shape.diagram.modelToView(t);return this._visualBounds.contains(e)}});function ut(t){var e=t.options.editable;return e&&!1!==e.drag}function ft(t){return!1===t.ctrlKey&&!1===t.altKey&&!1===t.shiftKey}f(n,{CompositeUnit:R,TransformUnit:V,PanUndoUnit:G,AddShapeUnit:F,AddConnectionUnit:H,DeleteShapeUnit:U,DeleteConnectionUnit:O,ConnectionEditAdorner:at,ConnectionTool:Z,ConnectorVisual:lt,UndoRedoService:j,ResizingAdorner:ct,Selector:dt,ToolService:et,ConnectorsAdorner:ht,LayoutUndoUnit:B,ConnectionEditUnit:N,ToFrontUnit:K,ToBackUnit:W,ConnectionRouterBase:it,PolylineRouter:ot,CascadingRouter:st,SelectionTool:Q,ScrollerTool:Y,PointerTool:J,ConnectionEditTool:$,RotateUnit:q})}(window.kendo.jQuery),function(t){var e=window.kendo,i=e.dataviz.diagram,n=i.Graph,o=i.Node,s=i.Link,r=e.deepExtend,a=i.Size,h=i.Rect,c=i.Dictionary,d=i.Set,l=i.Graph,u=i.Utils,f=i.Point,p=1e-6,g=Math.PI/180,m=u.contains,v=t.grep,_=e.Class.extend({defaultOptions:{type:"Tree",subtype:"Down",roots:null,animate:!1,limitToView:!1,friction:.9,nodeDistance:50,iterations:300,horizontalSeparation:90,verticalSeparation:50,underneathVerticalTopOffset:15,underneathHorizontalOffset:15,underneathVerticalSeparation:15,grid:{width:1500,offsetX:50,offsetY:50,componentSpacingX:20,componentSpacingY:20},layerSeparation:50,layeredIterations:2,startRadialAngle:0,endRadialAngle:360,radialSeparation:150,radialFirstLevelSeparation:200,keepComponentsInOneRadialLayout:!1,ignoreContainers:!0,layoutContainerChildren:!1,ignoreInvisible:!0,animateTransitions:!1},init:function(){},gridLayoutComponents:function(t){if(!t)throw"No components supplied.";u.forEach(t,(function(t){t.calcBounds()})),t.sort((function(t,e){return e.bounds.width-t.bounds.width}));for(var e,i=this.options.grid.width,n=this.options.grid.componentSpacingX,o=this.options.grid.componentSpacingY,s=0,r=this.options.grid.offsetX,a=r,h=this.options.grid.offsetY,c=[],d=[];t.length>0;){a>=i&&(a=r,h+=s+o,s=0);var l=t.pop();for(this.moveToOffset(l,new f(a,h)),e=0;e<l.nodes.length;e++)d.push(l.nodes[e]);for(e=0;e<l.links.length;e++)c.push(l.links[e]);var p=l.bounds,g=p.height;(g<=0||isNaN(g))&&(g=0);var m=p.width;(m<=0||isNaN(m))&&(m=0),g>=s&&(s=g),a+=m+n}return{nodes:d,links:c}},moveToOffset:function(t,e){var i,n,o=t.bounds,s=e.x-o.x,r=e.y-o.y;for(i=0;i<t.nodes.length;i++){var a=t.nodes[i],c=a.bounds();0===c.width&&0===c.height&&0===c.x&&0===c.y&&(c=new h(0,0,0,0)),c.x+=s,c.y+=r,a.bounds(c)}for(i=0;i<t.links.length;i++){var d=t.links[i];if(d.points){var l=[],u=d.points;for(n=0;n<u.length;n++){var p=u[n];p.x+=s,p.y+=r,l.push(p)}d.points=l}}return this.currentHorizontalOffset+=o.width+this.options.grid.offsetX,new f(s,r)},transferOptions:function(t){this.options=e.deepExtend({},this.defaultOptions),u.isUndefined(t)||(this.options=e.deepExtend(this.options,t||{}))}}),y=e.Class.extend({init:function(t){this.nodeMap=new c,this.shapeMap=new c,this.nodes=[],this.edges=[],this.edgeMap=new c,this.finalNodes=[],this.finalLinks=[],this.ignoredConnections=[],this.ignoredShapes=[],this.hyperMap=new c,this.hyperTree=new n,this.finalGraph=null,this.diagram=t},convert:function(t){if(u.isUndefined(this.diagram))throw"No diagram to convert.";return this.options=e.deepExtend({ignoreInvisible:!0,ignoreContainers:!0,layoutContainerChildren:!1},t||{}),this.clear(),this._renormalizeShapes(),this._renormalizeConnections(),this.finalNodes=new c(this.nodes),this.finalLinks=new c(this.edges),this.finalGraph=new n,this.finalNodes.forEach((function(t){this.finalGraph.addNode(t)}),this),this.finalLinks.forEach((function(t){this.finalGraph.addExistingLink(t)}),this),this.finalGraph},mapConnection:function(t){return this.edgeMap.get(t.id)},mapShape:function(t){return this.nodeMap.get(t.id)},getEdge:function(t,e){return u.first(t.links,(function(i){return i.getComplement(t)===e}))},clear:function(){this.finalGraph=null,this.hyperTree=!this.options.ignoreContainers&&this.options.layoutContainerChildren?new l:null,this.hyperMap=!this.options.ignoreContainers&&this.options.layoutContainerChildren?new c:null,this.nodeMap=new c,this.shapeMap=new c,this.nodes=[],this.edges=[],this.edgeMap=new c,this.ignoredConnections=[],this.ignoredShapes=[],this.finalNodes=[],this.finalLinks=[]},listToRoot:function(t){var e=[],i=t.container;if(!i)return e;for(e.push(i);i.parentContainer;)i=i.parentContainer,e.push(i);return e.reverse(),e},firstNonIgnorableContainer:function(t){return t.isContainer&&!this._isIgnorableItem(t)?t:t.parentContainer?this.firstNonIgnorableContainer(t.parentContainer):null},isContainerConnection:function(t,e){return!(!t.isContainer||!this.isDescendantOf(t,e))||e.isContainer&&this.isDescendantOf(e,t)},isDescendantOf:function(t,e){if(!t.isContainer)throw"Expecting a container.";if(t===e)return!1;if(m(t.children,e))return!0;for(var i=[],n=0,o=t.children.length;n<o;n++){var s=t.children[n];s.isContainer&&this.isDescendantOf(s,e)&&i.push(s)}return i.length>0},isIgnorableItem:function(t){return this.options.ignoreInvisible?(!t.isCollapsed||!this._isVisible(t))&&!(!t.isCollapsed&&this._isVisible(t)):t.isCollapsed&&!this._isTop(t)},isShapeMapped:function(t){return t.isCollapsed&&!this._isVisible(t)&&!this._isTop(t)},leastCommonAncestor:function(t,e){if(!t)throw"Parameter should not be null.";if(!e)throw"Parameter should not be null.";if(!this.hyperTree)throw"No hypertree available.";var i=this.listToRoot(t),n=this.listToRoot(e),o=null;if(u.isEmpty(i)||u.isEmpty(n))return this.hyperTree.root.data;for(var s=i[0],r=n[0],a=0;s===r&&(o=i[a],!(++a>=i.length||a>=n.length));)s=i[a],r=n[a];return o?v(this.hyperTree.nodes,(function(t){return t.data.container===o})):this.hyperTree.root.data},_isTop:function(t){return!t.parentContainer},_isVisible:function(t){return!!t.visible()&&(t.parentContainer?this._isVisible(t.parentContainer):t.visible())},_isCollapsed:function(t){return!(!t.isContainer||!t.isCollapsed)||t.parentContainer&&this._isCollapsed(t.parentContainer)},_renormalizeShapes:function(){if(!this.options.ignoreContainers)throw"Containers are not supported yet, but stay tuned.";for(var t=0,e=this.diagram.shapes.length;t<e;t++){var i=this.diagram.shapes[t];if(this.options.ignoreInvisible&&!this._isVisible(i)||i.isContainer)this.ignoredShapes.push(i);else{var n=new o(i.id,i);n.isVirtual=!1,this.nodeMap.add(i.id,n),this.nodes.push(n)}}},_renormalizeConnections:function(){if(0!==this.diagram.connections.length)for(var t=0,e=this.diagram.connections.length;t<e;t++){var i=this.diagram.connections[t];if(this.isIgnorableItem(i))this.ignoredConnections.push(i);else{var n=i.sourceConnector?i.sourceConnector.shape:null,o=i.targetConnector?i.targetConnector.shape:null;if(n&&o)if(!m(this.ignoredShapes,n)||this.shapeMap.containsKey(n))if(!m(this.ignoredShapes,o)||this.shapeMap.containsKey(o)){this.shapeMap.containsKey(n)&&(n=this.shapeMap[n]),this.shapeMap.containsKey(o)&&(o=this.shapeMap[o]);var r=this.mapShape(n),a=this.mapShape(o);if(r===a||this.areConnectedAlready(r,a))this.ignoredConnections.push(i);else{if(null===r||null===a)throw"A shape was not mapped to a node.";if(!this.options.ignoreContainers)throw"Containers are not supported yet, but stay tuned.";if(r.isVirtual||a.isVirtual)this.ignoredConnections.push(i);else{var h=new s(r,a,i.id,i);this.edgeMap.add(i.id,h),this.edges.push(h)}}}else this.ignoredConnections.push(i);else this.ignoredConnections.push(i);else this.ignoredConnections.push(i)}}},areConnectedAlready:function(t,e){return u.any(this.edges,(function(i){return i.source===t&&i.target===e||i.source===e&&i.target===t}))}}),w=_.extend({init:function(t){if(_.fn.init.call(this),u.isUndefined(t))throw"Diagram is not specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new y(this.diagram).convert(t);if(!e.isEmpty()){var n=e.getConnectedComponents();if(!u.isEmpty(n)){for(var o=0;o<n.length;o++){var s=n[o];this.layoutGraph(s,t)}var r=this.gridLayoutComponents(n);return new i.LayoutState(this.diagram,r)}}},layoutGraph:function(t,e){u.isDefined(e)&&this.transferOptions(e),this.graph=t;var i=9*this.options.nodeDistance;this.temperature=i;var n=this._expectedBounds();this.width=n.width,this.height=n.height;for(var o=0;o<this.options.iterations;o++)this.refineStage=o>=5*this.options.iterations/6,this.tick(),this.temperature=this.refineStage?i/30:i*(1-o/(2*this.options.iterations))},tick:function(){var t;for(t=0;t<this.graph.nodes.length;t++)this._repulsion(this.graph.nodes[t]);for(t=0;t<this.graph.links.length;t++)this._attraction(this.graph.links[t]);for(t=0;t<this.graph.nodes.length;t++){var e=this.graph.nodes[t],i=Math.sqrt(e.dx*e.dx+e.dy*e.dy);if(0===i)return;e.x+=Math.min(i,this.temperature)*e.dx/i,e.y+=Math.min(i,this.temperature)*e.dy/i,this.options.limitToView&&(e.x=Math.min(this.width,Math.max(e.width/2,e.x)),e.y=Math.min(this.height,Math.max(e.height/2,e.y)))}},_shake:function(t){var e=Math.random()*this.options.nodeDistance/4,i=2*Math.random()*Math.PI;t.x+=e*Math.cos(i),t.y-=e*Math.sin(i)},_InverseSquareForce:function(t,e,i){var n;if(this.refineStage){var o=e.x-i.x,s=e.y-i.y,r=e.width/2,a=e.height/2,h=i.width/2,c=i.height/2;n=Math.pow(o,2)/Math.pow(r+h+this.options.nodeDistance,2)+Math.pow(s,2)/Math.pow(a+c+this.options.nodeDistance,2)}else n=Math.pow(t,2)/Math.pow(this.options.nodeDistance,2);return 4*n/3},_SquareForce:function(t,e,i){return 1/this._InverseSquareForce(t,e,i)},_repulsion:function(t){t.dx=0,t.dy=0,u.forEach(this.graph.nodes,(function(e){if(e!==t){for(;t.x===e.x&&t.y===e.y;)this._shake(e);var i=t.x-e.x,n=t.y-e.y,o=Math.sqrt(i*i+n*n),s=2*this._SquareForce(o,t,e);t.dx+=i/o*s,t.dy+=n/o*s}}),this)},_attraction:function(t){var e=t.target,i=t.source;if(i!==e){for(;i.x===e.x&&i.y===e.y;)this._shake(e);var n=i.x-e.x,o=i.y-e.y,s=Math.sqrt(n*n+o*o),r=5*this._InverseSquareForce(s,i,e),a=n/s*r,h=o/s*r;e.dx+=a,e.dy+=h,i.dx-=a,i.dy-=h}},_expectedBounds:function(){var t,e=this.graph.nodes.length;if(0===e)return t;var i=(t=u.fold(this.graph.nodes,(function(t,e){var i=e.width*e.height;return i>0?t+=Math.sqrt(i):0}),0,this))/e*Math.ceil(Math.sqrt(e));return{width:4*(i*Math.sqrt(1.5)),height:4*(i/Math.sqrt(1.5))}}}),x=e.Class.extend({init:function(t){this.center=null,this.options=t},layout:function(t,e){if(this.graph=t,this.graph.nodes&&0!==this.graph.nodes.length){if(!m(this.graph.nodes,e))throw"The given root is not in the graph.";this.center=e,this.graph.cacheRelationships(),this.layoutSwitch()}},layoutLeft:function(t){this.setChildrenDirection(this.center,"Left",!1),this.setChildrenLayout(this.center,"Default",!1);var e,i,n,o=0,s=0;for(i=0;i<t.length;i++){(n=t[i]).TreeDirection="Left";var r=this.measure(n,a.Empty);s=Math.max(s,r.Width),o+=r.height+this.options.verticalSeparation}o-=this.options.verticalSeparation;var h=this.center.x-this.options.horizontalSeparation;for(e=this.center.y+(this.center.height-o)/2,i=0;i<t.length;i++){n=t[i];var c=new f(h-n.Size.width,e);this.arrange(n,c),e+=n.Size.height+this.options.verticalSeparation}},layoutRight:function(t){this.setChildrenDirection(this.center,"Right",!1),this.setChildrenLayout(this.center,"Default",!1);var e,i,n,o=0,s=0;for(i=0;i<t.length;i++){(n=t[i]).TreeDirection="Right";var r=this.measure(n,a.Empty);s=Math.max(s,r.Width),o+=r.height+this.options.verticalSeparation}o-=this.options.verticalSeparation;var h=this.center.x+this.options.horizontalSeparation+this.center.width;for(e=this.center.y+(this.center.height-o)/2,i=0;i<t.length;i++){n=t[i];var c=new f(h,e);this.arrange(n,c),e+=n.Size.height+this.options.verticalSeparation}},layoutUp:function(t){this.setChildrenDirection(this.center,"Up",!1),this.setChildrenLayout(this.center,"Default",!1);var e,i,n,o=0;for(n=0;n<t.length;n++){(i=t[n]).TreeDirection="Up",o+=this.measure(i,a.Empty).width+this.options.horizontalSeparation}o-=this.options.horizontalSeparation;var s=this.center.x+this.center.width/2-o/2;for(n=0;n<t.length;n++){i=t[n],e=this.center.y-this.options.verticalSeparation-i.Size.height;var r=new f(s,e);this.arrange(i,r),s+=i.Size.width+this.options.horizontalSeparation}},layoutDown:function(t){var e,i;this.setChildrenDirection(this.center,"Down",!1),this.setChildrenLayout(this.center,"Default",!1);var n,o=0;for(i=0;i<t.length;i++){(e=t[i]).treeDirection="Down",o+=this.measure(e,a.Empty).width+this.options.horizontalSeparation}o-=this.options.horizontalSeparation;var s=this.center.x+this.center.width/2-o/2;for(n=this.center.y+this.options.verticalSeparation+this.center.height,i=0;i<t.length;i++){e=t[i];var r=new f(s,n);this.arrange(e,r),s+=e.Size.width+this.options.horizontalSeparation}},layoutRadialTree:function(){this.setChildrenDirection(this.center,"Radial",!1),this.setChildrenLayout(this.center,"Default",!1),this.previousRoot=null;var t=this.options.startRadialAngle*g,e=this.options.endRadialAngle*g;if(e<=t)throw"Final angle should not be less than the start angle.";this.maxDepth=0,this.origin=new f(this.center.x,this.center.y),this.calculateAngularWidth(this.center,0),this.maxDepth>0&&this.radialLayout(this.center,this.options.radialFirstLevelSeparation,t,e),this.center.Angle=e-t},tipOverTree:function(t,e){u.isUndefined(e)&&(e=0),this.setChildrenDirection(this.center,"Down",!1),this.setChildrenLayout(this.center,"Default",!1),this.setChildrenLayout(this.center,"Underneath",!1,e);var i,n,o,s=0;for(o=0;o<t.length;o++){(n=t[o]).TreeDirection="Down",s+=this.measure(n,a.Empty).width+this.options.horizontalSeparation}s-=this.options.horizontalSeparation,s-=t[t.length-1].width,s+=t[t.length-1].associatedShape.bounds().width;var r=this.center.x+this.center.width/2-s/2;for(i=this.center.y+this.options.verticalSeparation+this.center.height,o=0;o<t.length;o++){n=t[o];var h=new f(r,i);this.arrange(n,h),r+=n.Size.width+this.options.horizontalSeparation}},calculateAngularWidth:function(t,e){e>this.maxDepth&&(this.maxDepth=e);var i=0,n=0===e?0:Math.sqrt(2e6)/e;if(t.children.length>0){for(var o=0,s=t.children.length;o<s;o++){var r=t.children[o];i+=this.calculateAngularWidth(r,e+1)}i=Math.max(n,i)}else i=n;return t.sectorAngle=i,i},sortChildren:function(t){var e,i=0;if(t.parents.length>1)throw"Node is not part of a tree.";var n=t.parents[0];if(n){var o=new f(n.x,n.y),s=new f(t.x,t.y);i=this.normalizeAngle(Math.atan2(o.y-s.y,o.x-s.x))}var r=t.children.length;if(0===r)return null;var a=[],h=[];for(e=0;e<r;++e){var c=t.children[e],d=new f(c.x,c.y);h[e]=e,a[e]=this.normalizeAngle(-i+Math.atan2(d.y-d.y,d.x-d.x))}u.bisort(a,h);var l=[],p=t.children;for(e=0;e<r;++e)l.push(p[h[e]]);return l},normalizeAngle:function(t){for(;t>2*Math.PI;)t-=2*Math.PI;for(;t<0;)t+=2*Math.PI;return t},radialLayout:function(t,e,i,n){for(var o=n-i,s=o/2,r=t.sectorAngle,a=0,h=this.sortChildren(t),c=0,d=h.length;c<d;c++){var l=h[c],u=l,f=u.sectorAngle/r;l.children.length>0&&this.radialLayout(l,e+this.options.radialSeparation,i+a*o,i+(a+f)*o),this.setPolarLocation(l,e,i+a*o+f*s),u.angle=f*o,a+=f}},setPolarLocation:function(t,e,i){t.x=this.origin.x+e*Math.cos(i),t.y=this.origin.y+e*Math.sin(i),t.BoundingRectangle=new h(t.x,t.y,t.width,t.height)},setChildrenDirection:function(t,e,i){var n=t.treeDirection;this.graph.depthFirstTraversal(t,(function(t){t.treeDirection=e})),i||(t.treeDirection=n)},setChildrenLayout:function(t,e,i,n){u.isUndefined(n)&&(n=0);var o=t.childrenLayout;n>0?(this.graph.assignLevels(t),this.graph.depthFirstTraversal(t,(function(t){t.level>=n+1&&(t.childrenLayout=e)}))):(this.graph.depthFirstTraversal(t,(function(t){t.childrenLayout=e})),i||(t.childrenLayout=o))},measure:function(t,e){var i,n=0,o=0,s=new a(0,0);if(!t)throw"";var r=t.associatedShape.bounds(),h=r.width,c=r.height;if(1!==t.parents.length)throw"Node not in a spanning tree.";var d=t.parents[0];if("Undefined"===t.treeDirection&&(t.treeDirection=d.treeDirection),u.isEmpty(t.children))s=new a(Math.abs(h)<p?50:h,Math.abs(c)<p?25:c);else if(1===t.children.length){switch(t.treeDirection){case"Radial":i=this.measure(t.children[0],e),n=h+this.options.radialSeparation*Math.cos(t.AngleToParent)+i.width,o=c+Math.abs(this.options.radialSeparation*Math.sin(t.AngleToParent))+i.height;break;case"Left":case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":n=h+(i=this.measure(t.children[0],e)).width+this.options.underneathHorizontalOffset,o=c+this.options.underneathVerticalTopOffset+i.height;break;case"Default":i=this.measure(t.children[0],e),n=h+this.options.horizontalSeparation+i.width,o=Math.max(c,i.height);break;default:throw"Unhandled TreeDirection in the Radial layout measuring."}break;case"Up":case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":i=this.measure(t.children[0],e),n=Math.max(h,i.width+this.options.underneathHorizontalOffset),o=c+this.options.underneathVerticalTopOffset+i.height;break;case"Default":i=this.measure(t.children[0],e),o=c+this.options.verticalSeparation+i.height,n=Math.max(h,i.width);break;default:throw"Unhandled TreeDirection in the Down layout measuring."}break;default:throw"Unhandled TreeDirection in the layout measuring."}s=new a(n,o)}else{var l,f;switch(t.treeDirection){case"Left":case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":for(n=h,o=c+this.options.underneathVerticalTopOffset,l=0;l<t.children.length;l++)f=t.children[l],i=this.measure(f,e),n=Math.max(n,i.width+this.options.underneathHorizontalOffset),o+=i.height+this.options.underneathVerticalSeparation;o-=this.options.underneathVerticalSeparation;break;case"Default":for(n=h,o=0,l=0;l<t.children.length;l++)f=t.children[l],i=this.measure(f,e),n=Math.max(n,h+this.options.horizontalSeparation+i.width),o+=i.height+this.options.verticalSeparation;o-=this.options.verticalSeparation;break;default:throw"Unhandled TreeDirection in the Right layout measuring."}break;case"Up":case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":for(n=h,o=c+this.options.underneathVerticalTopOffset,l=0;l<t.children.length;l++)f=t.children[l],i=this.measure(f,e),n=Math.max(n,i.width+this.options.underneathHorizontalOffset),o+=i.height+this.options.underneathVerticalSeparation;o-=this.options.underneathVerticalSeparation;break;case"Default":for(n=0,o=0,l=0;l<t.children.length;l++)f=t.children[l],n+=(i=this.measure(f,e)).width+this.options.horizontalSeparation,o=Math.max(o,i.height+this.options.verticalSeparation+c);n-=this.options.horizontalSeparation;break;default:throw"Unhandled TreeDirection in the Down layout measuring."}break;default:throw"Unhandled TreeDirection in the layout measuring."}s=new a(n,o)}return t.SectorAngle=Math.sqrt(n*n/4+o*o/4),t.Size=s,s},arrange:function(t,e){var i,n,o,s,r,a,c,d=t.associatedShape.bounds(),l=d.width,g=d.height;if(u.isEmpty(t.children))t.x=e.x,t.y=e.y,t.BoundingRectangle=new h(e.x,e.y,l,g);else switch(t.treeDirection){case"Left":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":for(c=e,t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),a=e.y+g+this.options.underneathVerticalTopOffset,i=0;i<o.children.length;i++)o=o.children[i],r=c.x-o.associatedShape.width-this.options.underneathHorizontalOffset,n=new f(r,a),this.arrange(o,n),a+=o.Size.height+this.options.underneathVerticalSeparation;break;case"Default":for(c=new f(e.x+t.Size.width-l,e.y+(t.Size.height-g)/2),t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),r=c.x-this.options.horizontalSeparation,a=e.y,i=0;i<t.children.length;i++)o=t.children[i],n=new f(r-o.Size.width,a),this.arrange(o,n),a+=o.Size.height+this.options.verticalSeparation;break;default:throw"Unsupported TreeDirection"}break;case"Right":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":for(c=e,t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),r=e.x+l+this.options.underneathHorizontalOffset,a=e.y+g+this.options.underneathVerticalTopOffset,i=0;i<t.children.length;i++)o=t.children[i],n=new f(r,a),this.arrange(o,n),a+=o.Size.height+this.options.underneathVerticalSeparation;break;case"Default":for(c=new f(e.x,e.y+(t.Size.height-g)/2),t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),r=e.x+l+this.options.horizontalSeparation,a=e.y,i=0;i<t.children.length;i++)o=t.children[i],n=new f(r,a),this.arrange(o,n),a+=o.Size.height+this.options.verticalSeparation;break;default:throw"Unsupported TreeDirection"}break;case"Up":if(c=new f(e.x+(t.Size.width-l)/2,e.y+t.Size.height-g),t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),Math.abs(c.x-e.x)<p){for(s=0,i=0;i<t.children.length;i++)s+=t.children[i].Size.width+this.options.horizontalSeparation;s-=this.options.horizontalSeparation,r=e.x+(l-s)/2}else r=e.x;for(i=0;i<t.children.length;i++)o=t.children[i],a=c.y-this.options.verticalSeparation-o.Size.height,n=new f(r,a),this.arrange(o,n),r+=o.Size.width+this.options.horizontalSeparation;break;case"Down":switch(t.childrenLayout){case"TopAlignedWithParent":case"BottomAlignedWithParent":break;case"Underneath":for(c=e,t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),r=e.x+this.options.underneathHorizontalOffset,a=e.y+g+this.options.underneathVerticalTopOffset,i=0;i<t.children.length;i++)o=t.children[i],n=new f(r,a),this.arrange(o,n),a+=o.Size.height+this.options.underneathVerticalSeparation;break;case"Default":if(c=new f(e.x+(t.Size.width-l)/2,e.y),t.x=c.x,t.y=c.y,t.BoundingRectangle=new h(t.x,t.y,t.width,t.height),Math.abs(c.x-e.x)<p){for(s=0,i=0;i<t.children.length;i++)s+=t.children[i].Size.width+this.options.horizontalSeparation;s-=this.options.horizontalSeparation,r=e.x+(l-s)/2}else r=e.x;for(i=0;i<t.children.length;i++)o=t.children[i],a=c.y+this.options.verticalSeparation+g,n=new f(r,a),this.arrange(o,n),r+=o.Size.width+this.options.horizontalSeparation;break;default:throw"Unsupported TreeDirection"}break;case"None":break;default:throw"Unsupported TreeDirection"}},layoutSwitch:function(){if(this.center&&!u.isEmpty(this.center.children)){var t,e,i,n,o=this.options.subtype;u.isUndefined(o)&&(o="Down");var s=this.center.children;switch(o.toLowerCase()){case"radial":case"radialtree":this.layoutRadialTree();break;case"mindmaphorizontal":case"mindmap":t=this.center.children,1===this.center.children.length?this.layoutRight(t):(n=s.length/2,e=v(this.center.children,(function(t){return u.indexOf(s,t)<n})),i=v(this.center.children,(function(t){return u.indexOf(s,t)>=n})),this.layoutLeft(e),this.layoutRight(i));break;case"mindmapvertical":t=this.center.children,1===this.center.children.length?this.layoutDown(t):(n=s.length/2,e=v(this.center.children,(function(t){return u.indexOf(s,t)<n})),i=v(this.center.children,(function(t){return u.indexOf(s,t)>=n})),this.layoutUp(e),this.layoutDown(i));break;case"right":this.layoutRight(this.center.children);break;case"left":this.layoutLeft(this.center.children);break;case"up":case"bottom":this.layoutUp(this.center.children);break;case"down":case"top":this.layoutDown(this.center.children);break;case"tipover":case"tipovertree":if(this.options.tipOverTreeStartLevel<0)throw"The tip-over level should be a positive integer.";this.tipOverTree(this.center.children,this.options.tipOverTreeStartLevel)}}}}),b=_.extend({init:function(t){if(_.fn.init.call(this),u.isUndefined(t))throw"No diagram specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new y(this.diagram);this.graph=e.convert();var n=this.layoutComponents();return new i.LayoutState(this.diagram,n)},layoutComponents:function(){if(!this.graph.isEmpty()){var t=this.graph.getConnectedComponents();if(!u.isEmpty(t)){for(var e=new x(this.options),i=[],n=0;n<t.length;n++){var o=t[n],s=this.getTree(o);if(!s)throw"Failed to find a spanning tree for the component.";var r=s.root,a=s.tree;e.layout(a,r),i.push(a)}return this.gridLayoutComponents(i)}}},getTree:function(t){var e=null;if(this.options.roots&&this.options.roots.length>0)for(var i=0,n=t.nodes.length;i<n;i++)for(var o=t.nodes[i],s=0;s<this.options.roots.length;s++){if(this.options.roots[s]===o.associatedShape){e=o;break}}if(!e&&!(e=t.root()))throw"Unable to find a root for the tree.";return this.getTreeForRoot(t,e)},getTreeForRoot:function(t,e){var i=t.getSpanningTree(e);return u.isUndefined(i)||i.isEmpty()?null:{tree:i,root:i.root}}}),C=_.extend({init:function(t){if(_.fn.init.call(this),u.isUndefined(t))throw"Diagram is not specified.";this.diagram=t},layout:function(t){this.transferOptions(t);var e=new y(this.diagram).convert(t);if(!e.isEmpty()){var n=e.getConnectedComponents();if(!u.isEmpty(n)){for(var o=0;o<n.length;o++){var s=n[o];this.layoutGraph(s,t)}var r=this.gridLayoutComponents(n);return new i.LayoutState(this.diagram,r)}}},_initRuntimeProperties:function(){for(var t=0;t<this.graph.nodes.length;t++){var e=this.graph.nodes[t];e.layer=-1,e.downstreamLinkCount=0,e.upstreamLinkCount=0,e.isVirtual=!1,e.uBaryCenter=0,e.dBaryCenter=0,e.upstreamPriority=0,e.downstreamPriority=0,e.gridPosition=0}},_prepare:function(t){var e,i,n,o,s,r,a=[],h=new c,d=0;for(u.forEach(t.nodes,(function(t){0===t.incoming.length&&(h.set(t,0),a.push(t))}));a.length>0;)for(s=a.shift(),e=0;e<s.outgoing.length;e++)r=(n=s.outgoing[e]).target,o=h.containsKey(r)?Math.max(h.get(s)+1,h.get(r)):h.get(s)+1,h.set(r,o),o>d&&(d=o),m(a,r)||a.push(r);var l,f=h.keys();f.sort((function(t,e){var i=h.get(t),n=h.get(e);return u.sign(n-i)}));for(var p=0;p<f.length;++p){var g=f[p],v=Number.MAX_VALUE;if(0!==g.outgoing.length){for(i=0;i<g.outgoing.length;++i)n=g.outgoing[i],v=Math.min(v,h.get(n.target));v>1&&h.set(g,v-1)}}for(this.layers=[],e=0;e<d+1;e++)(l=[]).linksTo={},this.layers.push(l);for(h.forEach((function(t,e){t.layer=e,this.layers[e].push(t)}),this),i=0;i<this.layers.length;i++)for(l=this.layers[i],e=0;e<l.length;e++)l[e].gridPosition=e},layoutGraph:function(t,e){if(u.isUndefined(t))throw"No graph given or graph analysis of the diagram failed.";u.isDefined(e)&&this.transferOptions(e),this.graph=t,t.setItemIndices();var i=t.makeAcyclic();this._initRuntimeProperties(),this._prepare(t,e),this._dummify(),this._optimizeCrossings(),this._swapPairs(),this.arrangeNodes(),this._moveThingsAround(),this._dedummify(),u.forEach(i,(function(t){t.points&&t.points.reverse()}))},setMinDist:function(t,e,i){var n=t.layer,o=t.layerIndex;this.minDistances[n][o]=i},getMinDist:function(t,e){for(var i=0,n=t.layerIndex,o=e.layerIndex,s=t.layer,r=Math.min(n,o),a=Math.max(n,o),h=r;h<a;++h)i+=this.minDistances[s][h];return i},placeLeftToRight:function(t){for(var e,i,n=new c,o=0;o<this.layers.length;++o){var s=t[o];if(s){for(e=0;e<s.length;e++)i=s[e],n.containsKey(i)||this.placeLeft(i,n,o);var r=Number.POSITIVE_INFINITY;for(e=0;e<s.length;e++){i=s[e];var a=this.rightSibling(i);a&&this.nodeLeftClass.get(a)!==o&&(r=Math.min(r,n.get(a)-n.get(i)-this.getMinDist(i,a)))}if(r===Number.POSITIVE_INFINITY){var h=[];for(e=0;e<s.length;e++){i=s[e];var d=[];u.addRange(d,this.upNodes.get(i)),u.addRange(d,this.downNodes.get(i));for(var l=0;l<d.length;l++){var f=d[l];this.nodeLeftClass.get(f)<o&&h.push(n.get(f)-n.get(i))}}h.sort(),r=0===h.length?0:h.length%2==1?h[this.intDiv(h.length,2)]:(h[this.intDiv(h.length,2)-1]+h[this.intDiv(h.length,2)])/2}for(e=0;e<s.length;e++)i=s[e],n.set(i,n.get(i)+r)}}return n},placeRightToLeft:function(t){for(var e,i,n=new c,o=0;o<this.layers.length;++o){var s=t[o];if(s){for(e=0;e<s.length;e++)i=s[e],n.containsKey(i)||this.placeRight(i,n,o);var r=Number.NEGATIVE_INFINITY;for(e=0;e<s.length;e++){i=s[e];var a=this.leftSibling(i);a&&this.nodeRightClass.get(a)!==o&&(r=Math.max(r,n.get(a)-n.get(i)+this.getMinDist(a,i)))}if(r===Number.NEGATIVE_INFINITY){var h=[];for(e=0;e<s.length;e++){i=s[e];var d=[];u.addRange(d,this.upNodes.get(i)),u.addRange(d,this.downNodes.get(i));for(var l=0;l<d.length;l++){var f=d[l];this.nodeRightClass.get(f)<o&&h.push(n.get(i)-n.get(f))}}h.sort(),r=0===h.length?0:h.length%2==1?h[this.intDiv(h.length,2)]:(h[this.intDiv(h.length,2)-1]+h[this.intDiv(h.length,2)])/2}for(e=0;e<s.length;e++)i=s[e],n.set(i,n.get(i)+r)}}return n},_getLeftWing:function(){var t={value:null},e=this.computeClasses(t,1);return this.nodeLeftClass=t.value,e},_getRightWing:function(){var t={value:null},e=this.computeClasses(t,-1);return this.nodeRightClass=t.value,e},computeClasses:function(t,e){for(var i=0,n=t.value=new c,o=0;o<this.layers.length;++o){i=o;for(var s=this.layers[o],r=1===e?0:s.length-1;r>=0&&r<s.length;r+=e){var a=s[r];if(n.containsKey(a))i=n.get(a);else if(n.set(a,i),a.isVirtual)for(var h=this._nodesInLink(a),d=0;d<h.length;d++){var l=h[d];n.set(l,i)}}}for(var u=[],f=0;f<this.layers.length;f++)u.push(null);return n.forEach((function(t,e){null===u[e]&&(u[e]=[]),u[e].push(t)})),u},_isVerticalLayout:function(){return"up"===this.options.subtype.toLowerCase()||"down"===this.options.subtype.toLowerCase()||"vertical"===this.options.subtype.toLowerCase()},_isHorizontalLayout:function(){return"right"===this.options.subtype.toLowerCase()||"left"===this.options.subtype.toLowerCase()||"horizontal"===this.options.subtype.toLowerCase()},_isIncreasingLayout:function(){return"right"===this.options.subtype.toLowerCase()||"down"===this.options.subtype.toLowerCase()},_moveThingsAround:function(){var t,e,i,n,o,s;for(e=0;e<this.layers.length;++e)(n=this.layers[e]).sort(this._gridPositionComparer);for(this.minDistances=[],e=0;e<this.layers.length;++e)for(n=this.layers[e],this.minDistances[e]=[],o=0;o<n.length;++o)(i=n[o]).layerIndex=o,this.minDistances[e][o]=this.options.nodeDistance,o<n.length-1&&(this._isVerticalLayout()?this.minDistances[e][o]+=(i.width+n[o+1].width)/2:this.minDistances[e][o]+=(i.height+n[o+1].height)/2);for(this.downNodes=new c,this.upNodes=new c,u.forEach(this.graph.nodes,(function(t){this.downNodes.set(t,[]),this.upNodes.set(t,[])}),this),u.forEach(this.graph.links,(function(t){var e=t.source,i=t.target,n=null,o=null;e.layer>i.layer?(n=t.source,o=t.target):(o=t.source,n=t.target),this.downNodes.get(o).push(n),this.upNodes.get(n).push(o)}),this),this.downNodes.forEachValue((function(t){t.sort(this._gridPositionComparer)}),this),this.upNodes.forEachValue((function(t){t.sort(this._gridPositionComparer)}),this),e=0;e<this.layers.length-1;++e)for(n=this.layers[e],s=0;s<n.length-1;s++){var r=n[s];if(r.isVirtual){var a=this.downNodes.get(r)[0];if(a.isVirtual)for(o=s+1;o<n.length;++o)if((i=n[o]).isVirtual){var h=this.downNodes.get(i)[0];if(h.isVirtual&&a.gridPosition>h.gridPosition){var d=a.gridPosition;a.gridPosition=h.gridPosition,h.gridPosition=d;var l=a.layerIndex,f=h.layerIndex;this.layers[e+1][l]=h,this.layers[e+1][f]=a,a.layerIndex=f,h.layerIndex=l}}}}var p=this._getLeftWing(),g=this._getRightWing(),m=this.placeLeftToRight(p),v=this.placeRightToLeft(g),_=new c;u.forEach(this.graph.nodes,(function(t){_.set(t,(m.get(t)+v.get(t))/2)}));var y=new c,w=new c;for(e=0;e<this.layers.length;++e){n=this.layers[e];var x=-1;for(o=0;o<n.length;++o)i=n[o],y.set(i,0),w.set(i,!1),i.isVirtual&&(-1===x||x===o-1||(y.set(n[x],0),_.get(i)-_.get(n[x])===this.getMinDist(n[x],i)?w.set(n[x],!0):w.set(n[x],!1)),x=o)}u.forEach([1,-1],(function(e){for(var i=1===e?0:this.layers.length-1;i>=0&&i<this.layers.length;i+=e){var n=this.layers[i],o=this._firstVirtualNode(n),s=null,r=null;if(-1!==o)for(s=n[o],r=[],t=0;t<o;t++)r.push(n[t]);else s=null,r=n;if(r.length>0){for(this._sequencer(_,null,s,e,r),t=0;t<r.length-1;++t)this.setMinDist(r[t],r[t+1],_.get(r[t+1])-_.get(r[t]));s&&this.setMinDist(r[r.length-1],s,_.get(s)-_.get(r[r.length-1]))}for(;s;){var a=this.nextVirtualNode(n,s);if(a){if(y.get(s)===e){o=s.layerIndex;var h=a.layerIndex;for(r=[],t=o+1;t<h;t++)r.push(n[t]);r.length>0&&this._sequencer(_,s,a,e,r),w.set(s,!0)}}else{for(o=s.layerIndex,r=[],t=o+1;t<n.length;t++)r.push(n[t]);if(r.length>0){for(this._sequencer(_,s,null,e,r),t=0;t<r.length-1;++t)this.setMinDist(r[t],r[t+1],_.get(r[t+1])-_.get(r[t]));this.setMinDist(s,r[0],_.get(r[0])-_.get(s))}}s=a}this.adjustDirections(i,e,y,w)}}),this);var b,C,S=this._isIncreasingLayout()?0:this.layers.length-1,k=this._isIncreasingLayout()?1:-1,T=0;function M(t,e){for(var i=Number.MIN_VALUE,n=0;n<t.length;++n){var o=t[n];i=e._isVerticalLayout()?Math.max(i,o.height):Math.max(i,o.width)}return i}for(t=S;b=t,(C=this)._isIncreasingLayout()?b<C.layers.length:b>=0;t+=k){var D=M(n=this.layers[t],this);for(o=0;o<n.length;++o)i=n[o],this._isVerticalLayout()?(i.x=_.get(i),i.y=T+D/2):(i.x=T+D/2,i.y=_.get(i));T+=this.options.layerSeparation+D}},adjustDirections:function(t,e,i,n){if(!(t+e<0||t+e>=this.layers.length))for(var o=null,s=null,r=this.layers[t+e],a=0;a<r.length;++a){var h=r[a];if(h.isVirtual){var c=this.getNeighborOnLayer(h,t);if(c.isVirtual){if(o){for(var d=n.get(s),l=this.layers[t],u=s.layerIndex,f=c.layerIndex,p=u+1;p<f;++p)l[p].isVirtual&&(d=d&&n.get(l[p]));if(d){i.set(o,e);for(var g=o.layerIndex,m=h.layerIndex,v=g+1;v<m;++v)r[v].isVirtual&&i.set(r[v],e)}}o=h,s=c}}}},getNeighborOnLayer:function(t,e){var i=this.upNodes.get(t)[0];return i.layer===e||(i=this.downNodes.get(t)[0]).layer===e?i:null},_sequencer:function(t,e,i,n,o){if(1===o.length&&this._sequenceSingle(t,e,i,n,o[0]),o.length>1){var s=o.length,r=this.intDiv(s,2);this._sequencer(t,e,i,n,o.slice(0,r)),this._sequencer(t,e,i,n,o.slice(r)),this.combineSequences(t,e,i,n,o)}},_sequenceSingle:function(t,e,i,n,o){var s=-1===n?this.downNodes.get(o):this.upNodes.get(o),r=s.length;0!==r&&(r%2==1?t.set(o,t.get(s[this.intDiv(r,2)])):t.set(o,(t.get(s[this.intDiv(r,2)-1])+t.get(s[this.intDiv(r,2)]))/2),e&&t.set(o,Math.max(t.get(o),t.get(e)+this.getMinDist(e,o))),i&&t.set(o,Math.min(t.get(o),t.get(i)-this.getMinDist(o,i))))},combineSequences:function(t,e,i,n,o){var s,r,a,h,c,d,l=o.length,u=this.intDiv(l,2),f=[];for(s=0;s<u;++s){for(r=0,h=-1===n?this.downNodes.get(o[s]):this.upNodes.get(o[s]),a=0;a<h.length;++a)c=h[a],t.get(c)>=t.get(o[s])?r++:(r--,f.push({k:t.get(c)+this.getMinDist(o[s],o[u-1]),v:2}));f.push({k:t.get(o[s])+this.getMinDist(o[s],o[u-1]),v:r})}e&&f.push({k:t.get(e)+this.getMinDist(e,o[u-1]),v:Number.MAX_VALUE}),f.sort(this._positionDescendingComparer);var p=[];for(s=u;s<l;++s){for(r=0,h=-1===n?this.downNodes.get(o[s]):this.upNodes.get(o[s]),a=0;a<h.length;++a)c=h[a],t.get(c)<=t.get(o[s])?r++:(r--,p.push({k:t.get(c)-this.getMinDist(o[s],o[u]),v:2}));p.push({k:t.get(o[s])-this.getMinDist(o[s],o[u]),v:r})}i&&p.push({k:t.get(i)-this.getMinDist(i,o[u]),v:Number.MAX_VALUE}),p.sort(this._positionAscendingComparer);for(var g=0,m=0,v=this.getMinDist(o[u-1],o[u]);t.get(o[u])-t.get(o[u-1])<v;)if(g<m){if(0===f.length){t.set(o[u-1],t.get(o[u])-v);break}g+=(d=f.shift()).v,t.set(o[u-1],d.k),t.set(o[u-1],Math.max(t.get(o[u-1]),t.get(o[u])-v))}else{if(0===p.length){t.set(o[u],t.get(o[u-1])+v);break}m+=(d=p.shift()).v,t.set(o[u],d.k),t.set(o[u],Math.min(t.get(o[u]),t.get(o[u-1])+v))}for(s=u-2;s>=0;s--)t.set(o[s],Math.min(t.get(o[s]),t.get(o[u-1])-this.getMinDist(o[s],o[u-1])));for(s=u+1;s<l;s++)t.set(o[s],Math.max(t.get(o[s]),t.get(o[u])+this.getMinDist(o[s],o[u])))},placeLeft:function(t,e,i){var n=Number.NEGATIVE_INFINITY;u.forEach(this._getComposite(t),(function(t){var o=this.leftSibling(t);o&&this.nodeLeftClass.get(o)===this.nodeLeftClass.get(t)&&(e.containsKey(o)||this.placeLeft(o,e,i),n=Math.max(n,e.get(o)+this.getMinDist(o,t)))}),this),n===Number.NEGATIVE_INFINITY&&(n=0),u.forEach(this._getComposite(t),(function(t){e.set(t,n)}))},placeRight:function(t,e,i){var n=Number.POSITIVE_INFINITY;u.forEach(this._getComposite(t),(function(t){var o=this.rightSibling(t);o&&this.nodeRightClass.get(o)===this.nodeRightClass.get(t)&&(e.containsKey(o)||this.placeRight(o,e,i),n=Math.min(n,e.get(o)-this.getMinDist(t,o)))}),this),n===Number.POSITIVE_INFINITY&&(n=0),u.forEach(this._getComposite(t),(function(t){e.set(t,n)}))},leftSibling:function(t){var e=this.layers[t.layer],i=t.layerIndex;return 0===i?null:e[i-1]},rightSibling:function(t){var e=this.layers[t.layer],i=t.layerIndex;return i===e.length-1?null:e[i+1]},_getComposite:function(t){return t.isVirtual?this._nodesInLink(t):[t]},arrangeNodes:function(){var t,e,i,n,o;for(e=0;e<this.layers.length;e++)for(n=this.layers[e],i=0;i<n.length;i++)(o=n[i]).upstreamPriority=o.upstreamLinkCount,o.downstreamPriority=o.downstreamLinkCount;for(var s=0;s<2;s++){for(t=this.layers.length-1;t>=1;t--)this.layoutLayer(!1,t);for(t=0;t<this.layers.length-1;t++)this.layoutLayer(!0,t)}var r=Number.MAX_VALUE;for(e=0;e<this.layers.length;e++)for(n=this.layers[e],i=0;i<n.length;i++)o=n[i],r=Math.min(r,o.gridPosition);if(r<0)for(e=0;e<this.layers.length;e++)for(n=this.layers[e],i=0;i<n.length;i++)(o=n[i]).gridPosition=o.gridPosition-r},layoutLayer:function(t,e){var i,n;n=t?this.layers[i=e+1]:this.layers[i=e-1];for(var o=[],s=0;s<n.length;s++)o.push(n[s]);o.sort((function(t,e){var i=(t.upstreamPriority+t.downstreamPriority)/2,n=(e.upstreamPriority+e.downstreamPriority)/2;return Math.abs(i-n)<1e-4?0:i<n?1:-1})),u.forEach(o,(function(t){var e=t.gridPosition,i=this.calcBaryCenter(t),o=(t.upstreamPriority+t.downstreamPriority)/2;if(!(Math.abs(e-i)<1e-4||Math.abs(e-i)<.2501))if(e<i)for(;e<i&&this.moveRight(t,n,o);)e=t.gridPosition;else for(;e>i&&this.moveLeft(t,n,o);)e=t.gridPosition}),this),i>0&&this.calcDownData(i-1),i<this.layers.length-1&&this.calcUpData(i+1)},moveRight:function(t,e,i){var n=u.indexOf(e,t);if(n===e.length-1)return t.gridPosition=t.gridPosition+.5,!0;var o=e[n+1],s=(o.upstreamPriority+o.downstreamPriority)/2;return o.gridPosition>t.gridPosition+1?(t.gridPosition=t.gridPosition+.5,!0):!(s>i||Math.abs(s-i)<1e-4)&&(!!this.moveRight(o,e,i)&&(t.gridPosition=t.gridPosition+.5,!0))},moveLeft:function(t,e,i){var n=u.indexOf(e,t);if(0===n)return t.gridPosition=t.gridPosition-.5,!0;var o=e[n-1],s=(o.upstreamPriority+o.downstreamPriority)/2;return o.gridPosition<t.gridPosition-1?(t.gridPosition=t.gridPosition-.5,!0):!(s>i||Math.abs(s-i)<1e-4)&&(!!this.moveLeft(o,e,i)&&(t.gridPosition=t.gridPosition-.5,!0))},mapVirtualNode:function(t,e){this.nodeToLinkMap.set(t,e),this.linkToNodeMap.containsKey(e)||this.linkToNodeMap.set(e,[]),this.linkToNodeMap.get(e).push(t)},_nodesInLink:function(t){return this.linkToNodeMap.get(this.nodeToLinkMap.get(t))},_dummify:function(){this.linkToNodeMap=new c,this.nodeToLinkMap=new c;var t,e,i,n,r,a,h,d,l=this.graph.links.slice(0),f=this.layers,p=function(t,e,i){f[t].linksTo[e]=f[t].linksTo[e]||[],f[t].linksTo[e].push(i)};for(d=0;d<l.length;d++){var g=l[d],m=g.source,v=g.target,_=m.layer,y=v.layer,w=m.gridPosition,x=v.gridPosition,b=(x-w)/Math.abs(y-_),C=m;if(_-y>1){for(h=_-1;h>y;h--){for((i=new o).x=m.x,i.y=m.y,i.width=m.width/100,i.height=m.height/100,(e=(h-y)*b+w)>(t=f[h]).length&&(e=t.length),w>=f[_].length-1&&x>=f[y].length-1?e=t.length:0===w&&0===x&&(e=0),i.layer=h,i.uBaryCenter=0,i.dBaryCenter=0,i.upstreamLinkCount=0,i.downstreamLinkCount=0,i.gridPosition=e,i.isVirtual=!0,u.insert(t,i,e),r=e+1;r<t.length;r++)(n=t[r]).gridPosition=n.gridPosition+1;(a=new s(C,i)).depthOfDumminess=0,p(h-1,h,a),C=i,this.graph._addNode(i),this.graph.addLink(a),i.index=this.graph.nodes.length-1,this.mapVirtualNode(i,g)}p(y-1,y,a),g.changeSource(C),g.depthOfDumminess=_-y-1}else if(_-y<-1){for(h=_+1;h<y;h++){for((i=new o).x=m.x,i.y=m.y,i.width=m.width/100,i.height=m.height/100,(e=(h-_)*b+w)>(t=f[h]).length&&(e=t.length),w>=f[_].length-1&&x>=f[y].length-1?e=t.length:0===w&&0===x&&(e=0),i.layer=h,i.uBaryCenter=0,i.dBaryCenter=0,i.upstreamLinkCount=0,i.downstreamLinkCount=0,i.gridPosition=e,i.isVirtual=!0,e&=e,u.insert(t,i,e),r=e+1;r<t.length;r++)(n=t[r]).gridPosition=n.gridPosition+1;(a=new s(C,i)).depthOfDumminess=0,p(h-1,h,a),C=i,this.graph._addNode(i),this.graph.addLink(a),i.index=this.graph.nodes.length-1,this.mapVirtualNode(i,g)}p(y-1,y,g),g.changeSource(C),g.depthOfDumminess=y-_-1}else p(_,y,g)}},_dedummify:function(){for(var t=!0;t;){t=!1;for(var e=0;e<this.graph.links.length;e++){var i=this.graph.links[e];if(i.depthOfDumminess){var n=[];n.unshift({x:i.target.x,y:i.target.y}),n.unshift({x:i.source.x,y:i.source.y});for(var o=i,s=i.depthOfDumminess,r=0;r<s;r++){var a=o.source.incoming[0];n.unshift({x:a.source.x,y:a.source.y}),o=a}i.changeSource(o.source),i.depthOfDumminess=0,n.length>2?(n.splice(0,1),n.splice(n.length-1),i.points=n):i.points=[],t=!0;break}}}},_optimizeCrossings:function(){for(var t,e=-1,i=0;0!==e&&!(i++>3);){for(e=0,t=this.layers.length-1;t>=1;t--)e+=this.optimizeLayerCrossings(!1,t);for(t=0;t<this.layers.length-1;t++)e+=this.optimizeLayerCrossings(!0,t)}},calcUpData:function(t){if(0!==t){var e,i,n,o=this.layers[t],s=new d,r=this.layers[t-1];for(e=0;e<r.length;e++)s.add(r[e]);for(e=0;e<o.length;e++){var a=o[e],h=0,c=0;for(i=0;i<a.incoming.length;i++)n=a.incoming[i],s.contains(n.source)&&(c++,h+=n.source.gridPosition);for(i=0;i<a.outgoing.length;i++)n=a.outgoing[i],s.contains(n.target)&&(c++,h+=n.target.gridPosition);c>0?(a.uBaryCenter=h/c,a.upstreamLinkCount=c):(a.uBaryCenter=e,a.upstreamLinkCount=0)}}},calcDownData:function(t){if(t!==this.layers.length-1){var e,i,n,o=this.layers[t],s=new d,r=this.layers[t+1];for(e=0;e<r.length;e++)s.add(r[e]);for(e=0;e<o.length;e++){var a=o[e],h=0,c=0;for(i=0;i<a.incoming.length;i++)n=a.incoming[i],s.contains(n.source)&&(c++,h+=n.source.gridPosition);for(i=0;i<a.outgoing.length;i++)n=a.outgoing[i],s.contains(n.target)&&(c++,h+=n.target.gridPosition);c>0?(a.dBaryCenter=h/c,a.downstreamLinkCount=c):(a.dBaryCenter=e,a.downstreamLinkCount=0)}}},optimizeLayerCrossings:function(t,e){var i,n,o=(n=t?this.layers[i=e+1]:this.layers[i=e-1]).slice(0);t?this.calcUpData(i):this.calcDownData(i);var s=this;n.sort((function(t,e){var i=s.calcBaryCenter(t),n=s.calcBaryCenter(e);if(Math.abs(i-n)<1e-4)return t.degree()===e.degree()?s.compareByIndex(t,e):t.degree()<e.degree()?1:-1;var o=1e3*(n-i);return o>0?-1:o<0?1:s.compareByIndex(t,e)}));var r,a=0;for(r=0;r<n.length;r++)n[r]!==o[r]&&a++;if(a>0){var h=0;for(r=0;r<n.length;r++){n[r].gridPosition=h++}}return a},_swapPairs:function(){for(var t=this.options.layeredIterations,e=0;!(e++>t);)for(var i=e%4<=1,n=e%4==1,o=i?0:this.layers.length-1;i?o<=this.layers.length-1:o>=0;o+=i?1:-1){for(var s=this.layers[o],r=!1,a=!0,h=0,c=0;c<s.length-1;c++){var d=0,l=0,u=0;if(a?(0!==o&&(d=this.countLinksCrossingBetweenTwoLayers(o-1,o)),o!==this.layers.length-1&&(l=this.countLinksCrossingBetweenTwoLayers(o,o+1)),i?d*=2:l*=2,u=d+l):u=h,0!==u){var f=s[c],p=s[c+1],g=f.gridPosition,m=p.gridPosition;s[c]=p,s[c+1]=f,f.gridPosition=m,p.gridPosition=g,d=0,0!==o&&(d=this.countLinksCrossingBetweenTwoLayers(o-1,o)),l=0,o!==this.layers.length-1&&(l=this.countLinksCrossingBetweenTwoLayers(o,o+1)),i?d*=2:l*=2;var v=d+l;(n?v>=u:v>u)?(f=s[c],p=s[c+1],g=f.gridPosition,m=p.gridPosition,s[c]=p,s[c+1]=f,f.gridPosition=m,p.gridPosition=g,h=u,a=!1):(r=!0,a=!0)}}r&&(o!==this.layers.length-1&&this.calcUpData(o+1),0!==o&&this.calcDownData(o-1))}},countLinksCrossingBetweenTwoLayers:function(t,e){var i,n,o,s,r,a,h,c,d=this.layers[t].linksTo[e],l=0,u=d.length;for(h=0;h<u;h++)for(i=d[h],c=h+1;c<u;c++){n=d[c],i.target.layer===e?(o=i.source,s=i.target):(o=i.target,s=i.source),n.target.layer===e?(r=n.source,a=n.target):(r=n.target,a=n.source);var f=o.gridPosition,p=s.gridPosition;(f-r.gridPosition)*(p-a.gridPosition)<0&&l++}return l},calcBaryCenter:function(t){var e=t.upstreamLinkCount,i=t.downstreamLinkCount,n=t.uBaryCenter,o=t.dBaryCenter;return e>0&&i>0?(n+o)/2:e>0?n:i>0?o:0},_gridPositionComparer:function(t,e){return t.gridPosition<e.gridPosition?-1:t.gridPosition>e.gridPosition?1:0},_positionAscendingComparer:function(t,e){return t.k<e.k?-1:t.k>e.k?1:0},_positionDescendingComparer:function(t,e){return t.k<e.k?1:t.k>e.k?-1:0},_firstVirtualNode:function(t){for(var e=0;e<t.length;e++)if(t[e].isVirtual)return e;return-1},compareByIndex:function(t,e){var i=t.index,n=e.index;return i<n?1:i>n?-1:0},intDiv:function(t,e){return(t-t%e)/e},nextVirtualNode:function(t,e){for(var i=e.layerIndex+1;i<t.length;++i)if(t[i].isVirtual)return t[i];return null}}),S=e.Class.extend({init:function(t,e){if(u.isUndefined(t))throw"No diagram given";this.diagram=t,this.nodeMap=new c,this.linkMap=new c,this.capture(e||t)},capture:function(t){var e,n,o,s,r,a,c;if(t instanceof i.Graph){for(s=0;s<t.nodes.length;s++)o=(e=t.nodes[s]).associatedShape,this.nodeMap.set(o.visual.id,new h(e.x,e.y,e.width,e.height));for(s=0;s<t.links.length;s++)r=(a=t.links[s]).associatedConnection,this.linkMap.set(r.visual.id,a.points())}else if(t instanceof Array)for(n=t,s=0;s<n.length;s++)(o=(e=n[s]).associatedShape)&&this.nodeMap.set(o.visual.id,new h(e.x,e.y,e.width,e.height));else if(t.hasOwnProperty("links")&&t.hasOwnProperty("nodes")){for(n=t.nodes,c=t.links,s=0;s<n.length;s++)(o=(e=n[s]).associatedShape)&&this.nodeMap.set(o.visual.id,new h(e.x,e.y,e.width,e.height));for(s=0;s<c.length;s++)(r=(a=c[s]).associatedConnection)&&this.linkMap.set(r.visual.id,a.points)}else{var d=this.diagram.shapes,l=this.diagram.connections;for(s=0;s<d.length;s++)o=d[s],this.nodeMap.set(o.visual.id,o.bounds());for(s=0;s<l.length;s++)r=l[s],this.linkMap.set(r.visual.id,r.points())}}});r(i,{init:function(t){e.init(t,i.ui)},SpringLayout:w,TreeLayout:b,GraphAdapter:y,LayeredLayout:C,LayoutBase:_,LayoutState:S})}(window.kendo.jQuery),function(t,e){var i=kendo.dataviz,n=kendo.drawing,o=kendo.geometry,s=i.diagram,r=kendo.ui.Widget,a=kendo.Class,h=kendo.deepExtend,c=kendo._outerWidth,d=kendo._outerHeight,l=t.extend,u=kendo.data.HierarchicalDataSource,f=s.Canvas,p=s.Group,g=s.Rectangle,m=s.Circle,v=s.CompositeTransform,_=s.Rect,y=s.Path,w=s.DeleteShapeUnit,x=s.DeleteConnectionUnit,b=s.TextBlock,C=s.Image,S=s.Point,k=s.Intersect,T=s.ConnectionEditAdorner,M=s.UndoRedoService,D=s.ToolService,I=s.Selector,P=s.ResizingAdorner,L=s.ConnectorsAdorner,E=s.Cursors,z=s.Utils,B=kendo.Observable,R=s.ToBackUnit,N=s.ToFrontUnit,A=s.PolylineRouter,O=s.CascadingRouter,U=z.isUndefined,V=z.isDefined,H=n.util.defined,F=Array.isArray,G=kendo.isFunction,q=z.isString,K=t.isPlainObject,W=Math,j=".kendoDiagram",X="cascading",Y="itemBoundsChange",J="change",Q="click",Z="error",$="Auto",tt=9007199254740992,et="select",it="itemRotate",nt="pan",ot="zoomStart",st="zoomEnd",rt="none",at=Number.MAX_VALUE,ht=-Number.MAX_VALUE,ct="transformed",dt="rotated",lt="DOMMouseScroll"+j+" mousewheel"+j,ut=({className:t,icon:e,themeColor:i,text:n})=>kendo.html.renderButton(`<button class="${t}" href="#">${n}</button>`,{icon:e,themeColor:i});s.DefaultConnectors=[{name:"Top"},{name:"Bottom"},{name:"Left"},{name:"Right"},{name:$,position:function(t){return t.getPosition("center")}}];var ft={cancel:{text:"Cancel",icon:"cancel-outline",className:"k-diagram-cancel"},update:{text:"Save",imageClass:"save",className:"k-diagram-update",icon:"save",themeColor:"primary"}};function pt(t){return t.options.name.toLowerCase()===$.toLowerCase()}function gt(t,e){for(var i,n,o=tt,s=0;s<e.length;s++)if(!pt(n=e[s])){var r=t.distanceTo(n.position());r<o&&(o=r,i=n)}return i}function mt(t,e){var i,n,o=[],s=t.drawingContainer().children,r=s.length;for(i=0;i<e.length;i++){n=e[i];for(var a=0;a<r;a++)if(s[a]==n.drawingContainer()){o.push(a);break}}return o}s.shapeDefaults=function(t){var e={type:"rectangle",path:"",autoSize:!0,visual:null,x:0,y:0,minWidth:20,minHeight:20,width:100,height:100,hover:{},editable:{connect:!0,tools:[]},connectors:s.DefaultConnectors,rotation:{angle:0}};return z.simpleExtend(e,t),e};var vt=B.extend({init:function(t){var e=this;e.dataItem=(t||{}).dataItem,B.fn.init.call(e),e.options=h({id:s.randomId()},e.options,t),e.isSelected=!1,e.visual=new p({id:e.options.id,autoSize:e.options.autoSize}),e.id=e.options.id,e._template()},options:{hover:{},cursor:E.grip,content:{align:"center middle"},selectable:!0,serializable:!0,enable:!0},_getCursor:function(t){return this.adorner?this.adorner._getCursor(t):this.options.cursor},visible:function(t){if(U(t))return this.visual.visible();this.visual.visible(t)},bounds:function(){},refresh:function(){this.visual.redraw()},position:function(t){this.options.x=t.x,this.options.y=t.y,this.visual.position(t)},toString:function(){return this.options.id},serialize:function(){var t=h({},{options:this.options});return this.dataItem&&(t.dataItem=this.dataItem.toString()),t},_content:function(t){if(t!==e){var i=this.options;s.Utils.isString(t)?i.content.text=t:h(i.content,t);var n=i.content;this._contentVisual?this._updateContentVisual(n):this._createContentVisual(n)}return this.options.content.text},_createContentVisual:function(t){t.text&&(this._contentVisual=new b(t),this._contentVisual._includeInBBox=!1,this.visual.append(this._contentVisual))},_updateContentVisual:function(t){this._contentVisual.redraw(t)},_hitTest:function(t){var e=this.bounds();return this.visible()&&e.contains(t)&&this.options.enable},_template:function(){var t=this;if(t.options.content.template){var e=t.dataItem||{},i=kendo.template(t.options.content.template,{paramName:"dataItem"});t.options.content.text=i(e)}},_canSelect:function(){return!1!==this.options.selectable},toJSON:function(){return{id:this.options.id}}}),_t=a.extend({init:function(t,e){this.options=h({},this.options,e),this.connections=[],this.shape=t},options:{width:7,height:7,fill:{color:"Yellow"},hover:{}},position:function(){return this.options.position?this.options.position(this.shape):this.shape.getPosition(this.options.name)},toJSON:function(){return{shapeId:this.shape.toString(),connector:this.options.name}}});_t.parse=function(t,e){for(var i=e.split(":"),n=i[0],o=i[1]||$,s=0;s<t.shapes.length;s++){var r=t.shapes[s];if(r.options.id==n)return r.getConnector(o.trim())}};var yt=vt.extend({init:function(t,e){var i=this;vt.fn.init.call(i,t),this.diagram=e,this.updateOptionsFromModel(),t=i.options,i.connectors=[],i.type=t.type,i.createShapeVisual(),i.updateBounds(),i.content(i.content()),i._createConnectors()},options:s.shapeDefaults(),_setOptionsFromModel:function(t){var e=bt(t||this.dataItem);this.options=h({},this.options,e),this.redrawVisual()},updateOptionsFromModel:function(t,e){if(this.diagram&&this.diagram._isEditable){var n=bt(t||this.dataItem);if(t&&e)if(i.inArray(e,["x","y","width","height"])){var o=this.bounds();o[e]=t[e],this.bounds(o)}else this.options.visual?this._redrawVisual():n.type&&(this.options=h({},this.options,n),this._redrawVisual()),this.options.content&&(this._template(),this.content(this.options.content));else this.options=h({},this.options,n)}},_redrawVisual:function(){this.visual.clear(),this._contentVisual=null,this.options.dataItem=this.dataItem,this.createShapeVisual(),this.updateBounds()},redrawVisual:function(){this._redrawVisual(),this.options.content&&(this._template(),this.content(this.options.content))},updateModel:function(t){var e=this.diagram;if(e&&e._isEditable){var i=this._bounds,n=this.dataItem;n&&(e._suspendModelRefresh(),H(n.x)&&i.x!==n.x&&n.set("x",i.x),H(n.y)&&i.y!==n.y&&n.set("y",i.y),H(n.width)&&i.width!==n.width&&n.set("width",i.width),H(n.height)&&i.height!==n.height&&n.set("height",i.height),this.dataItem=n,e._resumeModelRefresh(),t&&e._syncShapeChanges())}},updateBounds:function(){var t=this.visual._measure(!0),e=this.options;this.bounds(new _(e.x,e.y,t.width,t.height)),this._rotate(),this._alignContent()},content:function(t){var e=this._content(t);return this._alignContent(),e},_alignContent:function(){var t=this.options.content||{},e=this._contentVisual;if(e&&t.align){var i=this.visual._measure(),n=new s.RectAlign(i),o=e.drawingElement.bbox(null),r=new _(0,0,o.width(),o.height()),a=n.align(r,t.align);e.position(a.topLeft())}},_createConnectors:function(){var t,e,i=this.options,n=i.connectors.length,o=i.connectorDefaults;for(e=0;e<n;e++)t=new _t(this,h({},o,i.connectors[e])),this.connectors.push(t)},bounds:function(t){var e;if(t)if(q(t))switch(t){case ct:e=this._transformedBounds();break;case"absolute":e=this._transformedBounds();var i=this.diagram._pan;e.x+=i.x,e.y+=i.y;break;case dt:e=this._rotatedBounds();break;default:e=this._bounds}else this._setBounds(t),this._triggerBoundsChange(),this.diagram&&this.diagram._layouting||this.refreshConnections();else e=this._bounds;return e},_setBounds:function(t){var e=this.options,i=t.topLeft(),n=e.x=i.x,o=e.y=i.y,s=e.width=W.max(t.width,e.minWidth),r=e.height=W.max(t.height,e.minHeight);this._bounds=new _(n,o,s,r),this.visual.redraw({x:n,y:o,width:s,height:r})},position:function(t){if(!t)return this._bounds.topLeft();this.bounds(new _(t.x,t.y,this._bounds.width,this._bounds.height))},clone:function(){var t=this.serialize();return t.options.id=s.randomId(),this.diagram&&this.diagram._isEditable&&H(this.dataItem)&&(t.options.dataItem=Et(this.dataItem)),new yt(t.options)},select:function(t){var e,i,n=this.diagram;if(U(t)&&(t=!0),this._canSelect()&&this.isSelected!=t)return e=[],i=[],this.isSelected=t,this.isSelected?(n._selectedItems.push(this),e.push(this)):(z.remove(n._selectedItems,this),i.push(this)),n._internalSelection||n._selectionChanged(e,i),!0},rotate:function(t,i,n){var o=this.visual.rotate();if(t!==e){!1!==n&&this.diagram&&this.diagram.undoRedoService&&t!==o.angle&&this.diagram.undoRedoService.add(new s.RotateUnit(this.diagram._resizingAdorner,[this],[o.angle]),!1);var r,a,h=this.bounds(),c=new S(h.width/2,h.height/2);i&&(r=t-o.angle,a=h.center().rotate(r,i).minus(c),this._rotationOffset=this._rotationOffset.plus(a.minus(h.topLeft())),this.position(a)),this.visual.rotate(t,c),this.options.rotation.angle=t,this.diagram&&this.diagram._connectorsAdorner&&this.diagram._connectorsAdorner.refresh(),this.refreshConnections(),this.diagram&&this.diagram.trigger(it,{item:this})}return o},connections:function(t){var e,i,n,o,s=[];for(e=0;e<this.connectors.length;e++)for(o=this.connectors[e].connections,i=0;i<o.length;i++)if(n=o[i],"out"==t){var r=n.source();r.shape&&r.shape==this&&s.push(n)}else if("in"==t){var a=n.target();a.shape&&a.shape==this&&s.push(n)}else s.push(n);return s},refreshConnections:function(){t.each(this.connections(),(function(){this.refresh()}))},getConnector:function(t){var e,i;if(!q(t))return t instanceof S?gt(t,this.connectors):this.connectors.length?this.connectors[0]:null;for(t=t.toLocaleLowerCase(),e=0;e<this.connectors.length;e++)if((i=this.connectors[e]).options.name.toLocaleLowerCase()==t)return i},getPosition:function(t){var e=this.bounds(),i=t.charAt(0).toLowerCase()+t.slice(1);return G(e[i])?this._transformPoint(e[i]()):e.center()},redraw:function(t){if(t){var e,i=this.options;this.shapeVisual.redraw(this._visualOptions(t)),this._diffNumericOptions(t,["width","height","x","y"])&&(this.bounds(new _(i.x,i.y,i.width,i.height)),e=!0),t.connectors&&(i.connectors=t.connectors,this._updateConnectors()),i=h(i,t),(t.rotation||e)&&this._rotate(),i.content&&this.content(i.content)}},_updateConnectors:function(){var t,e,i,n=this.connections();this.connectors=[],this._createConnectors();for(var o=0;o<n.length;o++)e=(t=n[o]).source(),i=t.target(),e.shape&&e.shape===this?t.source(this.getConnector(e.options.name)||null):i.shape&&i.shape===this&&t.target(this.getConnector(i.options.name)||null),t.updateModel()},_diffNumericOptions:s.diffNumericOptions,_visualOptions:function(t){return{data:t.path,source:t.source,hover:t.hover,fill:t.fill,stroke:t.stroke}},_triggerBoundsChange:function(){this.diagram&&this.diagram.trigger(Y,{item:this,bounds:this._bounds.clone()})},_transformPoint:function(t){var e=this.rotate(),i=this.bounds().topLeft();return e.angle&&t.rotate(e.angle,e.center().plus(i)),t},_transformedBounds:function(){var t=this.bounds(),e=t.topLeft(),i=t.bottomRight();return _.fromPoints(this.diagram.modelToView(e),this.diagram.modelToView(i))},_rotatedBounds:function(){var t=this.bounds().rotatedBounds(this.rotate().angle),e=t.topLeft(),i=t.bottomRight();return _.fromPoints(e,i)},_rotate:function(){var t=this.options.rotation;t&&t.angle&&this.rotate(t.angle),this._rotationOffset=new S},_hover:function(t){var e=this.options,i=e.hover,n=e.stroke,o=e.fill;t&&V(i.stroke)&&(n=h({},n,i.stroke)),t&&V(i.fill)&&(o=i.fill),this.shapeVisual.redraw({stroke:n,fill:o}),e.editable&&e.editable.connect&&this.diagram._showConnectors(this,t)},_hitTest:function(t){if(this.visible()){var e,i=this.bounds(),n=this.rotate().angle;if(t.isEmpty&&!t.isEmpty())return k.rects(t,i,n||0);if(e=t.clone().rotate(n,i.center()),i.contains(e))return this}},toJSON:function(){return{shapeId:this.options.id}},createShapeVisual:function(){var t,e,i,n=this.options,o=this._visualOptions(n),s=n.visual,r=(n.type+"").toLocaleLowerCase();o.width=n.width,o.height=n.height,G(s)?t=s.call(this,n):o.data?(t=new y(o),0===(i=(e=t).drawingContainer().clippedBBox(null)).origin.x&&0===i.origin.y||e.position(-i.origin.x,-i.origin.y)):t="rectangle"==r?new g(o):"circle"==r?new m(o):"text"==r?new b(o):"image"==r?new C(o):new y(o),this.shapeVisual=t,this.visual.append(this.shapeVisual)}}),wt=vt.extend({init:function(t,e,i){var n=this;vt.fn.init.call(n,i),this.updateOptionsFromModel(),this._initRouter(),n.path=new s.Polyline(n.options),n.path.fill("transparent"),n.visual.append(n.path),n._sourcePoint=n._targetPoint=new S,n._setSource(t),n._setTarget(e),n.content(n.options.content),n.definers=[],H(i)&&i.points&&n.points(i.points)},options:{hover:{stroke:{}},startCap:rt,endCap:rt,points:[],selectable:!0,fromConnector:$,toConnector:$},_setOptionsFromModel:function(t){this.updateOptionsFromModel(t||this.dataItem)},updateOptionsFromModel:function(t){if(this.diagram&&this.diagram._isEditable){var e=this.diagram._dataMap,i=function(t){var e={};H((t=t||{}).text)&&null!==t.text&&(e.content=t.text);H(t.type)&&null!==t.type&&(e.type=t.type);H(t.from)&&null!==t.from&&(e.from=t.from);H(t.fromConnector)&&null!==t.fromConnector&&(e.fromConnector=t.fromConnector);H(t.fromX)&&null!==t.fromX&&(e.fromX=t.fromX);H(t.fromY)&&null!==t.fromY&&(e.fromY=t.fromY);H(t.to)&&null!==t.to&&(e.to=t.to);H(t.toConnector)&&null!==t.toConnector&&(e.toConnector=t.toConnector);H(t.toX)&&null!==t.toX&&(e.toX=t.toX);H(t.toY)&&null!==t.toY&&(e.toY=t.toY);return e}(t||this.dataItem);if(t){if(H(i.from)){var n=e[i.from];n&&H(i.fromConnector)&&(n=n.getConnector(i.fromConnector)),this.source(n)}else H(i.fromX)&&H(i.fromY)&&this.source(new S(i.fromX,i.fromY));if(H(i.to)){var o=e[i.to];o&&H(i.toConnector)&&(o=o.getConnector(i.toConnector)),this.target(o)}else H(i.toX)&&H(i.toY)&&this.target(new S(i.toX,i.toY));H(i.type)&&this.type()!==i.type&&(this.points([]),this.type(i.type)),this.dataItem=t,this._template(),this.redraw(this.options)}else this.options=h({},i,this.options)}},updateModel:function(t){if(this.diagram&&this.diagram._isEditable&&this.diagram.connectionsDataSource){var e=this.diagram.connectionsDataSource.getByUid(this.dataItem.uid);e&&(this.diagram._suspendModelRefresh(),H(this.options.fromX)&&null!==this.options.fromX?(Rt("from",e),Rt("fromConnector",e),e.set("fromX",this.options.fromX),e.set("fromY",this.options.fromY)):(e.set("from",this.options.from),H(e.fromConnector)&&e.set("fromConnector",this.sourceConnector?this.sourceConnector.options.name:null),Rt("fromX",e),Rt("fromY",e)),H(this.options.toX)&&null!==this.options.toX?(Rt("to",e),Rt("toConnector",e),e.set("toX",this.options.toX),e.set("toY",this.options.toY)):(e.set("to",this.options.to),H(e.toConnector)&&e.set("toConnector",this.targetConnector?this.targetConnector.options.name:null),Rt("toX",e),Rt("toY",e)),H(this.options.type)&&H(e.type)&&e.set("type",this.options.type),this.dataItem=e,this.diagram._resumeModelRefresh(),t&&this.diagram._syncConnectionChanges())}},sourcePoint:function(){return this._resolvedSourceConnector?this._resolvedSourceConnector.position():this._sourcePoint},_setSource:function(t){var i,n=t instanceof yt,o=this.options.fromConnector||$;n&&!t.getConnector(o)||(t!==e&&(this.from=t),this._removeFromSourceConnector(),null===t?this.sourceConnector&&(this._sourcePoint=(this._resolvedSourceConnector||this.sourceConnector).position(),this._clearSourceConnector(),this._setFromOptions(null,this._sourcePoint)):t instanceof _t?((i=t.shape.dataItem)&&this._setFromOptions(i.id),this.sourceConnector=t,this.sourceConnector.connections.push(this)):t instanceof S?(this._setFromOptions(null,t),this._sourcePoint=t,this.sourceConnector&&this._clearSourceConnector()):n&&((i=t.dataItem)&&this._setFromOptions(i.id),this.sourceConnector=t.getConnector(o),this.sourceConnector.connections.push(this)))},source:function(t,e){return V(t)&&(e&&this.diagram&&this.diagram.undoRedoService.addCompositeItem(new s.ConnectionEditUnit(this,t)),this._setSource(t),this.refresh()),this.sourceConnector?this.sourceConnector:this._sourcePoint},_setFromOptions:function(t,e){this.options.from=t,e?(this.options.fromX=e.x,this.options.fromY=e.y):(this.options.fromX=null,this.options.fromY=null)},sourceDefiner:function(t){if(!t)return this._sourceDefiner||(this._sourceDefiner=new s.PathDefiner(this.sourcePoint(),null,null)),this._sourceDefiner;if(!(t instanceof s.PathDefiner))throw"The sourceDefiner needs to be a PathDefiner.";t.left=null,this._sourceDefiner=t,this.source(t.point)},targetPoint:function(){return this._resolvedTargetConnector?this._resolvedTargetConnector.position():this._targetPoint},_setTarget:function(t){var i,n=t instanceof yt,o=this.options.toConnector||$;n&&!t.getConnector(o)||(t!==e&&(this.to=t),this._removeFromTargetConnector(),null===t?this.targetConnector&&(this._targetPoint=(this._resolvedTargetConnector||this.targetConnector).position(),this._clearTargetConnector(),this._setToOptions(null,this._targetPoint)):t instanceof _t?((i=t.shape.dataItem)&&this._setToOptions(i.id),this.targetConnector=t,this.targetConnector.connections.push(this)):t instanceof S?(this._setToOptions(null,t),this._targetPoint=t,this.targetConnector&&this._clearTargetConnector()):n&&((i=t.dataItem)&&this._setToOptions(i.id),this.targetConnector=t.getConnector(o),this.targetConnector.connections.push(this)))},target:function(t,i){return V(t)&&(i&&this.diagram&&this.diagram.undoRedoService.addCompositeItem(new s.ConnectionEditUnit(this,e,t)),this._setTarget(t),this.refresh()),this.targetConnector?this.targetConnector:this._targetPoint},_setToOptions:function(t,e){this.options.to=t,e?(this.options.toX=e.x,this.options.toY=e.y):(this.options.toX=null,this.options.toY=null)},targetDefiner:function(t){if(!t)return this._targetDefiner||(this._targetDefiner=new s.PathDefiner(this.targetPoint(),null,null)),this._targetDefiner;if(!(t instanceof s.PathDefiner))throw"The sourceDefiner needs to be a PathDefiner.";t.right=null,this._targetDefiner=t,this.target(t.point)},_updateConnectors:function(){this._updateConnector(this.source(),"source"),this._updateConnector(this.target(),"target")},_updateConnector:function(t,e){var i=this,n=i.diagram;if(t instanceof _t&&!n.getShapeById(t.shape.id)){var o=t.shape.dataItem,s=t.options.name,r=function(){var r=n._dataMap[o.id];t=r.getConnector(s),i[e](t,!1),i.updateModel()};if(n._dataMap[o.id])r();else{var a=n._inactiveShapeItems.getByUid(o.uid);a&&n._deferredConnectionUpdates.push(a.onActivate(r))}}else i[e](t,!1)},content:function(t){var e=this._content(t);return H(t)&&this._alignContent(),e},_createContentVisual:function(t){var e;return G(t.visual)?e=t.visual.call(this,t):t.text&&(e=new b(t)),e&&(this._contentVisual=e,e._includeInBBox=!1,this.visual.append(e)),e},_updateContentVisual:function(t){G(t.visual)?(this.visual.remove(this._contentVisual),this._createContentVisual(t)):this._contentVisual.redraw(t)},_alignContent:function(){if(this._contentVisual){for(var t=5,e=this.allPoints(),i=W.floor(e.length/2),o=i-1;o>0&&e[o].equals(e[i]);)o--,i++;var s,r=e[i],a=e[o],h=this._contentVisual._measure(),c=h.width,d=h.height,l=e.length%2==0,u=a.distanceTo(r);if(l&&e.length>2&&u>0&&(a.y===r.y&&u<c||a.x===r.x&&u<d)&&(l=!1,t=0),l){var f=n.util.deg(W.atan2(r.y-a.y,r.x-a.x));s=new S((r.x-a.x)/2+a.x,(r.y-a.y)/2+a.y),90===W.abs(f)?(s.x+=t,s.y-=d/2):f%180==0?(s.x-=c/2,s.y-=d+t):f<-90||0<f&&f<90?s.y-=d:(f<0||f>90)&&(s.x-=c,s.y-=d)}else{var p=W.floor(e.length/2);s=e[p].clone(),a=e[p-1],r=e[p+1];var g=a.x<=s.x&&r.x<=s.x?t:-h.width-t,m=a.y<=s.y&&r.y<=s.y?t:-h.height-t;s.x+=g,s.y+=m}this._contentVisual.position(s)}},select:function(t){var i,n,o=this.diagram;if(this._canSelect()&&this.isSelected!==t)return this.isSelected=t,i=[],n=[],this.isSelected?(this.adorner=new T(this,this.options.selection),o._adorn(this.adorner,!0),o._selectedItems.push(this),i.push(this)):this.adorner&&(o._adorn(this.adorner,!1),z.remove(o._selectedItems,this),this.adorner=e,n.push(this)),this.adorner&&this.adorner.refresh(),o._internalSelection||o._selectionChanged(i,n),!0},bounds:function(t){if(!t||q(t))return this._bounds;this._bounds=t},type:function(t){var e=this.options;if(!t)return e.type;t!==e.type&&(e.type=t,this._initRouter(),this.refresh())},_initRouter:function(){var t=(this.options.type||"").toLowerCase();this._router=t==X?new O(this):new A(this)},points:function(t){if(!t){var e=[];if(V(this.definers))for(var i=0;i<this.definers.length;i++)e.push(this.definers[i].point);return e}this.definers=[];for(var n=0;n<t.length;n++){var o=t[n];if(o instanceof s.Point)this.definers.push(new s.PathDefiner(o));else{if(!o.hasOwnProperty("x")||!o.hasOwnProperty("y"))throw"A Connection point needs to be a Point or an object with x and y properties.";this.definers.push(new s.PathDefiner(new S(o.x,o.y)))}}},allPoints:function(){var t=[this.sourcePoint()];if(this.definers)for(var e=0;e<this.definers.length;e++)t.push(this.definers[e].point);return t.push(this.targetPoint()),t},refresh:function(){this._resolveConnectors(),this._refreshPath(),this._alignContent(),this.adorner&&this.adorner.refresh()},_resolveConnectors:function(){var t,e,i,n,o=this,s=o.source(),r=o.target();s instanceof S?t=s:s instanceof _t&&(i=pt(s)?s.shape.connectors:[s]),r instanceof S?e=r:r instanceof _t&&(n=pt(r)?r.shape.connectors:[r]),t?n&&(o._resolvedTargetConnector=gt(t,n)):i&&(e?o._resolvedSourceConnector=gt(e,i):n&&this._resolveAutoConnectors(i,n))},_resolveAutoConnectors:function(t,e){var i,n,o,s,r,a,h,c,d,l,u,f=tt,p=tt;for(d=0;d<t.length;d++)if(!pt(h=t[d]))for(o=h.position(),l=0;l<e.length;l++)pt(c=e[l])||(s=c.position(),(u=W.round(o.distanceTo(s)))<f&&this.diagram&&this._testRoutePoints(o,s,h,c)&&(f=u,i=h,n=c),u<p&&(r=h,a=c,p=u));i&&(r=i,a=n),this._resolvedSourceConnector=r,this._resolvedTargetConnector=a},_testRoutePoints:function(t,e,i,n){var o=this._router,s=!0;if(o instanceof O){var r,a,h,c,d=o.routePoints(t,e,i,n);c=this._getRouteExclude(t,e,i.shape,n.shape),d.unshift(t),d.push(e);for(var l=1;l<d.length;l++)if(r=d[l-1],a=d[l],(h=new _(W.min(r.x,a.x),W.min(r.y,a.y),W.abs(r.x-a.x),W.abs(r.y-a.y))).width>0&&(h.x++,h.width-=2),h.height>0&&(h.y++,h.height-=2),!h.isEmpty()&&this.diagram._shapesQuadTree.hitTestRect(h,c)){s=!1;break}}return s},_getRouteExclude:function(t,e,i,n){var o=[];return this._isPointInsideShape(t,i)&&o.push(i),this._isPointInsideShape(e,n)&&o.push(n),o},_isPointInsideShape:function(t,e){var i,n,o,s=e.bounds(),r=e.rotate().angle,a=s.x,h=s.y;return n=(i=t.clone().rotate(r,s.center())).x,o=i.y,n>a&&n<a+s.width&&o>h&&o<h+s.height},redraw:function(t){if(t){this.options=h({},this.options,t);var e=this.options.points;H(e)&&e.length>0&&(this.points(e),this._refreshPath()),(t&&t.content||t.text)&&this.content(t.content),this.path.redraw({fill:t.fill,stroke:t.stroke,startCap:t.startCap,endCap:t.endCap})}},clone:function(){var t=this.serialize();return this.diagram&&this.diagram._isEditable&&H(this.dataItem)&&(t.options.dataItem=Et(this.dataItem)),new wt(this.from,this.to,t.options)},serialize:function(){var t=this.from.toJSON?this.from.toJSON:this.from.toString(),e=this.to.toJSON?this.to.toJSON:this.to.toString(),i=h({},{options:this.options,from:t,to:e});return H(this.dataItem)&&(i.dataItem=this.dataItem.toString()),i.options.points=this.points(),i},_hitTest:function(t){if(this.visible()){var e=new S(t.x,t.y),i=this.sourcePoint(),n=this.targetPoint();if(t.isEmpty&&!t.isEmpty()&&t.contains(i)&&t.contains(n))return this;if(this._router.hitTest(e))return this}},_hover:function(t){var e=(this.options.stroke||{}).color;t&&V(this.options.hover.stroke.color)&&(e=this.options.hover.stroke.color),this.path.redraw({stroke:{color:e}})},_refreshPath:function(){H(this.path)&&(this._drawPath(),this.bounds(this._router.getBounds()))},_drawPath:function(){this._router&&this._router.route();var t=this.sourcePoint(),e=this.targetPoint(),i=this.points();this.path.redraw({points:[t].concat(i,[e])})},_clearSourceConnector:function(){this.sourceConnector=e,this._resolvedSourceConnector=e},_clearTargetConnector:function(){this.targetConnector=e,this._resolvedTargetConnector=e},_removeFromSourceConnector:function(){this.sourceConnector&&z.remove(this.sourceConnector.connections,this)},_removeFromTargetConnector:function(){this.targetConnector&&z.remove(this.targetConnector.connections,this)},toJSON:function(){var t,e=this;return{from:e.from&&e.from.toJSON?e.from.toJSON():{x:(t=e._sourcePoint).x,y:t.y},to:e.to&&e.to.toJSON?e.to.toJSON():{x:(t=e._targetPoint).x,y:t.y}}}}),xt=r.extend({init:function(t,e){var i=this;kendo.destroy(t),r.fn.init.call(i,t,e),i._initTheme(),i._initElements(),i._extendLayoutOptions(i.options),i._initDefaults(e),i._interactionDefaults(),i._initCanvas(),i.mainLayer=new p({id:"main-layer"}),i.canvas.append(i.mainLayer),i._shapesQuadTree=new Lt(i),i._pan=new S,i._adorners=[],i.adornerLayer=new p({id:"adorner-layer"}),i.canvas.append(i.adornerLayer),i._createHandlers(),i._initialize(),i._resizingAdorner=new P(i,{editable:i.options.editable}),i._connectorsAdorner=new L(i),i._adorn(i._resizingAdorner,!0),i._adorn(i._connectorsAdorner,!0),i.selector=new I(i),i._clipboard=[],i.pauseMouseHandlers=!1,i._fetchFreshData(),i._createGlobalToolBar(),i._createOptionElements(),i.zoom(i.options.zoom),i.canvas.draw()},options:{name:"Diagram",theme:"sass",layout:"",zoomRate:.1,zoom:1,zoomMin:0,zoomMax:2,dataSource:{},draggable:!0,template:"",autoBind:!0,editable:{rotate:{},resize:{},text:!0,tools:[],drag:{snap:{size:10,angle:10}},remove:!0},pannable:{},selectable:{key:"none"},tooltip:{enabled:!0,format:"{0}"},copy:{enabled:!0,offsetX:20,offsetY:20},shapeDefaults:s.shapeDefaults({undoable:!0}),connectionDefaults:{editable:{tools:[]},type:X},shapes:[],connections:[]},events:[st,ot,nt,et,it,Y,J,Q,"mouseEnter","mouseLeave","toolBarClick","save","cancel","edit","remove","add","dataBound","dragStart","drag","dragEnd"],items:function(){return t()},_createGlobalToolBar:function(){var t=this.options.editable;if(t){var e=t.tools;!this._isEditable||!1===e||e&&0!==e.length||(e=["createShape","undo","redo","rotateClockwise","rotateAnticlockwise"]),e&&e.length&&(this.toolBar=new Ct(this,{tools:e||{},click:this._toolBarClick.bind(this),modal:!1}),this.toolBar.element.css({textAlign:"left"}),this.element.prepend(this.toolBar.element),this._resize())}},createShape:function(){if(this.editor&&this.editor.end()||!this.editor){var t=this.dataSource,e=(t.view()||[]).length,i=Bt(t,{}),n=this._createShape(i,{});if(!this.trigger("add",{shape:n}))t.insert(e,i),this._inactiveShapeItems.getByUid(i.uid).element=n,this.edit(n)}},_createShape:function(t,e){return(e=h({},this.options.shapeDefaults,e)).dataItem=t,new yt(e,this)},createConnection:function(){if(this.editor&&this.editor.end()||!this.editor){var t=this.connectionsDataSource,e=(t.view()||[]).length,i=Bt(t,{}),n=this._createConnection(i);this.trigger("add",{connection:n})||(this._connectionsDataMap[i.uid]=n,t.insert(e,i),this.addConnection(n,!1),this.edit(n))}},_createConnection:function(t,e,i){var n=h({},this.options.connectionDefaults);return n.dataItem=t,new wt(e||new S,i||new S,n)},editModel:function(t,e){var i,n;this.cancelEdit();var o=this.options.editable;if("shape"==e)i=o.shapeEditors,n=o.shapeTemplate;else{if("connection"!=e)return;var s=Tt.bind(this);i=h({},{from:s,to:s},o.connectionEditors),n=o.connectionTemplate}this.editor=new kt(this.element,{update:this._update.bind(this),cancel:this._cancel.bind(this),model:t,type:e,target:this,editors:i,template:n}),this.trigger("edit",this._editArgs())},edit:function(t){if(t.dataItem){var e=t instanceof yt?"shape":"connection";this.editModel(t.dataItem,e)}},cancelEdit:function(){this.editor&&(this._getEditDataSource().cancelChanges(this.editor.model),this._destroyEditor())},saveEdit:function(){this.editor&&this.editor.end()&&!this.trigger("save",this._editArgs())&&this._getEditDataSource().sync()},_update:function(){this.editor&&this.editor.end()&&!this.trigger("save",this._editArgs())&&(this._getEditDataSource().sync(),this._destroyEditor())},_cancel:function(){if(this.editor&&!this.trigger("cancel",this._editArgs())){var t=this.editor.model;this._getEditDataSource().cancelChanges(t);var e=this._connectionsDataMap[t.uid]||this._dataMap[t.id];e&&e._setOptionsFromModel(t),this._destroyEditor()}},_getEditDataSource:function(){return"shape"===this.editor.options.type?this.dataSource:this.connectionsDataSource},_editArgs:function(){var t={container:this.editor.wrapper};return t[this.editor.options.type]=this.editor.model,t},_destroyEditor:function(){this.editor&&(this.editor.close(),this.editor=null)},_initElements:function(){this.wrapper=this.element.empty().css("position","relative").attr("tabindex",0).addClass("k-widget k-diagram"),this.scrollable=t("<div />").appendTo(this.element)},_initDefaults:function(t){var e=this.options,i=e.editable,n=e.shapeDefaults,o=e.connectionDefaults,s=(t||{}).shapeDefaults;!1===i?(n.editable=!1,o.editable=!1):(Nt(i,n.editable,["drag","remove","connect"]),Nt(i,o.editable,["drag","remove"])),s&&s.connectors&&(e.shapeDefaults.connectors=s.connectors)},_interactionDefaults:function(){var t=this.options,e=t.selectable,i=t.pannable,n=kendo.support.mobileOS;e&&!H(e.multiple)&&(t.selectable=h({multiple:!n},t.selectable)),i&&!H(i.key)&&(t.pannable=h({key:n?"none":"ctrl"},t.pannable))},_initCanvas:function(){var e=t("<div class='k-layer'></div>").appendTo(this.scrollable)[0],i=this.viewport();this.canvas=new f(e,{width:i.width||600,height:i.height||600})},_createHandlers:function(){var t=this;t.element.on(lt,t._wheel.bind(t)).on("keydown"+j,t._keydown.bind(t)),t._userEvents=new kendo.UserEvents(this.scrollable,{multiTouch:!0,fastTap:!0,tap:t._tap.bind(t),start:t._dragStart.bind(t),move:t._drag.bind(t),end:t._dragEnd.bind(t),gesturestart:t._gestureStart.bind(t),gesturechange:t._gestureChange.bind(t),gestureend:t._gestureEnd.bind(t),doubleTap:t._doubleTap.bind(t),supportDoubleTap:!0}),t.toolService=new D(t),this.scrollable.on("mouseover"+j,t._mouseover.bind(t)).on("mouseout"+j,t._mouseout.bind(t)).on("mousemove"+j,t._mouseMove.bind(t)).on("mousedown"+j,t._mouseDown.bind(t)).on("mouseup"+j,t._mouseUp.bind(t)),this._syncHandler=t._syncChanges.bind(t),t._resizeHandler=t.resize.bind(t,!1),kendo.onResize(t._resizeHandler),this.bind(ot,t._destroyToolBar.bind(t)),this.bind(nt,t._destroyToolBar.bind(t))},_dragStart:function(t){this._pauseMouseHandlers=!0;var e=this._eventPositions(t,!0),i=t.event;this.toolService.start(e,this._meta(i))&&(this._destroyToolBar(),i.preventDefault())},_drag:function(t){var e=this._eventPositions(t),i=t.event;this.toolService.move(e,this._meta(i))&&i.preventDefault()},_dragEnd:function(t){this._pauseMouseHandlers=!1;var e=this._eventPositions(t),i=t.event;this.toolService.end(e,this._meta(i))&&(this._createToolBar(),i.preventDefault())},_mouseMove:function(t){if(!this._pauseMouseHandlers){var e=this._eventPositions(t);this.toolService._updateHoveredItem(e),this.toolService._updateCursor(e)}},_mouseDown:function(){this._pauseMouseHandlers=!0},_mouseUp:function(){this._pauseMouseHandlers=!1},_tap:function(t){var e=this.toolService,i=this.options.selectable,n=this._eventPositions(t),o=this.focus();if(e._updateHoveredItem(n),e.hoveredItem){var s=e.hoveredItem;if(this.trigger("click",{item:s,point:n,meta:this._meta(t.event)}),i&&!1!==s.options.selectable){var r=!1!==i.multiple,a=kendo.support.mobileOS||this._meta(t.event).ctrlKey;s.isSelected?a?(this._destroyToolBar(),s.select(!1)):this._createToolBar(o):(this._destroyToolBar(),this.select(s,{addToSelection:r&&a}),this._createToolBar(o))}}else i&&(this._destroyToolBar(),this.deselect())},_keydown:function(t){this.toolService.keyDown(t.keyCode,this._meta(t))&&t.preventDefault()},_wheel:function(t){var e=function(t){var e=t.originalEvent,i=0;return e.wheelDelta?i=(i=-e.wheelDelta/40)>0?W.ceil(i):W.floor(i):e.detail&&(i=e.detail),i}(t),i=this._eventPositions(t),n=h(this._meta(t),{delta:e});this.toolService.wheel(i,n)&&t.preventDefault()},_meta:function(t){return{ctrlKey:t.ctrlKey,metaKey:t.metaKey,altKey:t.altKey,shiftKey:t.shiftKey,type:t.type}},_eventPositions:function(t,e){var i;if(t.touch){var n=e?"startLocation":"location";i=new S(t.x[n],t.y[n])}else{var o=t.originalEvent;i=new S(o.pageX,o.pageY)}return this.documentToModel(i)},_gestureStart:function(t){this._destroyToolBar(),this.scroller.disable();var e=this.documentToModel(new S(t.center.x,t.center.y)),i={point:e,zoom:this.zoom()};this.trigger(ot,i)||(this._gesture=t,this._initialCenter=e)},_gestureChange:function(t){var e=this._gesture,i=this._initialCenter,n=this.documentToView(new S(t.center.x,t.center.y)),o=t.distance/e.distance,s=this._zoom,r=!1;W.abs(o-1)>=.05&&(this._zoom=s=this._getValidZoom(s*o),this.options.zoom=s,this._gesture=t,r=!0);var a=i.times(s),h=n.minus(a);(r||this._pan.distanceTo(h)>=5)&&(this._panTransform(h),this._updateAdorners()),t.preventDefault()},_doubleTap:function(t){var e=this,i=this._eventPositions(t),n=e.options,o=n.zoomRate,s=e.zoom()+o,r={point:i,meta:this._meta(t),zoom:s};e.trigger(ot,r)||(s=kendo.drawing.util.round(Math.max(n.zoomMin,Math.min(n.zoomMax,s)),2),r.zoom=s,e.zoom(s,r),e.trigger(st,r))},_gestureEnd:function(){!1!==this.options.pannable&&this.scroller.enable(),this.trigger(st,{point:this._initialCenter,zoom:this.zoom()})},_resize:function(){var t=this.viewport();this.canvas&&this.canvas.size(t),this.scrollable&&this.toolBar&&this.scrollable.height(t.height)},_mouseover:function(t){var e=t.target._kendoNode;e&&e.srcElement._hover&&e.srcElement._hover(!0,e.srcElement)},_mouseout:function(t){var e=t.target._kendoNode;e&&e.srcElement._hover&&e.srcElement._hover(!1,e.srcElement)},_initTheme:function(){var t,e=this,n=((e.options||{}).theme||"").toLowerCase(),o=i.ui.themes||{};t=-1!=i.SASS_THEMES.indexOf(n)?i.autoTheme().diagram:(o[n]||{}).diagram,e.options=h({},t,e.options),!0===e.options.editable&&h(e.options,{editable:(t||{}).editable})},_createOptionElements:function(){var t=this.options,e=t.shapes.length;e&&this._createShapes(),t.connections.length&&this._createConnections(),e&&t.layout&&this.layout(t.layout)},_createShapes:function(){var t,e,i=this.options.shapes;for(e=0;e<i.length;e++)t=i[e],this.addShape(t)},_createConnections:function(){var t,e,i,n,o=this,s=o.options,r=s.connectionDefaults,a=s.connections;for(n=0;n<a.length;n++)t=a[n],e=o._findConnectionTarget(t.from),i=o._findConnectionTarget(t.to),o.connect(e,i,h({},r,t))},_findConnectionTarget:function(t){var e,i=q(t=t||{})?t:t.shapeId||t.id;return i?(e=this.getShapeById(i),t.connector&&(e=e.getConnector(t.connector))):e=new S(t.x||0,t.y||0),e},destroy:function(){var t=this;r.fn.destroy.call(t),this._userEvents&&this._userEvents.destroy(),kendo.unbindResize(t._resizeHandler),t.clear(),t.element.off(j),t.scroller.wrapper.off(j),t.canvas.destroy(!0),t.canvas=e,t._destroyEditor(),t.destroyScroller(),t._destroyGlobalToolBar(),t._destroyToolBar()},destroyScroller:function(){var t=this.scroller;t&&(t.destroy(),t.element.remove(),this.scroller=null)},save:function(){var t,e,i,n={shapes:[],connections:[]};for(t=0;t<this.shapes.length;t++)(i=this.shapes[t]).options.serializable&&n.shapes.push(i.options);for(t=0;t<this.connections.length;t++)e=this.connections[t],n.connections.push(h({},e.options,e.toJSON()));return n},focus:function(){if(!this.element.is(kendo._activeElement())){var t,e=this.element,i=e[0],n=[],o=[],s=document.documentElement;do{(i=i.parentNode).scrollHeight>i.clientHeight&&(n.push(i),o.push(i.scrollTop))}while(i!=s);for(e.trigger("focus"),t=0;t<n.length;t++)n[t].scrollTop=o[t];return!0}},load:function(t){this.clear(),this.setOptions(t),this._createShapes(),this._createConnections()},setOptions:function(t){h(this.options,t)},clear:function(){var t=this;t.select(!1),t.mainLayer.clear(),t._shapesQuadTree.clear(),t._initialize()},connect:function(t,e,i){var n;if(this.connectionsDataSource&&this._isEditable){var o=this.connectionsDataSource.add({});(n=this._connectionsDataMap[o.uid]).source(t),n.target(e),n.redraw(i),n.updateModel()}else n=new wt(t,e,h({},this.options.connectionDefaults,i)),this.addConnection(n);return n},connected:function(t,e){for(var i=0;i<this.connections.length;i++){var n=this.connections[i];if(n.from==t&&n.to==e)return!0}return!1},addConnection:function(t,e){return!1!==e&&this.undoRedoService.add(new s.AddConnectionUnit(t,this),!1),t.diagram=this,t._setOptionsFromModel(),t.refresh(),this.mainLayer.append(t.visual),this.connections.push(t),this.trigger(J,{added:[t],removed:[]}),t},_addConnection:function(t,e){var i,n=this.connectionsDataSource;if(n&&this._isEditable){if(i=Bt(n,Et(t.dataItem)),t.dataItem=i,t.updateModel(),!this.trigger("add",{connection:t}))return this._connectionsDataMap[i.uid]=t,n.add(i),this.addConnection(t,e),t._updateConnectors(),t}else if(!this.trigger("add",{connection:t}))return this.addConnection(t,e),t._updateConnectors(),t},addShape:function(t,e){var i,n=this.options.shapeDefaults;if(t instanceof yt)i=t,this._parseBounds(i.bounds());else{if(t instanceof kendo.Class)return;n=h({},n,t||{}),i=new yt(n,this),this._parseBounds(i.bounds())}return!1!==e&&this.undoRedoService.add(new s.AddShapeUnit(i,this),!1),this.shapes.push(i),i.diagram!==this&&(this._shapesQuadTree.insert(i),i.diagram=this),this.mainLayer.append(i.visual),this.trigger(J,{added:[i],removed:[]}),i},_addShape:function(t,e){var i,n=this.dataSource;if(n&&this._isEditable){if(i=Bt(n,Et(t.dataItem)),t.dataItem=i,t.updateModel(),!this.trigger("add",{shape:t})){this.dataSource.add(i);var o=this._inactiveShapeItems.getByUid(i.uid);return o.element=t,o.undoable=e,t}}else if(!this.trigger("add",{shape:t}))return this.addShape(t,e)},_parseBounds:function(t){t.x="string"==typeof t.x?parseFloat(t.x):t.x,t.y="string"==typeof t.y?parseFloat(t.y):t.y},remove:function(t,e){var i,n=zt(t=F(t)?t.slice(0):[t]),o=n.shapes,s=n.connections;for(H(e)||(e=!0),e&&this.undoRedoService.begin(),this._suspendModelRefresh(),i=o.length-1;i>=0;i--)this._removeItem(o[i],e,s);for(i=s.length-1;i>=0;i--)this._removeItem(s[i],e);this._resumeModelRefresh(),e&&this.undoRedoService.commit(!1),this.trigger(J,{added:[],removed:t})},_removeShapeDataItem:function(t){this._isEditable&&(this.dataSource.remove(t.dataItem),delete this._dataMap[t.dataItem.id])},_removeConnectionDataItem:function(t){this._isEditable&&(this.connectionsDataSource.remove(t.dataItem),delete this._connectionsDataMap[t.dataItem.uid])},_triggerRemove:function(t){for(var e,i,n,o=[],s=0;s<t.length;s++)n=(e=t[s]).options.editable,i=e instanceof yt?{shape:e}:{connection:e},n&&!1!==n.remove&&!this.trigger("remove",i)&&o.push(e);return o},undo:function(){this.undoRedoService.undo()},redo:function(){this.undoRedoService.redo()},select:function(t,e){if(!V(t))return this._selectedItems;var i,n,o=[],s=[];for((e=h({addToSelection:!1},e)).addToSelection||this.deselect(),this._internalSelection=!0,t instanceof Array?o=t:t instanceof vt&&(o=[t]),i=0;i<o.length;i++)(n=o[i]).select(!0)&&s.push(n);this._selectionChanged(s,[]),this._internalSelection=!1},selectAll:function(){this.select(this.shapes.concat(this.connections))},selectArea:function(t){var e,i,n;this._internalSelection=!0;var o=[];if(t instanceof _)for(i=this.shapes.concat(this.connections),e=0;e<i.length;e++)n=i[e],t&&!n._hitTest(t)||!n.options.enable||n.select(!0)&&o.push(n);this._selectionChanged(o,[]),this._internalSelection=!1},deselect:function(t){this._internalSelection=!0;var e,i,n=[],o=[];for(t instanceof Array?o=t:t instanceof vt?o.push(t):V(t)||(o=this._selectedItems.slice(0)),i=0;i<o.length;i++)(e=o[i]).select(!1)&&n.push(e);this._selectionChanged([],n),this._internalSelection=!1},toFront:function(t,e){t||(t=this._selectedItems.slice());var i,n=this._getDiagramItems(t);if(!H(e)||e){i=mt(this.mainLayer,n.visuals);var o=new N(this,t,i);this.undoRedoService.add(o)}else this.mainLayer.toFront(n.visuals),this._fixOrdering(n,!0)},toBack:function(t,e){t||(t=this._selectedItems.slice());var i,n=this._getDiagramItems(t);if(!H(e)||e){i=mt(this.mainLayer,n.visuals);var o=new R(this,t,i);this.undoRedoService.add(o)}else this.mainLayer.toBack(n.visuals),this._fixOrdering(n,!1)},bringIntoView:function(t,e){var i,n,o,r,a=this.viewport(),c=new s.RectAlign(a);0!==a.width&&0!==a.height&&("none"==(e=h({animate:!1,align:"center middle"},e)).align&&(e.align="center middle"),t instanceof vt?n=t.bounds(ct):F(t)?n=this.boundingBox(t):t instanceof _&&(n=t.clone()),o=n.clone(),n.zoom(this._zoom),(n.width>a.width||n.height>a.height)&&(this._zoom=this._getValidZoom(W.min(a.width/o.width,a.height/o.height)),n=o.clone().zoom(this._zoom)),this._zoomMainLayer(),i=n.clone(),c.align(n,e.align),r=n.topLeft().minus(i.topLeft()),this.pan(r.times(-1),e.animate))},alignShapes:function(t){U(t)&&(t="Left");var e,i,n,o=this.select();if(0!==o.length){switch(t.toLowerCase()){case"left":case"top":e=at;break;case"right":case"bottom":e=ht}for(n=0;n<o.length;n++)if((i=o[n])instanceof yt)switch(t.toLowerCase()){case"left":e=W.min(e,i.options.x);break;case"top":e=W.min(e,i.options.y);break;case"right":e=W.max(e,i.options.x);break;case"bottom":e=W.max(e,i.options.y)}var r=[],a=[];for(n=0;n<o.length;n++)if((i=o[n])instanceof yt)switch(a.push(i),r.push(i.bounds()),t.toLowerCase()){case"left":case"right":i.position(new S(e,i.options.y));break;case"top":case"bottom":i.position(new S(i.options.x,e))}var h=new s.TransformUnit(a,r);this.undoRedoService.add(h,!1)}},zoom:function(t,e){if(t){var i=e?e.point:new s.Point(0,0);if(t=this._zoom=this._getValidZoom(t),!U(i)){var n=(i=new s.Point(W.round(i.x),W.round(i.y))).times(t),o=this.modelToView(i).minus(n);this._storePan(new s.Point(W.round(o.x),W.round(o.y)))}e&&(e.zoom=t),this._panTransform(),this.canvas.surface.hideTooltip(),this._updateAdorners()}return this._zoom},_getPan:function(t){return this.canvas.translate||(t=t.plus(this._pan)),t},pan:function(t,e){if(!(t instanceof S))return this._pan.times(-1);var i=this,n=i.scroller;t=(t=i._getPan(t)).times(-1),e?n.animatedScrollTo(t.x,t.y,(function(){i._updateAdorners()})):(n.scrollTo(t.x,t.y),i._updateAdorners())},viewport:function(){var t=this.element,e=t.width(),i=t.height();return this.toolBar&&(i-=d(this.toolBar.element)),new _(0,0,e,i)},copy:function(){if(this.options.copy.enabled){this._clipboard=[],this._copyOffset=1;for(var t=0;t<this._selectedItems.length;t++){var e=this._selectedItems[t];this._clipboard.push(e)}}},cut:function(){if(this.options.copy.enabled){this._clipboard=[],this._copyOffset=0;for(var t=0;t<this._selectedItems.length;t++){var e=this._selectedItems[t];this._clipboard.push(e)}this.remove(this._clipboard,!0)}},paste:function(){if(this._clipboard.length>0){var t,e,i,n={},o=zt(this._clipboard),s=o.connections,r=o.shapes,a={x:this._copyOffset*this.options.copy.offsetX,y:this._copyOffset*this.options.copy.offsetY};for(this.deselect(),i=0;i<r.length;i++)e=(t=r[i]).clone(),n[t.id]=e,e.position(new S(t.options.x+a.x,t.options.y+a.y)),e.diagram=this,(e=this._addShape(e))&&e.select();for(i=0;i<s.length;i++)t=s[i],(e=this._addConnection(t.clone()))&&(this._updateCopiedConnection(e,t,"source",n,a),this._updateCopiedConnection(e,t,"target",n,a),e.select(!0),e.updateModel());this._syncChanges(),this._copyOffset+=1}},_updateCopiedConnection:function(t,e,i,n,o){var s,r,a,h=e[i](),c=this;h instanceof _t&&n[h.shape.id]?(a=n[h.shape.id],c.getShapeById(a.id)?t[i](a.getConnector(h.options.name)):(r=c._inactiveShapeItems.getByUid(a.dataItem.uid))&&(s=function(e){a=c._dataMap[e.id],t[i](a.getConnector(h.options.name)),t.updateModel()},c._deferredConnectionUpdates.push(r.onActivate(s)))):t[i](new S(e[i+"Point"]().x+o.x,e[i+"Point"]().y+o.y))},boundingBox:function(t,e){var i,n=_.empty(),o=V(t)?this._getDiagramItems(t):{shapes:this.shapes};if(o.shapes.length>0){var s=o.shapes[0];n=s.bounds(dt);for(var r=1;r<o.shapes.length;r++)i=(s=o.shapes[r]).bounds(dt),!0===e&&(i.x-=s._rotationOffset.x,i.y-=s._rotationOffset.y),n=n.union(i)}return n},_containerOffset:function(){var t=this.element.offset();return this.toolBar&&(t.top+=d(this.toolBar.element)),t},documentToView:function(t){var e=this._containerOffset();return new S(t.x-e.left,t.y-e.top)},viewToDocument:function(t){var e=this._containerOffset();return new S(t.x+e.left,t.y+e.top)},viewToModel:function(t){return this._transformWithMatrix(t,this._matrixInvert)},modelToView:function(t){return this._transformWithMatrix(t,this._matrix)},modelToLayer:function(t){return this._transformWithMatrix(t,this._layerMatrix)},layerToModel:function(t){return this._transformWithMatrix(t,this._layerMatrixInvert)},documentToModel:function(t){var e=this.documentToView(t);return this.canvas.translate||(e.x=e.x+this.scroller.scrollLeft,e.y=e.y+this.scroller.scrollTop),this.viewToModel(e)},modelToDocument:function(t){return this.viewToDocument(this.modelToView(t))},_transformWithMatrix:function(t,e){var i=t;if(t instanceof S)e&&(i=e.apply(t));else{var n=this._transformWithMatrix(t.topLeft(),e),o=this._transformWithMatrix(t.bottomRight(),e);i=_.fromPoints(n,o)}return i},setDataSource:function(t){this.options.dataSource=t,this._dataSource(),this.options.autoBind&&this.dataSource.fetch()},setConnectionsDataSource:function(t){this.options.connectionsDataSource=t,this._connectionDataSource(),this.options.autoBind&&this.connectionsDataSource.fetch()},layout:function(t){var e,i;switch(this._layouting=!0,U(t)&&(t=this.options.layout),(e=U(t)||U(t.type)?"Tree":t.type).toLowerCase()){case"tree":i=new s.TreeLayout(this);break;case"layered":i=new s.LayeredLayout(this);break;case"forcedirected":case"force":case"spring":case"springembedder":i=new s.SpringLayout(this);break;default:throw"Layout algorithm '"+e+"' is not supported."}var n=new s.LayoutState(this),o=i.layout(t);if(o){var r=new s.LayoutUndoUnit(n,o,t?t.animate:null);this.undoRedoService.add(r)}this._layouting=!1,this._redrawConnections()},getShapeById:function(t){var e;return(e=z.first(this.shapes,(function(e){return e.visual.id===t})))?e:e=z.first(this.connections,(function(e){return e.visual.id===t}))},getShapeByModelId:function(t){return this._isEditable?this._dataMap[t]:z.first(this.shapes,(function(e){return(e.dataItem||{}).id===t}))},getShapeByModelUid:function(t){return this._isEditable?z.first(this.shapes,(function(e){return(e.dataItem||{}).uid===t})):this._dataMap[t]},getConnectionByModelId:function(t){var e;return this.connectionsDataSource&&(e=z.first(this.connections,(function(e){return(e.dataItem||{}).id===t}))),e},getConnectionByModelUid:function(t){var e;return this.connectionsDataSource&&(e=this._connectionsDataMap[t]),e},_extendLayoutOptions:function(t){t.layout&&(t.layout=h({},s.LayoutBase.fn.defaultOptions||{},t.layout))},_selectionChanged:function(t,e){(t.length||e.length)&&this.trigger(et,{selected:t,deselected:e})},_getValidZoom:function(t){return W.min(W.max(t,this.options.zoomMin),this.options.zoomMax)},_panTransform:function(t){var e=this,i=t||e._pan;e.canvas.translate?(e.scroller.scrollTo(i.x,i.y),e._zoomMainLayer()):(e._storePan(i),e._transformMainLayer())},_finishPan:function(){this.trigger(nt,{total:this._pan,delta:Number.NaN})},_storePan:function(t){this._pan=t,this._storeViewMatrix()},_zoomMainLayer:function(){var t=this._zoom,e=new v(0,0,t,t);e.render(this.mainLayer),this._storeLayerMatrix(e),this._storeViewMatrix()},_transformMainLayer:function(){var t=this._pan,e=this._zoom,i=new v(t.x,t.y,e,e);i.render(this.mainLayer),this._storeLayerMatrix(i),this._storeViewMatrix()},_storeLayerMatrix:function(t){this._layerMatrix=t.toMatrix(),this._layerMatrixInvert=t.invert().toMatrix()},_storeViewMatrix:function(){var t=this._pan,e=this._zoom,i=new v(t.x,t.y,e,e);this._matrix=i.toMatrix(),this._matrixInvert=i.invert().toMatrix()},_toIndex:function(t,e){var i=this._getDiagramItems(t);this.mainLayer.toIndex(i.visuals,e),this._fixOrdering(i,!1)},_fixOrdering:function(t,e){var i,n,o=e?this.shapes.length-1:0,s=e?this.connections.length-1:0;for(i=0;i<t.shapes.length;i++)n=t.shapes[i],z.remove(this.shapes,n),z.insert(this.shapes,n,o);for(i=0;i<t.cons.length;i++)n=t.cons[i],z.remove(this.connections,n),z.insert(this.connections,n,s)},_getDiagramItems:function(t){var e,i={},n=t;for(i.visuals=[],i.shapes=[],i.cons=[],t?F(t)||(n=[t]):n=this._selectedItems.slice(),e=0;e<n.length;e++){var o=n[e];o instanceof yt?(i.shapes.push(o),i.visuals.push(o.visual)):o instanceof wt&&(i.cons.push(o),i.visuals.push(o.visual))}return i},_removeItem:function(t,e,i){t.select(!1),t instanceof yt?(this._removeShapeDataItem(t),this._removeShape(t,e,i)):t instanceof wt&&(this._removeConnectionDataItem(t),this._removeConnection(t,e)),this.mainLayer.remove(t.visual)},_removeShape:function(t,e,n){var o,s,r,a=[],h=[];for(this.toolService._removeHover(),e&&this.undoRedoService.addCompositeItem(new w(t)),z.remove(this.shapes,t),this._shapesQuadTree.remove(t),o=0;o<t.connectors.length;o++){r=t.connectors[o];for(var c=0;c<r.connections.length;c++)s=r.connections[c],n&&i.inArray(s,n)||(s.sourceConnector==r?a.push(s):s.targetConnector==r&&h.push(s))}for(o=0;o<a.length;o++)a[o].source(null,e),a[o].updateModel();for(o=0;o<h.length;o++)h[o].target(null,e),h[o].updateModel()},_removeConnection:function(t,e){t.sourceConnector&&z.remove(t.sourceConnector.connections,t),t.targetConnector&&z.remove(t.targetConnector.connections,t),e&&this.undoRedoService.addCompositeItem(new x(t)),z.remove(this.connections,t)},_removeDataItems:function(t,e){var i,n,o,s;for(t=F(t)?t:[t];t.length;)if(i=t.shift(),(o=this._dataMap[i.uid])&&(this._removeShapeConnections(o),this._removeItem(o,!1),delete this._dataMap[i.uid],e&&i.hasChildren&&i.loaded()))for(n=i.children.data(),s=0;s<n.length;s++)t.push(n[s])},_removeShapeConnections:function(t){var e,i=t.connections();if(i)for(e=0;e<i.length;e++)this._removeItem(i[e],!1)},_addDataItem:function(t,e){if(H(t)){var i=this._dataMap[t.id];if(i)return i;var n=h({},this.options.shapeDefaults);return n.dataItem=t,i=new yt(n,this),this.addShape(i,!1!==e),this._dataMap[t.id]=i,i}},_addDataItemByUid:function(t){if(H(t)){var e=this._dataMap[t.uid];if(e)return e;var i=h({},this.options.shapeDefaults);return i.dataItem=t,e=new yt(i,this),this.addShape(e),this._dataMap[t.uid]=e,e}},_addDataItems:function(t,e){var i,n,o,s;for(n=0;n<t.length;n++)i=t[n],o=this._addDataItemByUid(i),(s=this._addDataItemByUid(e))&&!this.connected(s,o)&&this.connect(s,o)},_refreshSource:function(t){var e,i,n=this,o=t.node,s=t.action,r=t.items,a=n.options;if(t.field)for(e=0;e<r.length;e++)this._dataMap[r[e].uid]&&this._dataMap[r[e].uid].redrawVisual();else{if("remove"==s)this._removeDataItems(t.items,!0);else for(s&&"itemloaded"!==s||this._bindingRoots||(this._bindingRoots=!0,i=!0),s||o||n.clear(),this._addDataItems(r,o),e=0;e<r.length;e++)r[e].load();a.layout&&(i||"remove"==s||"add"==s)&&n.layout(a.layout),i&&(this.trigger("dataBound"),this._bindingRoots=!1)}},_addItem:function(t){t instanceof yt?this.addShape(t):t instanceof wt&&this.addConnection(t)},_createToolBar:function(t){var e=this.toolService.diagram;if(!this.singleToolBar&&1===e.select().length){var i=e.select()[0];if(i&&!1!==i.options.editable){var n=i.options.editable,o=n.tools;if(this._isEditable&&0===o.length&&(i instanceof yt?o=["edit","rotateClockwise","rotateAnticlockwise"]:i instanceof wt&&(o=["edit"]),n&&!1!==n.remove&&o.push("delete")),o&&o.length){var s;this.singleToolBar=new Ct(e,{tools:o,click:this._toolBarClick.bind(this),modal:!0,popupZIndex:parseInt(e.element.closest(".k-window").css("zIndex"),10)+10});var r=c(this.singleToolBar._popup.element),a=d(this.singleToolBar._popup.element);if(i instanceof yt){var h=this.modelToView(i.bounds(dt));s=new S(h.x,h.y).minus(new S((r-h.width)/2,a+20))}else if(i instanceof wt){var l=this.modelToView(i.bounds());s=new S(l.x,l.y).minus(new S((r-l.width-20)/2,a+20))}s?(this.canvas.translate||(s=s.minus(new S(this.scroller.scrollLeft,this.scroller.scrollTop))),s=this.viewToDocument(s),s=new S(W.max(s.x,0),W.max(s.y,0)),this.singleToolBar.showAt(s),t&&this.singleToolBar._popup.one("close",At)):this._destroyToolBar()}}}},_toolBarClick:function(t){this.trigger("toolBarClick",t),this._destroyToolBar()},_normalizePointZoom:function(t){return t.times(1/this.zoom())},_initialize:function(){this.shapes=[],this._selectedItems=[],this.connections=[],this._dataMap={},this._connectionsDataMap={},this._inactiveShapeItems=new Dt,this._deferredConnectionUpdates=[],this.undoRedoService=new M({undone:this._syncHandler,redone:this._syncHandler}),this.id=s.randomId()},_fetchFreshData:function(){var t=this;t._dataSource(),t._isEditable&&t._connectionDataSource(),t.options.autoBind&&(t._isEditable?(this._loadingShapes=!0,this._loadingConnections=!0,t.dataSource.fetch(),t.connectionsDataSource.fetch()):t.dataSource.fetch())},_dataSource:function(){if(H(this.options.connectionsDataSource)){this._isEditable=!0;var t=this.options.dataSource||{},e=F(t)?{data:t}:t;this.dataSource&&this._shapesRefreshHandler?this.dataSource.unbind("change",this._shapesRefreshHandler).unbind("requestStart",this._shapesRequestStartHandler).unbind("error",this._shapesErrorHandler):(this._shapesRefreshHandler=this._refreshShapes.bind(this),this._shapesRequestStartHandler=this._shapesRequestStart.bind(this),this._shapesErrorHandler=this._error.bind(this)),this.dataSource=kendo.data.DataSource.create(e).bind("change",this._shapesRefreshHandler).bind("requestStart",this._shapesRequestStartHandler).bind("error",this._shapesErrorHandler)}else this._treeDataSource(),this._isEditable=!1},_connectionDataSource:function(){var t=this.options.connectionsDataSource;if(t){var e=F(t)?{data:t}:t;this.connectionsDataSource&&this._connectionsRefreshHandler?this.connectionsDataSource.unbind("change",this._connectionsRefreshHandler).unbind("requestStart",this._connectionsRequestStartHandler).unbind("error",this._connectionsErrorHandler):(this._connectionsRefreshHandler=this._refreshConnections.bind(this),this._connectionsRequestStartHandler=this._connectionsRequestStart.bind(this),this._connectionsErrorHandler=this._connectionsError.bind(this)),this.connectionsDataSource=kendo.data.DataSource.create(e).bind("change",this._connectionsRefreshHandler).bind("requestStart",this._connectionsRequestStartHandler).bind("error",this._connectionsErrorHandler)}},_shapesRequestStart:function(t){"read"==t.type&&(this._loadingShapes=!0)},_connectionsRequestStart:function(t){"read"==t.type&&(this._loadingConnections=!0)},_error:function(){this._loadingShapes=!1},_connectionsError:function(){this._loadingConnections=!1},_refreshShapes:function(t){"remove"===t.action?this._shouldRefresh()&&this._removeShapes(t.items):"itemchange"===t.action?this._shouldRefresh()&&this._updateShapes(t.items,t.field):"add"===t.action?this._inactiveShapeItems.add(t.items):"sync"===t.action?this._syncShapes(t.items):this.refresh()},_shouldRefresh:function(){return!this._suspended},_suspendModelRefresh:function(){this._suspended=(this._suspended||0)+1},_resumeModelRefresh:function(){this._suspended=W.max((this._suspended||0)-1,0)},refresh:function(){this._loadingShapes=!1,this._loadingConnections||this._rebindShapesAndConnections()},_rebindShapesAndConnections:function(){this.clear(),this._addShapes(this.dataSource.view()),this.connectionsDataSource&&this._addConnections(this.connectionsDataSource.view(),!1),this.options.layout?this.layout(this.options.layout):this._redrawConnections(),this.trigger("dataBound")},refreshConnections:function(){this._loadingConnections=!1,this._loadingShapes||this._rebindShapesAndConnections()},_redrawConnections:function(){for(var t=this.connections,e=0;e<t.length;e++)t[e].refresh()},_removeShapes:function(t){var e,i,n=this._dataMap;for(i=0;i<t.length;i++)n[(e=t[i]).id]&&(this.remove(n[e.id],!1),n[e.id]=null)},_syncShapes:function(){var t=this,e=t._inactiveShapeItems;e.forEach((function(i){var n=i.dataItem,o=i.element;n.isNew()||(o?(o._setOptionsFromModel(),t.addShape(o,i.undoable),t._dataMap[n.id]=o):t._addDataItem(n),i.activate(),e.remove(n))}))},_updateShapes:function(t,e){for(var i=0;i<t.length;i++){var n=t[i],o=this._dataMap[n.id];o&&o.updateOptionsFromModel(n,e)}},_addShapes:function(t){for(var e=0;e<t.length;e++)this._addDataItem(t[e],!1)},_refreshConnections:function(t){"remove"===t.action?this._shouldRefresh()&&this._removeConnections(t.items):"add"===t.action?this._addConnections(t.items):"sync"===t.action||("itemchange"===t.action?this._shouldRefresh()&&this._updateConnections(t.items):this.refreshConnections())},_removeConnections:function(t){for(var e=0;e<t.length;e++)this.remove(this._connectionsDataMap[t[e].uid],!1),this._connectionsDataMap[t[e].uid]=null},_updateConnections:function(t){for(var e=0;e<t.length;e++){var i=t[e];this._connectionsDataMap[i.uid].updateOptionsFromModel(i)}},_addConnections:function(t,e){for(var i=t.length,n=0;n<i;n++){var o=t[n];this._addConnectionDataItem(o,e)}},_addConnectionDataItem:function(t,e){if(!this._connectionsDataMap[t.uid]){var i=this._validateConnector(t.from);H(i)&&null!==i||(i=new S(t.fromX,t.fromY));var n=this._validateConnector(t.to);if(H(n)&&null!==n||(n=new S(t.toX,t.toY)),H(i)&&H(n)){var o=h({},this.options.connectionDefaults);o.dataItem=t;var s=new wt(i,n,o);this._connectionsDataMap[t.uid]=s,this.addConnection(s,e)}}},_validateConnector:function(t){var e;return H(t)&&null!==t&&(e=this._dataMap[t]),e},_treeDataSource:function(){var t=this,e=t.options.dataSource;if((e=F(e)?{data:e}:e)instanceof kendo.data.DataSource&&!(e instanceof kendo.data.HierarchicalDataSource))throw new Error("Incorrect DataSource type. If a single dataSource instance is set to the diagram then it should be a HierarchicalDataSource. You should set only the options instead of an instance or a HierarchicalDataSource instance or supply connectionsDataSource as well.");e.fields||(e.fields=[{field:"text"},{field:"url"},{field:"spriteCssClass"},{field:"imageUrl"}]),t.dataSource&&t._refreshHandler&&t._unbindDataSource(),t._refreshHandler=t._refreshSource.bind(t),t._errorHandler=t._error.bind(t),t.dataSource=u.create(e).bind(J,t._refreshHandler).bind(Z,t._errorHandler)},_unbindDataSource:function(){var t=this;t.dataSource.unbind(J,t._refreshHandler).unbind(Z,t._errorHandler)},_adorn:function(t,i){i!==e&&t&&(i?(this._adorners.push(t),this.adornerLayer.append(t.visual)):(z.remove(this._adorners,t),this.adornerLayer.remove(t.visual)))},_showConnectors:function(t,e){e?this._connectorsAdorner.show(t):this._connectorsAdorner.destroy()},_updateAdorners:function(){for(var t=this._adorners,e=0;e<t.length;e++){var i=t[e];i.refreshBounds&&i.refreshBounds(),i.refresh()}},_refresh:function(){for(var t=0;t<this.connections.length;t++)this.connections[t].refresh()},_destroyToolBar:function(){this.singleToolBar&&(this.singleToolBar.hide(),this.singleToolBar.destroy(),this.singleToolBar=null)},_destroyGlobalToolBar:function(){this.toolBar&&(this.toolBar.hide(),this.toolBar.destroy(),this.toolBar=null)},exportDOMVisual:function(){var t=this.canvas._viewBox,e=o.transform().translate(-t.x,-t.y),i=new o.Rect([0,0],[t.width,t.height]),s=n.Path.fromRect(i),r=new n.Group({transform:e}),a=new n.Group({clip:s}),h=this.canvas.drawingElement.children[0];return a.append(r),r.children.push(h),a},exportVisual:function(){var t=o.transform().scale(1/this._zoom),e=new n.Group({transform:t}),i=this.mainLayer.drawingElement;return e.children.push(i),e},_syncChanges:function(){this._syncShapeChanges(),this._syncConnectionChanges()},_syncShapeChanges:function(){this.dataSource&&this._isEditable&&this.dataSource.sync()},_syncConnectionChanges:function(){var e=this;e.connectionsDataSource&&e._isEditable&&(t.when.apply(t,e._deferredConnectionUpdates).then((function(){e.connectionsDataSource.sync()})),e.deferredConnectionUpdates=[])}});function bt(t){var e={};return H((t=t||{}).text)&&null!==t.text&&(e.text=t.text),H(t.x)&&null!==t.x&&(e.x=t.x),H(t.y)&&null!==t.y&&(e.y=t.y),H(t.width)&&null!==t.width&&(e.width=t.width),H(t.height)&&null!==t.height&&(e.height=t.height),H(t.type)&&null!==t.type&&(e.type=t.type),e}i.ExportMixin.extend(xt.fn,!0),kendo.PDFMixin&&kendo.PDFMixin.extend(xt.fn);var Ct=kendo.Observable.extend({init:function(t,e){kendo.Observable.fn.init.call(this),this.diagram=t,this.options=h({},this.options,e),this._tools=[],this.createToolBar(),this.createTools(),this.appendTools(),this.options.modal&&this.createPopup(),this.bind(this.events,e)},events:["click"],createPopup:function(){this.container=t("<div/>").append(this.element),this._popup=this.container.kendoPopup({}).getKendoPopup()},appendTools:function(){for(var t=0;t<this._tools.length;t++){var e=this._tools[t];(e.buttons&&e.buttons.length||!H(e.buttons))&&this._toolBar.add(e)}},createToolBar:function(){this.element=t("<div/>"),this._toolBar=this.element.kendoToolBar({click:this.click.bind(this),resizable:!1}).getKendoToolBar(),this.element.css("border","none")},createTools:function(){for(var t=0;t<this.options.tools.length;t++)this.createTool(this.options.tools[t])},createTool:function(t){K(t)||(t={name:t});var e=t.name+"Tool";this[e]?this[e](t):this._tools.push(h({},t,{attributes:this._setAttributes({action:t.name})}))},showAt:function(t){var e=parseInt(this.options.popupZIndex,10);this._popup&&(this._popup.open(t.x,t.y),e&&this._popup.wrapper.css("zIndex",e))},hide:function(){this._popup&&this._popup.close()},newGroup:function(){return{type:"buttonGroup",buttons:[]}},editTool:function(){this._tools.push({icon:"pencil",showText:"overflow",type:"button",text:"Edit",attributes:this._setAttributes({action:"edit"})})},deleteTool:function(){this._tools.push({icon:"x",showText:"overflow",type:"button",text:"Delete",attributes:this._setAttributes({action:"delete"})})},rotateAnticlockwiseTool:function(t){this._appendGroup("rotate"),this._rotateGroup.buttons.push({icon:"rotate-left",showText:"overflow",text:"RotateAnticlockwise",group:"rotate",attributes:this._setAttributes({action:"rotateAnticlockwise",step:t.step})})},rotateClockwiseTool:function(t){this._appendGroup("rotate"),this._rotateGroup.buttons.push({icon:"rotate-right",attributes:this._setAttributes({action:"rotateClockwise",step:t.step}),showText:"overflow",text:"RotateClockwise",group:"rotate"})},createShapeTool:function(){this._appendGroup("create"),this._createGroup.buttons.push({icon:"shapes",showText:"overflow",text:"CreateShape",group:"create",attributes:this._setAttributes({action:"createShape"})})},createConnectionTool:function(){this._appendGroup("create"),this._createGroup.buttons.push({icon:"connector",showText:"overflow",text:"CreateConnection",group:"create",attributes:this._setAttributes({action:"createConnection"})})},undoTool:function(){this._appendGroup("history"),this._historyGroup.buttons.push({icon:"undo",showText:"overflow",text:"Undo",group:"history",attributes:this._setAttributes({action:"undo"})})},redoTool:function(){this._appendGroup("history"),this._historyGroup.buttons.push({icon:"redo",showText:"overflow",text:"Redo",group:"history",attributes:this._setAttributes({action:"redo"})})},_appendGroup:function(t){var e="_"+t+"Group";this[e]||(this[e]=this.newGroup(),this._tools.push(this[e]))},_setAttributes:function(t){var e={};return t.action&&(e[kendo.attr("action")]=t.action),t.step&&(e[kendo.attr("step")]=t.step),e},_getAttributes:function(t){var e={},i=t.attr(kendo.attr("action"));i&&(e.action=i);var n=t.attr(kendo.attr("step"));return n&&(e.step=n),e},click:function(e){var i=this._getAttributes(t(e.target)),n=i.action;n&&this[n]&&this[n](i),this.trigger("click",this.eventData(n,e.target))},eventData:function(t,e){for(var i,n=this.selectedElements(),o=n.length,s=[],r=[],a=0;a<o;a++)(i=n[a])instanceof yt?s.push(i):r.push(i);return{shapes:s,connections:r,action:t,target:e}},delete:function(){var t=this.diagram._triggerRemove(this.selectedElements());t.length&&(this.diagram.remove(t,!0),this.diagram._syncChanges())},edit:function(){var t=this.selectedElements();1===t.length&&this.diagram.edit(t[0])},rotateClockwise:function(t){var e=parseFloat(t.step||90);this._rotate(e)},rotateAnticlockwise:function(t){var e=parseFloat(t.step||90);this._rotate(-e)},_rotate:function(t){var e=this.diagram._resizingAdorner;e.angle(e.angle()+t),e.rotate()},selectedElements:function(){return this.diagram.select()},createShape:function(){this.diagram.createShape()},createConnection:function(){this.diagram.createConnection()},undo:function(){this.diagram.undo()},redo:function(){this.diagram.redo()},destroy:function(){this.diagram=null,this.element=null,this.options=null,this._toolBar&&this._toolBar.destroy(),this._popup&&this._popup.destroy()}}),St=kendo.Observable.extend({init:function(t,e){kendo.Observable.fn.init.call(this),this.options=l(!0,{},this.options,e),this.element=t,this.model=this.options.model,this.fields=this._getFields(),this._initContainer(),this.createEditable()},options:{editors:{}},_initContainer:function(){this.wrapper=this.element},createEditable:function(){var t=this.options;this.editable=new kendo.ui.Editable(this.wrapper,{fields:this.fields,target:t.target,clearContainer:!1,model:this.model})},_isEditable:function(t){return this.model.editable&&this.model.editable(t)},_getFields:function(){var t=[],e=this.model.fields;for(var i in e){var n={};if(this._isEditable(i)){var o=this.options.editors[i];o&&(n.editor=o),n.field=i,t.push(n)}}return t},end:function(){return this.editable.end()},destroy:function(){this.editable.destroy(),this.editable.element.find("["+kendo.attr("container-for")+"]").empty(),this.model=this.wrapper=this.element=this.columns=this.editable=null}}),kt=St.extend({init:function(t,e){St.fn.init.call(this,t,e),this.bind(this.events,this.options),this.open()},events:["update","cancel"],options:{window:{modal:!0,resizable:!1,draggable:!0,title:"Edit",visible:!1}},_initContainer:function(){var e=this;this.wrapper=t('<div class="k-popup-edit-form"/>').attr(kendo.attr("uid"),this.model.uid);var i="";this.options.template?(i+=this._renderTemplate(),this.fields=[]):i+=this._renderFields(),i+=this._renderButtons(),this.wrapper.append(t('<div class="k-edit-form-container"/>').append(i)),this.window=new kendo.ui.Window(this.wrapper.appendTo(this.element),this.options.window),this.window.bind("close",(function(t){t.userTriggered&&(t.sender.element.trigger("focus"),e._cancelClick(t))})),this._attachButtonEvents()},_renderTemplate:function(){var t=this.options.template;return"string"==typeof t&&(t=kendo.unescape(t)),t=kendo.template(t)(this.model)},_renderFields:function(){for(var t="",e=0;e<this.fields.length;e++){var i=this.fields[e];t+='<div class="k-edit-label"><label for="'+i.field+'">'+(i.field||"")+"</label></div>",this._isEditable(i.field)&&(t+="<div "+kendo.attr("container-for")+'="'+i.field+'" class="k-edit-field"></div>')}return t},_renderButtons:function(){var t='<div class="k-edit-buttons">';return t+=this._createButton("update"),t+=this._createButton("cancel"),t+="</div>"},_createButton:function(t){return kendo.template(ut)(ft[t])},_attachButtonEvents:function(){this._cancelClickHandler=this._cancelClick.bind(this),this.window.element.on(Q+j,"button.k-diagram-cancel",this._cancelClickHandler),this._updateClickHandler=this._updateClick.bind(this),this.window.element.on(Q+j,"button.k-diagram-update",this._updateClickHandler)},_updateClick:function(t){t.preventDefault(),this.trigger("update")},_cancelClick:function(t){t.preventDefault(),this.trigger("cancel")},open:function(){this.window.center().open()},close:function(){this.window.bind("deactivate",this.destroy.bind(this)).close()},destroy:function(){this.window.close().destroy(),this.window.element.off(Q+j,"a.k-diagram-cancel",this._cancelClickHandler),this.window.element.off(Q+j,"a.k-diagram-update",this._updateClickHandler),this._cancelClickHandler=null,this._editUpdateClickHandler=null,this.window=null,St.fn.destroy.call(this)}});function Tt(e,i){var n=this.dataSource.reader.model;if(n){var o=n.fn.fields.text?"text":n.idField;t("<input name='"+i.field+"' />").appendTo(e).kendoDropDownList({dataValueField:n.idField,dataTextField:o,dataSource:this.dataSource.data().toJSON(),optionLabel:" ",valuePrimitive:!0})}}function Mt(t){this.dataItem=t,this.callbacks=[]}function Dt(){this.items={}}Mt.fn=Mt.prototype={onActivate:function(e){var i=t.Deferred();return this.callbacks.push({callback:e,deferred:i}),i},activate:function(){for(var t,e=this.callbacks,i=0;i<e.length;i++)(t=this.callbacks[i]).callback(this.dataItem),t.deferred.resolve();this.callbacks=[]}},Dt.fn=Dt.prototype={add:function(t){for(var e=0;e<t.length;e++)this.items[t[e].uid]=new Mt(t[e])},forEach:function(t){for(var e in this.items)t(this.items[e])},getByUid:function(t){return this.items[t]},remove:function(t){delete this.items[t.uid]}};var It=a.extend({init:function(){this.shapes=[]},_add:function(t,e){this.shapes.push({bounds:e,shape:t}),t._quadNode=this},insert:function(t,e){this._add(t,e)},remove:function(t){for(var e=this.shapes,i=e.length,n=0;n<i;n++)if(e[n].shape===t){e.splice(n,1);break}},hitTestRect:function(t,e){for(var n=this.shapes,o=n.length,s=0;s<o;s++)if(this._testRect(n[s].shape,t)&&!i.inArray(n[s].shape,e))return!0},_testRect:function(t,e){var i=t.rotate().angle,n=t.bounds();return i?k.rects(e,n,-i):n.overlaps(e)}}),Pt=It.extend({init:function(t){It.fn.init.call(this),this.children=[],this.rect=t},inBounds:function(t){var e=this.rect,i=e.bottomRight(),n=t.bottomRight();return e.x<=t.x&&e.y<=t.y&&n.x<=i.x&&n.y<=i.y},overlapsBounds:function(t){return this.rect.overlaps(t)},insert:function(t,e){var i=!1,n=this.children,o=n.length;if(this.inBounds(e)){if(!o&&this.shapes.length<4)this._add(t,e);else{o||this._initChildren();for(var s=0;s<n.length;s++)if(n[s].insert(t,e)){i=!0;break}i||this._add(t,e)}i=!0}return i},_initChildren:function(){var t,e,i=this.rect,n=this.children,o=this.shapes,s=i.center(),r=i.width/2,a=i.height/2;for(n.push(new Pt(new _(i.x,i.y,r,a)),new Pt(new _(s.x,i.y,r,a)),new Pt(new _(i.x,s.y,r,a)),new Pt(new _(s.x,s.y,r,a))),e=o.length-1;e>=0;e--)for(t=0;t<n.length;t++)if(n[t].insert(o[e].shape,o[e].bounds)){o.splice(e,1);break}},hitTestRect:function(t,e){var i,n=this.children,o=n.length,s=!1;if(this.overlapsBounds(t))if(It.fn.hitTestRect.call(this,t,e))s=!0;else for(i=0;i<o;i++)if(n[i].hitTestRect(t,e)){s=!0;break}return s}}),Lt=a.extend({ROOT_SIZE:1e3,init:function(t){var e=this._boundsChange.bind(this);t.bind(Y,e),t.bind(it,e),this.initRoots()},initRoots:function(){this.rootMap={},this.root=new It},clear:function(){this.initRoots()},_boundsChange:function(t){t.item._quadNode&&t.item._quadNode.remove(t.item),this.insert(t.item)},insert:function(t){var e=t.bounds(dt),i=this.ROOT_SIZE,n=this.getSectors(e),o=n[0][0],s=n[1][0];this.inRoot(n)?this.root.insert(t,e):(this.rootMap[o]||(this.rootMap[o]={}),this.rootMap[o][s]||(this.rootMap[o][s]=new Pt(new _(o*i,s*i,i,i))),this.rootMap[o][s].insert(t,e))},remove:function(t){t._quadNode&&t._quadNode.remove(t)},inRoot:function(t){return t[0].length>1||t[1].length>1},getSectors:function(t){for(var e=this.ROOT_SIZE,i=t.bottomRight(),n=W.floor(i.x/e),o=W.floor(i.y/e),s=[[],[]],r=W.floor(t.x/e);r<=n;r++)s[0].push(r);for(var a=W.floor(t.y/e);a<=o;a++)s[1].push(a);return s},hitTestRect:function(t,e){var i,n,o,s,r,a=this.getSectors(t);if(this.root.hitTestRect(t,e))return!0;for(i=0;i<a[0].length;i++)for(o=a[0][i],n=0;n<a[1].length;n++)if(s=a[1][n],(r=(this.rootMap[o]||{})[s])&&r.hitTestRect(t,e))return!0;return!1}});function Et(t){var e=t;return t instanceof kendo.data.Model&&((e=t.toJSON())[t.idField]=t._defaultId),e}function zt(t){var e,i,n=[],o=[];for(i=0;i<t.length;i++)(e=t[i])instanceof yt?o.push(e):n.push(e);return{shapes:o,connections:n}}function Bt(t,e){return t.reader.model?new t.reader.model(e):new kendo.data.ObservableObject(e)}function Rt(t,e){H(e[t])&&e.set(t,null)}function Nt(t,e,i){for(var n,o=0;o<i.length;o++)n=i[o],e&&!H(e[n])&&(e[n]=t[n])}function At(t){t.preventDefault()}i.ui.plugin(xt),h(s,{Shape:yt,Connection:wt,Connector:_t,DiagramToolBar:Ct,QuadNode:Pt,QuadRoot:It,ShapesQuadTree:Lt,PopupEditor:kt})}(window.kendo.jQuery);var e=kendo;t.__meta__={id:"dataviz.diagram",name:"Diagram",category:"dataviz",description:"The Kendo DataViz Diagram ",depends:["data","userevents","mobile.scroller","draganddrop","drawing","dataviz.core","dataviz.themes","toolbar"],features:[{id:"dataviz.diagram-pdf-export",name:"PDF export",description:"Export Diagram as PDF",depends:["pdf"]},{id:"dataviz.diagram-editing",name:"Editing",description:"Support for model editing",depends:["editable","window","dropdownlist"]}]},t.default=e,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=kendo.dataviz.diagram.min.js.map
