
CREATE OR REPLACE VIEW public."RespondentMatrixAnswersView" AS 
 SELECT rma."Id",
    rma."QuestionId"::text AS "QuestionId",
    rma."ExtendedQuestionId"::text AS "ExtendedQuestionId",
    rma."AnswerOptionId"::text AS "AnswerOptionId",
    rma."RespondentId",
    rma."Date", 
    strip_tags(q."Text") as "ParentQuestionText",
    eq."Text" as "QuestionText",
    ao."Text" as "AnswerText"
   FROM "RespondentMatrixAnswers" rma
   join "Questions" q on rma."QuestionId" = q."Id"
   join "ExtendedQuestions" eq on rma."ExtendedQuestionId" = eq."Id"
   join "AnswerOptions" ao on rma."AnswerOptionId" = ao."Id";


