DROP VIEW public."Respondents_Answers";
DROP VIEW public."Respondents_ExtendedAnswers";
DROP VIEW public."RespondentMatrixAnswersView";
DROP VIEW public."RespondentAnswers_Match";
DROP VIEW public."RespondentAnswers_Single";
DROP VIEW public."RespondentAnswers_Multy";

CREATE OR REPLACE VIEW public."RespondentAnswers_Single" AS
 SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%single%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."AnswerValue" AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text;
		  
CREATE OR REPLACE VIEW public."RespondentAnswers_Multy" AS 
SELECT total_multy."Id",
    total_multy."RespondentId",
    total_multy."QuestionText",
    total_multy."Points",
    total_multy."Date",
    total_multy."AnswerValue",
    total_multy."AnswerId",
    total_multy."UserOwnAnswer",
    total_multy."QuestionId"
   FROM ( SELECT multy."Id",
            multy."RespondentId",
            q."Text" AS "QuestionText",
            multy."Points",
            multy."Date",
            ao."Text" AS "AnswerValue",
            multy."AnswerId",
            ''::text AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM ( SELECT ra_split."Id",
                    ra_split."RespondentId",
                    ra_split."QuestionId",
                    ra_split."Points",
                    ra_split."Date",
                    ra_split."AnswerId",
                    ra_split."AnswerValue"
                   FROM ( SELECT ra_m."Id",
                            ra_m."RespondentId",
                            ra_m."QuestionId",
                            ra_m."Points",
                            ra_m."Date",
                            unnest(string_to_array(ra_m."AnswerId", ','::text)) AS "AnswerId",
                            ra_m."AnswerValue"
                           FROM ( SELECT ra."Id",
                                    ra."RespondentId",
                                    ra."QuestionId",
                                    ra."Points",
                                    ra."Date",
                                    ra."AnswerId",
                                    ra."AnswerValue"
                                   FROM "RespondentAnswers" ra
                                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                                  WHERE q_1."Type" ~~ '%multy%'::text) ra_m) ra_split
                  WHERE ra_split."AnswerId" <> ''::text) multy
             JOIN "Questions" q ON q."Id" = multy."QuestionId"
             LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = multy."AnswerId"
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ''::text AS "AnswerId",
            ra."AnswerValue" AS "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%multy%'::text AND ra."AnswerValue" <> ''::text) total_multy;


CREATE MATERIALIZED VIEW public."Respondents_Answers" AS 
 SELECT total."Id",
    total."RespondentId",
    strip_tags(total."QuestionText") AS "QuestionText",
    total."Points",
    total."Date",
    strip_tags(total."AnswerValue") AS "AnswerValue",
    total."AnswerId",
    total."UserOwnAnswer",
    total."QuestionId"
   FROM ( SELECT "RespondentAnswers_Single"."Id",
            "RespondentAnswers_Single"."RespondentId",
            "RespondentAnswers_Single"."QuestionText",
            "RespondentAnswers_Single"."Points",
            "RespondentAnswers_Single"."Date",
            "RespondentAnswers_Single"."AnswerValue",
            "RespondentAnswers_Single"."AnswerId",
            "RespondentAnswers_Single"."UserOwnAnswer",
            "RespondentAnswers_Single"."QuestionId"
           FROM "RespondentAnswers_Single"
        UNION
         SELECT "RespondentAnswers_Multy"."Id",
            "RespondentAnswers_Multy"."RespondentId",
            "RespondentAnswers_Multy"."QuestionText",
            "RespondentAnswers_Multy"."Points",
            "RespondentAnswers_Multy"."Date",
            "RespondentAnswers_Multy"."AnswerValue",
            "RespondentAnswers_Multy"."AnswerId",
            "RespondentAnswers_Multy"."UserOwnAnswer",
            "RespondentAnswers_Multy"."QuestionId"
           FROM "RespondentAnswers_Multy"
        UNION
         SELECT "RespondentAnswers_Dropdown"."Id",
            "RespondentAnswers_Dropdown"."RespondentId",
            "RespondentAnswers_Dropdown"."QuestionText",
            "RespondentAnswers_Dropdown"."Points",
            "RespondentAnswers_Dropdown"."Date",
            "RespondentAnswers_Dropdown"."AnswerValue",
            "RespondentAnswers_Dropdown"."AnswerId",
            "RespondentAnswers_Dropdown"."UserOwnAnswer",
            "RespondentAnswers_Dropdown"."QuestionId"
           FROM "RespondentAnswers_Dropdown"
        UNION
         SELECT "RespondentAnswers_Files"."Id",
            "RespondentAnswers_Files"."RespondentId",
            "RespondentAnswers_Files"."QuestionText",
            "RespondentAnswers_Files"."Points",
            "RespondentAnswers_Files"."Date",
            "RespondentAnswers_Files"."AnswerValue",
            "RespondentAnswers_Files"."AnswerId",
            "RespondentAnswers_Files"."UserOwnAnswer",
            "RespondentAnswers_Files"."QuestionId"
           FROM "RespondentAnswers_Files"
        UNION
         SELECT "RespondentAnswers_Inputs"."Id",
            "RespondentAnswers_Inputs"."RespondentId",
            "RespondentAnswers_Inputs"."QuestionText",
            "RespondentAnswers_Inputs"."Points",
            "RespondentAnswers_Inputs"."Date",
            "RespondentAnswers_Inputs"."AnswerValue",
            "RespondentAnswers_Inputs"."AnswerId",
            "RespondentAnswers_Inputs"."UserOwnAnswer",
            "RespondentAnswers_Inputs"."QuestionId"
           FROM "RespondentAnswers_Inputs") total
  ORDER BY total."RespondentId", total."AnswerValue";

CREATE MATERIALIZED VIEW public."Respondents_ExtendedAnswers" AS 
 SELECT total."Id",
    total."RecordId",
    total."RecordName",
    total."RespondentId",
    total."Date",
    total."AnswerValue",
    strip_tags(total."ParentQuestionText") AS "ParentQuestionText",
    total."ParentQuestionId",
    strip_tags(total."QuestionText") AS "QuestionText",
    total."QuestionId"
   FROM ( SELECT "RespondentExtendedAnswers_Inputs"."Id",
            "RespondentExtendedAnswers_Inputs"."RecordId",
            "RespondentExtendedAnswers_Inputs"."RecordName",
            "RespondentExtendedAnswers_Inputs"."RespondentId",
            "RespondentExtendedAnswers_Inputs"."Date",
            "RespondentExtendedAnswers_Inputs"."AnswerValue",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionText",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionId",
            "RespondentExtendedAnswers_Inputs"."QuestionText",
            "RespondentExtendedAnswers_Inputs"."QuestionId"
           FROM "RespondentExtendedAnswers_Inputs"
        UNION
         SELECT "RespondentExtendedAnswers_Files"."Id",
            "RespondentExtendedAnswers_Files"."RecordId",
            "RespondentExtendedAnswers_Files"."RecordName",
            "RespondentExtendedAnswers_Files"."RespondentId",
            "RespondentExtendedAnswers_Files"."Date",
            "RespondentExtendedAnswers_Files"."AnswerValue",
            "RespondentExtendedAnswers_Files"."ParentQuestionText",
            "RespondentExtendedAnswers_Files"."ParentQuestionId",
            "RespondentExtendedAnswers_Files"."QuestionText",
            "RespondentExtendedAnswers_Files"."QuestionId"
           FROM "RespondentExtendedAnswers_Files"
        UNION
         SELECT "RespondentExtendedAnswers_Multy"."Id",
            "RespondentExtendedAnswers_Multy"."RecordId",
            "RespondentExtendedAnswers_Multy"."RecordName",
            "RespondentExtendedAnswers_Multy"."RespondentId",
            "RespondentExtendedAnswers_Multy"."Date",
            "RespondentExtendedAnswers_Multy"."AnswerValue",
            "RespondentExtendedAnswers_Multy"."ParentQuestionText",
            "RespondentExtendedAnswers_Multy"."ParentQuestionId",
            "RespondentExtendedAnswers_Multy"."QuestionText",
            "RespondentExtendedAnswers_Multy"."QuestionId"
           FROM "RespondentExtendedAnswers_Multy"
        UNION
         SELECT "RespondentExtendedAnswers_Single"."Id",
            "RespondentExtendedAnswers_Single"."RecordId",
            "RespondentExtendedAnswers_Single"."RecordName",
            "RespondentExtendedAnswers_Single"."RespondentId",
            "RespondentExtendedAnswers_Single"."Date",
            "RespondentExtendedAnswers_Single"."AnswerValue",
            "RespondentExtendedAnswers_Single"."ParentQuestionText",
            "RespondentExtendedAnswers_Single"."ParentQuestionId",
            "RespondentExtendedAnswers_Single"."QuestionText",
            "RespondentExtendedAnswers_Single"."QuestionId"
           FROM "RespondentExtendedAnswers_Single") total
  ORDER BY total."RespondentId", total."RecordId", total."AnswerValue";
CREATE MATERIALIZED VIEW public."RespondentAnswers_Match" AS 
 SELECT match."Id",
    match."RespondentId",
    q."Text" AS "QuestionText",
    match."Points",
    match."Date",
    ao1."TextA" AS "LeftSide",
    ao2."TextB" AS "RightSide",
    q."Id" AS "QuestionId"
   FROM ( SELECT ra_split."Id",
            ra_split."RespondentId",
            ra_split."QuestionId",
            ra_split."Points",
            ra_split."Date",
            split_part(ra_split."AnswerId", '='::text, 1) AS "LeftPart",
            split_part(ra_split."AnswerId", '='::text, 2) AS "RigthPart"
           FROM ( SELECT ra."Id",
                    ra."RespondentId",
                    ra."QuestionId",
                    ra."Points",
                    ra."Date",
                    unnest(string_to_array(ra."AnswerId", ';'::text)) AS "AnswerId"
                   FROM "RespondentAnswers" ra
                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                  WHERE q_1."Type" ~~ '%table%'::text) ra_split
          WHERE ra_split."AnswerId" <> ''::text) match
     JOIN "AnswerOptions" ao1 ON ao1."Id"::text = match."LeftPart"
     JOIN "AnswerOptions" ao2 ON ao2."PublicBId" = match."RigthPart"
     JOIN "Questions" q ON q."Id" = match."QuestionId";

CREATE MATERIALIZED VIEW public."RespondentMatrixAnswersView" AS 
 SELECT rma."Id",
    rma."QuestionId"::text AS "QuestionId",
    rma."ExtendedQuestionId"::text AS "ExtendedQuestionId",
    rma."AnswerOptionId"::text AS "AnswerOptionId",
    rma."RespondentId",
    rma."Date",
    strip_tags(q."Text") AS "ParentQuestionText",
    eq."Text" AS "QuestionText",
    ao."Text" AS "AnswerText"
   FROM "RespondentMatrixAnswers" rma
     JOIN "Questions" q ON rma."QuestionId" = q."Id"
     JOIN "ExtendedQuestions" eq ON rma."ExtendedQuestionId" = eq."Id"
     JOIN "AnswerOptions" ao ON rma."AnswerOptionId" = ao."Id";