-- View: public."RespondentAnswers_Files"

-- DROP VIEW public."RespondentAnswers_Files";

CREATE OR REPLACE VIEW public."RespondentAnswers_Files"
 AS
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    '/answerfiles/'||ra."AnswerValue" as "AnswerValue",
    ra."AnswerId",
    ''::text AS "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" ~~ '%file%'::text;