DROP VIEW public."Respondents_Answers";
DROP VIEW public."RespondentAnswers_Single";
DROP VIEW public."RespondentAnswers_Multy";
DROP VIEW public."RespondentAnswers_Inputs";
DROP VIEW public."RespondentAnswers_Files";
DROP VIEW public."RespondentAnswers_Dropdown";

CREATE OR REPLACE VIEW public."RespondentAnswers_Dropdown" AS 
SELECT total_drop."Id",
    total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    total_drop."Date",
    total_drop."AnswerValue",
    total_drop."AnswerId",
    total_drop."UserOwnAnswer",
    total_drop."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%dropdown%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."AnswerValue" as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%dropdown%'::text AND ra."AnswerValue" <> ''::text) total_drop
  ORDER BY total_drop."RespondentId", total_drop."AnswerValue";

  CREATE OR REPLACE VIEW public."RespondentAnswers_Files" AS 
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    ra."AnswerValue",
    ra."AnswerId",
    ''::text as "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" ~~ '%file%'::text;

  CREATE OR REPLACE VIEW public."RespondentAnswers_Inputs" AS 
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    concat_ws(';'::text, ra."AnswerId", ra."AnswerValue") AS "AnswerValue",
    ra."AnswerId",
    ''::text as "UserOwnAnswer",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" !~~ '%single%'::text AND q."Type" !~~ '%file%'::text AND q."Type" !~~ '%multy%'::text AND q."Type" !~~ '%table%'::text AND q."Type" !~~ '%dropdown%'::text AND q."Type" !~~ '%extended%'::text;

  CREATE OR REPLACE VIEW public."RespondentAnswers_Multy" AS 
 SELECT total_multy."Id",
    total_multy."RespondentId",
    total_multy."QuestionText",
    total_multy."Points",
    total_multy."Date",
    total_multy."AnswerValue",
    total_multy."AnswerId",
    total_multy."UserOwnAnswer",
    total_multy."QuestionId"
   FROM ( SELECT multy."Id",
            multy."RespondentId",
            q."Text" AS "QuestionText",
            multy."Points",
            multy."Date",
            ao."Text" AS "AnswerValue",
            multy."AnswerId",
            ''::text as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM ( SELECT ra_split."Id",
                    ra_split."RespondentId",
                    ra_split."QuestionId",
                    ra_split."Points",
                    ra_split."Date",
                    ra_split."AnswerId",
                    ra_split."AnswerValue"
                   FROM ( SELECT ra_m."Id",
                            ra_m."RespondentId",
                            ra_m."QuestionId",
                            ra_m."Points",
                            ra_m."Date",
                            unnest(string_to_array(ra_m."AnswerId", ','::text)) AS "AnswerId",
                            ra_m."AnswerValue"
                           FROM ( SELECT ra."Id",
                                    ra."RespondentId",
                                    ra."QuestionId",
                                    ra."Points",
                                    ra."Date",
                                    ra."AnswerId",
                                    ra."AnswerValue"
                                   FROM "RespondentAnswers" ra
                                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                                  WHERE q_1."Type" ~~ '%multy%'::text) ra_m) ra_split
                  WHERE ra_split."AnswerId" <> ''::text) multy
             JOIN "Questions" q ON q."Id" = multy."QuestionId"
             LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = multy."AnswerId"
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ''::text as "AnswerId",
            ra."AnswerValue" as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%multy%'::text AND ra."AnswerValue" <> ''::text) total_multy
  ORDER BY total_multy."RespondentId", total_multy."AnswerValue";

  CREATE OR REPLACE VIEW public."RespondentAnswers_Single" AS 
 SELECT total_single."Id",
    total_single."RespondentId",
    strip_tags(total_single."QuestionText") AS "QuestionText",
    total_single."Points",
    total_single."Date",
    strip_tags(total_single."AnswerValue") AS "AnswerValue",
    total_single."AnswerId",
    total_single."UserOwnAnswer",
    total_single."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            ra."AnswerId",
            ''::text as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%single%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            ra."AnswerId",
            ra."AnswerValue" as "UserOwnAnswer",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text) total_single
  ORDER BY total_single."RespondentId", total_single."AnswerValue";

  CREATE OR REPLACE VIEW public."Respondents_Answers" AS 
 SELECT total."Id",
    total."RespondentId",
    total."QuestionText",
    total."Points",
    total."Date",
    total."AnswerValue",
    total."AnswerId",
    total."UserOwnAnswer",
    total."QuestionId"
   FROM ( SELECT "RespondentAnswers_Single"."Id",
            "RespondentAnswers_Single"."RespondentId",
            "RespondentAnswers_Single"."QuestionText",
            "RespondentAnswers_Single"."Points",
            "RespondentAnswers_Single"."Date",
            "RespondentAnswers_Single"."AnswerValue",
            "RespondentAnswers_Single"."AnswerId",
            "RespondentAnswers_Single"."UserOwnAnswer",
            "RespondentAnswers_Single"."QuestionId"
           FROM "RespondentAnswers_Single"
        UNION
         SELECT "RespondentAnswers_Multy"."Id",
            "RespondentAnswers_Multy"."RespondentId",
            "RespondentAnswers_Multy"."QuestionText",
            "RespondentAnswers_Multy"."Points",
            "RespondentAnswers_Multy"."Date",
            "RespondentAnswers_Multy"."AnswerValue",
            "RespondentAnswers_Multy"."AnswerId",
            "RespondentAnswers_Multy"."UserOwnAnswer",
            "RespondentAnswers_Multy"."QuestionId"
           FROM "RespondentAnswers_Multy"
        UNION
         SELECT "RespondentAnswers_Dropdown"."Id",
            "RespondentAnswers_Dropdown"."RespondentId",
            "RespondentAnswers_Dropdown"."QuestionText",
            "RespondentAnswers_Dropdown"."Points",
            "RespondentAnswers_Dropdown"."Date",
            "RespondentAnswers_Dropdown"."AnswerValue",
            "RespondentAnswers_Dropdown"."AnswerId",
            "RespondentAnswers_Dropdown"."UserOwnAnswer",
            "RespondentAnswers_Dropdown"."QuestionId"
           FROM "RespondentAnswers_Dropdown"
        UNION
         SELECT "RespondentAnswers_Files"."Id",
            "RespondentAnswers_Files"."RespondentId",
            "RespondentAnswers_Files"."QuestionText",
            "RespondentAnswers_Files"."Points",
            "RespondentAnswers_Files"."Date",
            "RespondentAnswers_Files"."AnswerValue",
            "RespondentAnswers_Files"."AnswerId",
            "RespondentAnswers_Files"."UserOwnAnswer",
            "RespondentAnswers_Files"."QuestionId"
           FROM "RespondentAnswers_Files"
        UNION
         SELECT "RespondentAnswers_Inputs"."Id",
            "RespondentAnswers_Inputs"."RespondentId",
            "RespondentAnswers_Inputs"."QuestionText",
            "RespondentAnswers_Inputs"."Points",
            "RespondentAnswers_Inputs"."Date",
            "RespondentAnswers_Inputs"."AnswerValue",
            "RespondentAnswers_Inputs"."AnswerId",
            "RespondentAnswers_Inputs"."UserOwnAnswer",
            "RespondentAnswers_Inputs"."QuestionId"
           FROM "RespondentAnswers_Inputs") total
  ORDER BY total."RespondentId", total."AnswerValue";