﻿
drop MATERIALIZED VIEW public."RespondentMatrixAnswersView";

CREATE MATERIALIZED VIEW public."RespondentMatrixAnswersView" AS 
 SELECT rma."Id",
    rma."QuestionId"::text AS "QuestionId",
    rma."ExtendedQuestionId"::text AS "ExtendedQuestionId",
    rma."AnswerOptionId"::text AS "AnswerOptionId",
    rma."RespondentId",
    rma."Date",
    strip_tags(q."Text") AS "ParentQuestionText",
    strip_tags(eq."Text") AS "QuestionText",
    strip_tags(ao."Text") AS "AnswerText"
   FROM "RespondentMatrixAnswers" rma
     JOIN "Questions" q ON rma."QuestionId" = q."Id"
     JOIN "ExtendedQuestions" eq ON rma."ExtendedQuestionId" = eq."Id"
     JOIN "AnswerOptions" ao ON rma."AnswerOptionId" = ao."Id";

