﻿
CREATE OR REPLACE FUNCTION public.accessrights_getaccessrightsbyuser(
    IN itemid uuid,
    IN userid uuid)
  RETURNS TABLE("Id" integer, "ObjectId" uuid, "ObjectType" text, "UserId" uuid, "CanRead" boolean, "CanUpdate" boolean, "CanDelete" boolean, "UserName" text) AS
$BODY$
SELECT ar."Id", ar."ObjectId", ar."ObjectType", ar."UserId", ar."CanRead", ar."CanUpdate", 
       ar."CanDelete", u2."UserName"
FROM public."AccessRights" ar
LEFT JOIN public."AspNetUserRoles" ur on ur."UserId"::uuid=userid and ur."RoleId"::uuid=ar."RoleId"
LEFT JOIN public."AspNetRoles" roles on roles."Id"=ur."RoleId"
LEFT JOIN public."AspNetRoles" roles2 on roles2."Id"=ar."RoleId"::text
LEFT JOIN public."AspNetUsers" u2 on u2."Id"=ur."UserId"

WHERE ar."ObjectId" = itemid AND
(
    (ar."RoleId" = '00000000-0000-0000-0000-000000000000' AND ar."UserId"=userid/*доступ по юзеру к отчету из папки*/ )
    OR
    ( userid = '00000000-0000-0000-0000-000000000000' and roles2."NormalizedName"='UNAUTHORIZEDUSERS')
    OR
    (roles."Id"::text=ar."RoleId"::text)
    OR
    (
        roles."NormalizedName"='REGISTEREDUSERS' and
        userid<>'00000000-0000-0000-0000-000000000000' and
        u2."IsEnabled" = true and
        u2."EmailConfirmed" = true
    )/*если выбрано зарегистированные пользователи*/
 )
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;
