﻿SET datestyle TO 'ISO, DMY';
CREATE EXTENSION IF NOT EXISTS tablefunc;
 -------------------------------------------------------------------------------------------------------------
 ------------------------------------------FUNCTIONS----------------------------------------------------------
 -------------------------------------------------------------------------------------------------------------
 -- Function: public.accessrights_getaccessrights(uuid)
 DROP FUNCTION IF EXISTS public.accessrights_getaccessrights(uuid);

CREATE OR REPLACE FUNCTION public.accessrights_getaccessrights(IN itemid uuid)
  RETURNS TABLE("Id" integer, "ObjectId" uuid, "ObjectType" text, "UserId" uuid, "RoleId" uuid, "CanRead" boolean, "CanUpdate" boolean, "CanDelete" boolean, "UserName" text, "RoleName" text) AS
$BODY$
SELECT ar."Id", ar."ObjectId", ar."ObjectType", ar."UserId",ar."RoleId", ar."CanRead", ar."CanUpdate", 
ar."CanDelete", u."UserName", r."Name"
FROM public."AccessRights" ar

LEFT JOIN public."AspNetUsers" u ON u."Id"::uuid = ar."UserId"
LEFT JOIN public."AspNetRoles" r ON r."Id"::uuid=ar."RoleId"


WHERE ar."ObjectId" = itemid
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;



 --DROP FUNCTION IF EXISTS  public.accessrights_getaccessrightsbyuser(uuid, uuid);

CREATE OR REPLACE FUNCTION public.accessrights_getaccessrightsbyuser(
    IN itemid uuid,
    IN userid uuid)
  RETURNS TABLE("Id" integer, "ObjectId" uuid, "ObjectType" text, "UserId" uuid, "CanRead" boolean, "CanUpdate" boolean, "CanDelete" boolean, "UserName" text) AS
$BODY$
SELECT ar."Id", ar."ObjectId", ar."ObjectType", ar."UserId", ar."CanRead", ar."CanUpdate", 
       ar."CanDelete", u2."UserName"
FROM public."AccessRights" ar
LEFT JOIN public."AspNetUserRoles" ur on ur."UserId"::uuid=userid and ur."RoleId"::uuid=ar."RoleId"
LEFT JOIN public."AspNetRoles" roles on roles."Id"=ur."RoleId"
LEFT JOIN public."AspNetRoles" roles2 on roles2."Id"=ar."RoleId"::text
LEFT JOIN public."AspNetUsers" u2 on u2."Id"=ur."UserId"

WHERE ar."ObjectId" = itemid AND
(
    (ar."RoleId" = '00000000-0000-0000-0000-000000000000' AND ar."UserId"=userid/*доступ по юзеру к отчету из папки*/ )
    OR
    ( userid = '00000000-0000-0000-0000-000000000000' and roles2."NormalizedName"='UNAUTHORIZEDUSERS')
    OR
    (roles."Id"::text=ar."RoleId"::text)
    OR
    (
        roles."NormalizedName"='REGISTEREDUSERS' and
        userid<>'00000000-0000-0000-0000-000000000000' and
        u2."IsEnabled" = true and
        u2."EmailConfirmed" = true
    )/*если выбрано зарегистированные пользователи*/
 )
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;


  
  
  -- Function: public.accessrights_getgrouppedaccessrightsbyuser(uuid, uuid)

 DROP FUNCTION IF EXISTS  public.accessrights_getgrouppedaccessrightsbyuser(uuid, uuid);

CREATE OR REPLACE FUNCTION public.accessrights_getgrouppedaccessrightsbyuser(
    IN itemid uuid,
    IN userid uuid)
  RETURNS TABLE("CanRead" boolean, "CanUpdate" boolean, "CanDelete" boolean) AS
$BODY$
SELECT  bool_or(ar."CanRead" = true), bool_or(ar."CanUpdate" = true),bool_or( ar."CanDelete" = true)
FROM public."AccessRights" ar
LEFT JOIN public."AspNetUsers" u ON u."Id"::uuid = ar."UserId" and ar."UserId"::uuid=userid
LEFT JOIN public."AspNetUserRoles" ur on ur."UserId"::uuid=userid and ur."RoleId"::uuid=ar."RoleId"
LEFT JOIN public."AspNetRoles" roles on roles."Id"::uuid=ar."RoleId"
LEFT JOIN public."AspNetUsers" u2 on u2."Id"=ur."UserId"

WHERE ar."ObjectId" = itemid AND (
(ar."RoleId" = '00000000-0000-0000-0000-000000000000' AND ar."UserId"=$2 /*доступ по юзеру к отчету из папки*/ )
OR
(roles."NormalizedName"='UNAUTHORIZEDUSERS' )
 OR (roles."NormalizedName"='REGISTEREDUSERS' and userid<>'00000000-0000-0000-0000-000000000000' and u2."IsEnabled" = true and u2."EmailConfirmed" = true)/*если выбрано зарегистированные пользователи*/
 )

  --group by  ar."CanRead", ar."CanUpdate", ar."CanDelete"
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;


  
  
  
  -- Function: public.folders_getfoldersbyuser(uuid, uuid)

 DROP FUNCTION IF EXISTS  public.folders_getfoldersbyuser(uuid, uuid);

CREATE OR REPLACE FUNCTION public.folders_getfoldersbyuser(
    IN userid uuid,
    IN questionnaireid uuid)
  RETURNS TABLE("Id" uuid, "Name" text, "Description" text, "UserId" uuid, "ParentId" uuid, "CreationDate" timestamp with time zone, "UpdateDate" timestamp with time zone, "HasChilds" boolean, "QuestionnaireId" uuid, "UserName" text, "LastModifiedByUserName" text) AS
$BODY$
 SELECT DISTINCT f."Id", f."Name", f."Description", f."UserId", f."ParentId", 
 f."CreationDate"::timestamp with time zone, f."UpdateDate"::timestamp with time zone,

CASE WHEN count(qa."UserId")>0 --если автор
	THEN CASE count(r."Id") WHEN 0 THEN false ELSE true END -- смотрим количество отчетов в папке
     ELSE  CASE count(ar2."Id") WHEN 0 THEN false ELSE true END
  END,
  f."QuestionnaireId", u."UserName", u2."UserName"
  
	FROM public."Folders" as f
	join public."QuestionnaireAuthors" qa on qa."QuestionnaireId"=$2 AND qa."AccessLevel"<=1 /*автор и полный соавтор*/
	LEFT JOIN public."AspNetUsers" u ON u."Id"::uuid =  f."UserId"
	LEFT JOIN public."AspNetUsers" u2 ON u2."Id"::uuid =  f."LastModifiedByUserId"
	LEFT JOIN public."Reports" as r ON r."FolderId" = f."Id" 
	LEFT JOIN public."AccessRights" ar2 ON ar2."ObjectId"= r."Id" --AND ar2."ObjectType"='Report' --and (f."UserId"=$1 OR (ar2."CanRead" = true and ar2."UserId"=$1))
	LEFT JOIN public."AspNetUserRoles" rur ON rur."UserId"::uuid=$1 and rur."RoleId"::uuid = ar2."RoleId"
	LEFT JOIN public."AspNetRoles" roles on roles."Id"::uuid=ar2."RoleId"
	
	
	
	WHERE f."QuestionnaireId"=$2 
and  (f."UserId"=$1/*хозяин папки*/ 

OR qa."UserId"::uuid = $1/*есил автор или соавтор с полным доступом*/

	OR (ar2."UserId"=$1 AND ar2."RoleId"='00000000-0000-0000-0000-000000000000')/*доступ по юзеру к отчету из папки*/ 

	OR (rur."RoleId"::uuid= ar2."RoleId" AND ar2."UserId"='00000000-0000-0000-0000-000000000000')/*доступ по роли к отчету из папки*/

	OR (roles."NormalizedName"='UNAUTHORIZEDUSERS')/*если выбрано Все пользователи*/
	OR (roles."NormalizedName"='REGISTEREDUSERS'  and $1<>'00000000-0000-0000-0000-000000000000' and u."IsEnabled" = true and u."EmailConfirmed" = true)/*если выбрано зарегистрированные пользователи*/
)
	GROUP BY f."Id", f."Name", f."Description", f."UserId", f."ParentId", f."CreationDate", f."UpdateDate",u."UserName",u2."UserName"
	ORDER BY f."Name"
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;


  
  
  -- Function: public.reports_getreportsbyuser(uuid, uuid)

 DROP FUNCTION IF EXISTS  public.reports_getreportsbyuser(uuid, uuid);

CREATE OR REPLACE FUNCTION public.reports_getreportsbyuser(
    IN userid uuid,
    IN questionnaireid uuid)
  RETURNS TABLE("Id" uuid, "Name" text, "Description" text, "UserId" uuid, "ParentId" uuid, "CreationDate" timestamp with time zone, "UpdateDate" timestamp with time zone, "UserName" text) AS
$BODY$
 SELECT DISTINCT r."Id", r."Name", r."Description", r."UserId", r."FolderId", r."CreationDate"::timestamp with time zone, r."UpdateDate"::timestamp with time zone,-- CASE count(r."Id") WHEN 0 THEN false ELSE true END  as HasChilds
 u2."UserName"
  
	FROM public."Folders" as f
	join public."QuestionnaireAuthors" qa on qa."QuestionnaireId"=$2 AND qa."AccessLevel"<=1 /*автор и полный соавтор*/
	JOIN public."AspNetUsers" u ON u."Id"::uuid =  f."UserId"
	
	JOIN public."Reports" as r ON r."FolderId" = f."Id" 
	LEFT JOIN public."AccessRights" ar2 ON ar2."ObjectId"= r."Id" --AND ar2."ObjectType"='Report' --and (f."UserId"=$1 OR (ar2."CanRead" = true and ar2."UserId"=$1))
	LEFT JOIN public."AspNetUserRoles" rur ON rur."UserId"::uuid=$1 and rur."RoleId"::uuid = ar2."RoleId"
	LEFT JOIN public."AspNetRoles" roles on roles."Id"::uuid=ar2."RoleId"
	LEFT JOIN public."AspNetUsers" u2 ON u2."Id"::uuid =  r."UserId"
	
	
	
	WHERE f."QuestionnaireId"=$2 
and  (f."UserId"=$1/*хозяин папки*/ 

OR qa."UserId"::uuid = $1/*есил автор или соавтор с полным доступом*/

	OR (ar2."UserId"=$1 AND ar2."RoleId"='00000000-0000-0000-0000-000000000000')/*доступ по юзеру к отчету из папки*/ 

	OR (rur."RoleId"::uuid= ar2."RoleId" AND ar2."UserId"='00000000-0000-0000-0000-000000000000')/*доступ по роли к отчету из папки*/

	OR (roles."NormalizedName"='UNAUTHORIZEDUSERS')/*если выбрано Все пользователи*/
	OR (roles."NormalizedName"='REGISTEREDUSERS' and userid<>'00000000-0000-0000-0000-000000000000' and u."IsEnabled" = true and u."EmailConfirmed" = true )/*если выбрано зарегистрированные пользователи*/
)
	GROUP BY r."Id", r."Name", r."Description", r."UserId", r."FolderId", r."CreationDate", r."UpdateDate",u2."UserName"
	ORDER BY r."Name"
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;


  
  
  
  
  -- Function: public.reports_getreportsbyuserandfolder(uuid, uuid, uuid)

 DROP FUNCTION IF EXISTS public.reports_getreportsbyuserandfolder(uuid, uuid, uuid);

CREATE OR REPLACE FUNCTION public.reports_getreportsbyuserandfolder(
    IN userid uuid,
    IN questionnaireid uuid,
    IN folderid uuid)
  RETURNS TABLE("Id" uuid, "Name" text, "Description" text, "UserId" uuid, "LastModifiedByUserId" uuid, "ParentId" uuid, "CreationDate" timestamp with time zone, "UpdateDate" timestamp with time zone, "UserName" text, "LastModifiedByUserName" text, "ViewsCount" integer) AS
$BODY$
 SELECT DISTINCT r."Id", r."Name", r."Description", r."UserId", r."LastModifiedByUserId", r."FolderId", r."CreationDate"::timestamp with time zone, r."UpdateDate"::timestamp with time zone,-- CASE count(r."Id") WHEN 0 THEN false ELSE true END  as HasChilds
 u."UserName", u2."UserName", r."ViewsCount"
  
	FROM public."Folders" as f
	join public."QuestionnaireAuthors" qa on qa."QuestionnaireId"=$2 AND qa."AccessLevel"<=1 /*автор и полный соавтор*/

	
	JOIN public."Reports" as r ON r."FolderId" = f."Id" AND f."Id" = $3
	LEFT JOIN public."AccessRights" ar2 ON ar2."ObjectId"= r."Id" --AND ar2."ObjectType"='Report' --and (f."UserId"=$1 OR (ar2."CanRead" = true and ar2."UserId"=$1))
	LEFT JOIN public."AspNetUserRoles" rur ON rur."UserId"::uuid=$1 and rur."RoleId"::uuid = ar2."RoleId"
	LEFT JOIN public."AspNetRoles" roles on roles."Id"::uuid=ar2."RoleId"
	LEFT JOIN public."AspNetUsers" u ON u."Id"::uuid =  r."UserId"
	LEFT JOIN public."AspNetUsers" u2 ON u2."Id"::uuid =  r."LastModifiedByUserId"
	
	
	WHERE  f."QuestionnaireId"=$2 
and  (f."UserId"=$1/*хозяин папки*/ 

OR qa."UserId"::uuid = $1/*есил автор или соавтор с полным доступом*/

	OR (ar2."UserId"=$1 AND ar2."RoleId"='00000000-0000-0000-0000-000000000000')/*доступ по юзеру к отчету из папки*/ 

	OR (rur."RoleId"::uuid= ar2."RoleId" AND ar2."UserId"='00000000-0000-0000-0000-000000000000')/*доступ по роли к отчету из папки*/

	OR (roles."NormalizedName"='UNAUTHORIZEDUSERS')/*если выбрано Все пользователи*/
	OR (roles."NormalizedName"='REGISTEREDUSERS' and $1<>'00000000-0000-0000-0000-000000000000' and u."IsEnabled" = true and u."EmailConfirmed" = true )/*если выбрано зарегистированные пользователи*/
)
	GROUP BY r."Id", r."Name", r."Description", r."UserId",r."LastModifiedByUserId", r."FolderId", r."CreationDate", r."UpdateDate",u."UserName", u2."UserName",r."ViewsCount"
	ORDER BY r."Name"
$BODY$
  LANGUAGE sql VOLATILE
  COST 100
  ROWS 1000;


 -------------------------------------------------------------------------------------------------------------
 ------------------------------------------VIEWS--------------------------------------------------------------
 -------------------------------------------------------------------------------------------------------------

-- View: public."RespondentAnswersView"

-- DROP VIEW public."RespondentAnswersView";

CREATE OR REPLACE VIEW public."RespondentAnswersView" AS 
select * from  (SELECT ra."Id",
    ra."AnswerValue",
    ''::text AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM "RespondentAnswers" ra
  WHERE ra."AnswerValue" <> ''::text
UNION ALL
 SELECT ra."Id",
    ra."AnswerValue",
    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM ( SELECT ra_1."Id",
            ''::text AS "AnswerValue",
            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
            ra_1."Points",
            ra_1."QuestionId",
            ra_1."RespondentId",
            ra_1."Date",
            row_number() OVER (ORDER BY ra_1."Id") AS rownumber
           FROM "RespondentAnswers" ra_1
          WHERE ra_1."AnswerId" <> ''::text) ra) ra1
where ra1."AnswerId" <>'' or ra1."AnswerValue"<>'';


-- View: public."RespondentAnswersTableQuestionView"

-- DROP VIEW public."RespondentAnswersTableQuestionView";

CREATE OR REPLACE VIEW public."RespondentAnswersTableQuestionView" AS 
 SELECT ra."Id",
    ''::text AS "AnswerValue",
    unnest(string_to_array(ra."AnswerId", '='::text)) AS "AnswerId",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    row_number() OVER (ORDER BY ra."Id") AS rownumber
   FROM ( SELECT ra_1."Id",
            ''::text AS "AnswerValue",
            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
            ra_1."Points",
            ra_1."QuestionId",
            ra_1."RespondentId",
            ra_1."Date",
            row_number() OVER (ORDER BY ra_1."Id") AS rownumber
           FROM ( SELECT ra_2."Id",
                    ra_2."AnswerId",
                    ''::text AS "AnswerValue",
                    ra_2."Points",
                    ra_2."QuestionId",
                    ra_2."RespondentId",
                    ra_2."Date",
                    row_number() OVER (ORDER BY ra_2."Id") AS rownumber
                   FROM "RespondentAnswers" ra_2
                  WHERE ra_2."AnswerId" ~~ '%;%'::text) ra_1
          WHERE ra_1."AnswerId" <> ''::text) ra;



-- View: public."RespondentExtendedAnswersView"

-- DROP VIEW public."RespondentExtendedAnswersView";

CREATE OR REPLACE VIEW public."RespondentExtendedAnswersView" AS 
 SELECT rea."Id",
    unnest(string_to_array(rea."AnswerId", ','::text)) AS "AnswerId",
    rea."AnswerValue",
    rea."Date",
    rea."ExtendedQuestionId",
    rer."RespondentId",
    rer."Id" AS "RecordId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rer."Id" = rea."RecordId"
  WHERE rea."AnswerValue" IS NULL
UNION ALL
 SELECT rea."Id",
    rea."AnswerId",
    rea."AnswerValue",
    rea."Date",
    rea."ExtendedQuestionId",
    rer."RespondentId",
    rer."Id" AS "RecordId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rer."Id" = rea."RecordId"
  WHERE rea."AnswerValue" IS NOT NULL;

-- View: public."RespondentAnswersViewStimulsoft"

-- DROP VIEW public."RespondentAnswersViewStimulsoft";

CREATE OR REPLACE VIEW public."RespondentAnswersViewStimulsoft" AS 
 SELECT "RespondentAnswersView"."Id",
    "RespondentAnswersView"."AnswerValue",
    "RespondentAnswersView"."AnswerId",
    "RespondentAnswersView"."Points",
    "RespondentAnswersView"."QuestionId",
    "RespondentAnswersView"."RespondentId",
    "RespondentAnswersView"."Date",
    "RespondentAnswersView".rownumber
   FROM "RespondentAnswersView"
UNION
 SELECT "RespondentAnswersTableQuestionView"."Id",
    "RespondentAnswersTableQuestionView"."AnswerValue",
    "RespondentAnswersTableQuestionView"."AnswerId",
    "RespondentAnswersTableQuestionView"."Points",
    "RespondentAnswersTableQuestionView"."QuestionId",
    "RespondentAnswersTableQuestionView"."RespondentId",
    "RespondentAnswersTableQuestionView"."Date",
    "RespondentAnswersTableQuestionView".rownumber
   FROM "RespondentAnswersTableQuestionView"
UNION
 SELECT "RespondentExtendedAnswersView"."Id",
    "RespondentExtendedAnswersView"."AnswerId" AS "AnswerValue",
    "RespondentExtendedAnswersView"."AnswerValue" AS "AnswerId",
    0 AS "Points",
    "RespondentExtendedAnswersView"."ExtendedQuestionId" AS "QuestionId",
    "RespondentExtendedAnswersView"."RespondentId",
    "RespondentExtendedAnswersView"."Date",
    0 AS rownumber
   FROM "RespondentExtendedAnswersView";


-- View: public."RespondentAnswersReview_Multy"

-- DROP VIEW public."RespondentAnswersReview_Multy";

CREATE OR REPLACE VIEW public."RespondentAnswersReview_Multy" AS 
 SELECT aom."QuestionId" AS "Id",
    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
    aom."Points",
    aom."QuestionId",
    aom."RespondentId",
    aom."Date",
    aom."ExpertComment",
    aom."QuestionText",
    aom."QuestionnaireId",
    aom."QuestionId"::text AS "Unique"
   FROM ( SELECT respanswers."Id",
            respanswers."AnswerId",
            ao."Text" AS "AnswerValue",
            respanswers."Points",
            respanswers."QuestionId",
            respanswers."RespondentId",
            respanswers."Date",
            respanswers.rownumber,
            ao."Message" AS "ExpertComment",
            respanswers."QuestionText",
            respanswers."QuestionnaireId"
           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                    ra."AnswerValue",
                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                    ra."Points",
                    ra."QuestionId",
                    ra."RespondentId",
                    ra."Date",
                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                    ra."ExpertComment",
                    ra."Text" AS "QuestionText",
                    ra."QuestionnaireId"
                   FROM ( SELECT ra_1."Id",
                            ''::text AS "AnswerValue",
                            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                            ra_1."Points",
                            ra_1."QuestionId",
                            ra_1."RespondentId",
                            ra_1."Date",
                            row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                            '' AS "ExpertComment",
                            q."Text",
                            q."QuestionnaireId"
                           FROM "RespondentAnswers" ra_1
                             JOIN "Questions" q ON q."Id" = ra_1."QuestionId"
                          WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
             JOIN "AnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId";


-- View: public."RespondentAnswersReview_Simple"

-- DROP VIEW public."RespondentAnswersReview_Simple";
CREATE OR REPLACE VIEW public."RespondentAnswersReview_Simple" AS 
 SELECT ra."QuestionId" AS "Id",
    ra."AnswerValue",
    ra."Points",
    ra."QuestionId",
    ra."RespondentId",
    ra."Date",
    '' AS "ExpertComment",
    q."Text" AS "QuestionText",
    q."QuestionnaireId",
    ra."QuestionId"::text AS "Unique"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE ra."AnswerValue" <> ''::text;


-- View: public."RespondentAnswersReview_Table"

-- DROP VIEW public."RespondentAnswersReview_Table";

CREATE OR REPLACE VIEW public."RespondentAnswersReview_Table" AS 
 SELECT aotr."QuestionId" AS "Id",
    string_agg(aotr."AnswerValue", '</br>'::text) AS "AnswerValue",
    aotr."Points",
    aotr."QuestionId",
    aotr."RespondentId",
    aotr."Date",
    aotr."ExpertComment",
    aotr."QuestionText",
    aotr."QuestionnaireId",
    aotr."QuestionId"::text AS "Unique"
   FROM ( SELECT aot."Id",
            string_agg(aot."AnswerValue", ' - '::text) AS "AnswerValue",
            aot."Points",
            aot."QuestionId",
            aot."RespondentId",
            aot."Date",
            aot.rownumber,
            aot."ExpertComment",
            aot."QuestionText",
            aot."QuestionnaireId"
           FROM ( SELECT tablesanswers."Id",
                    tablesanswers."AnswerId",
                        CASE
                            WHEN ao."TextA" IS NULL THEN ao2."TextB"
                            ELSE ao."TextA"
                        END AS "AnswerValue",
                    tablesanswers."Points",
                    tablesanswers."QuestionId",
                    tablesanswers."RespondentId",
                    tablesanswers."Date",
                    tablesanswers.rownumber,
                        CASE
                            WHEN ao."Message" IS NULL THEN ao2."Message"
                            ELSE ao."Message"
                        END AS "ExpertComment",
                    tablesanswers."QuestionText",
                    tablesanswers."QuestionnaireId"
                   FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                            ra."AnswerValue",
                            unnest(string_to_array(ra."AnswerId", '='::text)) AS "AnswerId",
                            ra."Points",
                            ra."QuestionId",
                            ra."RespondentId",
                            ra."Date",
                            row_number() OVER (ORDER BY ra."Id") AS rownumber,
                            ra."ExpertComment",
                            ra."Text" AS "QuestionText",
                            ra."QuestionnaireId"
                           FROM ( SELECT ra_1."Id",
                                    ''::text AS "AnswerValue",
                                    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                                    ra_1."Points",
                                    ra_1."QuestionId",
                                    ra_1."RespondentId",
                                    ra_1."Date",
                                    row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                                    '' AS "ExpertComment",
                                    q."Text",
                                    q."QuestionnaireId"
                                   FROM "RespondentAnswers" ra_1
                                     JOIN "Questions" q ON q."Id" = ra_1."QuestionId"
                                  WHERE ra_1."AnswerId" <> ''::text AND ra_1."AnswerId" ~~ (('%'::text || '='::text) || '%'::text)) ra) tablesanswers
                     LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = tablesanswers."AnswerId"
                     LEFT JOIN "AnswerOptions" ao2 ON ao2."PublicBId" = tablesanswers."AnswerId") aot
          GROUP BY aot."Id", aot."Points", aot."QuestionId", aot."RespondentId", aot."Date", aot.rownumber, aot."ExpertComment", aot."QuestionText", aot."QuestionnaireId"
          ORDER BY aot.rownumber) aotr
  GROUP BY aotr."QuestionId", aotr."Points", aotr."RespondentId", aotr."Date", aotr."ExpertComment", aotr."QuestionText", aotr."QuestionnaireId";




    -- View: public."RespondentAnswersReviewStimulsoft"

-- DROP VIEW public."RespondentAnswersReviewStimulsoft";

CREATE OR REPLACE VIEW public."RespondentAnswersReviewStimulsoft" AS 
 SELECT "RespondentAnswersReview_Simple"."Id",
    "RespondentAnswersReview_Simple"."AnswerValue",
    "RespondentAnswersReview_Simple"."Points",
    "RespondentAnswersReview_Simple"."QuestionId",
    "RespondentAnswersReview_Simple"."RespondentId",
    "RespondentAnswersReview_Simple"."Date",
    "RespondentAnswersReview_Simple"."ExpertComment",
    "RespondentAnswersReview_Simple"."QuestionText",
    "RespondentAnswersReview_Simple"."QuestionnaireId"
   FROM "RespondentAnswersReview_Simple"
UNION ALL
 SELECT "RespondentAnswersReview_Multy"."Id",
    "RespondentAnswersReview_Multy"."AnswerValue",
    "RespondentAnswersReview_Multy"."Points",
    "RespondentAnswersReview_Multy"."QuestionId",
    "RespondentAnswersReview_Multy"."RespondentId",
    "RespondentAnswersReview_Multy"."Date",
    "RespondentAnswersReview_Multy"."ExpertComment",
    "RespondentAnswersReview_Multy"."QuestionText",
    "RespondentAnswersReview_Multy"."QuestionnaireId"
   FROM "RespondentAnswersReview_Multy"
UNION ALL
 SELECT "RespondentAnswersReview_Table"."Id",
    "RespondentAnswersReview_Table"."AnswerValue",
    "RespondentAnswersReview_Table"."Points",
    "RespondentAnswersReview_Table"."QuestionId",
    "RespondentAnswersReview_Table"."RespondentId",
    "RespondentAnswersReview_Table"."Date",
    "RespondentAnswersReview_Table"."ExpertComment",
    "RespondentAnswersReview_Table"."QuestionText",
    "RespondentAnswersReview_Table"."QuestionnaireId"
   FROM "RespondentAnswersReview_Table";



 -- View: public."RespondentAnswersReviewStimulsoftWithTable"
 
CREATE OR REPLACE VIEW public."RespondentAnswers_Matrix" AS 
 SELECT total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    array_to_string(array_agg(total_drop."AnswerValue"), '</br>'::text) AS "AnswerValue",
    total_drop."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            0 AS "Points",
            ra."Date",
            (eq."Text" || '-'::text) || ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentMatrixAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerOptionId"::text
             JOIN "ExtendedQuestions" eq ON eq."Id" = ra."ExtendedQuestionId"
          WHERE q."Type" ~~ '%matrix%'::text
          ORDER BY ra.*, ra."RespondentId", eq."OrderId") total_drop
  GROUP BY total_drop."RespondentId", total_drop."QuestionText", total_drop."Points", total_drop."QuestionId";

-- DROP VIEW public."RespondentAnswersReviewStimulsoftWithTable";

CREATE OR REPLACE VIEW public."RespondentAnswersReviewStimulsoftWithTable" AS 
 SELECT array_to_string(array_agg(agg."AnswerValue"), '</br>'::text) AS "AnswerValue",
    agg."RespondentId",
    agg."QuestionnaireId",
    agg."ParentQuestionId" AS "QuestionId"
   FROM ( SELECT array_to_string(array_agg((((('<div>'::text || ex."QuestionText") || '<p>'::text) || ex."AnswerValue") || '</p>'::text) || '</div>'::text), '</br>'::text) AS "AnswerValue",
            ex."RespondentId",
            ex."QuestionnaireId",
            ex."RecordId",
            ex."ParentQuestionId"
           FROM ( SELECT ra."ExtendedQuestionId" AS "Id",
                    ra."AnswerValue",
                    0 AS "Points",
                    ra."ExtendedQuestionId",
                    ra."RespondentId",
                    ra."Date",
                    ''::text AS "ExpertComment",
                    q."Text" AS "QuestionText",
                    qq."QuestionnaireId",
                    ra."RecordId",
                    q."ParentQuestionId"
                   FROM "RespondentExtendedAnswersView" ra
                     JOIN "ExtendedQuestions" q ON q."Id" = ra."ExtendedQuestionId"
                     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
                  WHERE ra."AnswerValue" <> ''::text
                UNION
                 SELECT aom."QuestionId" AS "Id",
                    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
                    aom."Points",
                    aom."QuestionId" AS "ExtendedQuestionId",
                    aom."RespondentId",
                    aom."Date",
                    aom."ExpertComment",
                    aom."QuestionText",
                    aom."QuestionnaireId",
                    aom."RecordId",
                    aom."ParentQuestionId"
                   FROM ( SELECT respanswers."Id",
                            respanswers."AnswerId",
                            ao."Text" AS "AnswerValue",
                            respanswers."Points",
                            respanswers."QuestionId",
                            respanswers."RespondentId",
                            respanswers."Date",
                            respanswers.rownumber,
                            respanswers."ExpertComment",
                            respanswers."QuestionText",
                            respanswers."QuestionnaireId",
                            respanswers."RecordId",
                            respanswers."ParentQuestionId"
                           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                                    ra."AnswerValue",
                                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                                    ra."Points",
                                    ra."ExtendedQuestionId" AS "QuestionId",
                                    ra."RespondentId",
                                    ra."Date",
                                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                                    ra."ExpertComment",
                                    ra."Text" AS "QuestionText",
                                    ra."QuestionnaireId",
                                    ra."RecordId",
                                    ra."ParentQuestionId"
                                   FROM ( SELECT ra_1."Id",
    ''::text AS "AnswerValue",
    unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
    0 AS "Points",
    ra_1."ExtendedQuestionId",
    ra_1."RespondentId",
    ra_1."Date",
    row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
    ''::text AS "ExpertComment",
    q."Text",
    qq."QuestionnaireId",
    ra_1."RecordId",
    q."ParentQuestionId"
   FROM "RespondentExtendedAnswersView" ra_1
     JOIN "ExtendedQuestions" q ON q."Id" = ra_1."ExtendedQuestionId"
     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
  WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
                             JOIN "ExtendedAnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
                  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId", aom."RecordId", aom."ParentQuestionId") ex
          GROUP BY ex."RespondentId", ex."QuestionnaireId", ex."RecordId", ex."ParentQuestionId") agg
  GROUP BY agg."RespondentId", agg."QuestionnaireId", agg."ParentQuestionId"
UNION ALL
 SELECT ravs."AnswerValue",
    ravs."RespondentId",
    ravs."QuestionnaireId",
    ravs."QuestionId"
   FROM "RespondentAnswersReviewStimulsoft" ravs
    UNION ALL 
  Select ram."AnswerValue", ram."RespondentId", q."QuestionnaireId",ram."QuestionId" 
  from "RespondentAnswers_Matrix" ram
  join "Questions" q on q."Id" = ram."QuestionId";



 -- View: public."RespondentAnswersReview_Extended"

-- DROP VIEW public."RespondentAnswersReview_Extended";

CREATE OR REPLACE VIEW public."RespondentAnswersReview_Extended" AS 
 SELECT ra."ExtendedQuestionId" AS "Id",
    ra."AnswerValue",
    0 AS "Points",
    ra."ExtendedQuestionId",
    ra."RespondentId",
    ra."Date",
    ''::text AS "ExpertComment",
    q."Text" AS "QuestionText",
    qq."QuestionnaireId",
    ra."ExtendedQuestionId"::text || ra."RecordId"::text AS "Unique"
   FROM "RespondentExtendedAnswersView" ra
     JOIN "ExtendedQuestions" q ON q."Id" = ra."ExtendedQuestionId"
     JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
  WHERE ra."AnswerValue" <> ''::text
UNION
 SELECT aom."QuestionId" AS "Id",
    string_agg(aom."AnswerValue", ', '::text) AS "AnswerValue",
    aom."Points",
    aom."QuestionId" AS "ExtendedQuestionId",
    aom."RespondentId",
    aom."Date",
    aom."ExpertComment",
    aom."QuestionText",
    aom."QuestionnaireId",
    aom."QuestionId"::text || aom."RecordId"::text AS "Unique"
   FROM ( SELECT respanswers."Id",
            respanswers."AnswerId",
            ao."Text" AS "AnswerValue",
            respanswers."Points",
            respanswers."QuestionId",
            respanswers."RespondentId",
            respanswers."Date",
            respanswers.rownumber,
            respanswers."ExpertComment",
            respanswers."QuestionText",
            respanswers."QuestionnaireId",
            respanswers."RecordId"
           FROM ( SELECT (ra."Id"::text || '_'::text) || unnest(string_to_array(ra."AnswerId", ','::text)) AS "Id",
                    ra."AnswerValue",
                    unnest(string_to_array(ra."AnswerId", ','::text)) AS "AnswerId",
                    ra."Points",
                    ra."ExtendedQuestionId" AS "QuestionId",
                    ra."RespondentId",
                    ra."Date",
                    row_number() OVER (ORDER BY ra."Id") AS rownumber,
                    ra."ExpertComment",
                    ra."Text" AS "QuestionText",
                    ra."QuestionnaireId",
                    ra."RecordId"
                   FROM ( SELECT ra_1."Id",
                            ''::text AS "AnswerValue",
                            unnest(string_to_array(ra_1."AnswerId", ';'::text)) AS "AnswerId",
                            0 AS "Points",
                            ra_1."ExtendedQuestionId",
                            ra_1."RespondentId",
                            ra_1."Date",
                            row_number() OVER (ORDER BY ra_1."Id") AS rownumber,
                            ''::text AS "ExpertComment",
                            q."Text",
                            qq."QuestionnaireId",
                            ra_1."RecordId"
                           FROM "RespondentExtendedAnswersView" ra_1
                             JOIN "ExtendedQuestions" q ON q."Id" = ra_1."ExtendedQuestionId"
                             JOIN "Questions" qq ON qq."Id" = q."ParentQuestionId"
                          WHERE ra_1."AnswerId" <> ''::text) ra) respanswers
             JOIN "ExtendedAnswerOptions" ao ON ao."Id"::text = respanswers."AnswerId") aom
  GROUP BY aom."QuestionId", aom."Points", aom."RespondentId", aom."Date", aom.rownumber, aom."ExpertComment", aom."QuestionText", aom."QuestionnaireId", aom."RecordId";



  -- View: public."RespondentAnswersReview"

-- DROP VIEW public."RespondentAnswersReview";

CREATE OR REPLACE VIEW public."RespondentAnswersReview" AS 
 SELECT "RespondentAnswersReview_Simple"."Id",
    "RespondentAnswersReview_Simple"."AnswerValue",
    "RespondentAnswersReview_Simple"."Points",
    "RespondentAnswersReview_Simple"."QuestionId",
    "RespondentAnswersReview_Simple"."RespondentId",
    "RespondentAnswersReview_Simple"."Date",
    "RespondentAnswersReview_Simple"."ExpertComment",
    "RespondentAnswersReview_Simple"."QuestionText",
    "RespondentAnswersReview_Simple"."QuestionnaireId"
   FROM "RespondentAnswersReview_Simple"
UNION ALL
 SELECT "RespondentAnswersReview_Multy"."Id",
    "RespondentAnswersReview_Multy"."AnswerValue",
    "RespondentAnswersReview_Multy"."Points",
    "RespondentAnswersReview_Multy"."QuestionId",
    "RespondentAnswersReview_Multy"."RespondentId",
    "RespondentAnswersReview_Multy"."Date",
    "RespondentAnswersReview_Multy"."ExpertComment",
    "RespondentAnswersReview_Multy"."QuestionText",
    "RespondentAnswersReview_Multy"."QuestionnaireId"
   FROM "RespondentAnswersReview_Multy"
UNION ALL
 SELECT "RespondentAnswersReview_Table"."Id",
    "RespondentAnswersReview_Table"."AnswerValue",
    "RespondentAnswersReview_Table"."Points",
    "RespondentAnswersReview_Table"."QuestionId",
    "RespondentAnswersReview_Table"."RespondentId",
    "RespondentAnswersReview_Table"."Date",
    "RespondentAnswersReview_Table"."ExpertComment",
    "RespondentAnswersReview_Table"."QuestionText",
    "RespondentAnswersReview_Table"."QuestionnaireId"
   FROM "RespondentAnswersReview_Table"
UNION ALL
 SELECT "RespondentAnswersReview_Extended"."Id",
    "RespondentAnswersReview_Extended"."AnswerValue",
    "RespondentAnswersReview_Extended"."Points",
    "RespondentAnswersReview_Extended"."ExtendedQuestionId" AS "QuestionId",
    "RespondentAnswersReview_Extended"."RespondentId",
    "RespondentAnswersReview_Extended"."Date",
    "RespondentAnswersReview_Extended"."ExpertComment",
    "RespondentAnswersReview_Extended"."QuestionText",
    "RespondentAnswersReview_Extended"."QuestionnaireId"
   FROM "RespondentAnswersReview_Extended";


------------------------------advanced ds sti-------------------------------------------
-- View: public."RespondentAnswers_Dropdown"

-- DROP VIEW public."RespondentAnswers_Dropdown";

CREATE OR REPLACE VIEW public."RespondentAnswers_Dropdown" AS 
 SELECT total_drop."Id",
    total_drop."RespondentId",
    total_drop."QuestionText",
    total_drop."Points",
    total_drop."Date",
    total_drop."AnswerValue",
    total_drop."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%dropdown%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%dropdown%'::text AND ra."AnswerValue" <> ''::text) total_drop
  ORDER BY total_drop."RespondentId", total_drop."AnswerValue";


-- View: public."RespondentAnswers_Files"

-- DROP VIEW public."RespondentAnswers_Files";

CREATE OR REPLACE VIEW public."RespondentAnswers_Files" AS 
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    ra."AnswerValue",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" ~~ '%file%'::text;


-- View: public."RespondentAnswers_Inputs"

-- DROP VIEW public."RespondentAnswers_Inputs";

CREATE OR REPLACE VIEW public."RespondentAnswers_Inputs" AS 
 SELECT ra."Id",
    ra."RespondentId",
    q."Text" AS "QuestionText",
    ra."Points",
    ra."Date",
    concat_ws(';'::text, ra."AnswerId", ra."AnswerValue") AS "AnswerValue",
    q."Id" AS "QuestionId"
   FROM "RespondentAnswers" ra
     JOIN "Questions" q ON q."Id" = ra."QuestionId"
  WHERE q."Type" !~~ '%single%'::text AND q."Type" !~~ '%file%'::text AND q."Type" !~~ '%multy%'::text AND q."Type" !~~ '%table%'::text AND q."Type" !~~ '%dropdown%'::text AND q."Type" !~~ '%extended%'::text;


-- View: public."RespondentAnswers_Match"

-- DROP VIEW public."RespondentAnswers_Match";


CREATE OR REPLACE VIEW public."RespondentAnswers_Match" AS 
 SELECT match."Id",
    match."RespondentId",
    q."Text" AS "QuestionText",
    match."Points",
    match."Date",
    ao1."TextA" AS "LeftSide",
    ao2."TextB" AS "RightSide",
    q."Id" AS "QuestionId"
   FROM ( SELECT ra_split."Id",
            ra_split."RespondentId",
            ra_split."QuestionId",
            ra_split."Points",
            ra_split."Date",
            split_part(ra_split."AnswerId", '='::text, 1) AS "LeftPart",
            split_part(ra_split."AnswerId", '='::text, 2) AS "RigthPart"
           FROM ( SELECT ra."Id",
                    ra."RespondentId",
                    ra."QuestionId",
                    ra."Points",
                    ra."Date",
                    unnest(string_to_array(ra."AnswerId", ';'::text)) AS "AnswerId"
                   FROM "RespondentAnswers" ra
                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                  WHERE q_1."Type" ~~ '%table%'::text) ra_split
          WHERE ra_split."AnswerId" <> ''::text) match
     JOIN "AnswerOptions" ao1 ON ao1."Id"::text = match."LeftPart"
     JOIN "AnswerOptions" ao2 ON ao2."PublicBId" = match."RigthPart"
     JOIN "Questions" q ON q."Id" = match."QuestionId";


-- View: public."RespondentAnswers_Multy"

-- DROP VIEW public."RespondentAnswers_Multy";

CREATE OR REPLACE VIEW public."RespondentAnswers_Multy" AS 
 SELECT total_multy."Id",
    total_multy."RespondentId",
    total_multy."QuestionText",
    total_multy."Points",
    total_multy."Date",
    total_multy."AnswerValue",
    total_multy."QuestionId"
   FROM ( SELECT multy."Id",
            multy."RespondentId",
            q."Text" AS "QuestionText",
            multy."Points",
            multy."Date",
            ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM ( SELECT ra_split."Id",
                    ra_split."RespondentId",
                    ra_split."QuestionId",
                    ra_split."Points",
                    ra_split."Date",
                    ra_split."AnswerId",
                    ra_split."AnswerValue"
                   FROM ( SELECT ra_m."Id",
                            ra_m."RespondentId",
                            ra_m."QuestionId",
                            ra_m."Points",
                            ra_m."Date",
                            unnest(string_to_array(ra_m."AnswerId", ','::text)) AS "AnswerId",
                            ra_m."AnswerValue"
                           FROM ( SELECT ra."Id",
                                    ra."RespondentId",
                                    ra."QuestionId",
                                    ra."Points",
                                    ra."Date",
                                    ra."AnswerId",
                                    ra."AnswerValue"
                                   FROM "RespondentAnswers" ra
                                     JOIN "Questions" q_1 ON q_1."Id" = ra."QuestionId"
                                  WHERE q_1."Type" ~~ '%multy%'::text) ra_m) ra_split
                  WHERE ra_split."AnswerId" <> ''::text) multy
             JOIN "Questions" q ON q."Id" = multy."QuestionId"
             LEFT JOIN "AnswerOptions" ao ON ao."Id"::text = multy."AnswerId"
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%multy%'::text AND ra."AnswerValue" <> ''::text) total_multy
  ORDER BY total_multy."RespondentId", total_multy."AnswerValue";


-- View: public."RespondentAnswers_Single"

-- DROP VIEW public."RespondentAnswers_Single";

CREATE OR REPLACE VIEW public."RespondentAnswers_Single" AS 
 SELECT total_single."Id",
    total_single."RespondentId",
    total_single."QuestionText",
    total_single."Points",
    total_single."Date",
    total_single."AnswerValue",
    total_single."QuestionId"
   FROM ( SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ao."Text" AS "AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
             JOIN "AnswerOptions" ao ON ao."Id"::text = ra."AnswerId"
          WHERE q."Type" ~~ '%single%'::text
        UNION
         SELECT ra."Id",
            ra."RespondentId",
            q."Text" AS "QuestionText",
            ra."Points",
            ra."Date",
            ra."AnswerValue",
            q."Id" AS "QuestionId"
           FROM "RespondentAnswers" ra
             JOIN "Questions" q ON q."Id" = ra."QuestionId"
          WHERE q."Type" ~~ '%single%'::text AND ra."AnswerValue" <> ''::text) total_single
  ORDER BY total_single."RespondentId", total_single."AnswerValue";


-- View: public."RespondentExtendedAnswers_Files"

-- DROP VIEW public."RespondentExtendedAnswers_Files";

CREATE OR REPLACE VIEW public."RespondentExtendedAnswers_Files" AS 
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    rea."AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
  WHERE eq."Type" ~~ '%file%'::text;


-- View: public."RespondentExtendedAnswers_Inputs"

-- DROP VIEW public."RespondentExtendedAnswers_Inputs";

CREATE OR REPLACE VIEW public."RespondentExtendedAnswers_Inputs" AS 
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    rea."AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
  WHERE eq."Type" ~~ '%input%'::text;


-- View: public."RespondentExtendedAnswers_Multy"

-- DROP VIEW public."RespondentExtendedAnswers_Multy";

CREATE OR REPLACE VIEW public."RespondentExtendedAnswers_Multy" AS 
 SELECT table_multy."Id",
    table_multy."RecordId",
    table_multy."RecordName",
    table_multy."RespondentId",
    table_multy."Date",
    eao."Text" AS "AnswerValue",
    table_multy."ParentQuestionText",
    table_multy."ParentQuestionId",
    table_multy."QuestionText",
    table_multy."QuestionId"
   FROM ( SELECT rea."Id",
            rea."RecordId",
            rer."Name" AS "RecordName",
            rer."RespondentId",
            rea."Date",
            unnest(string_to_array(rea."AnswerId", ','::text)) AS "AnswerId",
            q."Text" AS "ParentQuestionText",
            eq."ParentQuestionId",
            eq."Text" AS "QuestionText",
            eq."Id" AS "QuestionId"
           FROM "RespondentExtendedAnswers" rea
             JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
             JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
             JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
          WHERE eq."Type" ~~ '%multy%'::text) table_multy
     JOIN "ExtendedAnswerOptions" eao ON eao."Id"::text = table_multy."AnswerId";


-- View: public."RespondentExtendedAnswers_Single"

-- DROP VIEW public."RespondentExtendedAnswers_Single";

CREATE OR REPLACE VIEW public."RespondentExtendedAnswers_Single" AS 
 SELECT rea."Id",
    rea."RecordId",
    rer."Name" AS "RecordName",
    rer."RespondentId",
    rea."Date",
    eao."Text" AS "AnswerValue",
    q."Text" AS "ParentQuestionText",
    eq."ParentQuestionId",
    eq."Text" AS "QuestionText",
    eq."Id" AS "QuestionId"
   FROM "RespondentExtendedAnswers" rea
     JOIN "RespondentExtendedRecords" rer ON rea."RecordId" = rer."Id"
     JOIN "ExtendedQuestions" eq ON rea."ExtendedQuestionId" = eq."Id"
     JOIN "Questions" q ON q."Id" = eq."ParentQuestionId"
     JOIN "ExtendedAnswerOptions" eao ON eao."Id"::text = rea."AnswerId"
  WHERE eq."Type" ~~ '%dropdown%'::text;


-- View: public."Respondents_Answers"

-- DROP VIEW public."Respondents_Answers";

CREATE OR REPLACE VIEW public."Respondents_Answers" AS 
 SELECT total."Id",
    total."RespondentId",
    total."QuestionText",
    total."Points",
    total."Date",
    total."AnswerValue",
    total."QuestionId"
   FROM ( SELECT "RespondentAnswers_Single"."Id",
            "RespondentAnswers_Single"."RespondentId",
            "RespondentAnswers_Single"."QuestionText",
            "RespondentAnswers_Single"."Points",
            "RespondentAnswers_Single"."Date",
            "RespondentAnswers_Single"."AnswerValue",
            "RespondentAnswers_Single"."QuestionId"
           FROM "RespondentAnswers_Single"
        UNION
         SELECT "RespondentAnswers_Multy"."Id",
            "RespondentAnswers_Multy"."RespondentId",
            "RespondentAnswers_Multy"."QuestionText",
            "RespondentAnswers_Multy"."Points",
            "RespondentAnswers_Multy"."Date",
            "RespondentAnswers_Multy"."AnswerValue",
            "RespondentAnswers_Multy"."QuestionId"
           FROM "RespondentAnswers_Multy"
        UNION
         SELECT "RespondentAnswers_Dropdown"."Id",
            "RespondentAnswers_Dropdown"."RespondentId",
            "RespondentAnswers_Dropdown"."QuestionText",
            "RespondentAnswers_Dropdown"."Points",
            "RespondentAnswers_Dropdown"."Date",
            "RespondentAnswers_Dropdown"."AnswerValue",
            "RespondentAnswers_Dropdown"."QuestionId"
           FROM "RespondentAnswers_Dropdown"
        UNION
         SELECT "RespondentAnswers_Files"."Id",
            "RespondentAnswers_Files"."RespondentId",
            "RespondentAnswers_Files"."QuestionText",
            "RespondentAnswers_Files"."Points",
            "RespondentAnswers_Files"."Date",
            "RespondentAnswers_Files"."AnswerValue",
            "RespondentAnswers_Files"."QuestionId"
           FROM "RespondentAnswers_Files"
        UNION
         SELECT "RespondentAnswers_Inputs"."Id",
            "RespondentAnswers_Inputs"."RespondentId",
            "RespondentAnswers_Inputs"."QuestionText",
            "RespondentAnswers_Inputs"."Points",
            "RespondentAnswers_Inputs"."Date",
            "RespondentAnswers_Inputs"."AnswerValue",
            "RespondentAnswers_Inputs"."QuestionId"
           FROM "RespondentAnswers_Inputs") total
  ORDER BY total."RespondentId", total."AnswerValue";

-- View: public."Respondents_ExtendedAnswers"

-- DROP VIEW public."Respondents_ExtendedAnswers";

CREATE OR REPLACE VIEW public."Respondents_ExtendedAnswers" AS 
 SELECT total."Id",
    total."RecordId",
    total."RecordName",
    total."RespondentId",
    total."Date",
    total."AnswerValue",
    total."ParentQuestionText",
    total."ParentQuestionId",
    total."QuestionText",
    total."QuestionId"
   FROM ( SELECT "RespondentExtendedAnswers_Inputs"."Id",
            "RespondentExtendedAnswers_Inputs"."RecordId",
            "RespondentExtendedAnswers_Inputs"."RecordName",
            "RespondentExtendedAnswers_Inputs"."RespondentId",
            "RespondentExtendedAnswers_Inputs"."Date",
            "RespondentExtendedAnswers_Inputs"."AnswerValue",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionText",
            "RespondentExtendedAnswers_Inputs"."ParentQuestionId",
            "RespondentExtendedAnswers_Inputs"."QuestionText",
            "RespondentExtendedAnswers_Inputs"."QuestionId"
           FROM "RespondentExtendedAnswers_Inputs"
        UNION
         SELECT "RespondentExtendedAnswers_Files"."Id",
            "RespondentExtendedAnswers_Files"."RecordId",
            "RespondentExtendedAnswers_Files"."RecordName",
            "RespondentExtendedAnswers_Files"."RespondentId",
            "RespondentExtendedAnswers_Files"."Date",
            "RespondentExtendedAnswers_Files"."AnswerValue",
            "RespondentExtendedAnswers_Files"."ParentQuestionText",
            "RespondentExtendedAnswers_Files"."ParentQuestionId",
            "RespondentExtendedAnswers_Files"."QuestionText",
            "RespondentExtendedAnswers_Files"."QuestionId"
           FROM "RespondentExtendedAnswers_Files"
        UNION
         SELECT "RespondentExtendedAnswers_Multy"."Id",
            "RespondentExtendedAnswers_Multy"."RecordId",
            "RespondentExtendedAnswers_Multy"."RecordName",
            "RespondentExtendedAnswers_Multy"."RespondentId",
            "RespondentExtendedAnswers_Multy"."Date",
            "RespondentExtendedAnswers_Multy"."AnswerValue",
            "RespondentExtendedAnswers_Multy"."ParentQuestionText",
            "RespondentExtendedAnswers_Multy"."ParentQuestionId",
            "RespondentExtendedAnswers_Multy"."QuestionText",
            "RespondentExtendedAnswers_Multy"."QuestionId"
           FROM "RespondentExtendedAnswers_Multy"
        UNION
         SELECT "RespondentExtendedAnswers_Single"."Id",
            "RespondentExtendedAnswers_Single"."RecordId",
            "RespondentExtendedAnswers_Single"."RecordName",
            "RespondentExtendedAnswers_Single"."RespondentId",
            "RespondentExtendedAnswers_Single"."Date",
            "RespondentExtendedAnswers_Single"."AnswerValue",
            "RespondentExtendedAnswers_Single"."ParentQuestionText",
            "RespondentExtendedAnswers_Single"."ParentQuestionId",
            "RespondentExtendedAnswers_Single"."QuestionText",
            "RespondentExtendedAnswers_Single"."QuestionId"
           FROM "RespondentExtendedAnswers_Single") total
  ORDER BY total."RespondentId", total."RecordId", total."AnswerValue";


----------------------------------------------------------------------------------------

 -------------------------------------------------------------------------------------------------------------
 ------------------------------------------DATA---------------------------------------------------------------
 -------------------------------------------------------------------------------------------------------------  
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div class="panel panel-colorpanelinfo"style="minwidth:479.156px;marginleft:31px;minheight: 255px;"><h3>Panel Default</h3><div class="panel-body"><p>Your text</p></div></div>',
	'host', now(),  
            now(),'host', 'Default panel');
-----------------------------------------------------------------
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div style="min-width: 479.156px; margin-left: 31px; min-height: 255px;">&nbsp;<div class="col-lg-12"><ul class="nav nav-tabs"><li class="active"><a href="#home" data-toggle="tab"> <span class="hidden-xs">First</span> </a></li><li class=""><a href="#profile" data-toggle="tab"> <span class="hidden-xs">Second</span> </a></li><li class=""><a href="#messages" data-toggle="tab"> <span class="hidden-xs">Third</span> </a></li><li class=""><a href="#settings" data-toggle="tab"> <span class="hidden-xs">Fourth</span> </a></li></ul><div class="tab-content"><div id="home" class="tab-pane active"><div><p>Text1</p></div></div><div id="profile" class="tab-pane"><p>Text2</p></div><div id="messages" class="tab-pane"><p>Text3</p></div><div id="settings" class="tab-pane"><p>Text4</p></div></div></div></div>',
	'host', now(), 
            now(),'host',  'Tabs upstairs min string');
-------------------------------------------------------------------------
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div style="min-width: 479.156px; margin-left: 31px; min-height: 255px;"><div class="col-lg-12"><ul class="nav nav-tabs nav-justified"><li class="active"><a href="#home-2" data-toggle="tab"> <span class="hidden-xs">First option</span> </a></li><li class=""><a href="#profile-2" data-toggle="tab"> <span class="hidden-xs">Second option</span> </a></li><li class=""><a href="#messages-2" data-toggle="tab"> <span class="hidden-xs">Third option</span> </a></li><li class=""><a href="#settings-2" data-toggle="tab"> <span class="hidden-xs">fourth option</span> </a></li></ul><div class="tab-content"><div id="home-2" class="tab-pane active"><div><p>Text from first option.</p></div></div><div id="profile-2" class="tab-pane"><p>Text from second option.</p></div><div id="messages-2" class="tab-pane"><p>Text from third option.</p></div><div id="settings-2" class="tab-pane"><p>Text from fourth option.</p></div></div></div></div>',
	'host', now(),  now(),'host', 'Tabs upstairs max string');
-------------------------------------------------------------------
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div style="min-width: 479.156px; margin-left: 31px; min-height: 255px;"><div class="col-lg-12"><div class="tabs-vertical-env"><div class="col-sm-8"><div class="tab-content"><div id="v2-home" class="tab-pane active"><p>Text from first button.</p></div><div id="v2-profile" class="tab-pane"><p>Text from second button.</p></div><div id="v2-messages" class="tab-pane"><p>Text from third button.</p></div><div id="v2-settings" class="tab-pane"><p>Text from fourth button.</p></div></div></div><div class="col-sm-4"><ul class="nav tabs-vertical"><li class="active"><a href="#v2-home" data-toggle="tab">First</a></li><li><a href="#v2-profile" data-toggle="tab">Second</a></li><li><a href="#v2-messages" data-toggle="tab">Third</a></li><li><a href="#v2-settings" data-toggle="tab">Fourth</a></li></ul></div></div></div></div>', 'host', now(),  
            now(),'host', 'Tabs button right');
----------------------------------------------------------------------------------------------------------            
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div style="min-width: 479.156px; margin-left: 31px; min-height: 255px;"><div class="col-lg-12"><div class="tabs-vertical-env"><div class="col-sm-4"><ul class="nav tabs-vertical"><li class="active"><a href="#v-home" data-toggle="tab">First option</a></li><li class=""><a href="#v-profile" data-toggle="tab">Second option</a></li><li class=""><a href="#v-messages" data-toggle="tab">Third option</a></li><li class=""><a href="#v-settings" data-toggle="tab">Fourth option</a></li></ul></div><div class="col-sm-8"><div class="tab-content"><div id="v-home" class="tab-pane active"><p>Text from first option.</p></div><div id="v-profile" class="tab-pane"><p>Text from second option.</p></div><div id="v-messages" class="tab-pane"><p>text from third option</p></div><div id="v-settings" class="tab-pane"><p>Text from fourth option.</p></div></div></div></div></div></div>', 'host', now(), 
            now(), 'host', 'Tabs button left');
------------------------------------------------------------------------------------------------------------
 
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div id="accordion"><div><h3>Collapsible Group Item #1</h3></div><div>Some text 1</div><div><h3>Collapsible Group Item #2</h3></div><div>Some text 2</div><div><h3>Collapsible Group Item #3 </h3></div><div>some text 3</div></div><script>$("#accordion").accordion({hightStyle: "content"});</script>', 'host', now(),
            now(), 'host',  'Accordion');
INSERT INTO public."PageTeamplates"(
               "Body", "CreatedByUser", "CreationDate", "ModificationDate", 
            "ModifiedByUser", "Name")
    VALUES (  '<div id="my-store-shopId"></div><div> <script type="text/javascript" data-cfasync="false" src="https://app.ecwid.com/script.js?shopId" charset="utf-8"></script><script type="text/javascript"> xProductBrowser("categoriesPerRow=3","views=grid(20,3) list(60) table(60)","categoryView=grid","searchView=list","id=my-store-shopId");</script></div>', 'host', now(),
            now(), 'host',  'Ecwid');
------------------------------------------------------------------------------------------------------------
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('Culture',	'ru-RU');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('CategoriesView','True');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('TagsView','False');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('NewsView','True');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('UserAccountsLogin','True');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('SocialLogin','False');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('ActiveDirectoryLogin','False');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('SocailLoginOAuth','False');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('SeoDescription','Expasys Questionnaire Studio Pro - программная платформа для сбора, хранения, консолидации, анализа и визуализации массивов данных, поступающих с территориально распределённых источников.');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('SeoKeyWords','Expasys, Expasys Questionnarie Studio Pro, Questionnarie Studio, Questionnarie Studio Pro');
INSERT INTO public."ApplicationSettings"("SettingName", "SettingValue")	VALUES ('SeoTitle','Expasys Questionnarie Studio Pro');
------------------------------------------------------------------------------------------------------------

--потому что постгресс не умеет сам определять следующий ИД
SELECT SETVAL('public."AccessRights_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."AccessRights";
SELECT SETVAL('public."AnswerOptionFiles_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."AnswerOptionFiles";
SELECT SETVAL('public."AspNetRoleClaims_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."AspNetRoleClaims";
SELECT SETVAL('public."AspNetUserClaims_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."AspNetUserClaims";
SELECT SETVAL('public."Categories_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Categories";
SELECT SETVAL('public."Cities_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Cities";
SELECT SETVAL('public."Countries_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Countries";
SELECT SETVAL('public."CustomPages_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."CustomPages";
SELECT SETVAL('public."Documents_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Documents";
SELECT SETVAL('public."Log_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Log";
SELECT SETVAL('public."Logic_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Logic";
SELECT SETVAL('public."MobileConfirmationCodes_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."MobileConfirmationCodes";
SELECT SETVAL('public."NewsCategories_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."NewsCategories";
SELECT SETVAL('public."NewsDocuments_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."NewsDocuments";
SELECT SETVAL('public."NewsPictures_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."NewsPictures";
SELECT SETVAL('public."NewsTags_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."NewsTags";
SELECT SETVAL('public."News_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."News";
SELECT SETVAL('public."PageTeamplates_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."PageTeamplates";
SELECT SETVAL('public."QuestionFiles_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionFiles";
SELECT SETVAL('public."QuestionnaireAccessRoles_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireAccessRoles";
SELECT SETVAL('public."QuestionnaireAuthors_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireAuthors";
SELECT SETVAL('public."QuestionnaireCategories_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireCategories";
SELECT SETVAL('public."QuestionnaireSecretKeys_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireSecretKeys";
SELECT SETVAL('public."QuestionnaireTags_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireTags";
SELECT SETVAL('public."QuestionnaireTimespans_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."QuestionnaireTimespans";
SELECT SETVAL('public."Regions_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Regions";
SELECT SETVAL('public."RespondentAnswers_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."RespondentAnswers";
SELECT SETVAL('public."RespondentExtendedAnswers_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."RespondentExtendedAnswers";
SELECT SETVAL('public."RespondentExtendedRecords_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."RespondentExtendedRecords";
SELECT SETVAL('public."Respondents_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."Respondents";
SELECT SETVAL('public."SystemsNotifications_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."SystemsNotifications";
SELECT SETVAL('public."TestResultTexts_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."TestResultTexts";
SELECT SETVAL('public."UserTasks_Id_seq"', COALESCE(MAX("Id"), 1) ) FROM public."UserTasks";

