﻿let lastPassingActivityConnection = null;
let isLocked = true;

function ConnectHub(url, handlerName, handlerBehavior, onCloseHandler, connectionLifetime) {
    var connection2 = new signalR.HubConnectionBuilder()
        .withUrl(url)
        .configureLogging(signalR.LogLevel.None)
        .build();

    connection2.serverTimeoutInMilliseconds = connectionLifetime;

    connection2.on(handlerName, handlerBehavior);
    connection2.onclose(onCloseHandler);

    connection2.on("RedirectToPassingLimit", () => {
        window.location.href = "/passinglimit";
    });

    connection2.start();

    if (url === "/hubs/last-passing-activity") {
        lastPassingActivityConnection = connection2;
    }
}

function CreateLastPassingActivityConnection() {
    var lastActivityHandler = {
        name: "UpdateUserPassingActivity",
        handle: () => {

        },
        onclose: (error) => {
            if (error) {
                console.error(error);
            }
        }
    }
    const url = "/hubs/last-passing-activity";
    const connectionLifetime = 5 * 60 * 1000;

    ConnectHub(url, lastActivityHandler.name, lastActivityHandler.handle, lastActivityHandler.onclose, connectionLifetime);
}
function UpdateLastPassingActivity(respondentId) {
    if (isLocked) {
        isLocked = false;
        setTimeout(() => {
            isLocked = true;
        }, 30000);
    } else {
        return;
    }

    if (lastPassingActivityConnection.q === "Connected") {
        lastPassingActivityConnection.invoke("UpdateActivity", respondentId)
            .catch(err => console.error("Invoke Error:", err));
    }
}

function CheckLastPassingActivity(respondentId) {
    setInterval(() => {
        if (lastPassingActivityConnection.q === "Connected") {
            lastPassingActivityConnection.invoke("CheckActivity", respondentId)
                .catch(err => console.error("Invoke Error:", err));
        }
    }, 300000);
}