﻿var record_id = 1;

function RenderQuestions(wrapper, showOrderId) {
    var i18n = eqspI18nRenderQuestions;

    const that = this;
    function appendFiles(files) {
        if (!files || !(files instanceof Array) || files.length == 0) return "";
        var fragment = $('<div class="files_wrapper">');
        fragment.append('<h5 class="passing__subtitle">' + i18n.header_Files + '</h5>');
        for (var i = 0; i < files.length; i++) {
            fragment.append('<a href="' + files[i].Path + '" target="_blank"><span class="fas fa-download mr-2"></span>&nbsp;' + files[i].Name + '</a><br>')
        }
        return fragment[0].outerHTML;
    }

    function getQuestionText(text) {
        if (text) {
            return text;
        } else {
            return "";
        }
    }

    function sumFloats(items) {
        var R = 0;

        for (var x = 0; x < items.length; x++) {
            R += parseFloat((items[x]).toFixed(2));
        }

        R = parseFloat(R.toFixed(2));
        return R;
    }

    function escapeHtml(str) {
        return str.replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;');
    }

    function unescapeHtml(str) {
        return str.replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&quot;/g, '"')
            .replace(/&#39;/g, "'");
    }

    // main
    that.RenderQuestionData = function (questionData, extendedQuestionsData) {
        const renderMethods = {
            'questionnaire_single': that.renderQSingle,
            'questionnaire_textblock': that.renderQSingle,
            'questionnaire_multy': that.renderQMulty,
            'questionnaire_file': that.renderQFile,
            'questionnaire_table': that.renderQTable,
            'questionnaire_matrix': that.renderQMatrix,
            'questionnaire_autocomplete': that.renderQAutocomplete,
            'questionnaire_input': that.renderQInput,
            'questionnaire_dadatainput': that.renderQDaDataInput,
            'questionnaire_dropdown': that.renderQDropdown,
            'questionnaire_scale': that.renderQScale,
            'questionnaire_nps': that.renderQNps,
            'questionnaire_rating': that.renderQRating,
            'test_single_undefined': that.renderTSingle,
            'test_single': that.renderTSingle,
            'test_multy_undefined': that.renderTMulty,
            'test_multy': that.renderTMulty,
            'test_open': that.renderTOpen,
            'test_table': that.renderTTable,
            'test_scale': that.renderTScale,
            'questionnaire_date': that.renderQuestionDate,
            'questionnaire_scale_two_slide': that.renderQScaleWithTwoSliders,
            'questionnaire_spreadsheet': that.renderQSpreadsheet
        };

        const renderMethod = renderMethods[questionData.Type];

        if (renderMethod) {
            renderMethod.call(that, questionData);
        } else if (questionData.Type === 'questionnaire_extended') {
            that.renderParentExtendedQuestion(questionData);
            if (Array.isArray(questionData.ExtendedQuestions)) {
                extendedQuestionsData[questionData.QuestionId] = questionData.ExtendedQuestions;
            }
        } else if (questionData.Type === 'answered') {
            $("#answered").html(questionData.Value);
        }
    };

    that.renderQuestionDate = function (data) {
        const container = that.createDateContainer_qdate(data);
        that.appendCommonElements_qdate(container, data);
        that.appendDateInput_qdate(container, data);
        that.setGivenAnswer_qdate(container, data);
        wrapper.append(container);
    };

    that.createDateContainer_qdate = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId,
            'data-inputtype': data.InputType
        });
    };

    that.appendCommonElements_qdate = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendDateInput_qdate = function (container, data) {
        const inputTypes = {
            date: that.createDatePicker_qdate,
            dateandtime: that.createDateTimePicker_qdate,
            notLess: that.createNotLessPicker_qdate,
            notMore: that.createNotMorePicker_qdate,
            time: that.createTimePicker_qdate,
            between: that.createBetweenPicker_qdate
        };

        const createInput = inputTypes[data.InputType];
        if (createInput) {
            createInput.call(that, container, data);
        }
    };

    that.createDatePicker_qdate = function (container, data) {
        container.append(`<input id="justDate_${data.QuestionId}" class="form-control just_date" name="${data.QuestionId}" /> <span class="invalid_text"></span>`);
        container.append(`<script>
            $("#justDate_${data.QuestionId}").kendoDatePicker();
            $("#justDate_${data.QuestionId}").attr("readonly", "true");
        </script>`);
    };

    that.createDateTimePicker_qdate = function (container, data) {
        container.append(`<input id="dateTime_${data.QuestionId}" class="form-control date_and_time" name="${data.QuestionId}"/> <span class="invalid_text"></span>`);
        container.append(`<script>
            $("#dateTime_${data.QuestionId}").kendoDateTimePicker({dateInput: true});
        </script>`);
    };

    that.createNotLessPicker_qdate = function (container, data) {
        container.append(`<input class="form-control not_Less" id="notLess_${data.QuestionId}" min="${data.MinDate}" name="${data.QuestionId}"/> <span class="invalid_text"></span>`);
        container.append(`<script>
            $("#notLess_${data.QuestionId}").kendoDatePicker({min:"${data.MinDate}"});
            $("#notLess_${data.QuestionId}").attr("readonly", true);
        </script>`);
    };

    that.createNotMorePicker_qdate = function (container, data) {
        container.append(`<input class="form-control not_More" id="notMore_${data.QuestionId}" max="${data.MaxDate}" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
        container.append(`<script>
            $("#notMore_${data.QuestionId}").kendoDatePicker({max:"${data.MaxDate}"});
            $("#notMore_${data.QuestionId}").attr("readonly", true);
        </script>`);
    };

    that.createTimePicker_qdate = function (container, data) {
        container.append(`<input type="time" class="form-control time" id="time_${data.QuestionId}" placeholder="hh:mm:ss" step="2" name="${data.QuestionId}"/> <span class="invalid_text"></span>`);
    };

    that.createBetweenPicker_qdate = function (container, data) {
        container.append(`<input class='form-control between' id='between_${data.QuestionId}' name='${data.QuestionId}'/><span class='invalid_text'></span>`);
        container.append(`<script>
            $('#between_${data.QuestionId}').kendoDatePicker({ min: '${data.MinDateScale}', max: '${data.MaxDateScale}'})
            $('#between_${data.QuestionId}').attr('readonly', true);
        </script>`);
    };

    that.setGivenAnswer_qdate = function (container, data) {
        if (data.GivenAnswerValue) {
            container.find(`input[name="${data.QuestionId}"]`).val(data.GivenAnswerValue);
        }
    };

    that.renderQSingle = function (data) {
        const container = that.createContainer_qsingle(data);
        that.appendCommonElements_qsingle(container, data);
        that.appendOptionsContainer_qsingle(container, data);
        wrapper.append(container);
    };

    that.createContainer_qsingle = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendCommonElements_qsingle = function (container, data) {
        if (showOrderId && !(data.InputMask === "true")) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendOptionsContainer_qsingle = function (container, data) {
        const optionsContainer = $('<div class="options_container">');

        data.AnswerOptions.forEach(option => {
            optionsContainer.append(that.createOptionElement_qsingle(data, option));
        });

        if (data.GivenAnswerId) {
            that.setGivenAnswer_qsingle(optionsContainer, data.GivenAnswerId);
        }

        if (data.AllowUserOption) {
            optionsContainer.append(that.createUserOptionElement_qsingle(data));
        }

        container.append(optionsContainer);
    };

    that.createOptionElement_qsingle = function (data, option) {
        const div = $('<div class="custom-control custom-radio"></div>');
        div.append(`
            <input class="custom-control-input" id="${option.AnswerOptionId}"
                type="radio" name="${data.QuestionId}" data-answeroptionid="${option.AnswerOptionId}">
            <label class="custom-control-label" for="${option.AnswerOptionId}">
                ${option.Text || ""}${appendFiles(option.Files)}
            </label>
        `);
        return div;
    };

    that.setGivenAnswer_qsingle = function (optionsContainer, givenAnswerId) {
        optionsContainer.find(`input[data-answeroptionid="${givenAnswerId}"]`).attr("checked", "checked");
    };

    that.createUserOptionElement_qsingle = function (data) {
        const div = $('<div class="custom-control custom-radio"></div>');
        div.append(`
            <input class="custom-control-input" id="useroption_${data.QuestionId}"
                type="radio" name="${data.QuestionId}" data-answeroptionid="useroption">
            <label class="custom-control-label" for="useroption_${data.QuestionId}">${i18n.label_YourOption}</label>
            <input class="form-control mt-2" type="text" name="${data.QuestionId}" 
                readonly="readonly" data-useroption="useroption" />
        `);

        if (data.GivenAnswerValue != null) {
            div.find('input[data-answeroptionid="useroption"]').attr("checked", "checked");
            div.find('input[data-useroption="useroption"]')
                .val(data.GivenAnswerValue)
                .removeAttr('readonly');
        }

        return div;
    };

    that.renderQMulty = function (data) {
        const container = that.createMultyContainer_qmulty(data);
        that.appendCommonElements_qmulty(container, data);
        that.appendOptionsContainer_qmulty(container, data);
        that.appendCheckedCountValidation_qmulty(container);
        wrapper.append(container);
    };

    that.createMultyContainer_qmulty = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId,
            'data-maxchecked': data.MaxChecked,
            'data-minchecked': data.MinChecked
        });
    };

    that.appendCommonElements_qmulty = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendOptionsContainer_qmulty = function (container, data) {
        const optionsContainer = $('<div class="options_container">');

        data.AnswerOptions.forEach(option => {
            optionsContainer.append(that.createOptionElement_qmulty(data, option));
        });

        if (data.GivenAnswerIds) {
            that.setGivenAnswers_qmulty(optionsContainer, data.GivenAnswerIds);
        }

        if (data.AllowUserOption) {
            optionsContainer.append(that.createUserOptionElement_qmulty(data));
        }

        container.append(optionsContainer);
    };

    that.createOptionElement_qmulty = function (data, option) {
        const div = $('<div class="custom-control custom-checkbox"></div>');
        div.append(`
            <input class="custom-control-input" id="${option.AnswerOptionId}"
                type="checkbox" name="${data.QuestionId}" data-answeroptionid="${option.AnswerOptionId}">
            <label class="custom-control-label" for="${option.AnswerOptionId}">
                ${option.Text || ""}${appendFiles(option.Files)}
            </label>
        `);
        return div;
    };

    that.setGivenAnswers_qmulty = function (optionsContainer, givenAnswerIds) {
        givenAnswerIds.split(",").forEach(givenAnswerId => {
            optionsContainer.find(`input[data-answeroptionid="${givenAnswerId}"]`).attr("checked", "checked");
        });
    };

    that.createUserOptionElement_qmulty = function (data) {
        const div = $('<div class="custom-control custom-checkbox"></div>');
        div.append(`
            <input class="custom-control-input" id="useroption_${data.QuestionId}"
                type="checkbox" name="${data.QuestionId}" data-answeroptionid="useroption">
            <label class="custom-control-label" for="useroption_${data.QuestionId}">${i18n.label_YourOption}</label>
            <input class="form-control" type="text" name="${data.QuestionId}"
                readonly="readonly" data-useroption="useroption" />
        `);

        if (data.GivenAnswerValue != null) {
            div.find('input[data-answeroptionid="useroption"]').attr("checked", "checked");
            div.find('input[data-useroption="useroption"]').val(data.GivenAnswerValue).removeAttr('readonly');
        }

        return div;
    };

    that.appendCheckedCountValidation_qmulty = function (container) {
        container.append('<div class="checked_count_validation">');
    };

    that.renderQFile = function (data) {
        const container = that.createFileContainer_qfile(data);
        that.appendCommonElements_qfile(container, data);
        that.appendFileInput_qfile(container, data);
        that.appendFileInfo_qfile(container, data);
        that.appendFileRestrictions_qfile(container, data);
        wrapper.append(container);
        that.setupFileInputChange_qfile();
        that.setMaxFileSize_qfile(container, data);
    };

    that.createFileContainer_qfile = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendCommonElements_qfile = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendFileInput_qfile = function (container, data) {
        const allowedTypes = data.AllowedTypes?.split(',').map(x => "." + x.trim()).join(",");
        container.append(`
            <div class="custom-file">
                <input type="file" accept="${allowedTypes}" class="custom-file-input question_file" 
                    id="${data.QuestionId}" name="${data.QuestionId}" data-allowedtypes="${data.AllowedTypes}" />
                <label class="custom-file-label" for="${data.QuestionId}">
                    ${data.GivenAnswerFileName || ""}
                </label>
            </div>
        `);
    };

    that.appendFileInfo_qfile = function (container, data) {
        if (data.GivenAnswerFileName) {
            container.append(`
                <span class="file_info">
                    ${i18n.message_File_File}${i18n.message_File_UploadedBut}${i18n.message_File_Current}
                    <a target="_blank" href="${window.origin}/${data.PathToAnswerFileName}" class="download_uploaded_file">
                        ${i18n.message_File_Download}
                    </a> 
                    ${i18n.message_File_Or}
                    <a href="#" class="delete_uploaded_file">${i18n.message_File_Remove}</a>
                </span>
            `);
        }
    };

    that.appendFileRestrictions_qfile = function (container, data) {
        container.append(`
            <div class="px-1 fs--1 text-secondary">${i18n.message_AllowedTypes}${data.AllowedTypes}</div>
            <div class="px-1 fs--1 text-secondary">${i18n.message_MaxFileSize}${data.MaxFileSize}</div>
        `);
    };

    that.setupFileInputChange_qfile = function () {
        $("input.custom-file-input[type='file']").change(function () {
            const fileInputValue = $(this).val().split('\\').pop();

            $(this).next().text(fileInputValue);
        });
    };

    that.setMaxFileSize_qfile = function (container, data) {
        const [value, ext] = data.MaxFileSize.split(' ');
        const units = {
            Bytes: +value,
            KB: +value * 1e3,
            MB: +value * 1e6,
            GB: +value * 1e9
        };
        container.attr('data-maxfilesize', units[ext]);
    };

    that.renderQTable = function (data) {
        const container = that.createTableContainer_qtable(data);
        that.appendCommonElements_qtable(container, data);
        that.appendSortableWrapper_qtable(container, data);
        that.setColumnHeights_qtable(container, data);
        wrapper.append(container);
    }

    that.createTableContainer_qtable = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendCommonElements_qtable = function (container, data) {
        if (showOrderId) {
            container.append('<div><span class="badge">' + data.OrderId + " " + i18n.question + '</span></div>');
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append('<div class="passing__text">' + getQuestionText(data.Text) + '</div>');
        container.append(appendFiles(data.Files));
    };

    that.appendSortableWrapper_qtable = function (container, data) {
        const sortableWrapper = $('<div class="sortable-wrapper"></div>');
        sortableWrapper.append('<ul class="sortable sortable_a" id="As_' + data.QuestionId + '">');
        sortableWrapper.append('<ul class="sortable sortable_b" id="Bs_' + data.QuestionId + '">');

        container.append(sortableWrapper);

        const asContainer = container.find("ul#As_" + data.QuestionId);
        const bsContainer = container.find("ul#Bs_" + data.QuestionId);

        that.populateSortableLists_qtable(asContainer, bsContainer, data);

        bsContainer.sortable({
            placeholder: "sortable_placeholder",
            start: function (e, ui) {
                ui.placeholder.css('height', ui.item.height() + 'px');
            },
            handle: ".sortable_handle_wrapper"
        }).disableSelection();
    };

    that.populateSortableLists_qtable = function (asContainer, bsContainer, data) {
        for (let i = 0; i < data.AnswerOptionsAs.length; i++) {
            asContainer.append('<li data-aoptionid="' + data.AnswerOptionsAs[i].AnswerOptionId + '"><div>' + (data.AnswerOptionsAs[i].Text || "") + appendFiles(data.AnswerOptionsAs[i].Files) + '</div></li>');
            bsContainer.append('<li data-boptionid="' + data.AnswerOptionsBs[i].AnswerOptionId + '"><div class="sortable_handle_wrapper"><div class="sortable_handle">' +
                '<span class="fas fa-arrows-alt-v"></span></div>' + (data.AnswerOptionsBs[i].Text || "") + '</div></li>');
        }
    };

    that.setColumnHeights_qtable = function (container, data) {
        const asContainer = container.find("ul#As_" + data.QuestionId);
        const bsContainer = container.find("ul#Bs_" + data.QuestionId);

        let maxHeight = that.calculateMaxHeight_qtable(asContainer, bsContainer, data);

        for (let i = 0; i < data.AnswerOptionsAs.length; i++) {
            asContainer.find('li[data-aoptionid="' + data.AnswerOptionsAs[i].AnswerOptionId + '"]').css('height', maxHeight + 'px');
            bsContainer.find('li[data-boptionid="' + data.AnswerOptionsBs[i].AnswerOptionId + '"]').css('height', maxHeight + 'px');
        }
    };

    that.calculateMaxHeight_qtable = function (asContainer, bsContainer, data) {
        let maxHeight = 0;

        for (let i = 0; i < data.AnswerOptionsAs.length; i++) {
            const asContainerNode = asContainer.find('li[data-aoptionid="' + data.AnswerOptionsAs[i].AnswerOptionId + '"]').find('p');
            const bsContainerNode = bsContainer.find('li[data-boptionid="' + data.AnswerOptionsBs[i].AnswerOptionId + '"]').find('p');

            const height1 = asContainerNode.length ? asContainerNode.css('height') : "50px";
            const height2 = bsContainerNode.length ? bsContainerNode.css('height') : "50px";

            maxHeight = Math.max(maxHeight, parseInt(height1), parseInt(height2));
        }

        return maxHeight;
    };

    that.renderQMatrix = function (data) {
        const container = that.createMatrixContainer_qmatrix(data);
        that.appendCommonElements_qmatrix(container, data);
        that.appendMatrixTable_qmatrix(container, data);
        that.setGivenAnswers_qmatrix(container, data);
        wrapper.append(container);
    };

    that.createMatrixContainer_qmatrix = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendCommonElements_qmatrix = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendMatrixTable_qmatrix = function (container, data) {
        const recordsContainer = $('<div class="records"></div>');
        container.append(recordsContainer);

        let table = `<div class="mainTable matrix-table" id="${data.QuestionId}">`;
        table += that.createTableHeader_qmatrix(data);
        table += that.createTableRows_qmatrix(data);
        table += '</div>';

        recordsContainer.append(table + '<div class="record_editor"></div>');
    };

    that.createTableHeader_qmatrix = function (data) {
        let header = '<div class="headString"><div class="firstPoint"></div>';
        data.AnswerOptions.forEach(option => {
            header += `<div class="point">${getQuestionText(option.Text)}</div>`;
        });
        header += '</div>';
        return header;
    };

    that.createTableRows_qmatrix = function (data) {
        let rows = '';
        data.ExtendedQuestions.forEach(question => {
            rows += `<div class="extended_question_wrapper" data-extendedquestionid="${question.ExtendedQuestionId}" data-questiontype="${data.Type}">`;
            rows += `<div>${getQuestionText(question.Text)}</div>`;
            data.AnswerOptions.forEach(option => {
                rows += `<div class="position-relative">`;
                rows += `<div><label class="stretched-link cursor-pointer mb-0"><input class="" type="radio" name="${question.ExtendedQuestionId}" data-answeroptionid="${option.AnswerOptionId}"></label></div>`;
                rows += '</div>';
            });
            rows += '</div>';
        });
        return rows;
    };

    that.setGivenAnswers_qmatrix = function (container, data) {
        data.Answers.forEach(answer => {
            $(`input[name=${answer.ExtendedQuestionId}][data-answeroptionid=${answer.AnswerOptionId}]`, container)[0].checked = true;
        });
    };

    this.renderQAutocomplete = function (data) {
        var container = $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });

        if (showOrderId) {
            container.append($('<div>').append($('<span>', { class: 'badge', text: data.OrderId + " " + i18n.question })));
        }

        if (data.IsRequired) {
            container.attr('data-isrequired', data.IsRequired)
                .append($('<span>', { class: 'passing__asterisk', text: '*' }));
        }

        container.append($('<div>', { class: 'passing__text', html: getQuestionText(data.Text) }))
            .append(appendFiles(data.Files))
            .append($('<input>', {
                class: 'form-control',
                type: 'text',
                'data-AllowUserOption': data.AllowUserOption,
                placeholder: i18n.placeholder_EnterAnswer,
                name: data.QuestionId
            }));

        var $input = container.find('input[name="' + data.QuestionId + '"]');

        $input.autocomplete({
            minLength: 0,
            source: data.Options,
            change: !data.AllowUserOption ? function (event, ui) {
                if (!ui.item && !$(this).autocomplete("option").source.includes($(this).val())) {
                    $(this).val("");
                }
            } : null
        }).click(function (e) {
            $(this).autocomplete("search", "");
        });

        if (data.GivenAnswerValue) {
            $input.val(data.GivenAnswerValue);
        }

        wrapper.append(container);
    };

    that.renderQSpreadsheet = function (data) {
        var container = that.createContainer_qspreadsheet(data);
        that.appendCommonElements_qspreadsheet(container, data);
        that.appendSpreadsheetElement_qspreadsheet(container, data);
        wrapper.append(container);
        that.setGivenAnswer_qspreadsheet(container, data);
        setTimeout(() => {
            window.scroll(0, 0);
        }, 100);
    };

    that.appendCommonElements_qspreadsheet = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.createContainer_qspreadsheet = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendSpreadsheetElement_qspreadsheet = function (container, data) {
        container.append(`<div id="spreadSheet_${data.QuestionId}" name="${data.QuestionId}" class="w-100"></div>`);
        if (!data.SpreadsheetConfigurationJson) {
            container.append(`<script>
                var spreadsheet = ($("#spreadSheet_${data.QuestionId}").kendoSpreadsheet().data("kendoSpreadsheet"));
            </script>`);
            return;
        }
        const spreadsheetConfig = JSON.parse(data.SpreadsheetConfigurationJson);
        const sheets = spreadsheetConfig.sheets;
        const activeSheet = spreadsheetConfig.activeSheet;
        let tabsTemplate = '';

        sheets.forEach(item => {
            const name = item.name;
            const activeClass = name === activeSheet ? 'k-active' : '';
            const htmlName = escapeHtml(name);

            tabsTemplate += `<li class="k-item k-tabstrip-item sheet-tab-element ${activeClass}" data-questionid="${data.QuestionId}" data-sheetname="${htmlName}" role="tab"><span class="k-link" title="${htmlName}">${name}</span></li>`;
        });

        const customSheetsBar = `<div class="k-spreadsheet-sheets-bar k-widget k-header px-0 border-top-0" data-role="sheetsbar">
          <div class="k-spreadsheet-sheets-items k-tabstrip-scrollable k-tabstrip k-floatwrap k-tabstrip-bottom">
              <div class="k-tabstrip-items-wrapper k-hstack">
                <ul class="k-reset k-tabstrip-items overflow-auto" role="tablist">${tabsTemplate}</ul>
              </div>
          </div>
        </div>`;

        container.append(customSheetsBar);

        container.append(`<script>
            var spreadsheet = ($("#spreadSheet_${data.QuestionId}").kendoSpreadsheet({
                rows: ${data.SpreadsheetRowsCount}, 
                columns: ${data.SpreadsheetColumnsCount},
                contextMenu: false,
                toolbar: {
                    file: false,
                    home: [
                        {
                            type: "button",
                            text: "Во весь экран",
                            togglable: true,
                            icon: "border-radius",
                            click: function () {
                                if (document.fullscreenElement) {
                                    document.exitFullscreen();
                                } else {
                                    $("#spreadSheet_${data.QuestionId}").get(0).requestFullscreen();
                                }
                            }
                        },
                        "undo",
                        "redo",
                        "exportAs", 
                        ["cut", "copy", "paste"]
                    ],
                    insert: false,
                    format: false,
                    data: false,
                    view: false,
                },
                sheetsbar: false,
                insertSheet: function(e){
                  e.preventDefault();
                },
                removeSheet: function(e){
                  e.preventDefault();
                }
            }).data("kendoSpreadsheet"));
            spreadsheet.fromJSON(${data.SpreadsheetConfigurationJson});
            var analyticCells = "${data.SpreadsheetAnaliticsCells}".split("|");
            spreadsheet.cellContextMenu.destroy();
            spreadsheet.colHeaderContextMenu.destroy();
            spreadsheet.rowHeaderContextMenu.destroy();

            $("body").on("click", ".sheet-tab-element", function (e) {
                var questionId = $(e.currentTarget).data("questionid");
                var sheetName = $(e.currentTarget).data("sheetname");

                var spreadsheet = $("#spreadSheet_" + questionId).data("kendoSpreadsheet");
                
                if (spreadsheet) {
                    var sheet = spreadsheet.sheets().find((item)=> item._sheetName == sheetName);
                    spreadsheet.activeSheet(sheet);

                    $("[data-questionid='" + questionId + "']").find(".sheet-tab-element").removeClass("k-active");
                    $(e.currentTarget).addClass("k-active");
                }
            });
        </script>`);
    };

    that.setGivenAnswer_qspreadsheet = function (container, data) {
        if (data.GivenAnswerValue) {
            var spreadsheet = $(`#spreadSheet_${data.QuestionId}`).data("kendoSpreadsheet");
            spreadsheet.fromJSON(JSON.parse(data.GivenAnswerValue));
        }
    };

    that.renderQDaDataInput = function (data) {
        var container = that.createContainer_qdadatainput(data);
        that.appendCommonElements_qinput(container, data);
        that.appendInputElement_qdadatainput(container, data);
        that.setGivenAnswer_qinput(container, data);
        wrapper.append(container);
    }

    that.appendInputElement_qdadatainput = function (container, data) {
        let placeholder;
        switch (data.DaDataInputType) {
            case "addressClean":
                placeholder = i18n.placeholder_DaDataAddress_Standardization;
                break;
            case "addressSuggest":
                placeholder = i18n.placeholder_DaDataAddress_Hints;
                break;
            case "addressGeocoding":
                placeholder = i18n.placeholder_DaDataAddress_Geocoding;
                break;
            case "addressReverseGeocoding":
                placeholder = i18n.placeholder_DaDataAddress_ReverseGeocoding;
                break;
            case "addressIplocate":
                placeholder = i18n.placeholder_DaDataAddress_CityByIPAddress;
                break;
            case "addressByCode":
                placeholder = i18n.placeholder_DaDataAddress_ByCode;
                break;
            case "addressCadastralNumber":
                placeholder = i18n.placeholder_DaDataAddress_CadastralNumber;
                break;
            case "addressPostalUnit":
                placeholder = i18n.placeholder_DaDataAddress_NearestPostOffice;
                break;
            case "addressFindDelivery":
                placeholder = i18n.placeholder_DaDataAddress_CityInDeliveryService;
                break;
            case "addressCountries":
                placeholder = i18n.placeholder_DaDataAddress_Countries;
                break;
            case "partyByINN":
                placeholder = i18n.placeholder_DaDataCompanie_OrganizationByINN;
                break;
            case "partySuggest":
                placeholder = i18n.placeholder_DaDataCompanie_Hints;
                break;
            case "partyAffiliated":
                placeholder = i18n.placeholder_DaDataCompanie_AffiliatedCompanies;
                break;
            case "partyByEmail":
                placeholder = i18n.placeholder_DaDataCompanie_partyByEmail;
                break;
            case "companieSelfEmployedByINN":
                placeholder = i18n.placeholder_DaDataCompanie_SelfEmployedByINN;
                break;
            case "partyBy":
                placeholder = i18n.placeholder_DaDataCompanie_BelarusCompanies;
                break;
            case "partyKz":
                placeholder = i18n.placeholder_DaDataCompanie_KazahstanCompanies;
                break;
            case "bankById":
                placeholder = i18n.placeholder_DaDataBank_ByIdentifier;
                break;
            case "bankSuggest":
                placeholder = i18n.placeholder_DaDataBank_Hints;
                break;
            case "fullNameClean":
                placeholder = i18n.placeholder_DaDataFullName_Standardization;
                break;
            case "fullNameSuggest":
                placeholder = i18n.placeholder_DaDataFullName_Hints;
                break;
            case "phoneNumberClean":
                placeholder = i18n.placeholder_DaDataPhoneNumber_Check;
                break;
            case "passportClean":
                placeholder = i18n.placeholder_DaDataPassport_MVDRegistryCheck;
                break;
            case "passportFmsUnit":
                placeholder = i18n.placeholder_DaDataPassport_Issuer;
                break;
            case "emailClean":
                placeholder = i18n.placeholder_DaDataEmail_Check;
                break;
            case "emailSuggest":
                placeholder = i18n.placeholder_DaDataEmail_Hints;
                break;
            case "vehicleClean":
                placeholder = i18n.placeholder_DaDataAutomobile_Check;
                break;
            case "vehicleBrands":
                placeholder = i18n.placeholder_DaDataAutomobile_Brands;
                break;
            case "fnsUnit":
                placeholder = i18n.placeholder_EnterfnsUnit;
                break;
            case "custom":
                placeholder = i18n.placeholder_EnterCustom;
                break;
            case "magistrateCourt":
                placeholder = i18n.placeholder_EnterMagistrateCourt;
                break;
            case "subwayStation":
                placeholder = i18n.placeholder_EnterSubwayStation;
                break;
            case "mktu":
                placeholder = i18n.placeholder_EnterGoodsAndServices;
                break;
            case "currency":
                placeholder = i18n.placeholder_EnterCurrency;
                break;
            case "okved2":
                placeholder = i18n.placeholder_EnterTypesEconomicActivityClassifier;
                break;
            case "okpd2":
                placeholder = i18n.placeholder_EnterProductsEconomicActivityClassifier;
                break;
            case "oktmo":
                placeholder = i18n.placeholder_EnterMunicipalitiesClassifier;
                break;
        }
        container.append(`<input class="form-control" id="DaDataInput_${data.QuestionId}" placeholder="${placeholder}" type="text" name="${data.QuestionId}" /><div style="height:8px"><span class="invalid_text"></span></div>`);
        container.append(`<script>
            $("#DaDataInput_${data.QuestionId}").kendoAutoComplete({
                autoBind: false,
                ignoreCase: true,
                delay: 500,
                filter: "contains",
                noDataTemplate: "Ничего не найдено",
                dataTextField: "Suggestion",
                filtering: function (e) {
                    var filter = e.filter.value;
                    if (filter) {
                        this.options.dataSource.transport.read.url = "/api/dadataSuggestions/getsuggestions?questionId=${data.QuestionId}&input=" + encodeURIComponent(filter);
                        this.dataSource.read();
                    }
                },
                dataSource: {
                    serverFiltering: true,
                    transport: {
                        read: {
                            url: "/api/dadataSuggestions/getsuggestions",
                            dataType: "json"
                        },
                    },
                    schema: {
                        data: function (response) {
                            return response;
                        },
                        model: {
                            fields: {
                                Suggestion: { type: "string" },
                                JsonSuggestion: { type: "string" }
                            }
                        }
                    }
                }
            }).data("kendoAutoComplete");
        </script>`);
    };

    that.createContainer_qdadatainput = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId,
            'data-dadatainputtype': data.DaDataInputType
        });
    };

    that.renderQInput = function (data) {
        var container = that.createContainer_qinput(data);
        that.appendCommonElements_qinput(container, data);
        that.appendInputElement_qinput(container, data);
        that.setGivenAnswer_qinput(container, data);
        wrapper.append(container);
        that.setupSpecialInputs_qinput(container, data);
    };

    that.createContainer_qinput = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId,
            'data-inputtype': data.InputType
        });
    };

    that.appendCommonElements_qinput = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendInputElement_qinput = function (container, data) {
        switch (data.InputType) {
            case "inputMask":
            case "input":
                container.append(`<input class="form-control" placeholder="${i18n.placeholder_EnterAnswer}" type="text" name="${data.QuestionId}" /><div style="height:8px"><span class="invalid_text"></span></div>`);
                break;
            case "textarea":
                container.append(`<textarea class="form-control" placeholder="${i18n.placeholder_EnterAnswer}" name="${data.QuestionId}"></textarea>`);
                break;
            case "number":
                container.append(`<input class="form-control numberinput" placeholder="${i18n.placeholder_EnterNumber}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "ipv4":
                container.append(`<input class="form-control IPv4" placeholder="${i18n.placeholder_EnterIPV4}" maxlenth="15" size="15" type="text" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                container.append(`<script>$("input[name='${data.QuestionId}']").mask("0ZZ.0ZZ.0ZZ.0ZZ", { translation: { "Z": { pattern: /[0-9]/, optional: true } } });</script>`);
                break;
            case "ipv6":
                container.append(`<input class="form-control IPv6" placeholder="${i18n.placeholder_EnterIPV6}" type="text" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                container.append(`<script>$("input[name='${data.QuestionId}']").mask("ZZZZ:ZZZZ:ZZZZ:ZZZZ:ZZZZ:ZZZZ:ZZZZ:ZZZZ", { translation: { "Z": { pattern: /[a-fA-F0-9]/, optional: true } } });</script>`);
                break;
            case "lesszero":
                container.append(`<input class="form-control lessZero" type="number" placeholder="${i18n.placeholder_EnterLessThenZero}" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                break;
            case "lesszeroWithZero":
                container.append(`<input class="form-control lessZeroWithZero" type="number" placeholder="${i18n.placeholder_EnterLessThenZeroWithZero}" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                break;
            case "intlesszero":
                container.append(`<input class="form-control lessZeroInt" type="number" placeholder="${i18n.placeholder_EnterIntLessThenZero}" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                break;
            case "intlesszeroWithZero":
                container.append(`<input class="form-control lessZeroWithZeroInt" type="number" placeholder="${i18n.placeholder_EnterIntLessZeroWithZero}" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                break;
            case "morezero":
                container.append(`<input class="form-control moreZero" placeholder="${i18n.placeholder_EnterMoreThenZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "intmorezero":
                container.append(`<input class="form-control moreZeroInt" placeholder="${i18n.placeholder_EnterIntMoreThenZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "morezeroWithZero":
                container.append(`<input class="form-control moreZeroWithZero" placeholder="${i18n.placeholder_EnterMoreZeroWithZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "intmorezeroWithZero":
                container.append(`<input class="form-control moreZeroWithZeroInt" placeholder="${i18n.placeholder_EnterIntMoreZeroWithZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "numberRange":
                container.append(`<input class="form-control numberRange" placeholder="${i18n.placeholder_NumberRange} ${data.From} - ${data.To}" type="number" data-from="${data.From}" data-to="${data.To}" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "intRange":
                container.append(`<input class="form-control intRange" placeholder="${i18n.placeholder_IntRange} ${data.From} - ${data.To}" type="number" data-from="${data.From}" data-to="${data.To}" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "withoutzero":
                container.append(`<input class="form-control withOutZero" placeholder="${i18n.placeholder_EnterExceptZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "intwithoutzero":
                container.append(`<input class="form-control withOutZeroInt" placeholder="${i18n.placeholder_EnterIntWithOutZero}" type="number" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "OnlyInt":
                container.append(`<input class="form-control onlyInt" placeholder="${i18n.placeholder_EnterOnlyInt}" type="number" name="${data.QuestionId}"/><span class="invalid_text"></span>`);
                break;
            case "numberOfThePhone":
                that.appendPhoneInput_qinput(container, data);
                break;
            case "url":
                container.append(`<input class="form-control URL" placeholder="${i18n.placeholder_EnterURL}" type="url" name="${data.QuestionId}" /><span class="invalid_text"></span>`);
                break;
            case "ISBN":
                that.appendISBNInput_qinput(container, data);
                break;
            case "numberCreditCard":
                that.appendCreditCardInput_qinput(container, data);
                break;
            case "email":
                container.append(`<input class="form-control emailinput" placeholder="${i18n.placeholder_EnterEmail}" type="email" name="${data.QuestionId}" /><div style="height:8px"><span class="invalid_text"></span></div>`);
                break;
        }
    };

    that.setGivenAnswer_qinput = function (container, data) {
        if (data.GivenAnswerValue) {
            if (data.InputType === "textarea") {
                container.find(`textarea[name="${data.QuestionId}"]`).val(data.GivenAnswerValue);
            } else {
                container.find(`input[name="${data.QuestionId}"]`).val(data.GivenAnswerValue);
            }
        }
    };

    that.setupSpecialInputs_qinput = function (container, data) {
        if (data.InputType === "inputMask") {
            $(document).ready(function () {
                let input = container.find(`input[name="${data.QuestionId}"]`);
                input.kendoMaskedTextBox({
                    mask: data.InputMask,
                    clearPromptChar: true
                });
            });
        }

        $('input[type="number"]').on("keydown", function (e) {
            if ('e' === e.key || 'E' === e.key) {
                e.preventDefault();
            }
        });
    };

    that.appendPhoneInput_qinput = function (container, data) {
        const phoneId = data.QuestionId.replace(/-/g, '');
        const phoneValue = data.GivenAnswerValue ? (data.GivenAnswerValue.startsWith('8') ? "+7" + data.GivenAnswerValue.substring(1) : data.GivenAnswerValue.replace(/ /g, '')) : "+7";

        container.append(`
            <input class="form-control PhoneNumber" type="tel" value="${phoneValue}" id="Phone${phoneId}" name="${data.QuestionId}" />
            <span class="invalid_text"></span>
            <span id="valid-msg${phoneId}" class="d-none ml-1 text-success fs--1">${i18n.iti_valid}</span>
            <span id="error-msg${phoneId}" class="d-none ml-1 text-danger fs--1"></span>
        `);

        that.appendPhoneScript_qinput(container, data, phoneId);
    };

    that.appendPhoneScript_qinput = function (container, data, phoneId) {
        const errorMap = [i18n.iti_invalidnum, i18n.iti_invalidcountry, i18n.iti_tooshort, i18n.iti_toolong, i18n.iti_invalidnum];
        container.append(`
            <script>
                var errorMap${phoneId} = ${JSON.stringify(errorMap)};

                var input${phoneId} = document.querySelector("#Phone${phoneId}");
                var errorMsg${phoneId} = document.querySelector("#error-msg${phoneId}");
                var validMsg${phoneId} = document.querySelector("#valid-msg${phoneId}");
                var iti${phoneId} = window.intlTelInput(input${phoneId}, {
                    placeholderNumberType: "MOBILE",
                    preferredCountries: ["ru", "us", "gb"],
                    dropdownContainer: document.body,
                    formatOnDisplay: true,
                    autoFormat: true,
                    utilsScript: "~/static/js/utils.js"
                });

                var reset = function() {
                    input${phoneId}.classList.remove("error");
                    errorMsg${phoneId}.innerHTML = "";
                    errorMsg${phoneId}.classList.add("d-none");
                    validMsg${phoneId}.classList.add("d-none");
                };

                // Ограничение ввода: цифры, "+", "(", ")", "-", пробелы
                input${phoneId}.addEventListener("input", function (e) {
                    var value = e.target.value;
                    // Разрешаем цифры, "+", "(", ")", "-", пробелы
                    var cleanValue = value.replace(/[^0-9+()\\- ]/g, '');
                    // Убедимся, что "+" может быть только в начале
                    if (cleanValue.indexOf('+') !== 0 && cleanValue.includes('+')) {
                        cleanValue = cleanValue.replace(/\\+/g, '');
                    }
                    if (value !== cleanValue) {
                        e.target.value = cleanValue;
                    }
                });

                input${phoneId}.addEventListener("blur", function() {
                    var container = $(this).closest("div.question_wrapper");
                    reset();
                    var rawValue = input${phoneId}.value.trim();
                    // Очищаем номер от пробелов, скобок, дефисов для валидации
                    var cleanValue = rawValue.replace(/[\\s()-]/g, '');
                    // Заменяем начальную "8" на "+7" для российских номеров
                    if (cleanValue.startsWith('8') && iti${phoneId}.getSelectedCountryData().iso2 === 'ru') {
                        cleanValue = '+7' + cleanValue.substring(1);
                        input${phoneId}.value = cleanValue; // Обновляем значение в поле
                    }
                    var pattern = /^\\+?\\d{10,14}$/;
                
                    if ($(container).attr("data-isrequired") == "true") {
                        if (cleanValue) {
                            if (iti${phoneId}.isValidNumber() && pattern.test(cleanValue)) {
                                container.removeAttr("invalid");
                                container.find(".invalid_text").html("");
                                container.removeClass("required");
                                validMsg${phoneId}.classList.remove("d-none");
                                // Сохраняем очищенный номер в поле для отправки
                                input${phoneId}.value = cleanValue;
                            } else {
                                input${phoneId}.classList.add("error");
                                var errorCode = iti${phoneId}.getValidationError();
                                errorMsg${phoneId}.innerHTML = errorMap${phoneId}[errorCode] || i18n.iti_invalidnum;
                                errorMsg${phoneId}.classList.remove("d-none");
                                container.addClass("required");
                                container.attr("invalid", "invalid");
                            }
                        }
                    } else {
                        if (cleanValue) {
                            if (iti${phoneId}.isValidNumber() && pattern.test(cleanValue)) {
                                container.removeAttr("invalid");
                                container.find(".invalid_text").html("");
                                container.removeClass("required");
                                validMsg${phoneId}.classList.remove("d-none");
                                // Сохраняем очищенный номер в поле для отправки
                                input${phoneId}.value = cleanValue;
                            } else {
                                input${phoneId}.classList.add("error");
                                var errorCode = iti${phoneId}.getValidationError();
                                errorMsg${phoneId}.innerHTML = errorMap${phoneId}[errorCode] || i18n.iti_invalidnum;
                                errorMsg${phoneId}.classList.remove("d-none");
                                container.addClass("required");
                                container.attr("invalid", "invalid");
                            }
                        }
                    }
                });

                input${phoneId}.addEventListener("change", reset);
                input${phoneId}.addEventListener("keyup", reset);
            </script>
        `);
    };

    that.appendISBNInput_qinput = function (container, data) {
        container.append(`
            <input class="form-control ISBN" id="isbn-${data.QuestionId}" placeholder="${i18n.placeholder_EnterISBN}" type="text" name="${data.QuestionId}" />
            <span class="invalid_text"></span>
            <script>
                $(document).ready(function(){
                    $("#isbn-${data.QuestionId}").kendoMaskedTextBox({mask: "000-0-00000-000-0"});
                });
            </script>
        `);
    };

    that.appendCreditCardInput_qinput = function (container, data) {
        container.append(`
            <input class="form-control CreditCard" placeholder="${i18n.placeholder_EnterNumberCreditCard}" id="creditcard-${data.QuestionId}" type="text" name="${data.QuestionId}" />
            <span class="invalid_text"></span>
            <script>
                $(document).ready(function(){
                    $("#creditcard-${data.QuestionId}").kendoMaskedTextBox({mask: "0000-0000-0000-0000"});
                });
            </script>
        `);
    };

    that.renderQDropdown = function (data) {
        const container = that.createDropdownContainer_qdropdown(data);
        that.appendCommonElements_qdropdown(container, data);
        that.appendDropdownElements_qdropdown(container, data);
        that.setGivenAnswer_qdropdown(container, data);
        wrapper.append(container);
    };

    that.createDropdownContainer_qdropdown = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId
        });
    };

    that.appendCommonElements_qdropdown = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendDropdownElements_qdropdown = function (container, data) {
        const select = $('<select>', {
            id: 'run-select',
            class: 'form-control',
            name: data.QuestionId
        });

        data.Options.forEach(option => {
            select.append($('<option>', {
                value: option.Value || "",
                text: option.Text || ""
            }));
        });



        container.append($('<div>').append(select));
        $(document).find(`select[name="${data.QuestionId}"]`).kendoDropDownList();
        if (data.AllowUserOption) {
            that.appendUserOption_qdropdown(select, container, data);
        }
    };

    that.appendUserOption_qdropdown = function (select, container, data) {
        select.append($('<option>', {
            value: "useroption",
            text: i18n.selectoption_YourOption
        }));

        container.append($('<label>', {
            class: 'mt-3',
            for: `useroptionId_${data.QuestionId}`,
            text: i18n.label_YourOption
        }));

        container.append($('<input>', {
            class: 'form-control',
            type: 'text',
            id: `useroptionId_${data.QuestionId}`,
            name: data.QuestionId,
            readonly: 'readonly',
            'data-useroption': 'useroption'
        }));
    };

    that.setGivenAnswer_qdropdown = function (container, data) {
        if (data.GivenAnswerId) {
            container.find(`select[name="${data.QuestionId}"] option[value="${data.GivenAnswerId}"]`).attr("selected", "selected");
        }

        if (data.AllowUserOption && data.GivenAnswerValue) {
            container.find(`select[name="${data.QuestionId}"] option[value="useroption"]`).attr("selected", "selected");
            const userOptionInput = container.find('input[data-useroption="useroption"]');
            userOptionInput.val(data.GivenAnswerValue);
            userOptionInput.removeAttr('readonly');
        }
    };

    that.renderQNps = function (data) {
        const container = that.createQuestionContainer_qnps(data);
        that.appendCommonElements_qnps(container, data);
        that.appendNpsElements_qnps(container, data);
        that.setGivenAnswer_qnps(container, data);
        wrapper.append(container);
    };

    that.createQuestionContainer_qnps = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId || 0
        });
    };

    that.appendCommonElements_qnps = function (container, data) {
        if (showOrderId) {
            container.append(`<div><span class="badge">${data.OrderId} ${i18n.question}</span></div>`);
        }

        if (data.IsRequired) {
            container.attr("data-isrequired", data.IsRequired);
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append(`<div class="passing__text">${getQuestionText(data.Text)}</div>`);
        container.append(appendFiles(data.Files));
    };

    that.appendNpsElements_qnps = function (container, data) {
        const npsWrapper = $('<div>', {
            class: 'nps_wrapper',
            id: `nps_${data.QuestionId}`
        });

        for (let i = 0; i < 11; i++) {
            npsWrapper.append(that.createNpsOption_qnps(data, i));
        }

        container.append(npsWrapper);
        that.appendScaleTextWrapper_qnps(container, data);
    };

    that.createNpsOption_qnps = function (data, value) {
        return $('<span>', {
            class: 'nps_option btn btn-sm btn-sm--square btn--run-default',
            'data-answeroptionid': data.AnswerOptionId,
            'data-optionvalue': value,
            name: data.QuestionId
        }).append($('<span>', {
            class: 'nps-value',
            text: value
        }));
    };

    that.appendScaleTextWrapper_qnps = function (container, data) {
        const scaleTextWrapper = $('<div>', {
            class: 'scale_text_wrapper',
            id: `wrapper_${data.QuestionId}`
        });

        const scaleTextTemplate = `
            <div class="scale_min_text">${data.MinText || ''}</div>
            <div class="scale_max_text">${data.MaxText || ''}</div>
        `;

        scaleTextWrapper.append(scaleTextTemplate);
        container.append(scaleTextWrapper);
    };

    that.setGivenAnswer_qnps = function (container, data) {
        if (data.GivenAnswerValue) {
            const answer = container.find(`.nps_option[data-optionvalue="${data.GivenAnswerValue}"]`);
            answer.addClass('nps-selected btn--run-primary selected');
        }
    };

    that.renderQRating = function (data) {
        const container = that.createQuestionContainer_qrating(data);
        that.appendCommonElements(container, data);
        that.appendRatingElements_qrating(container, data);
        that.setGivenAnswer_qrating(container, data);
        wrapper.append(container);
    };

    that.createQuestionContainer_qrating = function (data) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId || 0
        });
    };

    that.appendRatingElements_qrating = function (container, data) {
        const ratingWrapper = $('<div>', {
            class: 'rating_wrapper',
            id: `rating_${data.QuestionId}`
        });

        for (let i = 1; i <= data.MaxValue; i++) {
            ratingWrapper.append(that.createRatingOption_qrating(data, i));
        }

        container.append(ratingWrapper);
        that.appendScaleTextWrapper_qrating(container, data);
    };

    that.createRatingOption_qrating = function (data, value) {
        return $('<div>', {
            class: 'rating_option mx-1',
            name: data.QuestionId,
            'data-optionvalue': value,
            'data-skin': data.Skin
        }).append($('<span>', {
            class: `fs-3 fas fa-${data.Skin}`
        }));
    };

    that.appendScaleTextWrapper_qrating = function (container, data) {
        const scaleTextWrapper = $('<div>', {
            class: 'scale_text_wrapper',
            id: `wrapper_${data.QuestionId}`
        });

        scaleTextWrapper.append(
            $('<div>', { class: 'scale_min_text', text: data.MinText || '' }),
            $('<div>', { class: 'scale_max_text', text: data.MaxText || '' })
        );

        container.append(scaleTextWrapper);
    };

    that.setGivenAnswer_qrating = function (container, data) {
        if (data.GivenAnswerValue) {
            const answer = container.find(`.rating_option[data-optionvalue="${data.GivenAnswerValue}"]`);
            answer.addClass('rating-selected');

            const selectedValue = parseFloat(data.GivenAnswerValue);
            container.find('.rating_option').each(function () {
                if ($(that).data('optionvalue') < selectedValue) {
                    $(that).addClass('visible-rating-selected');
                }
            });
        }

        container.find('.rating_option').slice(0, parseFloat(data.MinValue)).addClass('previously_selected');
        container.find('.previously_selected').last().addClass('rating-selected');
        container.find('.rating_option').slice(0, parseFloat(data.MinValue) - 1).addClass('less-min-value');
    };


    that.renderQScale = function (data) {
        that.renderScale(data, 'Q');
    };
    that.renderQScaleWithTwoSliders = function (data) {
        var container = that.createScaleContainer(data, 'Q');
        that.appendCommonElements(container, data);
        that.appendTwoSliderElements(container, data);
        wrapper.append(container);
        that.initializeTwoSliders(container, data);
    };


    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    that.renderTSingle = function (data) {
        const container = that.createQuestionContainer(data, 'radio');
        that.appendCommonElements(container, data);
        that.appendOptionsContainer(container, data, 'radio');
        wrapper.append(container);
    };

    that.renderTMulty = function (data) {
        const container = that.createQuestionContainer(data, 'checkbox');
        that.appendCommonElements(container, data);
        that.appendOptionsContainer(container, data, 'checkbox');
        wrapper.append(container);
    };

    that.renderTTable = function (data) {
        const container = that.createQuestionContainer(data);
        that.appendCommonElements(container, data);
        that.appendSortableTable(container, data);
        wrapper.append(container);
    };

    that.renderTOpen = function (data) {
        const container = that.createQuestionContainer(data);
        that.appendCommonElements(container, data);
        that.appendTextArea(container, data);
        wrapper.append(container);
    };

    that.renderTScale = function (data) {
        that.renderScale(data, 'T');
    };
    // Helper methods
    that.createQuestionContainer = function (data, inputType) {
        const container = $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-isrequired': data.IsRequired,
            'data-respondentanswerid': data.RespondentAnswerId
        });

        if (data.IsUndefined) {
            container.attr('data-isundefined', 'true');
        }

        if (inputType) {
            container.attr('data-inputtype', inputType);
        }

        return container;
    };

    that.appendCommonElements = function (container, data) {
        if (showOrderId) {
            container.append($('<div>').append($('<span>', {
                class: 'badge',
                text: `${data.OrderId} ${i18n.question}`
            })));
        }

        if (data.IsRequired) {
            container.append($('<span>', { class: 'passing__asterisk', text: '*' }));
        }

        container.append($('<div>', {
            class: 'passing__text',
            html: getQuestionText(data.Text)
        }));

        container.append(appendFiles(data.Files));
    };

    that.appendOptionsContainer = function (container, data, inputType) {
        const optionsContainer = $('<div>', { class: 'options_container' });

        data.AnswerOptions.forEach(option => {
            const optionWrapper = $('<div>', {
                class: `custom-control custom-${inputType} answer_option_wrapper answer_option_wrapper_${option.AnswerOptionId}`
            });

            optionWrapper.append(
                $(`<input>`, {
                    class: 'custom-control-input',
                    id: option.AnswerOptionId,
                    type: inputType,
                    name: data.QuestionId,
                    'data-answeroptionid': option.AnswerOptionId
                }),
                $('<label>', {
                    class: 'custom-control-label',
                    for: option.AnswerOptionId,
                    html: (option.Text || "") + appendFiles(option.Files)
                }),
                $('<div>', { class: 'message' })
            );

            optionsContainer.append(optionWrapper);
        });

        that.setGivenAnswers(optionsContainer, data, inputType);

        container.append(optionsContainer);
    };

    that.setGivenAnswers = function (optionsContainer, data, inputType) {
        if (inputType === 'radio' && data.GivenAnswerId) {
            optionsContainer.find(`input[data-answeroptionid="${data.GivenAnswerId}"]`).prop('checked', true);
        } else if (inputType === 'checkbox' && data.GivenAnswerIds) {
            data.GivenAnswerIds.split(",").forEach(givenAnswerId => {
                optionsContainer.find(`input[data-answeroptionid="${givenAnswerId}"]`).prop('checked', true);
            });
        }
    };

    that.appendSortableTable = function (container, data) {
        const sortableWrapper = $('<div>', { class: 'sortable-wrapper' });
        const asContainer = $('<ul>', { class: 'sortable sortable_a', id: `As_${data.QuestionId}` });
        const bsContainer = $('<ul>', { class: 'sortable sortable_b', id: `Bs_${data.QuestionId}` });

        sortableWrapper.append(asContainer, bsContainer);
        container.append(sortableWrapper);

        that.populateSortableTable(asContainer, bsContainer, data);
        that.initializeSortable(bsContainer);
    };

    that.populateSortableTable = function (asContainer, bsContainer, data) {
        let maxHeight = 0;

        data.AnswerOptionsAs.forEach((optionA, index) => {
            const optionB = data.AnswerOptionsBs[index];

            const liA = $('<li>', { 'data-aoptionid': optionA.AnswerOptionId })
                .append($('<div>').html((optionA.Text || "") + appendFiles(optionA.Files)));

            const liB = $('<li>', { 'data-boptionid': optionB.AnswerOptionId })
                .append($('<div>', { class: 'sortable_handle_wrapper' })
                    .append($('<div>', { class: 'sortable_handle' })
                        .append($('<span>', { class: 'fas fa-arrows-alt-v' })))
                    .append((optionB.Text || "")));

            asContainer.append(liA, $('<div>', { class: 'message' }));
            bsContainer.append(liB);

            const height1 = liA.find('p').length ? liA.find('p').height() : 50;
            const height2 = liB.find('p').length ? liB.find('p').height() : 50;
            maxHeight = Math.max(maxHeight, height1, height2);
        });

        asContainer.find('li, .message').height(maxHeight);
        bsContainer.find('li').height(maxHeight);
    };

    that.initializeSortable = function (bsContainer) {
        bsContainer.sortable({
            placeholder: "sortable_placeholder",
            start: function (e, ui) {
                ui.placeholder.height(ui.item.height());
            },
            handle: ".sortable_handle_wrapper"
        }).disableSelection();
    };

    that.appendTextArea = function (container, data) {
        const textarea = $('<textarea>', {
            class: 'form-control',
            placeholder: i18n.placeholder_EnterAnswer,
            name: data.QuestionId
        });

        if (data.GivenAnswerValue) {
            textarea.val(data.GivenAnswerValue);
        }

        container.append(textarea, $('<div>', { class: 'message' }));
    };

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    that.createScaleContainer = function (data, type) {
        return $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type,
            'data-respondentanswerid': data.RespondentAnswerId,
            'data-isrequired': data.IsRequired
        });
    };

    that.renderScale = function (data, type) {
        var container = that.createScaleContainer(data, type);
        that.appendCommonElements(container, data);
        that.appendScaleElements(container, data);
        wrapper.append(container);
        that.initializeSlider(container, data);
    };

    that.appendCommonElements = function (container, data) {
        if (showOrderId) {
            container.append('<div><span class="badge">' + data.OrderId + " " + i18n.question + '</span></div>');
        }

        if (data.IsRequired) {
            container.append('<span class="passing__asterisk">*</span>');
        }

        container.append('<div class="passing__text">' + getQuestionText(data.Text) + '</div>');
        container.append(appendFiles(data.Files));
    };

    that.appendScaleElements = function (container, data) {
        container.append(`
            <label for='input-${data.QuestionId}'>${i18n.placeholder_EnterValue}</label>
            <input class='form-control mb-2' id='input-${data.QuestionId}' type='number' value='${data.Min}' data-type='input'/>
            <input data-type='Slider'/>
            <div class="scale_text_wrapper" id="wrapper_${data.QuestionId}">
                <div class="scale_min_text">${data.MinText || ''}</div>
                <div class="scale_max_text">${data.MaxText || ''}</div>
            </div>
        `);
    };

    that.initializeSlider = function (container, data) {
        var slider = container.find("input[data-type='Slider']").kendoSlider({
            min: data.Min,
            max: data.Max,
            smallStep: data.Step,
            largeStep: (data.Max - data.Min),
            showButtons: false,
            tickPlacement: "bottomRight",
            slide: that.onSliderChange.bind(that, data),
            change: that.onSliderChange.bind(that, data),
            tooltip: { enabled: false }
        }).data("kendoSlider");

        container.find("input[data-type='input']").on("change", that.onInputChange.bind(that, data, slider));
    };

    that.onSliderChange = function (data, e) {
        $(`div[data-questionid=${data.QuestionId}]`).find("input[data-type='input']").val(e.value);
    };

    that.onInputChange = function (data, slider) {
        var input = $(`div[data-questionid=${data.QuestionId}]`).find("input[data-type='input']");
        var value = +input.val();

        if (value <= data.Min) {
            value = data.Min;
        } else if (value >= data.Max) {
            value = data.Max;
        } else {
            value = Math.round(value / data.Step) * data.Step;
        }

        input.val(value);
        slider.value(value);
    };

    that.appendTwoSliderElements = function (container, data) {
        container.append(`
            <label for='input-${data.QuestionId}'>${i18n.placeholder_EnterValues}</label>
            <div class='range-slider mb-2'>
                <input class='form-control mr-1' id='input-${data.QuestionId}' type='number' value='${data.Min}' data-type='leftInput'/> &ndash;
                <input class='form-control ml-1' type='number' value='${data.Max}' data-type='rigtInput'/>
            </div>
            <div data-type='RangeSlider'><input data-type='Slider1'/><input data-type='Slider2'/></div>
            <div class="scale_text_wrapper" id="wrapper_${data.QuestionId}">
                <div class="scale_min_text">${data.MinText || ''}</div>
                <div class="scale_max_text">${data.MaxText || ''}</div>
            </div>
        `);
    };

    that.initializeTwoSliders = function (container, data) {
        var slider = container.find(`div[data-type='RangeSlider']`).kendoRangeSlider({
            min: data.Min,
            max: data.Max,
            smallStep: data.Step,
            largeStep: (data.Max - data.Min),
            showButtons: false,
            tickPlacement: "bottomRight",
            slide: that.onTwoSliderChange.bind(that, data),
            change: that.onTwoSliderChange.bind(that, data),
            tooltip: { enabled: false }
        }).data("kendoRangeSlider");

        container.find("input[data-type='leftInput']").on("change", that.onLeftInputChange.bind(that, data, slider));
        container.find("input[data-type='rigtInput']").on("change", that.onRightInputChange.bind(that, data, slider));
    };

    that.onTwoSliderChange = function (data, e) {
        var container = $(`div[data-questionid=${data.QuestionId}]`);
        container.find("input[data-type='leftInput']").val(e.value[0]);
        container.find("input[data-type='rigtInput']").val(e.value[1]);
    };

    that.onLeftInputChange = function (data, slider) {
        var container = $(`div[data-questionid=${data.QuestionId}]`);
        var leftInput = container.find("input[data-type='leftInput']");
        var rightInput = container.find("input[data-type='rigtInput']");
        var leftValue = that.validateInputValue(+leftInput.val(), data);
        var rightValue = +rightInput.val();

        if (leftValue > rightValue) {
            rightInput.val(leftValue);
            rightValue = leftValue;
        }

        leftInput.val(leftValue);
        slider.value([leftValue, rightValue]);
    };

    that.onRightInputChange = function (data, slider) {
        var container = $(`div[data-questionid=${data.QuestionId}]`);
        var leftInput = container.find("input[data-type='leftInput']");
        var rightInput = container.find("input[data-type='rigtInput']");
        var rightValue = that.validateInputValue(+rightInput.val(), data);
        var leftValue = +leftInput.val();

        if (rightValue < leftValue) {
            leftInput.val(rightValue);
            leftValue = rightValue;
        }

        rightInput.val(rightValue);
        slider.value([leftValue, rightValue]);
    };

    that.validateInputValue = function (value, data) {
        if (value <= data.Min) return data.Min;
        if (value >= data.Max) return data.Max;
        return Math.round(value / data.Step) * data.Step;
    };


    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    that.renderParentExtendedQuestion = function (data) {
        const container = $('<div>', {
            class: 'question_wrapper',
            'data-questionid': data.QuestionId,
            'data-questiontype': data.Type
        });

        if (showOrderId) {
            container.append($('<div>').append($('<span>', {
                class: 'badge',
                text: `${data.OrderId} ${i18n.question}`
            })));
        }

        if (data.IsRequired) {
            container.attr('data-isrequired', data.IsRequired)
                .append($('<span>', { class: 'passing__asterisk', text: '*' }));
        }

        container.append($('<div>', {
            class: 'passing__text',
            html: getQuestionText(data.Text)
        }));

        container.append(appendFiles(data.Files));

        const addRecordBtn = $('<button>', {
            class: 'btn btn-sm btn--run-default add_record mb-2',
            text: i18n.button_AddRecord
        });

        container.append(addRecordBtn);

        const recordsContainer = $('<div>', { class: 'records' });
        container.append(recordsContainer);

        const secondAddRecordBtn = addRecordBtn.clone().addClass('secon_add_record');
        secondAddRecordBtn.toggle(data.Records.length > 0);
        container.append(secondAddRecordBtn);

        if (data.Records) {
            data.Records.forEach(record => {
                const recordContainer = $('<div>', {
                    class: 'record_container',
                    'data-recordid': record.RecordId,
                    style: `order:${record.RecordId}`
                });

                recordContainer.append(
                    $('<span>', { class: 'record_name ml-3', text: record.Name || '' }),
                    $('<button>', {
                        type: 'button',
                        class: 'record_edit btn btn-sm btn-sm--square btn-primary ml-1 my-2',
                        html: '<span class="fas fa-pencil-alt"></span>'
                    }),
                    $('<button>', {
                        type: 'button',
                        class: 'record_remove btn btn-sm btn-sm--square btn-danger ml-1 my-2',
                        html: '<span class="fas fa-trash"></span>'
                    }),
                    record.GivenAnswers
                );

                recordsContainer.append(recordContainer);
            });
        }

        recordsContainer.append($('<div>', { class: 'record_editor' }));

        wrapper.append(container);
    };
    that.renderExtendedDropdown = function (wrapper, data, givenAnswer) {
        const container = that.createExtendedQuestionContainer(data, givenAnswer);
        container.append(that.createQuestionText_extended(data.Text));

        const select = $('<select>', {
            id: 'name2',
            class: 'form-control',
            name: data.ExtendedQuestionId
        });

        select.append($('<option>', { value: 'noanswer' }));
        that.appendOptionsToSelect_extended(select, data.ExtendedAnswerOptions, givenAnswer);

        container.append(select);
        wrapper.append(container);
    }

    that.renderExtendedInput = function (wrapper, data, givenAnswer) {
        const container = that.createExtendedQuestionContainer(data, givenAnswer);
        container.append(that.createQuestionText_extended(data.Text));

        const inputElement = that.createInputElement_extended(data, givenAnswer);
        container.append(inputElement);

        if (data.InputType === "number" || data.InputType === "date" || data.InputType === "email") {
            container.append($('<span>', { class: 'invalid_text' }));
        }

        wrapper.append(container);

        that.applyInputSpecificBehavior_extended(inputElement, data, givenAnswer);
    }

    that.renderExtendedMulty = function (wrapper, data, givenAnswer) {
        const container = that.createExtendedQuestionContainer(data, givenAnswer);
        container.append(that.createQuestionText_extended(data.Text));

        that.appendCheckboxOptions_extended(container, data, givenAnswer);

        wrapper.append(container);
    };

    that.renderExtendedFile = function (wrapper, data, givenAnswer) {
        const container = that.createExtendedQuestionContainer(data, givenAnswer);
        container.append(that.createQuestionText_extended(data.Text));

        const fileInput = that.createFileInput_extended(data);
        const fileLabel = that.createFileLabel_extended(data, givenAnswer);
        const fileValueSpan = that.createFileValueSpan_extended(data);

        const fileWrapper = $('<div>', { class: 'custom-file' }).append(fileInput, fileLabel, fileValueSpan);
        container.append(fileWrapper);

        if (givenAnswer) {
            container.append(that.createFileInfo_extended(givenAnswer));
        }

        container.append(that.createFileTypeInfo_extended(data));
        container.append(that.createFileSizeInfo_extended(data));

        wrapper.append(container);

        that.setupFileInputBehavior_extended(fileInput, data);
    };

    // Helper methods
    that.createExtendedQuestionContainer = function (data, givenAnswer) {
        return $('<div>', {
            class: 'extended_question_wrapper question_wrapper',
            'data-extendedquestionid': data.ExtendedQuestionId,
            'data-questiontype': data.Type,
            'data-respondentextendedanswerid': givenAnswer ? givenAnswer.RespondentExtendedAnswerId : 0,
            'data-inputtype': data.InputType
        });
    }

    that.createQuestionText_extended = function (text) {
        return $('<div>', {
            class: 'passing__text',
            html: getQuestionText(text)
        });
    }

    that.appendOptionsToSelect_extended = function (select, options, givenAnswer) {
        options.forEach(option => {
            select.append($('<option>', {
                value: option.Id || '',
                text: option.Text
            }));
        });

        if (givenAnswer) {
            select.find(`option[value="${givenAnswer.AnswerId}"]`).prop('selected', true);
        }
    }

    that.createInputElement_extended = function (data, givenAnswer) {
        let inputElement;
        switch (data.InputType) {
            case "input":
                inputElement = $('<input>', {
                    class: 'form-control',
                    placeholder: i18n.placeholder_EnterAnswer,
                    type: 'text',
                    name: data.ExtendedQuestionId
                });
                break;
            case "textarea":
                inputElement = $('<textarea>', {
                    class: 'form-control',
                    placeholder: i18n.placeholder_EnterAnswer,
                    name: data.ExtendedQuestionId
                });
                break;
            case "number":
                inputElement = $('<input>', {
                    class: 'form-control numberinput',
                    placeholder: i18n.placeholder_EnterNumber,
                    type: 'number',
                    name: data.ExtendedQuestionId
                });
                break;
            case "date":
                inputElement = $('<input>', {
                    class: 'form-control datepickerinput',
                    placeholder: i18n.placeholder_EnterDate,
                    name: data.ExtendedQuestionId
                });
                break;
            case "email":
                inputElement = $('<input>', {
                    class: 'form-control emailinput',
                    placeholder: i18n.placeholder_EnterEmail,
                    type: 'email',
                    name: data.ExtendedQuestionId
                });
                break;
        }

        if (givenAnswer) {
            inputElement.val(givenAnswer.AnswerValue);
        }

        return inputElement;
    }

    that.applyInputSpecificBehavior_extended = function (inputElement, data, givenAnswer) {
        if (data.InputType === "date") {
            inputElement.kendoDatePicker({
                value: givenAnswer ? givenAnswer.AnswerValue : new Date(),
                dateInput: true
            });
        }

        if (data.InputType === "input" && data.InputMask) {
            $(document).ready(function () {
                inputElement.kendoMaskedTextBox({
                    mask: data.InputMask,
                    clearPromptChar: true
                });
            });
        }
    }

    that.appendCheckboxOptions_extended = function (container, data, givenAnswer) {
        data.ExtendedAnswerOptions.forEach(option => {
            const div = $('<div>', { class: 'custom-control custom-checkbox' });
            const input = $('<input>', {
                id: option.Id,
                type: 'checkbox',
                name: data.ExtendedQuestionId,
                'data-extendedansweroptionid': option.Id,
                class: 'custom-control-input'
            });
            const label = $('<label>', {
                class: 'custom-control-label',
                for: option.Id,
                html: (option.Text || "") + appendFiles(option.Files)
            });

            div.append(input, label);
            container.append(div);
        });

        if (givenAnswer) {
            givenAnswer.AnswerId.split(",").forEach(givenAnswerId => {
                container.find(`input[data-extendedansweroptionid="${givenAnswerId}"]`).prop("checked", true);
            });
        }
    }

    that.createFileInput_extended = function (data) {
        return $('<input>', {
            type: 'file',
            class: 'custom-file-input question_file',
            name: data.ExtendedQuestionId,
            id: data.ExtendedQuestionId,
            'data-allowedtypes': data.FileExtensions,
            accept: data.FileExtensions.split(", ").map(x => '.' + x).join(", ")
        });
    }

    that.createFileLabel_extended = function (data, givenAnswer) {
        return $('<label>', {
            class: 'custom-file-label',
            for: data.ExtendedQuestionId,
            text: givenAnswer ? givenAnswer.AnswerValue.substring(givenAnswer.AnswerValue.indexOf("_") + 1) : i18n.message_File_Unselected
        });
    }

    that.createFileValueSpan_extended = function (data) {
        return $('<span>', {
            class: 'd-none',
            id: `input_file_value_${data.ExtendedQuestionId}`,
            text: i18n.message_File_Unselected
        });
    }

    that.createFileInfo_extended = function (givenAnswer) {
        return $('<span>', { class: 'file_info' }).html(
            `${i18n.message_File_File}${i18n.message_File_UploadedBut}${i18n.message_File_Current}` +
            `<a href="${window.origin}/files/answerfiles/${givenAnswer.AnswerValue}" target="_blank" class="download_uploaded_file">${i18n.message_File_Download}</a> ` +
            `${i18n.message_File_Or} ` +
            `<a href="#" class="delete_uploaded_file">${i18n.message_File_Remove}</a>`
        );
    }

    that.createFileTypeInfo_extended = function (data) {
        return $('<div>').append($('<span>', { class: 'text-secondary', text: `${i18n.message_AllowedTypes}${data.FileExtensions}` }));
    }

    that.createFileSizeInfo_extended = function (data) {
        return $('<div>').append($('<span>', { class: 'text-secondary', text: `${i18n.message_MaxFileSize}${data.MaxFileSize}` }));
    }

    that.setupFileInputBehavior_extended = function (fileInput, data) {
        fileInput.on('change', function () {
            const fileName = $(this).val().split('\\').pop();
            $(this).next().text(fileName);
        });

        const [value, ext] = data.MaxFileSize.split(' ');
        const units = {
            Bytes: +value,
            KB: +value * 1e3,
            MB: +value * 1e6,
            GB: +value * 1e9
        };

        fileInput.closest('.extended_question_wrapper').attr('data-maxfilesize', units[ext]);
    }

    that.renderRecordNameInput = function (wrapper, data) {
        let container = $('<div>');

        container.append('<label style="display:none;">' + i18n.label_RecordName + '</label>');

        if (data == null) {
            record_id = $("#wrapper").find(".record_container").length;
            container.append('<input style="display:none;" type="text" name="recordName" value="' + record_id + '" max-length="50" placeholder="' + data + '" class="form-control" />');
        }
        else {
            container.append('<input style="display:none;" type="text" name="recordName" value="' + data + '" max-length="50" placeholder="' + data + '" class="form-control" />');
        }

        //if (data) container.find('input[name="recordName"]').val(data);

        container.append('<span style="display:none;" class="record_name_required required_text">' + i18n.message_RecordNameRequired + '</span>');
        container.append('<hr style="display:none;">');

        wrapper.append(container);
    }

    that.renderSaveRecord = function (wrapper, recordId) {
        var container = $('<div>');

        container.append('<button class="btn btn-sm btn--run-primary save_record" data-recordid="' + recordId + '">' + i18n.button_SaveRecord + '</button>');
        container.append('<button class="btn btn-sm btn--run-default cancel_record_edit">' + i18n.button_CancelRecord + '</button>');

        wrapper.append(container);
    }
}

