﻿const getRespondentAnswer = (questionContainer, type) => {
    const res = GetQuestionInfoObject(questionContainer);
    const questionId = questionContainer.data("questionid");
    const isRequired = questionContainer.data("isrequired");
    const respondentAnswerId = questionContainer.data("respondentanswerid");

    const handlers = {
        QRating: () => {
            const checked = $(questionContainer).find(`div#rating_${questionId}`).find(".rating-selected").attr('data-optionvalue');
            if (!checked) {
                return isRequired ? { required: true, questionId } : { ...res, answer: checked, questionId: res.questionId + ":notanswered" };
            }
            return { ...res, answer: checked };
        },
        QScaleWithTwoSliders: () => {
            const leftInput = $(`div[data-questionid=${questionId}]`).find(`input[data-type="leftInput"]`).val();
            const rightInput = $(`div[data-questionid=${questionId}]`).find(`input[data-type="rigtInput"]`).val();
            return { ...res, answer: `${leftInput}|${rightInput}` };
        },
        QScale: () => {
            const answer = $(`div[data-questionid=${questionId}]`).find(`input[data-type="input"]`).val();
            return { ...res, answer };
        },
        QNps: () => {
            const checked = $(questionContainer).find(`div#nps_${questionId}`).find(".nps-selected").attr('data-optionvalue');
            if (!checked) {
                return isRequired ? { required: true, questionId } : { ...res, answer: checked, questionId: res.questionId + ":notanswered" };
            }
            return { ...res, answer: checked };
        },
        QDropdown: () => {
            const select = $(`select[name="${questionId}"]`);
            if (select.val() === "noanswer") {
                if (isRequired) return { required: true, questionId };
                return respondentAnswerId === 0 ? { ...res, questionId: res.questionId + ":notanswered" } : { ...res, questionId: res.questionId + ":toremove" };
            }
            if (select.val() === "useroption") {
                const userInput = $(`input[type="text"][name="${questionId}"]`).val().trim();
                return userInput ? { ...res, answer: `answerval:${userInput}` } : { ...res, questionId: res.questionId + ":notanswered" };
            }
            return { ...res, answer: `answerid:${select.val()}` };
        },
        QSingle: () => {
            const checked = questionContainer.find(".options_container input[data-answeroptionid]:checked");
            if (!checked.length) {
                return isRequired ? { required: true, questionId } : { ...res, questionId: res.questionId + ":notanswered" };
            }
            if (checked.data("answeroptionid") === "useroption") {
                const userInput = $(`input[type="text"][name="${questionId}"]`).val().trim();
                return userInput ? { ...res, answer: `answerval:${userInput}` } : { ...res, questionId: res.questionId + ":notanswered" };
            }
            return { ...res, answer: `answerid:${$(checked[0]).data("answeroptionid")}` };
        },
        QMatrix: () => {
            const checked = questionContainer.find('input:checked');
            if (!checked.length) {
                return isRequired ? { required: true, questionId } : { ...res, questionId: res.questionId + ":notanswered" };
            }
            const answer = checked.map((_, item) => `${item.name}=${$(item).data('answeroptionid')}`).get().join(';');
            return { ...res, answer };
        },
        QMulty: () => {
            const checked = questionContainer.find(".options_container input[data-answeroptionid]:checked").toArray();
            const maxChecked = questionContainer.data("maxchecked");
            const minChecked = questionContainer.data("minchecked");
            const validationContainer = questionContainer.find(".checked_count_validation");

            validationContainer.html("");
            if (maxChecked !== 0) {
                if (checked.length > maxChecked) {
                    validationContainer.append(`<span>${eqspI18nRun.message_SelectNoMore}${maxChecked}${maxChecked === 1 ? eqspI18nRun.message_Option : eqspI18nRun.message_Options}!</span>`);
                    return { required: true, questionId };
                }
                if (isRequired && checked.length < minChecked) {
                    validationContainer.append(`<span>${eqspI18nRun.message_SelectEqualOrMore}${minChecked}${minChecked === 1 ? eqspI18nRun.message_Option : eqspI18nRun.message_Options}!</span>`);
                    return { required: true, questionId };
                }
            }

            if (!checked.length) {
                if (isRequired) return { required: true, questionId };
                return respondentAnswerId === 0 ? { ...res, questionId: res.questionId + ":notanswered" } : { ...res, questionId: res.questionId + ":toremove" };
            }

            const answerParts = checked.reduce((acc, item) => {
                const $item = $(item);
                if ($item.data("answeroptionid") === "useroption") {
                    const userInput = $(`input[type="text"][name="${questionId}"]`).val().trim();
                    if (userInput) {
                        acc.answerVal = `answerval:${userInput}`;
                    }
                } else {
                    acc.answerIds.push($item.data("answeroptionid"));
                }
                return acc;
            }, { answerIds: [], answerVal: "" });

            const answerIdsPart = answerParts.answerIds.length ? `answerids:${answerParts.answerIds.join(",")}` : "";
            const answer = [answerIdsPart, answerParts.answerVal].filter(Boolean).join("|");

            return { ...res, answer };
        },
        QFile: () => {
            const fileInput = $(`input[type="file"][name="${questionId}"]`);
            const fileDeleted = questionContainer.data("filedeleted");

            if (!fileInput.val()) {
                if (questionContainer.attr("invalid")) {
                    return { invalid: true, questionId };
                }
                if (isRequired && (respondentAnswerId === 0 || fileDeleted)) {
                    return { required: true, questionId };
                }
                if (respondentAnswerId === 0) {
                    return { ...res, questionId: res.questionId + ":notanswered" };
                }
                if (fileDeleted) {
                    return { ...res, questionId: res.questionId + ":toremove" };
                }
                return;
            }

            return { ...res, answer: fileInput[0].files[0] };
        },
        QTable: () => {
            const As = $(`ul#As_${questionId} li`).toArray();
            const Bs = $(`ul#Bs_${questionId} li`).toArray();
            const answer = As.reduce((result, currentItem, i) =>
                result + `${$(currentItem).data("aoptionid")}=${$(Bs[i]).data("boptionid")};`, "");

            return answer ? { ...res, answer } : { ...res, questionId: res.questionId + ":notanswered" };
        },
        QAutocomplete: () => {
            const fileInput = $(`input[type="text"][name="${questionId}"]`);
            if (!fileInput.val()) {
                return isRequired ? { required: true, questionId } : { ...res, questionId: res.questionId + ":notanswered" };
            }
            return { ...res, answer: fileInput.val() };
        },
        QDate: () => {
            const inputType = questionContainer.data("inputtype");
            const dateValue = questionContainer.find(`input[name="${questionId}"]`).val();
            const value = ["date", "dateandtime", "notMore", "time", "notLess", "between"].includes(inputType) ? (dateValue || null) : null;

            if (questionContainer.attr("invalid")) {
                return { invalid: true, questionId };
            }

            if (!value) {
                if (isRequired) {
                    return { required: true, questionId };
                }
                return respondentAnswerId === 0 ? { ...res, questionId: res.questionId + ":notanswered" } : { ...res, questionId: res.questionId + ":toremove" };
            }

            return { ...res, answer: value };
        },
        QTextblock: () => ({ ...res, answer: " " }),
        QInput: () => {
            const inputType = questionContainer.data("inputtype");
            const getValue = {
                textarea: () => questionContainer.find(`textarea[name="${questionId}"]`).val(),
                inputMask: () => {
                    const input = questionContainer.find(`input[name="${questionId}"]`);
                    const value = input.val();
                    const kendoMask = input.data("kendoMaskedTextBox");
                    if (kendoMask) {
                        const maskLength = kendoMask.options.mask?.replace(/[_\s]/g, "").length;
                        const valueLength = value.replace(/[_\s]/g, "").length;
                        if (!maskLength || valueLength === maskLength) {
                            questionContainer.removeAttr("invalid");
                        } else if (value.length !== 0) {
                            questionContainer.attr("invalid", "invalid");
                        }
                    }
                    return value;
                },
                numberOfThePhone: () => {
                    const value = questionContainer.find(`input.PhoneNumber[name="${questionId}"]`).val();
                    return value.length < 6 ? "" : value;
                },
                default: () => questionContainer.find(`input[name="${questionId}"]`).val()
            };

            const value = (getValue[inputType] || getValue.default)();

            if (questionContainer.attr("invalid")) {
                return { invalid: true, questionId };
            }

            if (!value) {
                if (isRequired) {
                    return { required: true, questionId };
                }
                return respondentAnswerId === 0 ? { ...res, questionId: res.questionId + ":notanswered" } : { ...res, questionId: res.questionId + ":toremove" };
            }

            return { ...res, answer: value };
        },
        QDaDataInput: () => {
            const value = questionContainer.find(`input[name="${questionId}"]`).val();
            var autocomplete = questionContainer.find(`#DaDataInput_${questionId}`).data("kendoAutoComplete");
            var jsonValue = "undefined";
            var suggestionModel = autocomplete.dataSource._data.find((element) => element.Suggestion === value);
            if (value !== "" && suggestionModel !== undefined)
                jsonValue = suggestionModel.JsonSuggestion;

            if (questionContainer.attr("invalid")) {
                return { invalid: true, questionId };
            }

            if (!value) {
                if (isRequired) {
                    return { required: true, questionId };
                }
                return respondentAnswerId === 0 ? { ...res, questionId: res.questionId + ":notanswered" } : { ...res, questionId: res.questionId + ":toremove" };
            }

            return { ...res, answer: value + "|" + jsonValue };
        },
        QSpreadsheet: () => {
            var spreadsheet = questionContainer.find(`#spreadSheet_${questionId}`).data("kendoSpreadsheet");
            var spreadsheet = questionContainer.find(`#spreadSheet_${questionId}`).data("kendoSpreadsheet");
            var spreadsheetJson = JSON.stringify(spreadsheet);
            const blob = new Blob([spreadsheetJson], { type: 'application/json' });
            const formData = new FormData();
            var validationPassed = true;
            formData.append('file', blob, 'data.json');
            $.ajax({
                url: "/api/getspreadsheetvalidationcells",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                async: false,
                success: function (e) {
                    if (e === "") {
                        return;
                    }
                    var validationCells = e.split(',');
                    var sheets = spreadsheet.sheets();
                    validationCells.forEach(function (cellRef) {
                        var sheetIndex = cellRef.split('_')[0];
                        var cellReference = cellRef.split('_')[1];
                        var sheet = sheets[sheetIndex];
                        var range = sheet.range(cellReference + ":" + cellReference);
                        range.forEachCell(function (row, column, cell) {
                            if (cell.validation && !cell.validation.value) {
                                validationPassed = false;
                                return;
                            }
                        });
                        if (!validationPassed) {
                            return;
                        }
                    });
                    if (!validationPassed) {
                        return;
                    }
                },
                error: function (e) {
                    console.error(e);
                }
            });
            var ans = JSON.stringify(spreadsheet.toJSON());
            if (validationPassed) {
                return { ...res, answer: ans };
            }
            return { invalid: true, questionId };
        }
    };

    return handlers[type]();
};

// Wrapper functions for each question type
const questionTypes = [
    'QRating', 'QScaleWithTwoSliders', 'QScale', 'QNps', 'QDropdown', 'QSingle', 'QMatrix', 'QMulty',
    'QFile', 'QTable', 'QAutocomplete', 'QDate', 'QTextblock', 'QInput', 'QDaDataInput', 'QSpreadsheet'
];

questionTypes.forEach(type => {
    window[`GetRespondentAnswer${type}`] = questionContainer => getRespondentAnswer(questionContainer, type);
});