﻿const userTaskInfoTemplate = `<div class="k-form">
        <div>
            <span class="font-weight-bold">Создана:</span>
            <span id="info-creation-date-user"></span>
        </div>
        <div>
            <span class="font-weight-bold">Дата начала:</span>
            <span id="info-start-date-user"></span>
        </div>
        <div>
            <span class="font-weight-bold">Дата окончания:</span>
            <span id="info-end-date-user"></span>
        </div>
        <div>
            <span class="font-weight-bold">Автор:</span>
            <span id="info-creator-user"></span>
        </div>

         <div class="font-weight-bold d-sm-flex align-items-center mb-1">
            <span class="mr-2">Состояние:</span>
            <input id="info-status-user" />
        </div>

        <div>
            <span class="font-weight-bold">Описание:</span>
            <span id="info-description-user"></span>
        </div>

        <div class = "questionnaire-info-wrapper">
            <span class="font-weight-bold">Прикрепленная анкета/тест:</span>
            <span id="info-questionnaire-user"></span>
        </div>
    </div>`;

function ShowUserTaskInfo(taskId, refreshSourceFunc = null) {
    let dialog = $("<div id='user-task_info'></div>").kendoDialog({
        modal: true,
        pinned: true,
        visible: false,
        size: "medium",
        height: 500,
        content: kendo.template(userTaskInfoTemplate),
        open: function () {

            $.ajax({
                url: "/api/user-tasks/task-info?taskId=" + taskId,
                type: "GET",
                dataType: "json",
                success: function (task) {
                    dialog.title(task.Title);

                    $("#info-description-user").html(task.Description);
                    $("#info-creation-date-user").html(kendo.toString(new Date(task.CreationDate), "dd.MM.yyyy HH:mm"));
                    $("#info-start-date-user").html(kendo.toString(new Date(task.StartDate), "dd.MM.yyyy HH:mm"));
                    $("#info-end-date-user").html(kendo.toString(new Date(task.EndDate), "dd.MM.yyyy HH:mm"));
                    $("#info-creator-user").html(task.CreatorUserName);
                    $("#info-status-user").data("kendoDropDownList").value(task.Status);

                    if (task.QuestionnaireId) {
                            var link = $('<a>', {
                                text: task.QuestionnaireName,
                                href: '/start/' + task.QuestionnaireId,
                                target: '_blank'
                            });
                            $("#info-questionnaire-user").html(link);
                    }
                    else {
                        $(".questionnaire-info-wrapper").hide();
                    }
                }
            });
        },
        close: function () {
            $("#user-task_info").remove();
        }
    }).data("kendoDialog");

    $("#info-status-user").kendoDropDownList({
        dataSource: [
            {text: "Активная", value: "0",},
            {text: "Завершенная", value: "1",}
        ],
        dataTextField: "text",
        dataValueField: "value",
        change: function (e) {
            let status = this.value();

            //Проверка на сроки выполнения
            const dateString = $("#info-start-date-user").html();
            const [datePart, timePart] = dateString.split(' ');
            const [day, month, year] = datePart.split('.').map(Number);
            const [hours, minutes] = timePart.split(':').map(Number);
            const startDate = new Date(year, month - 1, day, hours, minutes);
            const now = new Date();
            if (status == '1' && startDate > now) {
                Notification.ShowError("Нельзя завершить задачу раньше начала срока выполнения");
                this.value('0');
            }
            else {
                ChangeStatus(taskId, status, refreshSourceFunc);
            }

            if (refreshSourceFunc !== null || refreshSourceFunc != undefined) {
                refreshSourceFunc();
            }
        }
    });

    dialog.open();
}

function ChangeStatus(taskId, status, refreshSourceFunc) {
    $.ajax({
        url: "/api/user-tasks/change-status?userTaskId=" + taskId + "&status=" + status,
        type: "POST",
        dataType: "json",
        complete: function (response) {
            if (response.status === 200) {
                Notification.ShowSuccess("Успешно");
                if (refreshSourceFunc != null || refreshSourceFunc !== undefined) {
                    refreshSourceFunc();
                }
            } else {
                Notification.ShowError("Ошибка!");
            }
        }
    })
}

function GetColor(status) {
    switch (status) {
        case "completed":
            return "success";
        case "active":
            return "primary";
        case "overdue":
            return "danger";
        default:
            return "secondary";
    }
}
