﻿const managerEditorTemplate = `<div id="taskForm" class="k-form">
        <div class="mb-3">
            <label for="title" class="form-label">Заголовок</label>
            <input type="text" id="title" class="form-control k-textbox" required/>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Описание</label>
            <textarea id="description" class="form-control k-textarea"></textarea>
        </div>

        <div class="row">
            <div class="col-md-6 col-lg-4 order-lg-1 start-date-wrapper">
                <div class="mb-3">
                    <label for="start_date" class="form-label">Дата начала</label>
                    <input id="start_date" class="form-control"/>
                </div>
            </div>

            <div class="col-md-6 col-lg-4 order-lg-2">
                <div class="mb-3">
                    <label for="end_date" class="form-label">Дата окончания</label>
                    <input id="end_date" class="form-control"/>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="mb-3">
                    <label for="assignment" class="form-label">Назначение</label>
                    <input id="assignment" class="form-control"/>
                </div>
            </div>
        </div>

        <div class="mb-3 users-container">
            <label for="users" class="form-label">Пользователи</label>
            <input id="users" class="form-control"/>
        </div>
        <div class="mb-3 roles-container">
            <label for="roles" class="form-label">Роли</label>
            <input id="roles" class="form-control"/>
        </div>

        <div class="mb-3 questionnaire-checkbox-container">
            <input type="checkbox" id="questionnaire-checkbox">
        </div>
        <div class="mb-3 questionnaire-container">
            <label for="questionnaire-dropdown" class="form-label">Доступные анкеты</label>
            <input id="questionnaire-dropdown" class="form-control"/>
        </div>
    </div>`;

function OpenManagerTaskEditWindow(task, refreshSourceFunc = null, questionnaireId = null) {
    let editDialog = $("<div id='task-editor-window'></div>").kendoDialog({
        modal: true,
        pinned: true,
        visible: false,
        height: "780px",
        buttonLayout: "normal",
        content: kendo.template(managerEditorTemplate),
        open: function (e) {
            let dialog = e.sender;

            let titleInput = dialog.element.find("#title");
            let descriptionEditor = dialog.element.find("#description").data("kendoEditor");
            let startDatePicker = dialog.element.find("#start_date").data("kendoDateTimePicker");
            let endDatePicker = dialog.element.find("#end_date").data("kendoDateTimePicker");
            let assignmentDropDown = dialog.element.find("#assignment").data("kendoDropDownList");
            let usersMultiselect = dialog.element.find("#users").data("kendoMultiSelect");
            let rolesMultiselect = dialog.element.find("#roles").data("kendoMultiSelect");
            let questionnaireCheckbox = dialog.element.find("#questionnaire-checkbox").data("kendoCheckBox");

            if (task) {
                titleInput.val(task?.Title);
                descriptionEditor.value(task?.Description);
                startDatePicker.value(task?.StartDate);
                endDatePicker.value(task?.EndDate);
                assignmentDropDown.value(task?.Assignment);
                usersMultiselect.value(task?.UsersIds);
                rolesMultiselect.value(task?.RolesIds);

                if (task?.QuestionnaireId) {
                    questionnaireCheckbox.value(true);
                }
            }
            else {
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                const nextWeek = new Date();
                nextWeek.setHours(0, 0, 0, 0);
                nextWeek.setDate(today.getDate() + 7);

                startDatePicker.value(today);
                endDatePicker.value(nextWeek);
            }

            if (assignmentDropDown.value() === "1") {
                $(".users-container").hide();
                $(".roles-container").hide();
                $(".questionnaire-checkbox-container").hide();
                $(".questionnaire-container").hide();
            } else if (assignmentDropDown.value() === "2") {
                $(".users-container").show();
                $(".roles-container").hide();
            } else if (assignmentDropDown.value() === "3") {
                $(".users-container").hide();
                $(".roles-container").show();
            }

            if (assignmentDropDown.value() != "1") {
                $(".questionnaire-checkbox-container").show();
                questionnaireCheckbox.trigger("change", { checked: questionnaireCheckbox.value() });
            }
        },
        close: function () {
            if (refreshSourceFunc != null || refreshSourceFunc !== undefined) {
                refreshSourceFunc();
            }
            $("#task-editor-window").remove();
        },
        actions: [
            {
                text: "Сохранить",
                action: function (e) {
                    let newTask = {
                        Title: $("#title").val(),
                        StartDate: $("#start_date").data("kendoDateTimePicker").value(),
                        EndDate: $("#end_date").data("kendoDateTimePicker").value(),
                        Assignment: $("#assignment").data("kendoDropDownList").value(),
                        UserIds: $("#users").data("kendoMultiSelect").value(),
                        RoleIds: $("#roles").data("kendoMultiSelect").value(),
                        QuestionnaireCheckbox: $("#questionnaire-checkbox").data("kendoCheckBox").value(),
                        Questionnaire: $("#questionnaire-dropdown").data("kendoDropDownList").value()
                    }

                    if (!newTask.Questionnaire) {
                        newTask.Questionnaire = questionnaireId;
                    }

                    let validationResult = ValidateTaskForManager(newTask);

                    if (!validationResult.isValid) {

                        Notification.ShowError(validationResult.error);

                        return false;
                    }

                    let taskData = new FormData();

                    taskData.append("Title", $("#title").val());
                    taskData.append("Description", $("#description").data("kendoEditor").value());
                    taskData.append("StartDate", FormatDate($("#start_date").data("kendoDateTimePicker").value()));
                    taskData.append("EndDate", FormatDate($("#end_date").data("kendoDateTimePicker").value()));

                    let assignment = $("#assignment").data("kendoDropDownList").value();
                    taskData.append("Assignment", assignment);

                    //Id анкеты из дропдауна
                    var dropDownValue = $("#questionnaire-dropdown").data("kendoDropDownList").value();
                    if (dropDownValue != null && dropDownValue != '') {
                        //редактирование
                        taskData.append("QuestionnaireId", dropDownValue);
                    }
                    else {
                        //создание
                        if (questionnaireId) {
                            //из окна настроек анкеты
                            taskData.append("QuestionnaireId", questionnaireId);
                        }
                        else {
                            taskData.append("QuestionnaireId", dropDownValue);
                        }
                    }

                    let users = $("#users").data("kendoMultiSelect").value();
                    let roles = $("#roles").data("kendoMultiSelect").value();

                    if (assignment == '2') {
                        FillAssignmentIds(taskData, users);
                    }
                    else if (assignment == '3') {
                        FillAssignmentIds(taskData, roles);
                    }

                    let url;
                    if (task != null) {
                        url = "/api/user-tasks/update";

                        taskData.append("Id", task.Id);

                    } else {
                        url = "/api/user-tasks/create";
                    }

                    $.ajax({
                        url: url,
                        dataType: "json",
                        type: "POST",
                        contentType: false,
                        processData: false,
                        data: taskData,
                        complete: function (response) {
                            if (response.status === 200) {
                                if (refreshSourceFunc != null || refreshSourceFunc !== undefined) {
                                    refreshSourceFunc();
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    })

                    return true;
                },
                primary: true
            },
            {
                text: "Отмена"
            }
        ],
    }).data("kendoDialog");

    function FillAssignmentIds(taskData, ids) {
        for (let i = 0; i < ids.length; i++) {
            taskData.append("AssignmentIds[]", ids[i]);
        }
    }

    $("#description").kendoEditor({
        tools: [
            "undo",
            "redo",
            {
                name: "fontName",
                items: [
                    {text: "Andale Mono", value: "\"Andale Mono\""},
                    {text: "Arial", value: "Arial"},
                    {text: "Arial Black", value: "\"Arial Black\""},
                    {text: "Book Antiqua", value: "\"Book Antiqua\""},
                    {text: "Comic Sans MS", value: "\"Comic Sans MS\""},
                    {text: "Courier New", value: "\"Courier New\""},
                    {text: "Georgia", value: "Georgia"},
                    {text: "Helvetica", value: "Helvetica"},
                    {text: "Impact", value: "Impact"},
                    {text: "Symbol", value: "Symbol"},
                    {text: "Tahoma", value: "Tahoma"},
                    {text: "Terminal", value: "Terminal"},
                    {text: "Times New Roman", value: "\"Times New Roman\""},
                    {text: "Trebuchet MS", value: "\"Trebuchet MS\""},
                    {text: "Verdana", value: "Verdana"},
                ]
            },
            "fontSize",
            "bold",
            "italic",
            "underline",
            "backColor",
            "foreColor",
            "insertUnorderedList",
            "justifyLeft",
            "justifyCenter",
            "justifyRight",
            "formatting",
            "createLink",
            "unlink",
            "insertImage",
            "tableWizard",
            "tableProperties",
            "tableCellProperties",
            "createTable",
            "addRowAbove",
            "addRowBelow",
            "addColumnLeft",
            "addColumnRight",
            "deleteRow",
            "deleteColumn",
            "mergeCellsHorizontally",
            "mergeCellsVertically",
            "splitCellHorizontally",
            "splitCellVertically",
            "tableAlignLeft",
            "tableAlignCenter",
            "tableAlignRight"
        ]
    });

    $("#start_date").kendoDateTimePicker({});

    $("#end_date").kendoDateTimePicker({});

    $("#assignment").kendoDropDownList({
        dataSource: [
            {text: "Личная", id: "1"},
            {text: "Пользователь", id: "2"},
            {text: "Роль", id: "3"}
        ],
        dataTextField: "text",
        dataValueField: "id",
        change: changeHandlerWithQuestionnaireSettings
    })

    $("#users").kendoMultiSelect({
        dataSource: {
            transport: {
                read: {url: "/api/user-tasks/users", dataType: "json", type: "GET"}
            },
            schema: {
                data: (response) => {
                    if (response["data"])
                        return response.data;
                    else
                        return response;
                },
                total: (response) => {
                    return response.total;
                },
                model: {
                    id: "Id",
                    fields: {
                        Id: {type: "string"},
                        Email: {type: "string"},
                        DisplayName: {type: "string"},
                        UserName: {type: "string"},
                        IsEnabled: {type: "boolean"},
                        CreationDate: {type: "date"}
                    }
                }
            }
        },
        dataTextField: "DisplayName",
        dataValueField: "Id",
        filter: "contains",
        optionLabel: "Выберите пользователей"
    });

    $("#roles").kendoMultiSelect({
        dataSource: {
            transport: {
                read: {url: "/api/user-tasks/roles", dataType: "json", type: "GET"}
            },
            schema: {
                model: {
                    id: "Id",
                    fields: {
                        Name: {type: "string"},
                        Description: {type: "string"},
                        IsAutoAssignable: {type: "boolean"}
                    }
                }
            }
        },
        dataTextField: "Name",
        dataValueField: "Id",
        filter: "contains",
        optionLabel: "Выберите роли",
    });

    $("#questionnaire-checkbox").kendoCheckBox({
        label: "Добавить анкету/тест",
        rounded: "medium",
        change: function (e) {
            if (e.checked) {
                $(".questionnaire-container").show();
                let dropdown = $("#questionnaire-dropdown").data("kendoDropDownList");
                dropdown.setDataSource({
                    transport: {
                        read: {
                            url: "/api/user-tasks/questionnaires", // access level?
                            dataType: "json",
                            type: "GET"
                        },
                    },
                    serverPaging: true,
                    serverSorting: true,
                    serverFiltering: true,
                    schema: {
                        data: "data",
                        total: "total",
                        model: {
                            id: "Id",
                            fields: {
                                Id: { type: "string" },
                                Title: { type: "string" },
                                CreationDate: { type: "date" }
                            }
                        }
                    },
                    sort: { field: "CreationDate", dir: "desc" },
                    requestEnd: function (e) {
                        if (e.type == 'read' && task?.QuestionnaireId) {
                            dropdown.value(task.QuestionnaireId);
                        }
                    }
                });
            }
            else {
                $(".questionnaire-container").hide();
                $("#questionnaire-dropdown").data("kendoDropDownList").value("");//empty value
            }
        }
    });

    $("#questionnaire-dropdown").kendoDropDownList({
        dataSource: [],
        dataTextField: "Title",
        dataValueField: "Id",
        optionLabel: "Выберите..."
    });

    editDialog.title(task == null ? "Создать задачу" : "Редактировать задачу");
    editDialog.open();
}

function ValidateTaskForManager(task) {
    if (!task.Title || task.Title.trim() === '') {
        return {isValid: false, error: 'Заголовок задачи отсутствует'};
    }

    // Проверка наличия дат
    if (!task.StartDate || !task.EndDate) {
        return {isValid: false, error: 'Даты начала и/или окончания отсутствуют'};
    }

    // Преобразование строковых дат в объекты Date
    const startDate = new Date(task.StartDate);
    const endDate = new Date(task.EndDate);

    // Проверка корректности дат
    if (isNaN(startDate.getTime()) || isNaN(endDate.getTime())) {
        return {isValid: false, error: 'Некорректный формат дат'};
    }

    // Проверка, что дата окончания не раньше даты начала
    if (endDate < startDate) {
        return {isValid: false, error: 'Дата окончания не может быть раньше даты начала'};
    }

    // Пустое поле пользователей
    if (task.Assignment == '2' && task.UserIds.length == 0) {
        return { isValid: false, error: 'Укажите пользователей' };
    }

    // Пустое поле ролей
    if (task.Assignment == '3' && task.RoleIds.length == 0) {
        return { isValid: false, error: 'Укажите роли' };
    }

    // Не выбрана анкета
    if (task.QuestionnaireCheckbox == true && task.Questionnaire == '') {
        return { isValid: false, error: 'Выберите анкету/тест' };
    }

    // Если все проверки пройдены
    return {isValid: true};
}

function FormatDate(timeStamp) {
    let date = new Date(timeStamp);
    return date.toLocaleString();
}

function changeHandlerWithQuestionnaireSettings(e) {
    let value = $("#assignment").data("kendoDropDownList").value();

    if (value === "1") {
        $(".users-container").hide();
        $(".roles-container").hide();

        $(".questionnaire-checkbox-container").hide();
        $(".questionnaire-container").hide();
        $("#questionnaire-dropdown").data("kendoDropDownList").value("");
        $("#questionnaire-checkbox").data("kendoCheckBox").value(false);

    } else if (value === "2") {
        $(".users-container").show();
        $(".roles-container").hide();

    } else if (value === "3") {
        $(".users-container").hide();
        $(".roles-container").show();
    }

    if (value != "1") {
        let questionnaireCheckbox = $("#questionnaire-checkbox").data("kendoCheckBox");
        $(".questionnaire-checkbox-container").show();
        if (questionnaireCheckbox.value() == true) {
            $(".questionnaire-container").show();
        }
        else {
            $(".questionnaire-container").hide();
            $("#questionnaire-dropdown").data("kendoDropDownList").value("");
        }
    }


}

function changeHandlerWithoutQuestionnaireSettings(e) {
    let value = $("#assignment").data("kendoDropDownList").value();

    $(".questionnaire-checkbox-container").hide();
    $(".questionnaire-container").hide();
    $("#questionnaire-dropdown").data("kendoDropDownList").value("");

    if (value === "1") {
        $(".users-container").hide();
        $(".roles-container").hide();

    } else if (value === "2") {
        $(".users-container").show();
        $(".roles-container").hide();

    } else if (value === "3") {
        $(".users-container").hide();
        $(".roles-container").show();
    }
}
