/*
Stimulsoft.Reports.JS
Version: 2021.4.1
Build date: 2021.10.04
License: https://www.stimulsoft.com/en/licensing/reports
*/
var Stimulsoft;!function(t){var e,o;o=e=t.ExternalLibrary||(t.ExternalLibrary={})}(Stimulsoft=Stimulsoft||{}),function(t,e){t.Blockly=e(),Stimulsoft.ExternalLibrary.Blockly=t.Blockly}(this,function(){"use strict";var I={connectionTypes:{INPUT_VALUE:1,OUTPUT_VALUE:2,NEXT_STATEMENT:3,PREVIOUS_STATEMENT:4},spritesBase64:"data:image/png;base64,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",constants:{},LINE_MODE_MULTIPLIER:40,PAGE_MODE_MULTIPLIER:125,DRAG_RADIUS:5,FLYOUT_DRAG_RADIUS:10,SNAP_RADIUS:28};return I.CONNECTING_SNAP_RADIUS=I.SNAP_RADIUS,I.CURRENT_CONNECTION_PREFERENCE=8,I.BUMP_DELAY=250,I.BUMP_RANDOMNESS=10,I.COLLAPSE_CHARS=30,I.LONGPRESS=750,I.SOUND_LIMIT=100,I.DRAG_STACK=!0,I.HSV_SATURATION=.45,I.HSV_VALUE=.65,I.SPRITE={width:96,height:124,url:"sprites.png"},I.constants.ALIGN={LEFT:-1,CENTRE:0,RIGHT:1},I.DRAG_NONE=0,I.DRAG_STICKY=1,I.DRAG_BEGIN=1,I.DRAG_FREE=2,I.OPPOSITE_TYPE=[],I.OPPOSITE_TYPE[I.connectionTypes.INPUT_VALUE]=I.connectionTypes.OUTPUT_VALUE,I.OPPOSITE_TYPE[I.connectionTypes.OUTPUT_VALUE]=I.connectionTypes.INPUT_VALUE,I.OPPOSITE_TYPE[I.connectionTypes.NEXT_STATEMENT]=I.connectionTypes.PREVIOUS_STATEMENT,I.OPPOSITE_TYPE[I.connectionTypes.PREVIOUS_STATEMENT]=I.connectionTypes.NEXT_STATEMENT,I.DELETE_AREA_NONE=null,I.DELETE_AREA_TRASH=1,I.DELETE_AREA_TOOLBOX=2,I.VARIABLE_CATEGORY_NAME="VARIABLE",I.VARIABLE_DYNAMIC_CATEGORY_NAME="VARIABLE_DYNAMIC",I.PROCEDURE_CATEGORY_NAME="PROCEDURE",I.RENAME_VARIABLE_ID="RENAME_VARIABLE_ID",I.DELETE_VARIABLE_ID="DELETE_VARIABLE_ID",I.constants.COLLAPSED_INPUT_NAME="_TEMP_COLLAPSED_INPUT",I.constants.COLLAPSED_FIELD_NAME="_TEMP_COLLAPSED_FIELD",I.utils={},I.utils.global=function(){return"object"==typeof self?self:"object"==typeof window?window:"object"==typeof global?global:this}(),I.Msg={},I.utils.global.Blockly||(I.utils.global.Blockly={}),I.utils.global.Blockly.Msg||(I.utils.global.Blockly.Msg=I.Msg),I.utils.colour={},I.utils.colour.parse=function(t){t=String(t).toLowerCase().trim();var e=I.utils.colour.names[t];if(e)return e;if(e="#"==(e="0x"==t.substring(0,2)?"#"+t.substring(2):t)[0]?e:"#"+e,/^#[0-9a-f]{6}$/.test(e))return e;if(/^#[0-9a-f]{3}$/.test(e))return["#",e[1],e[1],e[2],e[2],e[3],e[3]].join("");var o=t.match(/^(?:rgb)?\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/);return o&&(t=Number(o[1]),e=Number(o[2]),o=Number(o[3]),0<=t&&t<256&&0<=e&&e<256&&0<=o&&o<256)?I.utils.colour.rgbToHex(t,e,o):null},I.utils.colour.rgbToHex=function(t,e,o){return e=t<<16|e<<8|o,t<16?"#"+(16777216|e).toString(16).substr(1):"#"+e.toString(16)},I.utils.colour.hexToRgb=function(t){if(!(t=I.utils.colour.parse(t)))return[0,0,0];return[(t=parseInt(t.substr(1),16))>>16,t>>8&255,255&t]},I.utils.colour.hsvToHex=function(t,e,o){var i=0,s=0,n=0;if(0==e)n=s=i=o;else{var r=Math.floor(t/60),l=t/60-r;t=o*(1-e);var a=o*(1-e*l);switch(e=o*(1-e*(1-l)),r){case 1:i=a,s=o,n=t;break;case 2:i=t,s=o,n=e;break;case 3:i=t,s=a,n=o;break;case 4:i=e,s=t,n=o;break;case 5:i=o,s=t,n=a;break;case 6:case 0:i=o,s=e,n=t}}return I.utils.colour.rgbToHex(Math.floor(i),Math.floor(s),Math.floor(n))},I.utils.colour.blend=function(t,e,o){if(!(t=I.utils.colour.parse(t)))return null;if(!(e=I.utils.colour.parse(e)))return null;return t=I.utils.colour.hexToRgb(t),e=I.utils.colour.hexToRgb(e),I.utils.colour.rgbToHex(Math.round(e[0]+o*(t[0]-e[0])),Math.round(e[1]+o*(t[1]-e[1])),Math.round(e[2]+o*(t[2]-e[2])))},I.utils.colour.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00"},I.utils.Coordinate=function(t,e){this.x=t,this.y=e},I.utils.Coordinate.equals=function(t,e){return t==e||!(!t||!e)&&(t.x==e.x&&t.y==e.y)},I.utils.Coordinate.distance=function(t,e){var o=t.x-e.x;return t=t.y-e.y,Math.sqrt(o*o+t*t)},I.utils.Coordinate.magnitude=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},I.utils.Coordinate.difference=function(t,e){return new I.utils.Coordinate(t.x-e.x,t.y-e.y)},I.utils.Coordinate.sum=function(t,e){return new I.utils.Coordinate(t.x+e.x,t.y+e.y)},I.utils.Coordinate.prototype.scale=function(t){return this.x*=t,this.y*=t,this},I.utils.Coordinate.prototype.translate=function(t,e){return this.x+=t,this.y+=e,this},I.utils.Rect=function(t,e,o,i){this.top=t,this.bottom=e,this.left=o,this.right=i},I.utils.Rect.prototype.contains=function(t,e){return t>=this.left&&t<=this.right&&e>=this.top&&e<=this.bottom},I.utils.Rect.prototype.intersects=function(t){return!(this.left>t.right||this.right<t.left||this.top>t.bottom||this.bottom<t.top)},I.utils.string={},I.utils.string.startsWith=function(t,e){return 0==t.lastIndexOf(e,0)},I.utils.string.shortestStringLength=function(t){return t.length?t.reduce(function(t,e){return t.length<e.length?t:e}).length:0},I.utils.string.commonWordPrefix=function(t,e){if(!t.length)return 0;if(1==t.length)return t[0].length;var o=0;e=e||I.utils.string.shortestStringLength(t);for(var i=0;i<e;i++){for(var s=t[0][i],n=1;n<t.length;n++)if(s!=t[n][i])return o;" "==s&&(o=i+1)}for(n=1;n<t.length;n++)if((s=t[n][i])&&" "!=s)return o;return e},I.utils.string.commonWordSuffix=function(t,e){if(!t.length)return 0;if(1==t.length)return t[0].length;var o=0;e=e||I.utils.string.shortestStringLength(t);for(var i=0;i<e;i++){for(var s=t[0].substr(-i-1,1),n=1;n<t.length;n++)if(s!=t[n].substr(-i-1,1))return o;" "==s&&(o=i+1)}for(n=1;n<t.length;n++)if((s=t[n].charAt(t[n].length-i-1))&&" "!=s)return o;return e},I.utils.string.wrap=function(t,e){t=t.split("\n");for(var o=0;o<t.length;o++)t[o]=I.utils.string.wrapLine_(t[o],e);return t.join("\n")},I.utils.string.wrapLine_=function(t,e){if(t.length<=e)return t;for(var o=t.trim().split(/\s+/),i=0;i<o.length;i++)o[i].length>e&&(e=o[i].length);i=-(1/0);var s=1;do{var n=i,r=t;t=[];for(var l=o.length/s,a=1,i=0;i<o.length-1;i++)a<(i+1.5)/l?(a++,t[i]=!0):t[i]=!1;t=I.utils.string.wrapMutate_(o,t,e),i=I.utils.string.wrapScore_(o,t,e),t=I.utils.string.wrapToText_(o,t),s++}while(n<i);return r},I.utils.string.wrapScore_=function(t,e,o){for(var i=[0],s=[],n=0;n<t.length;n++)i[i.length-1]+=t[n].length,!0===e[n]?(i.push(0),s.push(t[n].charAt(t[n].length-1))):!1===e[n]&&i[i.length-1]++;for(t=Math.max.apply(Math,i),n=e=0;n<i.length;n++)e-=2*Math.pow(Math.abs(o-i[n]),1.5),e-=Math.pow(t-i[n],1.5),-1!=".?!".indexOf(s[n])?e+=o/3:-1!=",;)]}".indexOf(s[n])&&(e+=o/4);return 1<i.length&&i[i.length-1]<=i[i.length-2]&&(e+=.5),e},I.utils.string.wrapMutate_=function(t,e,o){for(var i=I.utils.string.wrapScore_(t,e,o),s,n=0,r,l;n<e.length-1;n++){e[n]!=e[n+1]&&((r=[].concat(e))[n]=!r[n],r[n+1]=!r[n+1],i<(l=I.utils.string.wrapScore_(t,r,o))&&(i=l,s=r))}return s?I.utils.string.wrapMutate_(t,s,o):e},I.utils.string.wrapToText_=function(t,e){for(var o=[],i=0;i<t.length;i++)o.push(t[i]),void 0!==e[i]&&o.push(e[i]?"\n":" ");return o.join("")},I.utils.Size=function(t,e){this.width=t,this.height=e},I.utils.Size.equals=function(t,e){return t==e||!(!t||!e)&&(t.width==e.width&&t.height==e.height)},I.utils.style={},I.utils.style.getSize=function(t){if("none"!=I.utils.style.getStyle_(t,"display"))return I.utils.style.getSizeWithDisplay_(t);var e=t.style,o=e.display,i=e.visibility,s=e.position;e.visibility="hidden",e.position="absolute",e.display="inline";var n=t.offsetWidth;return t=t.offsetHeight,e.display=o,e.position=s,e.visibility=i,new I.utils.Size(n,t)},I.utils.style.getSizeWithDisplay_=function(t){return new I.utils.Size(t.offsetWidth,t.offsetHeight)},I.utils.style.getStyle_=function(t,e){return I.utils.style.getComputedStyle(t,e)||I.utils.style.getCascadedStyle(t,e)||t.style&&t.style[e]},I.utils.style.getComputedStyle=function(t,e){return document.defaultView&&document.defaultView.getComputedStyle&&(t=document.defaultView.getComputedStyle(t,null))&&(t[e]||t.getPropertyValue(e))||""},I.utils.style.getCascadedStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:null},I.utils.style.getPageOffset=function(t){var e=new I.utils.Coordinate(0,0);t=t.getBoundingClientRect();var o=document.documentElement,o=new I.utils.Coordinate(window.pageXOffset||o.scrollLeft,window.pageYOffset||o.scrollTop);return e.x=t.left+o.x,e.y=t.top+o.y,e},I.utils.style.getViewportPageOffset=function(){var t=document.body,e=document.documentElement;return new I.utils.Coordinate(t.scrollLeft||e.scrollLeft,t.scrollTop||e.scrollTop)},I.utils.style.setElementShown=function(t,e){t.style.display=e?"":"none"},I.utils.style.isRightToLeft=function(t){return"rtl"==I.utils.style.getStyle_(t,"direction")},I.utils.style.getBorderBox=function(t){var e=I.utils.style.getComputedStyle(t,"borderLeftWidth"),o=I.utils.style.getComputedStyle(t,"borderRightWidth"),i=I.utils.style.getComputedStyle(t,"borderTopWidth");return t=I.utils.style.getComputedStyle(t,"borderBottomWidth"),{top:parseFloat(i),right:parseFloat(o),bottom:parseFloat(t),left:parseFloat(e)}},I.utils.style.scrollIntoContainerView=function(t,e,o){t=I.utils.style.getContainerOffsetToScrollInto(t,e,o),e.scrollLeft=t.x,e.scrollTop=t.y},I.utils.style.getContainerOffsetToScrollInto=function(t,e,o){var i=I.utils.style.getPageOffset(t),s=I.utils.style.getPageOffset(e),n=I.utils.style.getBorderBox(e),r=i.x-s.x-n.left,i=i.y-s.y-n.top,s=I.utils.style.getSizeWithDisplay_(t);return t=e.clientWidth-s.width,s=e.clientHeight-s.height,n=e.scrollLeft,e=e.scrollTop,o?(n+=r-t/2,e+=i-s/2):(n+=Math.min(r,Math.max(r-t,0)),e+=Math.min(i,Math.max(i-s,0))),new I.utils.Coordinate(n,e)},I.utils.userAgent={},function(t){function e(t){return-1!=o.indexOf(t.toUpperCase())}I.utils.userAgent.raw=t;var o=I.utils.userAgent.raw.toUpperCase();I.utils.userAgent.IE=e("Trident")||e("MSIE"),I.utils.userAgent.EDGE=e("Edge"),I.utils.userAgent.JAVA_FX=e("JavaFX"),I.utils.userAgent.CHROME=(e("Chrome")||e("CriOS"))&&!I.utils.userAgent.EDGE,I.utils.userAgent.WEBKIT=e("WebKit")&&!I.utils.userAgent.EDGE,I.utils.userAgent.GECKO=e("Gecko")&&!I.utils.userAgent.WEBKIT&&!I.utils.userAgent.IE&&!I.utils.userAgent.EDGE,I.utils.userAgent.ANDROID=e("Android"),I.utils.userAgent.IPAD=e("iPad"),I.utils.userAgent.IPOD=e("iPod"),I.utils.userAgent.IPHONE=e("iPhone")&&!I.utils.userAgent.IPAD&&!I.utils.userAgent.IPOD,I.utils.userAgent.MAC=e("Macintosh"),I.utils.userAgent.TABLET=I.utils.userAgent.IPAD||I.utils.userAgent.ANDROID&&!e("Mobile")||e("Silk"),I.utils.userAgent.MOBILE=!I.utils.userAgent.TABLET&&(I.utils.userAgent.IPOD||I.utils.userAgent.IPHONE||I.utils.userAgent.ANDROID||e("IEMobile"))}(I.utils.global.navigator&&I.utils.global.navigator.userAgent||""),I.utils.noEvent=function(t){t.preventDefault(),t.stopPropagation()},I.utils.isTargetInput=function(t){return"textarea"==t.target.type||"text"==t.target.type||"number"==t.target.type||"email"==t.target.type||"password"==t.target.type||"search"==t.target.type||"tel"==t.target.type||"url"==t.target.type||t.target.isContentEditable||t.target.dataset&&"true"==t.target.dataset.isTextInput},I.utils.getRelativeXY=function(t){var e=new I.utils.Coordinate(0,0),o=t.getAttribute("x");return o&&(e.x=parseInt(o,10)),(o=t.getAttribute("y"))&&(e.y=parseInt(o,10)),(o=(o=t.getAttribute("transform"))&&o.match(I.utils.getRelativeXY.XY_REGEX_))&&(e.x+=Number(o[1]),o[3]&&(e.y+=Number(o[3]))),(t=t.getAttribute("style"))&&-1<t.indexOf("translate")&&(t=t.match(I.utils.getRelativeXY.XY_STYLE_REGEX_))&&(e.x+=Number(t[1]),t[3]&&(e.y+=Number(t[3]))),e},I.utils.getInjectionDivXY_=function(t){for(var e=0,o=0;t;){var i=I.utils.getRelativeXY(t);if(e+=i.x,o+=i.y,-1!=(" "+(t.getAttribute("class")||"")+" ").indexOf(" injectionDiv "))break;t=t.parentNode}return new I.utils.Coordinate(e,o)},I.utils.getRelativeXY.XY_REGEX_=/translate\(\s*([-+\d.e]+)([ ,]\s*([-+\d.e]+)\s*)?/,I.utils.getRelativeXY.XY_STYLE_REGEX_=/transform:\s*translate(?:3d)?\(\s*([-+\d.e]+)\s*px([ ,]\s*([-+\d.e]+)\s*px)?/,I.utils.isRightButton=function(t){return!(!t.ctrlKey||!I.utils.userAgent.MAC)||2==t.button},I.utils.mouseToSvg=function(t,e,o){var i=e.createSVGPoint();return i.x=t.clientX,i.y=t.clientY,o=o||e.getScreenCTM().inverse(),i.matrixTransform(o)},I.utils.getScrollDeltaPixels=function(t){switch(t.deltaMode){default:return{x:t.deltaX,y:t.deltaY};case 1:return{x:t.deltaX*I.LINE_MODE_MULTIPLIER,y:t.deltaY*I.LINE_MODE_MULTIPLIER};case 2:return{x:t.deltaX*I.PAGE_MODE_MULTIPLIER,y:t.deltaY*I.PAGE_MODE_MULTIPLIER}}},I.utils.tokenizeInterpolation=function(t){return I.utils.tokenizeInterpolation_(t,!0)},I.utils.replaceMessageReferences=function(t){if("string"!=typeof t)return t;return(t=I.utils.tokenizeInterpolation_(t,!1)).length?String(t[0]):""},I.utils.checkMessageReferences=function(t){for(var e=!0,o=I.Msg,i=t.match(/%{BKY_[A-Z]\w*}/gi),s=0,n;s<i.length;s++){null==o[i[s].toUpperCase().slice(6,-1)]&&(console.warn("No message string for "+i[s]+" in "+t),e=!1)}return e},I.utils.tokenizeInterpolation_=function(t,e){var o=[],i=t.split("");i.push("");var s=0;t=[];for(var n=null,r=0;r<i.length;r++){var l=i[r];0==s?"%"==l?((l=t.join(""))&&o.push(l),t.length=0,s=1):t.push(l):1==s?"%"==l?(t.push(l),s=0):e&&"0"<=l&&l<="9"?(s=2,n=l,(l=t.join(""))&&o.push(l),t.length=0):s="{"==l?3:(t.push("%",l),0):2==s?"0"<=l&&l<="9"?n+=l:(o.push(parseInt(n,10)),r--,s=0):3==s&&(""==l?(t.splice(0,0,"%{"),r--,s=0):"}"!=l?t.push(l):(s=t.join(""),/[A-Z]\w*/i.test(s)?(l=s.toUpperCase(),(l=I.utils.string.startsWith(l,"BKY_")?l.substring(4):null)&&l in I.Msg?"string"==typeof(s=I.Msg[l])?Array.prototype.push.apply(o,I.utils.tokenizeInterpolation_(s,e)):e?o.push(String(s)):o.push(s):o.push("%{"+s+"}")):o.push("%{"+s+"}"),s=t.length=0))}for((l=t.join(""))&&o.push(l),e=[],r=t.length=0;r<o.length;++r)"string"==typeof o[r]?t.push(o[r]):((l=t.join(""))&&e.push(l),t.length=0,e.push(o[r]));return(l=t.join(""))&&e.push(l),t.length=0,e},I.utils.genUid=function(){for(var t=I.utils.genUid.soup_.length,e=[],o=0;o<20;o++)e[o]=I.utils.genUid.soup_.charAt(Math.random()*t);return e.join("")},I.utils.genUid.soup_="!#$%()*+,-./:;=?@[]^_`{|}~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",I.utils.is3dSupported=function(){if(void 0!==I.utils.is3dSupported.cached_)return I.utils.is3dSupported.cached_;if(!I.utils.global.getComputedStyle)return!1;var t=document.createElement("p"),e="none",o={webkitTransform:"-webkit-transform",OTransform:"-o-transform",msTransform:"-ms-transform",MozTransform:"-moz-transform",transform:"transform"},i;for(i in document.body.insertBefore(t,null),o)if(void 0!==t.style[i]){if(t.style[i]="translate3d(1px,1px,1px)",!(e=I.utils.global.getComputedStyle(t)))return document.body.removeChild(t),!1;e=e.getPropertyValue(o[i])}return document.body.removeChild(t),I.utils.is3dSupported.cached_="none"!==e,I.utils.is3dSupported.cached_},I.utils.runAfterPageLoad=function(t){if("object"!=typeof document)throw Error("Blockly.utils.runAfterPageLoad() requires browser document.");var e;"complete"==document.readyState?t():e=setInterval(function(){"complete"==document.readyState&&(clearInterval(e),t())},10)},I.utils.getViewportBBox=function(){var t=I.utils.style.getViewportPageOffset();return new I.utils.Rect(t.y,document.documentElement.clientHeight+t.y,t.x,document.documentElement.clientWidth+t.x)},I.utils.arrayRemove=function(t,e){if(-1==(e=t.indexOf(e)))return!1;return t.splice(e,1),!0},I.utils.getDocumentScroll=function(){var t=document.documentElement,e=window;return I.utils.userAgent.IE&&e.pageYOffset!=t.scrollTop?new I.utils.Coordinate(t.scrollLeft,t.scrollTop):new I.utils.Coordinate(e.pageXOffset||t.scrollLeft,e.pageYOffset||t.scrollTop)},I.utils.getBlockTypeCounts=function(t,e){var o=Object.create(null),i=t.getDescendants(!0);for(e&&(t=t.getNextBlock())&&(t=i.indexOf(t),i.splice(t,i.length-t)),t=0;e=i[t];t++)o[e.type]?o[e.type]++:o[e.type]=1;return o},I.utils.screenToWsCoordinates=function(t,e){var o=e.x;e=e.y;var i=t.getInjectionDiv().getBoundingClientRect(),o=new I.utils.Coordinate(o-i.left,e-i.top);return e=t.getOriginOffsetInPixels(),I.utils.Coordinate.difference(o,e).scale(1/t.scale)},I.utils.parseBlockColour=function(t){var e="string"==typeof t?I.utils.replaceMessageReferences(t):t,o=Number(e);if(!isNaN(o)&&0<=o&&o<=360)return{hue:o,hex:I.utils.colour.hsvToHex(o,I.HSV_SATURATION,255*I.HSV_VALUE)};if(o=I.utils.colour.parse(e))return{hue:null,hex:o};throw o='Invalid colour: "'+e+'"',t!=e&&(o+=' (from "'+t+'")'),Error(o)},I.Touch={},I.Touch.TOUCH_ENABLED="ontouchstart"in I.utils.global||!!(I.utils.global.document&&document.documentElement&&"ontouchstart"in document.documentElement)||!(!I.utils.global.navigator||!I.utils.global.navigator.maxTouchPoints&&!I.utils.global.navigator.msMaxTouchPoints),I.Touch.touchIdentifier_=null,I.Touch.TOUCH_MAP={},I.utils.global.PointerEvent?I.Touch.TOUCH_MAP={mousedown:["pointerdown"],mouseenter:["pointerenter"],mouseleave:["pointerleave"],mousemove:["pointermove"],mouseout:["pointerout"],mouseover:["pointerover"],mouseup:["pointerup","pointercancel"],touchend:["pointerup"],touchcancel:["pointercancel"]}:I.Touch.TOUCH_ENABLED&&(I.Touch.TOUCH_MAP={mousedown:["touchstart"],mousemove:["touchmove"],mouseup:["touchend","touchcancel"]}),I.longPid_=0,I.longStart=function(t,e){I.longStop_(),t.changedTouches&&1!=t.changedTouches.length||(I.longPid_=setTimeout(function(){t.changedTouches&&(t.button=2,t.clientX=t.changedTouches[0].clientX,t.clientY=t.changedTouches[0].clientY),e&&e.handleRightClick(t)},I.LONGPRESS))},I.longStop_=function(){I.longPid_&&(clearTimeout(I.longPid_),I.longPid_=0)},I.Touch.clearTouchIdentifier=function(){I.Touch.touchIdentifier_=null},I.Touch.shouldHandleEvent=function(t){return!I.Touch.isMouseOrTouchEvent(t)||I.Touch.checkTouchIdentifier(t)},I.Touch.getTouchIdentifierFromEvent=function(t){return null!=t.pointerId?t.pointerId:t.changedTouches&&t.changedTouches[0]&&void 0!==t.changedTouches[0].identifier&&null!==t.changedTouches[0].identifier?t.changedTouches[0].identifier:"mouse"},I.Touch.checkTouchIdentifier=function(t){var e=I.Touch.getTouchIdentifierFromEvent(t);return void 0!==I.Touch.touchIdentifier_&&null!==I.Touch.touchIdentifier_?I.Touch.touchIdentifier_==e:("mousedown"==t.type||"touchstart"==t.type||"pointerdown"==t.type)&&(I.Touch.touchIdentifier_=e,!0)},I.Touch.setClientFromTouch=function(t){var e;I.utils.string.startsWith(t.type,"touch")&&(e=t.changedTouches[0],t.clientX=e.clientX,t.clientY=e.clientY)},I.Touch.isMouseOrTouchEvent=function(t){return I.utils.string.startsWith(t.type,"touch")||I.utils.string.startsWith(t.type,"mouse")||I.utils.string.startsWith(t.type,"pointer")},I.Touch.isTouchEvent=function(t){return I.utils.string.startsWith(t.type,"touch")||I.utils.string.startsWith(t.type,"pointer")},I.Touch.splitEventByTouches=function(t){var e=[];if(t.changedTouches)for(var o=0;o<t.changedTouches.length;o++)e[o]={type:t.type,changedTouches:[t.changedTouches[o]],target:t.target,stopPropagation:function(){t.stopPropagation()},preventDefault:function(){t.preventDefault()}};else e.push(t);return e},I.browserEvents={},I.browserEvents.conditionalBind=function(t,e,s,n,r,o){var l=!1,i=function(t){var e=!r;t=I.Touch.splitEventByTouches(t);for(var o=0,i;i=t[o];o++)e&&!I.Touch.shouldHandleEvent(i)||(I.Touch.setClientFromTouch(i),s?n.call(s,i):n(i),l=!0)},a=[];if(I.utils.global.PointerEvent&&e in I.Touch.TOUCH_MAP)for(var c=0,h;h=I.Touch.TOUCH_MAP[e][c];c++)t.addEventListener(h,i,!1),a.push([t,h,i]);else if(t.addEventListener(e,i,!1),a.push([t,e,i]),e in I.Touch.TOUCH_MAP)for(var u=function(t){var e;i(t),l&&!o&&t.preventDefault()},c=0;h=I.Touch.TOUCH_MAP[e][c];c++)t.addEventListener(h,u,!1),a.push([t,h,u]);return a},I.browserEvents.bind=function(t,e,o,i){var s=function(t){o?i.call(o,t):i(t)},n=[];if(I.utils.global.PointerEvent&&e in I.Touch.TOUCH_MAP)for(var r=0,l;l=I.Touch.TOUCH_MAP[e][r];r++)t.addEventListener(l,s,!1),n.push([t,l,s]);else if(t.addEventListener(e,s,!1),n.push([t,e,s]),e in I.Touch.TOUCH_MAP)for(var a=function(t){var e;t.changedTouches&&1==t.changedTouches.length&&(e=t.changedTouches[0],t.clientX=e.clientX,t.clientY=e.clientY),s(t),t.preventDefault()},r=0;l=I.Touch.TOUCH_MAP[e][r];r++)t.addEventListener(l,a,!1),n.push([t,l,a]);return n},I.browserEvents.unbind=function(t){for(;t.length;){var e=t.pop(),o=e[2];e[0].removeEventListener(e[1],o,!1)}return o},I.registry={},I.registry.typeMap_={},I.registry.DEFAULT="default",I.registry.Type=function(t){this.name_=t},I.registry.Type.prototype.toString=function(){return this.name_},I.registry.Type.CONNECTION_CHECKER=new I.registry.Type("connectionChecker"),I.registry.Type.CURSOR=new I.registry.Type("cursor"),I.registry.Type.EVENT=new I.registry.Type("event"),I.registry.Type.FIELD=new I.registry.Type("field"),I.registry.Type.RENDERER=new I.registry.Type("renderer"),I.registry.Type.TOOLBOX=new I.registry.Type("toolbox"),I.registry.Type.THEME=new I.registry.Type("theme"),I.registry.Type.TOOLBOX_ITEM=new I.registry.Type("toolboxItem"),I.registry.Type.FLYOUTS_VERTICAL_TOOLBOX=new I.registry.Type("flyoutsVerticalToolbox"),I.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX=new I.registry.Type("flyoutsHorizontalToolbox"),I.registry.Type.METRICS_MANAGER=new I.registry.Type("metricsManager"),I.registry.register=function(t,e,o,i){if(!(t instanceof I.registry.Type)&&"string"!=typeof t||""==String(t).trim())throw Error('Invalid type "'+t+'". The type must be a non-empty string or a Blockly.registry.Type.');if(t=String(t).toLowerCase(),"string"!=typeof e||""==e.trim())throw Error('Invalid name "'+e+'". The name must be a non-empty string.');if(e=e.toLowerCase(),!o)throw Error("Can not register a null value");var s,s=(s=I.registry.typeMap_[t])||(I.registry.typeMap_[t]={});if(I.registry.validate_(t,o),!i&&s[e])throw Error('Name "'+e+'" with type "'+t+'" already registered.');s[e]=o},I.registry.validate_=function(t,e){switch(t){case String(I.registry.Type.FIELD):if("function"!=typeof e.fromJson)throw Error('Type "'+t+'" must have a fromJson function')}},I.registry.unregister=function(t,e){t=String(t).toLowerCase(),e=e.toLowerCase();var o=I.registry.typeMap_[t];o&&o[e]?delete I.registry.typeMap_[t][e]:console.warn("Unable to unregister ["+e+"]["+t+"] from the registry.")},I.registry.getItem_=function(t,e,o){t=String(t).toLowerCase(),e=e.toLowerCase();var i=I.registry.typeMap_[t];if(!i||!i[e]){if(e="Unable to find ["+e+"]["+t+"] in the registry.",o)throw Error(e+" You must require or register a "+t+" plugin.");return console.warn(e),null}return i[e]},I.registry.hasItem=function(t,e){return t=String(t).toLowerCase(),e=e.toLowerCase(),!!(t=I.registry.typeMap_[t])&&!!t[e]},I.registry.getClass=function(t,e,o){return I.registry.getItem_(t,e,o)},I.registry.getObject=function(t,e,o){return I.registry.getItem_(t,e,o)},I.registry.getClassFromOptions=function(t,e,o){return"function"==typeof(e=e.plugins[t.toString()]||I.registry.DEFAULT)?e:I.registry.getClass(t,e,o)},I.Events={},I.Events.group_="",I.Events.recordUndo=!0,I.Events.disabled_=0,I.Events.CREATE="create",I.Events.BLOCK_CREATE=I.Events.CREATE,I.Events.DELETE="delete",I.Events.BLOCK_DELETE=I.Events.DELETE,I.Events.CHANGE="change",I.Events.BLOCK_CHANGE=I.Events.CHANGE,I.Events.MOVE="move",I.Events.BLOCK_MOVE=I.Events.MOVE,I.Events.VAR_CREATE="var_create",I.Events.VAR_DELETE="var_delete",I.Events.VAR_RENAME="var_rename",I.Events.UI="ui",I.Events.BLOCK_DRAG="drag",I.Events.SELECTED="selected",I.Events.CLICK="click",I.Events.MARKER_MOVE="marker_move",I.Events.BUBBLE_OPEN="bubble_open",I.Events.TRASHCAN_OPEN="trashcan_open",I.Events.TOOLBOX_ITEM_SELECT="toolbox_item_select",I.Events.THEME_CHANGE="theme_change",I.Events.VIEWPORT_CHANGE="viewport_change",I.Events.COMMENT_CREATE="comment_create",I.Events.COMMENT_DELETE="comment_delete",I.Events.COMMENT_CHANGE="comment_change",I.Events.COMMENT_MOVE="comment_move",I.Events.FINISHED_LOADING="finished_loading",I.Events.BUMP_EVENTS=[I.Events.BLOCK_CREATE,I.Events.BLOCK_MOVE,I.Events.COMMENT_CREATE,I.Events.COMMENT_MOVE],I.Events.FIRE_QUEUE_=[],I.Events.fire=function(t){I.Events.isEnabled()&&(I.Events.FIRE_QUEUE_.length||setTimeout(I.Events.fireNow_,0),I.Events.FIRE_QUEUE_.push(t))},I.Events.fireNow_=function(){for(var t=I.Events.filter(I.Events.FIRE_QUEUE_,!0),e=I.Events.FIRE_QUEUE_.length=0,o,i;o=t[e];e++){!o.workspaceId||(i=I.Workspace.getById(o.workspaceId))&&i.fireChangeListener(o)}},I.Events.filter=function(t,e){t=t.slice(),e||t.reverse();for(var o=[],i=Object.create(null),s=0,n,r,l,a;n=t[s];s++){n.isNull()||(a=(l=i[r=[n.isUiEvent?I.Events.UI:n.type,n.blockId,n.workspaceId].join(" ")])?l.event:null,l?n.type==I.Events.MOVE&&l.index==s-1?(a.newParentId=n.newParentId,a.newInputName=n.newInputName,a.newCoordinate=n.newCoordinate,l.index=s):n.type==I.Events.CHANGE&&n.element==a.element&&n.name==a.name?a.newValue=n.newValue:n.type==I.Events.CLICK&&a.type==I.Events.BUBBLE_OPEN||(i[r]={event:n,index:s},o.push(n)):(i[r]={event:n,index:s},o.push(n)))}for(t=o.filter(function(t){return!t.isNull()}),e||t.reverse(),s=1;n=t[s];s++)n.type==I.Events.CHANGE&&"mutation"==n.element&&t.unshift(t.splice(s,1)[0]);return t},I.Events.clearPendingUndo=function(){for(var t=0,e;e=I.Events.FIRE_QUEUE_[t];t++)e.recordUndo=!1},I.Events.disable=function(){I.Events.disabled_++},I.Events.enable=function(){I.Events.disabled_--},I.Events.isEnabled=function(){return 0==I.Events.disabled_},I.Events.getGroup=function(){return I.Events.group_},I.Events.setGroup=function(t){I.Events.group_="boolean"==typeof t?t?I.utils.genUid():"":t},I.Events.getDescendantIds=function(t){var e=[];t=t.getDescendants(!1);for(var o=0,i;i=t[o];o++)e[o]=i.id;return e},I.Events.fromJson=function(t,e){var o=I.Events.get(t.type);if(!o)throw Error("Unknown event type.");return(o=new o).fromJson(t),o.workspaceId=e.id,o},I.Events.get=function(t){return I.registry.getClass(I.registry.Type.EVENT,t)},I.Events.disableOrphans=function(t){if((t.type==I.Events.MOVE||t.type==I.Events.CREATE)&&t.workspaceId){var e,o=(e=I.Workspace.getById(t.workspaceId)).getBlockById(t.blockId);if(o){t=I.Events.recordUndo;try{I.Events.recordUndo=!1;var i=o.getParent();if(i&&i.isEnabled())for(var s=o.getDescendants(!1),e=0,n;n=s[e];e++)n.setEnabled(!0);else if((o.outputConnection||o.previousConnection)&&!e.isDragging())do{o.setEnabled(!1),o=o.getNextBlock()}while(o)}finally{I.Events.recordUndo=t}}}},I.Events.Abstract=function(){this.isBlank=null,this.workspaceId=void 0,this.group=I.Events.getGroup(),this.recordUndo=I.Events.recordUndo},I.Events.Abstract.prototype.isUiEvent=!1,I.Events.Abstract.prototype.toJson=function(){var t={type:this.type};return this.group&&(t.group=this.group),t},I.Events.Abstract.prototype.fromJson=function(t){this.isBlank=!1,this.group=t.group},I.Events.Abstract.prototype.isNull=function(){return!1},I.Events.Abstract.prototype.run=function(t){},I.Events.Abstract.prototype.getEventWorkspace_=function(){var t;if(!(t=this.workspaceId?I.Workspace.getById(this.workspaceId):t))throw Error("Workspace is null. Event must have been generated from real Blockly events.");return t},I.utils.object={},I.utils.object.inherits=function(t,e){t.superClass_=e.prototype,t.prototype=Object.create(e.prototype),t.prototype.constructor=t},I.utils.object.mixin=function(t,e){for(var o in e)t[o]=e[o]},I.utils.object.deepMerge=function(t,e){for(var o in e)t[o]=null!=e[o]&&"object"==typeof e[o]?I.utils.object.deepMerge(t[o]||Object.create(null),e[o]):e[o];return t},I.utils.object.values=function(e){return Object.values?Object.values(e):Object.keys(e).map(function(t){return e[t]})},I.utils.xml={},I.utils.xml.NAME_SPACE="https://developers.google.com/blockly/xml",I.utils.xml.document=function(){return document},I.utils.xml.createElement=function(t){return I.utils.xml.document().createElementNS(I.utils.xml.NAME_SPACE,t)},I.utils.xml.createTextNode=function(t){return I.utils.xml.document().createTextNode(t)},I.utils.xml.textToDomDocument=function(t){return(new DOMParser).parseFromString(t,"text/xml")},I.utils.xml.domToText=function(t){return(new XMLSerializer).serializeToString(t)},I.inputTypes={VALUE:I.connectionTypes.INPUT_VALUE,STATEMENT:I.connectionTypes.NEXT_STATEMENT,DUMMY:5},I.utils.Svg=function(t){this.tagName_=t},I.utils.Svg.prototype.toString=function(){return this.tagName_},I.utils.Svg.ANIMATE=new I.utils.Svg("animate"),I.utils.Svg.CIRCLE=new I.utils.Svg("circle"),I.utils.Svg.CLIPPATH=new I.utils.Svg("clipPath"),I.utils.Svg.DEFS=new I.utils.Svg("defs"),I.utils.Svg.FECOMPOSITE=new I.utils.Svg("feComposite"),I.utils.Svg.FECOMPONENTTRANSFER=new I.utils.Svg("feComponentTransfer"),I.utils.Svg.FEFLOOD=new I.utils.Svg("feFlood"),I.utils.Svg.FEFUNCA=new I.utils.Svg("feFuncA"),I.utils.Svg.FEGAUSSIANBLUR=new I.utils.Svg("feGaussianBlur"),I.utils.Svg.FEPOINTLIGHT=new I.utils.Svg("fePointLight"),I.utils.Svg.FESPECULARLIGHTING=new I.utils.Svg("feSpecularLighting"),I.utils.Svg.FILTER=new I.utils.Svg("filter"),I.utils.Svg.FOREIGNOBJECT=new I.utils.Svg("foreignObject"),I.utils.Svg.G=new I.utils.Svg("g"),I.utils.Svg.IMAGE=new I.utils.Svg("image"),I.utils.Svg.LINE=new I.utils.Svg("line"),I.utils.Svg.PATH=new I.utils.Svg("path"),I.utils.Svg.PATTERN=new I.utils.Svg("pattern"),I.utils.Svg.POLYGON=new I.utils.Svg("polygon"),I.utils.Svg.RECT=new I.utils.Svg("rect"),I.utils.Svg.SVG=new I.utils.Svg("svg"),I.utils.Svg.TEXT=new I.utils.Svg("text"),I.utils.Svg.TSPAN=new I.utils.Svg("tspan"),I.utils.dom={},I.utils.dom.SVG_NS="http://www.w3.org/2000/svg",I.utils.dom.HTML_NS="http://www.w3.org/1999/xhtml",I.utils.dom.XLINK_NS="http://www.w3.org/1999/xlink",I.utils.dom.NodeType={ELEMENT_NODE:1,TEXT_NODE:3,COMMENT_NODE:8,DOCUMENT_POSITION_CONTAINED_BY:16},I.utils.dom.cacheWidths_=null,I.utils.dom.cacheReference_=0,I.utils.dom.canvasContext_=null,I.utils.dom.createSvgElement=function(t,e,o){for(var i in t=document.createElementNS(I.utils.dom.SVG_NS,String(t)),e)t.setAttribute(i,e[i]);return document.body.runtimeStyle&&(t.runtimeStyle=t.currentStyle=t.style),o&&o.appendChild(t),t},I.utils.dom.addClass=function(t,e){var o=t.getAttribute("class")||"";if(-1!=(" "+o+" ").indexOf(" "+e+" "))return!1;return o&&(o+=" "),t.setAttribute("class",o+e),!0},I.utils.dom.removeClasses=function(t,e){e=e.split(" ");for(var o=0;o<e.length;o++)I.utils.dom.removeClass(t,e[o])},I.utils.dom.removeClass=function(t,e){var o;if(-1==(" "+(o=t.getAttribute("class"))+" ").indexOf(" "+e+" "))return!1;for(var o=o.split(/\s+/),i=0;i<o.length;i++)o[i]&&o[i]!=e||(o.splice(i,1),i--);return o.length?t.setAttribute("class",o.join(" ")):t.removeAttribute("class"),!0},I.utils.dom.hasClass=function(t,e){return-1!=(" "+t.getAttribute("class")+" ").indexOf(" "+e+" ")},I.utils.dom.removeNode=function(t){return t&&t.parentNode?t.parentNode.removeChild(t):null},I.utils.dom.insertAfter=function(t,e){var o=e.nextSibling;if(!(e=e.parentNode))throw Error("Reference node has no parent.");o?e.insertBefore(t,o):e.appendChild(t)},I.utils.dom.containsNode=function(t,e){return!!(t.compareDocumentPosition(e)&I.utils.dom.NodeType.DOCUMENT_POSITION_CONTAINED_BY)},I.utils.dom.setCssTransform=function(t,e){t.style.transform=e,t.style["-webkit-transform"]=e},I.utils.dom.startTextWidthCache=function(){I.utils.dom.cacheReference_++,I.utils.dom.cacheWidths_||(I.utils.dom.cacheWidths_={})},I.utils.dom.stopTextWidthCache=function(){I.utils.dom.cacheReference_--,I.utils.dom.cacheReference_||(I.utils.dom.cacheWidths_=null)},I.utils.dom.getTextWidth=function(e){var t=e.textContent+"\n"+e.className.baseVal,o;if(I.utils.dom.cacheWidths_&&(o=I.utils.dom.cacheWidths_[t]))return o;try{o=I.utils.userAgent.IE||I.utils.userAgent.EDGE?e.getBBox().width:e.getComputedTextLength()}catch(t){return 8*e.textContent.length}return I.utils.dom.cacheWidths_&&(I.utils.dom.cacheWidths_[t]=o),o},I.utils.dom.getFastTextWidth=function(t,e,o,i){return I.utils.dom.getFastTextWidthWithSizeString(t,e+"pt",o,i)},I.utils.dom.getFastTextWidthWithSizeString=function(t,e,o,i){var s=t.textContent,n;if(t=s+"\n"+t.className.baseVal,I.utils.dom.cacheWidths_&&(n=I.utils.dom.cacheWidths_[t]))return n;return I.utils.dom.canvasContext_||((n=document.createElement("canvas")).className="blocklyComputeCanvas",document.body.appendChild(n),I.utils.dom.canvasContext_=n.getContext("2d")),I.utils.dom.canvasContext_.font=o+" "+e+" "+i,n=I.utils.dom.canvasContext_.measureText(s).width,I.utils.dom.cacheWidths_&&(I.utils.dom.cacheWidths_[t]=n),n},I.utils.dom.measureFontMetrics=function(t,e,o,i){var s=document.createElement("span");s.style.font=o+" "+e+" "+i,s.textContent=t,(t=document.createElement("div")).style.width="1px",t.style.height="0px",(e=document.createElement("div")).setAttribute("style","position: fixed; top: 0; left: 0; display: flex;"),e.appendChild(s),e.appendChild(t),document.body.appendChild(e);try{o={},e.style.alignItems="baseline",o.baseline=t.offsetTop-s.offsetTop,e.style.alignItems="flex-end",o.height=t.offsetTop-s.offsetTop}finally{document.body.removeChild(e)}return o},I.Xml={},I.Xml.workspaceToDom=function(t,e){var o=I.utils.xml.createElement("xml"),i;(i=I.Xml.variablesToDom(I.Variables.allUsedVarModels(t))).hasChildNodes()&&o.appendChild(i);for(var s=t.getTopComments(!0),i=0,n;n=s[i];i++)o.appendChild(n.toXmlWithXY(e));for(t=t.getTopBlocks(!0),i=0;s=t[i];i++)o.appendChild(I.Xml.blockToDomWithXY(s,e));return o},I.Xml.variablesToDom=function(t){for(var e=I.utils.xml.createElement("variables"),o=0,i;i=t[o];o++){var s=I.utils.xml.createElement("variable");s.appendChild(I.utils.xml.createTextNode(i.name)),i.type&&s.setAttribute("type",i.type),s.id=i.getId(),e.appendChild(s)}return e},I.Xml.blockToDomWithXY=function(t,e){if(t.isInsertionMarker()&&!(t=t.getChildren(!1)[0]))return new DocumentFragment;var o;t.workspace.RTL&&(o=t.workspace.getWidth()),e=I.Xml.blockToDom(t,e);var i=t.getRelativeToSurfaceXY();return e.setAttribute("x",Math.round(t.workspace.RTL?o-i.x:i.x)),e.setAttribute("y",Math.round(i.y)),e},I.Xml.fieldToDom_=function(t){if(t.isSerializable()){var e=I.utils.xml.createElement("field");return e.setAttribute("name",t.name||""),t.toXml(e)}return null},I.Xml.allFieldsToDom_=function(t,e){for(var o=0,i;i=t.inputList[o];o++)for(var s=0,n;n=i.fieldRow[s];s++)(n=I.Xml.fieldToDom_(n))&&e.appendChild(n)},I.Xml.blockToDom=function(t,e){if(t.isInsertionMarker())return(t=t.getChildren(!1)[0])?I.Xml.blockToDom(t):new DocumentFragment;var o=I.utils.xml.createElement(t.isShadow()?"shadow":"block"),i,s,n,r;for(o.setAttribute("type",t.type),e||o.setAttribute("id",t.id),!t.mutationToDom||(i=t.mutationToDom())&&(i.hasChildNodes()||i.hasAttributes())&&o.appendChild(i),I.Xml.allFieldsToDom_(t,o),(i=t.getCommentText())&&(s=t.commentModel.size,n=t.commentModel.pinned,(r=I.utils.xml.createElement("comment")).appendChild(I.utils.xml.createTextNode(i)),r.setAttribute("pinned",n),r.setAttribute("h",s.height),r.setAttribute("w",s.width),o.appendChild(r)),t.data&&((i=I.utils.xml.createElement("data")).appendChild(I.utils.xml.createTextNode(t.data)),o.appendChild(i)),i=0;s=t.inputList[i];i++){var l,a,n=!0;s.type!=I.inputTypes.DUMMY&&(a=s.connection.targetBlock(),s.type==I.inputTypes.VALUE?l=I.utils.xml.createElement("value"):s.type==I.inputTypes.STATEMENT&&(l=I.utils.xml.createElement("statement")),!(r=s.connection.getShadowDom())||a&&a.isShadow()||l.appendChild(I.Xml.cloneShadow_(r,e)),!a||(r=I.Xml.blockToDom(a,e)).nodeType==I.utils.dom.NodeType.ELEMENT_NODE&&(l.appendChild(r),n=!1),l.setAttribute("name",s.name),n||o.appendChild(l))}return null!=t.inputsInline&&t.inputsInline!=t.inputsInlineDefault&&o.setAttribute("inline",t.inputsInline),t.isCollapsed()&&o.setAttribute("collapsed",!0),t.isEnabled()||o.setAttribute("disabled",!0),t.isDeletable()||t.isShadow()||o.setAttribute("deletable",!1),t.isMovable()||t.isShadow()||o.setAttribute("movable",!1),t.isEditable()||o.setAttribute("editable",!1),!(i=t.getNextBlock())||(r=I.Xml.blockToDom(i,e)).nodeType==I.utils.dom.NodeType.ELEMENT_NODE&&((l=I.utils.xml.createElement("next")).appendChild(r),o.appendChild(l)),!(r=t.nextConnection&&t.nextConnection.getShadowDom())||i&&i.isShadow()||l.appendChild(I.Xml.cloneShadow_(r,e)),o},I.Xml.cloneShadow_=function(t,e){for(var o=t=t.cloneNode(!0),i;o;)if(e&&"shadow"==o.nodeName&&o.removeAttribute("id"),o.firstChild)o=o.firstChild;else{for(;o&&!o.nextSibling;)o=(i=o).parentNode,i.nodeType==I.utils.dom.NodeType.TEXT_NODE&&""==i.data.trim()&&o.firstChild!=i&&I.utils.dom.removeNode(i);o&&(o=(i=o).nextSibling,i.nodeType==I.utils.dom.NodeType.TEXT_NODE&&""==i.data.trim()&&I.utils.dom.removeNode(i))}return t},I.Xml.domToText=function(t){return I.utils.xml.domToText(t).replace(/<(\w+)([^<]*)\/>/g,"<$1$2></$1>")},I.Xml.domToPrettyText=function(t){t=I.Xml.domToText(t).split("<");for(var e="",o=1;o<t.length;o++){var i=t[o];"/"==i[0]&&(e=e.substring(2)),t[o]=e+"<"+i,"/"!=i[0]&&"/>"!=i.slice(-2)&&(e+="  ")}return(t=(t=t.join("\n")).replace(/(<(\w+)\b[^>]*>[^\n]*)\n *<\/\2>/g,"$1</$2>")).replace(/^\n/,"")},I.Xml.textToDom=function(t){var e=I.utils.xml.textToDomDocument(t);if(!e||!e.documentElement||e.getElementsByTagName("parsererror").length)throw Error("textToDom was unable to parse: "+t);return e.documentElement},I.Xml.clearWorkspaceAndLoadFromXml=function(t,e){return e.setResizesEnabled(!1),e.clear(),t=I.Xml.domToWorkspace(t,e),e.setResizesEnabled(!0),t},I.Xml.domToWorkspace=function(t,e){var o,i;t instanceof I.Workspace&&(o=t,t=e,e=o,console.warn("Deprecated call to Blockly.Xml.domToWorkspace, swap the arguments.")),e.RTL&&(i=e.getWidth()),o=[],I.utils.dom.startTextWidthCache();var s=I.Events.getGroup();s||I.Events.setGroup(!0),e.setResizesEnabled&&e.setResizesEnabled(!1);var n=!0;try{for(var r=0,l;l=t.childNodes[r];r++){var a=l.nodeName.toLowerCase(),c=l;if("block"==a||"shadow"==a&&!I.Events.recordUndo){var h=I.Xml.domToBlock(c,e);o.push(h.id);var u=c.hasAttribute("x")?parseInt(c.getAttribute("x"),10):10,p=c.hasAttribute("y")?parseInt(c.getAttribute("y"),10):10;isNaN(u)||isNaN(p)||h.moveBy(e.RTL?i-u:u,p),n=!1}else{if("shadow"==a)throw TypeError("Shadow block cannot be a top-level block.");if("comment"==a)e.rendered?I.WorkspaceCommentSvg?I.WorkspaceCommentSvg.fromXml(c,e,i):console.warn("Missing require for Blockly.WorkspaceCommentSvg, ignoring workspace comment."):I.WorkspaceComment?I.WorkspaceComment.fromXml(c,e):console.warn("Missing require for Blockly.WorkspaceComment, ignoring workspace comment.");else if("variables"==a){if(!n)throw Error("'variables' tag must exist once before block and shadow tag elements in the workspace XML, but it was found in another location.");I.Xml.domToVariables(c,e),n=!1}}}}finally{s||I.Events.setGroup(!1),I.utils.dom.stopTextWidthCache()}return e.setResizesEnabled&&e.setResizesEnabled(!0),I.Events.fire(new(I.Events.get(I.Events.FINISHED_LOADING))(e)),o},I.Xml.appendDomToWorkspace=function(t,e){var o;if(Object.prototype.hasOwnProperty.call(e,"scale")&&(o=e.getBlocksBoundingBox()),t=I.Xml.domToWorkspace(t,e),o&&o.top!=o.bottom){for(var i=o.bottom,s=e.RTL?o.right:o.left,n=1/0,r=-(1/0),l=1/0,o=0;o<t.length;o++){var a=e.getBlockById(t[o]).getRelativeToSurfaceXY();a.y<l&&(l=a.y),a.x<n&&(n=a.x),a.x>r&&(r=a.x)}for(i=i-l+10,s=e.RTL?s-r:s-n,o=0;o<t.length;o++)e.getBlockById(t[o]).moveBy(s,i)}return t},I.Xml.domToBlock=function(t,e){var o;t instanceof I.Workspace&&(o=t,t=e,e=o,console.warn("Deprecated call to Blockly.Xml.domToBlock, swap the arguments.")),I.Events.disable(),o=e.getAllVariables();try{var i=I.Xml.domToBlockHeadless_(t,e),s=i.getDescendants(!1);if(e.rendered){i.setConnectionTracking(!1);for(var n=s.length-1;0<=n;n--)s[n].initSvg();for(n=s.length-1;0<=n;n--)s[n].render(!1);setTimeout(function(){i.disposed||i.setConnectionTracking(!0)},1),i.updateDisabled(),e.resizeContents()}else for(n=s.length-1;0<=n;n--)s[n].initModel()}finally{I.Events.enable()}if(I.Events.isEnabled()){for(t=I.Variables.getAddedVariables(e,o),n=0;n<t.length;n++)e=t[n],I.Events.fire(new(I.Events.get(I.Events.VAR_CREATE))(e));I.Events.fire(new(I.Events.get(I.Events.CREATE))(i))}return i},I.Xml.domToVariables=function(t,e){for(var o=0,i,s,n;i=t.childNodes[o];o++){i.nodeType==I.utils.dom.NodeType.ELEMENT_NODE&&(s=i.getAttribute("type"),n=i.getAttribute("id"),e.createVariable(i.textContent,s,n))}},I.Xml.mapSupportedXmlTags_=function(t){for(var e={mutation:[],comment:[],data:[],field:[],input:[],next:[]},o=0,i;i=t.childNodes[o];o++)if(i.nodeType!=I.utils.dom.NodeType.TEXT_NODE)switch(i.nodeName.toLowerCase()){case"mutation":e.mutation.push(i);break;case"comment":if(!I.Comment){console.warn("Missing require for Blockly.Comment, ignoring block comment.");break}e.comment.push(i);break;case"data":e.data.push(i);break;case"title":case"field":e.field.push(i);break;case"value":case"statement":e.input.push(i);break;case"next":e.next.push(i);break;default:console.warn("Ignoring unknown tag: "+i.nodeName)}return e},I.Xml.applyMutationTagNodes_=function(t,e){for(var o=!1,i=0,s;s=t[i];i++)e.domToMutation&&(e.domToMutation(s),e.initSvg&&(o=!0));return o},I.Xml.applyCommentTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++){var s=i.textContent,n="true"==i.getAttribute("pinned"),r=parseInt(i.getAttribute("w"),10),i=parseInt(i.getAttribute("h"),10);e.setCommentText(s),e.commentModel.pinned=n,isNaN(r)||isNaN(i)||(e.commentModel.size=new I.utils.Size(r,i)),n&&e.getCommentIcon&&!e.isInFlyout&&setTimeout(function(){e.getCommentIcon().setVisible(!0)},1)}},I.Xml.applyDataTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++)e.data=i.textContent},I.Xml.applyFieldTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++){var s=i.getAttribute("name");I.Xml.domToField_(e,s,i)}},I.Xml.findChildBlocks_=function(t){for(var e={childBlockElement:null,childShadowElement:null},o=0,i;i=t.childNodes[o];o++)i.nodeType==I.utils.dom.NodeType.ELEMENT_NODE&&("block"==i.nodeName.toLowerCase()?e.childBlockElement=i:"shadow"==i.nodeName.toLowerCase()&&(e.childShadowElement=i));return e},I.Xml.applyInputTagNodes_=function(t,e,o,i){for(var s=0,n;n=t[s];s++){var r=n.getAttribute("name"),l=o.getInput(r);if(!l){console.warn("Ignoring non-existent input "+r+" in block "+i);break}if((n=I.Xml.findChildBlocks_(n)).childBlockElement){if(!l.connection)throw TypeError("Input connection does not exist.");I.Xml.domToBlockHeadless_(n.childBlockElement,e,l.connection,!1)}n.childShadowElement&&l.connection.setShadowDom(n.childShadowElement)}},I.Xml.applyNextTagNodes_=function(t,e,o){for(var i=0,s;s=t[i];i++){if((s=I.Xml.findChildBlocks_(s)).childBlockElement){if(!o.nextConnection)throw TypeError("Next statement does not exist.");if(o.nextConnection.isConnected())throw TypeError("Next statement is already connected.");I.Xml.domToBlockHeadless_(s.childBlockElement,e,o.nextConnection,!0)}s.childShadowElement&&o.nextConnection&&o.nextConnection.setShadowDom(s.childShadowElement)}},I.Xml.domToBlockHeadless_=function(t,e,o,i){var s=t.getAttribute("type");if(!s)throw TypeError("Block type unspecified: "+t.outerHTML);var n=t.getAttribute("id"),n=e.newBlock(s,n),r=I.Xml.mapSupportedXmlTags_(t),l=I.Xml.applyMutationTagNodes_(r.mutation,n);if(I.Xml.applyCommentTagNodes_(r.comment,n),I.Xml.applyDataTagNodes_(r.data,n),o)if(i){if(!n.previousConnection)throw TypeError("Next block does not have previous statement.");o.connect(n.previousConnection)}else if(n.outputConnection)o.connect(n.outputConnection);else{if(!n.previousConnection)throw TypeError("Child block does not have output or previous statement.");o.connect(n.previousConnection)}if(I.Xml.applyFieldTagNodes_(r.field,n),I.Xml.applyInputTagNodes_(r.input,e,n,s),I.Xml.applyNextTagNodes_(r.next,e,n),l&&n.initSvg(),(e=t.getAttribute("inline"))&&n.setInputsInline("true"==e),(e=t.getAttribute("disabled"))&&n.setEnabled("true"!=e&&"disabled"!=e),(e=t.getAttribute("deletable"))&&n.setDeletable("true"==e),(e=t.getAttribute("movable"))&&n.setMovable("true"==e),(e=t.getAttribute("editable"))&&n.setEditable("true"==e),(e=t.getAttribute("collapsed"))&&n.setCollapsed("true"==e),"shadow"==t.nodeName.toLowerCase()){for(t=n.getChildren(!1),e=0;o=t[e];e++)if(!o.isShadow())throw TypeError("Shadow block not allowed non-shadow child.");if(n.getVarModels().length)throw TypeError("Shadow blocks cannot have variable references.");n.setShadow(!0)}return n},I.Xml.domToField_=function(t,e,o){var i=t.getField(e);i?i.fromXml(o):console.warn("Ignoring non-existent field "+e+" in block "+t.type)},I.Xml.deleteNext=function(t){for(var e=0,o;o=t.childNodes[e];e++)if("next"==o.nodeName.toLowerCase()){t.removeChild(o);break}},I.Events.BlockBase=function(t){I.Events.BlockBase.superClass_.constructor.call(this),this.blockId=(this.isBlank=void 0===t)?"":t.id,this.workspaceId=this.isBlank?"":t.workspace.id},I.utils.object.inherits(I.Events.BlockBase,I.Events.Abstract),I.Events.BlockBase.prototype.toJson=function(){var t=I.Events.BlockBase.superClass_.toJson.call(this);return t.blockId=this.blockId,t},I.Events.BlockBase.prototype.fromJson=function(t){I.Events.BlockBase.superClass_.fromJson.call(this,t),this.blockId=t.blockId},I.Events.Change=function(t,e,o,i,s){I.Events.Change.superClass_.constructor.call(this,t),t&&(this.element=void 0===e?"":e,this.name=void 0===o?"":o,this.oldValue=void 0===i?"":i,this.newValue=void 0===s?"":s)},I.utils.object.inherits(I.Events.Change,I.Events.BlockBase),I.Events.BlockChange=I.Events.Change,I.Events.Change.prototype.type=I.Events.CHANGE,I.Events.Change.prototype.toJson=function(){var t=I.Events.Change.superClass_.toJson.call(this);return t.element=this.element,this.name&&(t.name=this.name),t.oldValue=this.oldValue,t.newValue=this.newValue,t},I.Events.Change.prototype.fromJson=function(t){I.Events.Change.superClass_.fromJson.call(this,t),this.element=t.element,this.name=t.name,this.oldValue=t.oldValue,this.newValue=t.newValue},I.Events.Change.prototype.isNull=function(){return this.oldValue==this.newValue},I.Events.Change.prototype.run=function(t){var e=this.getEventWorkspace_().getBlockById(this.blockId);if(e)switch(e.mutator&&e.mutator.setVisible(!1),t=t?this.newValue:this.oldValue,this.element){case"field":(e=e.getField(this.name))?e.setValue(t):console.warn("Can't set non-existent field: "+this.name);break;case"comment":e.setCommentText(t||null);break;case"collapsed":e.setCollapsed(!!t);break;case"disabled":e.setEnabled(!t);break;case"inline":e.setInputsInline(!!t);break;case"mutation":var o="",i;e.mutationToDom&&(o=(o=e.mutationToDom())&&I.Xml.domToText(o)),e.domToMutation&&(i=I.Xml.textToDom(t||"<mutation/>"),e.domToMutation(i)),I.Events.fire(new(I.Events.get(I.Events.CHANGE))(e,"mutation",null,o,t));break;default:console.warn("Unknown change type: "+this.element)}else console.warn("Can't change non-existent block: "+this.blockId)},I.Events.Create=function(t){I.Events.Create.superClass_.constructor.call(this,t),t&&(t.isShadow()&&(this.recordUndo=!1),this.xml=t.workspace.rendered?I.Xml.blockToDomWithXY(t):I.Xml.blockToDom(t),this.ids=I.Events.getDescendantIds(t))},I.utils.object.inherits(I.Events.Create,I.Events.BlockBase),I.Events.BlockCreate=I.Events.Create,I.Events.Create.prototype.type=I.Events.CREATE,I.Events.Create.prototype.toJson=function(){var t=I.Events.Create.superClass_.toJson.call(this);return t.xml=I.Xml.domToText(this.xml),t.ids=this.ids,this.recordUndo||(t.recordUndo=this.recordUndo),t},I.Events.Create.prototype.fromJson=function(t){I.Events.Create.superClass_.fromJson.call(this,t),this.xml=I.Xml.textToDom(t.xml),this.ids=t.ids,void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},I.Events.Create.prototype.run=function(t){var e=this.getEventWorkspace_(),o;if(t)(t=I.utils.xml.createElement("xml")).appendChild(this.xml),I.Xml.domToWorkspace(t,e);else{t=0;for(;o=this.ids[t];t++){var i=e.getBlockById(o);i?i.dispose(!1):o==this.blockId&&console.warn("Can't uncreate non-existent block: "+o)}}},I.Events.Delete=function(t){if(I.Events.Delete.superClass_.constructor.call(this,t),t){if(t.getParent())throw Error("Connected blocks cannot be deleted.");t.isShadow()&&(this.recordUndo=!1),this.oldXml=t.workspace.rendered?I.Xml.blockToDomWithXY(t):I.Xml.blockToDom(t),this.ids=I.Events.getDescendantIds(t)}},I.utils.object.inherits(I.Events.Delete,I.Events.BlockBase),I.Events.BlockDelete=I.Events.Delete,I.Events.Delete.prototype.type=I.Events.DELETE,I.Events.Delete.prototype.toJson=function(){var t=I.Events.Delete.superClass_.toJson.call(this);return t.oldXml=I.Xml.domToText(this.oldXml),t.ids=this.ids,this.recordUndo||(t.recordUndo=this.recordUndo),t},I.Events.Delete.prototype.fromJson=function(t){I.Events.Delete.superClass_.fromJson.call(this,t),this.oldXml=I.Xml.textToDom(t.oldXml),this.ids=t.ids,void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},I.Events.Delete.prototype.run=function(t){var e=this.getEventWorkspace_(),o;if(t){t=0;for(;o=this.ids[t];t++){var i=e.getBlockById(o);i?i.dispose(!1):o==this.blockId&&console.warn("Can't delete non-existent block: "+o)}}else(t=I.utils.xml.createElement("xml")).appendChild(this.oldXml),I.Xml.domToWorkspace(t,e)},I.Events.Move=function(t){I.Events.Move.superClass_.constructor.call(this,t),t&&(t.isShadow()&&(this.recordUndo=!1),t=this.currentLocation_(),this.oldParentId=t.parentId,this.oldInputName=t.inputName,this.oldCoordinate=t.coordinate)},I.utils.object.inherits(I.Events.Move,I.Events.BlockBase),I.Events.BlockMove=I.Events.Move,I.Events.Move.prototype.type=I.Events.MOVE,I.Events.Move.prototype.toJson=function(){var t=I.Events.Move.superClass_.toJson.call(this);return this.newParentId&&(t.newParentId=this.newParentId),this.newInputName&&(t.newInputName=this.newInputName),this.newCoordinate&&(t.newCoordinate=Math.round(this.newCoordinate.x)+","+Math.round(this.newCoordinate.y)),this.recordUndo||(t.recordUndo=this.recordUndo),t},I.Events.Move.prototype.fromJson=function(t){var e;I.Events.Move.superClass_.fromJson.call(this,t),this.newParentId=t.newParentId,this.newInputName=t.newInputName,t.newCoordinate&&(e=t.newCoordinate.split(","),this.newCoordinate=new I.utils.Coordinate(Number(e[0]),Number(e[1]))),void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},I.Events.Move.prototype.recordNew=function(){var t=this.currentLocation_();this.newParentId=t.parentId,this.newInputName=t.inputName,this.newCoordinate=t.coordinate},I.Events.Move.prototype.currentLocation_=function(){var t=this.getEventWorkspace_().getBlockById(this.blockId),e={},o=t.getParent();return o?(e.parentId=o.id,(t=o.getInputWithBlock(t))&&(e.inputName=t.name)):e.coordinate=t.getRelativeToSurfaceXY(),e},I.Events.Move.prototype.isNull=function(){return this.oldParentId==this.newParentId&&this.oldInputName==this.newInputName&&I.utils.Coordinate.equals(this.oldCoordinate,this.newCoordinate)},I.Events.Move.prototype.run=function(t){var e,o;if(o=(e=this.getEventWorkspace_()).getBlockById(this.blockId)){var i=t?this.newParentId:this.oldParentId,s=t?this.newInputName:this.oldInputName,n=t?this.newCoordinate:this.oldCoordinate,r,o,e;if(t=null,i&&!(t=e.getBlockById(i)))return void console.warn("Can't connect to non-existent block: "+i);o.getParent()&&o.unplug(),n?(s=o.getRelativeToSurfaceXY(),o.moveBy(n.x-s.x,n.y-s.y)):(e=(o=o.outputConnection||o.previousConnection).type,s?(t=t.getInput(s))&&(r=t.connection):e==I.connectionTypes.PREVIOUS_STATEMENT&&(r=t.nextConnection),r?o.connect(r):console.warn("Can't connect to non-existent input: "+s))}else console.warn("Can't move non-existent block: "+this.blockId)},I.registry.register(I.registry.Type.EVENT,I.Events.CREATE,I.Events.Create),I.registry.register(I.registry.Type.EVENT,I.Events.DELETE,I.Events.Delete),I.registry.register(I.registry.Type.EVENT,I.Events.CHANGE,I.Events.Change),I.registry.register(I.registry.Type.EVENT,I.Events.MOVE,I.Events.Move),I.Events.FinishedLoading=function(t){this.isBlank=void 0===t,this.workspaceId=t?t.id:"",this.group=I.Events.getGroup(),this.recordUndo=!1},I.utils.object.inherits(I.Events.FinishedLoading,I.Events.Abstract),I.Events.FinishedLoading.prototype.type=I.Events.FINISHED_LOADING,I.Events.FinishedLoading.prototype.toJson=function(){var t={type:this.type};return this.group&&(t.group=this.group),this.workspaceId&&(t.workspaceId=this.workspaceId),t},I.Events.FinishedLoading.prototype.fromJson=function(t){this.isBlank=!1,this.workspaceId=t.workspaceId,this.group=t.group},I.registry.register(I.registry.Type.EVENT,I.Events.FINISHED_LOADING,I.Events.FinishedLoading),I.Events.UiBase=function(t){I.Events.UiBase.superClass_.constructor.call(this),this.isBlank=void 0===t,this.workspaceId=t||"",this.recordUndo=!1},I.utils.object.inherits(I.Events.UiBase,I.Events.Abstract),I.Events.UiBase.prototype.isUiEvent=!0,I.Events.Ui=function(t,e,o,i){I.Events.Ui.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.element=void 0===e?"":e,this.oldValue=void 0===o?"":o,this.newValue=void 0===i?"":i},I.utils.object.inherits(I.Events.Ui,I.Events.UiBase),I.Events.Ui.prototype.type=I.Events.UI,I.Events.Ui.prototype.toJson=function(){var t=I.Events.Ui.superClass_.toJson.call(this);return t.element=this.element,void 0!==this.newValue&&(t.newValue=this.newValue),this.blockId&&(t.blockId=this.blockId),t},I.Events.Ui.prototype.fromJson=function(t){I.Events.Ui.superClass_.fromJson.call(this,t),this.element=t.element,this.newValue=t.newValue,this.blockId=t.blockId},I.registry.register(I.registry.Type.EVENT,I.Events.UI,I.Events.Ui),I.Events.VarBase=function(t){I.Events.VarBase.superClass_.constructor.call(this),this.varId=(this.isBlank=void 0===t)?"":t.getId(),this.workspaceId=this.isBlank?"":t.workspace.id},I.utils.object.inherits(I.Events.VarBase,I.Events.Abstract),I.Events.VarBase.prototype.toJson=function(){var t=I.Events.VarBase.superClass_.toJson.call(this);return t.varId=this.varId,t},I.Events.VarBase.prototype.fromJson=function(t){I.Events.VarBase.superClass_.toJson.call(this),this.varId=t.varId},I.Events.VarCreate=function(t){I.Events.VarCreate.superClass_.constructor.call(this,t),t&&(this.varType=t.type,this.varName=t.name)},I.utils.object.inherits(I.Events.VarCreate,I.Events.VarBase),I.Events.VarCreate.prototype.type=I.Events.VAR_CREATE,I.Events.VarCreate.prototype.toJson=function(){var t=I.Events.VarCreate.superClass_.toJson.call(this);return t.varType=this.varType,t.varName=this.varName,t},I.Events.VarCreate.prototype.fromJson=function(t){I.Events.VarCreate.superClass_.fromJson.call(this,t),this.varType=t.varType,this.varName=t.varName},I.Events.VarCreate.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.createVariable(this.varName,this.varType,this.varId):e.deleteVariableById(this.varId)},I.Events.VarDelete=function(t){I.Events.VarDelete.superClass_.constructor.call(this,t),t&&(this.varType=t.type,this.varName=t.name)},I.utils.object.inherits(I.Events.VarDelete,I.Events.VarBase),I.Events.VarDelete.prototype.type=I.Events.VAR_DELETE,I.Events.VarDelete.prototype.toJson=function(){var t=I.Events.VarDelete.superClass_.toJson.call(this);return t.varType=this.varType,t.varName=this.varName,t},I.Events.VarDelete.prototype.fromJson=function(t){I.Events.VarDelete.superClass_.fromJson.call(this,t),this.varType=t.varType,this.varName=t.varName},I.Events.VarDelete.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.deleteVariableById(this.varId):e.createVariable(this.varName,this.varType,this.varId)},I.Events.VarRename=function(t,e){I.Events.VarRename.superClass_.constructor.call(this,t),t&&(this.oldName=t.name,this.newName=void 0===e?"":e)},I.utils.object.inherits(I.Events.VarRename,I.Events.VarBase),I.Events.VarRename.prototype.type=I.Events.VAR_RENAME,I.Events.VarRename.prototype.toJson=function(){var t=I.Events.VarRename.superClass_.toJson.call(this);return t.oldName=this.oldName,t.newName=this.newName,t},I.Events.VarRename.prototype.fromJson=function(t){I.Events.VarRename.superClass_.fromJson.call(this,t),this.oldName=t.oldName,this.newName=t.newName},I.Events.VarRename.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.renameVariableById(this.varId,this.newName):e.renameVariableById(this.varId,this.oldName)},I.registry.register(I.registry.Type.EVENT,I.Events.VAR_CREATE,I.Events.VarCreate),I.registry.register(I.registry.Type.EVENT,I.Events.VAR_DELETE,I.Events.VarDelete),I.registry.register(I.registry.Type.EVENT,I.Events.VAR_RENAME,I.Events.VarRename),I.BlockDragSurfaceSvg=function(t){this.container_=t,this.createDom()},I.BlockDragSurfaceSvg.prototype.SVG_=null,I.BlockDragSurfaceSvg.prototype.dragGroup_=null,I.BlockDragSurfaceSvg.prototype.container_=null,I.BlockDragSurfaceSvg.prototype.scale_=1,I.BlockDragSurfaceSvg.prototype.surfaceXY_=null,I.BlockDragSurfaceSvg.prototype.createDom=function(){this.SVG_||(this.SVG_=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{xmlns:I.utils.dom.SVG_NS,"xmlns:html":I.utils.dom.HTML_NS,"xmlns:xlink":I.utils.dom.XLINK_NS,version:"1.1",class:"blocklyBlockDragSurface"},this.container_),this.dragGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},this.SVG_))},I.BlockDragSurfaceSvg.prototype.setBlocksAndShow=function(t){if(this.dragGroup_.childNodes.length)throw Error("Already dragging a block.");this.dragGroup_.appendChild(t),this.SVG_.style.display="block",this.surfaceXY_=new I.utils.Coordinate(0,0)},I.BlockDragSurfaceSvg.prototype.translateAndScaleGroup=function(t,e,o){this.scale_=o,t=t.toFixed(0),e=e.toFixed(0),this.dragGroup_.setAttribute("transform","translate("+t+","+e+") scale("+o+")")},I.BlockDragSurfaceSvg.prototype.translateSurfaceInternal_=function(){var t=this.surfaceXY_.x,e=this.surfaceXY_.y,t=t.toFixed(0),e=e.toFixed(0);this.SVG_.style.display="block",I.utils.dom.setCssTransform(this.SVG_,"translate3d("+t+"px, "+e+"px, 0px)")},I.BlockDragSurfaceSvg.prototype.translateSurface=function(t,e){this.surfaceXY_=new I.utils.Coordinate(t*this.scale_,e*this.scale_),this.translateSurfaceInternal_()},I.BlockDragSurfaceSvg.prototype.getSurfaceTranslation=function(){var t=I.utils.getRelativeXY(this.SVG_);return new I.utils.Coordinate(t.x/this.scale_,t.y/this.scale_)},I.BlockDragSurfaceSvg.prototype.getGroup=function(){return this.dragGroup_},I.BlockDragSurfaceSvg.prototype.getCurrentBlock=function(){return this.dragGroup_.firstChild},I.BlockDragSurfaceSvg.prototype.clearAndHide=function(t){if(t?t.appendChild(this.getCurrentBlock()):this.dragGroup_.removeChild(this.getCurrentBlock()),this.SVG_.style.display="none",this.dragGroup_.childNodes.length)throw Error("Drag group was not cleared.");this.surfaceXY_=null},I.Css={},I.Css.injected_=!1,I.Css.register=function(t){if(I.Css.injected_)throw Error("CSS already injected");Array.prototype.push.apply(I.Css.CONTENT,t),t.length=0},I.Css.inject=function(t,e){var o;I.Css.injected_||(I.Css.injected_=!0,o=I.Css.CONTENT.join("\n"),I.Css.CONTENT.length=0,t&&(t=e.replace(/[\\/]$/,""),o=o.replace(/<<<PATH>>>/g,t),(t=document.createElement("style")).id="blockly-common-style",o=document.createTextNode(o),t.appendChild(o),document.head.insertBefore(t,document.head.firstChild)))},I.Css.CONTENT=[".blocklySvg {","background-color: #fff;","outline: none;","overflow: hidden;","position: absolute;","display: block;","}",".blocklyWidgetDiv {","display: none;","position: absolute;","z-index: 99999;","}",".injectionDiv {","height: 100%;","position: relative;","overflow: hidden;","touch-action: none;","}",".blocklyNonSelectable {","user-select: none;","-ms-user-select: none;","-webkit-user-select: none;","}",".blocklyWsDragSurface {","display: none;","position: absolute;","top: 0;","left: 0;","}",".blocklyWsDragSurface.blocklyOverflowVisible {","overflow: visible;","}",".blocklyBlockDragSurface {","display: none;","position: absolute;","top: 0;","left: 0;","right: 0;","bottom: 0;","overflow: visible !important;","z-index: 50;","}",".blocklyBlockCanvas.blocklyCanvasTransitioning,",".blocklyBubbleCanvas.blocklyCanvasTransitioning {","transition: transform .5s;","}",".blocklyTooltipDiv {","background-color: #ffffc7;","border: 1px solid #ddc;","box-shadow: 4px 4px 20px 1px rgba(0,0,0,.15);","color: #000;","display: none;","font: 9pt sans-serif;","opacity: .9;","padding: 2px;","position: absolute;","z-index: 100000;","}",".blocklyDropDownDiv {","position: absolute;","left: 0;","top: 0;","z-index: 10000;","display: none;","border: 1px solid;","border-color: #dadce0;","background-color: #fff;","border-radius: 2px;","padding: 4px;","box-shadow: 0 0 3px 1px rgba(0,0,0,.3);","}",".blocklyDropDownDiv.blocklyFocused {","box-shadow: 0 0 6px 1px rgba(0,0,0,.3);","}",".blocklyDropDownContent {","max-height: 300px;","overflow: auto;","overflow-x: hidden;","position: relative;","}",".blocklyDropDownArrow {","position: absolute;","left: 0;","top: 0;","width: 16px;","height: 16px;","z-index: -1;","background-color: inherit;","border-color: inherit;","}",".blocklyDropDownButton {","display: inline-block;","float: left;","padding: 0;","margin: 4px;","border-radius: 4px;","outline: none;","border: 1px solid;","transition: box-shadow .1s;","cursor: pointer;","}",".blocklyArrowTop {","border-top: 1px solid;","border-left: 1px solid;","border-top-left-radius: 4px;","border-color: inherit;","}",".blocklyArrowBottom {","border-bottom: 1px solid;","border-right: 1px solid;","border-bottom-right-radius: 4px;","border-color: inherit;","}",".blocklyResizeSE {","cursor: se-resize;","fill: #aaa;","}",".blocklyResizeSW {","cursor: sw-resize;","fill: #aaa;","}",".blocklyResizeLine {","stroke: #515A5A;","stroke-width: 1;","}",".blocklyHighlightedConnectionPath {","fill: none;","stroke: #fc3;","stroke-width: 4px;","}",".blocklyPathLight {","fill: none;","stroke-linecap: round;","stroke-width: 1;","}",".blocklySelected>.blocklyPathLight {","display: none;","}",".blocklyDraggable {",'cursor: url("<<<PATH>>>/handopen.cur"), auto;',"cursor: grab;","cursor: -webkit-grab;","}",".blocklyDragging {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyDraggable:active {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyBlockDragSurface .blocklyDraggable {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyDragging.blocklyDraggingDelete {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyDragging>.blocklyPath,",".blocklyDragging>.blocklyPathLight {","fill-opacity: .8;","stroke-opacity: .8;","}",".blocklyDragging>.blocklyPathDark {","display: none;","}",".blocklyDisabled>.blocklyPath {","fill-opacity: .5;","stroke-opacity: .5;","}",".blocklyDisabled>.blocklyPathLight,",".blocklyDisabled>.blocklyPathDark {","display: none;","}",".blocklyInsertionMarker>.blocklyPath,",".blocklyInsertionMarker>.blocklyPathLight,",".blocklyInsertionMarker>.blocklyPathDark {","fill-opacity: .2;","stroke: none;","}",".blocklyMultilineText {","font-family: monospace;","}",".blocklyNonEditableText>text {","pointer-events: none;","}",".blocklyFlyout {","position: absolute;","z-index: 20;","}",".blocklyText text {","cursor: default;","}",".blocklySvg text,",".blocklyBlockDragSurface text {","user-select: none;","-ms-user-select: none;","-webkit-user-select: none;","cursor: inherit;","}",".blocklyHidden {","display: none;","}",".blocklyFieldDropdown:not(.blocklyHidden) {","display: block;","}",".blocklyIconGroup {","cursor: default;","}",".blocklyIconGroup:not(:hover),",".blocklyIconGroupReadonly {","opacity: .6;","}",".blocklyIconShape {","fill: #00f;","stroke: #fff;","stroke-width: 1px;","}",".blocklyIconSymbol {","fill: #fff;","}",".blocklyMinimalBody {","margin: 0;","padding: 0;","}",".blocklyHtmlInput {","border: none;","border-radius: 4px;","height: 100%;","margin: 0;","outline: none;","padding: 0;","width: 100%;","text-align: center;","display: block;","box-sizing: border-box;","}",".blocklyHtmlInput::-ms-clear {","display: none;","}",".blocklyMainBackground {","stroke-width: 1;","stroke: #c6c6c6;","}",".blocklyMutatorBackground {","fill: #fff;","stroke: #ddd;","stroke-width: 1;","}",".blocklyFlyoutBackground {","fill: #ddd;","fill-opacity: .8;","}",".blocklyMainWorkspaceScrollbar {","z-index: 20;","}",".blocklyFlyoutScrollbar {","z-index: 30;","}",".blocklyScrollbarHorizontal,",".blocklyScrollbarVertical {","position: absolute;","outline: none;","}",".blocklyScrollbarBackground {","opacity: 0;","}",".blocklyScrollbarHandle {","fill: #ccc;","}",".blocklyScrollbarBackground:hover+.blocklyScrollbarHandle,",".blocklyScrollbarHandle:hover {","fill: #bbb;","}",".blocklyFlyout .blocklyScrollbarHandle {","fill: #bbb;","}",".blocklyFlyout .blocklyScrollbarBackground:hover+.blocklyScrollbarHandle,",".blocklyFlyout .blocklyScrollbarHandle:hover {","fill: #aaa;","}",".blocklyInvalidInput {","background: #faa;","}",".blocklyVerticalMarker {","stroke-width: 3px;","fill: rgba(255,255,255,.5);","pointer-events: none;","}",".blocklyComputeCanvas {","position: absolute;","width: 0;","height: 0;","}",".blocklyNoPointerEvents {","pointer-events: none;","}",".blocklyContextMenu {","border-radius: 4px;","max-height: 100%;","}",".blocklyDropdownMenu {","border-radius: 2px;","padding: 0 !important;","}",".blocklyDropdownMenu .blocklyMenuItem {","padding-left: 28px;","}",".blocklyDropdownMenu .blocklyMenuItemRtl {","padding-left: 5px;","padding-right: 28px;","}",".blocklyWidgetDiv .blocklyMenu {","background: #fff;","border: 1px solid transparent;","box-shadow: 0 0 3px 1px rgba(0,0,0,.3);","font: normal 13px Arial, sans-serif;","margin: 0;","outline: none;","padding: 4px 0;","position: absolute;","overflow-y: auto;","overflow-x: hidden;","max-height: 100%;","z-index: 20000;","}",".blocklyWidgetDiv .blocklyMenu.blocklyFocused {","box-shadow: 0 0 6px 1px rgba(0,0,0,.3);","}",".blocklyDropDownDiv .blocklyMenu {","background: inherit;","border: inherit;",'font: normal 13px "Helvetica Neue", Helvetica, sans-serif;',"outline: none;","position: relative;","z-index: 20000;","}",".blocklyMenuItem {","border: none;","color: #000;","cursor: pointer;","list-style: none;","margin: 0;","min-width: 7em;","padding: 6px 15px;","white-space: nowrap;","}",".blocklyMenuItemDisabled {","color: #ccc;","cursor: inherit;","}",".blocklyMenuItemHighlight {","background-color: rgba(0,0,0,.1);","}",".blocklyMenuItemCheckbox {","height: 16px;","position: absolute;","width: 16px;","}",".blocklyMenuItemSelected .blocklyMenuItemCheckbox {","float: left;","margin-left: -24px;","position: static;","}",".blocklyMenuItemRtl .blocklyMenuItemCheckbox {","float: right;","margin-right: -24px;","}"],I.utils.math={},I.utils.math.toRadians=function(t){return t*Math.PI/180},I.utils.math.toDegrees=function(t){return 180*t/Math.PI},I.utils.math.clamp=function(t,e,o){var i;return o<t&&(i=o,o=t,t=i),Math.max(t,Math.min(e,o))},I.DropDownDiv=function(){},I.DropDownDiv.boundsElement_=null,I.DropDownDiv.owner_=null,I.DropDownDiv.positionToField_=null,I.DropDownDiv.ARROW_SIZE=16,I.DropDownDiv.BORDER_SIZE=1,I.DropDownDiv.ARROW_HORIZONTAL_PADDING=12,I.DropDownDiv.PADDING_Y=16,I.DropDownDiv.ANIMATION_TIME=.25,I.DropDownDiv.animateOutTimer_=null,I.DropDownDiv.onHide_=null,I.DropDownDiv.rendererClassName_="",I.DropDownDiv.themeClassName_="",I.DropDownDiv.createDom=function(){var t,e;I.DropDownDiv.DIV_||((t=document.createElement("div")).className="blocklyDropDownDiv",(I.parentContainer||document.body).appendChild(t),I.DropDownDiv.DIV_=t,(e=document.createElement("div")).className="blocklyDropDownContent",t.appendChild(e),I.DropDownDiv.content_=e,(e=document.createElement("div")).className="blocklyDropDownArrow",t.appendChild(e),I.DropDownDiv.arrow_=e,I.DropDownDiv.DIV_.style.opacity=0,I.DropDownDiv.DIV_.style.transition="transform "+I.DropDownDiv.ANIMATION_TIME+"s, opacity "+I.DropDownDiv.ANIMATION_TIME+"s",t.addEventListener("focusin",function(){I.utils.dom.addClass(t,"blocklyFocused")}),t.addEventListener("focusout",function(){I.utils.dom.removeClass(t,"blocklyFocused")}))},I.DropDownDiv.setBoundsElement=function(t){I.DropDownDiv.boundsElement_=t},I.DropDownDiv.getContentDiv=function(){return I.DropDownDiv.content_},I.DropDownDiv.clearContent=function(){I.DropDownDiv.content_.textContent="",I.DropDownDiv.content_.style.width=""},I.DropDownDiv.setColour=function(t,e){I.DropDownDiv.DIV_.style.backgroundColor=t,I.DropDownDiv.DIV_.style.borderColor=e},I.DropDownDiv.showPositionedByBlock=function(t,e,o,i){return I.DropDownDiv.showPositionedByRect_(I.DropDownDiv.getScaledBboxOfBlock_(e),t,o,i)},I.DropDownDiv.showPositionedByField=function(t,e,o){return I.DropDownDiv.positionToField_=!0,I.DropDownDiv.showPositionedByRect_(I.DropDownDiv.getScaledBboxOfField_(t),t,e,o)},I.DropDownDiv.getScaledBboxOfBlock_=function(t){var e=t.getSvgRoot(),o=e.getBBox(),i=t.workspace.scale;return t=o.height*i,o=o.width*i,e=I.utils.style.getPageOffset(e),new I.utils.Rect(e.y,e.y+t,e.x,e.x+o)},I.DropDownDiv.getScaledBboxOfField_=function(t){return t=t.getScaledBBox(),new I.utils.Rect(t.top,t.bottom,t.left,t.right)},I.DropDownDiv.showPositionedByRect_=function(t,e,o,i){var s=t.left+(t.right-t.left)/2,n=t.bottom;t=t.top,i&&(t+=i);for(var r=(i=e.getSourceBlock()).workspace;r.options.parentWorkspace;)r=r.options.parentWorkspace;return I.DropDownDiv.setBoundsElement(r.getParentSvg().parentNode),I.DropDownDiv.show(e,i.RTL,s,n,s,t,o)},I.DropDownDiv.show=function(t,e,o,i,s,n,r){return I.DropDownDiv.owner_=t,I.DropDownDiv.onHide_=r||null,(t=I.DropDownDiv.DIV_).style.direction=e?"rtl":"ltr",e=I.getMainWorkspace(),I.DropDownDiv.rendererClassName_=e.getRenderer().getClassName(),I.DropDownDiv.themeClassName_=e.getTheme().getClassName(),I.utils.dom.addClass(t,I.DropDownDiv.rendererClassName_),I.utils.dom.addClass(t,I.DropDownDiv.themeClassName_),I.DropDownDiv.positionInternal_(o,i,s,n)},I.DropDownDiv.getBoundsInfo_=function(){var t=I.utils.style.getPageOffset(I.DropDownDiv.boundsElement_),e=I.utils.style.getSize(I.DropDownDiv.boundsElement_);return{left:t.x,right:t.x+e.width,top:t.y,bottom:t.y+e.height,width:e.width,height:e.height}},I.DropDownDiv.getPositionMetrics_=function(t,e,o,i){var s=I.DropDownDiv.getBoundsInfo_(),n=I.utils.style.getSize(I.DropDownDiv.DIV_);return e+n.height<s.bottom?I.DropDownDiv.getPositionBelowMetrics_(t,e,s,n):i-n.height>s.top?I.DropDownDiv.getPositionAboveMetrics_(o,i,s,n):e+n.height<document.documentElement.clientHeight?I.DropDownDiv.getPositionBelowMetrics_(t,e,s,n):i-n.height>document.documentElement.clientTop?I.DropDownDiv.getPositionAboveMetrics_(o,i,s,n):I.DropDownDiv.getPositionTopOfPageMetrics_(t,s,n)},I.DropDownDiv.getPositionBelowMetrics_=function(t,e,o,i){return{initialX:(t=I.DropDownDiv.getPositionX(t,o.left,o.right,i.width)).divX,initialY:e,finalX:t.divX,finalY:e+I.DropDownDiv.PADDING_Y,arrowX:t.arrowX,arrowY:-(I.DropDownDiv.ARROW_SIZE/2+I.DropDownDiv.BORDER_SIZE),arrowAtTop:!0,arrowVisible:!0}},I.DropDownDiv.getPositionAboveMetrics_=function(t,e,o,i){return{initialX:(t=I.DropDownDiv.getPositionX(t,o.left,o.right,i.width)).divX,initialY:e-i.height,finalX:t.divX,finalY:e-i.height-I.DropDownDiv.PADDING_Y,arrowX:t.arrowX,arrowY:i.height-2*I.DropDownDiv.BORDER_SIZE-I.DropDownDiv.ARROW_SIZE/2,arrowAtTop:!1,arrowVisible:!0}},I.DropDownDiv.getPositionTopOfPageMetrics_=function(t,e,o){return{initialX:(t=I.DropDownDiv.getPositionX(t,e.left,e.right,o.width)).divX,initialY:0,finalX:t.divX,finalY:0,arrowAtTop:null,arrowX:null,arrowY:null,arrowVisible:!1}},I.DropDownDiv.getPositionX=function(t,e,o,i){var s=t;return t=I.utils.math.clamp(e,t-i/2,o-i),s-=I.DropDownDiv.ARROW_SIZE/2,e=I.DropDownDiv.ARROW_HORIZONTAL_PADDING,{arrowX:i=I.utils.math.clamp(e,s-t,i-e-I.DropDownDiv.ARROW_SIZE),divX:t}},I.DropDownDiv.isVisible=function(){return!!I.DropDownDiv.owner_},I.DropDownDiv.hideIfOwner=function(t,e){return I.DropDownDiv.owner_===t&&(e?I.DropDownDiv.hideWithoutAnimation():I.DropDownDiv.hide(),!0)},I.DropDownDiv.hide=function(){var t=I.DropDownDiv.DIV_;t.style.transform="translate(0, 0)",t.style.opacity=0,I.DropDownDiv.animateOutTimer_=setTimeout(function(){I.DropDownDiv.hideWithoutAnimation()},1e3*I.DropDownDiv.ANIMATION_TIME),I.DropDownDiv.onHide_&&(I.DropDownDiv.onHide_(),I.DropDownDiv.onHide_=null)},I.DropDownDiv.hideWithoutAnimation=function(){var t;I.DropDownDiv.isVisible()&&(I.DropDownDiv.animateOutTimer_&&clearTimeout(I.DropDownDiv.animateOutTimer_),(t=I.DropDownDiv.DIV_).style.transform="",t.style.left="",t.style.top="",t.style.opacity=0,t.style.display="none",t.style.backgroundColor="",t.style.borderColor="",I.DropDownDiv.onHide_&&(I.DropDownDiv.onHide_(),I.DropDownDiv.onHide_=null),I.DropDownDiv.clearContent(),I.DropDownDiv.owner_=null,I.DropDownDiv.rendererClassName_&&(I.utils.dom.removeClass(t,I.DropDownDiv.rendererClassName_),I.DropDownDiv.rendererClassName_=""),I.DropDownDiv.themeClassName_&&(I.utils.dom.removeClass(t,I.DropDownDiv.themeClassName_),I.DropDownDiv.themeClassName_=""),I.getMainWorkspace().markFocused())},I.DropDownDiv.positionInternal_=function(t,e,o,i){(t=I.DropDownDiv.getPositionMetrics_(t,e,o,i)).arrowVisible?(I.DropDownDiv.arrow_.style.display="",I.DropDownDiv.arrow_.style.transform="translate("+t.arrowX+"px,"+t.arrowY+"px) rotate(45deg)",I.DropDownDiv.arrow_.setAttribute("class",t.arrowAtTop?"blocklyDropDownArrow blocklyArrowTop":"blocklyDropDownArrow blocklyArrowBottom")):I.DropDownDiv.arrow_.style.display="none",e=Math.floor(t.initialX),o=Math.floor(t.initialY),i=Math.floor(t.finalX);var s=Math.floor(t.finalY),n=I.DropDownDiv.DIV_;return n.style.left=e+"px",n.style.top=o+"px",n.style.display="block",n.style.opacity=1,n.style.transform="translate("+(i-e)+"px,"+(s-o)+"px)",!!t.arrowAtTop},I.DropDownDiv.repositionForWindowResize=function(){var t,e,t,e;I.DropDownDiv.owner_?(e=(t=I.DropDownDiv.owner_).getSourceBlock(),e=(t=I.DropDownDiv.positionToField_?I.DropDownDiv.getScaledBboxOfField_(t):I.DropDownDiv.getScaledBboxOfBlock_(e)).left+(t.right-t.left)/2,I.DropDownDiv.positionInternal_(e,t.bottom,e,t.top)):I.DropDownDiv.hide()},I.Grid=function(t,e){this.gridPattern_=t,this.spacing_=e.spacing,this.length_=e.length,this.line2_=(this.line1_=t.firstChild)&&this.line1_.nextSibling,this.snapToGrid_=e.snap},I.Grid.prototype.scale_=1,I.Grid.prototype.dispose=function(){this.gridPattern_=null},I.Grid.prototype.shouldSnap=function(){return this.snapToGrid_},I.Grid.prototype.getSpacing=function(){return this.spacing_},I.Grid.prototype.getPatternId=function(){return this.gridPattern_.id},I.Grid.prototype.update=function(t){this.scale_=t;var e=this.spacing_*t||100;this.gridPattern_.setAttribute("width",e),this.gridPattern_.setAttribute("height",e);var e,o=(e=Math.floor(this.spacing_/2)+.5)-this.length_/2,i=e+this.length_/2;this.setLineAttributes_(this.line1_,t,o*=t,i*=t,e*=t,e),this.setLineAttributes_(this.line2_,t,e,e,o,i)},I.Grid.prototype.setLineAttributes_=function(t,e,o,i,s,n){t&&(t.setAttribute("stroke-width",e),t.setAttribute("x1",o),t.setAttribute("y1",s),t.setAttribute("x2",i),t.setAttribute("y2",n))},I.Grid.prototype.moveTo=function(t,e){this.gridPattern_.setAttribute("x",t),this.gridPattern_.setAttribute("y",e),(I.utils.userAgent.IE||I.utils.userAgent.EDGE)&&this.update(this.scale_)},I.Grid.createDom=function(t,e,o){return t=I.utils.dom.createSvgElement(I.utils.Svg.PATTERN,{id:"blocklyGridPattern"+t,patternUnits:"userSpaceOnUse"},o),0<e.length&&0<e.spacing?(I.utils.dom.createSvgElement(I.utils.Svg.LINE,{stroke:e.colour},t),1<e.length&&I.utils.dom.createSvgElement(I.utils.Svg.LINE,{stroke:e.colour},t)):I.utils.dom.createSvgElement(I.utils.Svg.LINE,{},t),t},I.Theme=function(t,e,o,i){this.name=t,this.blockStyles=e||Object.create(null),this.categoryStyles=o||Object.create(null),this.componentStyles=i||Object.create(null),this.fontStyle=Object.create(null),this.startHats=null,I.registry.register(I.registry.Type.THEME,t,this)},I.Theme.prototype.getClassName=function(){return this.name+"-theme"},I.Theme.prototype.setBlockStyle=function(t,e){this.blockStyles[t]=e},I.Theme.prototype.setCategoryStyle=function(t,e){this.categoryStyles[t]=e},I.Theme.prototype.getComponentStyle=function(t){return(t=this.componentStyles[t])&&"string"==typeof t&&this.getComponentStyle(t)?this.getComponentStyle(t):t?String(t):null},I.Theme.prototype.setComponentStyle=function(t,e){this.componentStyles[t]=e},I.Theme.prototype.setFontStyle=function(t){this.fontStyle=t},I.Theme.prototype.setStartHats=function(t){this.startHats=t},I.Theme.defineTheme=function(t,e){var o=new I.Theme(t),i=e.base;return i&&((i="string"==typeof i?I.registry.getObject(I.registry.Type.THEME,i):i)instanceof I.Theme&&(I.utils.object.deepMerge(o,i),o.name=t)),I.utils.object.deepMerge(o.blockStyles,e.blockStyles),I.utils.object.deepMerge(o.categoryStyles,e.categoryStyles),I.utils.object.deepMerge(o.componentStyles,e.componentStyles),I.utils.object.deepMerge(o.fontStyle,e.fontStyle),null!=e.startHats&&(o.startHats=e.startHats),o},I.Themes={},I.Themes.Classic={},I.Themes.Classic.defaultBlockStyles={colour_blocks:{colourPrimary:"#f3aa60"},list_blocks:{colourPrimary:"#ecc01c"},logic_blocks:{colourPrimary:"#91c854"},loop_blocks:{colourPrimary:"#aa0d43"},math_blocks:{colourPrimary:"#00948a"},procedure_blocks:{colourPrimary:"290"},text_blocks:{colourPrimary:"#9365b8"},variable_blocks:{colourPrimary:"330"},variable_dynamic_blocks:{colourPrimary:"#bf717f"},hat_blocks:{colourPrimary:"330",hat:"cap"}},I.Themes.Classic.categoryStyles={colour_category:{colour:"20"},list_category:{colour:"260"},logic_category:{colour:"210"},loop_category:{colour:"120"},math_category:{colour:"230"},procedure_category:{colour:"290"},text_category:{colour:"160"},variable_category:{colour:"330"},variable_dynamic_category:{colour:"310"}},I.Themes.Classic=new I.Theme("classic",I.Themes.Classic.defaultBlockStyles,I.Themes.Classic.categoryStyles),I.utils.IdGenerator={},I.utils.IdGenerator.nextId_=0,I.utils.IdGenerator.getNextUniqueId=function(){return"blockly-"+(I.utils.IdGenerator.nextId_++).toString(36)},I.utils.Metrics=function(){},I.utils.toolbox={},I.utils.toolbox.CATEGORY_TOOLBOX_KIND="categoryToolbox",I.utils.toolbox.FLYOUT_TOOLBOX_KIND="flyoutToolbox",I.utils.toolbox.Position={TOP:0,BOTTOM:1,LEFT:2,RIGHT:3},I.utils.toolbox.convertToolboxDefToJson=function(t){if(!t)return null;return(t instanceof Element||"string"==typeof t)&&(t=I.utils.toolbox.parseToolboxTree(t),t=I.utils.toolbox.convertToToolboxJson_(t)),I.utils.toolbox.validateToolbox_(t),t},I.utils.toolbox.validateToolbox_=function(t){var e=t.kind;if(t=t.contents,e&&e!=I.utils.toolbox.FLYOUT_TOOLBOX_KIND&&e!=I.utils.toolbox.CATEGORY_TOOLBOX_KIND)throw Error("Invalid toolbox kind "+e+". Please supply either "+I.utils.toolbox.FLYOUT_TOOLBOX_KIND+" or "+I.utils.toolbox.CATEGORY_TOOLBOX_KIND);if(!t)throw Error("Toolbox must have a contents attribute.")},I.utils.toolbox.convertFlyoutDefToJsonArray=function(t){return t?t.contents||(Array.isArray(t)&&0<t.length&&!t[0].nodeType?t:I.utils.toolbox.xmlToJsonArray_(t)):[]},I.utils.toolbox.hasCategories=function(t){if(!t)return!1;var e=t.kind;return e?e==I.utils.toolbox.CATEGORY_TOOLBOX_KIND:!!t.contents.filter(function(t){return"CATEGORY"==t.kind.toUpperCase()}).length},I.utils.toolbox.isCategoryCollapsible=function(t){return!(!t||!t.contents)&&!!t.contents.filter(function(t){return"CATEGORY"==t.kind.toUpperCase()}).length},I.utils.toolbox.convertToToolboxJson_=function(t){var e={contents:I.utils.toolbox.xmlToJsonArray_(t)};return t instanceof Node&&I.utils.toolbox.addAttributes_(t,e),e},I.utils.toolbox.xmlToJsonArray_=function(t){var e=[],o,o=(o=t.childNodes)||t,i,s,n;for(t=0;i=o[t];t++){i.tagName&&(s={},n=i.tagName.toUpperCase(),"BLOCK"==(s.kind=n)?s.blockxml=i:i.childNodes&&0<i.childNodes.length&&(s.contents=I.utils.toolbox.xmlToJsonArray_(i)),I.utils.toolbox.addAttributes_(i,s),e.push(s))}return e},I.utils.toolbox.addAttributes_=function(t,e){for(var o=0;o<t.attributes.length;o++){var i=t.attributes[o];-1<i.nodeName.indexOf("css-")?(e.cssconfig=e.cssconfig||{},e.cssconfig[i.nodeName.replace("css-","")]=i.value):e[i.nodeName]=i.value}},I.utils.toolbox.parseToolboxTree=function(t){if(t){if("string"!=typeof t&&(I.utils.userAgent.IE&&t.outerHTML?t=t.outerHTML:t instanceof Element||(t=null)),"string"==typeof t&&"xml"!=(t=I.Xml.textToDom(t)).nodeName.toLowerCase())throw TypeError("Toolbox should be an <xml> document.")}else t=null;return t},I.Options=function(t){var e=!!t.readOnly,o,i,s,n,r,l,a,o,i,s,c;e?(o=null,a=l=r=n=s=i=!1):(o=I.utils.toolbox.convertToolboxDefToJson(t.toolbox),i=I.utils.toolbox.hasCategories(o),s=t.trashcan,c=t.maxTrashcanContents,(s=void 0===s?i:s)?void 0===c&&(c=32):c=0,void 0===(n=t.collapse)&&(n=i),void 0===(r=t.comments)&&(r=i),void 0===(l=t.disable)&&(l=i),void 0===(a=t.sounds)&&(a=!0));var h=!!t.rtl,u=t.horizontalLayout,p,p="end"!==(p=t.toolboxPosition);p=(u=void 0===u?!1:u)?p?I.utils.toolbox.Position.TOP:I.utils.toolbox.Position.BOTTOM:p==h?I.utils.toolbox.Position.RIGHT:I.utils.toolbox.Position.LEFT;var g=t.css;void 0===g&&(g=!0);var d="https://blockly-demo.appspot.com/static/media/";t.media?d=t.media:t.path&&(d=t.path+"media/");var _=void 0===t.oneBasedIndex||!!t.oneBasedIndex,T=t.renderer||"geras",C=t.plugins||{};this.RTL=h,this.oneBasedIndex=_,this.collapse=n,this.comments=r,this.disable=l,this.readOnly=e,this.maxBlocks=t.maxBlocks||1/0,this.maxInstances=t.maxInstances,this.pathToMedia=d,this.hasCategories=i,this.moveOptions=I.Options.parseMoveOptions_(t,i),this.hasScrollbars=!!this.moveOptions.scrollbars,this.hasTrashcan=s,this.maxTrashcanContents=c,this.hasSounds=a,this.hasCss=g,this.horizontalLayout=u,this.languageTree=o,this.gridOptions=I.Options.parseGridOptions_(t),this.zoomOptions=I.Options.parseZoomOptions_(t),this.toolboxPosition=p,this.theme=I.Options.parseThemeOptions_(t),this.renderer=T,this.rendererOverrides=t.rendererOverrides,this.gridPattern=null,this.parentWorkspace=t.parentWorkspace,this.plugins=C},I.BlocklyOptions=function(){},I.Options.parseMoveOptions_=function(t,e){var o=t.move||{},i={};return void 0===o.scrollbars&&void 0===t.scrollbars?i.scrollbars=e:"object"==typeof o.scrollbars?(i.scrollbars={},i.scrollbars.horizontal=!!o.scrollbars.horizontal,i.scrollbars.vertical=!!o.scrollbars.vertical,i.scrollbars.horizontal&&i.scrollbars.vertical?i.scrollbars=!0:i.scrollbars.horizontal||i.scrollbars.vertical||(i.scrollbars=!1)):i.scrollbars=!!o.scrollbars||!!t.scrollbars,i.wheel=i.scrollbars&&void 0!==o.wheel?!!o.wheel:"object"==typeof i.scrollbars,i.drag=!!i.scrollbars&&(void 0===o.drag||!!o.drag),i},I.Options.parseZoomOptions_=function(t){t=t.zoom||{};var e={};return e.controls=void 0!==t.controls&&!!t.controls,e.wheel=void 0!==t.wheel&&!!t.wheel,e.startScale=void 0===t.startScale?1:Number(t.startScale),e.maxScale=void 0===t.maxScale?3:Number(t.maxScale),e.minScale=void 0===t.minScale?.3:Number(t.minScale),e.scaleSpeed=void 0===t.scaleSpeed?1.2:Number(t.scaleSpeed),e.pinch=void 0===t.pinch?e.wheel||e.controls:!!t.pinch,e},I.Options.parseGridOptions_=function(t){t=t.grid||{};var e={};return e.spacing=Number(t.spacing)||0,e.colour=t.colour||"#888",e.length=void 0===t.length?1:Number(t.length),e.snap=0<e.spacing&&!!t.snap,e},I.Options.parseThemeOptions_=function(t){return"string"==typeof(t=t.theme||I.Themes.Classic)?I.registry.getObject(I.registry.Type.THEME,t):t instanceof I.Theme?t:I.Theme.defineTheme(t.name||"builtin"+I.utils.IdGenerator.getNextUniqueId(),t)},I.Options.parseToolboxTree=function(t){return I.utils.deprecation.warn("Blockly.Options.parseToolboxTree","September 2020","September 2021","Blockly.utils.toolbox.parseToolboxTree"),I.utils.toolbox.parseToolboxTree(t)},I.ScrollbarPair=function(t,e,o,i){this.workspace_=t,o=void 0===o||o;var s=(e=void 0===e||e)&&o;e&&(this.hScroll=new I.Scrollbar(t,!0,s,i)),o&&(this.vScroll=new I.Scrollbar(t,!1,s,i)),s&&(this.corner_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{height:I.Scrollbar.scrollbarThickness,width:I.Scrollbar.scrollbarThickness,class:"blocklyScrollbarBackground"},null),I.utils.dom.insertAfter(this.corner_,t.getBubbleCanvas())),this.oldHostMetrics_=null},I.ScrollbarPair.prototype.dispose=function(){I.utils.dom.removeNode(this.corner_),this.oldHostMetrics_=this.workspace_=this.corner_=null,this.hScroll&&(this.hScroll.dispose(),this.hScroll=null),this.vScroll&&(this.vScroll.dispose(),this.vScroll=null)},I.ScrollbarPair.prototype.resize=function(){var t=this.workspace_.getMetrics();if(t){var e=!1,o=!1;if(this.oldHostMetrics_&&this.oldHostMetrics_.viewWidth==t.viewWidth&&this.oldHostMetrics_.viewHeight==t.viewHeight&&this.oldHostMetrics_.absoluteTop==t.absoluteTop&&this.oldHostMetrics_.absoluteLeft==t.absoluteLeft?(this.oldHostMetrics_&&this.oldHostMetrics_.scrollWidth==t.scrollWidth&&this.oldHostMetrics_.viewLeft==t.viewLeft&&this.oldHostMetrics_.scrollLeft==t.scrollLeft||(e=!0),this.oldHostMetrics_&&this.oldHostMetrics_.scrollHeight==t.scrollHeight&&this.oldHostMetrics_.viewTop==t.viewTop&&this.oldHostMetrics_.scrollTop==t.scrollTop||(o=!0)):o=e=!0,e||o){try{I.Events.disable(),this.hScroll&&e&&this.hScroll.resize(t),this.vScroll&&o&&this.vScroll.resize(t)}finally{I.Events.enable()}this.workspace_.maybeFireViewportChangeEvent()}this.hScroll&&this.vScroll&&(this.oldHostMetrics_&&this.oldHostMetrics_.viewWidth==t.viewWidth&&this.oldHostMetrics_.absoluteLeft==t.absoluteLeft||this.corner_.setAttribute("x",this.vScroll.position.x),this.oldHostMetrics_&&this.oldHostMetrics_.viewHeight==t.viewHeight&&this.oldHostMetrics_.absoluteTop==t.absoluteTop||this.corner_.setAttribute("y",this.hScroll.position.y)),this.oldHostMetrics_=t}},I.ScrollbarPair.prototype.canScrollHorizontally=function(){return!!this.hScroll},I.ScrollbarPair.prototype.canScrollVertically=function(){return!!this.vScroll},I.ScrollbarPair.prototype.setOrigin=function(t,e){this.hScroll&&this.hScroll.setOrigin(t,e),this.vScroll&&this.vScroll.setOrigin(t,e)},I.ScrollbarPair.prototype.set=function(t,e,o){this.hScroll&&this.hScroll.set(t,!1),this.vScroll&&this.vScroll.set(e,!1),!o&&void 0!==o||(t={},this.hScroll&&(t.x=this.hScroll.getRatio_()),this.vScroll&&(t.y=this.vScroll.getRatio_()),this.workspace_.setMetrics(t))},I.ScrollbarPair.prototype.setX=function(t){this.hScroll&&this.hScroll.set(t,!0)},I.ScrollbarPair.prototype.setY=function(t){this.vScroll&&this.vScroll.set(t,!0)},I.ScrollbarPair.prototype.setContainerVisible=function(t){this.hScroll&&this.hScroll.setContainerVisible(t),this.vScroll&&this.vScroll.setContainerVisible(t)},I.ScrollbarPair.prototype.isVisible=function(){var t=!1;return this.hScroll&&(t=this.hScroll.isVisible()),t=this.vScroll?t||this.vScroll.isVisible():t},I.ScrollbarPair.prototype.resizeContent=function(t){this.hScroll&&this.hScroll.resizeContentHorizontal(t),this.vScroll&&this.vScroll.resizeContentVertical(t)},I.ScrollbarPair.prototype.resizeView=function(t){this.hScroll&&this.hScroll.resizeViewHorizontal(t),this.vScroll&&this.vScroll.resizeViewVertical(t)},I.Scrollbar=function(t,e,o,i){this.workspace_=t,this.pair_=o||!1,this.horizontal_=e,this.ratio=this.oldHostMetrics_=null,this.createDom_(i),this.position=new I.utils.Coordinate(0,0),t=I.Scrollbar.scrollbarThickness,e?(this.svgBackground_.setAttribute("height",t),this.outerSvg_.setAttribute("height",t),this.svgHandle_.setAttribute("height",t-5),this.svgHandle_.setAttribute("y",2.5),this.lengthAttribute_="width",this.positionAttribute_="x"):(this.svgBackground_.setAttribute("width",t),this.outerSvg_.setAttribute("width",t),this.svgHandle_.setAttribute("width",t-5),this.svgHandle_.setAttribute("x",2.5),this.lengthAttribute_="height",this.positionAttribute_="y"),this.onMouseDownBarWrapper_=I.browserEvents.conditionalBind(this.svgBackground_,"mousedown",this,this.onMouseDownBar_),this.onMouseDownHandleWrapper_=I.browserEvents.conditionalBind(this.svgHandle_,"mousedown",this,this.onMouseDownHandle_)},I.Scrollbar.prototype.origin_=new I.utils.Coordinate(0,0),I.Scrollbar.prototype.startDragMouse_=0,I.Scrollbar.prototype.scrollbarLength_=0,I.Scrollbar.prototype.handleLength_=0,I.Scrollbar.prototype.handlePosition_=0,I.Scrollbar.prototype.isVisible_=!0,I.Scrollbar.prototype.containerVisible_=!0,I.Scrollbar.scrollbarThickness=15,I.Touch.TOUCH_ENABLED&&(I.Scrollbar.scrollbarThickness=25),I.Scrollbar.SCROLLBAR_MARGIN=.5,I.Scrollbar.metricsAreEquivalent_=function(t,e){return!(!t||!e||t.viewWidth!=e.viewWidth||t.viewHeight!=e.viewHeight||t.viewLeft!=e.viewLeft||t.viewTop!=e.viewTop||t.absoluteTop!=e.absoluteTop||t.absoluteLeft!=e.absoluteLeft||t.scrollWidth!=e.scrollWidth||t.scrollHeight!=e.scrollHeight||t.scrollLeft!=e.scrollLeft||t.scrollTop!=e.scrollTop)},I.Scrollbar.prototype.dispose=function(){this.cleanUp_(),I.browserEvents.unbind(this.onMouseDownBarWrapper_),this.onMouseDownBarWrapper_=null,I.browserEvents.unbind(this.onMouseDownHandleWrapper_),this.onMouseDownHandleWrapper_=null,I.utils.dom.removeNode(this.outerSvg_),this.svgBackground_=this.svgGroup_=this.outerSvg_=null,this.svgHandle_&&(this.workspace_.getThemeManager().unsubscribe(this.svgHandle_),this.svgHandle_=null),this.workspace_=null},I.Scrollbar.prototype.constrainHandleLength_=function(t){return t=t<=0||isNaN(t)?0:Math.min(t,this.scrollbarLength_)},I.Scrollbar.prototype.setHandleLength_=function(t){this.handleLength_=t,this.svgHandle_.setAttribute(this.lengthAttribute_,this.handleLength_)},I.Scrollbar.prototype.constrainHandlePosition_=function(t){return t=t<=0||isNaN(t)?0:Math.min(t,this.scrollbarLength_-this.handleLength_)},I.Scrollbar.prototype.setHandlePosition=function(t){this.handlePosition_=t,this.svgHandle_.setAttribute(this.positionAttribute_,this.handlePosition_)},I.Scrollbar.prototype.setScrollbarLength_=function(t){this.scrollbarLength_=t,this.outerSvg_.setAttribute(this.lengthAttribute_,this.scrollbarLength_),this.svgBackground_.setAttribute(this.lengthAttribute_,this.scrollbarLength_)},I.Scrollbar.prototype.setPosition=function(t,e){this.position.x=t,this.position.y=e,I.utils.dom.setCssTransform(this.outerSvg_,"translate("+(this.position.x+this.origin_.x)+"px,"+(this.position.y+this.origin_.y)+"px)")},I.Scrollbar.prototype.resize=function(t){if(!t&&!(t=this.workspace_.getMetrics()))return;I.Scrollbar.metricsAreEquivalent_(t,this.oldHostMetrics_)||(this.horizontal_?this.resizeHorizontal_(t):this.resizeVertical_(t),this.oldHostMetrics_=t,this.updateMetrics_())},I.Scrollbar.prototype.requiresViewResize_=function(t){return!this.oldHostMetrics_||(this.oldHostMetrics_.viewWidth!==t.viewWidth||this.oldHostMetrics_.viewHeight!==t.viewHeight||this.oldHostMetrics_.absoluteLeft!==t.absoluteLeft||this.oldHostMetrics_.absoluteTop!==t.absoluteTop)},I.Scrollbar.prototype.resizeHorizontal_=function(t){this.requiresViewResize_(t)?this.resizeViewHorizontal(t):this.resizeContentHorizontal(t)},I.Scrollbar.prototype.resizeViewHorizontal=function(t){var e=t.viewWidth-2*I.Scrollbar.SCROLLBAR_MARGIN;this.pair_&&(e-=I.Scrollbar.scrollbarThickness),this.setScrollbarLength_(Math.max(0,e)),e=t.absoluteLeft+I.Scrollbar.SCROLLBAR_MARGIN,this.pair_&&this.workspace_.RTL&&(e+=I.Scrollbar.scrollbarThickness),this.setPosition(e,t.absoluteTop+t.viewHeight-I.Scrollbar.scrollbarThickness-I.Scrollbar.SCROLLBAR_MARGIN),this.resizeContentHorizontal(t)},I.Scrollbar.prototype.resizeContentHorizontal=function(t){var e,e,o;t.viewWidth>=t.scrollWidth?(this.setHandleLength_(this.scrollbarLength_),this.setHandlePosition(0),this.pair_||this.setVisible(!1)):(this.pair_||this.setVisible(!0),e=this.scrollbarLength_*t.viewWidth/t.scrollWidth,e=this.constrainHandleLength_(e),this.setHandleLength_(e),e=t.scrollWidth-t.viewWidth,o=this.scrollbarLength_-this.handleLength_,t=(t.viewLeft-t.scrollLeft)/e*o,t=this.constrainHandlePosition_(t),this.setHandlePosition(t),this.ratio=o/e)},I.Scrollbar.prototype.resizeVertical_=function(t){this.requiresViewResize_(t)?this.resizeViewVertical(t):this.resizeContentVertical(t)},I.Scrollbar.prototype.resizeViewVertical=function(t){var e=t.viewHeight-2*I.Scrollbar.SCROLLBAR_MARGIN;this.pair_&&(e-=I.Scrollbar.scrollbarThickness),this.setScrollbarLength_(Math.max(0,e)),this.setPosition(this.workspace_.RTL?t.absoluteLeft+I.Scrollbar.SCROLLBAR_MARGIN:t.absoluteLeft+t.viewWidth-I.Scrollbar.scrollbarThickness-I.Scrollbar.SCROLLBAR_MARGIN,t.absoluteTop+I.Scrollbar.SCROLLBAR_MARGIN),this.resizeContentVertical(t)},I.Scrollbar.prototype.resizeContentVertical=function(t){var e,e,o;t.viewHeight>=t.scrollHeight?(this.setHandleLength_(this.scrollbarLength_),this.setHandlePosition(0),this.pair_||this.setVisible(!1)):(this.pair_||this.setVisible(!0),e=this.scrollbarLength_*t.viewHeight/t.scrollHeight,e=this.constrainHandleLength_(e),this.setHandleLength_(e),e=t.scrollHeight-t.viewHeight,o=this.scrollbarLength_-this.handleLength_,t=(t.viewTop-t.scrollTop)/e*o,t=this.constrainHandlePosition_(t),this.setHandlePosition(t),this.ratio=o/e)},I.Scrollbar.prototype.createDom_=function(t){var e="blocklyScrollbar"+(this.horizontal_?"Horizontal":"Vertical");t&&(e+=" "+t),this.outerSvg_=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{class:e},null),this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},this.outerSvg_),this.svgBackground_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyScrollbarBackground"},this.svgGroup_),t=Math.floor((I.Scrollbar.scrollbarThickness-5)/2),this.svgHandle_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyScrollbarHandle",rx:t,ry:t},this.svgGroup_),this.workspace_.getThemeManager().subscribe(this.svgHandle_,"scrollbarColour","fill"),this.workspace_.getThemeManager().subscribe(this.svgHandle_,"scrollbarOpacity","fill-opacity"),I.utils.dom.insertAfter(this.outerSvg_,this.workspace_.getParentSvg())},I.Scrollbar.prototype.isVisible=function(){return this.isVisible_},I.Scrollbar.prototype.setContainerVisible=function(t){var e=t!=this.containerVisible_;this.containerVisible_=t,e&&this.updateDisplay_()},I.Scrollbar.prototype.setVisible=function(t){var e=t!=this.isVisible();if(this.pair_)throw Error("Unable to toggle visibility of paired scrollbars.");this.isVisible_=t,e&&this.updateDisplay_()},I.Scrollbar.prototype.updateDisplay_=function(){this.containerVisible_&&this.isVisible()?this.outerSvg_.setAttribute("display","block"):this.outerSvg_.setAttribute("display","none")},I.Scrollbar.prototype.onMouseDownBar_=function(t){var e,e,o,o,i,s;this.workspace_.markFocused(),I.Touch.clearTouchIdentifier(),this.cleanUp_(),I.utils.isRightButton(t)?t.stopPropagation():(e=I.utils.mouseToSvg(t,this.workspace_.getParentSvg(),this.workspace_.getInverseScreenCTM()),e=this.horizontal_?e.x:e.y,o=I.utils.getInjectionDivXY_(this.svgHandle_),o=this.horizontal_?o.x:o.y,i=this.handlePosition_,s=.95*this.handleLength_,e<=o?i-=s:e>=o+this.handleLength_&&(i+=s),this.setHandlePosition(this.constrainHandlePosition_(i)),this.updateMetrics_(),t.stopPropagation(),t.preventDefault())},I.Scrollbar.prototype.onMouseDownHandle_=function(t){this.workspace_.markFocused(),this.cleanUp_(),I.utils.isRightButton(t)?t.stopPropagation():(this.startDragHandle=this.handlePosition_,this.workspace_.setupDragSurface(),this.startDragMouse_=this.horizontal_?t.clientX:t.clientY,I.Scrollbar.onMouseUpWrapper_=I.browserEvents.conditionalBind(document,"mouseup",this,this.onMouseUpHandle_),I.Scrollbar.onMouseMoveWrapper_=I.browserEvents.conditionalBind(document,"mousemove",this,this.onMouseMoveHandle_),t.stopPropagation(),t.preventDefault())},I.Scrollbar.prototype.onMouseMoveHandle_=function(t){this.setHandlePosition(this.constrainHandlePosition_(this.startDragHandle+((this.horizontal_?t.clientX:t.clientY)-this.startDragMouse_))),this.updateMetrics_()},I.Scrollbar.prototype.onMouseUpHandle_=function(){this.workspace_.resetDragSurface(),I.Touch.clearTouchIdentifier(),this.cleanUp_()},I.Scrollbar.prototype.cleanUp_=function(){I.hideChaff(!0),I.Scrollbar.onMouseUpWrapper_&&(I.browserEvents.unbind(I.Scrollbar.onMouseUpWrapper_),I.Scrollbar.onMouseUpWrapper_=null),I.Scrollbar.onMouseMoveWrapper_&&(I.browserEvents.unbind(I.Scrollbar.onMouseMoveWrapper_),I.Scrollbar.onMouseMoveWrapper_=null)},I.Scrollbar.prototype.getRatio_=function(){var t=this.handlePosition_/(this.scrollbarLength_-this.handleLength_);return t=isNaN(t)?0:t},I.Scrollbar.prototype.updateMetrics_=function(){var t=this.getRatio_(),e={};this.horizontal_?e.x=t:e.y=t,this.workspace_.setMetrics(e)},I.Scrollbar.prototype.set=function(t,e){this.setHandlePosition(this.constrainHandlePosition_(t*this.ratio)),!e&&void 0!==e||this.updateMetrics_()},I.Scrollbar.prototype.setOrigin=function(t,e){this.origin_=new I.utils.Coordinate(t,e)},I.Tooltip={},I.Tooltip.visible=!1,I.Tooltip.blocked_=!1,I.Tooltip.LIMIT=50,I.Tooltip.mouseOutPid_=0,I.Tooltip.showPid_=0,I.Tooltip.lastX_=0,I.Tooltip.lastY_=0,I.Tooltip.element_=null,I.Tooltip.poisonedElement_=null,I.Tooltip.OFFSET_X=0,I.Tooltip.OFFSET_Y=10,I.Tooltip.RADIUS_OK=10,I.Tooltip.HOVER_MS=750,I.Tooltip.MARGINS=5,I.Tooltip.DIV=null,I.Tooltip.getTooltipOfObject=function(t){if(t=I.Tooltip.getTargetObject_(t)){for(t=t.tooltip;"function"==typeof t;)t=t();if("string"!=typeof t)throw Error("Tooltip function must return a string.");return t}return""},I.Tooltip.getTargetObject_=function(t){for(;t&&t.tooltip;){if("string"==typeof t.tooltip||"function"==typeof t.tooltip)return t;t=t.tooltip}return null},I.Tooltip.createDom=function(){I.Tooltip.DIV||(I.Tooltip.DIV=document.createElement("div"),I.Tooltip.DIV.className="blocklyTooltipDiv",(I.parentContainer||document.body).appendChild(I.Tooltip.DIV))},I.Tooltip.bindMouseEvents=function(t){t.mouseOverWrapper_=I.browserEvents.bind(t,"mouseover",null,I.Tooltip.onMouseOver_),t.mouseOutWrapper_=I.browserEvents.bind(t,"mouseout",null,I.Tooltip.onMouseOut_),t.addEventListener("mousemove",I.Tooltip.onMouseMove_,!1)},I.Tooltip.unbindMouseEvents=function(t){t&&(I.browserEvents.unbind(t.mouseOverWrapper_),I.browserEvents.unbind(t.mouseOutWrapper_),t.removeEventListener("mousemove",I.Tooltip.onMouseMove_))},I.Tooltip.onMouseOver_=function(t){I.Tooltip.blocked_||(t=I.Tooltip.getTargetObject_(t.currentTarget),I.Tooltip.element_!=t&&(I.Tooltip.hide(),I.Tooltip.poisonedElement_=null,I.Tooltip.element_=t),clearTimeout(I.Tooltip.mouseOutPid_))},I.Tooltip.onMouseOut_=function(t){I.Tooltip.blocked_||(I.Tooltip.mouseOutPid_=setTimeout(function(){I.Tooltip.element_=null,I.Tooltip.poisonedElement_=null,I.Tooltip.hide()},1),clearTimeout(I.Tooltip.showPid_))},I.Tooltip.onMouseMove_=function(t){var e;I.Tooltip.element_&&I.Tooltip.element_.tooltip&&!I.Tooltip.blocked_&&(I.Tooltip.visible?(e=I.Tooltip.lastX_-t.pageX,t=I.Tooltip.lastY_-t.pageY,Math.sqrt(e*e+t*t)>I.Tooltip.RADIUS_OK&&I.Tooltip.hide()):I.Tooltip.poisonedElement_!=I.Tooltip.element_&&(clearTimeout(I.Tooltip.showPid_),I.Tooltip.lastX_=t.pageX,I.Tooltip.lastY_=t.pageY,I.Tooltip.showPid_=setTimeout(I.Tooltip.show_,I.Tooltip.HOVER_MS)))},I.Tooltip.dispose=function(){I.Tooltip.element_=null,I.Tooltip.poisonedElement_=null,I.Tooltip.hide()},I.Tooltip.hide=function(){I.Tooltip.visible&&(I.Tooltip.visible=!1,I.Tooltip.DIV&&(I.Tooltip.DIV.style.display="none")),I.Tooltip.showPid_&&clearTimeout(I.Tooltip.showPid_)},I.Tooltip.block=function(){I.Tooltip.hide(),I.Tooltip.blocked_=!0},I.Tooltip.unblock=function(){I.Tooltip.blocked_=!1},I.Tooltip.show_=function(){if(!I.Tooltip.blocked_&&(I.Tooltip.poisonedElement_=I.Tooltip.element_,I.Tooltip.DIV)){I.Tooltip.DIV.textContent="";var t=I.Tooltip.getTooltipOfObject(I.Tooltip.element_),t;t=(t=I.utils.string.wrap(t,I.Tooltip.LIMIT)).split("\n");for(var e=0;e<t.length;e++){var o=document.createElement("div");o.appendChild(document.createTextNode(t[e])),I.Tooltip.DIV.appendChild(o)}t=I.Tooltip.element_.RTL,e=document.documentElement.clientWidth,o=document.documentElement.clientHeight,I.Tooltip.DIV.style.direction=t?"rtl":"ltr",I.Tooltip.DIV.style.display="block",I.Tooltip.visible=!0;var i=I.Tooltip.lastX_,i=t?i-(I.Tooltip.OFFSET_X+I.Tooltip.DIV.offsetWidth):i+I.Tooltip.OFFSET_X,s=I.Tooltip.lastY_+I.Tooltip.OFFSET_Y;s+I.Tooltip.DIV.offsetHeight>o+window.scrollY&&(s-=I.Tooltip.DIV.offsetHeight+2*I.Tooltip.OFFSET_Y),t?i=Math.max(I.Tooltip.MARGINS-window.scrollX,i):i+I.Tooltip.DIV.offsetWidth>e+window.scrollX-2*I.Tooltip.MARGINS&&(i=e-I.Tooltip.DIV.offsetWidth-2*I.Tooltip.MARGINS),I.Tooltip.DIV.style.top=s+"px",I.Tooltip.DIV.style.left=i+"px"}},I.utils.aria={},I.utils.aria.ARIA_PREFIX_="aria-",I.utils.aria.ROLE_ATTRIBUTE_="role",I.utils.aria.Role={GRID:"grid",GRIDCELL:"gridcell",GROUP:"group",LISTBOX:"listbox",MENU:"menu",MENUITEM:"menuitem",MENUITEMCHECKBOX:"menuitemcheckbox",OPTION:"option",PRESENTATION:"presentation",ROW:"row",TREE:"tree",TREEITEM:"treeitem"},I.utils.aria.State={ACTIVEDESCENDANT:"activedescendant",COLCOUNT:"colcount",DISABLED:"disabled",EXPANDED:"expanded",INVALID:"invalid",LABEL:"label",LABELLEDBY:"labelledby",LEVEL:"level",ORIENTATION:"orientation",POSINSET:"posinset",ROWCOUNT:"rowcount",SELECTED:"selected",SETSIZE:"setsize",VALUEMAX:"valuemax",VALUEMIN:"valuemin"},I.utils.aria.setRole=function(t,e){t.setAttribute(I.utils.aria.ROLE_ATTRIBUTE_,e)},I.utils.aria.setState=function(t,e,o){Array.isArray(o)&&(o=o.join(" ")),t.setAttribute(I.utils.aria.ARIA_PREFIX_+e,o)},I.WorkspaceDragSurfaceSvg=function(t){this.container_=t,this.createDom()},I.WorkspaceDragSurfaceSvg.prototype.SVG_=null,I.WorkspaceDragSurfaceSvg.prototype.container_=null,I.WorkspaceDragSurfaceSvg.prototype.createDom=function(){this.SVG_||(this.SVG_=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{xmlns:I.utils.dom.SVG_NS,"xmlns:html":I.utils.dom.HTML_NS,"xmlns:xlink":I.utils.dom.XLINK_NS,version:"1.1",class:"blocklyWsDragSurface blocklyOverflowVisible"},null),this.container_.appendChild(this.SVG_))},I.WorkspaceDragSurfaceSvg.prototype.translateSurface=function(t,e){t=t.toFixed(0),e=e.toFixed(0),this.SVG_.style.display="block",I.utils.dom.setCssTransform(this.SVG_,"translate3d("+t+"px, "+e+"px, 0px)")},I.WorkspaceDragSurfaceSvg.prototype.getSurfaceTranslation=function(){return I.utils.getRelativeXY(this.SVG_)},I.WorkspaceDragSurfaceSvg.prototype.clearAndHide=function(t){if(!t)throw Error("Couldn't clear and hide the drag surface: missing new surface.");var e=this.SVG_.childNodes[0],o=this.SVG_.childNodes[1];if(!(e&&o&&I.utils.dom.hasClass(e,"blocklyBlockCanvas")&&I.utils.dom.hasClass(o,"blocklyBubbleCanvas")))throw Error("Couldn't clear and hide the drag surface. A node was missing.");if(null!=this.previousSibling_?I.utils.dom.insertAfter(e,this.previousSibling_):t.insertBefore(e,t.firstChild),I.utils.dom.insertAfter(o,e),this.SVG_.style.display="none",this.SVG_.childNodes.length)throw Error("Drag surface was not cleared.");I.utils.dom.setCssTransform(this.SVG_,""),this.previousSibling_=null},I.WorkspaceDragSurfaceSvg.prototype.setContentsAndShow=function(t,e,o,i,s,n){if(this.SVG_.childNodes.length)throw Error("Already dragging a block.");this.previousSibling_=o,t.setAttribute("transform","translate(0, 0) scale("+n+")"),e.setAttribute("transform","translate(0, 0) scale("+n+")"),this.SVG_.setAttribute("width",i),this.SVG_.setAttribute("height",s),this.SVG_.appendChild(t),this.SVG_.appendChild(e),this.SVG_.style.display="block"},I.blockRendering={},I.blockRendering.useDebugger=!1,I.blockRendering.register=function(t,e){I.registry.register(I.registry.Type.RENDERER,t,e)},I.blockRendering.unregister=function(t){I.registry.unregister(I.registry.Type.RENDERER,t)},I.blockRendering.startDebugger=function(){I.blockRendering.useDebugger=!0},I.blockRendering.stopDebugger=function(){I.blockRendering.useDebugger=!1},I.blockRendering.init=function(t,e,o){return(t=new(I.registry.getClass(I.registry.Type.RENDERER,t))(t)).init(e,o),t},I.ASTNode=function(t,e,o){if(!e)throw Error("Cannot create a node without a location.");this.type_=t,this.isConnection_=I.ASTNode.isConnectionType_(t),this.location_=e,this.wsCoordinate_=null,this.processParams_(o||null)},I.ASTNode.types={FIELD:"field",BLOCK:"block",INPUT:"input",OUTPUT:"output",NEXT:"next",PREVIOUS:"previous",STACK:"stack",WORKSPACE:"workspace"},I.ASTNode.NAVIGATE_ALL_FIELDS=!1,I.ASTNode.DEFAULT_OFFSET_Y=-20,I.ASTNode.isConnectionType_=function(t){switch(t){case I.ASTNode.types.PREVIOUS:case I.ASTNode.types.NEXT:case I.ASTNode.types.INPUT:case I.ASTNode.types.OUTPUT:return!0}return!1},I.ASTNode.createFieldNode=function(t){return t?new I.ASTNode(I.ASTNode.types.FIELD,t):null},I.ASTNode.createConnectionNode=function(t){if(!t)return null;var e=t.type;return e==I.connectionTypes.INPUT_VALUE||e==I.connectionTypes.NEXT_STATEMENT&&t.getParentInput()?I.ASTNode.createInputNode(t.getParentInput()):e==I.connectionTypes.NEXT_STATEMENT?new I.ASTNode(I.ASTNode.types.NEXT,t):e==I.connectionTypes.OUTPUT_VALUE?new I.ASTNode(I.ASTNode.types.OUTPUT,t):e==I.connectionTypes.PREVIOUS_STATEMENT?new I.ASTNode(I.ASTNode.types.PREVIOUS,t):null},I.ASTNode.createInputNode=function(t){return t&&t.connection?new I.ASTNode(I.ASTNode.types.INPUT,t.connection):null},I.ASTNode.createBlockNode=function(t){return t?new I.ASTNode(I.ASTNode.types.BLOCK,t):null},I.ASTNode.createStackNode=function(t){return t?new I.ASTNode(I.ASTNode.types.STACK,t):null},I.ASTNode.createWorkspaceNode=function(t,e){return e&&t?new I.ASTNode(I.ASTNode.types.WORKSPACE,t,{wsCoordinate:e}):null},I.ASTNode.createTopNode=function(t){var e=t.previousConnection||t.outputConnection;return e?I.ASTNode.createConnectionNode(e):I.ASTNode.createBlockNode(t)},I.ASTNode.prototype.processParams_=function(t){t&&t.wsCoordinate&&(this.wsCoordinate_=t.wsCoordinate)},I.ASTNode.prototype.getLocation=function(){return this.location_},I.ASTNode.prototype.getType=function(){return this.type_},I.ASTNode.prototype.getWsCoordinate=function(){return this.wsCoordinate_},I.ASTNode.prototype.isConnection=function(){return this.isConnection_},I.ASTNode.prototype.findNextForInput_=function(){for(var t,e=(t=this.location_.getParentInput()).getSourceBlock(),t=e.inputList.indexOf(t)+1,o;o=e.inputList[t];t++){for(var i=o.fieldRow,s=0,n;n=i[s];s++)if(n.isClickable()||I.ASTNode.NAVIGATE_ALL_FIELDS)return I.ASTNode.createFieldNode(n);if(o.connection)return I.ASTNode.createInputNode(o)}return null},I.ASTNode.prototype.findNextForField_=function(){for(var t,e=(t=this.location_).getParentInput(),o=t.getSourceBlock(),i=o.inputList.indexOf(e),t=e.fieldRow.indexOf(t)+1;e=o.inputList[i];i++){for(var s=e.fieldRow;t<s.length;){if(s[t].isClickable()||I.ASTNode.NAVIGATE_ALL_FIELDS)return I.ASTNode.createFieldNode(s[t]);t++}if(t=0,e.connection)return I.ASTNode.createInputNode(e)}return null},I.ASTNode.prototype.findPrevForInput_=function(){for(var t=this.location_.getParentInput(),e=t.getSourceBlock(),o=e.inputList.indexOf(t),i;i=e.inputList[o];o--){if(i.connection&&i!==t)return I.ASTNode.createInputNode(i);for(var i,s=(i=i.fieldRow).length-1,n;n=i[s];s--)if(n.isClickable()||I.ASTNode.NAVIGATE_ALL_FIELDS)return I.ASTNode.createFieldNode(n)}return null},I.ASTNode.prototype.findPrevForField_=function(){for(var t,e=(t=this.location_).getParentInput(),o=t.getSourceBlock(),i=o.inputList.indexOf(e),t=e.fieldRow.indexOf(t)-1,s;s=o.inputList[i];i--){if(s.connection&&s!==e)return I.ASTNode.createInputNode(s);for(s=s.fieldRow;-1<t;){if(s[t].isClickable()||I.ASTNode.NAVIGATE_ALL_FIELDS)return I.ASTNode.createFieldNode(s[t]);t--}0<=i-1&&(t=o.inputList[i-1].fieldRow.length-1)}return null},I.ASTNode.prototype.navigateBetweenStacks_=function(t){var e;if(!(e=!((e=this.getLocation())instanceof I.Block)?e.getSourceBlock():e)||!e.workspace)return null;for(var o=e.getRootBlock(),e=o.workspace.getTopBlocks(!0),i=0,s;s=e[i];i++)if(o.id==s.id)return-1==(t=i+(t?1:-1))||t==e.length?null:I.ASTNode.createStackNode(e[t]);throw Error("Couldn't find "+(t?"next":"previous")+" stack?!")},I.ASTNode.prototype.findTopASTNodeForBlock_=function(t){var e=t.previousConnection||t.outputConnection;return e?I.ASTNode.createConnectionNode(e):I.ASTNode.createBlockNode(t)},I.ASTNode.prototype.getOutAstNodeForBlock_=function(t){if(!t)return null;var e=(t=t.getTopStackBlock()).previousConnection||t.outputConnection;return e&&e.targetConnection&&e.targetConnection.getParentInput()?I.ASTNode.createInputNode(e.targetConnection.getParentInput()):I.ASTNode.createStackNode(t)},I.ASTNode.prototype.findFirstFieldOrInput_=function(t){t=t.inputList;for(var e=0,o;o=t[e];e++){for(var i=o.fieldRow,s=0,n;n=i[s];s++)if(n.isClickable()||I.ASTNode.NAVIGATE_ALL_FIELDS)return I.ASTNode.createFieldNode(n);if(o.connection)return I.ASTNode.createInputNode(o)}return null},I.ASTNode.prototype.getSourceBlock=function(){return this.getType()===I.ASTNode.types.BLOCK||this.getType()===I.ASTNode.types.STACK?this.getLocation():this.getType()===I.ASTNode.types.WORKSPACE?null:this.getLocation().getSourceBlock()},I.ASTNode.prototype.next=function(){switch(this.type_){case I.ASTNode.types.STACK:return this.navigateBetweenStacks_(!0);case I.ASTNode.types.OUTPUT:var t=this.location_;return I.ASTNode.createBlockNode(t.getSourceBlock());case I.ASTNode.types.FIELD:return this.findNextForField_();case I.ASTNode.types.INPUT:return this.findNextForInput_();case I.ASTNode.types.BLOCK:return I.ASTNode.createConnectionNode(this.location_.nextConnection);case I.ASTNode.types.PREVIOUS:return t=this.location_,I.ASTNode.createBlockNode(t.getSourceBlock());case I.ASTNode.types.NEXT:return t=this.location_,I.ASTNode.createConnectionNode(t.targetConnection)}return null},I.ASTNode.prototype.in=function(){switch(this.type_){case I.ASTNode.types.WORKSPACE:var t=this.location_.getTopBlocks(!0);if(0<t.length)return I.ASTNode.createStackNode(t[0]);break;case I.ASTNode.types.STACK:return t=this.location_,this.findTopASTNodeForBlock_(t);case I.ASTNode.types.BLOCK:return t=this.location_,this.findFirstFieldOrInput_(t);case I.ASTNode.types.INPUT:return I.ASTNode.createConnectionNode(this.location_.targetConnection)}return null},I.ASTNode.prototype.prev=function(){switch(this.type_){case I.ASTNode.types.STACK:return this.navigateBetweenStacks_(!1);case I.ASTNode.types.FIELD:return this.findPrevForField_();case I.ASTNode.types.INPUT:return this.findPrevForInput_();case I.ASTNode.types.BLOCK:var t=this.location_;return I.ASTNode.createConnectionNode(t.previousConnection||t.outputConnection);case I.ASTNode.types.PREVIOUS:if((t=(t=this.location_).targetConnection)&&!t.getParentInput())return I.ASTNode.createConnectionNode(t);break;case I.ASTNode.types.NEXT:return t=this.location_,I.ASTNode.createBlockNode(t.getSourceBlock())}return null},I.ASTNode.prototype.out=function(){switch(this.type_){case I.ASTNode.types.STACK:var t=this.location_,e=t.getRelativeToSurfaceXY(),e=new I.utils.Coordinate(e.x,e.y+I.ASTNode.DEFAULT_OFFSET_Y);return I.ASTNode.createWorkspaceNode(t.workspace,e);case I.ASTNode.types.OUTPUT:return(e=(t=this.location_).targetConnection)?I.ASTNode.createConnectionNode(e):I.ASTNode.createStackNode(t.getSourceBlock());case I.ASTNode.types.FIELD:return I.ASTNode.createBlockNode(this.location_.getSourceBlock());case I.ASTNode.types.INPUT:return t=this.location_,I.ASTNode.createBlockNode(t.getSourceBlock());case I.ASTNode.types.BLOCK:return t=this.location_,this.getOutAstNodeForBlock_(t);case I.ASTNode.types.PREVIOUS:return t=this.location_,this.getOutAstNodeForBlock_(t.getSourceBlock());case I.ASTNode.types.NEXT:return t=this.location_,this.getOutAstNodeForBlock_(t.getSourceBlock())}return null},I.Blocks=Object.create(null),I.utils.deprecation={},I.utils.deprecation.warn=function(t,e,o,i){t=t+" was deprecated on "+e+" and will be deleted on "+o+".",i&&(t+="\nUse "+i+" instead."),console.warn(t)},I.Connection=function(t,e){this.sourceBlock_=t,this.type=e},I.Connection.CAN_CONNECT=0,I.Connection.REASON_SELF_CONNECTION=1,I.Connection.REASON_WRONG_TYPE=2,I.Connection.REASON_TARGET_NULL=3,I.Connection.REASON_CHECKS_FAILED=4,I.Connection.REASON_DIFFERENT_WORKSPACES=5,I.Connection.REASON_SHADOW_PARENT=6,I.Connection.REASON_DRAG_CHECKS_FAILED=7,I.Connection.prototype.targetConnection=null,I.Connection.prototype.disposed=!1,I.Connection.prototype.check_=null,I.Connection.prototype.shadowDom_=null,I.Connection.prototype.x=0,I.Connection.prototype.y=0,I.Connection.prototype.connect_=function(t){var e=this,o=e.getSourceBlock(),i=t.getSourceBlock(),s;if(t.isConnected()&&t.disconnect(),e.isConnected()){var n=e.targetBlock(),r=e.getShadowDom(),l;if(e.shadowDom_=null,n.isShadow())r=I.Xml.blockToDom(n),n.dispose(!1),n=null;else if(e.type==I.connectionTypes.INPUT_VALUE){if(!n.outputConnection)throw Error("Orphan block does not have an output connection.");var a=I.Connection.lastConnectionInRow(i,n);a&&(n.outputConnection.connect(a),n=null)}else if(e.type==I.connectionTypes.NEXT_STATEMENT){if(!n.previousConnection)throw Error("Orphan block does not have a previous connection.");for(a=i;a.nextConnection;){var c=a.getNextBlock();if(!c||c.isShadow()){n.workspace.connectionChecker.canConnect(n.previousConnection,a.nextConnection,!1)&&(a.nextConnection.connect(n.previousConnection),n=null);break}a=c}}n&&(e.disconnect(),I.Events.recordUndo)&&(l=I.Events.getGroup(),setTimeout(function(){n.workspace&&!n.getParent()&&(I.Events.setGroup(l),n.outputConnection?n.outputConnection.onFailedConnect(e):n.previousConnection&&n.previousConnection.onFailedConnect(e),I.Events.setGroup(!1))},I.BUMP_DELAY)),e.shadowDom_=r}I.Events.isEnabled()&&(s=new(I.Events.get(I.Events.BLOCK_MOVE))(i)),I.Connection.connectReciprocally_(e,t),i.setParent(o),s&&(s.recordNew(),I.Events.fire(s))},I.Connection.prototype.dispose=function(){var t;this.isConnected()&&(this.setShadowDom(null),(t=this.targetBlock())&&t.unplug()),this.disposed=!0},I.Connection.prototype.getSourceBlock=function(){return this.sourceBlock_},I.Connection.prototype.isSuperior=function(){return this.type==I.connectionTypes.INPUT_VALUE||this.type==I.connectionTypes.NEXT_STATEMENT},I.Connection.prototype.isConnected=function(){return!!this.targetConnection},I.Connection.prototype.canConnectWithReason=function(t){return I.utils.deprecation.warn("Connection.prototype.canConnectWithReason","July 2020","July 2021","the workspace's connection checker"),this.getConnectionChecker().canConnectWithReason(this,t,!1)},I.Connection.prototype.checkConnection=function(t){I.utils.deprecation.warn("Connection.prototype.checkConnection","July 2020","July 2021","the workspace's connection checker");var e=this.getConnectionChecker(),o=e.canConnectWithReason(this,t,!1);if(o!=I.Connection.CAN_CONNECT)throw Error(e.getErrorMessage(o,this,t))},I.Connection.prototype.getConnectionChecker=function(){return this.sourceBlock_.workspace.connectionChecker},I.Connection.prototype.isConnectionAllowed=function(t){return I.utils.deprecation.warn("Connection.prototype.isConnectionAllowed","July 2020","July 2021","the workspace's connection checker"),this.getConnectionChecker().canConnect(this,t,!0)},I.Connection.prototype.onFailedConnect=function(t){},I.Connection.prototype.connect=function(t){var e;this.targetConnection!=t&&this.getConnectionChecker().canConnect(this,t,!1)&&((e=I.Events.getGroup())||I.Events.setGroup(!0),this.isSuperior()?this.connect_(t):t.connect_(this),e||I.Events.setGroup(!1))},I.Connection.connectReciprocally_=function(t,e){if(!t||!e)throw Error("Cannot connect null connections.");(t.targetConnection=e).targetConnection=t},I.Connection.singleConnection_=function(t,e){var o=null;e=e.outputConnection;for(var i=0;i<t.inputList.length;i++){var s=t.inputList[i].connection,n=e.getConnectionChecker();if(s&&s.type==I.connectionTypes.INPUT_VALUE&&n.canConnect(e,s,!1)){if(o)return null;o=s}}return o},I.Connection.lastConnectionInRow=function(t,e){for(var o;o=I.Connection.singleConnection_(t,e);)if(!(t=o.targetBlock())||t.isShadow())return o;return null},I.Connection.prototype.disconnect=function(){var t=this.targetConnection,e,o,t;if(!t)throw Error("Source connection not connected.");if(t.targetConnection!=this)throw Error("Target connection not connected to source connection.");this.isSuperior()?(e=this.sourceBlock_,o=t.getSourceBlock(),t=this):(e=t.getSourceBlock(),o=this.sourceBlock_);var i=I.Events.getGroup();i||I.Events.setGroup(!0),this.disconnectInternal_(e,o),o.isShadow()||t.respawnShadow_(),i||I.Events.setGroup(!1)},I.Connection.prototype.disconnectInternal_=function(t,e){var o;I.Events.isEnabled()&&(o=new(I.Events.get(I.Events.BLOCK_MOVE))(e)),this.targetConnection=this.targetConnection.targetConnection=null,e.setParent(null),o&&(o.recordNew(),I.Events.fire(o))},I.Connection.prototype.respawnShadow_=function(){var t=this.getSourceBlock(),e=this.getShadowDom();if(t.workspace&&e)if((t=I.Xml.domToBlock(e,t.workspace)).outputConnection)this.connect(t.outputConnection);else{if(!t.previousConnection)throw Error("Child block does not have output or previous statement.");this.connect(t.previousConnection)}},I.Connection.prototype.targetBlock=function(){return this.isConnected()?this.targetConnection.getSourceBlock():null},I.Connection.prototype.checkType=function(t){return I.utils.deprecation.warn("Connection.prototype.checkType","October 2019","January 2021","the workspace's connection checker"),this.getConnectionChecker().canConnect(this,t,!1)},I.Connection.prototype.checkType_=function(t){return I.utils.deprecation.warn("Connection.prototype.checkType_","October 2019","January 2021","the workspace's connection checker"),this.checkType(t)},I.Connection.prototype.onCheckChanged_=function(){!this.isConnected()||this.targetConnection&&this.getConnectionChecker().canConnect(this,this.targetConnection,!1)||(this.isSuperior()?this.targetBlock():this.sourceBlock_).unplug()},I.Connection.prototype.setCheck=function(t){return t?(Array.isArray(t)||(t=[t]),this.check_=t,this.onCheckChanged_()):this.check_=null,this},I.Connection.prototype.getCheck=function(){return this.check_},I.Connection.prototype.setShadowDom=function(t){this.shadowDom_=t,(t=this.targetBlock())?t.isShadow()&&(t.dispose(!1),this.respawnShadow_()):this.respawnShadow_()},I.Connection.prototype.getShadowDom=function(){return this.shadowDom_},I.Connection.prototype.neighbours=function(t){return[]},I.Connection.prototype.getParentInput=function(){for(var t=null,e=this.sourceBlock_,o=e.inputList,i=0;i<e.inputList.length;i++)if(o[i].connection===this){t=o[i];break}return t},I.Connection.prototype.toString=function(){var t=this.sourceBlock_;if(!t)return"Orphan Connection";if(t.outputConnection==this)var e="Output Connection of ";else if(t.previousConnection==this)e="Previous Connection of ";else if(t.nextConnection==this)e="Next Connection of ";else{for(var e=null,o=0,i;i=t.inputList[o];o++)if(i.connection==this){e=i;break}if(!e)return console.warn("Connection not actually connected to sourceBlock_"),"Orphan Connection";e='Input "'+e.name+'" connection on '}return e+t.toDevString()},I.Extensions={},I.Extensions.ALL_={},I.Extensions.register=function(t,e){if("string"!=typeof t||""==t.trim())throw Error('Error: Invalid extension name "'+t+'"');if(I.Extensions.ALL_[t])throw Error('Error: Extension "'+t+'" is already registered.');if("function"!=typeof e)throw Error('Error: Extension "'+t+'" must be a function');I.Extensions.ALL_[t]=e},I.Extensions.registerMixin=function(t,e){if(!e||"object"!=typeof e)throw Error('Error: Mixin "'+t+'" must be a object');I.Extensions.register(t,function(){this.mixin(e)})},I.Extensions.registerMutator=function(t,e,o,i){var s='Error when registering mutator "'+t+'": ';I.Extensions.checkHasFunction_(s,e.domToMutation,"domToMutation"),I.Extensions.checkHasFunction_(s,e.mutationToDom,"mutationToDom");var n=I.Extensions.checkMutatorDialog_(e,s);if(o&&"function"!=typeof o)throw Error('Extension "'+t+'" is not a function');I.Extensions.register(t,function(){if(n){if(!I.Mutator)throw Error(s+"Missing require for Blockly.Mutator");this.setMutator(new I.Mutator(i||[]))}this.mixin(e),o&&o.apply(this)})},I.Extensions.unregister=function(t){I.Extensions.ALL_[t]?delete I.Extensions.ALL_[t]:console.warn('No extension mapping for name "'+t+'" found to unregister')},I.Extensions.apply=function(t,e,o){var i=I.Extensions.ALL_[t],s;if("function"!=typeof i)throw Error('Error: Extension "'+t+'" not found.');if(o?I.Extensions.checkNoMutatorProperties_(t,e):s=I.Extensions.getMutatorProperties_(e),i.apply(e),o)I.Extensions.checkBlockHasMutatorProperties_('Error after applying mutator "'+t+'": ',e);else if(!I.Extensions.mutatorPropertiesMatch_(s,e))throw Error('Error when applying extension "'+t+'": mutation properties changed when applying a non-mutator extension.')},I.Extensions.checkHasFunction_=function(t,e,o){if(!e)throw Error(t+'missing required property "'+o+'"');if("function"!=typeof e)throw Error(t+'" required property "'+o+'" must be a function')},I.Extensions.checkNoMutatorProperties_=function(t,e){if(I.Extensions.getMutatorProperties_(e).length)throw Error('Error: tried to apply mutation "'+t+'" to a block that already has mutator functions.  Block id: '+e.id)},I.Extensions.checkMutatorDialog_=function(t,e){var o=void 0!==t.compose,i=void 0!==t.decompose;if(o&&i){if("function"!=typeof t.compose)throw Error(e+"compose must be a function.");if("function"!=typeof t.decompose)throw Error(e+"decompose must be a function.");return!0}if(o||i)throw Error(e+'Must have both or neither of "compose" and "decompose"');return!1},I.Extensions.checkBlockHasMutatorProperties_=function(t,e){if("function"!=typeof e.domToMutation)throw Error(t+'Applying a mutator didn\'t add "domToMutation"');if("function"!=typeof e.mutationToDom)throw Error(t+'Applying a mutator didn\'t add "mutationToDom"');I.Extensions.checkMutatorDialog_(e,t)},I.Extensions.getMutatorProperties_=function(t){var e=[];return void 0!==t.domToMutation&&e.push(t.domToMutation),void 0!==t.mutationToDom&&e.push(t.mutationToDom),void 0!==t.compose&&e.push(t.compose),void 0!==t.decompose&&e.push(t.decompose),e},I.Extensions.mutatorPropertiesMatch_=function(t,e){if((e=I.Extensions.getMutatorProperties_(e)).length!=t.length)return!1;for(var o=0;o<e.length;o++)if(t[o]!=e[o])return!1;return!0},I.Extensions.buildTooltipForDropdown=function(o,i){var s=[];return"object"==typeof document&&I.utils.runAfterPageLoad(function(){for(var t in i)I.utils.checkMessageReferences(i[t])}),function(){this.type&&-1==s.indexOf(this.type)&&(I.Extensions.checkDropdownOptionsInTable_(this,o,i),s.push(this.type)),this.setTooltip(function(){var t=String(this.getFieldValue(o)),e=i[t];return null==e?-1==s.indexOf(this.type)&&(t="No tooltip mapping for value "+t+" of field "+o,null!=this.type&&(t+=" of block type "+this.type),console.warn(t+".")):e=I.utils.replaceMessageReferences(e),e}.bind(this))}},I.Extensions.checkDropdownOptionsInTable_=function(t,e,o){var i;if(!(i=t.getField(e)).isOptionListDynamic())for(var i=i.getOptions(),s=0;s<i.length;++s){var n=i[s][1];null==o[n]&&console.warn("No tooltip mapping for value "+n+" of field "+e+" of block type "+t.type)}},I.Extensions.buildTooltipWithFieldText=function(e,o){return"object"==typeof document&&I.utils.runAfterPageLoad(function(){I.utils.checkMessageReferences(e)}),function(){this.setTooltip(function(){var t=this.getField(o);return I.utils.replaceMessageReferences(e).replace("%1",t?t.getText():"")}.bind(this))}},I.Extensions.extensionParentTooltip_=function(){this.tooltipWhenNotConnected_=this.tooltip,this.setTooltip(function(){var t=this.getParent();return t&&t.getInputsInline()&&t.tooltip||this.tooltipWhenNotConnected_}.bind(this))},I.Extensions.register("parent_tooltip_when_inline",I.Extensions.extensionParentTooltip_),I.fieldRegistry={},I.fieldRegistry.register=function(t,e){I.registry.register(I.registry.Type.FIELD,t,e)},I.fieldRegistry.unregister=function(t){I.registry.unregister(I.registry.Type.FIELD,t)},I.fieldRegistry.fromJson=function(t){var e=I.registry.getObject(I.registry.Type.FIELD,t.type);return e?e.fromJson(t):(console.warn("Blockly could not create a field of type "+t.type+". The field is probably not being registered. This could be because the file is not loaded, the field does not register itself (Issue #1584), or the registration is not being reached."),null)},I.blockAnimations={},I.blockAnimations.disconnectPid_=0,I.blockAnimations.disconnectGroup_=null,I.blockAnimations.disposeUiEffect=function(t){var e=t.workspace,o=t.getSvgRoot();e.getAudioManager().play("delete"),t=e.getSvgXY(o),(o=o.cloneNode(!0)).translateX_=t.x,o.translateY_=t.y,o.setAttribute("transform","translate("+t.x+","+t.y+")"),e.getParentSvg().appendChild(o),o.bBox_=o.getBBox(),I.blockAnimations.disposeUiStep_(o,e.RTL,new Date,e.scale)},I.blockAnimations.disposeUiStep_=function(t,e,o,i){var s=(new Date-o)/150;1<s?I.utils.dom.removeNode(t):(t.setAttribute("transform","translate("+(t.translateX_+(e?-1:1)*t.bBox_.width*i/2*s)+","+(t.translateY_+t.bBox_.height*i*s)+") scale("+(1-s)*i+")"),setTimeout(I.blockAnimations.disposeUiStep_,10,t,e,o,i))},I.blockAnimations.connectionUiEffect=function(t){var e=t.workspace,o=e.scale,i;e.getAudioManager().play("click"),o<1||(i=e.getSvgXY(t.getSvgRoot()),t.outputConnection?(i.x+=(t.RTL?3:-3)*o,i.y+=13*o):t.previousConnection&&(i.x+=(t.RTL?-23:23)*o,i.y+=3*o),t=I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{cx:i.x,cy:i.y,r:0,fill:"none",stroke:"#888","stroke-width":10},e.getParentSvg()),I.blockAnimations.connectionUiStep_(t,new Date,o))},I.blockAnimations.connectionUiStep_=function(t,e,o){var i=(new Date-e)/150;1<i?I.utils.dom.removeNode(t):(t.setAttribute("r",25*i*o),t.style.opacity=1-i,I.blockAnimations.disconnectPid_=setTimeout(I.blockAnimations.connectionUiStep_,10,t,e,o))},I.blockAnimations.disconnectUiEffect=function(t){var e,e;t.workspace.getAudioManager().play("disconnect"),t.workspace.scale<1||(e=t.getHeightWidth().height,e=Math.atan(10/e)/Math.PI*180,t.RTL||(e*=-1),I.blockAnimations.disconnectUiStep_(t.getSvgRoot(),e,new Date))},I.blockAnimations.disconnectUiStep_=function(t,e,o){var i=(new Date-o)/200;1<i?t.skew_="":(t.skew_="skewX("+Math.round(Math.sin(i*Math.PI*3)*(1-i)*e)+")",I.blockAnimations.disconnectGroup_=t,I.blockAnimations.disconnectPid_=setTimeout(I.blockAnimations.disconnectUiStep_,10,t,e,o)),t.setAttribute("transform",t.translate_+t.skew_)},I.blockAnimations.disconnectUiStop=function(){var t;I.blockAnimations.disconnectGroup_&&(clearTimeout(I.blockAnimations.disconnectPid_),(t=I.blockAnimations.disconnectGroup_).skew_="",t.setAttribute("transform",t.translate_),I.blockAnimations.disconnectGroup_=null)},I.Events.BlockDrag=function(t,e,o){I.Events.BlockDrag.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.isStart=e,this.blocks=o},I.utils.object.inherits(I.Events.BlockDrag,I.Events.UiBase),I.Events.BlockDrag.prototype.type=I.Events.BLOCK_DRAG,I.Events.BlockDrag.prototype.toJson=function(){var t=I.Events.BlockDrag.superClass_.toJson.call(this);return t.isStart=this.isStart,t.blockId=this.blockId,t.blocks=this.blocks,t},I.Events.BlockDrag.prototype.fromJson=function(t){I.Events.BlockDrag.superClass_.fromJson.call(this,t),this.isStart=t.isStart,this.blockId=t.blockId,this.blocks=t.blocks},I.registry.register(I.registry.Type.EVENT,I.Events.BLOCK_DRAG,I.Events.BlockDrag),I.InsertionMarkerManager=function(t){this.topBlock_=I.selected=t,this.workspace_=t.workspace,this.lastMarker_=this.lastOnStack_=null,this.firstMarker_=this.createMarkerBlock_(this.topBlock_),this.localConnection_=this.closestConnection_=null,this.wouldDeleteBlock_=!1,this.fadedBlock_=this.highlightedBlock_=this.markerConnection_=null,this.availableConnections_=this.initAvailableConnections_()},I.InsertionMarkerManager.PREVIEW_TYPE={INSERTION_MARKER:0,INPUT_OUTLINE:1,REPLACEMENT_FADE:2},I.InsertionMarkerManager.prototype.dispose=function(){this.availableConnections_.length=0,I.Events.disable();try{this.firstMarker_&&this.firstMarker_.dispose(),this.lastMarker_&&this.lastMarker_.dispose()}finally{I.Events.enable()}},I.InsertionMarkerManager.prototype.updateAvailableConnections=function(){this.availableConnections_=this.initAvailableConnections_()},I.InsertionMarkerManager.prototype.wouldDeleteBlock=function(){return this.wouldDeleteBlock_},I.InsertionMarkerManager.prototype.wouldConnectBlock=function(){return!!this.closestConnection_},I.InsertionMarkerManager.prototype.applyConnections=function(){var t;this.closestConnection_&&(I.Events.disable(),this.hidePreview_(),I.Events.enable(),this.localConnection_.connect(this.closestConnection_),this.topBlock_.rendered)&&(t=this.localConnection_.isSuperior()?this.closestConnection_:this.localConnection_,I.blockAnimations.connectionUiEffect(t.getSourceBlock()),this.topBlock_.getRootBlock().bringToFront())},I.InsertionMarkerManager.prototype.update=function(t,e){var o=this.getCandidate_(t);((this.wouldDeleteBlock_=this.shouldDelete_(o,e))||this.shouldUpdatePreviews_(o,t))&&(I.Events.disable(),this.maybeHidePreview_(o),this.maybeShowPreview_(o),I.Events.enable())},I.InsertionMarkerManager.prototype.createMarkerBlock_=function(t){var e=t.type;I.Events.disable();try{var o=this.workspace_.newBlock(e),i;for(o.setInsertionMarker(!0),!t.mutationToDom||(i=t.mutationToDom())&&o.domToMutation(i),e=0;e<t.inputList.length;e++){var s=t.inputList[e];if(s.name!=I.constants.COLLAPSED_INPUT_NAME)for(var n=o.inputList[e],i=0;i<s.fieldRow.length;i++)n.fieldRow[i].setValue(s.fieldRow[i].getValue())}o.setCollapsed(t.isCollapsed()),o.setInputsInline(t.getInputsInline()),o.initSvg(),o.getSvgRoot().setAttribute("visibility","hidden")}finally{I.Events.enable()}return o},I.InsertionMarkerManager.prototype.initAvailableConnections_=function(){var t=this.topBlock_.getConnections_(!1),e=this.topBlock_.lastConnectionInStack();if(e&&e!=this.topBlock_.nextConnection){if(t.push(e),this.lastOnStack_=e,this.lastMarker_){I.Events.disable();try{this.lastMarker_.dispose()}finally{I.Events.enable()}}this.lastMarker_=this.createMarkerBlock_(e.getSourceBlock())}return t},I.InsertionMarkerManager.prototype.shouldUpdatePreviews_=function(t,e){var o=t.local,i=t.closest;if(t=t.radius,!o||!i)return!(!this.localConnection_||!this.closestConnection_);if(this.localConnection_&&this.closestConnection_){if(this.closestConnection_==i&&this.localConnection_==o)return!1;return o=this.localConnection_.x+e.x-this.closestConnection_.x,e=this.localConnection_.y+e.y-this.closestConnection_.y,e=Math.sqrt(o*o+e*e),!(i&&t>e-I.CURRENT_CONNECTION_PREFERENCE)}if(!this.localConnection_&&!this.closestConnection_)return!0;return console.error("Only one of localConnection_ and closestConnection_ was set."),console.error("Returning true from shouldUpdatePreviews, but it's not clear why."),!0},I.InsertionMarkerManager.prototype.getCandidate_=function(t){for(var e=this.getStartRadius_(),o=null,i=null,s=0;s<this.availableConnections_.length;s++){var n=this.availableConnections_[s],r=n.closest(e,t);r.connection&&(o=r.connection,i=n,e=r.radius)}return{closest:o,local:i,radius:e}},I.InsertionMarkerManager.prototype.getStartRadius_=function(){return this.closestConnection_&&this.localConnection_?I.CONNECTING_SNAP_RADIUS:I.SNAP_RADIUS},I.InsertionMarkerManager.prototype.shouldDelete_=function(t,e){return t=t&&!!t.closest&&e!=I.DELETE_AREA_TOOLBOX,!!e&&!this.topBlock_.getParent()&&this.topBlock_.isDeletable()&&!t},I.InsertionMarkerManager.prototype.maybeShowPreview_=function(t){var e;this.wouldDeleteBlock_||(e=t.closest,t=t.local,e&&(e==this.closestConnection_||e.getSourceBlock().isInsertionMarker()?console.log("Trying to connect to an insertion marker"):(this.closestConnection_=e,this.localConnection_=t,this.showPreview_())))},I.InsertionMarkerManager.prototype.showPreview_=function(){var t=this.closestConnection_,e=this.workspace_.getRenderer();switch(e.getConnectionPreviewMethod(t,this.localConnection_,this.topBlock_)){case I.InsertionMarkerManager.PREVIEW_TYPE.INPUT_OUTLINE:this.showInsertionInputOutline_();break;case I.InsertionMarkerManager.PREVIEW_TYPE.INSERTION_MARKER:this.showInsertionMarker_();break;case I.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE:this.showReplacementFade_()}t&&e.shouldHighlightConnection(t)&&t.highlight()},I.InsertionMarkerManager.prototype.maybeHidePreview_=function(t){var e;t.closest?(e=this.closestConnection_!=t.closest,t=this.localConnection_!=t.local,this.closestConnection_&&this.localConnection_&&(e||t||this.wouldDeleteBlock_)&&this.hidePreview_()):this.hidePreview_(),this.localConnection_=this.closestConnection_=this.markerConnection_=null},I.InsertionMarkerManager.prototype.hidePreview_=function(){this.closestConnection_&&this.closestConnection_.targetBlock()&&this.workspace_.getRenderer().shouldHighlightConnection(this.closestConnection_)&&this.closestConnection_.unhighlight(),this.fadedBlock_?this.hideReplacementFade_():this.highlightedBlock_?this.hideInsertionInputOutline_():this.markerConnection_&&this.hideInsertionMarker_()},I.InsertionMarkerManager.prototype.showInsertionMarker_=function(){var t=this.localConnection_,e=this.closestConnection_,o=this.lastOnStack_&&t==this.lastOnStack_?this.lastMarker_:this.firstMarker_,t;if((t=o.getMatchingConnection(t.getSourceBlock(),t))==this.markerConnection_)throw Error("Made it to showInsertionMarker_ even though the marker isn't changing");o.render(),o.rendered=!0,o.getSvgRoot().setAttribute("visibility","visible"),t&&e&&o.positionNearConnection(t,e),e&&t.connect(e),this.markerConnection_=t},I.InsertionMarkerManager.prototype.hideInsertionMarker_=function(){if(this.markerConnection_){var t=this.markerConnection_,e=t.getSourceBlock(),o=e.nextConnection,i=e.previousConnection,s=e.outputConnection,s=t.type==I.connectionTypes.INPUT_VALUE&&!(s&&s.targetConnection);if(!(t!=o||i&&i.targetConnection)||s?t.targetBlock().unplug(!1):t.type==I.connectionTypes.NEXT_STATEMENT&&t!=o?((o=t.targetConnection).getSourceBlock().unplug(!1),i=i?i.targetConnection:null,e.unplug(!0),i&&i.connect(o)):e.unplug(!0),t.targetConnection)throw Error("markerConnection_ still connected at the end of disconnectInsertionMarker");this.markerConnection_=null,e.getSvgRoot().setAttribute("visibility","hidden")}else console.log("No insertion marker connection to disconnect")},I.InsertionMarkerManager.prototype.showInsertionInputOutline_=function(){var t=this.closestConnection_;this.highlightedBlock_=t.getSourceBlock(),this.highlightedBlock_.highlightShapeForInput(t,!0)},I.InsertionMarkerManager.prototype.hideInsertionInputOutline_=function(){this.highlightedBlock_.highlightShapeForInput(this.closestConnection_,!1),this.highlightedBlock_=null},I.InsertionMarkerManager.prototype.showReplacementFade_=function(){this.fadedBlock_=this.closestConnection_.targetBlock(),this.fadedBlock_.fadeForReplacement(!0)},I.InsertionMarkerManager.prototype.hideReplacementFade_=function(){this.fadedBlock_.fadeForReplacement(!1),this.fadedBlock_=null},I.InsertionMarkerManager.prototype.getInsertionMarkers=function(){var t=[];return this.firstMarker_&&t.push(this.firstMarker_),this.lastMarker_&&t.push(this.lastMarker_),t},I.BlockDragger=function(t,e){this.draggingBlock_=t,this.workspace_=e,this.draggedConnectionManager_=new I.InsertionMarkerManager(this.draggingBlock_),this.deleteArea_=null,this.wouldDeleteBlock_=!1,this.startXY_=this.draggingBlock_.getRelativeToSurfaceXY(),this.dragIconData_=I.BlockDragger.initIconData_(t)},I.BlockDragger.prototype.dispose=function(){this.dragIconData_.length=0,this.draggedConnectionManager_&&this.draggedConnectionManager_.dispose()},I.BlockDragger.initIconData_=function(t){var e=[];t=t.getDescendants(!1);for(var o=0,i;i=t[o];o++)for(var i=i.getIcons(),s=0;s<i.length;s++){var n={location:i[s].getIconLocation(),icon:i[s]};e.push(n)}return e},I.BlockDragger.prototype.startBlockDrag=function(t,e){I.Events.getGroup()||I.Events.setGroup(!0),this.fireDragStartEvent_(),this.workspace_.isMutator&&this.draggingBlock_.bringToFront(),I.utils.dom.startTextWidthCache(),this.workspace_.setResizesEnabled(!1),I.blockAnimations.disconnectUiStop(),(this.draggingBlock_.getParent()||e&&this.draggingBlock_.nextConnection&&this.draggingBlock_.nextConnection.targetBlock())&&(this.draggingBlock_.unplug(e),t=this.pixelsToWorkspaceUnits_(t),t=I.utils.Coordinate.sum(this.startXY_,t),this.draggingBlock_.translate(t.x,t.y),I.blockAnimations.disconnectUiEffect(this.draggingBlock_),this.draggedConnectionManager_.updateAvailableConnections()),this.draggingBlock_.setDragging(!0),this.draggingBlock_.moveToDragSurface(),(t=this.workspace_.getToolbox())&&"function"==typeof t.addStyle&&(e=this.draggingBlock_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.addStyle(e))},I.BlockDragger.prototype.fireDragStartEvent_=function(){var t=new(I.Events.get(I.Events.BLOCK_DRAG))(this.draggingBlock_,!0,this.draggingBlock_.getDescendants(!1));I.Events.fire(t)},I.BlockDragger.prototype.dragBlock=function(t,e){e=this.pixelsToWorkspaceUnits_(e);var o=I.utils.Coordinate.sum(this.startXY_,e);this.draggingBlock_.moveDuringDrag(o),this.dragIcons_(e),this.deleteArea_=this.workspace_.isDeleteArea(t),this.draggedConnectionManager_.update(e,this.deleteArea_),this.updateCursorDuringBlockDrag_()},I.BlockDragger.prototype.endBlockDrag=function(t,e){this.dragBlock(t,e),this.dragIconData_=[],this.fireDragEndEvent_(),I.utils.dom.stopTextWidthCache(),I.blockAnimations.disconnectUiStop(),t=this.pixelsToWorkspaceUnits_(e),e=I.utils.Coordinate.sum(this.startXY_,t),this.draggingBlock_.moveOffDragSurface(e),this.maybeDeleteBlock_()||(this.draggingBlock_.moveConnections(t.x,t.y),this.draggingBlock_.setDragging(!1),this.fireMoveEvent_(),this.draggedConnectionManager_.wouldConnectBlock()?this.draggedConnectionManager_.applyConnections():this.draggingBlock_.render(),this.draggingBlock_.scheduleSnapAndBump()),this.workspace_.setResizesEnabled(!0),(t=this.workspace_.getToolbox())&&"function"==typeof t.removeStyle&&(e=this.draggingBlock_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.removeStyle(e)),I.Events.setGroup(!1)},I.BlockDragger.prototype.fireDragEndEvent_=function(){var t=new(I.Events.get(I.Events.BLOCK_DRAG))(this.draggingBlock_,!1,this.draggingBlock_.getDescendants(!1));I.Events.fire(t)},I.BlockDragger.prototype.fireMoveEvent_=function(){var t=new(I.Events.get(I.Events.BLOCK_MOVE))(this.draggingBlock_);t.oldCoordinate=this.startXY_,t.recordNew(),I.Events.fire(t)},I.BlockDragger.prototype.maybeDeleteBlock_=function(){var t=this.workspace_.trashcan;return this.wouldDeleteBlock_?(t&&setTimeout(t.closeLid.bind(t),100),this.fireMoveEvent_(),this.draggingBlock_.dispose(!1,!0),I.draggingConnections=[]):t&&t.closeLid(),this.wouldDeleteBlock_},I.BlockDragger.prototype.updateCursorDuringBlockDrag_=function(){this.wouldDeleteBlock_=this.draggedConnectionManager_.wouldDeleteBlock();var t=this.workspace_.trashcan;this.wouldDeleteBlock_?(this.draggingBlock_.setDeleteStyle(!0),this.deleteArea_==I.DELETE_AREA_TRASH&&t&&t.setLidOpen(!0)):(this.draggingBlock_.setDeleteStyle(!1),t&&t.setLidOpen(!1))},I.BlockDragger.prototype.pixelsToWorkspaceUnits_=function(t){return t=new I.utils.Coordinate(t.x/this.workspace_.scale,t.y/this.workspace_.scale),this.workspace_.isMutator&&t.scale(1/this.workspace_.options.parentWorkspace.scale),t},I.BlockDragger.prototype.dragIcons_=function(t){for(var e=0;e<this.dragIconData_.length;e++){var o=this.dragIconData_[e];o.icon.setIconLocation(I.utils.Coordinate.sum(o.location,t))}},I.BlockDragger.prototype.getInsertionMarkers=function(){return this.draggedConnectionManager_&&this.draggedConnectionManager_.getInsertionMarkers?this.draggedConnectionManager_.getInsertionMarkers():[]},I.IConnectionChecker=function(){},I.ConnectionChecker=function(){},I.ConnectionChecker.prototype.canConnect=function(t,e,o,i){return this.canConnectWithReason(t,e,o,i)==I.Connection.CAN_CONNECT},I.ConnectionChecker.prototype.canConnectWithReason=function(t,e,o,i){var s=this.doSafetyChecks(t,e);return s!=I.Connection.CAN_CONNECT?s:this.doTypeChecks(t,e)?o&&!this.doDragChecks(t,e,i||0)?I.Connection.REASON_DRAG_CHECKS_FAILED:I.Connection.CAN_CONNECT:I.Connection.REASON_CHECKS_FAILED},I.ConnectionChecker.prototype.getErrorMessage=function(t,e,o){switch(t){case I.Connection.REASON_SELF_CONNECTION:return"Attempted to connect a block to itself.";case I.Connection.REASON_DIFFERENT_WORKSPACES:return"Blocks not on same workspace.";case I.Connection.REASON_WRONG_TYPE:return"Attempt to connect incompatible types.";case I.Connection.REASON_TARGET_NULL:return"Target connection is null.";case I.Connection.REASON_CHECKS_FAILED:return"Connection checks failed. "+e+" expected "+e.getCheck()+", found "+o.getCheck();case I.Connection.REASON_SHADOW_PARENT:return"Connecting non-shadow to shadow block.";case I.Connection.REASON_DRAG_CHECKS_FAILED:return"Drag checks failed.";default:return"Unknown connection failure: this should never happen!"}},I.ConnectionChecker.prototype.doSafetyChecks=function(t,e){if(!t||!e)return I.Connection.REASON_TARGET_NULL;var o,i;return t.isSuperior()?(o=t.getSourceBlock(),i=e.getSourceBlock()):(i=t.getSourceBlock(),o=e.getSourceBlock()),o==i?I.Connection.REASON_SELF_CONNECTION:e.type!=I.OPPOSITE_TYPE[t.type]?I.Connection.REASON_WRONG_TYPE:o.workspace!==i.workspace?I.Connection.REASON_DIFFERENT_WORKSPACES:o.isShadow()&&!i.isShadow()?I.Connection.REASON_SHADOW_PARENT:I.Connection.CAN_CONNECT},I.ConnectionChecker.prototype.doTypeChecks=function(t,e){if(t=t.getCheck(),e=e.getCheck(),!t||!e)return!0;for(var o=0;o<t.length;o++)if(-1!=e.indexOf(t[o]))return!0;return!1},I.ConnectionChecker.prototype.doDragChecks=function(t,e,o){if(t.distanceFrom(e)>o||e.getSourceBlock().isInsertionMarker())return!1;switch(e.type){case I.connectionTypes.PREVIOUS_STATEMENT:return this.canConnectToPrevious_(t,e);case I.connectionTypes.OUTPUT_VALUE:if(e.isConnected()&&!e.targetBlock().isInsertionMarker()||t.isConnected())return!1;break;case I.connectionTypes.INPUT_VALUE:if(e.isConnected()&&!e.targetBlock().isMovable()&&!e.targetBlock().isShadow())return!1;break;case I.connectionTypes.NEXT_STATEMENT:if(e.isConnected()&&!t.getSourceBlock().nextConnection&&!e.targetBlock().isShadow()&&e.targetBlock().nextConnection)return!1;break;default:return!1}return-1==I.draggingConnections.indexOf(e)},I.ConnectionChecker.prototype.canConnectToPrevious_=function(t,e){if(t.targetConnection||-1!=I.draggingConnections.indexOf(e))return!1;if(!e.targetConnection)return!0;return!!(t=e.targetBlock()).isInsertionMarker()&&!t.getPreviousBlock()},I.registry.register(I.registry.Type.CONNECTION_CHECKER,I.registry.DEFAULT,I.ConnectionChecker),I.VariableMap=function(t){this.variableMap_=Object.create(null),this.workspace=t},I.VariableMap.prototype.clear=function(){this.variableMap_=Object.create(null)},I.VariableMap.prototype.renameVariable=function(t,e){var o=this.getVariable(e,t.type),i=this.workspace.getAllBlocks(!1);I.Events.setGroup(!0);try{o&&o.getId()!=t.getId()?this.renameVariableWithConflict_(t,e,o,i):this.renameVariableAndUses_(t,e,i)}finally{I.Events.setGroup(!1)}},I.VariableMap.prototype.renameVariableById=function(t,e){var o=this.getVariableById(t);if(!o)throw Error("Tried to rename a variable that didn't exist. ID: "+t);this.renameVariable(o,e)},I.VariableMap.prototype.renameVariableAndUses_=function(t,e,o){for(I.Events.fire(new(I.Events.get(I.Events.VAR_RENAME))(t,e)),t.name=e,e=0;e<o.length;e++)o[e].updateVarName(t)},I.VariableMap.prototype.renameVariableWithConflict_=function(t,e,o,i){var s=t.type;for(e!=o.name&&this.renameVariableAndUses_(o,e,i),e=0;e<i.length;e++)i[e].renameVarById(t.getId(),o.getId());I.Events.fire(new(I.Events.get(I.Events.VAR_DELETE))(t)),t=this.getVariablesOfType(s).indexOf(t),this.variableMap_[s].splice(t,1)},I.VariableMap.prototype.createVariable=function(t,e,o){var i=this.getVariable(t,e);if(i){if(o&&i.getId()!=o)throw Error('Variable "'+t+'" is already in use and its id is "'+i.getId()+'" which conflicts with the passed in id, "'+o+'".');return i}if(o&&this.getVariableById(o))throw Error('Variable id, "'+o+'", is already in use.');return i=o||I.utils.genUid(),i=new I.VariableModel(this.workspace,t,e=e||"",i),(t=this.variableMap_[e]||[]).push(i),delete this.variableMap_[e],this.variableMap_[e]=t,i},I.VariableMap.prototype.deleteVariable=function(t){for(var e=this.variableMap_[t.type],o=0,i;i=e[o];o++)if(i.getId()==t.getId()){e.splice(o,1),I.Events.fire(new(I.Events.get(I.Events.VAR_DELETE))(t));break}},I.VariableMap.prototype.deleteVariableById=function(t){var e=this.getVariableById(t);if(e){var o=e.name,i=this.getVariableUsesById(t),s;for(t=0;s=i[t];t++)if("procedures_defnoreturn"==s.type||"procedures_defreturn"==s.type)return t=s.getFieldValue("NAME"),o=I.Msg.CANNOT_DELETE_VARIABLE_PROCEDURE.replace("%1",o).replace("%2",t),void I.alert(o);var n=this;1<i.length?(o=I.Msg.DELETE_VARIABLE_CONFIRMATION.replace("%1",String(i.length)).replace("%2",o),I.confirm(o,function(t){t&&e&&n.deleteVariableInternal(e,i)})):n.deleteVariableInternal(e,i)}else console.warn("Can't delete non-existent variable: "+t)},I.VariableMap.prototype.deleteVariableInternal=function(t,e){var o=I.Events.getGroup();o||I.Events.setGroup(!0);try{for(var i=0;i<e.length;i++)e[i].dispose(!0);this.deleteVariable(t)}finally{o||I.Events.setGroup(!1)}},I.VariableMap.prototype.getVariable=function(t,e){if(e=this.variableMap_[e||""])for(var o=0,i;i=e[o];o++)if(I.Names.equals(i.name,t))return i;return null},I.VariableMap.prototype.getVariableById=function(t){for(var e=Object.keys(this.variableMap_),o=0;o<e.length;o++)for(var i=e[o],s=0,n;n=this.variableMap_[i][s];s++)if(n.getId()==t)return n;return null},I.VariableMap.prototype.getVariablesOfType=function(t){return(t=this.variableMap_[t||""])?t.slice():[]},I.VariableMap.prototype.getVariableTypes=function(t){var e;I.utils.object.mixin(e={},this.variableMap_),t&&t.getPotentialVariableMap()&&I.utils.object.mixin(e,t.getPotentialVariableMap().variableMap_),t=Object.keys(e);for(var e=!1,o=0;o<t.length;o++)""==t[o]&&(e=!0);return e||t.push(""),t},I.VariableMap.prototype.getAllVariables=function(){var t=[],e;for(e in this.variableMap_)t=t.concat(this.variableMap_[e]);return t},I.VariableMap.prototype.getAllVariableNames=function(){var t=[],e;for(e in this.variableMap_)for(var o=this.variableMap_[e],i=0,s;s=o[i];i++)t.push(s.name);return t},I.VariableMap.prototype.getVariableUsesById=function(t){for(var e=[],o=this.workspace.getAllBlocks(!1),i=0;i<o.length;i++){var s=o[i].getVarModels();if(s)for(var n=0;n<s.length;n++)s[n].getId()==t&&e.push(o[i])}return e},I.Workspace=function(t){this.id=I.utils.genUid(),(I.Workspace.WorkspaceDB_[this.id]=this).options=t||new I.Options({}),this.RTL=!!this.options.RTL,this.horizontalLayout=!!this.options.horizontalLayout,this.toolboxPosition=this.options.toolboxPosition,this.connectionChecker=new(I.registry.getClassFromOptions(I.registry.Type.CONNECTION_CHECKER,this.options,!0))(this),this.topBlocks_=[],this.topComments_=[],this.commentDB_=Object.create(null),this.listeners_=[],this.undoStack_=[],this.redoStack_=[],this.blockDB_=Object.create(null),this.typedBlocksDB_=Object.create(null),this.variableMap_=new I.VariableMap(this),this.potentialVariableMap_=null},I.Workspace.prototype.rendered=!1,I.Workspace.prototype.isClearing=!1,I.Workspace.prototype.MAX_UNDO=1024,I.Workspace.prototype.connectionDBList=null,I.Workspace.prototype.dispose=function(){this.listeners_.length=0,this.clear(),delete I.Workspace.WorkspaceDB_[this.id]},I.Workspace.SCAN_ANGLE=3,I.Workspace.prototype.sortObjects_=function(t,e){return t=t.getRelativeToSurfaceXY(),e=e.getRelativeToSurfaceXY(),t.y+I.Workspace.prototype.sortObjects_.offset*t.x-(e.y+I.Workspace.prototype.sortObjects_.offset*e.x)},I.Workspace.prototype.addTopBlock=function(t){this.topBlocks_.push(t)},I.Workspace.prototype.removeTopBlock=function(t){if(!I.utils.arrayRemove(this.topBlocks_,t))throw Error("Block not present in workspace's list of top-most blocks.")},I.Workspace.prototype.getTopBlocks=function(t){var e=[].concat(this.topBlocks_);return t&&1<e.length&&(this.sortObjects_.offset=Math.sin(I.utils.math.toRadians(I.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),e.sort(this.sortObjects_)),e},I.Workspace.prototype.addTypedBlock=function(t){this.typedBlocksDB_[t.type]||(this.typedBlocksDB_[t.type]=[]),this.typedBlocksDB_[t.type].push(t)},I.Workspace.prototype.removeTypedBlock=function(t){this.typedBlocksDB_[t.type].splice(this.typedBlocksDB_[t.type].indexOf(t),1),this.typedBlocksDB_[t.type].length||delete this.typedBlocksDB_[t.type]},I.Workspace.prototype.getBlocksByType=function(t,e){if(!this.typedBlocksDB_[t])return[];return t=this.typedBlocksDB_[t].slice(0),e&&1<t.length&&(this.sortObjects_.offset=Math.sin(I.utils.math.toRadians(I.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),t.sort(this.sortObjects_)),t},I.Workspace.prototype.addTopComment=function(t){this.topComments_.push(t),this.commentDB_[t.id]&&console.warn('Overriding an existing comment on this workspace, with id "'+t.id+'"'),this.commentDB_[t.id]=t},I.Workspace.prototype.removeTopComment=function(t){if(!I.utils.arrayRemove(this.topComments_,t))throw Error("Comment not present in workspace's list of top-most comments.");delete this.commentDB_[t.id]},I.Workspace.prototype.getTopComments=function(t){var e=[].concat(this.topComments_);return t&&1<e.length&&(this.sortObjects_.offset=Math.sin(I.utils.math.toRadians(I.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),e.sort(this.sortObjects_)),e},I.Workspace.prototype.getAllBlocks=function(t){if(t){t=this.getTopBlocks(!0);for(var e=[],o=0;o<t.length;o++)e.push.apply(e,t[o].getDescendants(!0))}else for(e=this.getTopBlocks(!1),o=0;o<e.length;o++)e.push.apply(e,e[o].getChildren(!1));return e.filter(function(t){return!t.isInsertionMarker()})},I.Workspace.prototype.clear=function(){this.isClearing=!0;try{var t=I.Events.getGroup();for(t||I.Events.setGroup(!0);this.topBlocks_.length;)this.topBlocks_[0].dispose(!1);for(;this.topComments_.length;)this.topComments_[this.topComments_.length-1].dispose(!1);t||I.Events.setGroup(!1),this.variableMap_.clear(),this.potentialVariableMap_&&this.potentialVariableMap_.clear()}finally{this.isClearing=!1}},I.Workspace.prototype.renameVariableById=function(t,e){this.variableMap_.renameVariableById(t,e)},I.Workspace.prototype.createVariable=function(t,e,o){return this.variableMap_.createVariable(t,e,o)},I.Workspace.prototype.getVariableUsesById=function(t){return this.variableMap_.getVariableUsesById(t)},I.Workspace.prototype.deleteVariableById=function(t){this.variableMap_.deleteVariableById(t)},I.Workspace.prototype.getVariable=function(t,e){return this.variableMap_.getVariable(t,e)},I.Workspace.prototype.getVariableById=function(t){return this.variableMap_.getVariableById(t)},I.Workspace.prototype.getVariablesOfType=function(t){return this.variableMap_.getVariablesOfType(t)},I.Workspace.prototype.getVariableTypes=function(){return this.variableMap_.getVariableTypes(this)},I.Workspace.prototype.getAllVariables=function(){return this.variableMap_.getAllVariables()},I.Workspace.prototype.getAllVariableNames=function(){return this.variableMap_.getAllVariableNames()},I.Workspace.prototype.getWidth=function(){return 0},I.Workspace.prototype.newBlock=function(t,e){return new I.Block(this,t,e)},I.Workspace.prototype.remainingCapacity=function(){return isNaN(this.options.maxBlocks)?1/0:this.options.maxBlocks-this.getAllBlocks(!1).length},I.Workspace.prototype.remainingCapacityOfType=function(t){return this.options.maxInstances?(void 0!==this.options.maxInstances[t]?this.options.maxInstances[t]:1/0)-this.getBlocksByType(t,!1).length:1/0},I.Workspace.prototype.isCapacityAvailable=function(t){if(!this.hasBlockLimits())return!0;var e=0,o;for(o in t){if(t[o]>this.remainingCapacityOfType(o))return!1;e+=t[o]}return!(e>this.remainingCapacity())},I.Workspace.prototype.hasBlockLimits=function(){return 1/0!=this.options.maxBlocks||!!this.options.maxInstances},I.Workspace.prototype.getUndoStack=function(){return this.undoStack_},I.Workspace.prototype.getRedoStack=function(){return this.redoStack_},I.Workspace.prototype.undo=function(t){var e=t?this.redoStack_:this.undoStack_,o=t?this.undoStack_:this.redoStack_,i=e.pop();if(i){for(var s=[i];e.length&&i.group&&i.group==e[e.length-1].group;)s.push(e.pop());for(e=0;i=s[e];e++)o.push(i);s=I.Events.filter(s,t),I.Events.recordUndo=!1;try{for(e=0;i=s[e];e++)i.run(t)}finally{I.Events.recordUndo=!0}}},I.Workspace.prototype.clearUndo=function(){this.undoStack_.length=0,this.redoStack_.length=0,I.Events.clearPendingUndo()},I.Workspace.prototype.addChangeListener=function(t){return this.listeners_.push(t),t},I.Workspace.prototype.removeChangeListener=function(t){I.utils.arrayRemove(this.listeners_,t)},I.Workspace.prototype.fireChangeListener=function(t){if(t.recordUndo)for(this.undoStack_.push(t),this.redoStack_.length=0;this.undoStack_.length>this.MAX_UNDO&&0<=this.MAX_UNDO;)this.undoStack_.shift();for(var e=0,o;o=this.listeners_[e];e++)o(t)},I.Workspace.prototype.getBlockById=function(t){return this.blockDB_[t]||null},I.Workspace.prototype.setBlockById=function(t,e){this.blockDB_[t]=e},I.Workspace.prototype.removeBlockById=function(t){delete this.blockDB_[t]},I.Workspace.prototype.getCommentById=function(t){return this.commentDB_[t]||null},I.Workspace.prototype.allInputsFilled=function(t){for(var e=this.getTopBlocks(!1),o=0,i;i=e[o];o++)if(!i.allInputsFilled(t))return!1;return!0},I.Workspace.prototype.getPotentialVariableMap=function(){return this.potentialVariableMap_},I.Workspace.prototype.createPotentialVariableMap=function(){this.potentialVariableMap_=new I.VariableMap(this)},I.Workspace.prototype.getVariableMap=function(){return this.variableMap_},I.Workspace.prototype.setVariableMap=function(t){this.variableMap_=t},I.Workspace.WorkspaceDB_=Object.create(null),I.Workspace.getById=function(t){return I.Workspace.WorkspaceDB_[t]||null},I.Workspace.getAll=function(){var t=[],e;for(e in I.Workspace.WorkspaceDB_)t.push(I.Workspace.WorkspaceDB_[e]);return t},I.Bubble=function(t,e,o,i,s,n){this.workspace_=t,this.content_=e,this.shape_=o,this.onMouseDownResizeWrapper_=this.onMouseDownBubbleWrapper_=this.moveCallback_=this.resizeCallback_=null,this.disposed=!1,o=I.Bubble.ARROW_ANGLE,this.workspace_.RTL&&(o=-o),this.arrow_radians_=I.utils.math.toRadians(o),t.getBubbleCanvas().appendChild(this.createDom_(e,!(!s||!n))),this.setAnchorLocation(i),s&&n||(s=(t=this.content_.getBBox()).width+2*I.Bubble.BORDER_WIDTH,n=t.height+2*I.Bubble.BORDER_WIDTH),this.setBubbleSize(s,n),this.positionBubble_(),this.renderArrow_(),this.rendered_=!0},I.Bubble.BORDER_WIDTH=6,I.Bubble.ARROW_THICKNESS=5,I.Bubble.ARROW_ANGLE=20,I.Bubble.ARROW_BEND=4,I.Bubble.ANCHOR_RADIUS=8,I.Bubble.onMouseUpWrapper_=null,I.Bubble.onMouseMoveWrapper_=null,I.Bubble.unbindDragEvents_=function(){I.Bubble.onMouseUpWrapper_&&(I.browserEvents.unbind(I.Bubble.onMouseUpWrapper_),I.Bubble.onMouseUpWrapper_=null),I.Bubble.onMouseMoveWrapper_&&(I.browserEvents.unbind(I.Bubble.onMouseMoveWrapper_),I.Bubble.onMouseMoveWrapper_=null)},I.Bubble.bubbleMouseUp_=function(t){I.Touch.clearTouchIdentifier(),I.Bubble.unbindDragEvents_()},I.Bubble.prototype.rendered_=!1,I.Bubble.prototype.anchorXY_=null,I.Bubble.prototype.relativeLeft_=0,I.Bubble.prototype.relativeTop_=0,I.Bubble.prototype.width_=0,I.Bubble.prototype.height_=0,I.Bubble.prototype.autoLayout_=!0,I.Bubble.prototype.createDom_=function(t,e){this.bubbleGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},null);var o={filter:"url(#"+this.workspace_.getRenderer().getConstants().embossFilterId+")"};return I.utils.userAgent.JAVA_FX&&(o={}),o=I.utils.dom.createSvgElement(I.utils.Svg.G,o,this.bubbleGroup_),this.bubbleArrow_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{},o),this.bubbleBack_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyDraggable",x:0,y:0,rx:I.Bubble.BORDER_WIDTH,ry:I.Bubble.BORDER_WIDTH},o),e?(this.resizeGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:this.workspace_.RTL?"blocklyResizeSW":"blocklyResizeSE"},this.bubbleGroup_),e=2*I.Bubble.BORDER_WIDTH,I.utils.dom.createSvgElement(I.utils.Svg.POLYGON,{points:"0,x x,x x,0".replace(/x/g,e.toString())},this.resizeGroup_),I.utils.dom.createSvgElement(I.utils.Svg.LINE,{class:"blocklyResizeLine",x1:e/3,y1:e-1,x2:e-1,y2:e/3},this.resizeGroup_),I.utils.dom.createSvgElement(I.utils.Svg.LINE,{class:"blocklyResizeLine",x1:2*e/3,y1:e-1,x2:e-1,y2:2*e/3},this.resizeGroup_)):this.resizeGroup_=null,this.workspace_.options.readOnly||(this.onMouseDownBubbleWrapper_=I.browserEvents.conditionalBind(this.bubbleBack_,"mousedown",this,this.bubbleMouseDown_),this.resizeGroup_&&(this.onMouseDownResizeWrapper_=I.browserEvents.conditionalBind(this.resizeGroup_,"mousedown",this,this.resizeMouseDown_))),this.bubbleGroup_.appendChild(t),this.bubbleGroup_},I.Bubble.prototype.getSvgRoot=function(){return this.bubbleGroup_},I.Bubble.prototype.setSvgId=function(t){this.bubbleGroup_.dataset&&(this.bubbleGroup_.dataset.blockId=t)},I.Bubble.prototype.bubbleMouseDown_=function(t){var e=this.workspace_.getGesture(t);e&&e.handleBubbleStart(t,this)},I.Bubble.prototype.showContextMenu=function(t){},I.Bubble.prototype.isDeletable=function(){return!1},I.Bubble.prototype.setDeleteStyle=function(t){},I.Bubble.prototype.resizeMouseDown_=function(t){this.promote(),I.Bubble.unbindDragEvents_(),I.utils.isRightButton(t)||(this.workspace_.startDrag(t,new I.utils.Coordinate(this.workspace_.RTL?-this.width_:this.width_,this.height_)),I.Bubble.onMouseUpWrapper_=I.browserEvents.conditionalBind(document,"mouseup",this,I.Bubble.bubbleMouseUp_),I.Bubble.onMouseMoveWrapper_=I.browserEvents.conditionalBind(document,"mousemove",this,this.resizeMouseMove_),I.hideChaff()),t.stopPropagation()},I.Bubble.prototype.resizeMouseMove_=function(t){this.autoLayout_=!1,t=this.workspace_.moveDrag(t),this.setBubbleSize(this.workspace_.RTL?-t.x:t.x,t.y),this.workspace_.RTL&&this.positionBubble_()},I.Bubble.prototype.registerResizeEvent=function(t){this.resizeCallback_=t},I.Bubble.prototype.registerMoveEvent=function(t){this.moveCallback_=t},I.Bubble.prototype.promote=function(){var t=this.bubbleGroup_.parentNode;return t.lastChild!==this.bubbleGroup_&&(t.appendChild(this.bubbleGroup_),!0)},I.Bubble.prototype.setAnchorLocation=function(t){this.anchorXY_=t,this.rendered_&&this.positionBubble_()},I.Bubble.prototype.layoutBubble_=function(){var t=this.workspace_.getMetricsManager().getViewMetrics(!0),e=this.getOptimalRelativeLeft_(t),o=this.getOptimalRelativeTop_(t),i=this.shape_.getBBox(),s={x:e,y:-this.height_-this.workspace_.getRenderer().getConstants().MIN_BLOCK_HEIGHT},n={x:-this.width_-30,y:o},o={x:i.width,y:o},r={x:e,y:i.height},e=i.width<i.height?o:r,i=i.width<i.height?r:o;o=this.getOverlap_(s,t);var r=this.getOverlap_(n,t),l=this.getOverlap_(e,t),t=this.getOverlap_(i,t);o==(t=Math.max(o,r,l,t))?(this.relativeLeft_=s.x,this.relativeTop_=s.y):r==t?(this.relativeLeft_=n.x,this.relativeTop_=n.y):l==t?(this.relativeLeft_=e.x,this.relativeTop_=e.y):(this.relativeLeft_=i.x,this.relativeTop_=i.y)},I.Bubble.prototype.getOverlap_=function(t,e){var o=this.workspace_.RTL?this.anchorXY_.x-t.x-this.width_:t.x+this.anchorXY_.x;return t=t.y+this.anchorXY_.y,Math.max(0,Math.min(1,(Math.min(o+this.width_,e.left+e.width)-Math.max(o,e.left))*(Math.min(t+this.height_,e.top+e.height)-Math.max(t,e.top))/(this.width_*this.height_)))},I.Bubble.prototype.getOptimalRelativeLeft_=function(t){var e=-this.width_/4,o,i,s,n;if(this.width_>t.width)return e;return this.workspace_.RTL?(i=(o=this.anchorXY_.x-e)-this.width_,s=t.left+t.width,n=t.left+I.Scrollbar.scrollbarThickness/this.workspace_.scale):(o=(i=e+this.anchorXY_.x)+this.width_,n=t.left,s=t.left+t.width-I.Scrollbar.scrollbarThickness/this.workspace_.scale),this.workspace_.RTL?i<n?e=-(n-this.anchorXY_.x+this.width_):s<o&&(e=-(s-this.anchorXY_.x)):i<n?e=n-this.anchorXY_.x:s<o&&(e=s-this.anchorXY_.x-this.width_),e},I.Bubble.prototype.getOptimalRelativeTop_=function(t){var e=-this.height_/4;if(this.height_>t.height)return e;var o=this.anchorXY_.y+e,i=o+this.height_,s=t.top;t=t.top+t.height-I.Scrollbar.scrollbarThickness/this.workspace_.scale;var n=this.anchorXY_.y;return o<s?e=s-n:t<i&&(e=t-n-this.height_),e},I.Bubble.prototype.positionBubble_=function(){var t=this.anchorXY_.x,t=this.workspace_.RTL?t-(this.relativeLeft_+this.width_):t+this.relativeLeft_;this.moveTo(t,this.relativeTop_+this.anchorXY_.y)},I.Bubble.prototype.moveTo=function(t,e){this.bubbleGroup_.setAttribute("transform","translate("+t+","+e+")")},I.Bubble.prototype.setDragging=function(t){!t&&this.moveCallback_&&this.moveCallback_()},I.Bubble.prototype.getBubbleSize=function(){return new I.utils.Size(this.width_,this.height_)},I.Bubble.prototype.setBubbleSize=function(t,e){var o=2*I.Bubble.BORDER_WIDTH;t=Math.max(t,o+45),e=Math.max(e,o+20),this.width_=t,this.height_=e,this.bubbleBack_.setAttribute("width",t),this.bubbleBack_.setAttribute("height",e),this.resizeGroup_&&(this.workspace_.RTL?this.resizeGroup_.setAttribute("transform","translate("+2*I.Bubble.BORDER_WIDTH+","+(e-o)+") scale(-1 1)"):this.resizeGroup_.setAttribute("transform","translate("+(t-o)+","+(e-o)+")")),this.autoLayout_&&this.layoutBubble_(),this.positionBubble_(),this.renderArrow_(),this.resizeCallback_&&this.resizeCallback_()},I.Bubble.prototype.renderArrow_=function(){var t=[],e=this.width_/2,o=this.height_/2,i=-this.relativeLeft_,s=-this.relativeTop_,n,r,l,a,c,h,l,i,s,h,u;e==i&&o==s?t.push("M "+e+","+o):(s-=o,i-=e,this.workspace_.RTL&&(i*=-1),n=Math.sqrt(s*s+i*i),r=Math.acos(i/n),(l=(r=s<0?2*Math.PI-r:r)+Math.PI/2)>2*Math.PI&&(l-=2*Math.PI),a=Math.sin(l),c=Math.cos(l),l=((h=this.getBubbleSize()).width+h.height)/I.Bubble.ARROW_THICKNESS,l=Math.min(l,h.width,h.height)/4,i=e+(h=1-I.Bubble.ANCHOR_RADIUS/n)*i,s=o+h*s,h=e+l*c,u=o+l*a,e-=l*c,o-=l*a,(a=r+this.arrow_radians_)>2*Math.PI&&(a-=2*Math.PI),r=Math.sin(a)*n/I.Bubble.ARROW_BEND,n=Math.cos(a)*n/I.Bubble.ARROW_BEND,t.push("M"+h+","+u),t.push("C"+(h+n)+","+(u+r)+" "+i+","+s+" "+i+","+s),t.push("C"+i+","+s+" "+(e+n)+","+(o+r)+" "+e+","+o)),t.push("z"),this.bubbleArrow_.setAttribute("d",t.join(" "))},I.Bubble.prototype.setColour=function(t){this.bubbleBack_.setAttribute("fill",t),this.bubbleArrow_.setAttribute("fill",t)},I.Bubble.prototype.dispose=function(){this.onMouseDownBubbleWrapper_&&I.browserEvents.unbind(this.onMouseDownBubbleWrapper_),this.onMouseDownResizeWrapper_&&I.browserEvents.unbind(this.onMouseDownResizeWrapper_),I.Bubble.unbindDragEvents_(),I.utils.dom.removeNode(this.bubbleGroup_),this.disposed=!0},I.Bubble.prototype.moveDuringDrag=function(t,e){t?t.translateSurface(e.x,e.y):this.moveTo(e.x,e.y),this.relativeLeft_=this.workspace_.RTL?this.anchorXY_.x-e.x-this.width_:e.x-this.anchorXY_.x,this.relativeTop_=e.y-this.anchorXY_.y,this.renderArrow_()},I.Bubble.prototype.getRelativeToSurfaceXY=function(){return new I.utils.Coordinate(this.workspace_.RTL?-this.relativeLeft_+this.anchorXY_.x-this.width_:this.anchorXY_.x+this.relativeLeft_,this.anchorXY_.y+this.relativeTop_)},I.Bubble.prototype.setAutoLayout=function(t){this.autoLayout_=t},I.Bubble.textToDom=function(t){var e=I.utils.dom.createSvgElement(I.utils.Svg.TEXT,{class:"blocklyText blocklyBubbleText blocklyNoPointerEvents",y:I.Bubble.BORDER_WIDTH},null);t=t.split("\n");for(var o=0;o<t.length;o++){var i=I.utils.dom.createSvgElement(I.utils.Svg.TSPAN,{dy:"1em",x:I.Bubble.BORDER_WIDTH},e),s=document.createTextNode(t[o]);i.appendChild(s)}return e},I.Bubble.createNonEditableBubble=function(t,e,o){if((o=new I.Bubble(e.workspace,t,e.pathObject.svgPath,o,null,null)).setSvgId(e.id),e.RTL){e=t.getBBox().width;for(var i=0,s;s=t.childNodes[i];i++)s.setAttribute("text-anchor","end"),s.setAttribute("x",e+I.Bubble.BORDER_WIDTH)}return o},I.Events.CommentBase=function(t){this.commentId=(this.isBlank=void 0===t)?"":t.id,this.workspaceId=this.isBlank?"":t.workspace.id,this.group=I.Events.getGroup(),this.recordUndo=I.Events.recordUndo},I.utils.object.inherits(I.Events.CommentBase,I.Events.Abstract),I.Events.CommentBase.prototype.toJson=function(){var t=I.Events.CommentBase.superClass_.toJson.call(this);return this.commentId&&(t.commentId=this.commentId),t},I.Events.CommentBase.prototype.fromJson=function(t){I.Events.CommentBase.superClass_.fromJson.call(this,t),this.commentId=t.commentId},I.Events.CommentChange=function(t,e,o){I.Events.CommentChange.superClass_.constructor.call(this,t),t&&(this.oldContents_=void 0===e?"":e,this.newContents_=void 0===o?"":o)},I.utils.object.inherits(I.Events.CommentChange,I.Events.CommentBase),I.Events.CommentChange.prototype.type=I.Events.COMMENT_CHANGE,I.Events.CommentChange.prototype.toJson=function(){var t=I.Events.CommentChange.superClass_.toJson.call(this);return t.oldContents=this.oldContents_,t.newContents=this.newContents_,t},I.Events.CommentChange.prototype.fromJson=function(t){I.Events.CommentChange.superClass_.fromJson.call(this,t),this.oldContents_=t.oldContents,this.newContents_=t.newContents},I.Events.CommentChange.prototype.isNull=function(){return this.oldContents_==this.newContents_},I.Events.CommentChange.prototype.run=function(t){var e=this.getEventWorkspace_().getCommentById(this.commentId);e?e.setContent(t?this.newContents_:this.oldContents_):console.warn("Can't change non-existent comment: "+this.commentId)},I.Events.CommentCreate=function(t){I.Events.CommentCreate.superClass_.constructor.call(this,t),t&&(this.xml=t.toXmlWithXY())},I.utils.object.inherits(I.Events.CommentCreate,I.Events.CommentBase),I.Events.CommentCreate.prototype.type=I.Events.COMMENT_CREATE,I.Events.CommentCreate.prototype.toJson=function(){var t=I.Events.CommentCreate.superClass_.toJson.call(this);return t.xml=I.Xml.domToText(this.xml),t},I.Events.CommentCreate.prototype.fromJson=function(t){I.Events.CommentCreate.superClass_.fromJson.call(this,t),this.xml=I.Xml.textToDom(t.xml)},I.Events.CommentCreate.prototype.run=function(t){I.Events.CommentCreateDeleteHelper(this,t)},I.Events.CommentCreateDeleteHelper=function(t,e){var o=t.getEventWorkspace_();e?((e=I.utils.xml.createElement("xml")).appendChild(t.xml),I.Xml.domToWorkspace(e,o)):(o=o.getCommentById(t.commentId))?o.dispose(!1,!1):console.warn("Can't uncreate non-existent comment: "+t.commentId)},I.Events.CommentDelete=function(t){I.Events.CommentDelete.superClass_.constructor.call(this,t),t&&(this.xml=t.toXmlWithXY())},I.utils.object.inherits(I.Events.CommentDelete,I.Events.CommentBase),I.Events.CommentDelete.prototype.type=I.Events.COMMENT_DELETE,I.Events.CommentDelete.prototype.toJson=function(){return I.Events.CommentDelete.superClass_.toJson.call(this)},I.Events.CommentDelete.prototype.fromJson=function(t){I.Events.CommentDelete.superClass_.fromJson.call(this,t)},I.Events.CommentDelete.prototype.run=function(t){I.Events.CommentCreateDeleteHelper(this,!t)},I.Events.CommentMove=function(t){I.Events.CommentMove.superClass_.constructor.call(this,t),t&&(this.comment_=t,this.oldCoordinate_=t.getXY(),this.newCoordinate_=null)},I.utils.object.inherits(I.Events.CommentMove,I.Events.CommentBase),I.Events.CommentMove.prototype.recordNew=function(){if(!this.comment_)throw Error("Tried to record the new position of a comment on the same event twice.");this.newCoordinate_=this.comment_.getXY(),this.comment_=null},I.Events.CommentMove.prototype.type=I.Events.COMMENT_MOVE,I.Events.CommentMove.prototype.setOldCoordinate=function(t){this.oldCoordinate_=t},I.Events.CommentMove.prototype.toJson=function(){var t=I.Events.CommentMove.superClass_.toJson.call(this);return this.oldCoordinate_&&(t.oldCoordinate=Math.round(this.oldCoordinate_.x)+","+Math.round(this.oldCoordinate_.y)),this.newCoordinate_&&(t.newCoordinate=Math.round(this.newCoordinate_.x)+","+Math.round(this.newCoordinate_.y)),t},I.Events.CommentMove.prototype.fromJson=function(t){var e;I.Events.CommentMove.superClass_.fromJson.call(this,t),t.oldCoordinate&&(e=t.oldCoordinate.split(","),this.oldCoordinate_=new I.utils.Coordinate(Number(e[0]),Number(e[1]))),t.newCoordinate&&(e=t.newCoordinate.split(","),this.newCoordinate_=new I.utils.Coordinate(Number(e[0]),Number(e[1])))},I.Events.CommentMove.prototype.isNull=function(){return I.utils.Coordinate.equals(this.oldCoordinate_,this.newCoordinate_)},I.Events.CommentMove.prototype.run=function(t){var e=this.getEventWorkspace_().getCommentById(this.commentId),o;e?(t=t?this.newCoordinate_:this.oldCoordinate_,o=e.getXY(),e.moveBy(t.x-o.x,t.y-o.y)):console.warn("Can't move non-existent comment: "+this.commentId)},I.registry.register(I.registry.Type.EVENT,I.Events.COMMENT_CREATE,I.Events.CommentCreate),I.registry.register(I.registry.Type.EVENT,I.Events.COMMENT_CHANGE,I.Events.CommentChange),I.registry.register(I.registry.Type.EVENT,I.Events.COMMENT_MOVE,I.Events.CommentMove),I.registry.register(I.registry.Type.EVENT,I.Events.COMMENT_DELETE,I.Events.CommentDelete),I.BubbleDragger=function(t,e){this.draggingBubble_=t,this.workspace_=e,this.deleteArea_=null,this.wouldDeleteBubble_=!1,this.startXY_=this.draggingBubble_.getRelativeToSurfaceXY(),this.dragSurface_=I.utils.is3dSupported()&&e.getBlockDragSurface()?e.getBlockDragSurface():null},I.BubbleDragger.prototype.dispose=function(){this.dragSurface_=this.workspace_=this.draggingBubble_=null},I.BubbleDragger.prototype.startBubbleDrag=function(){I.Events.getGroup()||I.Events.setGroup(!0),this.workspace_.setResizesEnabled(!1),this.draggingBubble_.setAutoLayout(!1),this.dragSurface_&&this.moveToDragSurface_(),this.draggingBubble_.setDragging&&this.draggingBubble_.setDragging(!0);var t=this.workspace_.getToolbox(),e;t&&"function"==typeof t.addStyle&&(e=this.draggingBubble_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.addStyle(e))},I.BubbleDragger.prototype.dragBubble=function(t,e){e=this.pixelsToWorkspaceUnits_(e),e=I.utils.Coordinate.sum(this.startXY_,e),this.draggingBubble_.moveDuringDrag(this.dragSurface_,e),this.draggingBubble_.isDeletable()&&(this.deleteArea_=this.workspace_.isDeleteArea(t),this.updateCursorDuringBubbleDrag_())},I.BubbleDragger.prototype.maybeDeleteBubble_=function(){var t=this.workspace_.trashcan;return this.wouldDeleteBubble_?(t&&setTimeout(t.closeLid.bind(t),100),this.fireMoveEvent_(),this.draggingBubble_.dispose(!1,!0)):t&&t.closeLid(),this.wouldDeleteBubble_},I.BubbleDragger.prototype.updateCursorDuringBubbleDrag_=function(){this.wouldDeleteBubble_=this.deleteArea_!=I.DELETE_AREA_NONE;var t=this.workspace_.trashcan;this.wouldDeleteBubble_?(this.draggingBubble_.setDeleteStyle(!0),this.deleteArea_==I.DELETE_AREA_TRASH&&t&&t.setLidOpen(!0)):(this.draggingBubble_.setDeleteStyle(!1),t&&t.setLidOpen(!1))},I.BubbleDragger.prototype.endBubbleDrag=function(t,e){this.dragBubble(t,e),t=this.pixelsToWorkspaceUnits_(e),t=I.utils.Coordinate.sum(this.startXY_,t),this.draggingBubble_.moveTo(t.x,t.y),this.maybeDeleteBubble_()||(this.dragSurface_&&this.dragSurface_.clearAndHide(this.workspace_.getBubbleCanvas()),this.draggingBubble_.setDragging&&this.draggingBubble_.setDragging(!1),this.fireMoveEvent_()),this.workspace_.setResizesEnabled(!0),(t=this.workspace_.getToolbox())&&"function"==typeof t.removeStyle&&(e=this.draggingBubble_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.removeStyle(e)),I.Events.setGroup(!1)},I.BubbleDragger.prototype.fireMoveEvent_=function(){var t;this.draggingBubble_.isComment&&((t=new(I.Events.get(I.Events.COMMENT_MOVE))(this.draggingBubble_)).setOldCoordinate(this.startXY_),t.recordNew(),I.Events.fire(t))},I.BubbleDragger.prototype.pixelsToWorkspaceUnits_=function(t){return t=new I.utils.Coordinate(t.x/this.workspace_.scale,t.y/this.workspace_.scale),this.workspace_.isMutator&&t.scale(1/this.workspace_.options.parentWorkspace.scale),t},I.BubbleDragger.prototype.moveToDragSurface_=function(){this.draggingBubble_.moveTo(0,0),this.dragSurface_.translateSurface(this.startXY_.x,this.startXY_.y),this.dragSurface_.setBlocksAndShow(this.draggingBubble_.getSvgRoot())},I.Events.Click=function(t,e,o){I.Events.Click.superClass_.constructor.call(this,t?t.workspace.id:e),this.blockId=t?t.id:null,this.targetType=o},I.utils.object.inherits(I.Events.Click,I.Events.UiBase),I.Events.Click.prototype.type=I.Events.CLICK,I.Events.Click.prototype.toJson=function(){var t=I.Events.Click.superClass_.toJson.call(this);return t.targetType=this.targetType,this.blockId&&(t.blockId=this.blockId),t},I.Events.Click.prototype.fromJson=function(t){I.Events.Click.superClass_.fromJson.call(this,t),this.targetType=t.targetType,this.blockId=t.blockId},I.registry.register(I.registry.Type.EVENT,I.Events.CLICK,I.Events.Click),I.WorkspaceDragger=function(t){this.workspace_=t,this.horizontalScrollEnabled_=this.workspace_.isMovableHorizontally(),this.verticalScrollEnabled_=this.workspace_.isMovableVertically(),this.startScrollXY_=new I.utils.Coordinate(t.scrollX,t.scrollY)},I.WorkspaceDragger.prototype.dispose=function(){this.workspace_=null},I.WorkspaceDragger.prototype.startDrag=function(){I.selected&&I.selected.unselect(),this.workspace_.setupDragSurface()},I.WorkspaceDragger.prototype.endDrag=function(t){this.drag(t),this.workspace_.resetDragSurface()},I.WorkspaceDragger.prototype.drag=function(t){if(t=I.utils.Coordinate.sum(this.startScrollXY_,t),this.horizontalScrollEnabled_&&this.verticalScrollEnabled_)this.workspace_.scroll(t.x,t.y);else if(this.horizontalScrollEnabled_)this.workspace_.scroll(t.x,this.workspace_.scrollY);else{if(!this.verticalScrollEnabled_)throw new TypeError("Invalid state.");this.workspace_.scroll(this.workspace_.scrollX,t.y)}},I.Gesture=function(t,e){this.mouseDownXY_=null,this.currentDragDeltaXY_=new I.utils.Coordinate(0,0),this.startWorkspace_=this.targetBlock_=this.startBlock_=this.startField_=this.startBubble_=null,this.creatorWorkspace_=e,this.isDraggingBubble_=this.isDraggingBlock_=this.isDraggingWorkspace_=this.hasExceededDragRadius_=!1,this.mostRecentEvent_=t,this.flyout_=this.workspaceDragger_=this.blockDragger_=this.bubbleDragger_=this.onUpWrapper_=this.onMoveWrapper_=null,this.isEnding_=this.hasStarted_=this.calledUpdateIsDragging_=!1,this.healStack_=!I.DRAG_STACK},I.Gesture.prototype.dispose=function(){I.Touch.clearTouchIdentifier(),I.Tooltip.unblock(),this.creatorWorkspace_.clearGesture(),this.onMoveWrapper_&&I.browserEvents.unbind(this.onMoveWrapper_),this.onUpWrapper_&&I.browserEvents.unbind(this.onUpWrapper_),this.blockDragger_&&this.blockDragger_.dispose(),this.workspaceDragger_&&this.workspaceDragger_.dispose(),this.bubbleDragger_&&this.bubbleDragger_.dispose()},I.Gesture.prototype.updateFromEvent_=function(t){var e=new I.utils.Coordinate(t.clientX,t.clientY);this.updateDragDelta_(e)&&(this.updateIsDragging_(),I.longStop_()),this.mostRecentEvent_=t},I.Gesture.prototype.updateDragDelta_=function(t){return this.currentDragDeltaXY_=I.utils.Coordinate.difference(t,this.mouseDownXY_),!this.hasExceededDragRadius_&&(this.hasExceededDragRadius_=I.utils.Coordinate.magnitude(this.currentDragDeltaXY_)>(this.flyout_?I.FLYOUT_DRAG_RADIUS:I.DRAG_RADIUS))},I.Gesture.prototype.updateIsDraggingFromFlyout_=function(){return!(!this.targetBlock_||!this.flyout_.isBlockCreatable_(this.targetBlock_))&&(!(this.flyout_.isScrollable()&&!this.flyout_.isDragTowardWorkspace(this.currentDragDeltaXY_))&&(this.startWorkspace_=this.flyout_.targetWorkspace,this.startWorkspace_.updateScreenCalculationsIfScrolled(),I.Events.getGroup()||I.Events.setGroup(!0),this.startBlock_=null,this.targetBlock_=this.flyout_.createBlock(this.targetBlock_),this.targetBlock_.select(),!0))},I.Gesture.prototype.updateIsDraggingBubble_=function(){if(!this.startBubble_)return!1;return this.isDraggingBubble_=!0,this.startDraggingBubble_(),!0},I.Gesture.prototype.updateIsDraggingBlock_=function(){if(!this.targetBlock_)return!1;return this.flyout_?this.isDraggingBlock_=this.updateIsDraggingFromFlyout_():this.targetBlock_.isMovable()&&(this.isDraggingBlock_=!0),!!this.isDraggingBlock_&&(this.startDraggingBlock_(),!0)},I.Gesture.prototype.updateIsDraggingWorkspace_=function(){(this.flyout_?this.flyout_.isScrollable():this.startWorkspace_&&this.startWorkspace_.isDraggable())&&(this.workspaceDragger_=new I.WorkspaceDragger(this.startWorkspace_),this.isDraggingWorkspace_=!0,this.workspaceDragger_.startDrag())},I.Gesture.prototype.updateIsDragging_=function(){if(this.calledUpdateIsDragging_)throw Error("updateIsDragging_ should only be called once per gesture.");this.calledUpdateIsDragging_=!0,this.updateIsDraggingBubble_()||this.updateIsDraggingBlock_()||this.updateIsDraggingWorkspace_()},I.Gesture.prototype.startDraggingBlock_=function(){this.blockDragger_=new I.BlockDragger(this.targetBlock_,this.startWorkspace_),this.blockDragger_.startBlockDrag(this.currentDragDeltaXY_,this.healStack_),this.blockDragger_.dragBlock(this.mostRecentEvent_,this.currentDragDeltaXY_)},I.Gesture.prototype.startDraggingBubble_=function(){this.bubbleDragger_=new I.BubbleDragger(this.startBubble_,this.startWorkspace_),this.bubbleDragger_.startBubbleDrag(),this.bubbleDragger_.dragBubble(this.mostRecentEvent_,this.currentDragDeltaXY_)},I.Gesture.prototype.doStart=function(t){I.utils.isTargetInput(t)?this.cancel():(this.hasStarted_=!0,I.blockAnimations.disconnectUiStop(),this.startWorkspace_.updateScreenCalculationsIfScrolled(),this.startWorkspace_.isMutator&&this.startWorkspace_.resize(),I.hideChaff(!!this.flyout_),this.startWorkspace_.markFocused(),this.mostRecentEvent_=t,I.Tooltip.block(),this.targetBlock_&&this.targetBlock_.select(),I.utils.isRightButton(t)?this.handleRightClick(t):("touchstart"!=t.type.toLowerCase()&&"pointerdown"!=t.type.toLowerCase()||"mouse"==t.pointerType||I.longStart(t,this),this.mouseDownXY_=new I.utils.Coordinate(t.clientX,t.clientY),this.healStack_=t.altKey||t.ctrlKey||t.metaKey,this.bindMouseEvents(t)))},I.Gesture.prototype.bindMouseEvents=function(t){this.onMoveWrapper_=I.browserEvents.conditionalBind(document,"mousemove",null,this.handleMove.bind(this)),this.onUpWrapper_=I.browserEvents.conditionalBind(document,"mouseup",null,this.handleUp.bind(this)),t.preventDefault(),t.stopPropagation()},I.Gesture.prototype.handleMove=function(t){this.updateFromEvent_(t),this.isDraggingWorkspace_?this.workspaceDragger_.drag(this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.dragBlock(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingBubble_&&this.bubbleDragger_.dragBubble(this.mostRecentEvent_,this.currentDragDeltaXY_),t.preventDefault(),t.stopPropagation()},I.Gesture.prototype.handleUp=function(t){this.updateFromEvent_(t),I.longStop_(),this.isEnding_?console.log("Trying to end a gesture recursively."):(this.isEnding_=!0,this.isDraggingBubble_?this.bubbleDragger_.endBubbleDrag(t,this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.endBlockDrag(t,this.currentDragDeltaXY_):this.isDraggingWorkspace_?this.workspaceDragger_.endDrag(this.currentDragDeltaXY_):this.isBubbleClick_()?this.doBubbleClick_():this.isFieldClick_()?this.doFieldClick_():this.isBlockClick_()?this.doBlockClick_():this.isWorkspaceClick_()&&this.doWorkspaceClick_(t),t.preventDefault(),t.stopPropagation(),this.dispose())},I.Gesture.prototype.cancel=function(){this.isEnding_||(I.longStop_(),this.isDraggingBubble_?this.bubbleDragger_.endBubbleDrag(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.endBlockDrag(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingWorkspace_&&this.workspaceDragger_.endDrag(this.currentDragDeltaXY_),this.dispose())},I.Gesture.prototype.handleRightClick=function(t){this.targetBlock_?(this.bringBlockToFront_(),I.hideChaff(!!this.flyout_),this.targetBlock_.showContextMenu(t)):this.startBubble_?this.startBubble_.showContextMenu(t):this.startWorkspace_&&!this.flyout_&&(I.hideChaff(),this.startWorkspace_.showContextMenu(t)),t.preventDefault(),t.stopPropagation(),this.dispose()},I.Gesture.prototype.handleWsStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleWsStart, but the gesture had already been started.");this.setStartWorkspace_(e),this.mostRecentEvent_=t,this.doStart(t)},I.Gesture.prototype.fireWorkspaceClick_=function(t){I.Events.fire(new(I.Events.get(I.Events.CLICK))(null,t.id,"workspace"))},I.Gesture.prototype.handleFlyoutStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleFlyoutStart, but the gesture had already been started.");this.setStartFlyout_(e),this.handleWsStart(t,e.getWorkspace())},I.Gesture.prototype.handleBlockStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleBlockStart, but the gesture had already been started.");this.setStartBlock(e),this.mostRecentEvent_=t},I.Gesture.prototype.handleBubbleStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleBubbleStart, but the gesture had already been started.");this.setStartBubble(e),this.mostRecentEvent_=t},I.Gesture.prototype.doBubbleClick_=function(){this.startBubble_.setFocus&&this.startBubble_.setFocus(),this.startBubble_.select&&this.startBubble_.select()},I.Gesture.prototype.doFieldClick_=function(){this.startField_.showEditor(this.mostRecentEvent_),this.bringBlockToFront_()},I.Gesture.prototype.doBlockClick_=function(){var t;this.flyout_&&this.flyout_.autoClose?this.targetBlock_.isEnabled()&&(I.Events.getGroup()||I.Events.setGroup(!0),this.flyout_.createBlock(this.targetBlock_).scheduleSnapAndBump()):(t=new(I.Events.get(I.Events.CLICK))(this.startBlock_,this.startWorkspace_.id,"block"),I.Events.fire(t)),this.bringBlockToFront_(),I.Events.setGroup(!1)},I.Gesture.prototype.doWorkspaceClick_=function(t){t=this.creatorWorkspace_,I.selected&&I.selected.unselect(),this.fireWorkspaceClick_(this.startWorkspace_||t)},I.Gesture.prototype.bringBlockToFront_=function(){this.targetBlock_&&!this.flyout_&&this.targetBlock_.bringToFront()},I.Gesture.prototype.setStartField=function(t){if(this.hasStarted_)throw Error("Tried to call gesture.setStartField, but the gesture had already been started.");this.startField_||(this.startField_=t)},I.Gesture.prototype.setStartBubble=function(t){this.startBubble_||(this.startBubble_=t)},I.Gesture.prototype.setStartBlock=function(t){this.startBlock_||this.startBubble_||((this.startBlock_=t).isInFlyout&&t!=t.getRootBlock()?this.setTargetBlock_(t.getRootBlock()):this.setTargetBlock_(t))},I.Gesture.prototype.setTargetBlock_=function(t){t.isShadow()?this.setTargetBlock_(t.getParent()):this.targetBlock_=t},I.Gesture.prototype.setStartWorkspace_=function(t){this.startWorkspace_||(this.startWorkspace_=t)},I.Gesture.prototype.setStartFlyout_=function(t){this.flyout_||(this.flyout_=t)},I.Gesture.prototype.isBubbleClick_=function(){return!!this.startBubble_&&!this.hasExceededDragRadius_},I.Gesture.prototype.isBlockClick_=function(){return!!this.startBlock_&&!this.hasExceededDragRadius_&&!this.isFieldClick_()},I.Gesture.prototype.isFieldClick_=function(){return!!this.startField_&&this.startField_.isClickable()&&!this.hasExceededDragRadius_&&(!this.flyout_||!this.flyout_.autoClose)},I.Gesture.prototype.isWorkspaceClick_=function(){return!(this.startBlock_||this.startBubble_||this.startField_||this.hasExceededDragRadius_)},I.Gesture.prototype.isDragging=function(){return this.isDraggingWorkspace_||this.isDraggingBlock_||this.isDraggingBubble_},I.Gesture.prototype.hasStarted=function(){return this.hasStarted_},I.Gesture.prototype.getInsertionMarkers=function(){return this.blockDragger_?this.blockDragger_.getInsertionMarkers():[]},I.Gesture.inProgress=function(){for(var t=I.Workspace.getAll(),e=0,o;o=t[e];e++)if(o.currentGesture_)return!0;return!1},I.Field=function(t,e,o){this.value_=this.DEFAULT_VALUE,this.tooltip_=this.validator_=null,this.size_=new I.utils.Size(0,0),this.constants_=this.mouseDownWrapper_=this.textContent_=this.textElement_=this.borderRect_=this.fieldGroup_=this.markerSvg_=this.cursorSvg_=null,o&&this.configure_(o),this.setValue(t),e&&this.setValidator(e)},I.Field.prototype.DEFAULT_VALUE=null,I.Field.prototype.name=void 0,I.Field.prototype.disposed=!1,I.Field.prototype.maxDisplayLength=50,I.Field.prototype.sourceBlock_=null,I.Field.prototype.isDirty_=!0,I.Field.prototype.visible_=!0,I.Field.prototype.clickTarget_=null,I.Field.NBSP=" ",I.Field.prototype.EDITABLE=!0,I.Field.prototype.SERIALIZABLE=!1,I.Field.prototype.configure_=function(t){var e=t.tooltip;(e="string"==typeof e?I.utils.replaceMessageReferences(t.tooltip):e)&&this.setTooltip(e)},I.Field.prototype.setSourceBlock=function(t){if(this.sourceBlock_)throw Error("Field already bound to a block.");this.sourceBlock_=t},I.Field.prototype.getConstants=function(){return!this.constants_&&this.sourceBlock_&&this.sourceBlock_.workspace&&this.sourceBlock_.workspace.rendered&&(this.constants_=this.sourceBlock_.workspace.getRenderer().getConstants()),this.constants_},I.Field.prototype.getSourceBlock=function(){return this.sourceBlock_},I.Field.prototype.init=function(){this.fieldGroup_||(this.fieldGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},null),this.isVisible()||(this.fieldGroup_.style.display="none"),this.sourceBlock_.getSvgRoot().appendChild(this.fieldGroup_),this.initView(),this.updateEditable(),this.setTooltip(this.tooltip_),this.bindEvents_(),this.initModel())},I.Field.prototype.initView=function(){this.createBorderRect_(),this.createTextElement_()},I.Field.prototype.initModel=function(){},I.Field.prototype.createBorderRect_=function(){this.borderRect_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{rx:this.getConstants().FIELD_BORDER_RECT_RADIUS,ry:this.getConstants().FIELD_BORDER_RECT_RADIUS,x:0,y:0,height:this.size_.height,width:this.size_.width,class:"blocklyFieldRect"},this.fieldGroup_)},I.Field.prototype.createTextElement_=function(){this.textElement_=I.utils.dom.createSvgElement(I.utils.Svg.TEXT,{class:"blocklyText"},this.fieldGroup_),this.getConstants().FIELD_TEXT_BASELINE_CENTER&&this.textElement_.setAttribute("dominant-baseline","central"),this.textContent_=document.createTextNode(""),this.textElement_.appendChild(this.textContent_)},I.Field.prototype.bindEvents_=function(){I.Tooltip.bindMouseEvents(this.getClickTarget_()),this.mouseDownWrapper_=I.browserEvents.conditionalBind(this.getClickTarget_(),"mousedown",this,this.onMouseDown_)},I.Field.prototype.fromXml=function(t){this.setValue(t.textContent)},I.Field.prototype.toXml=function(t){return t.textContent=this.getValue(),t},I.Field.prototype.dispose=function(){I.DropDownDiv.hideIfOwner(this),I.WidgetDiv.hideIfOwner(this),I.Tooltip.unbindMouseEvents(this.getClickTarget_()),this.mouseDownWrapper_&&I.browserEvents.unbind(this.mouseDownWrapper_),I.utils.dom.removeNode(this.fieldGroup_),this.disposed=!0},I.Field.prototype.updateEditable=function(){var t=this.fieldGroup_;this.EDITABLE&&t&&(this.sourceBlock_.isEditable()?(I.utils.dom.addClass(t,"blocklyEditableText"),I.utils.dom.removeClass(t,"blocklyNonEditableText"),t.style.cursor=this.CURSOR):(I.utils.dom.addClass(t,"blocklyNonEditableText"),I.utils.dom.removeClass(t,"blocklyEditableText"),t.style.cursor=""))},I.Field.prototype.isClickable=function(){return!!this.sourceBlock_&&this.sourceBlock_.isEditable()&&!!this.showEditor_&&"function"==typeof this.showEditor_},I.Field.prototype.isCurrentlyEditable=function(){return this.EDITABLE&&!!this.sourceBlock_&&this.sourceBlock_.isEditable()},I.Field.prototype.isSerializable=function(){var t=!1;return this.name&&(this.SERIALIZABLE?t=!0:this.EDITABLE&&(console.warn("Detected an editable field that was not serializable. Please define SERIALIZABLE property as true on all editable custom fields. Proceeding with serialization."),t=!0)),t},I.Field.prototype.isVisible=function(){return this.visible_},I.Field.prototype.setVisible=function(t){var e;this.visible_!=t&&(this.visible_=t,(e=this.getSvgRoot())&&(e.style.display=t?"block":"none"))},I.Field.prototype.setValidator=function(t){this.validator_=t},I.Field.prototype.getValidator=function(){return this.validator_},I.Field.prototype.getSvgRoot=function(){return this.fieldGroup_},I.Field.prototype.applyColour=function(){},I.Field.prototype.render_=function(){this.textContent_&&(this.textContent_.nodeValue=this.getDisplayText_()),this.updateSize_()},I.Field.prototype.showEditor=function(t){this.isClickable()&&this.showEditor_(t)},I.Field.prototype.updateSize_=function(t){var e=this.getConstants(),o=2*(t=null!=t?t:this.borderRect_?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0),i=e.FIELD_TEXT_HEIGHT,s=0;this.textElement_&&(o+=s=I.utils.dom.getFastTextWidth(this.textElement_,e.FIELD_TEXT_FONTSIZE,e.FIELD_TEXT_FONTWEIGHT,e.FIELD_TEXT_FONTFAMILY)),this.borderRect_&&(i=Math.max(i,e.FIELD_BORDER_RECT_HEIGHT)),this.size_.height=i,this.size_.width=o,this.positionTextElement_(t,s),this.positionBorderRect_()},I.Field.prototype.positionTextElement_=function(t,e){var o,i;this.textElement_&&(o=this.getConstants(),i=this.size_.height/2,this.textElement_.setAttribute("x",this.sourceBlock_.RTL?this.size_.width-e-t:t),this.textElement_.setAttribute("y",o.FIELD_TEXT_BASELINE_CENTER?i:i-o.FIELD_TEXT_HEIGHT/2+o.FIELD_TEXT_BASELINE))},I.Field.prototype.positionBorderRect_=function(){this.borderRect_&&(this.borderRect_.setAttribute("width",this.size_.width),this.borderRect_.setAttribute("height",this.size_.height),this.borderRect_.setAttribute("rx",this.getConstants().FIELD_BORDER_RECT_RADIUS),this.borderRect_.setAttribute("ry",this.getConstants().FIELD_BORDER_RECT_RADIUS))},I.Field.prototype.getSize=function(){if(!this.isVisible())return new I.utils.Size(0,0);return this.isDirty_?(this.render_(),this.isDirty_=!1):this.visible_&&0==this.size_.width&&(console.warn("Deprecated use of setting size_.width to 0 to rerender a field. Set field.isDirty_ to true instead."),this.render_()),this.size_},I.Field.prototype.getScaledBBox=function(){var t,e,o,i,t;return this.borderRect_?(t=this.borderRect_.getBoundingClientRect(),o=I.utils.style.getPageOffset(this.borderRect_),i=t.width,t=t.height):(t=this.sourceBlock_.getHeightWidth(),e=this.sourceBlock_.workspace.scale,o=this.getAbsoluteXY_(),i=t.width*e,t=t.height*e,I.utils.userAgent.GECKO?(o.x+=1.5*e,o.y+=1.5*e):I.utils.userAgent.EDGE||I.utils.userAgent.IE||(o.x-=.5*e,o.y-=.5*e),i+=1*e,t+=1*e),new I.utils.Rect(o.y,o.y+t,o.x,o.x+i)},I.Field.prototype.getDisplayText_=function(){var t=this.getText();if(!t)return I.Field.NBSP;return t=(t=t.length>this.maxDisplayLength?t.substring(0,this.maxDisplayLength-2)+"…":t).replace(/\s/g,I.Field.NBSP),this.sourceBlock_&&this.sourceBlock_.RTL&&(t+="‏"),t},I.Field.prototype.getText=function(){if(this.getText_){var t=this.getText_.call(this);if(null!==t)return String(t)}return String(this.getValue())},I.Field.prototype.markDirty=function(){this.isDirty_=!0,this.constants_=null},I.Field.prototype.forceRerender=function(){this.isDirty_=!0,this.sourceBlock_&&this.sourceBlock_.rendered&&(this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours(),this.updateMarkers_())},I.Field.prototype.setValue=function(t){if(null!==t){var e=this.doClassValidation_(t),o,e;if(!((t=this.processValidation_(t,e))instanceof Error)){if((e=this.getValidator())&&(e=e.call(this,t),(t=this.processValidation_(t,e))instanceof Error))return;(e=this.sourceBlock_)&&e.disposed||((o=this.getValue())===t?this.doValueUpdate_(t):(e&&I.Events.isEnabled()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(e,"field",this.name||null,o,t)),this.doValueUpdate_(t),this.isDirty_&&this.forceRerender()))}}},I.Field.prototype.processValidation_=function(t,e){if(null===e)return this.doValueInvalid_(t),this.isDirty_&&this.forceRerender(),Error();return t=void 0!==e?e:t},I.Field.prototype.getValue=function(){return this.value_},I.Field.prototype.doClassValidation_=function(t){return null==t?null:t},I.Field.prototype.doValueUpdate_=function(t){this.value_=t,this.isDirty_=!0},I.Field.prototype.doValueInvalid_=function(t){},I.Field.prototype.onMouseDown_=function(t){this.sourceBlock_&&this.sourceBlock_.workspace&&(t=this.sourceBlock_.workspace.getGesture(t))&&t.setStartField(this)},I.Field.prototype.setTooltip=function(t){t||""===t||(t=this.sourceBlock_);var e=this.getClickTarget_();e?e.tooltip=t:this.tooltip_=t},I.Field.prototype.getTooltip=function(){var t=this.getClickTarget_();return t?I.Tooltip.getTooltipOfObject(t):I.Tooltip.getTooltipOfObject({tooltip:this.tooltip_})},I.Field.prototype.getClickTarget_=function(){return this.clickTarget_||this.getSvgRoot()},I.Field.prototype.getAbsoluteXY_=function(){return I.utils.style.getPageOffset(this.getClickTarget_())},I.Field.prototype.referencesVariables=function(){return!1},I.Field.prototype.getParentInput=function(){for(var t=null,e=this.sourceBlock_,o=e.inputList,i=0;i<e.inputList.length;i++)for(var s=o[i],n=s.fieldRow,r=0;r<n.length;r++)if(n[r]===this){t=s;break}return t},I.Field.prototype.getFlipRtl=function(){return!1},I.Field.prototype.isTabNavigable=function(){return!1},I.Field.prototype.onShortcut=function(t){return!1},I.Field.prototype.setCursorSvg=function(t){t?(this.fieldGroup_.appendChild(t),this.cursorSvg_=t):this.cursorSvg_=null},I.Field.prototype.setMarkerSvg=function(t){t?(this.fieldGroup_.appendChild(t),this.markerSvg_=t):this.markerSvg_=null},I.Field.prototype.updateMarkers_=function(){var t=this.sourceBlock_.workspace;t.keyboardAccessibilityMode&&this.cursorSvg_&&t.getCursor().draw(),t.keyboardAccessibilityMode&&this.markerSvg_&&t.getMarker(I.MarkerManager.LOCAL_MARKER).draw()},I.FieldLabel=function(t,e,o){this.class_=null,I.FieldLabel.superClass_.constructor.call(this,t,null,o),o||(this.class_=e||null)},I.utils.object.inherits(I.FieldLabel,I.Field),I.FieldLabel.prototype.DEFAULT_VALUE="",I.FieldLabel.fromJson=function(t){var e=I.utils.replaceMessageReferences(t.text);return new I.FieldLabel(e,void 0,t)},I.FieldLabel.prototype.EDITABLE=!1,I.FieldLabel.prototype.configure_=function(t){I.FieldLabel.superClass_.configure_.call(this,t),this.class_=t["class"]},I.FieldLabel.prototype.initView=function(){this.createTextElement_(),this.class_&&I.utils.dom.addClass(this.textElement_,this.class_)},I.FieldLabel.prototype.doClassValidation_=function(t){return null==t?null:String(t)},I.FieldLabel.prototype.setClass=function(t){this.textElement_&&(this.class_&&I.utils.dom.removeClass(this.textElement_,this.class_),t&&I.utils.dom.addClass(this.textElement_,t)),this.class_=t},I.fieldRegistry.register("field_label",I.FieldLabel),I.Input=function(t,e,o,i){if(t!=I.inputTypes.DUMMY&&!e)throw Error("Value inputs and statement inputs must have non-empty name.");this.type=t,this.name=e,this.sourceBlock_=o,this.connection=i,this.fieldRow=[]},I.Input.prototype.align=I.constants.ALIGN.LEFT,I.Input.prototype.visible_=!0,I.Input.prototype.getSourceBlock=function(){return this.sourceBlock_},I.Input.prototype.appendField=function(t,e){return this.insertFieldAt(this.fieldRow.length,t,e),this},I.Input.prototype.insertFieldAt=function(t,e,o){if(t<0||t>this.fieldRow.length)throw Error("index "+t+" out of bounds.");if(!(e||""==e&&o))return t;return(e="string"==typeof e?I.fieldRegistry.fromJson({type:"field_label",text:e}):e).setSourceBlock(this.sourceBlock_),this.sourceBlock_.rendered&&(e.init(),e.applyColour()),e.name=o,e.setVisible(this.isVisible()),e.prefixField&&(t=this.insertFieldAt(t,e.prefixField)),this.fieldRow.splice(t,0,e),++t,e.suffixField&&(t=this.insertFieldAt(t,e.suffixField)),this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours()),t},I.Input.prototype.removeField=function(t,e){for(var o=0,i;i=this.fieldRow[o];o++)if(i.name===t)return i.dispose(),this.fieldRow.splice(o,1),this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours()),!0;if(e)return!1;throw Error('Field "'+t+'" not found.')},I.Input.prototype.isVisible=function(){return this.visible_},I.Input.prototype.setVisible=function(t){var e=[];if(this.visible_==t)return e;this.visible_=t;for(var o=0,i;i=this.fieldRow[o];o++)i.setVisible(t);return this.connection&&(this.connection=this.connection,t?e=this.connection.startTrackingAll():this.connection.stopTrackingAll(),o=this.connection.targetBlock())&&(o.getSvgRoot().style.display=t?"block":"none"),e},I.Input.prototype.markDirty=function(){for(var t=0,e;e=this.fieldRow[t];t++)e.markDirty()},I.Input.prototype.setCheck=function(t){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.setCheck(t),this},I.Input.prototype.setAlign=function(t){return this.align=t,this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render()),this},I.Input.prototype.setShadowDom=function(t){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.setShadowDom(t),this},I.Input.prototype.getShadowDom=function(){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.getShadowDom()},I.Input.prototype.init=function(){if(this.sourceBlock_.workspace.rendered)for(var t=0;t<this.fieldRow.length;t++)this.fieldRow[t].init()},I.Input.prototype.dispose=function(){for(var t=0,e;e=this.fieldRow[t];t++)e.dispose();this.connection&&this.connection.dispose(),this.sourceBlock_=null},I.Block=function(t,e,o){if(I.Generator&&void 0!==I.Generator.prototype[e])throw Error('Block prototypeName "'+e+'" conflicts with Blockly.Generator members.');if(this.id=o&&!t.getBlockById(o)?o:I.utils.genUid(),t.setBlockById(this.id,this),this.previousConnection=this.nextConnection=this.outputConnection=null,this.inputList=[],this.inputsInline=void 0,this.disabled=!1,this.tooltip="",this.contextMenu=!0,this.parentBlock_=null,this.childBlocks_=[],this.editable_=this.movable_=this.deletable_=!0,this.collapsed_=this.isShadow_=!1,this.comment=this.outputShape_=null,this.commentModel={text:null,pinned:!1,size:new I.utils.Size(160,80)},this.xy_=new I.utils.Coordinate(0,0),this.workspace=t,this.isInFlyout=t.isFlyout,this.isInMutator=t.isMutator,this.RTL=t.RTL,this.isInsertionMarker_=!1,this.hat=void 0,this.rendered=null,this.statementInputCount=0,e){if(this.type=e,!(o=I.Blocks[e])||"object"!=typeof o)throw TypeError("Unknown block type: "+e);I.utils.object.mixin(this,o)}t.addTopBlock(this),t.addTypedBlock(this),(t=I.Events.getGroup())||I.Events.setGroup(!0),e=I.Events.recordUndo;try{"function"==typeof this.init&&(I.Events.recordUndo=!1,this.init(),I.Events.recordUndo=e),I.Events.isEnabled()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CREATE))(this))}finally{t||I.Events.setGroup(!1),I.Events.recordUndo=e}this.inputsInlineDefault=this.inputsInline,"function"==typeof this.onchange&&this.setOnChange(this.onchange)},I.Block.COLLAPSED_INPUT_NAME=I.constants.COLLAPSED_INPUT_NAME,I.Block.COLLAPSED_FIELD_NAME=I.constants.COLLAPSED_FIELD_NAME,I.Block.prototype.data=null,I.Block.prototype.disposed=!1,I.Block.prototype.hue_=null,I.Block.prototype.colour_="#000000",I.Block.prototype.styleName_=null,I.Block.prototype.dispose=function(t){if(this.workspace){this.onchangeWrapper_&&this.workspace.removeChangeListener(this.onchangeWrapper_),this.unplug(t),I.Events.isEnabled()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_DELETE))(this)),I.Events.disable();try{this.workspace&&(this.workspace.removeTopBlock(this),this.workspace.removeTypedBlock(this),this.workspace.removeBlockById(this.id),this.workspace=null),I.selected==this&&(I.selected=null);for(var e=this.childBlocks_.length-1,o;0<=e;e--)this.childBlocks_[e].dispose(!1);for(e=0;o=this.inputList[e];e++)o.dispose();this.inputList.length=0;for(var i=this.getConnections_(!0),e=0,s;s=i[e];e++)s.dispose()}finally{I.Events.enable(),this.disposed=!0}}},I.Block.prototype.initModel=function(){for(var t=0,e;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.initModel&&i.initModel()},I.Block.prototype.unplug=function(t){this.outputConnection?this.unplugFromRow_(t):this.previousConnection&&this.unplugFromStack_(t)},I.Block.prototype.unplugFromRow_=function(t){var e=null;this.outputConnection.isConnected()&&(e=this.outputConnection.targetConnection,this.outputConnection.disconnect()),e&&t&&(t=this.getOnlyValueConnection_())&&t.isConnected()&&!t.targetBlock().isShadow()&&((t=t.targetConnection).disconnect(),this.workspace.connectionChecker.canConnect(t,e,!1)?e.connect(t):t.onFailedConnect(e))},I.Block.prototype.getOnlyValueConnection_=function(){for(var t=null,e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;if(o&&o.type==I.connectionTypes.INPUT_VALUE&&o.targetConnection){if(t)return null;t=o}}return t},I.Block.prototype.unplugFromStack_=function(t){var e=null;this.previousConnection.isConnected()&&(e=this.previousConnection.targetConnection,this.previousConnection.disconnect());var o=this.getNextBlock();t&&o&&!o.isShadow()&&((t=this.nextConnection.targetConnection).disconnect(),e&&this.workspace.connectionChecker.canConnect(e,t,!1)&&e.connect(t))},I.Block.prototype.getConnections_=function(t){t=[],this.outputConnection&&t.push(this.outputConnection),this.previousConnection&&t.push(this.previousConnection),this.nextConnection&&t.push(this.nextConnection);for(var e=0,o;o=this.inputList[e];e++)o.connection&&t.push(o.connection);return t},I.Block.prototype.lastConnectionInStack=function(){for(var t=this.nextConnection;t;){var e=t.targetBlock();if(!e)return t;t=e.nextConnection}return null},I.Block.prototype.bumpNeighbours=function(){},I.Block.prototype.getParent=function(){return this.parentBlock_},I.Block.prototype.getInputWithBlock=function(t){for(var e=0,o;o=this.inputList[e];e++)if(o.connection&&o.connection.targetBlock()==t)return o;return null},I.Block.prototype.getSurroundParent=function(){var t=this;do{var e=t,t;if(!(t=t.getParent()))return null}while(t.getNextBlock()==e);return t},I.Block.prototype.getNextBlock=function(){return this.nextConnection&&this.nextConnection.targetBlock()},I.Block.prototype.getPreviousBlock=function(){return this.previousConnection&&this.previousConnection.targetBlock()},I.Block.prototype.getFirstStatementConnection=function(){for(var t=0,e;e=this.inputList[t];t++)if(e.connection&&e.connection.type==I.connectionTypes.NEXT_STATEMENT)return e.connection;return null},I.Block.prototype.getRootBlock=function(){var t=this;do{var e=t,t=e.parentBlock_}while(t);return e},I.Block.prototype.getTopStackBlock=function(){var t=this;do{var e=t.getPreviousBlock()}while(e&&e.getNextBlock()==t&&(t=e));return t},I.Block.prototype.getChildren=function(t){if(!t)return this.childBlocks_;t=[];for(var e=0,o;o=this.inputList[e];e++)o.connection&&(o=o.connection.targetBlock())&&t.push(o);return(e=this.getNextBlock())&&t.push(e),t},I.Block.prototype.setParent=function(t){if(t!=this.parentBlock_){if(this.parentBlock_){if(I.utils.arrayRemove(this.parentBlock_.childBlocks_,this),this.previousConnection&&this.previousConnection.isConnected())throw Error("Still connected to previous block.");if(this.outputConnection&&this.outputConnection.isConnected())throw Error("Still connected to parent block.");this.parentBlock_=null}else this.workspace.removeTopBlock(this);(this.parentBlock_=t)?t.childBlocks_.push(this):this.workspace.addTopBlock(this)}},I.Block.prototype.getDescendants=function(t){for(var e=[this],o=this.getChildren(t),i,s=0;i=o[s];s++)e.push.apply(e,i.getDescendants(t));return e},I.Block.prototype.isDeletable=function(){return this.deletable_&&!this.isShadow_&&!(this.workspace&&this.workspace.options.readOnly)},I.Block.prototype.setDeletable=function(t){this.deletable_=t},I.Block.prototype.isMovable=function(){return this.movable_&&!this.isShadow_&&!(this.workspace&&this.workspace.options.readOnly)},I.Block.prototype.setMovable=function(t){this.movable_=t},I.Block.prototype.isDuplicatable=function(){return!this.workspace.hasBlockLimits()||this.workspace.isCapacityAvailable(I.utils.getBlockTypeCounts(this,!0))},I.Block.prototype.isShadow=function(){return this.isShadow_},I.Block.prototype.setShadow=function(t){this.isShadow_=t},I.Block.prototype.isInsertionMarker=function(){return this.isInsertionMarker_},I.Block.prototype.setInsertionMarker=function(t){this.isInsertionMarker_=t},I.Block.prototype.isEditable=function(){return this.editable_&&!(this.workspace&&this.workspace.options.readOnly)},I.Block.prototype.setEditable=function(t){this.editable_=t,t=0;for(var e;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.updateEditable()},I.Block.prototype.isDisposed=function(){return this.disposed},I.Block.prototype.getMatchingConnection=function(t,e){var o=this.getConnections_(!0);if(t=t.getConnections_(!0),o.length!=t.length)throw Error("Connection lists did not match in length.");for(var i=0;i<t.length;i++)if(t[i]==e)return o[i];return null},I.Block.prototype.setHelpUrl=function(t){this.helpUrl=t},I.Block.prototype.setTooltip=function(t){this.tooltip=t},I.Block.prototype.getTooltip=function(){return I.Tooltip.getTooltipOfObject(this)},I.Block.prototype.getColour=function(){return this.colour_},I.Block.prototype.getStyleName=function(){return this.styleName_},I.Block.prototype.getHue=function(){return this.hue_},I.Block.prototype.setColour=function(t){t=I.utils.parseBlockColour(t),this.hue_=t.hue,this.colour_=t.hex},I.Block.prototype.setStyle=function(t){this.styleName_=t},I.Block.prototype.setOnChange=function(t){if(t&&"function"!=typeof t)throw Error("onchange must be a function.");this.onchangeWrapper_&&this.workspace.removeChangeListener(this.onchangeWrapper_),(this.onchange=t)&&(this.onchangeWrapper_=t.bind(this),this.workspace.addChangeListener(this.onchangeWrapper_))},I.Block.prototype.getField=function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)if(s.name==t)return s;return null},I.Block.prototype.getVars=function(){for(var t=[],e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&t.push(s.getValue());return t},I.Block.prototype.getVarModels=function(){for(var t=[],e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&(s=this.workspace.getVariableById(s.getValue()))&&t.push(s);return t},I.Block.prototype.updateVarName=function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&t.getId()==s.getValue()&&s.refreshVariableName()},I.Block.prototype.renameVarById=function(t,e){for(var o=0,i;i=this.inputList[o];o++)for(var s=0,n;n=i.fieldRow[s];s++)n.referencesVariables()&&t==n.getValue()&&n.setValue(e)},I.Block.prototype.getFieldValue=function(t){return(t=this.getField(t))?t.getValue():null},I.Block.prototype.setFieldValue=function(t,e){var o=this.getField(e);if(!o)throw Error('Field "'+e+'" not found.');o.setValue(t)},I.Block.prototype.setPreviousStatement=function(t,e){if(t){if(void 0===e&&(e=null),!this.previousConnection){if(this.outputConnection)throw Error("Remove output connection prior to adding previous connection.");this.previousConnection=this.makeConnection_(I.connectionTypes.PREVIOUS_STATEMENT)}this.previousConnection.setCheck(e)}else if(this.previousConnection){if(this.previousConnection.isConnected())throw Error("Must disconnect previous statement before removing connection.");this.previousConnection.dispose(),this.previousConnection=null}},I.Block.prototype.setNextStatement=function(t,e){if(t)void 0===e&&(e=null),this.nextConnection||(this.nextConnection=this.makeConnection_(I.connectionTypes.NEXT_STATEMENT)),this.nextConnection.setCheck(e);else if(this.nextConnection){if(this.nextConnection.isConnected())throw Error("Must disconnect next statement before removing connection.");this.nextConnection.dispose(),this.nextConnection=null}},I.Block.prototype.setOutput=function(t,e){if(t){if(void 0===e&&(e=null),!this.outputConnection){if(this.previousConnection)throw Error("Remove previous connection prior to adding output connection.");this.outputConnection=this.makeConnection_(I.connectionTypes.OUTPUT_VALUE)}this.outputConnection.setCheck(e)}else if(this.outputConnection){if(this.outputConnection.isConnected())throw Error("Must disconnect output value before removing connection.");this.outputConnection.dispose(),this.outputConnection=null}},I.Block.prototype.setInputsInline=function(t){this.inputsInline!=t&&(I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this,"inline",null,this.inputsInline,t)),this.inputsInline=t)},I.Block.prototype.getInputsInline=function(){if(null!=this.inputsInline)return this.inputsInline;for(var t=1;t<this.inputList.length;t++)if(this.inputList[t-1].type==I.inputTypes.DUMMY&&this.inputList[t].type==I.inputTypes.DUMMY)return!1;for(t=1;t<this.inputList.length;t++)if(this.inputList[t-1].type==I.inputTypes.VALUE&&this.inputList[t].type==I.inputTypes.DUMMY)return!0;return!1},I.Block.prototype.setOutputShape=function(t){this.outputShape_=t},I.Block.prototype.getOutputShape=function(){return this.outputShape_},I.Block.prototype.isEnabled=function(){return!this.disabled},I.Block.prototype.setEnabled=function(t){this.isEnabled()!=t&&(I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this,"disabled",null,this.disabled,!t)),this.disabled=!t)},I.Block.prototype.getInheritedDisabled=function(){for(var t=this.getSurroundParent();t;){if(t.disabled)return!0;t=t.getSurroundParent()}return!1},I.Block.prototype.isCollapsed=function(){return this.collapsed_},I.Block.prototype.setCollapsed=function(t){this.collapsed_!=t&&(I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this,"collapsed",null,this.collapsed_,t)),this.collapsed_=t)},I.Block.prototype.toString=function(t,e){function o(t){var e=t.getCheck();return(e=!e&&t.targetConnection?t.targetConnection.getCheck():e)&&(-1!=e.indexOf("Boolean")||-1!=e.indexOf("Number"))}function i(){r&&r.getType()==l.getType()&&r.getLocation()==l.getLocation()&&(r=null)}var s=[];e=e||"?";var n=I.ASTNode.NAVIGATE_ALL_FIELDS;I.ASTNode.NAVIGATE_ALL_FIELDS=!0;for(var r=I.ASTNode.createBlockNode(this),l=r;r;){switch(r.getType()){case I.ASTNode.types.INPUT:var a=r.getLocation();r.in()?o(a)&&s.push("("):s.push(e);break;case I.ASTNode.types.FIELD:(a=r.getLocation()).name!=I.constants.COLLAPSED_FIELD_NAME&&s.push(a.getText())}if(!(r=(a=r).in()||a.next())){for(r=a.out(),i();r&&!r.next();)r=r.out(),i(),r&&r.getType()==I.ASTNode.types.INPUT&&o(r.getLocation())&&s.push(")");r=r&&r.next()}}for(I.ASTNode.NAVIGATE_ALL_FIELDS=n,e=2,n=s.length;e<n;e++)"("==s[e-2]&&")"==s[e]&&(s[e-2]=s[e-1],s.splice(e-1,2),n-=2);return s=s.join(" ").replace(/(\() | (\))/gim,"$1$2").trim()||"???",s=t&&s.length>t?s.substring(0,t-3)+"...":s},I.Block.prototype.appendValueInput=function(t){return this.appendInput_(I.inputTypes.VALUE,t)},I.Block.prototype.appendStatementInput=function(t){return this.appendInput_(I.inputTypes.STATEMENT,t)},I.Block.prototype.appendDummyInput=function(t){return this.appendInput_(I.inputTypes.DUMMY,t||"")},I.Block.prototype.jsonInit=function(t){var e=t.type?'Block "'+t.type+'": ':"";if(t.output&&t.previousStatement)throw Error(e+"Must not have both an output and a previousStatement.");if(t.style&&t.style.hat&&(this.hat=t.style.hat,t.style=null),t.style&&t.colour)throw Error(e+"Must not have both a colour and a style.");t.style?this.jsonInitStyle_(t,e):this.jsonInitColour_(t,e);for(var o=0;void 0!==t["message"+o];)this.interpolate_(t["message"+o],t["args"+o]||[],t["lastDummyAlign"+o],e),o++;if(void 0!==t.inputsInline&&this.setInputsInline(t.inputsInline),void 0!==t.output&&this.setOutput(!0,t.output),void 0!==t.outputShape&&this.setOutputShape(t.outputShape),void 0!==t.previousStatement&&this.setPreviousStatement(!0,t.previousStatement),void 0!==t.nextStatement&&this.setNextStatement(!0,t.nextStatement),void 0!==t.tooltip&&(o=t.tooltip,o=I.utils.replaceMessageReferences(o),this.setTooltip(o)),void 0!==t.enableContextMenu&&(o=t.enableContextMenu,this.contextMenu=!!o),void 0!==t.helpUrl&&(o=t.helpUrl,o=I.utils.replaceMessageReferences(o),this.setHelpUrl(o)),"string"==typeof t.extensions&&(console.warn(e+"JSON attribute 'extensions' should be an array of strings. Found raw string in JSON for '"+t.type+"' block."),t.extensions=[t.extensions]),void 0!==t.mutator&&I.Extensions.apply(t.mutator,this,!0),Array.isArray(t.extensions))for(t=t.extensions,e=0;e<t.length;++e)I.Extensions.apply(t[e],this,!1)},I.Block.prototype.jsonInitColour_=function(e,o){if("colour"in e)if(void 0===e.colour)console.warn(o+"Undefined colour value.");else{e=e.colour;try{this.setColour(e)}catch(t){console.warn(o+"Illegal colour value: ",e)}}},I.Block.prototype.jsonInitStyle_=function(e,o){e=e.style;try{this.setStyle(e)}catch(t){console.warn(o+"Style does not exist: ",e)}},I.Block.prototype.mixin=function(t,e){if(void 0!==e&&"boolean"!=typeof e)throw Error("opt_disableCheck must be a boolean if provided");if(!e){for(var o in e=[],t)void 0!==this[o]&&e.push(o);if(e.length)throw Error("Mixin will overwrite block members: "+JSON.stringify(e))}I.utils.object.mixin(this,t)},I.Block.prototype.interpolate_=function(t,e,o,i){t=I.utils.tokenizeInterpolation(t),this.validateTokens_(t,e.length),e=this.interpolateArguments_(t,e,o),o=[],t=0;for(var s;s=e[t];t++)if(this.isInputKeyword_(s.type)){if(s=this.inputFromJson_(s,i)){for(var n=0,r;r=o[n];n++)s.appendField(r[0],r[1]);o.length=0}}else(n=this.fieldFromJson_(s))&&o.push([n,s.name])},I.Block.prototype.validateTokens_=function(t,e){for(var o=[],i=0,s=0;s<t.length;s++){var n=t[s];if("number"==typeof n){if(n<1||e<n)throw Error('Block "'+this.type+'": Message index %'+n+" out of range.");if(o[n])throw Error('Block "'+this.type+'": Message index %'+n+" duplicated.");o[n]=!0,i++}}if(i!=e)throw Error('Block "'+this.type+'": Message does not reference all '+e+" arg(s).")},I.Block.prototype.interpolateArguments_=function(t,e,o){for(var i=[],s=0;s<t.length;s++){var n=t[s];if("string"==typeof(n="number"==typeof n?e[n-1]:n)&&!(n=this.stringToFieldJson_(n)))continue;i.push(n)}return(t=i.length)&&!this.isInputKeyword_(i[t-1].type)&&(t={type:"input_dummy"},o&&(t.align=o),i.push(t)),i},I.Block.prototype.fieldFromJson_=function(t){var e=I.fieldRegistry.fromJson(t);return!e&&t.alt?"string"==typeof t.alt?(t=this.stringToFieldJson_(t.alt))?this.fieldFromJson_(t):null:this.fieldFromJson_(t.alt):e},I.Block.prototype.inputFromJson_=function(t,e){var o={LEFT:I.constants.ALIGN.LEFT,RIGHT:I.constants.ALIGN.RIGHT,CENTRE:I.constants.ALIGN.CENTRE,CENTER:I.constants.ALIGN.CENTRE},i=null;switch(t.type){case"input_value":i=this.appendValueInput(t.name);break;case"input_statement":i=this.appendStatementInput(t.name);break;case"input_dummy":i=this.appendDummyInput(t.name)}if(!i)return null;return t.check&&i.setCheck(t.check),t.align&&(void 0===(o=o[t.align.toUpperCase()])?console.warn(e+"Illegal align value: ",t.align):i.setAlign(o)),i},I.Block.prototype.isInputKeyword_=function(t){return"input_value"==t||"input_statement"==t||"input_dummy"==t},I.Block.prototype.stringToFieldJson_=function(t){return(t=t.trim())?{type:"field_label",text:t}:null},I.Block.prototype.appendInput_=function(t,e){var o=null;return t!=I.inputTypes.VALUE&&t!=I.inputTypes.STATEMENT||(o=this.makeConnection_(t)),t==I.inputTypes.STATEMENT&&this.statementInputCount++,t=new I.Input(t,e,this,o),this.inputList.push(t),t},I.Block.prototype.moveInputBefore=function(t,e){if(t!=e){for(var o=-1,i=e?-1:this.inputList.length,s=0,n;n=this.inputList[s];s++)if(n.name==t){if(o=s,-1!=i)break}else if(e&&n.name==e&&(i=s,-1!=o))break;if(-1==o)throw Error('Named input "'+t+'" not found.');if(-1==i)throw Error('Reference input "'+e+'" not found.');this.moveNumberedInputBefore(o,i)}},I.Block.prototype.moveNumberedInputBefore=function(t,e){if(t==e)throw Error("Can't move input to itself.");if(t>=this.inputList.length)throw RangeError("Input index "+t+" out of bounds.");if(e>this.inputList.length)throw RangeError("Reference input "+e+" out of bounds.");var o=this.inputList[t];this.inputList.splice(t,1),t<e&&e--,this.inputList.splice(e,0,o)},I.Block.prototype.removeInput=function(t,e){for(var o=0,i;i=this.inputList[o];o++)if(i.name==t)return i.type==I.inputTypes.STATEMENT&&this.statementInputCount--,i.dispose(),this.inputList.splice(o,1),!0;if(e)return!1;throw Error("Input not found: "+t)},I.Block.prototype.getInput=function(t){for(var e=0,o;o=this.inputList[e];e++)if(o.name==t)return o;return null},I.Block.prototype.getInputTargetBlock=function(t){return(t=this.getInput(t))&&t.connection&&t.connection.targetBlock()},I.Block.prototype.getCommentText=function(){return this.commentModel.text},I.Block.prototype.setCommentText=function(t){this.commentModel.text!=t&&(I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this,"comment",null,this.commentModel.text,t)),this.comment=this.commentModel.text=t)},I.Block.prototype.setWarningText=function(t,e){},I.Block.prototype.setMutator=function(t){},I.Block.prototype.getRelativeToSurfaceXY=function(){return this.xy_},I.Block.prototype.moveBy=function(t,e){if(this.parentBlock_)throw Error("Block has parent.");var o=new(I.Events.get(I.Events.BLOCK_MOVE))(this);this.xy_.translate(t,e),o.recordNew(),I.Events.fire(o)},I.Block.prototype.makeConnection_=function(t){return new I.Connection(this,t)},I.Block.prototype.allInputsFilled=function(t){if(!(t=void 0===t?!0:t)&&this.isShadow())return!1;for(var e=0,o;o=this.inputList[e];e++)if(o.connection&&(!(o=o.connection.targetBlock())||!o.allInputsFilled(t)))return!1;return!(e=this.getNextBlock())||e.allInputsFilled(t)},I.Block.prototype.toDevString=function(){var t=this.type?'"'+this.type+'" block':"Block";return this.id&&(t+=' (id="'+this.id+'")'),t},I.blockRendering.IPathObject=function(t,e){},I.utils.KeyCodes={WIN_KEY_FF_LINUX:0,MAC_ENTER:3,BACKSPACE:8,TAB:9,NUM_CENTER:12,ENTER:13,SHIFT:16,CTRL:17,ALT:18,PAUSE:19,CAPS_LOCK:20,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,PLUS_SIGN:43,PRINT_SCREEN:44,INSERT:45,DELETE:46,ZERO:48,ONE:49,TWO:50,THREE:51,FOUR:52,FIVE:53,SIX:54,SEVEN:55,EIGHT:56,NINE:57,FF_SEMICOLON:59,FF_EQUALS:61,FF_DASH:173,FF_HASH:163,QUESTION_MARK:63,AT_SIGN:64,A:65,B:66,C:67,D:68,E:69,F:70,G:71,H:72,I:73,J:74,K:75,L:76,M:77,N:78,O:79,P:80,Q:81,R:82,S:83,T:84,U:85,V:86,W:87,X:88,Y:89,Z:90,META:91,WIN_KEY_RIGHT:92,CONTEXT_MENU:93,NUM_ZERO:96,NUM_ONE:97,NUM_TWO:98,NUM_THREE:99,NUM_FOUR:100,NUM_FIVE:101,NUM_SIX:102,NUM_SEVEN:103,NUM_EIGHT:104,NUM_NINE:105,NUM_MULTIPLY:106,NUM_PLUS:107,NUM_MINUS:109,NUM_PERIOD:110,NUM_DIVISION:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUMLOCK:144,SCROLL_LOCK:145,FIRST_MEDIA_KEY:166,LAST_MEDIA_KEY:183,SEMICOLON:186,DASH:189,EQUALS:187,COMMA:188,PERIOD:190,SLASH:191,APOSTROPHE:192,TILDE:192,SINGLE_QUOTE:222,OPEN_SQUARE_BRACKET:219,BACKSLASH:220,CLOSE_SQUARE_BRACKET:221,WIN_KEY:224,MAC_FF_META:224,MAC_WK_CMD_LEFT:91,MAC_WK_CMD_RIGHT:93,WIN_IME:229,VK_NONAME:252,PHANTOM:255},I.Menu=function(){this.menuItems_=[],this.roleName_=this.element_=this.onKeyDownHandler_=this.mouseLeaveHandler_=this.mouseEnterHandler_=this.clickHandler_=this.mouseOverHandler_=this.highlightedItem_=this.openingCoords=null},I.Menu.prototype.addChild=function(t){this.menuItems_.push(t)},I.Menu.prototype.render=function(t){var e=document.createElement("div");e.className="blocklyMenu goog-menu blocklyNonSelectable",e.tabIndex=0,this.roleName_&&I.utils.aria.setRole(e,this.roleName_),this.element_=e;for(var o=0,i;i=this.menuItems_[o];o++)e.appendChild(i.createDom());this.mouseOverHandler_=I.browserEvents.conditionalBind(e,"mouseover",this,this.handleMouseOver_,!0),this.clickHandler_=I.browserEvents.conditionalBind(e,"click",this,this.handleClick_,!0),this.mouseEnterHandler_=I.browserEvents.conditionalBind(e,"mouseenter",this,this.handleMouseEnter_,!0),this.mouseLeaveHandler_=I.browserEvents.conditionalBind(e,"mouseleave",this,this.handleMouseLeave_,!0),this.onKeyDownHandler_=I.browserEvents.conditionalBind(e,"keydown",this,this.handleKeyEvent_),t.appendChild(e)},I.Menu.prototype.getElement=function(){return this.element_},I.Menu.prototype.focus=function(){var t=this.getElement();t&&(t.focus({preventScroll:!0}),I.utils.dom.addClass(t,"blocklyFocused"))},I.Menu.prototype.blur_=function(){var t=this.getElement();t&&(t.blur(),I.utils.dom.removeClass(t,"blocklyFocused"))},I.Menu.prototype.setRole=function(t){this.roleName_=t},I.Menu.prototype.dispose=function(){this.mouseOverHandler_&&(I.browserEvents.unbind(this.mouseOverHandler_),this.mouseOverHandler_=null),this.clickHandler_&&(I.browserEvents.unbind(this.clickHandler_),this.clickHandler_=null),this.mouseEnterHandler_&&(I.browserEvents.unbind(this.mouseEnterHandler_),this.mouseEnterHandler_=null),this.mouseLeaveHandler_&&(I.browserEvents.unbind(this.mouseLeaveHandler_),this.mouseLeaveHandler_=null),this.onKeyDownHandler_&&(I.browserEvents.unbind(this.onKeyDownHandler_),this.onKeyDownHandler_=null);for(var t=0,e;e=this.menuItems_[t];t++)e.dispose();this.element_=null},I.Menu.prototype.getMenuItem_=function(t){for(var e=this.getElement();t&&t!=e;){if(I.utils.dom.hasClass(t,"blocklyMenuItem"))for(var o=0,i;i=this.menuItems_[o];o++)if(i.getElement()==t)return i;t=t.parentElement}return null},I.Menu.prototype.setHighlighted=function(t){var e=this.highlightedItem_;e&&(e.setHighlighted(!1),this.highlightedItem_=null),t&&(t.setHighlighted(!0),this.highlightedItem_=t,e=this.getElement(),I.utils.style.scrollIntoContainerView(t.getElement(),e),I.utils.aria.setState(e,I.utils.aria.State.ACTIVEDESCENDANT,t.getId()))},I.Menu.prototype.highlightNext=function(){var t=this.menuItems_.indexOf(this.highlightedItem_);this.highlightHelper_(t,1)},I.Menu.prototype.highlightPrevious=function(){var t=this.menuItems_.indexOf(this.highlightedItem_);this.highlightHelper_(t<0?this.menuItems_.length:t,-1)},I.Menu.prototype.highlightFirst_=function(){this.highlightHelper_(-1,1)},I.Menu.prototype.highlightLast_=function(){this.highlightHelper_(this.menuItems_.length,-1)},I.Menu.prototype.highlightHelper_=function(t,e){t+=e;for(var o;o=this.menuItems_[t];){if(o.isEnabled()){this.setHighlighted(o);break}t+=e}},I.Menu.prototype.handleMouseOver_=function(t){(t=this.getMenuItem_(t.target))&&(t.isEnabled()?this.highlightedItem_!=t&&this.setHighlighted(t):this.setHighlighted(null))},I.Menu.prototype.handleClick_=function(t){var e=this.openingCoords;if(this.openingCoords=null,e&&"number"==typeof t.clientX){var o=new I.utils.Coordinate(t.clientX,t.clientY);if(I.utils.Coordinate.distance(e,o)<1)return}(t=this.getMenuItem_(t.target))&&t.performAction()},I.Menu.prototype.handleMouseEnter_=function(t){this.focus()},I.Menu.prototype.handleMouseLeave_=function(t){this.getElement()&&(this.blur_(),this.setHighlighted(null))},I.Menu.prototype.handleKeyEvent_=function(t){if(this.menuItems_.length&&!(t.shiftKey||t.ctrlKey||t.metaKey||t.altKey)){var e=this.highlightedItem_;switch(t.keyCode){case I.utils.KeyCodes.ENTER:case I.utils.KeyCodes.SPACE:e&&e.performAction();break;case I.utils.KeyCodes.UP:this.highlightPrevious();break;case I.utils.KeyCodes.DOWN:this.highlightNext();break;case I.utils.KeyCodes.PAGE_UP:case I.utils.KeyCodes.HOME:this.highlightFirst_();break;case I.utils.KeyCodes.PAGE_DOWN:case I.utils.KeyCodes.END:this.highlightLast_();break;default:return}t.preventDefault(),t.stopPropagation()}},I.Menu.prototype.getSize=function(){var t=this.getElement(),e=I.utils.style.getSize(t);return e.height=t.scrollHeight,e},I.MenuItem=function(t,e){this.content_=t,this.value_=e,this.enabled_=!0,this.element_=null,this.rightToLeft_=!1,this.roleName_=null,this.highlight_=this.checked_=this.checkable_=!1,this.actionHandler_=null},I.MenuItem.prototype.createDom=function(){var t=document.createElement("div");t.id=I.utils.IdGenerator.getNextUniqueId(),(this.element_=t).className="blocklyMenuItem goog-menuitem "+(this.enabled_?"":"blocklyMenuItemDisabled goog-menuitem-disabled ")+(this.checked_?"blocklyMenuItemSelected goog-option-selected ":"")+(this.highlight_?"blocklyMenuItemHighlight goog-menuitem-highlight ":"")+(this.rightToLeft_?"blocklyMenuItemRtl goog-menuitem-rtl ":"");var e=document.createElement("div"),o;return e.className="blocklyMenuItemContent goog-menuitem-content",this.checkable_&&((o=document.createElement("div")).className="blocklyMenuItemCheckbox goog-menuitem-checkbox",e.appendChild(o)),o=this.content_,"string"==typeof this.content_&&(o=document.createTextNode(this.content_)),e.appendChild(o),t.appendChild(e),this.roleName_&&I.utils.aria.setRole(t,this.roleName_),I.utils.aria.setState(t,I.utils.aria.State.SELECTED,this.checkable_&&this.checked_||!1),I.utils.aria.setState(t,I.utils.aria.State.DISABLED,!this.enabled_),t},I.MenuItem.prototype.dispose=function(){this.element_=null},I.MenuItem.prototype.getElement=function(){return this.element_},I.MenuItem.prototype.getId=function(){return this.element_.id},I.MenuItem.prototype.getValue=function(){return this.value_},I.MenuItem.prototype.setRightToLeft=function(t){this.rightToLeft_=t},I.MenuItem.prototype.setRole=function(t){this.roleName_=t},I.MenuItem.prototype.setCheckable=function(t){this.checkable_=t},I.MenuItem.prototype.setChecked=function(t){this.checked_=t},I.MenuItem.prototype.setHighlighted=function(t){this.highlight_=t;var e=this.getElement();e&&this.isEnabled()&&(t?(I.utils.dom.addClass(e,"blocklyMenuItemHighlight"),I.utils.dom.addClass(e,"goog-menuitem-highlight")):(I.utils.dom.removeClass(e,"blocklyMenuItemHighlight"),I.utils.dom.removeClass(e,"goog-menuitem-highlight")))},I.MenuItem.prototype.isEnabled=function(){return this.enabled_},I.MenuItem.prototype.setEnabled=function(t){this.enabled_=t},I.MenuItem.prototype.performAction=function(){this.isEnabled()&&this.actionHandler_&&this.actionHandler_(this)},I.MenuItem.prototype.onAction=function(t,e){this.actionHandler_=t.bind(e)},I.WidgetDiv={},I.WidgetDiv.owner_=null,I.WidgetDiv.dispose_=null,I.WidgetDiv.rendererClassName_="",I.WidgetDiv.themeClassName_="",I.WidgetDiv.createDom=function(){I.WidgetDiv.DIV||(I.WidgetDiv.DIV=document.createElement("div"),I.WidgetDiv.DIV.className="blocklyWidgetDiv",(I.parentContainer||document.body).appendChild(I.WidgetDiv.DIV))},I.WidgetDiv.show=function(t,e,o){I.WidgetDiv.hide(),I.WidgetDiv.owner_=t,I.WidgetDiv.dispose_=o,(t=I.WidgetDiv.DIV).style.direction=e?"rtl":"ltr",t.style.display="block",e=I.getMainWorkspace(),I.WidgetDiv.rendererClassName_=e.getRenderer().getClassName(),I.WidgetDiv.themeClassName_=e.getTheme().getClassName(),I.utils.dom.addClass(t,I.WidgetDiv.rendererClassName_),I.utils.dom.addClass(t,I.WidgetDiv.themeClassName_)},I.WidgetDiv.hide=function(){var t;I.WidgetDiv.isVisible()&&(I.WidgetDiv.owner_=null,(t=I.WidgetDiv.DIV).style.display="none",t.style.left="",t.style.top="",I.WidgetDiv.dispose_&&I.WidgetDiv.dispose_(),I.WidgetDiv.dispose_=null,t.textContent="",I.WidgetDiv.rendererClassName_&&(I.utils.dom.removeClass(t,I.WidgetDiv.rendererClassName_),I.WidgetDiv.rendererClassName_=""),I.WidgetDiv.themeClassName_&&(I.utils.dom.removeClass(t,I.WidgetDiv.themeClassName_),I.WidgetDiv.themeClassName_=""),I.getMainWorkspace().markFocused())},I.WidgetDiv.isVisible=function(){return!!I.WidgetDiv.owner_},I.WidgetDiv.hideIfOwner=function(t){I.WidgetDiv.owner_==t&&I.WidgetDiv.hide()},I.WidgetDiv.positionInternal_=function(t,e,o){I.WidgetDiv.DIV.style.left=t+"px",I.WidgetDiv.DIV.style.top=e+"px",I.WidgetDiv.DIV.style.height=o+"px"},I.WidgetDiv.positionWithAnchor=function(t,e,o,i){var s=I.WidgetDiv.calculateY_(t,e,o);t=I.WidgetDiv.calculateX_(t,e,o,i),s<0?I.WidgetDiv.positionInternal_(t,0,o.height+s):I.WidgetDiv.positionInternal_(t,s,o.height)},I.WidgetDiv.calculateX_=function(t,e,o,i){if(i)return e=Math.max(e.right-o.width,t.left),Math.min(e,t.right-o.width);return e=Math.min(e.left,t.right-o.width),Math.max(e,t.left)},I.WidgetDiv.calculateY_=function(t,e,o){return e.bottom+o.height>=t.bottom?e.top-o.height:e.bottom},I.ContextMenu={},I.ContextMenu.currentBlock=null,I.ContextMenu.menu_=null,I.ContextMenu.show=function(t,e,o){var i;I.WidgetDiv.show(I.ContextMenu,o,I.ContextMenu.dispose),e.length?(i=I.ContextMenu.populate_(e,o),I.ContextMenu.menu_=i,I.ContextMenu.position_(i,t,o),setTimeout(function(){i.focus()},1),I.ContextMenu.currentBlock=null):I.ContextMenu.hide()},I.ContextMenu.populate_=function(t,e){var o=new I.Menu;o.setRole(I.utils.aria.Role.MENU);for(var i=0,s;s=t[i];i++){var n=new I.MenuItem(s.text);n.setRightToLeft(e),n.setRole(I.utils.aria.Role.MENUITEM),o.addChild(n),n.setEnabled(s.enabled),s.enabled&&n.onAction(function(t){I.ContextMenu.hide(),this.callback(this.scope)},s)}return o},I.ContextMenu.position_=function(t,e,o){var i=I.utils.getViewportBBox();e=new I.utils.Rect(e.clientY+i.top,e.clientY+i.top,e.clientX+i.left,e.clientX+i.left),I.ContextMenu.createWidget_(t);var s=t.getSize();o&&(e.left+=s.width,e.right+=s.width,i.left+=s.width,i.right+=s.width),I.WidgetDiv.positionWithAnchor(i,e,s,o),t.focus()},I.ContextMenu.createWidget_=function(t){t.render(I.WidgetDiv.DIV);var e=t.getElement();I.utils.dom.addClass(e,"blocklyContextMenu"),I.browserEvents.conditionalBind(e,"contextmenu",null,I.utils.noEvent),t.focus()},I.ContextMenu.hide=function(){I.WidgetDiv.hideIfOwner(I.ContextMenu),I.ContextMenu.currentBlock=null},I.ContextMenu.dispose=function(){I.ContextMenu.menu_&&(I.ContextMenu.menu_.dispose(),I.ContextMenu.menu_=null)},I.ContextMenu.callbackFactory=function(o,i){return function(){I.Events.disable();try{var t=I.Xml.domToBlock(i,o.workspace),e=o.getRelativeToSurfaceXY();e.x=o.RTL?e.x-I.SNAP_RADIUS:e.x+I.SNAP_RADIUS,e.y+=2*I.SNAP_RADIUS,t.moveBy(e.x,e.y)}finally{I.Events.enable()}I.Events.isEnabled()&&!t.isShadow()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CREATE))(t)),t.select()}},I.ContextMenu.commentDeleteOption=function(t){return{text:I.Msg.REMOVE_COMMENT,enabled:!0,callback:function(){I.Events.setGroup(!0),t.dispose(!0,!0),I.Events.setGroup(!1)}}},I.ContextMenu.commentDuplicateOption=function(t){return{text:I.Msg.DUPLICATE_COMMENT,enabled:!0,callback:function(){I.duplicate(t)}}},I.ContextMenu.workspaceCommentOption=function(i,s){if(!I.WorkspaceCommentSvg)throw Error("Missing require for Blockly.WorkspaceCommentSvg");var t={enabled:!I.utils.userAgent.IE};return t.text=I.Msg.ADD_COMMENT,t.callback=function(){var t=new I.WorkspaceCommentSvg(i,I.Msg.WORKSPACE_COMMENT_DEFAULT_TEXT,I.WorkspaceCommentSvg.DEFAULT_SIZE,I.WorkspaceCommentSvg.DEFAULT_SIZE),e=i.getInjectionDiv().getBoundingClientRect(),e=new I.utils.Coordinate(s.clientX-e.left,s.clientY-e.top),o=i.getOriginOffsetInPixels();(e=I.utils.Coordinate.difference(e,o)).scale(1/i.scale),t.moveBy(e.x,e.y),i.rendered&&(t.initSvg(),t.render(),t.select())},t},I.ContextMenuRegistry=function(){(I.ContextMenuRegistry.registry=this).registry_={}},I.ContextMenuRegistry.ScopeType={BLOCK:"block",WORKSPACE:"workspace"},I.ContextMenuRegistry.registry=null,I.ContextMenuRegistry.prototype.register=function(t){if(this.registry_[t.id])throw Error('Menu item with id "'+t.id+'" is already registered.');this.registry_[t.id]=t},I.ContextMenuRegistry.prototype.unregister=function(t){if(!this.registry_[t])throw Error('Menu item with id "'+t+'" not found.');delete this.registry_[t]},I.ContextMenuRegistry.prototype.getItem=function(t){return this.registry_[t]||null},I.ContextMenuRegistry.prototype.getContextMenuOptions=function(o,i){var s=[],n=this.registry_;return Object.keys(n).forEach(function(t){var e;t=n[t],o!=t.scopeType||"hidden"!=(e=t.preconditionFn(i))&&(t={text:"function"==typeof t.displayText?t.displayText(i):t.displayText,enabled:"enabled"==e,callback:t.callback,scope:i,weight:t.weight},s.push(t))}),s.sort(function(t,e){return t.weight-e.weight}),s},new I.ContextMenuRegistry,I.Events.Selected=function(t,e,o){I.Events.Selected.superClass_.constructor.call(this,o),this.oldElementId=t,this.newElementId=e},I.utils.object.inherits(I.Events.Selected,I.Events.UiBase),I.Events.Selected.prototype.type=I.Events.SELECTED,I.Events.Selected.prototype.toJson=function(){var t=I.Events.Selected.superClass_.toJson.call(this);return t.oldElementId=this.oldElementId,t.newElementId=this.newElementId,t},I.Events.Selected.prototype.fromJson=function(t){I.Events.Selected.superClass_.fromJson.call(this,t),this.oldElementId=t.oldElementId,this.newElementId=t.newElementId},I.registry.register(I.registry.Type.EVENT,I.Events.SELECTED,I.Events.Selected),I.RenderedConnection=function(t,e){I.RenderedConnection.superClass_.constructor.call(this,t,e),this.db_=t.workspace.connectionDBList[e],this.dbOpposite_=t.workspace.connectionDBList[I.OPPOSITE_TYPE[e]],this.offsetInBlock_=new I.utils.Coordinate(0,0),this.trackedState_=I.RenderedConnection.TrackedState.WILL_TRACK,this.targetConnection=null},I.utils.object.inherits(I.RenderedConnection,I.Connection),I.RenderedConnection.TrackedState={WILL_TRACK:-1,UNTRACKED:0,TRACKED:1},I.RenderedConnection.prototype.dispose=function(){I.RenderedConnection.superClass_.dispose.call(this),this.trackedState_==I.RenderedConnection.TrackedState.TRACKED&&this.db_.removeConnection(this,this.y)},I.RenderedConnection.prototype.getSourceBlock=function(){return I.RenderedConnection.superClass_.getSourceBlock.call(this)},I.RenderedConnection.prototype.targetBlock=function(){return I.RenderedConnection.superClass_.targetBlock.call(this)},I.RenderedConnection.prototype.distanceFrom=function(t){var e=this.x-t.x;return t=this.y-t.y,Math.sqrt(e*e+t*t)},I.RenderedConnection.prototype.bumpAwayFrom=function(t){if(!this.sourceBlock_.workspace.isDragging()){var e=this.sourceBlock_.getRootBlock();if(!e.isInFlyout){var o=!1;if(!e.isMovable()){if(!(e=t.getSourceBlock().getRootBlock()).isMovable())return;t=this,o=!0}var i=I.selected==e;i||e.addSelect();var s=t.x+I.SNAP_RADIUS+Math.floor(Math.random()*I.BUMP_RANDOMNESS)-this.x,n=t.y+I.SNAP_RADIUS+Math.floor(Math.random()*I.BUMP_RANDOMNESS)-this.y;o&&(n=-n),e.RTL&&(s=t.x-I.SNAP_RADIUS-Math.floor(Math.random()*I.BUMP_RANDOMNESS)-this.x),e.moveBy(s,n),i||e.removeSelect()}}},I.RenderedConnection.prototype.moveTo=function(t,e){this.trackedState_==I.RenderedConnection.TrackedState.WILL_TRACK?(this.db_.addConnection(this,e),this.trackedState_=I.RenderedConnection.TrackedState.TRACKED):this.trackedState_==I.RenderedConnection.TrackedState.TRACKED&&(this.db_.removeConnection(this,this.y),this.db_.addConnection(this,e)),this.x=t,this.y=e},I.RenderedConnection.prototype.moveBy=function(t,e){this.moveTo(this.x+t,this.y+e)},I.RenderedConnection.prototype.moveToOffset=function(t){this.moveTo(t.x+this.offsetInBlock_.x,t.y+this.offsetInBlock_.y)},I.RenderedConnection.prototype.setOffsetInBlock=function(t,e){this.offsetInBlock_.x=t,this.offsetInBlock_.y=e},I.RenderedConnection.prototype.getOffsetInBlock=function(){return this.offsetInBlock_},I.RenderedConnection.prototype.tighten=function(){var t=this.targetConnection.x-this.x,e=this.targetConnection.y-this.y;if(0!=t||0!=e){var o=this.targetBlock(),i=o.getSvgRoot();if(!i)throw Error("block is not rendered.");i=I.utils.getRelativeXY(i),o.getSvgRoot().setAttribute("transform","translate("+(i.x-t)+","+(i.y-e)+")"),o.moveConnections(-t,-e)}},I.RenderedConnection.prototype.closest=function(t,e){return this.dbOpposite_.searchForClosest(this,t,e)},I.RenderedConnection.prototype.highlight=function(){var t,e=(t=this.sourceBlock_.workspace.getRenderer().getConstants()).shapeFor(this),e=this.type==I.connectionTypes.INPUT_VALUE||this.type==I.connectionTypes.OUTPUT_VALUE?(t=t.TAB_OFFSET_FROM_TOP,I.utils.svgPaths.moveBy(0,-t)+I.utils.svgPaths.lineOnAxis("v",t)+e.pathDown+I.utils.svgPaths.lineOnAxis("v",t)):(t=t.NOTCH_OFFSET_LEFT-t.CORNER_RADIUS,I.utils.svgPaths.moveBy(-t,0)+I.utils.svgPaths.lineOnAxis("h",t)+e.pathLeft+I.utils.svgPaths.lineOnAxis("h",t)),t=this.sourceBlock_.getRelativeToSurfaceXY();I.Connection.highlightedPath_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyHighlightedConnectionPath",d:e,transform:"translate("+(this.x-t.x)+","+(this.y-t.y)+")"+(this.sourceBlock_.RTL?" scale(-1 1)":"")},this.sourceBlock_.getSvgRoot())},I.RenderedConnection.prototype.unhighlight=function(){I.utils.dom.removeNode(I.Connection.highlightedPath_),delete I.Connection.highlightedPath_},I.RenderedConnection.prototype.setTracking=function(t){t&&this.trackedState_==I.RenderedConnection.TrackedState.TRACKED||!t&&this.trackedState_==I.RenderedConnection.TrackedState.UNTRACKED||this.sourceBlock_.isInFlyout||(t?(this.db_.addConnection(this,this.y),this.trackedState_=I.RenderedConnection.TrackedState.TRACKED):(this.trackedState_==I.RenderedConnection.TrackedState.TRACKED&&this.db_.removeConnection(this,this.y),this.trackedState_=I.RenderedConnection.TrackedState.UNTRACKED))},I.RenderedConnection.prototype.stopTrackingAll=function(){if(this.setTracking(!1),this.targetConnection)for(var t=this.targetBlock().getDescendants(!1),e=0;e<t.length;e++){for(var o=t[e],i=o.getConnections_(!0),s=0;s<i.length;s++)i[s].setTracking(!1);for(o=o.getIcons(),s=0;s<o.length;s++)o[s].setVisible(!1)}},I.RenderedConnection.prototype.startTrackingAll=function(){this.setTracking(!0);var t=[];if(this.type!=I.connectionTypes.INPUT_VALUE&&this.type!=I.connectionTypes.NEXT_STATEMENT)return t;var e=this.targetBlock(),o;if(e){e.isCollapsed()?(o=[],e.outputConnection&&o.push(e.outputConnection),e.nextConnection&&o.push(e.nextConnection),e.previousConnection&&o.push(e.previousConnection)):o=e.getConnections_(!0);for(var i=0;i<o.length;i++)t.push.apply(t,o[i].startTrackingAll());t.length||(t[0]=e)}return t},I.RenderedConnection.prototype.isConnectionAllowed=function(t,e){return I.utils.deprecation.warn("RenderedConnection.prototype.isConnectionAllowed","July 2020","July 2021","Blockly.Workspace.prototype.getConnectionChecker().canConnect"),!(this.distanceFrom(t)>e)&&I.RenderedConnection.superClass_.isConnectionAllowed.call(this,t)},I.RenderedConnection.prototype.onFailedConnect=function(t){this.bumpAwayFrom(t)},I.RenderedConnection.prototype.disconnectInternal_=function(t,e){I.RenderedConnection.superClass_.disconnectInternal_.call(this,t,e),t.rendered&&t.render(),e.rendered&&(e.updateDisabled(),e.render(),e.getSvgRoot().style.display="block")},I.RenderedConnection.prototype.respawnShadow_=function(){I.RenderedConnection.superClass_.respawnShadow_.call(this);var t=this.targetBlock();t&&(t.initSvg(),t.render(!1),(t=this.getSourceBlock()).rendered&&t.render())},I.RenderedConnection.prototype.neighbours=function(t){return this.dbOpposite_.getNeighbours(this,t)},I.RenderedConnection.prototype.connect_=function(t){I.RenderedConnection.superClass_.connect_.call(this,t);var e=this.getSourceBlock();t=t.getSourceBlock();var o=e.rendered,i=t.rendered;o&&e.updateDisabled(),i&&t.updateDisabled(),o&&i&&(this.type==I.connectionTypes.NEXT_STATEMENT||this.type==I.connectionTypes.PREVIOUS_STATEMENT?t:e).render(),(e=e.getInputWithBlock(t))&&(e=e.isVisible(),t.getSvgRoot().style.display=e?"block":"none")},I.RenderedConnection.prototype.onCheckChanged_=function(){!this.isConnected()||this.targetConnection&&this.getConnectionChecker().canConnect(this,this.targetConnection,!1)||((this.isSuperior()?this.targetBlock():this.sourceBlock_).unplug(),this.sourceBlock_.bumpNeighbours())},I.Marker=function(){this.drawer_=this.curNode_=this.colour=null,this.type="marker"},I.Marker.prototype.setDrawer=function(t){this.drawer_=t},I.Marker.prototype.getDrawer=function(){return this.drawer_},I.Marker.prototype.getCurNode=function(){return this.curNode_},I.Marker.prototype.setCurNode=function(t){var e=this.curNode_;this.curNode_=t,this.drawer_&&this.drawer_.draw(e,this.curNode_)},I.Marker.prototype.draw=function(){this.drawer_&&this.drawer_.draw(this.curNode_,this.curNode_)},I.Marker.prototype.hide=function(){this.drawer_&&this.drawer_.hide()},I.Marker.prototype.dispose=function(){this.getDrawer()&&this.getDrawer().dispose()},I.Cursor=function(){I.Cursor.superClass_.constructor.call(this),this.type="cursor"},I.utils.object.inherits(I.Cursor,I.Marker),I.Cursor.prototype.next=function(){var t=this.getCurNode();if(!t)return null;for(t=t.next();t&&t.next()&&(t.getType()==I.ASTNode.types.NEXT||t.getType()==I.ASTNode.types.BLOCK);)t=t.next();return t&&this.setCurNode(t),t},I.Cursor.prototype.in=function(){var t=this.getCurNode();if(!t)return null;return(t=(t=t.getType()==I.ASTNode.types.PREVIOUS||t.getType()==I.ASTNode.types.OUTPUT?t.next():t).in())&&this.setCurNode(t),t},I.Cursor.prototype.prev=function(){var t=this.getCurNode();if(!t)return null;for(t=t.prev();t&&t.prev()&&(t.getType()==I.ASTNode.types.NEXT||t.getType()==I.ASTNode.types.BLOCK);)t=t.prev();return t&&this.setCurNode(t),t},I.Cursor.prototype.out=function(){var t=this.getCurNode();if(!t)return null;return(t=(t=t.out())&&t.getType()==I.ASTNode.types.BLOCK?t.prev()||t:t)&&this.setCurNode(t),t},I.registry.register(I.registry.Type.CURSOR,I.registry.DEFAULT,I.Cursor),I.BasicCursor=function(){I.BasicCursor.superClass_.constructor.call(this)},I.utils.object.inherits(I.BasicCursor,I.Cursor),I.BasicCursor.registrationName="basicCursor",I.BasicCursor.prototype.next=function(){var t=this.getCurNode();if(!t)return null;return(t=this.getNextNode_(t,this.validNode_))&&this.setCurNode(t),t},I.BasicCursor.prototype.in=function(){return this.next()},I.BasicCursor.prototype.prev=function(){var t=this.getCurNode();if(!t)return null;return(t=this.getPreviousNode_(t,this.validNode_))&&this.setCurNode(t),t},I.BasicCursor.prototype.out=function(){return this.prev()},I.BasicCursor.prototype.getNextNode_=function(t,e){if(!t)return null;var o=t.in()||t.next();if(e(o))return o;if(o)return this.getNextNode_(o,e);return e(t=this.findSiblingOrParent_(t.out()))?t:t?this.getNextNode_(t,e):null},I.BasicCursor.prototype.getPreviousNode_=function(t,e){if(!t)return null;var o=t.prev(),o;return e(o=o?this.getRightMostChild_(o):t.out())?o:o?this.getPreviousNode_(o,e):null},I.BasicCursor.prototype.validNode_=function(t){var e=!1;return e=(t=t&&t.getType())==I.ASTNode.types.OUTPUT||t==I.ASTNode.types.INPUT||t==I.ASTNode.types.FIELD||t==I.ASTNode.types.NEXT||t==I.ASTNode.types.PREVIOUS||t==I.ASTNode.types.WORKSPACE?!0:e},I.BasicCursor.prototype.findSiblingOrParent_=function(t){if(!t)return null;var e=t.next();return e||this.findSiblingOrParent_(t.out())},I.BasicCursor.prototype.getRightMostChild_=function(t){if(!t.in())return t;for(t=t.in();t.next();)t=t.next();return this.getRightMostChild_(t)},I.registry.register(I.registry.Type.CURSOR,I.BasicCursor.registrationName,I.BasicCursor),I.TabNavigateCursor=function(){I.TabNavigateCursor.superClass_.constructor.call(this)},I.utils.object.inherits(I.TabNavigateCursor,I.BasicCursor),I.TabNavigateCursor.prototype.validNode_=function(t){var e=!1,o=t&&t.getType();return t&&(t=t.getLocation(),o==I.ASTNode.types.FIELD&&t&&t.isTabNavigable()&&t.isClickable()&&(e=!0)),e},I.BlockSvg=function(t,e,o){this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},null),this.svgGroup_.translate_="",this.style=t.getRenderer().getConstants().getBlockStyle(null),this.pathObject=t.getRenderer().makePathObject(this.svgGroup_,this.style),this.renderIsInProgress_=this.rendered=!1,this.workspace=t,this.previousConnection=this.nextConnection=this.outputConnection=null,this.useDragSurface_=I.utils.is3dSupported()&&!!t.getBlockDragSurface();var i=this.pathObject.svgPath;i.tooltip=this,I.Tooltip.bindMouseEvents(i),I.BlockSvg.superClass_.constructor.call(this,t,e,o),this.svgGroup_.dataset?this.svgGroup_.dataset.id=this.id:I.utils.userAgent.IE&&this.svgGroup_.setAttribute("data-id",this.id)},I.utils.object.inherits(I.BlockSvg,I.Block),I.BlockSvg.prototype.height=0,I.BlockSvg.prototype.width=0,I.BlockSvg.prototype.warningTextDb_=null,I.BlockSvg.INLINE=-1,I.BlockSvg.COLLAPSED_WARNING_ID="TEMP_COLLAPSED_WARNING_",I.BlockSvg.prototype.initSvg=function(){if(!this.workspace.rendered)throw TypeError("Workspace is headless.");for(var t=0,e;e=this.inputList[t];t++)e.init();for(e=this.getIcons(),t=0;t<e.length;t++)e[t].createIcon();this.applyColour(),this.pathObject.updateMovable(this.isMovable()),t=this.getSvgRoot(),this.workspace.options.readOnly||this.eventsInit_||!t||I.browserEvents.conditionalBind(t,"mousedown",this,this.onMouseDown_),this.eventsInit_=!0,t.parentNode||this.workspace.getCanvas().appendChild(t)},I.BlockSvg.prototype.getColourSecondary=function(){return this.style.colourSecondary},I.BlockSvg.prototype.getColourTertiary=function(){return this.style.colourTertiary},I.BlockSvg.prototype.getColourShadow=function(){return I.utils.deprecation.warn("BlockSvg.prototype.getColourShadow","January 2020","January 2021","style.colourSecondary"),this.getColourSecondary()},I.BlockSvg.prototype.getColourBorder=function(){return I.utils.deprecation.warn("BlockSvg.prototype.getColourBorder","January 2020","January 2021","style.colourTertiary"),{colourBorder:this.getColourTertiary(),colourLight:null,colourDark:null}},I.BlockSvg.prototype.select=function(){if(this.isShadow()&&this.getParent())this.getParent().select();else if(I.selected!=this){var t=null;if(I.selected){t=I.selected.id,I.Events.disable();try{I.selected.unselect()}finally{I.Events.enable()}}t=new(I.Events.get(I.Events.SELECTED))(t,this.id,this.workspace.id),I.Events.fire(t),(I.selected=this).addSelect()}},I.BlockSvg.prototype.unselect=function(){var t;I.selected==this&&((t=new(I.Events.get(I.Events.SELECTED))(this.id,null,this.workspace.id)).workspaceId=this.workspace.id,I.Events.fire(t),I.selected=null,this.removeSelect())},I.BlockSvg.prototype.mutator=null,I.BlockSvg.prototype.comment=null,I.BlockSvg.prototype.commentIcon_=null,I.BlockSvg.prototype.warning=null,I.BlockSvg.prototype.getIcons=function(){var t=[];return this.mutator&&t.push(this.mutator),this.commentIcon_&&t.push(this.commentIcon_),this.warning&&t.push(this.warning),t},I.BlockSvg.prototype.setParent=function(t){var e=this.parentBlock_,o,i;t!=e&&(I.utils.dom.startTextWidthCache(),I.BlockSvg.superClass_.setParent.call(this,t),I.utils.dom.stopTextWidthCache(),o=this.getSvgRoot(),!this.workspace.isClearing&&o&&(i=this.getRelativeToSurfaceXY(),t?(t.getSvgRoot().appendChild(o),t=this.getRelativeToSurfaceXY(),this.moveConnections(t.x-i.x,t.y-i.y)):e&&(this.workspace.getCanvas().appendChild(o),this.translate(i.x,i.y)),this.applyColour()))},I.BlockSvg.prototype.getRelativeToSurfaceXY=function(){var t=0,e=0,o=this.useDragSurface_?this.workspace.getBlockDragSurface().getGroup():null,i=this.getSvgRoot();if(i)do{var s=I.utils.getRelativeXY(i);t+=s.x,e+=s.y,this.useDragSurface_&&this.workspace.getBlockDragSurface().getCurrentBlock()==i&&(t+=(s=this.workspace.getBlockDragSurface().getSurfaceTranslation()).x,e+=s.y),i=i.parentNode}while(i&&i!=this.workspace.getCanvas()&&i!=o);return new I.utils.Coordinate(t,e)},I.BlockSvg.prototype.moveBy=function(t,e){if(this.parentBlock_)throw Error("Block has parent.");var o=I.Events.isEnabled(),i;o&&(i=new(I.Events.get(I.Events.BLOCK_MOVE))(this));var s=this.getRelativeToSurfaceXY();this.translate(s.x+t,s.y+e),this.moveConnections(t,e),o&&(i.recordNew(),I.Events.fire(i)),this.workspace.resizeContents()},I.BlockSvg.prototype.translate=function(t,e){this.getSvgRoot().setAttribute("transform","translate("+t+","+e+")")},I.BlockSvg.prototype.moveToDragSurface=function(){var t;this.useDragSurface_&&(t=this.getRelativeToSurfaceXY(),this.clearTransformAttributes_(),this.workspace.getBlockDragSurface().translateSurface(t.x,t.y),(t=this.getSvgRoot())&&this.workspace.getBlockDragSurface().setBlocksAndShow(t))},I.BlockSvg.prototype.moveTo=function(t){var e=this.getRelativeToSurfaceXY();this.moveBy(t.x-e.x,t.y-e.y)},I.BlockSvg.prototype.moveOffDragSurface=function(t){this.useDragSurface_&&(this.translate(t.x,t.y),this.workspace.getBlockDragSurface().clearAndHide(this.workspace.getCanvas()))},I.BlockSvg.prototype.moveDuringDrag=function(t){this.useDragSurface_?this.workspace.getBlockDragSurface().translateSurface(t.x,t.y):(this.svgGroup_.translate_="translate("+t.x+","+t.y+")",this.svgGroup_.setAttribute("transform",this.svgGroup_.translate_+this.svgGroup_.skew_))},I.BlockSvg.prototype.clearTransformAttributes_=function(){this.getSvgRoot().removeAttribute("transform")},I.BlockSvg.prototype.snapToGrid=function(){var t,e,o,i,t,e;!this.workspace||this.workspace.isDragging()||this.getParent()||this.isInFlyout||(t=this.workspace.getGrid())&&t.shouldSnap()&&(o=(e=t.getSpacing())/2,i=this.getRelativeToSurfaceXY(),t=Math.round((i.x-o)/e)*e+o-i.x,e=Math.round((i.y-o)/e)*e+o-i.y,t=Math.round(t),e=Math.round(e),0==t&&0==e||this.moveBy(t,e))},I.BlockSvg.prototype.getBoundingRectangle=function(){var t=this.getRelativeToSurfaceXY(),e=this.getHeightWidth(),o,i,i=this.RTL?(o=t.x-e.width,t.x):(o=t.x,t.x+e.width);return new I.utils.Rect(t.y,t.y+e.height,o,i)},I.BlockSvg.prototype.markDirty=function(){this.pathObject.constants=this.workspace.getRenderer().getConstants();for(var t=0,e;e=this.inputList[t];t++)e.markDirty()},I.BlockSvg.prototype.setCollapsed=function(t){this.collapsed_!=t&&(I.BlockSvg.superClass_.setCollapsed.call(this,t),t?this.rendered&&this.render():this.updateCollapsed_())},I.BlockSvg.prototype.updateCollapsed_=function(){for(var t=this.isCollapsed(),e=I.constants.COLLAPSED_INPUT_NAME,o=I.constants.COLLAPSED_FIELD_NAME,i=0,s;s=this.inputList[i];i++)s.name!=e&&s.setVisible(!t);if(t){for(s=this.getIcons(),i=0;t=s[i];i++)t.setVisible(!1);i=this.toString(I.COLLAPSE_CHARS),(s=this.getField(o))?s.setValue(i):(s=this.getInput(e)||this.appendDummyInput(e)).appendField(new I.FieldLabel(i),o)}else this.updateDisabled(),this.removeInput(e)},I.BlockSvg.prototype.tab=function(t,e){var o=new I.TabNavigateCursor;o.setCurNode(I.ASTNode.createFieldNode(t)),t=o.getCurNode(),e?o.next():o.prev(),(e=o.getCurNode())&&e!==t&&(e.getLocation().showEditor(),this.workspace.keyboardAccessibilityMode&&this.workspace.getCursor().setCurNode(e))},I.BlockSvg.prototype.onMouseDown_=function(t){var e=this.workspace&&this.workspace.getGesture(t);e&&e.handleBlockStart(t,this)},I.BlockSvg.prototype.showHelp=function(){var t="function"==typeof this.helpUrl?this.helpUrl():this.helpUrl;t&&window.open(t)},I.BlockSvg.prototype.generateContextMenu=function(){if(this.workspace.options.readOnly||!this.contextMenu)return null;var t=I.ContextMenuRegistry.registry.getContextMenuOptions(I.ContextMenuRegistry.ScopeType.BLOCK,{block:this});return this.customContextMenu&&this.customContextMenu(t),t},I.BlockSvg.prototype.showContextMenu=function(t){var e=this.generateContextMenu();e&&e.length&&(I.ContextMenu.show(t,e,this.RTL),I.ContextMenu.currentBlock=this)},I.BlockSvg.prototype.moveConnections=function(t,e){if(this.rendered){for(var o=this.getConnections_(!1),i=0;i<o.length;i++)o[i].moveBy(t,e);for(o=this.getIcons(),i=0;i<o.length;i++)o[i].computeIconLocation();for(i=0;i<this.childBlocks_.length;i++)this.childBlocks_[i].moveConnections(t,e)}},I.BlockSvg.prototype.setDragging=function(t){var e;for(t?((e=this.getSvgRoot()).translate_="",e.skew_="",I.draggingConnections=I.draggingConnections.concat(this.getConnections_(!0)),I.utils.dom.addClass(this.svgGroup_,"blocklyDragging")):(I.draggingConnections=[],I.utils.dom.removeClass(this.svgGroup_,"blocklyDragging")),e=0;e<this.childBlocks_.length;e++)this.childBlocks_[e].setDragging(t)},I.BlockSvg.prototype.setMovable=function(t){I.BlockSvg.superClass_.setMovable.call(this,t),this.pathObject.updateMovable(t)},I.BlockSvg.prototype.setEditable=function(t){I.BlockSvg.superClass_.setEditable.call(this,t),t=this.getIcons();for(var e=0;e<t.length;e++)t[e].updateEditable()},I.BlockSvg.prototype.setShadow=function(t){I.BlockSvg.superClass_.setShadow.call(this,t),this.applyColour()},I.BlockSvg.prototype.setInsertionMarker=function(t){this.isInsertionMarker_!=t&&(this.isInsertionMarker_=t)&&(this.setColour(this.workspace.getRenderer().getConstants().INSERTION_MARKER_COLOUR),this.pathObject.updateInsertionMarker(!0))},I.BlockSvg.prototype.getSvgRoot=function(){return this.svgGroup_},I.BlockSvg.prototype.dispose=function(t,e){if(this.workspace){I.Tooltip.dispose(),I.Tooltip.unbindMouseEvents(this.pathObject.svgPath),I.utils.dom.startTextWidthCache();var o=this.workspace;if(I.selected==this&&(this.unselect(),this.workspace.cancelCurrentGesture()),I.ContextMenu.currentBlock==this&&I.ContextMenu.hide(),e&&this.rendered&&(this.unplug(t),I.blockAnimations.disposeUiEffect(this)),this.rendered=!1,this.warningTextDb_){for(var i in this.warningTextDb_)clearTimeout(this.warningTextDb_[i]);this.warningTextDb_=null}for(e=this.getIcons(),i=0;i<e.length;i++)e[i].dispose();I.BlockSvg.superClass_.dispose.call(this,!!t),I.utils.dom.removeNode(this.svgGroup_),o.resizeContents(),this.svgGroup_=null,I.utils.dom.stopTextWidthCache()}},I.BlockSvg.prototype.toCopyData=function(){if(this.isInsertionMarker_)return null;var t=I.Xml.blockToDom(this,!0);I.Xml.deleteNext(t);var e=this.getRelativeToSurfaceXY();return t.setAttribute("x",this.RTL?-e.x:e.x),t.setAttribute("y",e.y),{xml:t,source:this.workspace,typeCounts:I.utils.getBlockTypeCounts(this,!0)}},I.BlockSvg.prototype.applyColour=function(){this.pathObject.applyColour(this);for(var t=this.getIcons(),e=0;e<t.length;e++)t[e].applyColour();for(t=0;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.applyColour()},I.BlockSvg.prototype.updateDisabled=function(){var t=this.getChildren(!1);if(this.applyColour(),!this.isCollapsed())for(var e=0,o;o=t[e];e++)o.rendered&&o.updateDisabled()},I.BlockSvg.prototype.getCommentIcon=function(){return this.commentIcon_},I.BlockSvg.prototype.setCommentText=function(t){if(!I.Comment)throw Error("Missing require for Blockly.Comment");this.commentModel.text!=t&&(I.BlockSvg.superClass_.setCommentText.call(this,t),!!this.commentIcon_==(t=null!=t)?this.commentIcon_.updateText():(t?this.comment=this.commentIcon_=new I.Comment(this):(this.commentIcon_.dispose(),this.comment=this.commentIcon_=null),this.rendered&&(this.render(),this.bumpNeighbours())))},I.BlockSvg.prototype.setWarningText=function(t,e){if(!I.Warning)throw Error("Missing require for Blockly.Warning");this.warningTextDb_||(this.warningTextDb_=Object.create(null));var o=e||"";if(o)this.warningTextDb_[o]&&(clearTimeout(this.warningTextDb_[o]),delete this.warningTextDb_[o]);else for(var i in this.warningTextDb_)clearTimeout(this.warningTextDb_[i]),delete this.warningTextDb_[i];if(this.workspace.isDragging()){var s=this;this.warningTextDb_[o]=setTimeout(function(){s.workspace&&(delete s.warningTextDb_[o],s.setWarningText(t,o))},100)}else{if(e=!1,"string"==typeof(t=this.isInFlyout?null:t)){for(var i=this.getSurroundParent(),n=null;i;)i.isCollapsed()&&(n=i),i=i.getSurroundParent();n&&n.setWarningText(I.Msg.COLLAPSED_WARNINGS_WARNING,I.BlockSvg.COLLAPSED_WARNING_ID),this.warning||(this.warning=new I.Warning(this),e=!0),this.warning.setText(t,o)}else this.warning&&!o?(this.warning.dispose(),e=!0):this.warning&&(e=this.warning.getText(),this.warning.setText("",o),(i=this.warning.getText())||this.warning.dispose(),e=e!=i);e&&this.rendered&&(this.render(),this.bumpNeighbours())}},I.BlockSvg.prototype.setMutator=function(t){this.mutator&&this.mutator!==t&&this.mutator.dispose(),t&&(t.setBlock(this),(this.mutator=t).createIcon()),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.setEnabled=function(t){this.isEnabled()!=t&&(I.BlockSvg.superClass_.setEnabled.call(this,t),this.rendered&&!this.getInheritedDisabled()&&this.updateDisabled())},I.BlockSvg.prototype.setHighlighted=function(t){this.rendered&&this.pathObject.updateHighlighted(t)},I.BlockSvg.prototype.addSelect=function(){this.pathObject.updateSelected(!0)},I.BlockSvg.prototype.removeSelect=function(){this.pathObject.updateSelected(!1)},I.BlockSvg.prototype.setDeleteStyle=function(t){this.pathObject.updateDraggingDelete(t)},I.BlockSvg.prototype.getColour=function(){return this.style.colourPrimary},I.BlockSvg.prototype.setColour=function(t){I.BlockSvg.superClass_.setColour.call(this,t),t=this.workspace.getRenderer().getConstants().getBlockStyleForColour(this.colour_),this.pathObject.setStyle(t.style),this.style=t.style,this.styleName_=t.name,this.applyColour()},I.BlockSvg.prototype.setStyle=function(t){var e=this.workspace.getRenderer().getConstants().getBlockStyle(t);if(this.styleName_=t,!e)throw Error("Invalid style name: "+t);this.hat=e.hat,this.pathObject.setStyle(e),this.colour_=e.colourPrimary,this.style=e,this.applyColour()},I.BlockSvg.prototype.bringToFront=function(){var t=this;do{var e=t.getSvgRoot(),o=e.parentNode,i=o.childNodes;i[i.length-1]!==e&&o.appendChild(e),t=t.getParent()}while(t)},I.BlockSvg.prototype.setPreviousStatement=function(t,e){I.BlockSvg.superClass_.setPreviousStatement.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.setNextStatement=function(t,e){I.BlockSvg.superClass_.setNextStatement.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.setOutput=function(t,e){I.BlockSvg.superClass_.setOutput.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.setInputsInline=function(t){I.BlockSvg.superClass_.setInputsInline.call(this,t),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.removeInput=function(t,e){return t=I.BlockSvg.superClass_.removeInput.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours()),t},I.BlockSvg.prototype.moveNumberedInputBefore=function(t,e){I.BlockSvg.superClass_.moveNumberedInputBefore.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},I.BlockSvg.prototype.appendInput_=function(t,e){return t=I.BlockSvg.superClass_.appendInput_.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours()),t},I.BlockSvg.prototype.setConnectionTracking=function(t){var e;if(this.previousConnection&&this.previousConnection.setTracking(t),this.outputConnection&&this.outputConnection.setTracking(t),this.nextConnection&&(this.nextConnection.setTracking(t),(e=this.nextConnection.targetBlock())&&e.setConnectionTracking(t)),!this.collapsed_)for(e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;o&&(o.setTracking(t),(o=o.targetBlock())&&o.setConnectionTracking(t))}},I.BlockSvg.prototype.getConnections_=function(t){var e=[],o;if((t||this.rendered)&&(this.outputConnection&&e.push(this.outputConnection),this.previousConnection&&e.push(this.previousConnection),this.nextConnection&&e.push(this.nextConnection),t||!this.collapsed_)){t=0;for(;o=this.inputList[t];t++)o.connection&&e.push(o.connection)}return e},I.BlockSvg.prototype.lastConnectionInStack=function(){return I.BlockSvg.superClass_.lastConnectionInStack.call(this)},I.BlockSvg.prototype.getMatchingConnection=function(t,e){return I.BlockSvg.superClass_.getMatchingConnection.call(this,t,e)},I.BlockSvg.prototype.makeConnection_=function(t){return new I.RenderedConnection(this,t)},I.BlockSvg.prototype.bumpNeighbours=function(){if(this.workspace&&!this.workspace.isDragging()){var t=this.getRootBlock();if(!t.isInFlyout)for(var e=this.getConnections_(!1),o=0,i;i=e[o];o++){i.isConnected()&&i.isSuperior()&&i.targetBlock().bumpNeighbours();for(var s=i.neighbours(I.SNAP_RADIUS),n=0,r;r=s[n];n++)i.isConnected()&&r.isConnected()||r.getSourceBlock().getRootBlock()!=t&&(i.isSuperior()?r.bumpAwayFrom(i):i.bumpAwayFrom(r))}}},I.BlockSvg.prototype.scheduleSnapAndBump=function(){var t=this,e=I.Events.getGroup();setTimeout(function(){I.Events.setGroup(e),t.snapToGrid(),I.Events.setGroup(!1)},I.BUMP_DELAY/2),setTimeout(function(){I.Events.setGroup(e),t.bumpNeighbours(),I.Events.setGroup(!1)},I.BUMP_DELAY)},I.BlockSvg.prototype.positionNearConnection=function(t,e){t.type!=I.connectionTypes.NEXT_STATEMENT&&t.type!=I.connectionTypes.INPUT_VALUE||this.moveBy(e.x-t.x,e.y-t.y)},I.BlockSvg.prototype.getParent=function(){return I.BlockSvg.superClass_.getParent.call(this)},I.BlockSvg.prototype.getRootBlock=function(){return I.BlockSvg.superClass_.getRootBlock.call(this)},I.BlockSvg.prototype.render=function(t){if(!this.renderIsInProgress_){this.renderIsInProgress_=!0;try{var e;this.rendered=!0,I.utils.dom.startTextWidthCache(),this.isCollapsed()&&this.updateCollapsed_(),this.workspace.getRenderer().render(this),this.updateConnectionLocations_(),!1!==t&&((e=this.getParent())?e.render(!0):this.workspace.resizeContents()),I.utils.dom.stopTextWidthCache(),this.updateMarkers_()}finally{this.renderIsInProgress_=!1}}},I.BlockSvg.prototype.updateMarkers_=function(){this.workspace.keyboardAccessibilityMode&&this.pathObject.cursorSvg&&this.workspace.getCursor().draw(),this.workspace.keyboardAccessibilityMode&&this.pathObject.markerSvg&&this.workspace.getMarker(I.MarkerManager.LOCAL_MARKER).draw()},I.BlockSvg.prototype.updateConnectionLocations_=function(){var t=this.getRelativeToSurfaceXY();this.previousConnection&&this.previousConnection.moveToOffset(t),this.outputConnection&&this.outputConnection.moveToOffset(t);for(var e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;o&&(o.moveToOffset(t),o.isConnected()&&o.tighten())}this.nextConnection&&(this.nextConnection.moveToOffset(t),this.nextConnection.isConnected()&&this.nextConnection.tighten())},I.BlockSvg.prototype.setCursorSvg=function(t){this.pathObject.setCursorSvg(t)},I.BlockSvg.prototype.setMarkerSvg=function(t){this.pathObject.setMarkerSvg(t)},I.BlockSvg.prototype.getHeightWidth=function(){var t=this.height,e=this.width,o=this.getNextBlock(),o,i;return o&&(o=o.getHeightWidth(),i=this.workspace.getRenderer().getConstants().NOTCH_HEIGHT,t+=o.height-i,e=Math.max(e,o.width)),{height:t,width:e}},I.BlockSvg.prototype.fadeForReplacement=function(t){this.pathObject.updateReplacementFade(t)},I.BlockSvg.prototype.highlightShapeForInput=function(t,e){this.pathObject.updateShapeForInputHighlight(t,e)},I.ConnectionDB=function(t){this.connections_=[],this.connectionChecker_=t},I.ConnectionDB.prototype.addConnection=function(t,e){e=this.calculateIndexForYPos_(e),this.connections_.splice(e,0,t)},I.ConnectionDB.prototype.findIndexOfConnection_=function(t,e){if(!this.connections_.length)return-1;var o=this.calculateIndexForYPos_(e);if(o>=this.connections_.length)return-1;e=t.y;for(var i=o;0<=i&&this.connections_[i].y==e;){if(this.connections_[i]==t)return i;i--}for(;o<this.connections_.length&&this.connections_[o].y==e;){if(this.connections_[o]==t)return o;o++}return-1},I.ConnectionDB.prototype.calculateIndexForYPos_=function(t){if(!this.connections_.length)return 0;for(var e=0,o=this.connections_.length;e<o;){var i=Math.floor((e+o)/2);if(this.connections_[i].y<t)e=i+1;else{if(!(this.connections_[i].y>t)){e=i;break}o=i}}return e},I.ConnectionDB.prototype.removeConnection=function(t,e){if(-1==(t=this.findIndexOfConnection_(t,e)))throw Error("Unable to find connection in connectionDB.");this.connections_.splice(t,1)},I.ConnectionDB.prototype.getNeighbours=function(t,i){function e(t){var e=n-s[t].x,o=r-s[t].y;return Math.sqrt(e*e+o*o)<=i&&a.push(s[t]),o<i}var s=this.connections_,n=t.x,r=t.y;t=0;for(var o,l=o=s.length-2;t<l;)s[l].y<r?t=l:o=l,l=Math.floor((t+o)/2);var a=[],o=t=l;if(s.length){for(;0<=t&&e(t);)t--;do{o++}while(o<s.length&&e(o))}return a},I.ConnectionDB.prototype.isInYRange_=function(t,e,o){return Math.abs(this.connections_[t].y-e)<=o},I.ConnectionDB.prototype.searchForClosest=function(t,e,o){if(!this.connections_.length)return{connection:null,radius:e};var i=t.y,s=t.x;t.x=s+o.x,t.y=i+o.y;var n=this.calculateIndexForYPos_(t.y);o=null;for(var r=e,l,a=n-1;0<=a&&this.isInYRange_(a,t.y,e);)l=this.connections_[a],this.connectionChecker_.canConnect(t,l,!0,r)&&(r=(o=l).distanceFrom(t)),a--;for(;n<this.connections_.length&&this.isInYRange_(n,t.y,e);)l=this.connections_[n],this.connectionChecker_.canConnect(t,l,!0,r)&&(r=(o=l).distanceFrom(t)),n++;return t.x=s,t.y=i,{connection:o,radius:r}},I.ConnectionDB.init=function(t){var e=[];return e[I.connectionTypes.INPUT_VALUE]=new I.ConnectionDB(t),e[I.connectionTypes.OUTPUT_VALUE]=new I.ConnectionDB(t),e[I.connectionTypes.NEXT_STATEMENT]=new I.ConnectionDB(t),e[I.connectionTypes.PREVIOUS_STATEMENT]=new I.ConnectionDB(t),e},I.Events.ThemeChange=function(t,e){I.Events.ThemeChange.superClass_.constructor.call(this,e),this.themeName=t},I.utils.object.inherits(I.Events.ThemeChange,I.Events.UiBase),I.Events.ThemeChange.prototype.type=I.Events.THEME_CHANGE,I.Events.ThemeChange.prototype.toJson=function(){var t=I.Events.ThemeChange.superClass_.toJson.call(this);return t.themeName=this.themeName,t},I.Events.ThemeChange.prototype.fromJson=function(t){I.Events.ThemeChange.superClass_.fromJson.call(this,t),this.themeName=t.themeName},I.registry.register(I.registry.Type.EVENT,I.Events.THEME_CHANGE,I.Events.ThemeChange),I.Events.ViewportChange=function(t,e,o,i,s){I.Events.ViewportChange.superClass_.constructor.call(this,i),this.viewTop=t,this.viewLeft=e,this.scale=o,this.oldScale=s},I.utils.object.inherits(I.Events.ViewportChange,I.Events.UiBase),I.Events.ViewportChange.prototype.type=I.Events.VIEWPORT_CHANGE,I.Events.ViewportChange.prototype.toJson=function(){var t=I.Events.ViewportChange.superClass_.toJson.call(this);return t.viewTop=this.viewTop,t.viewLeft=this.viewLeft,t.scale=this.scale,t.oldScale=this.oldScale,t},I.Events.ViewportChange.prototype.fromJson=function(t){I.Events.ViewportChange.superClass_.fromJson.call(this,t),this.viewTop=t.viewTop,this.viewLeft=t.viewLeft,this.scale=t.scale,this.oldScale=t.oldScale},I.registry.register(I.registry.Type.EVENT,I.Events.VIEWPORT_CHANGE,I.Events.ViewportChange),I.MarkerManager=function(t){this.cursorSvg_=this.cursor_=null,this.markers_={},this.workspace_=t},I.MarkerManager.LOCAL_MARKER="local_marker_1",I.MarkerManager.prototype.registerMarker=function(t,e){this.markers_[t]&&this.unregisterMarker(t),e.setDrawer(this.workspace_.getRenderer().makeMarkerDrawer(this.workspace_,e)),this.setMarkerSvg(e.getDrawer().createDom()),this.markers_[t]=e},I.MarkerManager.prototype.unregisterMarker=function(t){var e=this.markers_[t];if(!e)throw Error("Marker with id "+t+" does not exist. Can only unregistermarkers that exist.");e.dispose(),delete this.markers_[t]},I.MarkerManager.prototype.getCursor=function(){return this.cursor_},I.MarkerManager.prototype.getMarker=function(t){return this.markers_[t]},I.MarkerManager.prototype.setCursor=function(t){this.cursor_&&this.cursor_.getDrawer()&&this.cursor_.getDrawer().dispose(),(this.cursor_=t)&&(t=this.workspace_.getRenderer().makeMarkerDrawer(this.workspace_,this.cursor_),this.cursor_.setDrawer(t),this.setCursorSvg(this.cursor_.getDrawer().createDom()))},I.MarkerManager.prototype.setCursorSvg=function(t){t?(this.workspace_.getBlockCanvas().appendChild(t),this.cursorSvg_=t):this.cursorSvg_=null},I.MarkerManager.prototype.setMarkerSvg=function(t){t?this.workspace_.getBlockCanvas()&&(this.cursorSvg_?this.workspace_.getBlockCanvas().insertBefore(t,this.cursorSvg_):this.workspace_.getBlockCanvas().appendChild(t)):this.markerSvg_=null},I.MarkerManager.prototype.updateMarkers=function(){this.workspace_.keyboardAccessibilityMode&&this.cursorSvg_&&this.workspace_.getCursor().draw()},I.MarkerManager.prototype.dispose=function(){for(var t=Object.keys(this.markers_),e=0,o;o=t[e];e++)this.unregisterMarker(o);this.markers_=null,this.cursor_&&(this.cursor_.dispose(),this.cursor_=null)},I.IMetricsManager=function(){},I.MetricsManager=function(t){this.workspace_=t},I.MetricsManager.prototype.getDimensionsPx_=function(t){var e=0,o=0;return t&&(e=t.getWidth(),o=t.getHeight()),new I.utils.Size(e,o)},I.MetricsManager.prototype.getFlyoutMetrics=function(t){return{width:(t=this.getDimensionsPx_(this.workspace_.getFlyout(t))).width,height:t.height,position:this.workspace_.toolboxPosition}},I.MetricsManager.prototype.getToolboxMetrics=function(){var t=this.getDimensionsPx_(this.workspace_.getToolbox());return{width:t.width,height:t.height,position:this.workspace_.toolboxPosition}},I.MetricsManager.prototype.getSvgMetrics=function(){return this.workspace_.getCachedParentSvgSize()},I.MetricsManager.prototype.getAbsoluteMetrics=function(){var t=0,e=this.getToolboxMetrics(),o=this.getFlyoutMetrics(!0),i=!!this.workspace_.getToolbox(),s=!!this.workspace_.getFlyout(!0),n,r=(n=(i?e:o).position)==I.utils.toolbox.Position.LEFT,n=n==I.utils.toolbox.Position.TOP;return i&&r?t=e.width:s&&r&&(t=o.width),r=0,i&&n?r=e.height:s&&n&&(r=o.height),{top:r,left:t}},I.MetricsManager.prototype.getViewMetrics=function(t){t=t?this.workspace_.scale:1;var e=this.getSvgMetrics(),o=this.getToolboxMetrics(),i=this.getFlyoutMetrics(!0),s=(this.workspace_.getToolbox()?o:i).position;return this.workspace_.getToolbox()?s==I.utils.toolbox.Position.TOP||s==I.utils.toolbox.Position.BOTTOM?e.height-=o.height:s!=I.utils.toolbox.Position.LEFT&&s!=I.utils.toolbox.Position.RIGHT||(e.width-=o.width):this.workspace_.getFlyout(!0)&&(s==I.utils.toolbox.Position.TOP||s==I.utils.toolbox.Position.BOTTOM?e.height-=i.height:s!=I.utils.toolbox.Position.LEFT&&s!=I.utils.toolbox.Position.RIGHT||(e.width-=i.width)),{height:e.height/t,width:e.width/t,top:-this.workspace_.scrollY/t,left:-this.workspace_.scrollX/t}},I.MetricsManager.prototype.getContentMetrics=function(t){t=t?1:this.workspace_.scale;var e=this.workspace_.getBlocksBoundingBox();return{height:(e.bottom-e.top)*t,width:(e.right-e.left)*t,top:e.top*t,left:e.left*t}},I.MetricsManager.prototype.hasFixedEdges=function(){return!this.workspace_.isMovableHorizontally()||!this.workspace_.isMovableVertically()},I.MetricsManager.prototype.getComputedFixedEdges_=function(t){if(!this.hasFixedEdges())return{};var e=this.workspace_.isMovableHorizontally(),o=this.workspace_.isMovableVertically();t=t||this.getViewMetrics(!1);var i={};return o||(i.top=t.top,i.bottom=t.top+t.height),e||(i.left=t.left,i.right=t.left+t.width),i},I.MetricsManager.prototype.getPaddedContent_=function(t,e){var o=e.top+e.height,i=e.left+e.width,s=t.width,n=s/2,r=(t=t.height)/2;return{top:Math.min(e.top-r,o-t),bottom:Math.max(o+r,e.top+t),left:Math.min(e.left-n,i-s),right:Math.max(i+n,e.left+s)}},I.MetricsManager.prototype.getScrollMetrics=function(t,e,o){t=t?this.workspace_.scale:1,e=e||this.getViewMetrics(!1);var i=o||this.getContentMetrics();o=this.getComputedFixedEdges_(e),e=this.getPaddedContent_(e,i);var i=(void 0!==o.top?o:e).top,s=(void 0!==o.left?o:e).left;return{top:i/t,left:s/t,width:((void 0!==o.right?o:e).right-s)/t,height:((void 0!==o.bottom?o:e).bottom-i)/t}},I.MetricsManager.prototype.getUiMetrics=function(){return{viewMetrics:this.getViewMetrics(),absoluteMetrics:this.getAbsoluteMetrics(),toolboxMetrics:this.getToolboxMetrics()}},I.MetricsManager.prototype.getMetrics=function(){var t=this.getToolboxMetrics(),e=this.getFlyoutMetrics(!0),o=this.getSvgMetrics(),i=this.getAbsoluteMetrics(),s=this.getViewMetrics(),n=this.getContentMetrics(),r=this.getScrollMetrics(!1,s,n);return{contentHeight:n.height,contentWidth:n.width,contentTop:n.top,contentLeft:n.left,scrollHeight:r.height,scrollWidth:r.width,scrollTop:r.top,scrollLeft:r.left,viewHeight:s.height,viewWidth:s.width,viewTop:s.top,viewLeft:s.left,absoluteTop:i.top,absoluteLeft:i.left,svgHeight:o.height,svgWidth:o.width,toolboxWidth:t.width,toolboxHeight:t.height,toolboxPosition:t.position,flyoutWidth:e.width,flyoutHeight:e.height}},I.registry.register(I.registry.Type.METRICS_MANAGER,I.registry.DEFAULT,I.MetricsManager),I.FlyoutMetricsManager=function(t,e){this.flyout_=e,I.FlyoutMetricsManager.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.FlyoutMetricsManager,I.MetricsManager),I.FlyoutMetricsManager.prototype.getBoundingBox_=function(){try{var e=this.workspace_.getCanvas().getBBox()}catch(t){e={height:0,y:0,width:0,x:0}}return e},I.FlyoutMetricsManager.prototype.getContentMetrics=function(t){var e=this.getBoundingBox_();return t=t?1:this.workspace_.scale,{height:e.height*t,width:e.width*t,top:e.y*t,left:e.x*t}},I.FlyoutMetricsManager.prototype.getScrollMetrics=function(t,e,o){return e=o||this.getContentMetrics(),o=this.flyout_.MARGIN*this.workspace_.scale,t=t?this.workspace_.scale:1,{height:(e.height+2*o)/t,width:(e.width+e.left+o)/t,top:0,left:0}},I.FlyoutMetricsManager.prototype.getViewMetrics=function(t){var e=this.getSvgMetrics(),o,e;return t=t?this.workspace_.scale:1,{height:(e=this.flyout_.horizontalLayout?(o=e.width-2*this.flyout_.SCROLLBAR_PADDING,e.height-this.flyout_.SCROLLBAR_PADDING):(o=e.width-this.flyout_.SCROLLBAR_PADDING,e.height-2*this.flyout_.SCROLLBAR_PADDING))/t,width:o/t,top:-this.workspace_.scrollY/t,left:-this.workspace_.scrollX/t}},I.FlyoutMetricsManager.prototype.getAbsoluteMetrics=function(){var t=this.flyout_.SCROLLBAR_PADDING;return this.flyout_.horizontalLayout?{top:0,left:t}:{top:t,left:0}},I.PluginManager=function(){this.pluginData_={},this.typeToPluginIds_={}},I.PluginManager.prototype.addPlugin=function(t){this.pluginData_[t.id]=t;for(var e=0,o;o=t.types[e];e++)o=String(o).toLowerCase(),void 0===this.typeToPluginIds_[o]?this.typeToPluginIds_[o]=[t.id]:this.typeToPluginIds_[o].push(t.id)},I.PluginManager.prototype.getPlugin=function(t){return this.pluginData_[t]&&this.pluginData_[t].plugin},I.PluginManager.prototype.getPlugins=function(t,e){if(t=String(t).toLowerCase(),!(t=this.typeToPluginIds_[t]))return[];var o=[],i,s;return e?(i=[],s=this.pluginData_,t.forEach(function(t){i.push(s[t])}),i.sort(function(t,e){return t.weight-e.weight}),i.forEach(function(t){o.push(t.plugin)})):(s=this.pluginData_,t.forEach(function(t){o.push(s[t].plugin)})),o},I.PluginManager.Type=function(t){this.name_=t},I.PluginManager.Type.prototype.toString=function(){return this.name_},I.PluginManager.Type.POSITIONABLE=new I.PluginManager.Type("positionable"),I.ThemeManager=function(t,e){this.workspace_=t,this.theme_=e,this.subscribedWorkspaces_=[],this.componentDB_=Object.create(null)},I.ThemeManager.prototype.getTheme=function(){return this.theme_},I.ThemeManager.prototype.setTheme=function(t){var e=this.theme_,o;for(this.theme_=t,(t=this.workspace_.getInjectionDiv())&&(e&&I.utils.dom.removeClass(t,e.getClassName()),I.utils.dom.addClass(t,this.theme_.getClassName())),e=0;t=this.subscribedWorkspaces_[e];e++)t.refreshTheme();for(e=0,t=Object.keys(this.componentDB_);o=t[e];e++)for(var i=0,s;s=this.componentDB_[o][i];i++){var n=s.element,s=s.propertyName,r=this.theme_&&this.theme_.getComponentStyle(o);n.style[s]=r||""}I.hideChaff()},I.ThemeManager.prototype.subscribeWorkspace=function(t){this.subscribedWorkspaces_.push(t)},I.ThemeManager.prototype.unsubscribeWorkspace=function(t){if((t=this.subscribedWorkspaces_.indexOf(t))<0)throw Error("Cannot unsubscribe a workspace that hasn't been subscribed.");this.subscribedWorkspaces_.splice(t,1)},I.ThemeManager.prototype.subscribe=function(t,e,o){this.componentDB_[e]||(this.componentDB_[e]=[]),this.componentDB_[e].push({element:t,propertyName:o}),e=this.theme_&&this.theme_.getComponentStyle(e),t.style[o]=e||""},I.ThemeManager.prototype.unsubscribe=function(t){if(t)for(var e=Object.keys(this.componentDB_),o=0,i;i=e[o];o++){for(var s=this.componentDB_[i],n=s.length-1;0<=n;n--)s[n].element===t&&s.splice(n,1);this.componentDB_[i].length||delete this.componentDB_[i]}},I.ThemeManager.prototype.dispose=function(){this.componentDB_=this.subscribedWorkspaces_=this.theme_=this.owner_=null},I.TouchGesture=function(t,e){I.TouchGesture.superClass_.constructor.call(this,t,e),this.isMultiTouch_=!1,this.cachedPoints_=Object.create(null),this.startDistance_=this.previousScale_=0,this.isPinchZoomEnabled_=this.onStartWrapper_=null},I.utils.object.inherits(I.TouchGesture,I.Gesture),I.TouchGesture.ZOOM_IN_MULTIPLIER=5,I.TouchGesture.ZOOM_OUT_MULTIPLIER=6,I.TouchGesture.prototype.doStart=function(t){this.isPinchZoomEnabled_=this.startWorkspace_.options.zoomOptions&&this.startWorkspace_.options.zoomOptions.pinch,I.TouchGesture.superClass_.doStart.call(this,t),!this.isEnding_&&I.Touch.isTouchEvent(t)&&this.handleTouchStart(t)},I.TouchGesture.prototype.bindMouseEvents=function(t){this.onStartWrapper_=I.browserEvents.conditionalBind(document,"mousedown",null,this.handleStart.bind(this),!0),this.onMoveWrapper_=I.browserEvents.conditionalBind(document,"mousemove",null,this.handleMove.bind(this),!0),this.onUpWrapper_=I.browserEvents.conditionalBind(document,"mouseup",null,this.handleUp.bind(this),!0),t.preventDefault(),t.stopPropagation()},I.TouchGesture.prototype.handleStart=function(t){!this.isDragging()&&I.Touch.isTouchEvent(t)&&(this.handleTouchStart(t),this.isMultiTouch()&&I.longStop_())},I.TouchGesture.prototype.handleMove=function(t){this.isDragging()?I.Touch.shouldHandleEvent(t)&&I.TouchGesture.superClass_.handleMove.call(this,t):this.isMultiTouch()?(I.Touch.isTouchEvent(t)&&this.handleTouchMove(t),I.longStop_()):I.TouchGesture.superClass_.handleMove.call(this,t)},I.TouchGesture.prototype.handleUp=function(t){I.Touch.isTouchEvent(t)&&!this.isDragging()&&this.handleTouchEnd(t),!this.isMultiTouch()||this.isDragging()?I.Touch.shouldHandleEvent(t)&&I.TouchGesture.superClass_.handleUp.call(this,t):(t.preventDefault(),t.stopPropagation(),this.dispose())},I.TouchGesture.prototype.isMultiTouch=function(){return this.isMultiTouch_},I.TouchGesture.prototype.dispose=function(){I.TouchGesture.superClass_.dispose.call(this),this.onStartWrapper_&&I.browserEvents.unbind(this.onStartWrapper_)},I.TouchGesture.prototype.handleTouchStart=function(t){var e=I.Touch.getTouchIdentifierFromEvent(t);this.cachedPoints_[e]=this.getTouchPoint(t),2==(e=Object.keys(this.cachedPoints_)).length&&(this.startDistance_=I.utils.Coordinate.distance(this.cachedPoints_[e[0]],this.cachedPoints_[e[1]]),this.isMultiTouch_=!0,t.preventDefault())},I.TouchGesture.prototype.handleTouchMove=function(t){var e=I.Touch.getTouchIdentifierFromEvent(t);this.cachedPoints_[e]=this.getTouchPoint(t),e=Object.keys(this.cachedPoints_),this.isPinchZoomEnabled_&&2===e.length?this.handlePinch_(t):I.TouchGesture.superClass_.handleMove.call(this,t)},I.TouchGesture.prototype.handlePinch_=function(t){var e=Object.keys(this.cachedPoints_),o,o,i,s,e=I.utils.Coordinate.distance(this.cachedPoints_[e[0]],this.cachedPoints_[e[1]])/this.startDistance_;0<this.previousScale_&&1/0>this.previousScale_&&(o=0<(o=e-this.previousScale_)?o*I.TouchGesture.ZOOM_IN_MULTIPLIER:o*I.TouchGesture.ZOOM_OUT_MULTIPLIER,i=this.startWorkspace_,s=I.utils.mouseToSvg(t,i.getParentSvg(),i.getInverseScreenCTM()),i.zoom(s.x,s.y,o)),this.previousScale_=e,t.preventDefault()},I.TouchGesture.prototype.handleTouchEnd=function(t){t=I.Touch.getTouchIdentifierFromEvent(t),this.cachedPoints_[t]&&delete this.cachedPoints_[t],Object.keys(this.cachedPoints_).length<2&&(this.cachedPoints_=Object.create(null),this.previousScale_=0)},I.TouchGesture.prototype.getTouchPoint=function(t){return this.startWorkspace_?new I.utils.Coordinate(t.pageX||t.changedTouches[0].pageX,t.pageY||t.changedTouches[0].pageY):null},I.WorkspaceAudio=function(t){this.parentWorkspace_=t,this.SOUNDS_=Object.create(null)},I.WorkspaceAudio.prototype.lastSound_=null,I.WorkspaceAudio.prototype.dispose=function(){this.SOUNDS_=this.parentWorkspace_=null},I.WorkspaceAudio.prototype.load=function(t,e){if(t.length){try{var o=new I.utils.global.Audio}catch(t){return}for(var i,s=0;s<t.length;s++){var n=t[s],r=n.match(/\.(\w+)$/);if(r&&o.canPlayType("audio/"+r[1])){i=new I.utils.global.Audio(n);break}}i&&i.play&&(this.SOUNDS_[e]=i)}},I.WorkspaceAudio.prototype.preload=function(){for(var t in this.SOUNDS_){var e=this.SOUNDS_[t];e.volume=.01;var t=e.play();if(void 0!==t?t.then(e.pause).catch(function(){}):e.pause(),I.utils.userAgent.IPAD||I.utils.userAgent.IPHONE)break}},I.WorkspaceAudio.prototype.play=function(t,e){var o=this.SOUNDS_[t];o?(t=new Date,null!=this.lastSound_&&t-this.lastSound_<I.SOUND_LIMIT||(this.lastSound_=t,(o=I.utils.userAgent.IPAD||I.utils.userAgent.ANDROID?o:o.cloneNode()).volume=void 0===e?1:e,o.play())):this.parentWorkspace_&&this.parentWorkspace_.getAudioManager().play(t,e)},I.WorkspaceSvg=function(t,e,o){I.WorkspaceSvg.superClass_.constructor.call(this,t),this.metricsManager_=new(I.registry.getClassFromOptions(I.registry.Type.METRICS_MANAGER,t,!0))(this),this.getMetrics=t.getMetrics||this.metricsManager_.getMetrics.bind(this.metricsManager_),this.setMetrics=t.setMetrics||I.WorkspaceSvg.setTopLevelWorkspaceMetrics_,this.pluginManager_=new I.PluginManager,this.connectionDBList=I.ConnectionDB.init(this.connectionChecker),e&&(this.blockDragSurface_=e),o&&(this.workspaceDragSurface_=o),this.useWorkspaceDragSurface_=!!this.workspaceDragSurface_&&I.utils.is3dSupported(),this.highlightedBlocks_=[],this.audioManager_=new I.WorkspaceAudio(t.parentWorkspace),this.grid_=this.options.gridPattern?new I.Grid(this.options.gridPattern,t.gridOptions):null,this.markerManager_=new I.MarkerManager(this),this.toolboxCategoryCallbacks_={},this.flyoutButtonCallbacks_={},I.Variables&&I.Variables.flyoutCategory&&this.registerToolboxCategoryCallback(I.VARIABLE_CATEGORY_NAME,I.Variables.flyoutCategory),I.VariablesDynamic&&I.VariablesDynamic.flyoutCategory&&this.registerToolboxCategoryCallback(I.VARIABLE_DYNAMIC_CATEGORY_NAME,I.VariablesDynamic.flyoutCategory),I.Procedures&&I.Procedures.flyoutCategory&&(this.registerToolboxCategoryCallback(I.PROCEDURE_CATEGORY_NAME,I.Procedures.flyoutCategory),this.addChangeListener(I.Procedures.mutatorOpenListener)),this.themeManager_=this.options.parentWorkspace?this.options.parentWorkspace.getThemeManager():new I.ThemeManager(this,this.options.theme||I.Themes.Classic),this.themeManager_.subscribeWorkspace(this),this.renderer_=I.blockRendering.init(this.options.renderer||"geras",this.getTheme(),this.options.rendererOverrides),this.cachedParentSvg_=null,this.keyboardAccessibilityMode=!1,this.topBoundedElements_=[],this.cachedParentSvgSize_=new I.utils.Size(0,0)},I.utils.object.inherits(I.WorkspaceSvg,I.Workspace),I.WorkspaceSvg.prototype.resizeHandlerWrapper_=null,I.WorkspaceSvg.prototype.rendered=!0,I.WorkspaceSvg.prototype.isVisible_=!0,I.WorkspaceSvg.prototype.isFlyout=!1,I.WorkspaceSvg.prototype.isMutator=!1,I.WorkspaceSvg.prototype.resizesEnabled_=!0,I.WorkspaceSvg.prototype.scrollX=0,I.WorkspaceSvg.prototype.scrollY=0,I.WorkspaceSvg.prototype.startScrollX=0,I.WorkspaceSvg.prototype.startScrollY=0,I.WorkspaceSvg.prototype.dragDeltaXY_=null,I.WorkspaceSvg.prototype.scale=1,I.WorkspaceSvg.prototype.oldScale_=1,I.WorkspaceSvg.prototype.oldTop_=0,I.WorkspaceSvg.prototype.oldLeft_=0,I.WorkspaceSvg.prototype.trashcan=null,I.WorkspaceSvg.prototype.scrollbar=null,I.WorkspaceSvg.prototype.flyout_=null,I.WorkspaceSvg.prototype.toolbox_=null,I.WorkspaceSvg.prototype.currentGesture_=null,I.WorkspaceSvg.prototype.blockDragSurface_=null,I.WorkspaceSvg.prototype.workspaceDragSurface_=null,I.WorkspaceSvg.prototype.useWorkspaceDragSurface_=!1,I.WorkspaceSvg.prototype.isDragSurfaceActive_=!1,I.WorkspaceSvg.prototype.injectionDiv_=null,I.WorkspaceSvg.prototype.lastRecordedPageScroll_=null,I.WorkspaceSvg.prototype.targetWorkspace=null,I.WorkspaceSvg.prototype.inverseScreenCTM_=null,I.WorkspaceSvg.prototype.inverseScreenCTMDirty_=!0,I.WorkspaceSvg.prototype.getMarkerManager=function(){return this.markerManager_},I.WorkspaceSvg.prototype.getMetricsManager=function(){return this.metricsManager_},I.WorkspaceSvg.prototype.setMetricsManager=function(t){this.metricsManager_=t,this.getMetrics=this.metricsManager_.getMetrics.bind(this.metricsManager_)},I.WorkspaceSvg.prototype.getPluginManager=function(){return this.pluginManager_},I.WorkspaceSvg.prototype.setCursorSvg=function(t){this.markerManager_.setCursorSvg(t)},I.WorkspaceSvg.prototype.setMarkerSvg=function(t){this.markerManager_.setMarkerSvg(t)},I.WorkspaceSvg.prototype.getMarker=function(t){return this.markerManager_?this.markerManager_.getMarker(t):null},I.WorkspaceSvg.prototype.getCursor=function(){return this.markerManager_?this.markerManager_.getCursor():null},I.WorkspaceSvg.prototype.getRenderer=function(){return this.renderer_},I.WorkspaceSvg.prototype.getThemeManager=function(){return this.themeManager_},I.WorkspaceSvg.prototype.getTheme=function(){return this.themeManager_.getTheme()},I.WorkspaceSvg.prototype.setTheme=function(t){t=t||I.Themes.Classic,this.themeManager_.setTheme(t)},I.WorkspaceSvg.prototype.refreshTheme=function(){this.svgGroup_&&this.renderer_.refreshDom(this.svgGroup_,this.getTheme()),this.updateBlockStyles_(this.getAllBlocks(!1).filter(function(t){return void 0!==t.getStyleName()})),this.refreshToolboxSelection(),this.toolbox_&&this.toolbox_.refreshTheme(),this.isVisible()&&this.setVisible(!0);var t=new(I.Events.get(I.Events.THEME_CHANGE))(this.getTheme().name,this.id);I.Events.fire(t)},I.WorkspaceSvg.prototype.updateBlockStyles_=function(t){for(var e=0,o;o=t[e];e++){var i=o.getStyleName();i&&(o.setStyle(i),o.mutator&&o.mutator.updateBlockStyle())}},I.WorkspaceSvg.prototype.getInverseScreenCTM=function(){var t;return!this.inverseScreenCTMDirty_||(t=this.getParentSvg().getScreenCTM())&&(this.inverseScreenCTM_=t.inverse(),this.inverseScreenCTMDirty_=!1),this.inverseScreenCTM_},I.WorkspaceSvg.prototype.updateInverseScreenCTM=function(){this.inverseScreenCTMDirty_=!0},I.WorkspaceSvg.prototype.isVisible=function(){return this.isVisible_},I.WorkspaceSvg.prototype.getSvgXY=function(t){var e=0,o=0,i=1;(I.utils.dom.containsNode(this.getCanvas(),t)||I.utils.dom.containsNode(this.getBubbleCanvas(),t))&&(i=this.scale);do{var s=I.utils.getRelativeXY(t);t!=this.getCanvas()&&t!=this.getBubbleCanvas()||(i=1),e+=s.x*i,o+=s.y*i,t=t.parentNode}while(t&&t!=this.getParentSvg());return new I.utils.Coordinate(e,o)},I.WorkspaceSvg.prototype.getCachedParentSvgSize=function(){var t=this.cachedParentSvgSize_;return new I.utils.Size(t.width,t.height)},I.WorkspaceSvg.prototype.getOriginOffsetInPixels=function(){return I.utils.getInjectionDivXY_(this.getCanvas())},I.WorkspaceSvg.prototype.getInjectionDiv=function(){if(!this.injectionDiv_)for(var t=this.svgGroup_;t;){if(-1!=(" "+(t.getAttribute("class")||"")+" ").indexOf(" injectionDiv ")){this.injectionDiv_=t;break}t=t.parentNode}return this.injectionDiv_},I.WorkspaceSvg.prototype.getBlockCanvas=function(){return this.svgBlockCanvas_},I.WorkspaceSvg.prototype.setResizeHandlerWrapper=function(t){this.resizeHandlerWrapper_=t},I.WorkspaceSvg.prototype.createDom=function(t){return this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyWorkspace"},null),t&&(this.svgBackground_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{height:"100%",width:"100%",class:t},this.svgGroup_),"blocklyMainBackground"==t&&this.grid_?this.svgBackground_.style.fill="url(#"+this.grid_.getPatternId()+")":this.themeManager_.subscribe(this.svgBackground_,"workspaceBackgroundColour","fill")),this.svgBlockCanvas_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyBlockCanvas"},this.svgGroup_),this.svgBubbleCanvas_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyBubbleCanvas"},this.svgGroup_),this.isFlyout||(I.browserEvents.conditionalBind(this.svgGroup_,"mousedown",this,this.onMouseDown_,!1,!0),I.browserEvents.conditionalBind(this.svgGroup_,"wheel",this,this.onMouseWheel_)),this.options.hasCategories&&(this.toolbox_=new(I.registry.getClassFromOptions(I.registry.Type.TOOLBOX,this.options,!0))(this)),this.grid_&&this.grid_.update(this.scale),this.recordDeleteAreas(),(t=I.registry.getClassFromOptions(I.registry.Type.CURSOR,this.options))&&this.markerManager_.setCursor(new t),this.renderer_.createDom(this.svgGroup_,this.getTheme()),this.svgGroup_},I.WorkspaceSvg.prototype.dispose=function(){var t;this.rendered=!1,this.currentGesture_&&this.currentGesture_.cancel(),this.svgGroup_&&(I.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.svgBubbleCanvas_=this.svgBlockCanvas_=null,this.toolbox_&&(this.toolbox_.dispose(),this.toolbox_=null),this.flyout_&&(this.flyout_.dispose(),this.flyout_=null),this.trashcan&&(this.trashcan.dispose(),this.trashcan=null),this.scrollbar&&(this.scrollbar.dispose(),this.scrollbar=null),this.zoomControls_&&(this.zoomControls_.dispose(),this.zoomControls_=null),this.audioManager_&&(this.audioManager_.dispose(),this.audioManager_=null),this.grid_&&(this.grid_.dispose(),this.grid_=null),this.renderer_.dispose(),this.markerManager_&&(this.markerManager_.dispose(),this.markerManager_=null),I.WorkspaceSvg.superClass_.dispose.call(this),this.themeManager_&&(this.themeManager_.unsubscribeWorkspace(this),this.themeManager_.unsubscribe(this.svgBackground_),this.options.parentWorkspace||(this.themeManager_.dispose(),this.themeManager_=null)),this.flyoutButtonCallbacks_=this.toolboxCategoryCallbacks_=this.connectionDBList=null,this.options.parentWorkspace||(t=this.getParentSvg())&&t.parentNode&&I.utils.dom.removeNode(t.parentNode),this.resizeHandlerWrapper_&&(I.browserEvents.unbind(this.resizeHandlerWrapper_),this.resizeHandlerWrapper_=null)},I.WorkspaceSvg.prototype.newBlock=function(t,e){return new I.BlockSvg(this,t,e)},I.WorkspaceSvg.prototype.addTrashcan=function(){if(!I.Trashcan)throw Error("Missing require for Blockly.Trashcan");this.trashcan=new I.Trashcan(this);var t=this.trashcan.createDom();this.svgGroup_.insertBefore(t,this.svgBlockCanvas_),this.pluginManager_.addPlugin({id:"trashcan",plugin:this.trashcan,weight:1,types:[I.PluginManager.Type.POSITIONABLE]})},I.WorkspaceSvg.prototype.addZoomControls=function(){if(!I.ZoomControls)throw Error("Missing require for Blockly.ZoomControls");this.zoomControls_=new I.ZoomControls(this);var t=this.zoomControls_.createDom();this.svgGroup_.appendChild(t),this.pluginManager_.addPlugin({id:"zoomControls",plugin:this.zoomControls_,weight:2,types:[I.PluginManager.Type.POSITIONABLE]})},I.WorkspaceSvg.prototype.addFlyout=function(t){var e=new I.Options({parentWorkspace:this,rtl:this.RTL,oneBasedIndex:this.options.oneBasedIndex,horizontalLayout:this.horizontalLayout,renderer:this.options.renderer,rendererOverrides:this.options.rendererOverrides,move:{scrollbars:!0}});return e.toolboxPosition=this.options.toolboxPosition,this.flyout_=new(this.horizontalLayout?I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,this.options,!0):I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,this.options,!0))(e),this.flyout_.autoClose=!1,this.flyout_.getWorkspace().setVisible(!0),this.flyout_.createDom(t)},I.WorkspaceSvg.prototype.getFlyout=function(t){return this.flyout_||t?this.flyout_:this.toolbox_?this.toolbox_.getFlyout():null},I.WorkspaceSvg.prototype.getToolbox=function(){return this.toolbox_},I.WorkspaceSvg.prototype.updateScreenCalculations_=function(){this.updateInverseScreenCTM(),this.recordDeleteAreas()},I.WorkspaceSvg.prototype.resizeContents=function(){this.resizesEnabled_&&this.rendered&&(this.scrollbar&&this.scrollbar.resize(),this.updateInverseScreenCTM())},I.WorkspaceSvg.prototype.resize=function(){this.toolbox_&&this.toolbox_.position(),this.flyout_&&this.flyout_.position();for(var t=this.pluginManager_.getPlugins(I.PluginManager.Type.POSITIONABLE,!0),e=this.getMetricsManager().getUiMetrics(),o=[],i=0,s;s=t[i];i++)s.position(e,o),o.push(s.getBoundingRectangle());this.scrollbar&&this.scrollbar.resize(),this.updateScreenCalculations_()},I.WorkspaceSvg.prototype.updateScreenCalculationsIfScrolled=function(){var t=I.utils.getDocumentScroll();I.utils.Coordinate.equals(this.lastRecordedPageScroll_,t)||(this.lastRecordedPageScroll_=t,this.updateScreenCalculations_())},I.WorkspaceSvg.prototype.getCanvas=function(){return this.svgBlockCanvas_},I.WorkspaceSvg.prototype.setCachedParentSvgSize=function(t,e){var o=this.getParentSvg();t&&(this.cachedParentSvgSize_.width=t,o.cachedWidth_=t),e&&(this.cachedParentSvgSize_.height=e,o.cachedHeight_=e)},I.WorkspaceSvg.prototype.getBubbleCanvas=function(){return this.svgBubbleCanvas_},I.WorkspaceSvg.prototype.getParentSvg=function(){if(!this.cachedParentSvg_)for(var t=this.svgGroup_;t;){if("svg"==t.tagName){this.cachedParentSvg_=t;break}t=t.parentNode}return this.cachedParentSvg_},I.WorkspaceSvg.prototype.maybeFireViewportChangeEvent=function(){var t,e,o,i;I.Events.isEnabled()&&(t=this.scale,e=-this.scrollY,o=-this.scrollX,t==this.oldScale_&&Math.abs(e-this.oldTop_)<1&&Math.abs(o-this.oldLeft_)<1||(i=new(I.Events.get(I.Events.VIEWPORT_CHANGE))(e,o,t,this.id,this.oldScale_),this.oldScale_=t,this.oldTop_=e,this.oldLeft_=o,I.Events.fire(i)))},I.WorkspaceSvg.prototype.translate=function(t,e){var o;this.useWorkspaceDragSurface_&&this.isDragSurfaceActive_?this.workspaceDragSurface_.translateSurface(t,e):(o="translate("+t+","+e+") scale("+this.scale+")",this.svgBlockCanvas_.setAttribute("transform",o),this.svgBubbleCanvas_.setAttribute("transform",o)),this.blockDragSurface_&&this.blockDragSurface_.translateAndScaleGroup(t,e,this.scale),this.grid_&&this.grid_.moveTo(t,e),this.maybeFireViewportChangeEvent()},I.WorkspaceSvg.prototype.resetDragSurface=function(){var t;this.useWorkspaceDragSurface_&&(this.isDragSurfaceActive_=!1,t=this.workspaceDragSurface_.getSurfaceTranslation(),this.workspaceDragSurface_.clearAndHide(this.svgGroup_),t="translate("+t.x+","+t.y+") scale("+this.scale+")",this.svgBlockCanvas_.setAttribute("transform",t),this.svgBubbleCanvas_.setAttribute("transform",t))},I.WorkspaceSvg.prototype.setupDragSurface=function(){var t,e,o,i;this.useWorkspaceDragSurface_&&!this.isDragSurfaceActive_&&(this.isDragSurfaceActive_=!0,t=this.svgBlockCanvas_.previousSibling,e=parseInt(this.getParentSvg().getAttribute("width"),10),o=parseInt(this.getParentSvg().getAttribute("height"),10),i=I.utils.getRelativeXY(this.getCanvas()),this.workspaceDragSurface_.setContentsAndShow(this.getCanvas(),this.getBubbleCanvas(),t,e,o,this.scale),this.workspaceDragSurface_.translateSurface(i.x,i.y))},I.WorkspaceSvg.prototype.getBlockDragSurface=function(){return this.blockDragSurface_},I.WorkspaceSvg.prototype.getWidth=function(){var t=this.getMetrics();return t?t.viewWidth/this.scale:0},I.WorkspaceSvg.prototype.setVisible=function(t){if(this.isVisible_=t,this.svgGroup_)if(this.scrollbar&&this.scrollbar.setContainerVisible(t),this.getFlyout()&&this.getFlyout().setContainerVisible(t),this.getParentSvg().style.display=t?"block":"none",this.toolbox_&&this.toolbox_.setVisible(t),t){for(var e=(t=this.getAllBlocks(!1)).length-1;0<=e;e--)t[e].markDirty();this.render(),this.toolbox_&&this.toolbox_.position()}else I.hideChaff(!0)},I.WorkspaceSvg.prototype.render=function(){for(var t=this.getAllBlocks(!1),e=t.length-1;0<=e;e--)t[e].render(!1);if(this.currentGesture_)for(t=this.currentGesture_.getInsertionMarkers(),e=0;e<t.length;e++)t[e].render(!1);this.markerManager_.updateMarkers()},I.WorkspaceSvg.prototype.highlightBlock=function(t,e){if(void 0===e){for(var o=0,i;i=this.highlightedBlocks_[o];o++)i.setHighlighted(!1);this.highlightedBlocks_.length=0}(i=t?this.getBlockById(t):null)&&((t=void 0===e||e)?-1==this.highlightedBlocks_.indexOf(i)&&this.highlightedBlocks_.push(i):I.utils.arrayRemove(this.highlightedBlocks_,i),i.setHighlighted(t))},I.WorkspaceSvg.prototype.paste=function(t){!this.rendered||!t.tagName||t.getElementsByTagName("block").length>=this.remainingCapacity()||(this.currentGesture_&&this.currentGesture_.cancel(),"comment"==t.tagName.toLowerCase()?this.pasteWorkspaceComment_(t):this.pasteBlock_(t))},I.WorkspaceSvg.prototype.pasteBlock_=function(t){I.Events.disable();try{var e=I.Xml.domToBlock(t,this),o=parseInt(t.getAttribute("x"),10),i=parseInt(t.getAttribute("y"),10);if(!isNaN(o)&&!isNaN(i)){this.RTL&&(o=-o);do{t=!1;for(var s=this.getAllBlocks(!1),n=0,r;r=s[n];n++){var l=r.getRelativeToSurfaceXY();if(Math.abs(o-l.x)<=1&&Math.abs(i-l.y)<=1){t=!0;break}}if(!t)for(var a=e.getConnections_(!1),n=0,c;c=a[n];n++)if(c.closest(I.SNAP_RADIUS,new I.utils.Coordinate(o,i)).connection){t=!0;break}t&&(o=this.RTL?o-I.SNAP_RADIUS:o+I.SNAP_RADIUS,i+=2*I.SNAP_RADIUS)}while(t);e.moveBy(o,i)}}finally{I.Events.enable()}I.Events.isEnabled()&&!e.isShadow()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CREATE))(e)),e.select()},I.WorkspaceSvg.prototype.pasteWorkspaceComment_=function(t){I.Events.disable();try{var e=I.WorkspaceCommentSvg.fromXml(t,this),o=parseInt(t.getAttribute("x"),10),i=parseInt(t.getAttribute("y"),10);isNaN(o)||isNaN(i)||(this.RTL&&(o=-o),e.moveBy(o+50,i+50))}finally{I.Events.enable()}I.Events.isEnabled()&&I.WorkspaceComment.fireCreateEvent(e),e.select()},I.WorkspaceSvg.prototype.refreshToolboxSelection=function(){var t=this.isFlyout?this.targetWorkspace:this;t&&!t.currentGesture_&&t.toolbox_&&t.toolbox_.getFlyout()&&t.toolbox_.refreshSelection()},I.WorkspaceSvg.prototype.renameVariableById=function(t,e){I.WorkspaceSvg.superClass_.renameVariableById.call(this,t,e),this.refreshToolboxSelection()},I.WorkspaceSvg.prototype.deleteVariableById=function(t){I.WorkspaceSvg.superClass_.deleteVariableById.call(this,t),this.refreshToolboxSelection()},I.WorkspaceSvg.prototype.createVariable=function(t,e,o){return t=I.WorkspaceSvg.superClass_.createVariable.call(this,t,e,o),this.refreshToolboxSelection(),t},I.WorkspaceSvg.prototype.recordDeleteAreas=function(){this.deleteAreaTrash_=this.trashcan&&this.svgGroup_.parentNode?this.trashcan.getClientRect():null,this.deleteAreaToolbox_=this.flyout_?this.flyout_.getClientRect():this.toolbox_&&"function"==typeof this.toolbox_.getClientRect?this.toolbox_.getClientRect():null},I.WorkspaceSvg.prototype.isDeleteArea=function(t){return this.deleteAreaTrash_&&this.deleteAreaTrash_.contains(t.clientX,t.clientY)?I.DELETE_AREA_TRASH:this.deleteAreaToolbox_&&this.deleteAreaToolbox_.contains(t.clientX,t.clientY)?I.DELETE_AREA_TOOLBOX:I.DELETE_AREA_NONE},I.WorkspaceSvg.prototype.onMouseDown_=function(t){var e=this.getGesture(t);e&&e.handleWsStart(t,this)},I.WorkspaceSvg.prototype.startDrag=function(t,e){(t=I.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM())).x/=this.scale,t.y/=this.scale,this.dragDeltaXY_=I.utils.Coordinate.difference(e,t)},I.WorkspaceSvg.prototype.moveDrag=function(t){return(t=I.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM())).x/=this.scale,t.y/=this.scale,I.utils.Coordinate.sum(this.dragDeltaXY_,t)},I.WorkspaceSvg.prototype.isDragging=function(){return null!=this.currentGesture_&&this.currentGesture_.isDragging()},I.WorkspaceSvg.prototype.isDraggable=function(){return this.options.moveOptions&&this.options.moveOptions.drag},I.WorkspaceSvg.prototype.isMovable=function(){
return this.options.moveOptions&&!!this.options.moveOptions.scrollbars||this.options.moveOptions&&this.options.moveOptions.wheel||this.options.moveOptions&&this.options.moveOptions.drag||this.options.zoomOptions&&this.options.zoomOptions.wheel||this.options.zoomOptions&&this.options.zoomOptions.pinch},I.WorkspaceSvg.prototype.isMovableHorizontally=function(){var t=!!this.scrollbar;return this.isMovable()&&(!t||t&&this.scrollbar.canScrollHorizontally())},I.WorkspaceSvg.prototype.isMovableVertically=function(){var t=!!this.scrollbar;return this.isMovable()&&(!t||t&&this.scrollbar.canScrollVertically())},I.WorkspaceSvg.prototype.onMouseWheel_=function(t){var e,o,i;I.Gesture.inProgress()?(t.preventDefault(),t.stopPropagation()):(e=this.options.zoomOptions&&this.options.zoomOptions.wheel,o=this.options.moveOptions&&this.options.moveOptions.wheel,(e||o)&&(i=I.utils.getScrollDeltaPixels(t),!e||!t.ctrlKey&&o?(e=this.scrollX-i.x,o=this.scrollY-i.y,t.shiftKey&&!i.x&&(e=this.scrollX-i.y,o=this.scrollY),this.scroll(e,o)):(i=-i.y/50,e=I.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM()),this.zoom(e.x,e.y,i)),t.preventDefault()))},I.WorkspaceSvg.prototype.getBlocksBoundingBox=function(){var t=this.getTopBoundedElements();if(!t.length)return new I.utils.Rect(0,0,0,0);for(var e=t[0].getBoundingRectangle(),o=1;o<t.length;o++){var i=t[o];i.isInsertionMarker&&i.isInsertionMarker()||((i=i.getBoundingRectangle()).top<e.top&&(e.top=i.top),i.bottom>e.bottom&&(e.bottom=i.bottom),i.left<e.left&&(e.left=i.left),i.right>e.right&&(e.right=i.right))}return e},I.WorkspaceSvg.prototype.cleanUp=function(){this.setResizesEnabled(!1),I.Events.setGroup(!0);for(var t=this.getTopBlocks(!0),e=0,o=0,i,s;i=t[o];o++){i.isMovable()&&(s=i.getRelativeToSurfaceXY(),i.moveBy(-s.x,e-s.y),i.snapToGrid(),e=i.getRelativeToSurfaceXY().y+i.getHeightWidth().height+this.renderer_.getConstants().MIN_BLOCK_HEIGHT)}I.Events.setGroup(!1),this.setResizesEnabled(!0)},I.WorkspaceSvg.prototype.showContextMenu=function(t){var e;this.options.readOnly||this.isFlyout||(e=I.ContextMenuRegistry.registry.getContextMenuOptions(I.ContextMenuRegistry.ScopeType.WORKSPACE,{workspace:this}),this.configureContextMenu&&this.configureContextMenu(e,t),I.ContextMenu.show(t,e,this.RTL))},I.WorkspaceSvg.prototype.updateToolbox=function(t){if(t=I.utils.toolbox.convertToolboxDefToJson(t)){if(!this.options.languageTree)throw Error("Existing toolbox is null.  Can't create new toolbox.");if(I.utils.toolbox.hasCategories(t)){if(!this.toolbox_)throw Error("Existing toolbox has no categories.  Can't change mode.");this.options.languageTree=t,this.toolbox_.render(t)}else{if(!this.flyout_)throw Error("Existing toolbox has categories.  Can't change mode.");this.options.languageTree=t,this.flyout_.show(t)}}else if(this.options.languageTree)throw Error("Can't nullify an existing toolbox.")},I.WorkspaceSvg.prototype.markFocused=function(){this.options.parentWorkspace?this.options.parentWorkspace.markFocused():(I.mainWorkspace=this).setBrowserFocus()},I.WorkspaceSvg.prototype.setBrowserFocus=function(){document.activeElement&&document.activeElement.blur&&document.activeElement.blur();try{this.getParentSvg().focus({preventScroll:!0})}catch(t){try{this.getParentSvg().parentNode.setActive()}catch(t){this.getParentSvg().parentNode.focus({preventScroll:!0})}}},I.WorkspaceSvg.prototype.zoom=function(t,e,o){o=Math.pow(this.options.zoomOptions.scaleSpeed,o);var i=this.scale*o,s,n;this.scale!=i&&(i>this.options.zoomOptions.maxScale?o=this.options.zoomOptions.maxScale/this.scale:i<this.options.zoomOptions.minScale&&(o=this.options.zoomOptions.minScale/this.scale),s=this.getCanvas().getCTM(),(n=this.getParentSvg().createSVGPoint()).x=t,n.y=e,t=(n=n.matrixTransform(s.inverse())).x,e=n.y,s=s.translate(t*(1-o),e*(1-o)).scale(o),this.scrollX=s.e,this.scrollY=s.f,this.setScale(i))},I.WorkspaceSvg.prototype.zoomCenter=function(t){var e=this.getMetrics(),o,e;e=this.flyout_?(o=e.svgWidth?e.svgWidth/2:0,e.svgHeight?e.svgHeight/2:0):(o=e.viewWidth/2+e.absoluteLeft,e.viewHeight/2+e.absoluteTop),this.zoom(o,e,t)},I.WorkspaceSvg.prototype.zoomToFit=function(){if(this.isMovable()){var t,e=(t=this.getMetrics()).viewWidth,t=t.viewHeight,o,i=(o=this.getBlocksBoundingBox()).right-o.left,o=o.bottom-o.top;if(i){this.flyout_&&(this.horizontalLayout?(t+=this.flyout_.getHeight(),o+=this.flyout_.getHeight()/this.scale):(e+=this.flyout_.getWidth(),i+=this.flyout_.getWidth()/this.scale)),e/=i,t/=o,I.Events.disable();try{this.setScale(Math.min(e,t)),this.scrollCenter()}finally{I.Events.enable()}this.maybeFireViewportChangeEvent()}}else console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},I.WorkspaceSvg.prototype.beginCanvasTransition=function(){I.utils.dom.addClass(this.svgBlockCanvas_,"blocklyCanvasTransitioning"),I.utils.dom.addClass(this.svgBubbleCanvas_,"blocklyCanvasTransitioning")},I.WorkspaceSvg.prototype.endCanvasTransition=function(){I.utils.dom.removeClass(this.svgBlockCanvas_,"blocklyCanvasTransitioning"),I.utils.dom.removeClass(this.svgBubbleCanvas_,"blocklyCanvasTransitioning")},I.WorkspaceSvg.prototype.scrollCenter=function(){var t,e,o,e,o;this.isMovable()?(e=((t=this.getMetrics()).scrollWidth-t.viewWidth)/2,o=(t.scrollHeight-t.viewHeight)/2,e=-e-t.scrollLeft,o=-o-t.scrollTop,this.scroll(e,o)):console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},I.WorkspaceSvg.prototype.centerOnBlock=function(t){var e,o,i;this.isMovable()?(t=t?this.getBlockById(t):null)&&(e=t.getRelativeToSurfaceXY(),o=t.getHeightWidth(),i=this.scale,t=(e.x+(this.RTL?-1:1)*o.width/2)*i,e=(e.y+o.height/2)*i,o=this.getMetrics(),this.scroll(-(t-o.viewWidth/2),-(e-o.viewHeight/2))):console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},I.WorkspaceSvg.prototype.setScale=function(t){this.options.zoomOptions.maxScale&&t>this.options.zoomOptions.maxScale?t=this.options.zoomOptions.maxScale:this.options.zoomOptions.minScale&&t<this.options.zoomOptions.minScale&&(t=this.options.zoomOptions.minScale),this.scale=t,I.hideChaff(!1),this.flyout_&&(this.flyout_.reflow(),this.recordDeleteAreas()),this.grid_&&this.grid_.update(this.scale),t=this.getMetrics(),this.scrollX-=t.absoluteLeft,this.scrollY-=t.absoluteTop,t.viewLeft+=t.absoluteLeft,t.viewTop+=t.absoluteTop,this.scroll(this.scrollX,this.scrollY),this.scrollbar&&(this.flyout_?this.scrollbar.resizeView(t):this.scrollbar.resizeContent(t))},I.WorkspaceSvg.prototype.getScale=function(){return this.options.parentWorkspace?this.options.parentWorkspace.getScale():this.scale},I.WorkspaceSvg.prototype.scroll=function(t,e){I.hideChaff(!0);var o=this.getMetrics();t=Math.min(t,-o.scrollLeft),e=Math.min(e,-o.scrollTop);var i=o.scrollTop+Math.max(0,o.scrollHeight-o.viewHeight);t=Math.max(t,-(o.scrollLeft+Math.max(0,o.scrollWidth-o.viewWidth))),e=Math.max(e,-i),this.scrollX=t,this.scrollY=e,this.scrollbar&&this.scrollbar.set(-(t+o.scrollLeft),-(e+o.scrollTop),!1),t+=o.absoluteLeft,e+=o.absoluteTop,this.translate(t,e)},I.WorkspaceSvg.setTopLevelWorkspaceMetrics_=function(t){var e=this.getMetrics();"number"==typeof t.x&&(this.scrollX=-(e.scrollLeft+(e.scrollWidth-e.viewWidth)*t.x)),"number"==typeof t.y&&(this.scrollY=-(e.scrollTop+(e.scrollHeight-e.viewHeight)*t.y)),this.translate(this.scrollX+e.absoluteLeft,this.scrollY+e.absoluteTop)},I.WorkspaceSvg.prototype.getBlockById=function(t){return I.WorkspaceSvg.superClass_.getBlockById.call(this,t)},I.WorkspaceSvg.prototype.getTopBlocks=function(t){return I.WorkspaceSvg.superClass_.getTopBlocks.call(this,t)},I.WorkspaceSvg.prototype.addTopBlock=function(t){this.addTopBoundedElement(t),I.WorkspaceSvg.superClass_.addTopBlock.call(this,t)},I.WorkspaceSvg.prototype.removeTopBlock=function(t){this.removeTopBoundedElement(t),I.WorkspaceSvg.superClass_.removeTopBlock.call(this,t)},I.WorkspaceSvg.prototype.addTopComment=function(t){this.addTopBoundedElement(t),I.WorkspaceSvg.superClass_.addTopComment.call(this,t)},I.WorkspaceSvg.prototype.removeTopComment=function(t){this.removeTopBoundedElement(t),I.WorkspaceSvg.superClass_.removeTopComment.call(this,t)},I.WorkspaceSvg.prototype.addTopBoundedElement=function(t){this.topBoundedElements_.push(t)},I.WorkspaceSvg.prototype.removeTopBoundedElement=function(t){I.utils.arrayRemove(this.topBoundedElements_,t)},I.WorkspaceSvg.prototype.getTopBoundedElements=function(){return[].concat(this.topBoundedElements_)},I.WorkspaceSvg.prototype.setResizesEnabled=function(t){var e=!this.resizesEnabled_&&t;this.resizesEnabled_=t,e&&this.resizeContents()},I.WorkspaceSvg.prototype.clear=function(){this.setResizesEnabled(!1),I.WorkspaceSvg.superClass_.clear.call(this),this.topBoundedElements_=[],this.setResizesEnabled(!0)},I.WorkspaceSvg.prototype.registerButtonCallback=function(t,e){if("function"!=typeof e)throw TypeError("Button callbacks must be functions.");this.flyoutButtonCallbacks_[t]=e},I.WorkspaceSvg.prototype.getButtonCallback=function(t){return(t=this.flyoutButtonCallbacks_[t])?t:null},I.WorkspaceSvg.prototype.removeButtonCallback=function(t){this.flyoutButtonCallbacks_[t]=null},I.WorkspaceSvg.prototype.registerToolboxCategoryCallback=function(t,e){if("function"!=typeof e)throw TypeError("Toolbox category callbacks must be functions.");this.toolboxCategoryCallbacks_[t]=e},I.WorkspaceSvg.prototype.getToolboxCategoryCallback=function(t){return this.toolboxCategoryCallbacks_[t]||null},I.WorkspaceSvg.prototype.removeToolboxCategoryCallback=function(t){this.toolboxCategoryCallbacks_[t]=null},I.WorkspaceSvg.prototype.getGesture=function(t){var e="mousedown"==t.type||"touchstart"==t.type||"pointerdown"==t.type,o=this.currentGesture_;return o?e&&o.hasStarted()?(console.warn("Tried to start the same gesture twice."),o.cancel(),null):o:e?this.currentGesture_=new I.TouchGesture(t,this):null},I.WorkspaceSvg.prototype.clearGesture=function(){this.currentGesture_=null},I.WorkspaceSvg.prototype.cancelCurrentGesture=function(){this.currentGesture_&&this.currentGesture_.cancel()},I.WorkspaceSvg.prototype.getAudioManager=function(){return this.audioManager_},I.WorkspaceSvg.prototype.getGrid=function(){return this.grid_},I.inject=function(t,e){if(I.checkBlockColourConstants(),!(t="string"==typeof t?document.getElementById(t)||document.querySelector(t):t)||!I.utils.dom.containsNode(document,t))throw Error("Error: container is not in current document.");e=new I.Options(e||{});var o=document.createElement("div");o.className="injectionDiv",o.tabIndex=0,I.utils.aria.setState(o,I.utils.aria.State.LABEL,I.Msg.WORKSPACE_ARIA_LABEL),t.appendChild(o),t=I.createDom_(o,e);var i=new I.BlockDragSurfaceSvg(o),s=new I.WorkspaceDragSurfaceSvg(o),n=I.createMainWorkspace_(t,e,i,s);return I.init_(n),I.mainWorkspace=n,I.svgResize(n),o.addEventListener("focusin",function(){I.mainWorkspace=n}),n},I.createDom_=function(t,e){t.setAttribute("dir","LTR"),I.Css.inject(e.hasCss,e.pathToMedia),t=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{xmlns:I.utils.dom.SVG_NS,"xmlns:html":I.utils.dom.HTML_NS,"xmlns:xlink":I.utils.dom.XLINK_NS,version:"1.1",class:"blocklySvg",tabindex:"0"},t);var o=I.utils.dom.createSvgElement(I.utils.Svg.DEFS,{},t),i=String(Math.random()).substring(2);return e.gridPattern=I.Grid.createDom(i,e.gridOptions,o),t},I.createMainWorkspace_=function(t,e,o,i){return e.parentWorkspace=null,o=(e=new I.WorkspaceSvg(e,o,i)).options,e.scale=o.zoomOptions.startScale,t.appendChild(e.createDom("blocklyMainBackground")),I.utils.dom.addClass(e.getInjectionDiv(),e.getRenderer().getClassName()),I.utils.dom.addClass(e.getInjectionDiv(),e.getTheme().getClassName()),!o.hasCategories&&o.languageTree&&(i=e.addFlyout(I.utils.Svg.SVG),I.utils.dom.insertAfter(i,t)),o.hasTrashcan&&e.addTrashcan(),o.zoomOptions&&o.zoomOptions.controls&&e.addZoomControls(),e.getThemeManager().subscribe(t,"workspaceBackgroundColour","background-color"),e.translate(0,0),e.addChangeListener(I.bumpIntoBoundsHandler_(e)),I.svgResize(e),I.WidgetDiv.createDom(),I.DropDownDiv.createDom(),I.Tooltip.createDom(),e},I.extractObjectFromEvent_=function(t,e){var o=null;switch(e.type){case I.Events.BLOCK_CREATE:case I.Events.BLOCK_MOVE:(o=t.getBlockById(e.blockId))&&(o=o.getRootBlock());break;case I.Events.COMMENT_CREATE:case I.Events.COMMENT_MOVE:o=t.getCommentById(e.commentId)}return o},I.bumpTopObjectsIntoBounds_=function(t){var e;if((e=t.getMetricsManager()).hasFixedEdges()&&!t.isDragging())for(var e=e.getScrollMetrics(!0),o=t.getTopBoundedElements(),i=0,s;s=o[i];i++)I.bumpObjectIntoBounds_(t,e,s)},I.bumpIntoBoundsHandler_=function(s){return function(t){var e=s.getMetricsManager(),e,o,i;e.hasFixedEdges&&!s.isDragging()&&(-1!==I.Events.BUMP_EVENTS.indexOf(t.type)?(e=e.getScrollMetrics(!0),(o=I.extractObjectFromEvent_(s,t))&&(i=I.Events.getGroup(),I.Events.setGroup(t.group),I.bumpObjectIntoBounds_(s,e,o)&&!t.group&&console.warn("Moved object in bounds but there was no event group. This may break undo."),null!==i&&I.Events.setGroup(i))):t.type===I.Events.VIEWPORT_CHANGE&&t.scale>t.oldScale&&I.bumpTopObjectsIntoBounds_(s))}},I.bumpObjectIntoBounds_=function(t,e,o){var i=o.getBoundingRectangle(),s=i.right-i.left,n=I.utils.math.clamp(e.top,i.top,e.top+e.height-(i.bottom-i.top))-i.top,r=e.left;return e=e.left+e.width-s,t.RTL?r=Math.min(e,r):e=Math.max(r,e),!(!(t=I.utils.math.clamp(r,i.left,e)-i.left)&&!n)&&(o.moveBy(t,n),!0)},I.init_=function(t){var e=t.options,o=t.getParentSvg(),o,i;I.browserEvents.conditionalBind(o.parentNode,"contextmenu",null,function(t){I.utils.isTargetInput(t)||t.preventDefault()}),o=I.browserEvents.conditionalBind(window,"resize",null,function(){I.hideChaff(!0),I.svgResize(t),I.bumpTopObjectsIntoBounds_(t)}),t.setResizeHandlerWrapper(o),I.inject.bindDocumentEvents_(),e.languageTree&&(o=t.getToolbox(),i=t.getFlyout(!0),o?o.init():i&&(i.init(t),i.show(e.languageTree),"function"==typeof i.scrollToStart&&i.scrollToStart())),o=I.Scrollbar.scrollbarThickness,e.hasTrashcan&&(o=t.trashcan.init(o)),e.zoomOptions&&e.zoomOptions.controls&&t.zoomControls_.init(o),e.moveOptions&&e.moveOptions.scrollbars?(t.scrollbar=new I.ScrollbarPair(t,!0===e.moveOptions.scrollbars||!!e.moveOptions.scrollbars.horizontal,!0===e.moveOptions.scrollbars||!!e.moveOptions.scrollbars.vertical,"blocklyMainWorkspaceScrollbar"),t.scrollbar.resize()):t.setMetrics({x:.5,y:.5}),e.hasSounds&&I.inject.loadSounds_(e.pathToMedia,t)},I.inject.bindDocumentEvents_=function(){I.documentEventsBound_||(I.browserEvents.conditionalBind(document,"scroll",null,function(){for(var t=I.Workspace.getAll(),e=0,o;o=t[e];e++)o.updateInverseScreenCTM&&o.updateInverseScreenCTM()}),I.browserEvents.conditionalBind(document,"keydown",null,I.onKeyDown),I.browserEvents.bind(document,"touchend",null,I.longStop_),I.browserEvents.bind(document,"touchcancel",null,I.longStop_),I.utils.userAgent.IPAD&&I.browserEvents.conditionalBind(window,"orientationchange",document,function(){I.svgResize(I.getMainWorkspace())})),I.documentEventsBound_=!0},I.inject.loadSounds_=function(t,e){var o=e.getAudioManager();o.load([t+"click.mp3",t+"click.wav",t+"click.ogg"],"click"),o.load([t+"disconnect.wav",t+"disconnect.mp3",t+"disconnect.ogg"],"disconnect"),o.load([t+"delete.mp3",t+"delete.ogg",t+"delete.wav"],"delete");var i=[];t=function(){for(;i.length;)I.browserEvents.unbind(i.pop());o.preload()},i.push(I.browserEvents.conditionalBind(document,"mousemove",null,t,!0)),i.push(I.browserEvents.conditionalBind(document,"touchstart",null,t,!0))},I.Names=function(t,e){if(this.variablePrefix_=e||"",this.reservedDict_=Object.create(null),t)for(t=t.split(","),e=0;e<t.length;e++)this.reservedDict_[t[e]]=!0;this.reset()},I.Names.DEVELOPER_VARIABLE_TYPE="DEVELOPER_VARIABLE",I.Names.prototype.reset=function(){this.db_=Object.create(null),this.dbReverse_=Object.create(null),this.variableMap_=null},I.Names.prototype.setVariableMap=function(t){this.variableMap_=t},I.Names.prototype.getNameForUserVariable_=function(t){return this.variableMap_?(t=this.variableMap_.getVariableById(t))?t.name:null:(console.log("Deprecated call to Blockly.Names.prototype.getName without defining a variable map. To fix, add the following code in your generator's init() function:\nBlockly.YourGeneratorName.variableDB_.setVariableMap(workspace.getVariableMap());"),null)},I.Names.prototype.getName=function(t,e){var o;e!=I.VARIABLE_CATEGORY_NAME||(o=this.getNameForUserVariable_(t))&&(t=o);var o=t.toLowerCase()+"_"+e,i=e==I.VARIABLE_CATEGORY_NAME||e==I.Names.DEVELOPER_VARIABLE_TYPE?this.variablePrefix_:"";if(o in this.db_)return i+this.db_[o];return t=this.getDistinctName(t,e),this.db_[o]=t.substr(i.length),t},I.Names.prototype.getDistinctName=function(t,e){t=this.safeName_(t);for(var o="";this.dbReverse_[t+o]||t+o in this.reservedDict_;)o=o?o+1:2;return this.dbReverse_[t+=o]=!0,(e==I.VARIABLE_CATEGORY_NAME||e==I.Names.DEVELOPER_VARIABLE_TYPE?this.variablePrefix_:"")+t},I.Names.prototype.safeName_=function(t){return t?(t=encodeURI(t.replace(/ /g,"_")).replace(/[^\w]/g,"_"),-1!="0123456789".indexOf(t[0])&&(t="my_"+t)):t=I.Msg.UNNAMED_KEY||"unnamed",t},I.Names.equals=function(t,e){return t.toLowerCase()==e.toLowerCase()},I.Procedures={},I.Procedures.NAME_TYPE=I.PROCEDURE_CATEGORY_NAME,I.Procedures.DEFAULT_ARG="x",I.Procedures.allProcedures=function(t){var e=t.getBlocksByType("procedures_defnoreturn",!1).map(function(t){return t.getProcedureDef()});return t=t.getBlocksByType("procedures_defreturn",!1).map(function(t){return t.getProcedureDef()}),e.sort(I.Procedures.procTupleComparator_),t.sort(I.Procedures.procTupleComparator_),[e,t]},I.Procedures.procTupleComparator_=function(t,e){return t[0].toLowerCase().localeCompare(e[0].toLowerCase())},I.Procedures.findLegalName=function(t,e){if(e.isInFlyout)return t;for(t=t||I.Msg.UNNAMED_KEY||"unnamed";!I.Procedures.isLegalName_(t,e.workspace,e);){var o=t.match(/^(.*?)(\d+)$/);t=o?o[1]+(parseInt(o[2],10)+1):t+"2"}return t},I.Procedures.isLegalName_=function(t,e,o){return!I.Procedures.isNameUsed(t,e,o)},I.Procedures.isNameUsed=function(t,e,o){e=e.getAllBlocks(!1);for(var i=0;i<e.length;i++)if(e[i]!=o&&e[i].getProcedureDef){var s=e[i].getProcedureDef();if(I.Names.equals(s[0],t))return!0}return!1},I.Procedures.rename=function(t){t=t.trim();var e=I.Procedures.findLegalName(t,this.getSourceBlock()),o=this.getValue();if(o!=t&&o!=e){t=this.getSourceBlock().workspace.getAllBlocks(!1);for(var i=0;i<t.length;i++)t[i].renameProcedure&&t[i].renameProcedure(o,e)}return e},I.Procedures.flyoutCategory=function(t){function e(t,e){for(var o=0;o<t.length;o++){var i=t[o][0],s=t[o][1],n=I.utils.xml.createElement("block");n.setAttribute("type",e),n.setAttribute("gap",16);var r=I.utils.xml.createElement("mutation");for(r.setAttribute("name",i),n.appendChild(r),i=0;i<s.length;i++){var l=I.utils.xml.createElement("arg");l.setAttribute("name",s[i]),r.appendChild(l)}a.push(n)}}var a=[],o,i;return I.Blocks.procedures_defnoreturn&&((o=I.utils.xml.createElement("block")).setAttribute("type","procedures_defnoreturn"),o.setAttribute("gap",16),(i=I.utils.xml.createElement("field")).setAttribute("name","NAME"),i.appendChild(I.utils.xml.createTextNode(I.Msg.PROCEDURES_DEFNORETURN_PROCEDURE)),o.appendChild(i),a.push(o)),I.Blocks.procedures_defreturn&&((o=I.utils.xml.createElement("block")).setAttribute("type","procedures_defreturn"),o.setAttribute("gap",16),(i=I.utils.xml.createElement("field")).setAttribute("name","NAME"),i.appendChild(I.utils.xml.createTextNode(I.Msg.PROCEDURES_DEFRETURN_PROCEDURE)),o.appendChild(i),a.push(o)),I.Blocks.procedures_ifreturn&&((o=I.utils.xml.createElement("block")).setAttribute("type","procedures_ifreturn"),o.setAttribute("gap",16),a.push(o)),a.length&&a[a.length-1].setAttribute("gap",24),e((t=I.Procedures.allProcedures(t))[0],"procedures_callnoreturn"),e(t[1],"procedures_callreturn"),a},I.Procedures.updateMutatorFlyout_=function(t){for(var e=[],o=t.getBlocksByType("procedures_mutatorarg",!1),i=0,s;s=o[i];i++)e.push(s.getFieldValue("NAME"));o=I.utils.xml.createElement("xml"),(i=I.utils.xml.createElement("block")).setAttribute("type","procedures_mutatorarg"),(s=I.utils.xml.createElement("field")).setAttribute("name","NAME"),e=I.Variables.generateUniqueNameFromOptions(I.Procedures.DEFAULT_ARG,e),e=I.utils.xml.createTextNode(e),s.appendChild(e),i.appendChild(s),o.appendChild(i),t.updateToolbox(o)},I.Procedures.mutatorOpenListener=function(t){var e;t.type==I.Events.BUBBLE_OPEN&&"mutator"===t.bubbleType&&t.isOpen&&("procedures_defnoreturn"!=(e=(t=I.Workspace.getById(t.workspaceId).getBlockById(t.blockId)).type)&&"procedures_defreturn"!=e||(t=t.mutator.getWorkspace(),I.Procedures.updateMutatorFlyout_(t),t.addChangeListener(I.Procedures.mutatorChangeListener_)))},I.Procedures.mutatorChangeListener_=function(t){t.type!=I.Events.BLOCK_CREATE&&t.type!=I.Events.BLOCK_DELETE&&t.type!=I.Events.BLOCK_CHANGE||(t=I.Workspace.getById(t.workspaceId),I.Procedures.updateMutatorFlyout_(t))},I.Procedures.getCallers=function(t,e){var o=[];e=e.getAllBlocks(!1);for(var i=0,s;i<e.length;i++){!e[i].getProcedureCall||(s=e[i].getProcedureCall())&&I.Names.equals(s,t)&&o.push(e[i])}return o},I.Procedures.mutateCallers=function(t){var e=I.Events.recordUndo,o=t.getProcedureDef()[0],i=t.mutationToDom(!0),s;for(t=I.Procedures.getCallers(o,t.workspace),o=0;s=t[o];o++){var n,n=(n=s.mutationToDom())&&I.Xml.domToText(n);s.domToMutation(i);var r=s.mutationToDom(),r;n!=(r=r&&I.Xml.domToText(r))&&(I.Events.recordUndo=!1,I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(s,"mutation",null,n,r)),I.Events.recordUndo=e)}},I.Procedures.getDefinition=function(t,e){e=e.getTopBlocks(!1);for(var o=0;o<e.length;o++)if(e[o].getProcedureDef){var i=e[o].getProcedureDef();if(i&&I.Names.equals(i[0],t))return e[o]}return null},I.ShortcutRegistry=function(){(I.ShortcutRegistry.registry=this).registry_=Object.create(null),this.keyMap_=Object.create(null)},I.ShortcutRegistry.modifierKeys={Shift:I.utils.KeyCodes.SHIFT,Control:I.utils.KeyCodes.CTRL,Alt:I.utils.KeyCodes.ALT,Meta:I.utils.KeyCodes.META},I.ShortcutRegistry.prototype.register=function(t,e){if(this.registry_[t.name]&&!e)throw Error('Shortcut with name "'+t.name+'" already exists.');this.registry_[t.name]=t},I.ShortcutRegistry.prototype.unregister=function(t){if(!this.registry_[t])return console.warn('Keyboard shortcut with name "'+t+'" not found.'),!1;return this.removeAllKeyMappings(t),delete this.registry_[t],!0},I.ShortcutRegistry.prototype.addKeyMapping=function(t,e,o){t=String(t);var i=this.keyMap_[t];if(i&&!o)throw Error('Shortcut with name "'+e+'" collides with shortcuts '+i.toString());i&&o?i.unshift(e):this.keyMap_[t]=[e]},I.ShortcutRegistry.prototype.removeKeyMapping=function(t,e,o){var i=this.keyMap_[t];if(!i&&!o)return console.warn('No keyboard shortcut with name "'+e+'" registered with key code "'+t+'"'),!1;var s=i.indexOf(e);if(-1<s)return i.splice(s,1),0==i.length&&delete this.keyMap_[t],!0;return o||console.warn('No keyboard shortcut with name "'+e+'" registered with key code "'+t+'"'),!1},I.ShortcutRegistry.prototype.removeAllKeyMappings=function(t){for(var e in this.keyMap_)this.removeKeyMapping(e,t,!0)},I.ShortcutRegistry.prototype.setKeyMap=function(t){this.keyMap_=t},I.ShortcutRegistry.prototype.getKeyMap=function(){return I.utils.object.deepMerge(Object.create(null),this.keyMap_)},I.ShortcutRegistry.prototype.getRegistry=function(){return I.utils.object.deepMerge(Object.create(null),this.registry_)},I.ShortcutRegistry.prototype.onKeyDown=function(t,e){var o=this.serializeKeyEvent_(e),o;if(!(o=this.getShortcutNamesByKeyCode(o)))return!1;for(var i=0,s;s=o[i];i++)if((!(s=this.registry_[s]).preconditionFn||s.preconditionFn(t))&&s.callback&&s.callback(t,e,s))return!0;return!1},I.ShortcutRegistry.prototype.getShortcutNamesByKeyCode=function(t){return this.keyMap_[t]||[]},I.ShortcutRegistry.prototype.getKeyCodesByShortcutName=function(t){var e=[],o;for(o in this.keyMap_)-1<this.keyMap_[o].indexOf(t)&&e.push(o);return e},I.ShortcutRegistry.prototype.serializeKeyEvent_=function(t){var e="",o;for(o in I.ShortcutRegistry.modifierKeys)t.getModifierState(o)&&(""!=e&&(e+="+"),e+=o);return""!=e&&t.keyCode?e=e+"+"+t.keyCode:t.keyCode&&(e=t.keyCode.toString()),e},I.ShortcutRegistry.prototype.checkModifiers_=function(t){for(var e=I.utils.object.values(I.ShortcutRegistry.modifierKeys),o=0,i;i=t[o];o++)if(e.indexOf(i)<0)throw Error(i+" is not a valid modifier key.")},I.ShortcutRegistry.prototype.createSerializedKey=function(t,e){var o="";if(e)for(var i in this.checkModifiers_(e),I.ShortcutRegistry.modifierKeys)-1<e.indexOf(I.ShortcutRegistry.modifierKeys[i])&&(""!=o&&(o+="+"),o+=i);return""!=o&&t?o=o+"+"+t:t&&(o=t.toString()),o},new I.ShortcutRegistry,I.VariableModel=function(t,e,o,i){this.workspace=t,this.name=e,this.type=o||"",this.id_=i||I.utils.genUid(),I.Events.fire(new(I.Events.get(I.Events.VAR_CREATE))(this))},I.VariableModel.prototype.getId=function(){return this.id_},I.VariableModel.compareByName=function(t,e){return(t=t.name.toLowerCase())<(e=e.name.toLowerCase())?-1:t==e?0:1},I.Variables={},I.Variables.NAME_TYPE=I.VARIABLE_CATEGORY_NAME,I.Variables.allUsedVarModels=function(t){var e=t.getAllBlocks(!1);t=Object.create(null);for(var o=0;o<e.length;o++){var i=e[o].getVarModels();if(i)for(var s=0;s<i.length;s++){var n=i[s],r=n.getId();r&&(t[r]=n)}}for(r in e=[],t)e.push(t[r]);return e},I.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_={},I.Variables.allDeveloperVariables=function(t){t=t.getAllBlocks(!1);for(var e=Object.create(null),o=0,i;i=t[o];o++){var s=i.getDeveloperVariables;if(!s&&i.getDeveloperVars&&(s=i.getDeveloperVars,I.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_[i.type]||(console.warn("Function getDeveloperVars() deprecated. Use getDeveloperVariables() (block type '"+i.type+"')"),I.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_[i.type]=!0)),s)for(i=s(),s=0;s<i.length;s++)e[i[s]]=!0}return Object.keys(e)},I.Variables.flyoutCategory=function(t){var e=[],o=document.createElement("button");return o.setAttribute("text","%{BKY_NEW_VARIABLE}"),o.setAttribute("callbackKey","CREATE_VARIABLE"),t.registerButtonCallback("CREATE_VARIABLE",function(t){I.Variables.createVariableButtonHandler(t.getTargetWorkspace())}),e.push(o),t=I.Variables.flyoutCategoryBlocks(t),e=e.concat(t)},I.Variables.flyoutCategoryBlocks=function(t){var e=[];if(0<(t=t.getVariablesOfType("")).length){var o=t[t.length-1],i,s;if(I.Blocks.variables_set&&((i=I.utils.xml.createElement("block")).setAttribute("type","variables_set"),i.setAttribute("gap",I.Blocks.math_change?8:24),i.appendChild(I.Variables.generateVariableFieldDom(o)),e.push(i)),I.Blocks.math_change&&((i=I.utils.xml.createElement("block")).setAttribute("type","math_change"),i.setAttribute("gap",I.Blocks.variables_get?20:8),i.appendChild(I.Variables.generateVariableFieldDom(o)),o=I.Xml.textToDom('<value name="DELTA"><shadow type="math_number"><field name="NUM">1</field></shadow></value>'),i.appendChild(o),e.push(i)),I.Blocks.variables_get){t.sort(I.VariableModel.compareByName),o=0;for(;s=t[o];o++)(i=I.utils.xml.createElement("block")).setAttribute("type","variables_get"),i.setAttribute("gap",8),i.appendChild(I.Variables.generateVariableFieldDom(s)),e.push(i)}}return e},I.Variables.VAR_LETTER_OPTIONS="ijkmnopqrstuvwxyzabcdefgh",I.Variables.generateUniqueName=function(t){return I.Variables.generateUniqueNameFromOptions(I.Variables.VAR_LETTER_OPTIONS.charAt(0),t.getAllVariableNames())},I.Variables.generateUniqueNameFromOptions=function(t,e){if(!e.length)return t;for(var o=I.Variables.VAR_LETTER_OPTIONS,i="",s=o.indexOf(t);;){for(var n=!1,r=0;r<e.length;r++)if(e[r].toLowerCase()==t){n=!0;break}if(!n)return t;++s==o.length&&(s=0,i=Number(i)+1),t=o.charAt(s)+i}},I.Variables.createVariableButtonHandler=function(i,s,t){var n=t||"",r=function(t){I.Variables.promptName(I.Msg.NEW_VARIABLE_TITLE,t,function(t){var e,o,o;t?(e=I.Variables.nameUsedWithAnyType(t,i))?(o=e.type==n?I.Msg.VARIABLE_ALREADY_EXISTS.replace("%1",e.name):(o=I.Msg.VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE).replace("%1",e.name).replace("%2",e.type),I.alert(o,function(){r(t)})):(i.createVariable(t,n),s&&s(t)):s&&s(null)})};r("")},I.Variables.createVariable=I.Variables.createVariableButtonHandler,I.Variables.renameVariable=function(o,i,s){var n=function(t){var e=I.Msg.RENAME_VARIABLE_TITLE.replace("%1",i.name);I.Variables.promptName(e,t,function(t){var e;t?(e=I.Variables.nameUsedWithOtherType_(t,i.type,o))?(e=I.Msg.VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE.replace("%1",e.name).replace("%2",e.type),I.alert(e,function(){n(t)})):(o.renameVariableById(i.getId(),t),s&&s(t)):s&&s(null)})};n("")},I.Variables.promptName=function(t,e,o){I.prompt(t,e,function(t){!t||(t=t.replace(/[\s\xa0]+/g," ").trim())!=I.Msg.RENAME_VARIABLE&&t!=I.Msg.NEW_VARIABLE||(t=null),o(t)})},I.Variables.nameUsedWithOtherType_=function(t,e,o){o=o.getVariableMap().getAllVariables(),t=t.toLowerCase();for(var i=0,s;s=o[i];i++)if(s.name.toLowerCase()==t&&s.type!=e)return s;return null},I.Variables.nameUsedWithAnyType=function(t,e){e=e.getVariableMap().getAllVariables(),t=t.toLowerCase();for(var o=0,i;i=e[o];o++)if(i.name.toLowerCase()==t)return i;return null},I.Variables.generateVariableFieldDom=function(t){var e=I.utils.xml.createElement("field");return e.setAttribute("name","VAR"),e.setAttribute("id",t.getId()),e.setAttribute("variabletype",t.type),t=I.utils.xml.createTextNode(t.name),e.appendChild(t),e},I.Variables.getOrCreateVariablePackage=function(t,e,o,i){var s,s;return s=(s=I.Variables.getVariable(t,e,o,i))||I.Variables.createVariable_(t,e,o,i)},I.Variables.getVariable=function(t,e,o,i){var s=t.getPotentialVariableMap(),n=null;if(e&&(n=!(n=t.getVariableById(e))&&s?s.getVariableById(e):n))return n;if(o){if(null==i)throw Error("Tried to look up a variable by name without a type");!(n=t.getVariable(o,i))&&s&&(n=s.getVariable(o,i))}return n},I.Variables.createVariable_=function(t,e,o,i){var s=t.getPotentialVariableMap();return o=o||I.Variables.generateUniqueName(t.isFlyout?t.targetWorkspace:t),(s||t).createVariable(o,i,e)},I.Variables.getAddedVariables=function(t,e){t=t.getAllVariables();var o=[];if(e.length!=t.length)for(var i=0;i<t.length;i++){var s=t[i];-1==e.indexOf(s)&&o.push(s)}return o},I.VERSION="5.20210325.1",I.mainWorkspace=null,I.selected=null,I.draggingConnections=[],I.clipboardXml_=null,I.clipboardSource_=null,I.clipboardTypeCounts_=null,I.cache3dSupported_=null,I.parentContainer=null,I.svgSize=function(t){return I.utils.deprecation.warn("Blockly.svgSize","March 2021","March 2022","workspace.getCachedParentSvgSize"),new I.utils.Size(t.cachedWidth_,t.cachedHeight_)},I.resizeSvgContents=function(t){t.resizeContents()},I.svgResize=function(t){for(;t.options.parentWorkspace;)t=t.options.parentWorkspace;var e=t.getParentSvg(),o=t.getCachedParentSvgSize(),i=e.parentNode,s,i;i&&(s=i.offsetWidth,i=i.offsetHeight,o.width!=s&&(e.setAttribute("width",s+"px"),t.setCachedParentSvgSize(s,null)),o.height!=i&&(e.setAttribute("height",i+"px"),t.setCachedParentSvgSize(null,i)),t.resize())},I.onKeyDown=function(t){var e=I.mainWorkspace;e&&!(I.utils.isTargetInput(t)||e.rendered&&!e.isVisible())&&I.ShortcutRegistry.registry.onKeyDown(e,t)},I.deleteBlock=function(t){t.workspace.isFlyout||(I.Events.setGroup(!0),I.hideChaff(),t.dispose(!0,!0),I.Events.setGroup(!1))},I.copy=function(t){(t=t.toCopyData())&&(I.clipboardXml_=t.xml,I.clipboardSource_=t.source,I.clipboardTypeCounts_=t.typeCounts)},I.paste=function(){if(!I.clipboardXml_)return!1;var t=I.clipboardSource_;return t.isFlyout&&(t=t.targetWorkspace),!(!I.clipboardTypeCounts_||!t.isCapacityAvailable(I.clipboardTypeCounts_))&&(I.Events.setGroup(!0),t.paste(I.clipboardXml_),I.Events.setGroup(!1),!0)},I.duplicate=function(t){var e=I.clipboardXml_,o=I.clipboardSource_;I.copy(t),t.workspace.paste(I.clipboardXml_),I.clipboardXml_=e,I.clipboardSource_=o},I.onContextMenu_=function(t){I.utils.isTargetInput(t)||t.preventDefault()},I.hideChaff=function(t){I.Tooltip.hide(),I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation(),t||((t=I.getMainWorkspace()).trashcan&&t.trashcan.flyout&&t.trashcan.closeFlyout(),(t=t.getToolbox())&&t.getFlyout()&&t.getFlyout().autoClose&&t.clearSelection())},I.getMainWorkspace=function(){return I.mainWorkspace},I.alert=function(t,e){alert(t),e&&e()},I.confirm=function(t,e){e(confirm(t))},I.prompt=function(t,e,o){o(prompt(t,e))},I.jsonInitFactory_=function(t){return function(){this.jsonInit(t)}},I.defineBlocksWithJsonArray=function(t){for(var e=0;e<t.length;e++){var o=t[e],i;o?null==(i=o.type)||""===i?console.warn("Block definition #"+e+" in JSON array is missing a type attribute. Skipping."):(I.Blocks[i]&&console.warn("Block definition #"+e+' in JSON array overwrites prior definition of "'+i+'".'),I.Blocks[i]={init:I.jsonInitFactory_(o)}):console.warn("Block definition #"+e+" in JSON array is "+o+". Skipping.")}},I.isNumber=function(t){return/^\s*-?\d+(\.\d+)?\s*$/.test(t)},I.hueToHex=function(t){return I.utils.colour.hsvToHex(t,I.HSV_SATURATION,255*I.HSV_VALUE)},I.checkBlockColourConstants=function(){I.checkBlockColourConstant_("LOGIC_HUE",["Blocks","logic","HUE"],void 0),I.checkBlockColourConstant_("LOGIC_HUE",["Constants","Logic","HUE"],210),I.checkBlockColourConstant_("LOOPS_HUE",["Blocks","loops","HUE"],void 0),I.checkBlockColourConstant_("LOOPS_HUE",["Constants","Loops","HUE"],120),I.checkBlockColourConstant_("MATH_HUE",["Blocks","math","HUE"],void 0),I.checkBlockColourConstant_("MATH_HUE",["Constants","Math","HUE"],230),I.checkBlockColourConstant_("TEXTS_HUE",["Blocks","texts","HUE"],void 0),I.checkBlockColourConstant_("TEXTS_HUE",["Constants","Text","HUE"],160),I.checkBlockColourConstant_("LISTS_HUE",["Blocks","lists","HUE"],void 0),I.checkBlockColourConstant_("LISTS_HUE",["Constants","Lists","HUE"],260),I.checkBlockColourConstant_("COLOUR_HUE",["Blocks","colour","HUE"],void 0),I.checkBlockColourConstant_("COLOUR_HUE",["Constants","Colour","HUE"],20),I.checkBlockColourConstant_("VARIABLES_HUE",["Blocks","variables","HUE"],void 0),I.checkBlockColourConstant_("VARIABLES_HUE",["Constants","Variables","HUE"],330),I.checkBlockColourConstant_("VARIABLES_DYNAMIC_HUE",["Constants","VariablesDynamic","HUE"],310),I.checkBlockColourConstant_("PROCEDURES_HUE",["Blocks","procedures","HUE"],void 0)},I.checkBlockColourConstant_=function(t,e,o){for(var i="Blockly",s=I,n=0;n<e.length;++n)i+="."+e[n],s=s&&s[e[n]];s&&s!==o&&(t=(void 0===o?'%1 has been removed. Use Blockly.Msg["%2"].':'%1 is deprecated and unused. Override Blockly.Msg["%2"].').replace("%1",i).replace("%2",t),console.warn(t))},I.setParentContainer=function(t){I.parentContainer=t},I.bindEvent_=I.browserEvents.bind,I.unbindEvent_=I.browserEvents.unbind,I.bindEventWithChecks_=I.browserEvents.conditionalBind,I.ALIGN_LEFT=I.constants.ALIGN.LEFT,I.ALIGN_CENTRE=I.constants.ALIGN.CENTRE,I.ALIGN_RIGHT=I.constants.ALIGN.RIGHT,I.INPUT_VALUE=I.connectionTypes.INPUT_VALUE,I.OUTPUT_VALUE=I.connectionTypes.OUTPUT_VALUE,I.NEXT_STATEMENT=I.connectionTypes.NEXT_STATEMENT,I.PREVIOUS_STATEMENT=I.connectionTypes.PREVIOUS_STATEMENT,I.DUMMY_INPUT=I.inputTypes.DUMMY,I.TOOLBOX_AT_TOP=I.utils.toolbox.Position.TOP,I.TOOLBOX_AT_BOTTOM=I.utils.toolbox.Position.BOTTOM,I.TOOLBOX_AT_LEFT=I.utils.toolbox.Position.LEFT,I.TOOLBOX_AT_RIGHT=I.utils.toolbox.Position.RIGHT,I.Events.BubbleOpen=function(t,e,o){I.Events.BubbleOpen.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.isOpen=e,this.bubbleType=o},I.utils.object.inherits(I.Events.BubbleOpen,I.Events.UiBase),I.Events.BubbleOpen.prototype.type=I.Events.BUBBLE_OPEN,I.Events.BubbleOpen.prototype.toJson=function(){var t=I.Events.BubbleOpen.superClass_.toJson.call(this);return t.isOpen=this.isOpen,t.bubbleType=this.bubbleType,t.blockId=this.blockId,t},I.Events.BubbleOpen.prototype.fromJson=function(t){I.Events.BubbleOpen.superClass_.fromJson.call(this,t),this.isOpen=t.isOpen,this.bubbleType=t.bubbleType,this.blockId=t.blockId},I.registry.register(I.registry.Type.EVENT,I.Events.BUBBLE_OPEN,I.Events.BubbleOpen),I.Icon=function(t){this.block_=t,this.iconGroup_=null},I.Icon.prototype.collapseHidden=!0,I.Icon.prototype.SIZE=17,I.Icon.prototype.bubble_=null,I.Icon.prototype.iconXY_=null,I.Icon.prototype.createIcon=function(){this.iconGroup_||(this.iconGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyIconGroup"},null),this.block_.isInFlyout&&I.utils.dom.addClass(this.iconGroup_,"blocklyIconGroupReadonly"),this.drawIcon_(this.iconGroup_),this.block_.getSvgRoot().appendChild(this.iconGroup_),I.browserEvents.conditionalBind(this.iconGroup_,"mouseup",this,this.iconClick_),this.updateEditable())},I.Icon.prototype.dispose=function(){I.utils.dom.removeNode(this.iconGroup_),this.iconGroup_=null,this.setVisible(!1),this.block_=null},I.Icon.prototype.updateEditable=function(){},I.Icon.prototype.isVisible=function(){return!!this.bubble_},I.Icon.prototype.iconClick_=function(t){this.block_.workspace.isDragging()||this.block_.isInFlyout||I.utils.isRightButton(t)||this.setVisible(!this.isVisible())},I.Icon.prototype.applyColour=function(){this.isVisible()&&this.bubble_.setColour(this.block_.style.colourPrimary)},I.Icon.prototype.setIconLocation=function(t){this.iconXY_=t,this.isVisible()&&this.bubble_.setAnchorLocation(t)},I.Icon.prototype.computeIconLocation=function(){var t=this.block_.getRelativeToSurfaceXY(),e=I.utils.getRelativeXY(this.iconGroup_),t=new I.utils.Coordinate(t.x+e.x+this.SIZE/2,t.y+e.y+this.SIZE/2);I.utils.Coordinate.equals(this.getIconLocation(),t)||this.setIconLocation(t)},I.Icon.prototype.getIconLocation=function(){return this.iconXY_},I.Icon.prototype.getCorrectedSize=function(){return new I.utils.Size(I.Icon.prototype.SIZE,I.Icon.prototype.SIZE-2)},I.Warning=function(t){I.Warning.superClass_.constructor.call(this,t),this.createIcon(),this.text_={}},I.utils.object.inherits(I.Warning,I.Icon),I.Warning.prototype.collapseHidden=!1,I.Warning.prototype.drawIcon_=function(t){I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyIconShape",d:"M2,15Q-1,15 0.5,12L6.5,1.7Q8,-1 9.5,1.7L15.5,12Q17,15 14,15z"},t),I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m7,4.8v3.16l0.27,2.27h1.46l0.27,-2.27v-3.16z"},t),I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyIconSymbol",x:"7",y:"11",height:"2",width:"2"},t)},I.Warning.prototype.setVisible=function(t){t!=this.isVisible()&&(I.Events.fire(new(I.Events.get(I.Events.BUBBLE_OPEN))(this.block_,t,"warning")),t?this.createBubble_():this.disposeBubble_())},I.Warning.prototype.createBubble_=function(){this.paragraphElement_=I.Bubble.textToDom(this.getText()),this.bubble_=I.Bubble.createNonEditableBubble(this.paragraphElement_,this.block_,this.iconXY_),this.applyColour()},I.Warning.prototype.disposeBubble_=function(){this.bubble_.dispose(),this.paragraphElement_=this.bubble_=null},I.Warning.prototype.setText=function(t,e){this.text_[e]!=t&&(t?this.text_[e]=t:delete this.text_[e],this.isVisible()&&(this.setVisible(!1),this.setVisible(!0)))},I.Warning.prototype.getText=function(){var t=[],e;for(e in this.text_)t.push(this.text_[e]);return t.join("\n")},I.Warning.prototype.dispose=function(){this.block_.warning=null,I.Icon.prototype.dispose.call(this)},I.Comment=function(t){I.Comment.superClass_.constructor.call(this,t),this.model_=t.commentModel,this.model_.text=this.model_.text||"",this.cachedText_="",this.onInputWrapper_=this.onChangeWrapper_=this.onWheelWrapper_=this.onMouseUpWrapper_=null,this.createIcon()},I.utils.object.inherits(I.Comment,I.Icon),I.Comment.prototype.drawIcon_=function(t){I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{class:"blocklyIconShape",r:"8",cx:"8",cy:"8"},t),I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m6.8,10h2c0.003,-0.617 0.271,-0.962 0.633,-1.266 2.875,-2.4050.607,-5.534 -3.765,-3.874v1.7c3.12,-1.657 3.698,0.118 2.336,1.25-1.201,0.998 -1.201,1.528 -1.204,2.19z"},t),I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyIconSymbol",x:"6.8",y:"10.78",height:"2",width:"2"},t)},I.Comment.prototype.createEditor_=function(){this.foreignObject_=I.utils.dom.createSvgElement(I.utils.Svg.FOREIGNOBJECT,{x:I.Bubble.BORDER_WIDTH,y:I.Bubble.BORDER_WIDTH},null);var t=document.createElementNS(I.utils.dom.HTML_NS,"body");t.setAttribute("xmlns",I.utils.dom.HTML_NS),t.className="blocklyMinimalBody";var e=this.textarea_=document.createElementNS(I.utils.dom.HTML_NS,"textarea");return e.className="blocklyCommentTextarea",e.setAttribute("dir",this.block_.RTL?"RTL":"LTR"),e.value=this.model_.text,this.resizeTextarea_(),t.appendChild(e),this.foreignObject_.appendChild(t),this.onMouseUpWrapper_=I.browserEvents.conditionalBind(e,"mouseup",this,this.startEdit_,!0,!0),this.onWheelWrapper_=I.browserEvents.conditionalBind(e,"wheel",this,function(t){t.stopPropagation()}),this.onChangeWrapper_=I.browserEvents.conditionalBind(e,"change",this,function(t){this.cachedText_!=this.model_.text&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this.block_,"comment",null,this.cachedText_,this.model_.text))}),this.onInputWrapper_=I.browserEvents.conditionalBind(e,"input",this,function(t){this.model_.text=e.value}),setTimeout(e.focus.bind(e),0),this.foreignObject_},I.Comment.prototype.updateEditable=function(){I.Comment.superClass_.updateEditable.call(this),this.isVisible()&&(this.disposeBubble_(),this.createBubble_())},I.Comment.prototype.onBubbleResize_=function(){this.isVisible()&&(this.model_.size=this.bubble_.getBubbleSize(),this.resizeTextarea_())},I.Comment.prototype.resizeTextarea_=function(){var t=this.model_.size,e=2*I.Bubble.BORDER_WIDTH,o=t.width-e,t=t.height-e;this.foreignObject_.setAttribute("width",o),this.foreignObject_.setAttribute("height",t),this.textarea_.style.width=o-4+"px",this.textarea_.style.height=t-4+"px"},I.Comment.prototype.setVisible=function(t){t!=this.isVisible()&&(I.Events.fire(new(I.Events.get(I.Events.BUBBLE_OPEN))(this.block_,t,"comment")),(this.model_.pinned=t)?this.createBubble_():this.disposeBubble_())},I.Comment.prototype.createBubble_=function(){!this.block_.isEditable()||I.utils.userAgent.IE?this.createNonEditableBubble_():this.createEditableBubble_()},I.Comment.prototype.createEditableBubble_=function(){this.bubble_=new I.Bubble(this.block_.workspace,this.createEditor_(),this.block_.pathObject.svgPath,this.iconXY_,this.model_.size.width,this.model_.size.height),this.bubble_.setSvgId(this.block_.id),this.bubble_.registerResizeEvent(this.onBubbleResize_.bind(this)),this.applyColour()},I.Comment.prototype.createNonEditableBubble_=function(){this.paragraphElement_=I.Bubble.textToDom(this.block_.getCommentText()),this.bubble_=I.Bubble.createNonEditableBubble(this.paragraphElement_,this.block_,this.iconXY_),this.applyColour()},I.Comment.prototype.disposeBubble_=function(){this.onMouseUpWrapper_&&(I.browserEvents.unbind(this.onMouseUpWrapper_),this.onMouseUpWrapper_=null),this.onWheelWrapper_&&(I.browserEvents.unbind(this.onWheelWrapper_),this.onWheelWrapper_=null),this.onChangeWrapper_&&(I.browserEvents.unbind(this.onChangeWrapper_),this.onChangeWrapper_=null),this.onInputWrapper_&&(I.browserEvents.unbind(this.onInputWrapper_),this.onInputWrapper_=null),this.bubble_.dispose(),this.paragraphElement_=this.foreignObject_=this.textarea_=this.bubble_=null},I.Comment.prototype.startEdit_=function(t){this.bubble_.promote()&&this.textarea_.focus(),this.cachedText_=this.model_.text},I.Comment.prototype.getBubbleSize=function(){return this.model_.size},I.Comment.prototype.setBubbleSize=function(t,e){this.bubble_?this.bubble_.setBubbleSize(t,e):(this.model_.size.width=t,this.model_.size.height=e)},I.Comment.prototype.updateText=function(){this.textarea_?this.textarea_.value=this.model_.text:this.paragraphElement_&&(this.paragraphElement_.firstChild.textContent=this.model_.text)},I.Comment.prototype.dispose=function(){this.block_.comment=null,I.Icon.prototype.dispose.call(this)},I.Css.register(".blocklyCommentTextarea {,background-color: #fef49c;,border: 0;,outline: 0;,margin: 0;,padding: 3px;,resize: none;,display: block;,text-overflow: hidden;,}".split(",")),I.Flyout=function(t){t.setMetrics=this.setMetrics_.bind(this),this.workspace_=new I.WorkspaceSvg(t),this.workspace_.setMetricsManager(new I.FlyoutMetricsManager(this.workspace_,this)),this.workspace_.isFlyout=!0,this.workspace_.setVisible(this.isVisible_),this.RTL=!!t.RTL,this.horizontalLayout=!1,this.toolboxPosition_=t.toolboxPosition,this.eventWrappers_=[],this.mats_=[],this.buttons_=[],this.listeners_=[],this.permanentlyDisabled_=[],this.tabWidth_=this.workspace_.getRenderer().getConstants().TAB_WIDTH,this.targetWorkspace=null},I.Flyout.prototype.autoClose=!0,I.Flyout.prototype.isVisible_=!1,I.Flyout.prototype.containerVisible_=!0,I.Flyout.prototype.CORNER_RADIUS=8,I.Flyout.prototype.MARGIN=I.Flyout.prototype.CORNER_RADIUS,I.Flyout.prototype.GAP_X=3*I.Flyout.prototype.MARGIN,I.Flyout.prototype.GAP_Y=3*I.Flyout.prototype.MARGIN,I.Flyout.prototype.SCROLLBAR_PADDING=2,I.Flyout.prototype.width_=0,I.Flyout.prototype.height_=0,I.Flyout.prototype.dragAngleRange_=70,I.Flyout.prototype.createDom=function(t){return this.svgGroup_=I.utils.dom.createSvgElement(t,{class:"blocklyFlyout",style:"display: none"},null),this.svgBackground_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyFlyoutBackground"},this.svgGroup_),this.svgGroup_.appendChild(this.workspace_.createDom()),this.workspace_.getThemeManager().subscribe(this.svgBackground_,"flyoutBackgroundColour","fill"),this.workspace_.getThemeManager().subscribe(this.svgBackground_,"flyoutOpacity","fill-opacity"),this.svgGroup_},I.Flyout.prototype.init=function(t){this.targetWorkspace=t,this.workspace_.targetWorkspace=t,this.workspace_.scrollbar=new I.ScrollbarPair(this.workspace_,this.horizontalLayout,!this.horizontalLayout,"blocklyFlyoutScrollbar"),this.hide(),Array.prototype.push.apply(this.eventWrappers_,I.browserEvents.conditionalBind(this.svgGroup_,"wheel",this,this.wheel_)),this.autoClose||(this.filterWrapper_=this.filterForCapacity_.bind(this),this.targetWorkspace.addChangeListener(this.filterWrapper_)),Array.prototype.push.apply(this.eventWrappers_,I.browserEvents.conditionalBind(this.svgBackground_,"mousedown",this,this.onMouseDown_)),this.workspace_.getGesture=this.targetWorkspace.getGesture.bind(this.targetWorkspace),this.workspace_.setVariableMap(this.targetWorkspace.getVariableMap()),this.workspace_.createPotentialVariableMap()},I.Flyout.prototype.dispose=function(){this.hide(),I.browserEvents.unbind(this.eventWrappers_),this.filterWrapper_&&(this.targetWorkspace.removeChangeListener(this.filterWrapper_),this.filterWrapper_=null),this.workspace_&&(this.workspace_.getThemeManager().unsubscribe(this.svgBackground_),this.workspace_.targetWorkspace=null,this.workspace_.dispose(),this.workspace_=null),this.svgGroup_&&(I.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.targetWorkspace=this.svgBackground_=null},I.Flyout.prototype.getWidth=function(){return this.width_},I.Flyout.prototype.getHeight=function(){return this.height_},I.Flyout.prototype.getFlyoutScale=function(){return this.targetWorkspace.scale},I.Flyout.prototype.getWorkspace=function(){return this.workspace_},I.Flyout.prototype.isVisible=function(){return this.isVisible_},I.Flyout.prototype.setVisible=function(t){var e=t!=this.isVisible();this.isVisible_=t,e&&this.updateDisplay_()},I.Flyout.prototype.setContainerVisible=function(t){var e=t!=this.containerVisible_;this.containerVisible_=t,e&&this.updateDisplay_()},I.Flyout.prototype.updateDisplay_=function(){var t=!!this.containerVisible_&&this.isVisible();this.svgGroup_.style.display=t?"block":"none",this.workspace_.scrollbar.setContainerVisible(t)},I.Flyout.prototype.positionAt_=function(t,e,o,i){this.svgGroup_.setAttribute("width",t),this.svgGroup_.setAttribute("height",e),this.workspace_.setCachedParentSvgSize(t,e),"svg"==this.svgGroup_.tagName?I.utils.dom.setCssTransform(this.svgGroup_,"translate("+o+"px,"+i+"px)"):this.svgGroup_.setAttribute("transform","translate("+o+","+i+")"),(t=this.workspace_.scrollbar)&&(t.setOrigin(o,i),t.resize(),t.hScroll&&t.hScroll.setPosition(t.hScroll.position.x,t.hScroll.position.y),t.vScroll&&t.vScroll.setPosition(t.vScroll.position.x,t.vScroll.position.y))},I.Flyout.prototype.hide=function(){if(this.isVisible()){this.setVisible(!1);for(var t=0,e;e=this.listeners_[t];t++)I.browserEvents.unbind(e);this.listeners_.length=0,this.reflowWrapper_&&(this.workspace_.removeChangeListener(this.reflowWrapper_),this.reflowWrapper_=null)}},I.Flyout.prototype.show=function(t){this.workspace_.setResizesEnabled(!1),this.hide(),this.clearOldBlocks_(),"string"==typeof t&&(t=this.getDynamicCategoryContents_(t)),this.setVisible(!0),t=I.utils.toolbox.convertFlyoutDefToJsonArray(t),t=this.createFlyoutInfo_(t),this.layout_(t.contents,t.gaps),this.listeners_.push(I.browserEvents.conditionalBind(this.svgBackground_,"mouseover",this,function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)o.removeSelect()})),this.horizontalLayout?this.height_=0:this.width_=0,this.workspace_.setResizesEnabled(!0),this.reflow(),this.filterForCapacity_(),this.position(),this.reflowWrapper_=this.reflow.bind(this),this.workspace_.addChangeListener(this.reflowWrapper_)},I.Flyout.prototype.createFlyoutInfo_=function(t){var e=[],o=[];this.permanentlyDisabled_.length=0;for(var i=this.horizontalLayout?this.GAP_X:this.GAP_Y,s=0,n;n=t[s];s++)switch(n.custom&&(n=this.getDynamicCategoryContents_(n.custom),n=I.utils.toolbox.convertFlyoutDefToJsonArray(n),t.splice.apply(t,[s,1].concat(n)),n=t[s]),n.kind.toUpperCase()){case"BLOCK":var r,l=this.getBlockXml_(r=n),n=this.createBlock_(l),r=parseInt(r.gap||l.getAttribute("gap"),10);o.push(isNaN(r)?i:r),e.push({type:"block",block:n});break;case"SEP":this.addSeparatorGap_(n,o,i);break;case"LABEL":n=this.createButton_(n,!0),e.push({type:"button",button:n}),o.push(i);break;case"BUTTON":n=this.createButton_(n,!1),e.push({type:"button",button:n}),o.push(i)}return{contents:e,gaps:o}},I.Flyout.prototype.getDynamicCategoryContents_=function(t){if("function"!=typeof(t=this.workspace_.targetWorkspace.getToolboxCategoryCallback(t)))throw TypeError("Couldn't find a callback function when opening a toolbox category.");if(t=t(this.workspace_.targetWorkspace),!Array.isArray(t))throw new TypeError("Result of toolbox category callback must be an array.");return t},I.Flyout.prototype.createButton_=function(t,e){if(!I.FlyoutButton)throw Error("Missing require for Blockly.FlyoutButton");return new I.FlyoutButton(this.workspace_,this.targetWorkspace,t,e)},I.Flyout.prototype.createBlock_=function(t){return(t=I.Xml.domToBlock(t,this.workspace_)).isEnabled()||this.permanentlyDisabled_.push(t),t},I.Flyout.prototype.getBlockXml_=function(t){var e=null,o=t.blockxml;if(o&&"string"!=typeof o?e=o:o&&"string"==typeof o?(e=I.Xml.textToDom(o),t.blockxml=e):t.type&&((e=I.utils.xml.createElement("xml")).setAttribute("type",t.type),e.setAttribute("disabled",t.disabled),t.blockxml=e),!e)throw Error("Error: Invalid block definition. Block definition must have blockxml or type.");return e},I.Flyout.prototype.addSeparatorGap_=function(t,e,o){t=parseInt(t.gap,10),!isNaN(t)&&0<e.length?e[e.length-1]=t:e.push(o)},I.Flyout.prototype.clearOldBlocks_=function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)o.workspace==this.workspace_&&o.dispose(!1,!1);for(e=0;e<this.mats_.length;e++)(t=this.mats_[e])&&(I.Tooltip.unbindMouseEvents(t),I.utils.dom.removeNode(t));for(e=this.mats_.length=0;t=this.buttons_[e];e++)t.dispose();this.buttons_.length=0,this.workspace_.getPotentialVariableMap().clear()},I.Flyout.prototype.addBlockListeners_=function(t,e,o){this.listeners_.push(I.browserEvents.conditionalBind(t,"mousedown",null,this.blockMouseDown_(e))),this.listeners_.push(I.browserEvents.conditionalBind(o,"mousedown",null,this.blockMouseDown_(e))),this.listeners_.push(I.browserEvents.bind(t,"mouseenter",e,e.addSelect)),this.listeners_.push(I.browserEvents.bind(t,"mouseleave",e,e.removeSelect)),this.listeners_.push(I.browserEvents.bind(o,"mouseenter",e,e.addSelect)),this.listeners_.push(I.browserEvents.bind(o,"mouseleave",e,e.removeSelect))},I.Flyout.prototype.blockMouseDown_=function(o){var i=this;return function(t){var e=i.targetWorkspace.getGesture(t);e&&(e.setStartBlock(o),e.handleFlyoutStart(t,i))}},I.Flyout.prototype.onMouseDown_=function(t){var e=this.targetWorkspace.getGesture(t);e&&e.handleFlyoutStart(t,this)},I.Flyout.prototype.isBlockCreatable_=function(t){return t.isEnabled()},I.Flyout.prototype.createBlock=function(t){var e=null;I.Events.disable();var o=this.targetWorkspace.getAllVariables();this.targetWorkspace.setResizesEnabled(!1);try{e=this.placeNewBlock_(t)}finally{I.Events.enable()}if(I.hideChaff(),t=I.Variables.getAddedVariables(this.targetWorkspace,o),I.Events.isEnabled()){for(I.Events.setGroup(!0),o=0;o<t.length;o++){var i=t[o];I.Events.fire(new(I.Events.get(I.Events.VAR_CREATE))(i))}I.Events.fire(new(I.Events.get(I.Events.BLOCK_CREATE))(e))}return this.autoClose?this.hide():this.filterForCapacity_(),e},I.Flyout.prototype.initFlyoutButton_=function(t,e,o){var i=t.createDom();t.moveTo(e,o),t.show(),this.listeners_.push(I.browserEvents.conditionalBind(i,"mousedown",this,this.onMouseDown_)),this.buttons_.push(t)},I.Flyout.prototype.createRect_=function(t,e,o,i,s){return(e=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{"fill-opacity":0,x:e,y:o,height:i.height,width:i.width},null)).tooltip=t,I.Tooltip.bindMouseEvents(e),this.workspace_.getCanvas().insertBefore(e,t.getSvgRoot()),t.flyoutRect_=e,this.mats_[s]=e},I.Flyout.prototype.moveRectToBlock_=function(t,e){var o=e.getHeightWidth();t.setAttribute("width",o.width),t.setAttribute("height",o.height),e=e.getRelativeToSurfaceXY(),t.setAttribute("y",e.y),t.setAttribute("x",this.RTL?e.x-o.width:e.x)},I.Flyout.prototype.filterForCapacity_=function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)if(-1==this.permanentlyDisabled_.indexOf(o))for(var i=this.targetWorkspace.isCapacityAvailable(I.utils.getBlockTypeCounts(o));o;)o.setEnabled(i),o=o.getNextBlock()},I.Flyout.prototype.reflow=function(){this.reflowWrapper_&&this.workspace_.removeChangeListener(this.reflowWrapper_),this.reflowInternal_(),this.reflowWrapper_&&this.workspace_.addChangeListener(this.reflowWrapper_)},I.Flyout.prototype.isScrollable=function(){return!!this.workspace_.scrollbar&&this.workspace_.scrollbar.isVisible()},I.Flyout.prototype.placeNewBlock_=function(t){var e=this.targetWorkspace;if(!t.getSvgRoot())throw Error("oldBlock is not rendered.");var o=I.Xml.blockToDom(t,!0);if(e.setResizesEnabled(!1),!(o=I.Xml.domToBlock(o,e)).getSvgRoot())throw Error("block is not rendered.");var i=e.getOriginOffsetInPixels(),s=this.workspace_.getOriginOffsetInPixels();return(t=t.getRelativeToSurfaceXY()).scale(this.workspace_.scale),t=I.utils.Coordinate.sum(s,t),(i=I.utils.Coordinate.difference(t,i)).scale(1/e.scale),o.moveBy(i.x,i.y),o},I.HorizontalFlyout=function(t){I.HorizontalFlyout.superClass_.constructor.call(this,t),this.horizontalLayout=!0},I.utils.object.inherits(I.HorizontalFlyout,I.Flyout),I.HorizontalFlyout.prototype.setMetrics_=function(t){var e,o,i,e;this.isVisible()&&(o=(e=this.workspace_.getMetricsManager()).getScrollMetrics(),i=e.getViewMetrics(),e=e.getAbsoluteMetrics(),"number"==typeof t.x&&(this.workspace_.scrollX=-(o.left+(o.width-i.width)*t.x)),this.workspace_.translate(this.workspace_.scrollX+e.left,this.workspace_.scrollY+e.top))},I.HorizontalFlyout.prototype.getX=function(){return 0},I.HorizontalFlyout.prototype.getY=function(){if(!this.isVisible())return 0;var t,e=(t=this.targetWorkspace.getMetricsManager()).getAbsoluteMetrics(),o=t.getViewMetrics(),t=t.getToolboxMetrics(),i=this.toolboxPosition_==I.utils.toolbox.Position.TOP;return this.targetWorkspace.toolboxPosition==this.toolboxPosition_?this.targetWorkspace.getToolbox()?i?t.height:o.height-this.height_:i?0:o.height:i?0:o.height+e.top-this.height_},I.HorizontalFlyout.prototype.position=function(){var t,t,e;this.isVisible()&&this.targetWorkspace.isVisible()&&(t=this.targetWorkspace.getMetricsManager().getViewMetrics(),this.width_=t.width,this.setBackgroundPath_(t.width-2*this.CORNER_RADIUS,this.height_-this.CORNER_RADIUS),t=this.getX(),e=this.getY(),this.positionAt_(this.width_,this.height_,t,e))},I.HorizontalFlyout.prototype.setBackgroundPath_=function(t,e){var o=this.toolboxPosition_==I.utils.toolbox.Position.TOP,i=["M 0,"+(o?0:this.CORNER_RADIUS)];o?(i.push("h",t+2*this.CORNER_RADIUS),i.push("v",e),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,-this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("h",-t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,-this.CORNER_RADIUS,-this.CORNER_RADIUS)):(i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,this.CORNER_RADIUS,-this.CORNER_RADIUS),i.push("h",t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("v",e),i.push("h",-t-2*this.CORNER_RADIUS)),i.push("z"),this.svgBackground_.setAttribute("d",i.join(" "))},I.HorizontalFlyout.prototype.scrollToStart=function(){this.workspace_.scrollbar.setX(this.RTL?1/0:0)},I.HorizontalFlyout.prototype.wheel_=function(t){var e=I.utils.getScrollDeltaPixels(t),o,i,e;(e=e.x||e.y)&&(i=(o=this.workspace_.getMetricsManager()).getScrollMetrics(),e=o.getViewMetrics().left-i.left+e,this.workspace_.scrollbar.setX(e),I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation()),t.preventDefault(),t.stopPropagation()},I.HorizontalFlyout.prototype.layout_=function(t,e){this.workspace_.scale=this.targetWorkspace.scale;var o=this.MARGIN,i=o+this.tabWidth_;this.RTL&&(t=t.reverse());for(var s=0,n;n=t[s];s++)if("block"==n.type){for(var n,r=(n=n.block).getDescendants(!1),l=0,a;a=r[l];l++)a.isInFlyout=!0;n.render(),r=n.getSvgRoot(),l=n.getHeightWidth(),a=n.outputConnection?this.tabWidth_:0,a=this.RTL?i+l.width:i-a,n.moveBy(a,o),a=this.createRect_(n,a,o,l,s),i+=l.width+e[s],this.addBlockListeners_(r,n,a)}else"button"==n.type&&(this.initFlyoutButton_(n.button,i,o),i+=n.button.width+e[s])},I.HorizontalFlyout.prototype.isDragTowardWorkspace=function(t){t=Math.atan2(t.y,t.x)/Math.PI*180;var e=this.dragAngleRange_;return t<90+e&&90-e<t||-90-e<t&&t<-90+e},I.HorizontalFlyout.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t=this.svgGroup_.getBoundingClientRect(),e=t.top;return this.toolboxPosition_==I.utils.toolbox.Position.TOP?new I.utils.Rect(-1e9,e+t.height,-1e9,1e9):new I.utils.Rect(e,1e9,-1e9,1e9)},I.HorizontalFlyout.prototype.reflowInternal_=function(){this.workspace_.scale=this.getFlyoutScale();for(var t=0,e=this.workspace_.getTopBlocks(!1),o=0,i;i=e[o];o++)t=Math.max(t,i.getHeightWidth().height);if(t+=1.5*this.MARGIN,t*=this.workspace_.scale,t+=I.Scrollbar.scrollbarThickness,this.height_!=t){for(o=0;i=e[o];o++)i.flyoutRect_&&this.moveRectToBlock_(i.flyoutRect_,i);this.targetWorkspace.toolboxPosition!=this.toolboxPosition_||this.toolboxPosition_!=I.utils.toolbox.Position.TOP||this.targetWorkspace.getToolbox()||this.targetWorkspace.translate(this.targetWorkspace.scrollX,this.targetWorkspace.scrollY+t),this.height_=t,this.position()}},I.registry.register(I.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,I.registry.DEFAULT,I.HorizontalFlyout),I.VerticalFlyout=function(t){I.VerticalFlyout.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.VerticalFlyout,I.Flyout),I.VerticalFlyout.registryName="verticalFlyout",I.VerticalFlyout.prototype.setMetrics_=function(t){var e,o,i,e;this.isVisible()&&(o=(e=this.workspace_.getMetricsManager()).getScrollMetrics(),i=e.getViewMetrics(),e=e.getAbsoluteMetrics(),"number"==typeof t.y&&(this.workspace_.scrollY=-(o.top+(o.height-i.height)*t.y)),this.workspace_.translate(this.workspace_.scrollX+e.left,this.workspace_.scrollY+e.top))},I.VerticalFlyout.prototype.getX=function(){if(!this.isVisible())return 0;var t,e=(t=this.targetWorkspace.getMetricsManager()).getAbsoluteMetrics(),o=t.getViewMetrics(),t=t.getToolboxMetrics();return this.targetWorkspace.toolboxPosition==this.toolboxPosition_?this.targetWorkspace.getToolbox()?this.toolboxPosition_==I.utils.toolbox.Position.LEFT?t.width:o.width-this.width_:this.toolboxPosition_==I.utils.toolbox.Position.LEFT?0:o.width:this.toolboxPosition_==I.utils.toolbox.Position.LEFT?0:o.width+e.left-this.width_},I.VerticalFlyout.prototype.getY=function(){return 0},I.VerticalFlyout.prototype.position=function(){var t,t,e;this.isVisible()&&this.targetWorkspace.isVisible()&&(t=this.targetWorkspace.getMetricsManager().getViewMetrics(),this.height_=t.height,this.setBackgroundPath_(this.width_-this.CORNER_RADIUS,t.height-2*this.CORNER_RADIUS),t=this.getX(),e=this.getY(),this.positionAt_(this.width_,this.height_,t,e))},I.VerticalFlyout.prototype.setBackgroundPath_=function(t,e){var o=this.toolboxPosition_==I.utils.toolbox.Position.RIGHT,i=t+this.CORNER_RADIUS,i;(i=["M "+(o?i:0)+",0"]).push("h",o?-t:t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,o?0:1,o?-this.CORNER_RADIUS:this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("v",Math.max(0,e)),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,o?0:1,o?this.CORNER_RADIUS:-this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("h",o?t:-t),i.push("z"),this.svgBackground_.setAttribute("d",i.join(" "))},I.VerticalFlyout.prototype.scrollToStart=function(){this.workspace_.scrollbar.setY(0)},I.VerticalFlyout.prototype.wheel_=function(t){var e=I.utils.getScrollDeltaPixels(t),o,i,e;e.y&&(i=(o=this.workspace_.getMetricsManager()).getScrollMetrics(),e=o.getViewMetrics().top-i.top+e.y,this.workspace_.scrollbar.setY(e),I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation()),t.preventDefault(),t.stopPropagation()},I.VerticalFlyout.prototype.layout_=function(t,e){this.workspace_.scale=this.targetWorkspace.scale;for(var o=this.MARGIN,i=this.RTL?o:o+this.tabWidth_,s=0,n;n=t[s];s++)if("block"==n.type){for(var n,r=(n=n.block).getDescendants(!1),l=0,a;a=r[l];l++)a.isInFlyout=!0;n.render(),r=n.getSvgRoot(),l=n.getHeightWidth(),a=n.outputConnection?i-this.tabWidth_:i,n.moveBy(a,o),a=this.createRect_(n,this.RTL?a-l.width:a,o,l,s),this.addBlockListeners_(r,n,a),o+=l.height+e[s]}else"button"==n.type&&(this.initFlyoutButton_(n.button,i,o),o+=n.button.height+e[s])},I.VerticalFlyout.prototype.isDragTowardWorkspace=function(t){t=Math.atan2(t.y,t.x)/Math.PI*180;var e=this.dragAngleRange_;return t<e&&-e<t||t<-180+e||180-e<t},I.VerticalFlyout.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t=this.svgGroup_.getBoundingClientRect(),e=t.left;return this.toolboxPosition_==I.utils.toolbox.Position.LEFT?new I.utils.Rect(-1e9,1e9,-1e9,e+t.width):new I.utils.Rect(-1e9,1e9,e,1e9)},I.VerticalFlyout.prototype.reflowInternal_=function(){this.workspace_.scale=this.getFlyoutScale();for(var t=0,e=this.workspace_.getTopBlocks(!1),o=0,i,s,n;i=e[o];o++){var s=i.getHeightWidth().width;i.outputConnection&&(s-=this.tabWidth_),t=Math.max(t,s)}for(o=0;i=this.buttons_[o];o++)t=Math.max(t,i.width);if(t+=1.5*this.MARGIN+this.tabWidth_,t*=this.workspace_.scale,t+=I.Scrollbar.scrollbarThickness,this.width_!=t){for(o=0;i=e[o];o++){this.RTL&&(s=i.getRelativeToSurfaceXY().x,n=t/this.workspace_.scale-this.MARGIN,i.outputConnection||(n-=this.tabWidth_),i.moveBy(n-s,0)),i.flyoutRect_&&this.moveRectToBlock_(i.flyoutRect_,i)}if(this.RTL)for(o=0;i=this.buttons_[o];o++)e=i.getPosition().y,i.moveTo(t/this.workspace_.scale-i.width-this.MARGIN-this.tabWidth_,e);this.targetWorkspace.toolboxPosition!=this.toolboxPosition_||this.toolboxPosition_!=I.utils.toolbox.Position.LEFT||this.targetWorkspace.getToolbox()||this.targetWorkspace.translate(this.targetWorkspace.scrollX+t,this.targetWorkspace.scrollY),this.width_=t,this.position()}},I.registry.register(I.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,I.registry.DEFAULT,I.VerticalFlyout),I.FlyoutButton=function(t,e,o,i){this.workspace_=t,this.targetWorkspace_=e,this.text_=o.text,this.position_=new I.utils.Coordinate(0,0),this.isLabel_=i,this.callbackKey_=o.callbackKey||o.callbackkey,this.cssClass_=o["web-class"]||null,this.onMouseUpWrapper_=null,this.info=o},I.FlyoutButton.MARGIN_X=5,I.FlyoutButton.MARGIN_Y=2,I.FlyoutButton.prototype.width=0,I.FlyoutButton.prototype.height=0,I.FlyoutButton.prototype.createDom=function(){var t=this.isLabel_?"blocklyFlyoutLabel":"blocklyFlyoutButton",e;this.cssClass_&&(t+=" "+this.cssClass_),this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:t},this.workspace_.getCanvas()),this.isLabel_||(e=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyFlyoutButtonShadow",rx:4,ry:4,x:1,y:1},this.svgGroup_));var t=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:this.isLabel_?"blocklyFlyoutLabelBackground":"blocklyFlyoutButtonBackground",rx:4,ry:4},this.svgGroup_),o=I.utils.dom.createSvgElement(I.utils.Svg.TEXT,{class:this.isLabel_?"blocklyFlyoutLabelText":"blocklyText",x:0,y:0,"text-anchor":"middle"},this.svgGroup_),i=I.utils.replaceMessageReferences(this.text_);this.workspace_.RTL&&(i+="‏"),o.textContent=i,this.isLabel_&&(this.svgText_=o,this.workspace_.getThemeManager().subscribe(this.svgText_,"flyoutForegroundColour","fill"));var s=I.utils.style.getComputedStyle(o,"fontSize"),n=I.utils.style.getComputedStyle(o,"fontWeight"),r=I.utils.style.getComputedStyle(o,"fontFamily");return this.width=I.utils.dom.getFastTextWidthWithSizeString(o,s,n,r),i=I.utils.dom.measureFontMetrics(i,s,n,r),this.height=i.height,this.isLabel_||(this.width+=2*I.FlyoutButton.MARGIN_X,this.height+=2*I.FlyoutButton.MARGIN_Y,e.setAttribute("width",this.width),e.setAttribute("height",this.height)),t.setAttribute("width",this.width),t.setAttribute("height",this.height),o.setAttribute("x",this.width/2),o.setAttribute("y",this.height/2-i.height/2+i.baseline),this.updateTransform_(),this.onMouseUpWrapper_=I.browserEvents.conditionalBind(this.svgGroup_,"mouseup",this,this.onMouseUp_),this.svgGroup_},I.FlyoutButton.prototype.show=function(){this.updateTransform_(),this.svgGroup_.setAttribute("display","block")},I.FlyoutButton.prototype.updateTransform_=function(){this.svgGroup_.setAttribute("transform","translate("+this.position_.x+","+this.position_.y+")")},I.FlyoutButton.prototype.moveTo=function(t,e){this.position_.x=t,this.position_.y=e,this.updateTransform_()},I.FlyoutButton.prototype.isLabel=function(){return this.isLabel_},I.FlyoutButton.prototype.getPosition=function(){return this.position_},I.FlyoutButton.prototype.getButtonText=function(){return this.text_},I.FlyoutButton.prototype.getTargetWorkspace=function(){return this.targetWorkspace_},I.FlyoutButton.prototype.dispose=function(){this.onMouseUpWrapper_&&I.browserEvents.unbind(this.onMouseUpWrapper_),this.svgGroup_&&I.utils.dom.removeNode(this.svgGroup_),this.svgText_&&this.workspace_.getThemeManager().unsubscribe(this.svgText_)},I.FlyoutButton.prototype.onMouseUp_=function(t){(t=this.targetWorkspace_.getGesture(t))&&t.cancel(),this.isLabel_&&this.callbackKey_?console.warn("Labels should not have callbacks. Label text: "+this.text_):this.isLabel_||this.callbackKey_&&this.targetWorkspace_.getButtonCallback(this.callbackKey_)?this.isLabel_||this.targetWorkspace_.getButtonCallback(this.callbackKey_)(this):console.warn("Buttons should have callbacks. Button text: "+this.text_)},I.Css.register(".blocklyFlyoutButton {,fill: #888;,cursor: default;,},.blocklyFlyoutButtonShadow {,fill: #666;,},.blocklyFlyoutButton:hover {,fill: #aaa;,},.blocklyFlyoutLabel {,cursor: default;,},.blocklyFlyoutLabelBackground {,opacity: 0;,}".split(",")),I.Generator=function(t){this.name_=t,this.FUNCTION_NAME_PLACEHOLDER_REGEXP_=new RegExp(this.FUNCTION_NAME_PLACEHOLDER_,"g")},I.Generator.NAME_TYPE="generated_function",I.Generator.prototype.INFINITE_LOOP_TRAP=null,I.Generator.prototype.STATEMENT_PREFIX=null,I.Generator.prototype.STATEMENT_SUFFIX=null,I.Generator.prototype.INDENT="  ",I.Generator.prototype.COMMENT_WRAP=60,I.Generator.prototype.ORDER_OVERRIDES=[],I.Generator.prototype.isInitialized=null,I.Generator.prototype.workspaceToCode=function(t){t||(console.warn("No workspace specified in workspaceToCode call.  Guessing."),t=I.getMainWorkspace());var e=[];this.init(t),t=t.getTopBlocks(!0);for(var o=0,i;i=t[o];o++){var s=this.blockToCode(i);(s=Array.isArray(s)?s[0]:s)&&(i.outputConnection&&(s=this.scrubNakedValue(s),this.STATEMENT_PREFIX&&!i.suppressPrefixSuffix&&(s=this.injectId(this.STATEMENT_PREFIX,i)+s),this.STATEMENT_SUFFIX&&!i.suppressPrefixSuffix&&(s+=this.injectId(this.STATEMENT_SUFFIX,i))),e.push(s))}return e=e.join("\n"),e=(e=(e=(e=this.finish(e)).replace(/^\s+\n/,"")).replace(/\n\s+$/,"\n")).replace(/[ \t]+\n/g,"\n")},I.Generator.prototype.prefixLines=function(t,e){return e+t.replace(/(?!\n$)\n/g,"\n"+e)},I.Generator.prototype.allNestedComments=function(t){var e=[];t=t.getDescendants(!0);for(var o=0;o<t.length;o++){var i=t[o].getCommentText();i&&e.push(i)}return e.length&&e.push(""),e.join("\n")},I.Generator.prototype.blockToCode=function(t,e){if(!1===this.isInitialized&&console.warn("Generator init was not called before blockToCode was called."),!t)return"";if(!t.isEnabled())return e?"":this.blockToCode(t.getNextBlock());if(t.isInsertionMarker())return e?"":this.blockToCode(t.getChildren(!1)[0]);var o=this[t.type];if("function"!=typeof o)throw Error('Language "'+this.name_+'" does not know how to generate  code for block type "'+t.type+'".');if(o=o.call(t,t),Array.isArray(o)){if(!t.outputConnection)throw TypeError("Expecting string from statement block: "+t.type);return[this.scrub_(t,o[0],e),o[1]]}if("string"==typeof o)return this.STATEMENT_PREFIX&&!t.suppressPrefixSuffix&&(o=this.injectId(this.STATEMENT_PREFIX,t)+o),this.STATEMENT_SUFFIX&&!t.suppressPrefixSuffix&&(o+=this.injectId(this.STATEMENT_SUFFIX,t)),this.scrub_(t,o,e);if(null===o)return"";throw SyntaxError("Invalid code generated: "+o)},I.Generator.prototype.valueToCode=function(t,e,o){if(isNaN(o))throw TypeError("Expecting valid order from block: "+t.type);var i;if(!(i=t.getInputTargetBlock(e)))return"";if(""===(e=this.blockToCode(i)))return"";if(!Array.isArray(e))throw TypeError("Expecting tuple from value block: "+i.type);if(t=e[0],e=e[1],isNaN(e))throw TypeError("Expecting valid order from value block: "+i.type);if(!t)return"";var i=!1,s=Math.floor(o),n=Math.floor(e);if(s<=n&&(s!=n||0!=s&&99!=s))for(i=!0,s=0;s<this.ORDER_OVERRIDES.length;s++)if(this.ORDER_OVERRIDES[s][0]==o&&this.ORDER_OVERRIDES[s][1]==e){i=!1;break}return t=i?"("+t+")":t},I.Generator.prototype.statementToCode=function(t,e){if(t=t.getInputTargetBlock(e),"string"!=typeof(e=this.blockToCode(t)))throw TypeError("Expecting code from statement block: "+(t&&t.type));return e=e&&this.prefixLines(e,this.INDENT)},I.Generator.prototype.addLoopTrap=function(t,e){return this.INFINITE_LOOP_TRAP&&(t=this.prefixLines(this.injectId(this.INFINITE_LOOP_TRAP,e),this.INDENT)+t),this.STATEMENT_SUFFIX&&!e.suppressPrefixSuffix&&(t=this.prefixLines(this.injectId(this.STATEMENT_SUFFIX,e),this.INDENT)+t),this.STATEMENT_PREFIX&&!e.suppressPrefixSuffix&&(t+=this.prefixLines(this.injectId(this.STATEMENT_PREFIX,e),this.INDENT)),t},I.Generator.prototype.injectId=function(t,e){return e=e.id.replace(/\$/g,"$$$$"),t.replace(/%1/g,"'"+e+"'")},I.Generator.prototype.RESERVED_WORDS_="",I.Generator.prototype.addReservedWords=function(t){this.RESERVED_WORDS_+=t+","},I.Generator.prototype.FUNCTION_NAME_PLACEHOLDER_="{leCUI8hutHZI4480Dc}",I.Generator.prototype.provideFunction_=function(t,e){if(!this.definitions_[t]){var o=this.variableDB_.getDistinctName(t,I.PROCEDURE_CATEGORY_NAME),i;for(this.functionNames_[t]=o,e=e.join("\n").replace(this.FUNCTION_NAME_PLACEHOLDER_REGEXP_,o);i!=e;)e=(i=e).replace(/^(( {2})*) {2}/gm,"$1\0");e=e.replace(/\0/g,this.INDENT),this.definitions_[t]=e}return this.functionNames_[t]},I.Generator.prototype.init=function(t){},I.Generator.prototype.scrub_=function(t,e,o){return e},I.Generator.prototype.finish=function(t){return t},I.Generator.prototype.scrubNakedValue=function(t){return t},I.ToolboxItem=function(t,e,o){this.id_=t.toolboxitemid||I.utils.IdGenerator.getNextUniqueId(),this.level_=(this.parent_=o||null)?this.parent_.getLevel()+1:0,this.toolboxItemDef_=t,this.parentToolbox_=e,this.workspace_=this.parentToolbox_.getWorkspace()},I.ToolboxItem.prototype.init=function(){},I.ToolboxItem.prototype.getDiv=function(){return null},I.ToolboxItem.prototype.getId=function(){return this.id_},I.ToolboxItem.prototype.getParent=function(){return null},I.ToolboxItem.prototype.getLevel=function(){return this.level_},I.ToolboxItem.prototype.isSelectable=function(){return!1},I.ToolboxItem.prototype.isCollapsible=function(){return!1},I.ToolboxItem.prototype.dispose=function(){},I.ToolboxCategory=function(t,e,o){I.ToolboxCategory.superClass_.constructor.call(this,t,e,o),this.name_=I.utils.replaceMessageReferences(t.name),this.colour_=this.getColour_(t),this.labelDom_=this.iconDom_=this.rowContents_=this.rowDiv_=this.htmlDiv_=null,this.cssConfig_=this.makeDefaultCssConfig_(),I.utils.object.mixin(this.cssConfig_,t.cssconfig||t.cssConfig),this.isDisabled_=this.isHidden_=!1,this.flyoutItems_=[],this.parseContents_(t)},I.utils.object.inherits(I.ToolboxCategory,I.ToolboxItem),I.ToolboxCategory.registrationName="category",I.ToolboxCategory.nestedPadding=19,I.ToolboxCategory.borderWidth=8,I.ToolboxCategory.defaultBackgroundColour="#57e",I.ToolboxCategory.prototype.makeDefaultCssConfig_=function(){return{container:"blocklyToolboxCategory",row:"blocklyTreeRow",rowcontentcontainer:"blocklyTreeRowContentContainer",icon:"blocklyTreeIcon",label:"blocklyTreeLabel",contents:"blocklyToolboxContents",selected:"blocklyTreeSelected",openicon:"blocklyTreeIconOpen",closedicon:"blocklyTreeIconClosed"}},I.ToolboxCategory.prototype.parseContents_=function(t){var e=t.contents,o;if(t.custom)this.flyoutItems_=t.custom;else if(e){t=0;for(;o=e[t];t++)this.flyoutItems_.push(o)}},I.ToolboxCategory.prototype.init=function(){this.createDom_(),"true"==this.toolboxItemDef_.hidden&&this.hide()},I.ToolboxCategory.prototype.createDom_=function(){return this.htmlDiv_=this.createContainer_(),I.utils.aria.setRole(this.htmlDiv_,I.utils.aria.Role.TREEITEM),I.utils.aria.setState(this.htmlDiv_,I.utils.aria.State.SELECTED,!1),I.utils.aria.setState(this.htmlDiv_,I.utils.aria.State.LEVEL,this.level_),this.rowDiv_=this.createRowContainer_(),this.rowDiv_.style.pointerEvents="auto",this.htmlDiv_.appendChild(this.rowDiv_),this.rowContents_=this.createRowContentsContainer_(),this.rowContents_.style.pointerEvents="none",this.rowDiv_.appendChild(this.rowContents_),this.iconDom_=this.createIconDom_(),I.utils.aria.setRole(this.iconDom_,I.utils.aria.Role.PRESENTATION),this.rowContents_.appendChild(this.iconDom_),this.labelDom_=this.createLabelDom_(this.name_),this.rowContents_.appendChild(this.labelDom_),I.utils.aria.setState(this.htmlDiv_,I.utils.aria.State.LABELLEDBY,this.labelDom_.getAttribute("id")),this.addColourBorder_(this.colour_),this.htmlDiv_},I.ToolboxCategory.prototype.createContainer_=function(){var t=document.createElement("div");return I.utils.dom.addClass(t,this.cssConfig_.container),t},I.ToolboxCategory.prototype.createRowContainer_=function(){var t=document.createElement("div");I.utils.dom.addClass(t,this.cssConfig_.row);var e,e=(e=I.ToolboxCategory.nestedPadding*this.getLevel()).toString()+"px";return this.workspace_.RTL?t.style.paddingRight=e:t.style.paddingLeft=e,t},I.ToolboxCategory.prototype.createRowContentsContainer_=function(){var t=document.createElement("div");return I.utils.dom.addClass(t,this.cssConfig_.rowcontentcontainer),t},I.ToolboxCategory.prototype.createIconDom_=function(){var t=document.createElement("span");return this.parentToolbox_.isHorizontal()||I.utils.dom.addClass(t,this.cssConfig_.icon),t.style.display="inline-block",t},I.ToolboxCategory.prototype.createLabelDom_=function(t){var e=document.createElement("span");return e.setAttribute("id",this.getId()+".label"),e.textContent=t,I.utils.dom.addClass(e,this.cssConfig_.label),e},I.ToolboxCategory.prototype.refreshTheme=function(){this.colour_=this.getColour_(this.toolboxItemDef_),this.addColourBorder_(this.colour_)},I.ToolboxCategory.prototype.addColourBorder_=function(t){t&&(t=I.ToolboxCategory.borderWidth+"px solid "+(t||"#ddd"),this.workspace_.RTL?this.rowDiv_.style.borderRight=t:this.rowDiv_.style.borderLeft=t)},I.ToolboxCategory.prototype.getColour_=function(t){var e=t.categorystyle||t.categoryStyle;if(!(t=t.colour)||!e)return e?this.getColourfromStyle_(e):this.parseColour_(t);return console.warn('Toolbox category "'+this.name_+'" must not have both a style and a colour'),""},I.ToolboxCategory.prototype.getColourfromStyle_=function(t){var e=this.workspace_.getTheme();if(t&&e){if((e=e.categoryStyles[t])&&e.colour)return this.parseColour_(e.colour);console.warn('Style "'+t+'" must exist and contain a colour value')}return""},I.ToolboxCategory.prototype.getClickTarget=function(){return this.rowDiv_},I.ToolboxCategory.prototype.parseColour_=function(t){if(null==(t=I.utils.replaceMessageReferences(t))||""===t)return"";var e=Number(t);if(isNaN(e)){if(e=I.utils.colour.parse(t))return e;return console.warn('Toolbox category "'+this.name_+'" has unrecognized colour attribute: '+t),""}return I.hueToHex(e)},I.ToolboxCategory.prototype.openIcon_=function(t){t&&(I.utils.dom.removeClasses(t,this.cssConfig_.closedicon),I.utils.dom.addClass(t,this.cssConfig_.openicon))},I.ToolboxCategory.prototype.closeIcon_=function(t){t&&(I.utils.dom.removeClasses(t,this.cssConfig_.openicon),I.utils.dom.addClass(t,this.cssConfig_.closedicon))},I.ToolboxCategory.prototype.setVisible_=function(t){this.htmlDiv_.style.display=t?"block":"none",this.isHidden_=!t,this.parentToolbox_.getSelectedItem()==this&&this.parentToolbox_.clearSelection()},I.ToolboxCategory.prototype.hide=function(){this.setVisible_(!1)},I.ToolboxCategory.prototype.show=function(){this.setVisible_(!0)},I.ToolboxCategory.prototype.isVisible=function(){return!this.isHidden_&&this.allAncestorsExpanded_()},I.ToolboxCategory.prototype.allAncestorsExpanded_=function(){for(var t=this;t.getParent();)if(!(t=t.getParent()).isExpanded())return!1;return!0},I.ToolboxCategory.prototype.isSelectable=function(){return this.isVisible()&&!this.isDisabled_},I.ToolboxCategory.prototype.onClick=function(t){},I.ToolboxCategory.prototype.setSelected=function(t){var e;t?(e=this.parseColour_(I.ToolboxCategory.defaultBackgroundColour),this.rowDiv_.style.backgroundColor=this.colour_||e,I.utils.dom.addClass(this.rowDiv_,this.cssConfig_.selected)):(this.rowDiv_.style.backgroundColor="",I.utils.dom.removeClass(this.rowDiv_,this.cssConfig_.selected)),I.utils.aria.setState(this.htmlDiv_,I.utils.aria.State.SELECTED,t)},I.ToolboxCategory.prototype.setDisabled=function(t){this.isDisabled_=t,this.getDiv().setAttribute("disabled",t),t?this.getDiv().setAttribute("disabled","true"):this.getDiv().removeAttribute("disabled")},I.ToolboxCategory.prototype.getName=function(){return this.name_},I.ToolboxCategory.prototype.getParent=function(){return this.parent_},I.ToolboxCategory.prototype.getDiv=function(){return this.htmlDiv_},I.ToolboxCategory.prototype.getContents=function(){return this.flyoutItems_},I.ToolboxCategory.prototype.updateFlyoutContents=function(t){this.flyoutItems_=[],"string"==typeof t?this.toolboxItemDef_.custom=t:(delete this.toolboxItemDef_.custom,this.toolboxItemDef_.contents=I.utils.toolbox.convertFlyoutDefToJsonArray(t)),this.parseContents_(this.toolboxItemDef_)},I.ToolboxCategory.prototype.dispose=function(){I.utils.dom.removeNode(this.htmlDiv_)},I.Css.register([".blocklyTreeRow:not(.blocklyTreeSelected):hover {","background-color: rgba(255, 255, 255, 0.2);","}",'.blocklyToolboxDiv[layout="h"] .blocklyToolboxCategory {',"margin: 1px 5px 1px 0;","}",'.blocklyToolboxDiv[dir="RTL"][layout="h"] .blocklyToolboxCategory {',"margin: 1px 0 1px 5px;","}",".blocklyTreeRow {","height: 22px;","line-height: 22px;","margin-bottom: 3px;","padding-right: 8px;","white-space: nowrap;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeRow {',"margin-left: 8px;","padding-right: 0px","}",".blocklyTreeIcon {","height: 16px;","vertical-align: middle;","visibility: hidden;","width: 16px;","}",".blocklyTreeIconClosed {","background-position: -32px -1px;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeIconClosed {',"background-position: 0 -1px;","}",".blocklyTreeSelected>.blocklyTreeIconClosed {","background-position: -32px -17px;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeSelected>.blocklyTreeIconClosed {',"background-position: 0 -17px;","}",".blocklyTreeIconOpen {","background-position: -16px -1px;","}",".blocklyTreeSelected>.blocklyTreeIconOpen {","background-position: -16px -17px;","}",".blocklyTreeLabel {","cursor: default;","font: 16px sans-serif;","padding: 0 3px;","vertical-align: middle;","}",".blocklyToolboxDelete .blocklyTreeLabel {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyTreeSelected .blocklyTreeLabel {","color: #fff;","}"]),I.registry.register(I.registry.Type.TOOLBOX_ITEM,I.ToolboxCategory.registrationName,I.ToolboxCategory),I.ToolboxSeparator=function(t,e){I.ToolboxSeparator.superClass_.constructor.call(this,t,e),this.cssConfig_={container:"blocklyTreeSeparator"},I.utils.object.mixin(this.cssConfig_,t.cssconfig||t.cssConfig)},I.utils.object.inherits(I.ToolboxSeparator,I.ToolboxItem),I.ToolboxSeparator.registrationName="sep",I.ToolboxSeparator.prototype.init=function(){this.createDom_()},I.ToolboxSeparator.prototype.createDom_=function(){var t=document.createElement("div");return I.utils.dom.addClass(t,this.cssConfig_.container),this.htmlDiv_=t},I.ToolboxSeparator.prototype.getDiv=function(){return this.htmlDiv_},I.ToolboxSeparator.prototype.dispose=function(){I.utils.dom.removeNode(this.htmlDiv_)},I.Css.register('.blocklyTreeSeparator {,border-bottom: solid #e5e5e5 1px;,height: 0;,margin: 5px 0;,},.blocklyToolboxDiv[layout="h"] .blocklyTreeSeparator {,border-right: solid #e5e5e5 1px;,border-bottom: none;,height: auto;,margin: 0 5px 0 5px;,padding: 5px 0;,width: 0;,}'.split(",")),I.registry.register(I.registry.Type.TOOLBOX_ITEM,I.ToolboxSeparator.registrationName,I.ToolboxSeparator),I.CollapsibleToolboxCategory=function(t,e,o){this.subcategoriesDiv_=null,this.expanded_=!1,this.toolboxItems_=[],I.CollapsibleToolboxCategory.superClass_.constructor.call(this,t,e,o)},I.utils.object.inherits(I.CollapsibleToolboxCategory,I.ToolboxCategory),I.CollapsibleToolboxCategory.registrationName="collapsibleCategory",I.CollapsibleToolboxCategory.prototype.makeDefaultCssConfig_=function(){var t=I.CollapsibleToolboxCategory.superClass_.makeDefaultCssConfig_.call(this);return t.contents="blocklyToolboxContents",t},I.CollapsibleToolboxCategory.prototype.parseContents_=function(t){var e=t.contents,o=!0,i;if(t.custom)this.flyoutItems_=t.custom;else if(e){t=0;for(;i=e[t];t++)o=!I.registry.hasItem(I.registry.Type.TOOLBOX_ITEM,i.kind)||i.kind.toLowerCase()==I.ToolboxSeparator.registrationName&&o?(this.flyoutItems_.push(i),!0):(this.createToolboxItem_(i),!1)}},I.CollapsibleToolboxCategory.prototype.createToolboxItem_=function(t){var e=t.kind;"CATEGORY"==e.toUpperCase()&&I.utils.toolbox.isCategoryCollapsible(t)&&(e=I.CollapsibleToolboxCategory.registrationName),t=new(I.registry.getClass(I.registry.Type.TOOLBOX_ITEM,e))(t,this.parentToolbox_,this),this.toolboxItems_.push(t)},I.CollapsibleToolboxCategory.prototype.init=function(){I.CollapsibleToolboxCategory.superClass_.init.call(this),this.setExpanded("true"==this.toolboxItemDef_.expanded||this.toolboxItemDef_.expanded)},I.CollapsibleToolboxCategory.prototype.createDom_=function(){I.CollapsibleToolboxCategory.superClass_.createDom_.call(this);var t=this.getChildToolboxItems();return this.subcategoriesDiv_=this.createSubCategoriesDom_(t),I.utils.aria.setRole(this.subcategoriesDiv_,I.utils.aria.Role.GROUP),this.htmlDiv_.appendChild(this.subcategoriesDiv_),this.htmlDiv_},I.CollapsibleToolboxCategory.prototype.createIconDom_=function(){var t=document.createElement("span");return this.parentToolbox_.isHorizontal()||(I.utils.dom.addClass(t,this.cssConfig_.icon),t.style.visibility="visible"),t.style.display="inline-block",t},I.CollapsibleToolboxCategory.prototype.createSubCategoriesDom_=function(t){var e=document.createElement("div");I.utils.dom.addClass(e,this.cssConfig_.contents);for(var o=0;o<t.length;o++){var i=t[o];i.init();var s=i.getDiv();e.appendChild(s),i.getClickTarget&&i.getClickTarget().setAttribute("id",i.getId())}return e},I.CollapsibleToolboxCategory.prototype.setExpanded=function(t){this.expanded_!=t&&((this.expanded_=t)?(this.subcategoriesDiv_.style.display="block",this.openIcon_(this.iconDom_)):(this.subcategoriesDiv_.style.display="none",this.closeIcon_(this.iconDom_)),I.utils.aria.setState(this.htmlDiv_,I.utils.aria.State.EXPANDED,t),this.parentToolbox_.handleToolboxItemResize())},I.CollapsibleToolboxCategory.prototype.setVisible_=function(t){this.htmlDiv_.style.display=t?"block":"none";for(var e=0,o;o=this.getChildToolboxItems()[e];e++)o.setVisible_(t);this.isHidden_=!t,this.parentToolbox_.getSelectedItem()==this&&this.parentToolbox_.clearSelection()},I.CollapsibleToolboxCategory.prototype.isExpanded=function(){return this.expanded_},I.CollapsibleToolboxCategory.prototype.isCollapsible=function(){return!0},I.CollapsibleToolboxCategory.prototype.onClick=function(t){this.toggleExpanded()},I.CollapsibleToolboxCategory.prototype.toggleExpanded=function(){this.setExpanded(!this.expanded_)},I.CollapsibleToolboxCategory.prototype.getDiv=function(){return this.htmlDiv_},I.CollapsibleToolboxCategory.prototype.getChildToolboxItems=function(){return this.toolboxItems_},I.registry.register(I.registry.Type.TOOLBOX_ITEM,I.CollapsibleToolboxCategory.registrationName,I.CollapsibleToolboxCategory),I.Events.ToolboxItemSelect=function(t,e,o){I.Events.ToolboxItemSelect.superClass_.constructor.call(this,o),this.oldItem=t,this.newItem=e},I.utils.object.inherits(I.Events.ToolboxItemSelect,I.Events.UiBase),I.Events.ToolboxItemSelect.prototype.type=I.Events.TOOLBOX_ITEM_SELECT,I.Events.ToolboxItemSelect.prototype.toJson=function(){var t=I.Events.ToolboxItemSelect.superClass_.toJson.call(this);return t.oldItem=this.oldItem,t.newItem=this.newItem,t},I.Events.ToolboxItemSelect.prototype.fromJson=function(t){I.Events.ToolboxItemSelect.superClass_.fromJson.call(this,t),this.oldItem=t.oldItem,this.newItem=t.newItem},I.registry.register(I.registry.Type.EVENT,I.Events.TOOLBOX_ITEM_SELECT,I.Events.ToolboxItemSelect),I.Toolbox=function(t){this.workspace_=t,this.toolboxDef_=t.options.languageTree||{contents:[]},this.horizontalLayout_=t.options.horizontalLayout,this.contentsDiv_=this.HtmlDiv=null,this.contents_=[],this.height_=this.width_=0,this.RTL=t.options.RTL,this.flyout_=null,this.contentMap_={},this.toolboxPosition=t.options.toolboxPosition,this.previouslySelectedItem_=this.selectedItem_=null,this.boundEvents_=[]},I.Toolbox.prototype.onShortcut=function(t){return!1},I.Toolbox.prototype.init=function(){var t=this.workspace_,e=t.getParentSvg();this.flyout_=this.createFlyout_(),this.HtmlDiv=this.createDom_(this.workspace_),I.utils.dom.insertAfter(this.flyout_.createDom("svg"),e),this.flyout_.init(t),this.render(this.toolboxDef_),(t=t.getThemeManager()).subscribe(this.HtmlDiv,"toolboxBackgroundColour","background-color"),t.subscribe(this.HtmlDiv,"toolboxForegroundColour","color")},I.Toolbox.prototype.createDom_=function(t){t=t.getParentSvg();var e=this.createContainer_();return this.contentsDiv_=this.createContentsContainer_(),this.contentsDiv_.tabIndex=0,I.utils.aria.setRole(this.contentsDiv_,I.utils.aria.Role.TREE),e.appendChild(this.contentsDiv_),t.parentNode.insertBefore(e,t),this.attachEvents_(e,this.contentsDiv_),e},I.Toolbox.prototype.createContainer_=function(){var t=document.createElement("div");return t.setAttribute("layout",this.isHorizontal()?"h":"v"),I.utils.dom.addClass(t,"blocklyToolboxDiv"),I.utils.dom.addClass(t,"blocklyNonSelectable"),t.setAttribute("dir",this.RTL?"RTL":"LTR"),t},I.Toolbox.prototype.createContentsContainer_=function(){var t=document.createElement("div");return I.utils.dom.addClass(t,"blocklyToolboxContents"),this.isHorizontal()&&(t.style.flexDirection="row"),t},I.Toolbox.prototype.attachEvents_=function(t,e){t=I.browserEvents.conditionalBind(t,"click",this,this.onClick_,!1,!0),this.boundEvents_.push(t),e=I.browserEvents.conditionalBind(e,"keydown",this,this.onKeyDown_,!1,!0),this.boundEvents_.push(e)},I.Toolbox.prototype.onClick_=function(t){var e;I.utils.isRightButton(t)||t.target==this.HtmlDiv?I.hideChaff(!1):(!(e=t.target.getAttribute("id"))||(e=this.getToolboxItemById(e)).isSelectable()&&(this.setSelectedItem(e),e.onClick(t)),I.hideChaff(!0)),I.Touch.clearTouchIdentifier()},I.Toolbox.prototype.onKeyDown_=function(t){var e=!1;switch(t.keyCode){case I.utils.KeyCodes.DOWN:e=this.selectNext_();break;case I.utils.KeyCodes.UP:e=this.selectPrevious_();break;case I.utils.KeyCodes.LEFT:e=this.selectParent_();break;case I.utils.KeyCodes.RIGHT:e=this.selectChild_();break;case I.utils.KeyCodes.ENTER:case I.utils.KeyCodes.SPACE:this.selectedItem_&&this.selectedItem_.isCollapsible()&&(this.selectedItem_.toggleExpanded(),e=!0);break;default:e=!1}(e=!e&&this.selectedItem_&&this.selectedItem_.onKeyDown?this.selectedItem_.onKeyDown(t):e)&&t.preventDefault()},I.Toolbox.prototype.createFlyout_=function(){var t=this.workspace_,e=new I.Options({parentWorkspace:t,rtl:t.RTL,oneBasedIndex:t.options.oneBasedIndex,horizontalLayout:t.horizontalLayout,renderer:t.options.renderer,rendererOverrides:t.options.rendererOverrides,move:{scrollbars:!0}});return e.toolboxPosition=t.options.toolboxPosition,new(t.horizontalLayout?I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,t.options,!0):I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,t.options,!0))(e)},I.Toolbox.prototype.render=function(t){this.toolboxDef_=t;for(var e=0;e<this.contents_.length;e++){var o=this.contents_[e];o&&o.dispose()}this.contents_=[],this.contentMap_={},this.renderContents_(t.contents),this.position()},I.Toolbox.prototype.renderContents_=function(t){for(var e=document.createDocumentFragment(),o=0,i;i=t[o];o++)this.createToolboxItem_(i,e);this.contentsDiv_.appendChild(e)},I.Toolbox.prototype.createToolboxItem_=function(t,e){var o=t.kind;"CATEGORY"==o.toUpperCase()&&I.utils.toolbox.isCategoryCollapsible(t)&&(o=I.CollapsibleToolboxCategory.registrationName),(o=I.registry.getClass(I.registry.Type.TOOLBOX_ITEM,o.toLowerCase()))&&(t=new o(t,this),this.addToolboxItem_(t),t.init(),(o=t.getDiv())&&e.appendChild(o),t.getClickTarget&&t.getClickTarget().setAttribute("id",t.getId()))},I.Toolbox.prototype.addToolboxItem_=function(t){if(this.contents_.push(t),(this.contentMap_[t.getId()]=t).isCollapsible())for(var e=0,o;o=t.getChildToolboxItems()[e];e++)this.addToolboxItem_(o)},I.Toolbox.prototype.getToolboxItems=function(){return this.contents_},I.Toolbox.prototype.addStyle=function(t){I.utils.dom.addClass(this.HtmlDiv,t)},I.Toolbox.prototype.removeStyle=function(t){I.utils.dom.removeClass(this.HtmlDiv,t)},I.Toolbox.prototype.getClientRect=function(){if(!this.HtmlDiv)return null;var t,e=(t=this.HtmlDiv.getBoundingClientRect()).top,o=e+t.height,i=t.left,t=i+t.width;return this.toolboxPosition==I.utils.toolbox.Position.TOP?new I.utils.Rect(-1e7,o,-1e7,1e7):this.toolboxPosition==I.utils.toolbox.Position.BOTTOM?new I.utils.Rect(e,1e7,-1e7,1e7):this.toolboxPosition==I.utils.toolbox.Position.LEFT?new I.utils.Rect(-1e7,1e7,-1e7,t):new I.utils.Rect(-1e7,1e7,i,1e7)},I.Toolbox.prototype.getToolboxItemById=function(t){return this.contentMap_[t]},I.Toolbox.prototype.getWidth=function(){return this.width_},I.Toolbox.prototype.getHeight=function(){return this.height_},I.Toolbox.prototype.getFlyout=function(){return this.flyout_},I.Toolbox.prototype.getWorkspace=function(){return this.workspace_},I.Toolbox.prototype.getSelectedItem=function(){return this.selectedItem_},I.Toolbox.prototype.getPreviouslySelectedItem=function(){return this.previouslySelectedItem_},I.Toolbox.prototype.isHorizontal=function(){return this.horizontalLayout_},I.Toolbox.prototype.position=function(){var t=this.workspace_.getMetrics(),e=this.HtmlDiv;e&&(this.horizontalLayout_?(e.style.left="0",e.style.height="auto",e.style.width="100%",this.height_=e.offsetHeight,this.width_=t.viewWidth,this.toolboxPosition==I.utils.toolbox.Position.TOP?e.style.top="0":e.style.bottom="0"):(this.toolboxPosition==I.utils.toolbox.Position.RIGHT?e.style.right="0":e.style.left="0",e.style.height="100%",this.width_=e.offsetWidth,this.height_=t.viewHeight),this.flyout_.position())},I.Toolbox.prototype.handleToolboxItemResize=function(){var t=this.workspace_,e=this.HtmlDiv.getBoundingClientRect();t.translate(this.toolboxPosition==I.utils.toolbox.Position.LEFT?t.scrollX+e.width:t.scrollX,this.toolboxPosition==I.utils.toolbox.Position.TOP?t.scrollY+e.height:t.scrollY),I.svgResize(t)},I.Toolbox.prototype.clearSelection=function(){this.setSelectedItem(null)},I.Toolbox.prototype.refreshTheme=function(){for(var t=0;t<this.contents_.length;t++){var e=this.contents_[t];e.refreshTheme&&e.refreshTheme()}},I.Toolbox.prototype.refreshSelection=function(){this.selectedItem_&&this.selectedItem_.isSelectable()&&this.selectedItem_.getContents().length&&this.flyout_.show(this.selectedItem_.getContents())},I.Toolbox.prototype.setVisible=function(t){this.HtmlDiv.style.display=t?"block":"none"},I.Toolbox.prototype.setSelectedItem=function(t){var e=this.selectedItem_;!t&&!e||t&&!t.isSelectable()||(this.shouldDeselectItem_(e,t)&&null!=e&&this.deselectItem_(e),this.shouldSelectItem_(e,t)&&null!=t&&this.selectItem_(e,t),this.updateFlyout_(e,t),this.fireSelectEvent_(e,t))},I.Toolbox.prototype.shouldDeselectItem_=function(t,e){return null!=t&&(!t.isCollapsible()||t!=e)},I.Toolbox.prototype.shouldSelectItem_=function(t,e){return null!=e&&e!=t},I.Toolbox.prototype.deselectItem_=function(t){this.selectedItem_=null,(this.previouslySelectedItem_=t).setSelected(!1),I.utils.aria.setState(this.contentsDiv_,I.utils.aria.State.ACTIVEDESCENDANT,"")},I.Toolbox.prototype.selectItem_=function(t,e){this.selectedItem_=e,this.previouslySelectedItem_=t,e.setSelected(!0),I.utils.aria.setState(this.contentsDiv_,I.utils.aria.State.ACTIVEDESCENDANT,e.getId())},I.Toolbox.prototype.selectItemByPosition=function(t){-1<t&&t<this.contents_.length&&((t=this.contents_[t]).isSelectable()&&this.setSelectedItem(t))},I.Toolbox.prototype.updateFlyout_=function(t,e){(t!=e||e.isCollapsible())&&e&&e.getContents().length?(this.flyout_.show(e.getContents()),this.flyout_.scrollToStart()):this.flyout_.hide()},I.Toolbox.prototype.fireSelectEvent_=function(t,e){var o=t&&t.getName(),i=e&&e.getName();t==e&&(i=null),t=new(I.Events.get(I.Events.TOOLBOX_ITEM_SELECT))(o,i,this.workspace_.id),I.Events.fire(t)},I.Toolbox.prototype.selectParent_=function(){return!!this.selectedItem_&&(this.selectedItem_.isCollapsible()&&this.selectedItem_.isExpanded()?(this.selectedItem_.setExpanded(!1),!0):!(!this.selectedItem_.getParent()||!this.selectedItem_.getParent().isSelectable())&&(this.setSelectedItem(this.selectedItem_.getParent()),!0))},I.Toolbox.prototype.selectChild_=function(){if(!this.selectedItem_||!this.selectedItem_.isCollapsible())return!1;var t=this.selectedItem_;return t.isExpanded()?this.selectNext_():t.setExpanded(!0),!0},I.Toolbox.prototype.selectNext_=function(){if(!this.selectedItem_)return!1;var t=this.contents_.indexOf(this.selectedItem_)+1;if(-1<t&&t<this.contents_.length){for(var e=this.contents_[t];e&&!e.isSelectable();)e=this.contents_[++t];if(e&&e.isSelectable())return this.setSelectedItem(e),!0}return!1},I.Toolbox.prototype.selectPrevious_=function(){if(!this.selectedItem_)return!1;var t=this.contents_.indexOf(this.selectedItem_)-1;if(-1<t&&t<this.contents_.length){for(var e=this.contents_[t];e&&!e.isSelectable();)e=this.contents_[--t];if(e&&e.isSelectable())return this.setSelectedItem(e),!0}return!1},I.Toolbox.prototype.dispose=function(){this.flyout_.dispose();for(var t=0;t<this.contents_.length;t++)this.contents_[t].dispose();for(t=0;t<this.boundEvents_.length;t++)I.browserEvents.unbind(this.boundEvents_[t]);this.boundEvents_=[],this.contents_=[],this.workspace_.getThemeManager().unsubscribe(this.HtmlDiv),I.utils.dom.removeNode(this.HtmlDiv)},I.Css.register([".blocklyToolboxDelete {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyToolboxGrab {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyToolboxDiv {","background-color: #ddd;","overflow-x: visible;","overflow-y: auto;","padding: 4px 0 4px 0;","position: absolute;","z-index: 70;","-webkit-tap-highlight-color: transparent;","}",".blocklyToolboxContents {","display: flex;","flex-wrap: wrap;","flex-direction: column;","}",".blocklyToolboxContents:focus {","outline: none;","}"]),I.registry.register(I.registry.Type.TOOLBOX,I.registry.DEFAULT,I.Toolbox),I.Events.TrashcanOpen=function(t,e){I.Events.TrashcanOpen.superClass_.constructor.call(this,e),this.isOpen=t},I.utils.object.inherits(I.Events.TrashcanOpen,I.Events.UiBase),I.Events.TrashcanOpen.prototype.type=I.Events.TRASHCAN_OPEN,I.Events.TrashcanOpen.prototype.toJson=function(){var t=I.Events.TrashcanOpen.superClass_.toJson.call(this);return t.isOpen=this.isOpen,t},I.Events.TrashcanOpen.prototype.fromJson=function(t){I.Events.TrashcanOpen.superClass_.fromJson.call(this,t),this.isOpen=t.isOpen},I.registry.register(I.registry.Type.EVENT,I.Events.TRASHCAN_OPEN,I.Events.TrashcanOpen),I.IPlugin=function(){},I.IPositionable=function(){},I.Trashcan=function(t){this.workspace_=t,this.contents_=[],this.flyout=null,this.workspace_.options.maxTrashcanContents<=0||(t=new I.Options({scrollbars:!0,parentWorkspace:this.workspace_,rtl:this.workspace_.RTL,oneBasedIndex:this.workspace_.options.oneBasedIndex,renderer:this.workspace_.options.renderer,rendererOverrides:this.workspace_.options.rendererOverrides,move:{scrollbars:!0}}),this.workspace_.horizontalLayout?(t.toolboxPosition=this.workspace_.toolboxPosition==I.utils.toolbox.Position.TOP?I.utils.toolbox.Position.BOTTOM:I.utils.toolbox.Position.TOP,this.flyout=new(I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,this.workspace_.options,!0))(t)):(t.toolboxPosition=this.workspace_.toolboxPosition==I.utils.toolbox.Position.RIGHT?I.utils.toolbox.Position.LEFT:I.utils.toolbox.Position.RIGHT,this.flyout=new(I.registry.getClassFromOptions(I.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,this.workspace_.options,!0))(t)),this.workspace_.addChangeListener(this.onDelete_.bind(this)))},I.Trashcan.prototype.WIDTH_=47,I.Trashcan.prototype.BODY_HEIGHT_=44,I.Trashcan.prototype.LID_HEIGHT_=16,I.Trashcan.prototype.MARGIN_BOTTOM_=20,I.Trashcan.prototype.MARGIN_SIDE_=20,I.Trashcan.prototype.MARGIN_HOTSPOT_=10,I.Trashcan.prototype.SPRITE_LEFT_=0,I.Trashcan.prototype.SPRITE_TOP_=32,I.Trashcan.prototype.HAS_BLOCKS_LID_ANGLE_=.1,I.Trashcan.ANIMATION_LENGTH_=80,I.Trashcan.ANIMATION_FRAMES_=4,I.Trashcan.OPACITY_MIN_=.4,I.Trashcan.OPACITY_MAX_=.8,I.Trashcan.MAX_LID_ANGLE_=45,I.Trashcan.prototype.isLidOpen=!1,I.Trashcan.prototype.minOpenness_=0,I.Trashcan.prototype.svgGroup_=null,I.Trashcan.prototype.svgLid_=null,I.Trashcan.prototype.lidTask_=0,I.Trashcan.prototype.lidOpen_=0,I.Trashcan.prototype.left_=0,I.Trashcan.prototype.top_=0,I.Trashcan.prototype.createDom=function(){this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyTrash"},null);var t=String(Math.random()).substring(2),e=I.utils.dom.createSvgElement(I.utils.Svg.CLIPPATH,{id:"blocklyTrashBodyClipPath"+t},this.svgGroup_);I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:this.WIDTH_,height:this.BODY_HEIGHT_,y:this.LID_HEIGHT_},e);var o=I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{width:I.SPRITE.width,x:-this.SPRITE_LEFT_,height:I.SPRITE.height,y:-this.SPRITE_TOP_,"clip-path":"url(#blocklyTrashBodyClipPath"+t+")"},this.svgGroup_);return o.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",I.spritesBase64),e=I.utils.dom.createSvgElement(I.utils.Svg.CLIPPATH,{id:"blocklyTrashLidClipPath"+t},this.svgGroup_),I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:this.WIDTH_,height:this.LID_HEIGHT_},e),this.svgLid_=I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{width:I.SPRITE.width,x:-this.SPRITE_LEFT_,height:I.SPRITE.height,y:-this.SPRITE_TOP_,"clip-path":"url(#blocklyTrashLidClipPath"+t+")"},this.svgGroup_),this.svgLid_.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",I.spritesBase64),I.browserEvents.bind(this.svgGroup_,"mousedown",this,this.blockMouseDownWhenOpenable_),I.browserEvents.bind(this.svgGroup_,"mouseup",this,this.click),I.browserEvents.bind(o,"mouseover",this,this.mouseOver_),I.browserEvents.bind(o,"mouseout",this,this.mouseOut_),this.animateLid_(),this.svgGroup_},I.Trashcan.prototype.init=function(t){return 0<this.workspace_.options.maxTrashcanContents&&(I.utils.dom.insertAfter(this.flyout.createDom(I.utils.Svg.SVG),this.workspace_.getParentSvg()),this.flyout.init(this.workspace_)),this.verticalSpacing_=this.MARGIN_BOTTOM_+t,this.setLidOpen(!1),this.verticalSpacing_+this.BODY_HEIGHT_+this.LID_HEIGHT_},I.Trashcan.prototype.dispose=function(){this.svgGroup_&&(I.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.workspace_=this.svgLid_=null,clearTimeout(this.lidTask_)},I.Trashcan.prototype.hasContents_=function(){return!!this.contents_.length},I.Trashcan.prototype.contentsIsOpen=function(){return this.flyout.isVisible()},I.Trashcan.prototype.openFlyout=function(){if(!this.contentsIsOpen()){for(var t=[],e=0,o;o=this.contents_[e];e++)t[e]=I.Xml.textToDom(o);this.flyout.show(t),this.fireUiEvent_(!0)}},I.Trashcan.prototype.closeFlyout=function(){this.contentsIsOpen()&&(this.flyout.hide(),this.fireUiEvent_(!1))},I.Trashcan.prototype.emptyContents=function(){this.hasContents_()&&(this.contents_.length=0,this.setMinOpenness_(0),this.closeFlyout())},I.Trashcan.prototype.position=function(t,e){if(this.verticalSpacing_){this.left_=t.toolboxMetrics.position==I.utils.toolbox.Position.LEFT||this.workspace_.horizontalLayout&&!this.workspace_.RTL?t.viewMetrics.width+t.absoluteMetrics.left-this.WIDTH_-this.MARGIN_SIDE_-I.Scrollbar.scrollbarThickness:this.MARGIN_SIDE_+I.Scrollbar.scrollbarThickness;var o=this.BODY_HEIGHT_+this.LID_HEIGHT_,i=this.top_=t.absoluteMetrics.top+this.verticalSpacing_,s=t.absoluteMetrics.top+t.viewMetrics.height-o-this.verticalSpacing_;this.top_=(t=t.toolboxMetrics.position!==I.utils.toolbox.Position.BOTTOM)?s:i;for(var n=this.getBoundingRectangle(),r=0,l;l=e[r];r++)n.intersects(l)&&(this.top_=t?l.top-o-this.MARGIN_BOTTOM_:l.bottom+this.MARGIN_BOTTOM_,n=this.getBoundingRectangle(),r=-1);this.top_=I.utils.math.clamp(i,this.top_,s),this.svgGroup_.setAttribute("transform","translate("+this.left_+","+this.top_+")")}},I.Trashcan.prototype.getBoundingRectangle=function(){return new I.utils.Rect(this.top_,this.top_+this.BODY_HEIGHT_+this.LID_HEIGHT_,this.left_,this.left_+this.WIDTH_)},I.Trashcan.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t,e=(t=this.svgGroup_.getBoundingClientRect()).top+this.SPRITE_TOP_-this.MARGIN_HOTSPOT_,t=t.left+this.SPRITE_LEFT_-this.MARGIN_HOTSPOT_;return new I.utils.Rect(e,e+this.LID_HEIGHT_+this.BODY_HEIGHT_+2*this.MARGIN_HOTSPOT_,t,t+this.WIDTH_+2*this.MARGIN_HOTSPOT_)},I.Trashcan.prototype.setLidOpen=function(t){this.isLidOpen!=t&&(clearTimeout(this.lidTask_),this.isLidOpen=t,this.animateLid_())},I.Trashcan.prototype.animateLid_=function(){var t=I.Trashcan.ANIMATION_FRAMES_,e=1/(t+1);this.lidOpen_+=this.isLidOpen?e:-e,this.lidOpen_=Math.min(Math.max(this.lidOpen_,this.minOpenness_),1),this.setLidAngle_(this.lidOpen_*I.Trashcan.MAX_LID_ANGLE_),e=I.Trashcan.OPACITY_MIN_,this.svgGroup_.style.opacity=e+this.lidOpen_*(I.Trashcan.OPACITY_MAX_-e),this.lidOpen_>this.minOpenness_&&this.lidOpen_<1&&(this.lidTask_=setTimeout(this.animateLid_.bind(this),I.Trashcan.ANIMATION_LENGTH_/t))},I.Trashcan.prototype.setLidAngle_=function(t){var e=this.workspace_.toolboxPosition==I.utils.toolbox.Position.RIGHT||this.workspace_.horizontalLayout&&this.workspace_.RTL;this.svgLid_.setAttribute("transform","rotate("+(e?-t:t)+","+(e?4:this.WIDTH_-4)+","+(this.LID_HEIGHT_-2)+")")},I.Trashcan.prototype.setMinOpenness_=function(t){this.minOpenness_=t,this.isLidOpen||this.setLidAngle_(t*I.Trashcan.MAX_LID_ANGLE_)},I.Trashcan.prototype.closeLid=function(){this.setLidOpen(!1)},I.Trashcan.prototype.click=function(){this.hasContents_()&&this.openFlyout()},I.Trashcan.prototype.fireUiEvent_=function(t){t=new(I.Events.get(I.Events.TRASHCAN_OPEN))(t,this.workspace_.id),I.Events.fire(t)},I.Trashcan.prototype.blockMouseDownWhenOpenable_=function(t){!this.contentsIsOpen()&&this.hasContents_()&&t.stopPropagation()},I.Trashcan.prototype.mouseOver_=function(){this.hasContents_()&&this.setLidOpen(!0)},I.Trashcan.prototype.mouseOut_=function(){this.setLidOpen(!1)},I.Trashcan.prototype.onDelete_=function(t){if(!(this.workspace_.options.maxTrashcanContents<=0)&&t.type==I.Events.BLOCK_DELETE&&t.oldXml.tagName&&"shadow"!=t.oldXml.tagName.toLowerCase()&&(t=this.cleanBlockXML_(t.oldXml),-1==this.contents_.indexOf(t))){for(this.contents_.unshift(t);this.contents_.length>this.workspace_.options.maxTrashcanContents;)this.contents_.pop();this.setMinOpenness_(this.HAS_BLOCKS_LID_ANGLE_)}},I.Trashcan.prototype.cleanBlockXML_=function(t){for(var e=t=t.cloneNode(!0);e;){e.removeAttribute&&(e.removeAttribute("x"),e.removeAttribute("y"),e.removeAttribute("id"),e.removeAttribute("disabled"),"comment"==e.nodeName&&(e.removeAttribute("h"),e.removeAttribute("w"),e.removeAttribute("pinned")));var o=e.firstChild||e.nextSibling;if(!o)for(o=e.parentNode;o;){if(o.nextSibling){o=o.nextSibling;break}o=o.parentNode}e=o}return I.Xml.domToText(t)},I.VariablesDynamic={},I.VariablesDynamic.onCreateVariableButtonClick_String=function(t){I.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"String")},I.VariablesDynamic.onCreateVariableButtonClick_Number=function(t){I.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"Number")},I.VariablesDynamic.onCreateVariableButtonClick_Colour=function(t){I.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"Colour")},I.VariablesDynamic.flyoutCategory=function(t){var e=[],o=document.createElement("button");return o.setAttribute("text",I.Msg.NEW_STRING_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_STRING"),e.push(o),(o=document.createElement("button")).setAttribute("text",I.Msg.NEW_NUMBER_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_NUMBER"),e.push(o),(o=document.createElement("button")).setAttribute("text",I.Msg.NEW_COLOUR_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_COLOUR"),e.push(o),t.registerButtonCallback("CREATE_VARIABLE_STRING",I.VariablesDynamic.onCreateVariableButtonClick_String),t.registerButtonCallback("CREATE_VARIABLE_NUMBER",I.VariablesDynamic.onCreateVariableButtonClick_Number),t.registerButtonCallback("CREATE_VARIABLE_COLOUR",I.VariablesDynamic.onCreateVariableButtonClick_Colour),t=I.VariablesDynamic.flyoutCategoryBlocks(t),e=e.concat(t)},I.VariablesDynamic.flyoutCategoryBlocks=function(t){t=t.getAllVariables();var e=[],o,i,s;if(0<t.length&&(I.Blocks.variables_set_dynamic&&(o=t[t.length-1],(i=I.utils.xml.createElement("block")).setAttribute("type","variables_set_dynamic"),i.setAttribute("gap",24),i.appendChild(I.Variables.generateVariableFieldDom(o)),e.push(i)),I.Blocks.variables_get_dynamic)){t.sort(I.VariableModel.compareByName),o=0;for(;s=t[o];o++)(i=I.utils.xml.createElement("block")).setAttribute("type","variables_get_dynamic"),i.setAttribute("gap",8),i.appendChild(I.Variables.generateVariableFieldDom(s)),e.push(i)}return e},I.ZoomControls=function(t){this.workspace_=t,this.zoomResetGroup_=this.zoomOutGroup_=this.zoomInGroup_=this.verticalSpacing_=this.onZoomOutWrapper_=this.onZoomInWrapper_=this.onZoomResetWrapper_=null},I.ZoomControls.prototype.WIDTH_=32,I.ZoomControls.prototype.HEIGHT_=110,I.ZoomControls.prototype.MARGIN_BOTTOM_=20,I.ZoomControls.prototype.MARGIN_SIDE_=20,I.ZoomControls.prototype.svgGroup_=null,I.ZoomControls.prototype.left_=0,I.ZoomControls.prototype.top_=0,I.ZoomControls.prototype.createDom=function(){this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{},null);var t=String(Math.random()).substring(2);return this.createZoomOutSvg_(t),this.createZoomInSvg_(t),this.workspace_.isMovable()&&this.createZoomResetSvg_(t),this.svgGroup_},I.ZoomControls.prototype.init=function(t){return this.verticalSpacing_=this.MARGIN_BOTTOM_+t,this.verticalSpacing_+this.HEIGHT_},I.ZoomControls.prototype.dispose=function(){this.svgGroup_&&I.utils.dom.removeNode(this.svgGroup_),this.onZoomResetWrapper_&&I.browserEvents.unbind(this.onZoomResetWrapper_),this.onZoomInWrapper_&&I.browserEvents.unbind(this.onZoomInWrapper_),this.onZoomOutWrapper_&&I.browserEvents.unbind(this.onZoomOutWrapper_)},I.ZoomControls.prototype.getBoundingRectangle=function(){return new I.utils.Rect(this.top_,this.top_+this.HEIGHT_,this.left_,this.left_+this.WIDTH_)},I.ZoomControls.prototype.position=function(t,e){if(this.verticalSpacing_){this.left_=t.toolboxMetrics.position==I.utils.toolbox.Position.LEFT||this.workspace_.horizontalLayout&&!this.workspace_.RTL?t.viewMetrics.width+t.absoluteMetrics.left-this.WIDTH_-this.MARGIN_SIDE_-I.Scrollbar.scrollbarThickness:this.MARGIN_SIDE_+I.Scrollbar.scrollbarThickness;var o=this.top_=t.absoluteMetrics.top+this.verticalSpacing_,i=t.absoluteMetrics.top+t.viewMetrics.height-this.HEIGHT_-this.verticalSpacing_;this.top_=(t=t.toolboxMetrics.position!==I.utils.toolbox.Position.BOTTOM)?i:o,t?(this.zoomInGroup_.setAttribute("transform","translate(0, 43)"),this.zoomOutGroup_.setAttribute("transform","translate(0, 77)")):(this.zoomInGroup_.setAttribute("transform","translate(0, 34)"),this.zoomResetGroup_&&this.zoomResetGroup_.setAttribute("transform","translate(0, 77)"));for(var s=this.getBoundingRectangle(),n=0,r;r=e[n];n++)s.intersects(r)&&(this.top_=t?r.top-this.HEIGHT_-this.MARGIN_BOTTOM_:r.bottom+this.MARGIN_BOTTOM_,s=this.getBoundingRectangle(),n=-1);this.top_=I.utils.math.clamp(o,this.top_,i),this.svgGroup_.setAttribute("transform","translate("+this.left_+","+this.top_+")")}},I.ZoomControls.prototype.createZoomOutSvg_=function(t){this.zoomOutGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var e=I.utils.dom.createSvgElement(I.utils.Svg.CLIPPATH,{id:"blocklyZoomoutClipPath"+t},this.zoomOutGroup_);I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:32,height:32},e),I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{width:I.SPRITE.width,height:I.SPRITE.height,x:-64,y:-92,"clip-path":"url(#blocklyZoomoutClipPath"+t+")"},this.zoomOutGroup_).setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",I.spritesBase64),this.onZoomOutWrapper_=I.browserEvents.conditionalBind(this.zoomOutGroup_,"mousedown",null,this.zoom_.bind(this,-1))},I.ZoomControls.prototype.createZoomInSvg_=function(t){this.zoomInGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var e=I.utils.dom.createSvgElement(I.utils.Svg.CLIPPATH,{id:"blocklyZoominClipPath"+t},this.zoomInGroup_);I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:32,height:32},e),I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{width:I.SPRITE.width,height:I.SPRITE.height,x:-32,y:-92,"clip-path":"url(#blocklyZoominClipPath"+t+")"},this.zoomInGroup_).setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",I.spritesBase64),this.onZoomInWrapper_=I.browserEvents.conditionalBind(this.zoomInGroup_,"mousedown",null,this.zoom_.bind(this,1))},I.ZoomControls.prototype.zoom_=function(t,e){this.workspace_.markFocused(),this.workspace_.zoomCenter(t),this.fireZoomEvent_(),I.Touch.clearTouchIdentifier(),e.stopPropagation(),e.preventDefault()},I.ZoomControls.prototype.createZoomResetSvg_=function(t){this.zoomResetGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var t=I.utils.dom.createSvgElement(I.utils.Svg.CLIPPATH,{id:"blocklyZoomresetClipPath"+t},this.zoomResetGroup_);I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:32,height:32},t)},I.ZoomControls.prototype.resetZoom_=function(t){this.workspace_.markFocused();var e=Math.log(this.workspace_.options.zoomOptions.startScale/this.workspace_.scale)/Math.log(this.workspace_.options.zoomOptions.scaleSpeed);this.workspace_.beginCanvasTransition(),this.workspace_.zoomCenter(e),this.workspace_.scrollCenter(),setTimeout(this.workspace_.endCanvasTransition.bind(this.workspace_),500),this.fireZoomEvent_(),I.Touch.clearTouchIdentifier(),t.stopPropagation(),t.preventDefault()},I.ZoomControls.prototype.fireZoomEvent_=function(){var t=new(I.Events.get(I.Events.CLICK))(null,this.workspace_.id,"zoom_controls");I.Events.fire(t)},I.Css.register([".blocklyZoom>image, .blocklyZoom>svg>image {","opacity: .4;","}",".blocklyZoom>image:hover, .blocklyZoom>svg>image:hover {","opacity: .6;","}",".blocklyZoom>image:active, .blocklyZoom>svg>image:active {","opacity: .8;","}"]),I.ShortcutItems={},I.ShortcutItems.names={ESCAPE:"escape",DELETE:"delete",COPY:"copy",CUT:"cut",PASTE:"paste",UNDO:"undo",REDO:"redo"},I.ShortcutItems.registerEscape=function(){var t={name:I.ShortcutItems.names.ESCAPE,preconditionFn:function(t){return!t.options.readOnly},callback:function(){return I.hideChaff(),!0}};I.ShortcutRegistry.registry.register(t),I.ShortcutRegistry.registry.addKeyMapping(I.utils.KeyCodes.ESC,t.name)},I.ShortcutItems.registerDelete=function(){var t={name:I.ShortcutItems.names.DELETE,preconditionFn:function(t){return!t.options.readOnly&&I.selected&&I.selected.isDeletable()},callback:function(t,e){if(e.preventDefault(),I.Gesture.inProgress())return!1;return I.deleteBlock(I.selected),!0}};I.ShortcutRegistry.registry.register(t),I.ShortcutRegistry.registry.addKeyMapping(I.utils.KeyCodes.DELETE,t.name),I.ShortcutRegistry.registry.addKeyMapping(I.utils.KeyCodes.BACKSPACE,t.name)},I.ShortcutItems.registerCopy=function(){var t={name:I.ShortcutItems.names.COPY,preconditionFn:function(t){return!t.options.readOnly&&!I.Gesture.inProgress()&&I.selected&&I.selected.isDeletable()&&I.selected.isMovable()},callback:function(){return I.hideChaff(),I.copy(I.selected),!0}};I.ShortcutRegistry.registry.register(t);var e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.C,[I.utils.KeyCodes.CTRL]);I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.C,[I.utils.KeyCodes.ALT]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.C,[I.utils.KeyCodes.META]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name)},I.ShortcutItems.registerCut=function(){var t={name:I.ShortcutItems.names.CUT,preconditionFn:function(t){return!t.options.readOnly&&!I.Gesture.inProgress()&&I.selected&&I.selected.isDeletable()&&I.selected.isMovable()&&!I.selected.workspace.isFlyout},callback:function(){return I.copy(I.selected),I.deleteBlock(I.selected),!0}};I.ShortcutRegistry.registry.register(t);var e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.X,[I.utils.KeyCodes.CTRL]);I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.X,[I.utils.KeyCodes.ALT]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.X,[I.utils.KeyCodes.META]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name)},I.ShortcutItems.registerPaste=function(){var t={name:I.ShortcutItems.names.PASTE,preconditionFn:function(t){return!t.options.readOnly&&!I.Gesture.inProgress()},callback:function(){return I.paste()}};I.ShortcutRegistry.registry.register(t);var e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.V,[I.utils.KeyCodes.CTRL]);I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.V,[I.utils.KeyCodes.ALT]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.V,[I.utils.KeyCodes.META]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name)},I.ShortcutItems.registerUndo=function(){var t={name:I.ShortcutItems.names.UNDO,preconditionFn:function(t){return!t.options.readOnly&&!I.Gesture.inProgress()},callback:function(t){return I.hideChaff(),t.undo(!1),!0}};I.ShortcutRegistry.registry.register(t);var e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.CTRL]);I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.ALT]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.META]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name)},I.ShortcutItems.registerRedo=function(){var t={name:I.ShortcutItems.names.REDO,preconditionFn:function(t){return!I.Gesture.inProgress()&&!t.options.readOnly},callback:function(t){return I.hideChaff(),t.undo(!0),!0}};I.ShortcutRegistry.registry.register(t);var e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.SHIFT,I.utils.KeyCodes.CTRL]);I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.SHIFT,I.utils.KeyCodes.ALT]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Z,[I.utils.KeyCodes.SHIFT,I.utils.KeyCodes.META]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=I.ShortcutRegistry.registry.createSerializedKey(I.utils.KeyCodes.Y,[I.utils.KeyCodes.CTRL]),I.ShortcutRegistry.registry.addKeyMapping(e,t.name)},I.ShortcutItems.registerDefaultShortcuts=function(){I.ShortcutItems.registerEscape(),I.ShortcutItems.registerDelete(),I.ShortcutItems.registerCopy(),I.ShortcutItems.registerCut(),I.ShortcutItems.registerPaste(),I.ShortcutItems.registerUndo(),I.ShortcutItems.registerRedo()},I.ShortcutItems.registerDefaultShortcuts(),I.ContextMenuItems={},I.ContextMenuItems.registerUndo=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.UNDO},preconditionFn:function(t){return 0<t.workspace.getUndoStack().length?"enabled":"disabled"},callback:function(t){t.workspace.undo(!1)},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"undoWorkspace",weight:1})},I.ContextMenuItems.registerRedo=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.REDO},preconditionFn:function(t){return 0<t.workspace.getRedoStack().length?"enabled":"disabled"},callback:function(t){t.workspace.undo(!0)},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"redoWorkspace",weight:2})},I.ContextMenuItems.registerCleanup=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.CLEAN_UP},preconditionFn:function(t){return t.workspace.isMovable()?1<t.workspace.getTopBlocks(!1).length?"enabled":"disabled":"hidden"},callback:function(t){t.workspace.cleanUp()},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"cleanWorkspace",weight:3})},I.ContextMenuItems.toggleOption_=function(t,e){for(var o=0,i=0;i<e.length;i++)for(var s=e[i];s;)setTimeout(s.setCollapsed.bind(s,t),o),s=s.getNextBlock(),o+=10},I.ContextMenuItems.registerCollapse=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.COLLAPSE_ALL},preconditionFn:function(t){if(t.workspace.options.collapse){t=t.workspace.getTopBlocks(!1);for(var e=0;e<t.length;e++)for(var o=t[e];o;){if(!o.isCollapsed())return"enabled";o=o.getNextBlock()}return"disabled"}return"hidden"},callback:function(t){I.ContextMenuItems.toggleOption_(!0,t.workspace.getTopBlocks(!0))},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"collapseWorkspace",weight:4})},I.ContextMenuItems.registerExpand=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.EXPAND_ALL},preconditionFn:function(t){if(t.workspace.options.collapse){t=t.workspace.getTopBlocks(!1);for(var e=0;e<t.length;e++)for(var o=t[e];o;){if(o.isCollapsed())return"enabled";o=o.getNextBlock()}return"disabled"}return"hidden"},callback:function(t){I.ContextMenuItems.toggleOption_(!1,t.workspace.getTopBlocks(!0))},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"expandWorkspace",weight:5})},I.ContextMenuItems.addDeletableBlocks_=function(t,e){if(t.isDeletable())Array.prototype.push.apply(e,t.getDescendants(!1));else{t=t.getChildren(!1);for(var o=0;o<t.length;o++)I.ContextMenuItems.addDeletableBlocks_(t[o],e)}},I.ContextMenuItems.getDeletableBlocks_=function(t){var e=[];t=t.getTopBlocks(!0);for(var o=0;o<t.length;o++)I.ContextMenuItems.addDeletableBlocks_(t[o],e);return e},I.ContextMenuItems.deleteNext_=function(t,e){I.Events.setGroup(e);var o=t.shift();o&&(o.workspace?(o.dispose(!1,!0),setTimeout(I.ContextMenuItems.deleteNext_,10,t,e)):I.ContextMenuItems.deleteNext_(t,e)),I.Events.setGroup(!1)},I.ContextMenuItems.registerDeleteAll=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){if(t.workspace)return 1==(t=I.ContextMenuItems.getDeletableBlocks_(t.workspace).length)?I.Msg.DELETE_BLOCK:I.Msg.DELETE_X_BLOCKS.replace("%1",String(t))},preconditionFn:function(t){if(t.workspace)return 0<I.ContextMenuItems.getDeletableBlocks_(t.workspace).length?"enabled":"disabled"},callback:function(t){var e,o;t.workspace&&(t.workspace.cancelCurrentGesture(),e=I.ContextMenuItems.getDeletableBlocks_(t.workspace),o=I.utils.genUid(),e.length<2?I.ContextMenuItems.deleteNext_(e,o):I.confirm(I.Msg.DELETE_ALL_BLOCKS.replace("%1",e.length),function(t){t&&I.ContextMenuItems.deleteNext_(e,o)}))},scopeType:I.ContextMenuRegistry.ScopeType.WORKSPACE,id:"workspaceDelete",weight:6})},I.ContextMenuItems.registerWorkspaceOptions_=function(){I.ContextMenuItems.registerUndo(),I.ContextMenuItems.registerRedo(),I.ContextMenuItems.registerCleanup(),I.ContextMenuItems.registerCollapse(),I.ContextMenuItems.registerExpand(),I.ContextMenuItems.registerDeleteAll()},I.ContextMenuItems.registerDuplicate=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.DUPLICATE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.isDeletable()&&t.isMovable()?t.isDuplicatable()?"enabled":"disabled":"hidden"},callback:function(t){t.block&&I.duplicate(t.block)},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDuplicate",weight:1})},I.ContextMenuItems.registerComment=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.getCommentIcon()?I.Msg.REMOVE_COMMENT:I.Msg.ADD_COMMENT},preconditionFn:function(t){return t=t.block,I.utils.userAgent.IE||t.isInFlyout||!t.workspace.options.comments||t.isCollapsed()||!t.isEditable()?"hidden":"enabled"},callback:function(t){(t=t.block).getCommentIcon()?t.setCommentText(null):t.setCommentText("")},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockComment",weight:2})},I.ContextMenuItems.registerInline=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.getInputsInline()?I.Msg.EXTERNAL_INPUTS:I.Msg.INLINE_INPUTS},preconditionFn:function(t){if(!(t=t.block).isInFlyout&&t.isMovable()&&!t.isCollapsed())for(var e=1;e<t.inputList.length;e++)if(t.inputList[e-1].type!=I.inputTypes.STATEMENT&&t.inputList[e].type!=I.inputTypes.STATEMENT)return"enabled";return"hidden"},callback:function(t){t.block.setInputsInline(!t.block.getInputsInline())},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockInline",weight:3})},I.ContextMenuItems.registerCollapseExpandBlock=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.isCollapsed()?I.Msg.EXPAND_BLOCK:I.Msg.COLLAPSE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.isMovable()?"enabled":"hidden"},callback:function(t){t.block.setCollapsed(!t.block.isCollapsed())},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockCollapseExpand",weight:4})},I.ContextMenuItems.registerDisable=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.isEnabled()?I.Msg.DISABLE_BLOCK:I.Msg.ENABLE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.workspace.options.disable&&t.isEditable()?t.getInheritedDisabled()?"disabled":"enabled":"hidden"},callback:function(t){t=t.block;var e=I.Events.getGroup();e||I.Events.setGroup(!0),t.setEnabled(!t.isEnabled()),e||I.Events.setGroup(!1)},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDisable",weight:5})},I.ContextMenuItems.registerDelete=function(){I.ContextMenuRegistry.registry.register({displayText:function(t){var e=t.block;return t=e.getDescendants(!1).length,(e=e.getNextBlock())&&(t-=e.getDescendants(!1).length),1==t?I.Msg.DELETE_BLOCK:I.Msg.DELETE_X_BLOCKS.replace("%1",String(t))},preconditionFn:function(t){return!t.block.isInFlyout&&t.block.isDeletable()?"enabled":"hidden"},callback:function(t){I.Events.setGroup(!0),t.block.dispose(!0,!0),I.Events.setGroup(!1)},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDelete",weight:6})},I.ContextMenuItems.registerHelp=function(){I.ContextMenuRegistry.registry.register({displayText:function(){return I.Msg.HELP},preconditionFn:function(t){return("function"==typeof(t=t.block).helpUrl?t.helpUrl():t.helpUrl)?"enabled":"hidden"},callback:function(t){t.block.showHelp()},scopeType:I.ContextMenuRegistry.ScopeType.BLOCK,id:"blockHelp",weight:7})},I.ContextMenuItems.registerBlockOptions_=function(){I.ContextMenuItems.registerDuplicate(),I.ContextMenuItems.registerComment(),I.ContextMenuItems.registerInline(),I.ContextMenuItems.registerCollapseExpandBlock(),I.ContextMenuItems.registerDisable(),I.ContextMenuItems.registerDelete(),I.ContextMenuItems.registerHelp()},I.ContextMenuItems.registerDefaultOptions=function(){I.ContextMenuItems.registerWorkspaceOptions_(),I.ContextMenuItems.registerBlockOptions_()},I.ContextMenuItems.registerDefaultOptions(),I.Mutator=function(t){I.Mutator.superClass_.constructor.call(this,null),this.quarkNames_=t},I.utils.object.inherits(I.Mutator,I.Icon),I.Mutator.prototype.workspaceWidth_=0,I.Mutator.prototype.workspaceHeight_=0,I.Mutator.prototype.setBlock=function(t){this.block_=t},I.Mutator.prototype.getWorkspace=function(){return this.workspace_},I.Mutator.prototype.drawIcon_=function(t){I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyIconShape",rx:"4",ry:"4",height:"16",width:"16"},t),I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m4.203,7.296 0,1.368 -0.92,0.677 -0.11,0.41 0.9,1.559 0.41,0.11 1.043,-0.457 1.187,0.683 0.127,1.134 0.3,0.3 1.8,0 0.3,-0.299 0.127,-1.138 1.185,-0.682 1.046,0.458 0.409,-0.11 0.9,-1.559 -0.11,-0.41 -0.92,-0.677 0,-1.366 0.92,-0.677 0.11,-0.41 -0.9,-1.559 -0.409,-0.109 -1.046,0.458 -1.185,-0.682 -0.127,-1.138 -0.3,-0.299 -1.8,0 -0.3,0.3 -0.126,1.135 -1.187,0.682 -1.043,-0.457 -0.41,0.11 -0.899,1.559 0.108,0.409z"},t),I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{class:"blocklyIconShape",r:"2.7",cx:"8",cy:"8"},t)},I.Mutator.prototype.iconClick_=function(t){this.block_.isEditable()&&I.Icon.prototype.iconClick_.call(this,t)},I.Mutator.prototype.createEditor_=function(){if(this.svgDialog_=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{x:I.Bubble.BORDER_WIDTH,y:I.Bubble.BORDER_WIDTH},null),this.quarkNames_.length)for(var t=I.utils.xml.createElement("xml"),e=0,o;o=this.quarkNames_[e];e++){var i=I.utils.xml.createElement("block");i.setAttribute("type",o),t.appendChild(i)}else t=null;return(e=new I.Options({disable:!1,parentWorkspace:this.block_.workspace,media:this.block_.workspace.options.pathToMedia,rtl:this.block_.RTL,horizontalLayout:!1,renderer:this.block_.workspace.options.renderer,rendererOverrides:this.block_.workspace.options.rendererOverrides})).toolboxPosition=this.block_.RTL?I.utils.toolbox.Position.RIGHT:I.utils.toolbox.Position.LEFT,(o=!!t)&&(e.languageTree=I.utils.toolbox.convertToolboxDefToJson(t)),this.workspace_=new I.WorkspaceSvg(e),this.workspace_.isMutator=!0,this.workspace_.addChangeListener(I.Events.disableOrphans),t=o?this.workspace_.addFlyout(I.utils.Svg.G):null,e=this.workspace_.createDom("blocklyMutatorBackground"),t&&e.insertBefore(t,this.workspace_.svgBlockCanvas_),this.svgDialog_.appendChild(e),this.svgDialog_},I.Mutator.prototype.updateEditable=function(){I.Mutator.superClass_.updateEditable.call(this),this.block_.isInFlyout||(this.block_.isEditable()?this.iconGroup_&&I.utils.dom.removeClass(this.iconGroup_,"blocklyIconGroupReadonly"):(this.setVisible(!1),this.iconGroup_&&I.utils.dom.addClass(this.iconGroup_,"blocklyIconGroupReadonly")))},I.Mutator.prototype.resizeBubble_=function(){var t=2*I.Bubble.BORDER_WIDTH,e=this.workspace_.getCanvas().getBBox(),o=e.width+e.x,i=e.height+3*t,s=this.workspace_.getFlyout(),n,i;s&&(n=s.getWorkspace().getMetricsManager().getScrollMetrics(),i=Math.max(i,n.height+20),o+=s.getWidth()),this.block_.RTL&&(o=-e.x),o+=3*t,(Math.abs(this.workspaceWidth_-o)>t||Math.abs(this.workspaceHeight_-i)>t)&&(this.workspaceWidth_=o,this.workspaceHeight_=i,this.bubble_.setBubbleSize(o+t,i+t),this.svgDialog_.setAttribute("width",this.workspaceWidth_),this.svgDialog_.setAttribute("height",this.workspaceHeight_),this.workspace_.setCachedParentSvgSize(this.workspaceWidth_,this.workspaceHeight_)),this.block_.RTL&&(t="translate("+this.workspaceWidth_+",0)",this.workspace_.getCanvas().setAttribute("transform",t)),this.workspace_.resize()},I.Mutator.prototype.onBubbleMove_=function(){this.workspace_&&this.workspace_.recordDeleteAreas()},I.Mutator.prototype.setVisible=function(t){if(t!=this.isVisible())if(I.Events.fire(new(I.Events.get(I.Events.BUBBLE_OPEN))(this.block_,t,"mutator")),t){this.bubble_=new I.Bubble(this.block_.workspace,this.createEditor_(),this.block_.pathObject.svgPath,this.iconXY_,null,null),this.bubble_.setSvgId(this.block_.id),this.bubble_.registerMoveEvent(this.onBubbleMove_.bind(this));var e=this.workspace_.options.languageTree;t=this.workspace_.getFlyout(),e&&(t.init(this.workspace_),t.show(e)),this.rootBlock_=this.block_.decompose(this.workspace_);for(var e=this.rootBlock_.getDescendants(!1),o=0,i,s,n;i=e[o];o++)i.render();this.rootBlock_.setMovable(!1),this.rootBlock_.setDeletable(!1),t=t?(e=2*t.CORNER_RADIUS,this.rootBlock_.RTL?t.getWidth()+e:e):e=16,this.block_.RTL&&(t=-t),this.rootBlock_.moveBy(t,e),this.block_.saveConnections&&((n=(s=this).block_).saveConnections(this.rootBlock_),this.sourceListener_=function(){n.saveConnections(s.rootBlock_)},this.block_.workspace.addChangeListener(this.sourceListener_)),this.resizeBubble_(),this.workspace_.addChangeListener(this.workspaceChanged_.bind(this)),this.applyColour()}else this.svgDialog_=null,this.workspace_.dispose(),this.rootBlock_=this.workspace_=null,this.bubble_.dispose(),this.bubble_=null,this.workspaceHeight_=this.workspaceWidth_=0,this.sourceListener_&&(this.block_.workspace.removeChangeListener(this.sourceListener_),this.sourceListener_=null)},I.Mutator.prototype.workspaceChanged_=function(t){if(!(t.isUiEvent||t.type==I.Events.CHANGE&&"disabled"==t.element)){if(!this.workspace_.isDragging()){t=this.workspace_.getTopBlocks(!1);for(var e=0,o;o=t[e];e++){var i=o.getRelativeToSurfaceXY(),s,n;i.y<20&&o.moveBy(0,20-i.y),o.RTL?(s=-20,(n=this.workspace_.getFlyout())&&(s-=n.getWidth()),i.x>s&&o.moveBy(s-i.x,0)):i.x<20&&o.moveBy(20-i.x,0)}}var r;this.rootBlock_.workspace==this.workspace_&&(I.Events.setGroup(!0),t=(t=(o=this.block_).mutationToDom())&&I.Xml.domToText(t),e=o.rendered,o.rendered=!1,o.compose(this.rootBlock_),o.rendered=e,o.initSvg(),o.rendered&&o.render(),t!=(e=(e=o.mutationToDom())&&I.Xml.domToText(e))&&(I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(o,"mutation",null,t,e)),r=I.Events.getGroup(),setTimeout(function(){I.Events.setGroup(r),o.bumpNeighbours(),I.Events.setGroup(!1)},I.BUMP_DELAY)),this.workspace_.isDragging()||this.resizeBubble_(),I.Events.setGroup(!1))}},I.Mutator.prototype.dispose=function(){this.block_.mutator=null,I.Icon.prototype.dispose.call(this)},I.Mutator.prototype.updateBlockStyle=function(){var t=this.workspace_;if(t&&t.getAllBlocks(!1)){for(var e=t.getAllBlocks(!1),o=0;o<e.length;o++){var i=e[o];i.setStyle(i.getStyleName())}if(o=t.getFlyout())for(t=o.workspace_.getAllBlocks(!1),o=0;o<t.length;o++)(i=t[o]).setStyle(i.getStyleName())}},I.Mutator.reconnect=function(t,e,o){if(!t||!t.getSourceBlock().workspace)return!1;o=e.getInput(o).connection;var i=t.targetBlock();return!(i&&i!=e||o.targetConnection==t)&&(o.isConnected()&&o.disconnect(),o.connect(t),!0)},I.Mutator.findParentWs=function(t){var e=null,o;return t&&t.options&&(o=t.options.parentWorkspace,t.isFlyout?o&&o.options&&(e=o.options.parentWorkspace):o&&(e=o)),e},I.FieldTextInput=function(t,e,o){this.spellcheck_=!0,I.FieldTextInput.superClass_.constructor.call(this,t,e,o),this.onKeyInputWrapper_=this.onKeyDownWrapper_=this.htmlInput_=null,this.fullBlockClickTarget_=!1,this.workspace_=null},I.utils.object.inherits(I.FieldTextInput,I.Field),I.FieldTextInput.prototype.DEFAULT_VALUE="",I.FieldTextInput.fromJson=function(t){var e=I.utils.replaceMessageReferences(t.text);return new I.FieldTextInput(e,void 0,t)},I.FieldTextInput.prototype.SERIALIZABLE=!0,I.FieldTextInput.BORDERRADIUS=4,I.FieldTextInput.prototype.CURSOR="text",I.FieldTextInput.prototype.configure_=function(t){I.FieldTextInput.superClass_.configure_.call(this,t),"boolean"==typeof t.spellcheck&&(this.spellcheck_=t.spellcheck)},I.FieldTextInput.prototype.initView=function(){if(this.getConstants().FULL_BLOCK_FIELDS){for(var t=0,e=0,o=0,i;i=this.sourceBlock_.inputList[o];o++){for(var s=0;i.fieldRow[s];s++)t++;i.connection&&e++}this.fullBlockClickTarget_=t<=1&&this.sourceBlock_.outputConnection&&!e}else this.fullBlockClickTarget_=!1;this.fullBlockClickTarget_?this.clickTarget_=this.sourceBlock_.getSvgRoot():this.createBorderRect_(),this.createTextElement_()},I.FieldTextInput.prototype.doClassValidation_=function(t){return null==t?null:String(t)},I.FieldTextInput.prototype.doValueInvalid_=function(t){this.isBeingEdited_&&(this.isTextValid_=!1,t=this.value_,this.value_=this.htmlInput_.untypedDefaultValue_,this.sourceBlock_&&I.Events.isEnabled()&&I.Events.fire(new(I.Events.get(I.Events.BLOCK_CHANGE))(this.sourceBlock_,"field",this.name||null,t,this.value_)))},I.FieldTextInput.prototype.doValueUpdate_=function(t){this.isTextValid_=!0,this.value_=t,this.isBeingEdited_||(this.isDirty_=!0)},I.FieldTextInput.prototype.applyColour=function(){this.sourceBlock_&&this.getConstants().FULL_BLOCK_FIELDS&&(this.borderRect_?this.borderRect_.setAttribute("stroke",this.sourceBlock_.style.colourTertiary):this.sourceBlock_.pathObject.svgPath.setAttribute("fill",this.getConstants().FIELD_BORDER_RECT_COLOUR))},I.FieldTextInput.prototype.render_=function(){var t;I.FieldTextInput.superClass_.render_.call(this),this.isBeingEdited_&&(this.resizeEditor_(),t=this.htmlInput_,this.isTextValid_?(I.utils.dom.removeClass(t,"blocklyInvalidInput"),I.utils.aria.setState(t,I.utils.aria.State.INVALID,!1)):(I.utils.dom.addClass(t,"blocklyInvalidInput"),I.utils.aria.setState(t,I.utils.aria.State.INVALID,!0)))},I.FieldTextInput.prototype.setSpellcheck=function(t){t!=this.spellcheck_&&(this.spellcheck_=t,this.htmlInput_&&this.htmlInput_.setAttribute("spellcheck",this.spellcheck_))},I.FieldTextInput.prototype.showEditor_=function(t,e){this.workspace_=this.sourceBlock_.workspace,!(t=e||!1)&&(I.utils.userAgent.MOBILE||I.utils.userAgent.ANDROID||I.utils.userAgent.IPAD)?this.showPromptEditor_():this.showInlineEditor_(t)},I.FieldTextInput.prototype.showPromptEditor_=function(){I.prompt(I.Msg.CHANGE_VALUE_TITLE,this.getText(),function(t){this.setValue(this.getValueFromEditorText_(t))}.bind(this))},I.FieldTextInput.prototype.showInlineEditor_=function(t){I.WidgetDiv.show(this,this.sourceBlock_.RTL,this.widgetDispose_.bind(this)),this.htmlInput_=this.widgetCreate_(),this.isBeingEdited_=!0,t||(this.htmlInput_.focus({preventScroll:!0}),this.htmlInput_.select())},I.FieldTextInput.prototype.widgetCreate_=function(){var t=I.WidgetDiv.DIV;I.utils.dom.addClass(this.getClickTarget_(),"editing");var e=document.createElement("input");e.className="blocklyHtmlInput",e.setAttribute("spellcheck",this.spellcheck_);var o=this.workspace_.getScale(),i=this.getConstants().FIELD_TEXT_FONTSIZE*o+"pt",i,s;return t.style.fontSize=i,e.style.fontSize=i,i=I.FieldTextInput.BORDERRADIUS*o+"px",this.fullBlockClickTarget_&&(i=((i=this.getScaledBBox()).bottom-i.top)/2+"px",s=(this.sourceBlock_.getParent()?this.sourceBlock_.getParent():this.sourceBlock_).style.colourTertiary,e.style.border=1*o+"px solid "+s,t.style.borderRadius=i,t.style.transition="box-shadow 0.25s ease 0s",this.getConstants().FIELD_TEXTINPUT_BOX_SHADOW&&(t.style.boxShadow="rgba(255, 255, 255, 0.3) 0px 0px 0px "+4*o+"px")),e.style.borderRadius=i,t.appendChild(e),e.value=e.defaultValue=this.getEditorText_(this.value_),e.untypedDefaultValue_=this.value_,e.oldValue_=null,this.resizeEditor_(),this.bindInputEvents_(e),e},I.FieldTextInput.prototype.widgetDispose_=function(){this.isBeingEdited_=!1,this.isTextValid_=!0,this.forceRerender(),this.onFinishEditing_&&this.onFinishEditing_(this.value_),this.unbindInputEvents_();var t=I.WidgetDiv.DIV.style;t.width="auto",t.height="auto",t.fontSize="",t.transition="",t.boxShadow="",this.htmlInput_=null,I.utils.dom.removeClass(this.getClickTarget_(),"editing")},I.FieldTextInput.prototype.bindInputEvents_=function(t){this.onKeyDownWrapper_=I.browserEvents.conditionalBind(t,"keydown",this,this.onHtmlInputKeyDown_),this.onKeyInputWrapper_=I.browserEvents.conditionalBind(t,"input",this,this.onHtmlInputChange_)},I.FieldTextInput.prototype.unbindInputEvents_=function(){this.onKeyDownWrapper_&&(I.browserEvents.unbind(this.onKeyDownWrapper_),this.onKeyDownWrapper_=null),this.onKeyInputWrapper_&&(I.browserEvents.unbind(this.onKeyInputWrapper_),this.onKeyInputWrapper_=null)},I.FieldTextInput.prototype.onHtmlInputKeyDown_=function(t){t.keyCode==I.utils.KeyCodes.ENTER?(I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation()):t.keyCode==I.utils.KeyCodes.ESC?(this.htmlInput_.value=this.htmlInput_.defaultValue,I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation()):t.keyCode==I.utils.KeyCodes.TAB&&(I.WidgetDiv.hide(),I.DropDownDiv.hideWithoutAnimation(),this.sourceBlock_.tab(this,!t.shiftKey),t.preventDefault())},I.FieldTextInput.prototype.onHtmlInputChange_=function(t){(t=this.htmlInput_.value)!==this.htmlInput_.oldValue_&&(this.htmlInput_.oldValue_=t,I.Events.setGroup(!0),t=this.getValueFromEditorText_(t),this.setValue(t),this.forceRerender(),this.resizeEditor_(),I.Events.setGroup(!1))},I.FieldTextInput.prototype.setEditorValue_=function(t){this.isDirty_=!0,this.isBeingEdited_&&(this.htmlInput_.value=this.getEditorText_(t)),this.setValue(t)},I.FieldTextInput.prototype.resizeEditor_=function(){var t=I.WidgetDiv.DIV,e=this.getScaledBBox();t.style.width=e.right-e.left+"px",t.style.height=e.bottom-e.top+"px",e=new I.utils.Coordinate(this.sourceBlock_.RTL?e.right-t.offsetWidth:e.left,e.top),t.style.left=e.x+"px",t.style.top=e.y+"px"},I.FieldTextInput.prototype.isTabNavigable=function(){return!0},I.FieldTextInput.prototype.getText_=function(){return this.isBeingEdited_&&this.htmlInput_?this.htmlInput_.value:null},I.FieldTextInput.prototype.getEditorText_=function(t){return String(t)},I.FieldTextInput.prototype.getValueFromEditorText_=function(t){return t},I.fieldRegistry.register("field_input",I.FieldTextInput),I.FieldAngle=function(t,e,o){this.clockwise_=I.FieldAngle.CLOCKWISE,this.offset_=I.FieldAngle.OFFSET,this.wrap_=I.FieldAngle.WRAP,this.round_=I.FieldAngle.ROUND,I.FieldAngle.superClass_.constructor.call(this,t,e,o),this.moveSurfaceWrapper_=this.clickSurfaceWrapper_=this.clickWrapper_=this.line_=this.gauge_=null},I.utils.object.inherits(I.FieldAngle,I.FieldTextInput),I.FieldAngle.prototype.DEFAULT_VALUE=0,I.FieldAngle.fromJson=function(t){return new I.FieldAngle(t.angle,void 0,t)},I.FieldAngle.prototype.SERIALIZABLE=!0,I.FieldAngle.ROUND=15,I.FieldAngle.HALF=50,I.FieldAngle.CLOCKWISE=!1,I.FieldAngle.OFFSET=0,I.FieldAngle.WRAP=360,I.FieldAngle.RADIUS=I.FieldAngle.HALF-1,I.FieldAngle.prototype.configure_=function(t){switch(I.FieldAngle.superClass_.configure_.call(this,t),t.mode){case"compass":this.clockwise_=!0,this.offset_=90;break;case"protractor":this.clockwise_=!1,this.offset_=0}var e=t.clockwise;"boolean"==typeof e&&(this.clockwise_=e),null!=(e=t.offset)&&(e=Number(e),isNaN(e)||(this.offset_=e)),null!=(e=t.wrap)&&(e=Number(e),isNaN(e)||(this.wrap_=e)),null!=(t=t.round)&&(t=Number(t),isNaN(t)||(this.round_=t))},I.FieldAngle.prototype.initView=function(){I.FieldAngle.superClass_.initView.call(this),this.symbol_=I.utils.dom.createSvgElement(I.utils.Svg.TSPAN,{},null),this.symbol_.appendChild(document.createTextNode("°")),this.textElement_.appendChild(this.symbol_)},I.FieldAngle.prototype.render_=function(){I.FieldAngle.superClass_.render_.call(this),this.updateGraph_()},I.FieldAngle.prototype.showEditor_=function(t){I.FieldAngle.superClass_.showEditor_.call(this,t,I.utils.userAgent.MOBILE||I.utils.userAgent.ANDROID||I.utils.userAgent.IPAD),t=this.dropdownCreate_(),I.DropDownDiv.getContentDiv().appendChild(t),I.DropDownDiv.setColour(this.sourceBlock_.style.colourPrimary,this.sourceBlock_.style.colourTertiary),I.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.updateGraph_()},I.FieldAngle.prototype.dropdownCreate_=function(){var t=I.utils.dom.createSvgElement(I.utils.Svg.SVG,{xmlns:I.utils.dom.SVG_NS,"xmlns:html":I.utils.dom.HTML_NS,"xmlns:xlink":I.utils.dom.XLINK_NS,version:"1.1",height:2*I.FieldAngle.HALF+"px",width:2*I.FieldAngle.HALF+"px",style:"touch-action: none"},null),e=I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{cx:I.FieldAngle.HALF,cy:I.FieldAngle.HALF,r:I.FieldAngle.RADIUS,class:"blocklyAngleCircle"},t);this.gauge_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyAngleGauge"},t),this.line_=I.utils.dom.createSvgElement(I.utils.Svg.LINE,{x1:I.FieldAngle.HALF,y1:I.FieldAngle.HALF,class:"blocklyAngleLine"},t);for(var o=0;o<360;o+=15)I.utils.dom.createSvgElement(I.utils.Svg.LINE,{x1:I.FieldAngle.HALF+I.FieldAngle.RADIUS,y1:I.FieldAngle.HALF,x2:I.FieldAngle.HALF+I.FieldAngle.RADIUS-(0==o%45?10:5),y2:I.FieldAngle.HALF,class:"blocklyAngleMarks",transform:"rotate("+o+","+I.FieldAngle.HALF+","+I.FieldAngle.HALF+")"},t);return this.clickWrapper_=I.browserEvents.conditionalBind(t,"click",this,this.hide_),this.clickSurfaceWrapper_=I.browserEvents.conditionalBind(e,"click",this,this.onMouseMove_,!0,!0),this.moveSurfaceWrapper_=I.browserEvents.conditionalBind(e,"mousemove",this,this.onMouseMove_,!0,!0),t},I.FieldAngle.prototype.dropdownDispose_=function(){this.clickWrapper_&&(I.browserEvents.unbind(this.clickWrapper_),this.clickWrapper_=null),this.clickSurfaceWrapper_&&(I.browserEvents.unbind(this.clickSurfaceWrapper_),this.clickSurfaceWrapper_=null),this.moveSurfaceWrapper_&&(I.browserEvents.unbind(this.moveSurfaceWrapper_),this.moveSurfaceWrapper_=null),this.line_=this.gauge_=null},I.FieldAngle.prototype.hide_=function(){I.DropDownDiv.hideIfOwner(this),I.WidgetDiv.hide()},I.FieldAngle.prototype.onMouseMove_=function(t){var e=this.gauge_.ownerSVGElement.getBoundingClientRect(),o=t.clientX-e.left-I.FieldAngle.HALF;t=t.clientY-e.top-I.FieldAngle.HALF,e=Math.atan(-t/o),isNaN(e)||(e=I.utils.math.toDegrees(e),o<0?e+=180:0<t&&(e+=360),e=this.clockwise_?this.offset_+360-e:360-(this.offset_-e),this.displayMouseOrKeyboardValue_(e))},I.FieldAngle.prototype.displayMouseOrKeyboardValue_=function(t){this.round_&&(t=Math.round(t/this.round_)*this.round_),(t=this.wrapValue_(t))!=this.value_&&this.setEditorValue_(t)},I.FieldAngle.prototype.updateGraph_=function(){var t,e,t,o,i,s,n,r,l;this.gauge_&&(t=Number(this.getText())+this.offset_,e=I.utils.math.toRadians(t%360),t=["M ",I.FieldAngle.HALF,",",I.FieldAngle.HALF],o=I.FieldAngle.HALF,i=I.FieldAngle.HALF,isNaN(e)||(s=Number(this.clockwise_),n=I.utils.math.toRadians(this.offset_),r=Math.cos(n)*I.FieldAngle.RADIUS,l=Math.sin(n)*-I.FieldAngle.RADIUS,s&&(e=2*n-e),o+=Math.cos(e)*I.FieldAngle.RADIUS,i-=Math.sin(e)*I.FieldAngle.RADIUS,e=Math.abs(Math.floor((e-n)/Math.PI)%2),t.push(" l ",r,",",l," A ",I.FieldAngle.RADIUS,",",I.FieldAngle.RADIUS," 0 ",e=s?1-e:e," ",s," ",o,",",i," z")),this.gauge_.setAttribute("d",t.join("")),this.line_.setAttribute("x2",o),this.line_.setAttribute("y2",i))},I.FieldAngle.prototype.onHtmlInputKeyDown_=function(t){var e,o;I.FieldAngle.superClass_.onHtmlInputKeyDown_.call(this,t),t.keyCode===I.utils.KeyCodes.LEFT?e=this.sourceBlock_.RTL?1:-1:t.keyCode===I.utils.KeyCodes.RIGHT?e=this.sourceBlock_.RTL?-1:1:t.keyCode===I.utils.KeyCodes.DOWN?e=-1:t.keyCode===I.utils.KeyCodes.UP&&(e=1),e&&(o=this.getValue(),this.displayMouseOrKeyboardValue_(o+e*this.round_),t.preventDefault(),t.stopPropagation())},I.FieldAngle.prototype.doClassValidation_=function(t){return t=Number(t),isNaN(t)||!isFinite(t)?null:this.wrapValue_(t)},I.FieldAngle.prototype.wrapValue_=function(t){return(t%=360)<0&&(t+=360),t>this.wrap_&&(t-=360),t},I.Css.register(".blocklyAngleCircle {,stroke: #444;,stroke-width: 1;,fill: #ddd;,fill-opacity: .8;,},.blocklyAngleMarks {,stroke: #444;,stroke-width: 1;,},.blocklyAngleGauge {,fill: #f88;,fill-opacity: .8;,pointer-events: none;,},.blocklyAngleLine {,stroke: #f00;,stroke-width: 2;,stroke-linecap: round;,pointer-events: none;,}".split(",")),I.fieldRegistry.register("field_angle",I.FieldAngle),I.FieldCheckbox=function(t,e,o){this.checkChar_=null,I.FieldCheckbox.superClass_.constructor.call(this,t,e,o)},I.utils.object.inherits(I.FieldCheckbox,I.Field),I.FieldCheckbox.prototype.DEFAULT_VALUE=!1,I.FieldCheckbox.fromJson=function(t){return new I.FieldCheckbox(t.checked,void 0,t)},I.FieldCheckbox.CHECK_CHAR="✓",I.FieldCheckbox.prototype.SERIALIZABLE=!0,I.FieldCheckbox.prototype.CURSOR="default",I.FieldCheckbox.prototype.configure_=function(t){I.FieldCheckbox.superClass_.configure_.call(this,t),t.checkCharacter&&(this.checkChar_=t.checkCharacter)},I.FieldCheckbox.prototype.initView=function(){I.FieldCheckbox.superClass_.initView.call(this),I.utils.dom.addClass(this.textElement_,"blocklyCheckbox"),this.textElement_.style.display=this.value_?"block":"none"},I.FieldCheckbox.prototype.render_=function(){this.textContent_&&(this.textContent_.nodeValue=this.getDisplayText_()),this.updateSize_(this.getConstants().FIELD_CHECKBOX_X_OFFSET)},I.FieldCheckbox.prototype.getDisplayText_=function(){return this.checkChar_||I.FieldCheckbox.CHECK_CHAR},I.FieldCheckbox.prototype.setCheckCharacter=function(t){this.checkChar_=t,this.forceRerender()},I.FieldCheckbox.prototype.showEditor_=function(){this.setValue(!this.value_)},I.FieldCheckbox.prototype.doClassValidation_=function(t){return!0===t||"TRUE"===t?"TRUE":!1===t||"FALSE"===t?"FALSE":null},I.FieldCheckbox.prototype.doValueUpdate_=function(t){this.value_=this.convertValueToBool_(t),this.textElement_&&(this.textElement_.style.display=this.value_?"block":"none")},I.FieldCheckbox.prototype.getValue=function(){return this.value_?"TRUE":"FALSE"},I.FieldCheckbox.prototype.getValueBoolean=function(){return this.value_},I.FieldCheckbox.prototype.getText=function(){return String(this.convertValueToBool_(this.value_))},I.FieldCheckbox.prototype.convertValueToBool_=function(t){return"string"==typeof t?"TRUE"==t:!!t},I.fieldRegistry.register("field_checkbox",I.FieldCheckbox),I.FieldColour=function(t,e,o){I.FieldColour.superClass_.constructor.call(this,t,e,o),this.onKeyDownWrapper_=this.onMouseLeaveWrapper_=this.onMouseEnterWrapper_=this.onMouseMoveWrapper_=this.onClickWrapper_=this.highlightedIndex_=this.picker_=null},I.utils.object.inherits(I.FieldColour,I.Field),I.FieldColour.fromJson=function(t){return new I.FieldColour(t.colour,void 0,t)},I.FieldColour.prototype.SERIALIZABLE=!0,I.FieldColour.prototype.CURSOR="default",I.FieldColour.prototype.isDirty_=!1,I.FieldColour.prototype.colours_=null,I.FieldColour.prototype.titles_=null,I.FieldColour.prototype.columns_=0,I.FieldColour.prototype.configure_=function(t){I.FieldColour.superClass_.configure_.call(this,t),t.colourOptions&&(this.colours_=t.colourOptions,this.titles_=t.colourTitles),t.columns&&(this.columns_=t.columns)},I.FieldColour.prototype.initView=function(){this.size_=new I.utils.Size(this.getConstants().FIELD_COLOUR_DEFAULT_WIDTH,this.getConstants().FIELD_COLOUR_DEFAULT_HEIGHT),this.getConstants().FIELD_COLOUR_FULL_BLOCK?this.clickTarget_=this.sourceBlock_.getSvgRoot():(this.createBorderRect_(),this.borderRect_.style.fillOpacity="1")},I.FieldColour.prototype.applyColour=function(){this.getConstants().FIELD_COLOUR_FULL_BLOCK?(this.sourceBlock_.pathObject.svgPath.setAttribute("fill",this.getValue()),this.sourceBlock_.pathObject.svgPath.setAttribute("stroke","#fff")):this.borderRect_&&(this.borderRect_.style.fill=this.getValue())},I.FieldColour.prototype.doClassValidation_=function(t){return"string"!=typeof t?null:I.utils.colour.parse(t)},I.FieldColour.prototype.doValueUpdate_=function(t){this.value_=t,this.borderRect_?this.borderRect_.style.fill=t:this.sourceBlock_&&this.sourceBlock_.rendered&&(this.sourceBlock_.pathObject.svgPath.setAttribute("fill",t),this.sourceBlock_.pathObject.svgPath.setAttribute("stroke","#fff"))},I.FieldColour.prototype.getText=function(){var t=this.value_;return t=/^#(.)\1(.)\2(.)\3$/.test(t)?"#"+t[1]+t[3]+t[5]:t},I.FieldColour.COLOURS="#ffffff #cccccc #c0c0c0 #999999 #666666 #333333 #000000 #ffcccc #ff6666 #ff0000 #cc0000 #990000 #660000 #330000 #ffcc99 #ff9966 #ff9900 #ff6600 #cc6600 #993300 #663300 #ffff99 #ffff66 #ffcc66 #ffcc33 #cc9933 #996633 #663333 #ffffcc #ffff33 #ffff00 #ffcc00 #999900 #666600 #333300 #99ff99 #66ff99 #33ff33 #33cc00 #009900 #006600 #003300 #99ffff #33ffff #66cccc #00cccc #339999 #336666 #003333 #ccffff #66ffff #33ccff #3366ff #3333ff #000099 #000066 #ccccff #9999ff #6666cc #6633ff #6600cc #333399 #330099 #ffccff #ff99ff #cc66cc #cc33cc #993399 #663366 #330033".split(" "),I.FieldColour.prototype.DEFAULT_VALUE=I.FieldColour.COLOURS[0],I.FieldColour.TITLES=[],I.FieldColour.COLUMNS=7,I.FieldColour.prototype.setColours=function(t,e){return this.colours_=t,e&&(this.titles_=e),this},I.FieldColour.prototype.setColumns=function(t){return this.columns_=t,this},I.FieldColour.prototype.showEditor_=function(){this.picker_=this.dropdownCreate_(),I.DropDownDiv.getContentDiv().appendChild(this.picker_),I.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.picker_.focus({preventScroll:!0})},I.FieldColour.prototype.onClick_=function(t){null!==(t=(t=t.target)&&t.label)&&(this.setValue(t),I.DropDownDiv.hideIfOwner(this))},I.FieldColour.prototype.onKeyDown_=function(t){var e=!1;t.keyCode===I.utils.KeyCodes.UP?(this.moveHighlightBy_(0,-1),e=!0):t.keyCode===I.utils.KeyCodes.DOWN?(this.moveHighlightBy_(0,1),e=!0):t.keyCode===I.utils.KeyCodes.LEFT?(this.moveHighlightBy_(-1,0),e=!0):t.keyCode===I.utils.KeyCodes.RIGHT?(this.moveHighlightBy_(1,0),e=!0):t.keyCode===I.utils.KeyCodes.ENTER&&(!(e=this.getHighlighted_())||null!==(e=e&&e.label)&&this.setValue(e),I.DropDownDiv.hideWithoutAnimation(),e=!0),e&&t.stopPropagation()},I.FieldColour.prototype.moveHighlightBy_=function(t,e){var o=this.colours_||I.FieldColour.COLOURS,i=this.columns_||I.FieldColour.COLUMNS,s=this.highlightedIndex_%i,n=Math.floor(this.highlightedIndex_/i);s+=t,n+=e,t<0?s<0&&0<n?(s=i-1,n--):s<0&&(s=0):0<t?i-1<s&&n<Math.floor(o.length/i)-1?(s=0,n++):i-1<s&&s--:e<0?n<0&&(n=0):0<e&&n>Math.floor(o.length/i)-1&&(n=Math.floor(o.length/i)-1),this.setHighlightedCell_(this.picker_.childNodes[n].childNodes[s],n*i+s)},I.FieldColour.prototype.onMouseMove_=function(t){var e=(t=t.target)&&Number(t.getAttribute("data-index"));null!==e&&e!==this.highlightedIndex_&&this.setHighlightedCell_(t,e)},I.FieldColour.prototype.onMouseEnter_=function(){this.picker_.focus({preventScroll:!0})},I.FieldColour.prototype.onMouseLeave_=function(){this.picker_.blur();var t=this.getHighlighted_();t&&I.utils.dom.removeClass(t,"blocklyColourHighlighted")},I.FieldColour.prototype.getHighlighted_=function(){var t=this.columns_||I.FieldColour.COLUMNS,e=this.picker_.childNodes[Math.floor(this.highlightedIndex_/t)];return e?e.childNodes[this.highlightedIndex_%t]:null},I.FieldColour.prototype.setHighlightedCell_=function(t,e){var o=this.getHighlighted_();o&&I.utils.dom.removeClass(o,"blocklyColourHighlighted"),I.utils.dom.addClass(t,"blocklyColourHighlighted"),this.highlightedIndex_=e,I.utils.aria.setState(this.picker_,I.utils.aria.State.ACTIVEDESCENDANT,t.getAttribute("id"))},I.FieldColour.prototype.dropdownCreate_=function(){var t=this.columns_||I.FieldColour.COLUMNS,e=this.colours_||I.FieldColour.COLOURS,o=this.titles_||I.FieldColour.TITLES,i=this.getValue(),s=document.createElement("table");s.className="blocklyColourTable",s.tabIndex=0,s.dir="ltr",I.utils.aria.setRole(s,I.utils.aria.Role.GRID),I.utils.aria.setState(s,I.utils.aria.State.EXPANDED,!0),I.utils.aria.setState(s,I.utils.aria.State.ROWCOUNT,Math.floor(e.length/t)),I.utils.aria.setState(s,I.utils.aria.State.COLCOUNT,t);for(var n,r=0;r<e.length;r++){0==r%t&&(n=document.createElement("tr"),I.utils.aria.setRole(n,I.utils.aria.Role.ROW),s.appendChild(n));var l=document.createElement("td");n.appendChild(l),l.label=e[r],l.title=o[r]||e[r],l.id=I.utils.IdGenerator.getNextUniqueId(),l.setAttribute("data-index",r),I.utils.aria.setRole(l,I.utils.aria.Role.GRIDCELL),I.utils.aria.setState(l,I.utils.aria.State.LABEL,e[r]),I.utils.aria.setState(l,I.utils.aria.State.SELECTED,e[r]==i),l.style.backgroundColor=e[r],e[r]==i&&(l.className="blocklyColourSelected",this.highlightedIndex_=r)}return this.onClickWrapper_=I.browserEvents.conditionalBind(s,"click",this,this.onClick_,!0),this.onMouseMoveWrapper_=I.browserEvents.conditionalBind(s,"mousemove",this,this.onMouseMove_,!0),this.onMouseEnterWrapper_=I.browserEvents.conditionalBind(s,"mouseenter",this,this.onMouseEnter_,!0),this.onMouseLeaveWrapper_=I.browserEvents.conditionalBind(s,"mouseleave",this,this.onMouseLeave_,!0),this.onKeyDownWrapper_=I.browserEvents.conditionalBind(s,"keydown",this,this.onKeyDown_),s},I.FieldColour.prototype.dropdownDispose_=function(){this.onClickWrapper_&&(I.browserEvents.unbind(this.onClickWrapper_),this.onClickWrapper_=null),this.onMouseMoveWrapper_&&(I.browserEvents.unbind(this.onMouseMoveWrapper_),this.onMouseMoveWrapper_=null),this.onMouseEnterWrapper_&&(I.browserEvents.unbind(this.onMouseEnterWrapper_),this.onMouseEnterWrapper_=null),this.onMouseLeaveWrapper_&&(I.browserEvents.unbind(this.onMouseLeaveWrapper_),this.onMouseLeaveWrapper_=null),this.onKeyDownWrapper_&&(I.browserEvents.unbind(this.onKeyDownWrapper_),this.onKeyDownWrapper_=null),this.highlightedIndex_=this.picker_=null},I.Css.register([".blocklyColourTable {","border-collapse: collapse;","display: block;","outline: none;","padding: 1px;","}",".blocklyColourTable>tr>td {","border: .5px solid #888;","box-sizing: border-box;","cursor: pointer;","display: inline-block;","height: 20px;","padding: 0;","width: 20px;","}",".blocklyColourTable>tr>td.blocklyColourHighlighted {","border-color: #eee;","box-shadow: 2px 2px 7px 2px rgba(0,0,0,.3);","position: relative;","}",".blocklyColourSelected, .blocklyColourSelected:hover {","border-color: #eee !important;","outline: 1px solid #333;","position: relative;","}"]),I.fieldRegistry.register("field_colour",I.FieldColour),I.FieldDropdown=function(t,e,o){"function"!=typeof t&&I.FieldDropdown.validateOptions_(t),this.menuGenerator_=t,this.suffixField=this.prefixField=this.generatedOptions_=null,this.trimOptions_(),this.selectedOption_=this.getOptions(!1)[0],I.FieldDropdown.superClass_.constructor.call(this,this.selectedOption_[1],e,o),this.svgArrow_=this.arrow_=this.imageElement_=this.menu_=this.selectedMenuItem_=null},I.utils.object.inherits(I.FieldDropdown,I.Field),I.FieldDropdown.fromJson=function(t){return new I.FieldDropdown(t.options,void 0,t)},I.FieldDropdown.prototype.fromXml=function(t){this.isOptionListDynamic()&&this.getOptions(!1),this.setValue(t.textContent)},I.FieldDropdown.prototype.SERIALIZABLE=!0,I.FieldDropdown.CHECKMARK_OVERHANG=25,I.FieldDropdown.MAX_MENU_HEIGHT_VH=.45,I.FieldDropdown.IMAGE_Y_OFFSET=5,I.FieldDropdown.IMAGE_Y_PADDING=2*I.FieldDropdown.IMAGE_Y_OFFSET,I.FieldDropdown.ARROW_CHAR=I.utils.userAgent.ANDROID?"▼":"▾",I.FieldDropdown.prototype.CURSOR="default",I.FieldDropdown.prototype.initView=function(){this.shouldAddBorderRect_()?this.createBorderRect_():this.clickTarget_=this.sourceBlock_.getSvgRoot(),this.createTextElement_(),this.imageElement_=I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{},this.fieldGroup_),this.getConstants().FIELD_DROPDOWN_SVG_ARROW?this.createSVGArrow_():this.createTextArrow_(),this.borderRect_&&I.utils.dom.addClass(this.borderRect_,"blocklyDropdownRect")},I.FieldDropdown.prototype.shouldAddBorderRect_=function(){return!this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW||this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW&&!this.sourceBlock_.isShadow()},I.FieldDropdown.prototype.createTextArrow_=function(){this.arrow_=I.utils.dom.createSvgElement(I.utils.Svg.TSPAN,{},this.textElement_),this.arrow_.appendChild(document.createTextNode(this.sourceBlock_.RTL?I.FieldDropdown.ARROW_CHAR+" ":" "+I.FieldDropdown.ARROW_CHAR)),this.sourceBlock_.RTL?this.textElement_.insertBefore(this.arrow_,this.textContent_):this.textElement_.appendChild(this.arrow_)},I.FieldDropdown.prototype.createSVGArrow_=function(){this.svgArrow_=I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{height:this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE+"px",width:this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE+"px"},this.fieldGroup_),this.svgArrow_.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",this.getConstants().FIELD_DROPDOWN_SVG_ARROW_DATAURI)},I.FieldDropdown.prototype.showEditor_=function(t){var e;this.menu_=this.dropdownCreate_(),this.menu_.openingCoords=t&&"number"==typeof t.clientX?new I.utils.Coordinate(t.clientX,t.clientY):null,this.menu_.render(I.DropDownDiv.getContentDiv()),t=this.menu_.getElement(),I.utils.dom.addClass(t,"blocklyDropdownMenu"),this.getConstants().FIELD_DROPDOWN_COLOURED_DIV&&(t=(this.sourceBlock_.isShadow()?this.sourceBlock_.getParent():this.sourceBlock_).getColour(),e=(this.sourceBlock_.isShadow()?this.sourceBlock_.getParent():this.sourceBlock_).style.colourTertiary,I.DropDownDiv.setColour(t,e)),I.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.menu_.focus(),this.selectedMenuItem_&&this.menu_.setHighlighted(this.selectedMenuItem_),this.applyColour()},I.FieldDropdown.prototype.dropdownCreate_=function(){var t=new I.Menu;t.setRole(I.utils.aria.Role.LISTBOX);var e=this.getOptions(!1);this.selectedMenuItem_=null;for(var o=0;o<e.length;o++){var i=e[o][0],s=e[o][1],n;"object"==typeof i&&((n=new Image(i.width,i.height)).src=i.src,n.alt=i.alt||"",i=n),(i=new I.MenuItem(i,s)).setRole(I.utils.aria.Role.OPTION),i.setRightToLeft(this.sourceBlock_.RTL),i.setCheckable(!0),t.addChild(i),i.setChecked(s==this.value_),s==this.value_&&(this.selectedMenuItem_=i),i.onAction(this.handleMenuActionEvent_,this)}return t},I.FieldDropdown.prototype.dropdownDispose_=function(){this.menu_&&this.menu_.dispose(),this.selectedMenuItem_=this.menu_=null,this.applyColour()},I.FieldDropdown.prototype.handleMenuActionEvent_=function(t){I.DropDownDiv.hideIfOwner(this,!0),this.onItemSelected_(this.menu_,t)},I.FieldDropdown.prototype.onItemSelected_=function(t,e){this.setValue(e.getValue())},I.FieldDropdown.prototype.trimOptions_=function(){var t=this.menuGenerator_;if(Array.isArray(t)){for(var e=!1,o=0;o<t.length;o++){var i=t[o][0];"string"==typeof i?t[o][0]=I.utils.replaceMessageReferences(i):(null!=i.alt&&(t[o][0].alt=I.utils.replaceMessageReferences(i.alt)),e=!0)}if(!(e||t.length<2)){for(e=[],o=0;o<t.length;o++)e.push(t[o][0]);var o=I.utils.string.shortestStringLength(e),i=I.utils.string.commonWordPrefix(e,o),s=I.utils.string.commonWordSuffix(e,o);!i&&!s||o<=i+s||(i&&(this.prefixField=e[0].substring(0,i-1)),s&&(this.suffixField=e[0].substr(1-s)),this.menuGenerator_=I.FieldDropdown.applyTrim_(t,i,s))}}},I.FieldDropdown.applyTrim_=function(t,e,o){for(var i=[],s=0;s<t.length;s++){var n=t[s][0],r=t[s][1],n=n.substring(e,n.length-o);i[s]=[n,r]}return i},I.FieldDropdown.prototype.isOptionListDynamic=function(){return"function"==typeof this.menuGenerator_},I.FieldDropdown.prototype.getOptions=function(t){return this.isOptionListDynamic()?(this.generatedOptions_&&t||(this.generatedOptions_=this.menuGenerator_.call(this),I.FieldDropdown.validateOptions_(this.generatedOptions_)),this.generatedOptions_):this.menuGenerator_},I.FieldDropdown.prototype.doClassValidation_=function(t){for(var e=!1,o=this.getOptions(!0),i=0,s;s=o[i];i++)if(s[1]==t){e=!0;break}return e?t:(this.sourceBlock_&&console.warn("Cannot set the dropdown's value to an unavailable option. Block type: "+this.sourceBlock_.type+", Field name: "+this.name+", Value: "+t),null)},I.FieldDropdown.prototype.doValueUpdate_=function(t){I.FieldDropdown.superClass_.doValueUpdate_.call(this,t),t=this.getOptions(!0);for(var e=0,o;o=t[e];e++)o[1]==this.value_&&(this.selectedOption_=o)},I.FieldDropdown.prototype.applyColour=function(){this.borderRect_&&(this.borderRect_.setAttribute("stroke",this.sourceBlock_.style.colourTertiary),this.menu_?this.borderRect_.setAttribute("fill",this.sourceBlock_.style.colourTertiary):this.borderRect_.setAttribute("fill","transparent")),this.sourceBlock_&&this.arrow_&&(this.sourceBlock_.isShadow()?this.arrow_.style.fill=this.sourceBlock_.style.colourSecondary:this.arrow_.style.fill=this.sourceBlock_.style.colourPrimary)},I.FieldDropdown.prototype.render_=function(){this.textContent_.nodeValue="",this.imageElement_.style.display="none";var t=this.selectedOption_&&this.selectedOption_[0];t&&"object"==typeof t?this.renderSelectedImage_(t):this.renderSelectedText_(),this.positionBorderRect_()},I.FieldDropdown.prototype.renderSelectedImage_=function(t){this.imageElement_.style.display="",this.imageElement_.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",t.src),this.imageElement_.setAttribute("height",t.height),this.imageElement_.setAttribute("width",t.width);var e=Number(t.height);t=Number(t.width);var o=!!this.borderRect_,i=Math.max(o?this.getConstants().FIELD_DROPDOWN_BORDER_RECT_HEIGHT:0,e+I.FieldDropdown.IMAGE_Y_PADDING),o=o?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,s=this.svgArrow_?this.positionSVGArrow_(t+o,i/2-this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE/2):I.utils.dom.getFastTextWidth(this.arrow_,this.getConstants().FIELD_TEXT_FONTSIZE,this.getConstants().FIELD_TEXT_FONTWEIGHT,this.getConstants().FIELD_TEXT_FONTFAMILY);this.size_.width=t+s+2*o,this.size_.height=i;var n=0;this.sourceBlock_.RTL?this.imageElement_.setAttribute("x",o+s):(n=t+s,this.textElement_.setAttribute("text-anchor","end"),this.imageElement_.setAttribute("x",o)),this.imageElement_.setAttribute("y",i/2-e/2),this.positionTextElement_(n+o,t+s)},I.FieldDropdown.prototype.renderSelectedText_=function(){this.textContent_.nodeValue=this.getDisplayText_(),I.utils.dom.addClass(this.textElement_,"blocklyDropdownText"),this.textElement_.setAttribute("text-anchor","start");var t=!!this.borderRect_,e=Math.max(t?this.getConstants().FIELD_DROPDOWN_BORDER_RECT_HEIGHT:0,this.getConstants().FIELD_TEXT_HEIGHT),o=I.utils.dom.getFastTextWidth(this.textElement_,this.getConstants().FIELD_TEXT_FONTSIZE,this.getConstants().FIELD_TEXT_FONTWEIGHT,this.getConstants().FIELD_TEXT_FONTFAMILY),t=t?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,i=0;this.svgArrow_&&(i=this.positionSVGArrow_(o+t,e/2-this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE/2)),this.size_.width=o+i+2*t,this.size_.height=e,this.positionTextElement_(t,o)},I.FieldDropdown.prototype.positionSVGArrow_=function(t,e){if(!this.svgArrow_)return 0;var o=this.borderRect_?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,i=this.getConstants().FIELD_DROPDOWN_SVG_ARROW_PADDING,s=this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE;return this.svgArrow_.setAttribute("transform","translate("+(this.sourceBlock_.RTL?o:t+i)+","+e+")"),s+i},I.FieldDropdown.prototype.getText_=function(){if(!this.selectedOption_)return null;var t=this.selectedOption_[0];return"object"==typeof t?t.alt:t},I.FieldDropdown.validateOptions_=function(t){if(!Array.isArray(t))throw TypeError("FieldDropdown options must be an array.");if(!t.length)throw TypeError("FieldDropdown options must not be an empty array.");for(var e=!1,o=0;o<t.length;++o){var i=t[o];Array.isArray(i)?"string"!=typeof i[1]?(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option id must be a string. Found "+i[1]+" in: ",i)):i[0]&&"string"!=typeof i[0]&&"string"!=typeof i[0].src&&(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option must have a string label or image description. Found"+i[0]+" in: ",i)):(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option must be an array. Found: ",i))}if(e)throw TypeError("Found invalid FieldDropdown options.")},I.fieldRegistry.register("field_dropdown",I.FieldDropdown),I.FieldLabelSerializable=function(t,e,o){I.FieldLabelSerializable.superClass_.constructor.call(this,t,e,o)},I.utils.object.inherits(I.FieldLabelSerializable,I.FieldLabel),I.FieldLabelSerializable.fromJson=function(t){var e=I.utils.replaceMessageReferences(t.text);return new I.FieldLabelSerializable(e,void 0,t)},I.FieldLabelSerializable.prototype.EDITABLE=!1,I.FieldLabelSerializable.prototype.SERIALIZABLE=!0,I.fieldRegistry.register("field_label_serializable",I.FieldLabelSerializable),I.FieldImage=function(t,e,o,i,s,n,r){if(!t)throw Error("Src value of an image field is required");if(t=I.utils.replaceMessageReferences(t),o=Number(I.utils.replaceMessageReferences(o)),e=Number(I.utils.replaceMessageReferences(e)),isNaN(o)||isNaN(e))throw Error("Height and width values of an image field must cast to numbers.");if(o<=0||e<=0)throw Error("Height and width values of an image field must be greater than 0.");this.flipRtl_=!1,this.altText_="",I.FieldImage.superClass_.constructor.call(this,t,null,r),r||(this.flipRtl_=!!n,this.altText_=I.utils.replaceMessageReferences(i)||""),this.size_=new I.utils.Size(e,o+I.FieldImage.Y_PADDING),this.imageHeight_=o,this.clickHandler_=null,"function"==typeof s&&(this.clickHandler_=s),this.imageElement_=null},I.utils.object.inherits(I.FieldImage,I.Field),I.FieldImage.prototype.DEFAULT_VALUE="",I.FieldImage.fromJson=function(t){return new I.FieldImage(t.src,t.width,t.height,void 0,void 0,void 0,t)},I.FieldImage.Y_PADDING=1,I.FieldImage.prototype.EDITABLE=!1,I.FieldImage.prototype.isDirty_=!1,I.FieldImage.prototype.configure_=function(t){I.FieldImage.superClass_.configure_.call(this,t),this.flipRtl_=!!t.flipRtl,this.altText_=I.utils.replaceMessageReferences(t.alt)||""},I.FieldImage.prototype.initView=function(){this.imageElement_=I.utils.dom.createSvgElement(I.utils.Svg.IMAGE,{height:this.imageHeight_+"px",width:this.size_.width+"px",alt:this.altText_},this.fieldGroup_),this.imageElement_.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",this.value_),this.clickHandler_&&(this.imageElement_.style.cursor="pointer")},I.FieldImage.prototype.updateSize_=function(){},I.FieldImage.prototype.doClassValidation_=function(t){return"string"!=typeof t?null:t},I.FieldImage.prototype.doValueUpdate_=function(t){this.value_=t,this.imageElement_&&this.imageElement_.setAttributeNS(I.utils.dom.XLINK_NS,"xlink:href",String(this.value_))},I.FieldImage.prototype.getFlipRtl=function(){return this.flipRtl_},I.FieldImage.prototype.setAlt=function(t){t!=this.altText_&&(this.altText_=t||"",this.imageElement_&&this.imageElement_.setAttribute("alt",this.altText_))},I.FieldImage.prototype.showEditor_=function(){this.clickHandler_&&this.clickHandler_(this)},I.FieldImage.prototype.setOnClickHandler=function(t){this.clickHandler_=t},I.FieldImage.prototype.getText_=function(){return this.altText_},I.fieldRegistry.register("field_image",I.FieldImage),I.FieldMultilineInput=function(t,e,o){I.FieldMultilineInput.superClass_.constructor.call(this,t,e,o),this.textGroup_=null,this.maxLines_=1/0,this.isOverflowedY_=!1},I.utils.object.inherits(I.FieldMultilineInput,I.FieldTextInput),I.FieldMultilineInput.prototype.configure_=function(t){I.FieldMultilineInput.superClass_.configure_.call(this,t),t.maxLines&&this.setMaxLines(t.maxLines)},I.FieldMultilineInput.fromJson=function(t){var e=I.utils.replaceMessageReferences(t.text);return new I.FieldMultilineInput(e,void 0,t)},I.FieldMultilineInput.prototype.toXml=function(t){return t.textContent=this.getValue().replace(/\n/g,"&#10;"),t},I.FieldMultilineInput.prototype.fromXml=function(t){this.setValue(t.textContent.replace(/&#10;/g,"\n"))},I.FieldMultilineInput.prototype.initView=function(){this.createBorderRect_(),this.textGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:"blocklyEditableText"},this.fieldGroup_)},I.FieldMultilineInput.prototype.getDisplayText_=function(){var t;if(!(t=this.getText()))return I.Field.NBSP;for(var e=t.split("\n"),t="",o=this.isOverflowedY_?this.maxLines_:e.length,i=0;i<o;i++){var s=e[i];s.length>this.maxDisplayLength?s=s.substring(0,this.maxDisplayLength-4)+"...":this.isOverflowedY_&&i===o-1&&(s=s.substring(0,s.length-3)+"..."),t+=s=s.replace(/\s/g,I.Field.NBSP),i!==o-1&&(t+="\n")}return this.sourceBlock_.RTL&&(t+="‏"),t},I.FieldMultilineInput.prototype.doValueUpdate_=function(t){I.FieldMultilineInput.superClass_.doValueUpdate_.call(this,t),this.isOverflowedY_=this.value_.split("\n").length>this.maxLines_},I.FieldMultilineInput.prototype.render_=function(){for(var t;t=this.textGroup_.firstChild;)this.textGroup_.removeChild(t);for(var t=this.getDisplayText_().split("\n"),e=0,o=0;o<t.length;o++){var i=this.getConstants().FIELD_TEXT_HEIGHT+this.getConstants().FIELD_BORDER_RECT_Y_PADDING;I.utils.dom.createSvgElement(I.utils.Svg.TEXT,{class:"blocklyText blocklyMultilineText",x:this.getConstants().FIELD_BORDER_RECT_X_PADDING,y:e+this.getConstants().FIELD_BORDER_RECT_Y_PADDING,dy:this.getConstants().FIELD_TEXT_BASELINE},this.textGroup_).appendChild(document.createTextNode(t[o])),e+=i}this.isBeingEdited_&&(t=this.htmlInput_,this.isOverflowedY_?I.utils.dom.addClass(t,"blocklyHtmlTextAreaInputOverflowedY"):I.utils.dom.removeClass(t,"blocklyHtmlTextAreaInputOverflowedY")),this.updateSize_(),this.isBeingEdited_&&(this.sourceBlock_.RTL?setTimeout(this.resizeEditor_.bind(this),0):this.resizeEditor_(),t=this.htmlInput_,this.isTextValid_?(I.utils.dom.removeClass(t,"blocklyInvalidInput"),I.utils.aria.setState(t,I.utils.aria.State.INVALID,!1)):(I.utils.dom.addClass(t,"blocklyInvalidInput"),I.utils.aria.setState(t,I.utils.aria.State.INVALID,!0)))},I.FieldMultilineInput.prototype.updateSize_=function(){for(var t=this.textGroup_.childNodes,e=0,o=0,i=0;i<t.length;i++){var s=I.utils.dom.getTextWidth(t[i]);e<s&&(e=s),o+=this.getConstants().FIELD_TEXT_HEIGHT+(0<i?this.getConstants().FIELD_BORDER_RECT_Y_PADDING:0)}if(this.isBeingEdited_){for(var t=this.value_.split("\n"),s=I.utils.dom.createSvgElement(I.utils.Svg.TEXT,{class:"blocklyText blocklyMultilineText"}),n=this.getConstants().FIELD_TEXT_FONTSIZE,r=this.getConstants().FIELD_TEXT_FONTWEIGHT,l=this.getConstants().FIELD_TEXT_FONTFAMILY,i=0;i<t.length;i++){t[i].length>this.maxDisplayLength&&(t[i]=t[i].substring(0,this.maxDisplayLength)),s.textContent=t[i];var a=I.utils.dom.getFastTextWidth(s,n,r,l);e<a&&(e=a)}e+=this.htmlInput_.offsetWidth-this.htmlInput_.clientWidth}this.borderRect_&&(o+=2*this.getConstants().FIELD_BORDER_RECT_Y_PADDING,e+=2*this.getConstants().FIELD_BORDER_RECT_X_PADDING,this.borderRect_.setAttribute("width",e),this.borderRect_.setAttribute("height",o)),this.size_.width=e,this.size_.height=o,this.positionBorderRect_()},I.FieldMultilineInput.prototype.showEditor_=function(t,e){I.FieldMultilineInput.superClass_.showEditor_.call(this,t,e),this.forceRerender()},I.FieldMultilineInput.prototype.widgetCreate_=function(){var t=I.WidgetDiv.DIV,e=this.workspace_.getScale(),o=document.createElement("textarea");o.className="blocklyHtmlInput blocklyHtmlTextAreaInput",o.setAttribute("spellcheck",this.spellcheck_);var i=this.getConstants().FIELD_TEXT_FONTSIZE*e+"pt";t.style.fontSize=i,o.style.fontSize=i,o.style.borderRadius=I.FieldTextInput.BORDERRADIUS*e+"px";var i=this.getConstants().FIELD_BORDER_RECT_X_PADDING*e,s=this.getConstants().FIELD_BORDER_RECT_Y_PADDING*e/2;return o.style.padding=s+"px "+i+"px "+s+"px "+i+"px",i=this.getConstants().FIELD_TEXT_HEIGHT+this.getConstants().FIELD_BORDER_RECT_Y_PADDING,o.style.lineHeight=i*e+"px",t.appendChild(o),o.value=o.defaultValue=this.getEditorText_(this.value_),o.untypedDefaultValue_=this.value_,o.oldValue_=null,I.utils.userAgent.GECKO?setTimeout(this.resizeEditor_.bind(this),0):this.resizeEditor_(),this.bindInputEvents_(o),o},I.FieldMultilineInput.prototype.setMaxLines=function(t){"number"==typeof t&&0<t&&t!==this.maxLines_&&(this.maxLines_=t,this.forceRerender())},I.FieldMultilineInput.prototype.getMaxLines=function(){return this.maxLines_},I.FieldMultilineInput.prototype.onHtmlInputKeyDown_=function(t){t.keyCode!==I.utils.KeyCodes.ENTER&&I.FieldMultilineInput.superClass_.onHtmlInputKeyDown_.call(this,t)},I.Css.register(".blocklyHtmlTextAreaInput {,font-family: monospace;,resize: none;,overflow: hidden;,height: 100%;,text-align: left;,},.blocklyHtmlTextAreaInputOverflowedY {,overflow-y: scroll;,}".split(",")),I.fieldRegistry.register("field_multilinetext",I.FieldMultilineInput),I.FieldNumber=function(t,e,o,i,s,n){this.min_=-(1/0),this.max_=1/0,this.precision_=0,this.decimalPlaces_=null,I.FieldNumber.superClass_.constructor.call(this,t,s,n),n||this.setConstraints(e,o,i)},I.utils.object.inherits(I.FieldNumber,I.FieldTextInput),I.FieldNumber.prototype.DEFAULT_VALUE=0,I.FieldNumber.fromJson=function(t){return new I.FieldNumber(t.value,void 0,void 0,void 0,void 0,t)},I.FieldNumber.prototype.SERIALIZABLE=!0,I.FieldNumber.prototype.configure_=function(t){I.FieldNumber.superClass_.configure_.call(this,t),this.setMinInternal_(t.min),this.setMaxInternal_(t.max),this.setPrecisionInternal_(t.precision)},I.FieldNumber.prototype.setConstraints=function(t,e,o){this.setMinInternal_(t),this.setMaxInternal_(e),this.setPrecisionInternal_(o),this.setValue(this.getValue())},I.FieldNumber.prototype.setMin=function(t){this.setMinInternal_(t),this.setValue(this.getValue())},I.FieldNumber.prototype.setMinInternal_=function(t){null==t?this.min_=-(1/0):(t=Number(t),isNaN(t)||(this.min_=t))},I.FieldNumber.prototype.getMin=function(){return this.min_},I.FieldNumber.prototype.setMax=function(t){this.setMaxInternal_(t),this.setValue(this.getValue())},I.FieldNumber.prototype.setMaxInternal_=function(t){null==t?this.max_=1/0:(t=Number(t),isNaN(t)||(this.max_=t))},I.FieldNumber.prototype.getMax=function(){return this.max_},I.FieldNumber.prototype.setPrecision=function(t){this.setPrecisionInternal_(t),this.setValue(this.getValue())},I.FieldNumber.prototype.setPrecisionInternal_=function(t){null==t?this.precision_=0:(t=Number(t),isNaN(t)||(this.precision_=t));var e=this.precision_.toLocaleString("en-US",{maximumFractionDigits:20}),o=e.indexOf(".");this.decimalPlaces_=-1==o?t?0:null:e.length-o-1},I.FieldNumber.prototype.getPrecision=function(){return this.precision_},I.FieldNumber.prototype.doClassValidation_=function(t){if(null===t)return null;if(t=(t=(t=(t=String(t)).replace(/O/gi,"0")).replace(/,/g,"")).replace(/infinity/i,"Infinity"),t=Number(t||0),isNaN(t))return null;return t=Math.min(Math.max(t,this.min_),this.max_),this.precision_&&isFinite(t)&&(t=Math.round(t/this.precision_)*this.precision_),t=null!=this.decimalPlaces_?Number(t.toFixed(this.decimalPlaces_)):t},I.FieldNumber.prototype.widgetCreate_=function(){var t=I.FieldNumber.superClass_.widgetCreate_.call(this);return-(1/0)<this.min_&&I.utils.aria.setState(t,I.utils.aria.State.VALUEMIN,this.min_),1/0>this.max_&&I.utils.aria.setState(t,I.utils.aria.State.VALUEMAX,this.max_),t},I.fieldRegistry.register("field_number",I.FieldNumber),I.FieldVariable=function(t,e,o,i,s){this.menuGenerator_=I.FieldVariable.dropdownCreate,this.defaultVariableName="string"==typeof t?t:"",this.size_=new I.utils.Size(0,0),s&&this.configure_(s),e&&this.setValidator(e),s||this.setTypes_(o,i)},I.utils.object.inherits(I.FieldVariable,I.FieldDropdown),I.FieldVariable.fromJson=function(t){var e=I.utils.replaceMessageReferences(t.variable);return new I.FieldVariable(e,void 0,void 0,void 0,t)},I.FieldVariable.prototype.SERIALIZABLE=!0,I.FieldVariable.prototype.configure_=function(t){I.FieldVariable.superClass_.configure_.call(this,t),this.setTypes_(t.variableTypes,t.defaultType)},I.FieldVariable.prototype.initModel=function(){var t;this.variable_||(t=I.Variables.getOrCreateVariablePackage(this.sourceBlock_.workspace,null,this.defaultVariableName,this.defaultType_),this.doValueUpdate_(t.getId()))},I.FieldVariable.prototype.shouldAddBorderRect_=function(){return I.FieldVariable.superClass_.shouldAddBorderRect_.call(this)&&(!this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW||"variables_get"!=this.sourceBlock_.type)},I.FieldVariable.prototype.fromXml=function(t){var e=t.getAttribute("id"),o=t.textContent,i=t.getAttribute("variabletype")||t.getAttribute("variableType")||"",e=I.Variables.getOrCreateVariablePackage(this.sourceBlock_.workspace,e,o,i);if(null!=i&&i!==e.type)throw Error("Serialized variable type with id '"+e.getId()+"' had type "+e.type+", and does not match variable field that references it: "+I.Xml.domToText(t)+".");this.setValue(e.getId())},I.FieldVariable.prototype.toXml=function(t){return this.initModel(),t.id=this.variable_.getId(),t.textContent=this.variable_.name,this.variable_.type&&t.setAttribute("variabletype",this.variable_.type),t},I.FieldVariable.prototype.setSourceBlock=function(t){if(t.isShadow())throw Error("Variable fields are not allowed to exist on shadow blocks.");I.FieldVariable.superClass_.setSourceBlock.call(this,t)},I.FieldVariable.prototype.getValue=function(){return this.variable_?this.variable_.getId():null},I.FieldVariable.prototype.getText=function(){return this.variable_?this.variable_.name:""},I.FieldVariable.prototype.getVariable=function(){return this.variable_},I.FieldVariable.prototype.getValidator=function(){return this.variable_?this.validator_:null},I.FieldVariable.prototype.doClassValidation_=function(t){if(null===t)return null;var e=I.Variables.getVariable(this.sourceBlock_.workspace,t);if(!e)return console.warn("Variable id doesn't point to a real variable! ID was "+t),null;return e=e.type,this.typeIsAllowed_(e)?t:(console.warn("Variable type doesn't match this field!  Type was "+e),null)},I.FieldVariable.prototype.doValueUpdate_=function(t){this.variable_=I.Variables.getVariable(this.sourceBlock_.workspace,t),I.FieldVariable.superClass_.doValueUpdate_.call(this,t)},I.FieldVariable.prototype.typeIsAllowed_=function(t){var e=this.getVariableTypes_();if(!e)return!0;for(var o=0;o<e.length;o++)if(t==e[o])return!0;return!1},I.FieldVariable.prototype.getVariableTypes_=function(){var t=this.variableTypes;if(null===t&&this.sourceBlock_&&this.sourceBlock_.workspace)return this.sourceBlock_.workspace.getVariableTypes();if(0==(t=t||[""]).length)throw t=this.getText(),Error("'variableTypes' of field variable "+t+" was an empty list");return t},I.FieldVariable.prototype.setTypes_=function(t,e){if(e=e||"",null==t||null==t)t=null;else{if(!Array.isArray(t))throw Error("'variableTypes' was not an array in the definition of a FieldVariable");for(var o=!1,i=0;i<t.length;i++)t[i]==e&&(o=!0);if(!o)throw Error("Invalid default type '"+e+"' in the definition of a FieldVariable")}this.defaultType_=e,this.variableTypes=t},I.FieldVariable.prototype.refreshVariableName=function(){this.forceRerender()},I.FieldVariable.dropdownCreate=function(){if(!this.variable_)throw Error("Tried to call dropdownCreate on a variable field with no variable selected.");var t=this.getText(),e=[];if(this.sourceBlock_&&this.sourceBlock_.workspace)for(var o=this.getVariableTypes_(),i=0;i<o.length;i++)var s=this.sourceBlock_.workspace.getVariablesOfType(o[i]),e=e.concat(s);for(e.sort(I.VariableModel.compareByName),o=[],i=0;i<e.length;i++)o[i]=[e[i].name,e[i].getId()];return o.push([I.Msg.RENAME_VARIABLE,I.RENAME_VARIABLE_ID]),I.Msg.DELETE_VARIABLE&&o.push([I.Msg.DELETE_VARIABLE.replace("%1",t),I.DELETE_VARIABLE_ID]),o},I.FieldVariable.prototype.onItemSelected_=function(t,e){if(t=e.getValue(),this.sourceBlock_&&this.sourceBlock_.workspace){if(t==I.RENAME_VARIABLE_ID)return void I.Variables.renameVariable(this.sourceBlock_.workspace,this.variable_);if(t==I.DELETE_VARIABLE_ID)return void this.sourceBlock_.workspace.deleteVariableById(this.variable_.getId())}this.setValue(t)},I.FieldVariable.prototype.referencesVariables=function(){return!0},I.fieldRegistry.register("field_variable",I.FieldVariable),I.utils.svgPaths={},I.utils.svgPaths.point=function(t,e){return" "+t+","+e+" "},I.utils.svgPaths.curve=function(t,e){return" "+t+e.join("")},I.utils.svgPaths.moveTo=function(t,e){return" M "+t+","+e+" "},I.utils.svgPaths.moveBy=function(t,e){return" m "+t+","+e+" "},I.utils.svgPaths.lineTo=function(t,e){return" l "+t+","+e+" "},I.utils.svgPaths.line=function(t){return" l"+t.join("")},I.utils.svgPaths.lineOnAxis=function(t,e){return" "+t+" "+e+" "},I.utils.svgPaths.arc=function(t,e,o,i){return t+" "+o+" "+o+" "+e+i},I.blockRendering.ConstantProvider=function(){this.NO_PADDING=0,this.SMALL_PADDING=3,this.MEDIUM_PADDING=5,this.MEDIUM_LARGE_PADDING=8,this.LARGE_PADDING=10,this.TALL_INPUT_FIELD_OFFSET_Y=this.MEDIUM_PADDING,this.TAB_HEIGHT=15,this.TAB_OFFSET_FROM_TOP=5,this.TAB_VERTICAL_OVERLAP=2.5,this.TAB_WIDTH=8,this.NOTCH_WIDTH=15,this.NOTCH_HEIGHT=4,this.MIN_BLOCK_WIDTH=12,this.EMPTY_BLOCK_SPACER_HEIGHT=16,this.DUMMY_INPUT_SHADOW_MIN_HEIGHT=this.DUMMY_INPUT_MIN_HEIGHT=this.TAB_HEIGHT,this.CORNER_RADIUS=8,this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT=15,this.STATEMENT_BOTTOM_SPACER=0,this.STATEMENT_INPUT_PADDING_LEFT=20,this.BETWEEN_STATEMENT_PADDING_Y=4,this.TOP_ROW_MIN_HEIGHT=this.MEDIUM_PADDING,this.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.BOTTOM_ROW_MIN_HEIGHT=this.MEDIUM_PADDING,this.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.ADD_START_HATS=!1,this.START_HAT_HEIGHT=15,this.START_HAT_WIDTH=100,this.SPACER_DEFAULT_HEIGHT=15,this.MIN_BLOCK_HEIGHT=24,this.EMPTY_INLINE_INPUT_PADDING=14.5,this.EMPTY_INLINE_INPUT_HEIGHT=this.TAB_HEIGHT+11,this.EXTERNAL_VALUE_INPUT_PADDING=2,this.EMPTY_STATEMENT_INPUT_HEIGHT=this.MIN_BLOCK_HEIGHT,this.START_POINT=I.utils.svgPaths.moveBy(0,0),this.JAGGED_TEETH_HEIGHT=12,this.JAGGED_TEETH_WIDTH=6,this.FIELD_TEXT_FONTSIZE=11,this.FIELD_TEXT_FONTWEIGHT="normal",this.FIELD_TEXT_FONTFAMILY="sans-serif",this.FIELD_TEXT_BASELINE=this.FIELD_TEXT_HEIGHT=-1,this.FIELD_BORDER_RECT_RADIUS=4,this.FIELD_BORDER_RECT_HEIGHT=16,this.FIELD_BORDER_RECT_X_PADDING=5,this.FIELD_BORDER_RECT_Y_PADDING=3,this.FIELD_BORDER_RECT_COLOUR="#fff",this.FIELD_TEXT_BASELINE_CENTER=!I.utils.userAgent.IE&&!I.utils.userAgent.EDGE,this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT,this.FIELD_DROPDOWN_SVG_ARROW=this.FIELD_DROPDOWN_COLOURED_DIV=this.FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW=!1,this.FIELD_DROPDOWN_SVG_ARROW_PADDING=this.FIELD_BORDER_RECT_X_PADDING,this.FIELD_DROPDOWN_SVG_ARROW_SIZE=12,this.FIELD_DROPDOWN_SVG_ARROW_DATAURI="data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMi43MSIgaGVpZ2h0PSI4Ljc5IiB2aWV3Qm94PSIwIDAgMTIuNzEgOC43OSI+PHRpdGxlPmRyb3Bkb3duLWFycm93PC90aXRsZT48ZyBvcGFjaXR5PSIwLjEiPjxwYXRoIGQ9Ik0xMi43MSwyLjQ0QTIuNDEsMi40MSwwLDAsMSwxMiw0LjE2TDguMDgsOC4wOGEyLjQ1LDIuNDUsMCwwLDEtMy40NSwwTDAuNzIsNC4xNkEyLjQyLDIuNDIsMCwwLDEsMCwyLjQ0LDIuNDgsMi40OCwwLDAsMSwuNzEuNzFDMSwwLjQ3LDEuNDMsMCw2LjM2LDBTMTEuNzUsMC40NiwxMiwuNzFBMi40NCwyLjQ0LDAsMCwxLDEyLjcxLDIuNDRaIiBmaWxsPSIjMjMxZjIwIi8+PC9nPjxwYXRoIGQ9Ik02LjM2LDcuNzlhMS40MywxLjQzLDAsMCwxLTEtLjQyTDEuNDIsMy40NWExLjQ0LDEuNDQsMCwwLDEsMC0yYzAuNTYtLjU2LDkuMzEtMC41Niw5Ljg3LDBhMS40NCwxLjQ0LDAsMCwxLDAsMkw3LjM3LDcuMzdBMS40MywxLjQzLDAsMCwxLDYuMzYsNy43OVoiIGZpbGw9IiNmZmYiLz48L3N2Zz4=",this.FIELD_COLOUR_FULL_BLOCK=this.FIELD_TEXTINPUT_BOX_SHADOW=!1,this.FIELD_COLOUR_DEFAULT_WIDTH=26,this.FIELD_COLOUR_DEFAULT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT,this.FIELD_CHECKBOX_X_OFFSET=this.FIELD_BORDER_RECT_X_PADDING-3,this.randomIdentifier=String(Math.random()).substring(2),this.embossFilterId="",this.embossFilter_=null,this.disabledPatternId="",this.disabledPattern_=null,this.debugFilterId="",this.cssNode_=this.debugFilter_=null,this.CURSOR_COLOUR="#cc0a0a",this.MARKER_COLOUR="#4286f4",this.CURSOR_WS_WIDTH=100,this.WS_CURSOR_HEIGHT=5,this.CURSOR_STACK_PADDING=10,this.CURSOR_BLOCK_PADDING=2,this.CURSOR_STROKE_WIDTH=4,this.FULL_BLOCK_FIELDS=!1,this.INSERTION_MARKER_COLOUR="#000000",this.INSERTION_MARKER_OPACITY=.2,this.SHAPES={PUZZLE:1,NOTCH:2}},I.blockRendering.ConstantProvider.prototype.init=function(){this.JAGGED_TEETH=this.makeJaggedTeeth(),this.NOTCH=this.makeNotch(),this.START_HAT=this.makeStartHat(),this.PUZZLE_TAB=this.makePuzzleTab(),this.INSIDE_CORNERS=this.makeInsideCorners(),this.OUTSIDE_CORNERS=this.makeOutsideCorners()},I.blockRendering.ConstantProvider.prototype.setTheme=function(t){this.blockStyles={};var e=t.blockStyles,o;for(o in e)this.blockStyles[o]=this.validatedBlockStyle_(e[o]);this.setDynamicProperties_(t)},I.blockRendering.ConstantProvider.prototype.setDynamicProperties_=function(t){this.setFontConstants_(t),this.setComponentConstants_(t),this.ADD_START_HATS=null!=t.startHats?t.startHats:this.ADD_START_HATS},I.blockRendering.ConstantProvider.prototype.setFontConstants_=function(t){this.FIELD_TEXT_FONTFAMILY=t.fontStyle&&null!=t.fontStyle.family?t.fontStyle.family:this.FIELD_TEXT_FONTFAMILY,this.FIELD_TEXT_FONTWEIGHT=t.fontStyle&&null!=t.fontStyle.weight?t.fontStyle.weight:this.FIELD_TEXT_FONTWEIGHT,this.FIELD_TEXT_FONTSIZE=t.fontStyle&&null!=t.fontStyle.size?t.fontStyle.size:this.FIELD_TEXT_FONTSIZE,t=I.utils.dom.measureFontMetrics("Hg",this.FIELD_TEXT_FONTSIZE+"pt",this.FIELD_TEXT_FONTWEIGHT,this.FIELD_TEXT_FONTFAMILY),this.FIELD_TEXT_HEIGHT=t.height,this.FIELD_TEXT_BASELINE=t.baseline},I.blockRendering.ConstantProvider.prototype.setComponentConstants_=function(t){this.CURSOR_COLOUR=t.getComponentStyle("cursorColour")||this.CURSOR_COLOUR,this.MARKER_COLOUR=t.getComponentStyle("markerColour")||this.MARKER_COLOUR,this.INSERTION_MARKER_COLOUR=t.getComponentStyle("insertionMarkerColour")||this.INSERTION_MARKER_COLOUR,this.INSERTION_MARKER_OPACITY=Number(t.getComponentStyle("insertionMarkerOpacity"))||this.INSERTION_MARKER_OPACITY},I.blockRendering.ConstantProvider.prototype.getBlockStyleForColour=function(t){var e="auto_"+t;return this.blockStyles[e]||(this.blockStyles[e]=this.createBlockStyle_(t)),{style:this.blockStyles[e],name:e}},I.blockRendering.ConstantProvider.prototype.getBlockStyle=function(t){return this.blockStyles[t||""]||(t&&0==t.indexOf("auto_")?this.getBlockStyleForColour(t.substring(5)).style:this.createBlockStyle_("#000000"))},I.blockRendering.ConstantProvider.prototype.createBlockStyle_=function(t){return this.validatedBlockStyle_({colourPrimary:t})},I.blockRendering.ConstantProvider.prototype.validatedBlockStyle_=function(t){var e={};return t&&I.utils.object.mixin(e,t),t=I.utils.parseBlockColour(e.colourPrimary||"#000"),e.colourPrimary=t.hex,e.colourSecondary=e.colourSecondary?I.utils.parseBlockColour(e.colourSecondary).hex:this.generateSecondaryColour_(e.colourPrimary),e.colourTertiary=e.colourTertiary?I.utils.parseBlockColour(e.colourTertiary).hex:this.generateTertiaryColour_(e.colourPrimary),e.hat=e.hat||"",e},I.blockRendering.ConstantProvider.prototype.generateSecondaryColour_=function(t){return I.utils.colour.blend("#fff",t,.6)||t},I.blockRendering.ConstantProvider.prototype.generateTertiaryColour_=function(t){return I.utils.colour.blend("#fff",t,.3)||t},I.blockRendering.ConstantProvider.prototype.dispose=function(){this.embossFilter_&&I.utils.dom.removeNode(this.embossFilter_),this.disabledPattern_&&I.utils.dom.removeNode(this.disabledPattern_),this.debugFilter_&&I.utils.dom.removeNode(this.debugFilter_),this.cssNode_=null},I.blockRendering.ConstantProvider.prototype.makeJaggedTeeth=function(){var t=this.JAGGED_TEETH_HEIGHT,e=this.JAGGED_TEETH_WIDTH,o;return{height:t,width:e,path:I.utils.svgPaths.line([I.utils.svgPaths.point(e,t/4),I.utils.svgPaths.point(2*-e,t/2),I.utils.svgPaths.point(e,t/4)])}},I.blockRendering.ConstantProvider.prototype.makeStartHat=function(){var t=this.START_HAT_HEIGHT,e=this.START_HAT_WIDTH,o;return{height:t,width:e,path:I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(30,-t),I.utils.svgPaths.point(70,-t),I.utils.svgPaths.point(e,0)])}},I.blockRendering.ConstantProvider.prototype.makePuzzleTab=function(){function t(t){var e=-(t=t?-1:1),o,i=(o=l/2)+2.5,s=o+.5,n=I.utils.svgPaths.point(-r,t*o),o=I.utils.svgPaths.point(r,t*o);return I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(0,t*i),I.utils.svgPaths.point(-r,e*s),n])+I.utils.svgPaths.curve("s",[I.utils.svgPaths.point(r,2.5*e),o])}var r=this.TAB_WIDTH,l=this.TAB_HEIGHT,e=t(!0),o=t(!1);return{type:this.SHAPES.PUZZLE,width:r,height:l,pathDown:o,pathUp:e}},I.blockRendering.ConstantProvider.prototype.makeNotch=function(){function t(t){return I.utils.svgPaths.line([I.utils.svgPaths.point(t*i,o),I.utils.svgPaths.point(3*t,0),I.utils.svgPaths.point(t*i,-o)])}var e=this.NOTCH_WIDTH,o=this.NOTCH_HEIGHT,i=(e-3)/2,s=t(1),n=t(-1);return{type:this.SHAPES.NOTCH,width:e,height:o,pathLeft:s,pathRight:n}},I.blockRendering.ConstantProvider.prototype.makeInsideCorners=function(){var t=this.CORNER_RADIUS,e,o;return{width:t,height:t,pathTop:I.utils.svgPaths.arc("a","0 0,0",t,I.utils.svgPaths.point(-t,t)),pathBottom:I.utils.svgPaths.arc("a","0 0,0",t,I.utils.svgPaths.point(t,t))}},I.blockRendering.ConstantProvider.prototype.makeOutsideCorners=function(){var t=this.CORNER_RADIUS,e=I.utils.svgPaths.moveBy(0,t)+I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(t,-t)),o=I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(t,t)),i=I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(-t,-t)),s;return{topLeft:e,topRight:o,bottomRight:I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(-t,t)),bottomLeft:i,rightHeight:t}},I.blockRendering.ConstantProvider.prototype.shapeFor=function(t){switch(t.type){case I.connectionTypes.INPUT_VALUE:case I.connectionTypes.OUTPUT_VALUE:return this.PUZZLE_TAB;case I.connectionTypes.PREVIOUS_STATEMENT:case I.connectionTypes.NEXT_STATEMENT:return this.NOTCH;default:throw Error("Unknown connection type")}},I.blockRendering.ConstantProvider.prototype.createDom=function(t,e,o){this.injectCSS_(e,o),t=I.utils.dom.createSvgElement(I.utils.Svg.DEFS,{},t),e=I.utils.dom.createSvgElement(I.utils.Svg.FILTER,{id:"blocklyEmbossFilter"+this.randomIdentifier},t),I.utils.dom.createSvgElement(I.utils.Svg.FEGAUSSIANBLUR,{in:"SourceAlpha",stdDeviation:1,result:"blur"},e),o=I.utils.dom.createSvgElement(I.utils.Svg.FESPECULARLIGHTING,{in:"blur",surfaceScale:1,specularConstant:.5,specularExponent:10,"lighting-color":"white",result:"specOut"},e),I.utils.dom.createSvgElement(I.utils.Svg.FEPOINTLIGHT,{x:-5e3,y:-1e4,z:2e4},o),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"specOut",in2:"SourceAlpha",operator:"in",result:"specOut"},e),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"SourceGraphic",in2:"specOut",operator:"arithmetic",k1:0,k2:1,k3:1,k4:0},e),this.embossFilterId=e.id,this.embossFilter_=e,e=I.utils.dom.createSvgElement(I.utils.Svg.PATTERN,{id:"blocklyDisabledPattern"+this.randomIdentifier,patternUnits:"userSpaceOnUse",width:10,height:10},t),I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:10,height:10,fill:"#aaa"},e),I.utils.dom.createSvgElement(I.utils.Svg.PATH,{d:"M 0 0 L 10 10 M 10 0 L 0 10",stroke:"#cc0"},e),this.disabledPatternId=e.id,this.disabledPattern_=e,I.blockRendering.Debug&&(t=I.utils.dom.createSvgElement(I.utils.Svg.FILTER,{id:"blocklyDebugFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),e=I.utils.dom.createSvgElement(I.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},t),I.utils.dom.createSvgElement(I.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},e),I.utils.dom.createSvgElement(I.utils.Svg.FEFLOOD,{"flood-color":"#ff0000","flood-opacity":.5,result:"outColor"},t),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},t),this.debugFilterId=t.id,this.debugFilter_=t)},I.blockRendering.ConstantProvider.prototype.injectCSS_=function(t,e){e=this.getCSS_(e),t="blockly-renderer-style-"+t,this.cssNode_=document.getElementById(t);var o=e.join("\n");this.cssNode_?this.cssNode_.firstChild.textContent=o:((e=document.createElement("style")).id=t,t=document.createTextNode(o),e.appendChild(t),document.head.insertBefore(e,document.head.firstChild),this.cssNode_=e)},I.blockRendering.ConstantProvider.prototype.getCSS_=function(t){return[t+" .blocklyText, ",t+" .blocklyFlyoutLabelText {","font: "+this.FIELD_TEXT_FONTWEIGHT+" "+this.FIELD_TEXT_FONTSIZE+"pt "+this.FIELD_TEXT_FONTFAMILY+";","}",t+" .blocklyText {","fill: #fff;","}",t+" .blocklyNonEditableText>rect,",t+" .blocklyEditableText>rect {","fill: "+this.FIELD_BORDER_RECT_COLOUR+";","fill-opacity: .6;","stroke: none;","}",t+" .blocklyNonEditableText>text,",t+" .blocklyEditableText>text {","fill: #000;","}",t+" .blocklyFlyoutLabelText {","fill: #000;","}",t+" .blocklyText.blocklyBubbleText {","fill: #000;","}",t+" .blocklyEditableText:not(.editing):hover>rect {","stroke: #fff;","stroke-width: 2;","}",t+" .blocklyHtmlInput {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","font-weight: "+this.FIELD_TEXT_FONTWEIGHT+";","}",t+" .blocklySelected>.blocklyPath {","stroke: #fc3;","stroke-width: 3px;","}",t+" .blocklyHighlightedConnectionPath {","stroke: #fc3;","}",t+" .blocklyReplaceable .blocklyPath {","fill-opacity: .5;","}",t+" .blocklyReplaceable .blocklyPathLight,",t+" .blocklyReplaceable .blocklyPathDark {","display: none;","}",t+" .blocklyInsertionMarker>.blocklyPath {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"]},I.blockRendering.Types={NONE:0,FIELD:1,HAT:2,ICON:4,SPACER:8,BETWEEN_ROW_SPACER:16,IN_ROW_SPACER:32,EXTERNAL_VALUE_INPUT:64,INPUT:128,INLINE_INPUT:256,STATEMENT_INPUT:512,CONNECTION:1024,PREVIOUS_CONNECTION:2048,NEXT_CONNECTION:4096,OUTPUT_CONNECTION:8192,CORNER:16384,LEFT_SQUARE_CORNER:32768,LEFT_ROUND_CORNER:65536,RIGHT_SQUARE_CORNER:131072,RIGHT_ROUND_CORNER:262144,JAGGED_EDGE:524288,ROW:1048576,TOP_ROW:2097152,BOTTOM_ROW:4194304,INPUT_ROW:8388608},I.blockRendering.Types.LEFT_CORNER=I.blockRendering.Types.LEFT_SQUARE_CORNER|I.blockRendering.Types.LEFT_ROUND_CORNER,I.blockRendering.Types.RIGHT_CORNER=I.blockRendering.Types.RIGHT_SQUARE_CORNER|I.blockRendering.Types.RIGHT_ROUND_CORNER,I.blockRendering.Types.nextTypeValue_=16777216,I.blockRendering.Types.getType=function(t){return Object.prototype.hasOwnProperty.call(I.blockRendering.Types,t)||(I.blockRendering.Types[t]=I.blockRendering.Types.nextTypeValue_,I.blockRendering.Types.nextTypeValue_<<=1),I.blockRendering.Types[t]},I.blockRendering.Types.isField=function(t){return t.type&I.blockRendering.Types.FIELD},I.blockRendering.Types.isHat=function(t){return t.type&I.blockRendering.Types.HAT},I.blockRendering.Types.isIcon=function(t){return t.type&I.blockRendering.Types.ICON},I.blockRendering.Types.isSpacer=function(t){return t.type&I.blockRendering.Types.SPACER},I.blockRendering.Types.isInRowSpacer=function(t){return t.type&I.blockRendering.Types.IN_ROW_SPACER},I.blockRendering.Types.isInput=function(t){return t.type&I.blockRendering.Types.INPUT},I.blockRendering.Types.isExternalInput=function(t){return t.type&I.blockRendering.Types.EXTERNAL_VALUE_INPUT},I.blockRendering.Types.isInlineInput=function(t){return t.type&I.blockRendering.Types.INLINE_INPUT},I.blockRendering.Types.isStatementInput=function(t){return t.type&I.blockRendering.Types.STATEMENT_INPUT},I.blockRendering.Types.isPreviousConnection=function(t){return t.type&I.blockRendering.Types.PREVIOUS_CONNECTION},I.blockRendering.Types.isNextConnection=function(t){return t.type&I.blockRendering.Types.NEXT_CONNECTION},I.blockRendering.Types.isPreviousOrNextConnection=function(t){return t.type&(I.blockRendering.Types.PREVIOUS_CONNECTION|I.blockRendering.Types.NEXT_CONNECTION)},I.blockRendering.Types.isLeftRoundedCorner=function(t){return t.type&I.blockRendering.Types.LEFT_ROUND_CORNER},I.blockRendering.Types.isRightRoundedCorner=function(t){return t.type&I.blockRendering.Types.RIGHT_ROUND_CORNER},I.blockRendering.Types.isLeftSquareCorner=function(t){return t.type&I.blockRendering.Types.LEFT_SQUARE_CORNER},I.blockRendering.Types.isRightSquareCorner=function(t){return t.type&I.blockRendering.Types.RIGHT_SQUARE_CORNER},I.blockRendering.Types.isCorner=function(t){return t.type&I.blockRendering.Types.CORNER},I.blockRendering.Types.isJaggedEdge=function(t){return t.type&I.blockRendering.Types.JAGGED_EDGE},I.blockRendering.Types.isRow=function(t){return t.type&I.blockRendering.Types.ROW},I.blockRendering.Types.isBetweenRowSpacer=function(t){return t.type&I.blockRendering.Types.BETWEEN_ROW_SPACER},I.blockRendering.Types.isTopRow=function(t){return t.type&I.blockRendering.Types.TOP_ROW},I.blockRendering.Types.isBottomRow=function(t){return t.type&I.blockRendering.Types.BOTTOM_ROW},I.blockRendering.Types.isTopOrBottomRow=function(t){return t.type&(I.blockRendering.Types.TOP_ROW|I.blockRendering.Types.BOTTOM_ROW)},I.blockRendering.Types.isInputRow=function(t){return t.type&I.blockRendering.Types.INPUT_ROW},I.blockRendering.Measurable=function(t){this.height=this.width=0,this.type=I.blockRendering.Types.NONE,this.centerline=this.xPos=0,this.constants_=t,this.notchOffset=this.constants_.NOTCH_OFFSET_LEFT},I.blockRendering.Connection=function(t,e){I.blockRendering.Connection.superClass_.constructor.call(this,t),this.connectionModel=e,this.shape=this.constants_.shapeFor(e),this.isDynamicShape=!!this.shape.isDynamic,this.type|=I.blockRendering.Types.CONNECTION},I.utils.object.inherits(I.blockRendering.Connection,I.blockRendering.Measurable),I.blockRendering.OutputConnection=function(t,e){I.blockRendering.OutputConnection.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.OUTPUT_CONNECTION,this.height=this.isDynamicShape?0:this.shape.height,this.startX=this.width=this.isDynamicShape?0:this.shape.width,this.connectionOffsetY=this.constants_.TAB_OFFSET_FROM_TOP,this.connectionOffsetX=0},I.utils.object.inherits(I.blockRendering.OutputConnection,I.blockRendering.Connection),I.blockRendering.PreviousConnection=function(t,e){I.blockRendering.PreviousConnection.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.PREVIOUS_CONNECTION,this.height=this.shape.height,this.width=this.shape.width},I.utils.object.inherits(I.blockRendering.PreviousConnection,I.blockRendering.Connection),I.blockRendering.NextConnection=function(t,e){I.blockRendering.NextConnection.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.NEXT_CONNECTION,this.height=this.shape.height,this.width=this.shape.width},I.utils.object.inherits(I.blockRendering.NextConnection,I.blockRendering.Connection),I.blockRendering.InputConnection=function(t,e){I.blockRendering.InputConnection.superClass_.constructor.call(this,t,e.connection),this.type|=I.blockRendering.Types.INPUT,this.input=e,this.align=e.align,(this.connectedBlock=e.connection&&e.connection.targetBlock()?e.connection.targetBlock():null)?(t=this.connectedBlock.getHeightWidth(),this.connectedBlockWidth=t.width,this.connectedBlockHeight=t.height):this.connectedBlockHeight=this.connectedBlockWidth=0,this.connectionOffsetY=this.connectionOffsetX=0},I.utils.object.inherits(I.blockRendering.InputConnection,I.blockRendering.Connection),I.blockRendering.InlineInput=function(t,e){I.blockRendering.InlineInput.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.INLINE_INPUT,this.connectedBlock?(this.width=this.connectedBlockWidth,this.height=this.connectedBlockHeight):(this.height=this.constants_.EMPTY_INLINE_INPUT_HEIGHT,this.width=this.constants_.EMPTY_INLINE_INPUT_PADDING),this.connectionHeight=this.isDynamicShape?this.shape.height(this.height):this.shape.height,this.connectionWidth=this.isDynamicShape?this.shape.width(this.height):this.shape.width,this.connectedBlock||(this.width+=this.connectionWidth*(this.isDynamicShape?2:1)),this.connectionOffsetY=this.isDynamicShape?this.shape.connectionOffsetY(this.connectionHeight):this.constants_.TAB_OFFSET_FROM_TOP,this.connectionOffsetX=this.isDynamicShape?this.shape.connectionOffsetX(this.connectionWidth):0},I.utils.object.inherits(I.blockRendering.InlineInput,I.blockRendering.InputConnection),I.blockRendering.StatementInput=function(t,e){I.blockRendering.StatementInput.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.STATEMENT_INPUT,this.height=this.connectedBlock?this.connectedBlockHeight+this.constants_.STATEMENT_BOTTOM_SPACER:this.constants_.EMPTY_STATEMENT_INPUT_HEIGHT,this.width=this.constants_.STATEMENT_INPUT_NOTCH_OFFSET+this.shape.width},I.utils.object.inherits(I.blockRendering.StatementInput,I.blockRendering.InputConnection),I.blockRendering.ExternalValueInput=function(t,e){I.blockRendering.ExternalValueInput.superClass_.constructor.call(this,t,e),this.type|=I.blockRendering.Types.EXTERNAL_VALUE_INPUT,this.height=this.connectedBlock?this.connectedBlockHeight-this.constants_.TAB_OFFSET_FROM_TOP-this.constants_.MEDIUM_PADDING:this.shape.height,this.width=this.shape.width+this.constants_.EXTERNAL_VALUE_INPUT_PADDING,this.connectionOffsetY=this.constants_.TAB_OFFSET_FROM_TOP,this.connectionHeight=this.shape.height,this.connectionWidth=this.shape.width},I.utils.object.inherits(I.blockRendering.ExternalValueInput,I.blockRendering.InputConnection),I.blockRendering.Icon=function(t,e){I.blockRendering.Icon.superClass_.constructor.call(this,t),this.icon=e,this.isVisible=e.isVisible(),this.type|=I.blockRendering.Types.ICON,t=e.getCorrectedSize(),this.height=t.height,this.width=t.width},I.utils.object.inherits(I.blockRendering.Icon,I.blockRendering.Measurable),I.blockRendering.JaggedEdge=function(t){I.blockRendering.JaggedEdge.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.JAGGED_EDGE,this.height=this.constants_.JAGGED_TEETH.height,this.width=this.constants_.JAGGED_TEETH.width},I.utils.object.inherits(I.blockRendering.JaggedEdge,I.blockRendering.Measurable),I.blockRendering.Field=function(t,e,o){I.blockRendering.Field.superClass_.constructor.call(this,t),this.field=e,this.isEditable=e.EDITABLE,this.flipRtl=e.getFlipRtl(),this.type|=I.blockRendering.Types.FIELD,t=this.field.getSize(),this.height=t.height,this.width=t.width,this.parentInput=o},I.utils.object.inherits(I.blockRendering.Field,I.blockRendering.Measurable),I.blockRendering.Hat=function(t){I.blockRendering.Hat.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.HAT,this.height=this.constants_.START_HAT.height,this.width=this.constants_.START_HAT.width,this.ascenderHeight=this.height},I.utils.object.inherits(I.blockRendering.Hat,I.blockRendering.Measurable),I.blockRendering.SquareCorner=function(t,e){I.blockRendering.SquareCorner.superClass_.constructor.call(this,t),this.type=(e&&"left"!=e?I.blockRendering.Types.RIGHT_SQUARE_CORNER:I.blockRendering.Types.LEFT_SQUARE_CORNER)|I.blockRendering.Types.CORNER,this.width=this.height=this.constants_.NO_PADDING},I.utils.object.inherits(I.blockRendering.SquareCorner,I.blockRendering.Measurable),I.blockRendering.RoundCorner=function(t,e){I.blockRendering.RoundCorner.superClass_.constructor.call(this,t),this.type=(e&&"left"!=e?I.blockRendering.Types.RIGHT_ROUND_CORNER:I.blockRendering.Types.LEFT_ROUND_CORNER)|I.blockRendering.Types.CORNER,this.width=this.constants_.CORNER_RADIUS,this.height=this.constants_.CORNER_RADIUS/2},I.utils.object.inherits(I.blockRendering.RoundCorner,I.blockRendering.Measurable),I.blockRendering.InRowSpacer=function(t,e){I.blockRendering.InRowSpacer.superClass_.constructor.call(this,t),this.type=this.type|I.blockRendering.Types.SPACER|I.blockRendering.Types.IN_ROW_SPACER,this.width=e,this.height=this.constants_.SPACER_DEFAULT_HEIGHT},I.utils.object.inherits(I.blockRendering.InRowSpacer,I.blockRendering.Measurable),I.blockRendering.Row=function(t){this.type=I.blockRendering.Types.ROW,this.elements=[],this.xPos=this.yPos=this.widthWithConnectedBlocks=this.minWidth=this.minHeight=this.width=this.height=0,this.hasJaggedEdge=this.hasDummyInput=this.hasInlineInput=this.hasStatement=this.hasExternalInput=!1,this.constants_=t,this.notchOffset=this.constants_.NOTCH_OFFSET_LEFT,this.align=null},I.blockRendering.Row.prototype.measure=function(){throw Error("Unexpected attempt to measure a base Row.")},I.blockRendering.Row.prototype.getLastInput=function(){for(var t=this.elements.length-1,e;e=this.elements[t];t--)if(I.blockRendering.Types.isInput(e))return e;return null},I.blockRendering.Row.prototype.startsWithElemSpacer=function(){return!0},I.blockRendering.Row.prototype.endsWithElemSpacer=function(){return!0},I.blockRendering.Row.prototype.getFirstSpacer=function(){for(var t=0,e;e=this.elements[t];t++)if(I.blockRendering.Types.isSpacer(e))return e;return null},I.blockRendering.Row.prototype.getLastSpacer=function(){for(var t=this.elements.length-1,e;e=this.elements[t];t--)if(I.blockRendering.Types.isSpacer(e))return e;return null},I.blockRendering.TopRow=function(t){I.blockRendering.TopRow.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.TOP_ROW,this.ascenderHeight=this.capline=0,this.hasPreviousConnection=!1,this.connection=null},I.utils.object.inherits(I.blockRendering.TopRow,I.blockRendering.Row),I.blockRendering.TopRow.prototype.hasLeftSquareCorner=function(t){var e=(t.hat?"cap"===t.hat:this.constants_.ADD_START_HATS)&&!t.outputConnection&&!t.previousConnection,o=t.getPreviousBlock();return!!t.outputConnection||e||!!o&&o.getNextBlock()==t},I.blockRendering.TopRow.prototype.hasRightSquareCorner=function(t){return!0},I.blockRendering.TopRow.prototype.measure=function(){for(var t=0,e=0,o=0,i=0,s;s=this.elements[i];i++)e+=s.width,I.blockRendering.Types.isSpacer(s)||(I.blockRendering.Types.isHat(s)?o=Math.max(o,s.ascenderHeight):t=Math.max(t,s.height));this.width=Math.max(this.minWidth,e),this.height=Math.max(this.minHeight,t)+o,this.capline=this.ascenderHeight=o,this.widthWithConnectedBlocks=this.width},I.blockRendering.TopRow.prototype.startsWithElemSpacer=function(){return!1},I.blockRendering.TopRow.prototype.endsWithElemSpacer=function(){return!1},I.blockRendering.BottomRow=function(t){I.blockRendering.BottomRow.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.BOTTOM_ROW,this.hasNextConnection=!1,this.connection=null,this.baseline=this.descenderHeight=0},I.utils.object.inherits(I.blockRendering.BottomRow,I.blockRendering.Row),I.blockRendering.BottomRow.prototype.hasLeftSquareCorner=function(t){return!!t.outputConnection||!!t.getNextBlock()},I.blockRendering.BottomRow.prototype.hasRightSquareCorner=function(t){return!0},I.blockRendering.BottomRow.prototype.measure=function(){for(var t=0,e=0,o=0,i=0,s;s=this.elements[i];i++)e+=s.width,I.blockRendering.Types.isSpacer(s)||(I.blockRendering.Types.isNextConnection(s)?o=Math.max(o,s.height):t=Math.max(t,s.height));this.width=Math.max(this.minWidth,e),this.height=Math.max(this.minHeight,t)+o,this.descenderHeight=o,this.widthWithConnectedBlocks=this.width},I.blockRendering.BottomRow.prototype.startsWithElemSpacer=function(){return!1},I.blockRendering.BottomRow.prototype.endsWithElemSpacer=function(){return!1},I.blockRendering.SpacerRow=function(t,e,o){I.blockRendering.SpacerRow.superClass_.constructor.call(this,t),this.type=this.type|I.blockRendering.Types.SPACER|I.blockRendering.Types.BETWEEN_ROW_SPACER,this.width=o,this.height=e,this.followsStatement=!1,this.widthWithConnectedBlocks=0,this.elements=[new I.blockRendering.InRowSpacer(this.constants_,o)]},I.utils.object.inherits(I.blockRendering.SpacerRow,I.blockRendering.Row),I.blockRendering.SpacerRow.prototype.measure=function(){},I.blockRendering.InputRow=function(t){I.blockRendering.InputRow.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.INPUT_ROW,this.connectedBlockWidths=0},I.utils.object.inherits(I.blockRendering.InputRow,I.blockRendering.Row),I.blockRendering.InputRow.prototype.measure=function(){this.width=this.minWidth,this.height=this.minHeight;for(var t=0,e=0,o;o=this.elements[e];e++)this.width+=o.width,I.blockRendering.Types.isInput(o)&&(I.blockRendering.Types.isStatementInput(o)?t+=o.connectedBlockWidth:I.blockRendering.Types.isExternalInput(o)&&0!=o.connectedBlockWidth&&(t+=o.connectedBlockWidth-o.connectionWidth)),I.blockRendering.Types.isSpacer(o)||(this.height=Math.max(this.height,o.height));this.connectedBlockWidths=t,this.widthWithConnectedBlocks=this.width+t},I.blockRendering.InputRow.prototype.endsWithElemSpacer=function(){return!this.hasExternalInput&&!this.hasStatement},I.blockRendering.RenderInfo=function(t,e){this.block_=e,this.renderer_=t,this.constants_=this.renderer_.getConstants(),this.outputConnection=e.outputConnection?new I.blockRendering.OutputConnection(this.constants_,e.outputConnection):null,this.isInline=e.getInputsInline()&&!e.isCollapsed(),this.isCollapsed=e.isCollapsed(),this.isInsertionMarker=e.isInsertionMarker(),this.RTL=e.RTL,this.statementEdge=this.width=this.widthWithChildren=this.height=0,this.rows=[],this.inputRows=[],this.hiddenIcons=[],this.topRow=new I.blockRendering.TopRow(this.constants_),this.bottomRow=new I.blockRendering.BottomRow(this.constants_),this.startY=this.startX=0},I.blockRendering.RenderInfo.prototype.getRenderer=function(){return this.renderer_},I.blockRendering.RenderInfo.prototype.measure=function(){this.createRows_(),this.addElemSpacing_(),this.addRowSpacing_(),this.computeBounds_(),this.alignRowElements_(),this.finalize_()},I.blockRendering.RenderInfo.prototype.createRows_=function(){this.populateTopRow_(),this.rows.push(this.topRow);var t=new I.blockRendering.InputRow(this.constants_);this.inputRows.push(t);var e=this.block_.getIcons();if(e.length)for(var o=0,i;i=e[o];o++){var s=new I.blockRendering.Icon(this.constants_,i);(this.isCollapsed&&i.collapseHidden?this.hiddenIcons:t.elements).push(s)}for(i=null,o=0;e=this.block_.inputList[o];o++)if(e.isVisible()){for(this.shouldStartNewRow_(e,i)&&(this.rows.push(t),t=new I.blockRendering.InputRow(this.constants_),this.inputRows.push(t)),i=0;s=e.fieldRow[i];i++)t.elements.push(new I.blockRendering.Field(this.constants_,s,e));this.addInput_(e,t),i=e}this.isCollapsed&&(t.hasJaggedEdge=!0,t.elements.push(new I.blockRendering.JaggedEdge(this.constants_))),(t.elements.length||t.hasDummyInput)&&this.rows.push(t),this.populateBottomRow_(),this.rows.push(this.bottomRow)},I.blockRendering.RenderInfo.prototype.populateTopRow_=function(){var t=!!this.block_.previousConnection,e=(this.block_.hat?"cap"===this.block_.hat:this.constants_.ADD_START_HATS)&&!this.outputConnection&&!t;this.topRow.hasLeftSquareCorner(this.block_)?this.topRow.elements.push(new I.blockRendering.SquareCorner(this.constants_)):this.topRow.elements.push(new I.blockRendering.RoundCorner(this.constants_)),e?(t=new I.blockRendering.Hat(this.constants_),this.topRow.elements.push(t),this.topRow.capline=t.ascenderHeight):t&&(this.topRow.hasPreviousConnection=!0,this.topRow.connection=new I.blockRendering.PreviousConnection(this.constants_,this.block_.previousConnection),this.topRow.elements.push(this.topRow.connection)),this.block_.inputList.length&&this.block_.inputList[0].type==I.inputTypes.STATEMENT&&!this.block_.isCollapsed()?this.topRow.minHeight=this.constants_.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT:this.topRow.minHeight=this.constants_.TOP_ROW_MIN_HEIGHT,this.topRow.hasRightSquareCorner(this.block_)?this.topRow.elements.push(new I.blockRendering.SquareCorner(this.constants_,"right")):this.topRow.elements.push(new I.blockRendering.RoundCorner(this.constants_,"right"))},I.blockRendering.RenderInfo.prototype.populateBottomRow_=function(){this.bottomRow.hasNextConnection=!!this.block_.nextConnection,this.bottomRow.minHeight=this.block_.inputList.length&&this.block_.inputList[this.block_.inputList.length-1].type==I.inputTypes.STATEMENT?this.constants_.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT:this.constants_.BOTTOM_ROW_MIN_HEIGHT,this.bottomRow.hasLeftSquareCorner(this.block_)?this.bottomRow.elements.push(new I.blockRendering.SquareCorner(this.constants_)):this.bottomRow.elements.push(new I.blockRendering.RoundCorner(this.constants_)),this.bottomRow.hasNextConnection&&(this.bottomRow.connection=new I.blockRendering.NextConnection(this.constants_,this.block_.nextConnection),this.bottomRow.elements.push(this.bottomRow.connection)),this.bottomRow.hasRightSquareCorner(this.block_)?this.bottomRow.elements.push(new I.blockRendering.SquareCorner(this.constants_,"right")):this.bottomRow.elements.push(new I.blockRendering.RoundCorner(this.constants_,"right"))},I.blockRendering.RenderInfo.prototype.addInput_=function(t,e){this.isInline&&t.type==I.inputTypes.VALUE?(e.elements.push(new I.blockRendering.InlineInput(this.constants_,t)),e.hasInlineInput=!0):t.type==I.inputTypes.STATEMENT?(e.elements.push(new I.blockRendering.StatementInput(this.constants_,t)),e.hasStatement=!0):t.type==I.inputTypes.VALUE?(e.elements.push(new I.blockRendering.ExternalValueInput(this.constants_,t)),e.hasExternalInput=!0):t.type==I.inputTypes.DUMMY&&(e.minHeight=Math.max(e.minHeight,t.getSourceBlock()&&t.getSourceBlock().isShadow()?this.constants_.DUMMY_INPUT_SHADOW_MIN_HEIGHT:this.constants_.DUMMY_INPUT_MIN_HEIGHT),e.hasDummyInput=!0),null==e.align&&(e.align=t.align)},I.blockRendering.RenderInfo.prototype.shouldStartNewRow_=function(t,e){return!!e&&(t.type==I.inputTypes.STATEMENT||e.type==I.inputTypes.STATEMENT||(t.type==I.inputTypes.VALUE||t.type==I.inputTypes.DUMMY)&&!this.isInline)},I.blockRendering.RenderInfo.prototype.addElemSpacing_=function(){for(var t=0,e;e=this.rows[t];t++){var o=e.elements;if(e.elements=[],e.startsWithElemSpacer()&&e.elements.push(new I.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,o[0]))),o.length){for(var i=0;i<o.length-1;i++){e.elements.push(o[i]);var s=this.getInRowSpacing_(o[i],o[i+1]);e.elements.push(new I.blockRendering.InRowSpacer(this.constants_,s))}e.elements.push(o[o.length-1]),e.endsWithElemSpacer()&&e.elements.push(new I.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(o[o.length-1],null)))}}},I.blockRendering.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t&&e&&I.blockRendering.Types.isStatementInput(e))return this.constants_.STATEMENT_INPUT_PADDING_LEFT;if(t&&I.blockRendering.Types.isInput(t)&&!e){if(I.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(I.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}return t&&I.blockRendering.Types.isLeftSquareCorner(t)&&e&&(I.blockRendering.Types.isPreviousConnection(e)||I.blockRendering.Types.isNextConnection(e))?e.notchOffset:t&&I.blockRendering.Types.isLeftRoundedCorner(t)&&e&&(I.blockRendering.Types.isPreviousConnection(e)||I.blockRendering.Types.isNextConnection(e))?e.notchOffset-this.constants_.CORNER_RADIUS:this.constants_.MEDIUM_PADDING},I.blockRendering.RenderInfo.prototype.computeBounds_=function(){for(var t=0,e=0,o=0,i=0,s,n,t;s=this.rows[i];i++){s.measure(),e=Math.max(e,s.width),s.hasStatement&&(n=s.getLastInput(),t=Math.max(t,s.width-n.width)),o=Math.max(o,s.widthWithConnectedBlocks)}for(this.statementEdge=t,this.width=e,i=0;s=this.rows[i];i++)s.hasStatement&&(s.statementEdge=this.statementEdge);this.widthWithChildren=Math.max(e,o),this.outputConnection&&(this.startX=this.outputConnection.width,this.width+=this.outputConnection.width,this.widthWithChildren+=this.outputConnection.width)},I.blockRendering.RenderInfo.prototype.alignRowElements_=function(){for(var t=0,e,o,o;e=this.rows[t];t++){e.hasStatement?this.alignStatementRow_(e):(o=e.width,0<(o=this.getDesiredRowWidth_(e)-o)&&this.addAlignmentPadding_(e,o),I.blockRendering.Types.isTopOrBottomRow(e)&&(e.widthWithConnectedBlocks=e.width))}},I.blockRendering.RenderInfo.prototype.getDesiredRowWidth_=function(t){return this.width-this.startX},I.blockRendering.RenderInfo.prototype.addAlignmentPadding_=function(t,e){var o=t.getFirstSpacer(),i=t.getLastSpacer();(t.hasExternalInput||t.hasStatement)&&(t.widthWithConnectedBlocks+=e),t.align==I.constants.ALIGN.LEFT?i.width+=e:t.align==I.constants.ALIGN.CENTRE?(o.width+=e/2,i.width+=e/2):t.align==I.constants.ALIGN.RIGHT?o.width+=e:i.width+=e,t.width+=e},I.blockRendering.RenderInfo.prototype.alignStatementRow_=function(t){var e=t.getLastInput(),o=t.width-e.width,i=this.statementEdge,o;0<(o=i-o)&&this.addAlignmentPadding_(t,o),o=t.width,i=this.getDesiredRowWidth_(t),e.width+=i-o,e.height=Math.max(e.height,t.height),t.width+=i-o,t.widthWithConnectedBlocks=Math.max(t.width,this.statementEdge+t.connectedBlockWidths)},I.blockRendering.RenderInfo.prototype.addRowSpacing_=function(){var t=this.rows;this.rows=[];for(var e=0;e<t.length;e++)this.rows.push(t[e]),e!=t.length-1&&this.rows.push(this.makeSpacerRow_(t[e],t[e+1]))},I.blockRendering.RenderInfo.prototype.makeSpacerRow_=function(t,e){var o=this.getSpacerRowHeight_(t,e),i=this.getSpacerRowWidth_(t,e),o=new I.blockRendering.SpacerRow(this.constants_,o,i);return t.hasStatement&&(o.followsStatement=!0),e.hasStatement&&(o.precedesStatement=!0),o},I.blockRendering.RenderInfo.prototype.getSpacerRowWidth_=function(t,e){return this.width-this.startX},I.blockRendering.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return this.constants_.MEDIUM_PADDING},I.blockRendering.RenderInfo.prototype.getElemCenterline_=function(t,e){return I.blockRendering.Types.isSpacer(e)?t.yPos+e.height/2:I.blockRendering.Types.isBottomRow(t)?(t=t.yPos+t.height-t.descenderHeight,I.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2):I.blockRendering.Types.isTopRow(t)?I.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2:t.yPos+t.height/2},I.blockRendering.RenderInfo.prototype.recordElemPositions_=function(t){for(var e=t.xPos,o=0,i;i=t.elements[o];o++)I.blockRendering.Types.isSpacer(i)&&(i.height=t.height),i.xPos=e,i.centerline=this.getElemCenterline_(t,i),e+=i.width},I.blockRendering.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++)i.yPos=e,i.xPos=this.startX,e+=i.height,t=Math.max(t,i.widthWithConnectedBlocks),this.recordElemPositions_(i);this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width)),this.widthWithChildren=t+this.startX,this.height=e,this.startY=this.topRow.capline,this.bottomRow.baseline=e-this.bottomRow.descenderHeight},I.blockRendering.Debug=function(t){this.debugElements_=[],this.svgRoot_=null,this.constants_=t},I.blockRendering.Debug.config={rowSpacers:!0,elemSpacers:!0,rows:!0,elems:!0,connections:!0,blockBounds:!0,connectedBlockBounds:!0,render:!0},I.blockRendering.Debug.prototype.clearElems=function(){for(var t=0,e;e=this.debugElements_[t];t++)I.utils.dom.removeNode(e);this.debugElements_=[]},I.blockRendering.Debug.prototype.drawSpacerRow=function(t,e,o){var i,s;I.blockRendering.Debug.config.rowSpacers&&(i=Math.abs(t.height),(s=t.height<0)&&(e-=i),this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"rowSpacerRect blockRenderDebug",x:o?-(t.xPos+t.width):t.xPos,y:e,width:t.width,height:i,stroke:s?"black":"blue",fill:"blue","fill-opacity":"0.5","stroke-width":"1px"},this.svgRoot_)))},I.blockRendering.Debug.prototype.drawSpacerElem=function(t,e,o){var i,s;I.blockRendering.Debug.config.elemSpacers&&(e=Math.abs(t.width),s=(i=t.width<0)?t.xPos-e:t.xPos,this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"elemSpacerRect blockRenderDebug",x:s=o?-(s+e):s,y:t.centerline-t.height/2,width:e,height:t.height,stroke:"pink",fill:i?"black":"pink","fill-opacity":"0.5","stroke-width":"1px"},this.svgRoot_)))},I.blockRendering.Debug.prototype.drawRenderedElem=function(t,e){var o;I.blockRendering.Debug.config.elems&&(o=t.xPos,e&&(o=-(o+t.width)),e=t.centerline-t.height/2,this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"rowRenderingRect blockRenderDebug",x:o,y:e,width:t.width,height:t.height,stroke:"black",fill:"none","stroke-width":"1px"},this.svgRoot_)),I.blockRendering.Types.isField(t)&&t.field instanceof I.FieldLabel&&this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"rowRenderingRect blockRenderDebug",x:o,y:e+this.constants_.FIELD_TEXT_BASELINE,width:t.width,height:"0.1px",stroke:"red",fill:"none","stroke-width":"0.5px"},this.svgRoot_))),I.blockRendering.Types.isInput(t)&&I.blockRendering.Debug.config.connections&&this.drawConnection(t.connectionModel)},I.blockRendering.Debug.prototype.drawConnection=function(t){var e,o,i;I.blockRendering.Debug.config.connections&&(t.type==I.connectionTypes.INPUT_VALUE?(e=4,o="magenta",i="none"):t.type==I.connectionTypes.OUTPUT_VALUE?(e=2,i=o="magenta"):t.type==I.connectionTypes.NEXT_STATEMENT?(e=4,o="goldenrod",i="none"):t.type==I.connectionTypes.PREVIOUS_STATEMENT&&(e=2,i=o="goldenrod"),this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{class:"blockRenderDebug",cx:t.offsetInBlock_.x,cy:t.offsetInBlock_.y,r:e,fill:i,stroke:o},this.svgRoot_)))},I.blockRendering.Debug.prototype.drawRenderedRow=function(t,e,o){I.blockRendering.Debug.config.rows&&(this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"elemRenderingRect blockRenderDebug",x:o?-(t.xPos+t.width):t.xPos,y:t.yPos,width:t.width,height:t.height,stroke:"red",fill:"none","stroke-width":"1px"},this.svgRoot_)),I.blockRendering.Types.isTopOrBottomRow(t)||I.blockRendering.Debug.config.connectedBlockBounds&&this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"connectedBlockWidth blockRenderDebug",x:o?-(t.xPos+t.widthWithConnectedBlocks):t.xPos,y:t.yPos,width:t.widthWithConnectedBlocks,height:t.height,stroke:this.randomColour_,fill:"none","stroke-width":"1px","stroke-dasharray":"3,3"},this.svgRoot_)))},I.blockRendering.Debug.prototype.drawRowWithElements=function(t,e,o){for(var i=0,s=t.elements.length;i<s;i++){var n=t.elements[i];n?I.blockRendering.Types.isSpacer(n)?this.drawSpacerElem(n,t.height,o):this.drawRenderedElem(n,o):console.warn("A row has an undefined or null element.",t,n)}this.drawRenderedRow(t,e,o)},I.blockRendering.Debug.prototype.drawBoundingBox=function(t){var e;I.blockRendering.Debug.config.blockBounds&&(e=t.RTL?-t.width:0,this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blockBoundingBox blockRenderDebug",x:e,y:0,width:t.width,height:t.height,stroke:"black",fill:"none","stroke-width":"1px","stroke-dasharray":"5,5"},this.svgRoot_)),I.blockRendering.Debug.config.connectedBlockBounds&&(e=t.RTL?-t.widthWithChildren:0,this.debugElements_.push(I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blockRenderDebug",x:e,y:0,width:t.widthWithChildren,height:t.height,stroke:"#DF57BC",fill:"none","stroke-width":"1px","stroke-dasharray":"3,3"},this.svgRoot_))))},I.blockRendering.Debug.prototype.drawDebug=function(t,e){this.clearElems(),this.svgRoot_=t.getSvgRoot(),this.randomColour_="#"+Math.floor(16777215*Math.random()).toString(16);for(var o=0,i=0,s;s=e.rows[i];i++)I.blockRendering.Types.isBetweenRowSpacer(s)?this.drawSpacerRow(s,o,e.RTL):this.drawRowWithElements(s,o,e.RTL),o+=s.height;t.previousConnection&&this.drawConnection(t.previousConnection),t.nextConnection&&this.drawConnection(t.nextConnection),t.outputConnection&&this.drawConnection(t.outputConnection),e.rightSide&&this.drawRenderedElem(e.rightSide,e.RTL),this.drawBoundingBox(e),this.drawRender(t.pathObject.svgPath)},I.blockRendering.Debug.prototype.drawRender=function(t){I.blockRendering.Debug.config.render&&(t.setAttribute("filter","url(#"+this.constants_.debugFilterId+")"),setTimeout(function(){t.setAttribute("filter","")},100))},I.blockRendering.Drawer=function(t,e){this.block_=t,this.info_=e,this.topLeft_=t.getRelativeToSurfaceXY(),this.inlinePath_=this.outlinePath_="",this.constants_=e.getRenderer().getConstants()},I.blockRendering.Drawer.prototype.draw=function(){this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_(),this.block_.pathObject.setPath(this.outlinePath_+"\n"+this.inlinePath_),this.info_.RTL&&this.block_.pathObject.flipRTL(),I.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_()},I.blockRendering.Drawer.prototype.recordSizeOnBlock_=function(){this.block_.height=this.info_.height,this.block_.width=this.info_.widthWithChildren},I.blockRendering.Drawer.prototype.hideHiddenIcons_=function(){for(var t=0,e;e=this.info_.hiddenIcons[t];t++)e.icon.iconGroup_.setAttribute("display","none")},I.blockRendering.Drawer.prototype.drawOutline_=function(){this.drawTop_();for(var t=1;t<this.info_.rows.length-1;t++){var e=this.info_.rows[t];e.hasJaggedEdge?this.drawJaggedEdge_(e):e.hasStatement?this.drawStatementInput_(e):e.hasExternalInput?this.drawValueInput_(e):this.drawRightSideRow_(e)}this.drawBottom_(),this.drawLeft_()},I.blockRendering.Drawer.prototype.drawTop_=function(){var t=this.info_.topRow,e=t.elements;this.positionPreviousConnection_(),this.outlinePath_+=I.utils.svgPaths.moveBy(t.xPos,this.info_.startY);for(var o=0,i;i=e[o];o++)I.blockRendering.Types.isLeftRoundedCorner(i)?this.outlinePath_+=this.constants_.OUTSIDE_CORNERS.topLeft:I.blockRendering.Types.isRightRoundedCorner(i)?this.outlinePath_+=this.constants_.OUTSIDE_CORNERS.topRight:I.blockRendering.Types.isPreviousConnection(i)?this.outlinePath_+=i.shape.pathLeft:I.blockRendering.Types.isHat(i)?this.outlinePath_+=this.constants_.START_HAT.path:I.blockRendering.Types.isSpacer(i)&&(this.outlinePath_+=I.utils.svgPaths.lineOnAxis("h",i.width));this.outlinePath_+=I.utils.svgPaths.lineOnAxis("v",t.height)},I.blockRendering.Drawer.prototype.drawJaggedEdge_=function(t){this.outlinePath_+=this.constants_.JAGGED_TEETH.path+I.utils.svgPaths.lineOnAxis("v",t.height-this.constants_.JAGGED_TEETH.height)},I.blockRendering.Drawer.prototype.drawValueInput_=function(t){var e=t.getLastInput();this.positionExternalValueConnection_(t);var o="function"==typeof e.shape.pathDown?e.shape.pathDown(e.height):e.shape.pathDown;this.outlinePath_+=I.utils.svgPaths.lineOnAxis("H",e.xPos+e.width)+o+I.utils.svgPaths.lineOnAxis("v",t.height-e.connectionHeight)},I.blockRendering.Drawer.prototype.drawStatementInput_=function(t){var e,o=(e=t.getLastInput()).xPos+e.notchOffset+e.shape.width,e=e.shape.pathRight+I.utils.svgPaths.lineOnAxis("h",-(e.notchOffset-this.constants_.INSIDE_CORNERS.width))+this.constants_.INSIDE_CORNERS.pathTop,i=t.height-2*this.constants_.INSIDE_CORNERS.height;this.outlinePath_+=I.utils.svgPaths.lineOnAxis("H",o)+e+I.utils.svgPaths.lineOnAxis("v",i)+this.constants_.INSIDE_CORNERS.pathBottom+I.utils.svgPaths.lineOnAxis("H",t.xPos+t.width),this.positionStatementInputConnection_(t)},I.blockRendering.Drawer.prototype.drawRightSideRow_=function(t){this.outlinePath_+=I.utils.svgPaths.lineOnAxis("V",t.yPos+t.height)},I.blockRendering.Drawer.prototype.drawBottom_=function(){var t=this.info_.bottomRow,e=t.elements;this.positionNextConnection_();for(var o=0,i="",s=e.length-1,n;n=e[s];s--)I.blockRendering.Types.isNextConnection(n)?i+=n.shape.pathRight:I.blockRendering.Types.isLeftSquareCorner(n)?i+=I.utils.svgPaths.lineOnAxis("H",t.xPos):I.blockRendering.Types.isLeftRoundedCorner(n)?i+=this.constants_.OUTSIDE_CORNERS.bottomLeft:I.blockRendering.Types.isRightRoundedCorner(n)?(i+=this.constants_.OUTSIDE_CORNERS.bottomRight,o=this.constants_.OUTSIDE_CORNERS.rightHeight):I.blockRendering.Types.isSpacer(n)&&(i+=I.utils.svgPaths.lineOnAxis("h",-1*n.width));this.outlinePath_+=I.utils.svgPaths.lineOnAxis("V",t.baseline-o),this.outlinePath_+=i},I.blockRendering.Drawer.prototype.drawLeft_=function(){var t=this.info_.outputConnection,e,t;this.positionOutputConnection_(),t&&(e=t.connectionOffsetY+t.height,t="function"==typeof t.shape.pathUp?t.shape.pathUp(t.height):t.shape.pathUp,this.outlinePath_+=I.utils.svgPaths.lineOnAxis("V",e)+t),this.outlinePath_+="z"},I.blockRendering.Drawer.prototype.drawInternals_=function(){for(var t=0,e;e=this.info_.rows[t];t++)for(var o=0,i;i=e.elements[o];o++)I.blockRendering.Types.isInlineInput(i)?this.drawInlineInput_(i):(I.blockRendering.Types.isIcon(i)||I.blockRendering.Types.isField(i))&&this.layoutField_(i)},I.blockRendering.Drawer.prototype.layoutField_=function(t){var e;I.blockRendering.Types.isField(t)?e=t.field.getSvgRoot():I.blockRendering.Types.isIcon(t)&&(e=t.icon.iconGroup_);var o=t.centerline-t.height/2,i=t.xPos,s="";this.info_.RTL&&(i=-(i+t.width),t.flipRtl&&(i+=t.width,s="scale(-1 1)")),I.blockRendering.Types.isIcon(t)?(e.setAttribute("display","block"),e.setAttribute("transform","translate("+i+","+o+")"),t.icon.computeIconLocation()):e.setAttribute("transform","translate("+i+","+o+")"+s),this.info_.isInsertionMarker&&e.setAttribute("display","none")},I.blockRendering.Drawer.prototype.drawInlineInput_=function(t){var e=t.width,o=t.height,i=t.connectionOffsetY,s=t.connectionHeight+i;this.inlinePath_+=I.utils.svgPaths.moveTo(t.xPos+t.connectionWidth,t.centerline-o/2)+I.utils.svgPaths.lineOnAxis("v",i)+t.shape.pathDown+I.utils.svgPaths.lineOnAxis("v",o-s)+I.utils.svgPaths.lineOnAxis("h",e-t.connectionWidth)+I.utils.svgPaths.lineOnAxis("v",-o)+"z",this.positionInlineInputConnection_(t)},I.blockRendering.Drawer.prototype.positionInlineInputConnection_=function(t){var e=t.centerline-t.height/2,o;t.connectionModel&&(o=t.xPos+t.connectionWidth+t.connectionOffsetX,this.info_.RTL&&(o*=-1),t.connectionModel.setOffsetInBlock(o,e+t.connectionOffsetY))},I.blockRendering.Drawer.prototype.positionStatementInputConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.statementEdge+e.notchOffset,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},I.blockRendering.Drawer.prototype.positionExternalValueConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.width,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},I.blockRendering.Drawer.prototype.positionPreviousConnection_=function(){var t=this.info_.topRow,e;t.connection&&(e=t.xPos+t.notchOffset,t.connection.connectionModel.setOffsetInBlock(this.info_.RTL?-e:e,0))},I.blockRendering.Drawer.prototype.positionNextConnection_=function(){var t=this.info_.bottomRow,e,o;t.connection&&(o=(e=t.connection).xPos,e.connectionModel.setOffsetInBlock(this.info_.RTL?-o:o,t.baseline))},I.blockRendering.Drawer.prototype.positionOutputConnection_=function(){var t;this.info_.outputConnection&&(t=this.info_.startX+this.info_.outputConnection.connectionOffsetX,this.block_.outputConnection.setOffsetInBlock(this.info_.RTL?-t:t,this.info_.outputConnection.connectionOffsetY))},I.Events.MarkerMove=function(t,e,o,i){var s=t?t.workspace.id:void 0;i&&i.getType()==I.ASTNode.types.WORKSPACE&&(s=i.getLocation().id),I.Events.MarkerMove.superClass_.constructor.call(this,s),this.blockId=t?t.id:null,this.oldNode=o,this.newNode=i,this.isCursor=e},I.utils.object.inherits(I.Events.MarkerMove,I.Events.UiBase),I.Events.MarkerMove.prototype.type=I.Events.MARKER_MOVE,I.Events.MarkerMove.prototype.toJson=function(){var t=I.Events.MarkerMove.superClass_.toJson.call(this);return t.isCursor=this.isCursor,t.blockId=this.blockId,t.oldNode=this.oldNode,t.newNode=this.newNode,t},I.Events.MarkerMove.prototype.fromJson=function(t){I.Events.MarkerMove.superClass_.fromJson.call(this,t),this.isCursor=t.isCursor,this.blockId=t.blockId,this.oldNode=t.oldNode,this.newNode=t.newNode},I.registry.register(I.registry.Type.EVENT,I.Events.MARKER_MOVE,I.Events.MarkerMove),I.blockRendering.MarkerSvg=function(t,e,o){this.workspace_=t,this.marker_=o,this.parent_=null,this.constants_=e,this.currentMarkerSvg=null,t=this.isCursor()?this.constants_.CURSOR_COLOUR:this.constants_.MARKER_COLOUR,this.colour_=o.colour||t},I.blockRendering.MarkerSvg.CURSOR_CLASS="blocklyCursor",I.blockRendering.MarkerSvg.MARKER_CLASS="blocklyMarker",I.blockRendering.MarkerSvg.HEIGHT_MULTIPLIER=.75,I.blockRendering.MarkerSvg.prototype.getSvgRoot=function(){return this.svgGroup_},I.blockRendering.MarkerSvg.prototype.getMarker=function(){return this.marker_},I.blockRendering.MarkerSvg.prototype.isCursor=function(){return"cursor"==this.marker_.type},I.blockRendering.MarkerSvg.prototype.createDom=function(){var t=this.isCursor()?I.blockRendering.MarkerSvg.CURSOR_CLASS:I.blockRendering.MarkerSvg.MARKER_CLASS;return this.svgGroup_=I.utils.dom.createSvgElement(I.utils.Svg.G,{class:t},null),this.createDomInternal_(),this.svgGroup_},I.blockRendering.MarkerSvg.prototype.setParent_=function(t){this.isCursor()?(this.parent_&&this.parent_.setCursorSvg(null),t.setCursorSvg(this.getSvgRoot())):(this.parent_&&this.parent_.setMarkerSvg(null),t.setMarkerSvg(this.getSvgRoot())),this.parent_=t},I.blockRendering.MarkerSvg.prototype.draw=function(t,e){var o;e?(this.constants_=this.workspace_.getRenderer().getConstants(),o=this.isCursor()?this.constants_.CURSOR_COLOUR:this.constants_.MARKER_COLOUR,this.colour_=this.marker_.colour||o,this.applyColour_(e),this.showAtLocation_(e),this.fireMarkerEvent_(t,e),void 0!==(t=this.currentMarkerSvg.childNodes[0])&&t.beginElement&&t.beginElement()):this.hide()},I.blockRendering.MarkerSvg.prototype.showAtLocation_=function(t){var e=t.getLocation().type;t.getType()==I.ASTNode.types.BLOCK?this.showWithBlock_(t):t.getType()==I.ASTNode.types.OUTPUT?this.showWithOutput_(t):e==I.connectionTypes.INPUT_VALUE?this.showWithInput_(t):e==I.connectionTypes.NEXT_STATEMENT?this.showWithNext_(t):t.getType()==I.ASTNode.types.PREVIOUS?this.showWithPrevious_(t):t.getType()==I.ASTNode.types.FIELD?this.showWithField_(t):t.getType()==I.ASTNode.types.WORKSPACE?this.showWithCoordinates_(t):t.getType()==I.ASTNode.types.STACK&&this.showWithStack_(t)},I.blockRendering.MarkerSvg.prototype.showWithBlockPrevOutput_=function(t){var e=(t=t.getSourceBlock()).width,o=t.height,i=o*I.blockRendering.MarkerSvg.HEIGHT_MULTIPLIER,s=this.constants_.CURSOR_BLOCK_PADDING,n;t.previousConnection?(n=this.constants_.shapeFor(t.previousConnection),this.positionPrevious_(e,s,i,n)):t.outputConnection?(n=this.constants_.shapeFor(t.outputConnection),this.positionOutput_(e,o,n)):this.positionBlock_(e,s,i),this.setParent_(t),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showWithBlock_=function(t){this.showWithBlockPrevOutput_(t)},I.blockRendering.MarkerSvg.prototype.showWithPrevious_=function(t){this.showWithBlockPrevOutput_(t)},I.blockRendering.MarkerSvg.prototype.showWithOutput_=function(t){this.showWithBlockPrevOutput_(t)},I.blockRendering.MarkerSvg.prototype.showWithCoordinates_=function(t){var e=t.getWsCoordinate();t=e.x,e=e.y,this.workspace_.RTL&&(t-=this.constants_.CURSOR_WS_WIDTH),this.positionLine_(t,e,this.constants_.CURSOR_WS_WIDTH),this.setParent_(this.workspace_),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showWithField_=function(t){var e=(t=t.getLocation()).getSize().width,o=t.getSize().height;this.positionRect_(0,0,e,o),this.setParent_(t),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showWithInput_=function(t){var e=(t=t.getLocation()).getSourceBlock();this.positionInput_(t),this.setParent_(e),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showWithNext_=function(t){var e;t=(e=t.getLocation()).getSourceBlock();var o=0,e=e.getOffsetInBlock().y,i=t.getHeightWidth().width;this.workspace_.RTL&&(o=-i),this.positionLine_(o,e,i),this.setParent_(t),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showWithStack_=function(t){var e,o=(e=(t=t.getLocation()).getHeightWidth()).width+this.constants_.CURSOR_STACK_PADDING,e=e.height+this.constants_.CURSOR_STACK_PADDING,i=-this.constants_.CURSOR_STACK_PADDING/2,s=-this.constants_.CURSOR_STACK_PADDING/2,n=i;this.workspace_.RTL&&(n=-(o+i)),this.positionRect_(n,s,o,e),this.setParent_(t),this.showCurrent_()},I.blockRendering.MarkerSvg.prototype.showCurrent_=function(){this.hide(),this.currentMarkerSvg.style.display=""},I.blockRendering.MarkerSvg.prototype.positionBlock_=function(t,e,o){t=I.utils.svgPaths.moveBy(-e,o)+I.utils.svgPaths.lineOnAxis("V",-e)+I.utils.svgPaths.lineOnAxis("H",t+2*e)+I.utils.svgPaths.lineOnAxis("V",o),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},I.blockRendering.MarkerSvg.prototype.positionInput_=function(t){var e=t.getOffsetInBlock().x,o=t.getOffsetInBlock().y;t=I.utils.svgPaths.moveTo(0,0)+this.constants_.shapeFor(t).pathDown,this.markerInput_.setAttribute("d",t),this.markerInput_.setAttribute("transform","translate("+e+","+o+")"+(this.workspace_.RTL?" scale(-1 1)":"")),this.currentMarkerSvg=this.markerInput_},I.blockRendering.MarkerSvg.prototype.positionLine_=function(t,e,o){this.markerSvgLine_.setAttribute("x",t),this.markerSvgLine_.setAttribute("y",e),this.markerSvgLine_.setAttribute("width",o),this.currentMarkerSvg=this.markerSvgLine_},I.blockRendering.MarkerSvg.prototype.positionOutput_=function(t,e,o){t=I.utils.svgPaths.moveBy(t,0)+I.utils.svgPaths.lineOnAxis("h",-(t-o.width))+I.utils.svgPaths.lineOnAxis("v",this.constants_.TAB_OFFSET_FROM_TOP)+o.pathDown+I.utils.svgPaths.lineOnAxis("V",e)+I.utils.svgPaths.lineOnAxis("H",t),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},I.blockRendering.MarkerSvg.prototype.positionPrevious_=function(t,e,o,i){t=I.utils.svgPaths.moveBy(-e,o)+I.utils.svgPaths.lineOnAxis("V",-e)+I.utils.svgPaths.lineOnAxis("H",this.constants_.NOTCH_OFFSET_LEFT)+i.pathLeft+I.utils.svgPaths.lineOnAxis("H",t+2*e)+I.utils.svgPaths.lineOnAxis("V",o),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},I.blockRendering.MarkerSvg.prototype.positionRect_=function(t,e,o,i){this.markerSvgRect_.setAttribute("x",t),this.markerSvgRect_.setAttribute("y",e),this.markerSvgRect_.setAttribute("width",o),this.markerSvgRect_.setAttribute("height",i),this.currentMarkerSvg=this.markerSvgRect_},I.blockRendering.MarkerSvg.prototype.flipRtl_=function(t){t.setAttribute("transform","scale(-1 1)")},I.blockRendering.MarkerSvg.prototype.hide=function(){this.markerSvgLine_.style.display="none",this.markerSvgRect_.style.display="none",this.markerInput_.style.display="none",this.markerBlock_.style.display="none"},I.blockRendering.MarkerSvg.prototype.fireMarkerEvent_=function(t,e){var o=e.getSourceBlock();t=new(I.Events.get(I.Events.MARKER_MOVE))(o,this.isCursor(),t,e),I.Events.fire(t)},I.blockRendering.MarkerSvg.prototype.getBlinkProperties_=function(){return{attributeType:"XML",attributeName:"fill",dur:"1s",values:this.colour_+";transparent;transparent;",repeatCount:"indefinite"}},I.blockRendering.MarkerSvg.prototype.createDomInternal_=function(){var t;return this.markerSvg_=I.utils.dom.createSvgElement(I.utils.Svg.G,{width:this.constants_.CURSOR_WS_WIDTH,height:this.constants_.WS_CURSOR_HEIGHT},this.svgGroup_),this.markerSvgLine_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{width:this.constants_.CURSOR_WS_WIDTH,height:this.constants_.WS_CURSOR_HEIGHT,style:"display: none"},this.markerSvg_),this.markerSvgRect_=I.utils.dom.createSvgElement(I.utils.Svg.RECT,{class:"blocklyVerticalMarker",rx:10,ry:10,style:"display: none"},this.markerSvg_),this.markerInput_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{transform:"",style:"display: none"},this.markerSvg_),this.markerBlock_=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{transform:"",style:"display: none",fill:"none","stroke-width":this.constants_.CURSOR_STROKE_WIDTH},this.markerSvg_),this.isCursor()&&(t=this.getBlinkProperties_(),I.utils.dom.createSvgElement(I.utils.Svg.ANIMATE,t,this.markerSvgLine_),I.utils.dom.createSvgElement(I.utils.Svg.ANIMATE,t,this.markerInput_),t.attributeName="stroke",I.utils.dom.createSvgElement(I.utils.Svg.ANIMATE,t,this.markerBlock_)),this.markerSvg_},I.blockRendering.MarkerSvg.prototype.applyColour_=function(t){this.markerSvgLine_.setAttribute("fill",this.colour_),this.markerSvgRect_.setAttribute("stroke",this.colour_),this.markerInput_.setAttribute("fill",this.colour_),this.markerBlock_.setAttribute("stroke",this.colour_),this.isCursor()&&(t=this.colour_+";transparent;transparent;",this.markerSvgLine_.firstChild.setAttribute("values",t),this.markerInput_.firstChild.setAttribute("values",t),this.markerBlock_.firstChild.setAttribute("values",t))},I.blockRendering.MarkerSvg.prototype.dispose=function(){this.svgGroup_&&I.utils.dom.removeNode(this.svgGroup_)},I.blockRendering.PathObject=function(t,e,o){this.constants=o,this.svgRoot=t,this.svgPath=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyPath"},this.svgRoot),this.style=e,this.markerSvg=this.cursorSvg=null},I.blockRendering.PathObject.prototype.setPath=function(t){this.svgPath.setAttribute("d",t)},I.blockRendering.PathObject.prototype.flipRTL=function(){this.svgPath.setAttribute("transform","scale(-1 1)")},I.blockRendering.PathObject.prototype.setCursorSvg=function(t){t?(this.svgRoot.appendChild(t),this.cursorSvg=t):this.cursorSvg=null},I.blockRendering.PathObject.prototype.setMarkerSvg=function(t){t?(this.cursorSvg?this.svgRoot.insertBefore(t,this.cursorSvg):this.svgRoot.appendChild(t),this.markerSvg=t):this.markerSvg=null},I.blockRendering.PathObject.prototype.applyColour=function(t){this.svgPath.setAttribute("stroke",this.style.colourTertiary),this.svgPath.setAttribute("fill",this.style.colourPrimary),this.updateShadow_(t.isShadow()),this.updateDisabled_(!t.isEnabled()||t.getInheritedDisabled())},I.blockRendering.PathObject.prototype.setStyle=function(t){this.style=t},I.blockRendering.PathObject.prototype.setClass_=function(t,e){e?I.utils.dom.addClass(this.svgRoot,t):I.utils.dom.removeClass(this.svgRoot,t)},I.blockRendering.PathObject.prototype.updateHighlighted=function(t){t?this.svgPath.setAttribute("filter","url(#"+this.constants.embossFilterId+")"):this.svgPath.setAttribute("filter","none")},I.blockRendering.PathObject.prototype.updateShadow_=function(t){t&&(this.svgPath.setAttribute("stroke","none"),this.svgPath.setAttribute("fill",this.style.colourSecondary))},I.blockRendering.PathObject.prototype.updateDisabled_=function(t){this.setClass_("blocklyDisabled",t),t&&this.svgPath.setAttribute("fill","url(#"+this.constants.disabledPatternId+")")},I.blockRendering.PathObject.prototype.updateSelected=function(t){this.setClass_("blocklySelected",t)},I.blockRendering.PathObject.prototype.updateDraggingDelete=function(t){this.setClass_("blocklyDraggingDelete",t)},I.blockRendering.PathObject.prototype.updateInsertionMarker=function(t){this.setClass_("blocklyInsertionMarker",t)},I.blockRendering.PathObject.prototype.updateMovable=function(t){this.setClass_("blocklyDraggable",t)},I.blockRendering.PathObject.prototype.updateReplacementFade=function(t){this.setClass_("blocklyReplaceable",t)},I.blockRendering.PathObject.prototype.updateShapeForInputHighlight=function(t,e){},I.IRegistrable=function(){},I.blockRendering.Renderer=function(t){this.name=t,this.overrides=this.constants_=null},I.blockRendering.Renderer.prototype.getClassName=function(){return this.name+"-renderer"},I.blockRendering.Renderer.prototype.init=function(t,e){this.constants_=this.makeConstants_(),e&&(this.overrides=e,I.utils.object.mixin(this.constants_,e)),this.constants_.setTheme(t),this.constants_.init()},I.blockRendering.Renderer.prototype.createDom=function(t,e){this.constants_.createDom(t,this.name+"-"+e.name,"."+this.getClassName()+"."+e.getClassName())},I.blockRendering.Renderer.prototype.refreshDom=function(t,e){var o=this.getConstants();o.dispose(),this.constants_=this.makeConstants_(),this.overrides&&I.utils.object.mixin(this.constants_,this.overrides),this.constants_.randomIdentifier=o.randomIdentifier,this.constants_.setTheme(e),this.constants_.init(),this.createDom(t,e)},I.blockRendering.Renderer.prototype.dispose=function(){this.constants_&&this.constants_.dispose()},I.blockRendering.Renderer.prototype.makeConstants_=function(){return new I.blockRendering.ConstantProvider},I.blockRendering.Renderer.prototype.makeRenderInfo_=function(t){return new I.blockRendering.RenderInfo(this,t)},I.blockRendering.Renderer.prototype.makeDrawer_=function(t,e){return new I.blockRendering.Drawer(t,e)},I.blockRendering.Renderer.prototype.makeDebugger_=function(){if(!I.blockRendering.Debug)throw Error("Missing require for Blockly.blockRendering.Debug");return new I.blockRendering.Debug(this.getConstants())},I.blockRendering.Renderer.prototype.makeMarkerDrawer=function(t,e){return new I.blockRendering.MarkerSvg(t,this.getConstants(),e)},I.blockRendering.Renderer.prototype.makePathObject=function(t,e){return new I.blockRendering.PathObject(t,e,this.constants_)},I.blockRendering.Renderer.prototype.getConstants=function(){return this.constants_},I.blockRendering.Renderer.prototype.shouldHighlightConnection=function(t){return!0},I.blockRendering.Renderer.prototype.orphanCanConnectAtEnd=function(t,e,o){return!!(t=o==I.connectionTypes.OUTPUT_VALUE?(o=e.outputConnection,I.Connection.lastConnectionInRow(t,e)):(o=e.previousConnection,t.lastConnectionInStack()))&&o.getConnectionChecker().canConnect(t,o,!1)},I.blockRendering.Renderer.prototype.getConnectionPreviewMethod=function(t,e,o){return e.type!=I.connectionTypes.OUTPUT_VALUE&&e.type!=I.connectionTypes.PREVIOUS_STATEMENT||!t.isConnected()||this.orphanCanConnectAtEnd(o,t.targetBlock(),e.type)?I.InsertionMarkerManager.PREVIEW_TYPE.INSERTION_MARKER:I.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE},I.blockRendering.Renderer.prototype.render=function(t){I.blockRendering.useDebugger&&!t.renderingDebugger&&(t.renderingDebugger=this.makeDebugger_());var e=this.makeRenderInfo_(t);e.measure(),this.makeDrawer_(t,e).draw()},I.geras={},I.geras.ConstantProvider=function(){I.geras.ConstantProvider.superClass_.constructor.call(this),this.FIELD_TEXT_BASELINE_CENTER=!1,this.DARK_PATH_OFFSET=1,this.MAX_BOTTOM_WIDTH=30,this.STATEMENT_BOTTOM_SPACER=-this.NOTCH_HEIGHT/2},I.utils.object.inherits(I.geras.ConstantProvider,I.blockRendering.ConstantProvider),I.geras.ConstantProvider.prototype.getCSS_=function(t){return I.geras.ConstantProvider.superClass_.getCSS_.call(this,t).concat([t+" .blocklyInsertionMarker>.blocklyPathLight,",t+" .blocklyInsertionMarker>.blocklyPathDark {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"])},I.geras.Highlighter=function(t){this.info_=t,this.inlineSteps_=this.steps_="",this.RTL_=this.info_.RTL,t=t.getRenderer(),this.constants_=t.getConstants(),this.highlightConstants_=t.getHighlightConstants(),this.highlightOffset_=this.highlightConstants_.OFFSET,this.outsideCornerPaths_=this.highlightConstants_.OUTSIDE_CORNER,this.insideCornerPaths_=this.highlightConstants_.INSIDE_CORNER,this.puzzleTabPaths_=this.highlightConstants_.PUZZLE_TAB,this.notchPaths_=this.highlightConstants_.NOTCH,this.startPaths_=this.highlightConstants_.START_HAT,this.jaggedTeethPaths_=this.highlightConstants_.JAGGED_TEETH},I.geras.Highlighter.prototype.getPath=function(){return this.steps_+"\n"+this.inlineSteps_},I.geras.Highlighter.prototype.drawTopCorner=function(t){this.steps_+=I.utils.svgPaths.moveBy(t.xPos,this.info_.startY);for(var e=0,o;o=t.elements[e];e++)I.blockRendering.Types.isLeftSquareCorner(o)?this.steps_+=this.highlightConstants_.START_POINT:I.blockRendering.Types.isLeftRoundedCorner(o)?this.steps_+=this.outsideCornerPaths_.topLeft(this.RTL_):I.blockRendering.Types.isPreviousConnection(o)?this.steps_+=this.notchPaths_.pathLeft:I.blockRendering.Types.isHat(o)?this.steps_+=this.startPaths_.path(this.RTL_):I.blockRendering.Types.isSpacer(o)&&0!=o.width&&(this.steps_+=I.utils.svgPaths.lineOnAxis("H",o.xPos+o.width-this.highlightOffset_));this.steps_+=I.utils.svgPaths.lineOnAxis("H",t.xPos+t.width-this.highlightOffset_)},I.geras.Highlighter.prototype.drawJaggedEdge_=function(t){this.info_.RTL&&(this.steps_+=this.jaggedTeethPaths_.pathLeft+I.utils.svgPaths.lineOnAxis("v",t.height-this.jaggedTeethPaths_.height-this.highlightOffset_))},I.geras.Highlighter.prototype.drawValueInput=function(t){var e=t.getLastInput(),o;this.RTL_?(o=t.height-e.connectionHeight,this.steps_+=I.utils.svgPaths.moveTo(e.xPos+e.width-this.highlightOffset_,t.yPos)+this.puzzleTabPaths_.pathDown(this.RTL_)+I.utils.svgPaths.lineOnAxis("v",o)):this.steps_+=I.utils.svgPaths.moveTo(e.xPos+e.width,t.yPos)+this.puzzleTabPaths_.pathDown(this.RTL_)},I.geras.Highlighter.prototype.drawStatementInput=function(t){var e=t.getLastInput(),o;this.RTL_?(o=t.height-2*this.insideCornerPaths_.height,this.steps_+=I.utils.svgPaths.moveTo(e.xPos,t.yPos)+this.insideCornerPaths_.pathTop(this.RTL_)+I.utils.svgPaths.lineOnAxis("v",o)+this.insideCornerPaths_.pathBottom(this.RTL_)+I.utils.svgPaths.lineTo(t.width-e.xPos-this.insideCornerPaths_.width,0)):this.steps_+=I.utils.svgPaths.moveTo(e.xPos,t.yPos+t.height)+this.insideCornerPaths_.pathBottom(this.RTL_)+I.utils.svgPaths.lineTo(t.width-e.xPos-this.insideCornerPaths_.width,0)},I.geras.Highlighter.prototype.drawRightSideRow=function(t){var e=t.xPos+t.width-this.highlightOffset_;t.followsStatement&&(this.steps_+=I.utils.svgPaths.lineOnAxis("H",e)),this.RTL_&&(this.steps_+=I.utils.svgPaths.lineOnAxis("H",e),t.height>this.highlightOffset_&&(this.steps_+=I.utils.svgPaths.lineOnAxis("V",t.yPos+t.height-this.highlightOffset_)))},I.geras.Highlighter.prototype.drawBottomRow=function(t){var e;this.RTL_?this.steps_+=I.utils.svgPaths.lineOnAxis("V",t.baseline-this.highlightOffset_):(e=this.info_.bottomRow.elements[0],I.blockRendering.Types.isLeftSquareCorner(e)?this.steps_+=I.utils.svgPaths.moveTo(t.xPos+this.highlightOffset_,t.baseline-this.highlightOffset_):I.blockRendering.Types.isLeftRoundedCorner(e)&&(this.steps_+=I.utils.svgPaths.moveTo(t.xPos,t.baseline),this.steps_+=this.outsideCornerPaths_.bottomLeft()))},I.geras.Highlighter.prototype.drawLeft=function(){var t=this.info_.outputConnection;t&&(t=t.connectionOffsetY+t.height,this.RTL_?this.steps_+=I.utils.svgPaths.moveTo(this.info_.startX,t):(this.steps_+=I.utils.svgPaths.moveTo(this.info_.startX+this.highlightOffset_,this.info_.bottomRow.baseline-this.highlightOffset_),this.steps_+=I.utils.svgPaths.lineOnAxis("V",t)),this.steps_+=this.puzzleTabPaths_.pathUp(this.RTL_)),this.RTL_||(t=this.info_.topRow,I.blockRendering.Types.isLeftRoundedCorner(t.elements[0])?this.steps_+=I.utils.svgPaths.lineOnAxis("V",this.outsideCornerPaths_.height):this.steps_+=I.utils.svgPaths.lineOnAxis("V",t.capline+this.highlightOffset_))},I.geras.Highlighter.prototype.drawInlineInput=function(t){var e=this.highlightOffset_,o=t.xPos+t.connectionWidth,i=t.centerline-t.height/2,s=t.width-t.connectionWidth,n=i+e;this.RTL_?(i=t.connectionOffsetY-e,t=t.height-(t.connectionOffsetY+t.connectionHeight)+e,this.inlineSteps_+=I.utils.svgPaths.moveTo(o-e,n)+I.utils.svgPaths.lineOnAxis("v",i)+this.puzzleTabPaths_.pathDown(this.RTL_)+I.utils.svgPaths.lineOnAxis("v",t)+I.utils.svgPaths.lineOnAxis("h",s)):this.inlineSteps_+=I.utils.svgPaths.moveTo(t.xPos+t.width+e,n)+I.utils.svgPaths.lineOnAxis("v",t.height)+I.utils.svgPaths.lineOnAxis("h",-s)+I.utils.svgPaths.moveTo(o,i+t.connectionOffsetY)+this.puzzleTabPaths_.pathDown(this.RTL_)},I.geras.InlineInput=function(t,e){I.geras.InlineInput.superClass_.constructor.call(this,t,e),this.connectedBlock&&(this.width+=this.constants_.DARK_PATH_OFFSET,this.height+=this.constants_.DARK_PATH_OFFSET)},I.utils.object.inherits(I.geras.InlineInput,I.blockRendering.InlineInput),I.geras.StatementInput=function(t,e){I.geras.StatementInput.superClass_.constructor.call(this,t,e),this.connectedBlock&&(this.height+=this.constants_.DARK_PATH_OFFSET)},I.utils.object.inherits(I.geras.StatementInput,I.blockRendering.StatementInput),I.geras.RenderInfo=function(t,e){I.geras.RenderInfo.superClass_.constructor.call(this,t,e)},I.utils.object.inherits(I.geras.RenderInfo,I.blockRendering.RenderInfo),I.geras.RenderInfo.prototype.getRenderer=function(){return this.renderer_},I.geras.RenderInfo.prototype.populateBottomRow_=function(){I.geras.RenderInfo.superClass_.populateBottomRow_.call(this),this.block_.inputList.length&&this.block_.inputList[this.block_.inputList.length-1].type==I.inputTypes.STATEMENT||(this.bottomRow.minHeight=this.constants_.MEDIUM_PADDING-this.constants_.DARK_PATH_OFFSET)},I.geras.RenderInfo.prototype.addInput_=function(t,e){this.isInline&&t.type==I.inputTypes.VALUE?(e.elements.push(new I.geras.InlineInput(this.constants_,t)),e.hasInlineInput=!0):t.type==I.inputTypes.STATEMENT?(e.elements.push(new I.geras.StatementInput(this.constants_,t)),e.hasStatement=!0):t.type==I.inputTypes.VALUE?(e.elements.push(new I.blockRendering.ExternalValueInput(this.constants_,t)),e.hasExternalInput=!0):t.type==I.inputTypes.DUMMY&&(e.minHeight=Math.max(e.minHeight,this.constants_.DUMMY_INPUT_MIN_HEIGHT),e.hasDummyInput=!0),this.isInline||null!=e.align||(e.align=t.align)},I.geras.RenderInfo.prototype.addElemSpacing_=function(){for(var t=!1,e=0,o;o=this.rows[e];e++)o.hasExternalInput&&(t=!0);for(e=0;o=this.rows[e];e++){var i=o.elements;if(o.elements=[],o.startsWithElemSpacer()&&o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,i[0]))),i.length){for(var s=0;s<i.length-1;s++){o.elements.push(i[s]);var n=this.getInRowSpacing_(i[s],i[s+1]);o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,n))}o.elements.push(i[i.length-1]),o.endsWithElemSpacer()&&(n=this.getInRowSpacing_(i[i.length-1],null),t&&o.hasDummyInput&&(n+=this.constants_.TAB_WIDTH),o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,n)))}}},I.geras.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t)return e&&I.blockRendering.Types.isField(e)&&e.isEditable?this.constants_.MEDIUM_PADDING:e&&I.blockRendering.Types.isInlineInput(e)?this.constants_.MEDIUM_LARGE_PADDING:e&&I.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:this.constants_.LARGE_PADDING;if(!I.blockRendering.Types.isInput(t)&&(!e||I.blockRendering.Types.isStatementInput(e)))return I.blockRendering.Types.isField(t)&&t.isEditable?this.constants_.MEDIUM_PADDING:I.blockRendering.Types.isIcon(t)?2*this.constants_.LARGE_PADDING+1:I.blockRendering.Types.isHat(t)?this.constants_.NO_PADDING:I.blockRendering.Types.isPreviousOrNextConnection(t)?this.constants_.LARGE_PADDING:I.blockRendering.Types.isLeftRoundedCorner(t)?this.constants_.MIN_BLOCK_WIDTH:I.blockRendering.Types.isJaggedEdge(t)?this.constants_.NO_PADDING:this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isInput(t)&&!e){if(I.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(I.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}if(!I.blockRendering.Types.isInput(t)&&e&&I.blockRendering.Types.isInput(e)){if(I.blockRendering.Types.isField(t)&&t.isEditable){if(I.blockRendering.Types.isInlineInput(e)||I.blockRendering.Types.isExternalInput(e))return this.constants_.SMALL_PADDING}else{if(I.blockRendering.Types.isInlineInput(e)||I.blockRendering.Types.isExternalInput(e))return this.constants_.MEDIUM_LARGE_PADDING;if(I.blockRendering.Types.isStatementInput(e))return this.constants_.LARGE_PADDING}return this.constants_.LARGE_PADDING-1}if(I.blockRendering.Types.isIcon(t)&&e&&!I.blockRendering.Types.isInput(e))return this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isInlineInput(t)&&e&&I.blockRendering.Types.isField(e))return e.isEditable?this.constants_.MEDIUM_PADDING:this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isLeftSquareCorner(t)&&e){if(I.blockRendering.Types.isHat(e))return this.constants_.NO_PADDING;if(I.blockRendering.Types.isPreviousConnection(e))return e.notchOffset;if(I.blockRendering.Types.isNextConnection(e))return t=(this.RTL?1:-1)*this.constants_.DARK_PATH_OFFSET/2,e.notchOffset+t}if(I.blockRendering.Types.isLeftRoundedCorner(t)&&e){if(I.blockRendering.Types.isPreviousConnection(e))return e.notchOffset-this.constants_.CORNER_RADIUS;if(I.blockRendering.Types.isNextConnection(e))return t=(this.RTL?1:-1)*this.constants_.DARK_PATH_OFFSET/2,e.notchOffset-this.constants_.CORNER_RADIUS+t}return I.blockRendering.Types.isField(t)&&e&&I.blockRendering.Types.isField(e)&&t.isEditable==e.isEditable||e&&I.blockRendering.Types.isJaggedEdge(e)?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},I.geras.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return I.blockRendering.Types.isTopRow(t)&&I.blockRendering.Types.isBottomRow(e)?this.constants_.EMPTY_BLOCK_SPACER_HEIGHT:I.blockRendering.Types.isTopRow(t)||I.blockRendering.Types.isBottomRow(e)?this.constants_.NO_PADDING:t.hasExternalInput&&e.hasExternalInput?this.constants_.LARGE_PADDING:!t.hasStatement&&e.hasStatement?this.constants_.BETWEEN_STATEMENT_PADDING_Y:t.hasStatement&&e.hasStatement||!t.hasStatement&&e.hasDummyInput||t.hasDummyInput?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},I.geras.RenderInfo.prototype.getElemCenterline_=function(t,e){if(I.blockRendering.Types.isSpacer(e))return t.yPos+e.height/2;if(I.blockRendering.Types.isBottomRow(t))return t=t.yPos+t.height-t.descenderHeight,I.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2;if(I.blockRendering.Types.isTopRow(t))return I.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2;var o=t.yPos;return I.blockRendering.Types.isField(e)||I.blockRendering.Types.isIcon(e)?(o+=e.height/2,(t.hasInlineInput||t.hasStatement)&&e.height+this.constants_.TALL_INPUT_FIELD_OFFSET_Y<=t.height&&(o+=this.constants_.TALL_INPUT_FIELD_OFFSET_Y)):o=I.blockRendering.Types.isInlineInput(e)?o+e.height/2:o+t.height/2,o},I.geras.RenderInfo.prototype.alignRowElements_=function(){if(this.isInline){for(var t=0,e=null,o=this.rows.length-1,i;i=this.rows[o];o--)i.nextRightEdge=t,I.blockRendering.Types.isInputRow(i)&&(i.hasStatement&&this.alignStatementRow_(i),e&&e.hasStatement&&i.width<e.width?i.nextRightEdge=e.width:t=i.width,e=i);for(o=t=0;i=this.rows[o];o++)i.hasStatement?t=this.getDesiredRowWidth_(i):I.blockRendering.Types.isSpacer(i)?i.width=Math.max(t,i.nextRightEdge):(0<(t=Math.max(t,i.nextRightEdge)-i.width)&&this.addAlignmentPadding_(i,t),t=i.width)}else I.geras.RenderInfo.superClass_.alignRowElements_.call(this)},I.geras.RenderInfo.prototype.getDesiredRowWidth_=function(t){return this.isInline&&t.hasStatement?this.statementEdge+this.constants_.MAX_BOTTOM_WIDTH+this.startX:I.geras.RenderInfo.superClass_.getDesiredRowWidth_.call(this,t)},I.geras.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++){i.yPos=e,i.xPos=this.startX,e+=i.height;var t=Math.max(t,i.widthWithConnectedBlocks),s=e-this.topRow.ascenderHeight;i==this.bottomRow&&s<this.constants_.MIN_BLOCK_HEIGHT&&(s=this.constants_.MIN_BLOCK_HEIGHT-s,this.bottomRow.height+=s,e+=s),this.recordElemPositions_(i)}this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width-this.constants_.DARK_PATH_OFFSET)),this.bottomRow.baseline=e-this.bottomRow.descenderHeight,this.widthWithChildren=t+this.startX+this.constants_.DARK_PATH_OFFSET,this.width+=this.constants_.DARK_PATH_OFFSET,this.height=e+this.constants_.DARK_PATH_OFFSET,this.startY=this.topRow.capline},I.geras.Drawer=function(t,e){I.geras.Drawer.superClass_.constructor.call(this,t,e),this.highlighter_=new I.geras.Highlighter(e)},I.utils.object.inherits(I.geras.Drawer,I.blockRendering.Drawer),I.geras.Drawer.prototype.draw=function(){this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_();var t=this.block_.pathObject;t.setPath(this.outlinePath_+"\n"+this.inlinePath_),t.setHighlightPath(this.highlighter_.getPath()),this.info_.RTL&&t.flipRTL(),I.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_()},I.geras.Drawer.prototype.drawTop_=function(){this.highlighter_.drawTopCorner(this.info_.topRow),this.highlighter_.drawRightSideRow(this.info_.topRow),I.geras.Drawer.superClass_.drawTop_.call(this)},I.geras.Drawer.prototype.drawJaggedEdge_=function(t){this.highlighter_.drawJaggedEdge_(t),I.geras.Drawer.superClass_.drawJaggedEdge_.call(this,t)},I.geras.Drawer.prototype.drawValueInput_=function(t){this.highlighter_.drawValueInput(t),I.geras.Drawer.superClass_.drawValueInput_.call(this,t)},I.geras.Drawer.prototype.drawStatementInput_=function(t){this.highlighter_.drawStatementInput(t),I.geras.Drawer.superClass_.drawStatementInput_.call(this,t)},I.geras.Drawer.prototype.drawRightSideRow_=function(t){this.highlighter_.drawRightSideRow(t),this.outlinePath_+=I.utils.svgPaths.lineOnAxis("H",t.xPos+t.width)+I.utils.svgPaths.lineOnAxis("V",t.yPos+t.height)},I.geras.Drawer.prototype.drawBottom_=function(){this.highlighter_.drawBottomRow(this.info_.bottomRow),I.geras.Drawer.superClass_.drawBottom_.call(this)},I.geras.Drawer.prototype.drawLeft_=function(){this.highlighter_.drawLeft(),I.geras.Drawer.superClass_.drawLeft_.call(this)},I.geras.Drawer.prototype.drawInlineInput_=function(t){this.highlighter_.drawInlineInput(t),I.geras.Drawer.superClass_.drawInlineInput_.call(this,t)},I.geras.Drawer.prototype.positionInlineInputConnection_=function(t){var e=t.centerline-t.height/2,o;t.connectionModel&&(o=t.xPos+t.connectionWidth+this.constants_.DARK_PATH_OFFSET,this.info_.RTL&&(o*=-1),t.connectionModel.setOffsetInBlock(o,e+t.connectionOffsetY+this.constants_.DARK_PATH_OFFSET))},I.geras.Drawer.prototype.positionStatementInputConnection_=function(t){var e=t.getLastInput(),o,o;e.connectionModel&&(o=t.xPos+t.statementEdge+e.notchOffset,o=this.info_.RTL?-1*o:o+this.constants_.DARK_PATH_OFFSET,e.connectionModel.setOffsetInBlock(o,t.yPos+this.constants_.DARK_PATH_OFFSET))},I.geras.Drawer.prototype.positionExternalValueConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.width+this.constants_.DARK_PATH_OFFSET,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},I.geras.Drawer.prototype.positionNextConnection_=function(){var t=this.info_.bottomRow,e,o;t.connection&&(o=(e=t.connection).xPos,e.connectionModel.setOffsetInBlock((this.info_.RTL?-o:o)+this.constants_.DARK_PATH_OFFSET/2,t.baseline+this.constants_.DARK_PATH_OFFSET))},I.geras.HighlightConstantProvider=function(t){this.constantProvider=t,this.OFFSET=.5,this.START_POINT=I.utils.svgPaths.moveBy(this.OFFSET,this.OFFSET)},I.geras.HighlightConstantProvider.prototype.init=function(){this.INSIDE_CORNER=this.makeInsideCorner(),this.OUTSIDE_CORNER=this.makeOutsideCorner(),this.PUZZLE_TAB=this.makePuzzleTab(),this.NOTCH=this.makeNotch(),this.JAGGED_TEETH=this.makeJaggedTeeth(),this.START_HAT=this.makeStartHat()},I.geras.HighlightConstantProvider.prototype.makeInsideCorner=function(){var t=this.constantProvider.CORNER_RADIUS,e=this.OFFSET,o=(1-Math.SQRT1_2)*(t+e)-e,i=I.utils.svgPaths.moveBy(o,o)+I.utils.svgPaths.arc("a","0 0,0",t,I.utils.svgPaths.point(-o-e,t-o)),s=I.utils.svgPaths.arc("a","0 0,0",t+e,I.utils.svgPaths.point(t+e,t+e)),n=I.utils.svgPaths.moveBy(o,-o)+I.utils.svgPaths.arc("a","0 0,0",t+e,I.utils.svgPaths.point(t-o,o+e));return{width:t+e,height:t,pathTop:function(t){return t?i:""},pathBottom:function(t){return t?s:n}}},I.geras.HighlightConstantProvider.prototype.makeOutsideCorner=function(){var t=this.constantProvider.CORNER_RADIUS,e=this.OFFSET,o=(1-Math.SQRT1_2)*(t-e)+e,i=I.utils.svgPaths.moveBy(o,o)+I.utils.svgPaths.arc("a","0 0,1",t-e,I.utils.svgPaths.point(t-o,-o+e)),s=I.utils.svgPaths.moveBy(e,t)+I.utils.svgPaths.arc("a","0 0,1",t-e,I.utils.svgPaths.point(t,-t+e)),n=-o,r=I.utils.svgPaths.moveBy(o,n)+I.utils.svgPaths.arc("a","0 0,1",t-e,I.utils.svgPaths.point(-o+e,-n-t));return{height:t,topLeft:function(t){return t?i:s},bottomLeft:function(){return r}}},I.geras.HighlightConstantProvider.prototype.makePuzzleTab=function(){var t=this.constantProvider.TAB_WIDTH,e=this.constantProvider.TAB_HEIGHT,o=I.utils.svgPaths.moveBy(-2,-e+3.4)+I.utils.svgPaths.lineTo(-.45*t,-2.1),i=I.utils.svgPaths.lineOnAxis("v",2.5)+I.utils.svgPaths.moveBy(.97*-t,2.5)+I.utils.svgPaths.curve("q",[I.utils.svgPaths.point(.05*-t,10),I.utils.svgPaths.point(.3*t,9.5)])+I.utils.svgPaths.moveBy(.67*t,-1.9)+I.utils.svgPaths.lineOnAxis("v",2.5),s=I.utils.svgPaths.lineOnAxis("v",-1.5)+I.utils.svgPaths.moveBy(-.92*t,-.5)+I.utils.svgPaths.curve("q",[I.utils.svgPaths.point(-.19*t,-5.5),I.utils.svgPaths.point(0,-11)])+I.utils.svgPaths.moveBy(.92*t,1),n=I.utils.svgPaths.moveBy(-5,e-.7)+I.utils.svgPaths.lineTo(.46*t,-2.1);return{width:t,height:e,pathUp:function(t){return t?o:s},pathDown:function(t){return t?i:n}}},I.geras.HighlightConstantProvider.prototype.makeNotch=function(){return{pathLeft:I.utils.svgPaths.lineOnAxis("h",this.OFFSET)+this.constantProvider.NOTCH.pathLeft}},I.geras.HighlightConstantProvider.prototype.makeJaggedTeeth=function(){return{pathLeft:I.utils.svgPaths.lineTo(5.1,2.6)+I.utils.svgPaths.moveBy(-10.2,6.8)+I.utils.svgPaths.lineTo(5.1,2.6),height:12,width:10.2}},I.geras.HighlightConstantProvider.prototype.makeStartHat=function(){var t=this.constantProvider.START_HAT.height,e=I.utils.svgPaths.moveBy(25,-8.7)+I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(29.7,-6.2),I.utils.svgPaths.point(57.2,-.5),I.utils.svgPaths.point(75,8.7)]),o=I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(17.8,-9.2),I.utils.svgPaths.point(45.3,-14.9),I.utils.svgPaths.point(75,-8.7)])+I.utils.svgPaths.moveTo(100.5,t+.5);return{path:function(t){return t?e:o}}},I.geras.PathObject=function(t,e,o){this.constants=o,this.svgRoot=t,this.svgPathDark=I.utils.dom.createSvgElement(),this.svgPath=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyPath"},this.svgRoot),this.svgPathLight=I.utils.dom.createSvgElement(),this.colourDark="#000000",this.style=e},I.utils.object.inherits(I.geras.PathObject,I.blockRendering.PathObject),I.geras.PathObject.prototype.setPath=function(t){this.svgPath.setAttribute("d",t),this.svgPathDark.setAttribute("d",t)},I.geras.PathObject.prototype.setHighlightPath=function(t){this.svgPathLight.setAttribute("d",t)},I.geras.PathObject.prototype.flipRTL=function(){this.svgPath.setAttribute("transform","scale(-1 1)"),this.svgPathLight.setAttribute("transform","scale(-1 1)"),this.svgPathDark.setAttribute("transform","translate(1,1) scale(-1 1)")},I.geras.PathObject.prototype.applyColour=function(t){this.svgPathLight.style.display="",this.svgPathDark.style.display="",this.svgPathLight.setAttribute("stroke",this.style.colourTertiary),this.svgPathDark.setAttribute("fill",this.colourDark),I.geras.PathObject.superClass_.applyColour.call(this,t),this.svgPath.setAttribute("stroke","none")},I.geras.PathObject.prototype.setStyle=function(t){this.style=t,this.colourDark=I.utils.colour.blend("#000",this.style.colourPrimary,.2)||this.colourDark},I.geras.PathObject.prototype.updateHighlighted=function(t){t?(this.svgPath.setAttribute("filter","url(#"+this.constants.embossFilterId+")"),this.svgPathLight.style.display="none"):(this.svgPath.setAttribute("filter","none"),this.svgPathLight.style.display="inline")},I.geras.PathObject.prototype.updateShadow_=function(t){t&&(this.svgPathLight.style.display="none",this.svgPathDark.setAttribute("fill",this.style.colourSecondary),this.svgPath.setAttribute("stroke","none"),this.svgPath.setAttribute("fill",this.style.colourSecondary))},I.geras.PathObject.prototype.updateDisabled_=function(t){I.geras.PathObject.superClass_.updateDisabled_.call(this,t),t&&this.svgPath.setAttribute("stroke","none")},I.geras.Renderer=function(t){I.geras.Renderer.superClass_.constructor.call(this,t),this.highlightConstants_=null},I.utils.object.inherits(I.geras.Renderer,I.blockRendering.Renderer),I.geras.Renderer.prototype.init=function(t,e){I.geras.Renderer.superClass_.init.call(this,t,e),this.highlightConstants_=this.makeHighlightConstants_(),this.highlightConstants_.init()},I.geras.Renderer.prototype.refreshDom=function(t,e){I.geras.Renderer.superClass_.refreshDom.call(this,t,e),this.getHighlightConstants().init()},I.geras.Renderer.prototype.makeConstants_=function(){return new I.geras.ConstantProvider},I.geras.Renderer.prototype.makeRenderInfo_=function(t){return new I.geras.RenderInfo(this,t)},I.geras.Renderer.prototype.makeDrawer_=function(t,e){return new I.geras.Drawer(t,e)},I.geras.Renderer.prototype.makePathObject=function(t,e){return new I.geras.PathObject(t,e,this.getConstants())},I.geras.Renderer.prototype.makeHighlightConstants_=function(){return new I.geras.HighlightConstantProvider(this.getConstants())},I.geras.Renderer.prototype.getHighlightConstants=function(){return this.highlightConstants_},I.blockRendering.register("geras",I.geras.Renderer),I.thrasos={},I.thrasos.RenderInfo=function(t,e){I.thrasos.RenderInfo.superClass_.constructor.call(this,t,e)},I.utils.object.inherits(I.thrasos.RenderInfo,I.blockRendering.RenderInfo),I.thrasos.RenderInfo.prototype.getRenderer=function(){return this.renderer_},I.thrasos.RenderInfo.prototype.addElemSpacing_=function(){for(var t=!1,e=0,o;o=this.rows[e];e++)o.hasExternalInput&&(t=!0);for(e=0;o=this.rows[e];e++){var i=o.elements;o.elements=[],o.startsWithElemSpacer()&&o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,i[0])));for(var s=0;s<i.length-1;s++){o.elements.push(i[s]);var n=this.getInRowSpacing_(i[s],i[s+1]);o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,n))}o.elements.push(i[i.length-1]),o.endsWithElemSpacer()&&(n=this.getInRowSpacing_(i[i.length-1],null),t&&o.hasDummyInput&&(n+=this.constants_.TAB_WIDTH),o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,n)))}},I.thrasos.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t)return e&&I.blockRendering.Types.isField(e)&&e.isEditable?this.constants_.MEDIUM_PADDING:e&&I.blockRendering.Types.isInlineInput(e)?this.constants_.MEDIUM_LARGE_PADDING:e&&I.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:this.constants_.LARGE_PADDING;if(!I.blockRendering.Types.isInput(t)&&!e)return I.blockRendering.Types.isField(t)&&t.isEditable?this.constants_.MEDIUM_PADDING:I.blockRendering.Types.isIcon(t)?2*this.constants_.LARGE_PADDING+1:I.blockRendering.Types.isHat(t)?this.constants_.NO_PADDING:I.blockRendering.Types.isPreviousOrNextConnection(t)?this.constants_.LARGE_PADDING:I.blockRendering.Types.isLeftRoundedCorner(t)?this.constants_.MIN_BLOCK_WIDTH:I.blockRendering.Types.isJaggedEdge(t)?this.constants_.NO_PADDING:this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isInput(t)&&!e){if(I.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(I.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}if(!I.blockRendering.Types.isInput(t)&&e&&I.blockRendering.Types.isInput(e)){if(I.blockRendering.Types.isField(t)&&t.isEditable){if(I.blockRendering.Types.isInlineInput(e)||I.blockRendering.Types.isExternalInput(e))return this.constants_.SMALL_PADDING}else{if(I.blockRendering.Types.isInlineInput(e)||I.blockRendering.Types.isExternalInput(e))return this.constants_.MEDIUM_LARGE_PADDING;if(I.blockRendering.Types.isStatementInput(e))return this.constants_.LARGE_PADDING}return this.constants_.LARGE_PADDING-1}if(I.blockRendering.Types.isIcon(t)&&e&&!I.blockRendering.Types.isInput(e))return this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isInlineInput(t)&&e&&I.blockRendering.Types.isField(e))return e.isEditable?this.constants_.MEDIUM_PADDING:this.constants_.LARGE_PADDING;if(I.blockRendering.Types.isLeftSquareCorner(t)&&e){if(I.blockRendering.Types.isHat(e))return this.constants_.NO_PADDING;if(I.blockRendering.Types.isPreviousConnection(e)||I.blockRendering.Types.isNextConnection(e))return e.notchOffset}return I.blockRendering.Types.isLeftRoundedCorner(t)&&e?e.notchOffset-this.constants_.CORNER_RADIUS:I.blockRendering.Types.isField(t)&&e&&I.blockRendering.Types.isField(e)&&t.isEditable==e.isEditable||e&&I.blockRendering.Types.isJaggedEdge(e)?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},I.thrasos.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return I.blockRendering.Types.isTopRow(t)&&I.blockRendering.Types.isBottomRow(e)?this.constants_.EMPTY_BLOCK_SPACER_HEIGHT:I.blockRendering.Types.isTopRow(t)||I.blockRendering.Types.isBottomRow(e)?this.constants_.NO_PADDING:t.hasExternalInput&&e.hasExternalInput?this.constants_.LARGE_PADDING:!t.hasStatement&&e.hasStatement?this.constants_.BETWEEN_STATEMENT_PADDING_Y:t.hasStatement&&e.hasStatement||t.hasDummyInput||e.hasDummyInput?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},I.thrasos.RenderInfo.prototype.getElemCenterline_=function(t,e){if(I.blockRendering.Types.isSpacer(e))return t.yPos+e.height/2;if(I.blockRendering.Types.isBottomRow(t))return t=t.yPos+t.height-t.descenderHeight,I.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2;if(I.blockRendering.Types.isTopRow(t))return I.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2;var o=t.yPos;return o=I.blockRendering.Types.isField(e)&&t.hasStatement?o+(this.constants_.TALL_INPUT_FIELD_OFFSET_Y+e.height/2):o+t.height/2},I.thrasos.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++){i.yPos=e,i.xPos=this.startX,e+=i.height;var t=Math.max(t,i.widthWithConnectedBlocks),s=e-this.topRow.ascenderHeight;i==this.bottomRow&&s<this.constants_.MIN_BLOCK_HEIGHT&&(s=this.constants_.MIN_BLOCK_HEIGHT-s,this.bottomRow.height+=s,e+=s),this.recordElemPositions_(i)}this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width)),this.bottomRow.baseline=e-this.bottomRow.descenderHeight,this.widthWithChildren=t+this.startX,this.height=e,this.startY=this.topRow.capline},I.thrasos.Renderer=function(t){I.thrasos.Renderer.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.thrasos.Renderer,I.blockRendering.Renderer),I.thrasos.Renderer.prototype.makeRenderInfo_=function(t){return new I.thrasos.RenderInfo(this,t)},I.blockRendering.register("thrasos",I.thrasos.Renderer),I.zelos={},I.zelos.ConstantProvider=function(){I.zelos.ConstantProvider.superClass_.constructor.call(this),this.SMALL_PADDING=this.GRID_UNIT=4,this.MEDIUM_PADDING=2*this.GRID_UNIT,this.MEDIUM_LARGE_PADDING=3*this.GRID_UNIT,this.LARGE_PADDING=4*this.GRID_UNIT,this.CORNER_RADIUS=1*this.GRID_UNIT,this.NOTCH_WIDTH=9*this.GRID_UNIT,this.NOTCH_HEIGHT=2*this.GRID_UNIT,this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT=3*this.GRID_UNIT,this.MIN_BLOCK_WIDTH=2*this.GRID_UNIT,this.MIN_BLOCK_HEIGHT=12*this.GRID_UNIT,this.EMPTY_STATEMENT_INPUT_HEIGHT=6*this.GRID_UNIT,this.TAB_OFFSET_FROM_TOP=0,this.TOP_ROW_MIN_HEIGHT=this.CORNER_RADIUS,this.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.BOTTOM_ROW_MIN_HEIGHT=this.CORNER_RADIUS,this.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT=6*this.GRID_UNIT,this.STATEMENT_BOTTOM_SPACER=-this.NOTCH_HEIGHT,this.STATEMENT_INPUT_SPACER_MIN_WIDTH=40*this.GRID_UNIT,this.STATEMENT_INPUT_PADDING_LEFT=4*this.GRID_UNIT,this.EMPTY_INLINE_INPUT_PADDING=4*this.GRID_UNIT,this.EMPTY_INLINE_INPUT_HEIGHT=8*this.GRID_UNIT,this.DUMMY_INPUT_MIN_HEIGHT=8*this.GRID_UNIT,this.DUMMY_INPUT_SHADOW_MIN_HEIGHT=6*this.GRID_UNIT,this.CURSOR_WS_WIDTH=20*this.GRID_UNIT,this.CURSOR_COLOUR="#ffa200",this.CURSOR_RADIUS=5,this.JAGGED_TEETH_WIDTH=this.JAGGED_TEETH_HEIGHT=0,this.START_HAT_HEIGHT=22,this.START_HAT_WIDTH=96,this.SHAPES={HEXAGONAL:1,ROUND:2,SQUARE:3,PUZZLE:4,NOTCH:5},this.SHAPE_IN_SHAPE_PADDING={1:{0:5*this.GRID_UNIT,1:2*this.GRID_UNIT,2:5*this.GRID_UNIT,3:5*this.GRID_UNIT},2:{0:3*this.GRID_UNIT,1:3*this.GRID_UNIT,2:1*this.GRID_UNIT,3:2*this.GRID_UNIT},3:{0:2*this.GRID_UNIT,1:2*this.GRID_UNIT,2:2*this.GRID_UNIT,3:2*this.GRID_UNIT}},this.FULL_BLOCK_FIELDS=!0,this.FIELD_TEXT_FONTSIZE=3*this.GRID_UNIT,this.FIELD_TEXT_FONTWEIGHT="bold",this.FIELD_TEXT_FONTFAMILY='"Helvetica Neue", "Segoe UI", Helvetica, sans-serif',this.FIELD_BORDER_RECT_RADIUS=this.CORNER_RADIUS,this.FIELD_BORDER_RECT_X_PADDING=2*this.GRID_UNIT,this.FIELD_BORDER_RECT_Y_PADDING=1.625*this.GRID_UNIT,this.FIELD_BORDER_RECT_HEIGHT=8*this.GRID_UNIT,this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=8*this.GRID_UNIT,this.FIELD_DROPDOWN_SVG_ARROW=this.FIELD_DROPDOWN_COLOURED_DIV=this.FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW=!0,this.FIELD_DROPDOWN_SVG_ARROW_PADDING=this.FIELD_BORDER_RECT_X_PADDING,this.FIELD_COLOUR_FULL_BLOCK=this.FIELD_TEXTINPUT_BOX_SHADOW=!0,this.FIELD_COLOUR_DEFAULT_WIDTH=2*this.GRID_UNIT,this.FIELD_COLOUR_DEFAULT_HEIGHT=4*this.GRID_UNIT,this.FIELD_CHECKBOX_X_OFFSET=1*this.GRID_UNIT,this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH=12*this.GRID_UNIT,this.SELECTED_GLOW_COLOUR="#fff200",this.SELECTED_GLOW_SIZE=.5,this.REPLACEMENT_GLOW_COLOUR="#fff200",this.REPLACEMENT_GLOW_SIZE=2,this.selectedGlowFilterId="",this.selectedGlowFilter_=null,this.replacementGlowFilterId="",this.replacementGlowFilter_=null},I.utils.object.inherits(I.zelos.ConstantProvider,I.blockRendering.ConstantProvider),I.zelos.ConstantProvider.prototype.setFontConstants_=function(t){I.zelos.ConstantProvider.superClass_.setFontConstants_.call(this,t),this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT=this.FIELD_TEXT_HEIGHT+2*this.FIELD_BORDER_RECT_Y_PADDING},I.zelos.ConstantProvider.prototype.init=function(){I.zelos.ConstantProvider.superClass_.init.call(this),this.HEXAGONAL=this.makeHexagonal(),this.ROUNDED=this.makeRounded(),this.SQUARED=this.makeSquared(),this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT+this.INSIDE_CORNERS.rightWidth},I.zelos.ConstantProvider.prototype.setDynamicProperties_=function(t){I.zelos.ConstantProvider.superClass_.setDynamicProperties_.call(this,t),this.SELECTED_GLOW_COLOUR=t.getComponentStyle("selectedGlowColour")||this.SELECTED_GLOW_COLOUR;var e=Number(t.getComponentStyle("selectedGlowSize"));this.SELECTED_GLOW_SIZE=e&&!isNaN(e)?e:this.SELECTED_GLOW_SIZE,this.REPLACEMENT_GLOW_COLOUR=t.getComponentStyle("replacementGlowColour")||this.REPLACEMENT_GLOW_COLOUR,this.REPLACEMENT_GLOW_SIZE=(t=Number(t.getComponentStyle("replacementGlowSize")))&&!isNaN(t)?t:this.REPLACEMENT_GLOW_SIZE},I.zelos.ConstantProvider.prototype.dispose=function(){I.zelos.ConstantProvider.superClass_.dispose.call(this),this.selectedGlowFilter_&&I.utils.dom.removeNode(this.selectedGlowFilter_),this.replacementGlowFilter_&&I.utils.dom.removeNode(this.replacementGlowFilter_)},I.zelos.ConstantProvider.prototype.makeStartHat=function(){var t=this.START_HAT_HEIGHT,e=this.START_HAT_WIDTH,o;return{height:t,width:e,path:I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(25,-t),I.utils.svgPaths.point(71,-t),I.utils.svgPaths.point(e,0)])}},I.zelos.ConstantProvider.prototype.makeHexagonal=function(){function e(t,e,o){var i=t/2,i;return I.utils.svgPaths.lineTo(-(o=o?-1:1)*(i=s<i?s:i),t=(e?-1:1)*t/2)+I.utils.svgPaths.lineTo(o*i,t)}var s=this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH;return{type:this.SHAPES.HEXAGONAL,isDynamic:!0,width:function(t){return s<(t/=2)?s:t},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},I.zelos.ConstantProvider.prototype.makeRounded=function(){function e(t,e,o){var i=s<t?t-s:0;return I.utils.svgPaths.arc("a","0 0,1",t=(s<t?s:t)/2,I.utils.svgPaths.point((e?-1:1)*t,(e?-1:1)*t))+I.utils.svgPaths.lineOnAxis("v",(o?1:-1)*i)+I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point((e?1:-1)*t,(e?-1:1)*t))}var o=this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH,s=2*o;return{type:this.SHAPES.ROUND,isDynamic:!0,width:function(t){return o<(t/=2)?o:t},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},I.zelos.ConstantProvider.prototype.makeSquared=function(){function e(t,e,o){return t-=2*i,I.utils.svgPaths.arc("a","0 0,1",i,I.utils.svgPaths.point((e?-1:1)*i,(e?-1:1)*i))+I.utils.svgPaths.lineOnAxis("v",(o?1:-1)*t)+I.utils.svgPaths.arc("a","0 0,1",i,I.utils.svgPaths.point((e?1:-1)*i,(e?-1:1)*i))}var i=this.CORNER_RADIUS;return{type:this.SHAPES.SQUARE,isDynamic:!0,width:function(t){return i},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},I.zelos.ConstantProvider.prototype.shapeFor=function(t){var e=t.getCheck();switch(!e&&t.targetConnection&&(e=t.targetConnection.getCheck()),t.type){case I.connectionTypes.INPUT_VALUE:case I.connectionTypes.OUTPUT_VALUE:if(null!=(t=t.getSourceBlock().getOutputShape()))switch(t){case this.SHAPES.HEXAGONAL:return this.HEXAGONAL;case this.SHAPES.ROUND:return this.ROUNDED;case this.SHAPES.SQUARE:return this.SQUARED}if(e&&-1!=e.indexOf("Boolean"))return this.HEXAGONAL;if(e&&-1!=e.indexOf("Number"))return this.ROUNDED;return e&&e.indexOf("String"),this.ROUNDED;case I.connectionTypes.PREVIOUS_STATEMENT:case I.connectionTypes.NEXT_STATEMENT:return this.NOTCH;default:throw Error("Unknown type")}},I.zelos.ConstantProvider.prototype.makeNotch=function(){function t(t){return I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(t*s/2,0),I.utils.svgPaths.point(t*s*3/4,r/2),I.utils.svgPaths.point(t*s,r)])+I.utils.svgPaths.line([I.utils.svgPaths.point(t*s,n)])+I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(t*s/4,r/2),I.utils.svgPaths.point(t*s/2,r),I.utils.svgPaths.point(t*s,r)])+I.utils.svgPaths.lineOnAxis("h",t*i)+I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(t*s/2,0),I.utils.svgPaths.point(t*s*3/4,-(r/2)),I.utils.svgPaths.point(t*s,-r)])+I.utils.svgPaths.line([I.utils.svgPaths.point(t*s,-n)])+I.utils.svgPaths.curve("c",[I.utils.svgPaths.point(t*s/4,-(r/2)),I.utils.svgPaths.point(t*s/2,-r),I.utils.svgPaths.point(t*s,-r)])}var e=this.NOTCH_WIDTH,o=this.NOTCH_HEIGHT,i=e/3,s=i/3,n=o/2,r=n/2,l=t(1),a=t(-1);return{type:this.SHAPES.NOTCH,width:e,height:o,pathLeft:l,pathRight:a}},I.zelos.ConstantProvider.prototype.makeInsideCorners=function(){var t=this.CORNER_RADIUS,e=I.utils.svgPaths.arc("a","0 0,0",t,I.utils.svgPaths.point(-t,t)),o=I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(-t,t)),i,s;return{width:t,height:t,pathTop:e,pathBottom:I.utils.svgPaths.arc("a","0 0,0",t,I.utils.svgPaths.point(t,t)),rightWidth:t,rightHeight:t,pathTopRight:o,pathBottomRight:I.utils.svgPaths.arc("a","0 0,1",t,I.utils.svgPaths.point(t,t))}},I.zelos.ConstantProvider.prototype.generateSecondaryColour_=function(t){return I.utils.colour.blend("#000",t,.15)||t},I.zelos.ConstantProvider.prototype.generateTertiaryColour_=function(t){return I.utils.colour.blend("#000",t,.25)||t},I.zelos.ConstantProvider.prototype.createDom=function(t,e,o){I.zelos.ConstantProvider.superClass_.createDom.call(this,t,e,o),t=I.utils.dom.createSvgElement(I.utils.Svg.DEFS,{},t),e=I.utils.dom.createSvgElement(I.utils.Svg.FILTER,{id:"blocklySelectedGlowFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),I.utils.dom.createSvgElement(I.utils.Svg.FEGAUSSIANBLUR,{in:"SourceGraphic",stdDeviation:this.SELECTED_GLOW_SIZE},e),o=I.utils.dom.createSvgElement(I.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},e),I.utils.dom.createSvgElement(I.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},o),I.utils.dom.createSvgElement(I.utils.Svg.FEFLOOD,{"flood-color":this.SELECTED_GLOW_COLOUR,"flood-opacity":1,result:"outColor"},e),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},e),this.selectedGlowFilterId=e.id,this.selectedGlowFilter_=e,t=I.utils.dom.createSvgElement(I.utils.Svg.FILTER,{id:"blocklyReplacementGlowFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),I.utils.dom.createSvgElement(I.utils.Svg.FEGAUSSIANBLUR,{in:"SourceGraphic",stdDeviation:this.REPLACEMENT_GLOW_SIZE},t),e=I.utils.dom.createSvgElement(I.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},t),I.utils.dom.createSvgElement(I.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},e),I.utils.dom.createSvgElement(I.utils.Svg.FEFLOOD,{"flood-color":this.REPLACEMENT_GLOW_COLOUR,"flood-opacity":1,result:"outColor"},t),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},t),I.utils.dom.createSvgElement(I.utils.Svg.FECOMPOSITE,{in:"SourceGraphic",in2:"outGlow",operator:"over"},t),this.replacementGlowFilterId=t.id,this.replacementGlowFilter_=t},I.zelos.ConstantProvider.prototype.getCSS_=function(t){return[t+" .blocklyText,",t+" .blocklyFlyoutLabelText {","font: "+this.FIELD_TEXT_FONTWEIGHT+" "+this.FIELD_TEXT_FONTSIZE+"pt "+this.FIELD_TEXT_FONTFAMILY+";","}",t+" .blocklyText {","fill: #fff;","}",t+" .blocklyNonEditableText>rect:not(.blocklyDropdownRect),",t+" .blocklyEditableText>rect:not(.blocklyDropdownRect) {","fill: "+this.FIELD_BORDER_RECT_COLOUR+";","}",t+" .blocklyNonEditableText>text,",t+" .blocklyEditableText>text,",t+" .blocklyNonEditableText>g>text,",t+" .blocklyEditableText>g>text {","fill: #575E75;","}",t+" .blocklyFlyoutLabelText {","fill: #575E75;","}",t+" .blocklyText.blocklyBubbleText {","fill: #575E75;","}",t+" .blocklyDraggable:not(.blocklyDisabled)"," .blocklyEditableText:not(.editing):hover>rect,",t+" .blocklyDraggable:not(.blocklyDisabled)"," .blocklyEditableText:not(.editing):hover>.blocklyPath {","stroke: #fff;","stroke-width: 2;","}",t+" .blocklyHtmlInput {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","font-weight: "+this.FIELD_TEXT_FONTWEIGHT+";","color: #575E75;","}",t+" .blocklyDropdownText {","fill: #fff !important;","}",t+".blocklyWidgetDiv .goog-menuitem,",t+".blocklyDropDownDiv .goog-menuitem {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","}",t+".blocklyDropDownDiv .goog-menuitem-content {","color: #fff;","}",t+" .blocklyHighlightedConnectionPath {","stroke: "+this.SELECTED_GLOW_COLOUR+";","}",t+" .blocklyDisabled > .blocklyOutlinePath {","fill: url(#blocklyDisabledPattern"+this.randomIdentifier+")","}",t+" .blocklyInsertionMarker>.blocklyPath {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"]},I.zelos.TopRow=function(t){I.zelos.TopRow.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.zelos.TopRow,I.blockRendering.TopRow),I.zelos.TopRow.prototype.endsWithElemSpacer=function(){return!1},I.zelos.TopRow.prototype.hasLeftSquareCorner=function(t){var e=(t.hat?"cap"===t.hat:this.constants_.ADD_START_HATS)&&!t.outputConnection&&!t.previousConnection;return!!t.outputConnection||e},I.zelos.TopRow.prototype.hasRightSquareCorner=function(t){return!!t.outputConnection&&!t.statementInputCount&&!t.nextConnection},I.zelos.BottomRow=function(t){I.zelos.BottomRow.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.zelos.BottomRow,I.blockRendering.BottomRow),I.zelos.BottomRow.prototype.endsWithElemSpacer=function(){return!1},I.zelos.BottomRow.prototype.hasLeftSquareCorner=function(t){return!!t.outputConnection},I.zelos.BottomRow.prototype.hasRightSquareCorner=function(t){return!!t.outputConnection&&!t.statementInputCount&&!t.nextConnection},I.zelos.RightConnectionShape=function(t){I.zelos.RightConnectionShape.superClass_.constructor.call(this,t),this.type|=I.blockRendering.Types.getType("RIGHT_CONNECTION"),this.width=this.height=0},I.utils.object.inherits(I.zelos.RightConnectionShape,I.blockRendering.Measurable),I.zelos.RenderInfo=function(t,e){I.zelos.RenderInfo.superClass_.constructor.call(this,t,e),this.topRow=new I.zelos.TopRow(this.constants_),this.bottomRow=new I.zelos.BottomRow(this.constants_),this.isInline=!0,this.isMultiRow=!e.getInputsInline()||e.isCollapsed(),this.hasStatementInput=0<e.statementInputCount,this.rightSide=this.outputConnection?new I.zelos.RightConnectionShape(this.constants_):null},I.utils.object.inherits(I.zelos.RenderInfo,I.blockRendering.RenderInfo),I.zelos.RenderInfo.prototype.getRenderer=function(){return this.renderer_},I.zelos.RenderInfo.prototype.measure=function(){this.createRows_(),this.addElemSpacing_(),this.addRowSpacing_(),this.adjustXPosition_(),this.computeBounds_(),this.alignRowElements_(),this.finalize_()},I.zelos.RenderInfo.prototype.shouldStartNewRow_=function(t,e){return!!e&&(t.type==I.inputTypes.STATEMENT||e.type==I.inputTypes.STATEMENT||(t.type==I.inputTypes.VALUE||t.type==I.inputTypes.DUMMY)&&(!this.isInline||this.isMultiRow))},I.zelos.RenderInfo.prototype.getDesiredRowWidth_=function(t){return t.hasStatement?this.width-this.startX-(this.constants_.INSIDE_CORNERS.rightWidth||0):I.zelos.RenderInfo.superClass_.getDesiredRowWidth_.call(this,t)},I.zelos.RenderInfo.prototype.getInRowSpacing_=function(t,e){return t&&e||!this.outputConnection||!this.outputConnection.isDynamicShape||this.hasStatementInput||this.bottomRow.hasNextConnection?!t&&e&&I.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:t&&I.blockRendering.Types.isLeftRoundedCorner(t)&&e&&(I.blockRendering.Types.isPreviousConnection(e)||I.blockRendering.Types.isNextConnection(e))?e.notchOffset-this.constants_.CORNER_RADIUS:t&&I.blockRendering.Types.isLeftSquareCorner(t)&&e&&I.blockRendering.Types.isHat(e)?this.constants_.NO_PADDING:this.constants_.MEDIUM_PADDING:this.constants_.NO_PADDING},I.zelos.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){if(I.blockRendering.Types.isTopRow(t)&&I.blockRendering.Types.isBottomRow(e))return this.constants_.EMPTY_BLOCK_SPACER_HEIGHT;var o=I.blockRendering.Types.isInputRow(t)&&t.hasStatement,i=I.blockRendering.Types.isInputRow(e)&&e.hasStatement;return i||o?(t=Math.max(this.constants_.NOTCH_HEIGHT,this.constants_.INSIDE_CORNERS.rightHeight||0),i&&o?Math.max(t,this.constants_.DUMMY_INPUT_MIN_HEIGHT):t):I.blockRendering.Types.isTopRow(t)?t.hasPreviousConnection||this.outputConnection&&!this.hasStatementInput?this.constants_.NO_PADDING:Math.abs(this.constants_.NOTCH_HEIGHT-this.constants_.CORNER_RADIUS):I.blockRendering.Types.isBottomRow(e)?this.outputConnection?!e.hasNextConnection&&this.hasStatementInput?Math.abs(this.constants_.NOTCH_HEIGHT-this.constants_.CORNER_RADIUS):this.constants_.NO_PADDING:Math.max(this.topRow.minHeight,Math.max(this.constants_.NOTCH_HEIGHT,this.constants_.CORNER_RADIUS))-this.constants_.CORNER_RADIUS:this.constants_.MEDIUM_PADDING},I.zelos.RenderInfo.prototype.getSpacerRowWidth_=function(t,e){var o=this.width-this.startX;return I.blockRendering.Types.isInputRow(t)&&t.hasStatement||I.blockRendering.Types.isInputRow(e)&&e.hasStatement?Math.max(o,this.constants_.STATEMENT_INPUT_SPACER_MIN_WIDTH):o},I.zelos.RenderInfo.prototype.getElemCenterline_=function(t,e){if(t.hasStatement&&!I.blockRendering.Types.isSpacer(e)&&!I.blockRendering.Types.isStatementInput(e))return t.yPos+this.constants_.EMPTY_STATEMENT_INPUT_HEIGHT/2;if(I.blockRendering.Types.isInlineInput(e)){var o=e.connectedBlock;if(o&&o.outputConnection&&o.nextConnection)return t.yPos+o.height/2}return I.zelos.RenderInfo.superClass_.getElemCenterline_.call(this,t,e)},I.zelos.RenderInfo.prototype.addInput_=function(t,e){t.type==I.inputTypes.DUMMY&&e.hasDummyInput&&e.align==I.constants.ALIGN.LEFT&&t.align==I.constants.ALIGN.RIGHT&&(e.rightAlignedDummyInput=t),I.zelos.RenderInfo.superClass_.addInput_.call(this,t,e)},I.zelos.RenderInfo.prototype.addAlignmentPadding_=function(t,e){if(t.rightAlignedDummyInput){for(var o,i=0,s;(s=t.elements[i])&&(I.blockRendering.Types.isSpacer(s)&&(o=s),!I.blockRendering.Types.isField(s)||s.parentInput!=t.rightAlignedDummyInput);i++);if(o)return o.width+=e,void(t.width+=e)}I.zelos.RenderInfo.superClass_.addAlignmentPadding_.call(this,t,e)},I.zelos.RenderInfo.prototype.adjustXPosition_=function(){for(var t=this.constants_.NOTCH_OFFSET_LEFT+this.constants_.NOTCH_WIDTH,e=t,o=2;o<this.rows.length-1;o+=2){var i=this.rows[o-1],s=this.rows[o],n=this.rows[o+1];if(i=2==o?!!this.topRow.hasPreviousConnection:!!i.followsStatement,n=o+2>=this.rows.length-1?!!this.bottomRow.hasNextConnection:!!n.precedesStatement,I.blockRendering.Types.isInputRow(s)&&s.hasStatement)s.measure(),e=s.width-s.getLastInput().width+t;else if(i&&(2==o||n)&&I.blockRendering.Types.isInputRow(s)&&!s.hasStatement)for(var n=s.xPos,i=null,r=0,l;l=s.elements[r];r++)!((i=I.blockRendering.Types.isSpacer(l)?l:i)&&(I.blockRendering.Types.isField(l)||I.blockRendering.Types.isInput(l))&&n<e)||I.blockRendering.Types.isField(l)&&(l.field instanceof I.FieldLabel||l.field instanceof I.FieldImage)||(i.width+=e-n),n+=l.width}},I.zelos.RenderInfo.prototype.finalizeOutputConnection_=function(){if(this.outputConnection&&this.outputConnection.isDynamicShape){for(var t=0,e=0,o;o=this.rows[e];e++)o.yPos=t,t+=o.height;this.height=t,e=this.bottomRow.hasNextConnection?this.height-this.bottomRow.descenderHeight:this.height,t=this.outputConnection.shape.height(e),e=this.outputConnection.shape.width(e),this.outputConnection.height=t,this.outputConnection.width=e,this.outputConnection.startX=e,this.outputConnection.connectionOffsetY=this.outputConnection.shape.connectionOffsetY(t),this.outputConnection.connectionOffsetX=this.outputConnection.shape.connectionOffsetX(e),o=0,this.hasStatementInput||this.bottomRow.hasNextConnection||(o=e,this.rightSide.height=t,this.rightSide.width=o,this.rightSide.centerline=t/2,this.rightSide.xPos=this.width+o),this.startX=e,this.width+=e+o,this.widthWithChildren+=e+o}},I.zelos.RenderInfo.prototype.finalizeHorizontalAlignment_=function(){if(this.outputConnection&&!this.hasStatementInput&&!this.bottomRow.hasNextConnection){for(var t=0,e=0,o,t,i,s,n;o=this.rows[e];e++){I.blockRendering.Types.isInputRow(o)&&(t=o.elements[o.elements.length-2],i=this.getNegativeSpacing_(o.elements[1]),s=this.getNegativeSpacing_(t),n=this.constants_.MIN_BLOCK_WIDTH+2*this.outputConnection.width,this.width-(t=i+s)<n&&(s=i=(t=this.width-n)/2),o.elements.unshift(new I.blockRendering.InRowSpacer(this.constants_,-i)),o.elements.push(new I.blockRendering.InRowSpacer(this.constants_,-s)))}if(t)for(this.width-=t,this.widthWithChildren-=t,this.rightSide.xPos-=t,e=0;o=this.rows[e];e++)I.blockRendering.Types.isTopOrBottomRow(o)&&(o.elements[1].width-=t,o.elements[1].widthWithConnectedBlocks-=t),o.width-=t,o.widthWithConnectedBlocks-=t}},I.zelos.RenderInfo.prototype.getNegativeSpacing_=function(t){if(!t)return 0;var e=this.outputConnection.width,o=this.outputConnection.shape.type,i=this.constants_;if(this.isMultiRow&&1<this.inputRows.length)switch(o){case i.SHAPES.ROUND:return o=this.constants_.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH,e-(o=this.height/2>o?o:this.height/2)*(1-Math.sin(Math.acos((o-this.constants_.SMALL_PADDING)/o)));default:return 0}if(I.blockRendering.Types.isInlineInput(t)){var s=t.connectedBlock;return t=s?s.pathObject.outputShapeType:t.shape.type,s&&s.outputConnection&&(s.statementInputCount||s.nextConnection)||o==i.SHAPES.HEXAGONAL&&o!=t?0:e-this.constants_.SHAPE_IN_SHAPE_PADDING[o][t]}return I.blockRendering.Types.isField(t)?o==i.SHAPES.ROUND&&t.field instanceof I.FieldTextInput?e-2.75*i.GRID_UNIT:e-this.constants_.SHAPE_IN_SHAPE_PADDING[o][0]:I.blockRendering.Types.isIcon(t)?this.constants_.SMALL_PADDING:0},I.zelos.RenderInfo.prototype.finalizeVerticalAlignment_=function(){if(!this.outputConnection)for(var t=2;t<this.rows.length-1;t+=2){var e=this.rows[t-1],o=this.rows[t],i=this.rows[t+1],s=2==t,n=t+2>=this.rows.length-1?!!this.bottomRow.hasNextConnection:!!i.precedesStatement;if(s?this.topRow.hasPreviousConnection:e.followsStatement){var r=3==o.elements.length&&(o.elements[1].field instanceof I.FieldLabel||o.elements[1].field instanceof I.FieldImage);if(!s&&r)e.height-=this.constants_.SMALL_PADDING,i.height-=this.constants_.SMALL_PADDING,o.height-=this.constants_.MEDIUM_PADDING;else if(s||n){if(n){for(s=!1,n=0;r=o.elements[n];n++)if(I.blockRendering.Types.isInlineInput(r)&&r.connectedBlock&&!r.connectedBlock.isShadow()&&40<=r.connectedBlock.getHeightWidth().height){s=!0;break}s&&(e.height-=this.constants_.SMALL_PADDING,i.height-=this.constants_.SMALL_PADDING)}}else e.height+=this.constants_.SMALL_PADDING}}},I.zelos.RenderInfo.prototype.finalize_=function(){this.finalizeOutputConnection_(),this.finalizeHorizontalAlignment_(),this.finalizeVerticalAlignment_(),I.zelos.RenderInfo.superClass_.finalize_.call(this),this.rightSide&&(this.widthWithChildren+=this.rightSide.width)},I.zelos.Drawer=function(t,e){I.zelos.Drawer.superClass_.constructor.call(this,t,e)},I.utils.object.inherits(I.zelos.Drawer,I.blockRendering.Drawer),I.zelos.Drawer.prototype.draw=function(){var t=this.block_.pathObject;t.beginDrawing(),this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_(),t.setPath(this.outlinePath_+"\n"+this.inlinePath_),this.info_.RTL&&t.flipRTL(),I.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_(),this.info_.outputConnection&&(t.outputShapeType=this.info_.outputConnection.shape.type),t.endDrawing()},I.zelos.Drawer.prototype.drawOutline_=function(){this.info_.outputConnection&&this.info_.outputConnection.isDynamicShape&&!this.info_.hasStatementInput&&!this.info_.bottomRow.hasNextConnection?(this.drawFlatTop_(),this.drawRightDynamicConnection_(),this.drawFlatBottom_(),this.drawLeftDynamicConnection_()):I.zelos.Drawer.superClass_.drawOutline_.call(this)},I.zelos.Drawer.prototype.drawLeft_=function(){this.info_.outputConnection&&this.info_.outputConnection.isDynamicShape?this.drawLeftDynamicConnection_():I.zelos.Drawer.superClass_.drawLeft_.call(this)},I.zelos.Drawer.prototype.drawRightSideRow_=function(t){var e,e;t.height<=0||(t.precedesStatement||t.followsStatement?(e=this.constants_.INSIDE_CORNERS.rightHeight,e=t.height-(t.precedesStatement?e:0),this.outlinePath_+=(t.followsStatement?this.constants_.INSIDE_CORNERS.pathBottomRight:"")+(0<e?I.utils.svgPaths.lineOnAxis("V",t.yPos+e):"")+(t.precedesStatement?this.constants_.INSIDE_CORNERS.pathTopRight:"")):this.outlinePath_+=I.utils.svgPaths.lineOnAxis("V",t.yPos+t.height))},I.zelos.Drawer.prototype.drawRightDynamicConnection_=function(){this.outlinePath_+=this.info_.outputConnection.shape.pathRightDown(this.info_.outputConnection.height)},I.zelos.Drawer.prototype.drawLeftDynamicConnection_=function(){this.positionOutputConnection_(),this.outlinePath_+=this.info_.outputConnection.shape.pathUp(this.info_.outputConnection.height),this.outlinePath_+="z"},I.zelos.Drawer.prototype.drawFlatTop_=function(){var t=this.info_.topRow;this.positionPreviousConnection_(),this.outlinePath_+=I.utils.svgPaths.moveBy(t.xPos,this.info_.startY),this.outlinePath_+=I.utils.svgPaths.lineOnAxis("h",t.width)},I.zelos.Drawer.prototype.drawFlatBottom_=function(){var t=this.info_.bottomRow;this.positionNextConnection_(),this.outlinePath_+=I.utils.svgPaths.lineOnAxis("V",t.baseline),this.outlinePath_+=I.utils.svgPaths.lineOnAxis("h",-t.width)},I.zelos.Drawer.prototype.drawInlineInput_=function(t){this.positionInlineInputConnection_(t);var e=t.input.name,o;t.connectedBlock||this.info_.isInsertionMarker||(o=t.width-2*t.connectionWidth,t=I.utils.svgPaths.moveTo(t.xPos+t.connectionWidth,t.centerline-t.height/2)+I.utils.svgPaths.lineOnAxis("h",o)+t.shape.pathRightDown(t.height)+I.utils.svgPaths.lineOnAxis("h",-o)+t.shape.pathUp(t.height)+"z",this.block_.pathObject.setOutlinePath(e,t
))},I.zelos.Drawer.prototype.drawStatementInput_=function(t){var e,o=(e=t.getLastInput()).xPos+e.notchOffset+e.shape.width,i=e.shape.pathRight+I.utils.svgPaths.lineOnAxis("h",-(e.notchOffset-this.constants_.INSIDE_CORNERS.width))+this.constants_.INSIDE_CORNERS.pathTop,s=t.height-2*this.constants_.INSIDE_CORNERS.height,e=this.constants_.INSIDE_CORNERS.pathBottom+I.utils.svgPaths.lineOnAxis("h",e.notchOffset-this.constants_.INSIDE_CORNERS.width)+(e.connectedBottomNextConnection?"":e.shape.pathLeft);this.outlinePath_+=I.utils.svgPaths.lineOnAxis("H",o)+i+I.utils.svgPaths.lineOnAxis("v",s)+e+I.utils.svgPaths.lineOnAxis("H",t.xPos+t.width),this.positionStatementInputConnection_(t)},I.zelos.MarkerSvg=function(t,e,o){I.zelos.MarkerSvg.superClass_.constructor.call(this,t,e,o)},I.utils.object.inherits(I.zelos.MarkerSvg,I.blockRendering.MarkerSvg),I.zelos.MarkerSvg.prototype.showWithInputOutput_=function(t){var e=t.getSourceBlock();t=t.getLocation().getOffsetInBlock(),this.positionCircle_(t.x,t.y),this.setParent_(e),this.showCurrent_()},I.zelos.MarkerSvg.prototype.showWithOutput_=function(t){this.showWithInputOutput_(t)},I.zelos.MarkerSvg.prototype.showWithInput_=function(t){this.showWithInputOutput_(t)},I.zelos.MarkerSvg.prototype.showWithBlock_=function(t){var e=(t=t.getLocation()).getHeightWidth();this.positionRect_(0,0,e.width,e.height),this.setParent_(t),this.showCurrent_()},I.zelos.MarkerSvg.prototype.positionCircle_=function(t,e){this.markerCircle_.setAttribute("cx",t),this.markerCircle_.setAttribute("cy",e),this.currentMarkerSvg=this.markerCircle_},I.zelos.MarkerSvg.prototype.hide=function(){I.zelos.MarkerSvg.superClass_.hide.call(this),this.markerCircle_.style.display="none"},I.zelos.MarkerSvg.prototype.createDomInternal_=function(){var t;return I.zelos.MarkerSvg.superClass_.createDomInternal_.call(this),this.markerCircle_=I.utils.dom.createSvgElement(I.utils.Svg.CIRCLE,{r:this.constants_.CURSOR_RADIUS,style:"display: none","stroke-width":this.constants_.CURSOR_STROKE_WIDTH},this.markerSvg_),this.isCursor()&&(t=this.getBlinkProperties_(),I.utils.dom.createSvgElement(I.utils.Svg.ANIMATE,t,this.markerCircle_)),this.markerSvg_},I.zelos.MarkerSvg.prototype.applyColour_=function(t){I.zelos.MarkerSvg.superClass_.applyColour_.call(this,t),this.markerCircle_.setAttribute("fill",this.colour_),this.markerCircle_.setAttribute("stroke",this.colour_),this.isCursor()&&this.markerCircle_.firstChild.setAttribute("values",this.colour_+";transparent;transparent;")},I.zelos.PathObject=function(t,e,o){I.zelos.PathObject.superClass_.constructor.call(this,t,e,o),this.constants=o,this.svgPathSelected_=null,this.outlines_={},this.outputShapeType=this.remainingOutlines_=null},I.utils.object.inherits(I.zelos.PathObject,I.blockRendering.PathObject),I.zelos.PathObject.prototype.setPath=function(t){I.zelos.PathObject.superClass_.setPath.call(this,t),this.svgPathSelected_&&this.svgPathSelected_.setAttribute("d",t)},I.zelos.PathObject.prototype.applyColour=function(t){I.zelos.PathObject.superClass_.applyColour.call(this,t),t.isShadow()&&t.getParent()&&this.svgPath.setAttribute("stroke",t.getParent().style.colourTertiary),t=0;for(var e=Object.keys(this.outlines_),o;o=e[t];t++)this.outlines_[o].setAttribute("fill",this.style.colourTertiary)},I.zelos.PathObject.prototype.flipRTL=function(){I.zelos.PathObject.superClass_.flipRTL.call(this);for(var t=0,e=Object.keys(this.outlines_),o;o=e[t];t++)this.outlines_[o].setAttribute("transform","scale(-1 1)")},I.zelos.PathObject.prototype.updateSelected=function(t){this.setClass_("blocklySelected",t),t?this.svgPathSelected_||(this.svgPathSelected_=this.svgPath.cloneNode(!0),this.svgPathSelected_.setAttribute("fill","none"),this.svgPathSelected_.setAttribute("filter","url(#"+this.constants.selectedGlowFilterId+")"),this.svgRoot.appendChild(this.svgPathSelected_)):this.svgPathSelected_&&(this.svgRoot.removeChild(this.svgPathSelected_),this.svgPathSelected_=null)},I.zelos.PathObject.prototype.updateReplacementFade=function(t){this.setClass_("blocklyReplaceable",t),t?this.svgPath.setAttribute("filter","url(#"+this.constants.replacementGlowFilterId+")"):this.svgPath.removeAttribute("filter")},I.zelos.PathObject.prototype.updateShapeForInputHighlight=function(t,e){t=t.getParentInput().name,(t=this.getOutlinePath_(t))&&(e?t.setAttribute("filter","url(#"+this.constants.replacementGlowFilterId+")"):t.removeAttribute("filter"))},I.zelos.PathObject.prototype.beginDrawing=function(){this.remainingOutlines_={};for(var t=0,e=Object.keys(this.outlines_),o;o=e[t];t++)this.remainingOutlines_[o]=1},I.zelos.PathObject.prototype.endDrawing=function(){if(this.remainingOutlines_)for(var t=0,e=Object.keys(this.remainingOutlines_),o;o=e[t];t++)this.removeOutlinePath_(o);this.remainingOutlines_=null},I.zelos.PathObject.prototype.setOutlinePath=function(t,e){(t=this.getOutlinePath_(t)).setAttribute("d",e),t.setAttribute("fill",this.style.colourTertiary)},I.zelos.PathObject.prototype.getOutlinePath_=function(t){return this.outlines_[t]||(this.outlines_[t]=I.utils.dom.createSvgElement(I.utils.Svg.PATH,{class:"blocklyOutlinePath",d:""},this.svgRoot)),this.remainingOutlines_&&delete this.remainingOutlines_[t],this.outlines_[t]},I.zelos.PathObject.prototype.removeOutlinePath_=function(t){this.outlines_[t].parentNode.removeChild(this.outlines_[t]),delete this.outlines_[t]},I.zelos.Renderer=function(t){I.zelos.Renderer.superClass_.constructor.call(this,t)},I.utils.object.inherits(I.zelos.Renderer,I.blockRendering.Renderer),I.zelos.Renderer.prototype.makeConstants_=function(){return new I.zelos.ConstantProvider},I.zelos.Renderer.prototype.makeRenderInfo_=function(t){return new I.zelos.RenderInfo(this,t)},I.zelos.Renderer.prototype.makeDrawer_=function(t,e){return new I.zelos.Drawer(t,e)},I.zelos.Renderer.prototype.makeMarkerDrawer=function(t,e){return new I.zelos.MarkerSvg(t,this.getConstants(),e)},I.zelos.Renderer.prototype.makePathObject=function(t,e){return new I.zelos.PathObject(t,e,this.getConstants())},I.zelos.Renderer.prototype.shouldHighlightConnection=function(t){return t.type!=I.connectionTypes.INPUT_VALUE&&t.type!==I.connectionTypes.OUTPUT_VALUE},I.zelos.Renderer.prototype.getConnectionPreviewMethod=function(t,e,o){return e.type==I.connectionTypes.OUTPUT_VALUE?t.isConnected()?I.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE:I.InsertionMarkerManager.PREVIEW_TYPE.INPUT_OUTLINE:I.zelos.Renderer.superClass_.getConnectionPreviewMethod(t,e,o)},I.blockRendering.register("zelos",I.zelos.Renderer),I.Themes.Dark=I.Theme.defineTheme("dark",{base:I.Themes.Classic,componentStyles:{workspaceBackgroundColour:"#1e1e1e",toolboxBackgroundColour:"blackBackground",toolboxForegroundColour:"#fff",flyoutBackgroundColour:"#252526",flyoutForegroundColour:"#ccc",flyoutOpacity:1,scrollbarColour:"#797979",insertionMarkerColour:"#fff",insertionMarkerOpacity:.3,scrollbarOpacity:.4,cursorColour:"#d0d0d0",blackBackground:"#333"}}),I.Themes.Deuteranopia={},I.Themes.Deuteranopia.defaultBlockStyles={colour_blocks:{colourPrimary:"#f2a72c",colourSecondary:"#f1c172",colourTertiary:"#da921c"},list_blocks:{colourPrimary:"#7d65ab",colourSecondary:"#a88be0",colourTertiary:"#66518e"},logic_blocks:{colourPrimary:"#9fd2f1",colourSecondary:"#c0e0f4",colourTertiary:"#74bae5"},loop_blocks:{colourPrimary:"#795a07",colourSecondary:"#ac8726",colourTertiary:"#c4a03f"},math_blocks:{colourPrimary:"#e6da39",colourSecondary:"#f3ec8e",colourTertiary:"#f2eeb7"},procedure_blocks:{colourPrimary:"#590721",colourSecondary:"#8c475d",colourTertiary:"#885464"},text_blocks:{colourPrimary:"#058863",colourSecondary:"#5ecfaf",colourTertiary:"#04684c"},variable_blocks:{colourPrimary:"#47025a",colourSecondary:"#820fa1",colourTertiary:"#8e579d"},variable_dynamic_blocks:{colourPrimary:"#47025a",colourSecondary:"#820fa1",colourTertiary:"#8e579d"}},I.Themes.Deuteranopia.categoryStyles={colour_category:{colour:"#f2a72c"},list_category:{colour:"#7d65ab"},logic_category:{colour:"#9fd2f1"},loop_category:{colour:"#795a07"},math_category:{colour:"#e6da39"},procedure_category:{colour:"#590721"},text_category:{colour:"#058863"},variable_category:{colour:"#47025a"},variable_dynamic_category:{colour:"#47025a"}},I.Themes.Deuteranopia=new I.Theme("deuteranopia",I.Themes.Deuteranopia.defaultBlockStyles,I.Themes.Deuteranopia.categoryStyles),I.Themes.HighContrast={},I.Themes.HighContrast.defaultBlockStyles={colour_blocks:{colourPrimary:"#a52714",colourSecondary:"#FB9B8C",colourTertiary:"#FBE1DD"},list_blocks:{colourPrimary:"#4a148c",colourSecondary:"#AD7BE9",colourTertiary:"#CDB6E9"},logic_blocks:{colourPrimary:"#01579b",colourSecondary:"#64C7FF",colourTertiary:"#C5EAFF"},loop_blocks:{colourPrimary:"#33691e",colourSecondary:"#9AFF78",colourTertiary:"#E1FFD7"},math_blocks:{colourPrimary:"#1a237e",colourSecondary:"#8A9EFF",colourTertiary:"#DCE2FF"},procedure_blocks:{colourPrimary:"#006064",colourSecondary:"#77E6EE",colourTertiary:"#CFECEE"},text_blocks:{colourPrimary:"#004d40",colourSecondary:"#5ae27c",colourTertiary:"#D2FFDD"},variable_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB"},variable_dynamic_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB"},hat_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB",hat:"cap"}},I.Themes.HighContrast.categoryStyles={colour_category:{colour:"#a52714"},list_category:{colour:"#4a148c"},logic_category:{colour:"#01579b"},loop_category:{colour:"#33691e"},math_category:{colour:"#1a237e"},procedure_category:{colour:"#006064"},text_category:{colour:"#004d40"},variable_category:{colour:"#880e4f"},variable_dynamic_category:{colour:"#880e4f"}},I.Themes.HighContrast=new I.Theme("highcontrast",I.Themes.HighContrast.defaultBlockStyles,I.Themes.HighContrast.categoryStyles),I.Themes.HighContrast.setComponentStyle("selectedGlowColour","#000000"),I.Themes.HighContrast.setComponentStyle("selectedGlowSize",1),I.Themes.HighContrast.setComponentStyle("replacementGlowColour","#000000"),I.Themes.HighContrast.setFontStyle({family:null,weight:null,size:16}),I.Themes.Tritanopia={},I.Themes.Tritanopia.defaultBlockStyles={colour_blocks:{colourPrimary:"#05427f",colourSecondary:"#2974c0",colourTertiary:"#2d74bb"},list_blocks:{colourPrimary:"#b69ce8",colourSecondary:"#ccbaef",colourTertiary:"#9176c5"},logic_blocks:{colourPrimary:"#9fd2f1",colourSecondary:"#c0e0f4",colourTertiary:"#74bae5"},loop_blocks:{colourPrimary:"#aa1846",colourSecondary:"#d36185",colourTertiary:"#7c1636"},math_blocks:{colourPrimary:"#e6da39",colourSecondary:"#f3ec8e",colourTertiary:"#f2eeb7"},procedure_blocks:{colourPrimary:"#590721",colourSecondary:"#8c475d",colourTertiary:"#885464"},text_blocks:{colourPrimary:"#058863",colourSecondary:"#5ecfaf",colourTertiary:"#04684c"},variable_blocks:{colourPrimary:"#4b2d84",colourSecondary:"#816ea7",colourTertiary:"#83759e"},variable_dynamic_blocks:{colourPrimary:"#4b2d84",colourSecondary:"#816ea7",colourTertiary:"#83759e"}},I.Themes.Tritanopia.categoryStyles={colour_category:{colour:"#05427f"},list_category:{colour:"#b69ce8"},logic_category:{colour:"#9fd2f1"},loop_category:{colour:"#aa1846"},math_category:{colour:"#e6da39"},procedure_category:{colour:"#590721"},text_category:{colour:"#058863"},variable_category:{colour:"#4b2d84"},variable_dynamic_category:{colour:"#4b2d84"}},I.Themes.Tritanopia=new I.Theme("tritanopia",I.Themes.Tritanopia.defaultBlockStyles,I.Themes.Tritanopia.categoryStyles),I.requires={},I.Blocks.colour={},I.Constants={},I.Constants.Colour={},I.Constants.Colour.HUE=20,I.defineBlocksWithJsonArray([{type:"colour_picker",message0:"%1",args0:[{type:"field_colour",name:"COLOUR",colour:"#ff0000"}],output:"Colour",helpUrl:"%{BKY_COLOUR_PICKER_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_PICKER_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"colour_random",message0:"%{BKY_COLOUR_RANDOM_TITLE}",output:"Colour",helpUrl:"%{BKY_COLOUR_RANDOM_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_RANDOM_TOOLTIP}"},{type:"colour_rgb",message0:"%{BKY_COLOUR_RGB_TITLE} %{BKY_COLOUR_RGB_RED} %1 %{BKY_COLOUR_RGB_GREEN} %2 %{BKY_COLOUR_RGB_BLUE} %3",args0:[{type:"input_value",name:"RED",check:"Number",align:"RIGHT"},{type:"input_value",name:"GREEN",check:"Number",align:"RIGHT"},{type:"input_value",name:"BLUE",check:"Number",align:"RIGHT"}],output:"Colour",helpUrl:"%{BKY_COLOUR_RGB_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_RGB_TOOLTIP}"},{type:"colour_blend",message0:"%{BKY_COLOUR_BLEND_TITLE} %{BKY_COLOUR_BLEND_COLOUR1} %1 %{BKY_COLOUR_BLEND_COLOUR2} %2 %{BKY_COLOUR_BLEND_RATIO} %3",args0:[{type:"input_value",name:"COLOUR1",check:"Colour",align:"RIGHT"},{type:"input_value",name:"COLOUR2",check:"Colour",align:"RIGHT"},{type:"input_value",name:"RATIO",check:"Number",align:"RIGHT"}],output:"Colour",helpUrl:"%{BKY_COLOUR_BLEND_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_BLEND_TOOLTIP}"}]),I.Blocks.lists={},I.Constants.Lists={},I.Constants.Lists.HUE=260,I.defineBlocksWithJsonArray([{type:"lists_create_empty",message0:"%{BKY_LISTS_CREATE_EMPTY_TITLE}",output:"Array",style:"list_blocks",tooltip:"%{BKY_LISTS_CREATE_EMPTY_TOOLTIP}",helpUrl:"%{BKY_LISTS_CREATE_EMPTY_HELPURL}"},{type:"lists_repeat",message0:"%{BKY_LISTS_REPEAT_TITLE}",args0:[{type:"input_value",name:"ITEM"},{type:"input_value",name:"NUM",check:"Number"}],output:"Array",style:"list_blocks",tooltip:"%{BKY_LISTS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_LISTS_REPEAT_HELPURL}"},{type:"lists_reverse",message0:"%{BKY_LISTS_REVERSE_MESSAGE0}",args0:[{type:"input_value",name:"LIST",check:"Array"}],output:"Array",inputsInline:!0,style:"list_blocks",tooltip:"%{BKY_LISTS_REVERSE_TOOLTIP}",helpUrl:"%{BKY_LISTS_REVERSE_HELPURL}"},{type:"lists_isEmpty",message0:"%{BKY_LISTS_ISEMPTY_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Boolean",style:"list_blocks",tooltip:"%{BKY_LISTS_ISEMPTY_TOOLTIP}",helpUrl:"%{BKY_LISTS_ISEMPTY_HELPURL}"},{type:"lists_length",message0:"%{BKY_LISTS_LENGTH_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Number",style:"list_blocks",tooltip:"%{BKY_LISTS_LENGTH_TOOLTIP}",helpUrl:"%{BKY_LISTS_LENGTH_HELPURL}"}]),I.Blocks.lists_create_with={init:function(){this.setHelpUrl(I.Msg.LISTS_CREATE_WITH_HELPURL),this.setStyle("list_blocks"),this.itemCount_=3,this.updateShape_(),this.setOutput(!0,"Array"),this.setMutator(new I.Mutator(["lists_create_with_item"])),this.setTooltip(I.Msg.LISTS_CREATE_WITH_TOOLTIP)},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("items",this.itemCount_),t},domToMutation:function(t){this.itemCount_=parseInt(t.getAttribute("items"),10),this.updateShape_()},decompose:function(t){var e=t.newBlock("lists_create_with_container");e.initSvg();for(var o=e.getInput("STACK").connection,i=0;i<this.itemCount_;i++){var s=t.newBlock("lists_create_with_item");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return e},compose:function(t){var e=t.getInputTargetBlock("STACK");for(t=[];e&&!e.isInsertionMarker();)t.push(e.valueConnection_),e=e.nextConnection&&e.nextConnection.targetBlock();for(e=0;e<this.itemCount_;e++){var o=this.getInput("ADD"+e).connection.targetConnection;o&&-1==t.indexOf(o)&&o.disconnect()}for(this.itemCount_=t.length,this.updateShape_(),e=0;e<this.itemCount_;e++)I.Mutator.reconnect(t[e],this,"ADD"+e)},saveConnections:function(t){t=t.getInputTargetBlock("STACK");for(var e=0;t;){var o=this.getInput("ADD"+e);t.valueConnection_=o&&o.connection.targetConnection,e++,t=t.nextConnection&&t.nextConnection.targetBlock()}},updateShape_:function(){this.itemCount_&&this.getInput("EMPTY")?this.removeInput("EMPTY"):this.itemCount_||this.getInput("EMPTY")||this.appendDummyInput("EMPTY").appendField(I.Msg.LISTS_CREATE_EMPTY_TITLE);for(var t=0,e;t<this.itemCount_;t++){this.getInput("ADD"+t)||(e=this.appendValueInput("ADD"+t).setAlign(I.ALIGN_RIGHT),0==t&&e.appendField(I.Msg.LISTS_CREATE_WITH_INPUT_WITH))}for(;this.getInput("ADD"+t);)this.removeInput("ADD"+t),t++}},I.Blocks.lists_create_with_container={init:function(){this.setStyle("list_blocks"),this.appendDummyInput().appendField(I.Msg.LISTS_CREATE_WITH_CONTAINER_TITLE_ADD),this.appendStatementInput("STACK"),this.setTooltip(I.Msg.LISTS_CREATE_WITH_CONTAINER_TOOLTIP),this.contextMenu=!1}},I.Blocks.lists_create_with_item={init:function(){this.setStyle("list_blocks"),this.appendDummyInput().appendField(I.Msg.LISTS_CREATE_WITH_ITEM_TITLE),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setTooltip(I.Msg.LISTS_CREATE_WITH_ITEM_TOOLTIP),this.contextMenu=!1}},I.Blocks.lists_indexOf={init:function(){var t=[[I.Msg.LISTS_INDEX_OF_FIRST,"FIRST"],[I.Msg.LISTS_INDEX_OF_LAST,"LAST"]];this.setHelpUrl(I.Msg.LISTS_INDEX_OF_HELPURL),this.setStyle("list_blocks"),this.setOutput(!0,"Number"),this.appendValueInput("VALUE").setCheck("Array").appendField(I.Msg.LISTS_INDEX_OF_INPUT_IN_LIST),this.appendValueInput("FIND").appendField(new I.FieldDropdown(t),"END"),this.setInputsInline(!0);var e=this;this.setTooltip(function(){return I.Msg.LISTS_INDEX_OF_TOOLTIP.replace("%1",e.workspace.options.oneBasedIndex?"0":"-1")})}},I.Blocks.lists_getIndex={init:function(){var t=[[I.Msg.LISTS_GET_INDEX_GET,"GET"],[I.Msg.LISTS_GET_INDEX_GET_REMOVE,"GET_REMOVE"],[I.Msg.LISTS_GET_INDEX_REMOVE,"REMOVE"]];this.WHERE_OPTIONS=[[I.Msg.LISTS_GET_INDEX_FROM_START,"FROM_START"],[I.Msg.LISTS_GET_INDEX_FROM_END,"FROM_END"],[I.Msg.LISTS_GET_INDEX_FIRST,"FIRST"],[I.Msg.LISTS_GET_INDEX_LAST,"LAST"],[I.Msg.LISTS_GET_INDEX_RANDOM,"RANDOM"]],this.setHelpUrl(I.Msg.LISTS_GET_INDEX_HELPURL),this.setStyle("list_blocks"),t=new I.FieldDropdown(t,function(t){t="REMOVE"==t,this.getSourceBlock().updateStatement_(t)}),this.appendValueInput("VALUE").setCheck("Array").appendField(I.Msg.LISTS_GET_INDEX_INPUT_IN_LIST),this.appendDummyInput().appendField(t,"MODE").appendField("","SPACE"),this.appendDummyInput("AT"),I.Msg.LISTS_GET_INDEX_TAIL&&this.appendDummyInput("TAIL").appendField(I.Msg.LISTS_GET_INDEX_TAIL),this.setInputsInline(!0),this.setOutput(!0),this.updateAt_(!0);var i=this;this.setTooltip(function(){var t=i.getFieldValue("MODE"),e=i.getFieldValue("WHERE"),o="";switch(t+" "+e){case"GET FROM_START":case"GET FROM_END":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_FROM;break;case"GET FIRST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_FIRST;break;case"GET LAST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_LAST;break;case"GET RANDOM":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_RANDOM;break;case"GET_REMOVE FROM_START":case"GET_REMOVE FROM_END":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FROM;break;case"GET_REMOVE FIRST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FIRST;break;case"GET_REMOVE LAST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_LAST;break;case"GET_REMOVE RANDOM":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_RANDOM;break;case"REMOVE FROM_START":case"REMOVE FROM_END":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_FROM;break;case"REMOVE FIRST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_FIRST;break;case"REMOVE LAST":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_LAST;break;case"REMOVE RANDOM":o=I.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_RANDOM}return"FROM_START"!=e&&"FROM_END"!=e||(o+="  "+("FROM_START"==e?I.Msg.LISTS_INDEX_FROM_START_TOOLTIP:I.Msg.LISTS_INDEX_FROM_END_TOOLTIP).replace("%1",i.workspace.options.oneBasedIndex?"#1":"#0")),o})},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");t.setAttribute("statement",!this.outputConnection);var e=this.getInput("AT").type==I.INPUT_VALUE;return t.setAttribute("at",e),t},domToMutation:function(t){var e="true"==t.getAttribute("statement");this.updateStatement_(e),t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateStatement_:function(t){t!=!this.outputConnection&&(this.unplug(!0,!0),t?(this.setOutput(!1),this.setPreviousStatement(!0),this.setNextStatement(!0)):(this.setPreviousStatement(!1),this.setNextStatement(!1),this.setOutput(!0)))},updateAt_:function(i){this.removeInput("AT"),this.removeInput("ORDINAL",!0),i?(this.appendValueInput("AT").setCheck("Number"),I.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL").appendField(I.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT");var t=new I.FieldDropdown(this.WHERE_OPTIONS,function(t){var e="FROM_START"==t||"FROM_END"==t;if(e!=i){var o=this.getSourceBlock();return o.updateAt_(e),o.setFieldValue(t,"WHERE"),null}});this.getInput("AT").appendField(t,"WHERE"),I.Msg.LISTS_GET_INDEX_TAIL&&this.moveInputBefore("TAIL",null)}},I.Blocks.lists_setIndex={init:function(){var t=[[I.Msg.LISTS_SET_INDEX_SET,"SET"],[I.Msg.LISTS_SET_INDEX_INSERT,"INSERT"]];this.WHERE_OPTIONS=[[I.Msg.LISTS_GET_INDEX_FROM_START,"FROM_START"],[I.Msg.LISTS_GET_INDEX_FROM_END,"FROM_END"],[I.Msg.LISTS_GET_INDEX_FIRST,"FIRST"],[I.Msg.LISTS_GET_INDEX_LAST,"LAST"],[I.Msg.LISTS_GET_INDEX_RANDOM,"RANDOM"]],this.setHelpUrl(I.Msg.LISTS_SET_INDEX_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("LIST").setCheck("Array").appendField(I.Msg.LISTS_SET_INDEX_INPUT_IN_LIST),this.appendDummyInput().appendField(new I.FieldDropdown(t),"MODE").appendField("","SPACE"),this.appendDummyInput("AT"),this.appendValueInput("TO").appendField(I.Msg.LISTS_SET_INDEX_INPUT_TO),this.setInputsInline(!0),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setTooltip(I.Msg.LISTS_SET_INDEX_TOOLTIP),this.updateAt_(!0);var i=this;this.setTooltip(function(){var t=i.getFieldValue("MODE"),e=i.getFieldValue("WHERE"),o="";switch(t+" "+e){case"SET FROM_START":case"SET FROM_END":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_SET_FROM;break;case"SET FIRST":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_SET_FIRST;break;case"SET LAST":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_SET_LAST;break;case"SET RANDOM":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_SET_RANDOM;break;case"INSERT FROM_START":case"INSERT FROM_END":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_FROM;break;case"INSERT FIRST":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_FIRST;break;case"INSERT LAST":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_LAST;break;case"INSERT RANDOM":o=I.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_RANDOM}return"FROM_START"!=e&&"FROM_END"!=e||(o+="  "+I.Msg.LISTS_INDEX_FROM_START_TOOLTIP.replace("%1",i.workspace.options.oneBasedIndex?"#1":"#0")),o})},mutationToDom:function(){var t=I.utils.xml.createElement("mutation"),e=this.getInput("AT").type==I.INPUT_VALUE;return t.setAttribute("at",e),t},domToMutation:function(t){t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateAt_:function(i){this.removeInput("AT"),this.removeInput("ORDINAL",!0),i?(this.appendValueInput("AT").setCheck("Number"),I.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL").appendField(I.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT");var t=new I.FieldDropdown(this.WHERE_OPTIONS,function(t){var e="FROM_START"==t||"FROM_END"==t;if(e!=i){var o=this.getSourceBlock();return o.updateAt_(e),o.setFieldValue(t,"WHERE"),null}});this.moveInputBefore("AT","TO"),this.getInput("ORDINAL")&&this.moveInputBefore("ORDINAL","TO"),this.getInput("AT").appendField(t,"WHERE")}},I.Blocks.lists_getSublist={init:function(){this.WHERE_OPTIONS_1=[[I.Msg.LISTS_GET_SUBLIST_START_FROM_START,"FROM_START"],[I.Msg.LISTS_GET_SUBLIST_START_FROM_END,"FROM_END"],[I.Msg.LISTS_GET_SUBLIST_START_FIRST,"FIRST"]],this.WHERE_OPTIONS_2=[[I.Msg.LISTS_GET_SUBLIST_END_FROM_START,"FROM_START"],[I.Msg.LISTS_GET_SUBLIST_END_FROM_END,"FROM_END"],[I.Msg.LISTS_GET_SUBLIST_END_LAST,"LAST"]],this.setHelpUrl(I.Msg.LISTS_GET_SUBLIST_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("LIST").setCheck("Array").appendField(I.Msg.LISTS_GET_SUBLIST_INPUT_IN_LIST),this.appendDummyInput("AT1"),this.appendDummyInput("AT2"),I.Msg.LISTS_GET_SUBLIST_TAIL&&this.appendDummyInput("TAIL").appendField(I.Msg.LISTS_GET_SUBLIST_TAIL),this.setInputsInline(!0),this.setOutput(!0,"Array"),this.updateAt_(1,!0),this.updateAt_(2,!0),this.setTooltip(I.Msg.LISTS_GET_SUBLIST_TOOLTIP)},mutationToDom:function(){var t=I.utils.xml.createElement("mutation"),e=this.getInput("AT1").type==I.INPUT_VALUE;return t.setAttribute("at1",e),e=this.getInput("AT2").type==I.INPUT_VALUE,t.setAttribute("at2",e),t},domToMutation:function(t){var e="true"==t.getAttribute("at1");t="true"==t.getAttribute("at2"),this.updateAt_(1,e),this.updateAt_(2,t)},updateAt_:function(i,s){this.removeInput("AT"+i),this.removeInput("ORDINAL"+i,!0),s?(this.appendValueInput("AT"+i).setCheck("Number"),I.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL"+i).appendField(I.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT"+i);var t=new I.FieldDropdown(this["WHERE_OPTIONS_"+i],function(t){var e="FROM_START"==t||"FROM_END"==t;if(e!=s){var o=this.getSourceBlock();return o.updateAt_(i,e),o.setFieldValue(t,"WHERE"+i),null}});this.getInput("AT"+i).appendField(t,"WHERE"+i),1==i&&(this.moveInputBefore("AT1","AT2"),this.getInput("ORDINAL1")&&this.moveInputBefore("ORDINAL1","AT2")),I.Msg.LISTS_GET_SUBLIST_TAIL&&this.moveInputBefore("TAIL",null)}},I.Blocks.lists_sort={init:function(){this.jsonInit({message0:I.Msg.LISTS_SORT_TITLE,args0:[{type:"field_dropdown",name:"TYPE",options:[[I.Msg.LISTS_SORT_TYPE_NUMERIC,"NUMERIC"],[I.Msg.LISTS_SORT_TYPE_TEXT,"TEXT"],[I.Msg.LISTS_SORT_TYPE_IGNORECASE,"IGNORE_CASE"]]},{type:"field_dropdown",name:"DIRECTION",options:[[I.Msg.LISTS_SORT_ORDER_ASCENDING,"1"],[I.Msg.LISTS_SORT_ORDER_DESCENDING,"-1"]]},{type:"input_value",name:"LIST",check:"Array"}],output:"Array",style:"list_blocks",tooltip:I.Msg.LISTS_SORT_TOOLTIP,helpUrl:I.Msg.LISTS_SORT_HELPURL})}},I.Blocks.lists_split={init:function(){var e=this,t=new I.FieldDropdown([[I.Msg.LISTS_SPLIT_LIST_FROM_TEXT,"SPLIT"],[I.Msg.LISTS_SPLIT_TEXT_FROM_LIST,"JOIN"]],function(t){e.updateType_(t)});this.setHelpUrl(I.Msg.LISTS_SPLIT_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("INPUT").setCheck("String").appendField(t,"MODE"),this.appendValueInput("DELIM").setCheck("String").appendField(I.Msg.LISTS_SPLIT_WITH_DELIMITER),this.setInputsInline(!0),this.setOutput(!0,"Array"),this.setTooltip(function(){var t=e.getFieldValue("MODE");if("SPLIT"==t)return I.Msg.LISTS_SPLIT_TOOLTIP_SPLIT;if("JOIN"==t)return I.Msg.LISTS_SPLIT_TOOLTIP_JOIN;throw Error("Unknown mode: "+t)})},updateType_:function(t){var e,o;this.getFieldValue("MODE")!=t&&((e=this.getInput("INPUT").connection).setShadowDom(null),(o=e.targetBlock())&&(e.disconnect(),o.isShadow()?o.dispose():this.bumpNeighbours())),"SPLIT"==t?(this.outputConnection.setCheck("Array"),this.getInput("INPUT").setCheck("String")):(this.outputConnection.setCheck("String"),this.getInput("INPUT").setCheck("Array"))},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("mode",this.getFieldValue("MODE")),t},domToMutation:function(t){this.updateType_(t.getAttribute("mode"))}},I.Blocks.logic={},I.Constants.Logic={},I.Constants.Logic.HUE=210,I.defineBlocksWithJsonArray([{type:"logic_boolean",message0:"%1",args0:[{type:"field_dropdown",name:"BOOL",options:[["%{BKY_LOGIC_BOOLEAN_TRUE}","TRUE"],["%{BKY_LOGIC_BOOLEAN_FALSE}","FALSE"]]}],output:"Boolean",style:"logic_blocks",tooltip:"%{BKY_LOGIC_BOOLEAN_TOOLTIP}",helpUrl:"%{BKY_LOGIC_BOOLEAN_HELPURL}"},{type:"controls_if",message0:"%{BKY_CONTROLS_IF_MSG_IF} %1",args0:[{type:"input_value",name:"IF0",check:"Boolean"}],message1:"%{BKY_CONTROLS_IF_MSG_THEN} %1",args1:[{type:"input_statement",name:"DO0"}],previousStatement:null,nextStatement:null,style:"logic_blocks",helpUrl:"%{BKY_CONTROLS_IF_HELPURL}",mutator:"controls_if_mutator",extensions:["controls_if_tooltip"]},{type:"controls_ifelse",message0:"%{BKY_CONTROLS_IF_MSG_IF} %1",args0:[{type:"input_value",name:"IF0",check:"Boolean"}],message1:"%{BKY_CONTROLS_IF_MSG_THEN} %1",args1:[{type:"input_statement",name:"DO0"}],message2:"%{BKY_CONTROLS_IF_MSG_ELSE} %1",args2:[{type:"input_statement",name:"ELSE"}],previousStatement:null,nextStatement:null,style:"logic_blocks",tooltip:"%{BKYCONTROLS_IF_TOOLTIP_2}",helpUrl:"%{BKY_CONTROLS_IF_HELPURL}",extensions:["controls_if_tooltip"]},{type:"logic_compare",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A"},{type:"field_dropdown",name:"OP",options:[["=","EQ"],["≠","NEQ"],["‏<","LT"],["‏≤","LTE"],["‏>","GT"],["‏≥","GTE"]]},{type:"input_value",name:"B"}],inputsInline:!0,output:"Boolean",style:"logic_blocks",helpUrl:"%{BKY_LOGIC_COMPARE_HELPURL}",extensions:["logic_compare","logic_op_tooltip"]},{type:"logic_operation",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A",check:"Boolean"},{type:"field_dropdown",name:"OP",options:[["%{BKY_LOGIC_OPERATION_AND}","AND"],["%{BKY_LOGIC_OPERATION_OR}","OR"]]},{type:"input_value",name:"B",check:"Boolean"}],inputsInline:!0,output:"Boolean",style:"logic_blocks",helpUrl:"%{BKY_LOGIC_OPERATION_HELPURL}",extensions:["logic_op_tooltip"]},{type:"logic_negate",message0:"%{BKY_LOGIC_NEGATE_TITLE}",args0:[{type:"input_value",name:"BOOL",check:"Boolean"}],output:"Boolean",style:"logic_blocks",tooltip:"%{BKY_LOGIC_NEGATE_TOOLTIP}",helpUrl:"%{BKY_LOGIC_NEGATE_HELPURL}"},{type:"logic_null",message0:"%{BKY_LOGIC_NULL}",output:null,style:"logic_blocks",tooltip:"%{BKY_LOGIC_NULL_TOOLTIP}",helpUrl:"%{BKY_LOGIC_NULL_HELPURL}"},{type:"logic_ternary",message0:"%{BKY_LOGIC_TERNARY_CONDITION} %1",args0:[{type:"input_value",name:"IF",check:"Boolean"}],message1:"%{BKY_LOGIC_TERNARY_IF_TRUE} %1",args1:[{type:"input_value",name:"THEN"}],message2:"%{BKY_LOGIC_TERNARY_IF_FALSE} %1",args2:[{type:"input_value",name:"ELSE"}],output:null,style:"logic_blocks",tooltip:"%{BKY_LOGIC_TERNARY_TOOLTIP}",helpUrl:"%{BKY_LOGIC_TERNARY_HELPURL}",extensions:["logic_ternary"]}]),I.defineBlocksWithJsonArray([{type:"controls_if_if",message0:"%{BKY_CONTROLS_IF_IF_TITLE_IF}",nextStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_IF_TOOLTIP}"},{type:"controls_if_elseif",message0:"%{BKY_CONTROLS_IF_ELSEIF_TITLE_ELSEIF}",previousStatement:null,nextStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_ELSEIF_TOOLTIP}"},{type:"controls_if_else",message0:"%{BKY_CONTROLS_IF_ELSE_TITLE_ELSE}",previousStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_ELSE_TOOLTIP}"}]),I.Constants.Logic.TOOLTIPS_BY_OP={EQ:"%{BKY_LOGIC_COMPARE_TOOLTIP_EQ}",NEQ:"%{BKY_LOGIC_COMPARE_TOOLTIP_NEQ}",LT:"%{BKY_LOGIC_COMPARE_TOOLTIP_LT}",LTE:"%{BKY_LOGIC_COMPARE_TOOLTIP_LTE}",GT:"%{BKY_LOGIC_COMPARE_TOOLTIP_GT}",GTE:"%{BKY_LOGIC_COMPARE_TOOLTIP_GTE}",AND:"%{BKY_LOGIC_OPERATION_TOOLTIP_AND}",OR:"%{BKY_LOGIC_OPERATION_TOOLTIP_OR}"},I.Extensions.register("logic_op_tooltip",I.Extensions.buildTooltipForDropdown("OP",I.Constants.Logic.TOOLTIPS_BY_OP)),I.Constants.Logic.CONTROLS_IF_MUTATOR_MIXIN={elseifCount_:0,elseCount_:0,suppressPrefixSuffix:!0,mutationToDom:function(){if(!this.elseifCount_&&!this.elseCount_)return null;var t=I.utils.xml.createElement("mutation");return this.elseifCount_&&t.setAttribute("elseif",this.elseifCount_),this.elseCount_&&t.setAttribute("else",1),t},domToMutation:function(t){this.elseifCount_=parseInt(t.getAttribute("elseif"),10)||0,this.elseCount_=parseInt(t.getAttribute("else"),10)||0,this.rebuildShape_()},decompose:function(t){var e=t.newBlock("controls_if_if");e.initSvg();for(var o=e.nextConnection,i=1;i<=this.elseifCount_;i++){var s=t.newBlock("controls_if_elseif");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return this.elseCount_&&((t=t.newBlock("controls_if_else")).initSvg(),o.connect(t.previousConnection)),e},compose:function(t){t=t.nextConnection.targetBlock(),this.elseCount_=this.elseifCount_=0;for(var e=[null],o=[null],i=null;t&&!t.isInsertionMarker();){switch(t.type){case"controls_if_elseif":this.elseifCount_++,e.push(t.valueConnection_),o.push(t.statementConnection_);break;case"controls_if_else":this.elseCount_++,i=t.statementConnection_;break;default:throw TypeError("Unknown block type: "+t.type)}t=t.nextConnection&&t.nextConnection.targetBlock()}this.updateShape_(),this.reconnectChildBlocks_(e,o,i)},saveConnections:function(t){t=t.nextConnection.targetBlock();for(var e=1;t;){switch(t.type){case"controls_if_elseif":var o=this.getInput("IF"+e),i=this.getInput("DO"+e);t.valueConnection_=o&&o.connection.targetConnection,t.statementConnection_=i&&i.connection.targetConnection,e++;break;case"controls_if_else":i=this.getInput("ELSE"),t.statementConnection_=i&&i.connection.targetConnection;break;default:throw TypeError("Unknown block type: "+t.type)}t=t.nextConnection&&t.nextConnection.targetBlock()}},rebuildShape_:function(){var t=[null],e=[null],o=null;this.getInput("ELSE")&&(o=this.getInput("ELSE").connection.targetConnection);for(var i=1;this.getInput("IF"+i);){var s=this.getInput("IF"+i),n=this.getInput("DO"+i);t.push(s.connection.targetConnection),e.push(n.connection.targetConnection),i++}this.updateShape_(),this.reconnectChildBlocks_(t,e,o)},updateShape_:function(){this.getInput("ELSE")&&this.removeInput("ELSE");for(var t=1;this.getInput("IF"+t);)this.removeInput("IF"+t),this.removeInput("DO"+t),t++;for(t=1;t<=this.elseifCount_;t++)this.appendValueInput("IF"+t).setCheck("Boolean").appendField(I.Msg.CONTROLS_IF_MSG_ELSEIF),this.appendStatementInput("DO"+t).appendField(I.Msg.CONTROLS_IF_MSG_THEN);this.elseCount_&&this.appendStatementInput("ELSE").appendField(I.Msg.CONTROLS_IF_MSG_ELSE)},reconnectChildBlocks_:function(t,e,o){for(var i=1;i<=this.elseifCount_;i++)I.Mutator.reconnect(t[i],this,"IF"+i),I.Mutator.reconnect(e[i],this,"DO"+i);I.Mutator.reconnect(o,this,"ELSE")}},I.Extensions.registerMutator("controls_if_mutator",I.Constants.Logic.CONTROLS_IF_MUTATOR_MIXIN,null,["controls_if_elseif","controls_if_else"]),I.Constants.Logic.CONTROLS_IF_TOOLTIP_EXTENSION=function(){this.setTooltip(function(){if(!this.elseifCount_&&!this.elseCount_)return I.Msg.CONTROLS_IF_TOOLTIP_1;if(!this.elseifCount_&&this.elseCount_)return I.Msg.CONTROLS_IF_TOOLTIP_2;if(this.elseifCount_&&!this.elseCount_)return I.Msg.CONTROLS_IF_TOOLTIP_3;if(this.elseifCount_&&this.elseCount_)return I.Msg.CONTROLS_IF_TOOLTIP_4;return""}.bind(this))},I.Extensions.register("controls_if_tooltip",I.Constants.Logic.CONTROLS_IF_TOOLTIP_EXTENSION),I.Constants.Logic.LOGIC_COMPARE_ONCHANGE_MIXIN={onchange:function(t){this.prevBlocks_||(this.prevBlocks_=[null,null]);var e=this.getInputTargetBlock("A"),o=this.getInputTargetBlock("B");e&&o&&!this.workspace.connectionChecker.doTypeChecks(e.outputConnection,o.outputConnection)&&(I.Events.setGroup(t.group),(t=this.prevBlocks_[0])!==e&&(e.unplug(),!t||t.isDisposed()||t.isShadow()||this.getInput("A").connection.connect(t.outputConnection)),(e=this.prevBlocks_[1])!==o&&(o.unplug(),!e||e.isDisposed()||e.isShadow()||this.getInput("B").connection.connect(e.outputConnection)),this.bumpNeighbours(),I.Events.setGroup(!1)),this.prevBlocks_[0]=this.getInputTargetBlock("A"),this.prevBlocks_[1]=this.getInputTargetBlock("B")}},I.Constants.Logic.LOGIC_COMPARE_EXTENSION=function(){this.mixin(I.Constants.Logic.LOGIC_COMPARE_ONCHANGE_MIXIN)},I.Extensions.register("logic_compare",I.Constants.Logic.LOGIC_COMPARE_EXTENSION),I.Constants.Logic.LOGIC_TERNARY_ONCHANGE_MIXIN={prevParentConnection_:null,onchange:function(t){var e=this.getInputTargetBlock("THEN"),o=this.getInputTargetBlock("ELSE"),i=this.outputConnection.targetConnection;if((e||o)&&i)for(var s=0;s<2;s++){var n=1==s?e:o;n&&!n.workspace.connectionChecker.doTypeChecks(n.outputConnection,i)&&(I.Events.setGroup(t.group),i===this.prevParentConnection_?(this.unplug(),i.getSourceBlock().bumpNeighbours()):(n.unplug(),n.bumpNeighbours()),I.Events.setGroup(!1))}this.prevParentConnection_=i}},I.Extensions.registerMixin("logic_ternary",I.Constants.Logic.LOGIC_TERNARY_ONCHANGE_MIXIN),I.Blocks.loops={},I.Constants.Loops={},I.Constants.Loops.HUE=120,I.defineBlocksWithJsonArray([{type:"controls_repeat_ext",message0:"%{BKY_CONTROLS_REPEAT_TITLE}",args0:[{type:"input_value",name:"TIMES",check:"Number"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",tooltip:"%{BKY_CONTROLS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_CONTROLS_REPEAT_HELPURL}"},{type:"controls_repeat",message0:"%{BKY_CONTROLS_REPEAT_TITLE}",args0:[{type:"field_number",name:"TIMES",value:10,min:0,precision:1}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",tooltip:"%{BKY_CONTROLS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_CONTROLS_REPEAT_HELPURL}"},{type:"controls_whileUntil",message0:"%1 %2",args0:[{type:"field_dropdown",name:"MODE",options:[["%{BKY_CONTROLS_WHILEUNTIL_OPERATOR_WHILE}","WHILE"],["%{BKY_CONTROLS_WHILEUNTIL_OPERATOR_UNTIL}","UNTIL"]]},{type:"input_value",name:"BOOL",check:"Boolean"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_WHILEUNTIL_HELPURL}",extensions:["controls_whileUntil_tooltip"]},{type:"controls_for",message0:"%{BKY_CONTROLS_FOR_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:null},{type:"input_value",name:"FROM",check:"Number",align:"RIGHT"},{type:"input_value",name:"TO",check:"Number",align:"RIGHT"},{type:"input_value",name:"BY",check:"Number",align:"RIGHT"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],inputsInline:!0,previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FOR_HELPURL}",extensions:["contextMenu_newGetVariableBlock","controls_for_tooltip"]},{type:"controls_forEach",message0:"%{BKY_CONTROLS_FOREACH_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:null},{type:"input_value",name:"LIST",check:"Array"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FOREACH_HELPURL}",extensions:["contextMenu_newGetVariableBlock","controls_forEach_tooltip"]},{type:"controls_flow_statements",message0:"%1",args0:[{type:"field_dropdown",name:"FLOW",options:[["%{BKY_CONTROLS_FLOW_STATEMENTS_OPERATOR_BREAK}","BREAK"],["%{BKY_CONTROLS_FLOW_STATEMENTS_OPERATOR_CONTINUE}","CONTINUE"]]}],previousStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FLOW_STATEMENTS_HELPURL}",extensions:["controls_flow_tooltip","controls_flow_in_loop_check"]}]),I.Constants.Loops.WHILE_UNTIL_TOOLTIPS={WHILE:"%{BKY_CONTROLS_WHILEUNTIL_TOOLTIP_WHILE}",UNTIL:"%{BKY_CONTROLS_WHILEUNTIL_TOOLTIP_UNTIL}"},I.Extensions.register("controls_whileUntil_tooltip",I.Extensions.buildTooltipForDropdown("MODE",I.Constants.Loops.WHILE_UNTIL_TOOLTIPS)),I.Constants.Loops.BREAK_CONTINUE_TOOLTIPS={BREAK:"%{BKY_CONTROLS_FLOW_STATEMENTS_TOOLTIP_BREAK}",CONTINUE:"%{BKY_CONTROLS_FLOW_STATEMENTS_TOOLTIP_CONTINUE}"},I.Extensions.register("controls_flow_tooltip",I.Extensions.buildTooltipForDropdown("FLOW",I.Constants.Loops.BREAK_CONTINUE_TOOLTIPS)),I.Constants.Loops.CUSTOM_CONTEXT_MENU_CREATE_VARIABLES_GET_MIXIN={customContextMenu:function(t){var e,o,i;this.isInFlyout||(o=(e=this.getField("VAR").getVariable()).name,this.isCollapsed()||null==o||((i={enabled:!0}).text=I.Msg.VARIABLES_SET_CREATE_GET.replace("%1",o),e=I.Variables.generateVariableFieldDom(e),(o=I.utils.xml.createElement("block")).setAttribute("type","variables_get"),o.appendChild(e),i.callback=I.ContextMenu.callbackFactory(this,o),t.push(i)))}},I.Extensions.registerMixin("contextMenu_newGetVariableBlock",I.Constants.Loops.CUSTOM_CONTEXT_MENU_CREATE_VARIABLES_GET_MIXIN),I.Extensions.register("controls_for_tooltip",I.Extensions.buildTooltipWithFieldText("%{BKY_CONTROLS_FOR_TOOLTIP}","VAR")),I.Extensions.register("controls_forEach_tooltip",I.Extensions.buildTooltipWithFieldText("%{BKY_CONTROLS_FOREACH_TOOLTIP}","VAR")),I.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN={LOOP_TYPES:["controls_repeat","controls_repeat_ext","controls_forEach","controls_for","controls_whileUntil"],suppressPrefixSuffix:!0,getSurroundLoop:function(t){do{if(-1!=I.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN.LOOP_TYPES.indexOf(t.type))return t;t=t.getSurroundParent()}while(t);return null},onchange:function(t){var e,o;this.workspace.isDragging&&!this.workspace.isDragging()&&t.type==I.Events.BLOCK_MOVE&&(e=I.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN.getSurroundLoop(this),this.setWarningText(e?null:I.Msg.CONTROLS_FLOW_STATEMENTS_WARNING),this.isInFlyout||(o=I.Events.getGroup(),I.Events.setGroup(t.group),this.setEnabled(e),I.Events.setGroup(o)))}},I.Extensions.registerMixin("controls_flow_in_loop_check",I.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN),I.Blocks.math={},I.Constants.Math={},I.Constants.Math.HUE=230,I.defineBlocksWithJsonArray([{type:"math_number",message0:"%1",args0:[{type:"field_number",name:"NUM",value:0}],output:"Number",helpUrl:"%{BKY_MATH_NUMBER_HELPURL}",style:"math_blocks",tooltip:"%{BKY_MATH_NUMBER_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"math_arithmetic",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A",check:"Number"},{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ADDITION_SYMBOL}","ADD"],["%{BKY_MATH_SUBTRACTION_SYMBOL}","MINUS"],["%{BKY_MATH_MULTIPLICATION_SYMBOL}","MULTIPLY"],["%{BKY_MATH_DIVISION_SYMBOL}","DIVIDE"],["%{BKY_MATH_POWER_SYMBOL}","POWER"]]},{type:"input_value",name:"B",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ARITHMETIC_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_single",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_SINGLE_OP_ROOT}","ROOT"],["%{BKY_MATH_SINGLE_OP_ABSOLUTE}","ABS"],["-","NEG"],["ln","LN"],["log10","LOG10"],["e^","EXP"],["10^","POW10"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_SINGLE_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_trig",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_TRIG_SIN}","SIN"],["%{BKY_MATH_TRIG_COS}","COS"],["%{BKY_MATH_TRIG_TAN}","TAN"],["%{BKY_MATH_TRIG_ASIN}","ASIN"],["%{BKY_MATH_TRIG_ACOS}","ACOS"],["%{BKY_MATH_TRIG_ATAN}","ATAN"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_TRIG_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_constant",message0:"%1",args0:[{type:"field_dropdown",name:"CONSTANT",options:[["π","PI"],["e","E"],["φ","GOLDEN_RATIO"],["sqrt(2)","SQRT2"],["sqrt(½)","SQRT1_2"],["∞","INFINITY"]]}],output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_CONSTANT_TOOLTIP}",helpUrl:"%{BKY_MATH_CONSTANT_HELPURL}"},{type:"math_number_property",message0:"%1 %2",args0:[{type:"input_value",name:"NUMBER_TO_CHECK",check:"Number"},{type:"field_dropdown",name:"PROPERTY",options:[["%{BKY_MATH_IS_EVEN}","EVEN"],["%{BKY_MATH_IS_ODD}","ODD"],["%{BKY_MATH_IS_PRIME}","PRIME"],["%{BKY_MATH_IS_WHOLE}","WHOLE"],["%{BKY_MATH_IS_POSITIVE}","POSITIVE"],["%{BKY_MATH_IS_NEGATIVE}","NEGATIVE"],["%{BKY_MATH_IS_DIVISIBLE_BY}","DIVISIBLE_BY"]]}],inputsInline:!0,output:"Boolean",style:"math_blocks",tooltip:"%{BKY_MATH_IS_TOOLTIP}",mutator:"math_is_divisibleby_mutator"},{type:"math_change",message0:"%{BKY_MATH_CHANGE_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_MATH_CHANGE_TITLE_ITEM}"},{type:"input_value",name:"DELTA",check:"Number"}],previousStatement:null,nextStatement:null,style:"variable_blocks",helpUrl:"%{BKY_MATH_CHANGE_HELPURL}",extensions:["math_change_tooltip"]},{type:"math_round",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ROUND_OPERATOR_ROUND}","ROUND"],["%{BKY_MATH_ROUND_OPERATOR_ROUNDUP}","ROUNDUP"],["%{BKY_MATH_ROUND_OPERATOR_ROUNDDOWN}","ROUNDDOWN"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ROUND_HELPURL}",tooltip:"%{BKY_MATH_ROUND_TOOLTIP}"},{type:"math_on_list",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ONLIST_OPERATOR_SUM}","SUM"],["%{BKY_MATH_ONLIST_OPERATOR_MIN}","MIN"],["%{BKY_MATH_ONLIST_OPERATOR_MAX}","MAX"],["%{BKY_MATH_ONLIST_OPERATOR_AVERAGE}","AVERAGE"],["%{BKY_MATH_ONLIST_OPERATOR_MEDIAN}","MEDIAN"],["%{BKY_MATH_ONLIST_OPERATOR_MODE}","MODE"],["%{BKY_MATH_ONLIST_OPERATOR_STD_DEV}","STD_DEV"],["%{BKY_MATH_ONLIST_OPERATOR_RANDOM}","RANDOM"]]},{type:"input_value",name:"LIST",check:"Array"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ONLIST_HELPURL}",mutator:"math_modes_of_list_mutator",extensions:["math_op_tooltip"]},{type:"math_modulo",message0:"%{BKY_MATH_MODULO_TITLE}",args0:[{type:"input_value",name:"DIVIDEND",check:"Number"},{type:"input_value",name:"DIVISOR",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_MODULO_TOOLTIP}",helpUrl:"%{BKY_MATH_MODULO_HELPURL}"},{type:"math_constrain",message0:"%{BKY_MATH_CONSTRAIN_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"Number"},{type:"input_value",name:"LOW",check:"Number"},{type:"input_value",name:"HIGH",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_CONSTRAIN_TOOLTIP}",helpUrl:"%{BKY_MATH_CONSTRAIN_HELPURL}"},{type:"math_random_int",message0:"%{BKY_MATH_RANDOM_INT_TITLE}",args0:[{type:"input_value",name:"FROM",check:"Number"},{type:"input_value",name:"TO",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_RANDOM_INT_TOOLTIP}",helpUrl:"%{BKY_MATH_RANDOM_INT_HELPURL}"},{type:"math_random_float",message0:"%{BKY_MATH_RANDOM_FLOAT_TITLE_RANDOM}",output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_RANDOM_FLOAT_TOOLTIP}",helpUrl:"%{BKY_MATH_RANDOM_FLOAT_HELPURL}"},{type:"math_atan2",message0:"%{BKY_MATH_ATAN2_TITLE}",args0:[{type:"input_value",name:"X",check:"Number"},{type:"input_value",name:"Y",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_ATAN2_TOOLTIP}",helpUrl:"%{BKY_MATH_ATAN2_HELPURL}"}]),I.Constants.Math.TOOLTIPS_BY_OP={ADD:"%{BKY_MATH_ARITHMETIC_TOOLTIP_ADD}",MINUS:"%{BKY_MATH_ARITHMETIC_TOOLTIP_MINUS}",MULTIPLY:"%{BKY_MATH_ARITHMETIC_TOOLTIP_MULTIPLY}",DIVIDE:"%{BKY_MATH_ARITHMETIC_TOOLTIP_DIVIDE}",POWER:"%{BKY_MATH_ARITHMETIC_TOOLTIP_POWER}",ROOT:"%{BKY_MATH_SINGLE_TOOLTIP_ROOT}",ABS:"%{BKY_MATH_SINGLE_TOOLTIP_ABS}",NEG:"%{BKY_MATH_SINGLE_TOOLTIP_NEG}",LN:"%{BKY_MATH_SINGLE_TOOLTIP_LN}",LOG10:"%{BKY_MATH_SINGLE_TOOLTIP_LOG10}",EXP:"%{BKY_MATH_SINGLE_TOOLTIP_EXP}",POW10:"%{BKY_MATH_SINGLE_TOOLTIP_POW10}",SIN:"%{BKY_MATH_TRIG_TOOLTIP_SIN}",COS:"%{BKY_MATH_TRIG_TOOLTIP_COS}",TAN:"%{BKY_MATH_TRIG_TOOLTIP_TAN}",ASIN:"%{BKY_MATH_TRIG_TOOLTIP_ASIN}",ACOS:"%{BKY_MATH_TRIG_TOOLTIP_ACOS}",ATAN:"%{BKY_MATH_TRIG_TOOLTIP_ATAN}",SUM:"%{BKY_MATH_ONLIST_TOOLTIP_SUM}",MIN:"%{BKY_MATH_ONLIST_TOOLTIP_MIN}",MAX:"%{BKY_MATH_ONLIST_TOOLTIP_MAX}",AVERAGE:"%{BKY_MATH_ONLIST_TOOLTIP_AVERAGE}",MEDIAN:"%{BKY_MATH_ONLIST_TOOLTIP_MEDIAN}",MODE:"%{BKY_MATH_ONLIST_TOOLTIP_MODE}",STD_DEV:"%{BKY_MATH_ONLIST_TOOLTIP_STD_DEV}",RANDOM:"%{BKY_MATH_ONLIST_TOOLTIP_RANDOM}"},I.Extensions.register("math_op_tooltip",I.Extensions.buildTooltipForDropdown("OP",I.Constants.Math.TOOLTIPS_BY_OP)),I.Constants.Math.IS_DIVISIBLEBY_MUTATOR_MIXIN={mutationToDom:function(){var t=I.utils.xml.createElement("mutation"),e="DIVISIBLE_BY"==this.getFieldValue("PROPERTY");return t.setAttribute("divisor_input",e),t},domToMutation:function(t){t="true"==t.getAttribute("divisor_input"),this.updateShape_(t)},updateShape_:function(t){var e=this.getInput("DIVISOR");t?e||this.appendValueInput("DIVISOR").setCheck("Number"):e&&this.removeInput("DIVISOR")}},I.Constants.Math.IS_DIVISIBLE_MUTATOR_EXTENSION=function(){this.getField("PROPERTY").setValidator(function(t){t="DIVISIBLE_BY"==t,this.getSourceBlock().updateShape_(t)})},I.Extensions.registerMutator("math_is_divisibleby_mutator",I.Constants.Math.IS_DIVISIBLEBY_MUTATOR_MIXIN,I.Constants.Math.IS_DIVISIBLE_MUTATOR_EXTENSION),I.Extensions.register("math_change_tooltip",I.Extensions.buildTooltipWithFieldText("%{BKY_MATH_CHANGE_TOOLTIP}","VAR")),I.Constants.Math.LIST_MODES_MUTATOR_MIXIN={updateType_:function(t){"MODE"==t?this.outputConnection.setCheck("Array"):this.outputConnection.setCheck("Number")},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("op",this.getFieldValue("OP")),t},domToMutation:function(t){this.updateType_(t.getAttribute("op"))}},I.Constants.Math.LIST_MODES_MUTATOR_EXTENSION=function(){this.getField("OP").setValidator(function(t){this.updateType_(t)}.bind(this))},I.Extensions.registerMutator("math_modes_of_list_mutator",I.Constants.Math.LIST_MODES_MUTATOR_MIXIN,I.Constants.Math.LIST_MODES_MUTATOR_EXTENSION),I.Blocks.procedures={},I.Blocks.procedures_defnoreturn={init:function(){var t=I.Procedures.findLegalName("",this),t;(t=new I.FieldTextInput(t,I.Procedures.rename)).setSpellcheck(!1),this.appendDummyInput().appendField(I.Msg.PROCEDURES_DEFNORETURN_TITLE).appendField(t,"NAME").appendField("","PARAMS"),this.setMutator(new I.Mutator(["procedures_mutatorarg"])),(this.workspace.options.comments||this.workspace.options.parentWorkspace&&this.workspace.options.parentWorkspace.options.comments)&&I.Msg.PROCEDURES_DEFNORETURN_COMMENT&&this.setCommentText(I.Msg.PROCEDURES_DEFNORETURN_COMMENT),this.setStyle("procedure_blocks"),this.setTooltip(I.Msg.PROCEDURES_DEFNORETURN_TOOLTIP),this.setHelpUrl(I.Msg.PROCEDURES_DEFNORETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.setStatements_(!0),this.statementConnection_=null},setStatements_:function(t){this.hasStatements_!==t&&(t?(this.appendStatementInput("STACK").appendField(I.Msg.PROCEDURES_DEFNORETURN_DO),this.getInput("RETURN")&&this.moveInputBefore("STACK","RETURN")):this.removeInput("STACK",!0),this.hasStatements_=t)},updateParams_:function(){var t="";this.arguments_.length&&(t=I.Msg.PROCEDURES_BEFORE_PARAMS+" "+this.arguments_.join(", ")),I.Events.disable();try{this.setFieldValue(t,"PARAMS")}finally{I.Events.enable()}},mutationToDom:function(t){var e=I.utils.xml.createElement("mutation");t&&e.setAttribute("name",this.getFieldValue("NAME"));for(var o=0;o<this.argumentVarModels_.length;o++){var i=I.utils.xml.createElement("arg"),s=this.argumentVarModels_[o];i.setAttribute("name",s.name),i.setAttribute("varid",s.getId()),t&&this.paramIds_&&i.setAttribute("paramId",this.paramIds_[o]),e.appendChild(i)}return this.hasStatements_||e.setAttribute("statements","false"),e},domToMutation:function(t){this.arguments_=[],this.argumentVarModels_=[];for(var e=0,o,i,o;o=t.childNodes[e];e++){"arg"==o.nodeName.toLowerCase()&&(i=o.getAttribute("name"),o=o.getAttribute("varid")||o.getAttribute("varId"),this.arguments_.push(i),null!=(o=I.Variables.getOrCreateVariablePackage(this.workspace,o,i,""))?this.argumentVarModels_.push(o):console.log("Failed to create a variable with name "+i+", ignoring."))}this.updateParams_(),I.Procedures.mutateCallers(this),this.setStatements_("false"!==t.getAttribute("statements"))},decompose:function(t){var e=I.utils.xml.createElement("block");e.setAttribute("type","procedures_mutatorcontainer");var o=I.utils.xml.createElement("statement");o.setAttribute("name","STACK"),e.appendChild(o);for(var i=0;i<this.arguments_.length;i++){var s=I.utils.xml.createElement("block");s.setAttribute("type","procedures_mutatorarg");var n=I.utils.xml.createElement("field");n.setAttribute("name","NAME");var r=I.utils.xml.createTextNode(this.arguments_[i]);n.appendChild(r),s.appendChild(n),n=I.utils.xml.createElement("next"),s.appendChild(n),o.appendChild(s),o=n}return t=I.Xml.domToBlock(e,t),"procedures_defreturn"==this.type?t.setFieldValue(this.hasStatements_,"STATEMENTS"):t.removeInput("STATEMENT_INPUT"),I.Procedures.mutateCallers(this),t},compose:function(t){this.arguments_=[],this.paramIds_=[],this.argumentVarModels_=[];for(var e=t.getInputTargetBlock("STACK");e&&!e.isInsertionMarker();){var o=e.getFieldValue("NAME");this.arguments_.push(o),o=this.workspace.getVariable(o,""),this.argumentVarModels_.push(o),this.paramIds_.push(e.id),e=e.nextConnection&&e.nextConnection.targetBlock()}this.updateParams_(),I.Procedures.mutateCallers(this),null!==(t=t.getFieldValue("STATEMENTS"))&&this.hasStatements_!=(t="TRUE"==t)&&(t?(this.setStatements_(!0),I.Mutator.reconnect(this.statementConnection_,this,"STACK"),this.statementConnection_=null):(t=this.getInput("STACK").connection,(this.statementConnection_=t.targetConnection)&&((t=t.targetBlock()).unplug(),t.bumpNeighbours()),this.setStatements_(!1)))},getProcedureDef:function(){return[this.getFieldValue("NAME"),this.arguments_,!1]},getVars:function(){return this.arguments_},getVarModels:function(){return this.argumentVarModels_},renameVarById:function(t,e){var o=this.workspace.getVariableById(t);if(""==o.type){o=o.name,e=this.workspace.getVariableById(e);for(var i=!1,s=0;s<this.argumentVarModels_.length;s++)this.argumentVarModels_[s].getId()==t&&(this.arguments_[s]=e.name,this.argumentVarModels_[s]=e,i=!0);i&&(this.displayRenamedVar_(o,e.name),I.Procedures.mutateCallers(this))}},updateVarName:function(t){for(var e=t.name,o=!1,i=0,s;i<this.argumentVarModels_.length;i++){this.argumentVarModels_[i].getId()==t.getId()&&(s=this.arguments_[i],this.arguments_[i]=e,o=!0)}o&&(this.displayRenamedVar_(s,e),I.Procedures.mutateCallers(this))},displayRenamedVar_:function(t,e){if(this.updateParams_(),this.mutator&&this.mutator.isVisible())for(var o=this.mutator.workspace_.getAllBlocks(!1),i=0,s;s=o[i];i++)"procedures_mutatorarg"==s.type&&I.Names.equals(t,s.getFieldValue("NAME"))&&s.setFieldValue(e,"NAME")},customContextMenu:function(t){if(!this.isInFlyout){var e={enabled:!0},o=this.getFieldValue("NAME");e.text=I.Msg.PROCEDURES_CREATE_DO.replace("%1",o);var i=I.utils.xml.createElement("mutation");for(i.setAttribute("name",o),o=0;o<this.arguments_.length;o++){var s=I.utils.xml.createElement("arg");s.setAttribute("name",this.arguments_[o]),i.appendChild(s)}if((o=I.utils.xml.createElement("block")).setAttribute("type",this.callType_),o.appendChild(i),e.callback=I.ContextMenu.callbackFactory(this,o),t.push(e),!this.isCollapsed())for(o=0;o<this.argumentVarModels_.length;o++)i=this.argumentVarModels_[o],(e={enabled:!0}).text=I.Msg.VARIABLES_SET_CREATE_GET.replace("%1",i.name),i=I.Variables.generateVariableFieldDom(i),(s=I.utils.xml.createElement("block")).setAttribute("type","variables_get"),s.appendChild(i),e.callback=I.ContextMenu.callbackFactory(this,s),t.push(e)}},callType_:"procedures_callnoreturn"},I.Blocks.procedures_defreturn={init:function(){var t=I.Procedures.findLegalName("",this),t;(t=new I.FieldTextInput(t,I.Procedures.rename)).setSpellcheck(!1),this.appendDummyInput().appendField(I.Msg.PROCEDURES_DEFRETURN_TITLE).appendField(t,"NAME").appendField("","PARAMS"),this.appendValueInput("RETURN").setAlign(I.ALIGN_RIGHT).appendField(I.Msg.PROCEDURES_DEFRETURN_RETURN),this.setMutator(new I.Mutator(["procedures_mutatorarg"])),(this.workspace.options.comments||this.workspace.options.parentWorkspace&&this.workspace.options.parentWorkspace.options.comments)&&I.Msg.PROCEDURES_DEFRETURN_COMMENT&&this.setCommentText(I.Msg.PROCEDURES_DEFRETURN_COMMENT),this.setStyle("procedure_blocks"),this.setTooltip(I.Msg.PROCEDURES_DEFRETURN_TOOLTIP),this.setHelpUrl(I.Msg.PROCEDURES_DEFRETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.setStatements_(!0),this.statementConnection_=null},setStatements_:I.Blocks.procedures_defnoreturn.setStatements_,updateParams_:I.Blocks.procedures_defnoreturn.updateParams_,mutationToDom:I.Blocks.procedures_defnoreturn.mutationToDom,domToMutation:I.Blocks.procedures_defnoreturn.domToMutation,decompose:I.Blocks.procedures_defnoreturn.decompose,compose:I.Blocks.procedures_defnoreturn.compose,getProcedureDef:function(){return[this.getFieldValue("NAME"),this.arguments_,!0]},getVars:I.Blocks.procedures_defnoreturn.getVars,getVarModels:I.Blocks.procedures_defnoreturn.getVarModels,renameVarById:I.Blocks.procedures_defnoreturn.renameVarById,updateVarName:I.Blocks.procedures_defnoreturn.updateVarName,displayRenamedVar_:I.Blocks.procedures_defnoreturn.displayRenamedVar_,customContextMenu:I.Blocks.procedures_defnoreturn.customContextMenu,callType_:"procedures_callreturn"},I.Blocks.procedures_mutatorcontainer={init:function(){this.appendDummyInput().appendField(I.Msg.PROCEDURES_MUTATORCONTAINER_TITLE),this.appendStatementInput("STACK"),this.appendDummyInput("STATEMENT_INPUT").appendField(I.Msg.PROCEDURES_ALLOW_STATEMENTS).appendField(new I.FieldCheckbox("TRUE"),"STATEMENTS"),this.setStyle("procedure_blocks"),this.setTooltip(I.Msg.PROCEDURES_MUTATORCONTAINER_TOOLTIP),this.contextMenu=!1}},I.Blocks.procedures_mutatorarg={init:function(){var t=new I.FieldTextInput(I.Procedures.DEFAULT_ARG,this.validator_);t.oldShowEditorFn_=t.showEditor_,t.showEditor_=function(){this.createdVariables_=[],this.oldShowEditorFn_()},this.appendDummyInput().appendField(I.Msg.PROCEDURES_MUTATORARG_TITLE).appendField(t,"NAME"),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setTooltip(I.Msg.PROCEDURES_MUTATORARG_TOOLTIP),this.contextMenu=!1,t.onFinishEditing_=this.deleteIntermediateVars_,t.createdVariables_=[],t.onFinishEditing_("x")},validator_:function(t){var e=this.getSourceBlock(),o=I.Mutator.findParentWs(e.workspace);if(!(t=t.replace(/[\s\xa0]+/g," ").replace(/^ | $/g,"")))return null;for(var i=(e.workspace.targetWorkspace||e.workspace).getAllBlocks(!1),s=t.toLowerCase(),n=0;n<i.length;n++)if(i[n].id!=this.getSourceBlock().id){var r=i[n].getFieldValue("NAME");if(r&&r.toLowerCase()==s)return null}if(e.isInFlyout)return t;return(e=o.getVariable(t,""))&&e.name!=t&&o.renameVariableById(e.getId(),t),e||(e=o.createVariable(t,""))&&this.createdVariables_&&this.createdVariables_.push(e),t},deleteIntermediateVars_:function(t){var e=I.Mutator.findParentWs(this.getSourceBlock().workspace);if(e)for(var o=0;o<this.createdVariables_.length;o++){var i=this.createdVariables_[o];i.name!=t&&e.deleteVariableById(i.getId())}}},I.Blocks.procedures_callnoreturn={init:function(){this.appendDummyInput("TOPROW").appendField("","NAME"),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setHelpUrl(I.Msg.PROCEDURES_CALLNORETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.quarkConnections_={},this.quarkIds_=null,this.previousEnabledState_=!0},getProcedureCall:function(){return this.getFieldValue("NAME")},renameProcedure:function(t,e){I.Names.equals(t,this.getProcedureCall())&&(this.setFieldValue(e,"NAME"),this.setTooltip((this.outputConnection?I.Msg.PROCEDURES_CALLRETURN_TOOLTIP:I.Msg.PROCEDURES_CALLNORETURN_TOOLTIP).replace("%1",e)))},setProcedureParameters_:function(t,e){var o=I.Procedures.getDefinition(this.getProcedureCall(),this.workspace),i=o&&o.mutator&&o.mutator.isVisible();if(i||(this.quarkConnections_={},this.quarkIds_=null),e)if(t.join("\n")==this.arguments_.join("\n"))this.quarkIds_=e;else{if(e.length!=t.length)throw RangeError("paramNames and paramIds must be the same length.");this.setCollapsed(!1),this.quarkIds_||(this.quarkConnections_={},this.quarkIds_=[]),o=this.rendered,this.rendered=!1;for(var s=0;s<this.arguments_.length;s++){var n=this.getInput("ARG"+s);n&&(n=n.connection.targetConnection,this.quarkConnections_[this.quarkIds_[s]]=n,i&&n&&-1==e.indexOf(this.quarkIds_[s])&&(n.disconnect(),n.getSourceBlock().bumpNeighbours()))}for(this.arguments_=[].concat(t),this.argumentVarModels_=[],s=0;s<this.arguments_.length;s++)t=I.Variables.getOrCreateVariablePackage(this.workspace,null,this.arguments_[s],""),this.argumentVarModels_.push(t);if(this.updateShape_(),this.quarkIds_=e)for(s=0;s<this.arguments_.length;s++)(e=this.quarkIds_[s])in this.quarkConnections_&&(n=this.quarkConnections_[e],I.Mutator.reconnect(n,this,"ARG"+s)||delete this.quarkConnections_[e]);(this.rendered=o)&&this.render()}},updateShape_:function(){for(var t=0;t<this.arguments_.length;t++){var e=this.getField("ARGNAME"+t);if(e){I.Events.disable();try{e.setValue(this.arguments_[t])}finally{I.Events.enable()}}else e=new I.FieldLabel(this.arguments_[t]),this.appendValueInput("ARG"+t).setAlign(I.ALIGN_RIGHT).appendField(e,"ARGNAME"+t).init()}for(;this.getInput("ARG"+t);)this.removeInput("ARG"+t),t++;(t=this.getInput("TOPROW"))&&(this.arguments_.length?this.getField("WITH")||(t.appendField(I.Msg.PROCEDURES_CALL_BEFORE_PARAMS,"WITH"),t.init()):this.getField("WITH")&&t.removeField("WITH"))},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");t.setAttribute("name",this.getProcedureCall());for(var e=0;e<this.arguments_.length;e++){var o=I.utils.xml.createElement("arg");o.setAttribute("name",this.arguments_[e]),t.appendChild(o)}return t},domToMutation:function(t){var e=t.getAttribute("name");this.renameProcedure(this.getProcedureCall(),e);for(var e=[],o=[],i=0,s;s=t.childNodes[i];i++)"arg"==s.nodeName.toLowerCase()&&(e.push(s.getAttribute("name")),o.push(s.getAttribute("paramId")));this.setProcedureParameters_(e,o)},getVars:function(){return this.arguments_},getVarModels:function(){return this.argumentVarModels_},onchange:function(t){var e,o,i,e;this.workspace&&!this.workspace.isFlyout&&t.recordUndo&&(t.type==I.Events.BLOCK_CREATE&&-1!=t.ids.indexOf(this.id)?(e=this.getProcedureCall(),(e=(e=I.Procedures.getDefinition(e,this.workspace))&&(e.type!=this.defType_||JSON.stringify(e.getVars())!=JSON.stringify(this.arguments_))?null:e)||(I.Events.setGroup(t.group),t=I.utils.xml.createElement("xml"),(e=I.utils.xml.createElement("block")).setAttribute("type",this.defType_),i=(o=this.getRelativeToSurfaceXY()).y+2*I.SNAP_RADIUS,e.setAttribute("x",o.x+I.SNAP_RADIUS*(this.RTL?-1:1)),e.setAttribute("y",i),o=this.mutationToDom(),e.appendChild(o),(o=I.utils.xml.createElement("field")).setAttribute("name","NAME"),(i=this.getProcedureCall())||(i=I.Procedures.findLegalName("",this),this.renameProcedure("",i)),o.appendChild(I.utils.xml.createTextNode(i)),e.appendChild(o),t.appendChild(e),I.Xml.domToWorkspace(t,this.workspace),I.Events.setGroup(!1))):t.type==I.Events.BLOCK_DELETE?(e=this.getProcedureCall(),(e=I.Procedures.getDefinition(e,this.workspace))||(I.Events.setGroup(t.group),this.dispose(!0),I.Events.setGroup(!1))):t.type==I.Events.CHANGE&&"disabled"==t.element&&(e=this.getProcedureCall(),(e=I.Procedures.getDefinition(e,this.workspace))&&e.id==t.blockId&&((e=I.Events.getGroup())&&console.log("Saw an existing group while responding to a definition change"),I.Events.setGroup(t.group),t.newValue?(this.previousEnabledState_=this.isEnabled(),this.setEnabled(!1)):this.setEnabled(this.previousEnabledState_),I.Events.setGroup(e))))},customContextMenu:function(t){var e,o,i;this.workspace.isMovable()&&((e={enabled:!0}).text=I.Msg.PROCEDURES_HIGHLIGHT_DEF,o=this.getProcedureCall(),i=this.workspace,e.callback=function(){var t=I.Procedures.getDefinition(o,i);t&&(i.centerOnBlock(t.id),t.select())},t.push(e))},defType_:"procedures_defnoreturn"},I.Blocks.procedures_callreturn={init:function(){this.appendDummyInput("TOPROW").appendField("","NAME"),this.setOutput(!0),this.setStyle("procedure_blocks"),this.setHelpUrl(I.Msg.PROCEDURES_CALLRETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.quarkConnections_={},this.quarkIds_=null,this.previousEnabledState_=!0},getProcedureCall:I.Blocks.procedures_callnoreturn.getProcedureCall,renameProcedure:I.Blocks.procedures_callnoreturn.renameProcedure,setProcedureParameters_:I.Blocks.procedures_callnoreturn.setProcedureParameters_,updateShape_:I.Blocks.procedures_callnoreturn.updateShape_,mutationToDom:I.Blocks.procedures_callnoreturn.mutationToDom,domToMutation:I.Blocks.procedures_callnoreturn.domToMutation,getVars:I.Blocks.procedures_callnoreturn.getVars,getVarModels:I.Blocks.procedures_callnoreturn.getVarModels,onchange:I.Blocks.procedures_callnoreturn.onchange,customContextMenu:I.Blocks.procedures_callnoreturn.customContextMenu,defType_:"procedures_defreturn"},I.Blocks.procedures_ifreturn={init:function(){this.appendValueInput("CONDITION").setCheck("Boolean").appendField(I.Msg.CONTROLS_IF_MSG_IF),this.appendValueInput("VALUE").appendField(I.Msg.PROCEDURES_DEFRETURN_RETURN),this.setInputsInline(!0),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setTooltip(I.Msg.PROCEDURES_IFRETURN_TOOLTIP),this.setHelpUrl(I.Msg.PROCEDURES_IFRETURN_HELPURL),this.hasReturnValue_=!0},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("value",Number(this.hasReturnValue_)),t},domToMutation:function(t){this.hasReturnValue_=1==t.getAttribute("value"),this.hasReturnValue_||(this.removeInput("VALUE"),this.appendDummyInput("VALUE").appendField(I.Msg.PROCEDURES_DEFRETURN_RETURN))},onchange:function(t){if(this.workspace.isDragging&&!this.workspace.isDragging()){t=!1;var e=this;do{if(-1!=this.FUNCTION_TYPES.indexOf(e.type)){t=!0;break}e=e.getSurroundParent()}while(e);t?("procedures_defnoreturn"==e.type&&this.hasReturnValue_?(this.removeInput("VALUE"),this.appendDummyInput("VALUE").appendField(I.Msg.PROCEDURES_DEFRETURN_RETURN),this.hasReturnValue_=!1):"procedures_defreturn"!=e.type||this.hasReturnValue_||(this.removeInput("VALUE"),this.appendValueInput("VALUE").appendField(I.Msg.PROCEDURES_DEFRETURN_RETURN),this.hasReturnValue_=!0),this.setWarningText(null),this.isInFlyout||this.setEnabled(!0)):(this.setWarningText(I.Msg.PROCEDURES_IFRETURN_WARNING),this.isInFlyout||this.getInheritedDisabled()||this.setEnabled(!1))}},FUNCTION_TYPES:["procedures_defnoreturn","procedures_defreturn"]},I.Blocks.texts={},I.Constants.Text={},I.Constants.Text.HUE=160,I.defineBlocksWithJsonArray([{type:"text",message0:"%1",args0:[{type:"field_input",name:"TEXT",text:""}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_TEXT_HELPURL}",tooltip:"%{BKY_TEXT_TEXT_TOOLTIP}",extensions:["text_quotes","parent_tooltip_when_inline"]},{type:"text_multiline",message0:"%1 %2",args0:[{type:"field_image",src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAARCAYAAADpPU2iAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAdhgAAHYYBXaITgQAAABh0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMS42/U4J6AAAAP1JREFUOE+Vks0KQUEYhjmRIja4ABtZ2dm5A3t3Ia6AUm7CylYuQRaUhZSlLZJiQbFAyRnPN33y01HOW08z8873zpwzM4F3GWOCruvGIE4/rLaV+Nq1hVGMBqzhqlxgCys4wJA65xnogMHsQ5lujnYHTejBBCK2mE4abjCgMGhNxHgDFWjDSG07kdfVa2pZMf4ZyMAdWmpZMfYOsLiDMYMjlMB+K613QISRhTnITnsYg5yUd0DETmEoMlkFOeIT/A58iyK5E18BuTBfgYXfwNJv4P9/oEBerLylOnRhygmGdPpTTBZAPkde61lbQe4moWUvYUZYLfUNftIY4zwA5X2Z9AYnQrEAAAAASUVORK5CYII=",width:12,height:17,alt:"¶"},{type:"field_multilinetext",name:"TEXT",text:""}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_TEXT_HELPURL}",tooltip:"%{BKY_TEXT_TEXT_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"text_join",message0:"",output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_JOIN_HELPURL}",tooltip:"%{BKY_TEXT_JOIN_TOOLTIP}",mutator:"text_join_mutator"},{type:"text_create_join_container",message0:"%{BKY_TEXT_CREATE_JOIN_TITLE_JOIN} %1 %2",args0:[{type:"input_dummy"},{type:"input_statement",name:"STACK"}],style:"text_blocks",tooltip:"%{BKY_TEXT_CREATE_JOIN_TOOLTIP}",enableContextMenu:!1},{type:"text_create_join_item",message0:"%{BKY_TEXT_CREATE_JOIN_ITEM_TITLE_ITEM}",previousStatement:null,nextStatement:null,style:"text_blocks",tooltip:"%{BKY_TEXT_CREATE_JOIN_ITEM_TOOLTIP}",enableContextMenu:!1},{type:"text_append",message0:"%{BKY_TEXT_APPEND_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_TEXT_APPEND_VARIABLE}"},{type:"input_value",name:"TEXT"}],previousStatement:null,nextStatement:null,style:"text_blocks",extensions:["text_append_tooltip"]},{type:"text_length",message0:"%{BKY_TEXT_LENGTH_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Number",style:"text_blocks",tooltip:"%{BKY_TEXT_LENGTH_TOOLTIP}",helpUrl:"%{BKY_TEXT_LENGTH_HELPURL}"},{type:"text_isEmpty",message0:"%{BKY_TEXT_ISEMPTY_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Boolean",style:"text_blocks",tooltip:"%{BKY_TEXT_ISEMPTY_TOOLTIP}",helpUrl:"%{BKY_TEXT_ISEMPTY_HELPURL}"},{type:"text_indexOf",message0:"%{BKY_TEXT_INDEXOF_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"String"},{type:"field_dropdown",name:"END",options:[["%{BKY_TEXT_INDEXOF_OPERATOR_FIRST}","FIRST"],["%{BKY_TEXT_INDEXOF_OPERATOR_LAST}","LAST"]]},{type:"input_value",name:"FIND",check:"String"}],output:"Number",style:"text_blocks",helpUrl:"%{BKY_TEXT_INDEXOF_HELPURL}",inputsInline:!0,extensions:["text_indexOf_tooltip"]},{type:"text_charAt",message0:"%{BKY_TEXT_CHARAT_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"String"},{type:"field_dropdown",name:"WHERE",options:[["%{BKY_TEXT_CHARAT_FROM_START}","FROM_START"],["%{BKY_TEXT_CHARAT_FROM_END}","FROM_END"],["%{BKY_TEXT_CHARAT_FIRST}","FIRST"],["%{BKY_TEXT_CHARAT_LAST}","LAST"],["%{BKY_TEXT_CHARAT_RANDOM}","RANDOM"]]}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_CHARAT_HELPURL}",inputsInline:!0,mutator:"text_charAt_mutator"}]),I.Blocks.text_getSubstring={init:function(){this.WHERE_OPTIONS_1=[[I.Msg.TEXT_GET_SUBSTRING_START_FROM_START,"FROM_START"],[I.Msg.TEXT_GET_SUBSTRING_START_FROM_END,"FROM_END"],[I.Msg.TEXT_GET_SUBSTRING_START_FIRST,"FIRST"]],this.WHERE_OPTIONS_2=[[I.Msg.TEXT_GET_SUBSTRING_END_FROM_START,"FROM_START"],[I.Msg.TEXT_GET_SUBSTRING_END_FROM_END,"FROM_END"],[I.Msg.TEXT_GET_SUBSTRING_END_LAST,"LAST"]],this.setHelpUrl(I.Msg.TEXT_GET_SUBSTRING_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("STRING").setCheck("String").appendField(I.Msg.TEXT_GET_SUBSTRING_INPUT_IN_TEXT),this.appendDummyInput("AT1"),this.appendDummyInput("AT2"),I.Msg.TEXT_GET_SUBSTRING_TAIL&&this.appendDummyInput("TAIL").appendField(I.Msg.TEXT_GET_SUBSTRING_TAIL),this.setInputsInline(!0),this.setOutput(!0,"String"),this.updateAt_(1,!0),this.updateAt_(2,!0),this.setTooltip(I.Msg.TEXT_GET_SUBSTRING_TOOLTIP)},mutationToDom:function(){var t=I.utils.xml.createElement("mutation"),e=this.getInput("AT1").type==I.INPUT_VALUE;return t.setAttribute("at1",e),e=this.getInput("AT2").type==I.INPUT_VALUE,t.setAttribute("at2",e),t},domToMutation:function(t){var e="true"==t.getAttribute("at1");t="true"==t.getAttribute("at2"),this.updateAt_(1,e),this.updateAt_(2,t)},updateAt_:function(i,s){this.removeInput("AT"+i),this.removeInput("ORDINAL"+i,!0),s?(this.appendValueInput("AT"+i).setCheck("Number"),I.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL"+i).appendField(I.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT"+i),2==i&&I.Msg.TEXT_GET_SUBSTRING_TAIL&&(this.removeInput("TAIL",!0),this.appendDummyInput("TAIL").appendField(I.Msg.TEXT_GET_SUBSTRING_TAIL));var t=new I.FieldDropdown(this["WHERE_OPTIONS_"+i],function(t){var e="FROM_START"==t||"FROM_END"==t;if(e!=s){var o=this.getSourceBlock();return o.updateAt_(i,e),o.setFieldValue(t,"WHERE"+i),null}});this.getInput("AT"+i).appendField(t,"WHERE"+i),1==i&&(this.moveInputBefore("AT1","AT2"),this.getInput("ORDINAL1")&&this.moveInputBefore("ORDINAL1","AT2"))}},I.Blocks.text_changeCase={init:function(){var t=[[I.Msg.TEXT_CHANGECASE_OPERATOR_UPPERCASE,"UPPERCASE"],[I.Msg.TEXT_CHANGECASE_OPERATOR_LOWERCASE,"LOWERCASE"],[I.Msg.TEXT_CHANGECASE_OPERATOR_TITLECASE,"TITLECASE"]];this.setHelpUrl(I.Msg.TEXT_CHANGECASE_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("TEXT").setCheck("String").appendField(new I.FieldDropdown(t),"CASE"),this.setOutput(!0,"String"),this.setTooltip(I.Msg.TEXT_CHANGECASE_TOOLTIP)}},I.Blocks.text_trim={init:function(){var t=[[I.Msg.TEXT_TRIM_OPERATOR_BOTH,"BOTH"],[I.Msg.TEXT_TRIM_OPERATOR_LEFT,"LEFT"],[I.Msg.TEXT_TRIM_OPERATOR_RIGHT,"RIGHT"]];this.setHelpUrl(I.Msg.TEXT_TRIM_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("TEXT").setCheck("String").appendField(new I.FieldDropdown(t),"MODE"),this.setOutput(!0,"String"),this.setTooltip(I.Msg.TEXT_TRIM_TOOLTIP)}},I.Blocks.text_print={init:function(){this.jsonInit({message0:I.Msg.TEXT_PRINT_TITLE,args0:[{type:"input_value",name:"TEXT"}],previousStatement:null,nextStatement:null,style:"text_blocks",tooltip:I.Msg.TEXT_PRINT_TOOLTIP,helpUrl:I.Msg.TEXT_PRINT_HELPURL})}},I.Blocks.text_prompt_ext={init:function(){var t=[[I.Msg.TEXT_PROMPT_TYPE_TEXT,"TEXT"],[I.Msg.TEXT_PROMPT_TYPE_NUMBER,"NUMBER"]];this.setHelpUrl(I.Msg.TEXT_PROMPT_HELPURL),this.setStyle("text_blocks");var e=this,t=new I.FieldDropdown(t,function(t){e.updateType_(t)});this.appendValueInput("TEXT").appendField(t,"TYPE"),this.setOutput(!0,"String"),this.setTooltip(function(){return"TEXT"==e.getFieldValue("TYPE")?I.Msg.TEXT_PROMPT_TOOLTIP_TEXT:I.Msg.TEXT_PROMPT_TOOLTIP_NUMBER})},updateType_:function(t){this.outputConnection.setCheck("NUMBER"==t?"Number":"String")},mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("type",this.getFieldValue("TYPE")),t},domToMutation:function(t){this.updateType_(t.getAttribute("type"))}},I.Blocks.text_prompt={init:function(){this.mixin(I.Constants.Text.QUOTE_IMAGE_MIXIN);var t=[[I.Msg.TEXT_PROMPT_TYPE_TEXT,"TEXT"],[I.Msg.TEXT_PROMPT_TYPE_NUMBER,"NUMBER"]],e=this;this.setHelpUrl(I.Msg.TEXT_PROMPT_HELPURL),this.setStyle("text_blocks"),t=new I.FieldDropdown(t,function(t){e.updateType_(t)}),this.appendDummyInput().appendField(t,"TYPE").appendField(this.newQuote_(!0)).appendField(new I.FieldTextInput(""),"TEXT").appendField(this.newQuote_(!1)),this.setOutput(!0,"String"),this.setTooltip(function(){return"TEXT"==e.getFieldValue("TYPE")?I.Msg.TEXT_PROMPT_TOOLTIP_TEXT:I.Msg.TEXT_PROMPT_TOOLTIP_NUMBER})},updateType_:I.Blocks.text_prompt_ext.updateType_,mutationToDom:I.Blocks.text_prompt_ext.mutationToDom,domToMutation:I.Blocks.text_prompt_ext.domToMutation},I.Blocks.text_count={init:function(){this.jsonInit({message0:I.Msg.TEXT_COUNT_MESSAGE0,args0:[{type:"input_value",name:"SUB",check:"String"},{type:"input_value",name:"TEXT",check:"String"}],output:"Number",inputsInline:!0,style:"text_blocks",tooltip:I.Msg.TEXT_COUNT_TOOLTIP,helpUrl:I.Msg.TEXT_COUNT_HELPURL})}},I.Blocks.text_replace={init:function(){this.jsonInit({message0:I.Msg.TEXT_REPLACE_MESSAGE0,args0:[{type:"input_value",name:"FROM",check:"String"},{type:"input_value",name:"TO",check:"String"},{type:"input_value",name:"TEXT",check:"String"}],output:"String",inputsInline:!0,style:"text_blocks",tooltip:I.Msg.TEXT_REPLACE_TOOLTIP,helpUrl:I.Msg.TEXT_REPLACE_HELPURL})}},I.Blocks.text_reverse={init:function(){this.jsonInit({message0:I.Msg.TEXT_REVERSE_MESSAGE0,args0:[{type:"input_value",name:"TEXT",check:"String"}],output:"String",inputsInline:!0,style:"text_blocks",tooltip:I.Msg.TEXT_REVERSE_TOOLTIP,helpUrl:I.Msg.TEXT_REVERSE_HELPURL})}},I.Constants.Text.QUOTE_IMAGE_MIXIN={QUOTE_IMAGE_LEFT_DATAURI:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAKCAQAAAAqJXdxAAAAn0lEQVQI1z3OMa5BURSF4f/cQhAKjUQhuQmFNwGJEUi0RKN5rU7FHKhpjEH3TEMtkdBSCY1EIv8r7nFX9e29V7EBAOvu7RPjwmWGH/VuF8CyN9/OAdvqIXYLvtRaNjx9mMTDyo+NjAN1HNcl9ZQ5oQMM3dgDUqDo1l8DzvwmtZN7mnD+PkmLa+4mhrxVA9fRowBWmVBhFy5gYEjKMfz9AylsaRRgGzvZAAAAAElFTkSuQmCC",QUOTE_IMAGE_RIGHT_DATAURI:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAKCAQAAAAqJXdxAAAAqUlEQVQI1z3KvUpCcRiA8ef9E4JNHhI0aFEacm1o0BsI0Slx8wa8gLauoDnoBhq7DcfWhggONDmJJgqCPA7neJ7p934EOOKOnM8Q7PDElo/4x4lFb2DmuUjcUzS3URnGib9qaPNbuXvBO3sGPHJDRG6fGVdMSeWDP2q99FQdFrz26Gu5Tq7dFMzUvbXy8KXeAj57cOklgA+u1B5AoslLtGIHQMaCVnwDnADZIFIrXsoXrgAAAABJRU5ErkJggg==",QUOTE_IMAGE_WIDTH:12,QUOTE_IMAGE_HEIGHT:12,quoteField_:function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)if(t==s.name)return o.insertFieldAt(i,this.newQuote_(!0)),void o.insertFieldAt(i+2,this.newQuote_(!1));console.warn('field named "'+t+'" not found in '+this.toDevString())},newQuote_:function(t){return t=this.RTL?!t:t,new I.FieldImage(t?this.QUOTE_IMAGE_LEFT_DATAURI:this.QUOTE_IMAGE_RIGHT_DATAURI,this.QUOTE_IMAGE_WIDTH,this.QUOTE_IMAGE_HEIGHT,t?"“":"”")}},I.Constants.Text.TEXT_QUOTES_EXTENSION=function(){this.mixin(I.Constants.Text.QUOTE_IMAGE_MIXIN),this.quoteField_("TEXT")},I.Constants.Text.TEXT_JOIN_MUTATOR_MIXIN={mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("items",this.itemCount_),t},domToMutation:function(t){this.itemCount_=parseInt(t.getAttribute("items"),10),this.updateShape_()},decompose:function(t){var e=t.newBlock("text_create_join_container");e.initSvg();for(var o=e.getInput("STACK").connection,i=0;i<this.itemCount_;i++){var s=t.newBlock("text_create_join_item");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return e},compose:function(t){var e=t.getInputTargetBlock("STACK");for(t=[];e&&!e.isInsertionMarker();)t.push(e.valueConnection_),e=e.nextConnection&&e.nextConnection.targetBlock();for(e=0;e<this.itemCount_;e++){var o=this.getInput("ADD"+e).connection.targetConnection;o&&-1==t.indexOf(o)&&o.disconnect()}for(this.itemCount_=t.length,this.updateShape_(),e=0;e<this.itemCount_;e++)I.Mutator.reconnect(t[e],this,"ADD"+e)},saveConnections:function(t){t=t.getInputTargetBlock("STACK");for(var e=0;t;){var o=this.getInput("ADD"+e);t.valueConnection_=o&&o.connection.targetConnection,e++,t=t.nextConnection&&t.nextConnection.targetBlock()}},updateShape_:function(){this.itemCount_&&this.getInput("EMPTY")?this.removeInput("EMPTY"):this.itemCount_||this.getInput("EMPTY")||this.appendDummyInput("EMPTY").appendField(this.newQuote_(!0)).appendField(this.newQuote_(!1));for(var t=0,e;t<this.itemCount_;t++){this.getInput("ADD"+t)||(e=this.appendValueInput("ADD"+t).setAlign(I.ALIGN_RIGHT),0==t&&e.appendField(I.Msg.TEXT_JOIN_TITLE_CREATEWITH))}for(;this.getInput("ADD"+t);)this.removeInput("ADD"+t),t++}},I.Constants.Text.TEXT_JOIN_EXTENSION=function(){this.mixin(I.Constants.Text.QUOTE_IMAGE_MIXIN),this.itemCount_=2,this.updateShape_(),this.setMutator(new I.Mutator(["text_create_join_item"]))},I.Extensions.register("text_append_tooltip",I.Extensions.buildTooltipWithFieldText("%{BKY_TEXT_APPEND_TOOLTIP}","VAR")),I.Constants.Text.TEXT_INDEXOF_TOOLTIP_EXTENSION=function(){var t=this;this.setTooltip(function(){return I.Msg.TEXT_INDEXOF_TOOLTIP.replace("%1",t.workspace.options.oneBasedIndex?"0":"-1")})},I.Constants.Text.TEXT_CHARAT_MUTATOR_MIXIN={mutationToDom:function(){var t=I.utils.xml.createElement("mutation");return t.setAttribute("at",!!this.isAt_),t},domToMutation:function(t){t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateAt_:function(t){this.removeInput("AT",!0),this.removeInput("ORDINAL",!0),t&&(this.appendValueInput("AT").setCheck("Number"),I.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL").appendField(I.Msg.ORDINAL_NUMBER_SUFFIX)),I.Msg.TEXT_CHARAT_TAIL&&(this.removeInput("TAIL",!0),this.appendDummyInput("TAIL").appendField(I.Msg.TEXT_CHARAT_TAIL)),this.isAt_=t}},I.Constants.Text.TEXT_CHARAT_EXTENSION=function(){this.getField("WHERE").setValidator(function(t){(t="FROM_START"==t||"FROM_END"==t)!=this.isAt_&&this.getSourceBlock().updateAt_(t)}),this.updateAt_(!0);var o=this;this.setTooltip(function(){var t=o.getFieldValue("WHERE"),e=I.Msg.TEXT_CHARAT_TOOLTIP;return"FROM_START"!=t&&"FROM_END"!=t||!(t="FROM_START"==t?I.Msg.LISTS_INDEX_FROM_START_TOOLTIP:I.Msg.LISTS_INDEX_FROM_END_TOOLTIP)||(e+="  "+t.replace("%1",o.workspace.options.oneBasedIndex?"#1":"#0")),e})},I.Extensions.register("text_indexOf_tooltip",I.Constants.Text.TEXT_INDEXOF_TOOLTIP_EXTENSION),I.Extensions.register("text_quotes",I.Constants.Text.TEXT_QUOTES_EXTENSION),I.Extensions.registerMutator("text_join_mutator",I.Constants.Text.TEXT_JOIN_MUTATOR_MIXIN,I.Constants.Text.TEXT_JOIN_EXTENSION),I.Extensions.registerMutator("text_charAt_mutator",I.Constants.Text.TEXT_CHARAT_MUTATOR_MIXIN,I.Constants.Text.TEXT_CHARAT_EXTENSION),I.Blocks.variables={},I.Constants.Variables={},I.Constants.Variables.HUE=330,I.defineBlocksWithJsonArray([{type:"variables_get",message0:"%1",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"}],output:null,style:"variable_blocks",helpUrl:"%{BKY_VARIABLES_GET_HELPURL}",tooltip:"%{BKY_VARIABLES_GET_TOOLTIP}",extensions:["contextMenu_variableSetterGetter"]},{type:"variables_set",message0:"%{BKY_VARIABLES_SET}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"},{type:"input_value",name:"VALUE"}],previousStatement:null,nextStatement:null,style:"variable_blocks",tooltip:"%{BKY_VARIABLES_SET_TOOLTIP}",helpUrl:"%{BKY_VARIABLES_SET_HELPURL}",extensions:["contextMenu_variableSetterGetter"]}]),I.Constants.Variables.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN={customContextMenu:function(t){var e,o,o,i,s;this.isInFlyout?"variables_get"!=this.type&&"variables_get_reporter"!=this.type||(e={text:I.Msg.RENAME_VARIABLE,enabled:!0,callback:I.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY(this)},s=this.getField("VAR").getText(),i={text:I.Msg.DELETE_VARIABLE.replace("%1",s),enabled:!0,callback:I.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY(this)},t.unshift(e),t.unshift(i)):(o="variables_get"==this.type?(e="variables_set",I.Msg.VARIABLES_GET_CREATE_SET):(e="variables_get",I.Msg.VARIABLES_SET_CREATE_GET),i={enabled:0<this.workspace.remainingCapacity()},s=this.getField("VAR").getText(),i.text=o.replace("%1",s),(o=I.utils.xml.createElement("field")).setAttribute("name","VAR"),o.appendChild(I.utils.xml.createTextNode(s)),(s=I.utils.xml.createElement("block")).setAttribute("type",e),s.appendChild(o),i.callback=I.ContextMenu.callbackFactory(this,s),t.push(i))}},I.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();I.Variables.renameVariable(t,e)}},I.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();t.deleteVariableById(e.getId()),t.refreshToolboxSelection()}},I.Extensions.registerMixin("contextMenu_variableSetterGetter",I.Constants.Variables.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN),I.Constants.VariablesDynamic={},I.Constants.VariablesDynamic.HUE=310,I.defineBlocksWithJsonArray([{type:"variables_get_dynamic",message0:"%1",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"}],output:null,style:"variable_dynamic_blocks",helpUrl:"%{BKY_VARIABLES_GET_HELPURL}",tooltip:"%{BKY_VARIABLES_GET_TOOLTIP}",extensions:["contextMenu_variableDynamicSetterGetter"]},{type:"variables_set_dynamic",message0:"%{BKY_VARIABLES_SET}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"},{type:"input_value",name:"VALUE"}],previousStatement:null,nextStatement:null,style:"variable_dynamic_blocks",tooltip:"%{BKY_VARIABLES_SET_TOOLTIP}",helpUrl:"%{BKY_VARIABLES_SET_HELPURL}",extensions:["contextMenu_variableDynamicSetterGetter"]}]),I.Constants.VariablesDynamic.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN={customContextMenu:function(t){var e,o,e,i,i,s,n;this.isInFlyout?"variables_get_dynamic"!=this.type&&"variables_get_reporter_dynamic"!=this.type||(e={text:I.Msg.RENAME_VARIABLE,enabled:!0,callback:I.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY(this)},n=this.getField("VAR").getText(),s={text:I.Msg.DELETE_VARIABLE.replace("%1",n),enabled:!0,callback:I.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY(this)},t.unshift(e),t.unshift(s)):(e=this.getFieldValue("VAR"),o=this.workspace.getVariableById(e).type,i="variables_get_dynamic"==this.type?(e="variables_set_dynamic",I.Msg.VARIABLES_GET_CREATE_SET):(e="variables_get_dynamic",I.Msg.VARIABLES_SET_CREATE_GET),s={enabled:0<this.workspace.remainingCapacity()},n=this.getField("VAR").getText(),s.text=i.replace("%1",n),(i=I.utils.xml.createElement("field")).setAttribute("name","VAR"),i.setAttribute("variabletype",o),i.appendChild(I.utils.xml.createTextNode(n)),(n=I.utils.xml.createElement("block")).setAttribute("type",e),n.appendChild(i),s.callback=I.ContextMenu.callbackFactory(this,n),t.push(s))},onchange:function(t){t=this.getFieldValue("VAR"),t=I.Variables.getVariable(this.workspace,t),("variables_get_dynamic"==this.type?this.outputConnection:this.getInput("VALUE").connection).setCheck(t.type)}},I.Constants.VariablesDynamic.RENAME_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();I.Variables.renameVariable(t,e)}},I.Constants.VariablesDynamic.DELETE_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();t.deleteVariableById(e.getId()),t.refreshToolboxSelection()}},I.Extensions.registerMixin("contextMenu_variableDynamicSetterGetter",I.Constants.VariablesDynamic.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN),I.Msg["ADD_COMMENT"]="Add Comment",I.Msg["CANNOT_DELETE_VARIABLE_PROCEDURE"]="Can't delete the variable '%1' because it's part of the definition of the function '%2'",I.Msg["CHANGE_VALUE_TITLE"]="Change value:",I.Msg["CLEAN_UP"]="Clean up Blocks",I.Msg["COLLAPSED_WARNINGS_WARNING"]="Collapsed blocks contain warnings.",I.Msg["COLLAPSE_ALL"]="Collapse Blocks",I.Msg["COLLAPSE_BLOCK"]="Collapse Block",I.Msg["COLOUR_BLEND_COLOUR1"]="colour 1",I.Msg["COLOUR_BLEND_COLOUR2"]="colour 2",I.Msg["COLOUR_BLEND_HELPURL"]="https://meyerweb.com/eric/tools/color-blend/#:::rgbp",I.Msg["COLOUR_BLEND_RATIO"]="ratio",I.Msg["COLOUR_BLEND_TITLE"]="blend",I.Msg["COLOUR_BLEND_TOOLTIP"]="Blends two colours together with a given ratio (0.0 - 1.0).",I.Msg["COLOUR_PICKER_HELPURL"]="https://en.wikipedia.org/wiki/Color",I.Msg["COLOUR_PICKER_TOOLTIP"]="Choose a colour from the palette.",I.Msg["COLOUR_RANDOM_HELPURL"]="http://randomcolour.com",I.Msg["COLOUR_RANDOM_TITLE"]="random colour",I.Msg["COLOUR_RANDOM_TOOLTIP"]="Choose a colour at random.",I.Msg["COLOUR_RGB_BLUE"]="blue",I.Msg["COLOUR_RGB_GREEN"]="green",I.Msg["COLOUR_RGB_HELPURL"]="https://www.december.com/html/spec/colorpercompact.html",I.Msg["COLOUR_RGB_RED"]="red",I.Msg["COLOUR_RGB_TITLE"]="colour with",I.Msg["COLOUR_RGB_TOOLTIP"]="Create a colour with the specified amount of red, green, and blue. All values must be between 0 and 100.",I.Msg["CONTROLS_FLOW_STATEMENTS_HELPURL"]="https://github.com/google/blockly/wiki/Loops#loop-termination-blocks",I.Msg["CONTROLS_FLOW_STATEMENTS_OPERATOR_BREAK"]="break out of loop",I.Msg["CONTROLS_FLOW_STATEMENTS_OPERATOR_CONTINUE"]="continue with next iteration of loop",I.Msg["CONTROLS_FLOW_STATEMENTS_TOOLTIP_BREAK"]="Break out of the containing loop.",I.Msg["CONTROLS_FLOW_STATEMENTS_TOOLTIP_CONTINUE"]="Skip the rest of this loop, and continue with the next iteration.",I.Msg["CONTROLS_FLOW_STATEMENTS_WARNING"]="Warning: This block may only be used within a loop.",I.Msg["CONTROLS_FOREACH_HELPURL"]="https://github.com/google/blockly/wiki/Loops#for-each",I.Msg["CONTROLS_FOREACH_TITLE"]="for each item %1 in list %2",I.Msg["CONTROLS_FOREACH_TOOLTIP"]="For each item in a list, set the variable '%1' to the item, and then do some statements.",I.Msg["CONTROLS_FOR_HELPURL"]="https://github.com/google/blockly/wiki/Loops#count-with",I.Msg["CONTROLS_FOR_TITLE"]="count with %1 from %2 to %3 by %4",I.Msg["CONTROLS_FOR_TOOLTIP"]="Have the variable '%1' take on the values from the start number to the end number, counting by the specified interval, and do the specified blocks.",I.Msg["CONTROLS_IF_ELSEIF_TOOLTIP"]="Add a condition to the if block.",I.Msg["CONTROLS_IF_ELSE_TOOLTIP"]="Add a final, catch-all condition to the if block.",I.Msg["CONTROLS_IF_HELPURL"]="https://github.com/google/blockly/wiki/IfElse",I.Msg["CONTROLS_IF_IF_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this if block.",I.Msg["CONTROLS_IF_MSG_ELSE"]="else",I.Msg["CONTROLS_IF_MSG_ELSEIF"]="else if",I.Msg["CONTROLS_IF_MSG_IF"]="if",I.Msg["CONTROLS_IF_TOOLTIP_1"]="If a value is true, then do some statements.",I.Msg["CONTROLS_IF_TOOLTIP_2"]="If a value is true, then do the first block of statements. Otherwise, do the second block of statements.",I.Msg["CONTROLS_IF_TOOLTIP_3"]="If the first value is true, then do the first block of statements. Otherwise, if the second value is true, do the second block of statements.",I.Msg["CONTROLS_IF_TOOLTIP_4"]="If the first value is true, then do the first block of statements. Otherwise, if the second value is true, do the second block of statements. If none of the values are true, do the last block of statements.",I.Msg["CONTROLS_REPEAT_HELPURL"]="https://en.wikipedia.org/wiki/For_loop",I.Msg["CONTROLS_REPEAT_INPUT_DO"]="do",I.Msg["CONTROLS_REPEAT_TITLE"]="repeat %1 times",I.Msg["CONTROLS_REPEAT_TOOLTIP"]="Do some statements several times.",I.Msg["CONTROLS_WHILEUNTIL_HELPURL"]="https://github.com/google/blockly/wiki/Loops#repeat",I.Msg["CONTROLS_WHILEUNTIL_OPERATOR_UNTIL"]="repeat until",I.Msg["CONTROLS_WHILEUNTIL_OPERATOR_WHILE"]="repeat while",I.Msg["CONTROLS_WHILEUNTIL_TOOLTIP_UNTIL"]="While a value is false, then do some statements.",I.Msg["CONTROLS_WHILEUNTIL_TOOLTIP_WHILE"]="While a value is true, then do some statements.",I.Msg["DELETE_ALL_BLOCKS"]="Delete all %1 blocks?",I.Msg["DELETE_BLOCK"]="Delete Block",I.Msg["DELETE_VARIABLE"]="Delete the '%1' variable",I.Msg["DELETE_VARIABLE_CONFIRMATION"]="Delete %1 uses of the '%2' variable?",I.Msg["DELETE_X_BLOCKS"]="Delete %1 Blocks",I.Msg["DISABLE_BLOCK"]="Disable Block",I.Msg["DUPLICATE_BLOCK"]="Duplicate",I.Msg["DUPLICATE_COMMENT"]="Duplicate Comment",I.Msg["ENABLE_BLOCK"]="Enable Block",I.Msg["EXPAND_ALL"]="Expand Blocks",I.Msg["EXPAND_BLOCK"]="Expand Block",I.Msg["EXTERNAL_INPUTS"]="External Inputs",I.Msg["HELP"]="Help",I.Msg["INLINE_INPUTS"]="Inline Inputs",I.Msg["IOS_CANCEL"]="Cancel",I.Msg["IOS_ERROR"]="Error",I.Msg["IOS_OK"]="OK",I.Msg["IOS_PROCEDURES_ADD_INPUT"]="+ Add Input",I.Msg["IOS_PROCEDURES_ALLOW_STATEMENTS"]="Allow statements",I.Msg["IOS_PROCEDURES_DUPLICATE_INPUTS_ERROR"]="This function has duplicate inputs.",I.Msg["IOS_PROCEDURES_INPUTS"]="INPUTS",I.Msg["IOS_VARIABLES_ADD_BUTTON"]="Add",I.Msg["IOS_VARIABLES_ADD_VARIABLE"]="+ Add Variable",I.Msg["IOS_VARIABLES_DELETE_BUTTON"]="Delete",I.Msg["IOS_VARIABLES_EMPTY_NAME_ERROR"]="You can't use an empty variable name.",I.Msg["IOS_VARIABLES_RENAME_BUTTON"]="Rename",I.Msg["IOS_VARIABLES_VARIABLE_NAME"]="Variable name",I.Msg["LISTS_CREATE_EMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-empty-list",I.Msg["LISTS_CREATE_EMPTY_TITLE"]="create empty list",I.Msg["LISTS_CREATE_EMPTY_TOOLTIP"]="Returns a list, of length 0, containing no data records",I.Msg["LISTS_CREATE_WITH_CONTAINER_TITLE_ADD"]="list",I.Msg["LISTS_CREATE_WITH_CONTAINER_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this list block.",I.Msg["LISTS_CREATE_WITH_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-list-with",I.Msg["LISTS_CREATE_WITH_INPUT_WITH"]="create list with",I.Msg["LISTS_CREATE_WITH_ITEM_TOOLTIP"]="Add an item to the list.",I.Msg["LISTS_CREATE_WITH_TOOLTIP"]="Create a list with any number of items.",I.Msg["LISTS_GET_INDEX_FIRST"]="first",I.Msg["LISTS_GET_INDEX_FROM_END"]="# from end",I.Msg["LISTS_GET_INDEX_FROM_START"]="#",I.Msg["LISTS_GET_INDEX_GET"]="get",I.Msg["LISTS_GET_INDEX_GET_REMOVE"]="get and remove",I.Msg["LISTS_GET_INDEX_LAST"]="last",I.Msg["LISTS_GET_INDEX_RANDOM"]="random",I.Msg["LISTS_GET_INDEX_REMOVE"]="remove",I.Msg["LISTS_GET_INDEX_TAIL"]="",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_FIRST"]="Returns the first item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_FROM"]="Returns the item at the specified position in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_LAST"]="Returns the last item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_RANDOM"]="Returns a random item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FIRST"]="Removes and returns the first item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FROM"]="Removes and returns the item at the specified position in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_LAST"]="Removes and returns the last item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_RANDOM"]="Removes and returns a random item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_FIRST"]="Removes the first item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_FROM"]="Removes the item at the specified position in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_LAST"]="Removes the last item in a list.",I.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_RANDOM"]="Removes a random item in a list.",I.Msg["LISTS_GET_SUBLIST_END_FROM_END"]="to # from end",I.Msg["LISTS_GET_SUBLIST_END_FROM_START"]="to #",I.Msg["LISTS_GET_SUBLIST_END_LAST"]="to last",I.Msg["LISTS_GET_SUBLIST_HELPURL"]="https://github.com/google/blockly/wiki/Lists#getting-a-sublist",I.Msg["LISTS_GET_SUBLIST_START_FIRST"]="get sub-list from first",I.Msg["LISTS_GET_SUBLIST_START_FROM_END"]="get sub-list from # from end",I.Msg["LISTS_GET_SUBLIST_START_FROM_START"]="get sub-list from #",I.Msg["LISTS_GET_SUBLIST_TAIL"]="",I.Msg["LISTS_GET_SUBLIST_TOOLTIP"]="Creates a copy of the specified portion of a list.",I.Msg["LISTS_INDEX_FROM_END_TOOLTIP"]="%1 is the last item.",I.Msg["LISTS_INDEX_FROM_START_TOOLTIP"]="%1 is the first item.",I.Msg["LISTS_INDEX_OF_FIRST"]="find first occurrence of item",I.Msg["LISTS_INDEX_OF_HELPURL"]="https://github.com/google/blockly/wiki/Lists#getting-items-from-a-list",I.Msg["LISTS_INDEX_OF_LAST"]="find last occurrence of item",I.Msg["LISTS_INDEX_OF_TOOLTIP"]="Returns the index of the first/last occurrence of the item in the list. Returns %1 if item is not found.",I.Msg["LISTS_INLIST"]="in list",I.Msg["LISTS_ISEMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Lists#is-empty",I.Msg["LISTS_ISEMPTY_TITLE"]="%1 is empty",I.Msg["LISTS_ISEMPTY_TOOLTIP"]="Returns true if the list is empty.",I.Msg["LISTS_LENGTH_HELPURL"]="https://github.com/google/blockly/wiki/Lists#length-of",I.Msg["LISTS_LENGTH_TITLE"]="length of %1",I.Msg["LISTS_LENGTH_TOOLTIP"]="Returns the length of a list.",I.Msg["LISTS_REPEAT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-list-with",I.Msg["LISTS_REPEAT_TITLE"]="create list with item %1 repeated %2 times",I.Msg["LISTS_REPEAT_TOOLTIP"]="Creates a list consisting of the given value repeated the specified number of times.",I.Msg["LISTS_REVERSE_HELPURL"]="https://github.com/google/blockly/wiki/Lists#reversing-a-list",I.Msg["LISTS_REVERSE_MESSAGE0"]="reverse %1",I.Msg["LISTS_REVERSE_TOOLTIP"]="Reverse a copy of a list.",I.Msg["LISTS_SET_INDEX_HELPURL"]="https://github.com/google/blockly/wiki/Lists#in-list--set",I.Msg["LISTS_SET_INDEX_INPUT_TO"]="as",I.Msg["LISTS_SET_INDEX_INSERT"]="insert at",I.Msg["LISTS_SET_INDEX_SET"]="set",I.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_FIRST"]="Inserts the item at the start of a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_FROM"]="Inserts the item at the specified position in a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_LAST"]="Append the item to the end of a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_RANDOM"]="Inserts the item randomly in a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_SET_FIRST"]="Sets the first item in a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_SET_FROM"]="Sets the item at the specified position in a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_SET_LAST"]="Sets the last item in a list.",I.Msg["LISTS_SET_INDEX_TOOLTIP_SET_RANDOM"]="Sets a random item in a list.",I.Msg["LISTS_SORT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#sorting-a-list",I.Msg["LISTS_SORT_ORDER_ASCENDING"]="ascending",I.Msg["LISTS_SORT_ORDER_DESCENDING"]="descending",I.Msg["LISTS_SORT_TITLE"]="sort %1 %2 %3",I.Msg["LISTS_SORT_TOOLTIP"]="Sort a copy of a list.",I.Msg["LISTS_SORT_TYPE_IGNORECASE"]="alphabetic, ignore case",I.Msg["LISTS_SORT_TYPE_NUMERIC"]="numeric",I.Msg["LISTS_SORT_TYPE_TEXT"]="alphabetic",I.Msg["LISTS_SPLIT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#splitting-strings-and-joining-lists",I.Msg["LISTS_SPLIT_LIST_FROM_TEXT"]="make list from text",I.Msg["LISTS_SPLIT_TEXT_FROM_LIST"]="make text from list",I.Msg["LISTS_SPLIT_TOOLTIP_JOIN"]="Join a list of texts into one text, separated by a delimiter.",I.Msg["LISTS_SPLIT_TOOLTIP_SPLIT"]="Split text into a list of texts, breaking at each delimiter.",I.Msg["LISTS_SPLIT_WITH_DELIMITER"]="with delimiter",I.Msg["LOGIC_BOOLEAN_FALSE"]="false",I.Msg["LOGIC_BOOLEAN_HELPURL"]="https://github.com/google/blockly/wiki/Logic#values",I.Msg["LOGIC_BOOLEAN_TOOLTIP"]="Returns either true or false.",I.Msg["LOGIC_BOOLEAN_TRUE"]="true",I.Msg["LOGIC_COMPARE_HELPURL"]="https://en.wikipedia.org/wiki/Inequality_(mathematics)",I.Msg["LOGIC_COMPARE_TOOLTIP_EQ"]="Return true if both inputs equal each other.",I.Msg["LOGIC_COMPARE_TOOLTIP_GT"]="Return true if the first input is greater than the second input.",I.Msg["LOGIC_COMPARE_TOOLTIP_GTE"]="Return true if the first input is greater than or equal to the second input.",I.Msg["LOGIC_COMPARE_TOOLTIP_LT"]="Return true if the first input is smaller than the second input.",I.Msg["LOGIC_COMPARE_TOOLTIP_LTE"]="Return true if the first input is smaller than or equal to the second input.",I.Msg["LOGIC_COMPARE_TOOLTIP_NEQ"]="Return true if both inputs are not equal to each other.",I.Msg["LOGIC_NEGATE_HELPURL"]="https://github.com/google/blockly/wiki/Logic#not",I.Msg["LOGIC_NEGATE_TITLE"]="not %1",I.Msg["LOGIC_NEGATE_TOOLTIP"]="Returns true if the input is false. Returns false if the input is true.",I.Msg["LOGIC_NULL"]="null",I.Msg["LOGIC_NULL_HELPURL"]="https://en.wikipedia.org/wiki/Nullable_type",I.Msg["LOGIC_NULL_TOOLTIP"]="Returns null.",I.Msg["LOGIC_OPERATION_AND"]="and",I.Msg["LOGIC_OPERATION_HELPURL"]="https://github.com/google/blockly/wiki/Logic#logical-operations",I.Msg["LOGIC_OPERATION_OR"]="or",I.Msg["LOGIC_OPERATION_TOOLTIP_AND"]="Return true if both inputs are true.",I.Msg["LOGIC_OPERATION_TOOLTIP_OR"]="Return true if at least one of the inputs is true.",I.Msg["LOGIC_TERNARY_CONDITION"]="test",I.Msg["LOGIC_TERNARY_HELPURL"]="https://en.wikipedia.org/wiki/%3F:",I.Msg["LOGIC_TERNARY_IF_FALSE"]="if false",I.Msg["LOGIC_TERNARY_IF_TRUE"]="if true",I.Msg["LOGIC_TERNARY_TOOLTIP"]="Check the condition in 'test'. If the condition is true, returns the 'if true' value; otherwise returns the 'if false' value.",I.Msg["MATH_ADDITION_SYMBOL"]="+",I.Msg["MATH_ARITHMETIC_HELPURL"]="https://en.wikipedia.org/wiki/Arithmetic",I.Msg["MATH_ARITHMETIC_TOOLTIP_ADD"]="Return the sum of the two numbers.",I.Msg["MATH_ARITHMETIC_TOOLTIP_DIVIDE"]="Return the quotient of the two numbers.",I.Msg["MATH_ARITHMETIC_TOOLTIP_MINUS"]="Return the difference of the two numbers.",I.Msg["MATH_ARITHMETIC_TOOLTIP_MULTIPLY"]="Return the product of the two numbers.",I.Msg["MATH_ARITHMETIC_TOOLTIP_POWER"]="Return the first number raised to the power of the second number.",I.Msg["MATH_ATAN2_HELPURL"]="https://en.wikipedia.org/wiki/Atan2",I.Msg["MATH_ATAN2_TITLE"]="atan2 of X:%1 Y:%2",I.Msg["MATH_ATAN2_TOOLTIP"]="Return the arctangent of point (X, Y) in degrees from -180 to 180.",I.Msg["MATH_CHANGE_HELPURL"]="https://en.wikipedia.org/wiki/Programming_idiom#Incrementing_a_counter",I.Msg["MATH_CHANGE_TITLE"]="change %1 by %2",I.Msg["MATH_CHANGE_TOOLTIP"]="Add a number to variable '%1'.",I.Msg["MATH_CONSTANT_HELPURL"]="https://en.wikipedia.org/wiki/Mathematical_constant",I.Msg["MATH_CONSTANT_TOOLTIP"]="Return one of the common constants: π (3.141…), e (2.718…), φ (1.618…), sqrt(2) (1.414…), sqrt(½) (0.707…), or ∞ (infinity).",I.Msg["MATH_CONSTRAIN_HELPURL"]="https://en.wikipedia.org/wiki/Clamping_(graphics)",I.Msg["MATH_CONSTRAIN_TITLE"]="constrain %1 low %2 high %3",I.Msg["MATH_CONSTRAIN_TOOLTIP"]="Constrain a number to be between the specified limits (inclusive).",I.Msg["MATH_DIVISION_SYMBOL"]="÷",I.Msg["MATH_IS_DIVISIBLE_BY"]="is divisible by",I.Msg["MATH_IS_EVEN"]="is even",I.Msg["MATH_IS_NEGATIVE"]="is negative",I.Msg["MATH_IS_ODD"]="is odd",I.Msg["MATH_IS_POSITIVE"]="is positive",I.Msg["MATH_IS_PRIME"]="is prime",I.Msg["MATH_IS_TOOLTIP"]="Check if a number is an even, odd, prime, whole, positive, negative, or if it is divisible by certain number. Returns true or false.",I.Msg["MATH_IS_WHOLE"]="is whole",I.Msg["MATH_MODULO_HELPURL"]="https://en.wikipedia.org/wiki/Modulo_operation",I.Msg["MATH_MODULO_TITLE"]="remainder of %1 ÷ %2",I.Msg["MATH_MODULO_TOOLTIP"]="Return the remainder from dividing the two numbers.",I.Msg["MATH_MULTIPLICATION_SYMBOL"]="×",I.Msg["MATH_NUMBER_HELPURL"]="https://en.wikipedia.org/wiki/Number",I.Msg["MATH_NUMBER_TOOLTIP"]="A number.",I.Msg["MATH_ONLIST_HELPURL"]="",I.Msg["MATH_ONLIST_OPERATOR_AVERAGE"]="average of list",I.Msg["MATH_ONLIST_OPERATOR_MAX"]="max of list",I.Msg["MATH_ONLIST_OPERATOR_MEDIAN"]="median of list",I.Msg["MATH_ONLIST_OPERATOR_MIN"]="min of list",I.Msg["MATH_ONLIST_OPERATOR_MODE"]="modes of list",I.Msg["MATH_ONLIST_OPERATOR_RANDOM"]="random item of list",I.Msg["MATH_ONLIST_OPERATOR_STD_DEV"]="standard deviation of list",I.Msg["MATH_ONLIST_OPERATOR_SUM"]="sum of list",I.Msg["MATH_ONLIST_TOOLTIP_AVERAGE"]="Return the average (arithmetic mean) of the numeric values in the list.",I.Msg["MATH_ONLIST_TOOLTIP_MAX"]="Return the largest number in the list.",I.Msg["MATH_ONLIST_TOOLTIP_MEDIAN"]="Return the median number in the list.",I.Msg["MATH_ONLIST_TOOLTIP_MIN"]="Return the smallest number in the list.",I.Msg["MATH_ONLIST_TOOLTIP_MODE"]="Return a list of the most common item(s) in the list.",I.Msg["MATH_ONLIST_TOOLTIP_RANDOM"]="Return a random element from the list.",I.Msg["MATH_ONLIST_TOOLTIP_STD_DEV"]="Return the standard deviation of the list.",I.Msg["MATH_ONLIST_TOOLTIP_SUM"]="Return the sum of all the numbers in the list.",I.Msg["MATH_POWER_SYMBOL"]="^",I.Msg["MATH_RANDOM_FLOAT_HELPURL"]="https://en.wikipedia.org/wiki/Random_number_generation",I.Msg["MATH_RANDOM_FLOAT_TITLE_RANDOM"]="random fraction",I.Msg["MATH_RANDOM_FLOAT_TOOLTIP"]="Return a random fraction between 0.0 (inclusive) and 1.0 (exclusive).",I.Msg["MATH_RANDOM_INT_HELPURL"]="https://en.wikipedia.org/wiki/Random_number_generation",I.Msg["MATH_RANDOM_INT_TITLE"]="random integer from %1 to %2",I.Msg["MATH_RANDOM_INT_TOOLTIP"]="Return a random integer between the two specified limits, inclusive.",I.Msg["MATH_ROUND_HELPURL"]="https://en.wikipedia.org/wiki/Rounding",I.Msg["MATH_ROUND_OPERATOR_ROUND"]="round",I.Msg["MATH_ROUND_OPERATOR_ROUNDDOWN"]="round down",I.Msg["MATH_ROUND_OPERATOR_ROUNDUP"]="round up",I.Msg["MATH_ROUND_TOOLTIP"]="Round a number up or down.",I.Msg["MATH_SINGLE_HELPURL"]="https://en.wikipedia.org/wiki/Square_root",I.Msg["MATH_SINGLE_OP_ABSOLUTE"]="absolute",I.Msg["MATH_SINGLE_OP_ROOT"]="square root",I.Msg["MATH_SINGLE_TOOLTIP_ABS"]="Return the absolute value of a number.",I.Msg["MATH_SINGLE_TOOLTIP_EXP"]="Return e to the power of a number.",I.Msg["MATH_SINGLE_TOOLTIP_LN"]="Return the natural logarithm of a number.",I.Msg["MATH_SINGLE_TOOLTIP_LOG10"]="Return the base 10 logarithm of a number.",I.Msg["MATH_SINGLE_TOOLTIP_NEG"]="Return the negation of a number.",I.Msg["MATH_SINGLE_TOOLTIP_POW10"]="Return 10 to the power of a number.",I.Msg["MATH_SINGLE_TOOLTIP_ROOT"]="Return the square root of a number.",I.Msg["MATH_SUBTRACTION_SYMBOL"]="-",I.Msg["MATH_TRIG_ACOS"]="acos",I.Msg["MATH_TRIG_ASIN"]="asin",I.Msg["MATH_TRIG_ATAN"]="atan",I.Msg["MATH_TRIG_COS"]="cos",I.Msg["MATH_TRIG_HELPURL"]="https://en.wikipedia.org/wiki/Trigonometric_functions",I.Msg["MATH_TRIG_SIN"]="sin",I.Msg["MATH_TRIG_TAN"]="tan",I.Msg["MATH_TRIG_TOOLTIP_ACOS"]="Return the arccosine of a number.",I.Msg["MATH_TRIG_TOOLTIP_ASIN"]="Return the arcsine of a number.",I.Msg["MATH_TRIG_TOOLTIP_ATAN"]="Return the arctangent of a number.",I.Msg["MATH_TRIG_TOOLTIP_COS"]="Return the cosine of a degree (not radian).",I.Msg["MATH_TRIG_TOOLTIP_SIN"]="Return the sine of a degree (not radian).",I.Msg["MATH_TRIG_TOOLTIP_TAN"]="Return the tangent of a degree (not radian).",I.Msg["NEW_COLOUR_VARIABLE"]="Create colour variable...",I.Msg["NEW_NUMBER_VARIABLE"]="Create number variable...",I.Msg["NEW_STRING_VARIABLE"]="Create string variable...",I.Msg["NEW_VARIABLE"]="Create variable...",I.Msg["NEW_VARIABLE_TITLE"]="New variable name:",I.Msg["NEW_VARIABLE_TYPE_TITLE"]="New variable type:",I.Msg["ORDINAL_NUMBER_SUFFIX"]="",I.Msg["PROCEDURES_ALLOW_STATEMENTS"]="allow statements",I.Msg["PROCEDURES_BEFORE_PARAMS"]="with:",I.Msg["PROCEDURES_CALLNORETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",I.Msg["PROCEDURES_CALLNORETURN_TOOLTIP"]="Run the user-defined function '%1'.",I.Msg["PROCEDURES_CALLRETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",I.Msg["PROCEDURES_CALLRETURN_TOOLTIP"]="Run the user-defined function '%1' and use its output.",I.Msg["PROCEDURES_CALL_BEFORE_PARAMS"]="with:",I.Msg["PROCEDURES_CREATE_DO"]="Create '%1'",I.Msg["PROCEDURES_DEFNORETURN_COMMENT"]="Describe this function...",I.Msg["PROCEDURES_DEFNORETURN_DO"]="",I.Msg["PROCEDURES_DEFNORETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",I.Msg["PROCEDURES_DEFNORETURN_PROCEDURE"]="do something",I.Msg["PROCEDURES_DEFNORETURN_TITLE"]="to",I.Msg["PROCEDURES_DEFNORETURN_TOOLTIP"]="Creates a function with no output.",I.Msg["PROCEDURES_DEFRETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",I.Msg["PROCEDURES_DEFRETURN_RETURN"]="return",I.Msg["PROCEDURES_DEFRETURN_TOOLTIP"]="Creates a function with an output.",I.Msg["PROCEDURES_DEF_DUPLICATE_WARNING"]="Warning: This function has duplicate parameters.",I.Msg["PROCEDURES_HIGHLIGHT_DEF"]="Highlight function definition",I.Msg["PROCEDURES_IFRETURN_HELPURL"]="http://c2.com/cgi/wiki?GuardClause",I.Msg["PROCEDURES_IFRETURN_TOOLTIP"]="If a value is true, then return a second value.",I.Msg["PROCEDURES_IFRETURN_WARNING"]="Warning: This block may be used only within a function definition.",I.Msg["PROCEDURES_MUTATORARG_TITLE"]="input name:",I.Msg["PROCEDURES_MUTATORARG_TOOLTIP"]="Add an input to the function.",I.Msg["PROCEDURES_MUTATORCONTAINER_TITLE"]="inputs",I.Msg["PROCEDURES_MUTATORCONTAINER_TOOLTIP"]="Add, remove, or reorder inputs to this function.",I.Msg["REDO"]="Redo",I.Msg["REMOVE_COMMENT"]="Remove Comment",I.Msg["RENAME_VARIABLE"]="Rename variable...",I.Msg["RENAME_VARIABLE_TITLE"]="Rename all '%1' variables to:",I.Msg["TEXT_APPEND_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-modification",I.Msg["TEXT_APPEND_TITLE"]="to %1 append text %2",I.Msg["TEXT_APPEND_TOOLTIP"]="Append some text to variable '%1'.",I.Msg["TEXT_CHANGECASE_HELPURL"]="https://github.com/google/blockly/wiki/Text#adjusting-text-case",I.Msg["TEXT_CHANGECASE_OPERATOR_LOWERCASE"]="to lower case",I.Msg["TEXT_CHANGECASE_OPERATOR_TITLECASE"]="to Title Case",I.Msg["TEXT_CHANGECASE_OPERATOR_UPPERCASE"]="to UPPER CASE",I.Msg["TEXT_CHANGECASE_TOOLTIP"]="Return a copy of the text in a different case.",I.Msg["TEXT_CHARAT_FIRST"]="get first letter",I.Msg["TEXT_CHARAT_FROM_END"]="get letter # from end",I.Msg["TEXT_CHARAT_FROM_START"]="get letter #",I.Msg["TEXT_CHARAT_HELPURL"]="https://github.com/google/blockly/wiki/Text#extracting-text",I.Msg["TEXT_CHARAT_LAST"]="get last letter",I.Msg["TEXT_CHARAT_RANDOM"]="get random letter",I.Msg["TEXT_CHARAT_TAIL"]="",I.Msg["TEXT_CHARAT_TITLE"]="in text %1 %2",I.Msg["TEXT_CHARAT_TOOLTIP"]="Returns the letter at the specified position.",I.Msg["TEXT_COUNT_HELPURL"]="https://github.com/google/blockly/wiki/Text#counting-substrings",I.Msg["TEXT_COUNT_MESSAGE0"]="count %1 in %2",I.Msg["TEXT_COUNT_TOOLTIP"]="Count how many times some text occurs within some other text.",I.Msg["TEXT_CREATE_JOIN_ITEM_TOOLTIP"]="Add an item to the text.",I.Msg["TEXT_CREATE_JOIN_TITLE_JOIN"]="join",I.Msg["TEXT_CREATE_JOIN_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this text block.",I.Msg["TEXT_GET_SUBSTRING_END_FROM_END"]="to letter # from end",I.Msg["TEXT_GET_SUBSTRING_END_FROM_START"]="to letter #",I.Msg["TEXT_GET_SUBSTRING_END_LAST"]="to last letter",I.Msg["TEXT_GET_SUBSTRING_HELPURL"]="https://github.com/google/blockly/wiki/Text#extracting-a-region-of-text",I.Msg["TEXT_GET_SUBSTRING_INPUT_IN_TEXT"]="in text",I.Msg["TEXT_GET_SUBSTRING_START_FIRST"]="get substring from first letter",I.Msg["TEXT_GET_SUBSTRING_START_FROM_END"]="get substring from letter # from end",I.Msg["TEXT_GET_SUBSTRING_START_FROM_START"]="get substring from letter #",I.Msg["TEXT_GET_SUBSTRING_TAIL"]="",I.Msg["TEXT_GET_SUBSTRING_TOOLTIP"]="Returns a specified portion of the text.",I.Msg["TEXT_INDEXOF_HELPURL"]="https://github.com/google/blockly/wiki/Text#finding-text",I.Msg["TEXT_INDEXOF_OPERATOR_FIRST"]="find first occurrence of text",I.Msg["TEXT_INDEXOF_OPERATOR_LAST"]="find last occurrence of text",I.Msg["TEXT_INDEXOF_TITLE"]="in text %1 %2 %3",I.Msg["TEXT_INDEXOF_TOOLTIP"]="Returns the index of the first/last occurrence of the first text in the second text. Returns %1 if text is not found.",I.Msg["TEXT_ISEMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Text#checking-for-empty-text",I.Msg["TEXT_ISEMPTY_TITLE"]="%1 is empty",I.Msg["TEXT_ISEMPTY_TOOLTIP"]="Returns true if the provided text is empty.",I.Msg["TEXT_JOIN_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-creation",I.Msg["TEXT_JOIN_TITLE_CREATEWITH"]="create text with",I.Msg["TEXT_JOIN_TOOLTIP"]="Create a piece of text by joining together any number of items.",I.Msg["TEXT_LENGTH_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-modification",I.Msg["TEXT_LENGTH_TITLE"]="length of %1",I.Msg["TEXT_LENGTH_TOOLTIP"]="Returns the number of letters (including spaces) in the provided text.",I.Msg["TEXT_PRINT_HELPURL"]="https://github.com/google/blockly/wiki/Text#printing-text",I.Msg["TEXT_PRINT_TITLE"]="print %1",I.Msg["TEXT_PRINT_TOOLTIP"]="Print the specified text, number or other value.",I.Msg["TEXT_PROMPT_HELPURL"]="https://github.com/google/blockly/wiki/Text#getting-input-from-the-user",I.Msg["TEXT_PROMPT_TOOLTIP_NUMBER"]="Prompt for user for a number.",I.Msg["TEXT_PROMPT_TOOLTIP_TEXT"]="Prompt for user for some text.",I.Msg["TEXT_PROMPT_TYPE_NUMBER"]="prompt for number with message",I.Msg["TEXT_PROMPT_TYPE_TEXT"]="prompt for text with message",I.Msg["TEXT_REPLACE_HELPURL"]="https://github.com/google/blockly/wiki/Text#replacing-substrings",I.Msg["TEXT_REPLACE_MESSAGE0"]="replace %1 with %2 in %3",I.Msg["TEXT_REPLACE_TOOLTIP"]="Replace all occurances of some text within some other text.",I.Msg["TEXT_REVERSE_HELPURL"]="https://github.com/google/blockly/wiki/Text#reversing-text",I.Msg["TEXT_REVERSE_MESSAGE0"]="reverse %1",I.Msg["TEXT_REVERSE_TOOLTIP"]="Reverses the order of the characters in the text.",I.Msg["TEXT_TEXT_HELPURL"]="https://en.wikipedia.org/wiki/String_(computer_science)",I.Msg["TEXT_TEXT_TOOLTIP"]="A letter, word, or line of text.",I.Msg["TEXT_TRIM_HELPURL"]="https://github.com/google/blockly/wiki/Text#trimming-removing-spaces",I.Msg["TEXT_TRIM_OPERATOR_BOTH"]="trim spaces from both sides of",I.Msg["TEXT_TRIM_OPERATOR_LEFT"]="trim spaces from left side of",I.Msg["TEXT_TRIM_OPERATOR_RIGHT"]="trim spaces from right side of",I.Msg["TEXT_TRIM_TOOLTIP"]="Return a copy of the text with spaces removed from one or both ends.",I.Msg["TODAY"]="Today",I.Msg["UNDO"]="Undo",I.Msg["UNNAMED_KEY"]="unnamed",I.Msg["VARIABLES_DEFAULT_NAME"]="item",I.Msg["VARIABLES_GET_CREATE_SET"]="Create 'set %1'",I.Msg["VARIABLES_GET_HELPURL"]="https://github.com/google/blockly/wiki/Variables#get",I.Msg["VARIABLES_GET_TOOLTIP"]="Returns the value of this variable.",I.Msg["VARIABLES_SET"]="set %1 to %2",I.Msg["VARIABLES_SET_CREATE_GET"]="Create 'get %1'",I.Msg["VARIABLES_SET_HELPURL"]="https://github.com/google/blockly/wiki/Variables#set",I.Msg["VARIABLES_SET_TOOLTIP"]="Sets this variable to be equal to the input.",I.Msg["VARIABLE_ALREADY_EXISTS"]="A variable named '%1' already exists.",I.Msg["VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE"]="A variable named '%1' already exists for another type: '%2'.",I.Msg["WORKSPACE_ARIA_LABEL"]="Blockly Workspace",I.Msg["WORKSPACE_COMMENT_DEFAULT_TEXT"]="Say something...",I.Msg["CONTROLS_FOREACH_INPUT_DO"]=I.Msg["CONTROLS_REPEAT_INPUT_DO"],I.Msg["CONTROLS_FOR_INPUT_DO"]=I.Msg["CONTROLS_REPEAT_INPUT_DO"],I.Msg["CONTROLS_IF_ELSEIF_TITLE_ELSEIF"]=I.Msg["CONTROLS_IF_MSG_ELSEIF"],I.Msg["CONTROLS_IF_ELSE_TITLE_ELSE"]=I.Msg["CONTROLS_IF_MSG_ELSE"],I.Msg["CONTROLS_IF_IF_TITLE_IF"]=I.Msg["CONTROLS_IF_MSG_IF"],I.Msg["CONTROLS_IF_MSG_THEN"]=I.Msg["CONTROLS_REPEAT_INPUT_DO"],I.Msg["CONTROLS_WHILEUNTIL_INPUT_DO"]=I.Msg["CONTROLS_REPEAT_INPUT_DO"],I.Msg["LISTS_CREATE_WITH_ITEM_TITLE"]=I.Msg["VARIABLES_DEFAULT_NAME"],I.Msg["LISTS_GET_INDEX_HELPURL"]=I.Msg["LISTS_INDEX_OF_HELPURL"],I.Msg["LISTS_GET_INDEX_INPUT_IN_LIST"]=I.Msg["LISTS_INLIST"],I.Msg["LISTS_GET_SUBLIST_INPUT_IN_LIST"]=I.Msg["LISTS_INLIST"],I.Msg["LISTS_INDEX_OF_INPUT_IN_LIST"]=I.Msg["LISTS_INLIST"],I.Msg["LISTS_SET_INDEX_INPUT_IN_LIST"]=I.Msg["LISTS_INLIST"],I.Msg["MATH_CHANGE_TITLE_ITEM"]=I.Msg["VARIABLES_DEFAULT_NAME"],I.Msg["PROCEDURES_DEFRETURN_COMMENT"]=I.Msg["PROCEDURES_DEFNORETURN_COMMENT"],I.Msg["PROCEDURES_DEFRETURN_DO"]=I.Msg["PROCEDURES_DEFNORETURN_DO"],I.Msg["PROCEDURES_DEFRETURN_PROCEDURE"]=I.Msg["PROCEDURES_DEFNORETURN_PROCEDURE"],I.Msg["PROCEDURES_DEFRETURN_TITLE"]=I.Msg["PROCEDURES_DEFNORETURN_TITLE"],I.Msg["TEXT_APPEND_VARIABLE"]=I.Msg["VARIABLES_DEFAULT_NAME"],I.Msg["TEXT_CREATE_JOIN_ITEM_TITLE_ITEM"]=I.Msg["VARIABLES_DEFAULT_NAME"],I.Msg["MATH_HUE"]="230",I.Msg["LOOPS_HUE"]="120",I.Msg["LISTS_HUE"]="260",I.Msg["LOGIC_HUE"]="210",I.Msg["VARIABLES_HUE"]="330",I.Msg["TEXTS_HUE"]="160",I.Msg["PROCEDURES_HUE"]="290",I.Msg["COLOUR_HUE"]="20",I.Msg["VARIABLES_DYNAMIC_HUE"]="310",I.blocklyToolbox="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",I.blocklyToolboxCurrentValue="PGJsb2NrIHR5cGU9InN0aV9nZXRfY3VycmVudF92YWx1ZSI+PC9ibG9jaz4KPGJsb2NrIHR5cGU9InN0aV9zZXRfY3VycmVudF92YWx1ZSI+CiAgPHZhbHVlIG5hbWU9IlZhbHVlIj4KICAgIDxzaGFkb3cgdHlwZT0idGV4dCI+CiAgICAgIDxmaWVsZCBuYW1lPSJURVhUIj48L2ZpZWxkPgogICAgPC9zaGFkb3c+CiAgPC92YWx1ZT4KPC9ibG9jaz4=",I.blocklyWorkspace="PHhtbCB4bWxucz0iaHR0cHM6Ly9kZXZlbG9wZXJzLmdvb2dsZS5jb20vYmxvY2tseS94bWwiPjwveG1sPg==",I.blocklyBlocks="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",I}),"object"==typeof module&&(module.exports=Stimulsoft);;