/*
Stimulsoft.Reports.JS
Version: 2019.1.1
Build date: 2018.12.17
License: https://www.stimulsoft.com/en/licensing/reports
*/
StiJsDesigner.prototype.AddImages=function(){this.options.images["CloseFormWhite.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAAAWklEQVR42sSTQQ4AIAjDwP//ed4JGxhC5ChYwxodgE3q2LBWAGonVAAISNqLACevgcykK0QIvaxC9ObZnkZ07VQaXQQrNcadKYRpVCE+aSx7/z/TBQAA//8DANGGEx3s2+/cAAAAAElFTkSuQmCC",this.options.images["Gui.Office2013DarkGrayBlue.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayCarmine.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayGreen.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayOrange.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayPurple.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayTeal.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013DarkGrayViolet.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013LightGrayBlue.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAZAAAAFACAIAAAAd4720AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAQahJREFUeF7t3QtAk+X+B/CHDcZlCIzbEGEKAoKaaKL518q7meLdsjLrpJWmKXnhaHlKrdRK7YSe1M5RO2VWlrcQDW9FRyVTymuMkItuOrnjcMg2GPyf932fzQHb2A22F36fs0PP+7wX2N755XmevbyPS+cnPkIAAMAGHPJfAABwehBYAADWgMACALAGBBYAgDUgsAAArAGBBQBgDQgsAABrQGABAFgDAgsAwBr2udJdlp5MSi0JHbuBlGwQ2UXQPcwfF/JvVRTcrmQqW1Xbf0cAQHP2DCzTYWTONuZwVHZAZgHgcCzrEjowNfC3w98UF/APgH8MphIA0JbY1MLSpVVzdZr6qmrVrZKq4nIFqbKNMMA7LNjHh+/uyjWc6dDOAqDttZNBdxwr/j6efaKEvboHkyob4IPgQ+EDGksrAIBDsGwMy2CX0MUFebq7hQR447UuLi7iwlLc1GJWWQE3rOIighoaGvDxi8oVNarahgayyoEdUgAAZs8WBBNJBplYZRGDA0k4UO4ra/GqQtldvBga5MPUW4fZ/cadu/iA+LCQVgA4j3Z1WQPfkze4T3htXX3G74WkynLD+ke4uXIyr0ira9SkCtIKAOfAyjEaHBknfsvHjybZUaOsxV8b8P9swOyuVFGH0jH2HQEAbcnOLSxjDagWN7ALVy5neEIEbhnh9hGpshxuo+GW2s9ZhXWaelIFAHAO7epTsGB/Pv56V6FiFq3D7B4koA4FAHAqrRJYuD1lr1F2M/HcuKIQ3x5dA3G5qOweU2kdZvfYboH4gPiwTCUAwBmwvoU1+pHu+DH04W44rXCXUFosr6iqIeusgnfHB8GHwgfEh2WOT9YBABzKPmNYS58fsvT5wWTBuE1fZW766ixZsBMmTerrG+7dV+OguWNb80qnc2CncKFvJy8eh+OCF0/8ls/UAwAcyD6BBQAAbaBdDboDANo3CCwAAGtAYAEAWAMCCwDAGhBYAADWgMACALAGBBYAgDUgsAAArAGBBQBgDQgsAABrQGABAFgDAgsAwBoQWAAA1oDAAgCwBgQWAIA1ILAAAKzB4hv43Tz8BimxXNcJn5ASAMAkaGEBAFgDAgsAwBoQWAAA1oDAAgCwBgQWAIA1ILAAAKwBgQUAYA0ILAAAa0BgAYN8RaGkBJxbxzpTtl/pPvaX9IeiSZmmkLz7NXrjVf6RsbuWTp2RwxTIOnuy6kr3P7dMOIHee2NhX7JcenhXwq1Hbr7Wiyw7gs1XuuNTEFP8781PHyDLNhv03b6H0ddb7XdA8zV+O2nqqvKvLlh08hRZZhHqiaDjG4Z+TJZbR7s4U5akhH1aWNePbwgdq31M37v9wN7Y1gkp0Cb8hN6upOgIurfToA1XJeH9lr/mS1aAptrFmbIkLlqnS4gjM332JrJAiKZPO3cwWZaeLPvuxbWDSKVzuZP5/muf4PbOyOXpf1bTNSU/z52w/4efv3522icJc77++XrOl0uoDf62408Vvd7ALg5Evezzj29eRL3IRxYdflVEVYb22/EfpmZxzuZRI+kNDZwLet9LX+HNFlw8iH9zuj/66qLvptKrHEeScfJqGRJ1i8Edn5eSZ+ccoX/mI4uOvxbJbDDytRepSlzz6XzZvhnz6Eonfqc1fxaiT3clX1odx6xO2rSYKRs5Qdp/U0tm0092wHf7nO9MPXgjzd4U2/yJiHZ8kZzz4QBmr+WfLJZ9Okqk99SabR+3+5vkc8l0DibNlqXPbqsxrNBhO16IRBdPDpqddlDu/1LStGfJCqehyfvPW+dLxk67eWj2hm6FL27IrCIrpEcrH/vmu9kbupf8bUWm75LXb/6rF/rht5/LmF3+QM++0GwXB+KLas6PGbv/YLF7/+EDpuCKp/qN8y5eOXtD6OKLkvCH3njBxLngK8X7Q1/5atKUq9eR6ow9+5hW6j0mMUGIJDdy0chRSSO9r+/5InTsF9vzub2HD3gJr344ce0k/+KMtEGLz6uEfGYXp36nGXgWkm9y5cE9elJnCg0Y0lV1NVPMPAW/3NNjWngKF56e7nxnisK8kfanVDU/F5L/5sp9RCL6GQ3oH+Z6Pf+ChN6HYuDcic9KVMIuffDKeaEeVQoP+wRW9Bg6FKlH04YVkdi1N7fk6LsXJTLxgmOyKkHAyIfJmra38W2qTcQ8Ev6tDZlbhT+Vhf8tMRxxfR6eHNv/97zfyRqfKY9TlVG9+Ojx/pPCXFHX0P4IqeoRyss5qO425XF/7S7Sa0pmFwdSXck8dw0VLLhWjtxchbiiRoPcPHo/Ftk7N2PMlH9O+NLEuVBJrhUgmfzBG8hBdG+n40mR7uILH26To1P7+47dPOHrElG8n1yhwh0Dd7zdsGBRTcnRDWJJ7rkPL8qZfZ3qndaUoWdx5kvJdUHAePxDTo3sU1t89DhCo7pE8+SnUs5dI09BOI5pGDsfA2eKon0jGToXZ86VlzDPCD9f7/Ksb7UnDjO0/fZ8ubsweAoSJYTUnblSZ/cxLCN9UW8u4gbPY0LtZZEP8vDpRta0vWXvvXHzMHlkvepDaiurMvFXLl3uHNwb1VWR9PENDqT+48HhIl7j8YIa1Z9VeeOY7Hv1cjqqLnV8E0sh/YGUiH+f3i7mjp857fiRxec+HEa9842ei2b7OsiDt9P4zYOWZ9DjuJFrNy8qPJJ87sNJr8VRYYXNE3ojTR3zfj9TU0f/17neac0YeBZI9muW1Lf3k6J5j+AmiuQbXBPo7o7qlDJ67T55MXJ1d9ZBPENnCtO+kQyei1O5Vyv50YNEU/oE+EhlKczTZBjcPq0YB/qo0EgRT551Wd5WXUIN/ekh89yoh+MbsU0JfAbjr/jnxO6UXEOuPh502QSOa1Bk/Blt9t08PHtSMFnjTArefXtX7MQNY1LEqpgBy19lw7lo7tXHXopRnkrBnakNL2eRwcLtxQrEdWX+LT/qqf1d4szPztCzQEie8keJsNuAISJ05bcLVEWZSoVcPZiLFab7ClGdirRCXH3p1uKUlt+azsHwubiKe3mibv3GR/Cvi39t1Jw3uL0s+3oxX/SSUCSXb/+huK0C63vJNc/QZ5PjRCg46cNFsiMvrnW2i0fCIkYESv+bJkWaqj8O5fzeP6q/tu1lVK8ec8tyDlFdxzrpD7sSZqb9yeSdM5mHX+1diVNCUZUaL9WpFGaeC66nNyk5BU8ufjerqkpEw4a900/b3sgokXgGj8NPJGbQonhtpTO/0ww+C4QkP9y+Hhg50q34JyZbT96+rvYdmTSod2jcp0+E+lQWH8VNF3mdEvn2HhmJYgY921M7YEdxsjOlz8i52H65XBUaOTKwcX8QM7y95EihKrqfUFl0E6GLbRVYspNL9kjcByeeS39xeYzyzMHTK/Wbgs6AG/XKuoHB6fu7Tt6VfCPiiyWDW8wrxI195cN4+Y5dXSf869l0/turh/diepTOZHvKr6e40Z/uSj6XHOd++cyCr805F7evyVD/5xz/2dMD3189Vcafsjr5XFJM8WlJibfvQ/it/EfayuNy0bDEc/98GBVq3/rO9E7TG9tN/mWJkWeByS5cr0RV+QXb6SUky3j5y4K7MY8dx79pfCs+/+wk1U88dXL7H9WikdNkG/uodE/WCc+UPmPn4mvJNbWru6xxfxAzsv3BK+W4tygtEOPYhlskO15XuEWyjXBL5P3EKZqrg15Jd/gnBtYYlHjubdH1lK2zjpMKYExbtbAAsLsxib/so9svuxLHcSXbd7IzrV6YWbg6zuPyhZWQVmaAFpbjQQsLADNBCwsAwBoQWAAA1oDAAgCwBgQWAIA1ILAAAKwBgQUAYA0ILAAAa0BgAQBYg7pwtN1cgQkAaN+ghQUAYA0ILAAAa0BgAQBYAwKrjWRlZZESaEfgtNrOotcQAgsAwBosCyxxM0ql42eqAQC0Dfa1sHrqwYtSqRQyC4AOgmXXYeEmFZNTTTQ0NJCSKfU1ZXdKKmtq6/Hz5vD4/sFd/Nps+hHcUU9ISGDKd+7cYQrATJ07d8Zfned1Y34eTP+0dgSt8XwtOiYrA+v8X8W4PLAHNU9odnY2veaBiIgIDw8DQaQskd6urPMIFIYEeLmo5UXSUiUvsFu4X9s0MpsElpeX881X0Vbu39eIRPQ0+uaRSCS6wGqN183qnweDwLKdRce0z7/WioqK63rwIlnROnBUMWnFoHuHBF400kmUl8tVnE7CLgHUW57D8w0N8natUyvodfXyYsn1vLy/8vLyb5XX0FVVsoK/JLLbhVTldUmxHLfK1KWFeTfvMKuR/FaBrgwAaBv2Cazy8nJSojVZtDvcwmIeZLmx0NBQA5l1r0Zdz3H39iKLmE+IKCKYmsurvlJWfE/jGRQR3cWXq6q8U3yf2QCpa2q9u0RHBHnW3Su5I0c8Xy9ebU0VnVL3qpUu7p086c0A6Ljoj76MIhvZjz37QzE0stCamBaWfiNLP79wi72urq6wsJBZJBrqG5Abz+Bcg/L7qgaed6gvl+MZJPDk1CrvkUl5OZ6CIE8O11fAd6tXVVchXpCXO16rwu2ve0oXTx+nncASOJru36o5BfM136WVDmLRYUnvphmy2lrLDbEssOqqCurk1/HDxcVFvxtIVushK+juId6Y2atOntegvku2sEHzFpYuv8hL1fzF4nK5qFZdRZZo9Zo63NFDqBZnmYsL80r48tyQRkMmcHbjMbPz8rnkZeL4e7rX1lSq791TIg++XmsNgA5N909S/6Hg+l/ILdY9yKa2sbCF1fBgLvbm/b5cGlnQarxZg6amjBRtYKyFpXuQWn18D1dOvUqh7e1hNWW38qUluLnkxnFBDQ10diG5upbONpo24Ko19cgFb0QllrdHnbKyWoU8OnWi1wHQ6uzeJrI73T9J/Ye3pmJAjFD3IJtaaFNj9uwSmsec6w8s1uSVIrWN+Ab4utffK75dfh+Hbv39ytuyqjpPn0B3vMbL3UWtkMk19TWllTX1bh6d+Mwu9coquQZp5JXVtVx3Ph1QdBtLUV3v0anlmewB6BCyjYiLiyNb2E/bB5atyItBI1XmtLAQ8gjuIhS4qstlhX/lFdyqrHMXhIYJqOfPEYQKO3FrSguv35Zr3AUhQdq+nhuvvrzwr8JSpZtvSAhpUHEE7m4NLp7QvgKsZ5dmGk4lY8gWev7IKyUla1kZWLV3c5khdnPgjcluNiOvhJbuelEzWlgYxzs4PCImKqpHVFRMZNewAE/ts+f4CkXRdH33sAAv3WvC8RBFUpVR4UHe2sqa8ho118sX8goAs+gGsErlNS7UuIpNrAwsDMeQmQ+yQztQeTtfItfwA4Lh80G7wr/Y9ZFaxyE/hxapBYaQ18gQvJaJqgExQpxWNao6N1dbr/u1PrCcB+kfNkbWWc0nNLJHeCBZ0BJ06d4jKqKLT3t41ZwJbiyTUuOyozjbz+PkyAfzzeg+GcSFGyX37qvqugbb2jWx/z89N78Y0w+ynZ3g95MxZAvABsz5cp6z5mw/j5M7/1dRkweuHNgjhFlLfUoYHRwbLujk6cbUWK1V2grM9Q0G1dTAn7MAw5wtHSCtzIezqckDV+KODnM1g66pZbvW6tyQ8fbGcP2dO3fgbjCg42ieeu0yB5s0r/CDrGCaV9ZehNVcW4/GdO7cGTILgHamSfMKP8gKe2vrwPL09ITMAsAi5jTT2msHdmljbR1YGGQWAO0J87l8c2S1XVl2A786uYG/c27CzS8mN5e6rJQs68H1pKQVHR1NSu0d3MBPB27gx17t5AZ+TbgYuaCVGXrXIbUAAGCeNg0sAACwhQPGsAAAwDqtMoaVl5cXFRVFlo3Lzc21ZQyrsLAwNDTU3d2dLNNz59y4cSMsLMzNzdYLau2uyRgWUwBm0o1hMYsOB2NYdmTRMVkcWGKxGKdVRESErgdaVlYmk8lwTSfnu/tLR3tndxBwWm1n0WvI4i6hp6enQqHQ3dFUqVQWFRVxOBwvL3vdu7i+nrkNKQDAObA4sAICAvBXHFI4qnBn8Pbt2zhg/Pz8dHc4bqa+puz2TWY6r9wCye27Ji8Dk8vybhYxs4ABAJwDiwML9/twIwuHFI4q3M6qrq7GfcPAwKa3hNFRltyWlatd/UMjekRFdgtwVZbJpHeNN6FqNZpWuZszAMBq7P6UMCwsDPcBcVQxw7FCodDgnM804xOpUnOmSsncGCXSvDzZPXRPlndXherv3ymQNZpoBwDgSOwOLNzCCgoKwgXcJcRRxZQNMzGRqgGdQqP83BHHq3NkKEw2AYDTsDSwzLoi1BkvHDUxkSoAgCUsCyxX3yhX32jTD9zYwd00skMrUyqVpaXUPBxcLheXS0pKmHoDTEykCgBgiVZJltra2lwzkK0tp1Rr7lTev12ukMhK6uvrhUJhREQETsnSuwppyb2iyvuq2gcTvhImJlKl1NfThRoNRBgAzqtVAivabGQHSyiUtTdK7t1VqKru12rcOnkLgnFgeXl5+QWHcb38Faq6SoUKb1CjriM7EMYnUqUaX3VKuRLVySvv15LNKQ16E10DAByvjfpudlQqr8G9ToG3u1BAjaDXcTzq6xs09Q0KNbW2sz/fz9sd15TiAGrM6ESq/CCBN0ddeSuv8C7XncdsjJCXhzuqKYFPCQFwIuwLLFUt1WsT+nn6e7u7u3FxVNVq6tV1GpxinjxXPz4v2NcTb4C7jfTm+oxNpMrx6RJBVUZ3FYaJoqJC6b/r8Qrq1j2qB3xKCIATYV9guXGpnxl3DHFIqWo1Li7IlcthKnFy1Wnqq5VUZ9DNFW5xA0B7w77AEnSibs9wq6w6/w7VW/PxcudyXHBmeXu44bS6LpPfLqeuBhV4G7uCFADAViwMLG/3AB9PHFIcjouvFw/3DZn60AB+Jy+ei4uLK8clyNcT9w2ZetAOZGVlkRLo2NoysOxz8wPc0wv29Yjp4tejix8OKZxcTD0uhAXwY8P8orv4BfpA8wqAdsiiwCqT/kXf6oB55OYXSsrNnvcGbn4AALCVxS0sdwH9KVuPqMgwPzfV3bIyM1tNcPMDAICtLLrjKG5h3UWCqPBg7fKNvCo3YWQXvqLkduldFZVILlwP/85h/nUlkpIqVT1ywct+nUW8irxi6npN+s+JQxqKb5XcU+Ogc/UQhIYFkDGodg5uTWkLc149lUp17do1XPDx8bHummQrwGm1nbHXcPny5aSkx/oxLE11aY3ahefOR9Wl5ZW1vOCIqB4RgZ4NSvldRXlllcYrJDoqKjKAp7pbXql38wPvSlmxoqFTSGR0F1+uqvJOsd4fywBgvbt37zKFqqoqHF5MGbDapmYsbmE9eCO4cHh8/+Aufrrx7Xq1UlF6p6TGXSioL6lEvkFBAl937d0/8b5VXBxYtbfyy5F/TJgA18llBUW13t26Bj+YR6LdMudX8e+//05KuOvt7t65c2fmrqpW0z8g1r9/f1KyHHMo3RGaLLY2c16969ev46jCzSv8tVu3bja+dGYy9oOJxWJSaok5U8y376OZaGHhhCILWjZ1CbWU5ZI7d5WahgbE4bjUu3gKo/w1spJKhVqDdKGmDSylNK9S/7dfR7nnlKWBxejdu7f+tEBWKC8vv3HjhpeXlzlvPhPsHli4+xYSEmLiDrH6Wnz1mP4gk/L4+bZZr9Cc0wpMsyiw7HFZQ3nZ3RqON/3XLWGdXOkqD79QUURMVEQXH5f75WVkmgiaC0Jcr2B62J5+wN++NIVTAOcUc2f6+/dt7TErldQHufabmMNJMf3BTp06+fr64peuurq6rq7JX7+D9oDbKWr04ucGkaUW3K8qVyJPf18+WSaq5RW42k/gWVtZXK6oQ27cmtKiijpPH76r5v69e2qOt8DHg9rXxcvfR1B3v1yh1Hh24nOqbt28VVTdIPDx6gB/RSOTyUJDQ8mCEcyNnvFmOKfKysrwP7zw8HAbby5WXFyMWx/+/v7e3t6kyiq6n83gYos0Gs2VK1du376Nd+TxeDhAS0pK8FMrLCzElThfcA/u3r17uFsnlUrxNk2O3OKrh3fBTxM32fh8Pj4OjmlPT882iGljPxjuKOEzaIypW+Ma55zHNH0EfcaOZuw1PHny5BNPPEEWtOzRJayvKr5Zek+NO4Q8bz9eTYXau7tfvbSM+iDQhcPrFBjW2YeD7pfeuCNXueAOoLC+6HapgvqUkMPzCggO9e8QF3la2iXEvZvIyEjb/8ldunQJhwXuH+FeEqmyir26hPiNe+vWrb59++IeHE7kmJgY/ONlZ2fjtyx+4+IOnVAoJJvqMf3q4cYUPho+DlmmCQQC/AKShWZycnJIiRYbG0tKFoIuoe1ar0sYGN6j+QAWPoaPMKI71b+LFoUEhUT0EAW54ppIqiYmUkSlFfbg5gdcvxBRNN0fjBZZkVZ1FSU1f12+/2eW6uZ1zT05qW13cHuhoKDAxk+78O7MP2OHdwnxjyGRSHB63rx5U5csuN2HMws3uHCYVlZW4hqDadUiuVzeJK2wqipTNwbSTyir0wq0Pctmfna4hoaGmj+zGvT+xsctqDMvJBw1vot8vUrZcF/h4unF8Wi9f6j19fUWdNfMb2ExzRbmM6/AwMCuXbvSK63BjLjjxlrv3r1JlbVsbGEx25uvyZFNv3rMaxUWFqbLO6Zd2eJnhbidZWNaGfvBbP/sTF/7PppFLSyWBRamqSxTyW406P1GdfUVuIuimcyqu3e3rqyYg39rdxYhjv6Mqk2uyeC6+wV1CfY2GjhVsoI7Gp8e4UY+xJLL8ipQcIT5nxhYGlj4fXD//n0bA6u4uBj3v2w8CIP52XAnC3e1mMPixhHu2TFrW4SbV7i5h3umuFBaWoqfo65LqFarcZcwIiKisLAQ/5wGPzc08erp+oP63V7cjsN9T7s8cdPMOa3ANIsCy6JBd6fA8fRyFQTitla9knyChttTSFOL6mrVtwrqKsp4wjDc7EIuTbKIGvV3FURFdPX3D/Tz5ijl5XerG7x9+UamiVbdq1Q0uAf6GmmhKe6WqjidmFvdmMX8QXf8FautpW7WHBIS4ulp/Z8C4OPgmLB9xB2rrq7Gh8IdN3xMpreFmzPmj4vh3yAVFRU4rVxdXfFx8EtRUlKCK3Gy4PwKCgrCz5RZxMfHq/Ai2ZPW/NX74Ycf/qLh5hXuEuIfCbclmRqsqKgI1+CvZPmvv1qp32fOaQWmtd6gu3PBgVV7R4qbVGQZZ5mHl3u3GA7PYIo0/cTgvqxQpvTqEinEeVAvb/bXQnotrGZr78ks/0sj81tYDNz6MDYCbaYmvTDzu2/GMM0Wpqzf/2oDzV89HFjTp08nCy3Zt2/fpEmTyIJdGTutpjtK1l0T55zHhC6hBXBmqW5ep1pY+Jm4uLhHxHK9jf3Ob/YRZ+Xt/JJ6XxxJ9ZW38io0PsLwYG65RCav9w6NFHrpAsvgWt11sN4G1xpgTmABY1gXWMB8JgKLlPSwOLDqKsvU2sEsjptbfW0t18PTvXsvF/qSy2aaBZYuksoN/bWQyuRad21gmf2XRqx+Z5sYMre94WYOg4FFSuaBwHJapl/D1NRUUqKxNbBqi6TqEhlTdgsQunUW1cpu1laU8IK7uIWEMfWNNQssnERlDVQLq8TQXwshbWAZXOujDSyz/9II3tm2cNpXD06r7Sx6DS26DstZaCpKHqSVIJDXpZsLh8MLi3ALDKktu8P0EFt0T6lucONRF+2b/mshW9YCAOyKfYFFjVvJbjJljqeXW5cIpozxQru6CoLUd8ha4zT3y2+XKRrcOwmoIfIAL4/6GnlJTT3SyG8V5uXeKn9wmZeJtfQ0q6b3BQDYFfsCq/aOlLlw1MXV1b1rDG5bMfUM3NriuPI0CsNXOasqmfs7F8oq6twEwi5B9EQVnIDOwfwG+e2CvwpLa7hegYEB+oc0vFY7zarC5L4AALti2RhWg0ZzP/t33LjBZQ9Rd66fgYsMGxoaam/fwMnV5PJ3x4LBDlvAGFY71p7HsBpqVUxaufoFGEwrjJrpKzjUWCMLsBGEAmCwLLBcXHkuPJ5bgJAXZvQP8TEOz93FA2b6AqC9YV1guXrF9mM+FiRVRnDcOsB9lwHoYGCIGADAGhBYAADWgMACALAGBBYAgDUgsAAArAGBBQBgDQgsAABrQGABAFjDQYGlKbrwnzdnThs3btzkp5J3XGDuu3tx67glaUXMV7qiEWP11ihKWzJu60WyACxWnLYUnzo95r6YNeID76xNKyZLwCyVx94cN/nBK2z6n4ndOdkpc0hgVWasmfeJ/IlN3xw9evTQv6erP1myQ6ybBKff/KMfJzaagQA4o7j5n+PTR8zvR2pbUJV/NquClIF5ik4f500cIz51Vk0qaG32z8TJTpkjAuvmsS+vDJ6/YFgIfXMXwSMvf7AozruaXoU9+AXyZdr22ZPHTZ69PqOIiTN1/oGVk3GjbO5HpKYya8dC3Eyb/NTS3ZerqZpq8W6m4YY32nEZHxMf5/WUrcmTJ//zghpVX/7PXPqAafmNTj6wj6ang37xd6ynTuJT76QVaYrSPtwqRuKtH7ZJ06CdkGb+6D38uQnD849n6v85P2lhkbf0U+9sTXmdbuc2fc2ZLb88tnshXXMs/+KOudPGTX4p5Sw1cS2SnvgIL9KnTEz9E3T6U+aAwKrOFxdF9uz+YHYZXnjCkPDmN+rMOSZJ2HLo8JbE0o82HKFfroKfFaP3HD285Ymij1J+qsRN5Y/euTDgg6NH97wbl7nqk9PVSH0Pxc//93dH8TZTNQfO5tLHKcj2f/3QoUUDUOanq07Hr/z20K7n/SUF9CpgPfHWl+jeIPbpZaqi+enACrLRxC2Hvk8ecGXHgT9DEpfPj8NNs+XQgjab9MKxiDGDfcKHT1Uf+43OGD21+C19qid+S3//SsiDt3Sj15yuyTmcE/MBXZOyIiP+4+92vSw4diCzEuXsWHHAn2op7/94yMU3P82kf4079ylzQGC5uVH3JW5Z5LSpCXzEDR88LE4sZfrQg4c8Qmou50rQjfzLkU+MiUaIH/fE4/5n/8xDvJA4oeLM/q0p7390mMxHhcXHdUWIi/JzLqgfGTIAJ2P44OEwObmt9LqEC+KpiuangxI/oBcf8bv3jFQjppkMLCE9k9b9/wbgroggYRg68LOUVBMS/JZ+bFizt3Tz13z4MPwPh6rBpQF8bkh4d4Q0qqJcceXNA28+M27chLk7ctSZV5gJu5z6lDkgsHjdosILsvNryCIm/mbh1ixzOmnuPLoXaVRVxtq572dxeg6bNX+awZkoAGAT8bEfijLWT6aasTNTLt88dqFJYtlu2MpD5NfO0UPz6F88zs0RY1jhw5/tk7n104wiOqMqL+7Y+mPckF7Noqjg2PHr+PeANDNDHB8joqt+/hl3NHQ13brHM9tUi4/9r2JIryhUo6hQ9xzy5LB4t/wLBai28e+H7rEDeKczLlRRwwI/55BKYDfNTwew0Z9nj8X8/XuSJ0f3LPb/Jr3RrKUi297SId3j+JkH0nAIaqQHlkxem6EbSHZejggsJBi2assrvMMLn8a/OCa/+jV64eP58QYmTBYpTs2ePGHhsZC/J42g5v1DaIB3zsIHNYIn/v7ugAsr8C+fd8QPr5z/GB8FJgxPuPTJU5Nnf8UfM0WQJ200UMgbvGD9+Ly1z+C1iu7QJbS75qejOWHcAGH+1vcOwKC7OcSZx0QJsbrXUdBniOjIz5f1ZjlxG7xgzchs+i1dITJ1R0sjej37wWzhsTfGjZu25Gy/NW+w4ZQ56z3dL24dtxKtPzqfBY1U88DNv9slZzmt0gNLFx4bsuWzqeGkgkXa8z3d2QvSql1y7GlV53z75kx6hOuNY8IF/2BjWmEWvYYsmzUHANCRQQsLAMAaEFgAANaguoT7Vz1KlgAAwIlRgSVLTyZL9vbrr7/+3//9H1kAAADbQJcQAMAaEFgAANaAwAIAsIbRMSylUvn0hl/IghGpbz9BSkbAGBYAwI4gsABoU6ez75GStR7r2YmUOh7oEgIAWMNUC+u9995bu3YtWW5m6dKlmzZtIgtGQAsLgCaghWULaGEBAFij5RaWLYNZ0MICoIm2bGE11Nfe/WNjg0ZJlhFyD3qYHzmJLLAQBBYAbapJYP30/cekZNyIp5aQEs38wFKVZFUXHiYLCLnyQ316vYxcuGTZcqWlpVu3bmXK8+fPDwoKYsptxoGBdTVlbPqHpEzpHx+3fmVi7+bT57Q6+ieJ7Xfpk1HBpAaA1tI8sFatWkUWDFmzZo3VgSW/uk1zn9wr1MXV07f3XI47c/Nei/32228xMTFXrlzJyMhgaoYOHRofH5+bm/vII48wNVZYsWIFKdE++OADUjLC1BgWjqqlS5euXLnyIeX/cCQZe0TfPU52sAKOifRknJiF2/uJxOIx75wsIStanUp2cXvK6Tb7dgCY8M0vefihK+gezFrr1N2T6NIKuXC8u0+3Oq1SU1PT09P/9a9/nTlzhlQhdPbsWVyD6/FaUmUVHFIt5pSO0cDy8PDYRDPxQaEduXd77NnBCOVIrurPFtmKrm6fffLdQhVdfigJhyY0r4DjPDs0Cj90Bd2DWWsdZfFvpISQZ+jjbn5WHg23rS5epGbKr6+vr6urYyoxXMY1uIDX4m2YytbmnJ8S4j7ahtAFe1OWbggd+8UpBUJV4m9Wbx06ES9umPXByesk1Mhm2z/YOmjshr5P7/oml0z7oco9+e4r1MaDnt31+WU5Xad/zJ3vLaJ7ozkX+47998FietUbpHFnaF8kObVn1tNUZd+nt757SsZUAmAvuvaUrm2lq7FOfa1CXfFgip2a2xkVv62qOP9u7V1memEL4J4gh0OCQigUvvDCC//4xz/wV1xmKvHa6OhoptzanCWwVDd+/m8GCh4QTc0KyciXi5Ymy47MHOmZu31+2tKiLp9+lSz7LnHIjYtD5/9wTTeFV345mvDiuSMzloeWL1126EwNQpWn31128UzcqJwji7+bVrdy+Z5vdLO5kWO++PbmscvxItUhfXUKedlpBvcty/hwg+zuk5Nk6Yu/Gq7avuHQgwMCYA+69pSubaWrsY6q5A/U0HieO6pXONXNL4Ysmk0gEPTp04dHzwk6duzYiIgILpeLvz7xBDVyjevxWn9/f3rbVufowKLaOFTLJWKRWDWs3/fLH3sw5h4q6h+KENdVlXnh3TI0b+ZYajzeJ+6lmaGoLPdAJtObQ6h7zLhefMQVjRzli9Sy38Wo6o/rn6vR+GH9fLiuoscix6Hqg6clZGPtMcliM4b31dThb/b7wSMLUjJUk+bL0uc/y867/QOnpWtP6dpWuhrraKpvufJD8UP3mSA/YiIvoDdTttTjjz+u0VDxFx7+4K0vElGzheJ6vJapaQNmBRYz+m4M2cg62kF3Weri3StGRXuTaoqPqwf9X3kF1dHz5bvTS8idT8WNpIJ01pAbYjYLDvXFX69KS5QKqpv94VtUDoa+ePEoQmd0G2uPaYzhfYX/98ZzviJ13cEfL06YvXnQorRruJcKgP3o2lO6tpWuxjreMc/59J5LXXJFt7O8uo1zD+rHrLLC//73P9yqwgWp9EHnQiKh2gG4Hq9laizFfESIv+o+K9QVjGk5sHSj7yaQTVuHrz81v6O8mjSpVNVUpkQHUfFEqUXMVXElMiqVHgoPRvRvlOXr6BxkHq8/RFWZw/C+/N4vvHruyKu/fDhobby7JFe85FuLBwIAMEHXntK1rXQ1tqi5TV2Q5CUa4yG0/sqDysrKK1euqNXURO3p6emFhYW4VYW/Hjt2DNfgerwWb0Nvaxnm80GsSdkEZxnDMsE94eHlgWj7nvRrVdTo++d7ZCgwZvwjpMGF8rMPXpAjjeTUSTnyET0ah4KHxL3EQ0cyLlZpkOTAv0PH/jPlD23/8YEAUXd8NKUc//rR6+kb3jfnhwljN7x8UB4d/9hLcyIfxY3hID+yAwD2oGtP6dpWuhqraWpK1ZU5nl0e9+g8hFRZJTc3l/k0ECsuLv7yyy/ff/99/BWXmUq8Fm/DlFsbCwILecYlbU3cFHJ7wfMbQp9PP9ut3y/bJ/XWXazbPTJavHfQ+L0fVgZ/+n5if0+EBI+9s7Hfo+KTseM3TPy2bt6SaUkPa9PtgdD+TwZEl4mHjt/8+Q1SRTG4b+ykT1eKfPfvpfqJy6+HTx31cSJcAgHsZo1JZCPLKe+c9RAO9AwbSZatNXDgwH79qO4kh8NxdX0w/ovLzKeHeC3ehqlsbUavdLeLVv7THLhCHbBP2/wtYb1aXnP7f/yICWTZNg0NDefPnzd2pTtOKxcXF6bSOitWrGixM8hgQwsLAGChepWc3208WbAZzqNHHnlEIBD07NmTVCHUq1cvXIPrbUwrzMy0wiwLrBbH8AEAzsC1kwi52L85EhQUtEqr7f/yGbP4KTlTZsGf1ADQsViTwdDOAgA4hDWBZX6HEwAA7MjiwIK0AgA4CqsvawAAdCz2/xwBAABaCQQWAIA1ILAAAKwBgQUAYA0ILAAAaxgNLKVSOfG9Y6YfZFOTfv31V/gKX+ErfLXLV1PzElo9HaEO/h5wWQMAwF6gSwgAYA1TgcXMn5o02FU3Z6p+2ab5UwEAwHLQwgIAsIapMaz33ntvxIgRdXV1n54nlcbgBhcpNQZjWAAAO2ohsNauXXvs2DFbAouUAADAZq0eWJfLHHBbQgBAu2QqsFatWsWUXV1dcXLhwqlTp0aOJJNw6MpLly41NjUhBBYAwI6MDrp7eHh8SLNloiEAALAjcz8lxO0pTFfA9CsBAKANmBtYuPfHdACZAqZfCQAAbQCuwwIAsIbRQXcdpVK5cuVK/Smqm6irq2vlQfe/Lm3+JJ+UEXILCR++YGBsIFkEAHQYLQeWLewZWA+9MW14D1RfU/TL6rNXvfrMWhUtIKsBAB0E27qEHM+QPsP4qOi2pAwvVefsOr7ttf2bXzu049PrJTXMJqRy27o/T/8br7okoSprb6Vm/GfR/s2LjhxILVfR2wEA2MZhgXXj7I7mD7LOHBweqjx59hSK+9u2aa+/0a3h2pX/nVfi+vtnfz9+oTb2jYlzF/tUX2O2RVW/nD3wI0p4Z9rrb8XU/Xg6/QK1JQCAbRwWWN2GvExKWs1rDMBdwisZ1SikS5gPEowa89Jot9zU8wc+u4FbV/VIg1tSkkulyDM8rocbxzO0e19mp+r8s+UoMrx7IOKEhEaHa25eLa9l1gAA2MSRXUL9hGo5ra5+gvt3+/+15Fx+5+hJi6kBrKL9R3as+/2Wl2j44l4hZCu16j5CnfleVJnrTv8Ht7ruShEquPRfqvOYfhqXy5Wk+wgAYBPLAmvFihWkZCdMTpnVtnrojWmLtuHH5Jff6NPVB1eU551VogF9x4wKCXDTaPt4PCqk7lTj1EJIQ4UXxcsvHKHeA1+hdqcfyd2pAwAAWMbiFlYrZZYVeF6+CBXercTdwIz8u6TSTdQ3CNVIxX/V1pfduHyJqeR3G9gJ/ZWfW4bqy65/99r+PSfvMSsAAKxiTZfQ7pllnU69ZsUGy3O+XfTj+bouXT1Raf7dWtyaGtJ/TD9u9idHdn6uFPYmmwpGPT5pKDr/7v5/vSvmjBoyaVQnsgIAwCaWXYfFRNUHH3zALLbIAXdruHvy1Jf7awe+NXZQuPLqJ0d+dhv4yoJwT7ISAMBqFrewzE8rx/Ab0ndgD83FddT4+jl5+JgZkFYAtBusuNIdAAAojrysAQAALAKBBQBgDQgsAABrQGABAFgDAgsAwBqmZs1ZuXIlWTDC2H37dH6FeQkBAPZjKrCYeQnJcjMmZvfSwYH18MMPkwUAALCNWV3CN2m4MPG9Y8yDqQcAgLbUcgsLR5VarSa1Rpi4pzu0sAAA9mJWYHE4HOv6hhBYAAA7suxTQrprCH1DAIBjWNDCwoX169czX8lGNGhhAWMOHz5MSgA0M2HCBFIyW8uBpZ9cusDSta1S334CAgsYgwNr+vTpZAG0a/v27bPoXOPtrQislruET2/4hZToLiFTwDnFPJhFAABoAy0H1nfJQ0kJIV1nEMawAABtz1Rg4c4g7u7prndn0or5Ci0s4Ega8l/Q0RgNLA8Pj0003QUNulaV/oNZZYnL2xP1TJ+18qucarKqFZRl7Xxr1lT8jabOmPPWzqxiurI4bVni9st0EbQ9xaWvV74yZfzo0aMnzll/KE9Bqs0kSV2QnEpN+w06Igsua9C1qvQfZJ2FEt9LI3Yti/x11bfZpN7e8ncvWyceuO7bH9LSvt+9eqB43WsbM5UICRM3ps2LJ9uANqX4fcuclb/1WrLzyIkTJ/ativ4lKekrCVlnloqbuS1cxgzaMbMCi+kbGkM2so5PfEKvanE+1fKpzNq57Dm6MfTcst3ZdKuLagptPnh09YypiVPnbcy4Q9VR7mRsnIe3nDrj77tJ84zacuW6tVMTp2/O0r2fy8SXy8KHPBLO4yLE5YVPfnm8R0bWtQctrOLDy+hmHrHsMN0Aa35wYDeS9O2pokWrnovzp5Z4oukrXu91O49KrOLUpNFbyLxsv28ZvSi1CBc0FWf+OYdqjE2ckfxFtgIVpS5KTkXZW55PSsXnSvbT+tl43fgpiz/H6yjUQT7ed3LNrPGjxz+/5qfc7M8XUBvM2X7JwnYccFItB5aub2gC2dQKlVm/nufHdReiqoyU1eIhHx3Ara4N46r3/vfnSrLF8QM3End9n5Yyumjj+weluEKTs/PNbejZnWk/7E7udvytDRnaLcW8obvT9i5K4JFlFDgkMUG6+x+rd5+8nF+JYyx2ztdpixLISkw4YSPTzkvbuzZRGDukj8D4wYE9lF46faPnY33ptGIIn1yyfISILDRzdc/64kk7U0+cOLi255n1qTdCJm7eMBH1XPhVysTA7M+WbSoav+1E+t43I9KT1/9UQfb58XTFS7tTDy6NOrN+8WedVhw58Z+ZaP/nP5WS1YDVLOgS2lHa26RRM3XBTsW0dc/0xE2tYavTNk4JQ0hdzfP3R/VI207qPnVKAp+LwkcnJtw8exn/Xr1+9rh6TOJQAeLyE6ZMDc/KEpNpnyNjY/kIN6YeEAx7e3fKC3HFP21MnjUVN9x2ZhnKn+rL2xdsRK+vmdKVZ/zgwB7q8f+jREJmwQzuPN79OxKZGnGjXvrP7ue6kWqK9NKZ0pEzJ4sQ13vg9KdE509dkjMreo4cTlX2fCgKDZ85PRyhbj374mrqW4M2taIxUmsbxwSWbgzrwNfblk3ozqfqqnO+WjlremLiM7PXpeoPasRFdqb/6yMIof+Lamqrqw6SvtwrO/NRUQV5p0aFBzIFPVx++NAZy9btPvDDgZ3vxItXv3XwFllDaIrT1qyTPr1xXj/6pzB6cGAPHt7eKE/CfPShY+Ijv7iZG8ZX71k2xcDwfHl5EXKjOvtYaFRPpFCQXy1RImaeJi4P8XSNbeAA+lMC2mt6QMcElgE53646IJjzH5xhe1Oe1x8Qz5My7++qSmpQgxqNQrzIOTtJ4mEbE438xlaf2Zi4IZO01Lg8QeyYIZHSYv2ugaYyM+WtjMc2rx2nPYTZBwfW8I3q1y379CVt7w1T/LRm7PozNWRBQRcU9KmmeUc9sWTD3iMn/jvX+2DyHjGppQQEhKBaNRN2srxs5O3tQZeBM2Fyyo6TmTpNYKlraz143vg3YlX+3kMZeJHUo5yMM9TIlfREWlbssAG4DdVr2PiyAwezqPFw6aFlU5/bmWPkVzQvYXTin9s2/1JMva016uJfdh+4lRD7oFuhvrxj0TaPRWsm6GWS2QcHVhGNnTdRsnnN12I6s+R5+97flP30pEc9mcbX+fNXFUgjST9CBt+LDiVN2XhegU8Bbi4h/wBvprqCyrXwvo8GndpzSII0ivP7vpcMHNnXl1kLnIt9p162LLDs1RE1oNeURX0ur5uROPXvB4Uz58UXSKUkKQbH1WycmpiYdCZu9Qq6ucONnfPRLMWOWbjTlpQeMnvNM7GNxq30eMTP25gkOLbsmUmJiZOeWfQdmvFh8jABWYlQpfR6ZeXRlTOYDiC29bIFBwdW8e6/cNuqnhdXzxqNzVp/MX7tztk9qRW+IxYu6nl6zZTxL37u/+hIelsUMuHNherPZozFW25RzFpLDUghUb8n0J5XklLLes7duDTkyGujx85YXzh27d9H6I3kg3bL6B8/G8QElvmRaesfPxenLZtzaxZcM8Va8MfPHYez/PFzc63YzgIAAOOsCSz7dkpNgUvSAQB6LA6stksrAABozLLAgrQCADiQZYPuloI7jnZwcItkYII9b5FsFxBYAAA7smbQHQAAHAICCwDAGhBYAADWMDXNl+5u7i0ydkssGMPq4DrgoLsVA8nAfC3PS0iWjVsK8xICIzran+ZY9+cmwHwtdwmXf7vd4IOsBgCAtgJjWAAA1rA4sP72+JOk1I7BPbAAcEqWBRZOK6F0l22Z1arzEqozN2gnv8GqMlYnJs75lrr/n3ZxdUa+oUkJL+IfiqmUpi1emVb2YGYdYFeK7C+SZ0wc3WiqG62iQ0njN5Nb9wFgkAWBxaQVLticWa03LyEvvn9CTk4+uS1y7hVxQoIgi5q5gnIj50psQlx303eAqLh1XUWKwN7UZ7ck541IOXjiRPrupV1Skz89o51qRJH3XfKcT7O1iwAYZm5g6dKKoV+2iel5CRGqzt6dNB03xJJ271iXuCyNRI/xqQP5vRJiL4oL6HLO1bNDEp+Jk2WJq6jF4gKxICFeqNd0qr5+cDX+jtNf2/krc5dxvG5lGsrZPmcZ1chC6gJmSsTnVh+8Cf+U7IA35M0j7z0ZQt2Y3//R4SPUZ//Mo+uzt89a89eIVa/Qtx4FwDizAqtJWjEqfltFSrYwPS+hMnPbP47HrdibtneZd04ms0cLUwcK4wfwr4ipKVellzPj+sTEJjx6JesKjptq8aWiwX2pm+wSmpxv1+5WPLstbe/GeMRMbyBM3Lg2EcXO27kxkZqAJ+Oses7eA3vfGije+Xmm/fqtgCLJv4QeimZmJOw5e+/ut58UwRw3oCUtB5bBtGJYnVnmzksovpIRkDg+gY+44eMnD2P2bWnqwPD4wUWXxdWoKl/smxDng+L6DM68gvMoL+fa8IRoshHl1uXMsmHPjBNSxxlvcHKcPokjcMDxE4YORwoFTB1sT7LUTV95L1wwgkwrAfNxAfO0HFime3/WZZaZ8xIW38pDvnzmvczjk/d2i1MHxvYdfiUnr/pKlhR3APGOfRL6XMyR3ikQ946N0p9RoqKyGPHcmBoP/oO5KR4IEfiQErAn6b6ked9HrVo7MZRUAGCmlgPL/5E1ph9kOxsZmpdQGBaF5NXM6JG6WtvEaXHqQNymuphz/M/MAT3oDqBP9zgkzc+VuvWPo5NRy18gROpa5gqG+lrdtGKgVSmuffbagtOPbNy2sL/2NxAAZjN30L3VGZyXMK7PsPK0I1nVSCM9kqodw2px6kCP+IQuF87mD+4TxyzjTmLllYvqAX0aB1vXwYldM749LEWa6qyDB/JJLVZZDdPTt5KKn9a/lf3k9pTnYiCtgDVMBZZSqVxqBrK1jQzOS+gx+LW3h13+YEbijO1ug7VjWC1PHcgf8Lh/gW9CvHYq4Ni+4RnnBfFdyaJW+JR/LApJT0p8anZat6ljSKWozyi0dwHzKSGwM8nRz8/XZG95kZqTkLYFLrsCFmHJHUdxI2jL7HW8tw7Mhzl02AT++BnYl9N0CQ2qzNy8YAZ1adakWTtrZ214EdIKgA7NuQNLMHjRp3upS7PSDmxLTmQ+TQQAdFjOHVgAAKAHAgsAwBqWDbqvWLHCorlU4Y6jHRzcIhnYl8WBhb+an1kQWAAAO7KmS8jEFgAAtDFrAsuiXiEAANiLxYEFaQUAcBSWXOkO2AkG3YF9QWCBVgR/mgPsC67DAgCwBgQWAIA1ILCsBXMXAtDm2j6wWnVeQow6/vaLZAErPrwscavxCQZNzz9oeK127kJgMcPzEiqufZ40fTyunLPup6LGvwmKDiUxt87SSkotJatAB+SYFlarzUtoOaHpaQoNgrkLrWR4XsKKn9YvT4/6+94T6Xvnen+WtKvRuyFkcsoJrZSn/f2fnjsxiKwCHVCjwPrVTsjhzGHveQlb0HxH/WkKDX6vprMT6s1dqN0CmMngvITqa7+dD5w0aaA34noPnP6U/6FThm9DeuPrTT+PWDUb5i7s0BoF1v/ZCTmcOew+L6EJpnc0+L0oTWYn1Ju70NDUYMBM+vMSIk/tPF9cHk+dJzHQ6VOf2bsnZPZTPZveDht0LI7pErbmvIQU3fGxOZ/lkFrTOxr8XhSYnbAV6M1LyOvdt2/+99+fVyCN4lLqD1SHsJ7ZSE/FqR8uTJw53J8sgo7KwWNYrTEvIfZgjCwtbefcWFJrckfD34sCsxPaW5N5Cf2fXLq876X3p4yeknxR9GhPFOLf7AUv+l963qjHoHkFHBNYBthxXkJjTO5o+HsBezM4L2HIqDd3pp44kbrtpUBFXmhXkSep11JkX8gbMQBGr4DzBJYd5yU0xvSOBr+XUTB3oVUMzkso3Tdn+sfncWtXI9n3VXrI+EfJwNYDeX9e6tsriiyAjsxpAsue8xIaYXpHg9/LMO3chfApoYUMz0sYPn3tPNVns0aPnph0useqDdOYvLq0ZXRSKvMKl0ry1CH+vnQZdGwwL2EzMAei/cAfPwP7MhVYo+eOJqWWnPjsBCk1ZmtgVWZu/kdKxs1qNeKFD529bH5rzvTVlt+rw4DAAvbVQmA9PHwaWTDuj5/3t1ZgAZaDwAL2ZdYY1h/X9xh8kNUAANAmzB10fzh6ZpMHWQEAAG3FrC4hbkw1TyhdJXQJgTFwi2RgX+YGFlPTBAQWAKAtmdUlZPqAzR9kNQAAtImWLmsIM+OC7lse0MICALSBFgJr86odZMGIH/848OPhoxBYAIA20HJg4Ugiy0ZAYAFjOuCgOzCfFR9QQAsLtKKOduFoR7Zv3z6LzrV1F9m2POhORZLxB9kIAABaXwuBtWjNy1l/5OA2lImvZFMAAGhlLQQW7uuV3i5o8SvZ2hmYvjeWmXfOAs7JitMHZ7x9MRVYTBKZ89VS1dfTNi6YQc2QM33Wyh1Zxc3fVaanCzTM9HSB2rXWHBnYy6Ut5E5YtIkzkr/QTU5omiR1QXKqOXNBFqcmMbfZMn8XwB5mXThqX9UXt89bnhG+cDs1Q87XG0dXpbz2ZlrTzLL/dIHatdYcGdjTxA/IPIMndr8ZdWblnmuk3qSKm7nM/atbIpyYcmJhX6pk9i6APdo+sKTHdxyPX7JmRqyAWuIJhyWtm1G9a/d5Nd32Wblu7dTE6Zuzbum1gwxPJrhu51fL6OkCl+3Nwe/LRtMFNpviUG/tn5YeGbQa376PPKTIziuiyrKf1s+mJn9+MCM01VZKXrN6/OiJazcvTE5F2VueT0q9pqv8GL9lKs5/Rk8ZPXr89KTPr9G7kRZWUeoi7S5wY9h2pM0Dq/jy2ZuDByfo3RyPGx6f4JZxUUwviHlDd6ftXZTgRi9hRicTzBJ7J9HTBUp3f9t4ukDP5lMc6q0NJPvTR95cNDalpSODVlNx/vQ5755RIUiT/dmyTUXjt51I3/tmRHry+p8qyBbZvBF7TxxcuWjLhomo58KvUuhpn5nKJQNrftq0Mvuxfx7BbbWUCYqvd+r2wkImbtbuAtNHtiMO6BIi5M33ICWGIDCclFBkbCwf6d9q3ehkgpHDHjUyXaDBKQ6bu3U5s2zYMxPCtUfOuFzFrDB+ZGAPqSuYEazR41/9TPH0hpm9cbP70pnSkTMni5jJn0XnT10iM7BF9YrzbvR+oGgrfUesPZEyHZ8rtYI60RojJxo4yIrGSK1tHBJYiiZTzqirdXMwR4XrWkAMo5MJNtvyAQNTHBpQUVmMeG7MP4bOkXE4nGrosqkjAzvQjWEd2bfzzclR1Pw55eVFyI3HnIvQqJ74XJB3SJSIalI1oatUZH+RPGPi6NFTZq05aPxEAwf54IMPSKlx2RZtHljC+CFdMzPpubYIjTTzdOWwfnFksQkrZiE0NMWhAf4CIVLXMoP9dwrEyNu76XR4oK0EBISgWjVzLmR52fhcNG6DGybes/I7/7n/xcl3cNvf6HF24GSYnLJXWmFt38IKH/PymMsfr9qbQ7eq1MUZKW/t5c+eNZCZdLkZy2YhpKcLNDjFIaXxZIJh8YMDM749LKWmyTl4QJowLB5meHaU8L6PBp3ac0iCNIrz+76XDBzZ18CkXhXaJrCWSq32dKdOtDxvz76fkLp5j7DZLqDN2TGtMAd0Cfn95m3/cJh0C/X5XOJzy074JG1bnyhsOk6hZcEshNrpAoMMTXGoW6u7MAcfef2ikPSkxEmzNtwYs2rJMPpjS+AI3J5zNy4NOfLa6LEz1heOXfv3Ef5khY6o3xNozytJqaVkmfLQU0vjL66ZMnr84u9DXlzYN18iafTLTLsLfErYbiD0/7sIM8FFSPnAAAAAAElFTkSuQmCC",this.options.images["Gui.Office2013LightGrayCarmine.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013LightGrayGreen.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013LightGrayOrange.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAZAAAAFACAIAAAAd4720AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAQShJREFUeF7t3QtcU3X/B/AfG9sYm8BAYCCgIIiiPt61vKZG3go1LXvyMZ/SMvVRK7O81GM+RlRmT8Y/L6X5mGn5ZKbk9TEvqah5xVS8ISh3hjAug8HGxv93zvltDNjGbrAd+L5fi37ndy6yc8Znv9/Z2fm5HRocggAAgA045P8AAODyILAAAKwBgQUAYA0ILAAAa0BgAQBYAwILAMAaEFgAANaAwAIAsAYEFgCANRxzpfvY5CxSasrhIaGkZAdRaIRnWAQuVGamV2SlM5XNquX/RQBAY44MLPNhZMkylnBWdkBmAeB0LOsSOjE18D+H/1FcwL8A/jWYSgBAS2JTC0ufVo3VampqFOXK/OzqRwWkyj6C9oFCaYi7uJ0b151U1QftLABaXis56Y5jhect8Yru6RXVnVTZAW8Ebwpv0FRaAQCcgmXnsIx3Cd3cuAKhh7/UMzQclxX3b+OmFpllPdywEnfuimprK7MyqgrzNdVKXGZmwWksAJzLkS0sJpKMMjPLKsZPJNXWaqoqqVnZD/CUR0AQU20bZvXKnId4g3izkFYAuI5WdVkDVyjy7ft4bY360R+/kyrrtR80ws2dV3zlnEZZQaogrQBwDaw8h4UjozD5N/xokB1a3H3DdG0iG9Gra6urmCmGqX8RANCSHBxYuAFl9EFmNzc36ulo1WpmyjZkdTc3egoA4EJayaeEDIFfAP6pLi9lJm3DrC7w82cmAQCuo1kCa2xylqPOsluIw+MLg0LFEV1wubown6m0DbO6OCIabxBvlqkEALgC1rew/Ic8iR9+A4fjiHHjuivzslSlxWSeTfDqeCN4U3iDeLPM9sk8AIBTOeZTwshZb0W+8iaZMC3t23+nbfmcTDgISROttqaCutK9SpZHV9vLIyCIutJd1A5xqEwvTP6NqQcAOJFjAgsAAFpAqzrpDgBo3SCwAACsAYEFAGANCCwAAGtAYAEAWAMCCwDAGhBYAADWgMACALAGBBYAgDUgsAAArAGBBQBgDQgsAABrQGABAFgDAgsAwBoQWAAA1oDAAgCwBotv4Df6ZCsZcevYE7oRYQEAZkELCwDAGhBYAADWgMACALAGBBYAgDUgsAAArAGBBQBgDQgsAABrQGABAFgDAgsYFSqEEcHZoW0dKfsDa83Q5Kyxho8jP3aa9uPo5BM98Ex9wVVcT507OTWFTGDFB5de+uY6mWArfAhuDphGJhxhwYAj+3oMIRMtq/7L6VTa6C0f+pNZ7EI9kaHLyUSzaRVHypqUcEwLS3Eg9PAQ3WPMCw92vXBsyMgbZCZgnTCBWECKzqB/Of2++kdlx5lRb4aSGaChVnGkrImL5ukSGotM4YvbRvxGh/HBQzHOeU9ogib31I3lz1+a+/yl1TtylHRV/qGrc7+6d+KTK/MnX3r3k/S0O7dXUQtc/e66gp5vZBUnonb7lcFbbtLveDcfW0jv5ZCZfXYyNXXvgUaOBb3uyF/wYldHHn1BjLz8Fjq21WYL5dH3ymRIGDEOd3zC3j8x+hTzZn5z8JujmAX83zxEVeKa/1yhmvZ0pQu/0ho/iyG9dmWN/HQSM7vzhjSmbOIA6f6mlp+gn+xrA4643pGqeyGd6NG98RMZ0md31ujE15i1or5OG/ufD4UGT63R8pP6JWWNeJ/OwXdPjE0+0VLnsELe7/PqKHThvd+nLcgriQp7d5vL9bu1d+79+/80j3/e66utAdLf8tafKiUzflOUTe+Z+L2v9Hzxv7dyZ/23zzvPo3M7CgqZVb6uHf91n4arOJG/sHLj2SEz8/K8fJ58LQhXTP97oPh66rTQw69tU3Z8ofNsM8fCX3tj5uEX487H/qhAZUVfdr+4i8xwFq8JiT5BSJl+CI39sPPYgIqt4w4PGffgnsAr9rUwPHtAYszUqOqjC35/baM2SNcdceVXmpFnkZx9K0vQdTJ1pNBrvhFlZb/vZZ6C+61PzzbxFL6+OMb1jhSFeSG9dL+08bFIzryVxes4hH5Gr/l0FCjubqp7ozdy7PYWPSwThP4Vz+wU4q1WeDsmsMQT6FCkHib6os8O9uLeKFi+TZm999r+S2q/KP8BZE7Lq9w0+dJc8kj/9Q6pfXi9UjFCMiGExxGFTZjETTtVVMbMiPYaTFV6RUagvzwXEYK44dG4Fa7VIHTnXKXmyfZDfbhklcvyamYVJ8Kv+MQydPzatTQkEFC9BWUVEnh7jRzldXv12Scjz282cyzKKq8dR9lZTm8p6l9Og98dxb3x9b1/Z6HDM08M6X5+6w1h31B1eRni0l2D2B5C5Y2C1XuVtxPvXchi1nWpV1pDxp5F0eZkhV+UFP+S00Z5VV8vOIBzrZ+Yn/Xok8Qy8hR6Bo4lG3A1Ro4URfdCMnYsipLvVTPPCD9fcVrJd7oDhxlb/sG9TI60exAaIgmqKr5c5ZjAMjiHZaIvKvZA3B6dmFCbP4SHvN2dd0sVzzm/9N9AHhHPRJPa0mIt4rkx+yM4QoAUmkq6jCL49Js3h8tDHD6XriKqVVrlvhwm+1b/R4MK1HIyx3lkyt2kRHy55sENj8BXtg0+lTYi8X3qqZg8Fo3WdZK6l9Pw7r8vWI3bsgiNitly86lTWSMSv+7Uw4teCnUKCkCaKjVdLlLq3itc6ZXWiJFngbK/LHkY6hU3pNPQnuhhcjauCcDtiGoNVUJoZ1Y1EnC86bLrMXakMN0LyeixOHyorMhfPGRIUL8uvIeX7jNPk2F0+T03cKAHhIwS8jPlVzIdE1hNw+0RRfJt5rlRD+c3Yhvy9uUgda2WLuemVyMx15Mum4F3nv/fO+myr/+Gj6OkZI4rOX578chjI0PPfvKLpttrUQvZcCwaW7gkrGtp4Se4MxWack7G1D3IkyGuB48u+wl1555d+dkZexYIZd2/eEPQ+TW/jqjszNdUhaxUiwRcph/4YqgAVWvJuQYBj24tBvm4aoA1YPxY/Ih7ecLOM6UR/oobX9ZrzhtdPntvRV6AcE53YWnWg903WyqwdiSXCfuHvD9JiHp0Trw59tShGBc6tUDr2NNT/Lv8QLZaW5F5YK8mcrif7i3QpB4jxIq9sosVeD/Lfl166a3/5DB550o64b29KzEoBKlVeKpaW27hsRBw25GSSxB64FeztuSGMPb96IG6j6KO3lAKewTiJ9J1QUQ/XaUrv9KMPgvca//psiJglL/geiGTrYcvK1Sh7d9d4BUyqdfT/XlF1wsO4x5AtRaFeo0dhbouCOlheP2Aix0pQyaOxYMr97Qho/wD6vcHMePLJ+enl4kG9tTmJSP0n5YKrOz3bmxN5o5IHJF8KKpbadGuNamGTUFXwImOevMf3HNvXZv/siz/yaBXhzf9LsaJ7vzWdO0vL1+dOznzXKD3vOc6tNTutNyDT9YVcsf12pU14v3J3CufXttqybG4XJ6NfF52/mdPdXb8UCgLCPo0a8S746qPJ1eLw7zxS/nigtQDWZ6xiSO+fhnd1730XemVZnBul74my+izwLI3VRQh9d3jD+gplL366jfHa7q9Mxi/0/jcy0x8j3oGh9/LuFgoHLtt7Ia/avVP1gWPlCFTx2Lr2TKVgJNdvz+ImVg+7/JdJBYo7+7FrVG4RbLzwS2S7YVbImsTgzQ//v7iEqd/YmCLIYkjEoYoPul7+QCpAKa4XpMAAAtNSBx6hG6/7EoM5CY/+IqdaTV771OfTuJc2ZgKaWUBaGE5H7SwALAQtLAAAKwBgQUAYA0ILAAAa0BgAQBYAwILAMAaEFgAANaAwAIAsAYEFgCANagLR1vNFZgAgNYNWlgAANaAwAIAsAYEFgCANSCwWsilS5dICbQicFjtZ9U+hMACALAGywLrViNVVVVkHgCgtWNfCyvGAJ7MysqCzAKgjWDZdVi4ScXkVAO1tbWkZI5W+ShPJleqtfh5c/gi34AOPh5kVrPDHfX+/fsz5by8PKYALBQURI006jr7jfl9MMPD2hY0x/O1apusDKwLdwpweWB0IP6ZmppKz6kTHh7u4WEkiKpkWTnyGo/2gVI/TzdVaX5WYRW/fadQn5ZpZDYILE/PeiMctimVlZqwMGrkZgtlZmbqA6s59pvNvw8GgWU/q7bpmL/W4uLiewbwJJnRPHBUMWnFoHuHBJ400UksLSqt5rQL7OBHveQ5fO9gf7F7jUpBz9OWFmTeS0u7k5Z2P7uIuTF4WW76nczcnAyq8l5mQSlulakKM9Ie5pH7hpdmp+vLAICW4ZjAKioqIiVag0mHwy0s5kGm6wsODjaSWeVKlZYjEBsMjuolDQsPoMYe1MpzC8o1Qv/wqA7e3Gp5XgEZ8hmplGpxh6hwf2FNuSyvFPG9PflqZRmdUuUVVW6CdkJ6MQDaLvqjL5PIQo7jyP5QFxqZaE5MC8uwkWWYX7jFXlNTk5GRwUwStdpaxOMbHRu1tLK6li8O9uZyhP4SIUddVV7BzOAIJf5CDtdbIuJpqyvKEN/fU4DnVuP2V3mVm9BLzCwGQEP6v1VLCpZrvEozbcSqzZLeTSNktq3eNca6wKopS68pvYcfbm5uht1AMtsAmUF3D/HCzFo1pWm1qhKyhB0at7D0+UV2VeOdxeVykVpVRqZoWk0NPVKzGmeZmxuzJ7z5PKTRaOgyDjhmMFURl+wmjq9QoFbKVeXlVchD1ORQ9gC0Efo/ScOHgut78W6B/kEWtY+VLaxa8qeMNe733aWRCZ36i9VqlI9I0Q6mWlj6B6k1JPJw52irFbreHqZ8lH0/S4abSzyOG6qtZUaZL1Wp6Wyj6QKuQqNFbnghKrHEHjVV8opq5NHOZQcIB62Nw9tEDqf/kzR8iDXFA7oE6h9kUSutrc+RXULLWHL9gdUa7ClSW4+3n7dAW16QU1SJQ1dbKc/JLasRerUX4DmeAjeVIrdUo1UWypVankc7EbOKtqqsVIM0pfIKNVcgogOKbmMpKrQe7Yz2LgFoe1JN6NatG1nCcVo+sOxFdgaNVFnSwkLII6BDoMRdVZSbcSctPVteI5AEh0io58+RBAe24yoLM+7llGoEEqm/rq/H42uLMu5kFFbxvKVS0qDiSAS8WjchtK8A6zmkmYZTyRSyhIEraYWkZCsbA0tdcpc5xW4JvDBZzW5kT+jorxe1oIWFccQBoeFdIiOjIyO7RHQM8RPqnj3HOzAsiq7vHOLnqd8nHI+wCKoyMtRfrKtUFilVXE9vyCsALKI/gVVYqnSjzqvYxcbAwnAMWfggK7QC8pz7maUakV8AfD7oUPiN3RCpdR7ye+iQWmAM2UfG4LlMVA3oEojTSlldw3O397pf2wPLdZD+YX1kns28giOiQ9uTCR1Jh87RkeEdvFrDXnMluLFMSvXLzuJqv4+LIx/MN6L/ZBAXHsjKK6trOgbY2zVx/J8ez6eL+QdZzkHw68kUsgRgA+Z4uc5Rc7Xfx8VduJPf4IErB0ZLmbnUp4RRAV1DJe2EPKbGZs3SVmCubzBKqYSvswDjXC0dIK0sh7OpwQNX4o4OczWDvqllv+bq3JDz7fXh+ry8PLgbDGg7Gqdeq8zBBs0r/CAzmOaVrRdhNdbSZ2OCgoIgswBoZRo0r/CDzHC0lg4soVAImQWAVSxpprXWDuzi+lo6sDDILABaE+Zz+cbIbIey7gZ+NaVGvufcAM+ny9271GWlZNoAriclnaioKFJq7eAGfnpwAz/2aiU38GvAzcQFrcypdz1SCwAAlmnRwAIAAHs44RwWAADYplnOYaWlpUVGRpJp0+7evWvPOayMjIzg4GCBQECm6bFzHjx4EBISwuPZe0GtwzU4h8UUgIX057CYSaeDc1gOZNU2WRxYt27dwmkVHh6u74E+evQoNzcX17Rzvbu/tLVXdhsBh9V+Vu1DFncJhUKhQqHQ39G0qqoqPz+fw+F4ejrq3sVaLXMbUgCAa2BxYPn5+eGfOKRwVOHOYE5ODg4YHx8f/R2OG9EqH+U8ZIbzupuemVNi9jKw0ty0h/nMKGAAANfA4sDC/T7cyMIhhaMKt7MqKipw37B9+4a3hNGrkuXkFqncfYPDoyMjOvm5Vz3KzSox3YRSazTNcjdnAIDN2P0pYUhICO4D4qhiTscGBgYaHfOZZnogVWrM1CwyNoYsKy0ttxyV56aVVCNtZV56br2BdgAAzsTuwMItLH9/f1zAXUIcVUzZODMDqRrRLjjSR4A4nkERwTDYBAAuw9rAsuiKUFe8cNTMQKoAAJawLrDcvSPdvaPMP3BjB3fTyArNrKqqqrCQGoeDy+XiskwmY+qNMDOQKgCAJZolWdRq9V0LkKWtV6XS5Mkrc4oUmbkyrVYbGBgYHh6OU7KwRJElK8+XV1ar6wZ8JcwMpErRaumCUgMRBoDrapbAirIYWcEaiir1A1l5iaK6rFKt4bUTSwJwYHl6evoEhHA9fRXVNXJFNV5AqaohKxCmB1KlGl81VaVVqKZUXqkmi1NqDQa6BgA4Xwv13RyosFSJe50SsSBQQp1Br+F4aLW1Gm2tQkXNDfIV+YgFuKYQB1B9JgdSFflLxByVPDsto4Qr4DMLI+TpIUBKGXxKCIALYV9gVaupXlugj9BXLBDwuDiq1BqtqkaDU0zId/cR8QO8hXgB3G2kFzdkaiBVjleHcKoyqmNgSFhkZDD9vR5P/06dI6PhU0IAXAj7AovHpX5n3DHEIVWt1ri5IXcuh6nEyVWj0VZUUZ1Bnjvc4gaA1oZ9gSVpR92eIftRxf08qrfm5SngctxwZok9eDit7uWW5hRRV4NKxKauIAUAsBULA0ss8PMS4pDicNy8Pfm4b8jUB/uJ2nny3dzc3Dlu/t5C3Ddk6kErcOnSJVICbVtLBpZjbn6Ae3oB3h5dOvhEd/DBIYWTi6nHhRA/UdcQn6gOPu29oHkFQCtkVWA9yrpD3+qAedy9n5FZZPG4N3DzAwCAvaxuYQkk9Kds0ZERIT686pJHjyxsNcHNDwAA9rLqjqO4hVWCJJGhAbrpB2llvMCIDiKFLKewpJpKJDeuh29QiG+NLFNWVq1FbnjaJyiMX5xWQF2vSX+dWFpbkC0rV+Ggc/eQBIf4kXNQrRzcmtIeluy96urqGzdu4IKXl5dt1yTbAA6r/Uztw3fffZeUDNh+DktTUahUufEFIlRRWCRX8wPCI6PD2wtrq0pLFEXyMo2nNCoyMsKPX11SJDe4+YFYnlugqG0njYjq4M2tlucVGHxZBgDblZSUMIWysjIcXkwZsNraRqxuYdW9ENw4fJFvQAcf/fltrapKUZgnUwoCJVqZHHn7+0u8Bbq7f+J1y7g4sNTZ94uQb5cQCa4rzU3PV4s7dQyoG0ei1bLkrfjy5cukhLveAkFQUBBzV1WbGW4Q69evHylZj9mUfgsNJpubJXvv3r17OKpw8wr/7NSpk527zkKmfrFbt26RUlMsGWK+dW/NTAsLJxSZ0LGrS6hTVZSZV1Klqa1FHI6b1k0YGOmryZXJFSoN0oeaLrCqstLkhu9+beWeU9YGFqNHjx6GwwLZoKio6MGDB56enpa8+MxweGDh7ptUKjVzh1hDTe49pj/IpDx+vi3WK7TksALzrAosR1zWUPSoRMkR099uCWnnTld5+ASHhXeJDO/g5VZZ9IgME0FzQ4jrGUCftqcf8N2XhnAK4Jxi7kxfWWlvj7mqivog13EDc7gopj/Yrl07b29vvOsqKipqahp8+x20Bty/hXpF/H0RmWpCZVlRFRL6eovINFFRWoyrfSRCtbygSFGDeFxlYX5xjdBL5K6pLC9XccQSLw9qXTdPXy9JTWWRokojbCfilGU/zM6vqJV4ebaBb9Hk5uYGBweTCROYGz3jxXBOPXr0CP/hhYaG2nlzsYKCAtz68PX1FYvFpMom+t/N6GSTNBrNn3/+mZOTg1fk8/k4QGUyGX5qGRkZuBLnC+7BlZeX425dVlYWXqbBlpvce3gV/DRxk00kEuHt4JgWCoUtENOmfjHcUcJH0BRzt8Y1zTW3aX4LhkxtzdQ+/O2338aMGUMmdBzRJdSWFTwsLFfhDiFf7MNXFqvEnX20WY+oDwLdOPx27UOCvDiosvBBXmm1G+4ABmrzcwoV1KeEHL6nX0Cwb5u4yNPaLiHu3URERNj/J5eSkoLDAvePcC+JVNnEUV1C/MLNzs7u3bs37sHhRO7SpQv+9VJTU/FLFr9wcYcuMDCQLGrA/N7DjSm8NbwdMk2TSCR4B5KJRm7fvk1KtK5du5KSlaBLaL/m6xK2D41ufAILb8MrMLwz1b+LCpP6S8Ojw/zdcU0EVdMlIoxKK6zu5gdcH2lYFN0fjAqzIa1qimXKO9cqb16qfnhPU15Kalsd3F5IT0+389MuvDrzZ+z0LiH+NTIzM3F6Pnz4UJ8suN2HMws3uHCYyuVyXGM0rZpUWlraIK2wsjJzNwYyTCib0wq0POtGfna62tpa5c1LtQbf8eH5B/Gloaj+XeS11VW1lQo3oSfHo/n+ULVarRXdNctbWEyzhfnMq3379h07dqRn2oI5444baz169CBVtrKzhcUsb7kGWza/95h9FRISos87pl3Z5GeFuJ1lZ1qZ+sXs/+zMUOvemlUtLJYFFqaRP6rOfVBr8I7q7i0RhEUxmVVTXlLzqICD37WDwhDHcETVBtdkcAU+/h0CxCYDpyw3PU/jFR1q4kOs0ty0YhQQbvknBtYGFn4dVFZW2hlYBQUFuP9l50YYzO+GO1m4q8VsFjeOcM+Omdsk3LzCzT3cM8WFwsJC/Bz1XUKVSoW7hOHh4RkZGfj3NPq5oZm9p+8PGnZ7cTsO9z0d8sTNs+SwAvNaeWBhtWqVWparLpbhFhdTw/ML4ApF6qICrUolCIngelOXedVneAJOq5Ln58iU7r6hof4mburQRGDprtJohsAyxAQEmbBe46aHzZhNkQmaVCrt0KEDmWiKUqnEbT0cwcx1Ukxg4aYfs01/f/+wsDAcMTho8GTjKGy89/bt20dKlpk4cSIpORQElv1af2AxtFWV6rws3KQi0wjhDqCgUxcO3+iFSw0/MajMzcit8uwQESjEmypt9G0hg8BqNLc81/pvGlkbWPiP1tQZaAs1iD/Lu2+mMM0WpuyQELSc0cCaOnUqmWjK7t27WziwzHeUbLsmzjW3CV1CK+DMqn54T1tNXWrk5uYmCO/KFZtq8zT6iFOec1+m9caRpJVnpxVrvAJDA7hFmbmlWnFwRKCnPrCMztW3sMRG5xphSWABU1gXWMByZgKLlAywOLBq5I9UupNZHB5Pq1ZzPYSCzt3d6EsuG2kUWPpIKjL2baFqs3MFusCy+JtGrH5lN+6r6tnfcLOE0cAiJctAYLks8/swKSmJlGhsDSx1fpZKlsuUeX6BvKAwde5DdbGMH9CBJw1h6utrFFg4iR7VUi0smbFvCyFdYBmd66ULLIu/aQSvbHu47N6Dw2o/q/ahXVdRO4umWFaXVpL2/A6d3Dgcfkg4r71U/SiP6SE2qbxKVcvjUxftm/+2kD1zAQAOxb7Aos5b5VKfJWEcoSevQzhTxvjBHd0l/qo8Mtc0TWVRziNFraCdhDpF7ufpoVWWypRapCnNzki7m11Ud5mXmbn0MKvm1wUAOBT7Akudl8VcOOrm7i7o2AW3rZh6Bm5tcdz5GoXxq5yr5cz9nTNyi2t4ksAOzDUNHL+gAFFtaU76nYxCJdezfXs/w00an6sbZlVhdl0AgEOx7BxWrUZTmXqZufzKI6wz18fIZVK1tbXqnAc4uRpc/u5ccLLDHnAOqxVrzeewatXVTFq5+/gZTSuMGukrINhUIwuwEYQCYLAssNzc+W58Ps8vkB9i8ov4GIcvcPOAkb4AaG1YF1junl37MB8LkioTOLw2cN9lANoYOEUMAGANCCwAAGtAYAEAWAMCCwDAGhBYAADWgMACALAGBBYAgDUgsAAArOGkwNLkX/xm2fQp48ePn/Tcks0XmfvuXl0//q39+cxPuqIeU/W2yN//1vj1V8kEsFrB/sX40BmwdGcqb+35Z/z+AjIFLCI/smz8pLo9bP7PxOFc7JA5JbDkJ1e9/kXpmLU/HDx4cO/XU1VfvLX5ln4QnD7zDn7+tJRMAJfVbd5WfPiIeX1IbRPK7idfKiZlYJn80//jxz1161iyilTQWuzPxMUOmTMC6+GR7/4cPG/+E1L65i6SQbM/XthNXEHPwureQL7bv/GVSeMnvZJwMp+JM9X9PSsm4UbZnE9JjfzS5gW4mTbpucXbr1VQNRW3tjMNN7zQ5mt4m3g7/1i3fsmkSf++qEIV176ZQ29w//16Bx84RsPDQe/8zQnUQXzun/vzNfn7P1l/C91a/0mLNA1aiayzh8QjX3xm5P3/nTX8Oj9pYZGX9HP/XL/uH3Q7t+E+Z5b87sj2BXTNkftXN8+ZMn7Sy+uSqYFrUdbRT/EkfchuUX+CLn/InBBYFfdv5UfEdK4bXYYf2n9IaOMbdd4+ktk/ce+viU8XfrrmAL270k8oYncc/DVxTP6n647LcVP5039eHPDxwYM7/tXt7MovTlcgVTnqNe/r/x7Eyzyr2ZN8l95OeqrvP/buXTgAnf1q5eleK37c++3ffDPZOuyG67i1/mW6N4h9dY2qaHw4sPRUFJe496clA/7cvOem9Ol353XDTbN3oQVtsayLR8KfGuwVOvJZ1ZE/6IwxoMYv6WMx+CX906vSupd0vX1O19z+9XaXj+madUtP9vr8v9/OlhzZc1aObm9euseXain//PmQq8u+Oku/jbv2IXNCYPF41H2JmxYx5dn+IsQNHfxEt1tZTB968JBBpOba3Uz04P61iDFPRSEk6jZmuG/yzTTEl3YLVJz5ef26Dz/9lYxHhfXq1hEhLrp/+6Jq0JABOBlDB4+EwcntZdAlnN+Lqmh8OCi9BnQXIVHnmAgVYprJwBpZZ/Z3fnwA7opI+j+B9pzIItVEJn5JD3ui0Uu68T4f+QT+w6FqcGmAiCsN7YyQpjr/7i35wz3LXhg//pk5m2+rzv7JDNjl0ofMCYHF7xQZmp56X0kmsVs/LFh/yZJOmoBvYthTouxk/JwPL3Finpgxb4rRkSgAYJNbR/bln0yYRDVjp6+79vDIxQaJZb8nVuwlbzsH975Ov/G4Nmecwwod+de/nF3/1cl8OqPkVzevP9RtSPdGUZR+5H/38PtA1tmTt3p1CaOrTpzAHQ19TafOvZhlKm4dOVU8pHskUiqKVTFDxj3Ri3f/YjpS139/6Nx1AP/0yYtl1GmBE7dJJXCYxocD2Olm8pEu7/xE8uTgjjd9fzhcb9TSMPte0tLO3URn9+zHIajJ2vPWpPiT+hPJrssZgYUkT6xMfJX/64Ln8RvHpNd2opc+n9fLyIDJYYpjr0x6ZsER6TuLRjHDtQ8Q315QVyMZ886/Blxcit98/nmr74p5w0Soff+R/VO+eG7SK9+LnposScuqd6KQP3h+woS0+BfwXEVn6BI6XOPD0VhgtwGB99ev3gMn3S1x6+yRsP5d9ftR8pchYQdOXDMY5YQ3eP6q0an0S7o4zNwdLU3o/tePXwk88sb48VPeSu6z6g02HDJXvaf71fXjV6CEg/NY0Ei1DNz8u1VylcOatWfxgiNDEjc9G0oqWKQ139OdvSCtWiXnHlbV7R+XTafPcL1xJHD+e2xMK8yqfcjioeoBAG0NtLAAAKwBgQUAYA2qS+j92X/JFAAAuDAqsMYmO/xyNOLcuXOPP/44mQAAAPtAlxAAwBoQWAAA1oDAAgCwhslzWFVVVc+v+Z1MmJD0/hhSMgHOYQEAHAgCC4AWpb16mJRsxekzlpTaHugSAgBYw1wLa/Xq1fHx8WS6kcWLF69du5ZMmAAtLAAagBaWPaCFBQBgjaZbWPaczIIWFgANtGQLq1arLrnyWa2mikwjJPDvK4qYSCZYCAILgBbVILBWJ/1BSqa9HzeIlGiWB1a17FJFxq9kAiF3UbBX99nIjUumrVdYWLh+/XqmPG/ePH9/f6bcYpwYWNf+nL3C4J6sfE6nyUELZoR5k+kWRP8m0tejPny6PakBoLk0DqyVK1eSCWNWrVplc2CVXt+gqST3CnVzF3r3mMMRMDfvtdoff/zRpUuXP//88+TJk0zNiBEjevXqdffu3UGD6v16Vlm6dCkp0T7++GNSMsHcOSwcVYsXL16xYkXPqlM4kkw9okr+R1awAY6Jzfsf37y/93szuJm7ctbsrxvsppkpcy79ufF/LfbPAWDGD7+n4Ye+oH8wc21TU56pTyvkxhF3nmpzWiUlJR0+fPj//u//zpw5Q6oQSk5OxjW4Hs8lVTbBIdVkTumZDCwPD4+1NDMfFDqQsNMESXeE8i/JS0lNM7t2b+UHFdnMUD29/oJDE5pXwHn+OiISP/QF/YOZa5uqgrrOpjB4OM/Hxq3httXVq9RI+VqttqamhqnEcBnX4AKei5dhKpuba35KiPtoT59b/uWfq549N/ujewpUU3ot9ZO55157+tzsZy+u259DQo0sdmPd3HO4MP+D1Huki1l+b3/KErzu0+feWHHjWgW9jw23+c/LK+jeaP7Ge7Pfvp1Pz3qPNO6MrYtkxz67OJ+unD835VhB3UEDwBH07Sl920pfYxutWqEqrhtiR5lzsviPlcUX/qUuYYYXtgLuCXI4JCgCAwNfeuml9957D//EZaYSz42KimLKzc1VAkv54EDxdYSinmivP4cly+TP3jNgw/Jwz9u3V64olffvsGb/gLUrhXkbM1duydGPHSK7hWI/e3zDBm/JpdI1GzKqEZKfvLdmY3X48piv94cPry5PfPuu/hwd2ea/esXHUyOEUB3Sz7oajmlrdF3Z/swfTmofXzNg8/4OfYuVP3xQt0EAHEHfntK3rfQ1tqmWXUG19ce5o3qFz/J8upBJi0kkkr/85S98ekzQsWPHhoeHc7lc/HPMGOrMNa7Hc319fellm52zA4tq4+B209MpH/2Ier7eccETdZ1syQCvDsidh9Tn9pcrkOAZ6ny8u3evzs88gRS/FJzTDbwa8FRAjAjxQqWDuyLtyfKbqPTKyWotEj7W35uDpIOfcEdZ5Wd1AaPbpjuZbsj4ulpUi9+yTi1P2bi/duz2AZs3xLDzbv/AZenbU/q2lb7GNpqKbHdRMH7oPxMUhcfx/XowZWsNHz5co6HiLzS07qUfFkaNForr8VympgVYFFjM2XdTyEK20Z10f/zrXQMWPR3sSaopAhEztmqFnDpx6C4kI60KhWL8UyOXM5OIw2Oeg6+Uejuqzi1QKxW4ULGeysFz723E3TetvJhepG6bphhfVzoy8InOSFuhvrQxd+WzF9/bnlnJLA6AY+jbU/q2lb7GNuIuL3r1mENdckW3szw7jRf492Fm2eDUqVO4VYULWVl1nYvMzEz8E9fjuUyNtZiPCPFP/WeF+oIpTQeW/uy7GWTR5iGSUH22GiVpUimpTOHz/HRNMa2a6R0W51NvR4LgQKa7LZpH5yDzsHgMbhPrisL+tu7xDds7LljYrpME5e/K2w0jRwNH0ren9G0rfY09lDnUBUmeYU95BNp+5YFcLv/zzz9VKuoP8PDhwxkZGbhVhX8eOXIE1+B6PBcvQy9rHebzQaxB2QyLWljOJewfKxKj6l+3Z5ZSZ9/v/3oSiSf4D9I1lWR78i9U1Kiz8s/eRp5Pe3dHvo8/LeAg5flLpVok2/v2udnT/ryi6z/WkfIDcHtMrtKiGoOhdI2uW5O65Y/ZT1/8VeHf66noqU/hXcbxtfHjYQCM0ren9G0rfY3NNMpClfy2sMNwj6AhpMomd+/eZT4NxAoKCr777rsPP/wQ/8RlphLPxcsw5eZm8sJRh2j6wlHjl2s2nIVz6u7GjaX38e8pcu8+o8OrTOeRXixgmm/MpeKT95H3YMnri7pGUSfTy+/tv//1t0q5CglChZOWd48N5TXapuzgB/f3XkLaQO/lC2s+qptlbF0kO/Vl5p6TaoUK8SS8gYsiZvb3ZUHUA1fUYle6V6TvdeMKPDuOI9O2qq2t/fXXX69evcqh6a9scHd3x1GF9enT55lnnnFzc2PqbYB7gk22rRhODCz7mYk8AFxUy3yXUKsqVeacEoU/Q6btgzPrwoULpq50HzhwoD1phVkeWNBOAKAV0laXijpNIBN2w3k0aNAgiUQSExNDqhDq3r07rsH1dqYVZmFaYdYFVpPn8AEArsC9XRhyc3xzxN/ff6VOy3/zGbP6KblSZsFXagBoW2zJYGhnAQCcwpbAsrzDCQAADmR1YEFaAQCchdWXNQAA2hbHf44AAADNBAILAMAaEFgAANaAwAIAsAYEFgCANUwGVlVVVdzqI+YfZFGzzp07Bz/hJ/yEnw75aW5cQpuHI9TD/wZc1gAAcBToEgIAWMNcYDHjpy4a7K4fM9WwbNf4qQAAYD1oYQEAWMPcOazVq1ePGjWqpqbmqwuk0hTc4CKl+uAcFgDAgZoIrPj4+CNHjtgTWKQEAAB2a/bA6p7dxEeNAABgIXOBtXLlSqbs7u6OkwsXjh07Nnr0aKZSX168eLGpoQkhsAAADmTypLuHh8cntFWrVpEqAABwKks/JcTtKUxfwAwrAQCgBVgaWLj3x3QAmQJmWAkAAC0ArsMCALCGyZPuelVVVStWrHB3dyfTjdTU1DTzSXf55q+vHCJlhHiiYUN7vRElJJMAgDaj6cCyhyMDK6bvz0MlSFtz5ey5+FTezOcfi/MhswEAbQTbuoQc974xoQGo4ny2Ek/J7t1ctPXYlK+PvfB9SlJhDbMIqdx6Yee563jW5myqsiL3/vLvTkz5+sSs/ffvqOjlAABs47TA+uhySeMHmWcJDheVZMafQlP/Ovrn2X2f1BZtO5dPrV+Zu/5EviKq73cz+4YqHzHLovLs+P0PUJ/Hfp49cGLNg5XH6CUBAGzjtMBa3q9hj65xjRG4S5iaJUOix4L5yCds3V/DRGn3v9j/529VeBbCLaeKHNl15D68i0TEcX+sUwCzkuxB7h3kPayTEHFEj3Vup84quq1m5gAA2MSZXULDhGo6rVKv4P7dlM2/f/pAFDeuL3UCS3Zv1vcXvsrlDR/a90USTaiiGncMRQH0GXken3xQUFBajlDp5h+ozuPcc7islOOAAwCwjXWBtXTpUlJyECanLGpbxfT9+bXR+PHj3/rODOXjijsZuSVI+urIsL6+HLUugEQCHFIVMuoEF1KryFmtQO92CPm98RK1Ov3oPw5XAADYxuoWVjNllg1EHgLcbkovQRXZ2QfLdJUdAnqimlN35RVa5W83ZExlQKg0BMkPpSmRVpm099iU3Zn0iXgAAMvY0iV0eGbZJqRbtyn+1T//cmLuFe3joe6oqDRdjZBn8LyRAfw7V2Z9f1Pu354s6hO2alwIunJ+yubzuzlhK8aFhZAZAAA2se46LCaqPv74Y2aySU64W0NZ5ts/3qvoO3BD/3YlqVdmneG88VLvYR5kJgCA1axuYVmeVs7hFfxqX4nq+oUpXx97/ZJq2MhoSCsAWg1WXOkOAAAUZ17WAAAAVoHAAgCwBgQWAIA1ILAAAKwBgQUAYA1zo+asWLGCTJhg6r59eudgXEIAgOOYCyxmXEIy3YiZ0b30cGA93qs7mQAAAPtY1CVcRsOFuNVHmAdTDwAALanpFhaOKpWqiXt0mrmnO7SwAACOYlFgcTgc2/qGEFgAAAey7lNCumsIfUMAgHNY0cLChYSEBOYnWYgGLSxgyu6D/yMlABqZOv4pUrJY04FlmFz6wNK3rZLeHwOBBUzBgTV16lQyAVq13bt3W3WsqeWtD6ymu4TPr6m73QJOK6aAc4p5MJMAANACmg6s/y4ZQUoI6TuDcA4LANDyzAUW7gzi7p7+encmrZif0MICzqQh/wdtjcnA8vDwWEvTX9Cgb1UZPphZ1rieOHFKrP4xbdaSnXcUZFYzKLqy6b1ZE/A/9NxLM97bdoEZlUJ2aNHEzSl0EbQ8RcrOFa9OnhAbGxs3K2FvmpVHPzNp/pIk3Qi5oK2x4rIGfavK8EHmWSlu1c9H99GPb96IPB+/I5XUO1rG1iWfpg5c9cuen4/+uCV+4J1V8784U4VQwLh1+2b3JsuAFqW4nDhrxR/d39py4OjRo7tXRv2+aNH3mWSeRYof3m3iMmbQilkUWEzf0BSykG28eg6KqUhNp1o+xZe3LZrxAm52TZixfGtqBTWXagqt330ofvJzUybM/+J4HlVHyTudMB8v+cLkZTuZBeklP1iV8ELstPUX9K/notspRSHDBoTwuQhxeWFxM+M8Tl+4WdfCyt+/vK6tN3HKov10A6zxxoHDZB7emBS2cOWL3XypKX7Y1KX/6J6TRiVWQdKi2ETS7L2cGLswKR8XNMVn/j2LaozFTVuyLVWB8pMWLklCqYl/W5RUgFDu8YRX8LwJk9/ciudRqI18vvu3VTMmxE7426rjd1O3zqcWmLUxpRlb8aAFNR1Y+r6hGWRRG8ivnL4giokIQGWn1/7rzrCEH3Gza924ip3bTxWTJY799HDc9h9/3vCkLCEhiXpla+5sWvENmrbx6J4tyzoeW7L2tG7J2/zhW47unDeQGmWV5vf4xH7ZW/8Zv/XY9TS5GqHoOdt/fqsfmYlJn/6INPR2fhAXED2sp8T0xoEjFKacfhAzrDedVozAcW+9OyqMTDRyfUdCwcQtSUeP/hIfcyYh6YE07ss1cShmwffr4tqnbnp7bf6EDUcP71oWfnhJwnHdkTp0uvjl7Um/LI48k/DmpnZLDxz9Zjr6eevxQjIbsJoVXUIHSlpJGjUTFm5TPLtqegxuag2L3/fR1BCEVBV8CQ4OpGsnhT83sa+Yi8JGjxv48HwKbgOlnT+sHj1xuA/iigZOnBh2+XIqGfY5ontXEcKNqTo+o1Zs2TCja/6JLxb9/QXccNt0uYTMMVRxPXHBF2j+iqkdeaY3DhxBi/+LDAtkJiwg4PMr8zJzVYgb+fI321/sRKopWSlnCkdPnxSGuOKBU58Lu3AspZSZETN6JFUZ0zMSjZw+NRShTjFU95/6p0GLWlofqbWPcwJLfw7rwPZ1y54OF1N1Fak7P5g2bUrs9Lmr9hteyNo1Moj+v5ePlP4/UqoVZUmLmH7c69vSkKyYDPscEebHFAxwRWHDpyz7cMuBPT9uf69H6r9W7m4w6LNGlvThmsznEhb0FlGTJjcOHMFDLEZpmbg3Z8jMR37dpq+ZULHj7clGTs8XFeUjHtXZx4IjY5BCQd5aIsP86f9z+Yivb2wDJzAcEtBRwwM6J7CMuLN7xS8+czb+fPSn7za82JNUUtIzmY/2ykqokxrU2SjED5+5nenKUY+P4gLoBRpRJX8Ru/Y8aalxeb7RTw4Lz84z/IBJU3ImceWxIZ+tGafbhMUbB7bwjuzTKfV0ikE/W3F81diEM0oyoaALCjl1qGniyDFvrdl14Oh/5oh/WbLjFqml+PlJkVrFhF1uWioSi2EAStfD5JQDBzN1mcBSqVUefDF+RyzL2LHvNJ4k9ejOsWSqUZR57NCF6GEDcRsqZlhc0b6fLlPnwzOTlk+YsS3VxFs0v9/ouJvfrD0lo17WGnX+qZ0/5fTt3pHMRUid8u3iRI958U8bZJLFGwc2CRv7elzml6t23qIzqzRt94drU5+fOFTINL4uXLiuQJrMwwfIyff8vYsmf3ZBgQ8Bbi4hXz+6KY5QMZVrob2H+h/bsTcTaRQXdv+UOXB0b29mLnAtjh162brAclRH1IiYuMU9r696ccqEZfukL87unZGdSZLisRjlFxMmTpl7Jjr+3XFUr5AbPSfhRcW3s3Cvbe6RgDkrp8bUO29lwKPngjXzff+3bPKzU2KfnTF3N5qe8MYoCZmJkDzzXknxoQ8mMx1A/Nh43YqNA5uI+y3YsDLm6gczYrEZCVd7xW95JYaa4T1qwcKY06smT5i51XfoaHpZJH1m2QLVpmlj8ZKJihnx1AkpFNZnDNrx6qKkRzFzPlssPTA3duy0hIyx8e+MMjiTD1otk19+NooJLMsj094vP8sOLXo152W4Zoq14MvPbYerfPm5sWZsZwEAgGm2BJZjO6XmwCXpAAADVgdWy6UVAADUZ11gQVoBAJzIupPu1oI7jrZxcItkYIYjb5HsEBBYAAAHsuWkOwAAOAUEFgCANSCwAACsYW6YL/3d3Jtk6pZYcA6rjWuDJ91tOJEMLNf0uIRk2rTFMC4hMKGtfTXHtq+bAMs13SV898eNRh9kNgAAtBQ4hwUAYA2rA+vvw8eRUisG98ACwCVZF1g4rQKzvrUvs5p1XEL1mbW6wW+wstMrJk6ZsUt3U2RqMv54urFBCVM2x5LK7KTFHyQVwdiFzUSRum3JtLjYekPd6OTvXTThS9jlwBwrAotJK1ywO7Oab1xCXu++fVPvpJPbIt+7ntqvr+/l6+SGuw/vpET3jYkwfwcI+cM0GPauuaiSE5ekjVr3y9Gjh7cv7pC05Kszun2tSPvvkllfpcKuB+ZZGlj6tGIYlu1iflxC6h1559xpuCH29tYta2LfOUSix/TQgeLufWNS7qTR5dTr54dNmBqTdyWVHkgiP+O2b7+eUoOmkyItaQX+F6ct2nReTlfIkt75IAndSXx1OdXIQqo0ZkjEGfG7H+pv2Qxsxx+y7MDqcVLqxvy+Q0eOUiXfJEdq44xVd0atfJW+9SgAplkUWA3SilH8x0pSsof5cQmrzieuPBbzzndHd77R7s55Zo0mhg4M6DlIdD2VGnI1O+V8dO+o6EFDrv9xHcdNRWqKbGjvEGYpiubOjo92KqZ9eXTnR33QbboqIO7TD+JQ9IJvPoqjBuA5dVo985efvls54M6mbedhJE7HyryfgnpGMSMSxryya/v748JgjBvQlKYDy2haMWzOLEvHJbx947jf+In9RIgbEjdxGLNuU0MHhvR+THb1dgUqy7jp1TfGC8X0fOzMdZxH6TdvDh8USRaiZN84UzR8+rgAajvjxpMxxOrpOfEJ/AuJBg4fjhQKCCxHyk1a+714wfxRZFgJGI8LWKbpwDLf+7MtsywclzA/Ox15eTKvZb6IvLabHDowpvfwlDvpiuuXM3EHEK/Ys1/vlLuZeRmp3aMjDUeUkMvz8R8KUyP0NDaEQaCvFykBR8ravej1nyJXxscFkwoALNR0YPkOWmX+QZazk7FxCaUhEaiskjkRq6rQNXGaHDqwa4+hKXcPp54fGE13AL3Cu6OstHvZ/L7RusyjSSRSpCID22nUcLq3ZShubJo7//SgzzYs6FfvaABgCUtPujc7o+MSdu0xqujgvssVSJOdtF93DqvJoQM9eg4Kvnw6/bE+XZlp3EksSUlRDepZP9g6DprY8dSOA9lIU3Fh3z7m7C9NzgznCRyv+HjC8tRxG9e92AXSCtjCXGBVVVUttgBZ2k5GxyX0eGzBiuEpn74U++Jm/uPDyZJNDx0oGjhMkubVr7duKOCY3iHHLkp61w2hygiZumy+9MjbsS/M3ddxou4yjdA+o9GOhcynhMDBMg9uvaBMTZxJjUlIS4TLroBVWHLHUdwI+mruKv6SA68bjmIPXB18+Rk4lst0CY2Sn/984UsTJk6JfXbWJvVf182AtAKgTXPtwJI89taX3x2gzqz/uGXxuEgRqQYAtE2uHVgAAGAAAgsAwBrWnXRfunSpVWOpwh1H2zi4RTJwLKsDC/+0PLMgsAAADmRLl5CJLQAAaGG2BJZVvUIAAHAUqwML0goA4CwsudIdsBOcdAeOBYEFmhF8NQc4FlyHBQBgDQgsAABrQGDZCsYuBKDFtXxgNeu4hBi1fcPbLOXvXx678TqZaMz8+IPG5+rGLgRWMz4uoeLG1kVTJ+DKWR8dz6//TpC/dxFz6yydRUmFZBZog5zTwmq2cQmtF2B+mEKjYOxCGxkfl7D4eMK7hyPf2XX08K454k2Lvq33apBOWndUZ93zvr7Pz4nzJ7NAG1QvsM45CNmcJRw9LmETGq9oOEyh0X+r4eiEBmMX6kaYBhYyOi6h6sYfF9pPnDhQjLjigVOf8917zHiD98HOtSdGrXwFxi5s0+oF1uMOQjZnCYePS2iG+RWN/luUBqMTGoxd2GDwC2ANw3EJkVA3zheXz1elZRrp9KnO7NohfeW5RrfDBm2Lc7qEzTkuIUW/ffyY8c0dUmt+RaP/FgVGJ2wGBuMS8nv07n3/p58uKJBGkZK0j+oQapmFDBQf23cxbvpIY4OxgbbEyeewmmNcQqzuHNm+n7e/Gk1qza5o/N+iwOiEjtZgXELfcYvf7Z3y4eTYyUuuhg2NQdLGOzz/1OG0J4dB8wo4J7CMcOC4hKaYXdH4vwUczei4hNInl21JOno0acPL7RVpwR3DhKReR5F6MW3UADh7BVwnsBw4LqEp5lc0+m+ZBGMX2sTouIRZu2dN/fxCKUKazN3fH5ZOGEpObNVJu5nSu3skmQBtmcsEliPHJTTB/IpG/y3jdGMXwqeEVjI+LmHo1PjXqzfNiI2NW3Q6euWaKUxepSTGLkoqoIuFmWkqqa83XQZtG4xL2AiMgeg48OVn4FjmAit2TiwpNeXopqOkVJ+9gSU///nK9cceVqgQL2z4zGWvN+dIXy35b7UZEFjAsZoIrL4jp5AJ066c+Lm5AguwHAQWcCyLzmFdubfD6IPMBgCAFmHpSfe+UdMbPMgMAABoKRZ1CXFjqnFC6SuhSwhMgVskA8eyNLCYmgYgsAAALcmiLiHTB2z8ILMBAKBFNHVZQ0ijLxY3lu0BLSwAQAtoIrC+XLmZTJhw6MqeQ78ehMACALSApgMLRxKZNgECC5jSBk+6A8vZ8AEFtLBAM2prF462ZdRFs9Yca9susm36pDsVSaYfZCEAAGh+TQTWwlWzL125jdtQZn6SRQEAoJk1EVi4r1eYk97kT7K0KzB/bywL75wFXJMNhw+OeOtiLrCYJLLkp7UUaYcSFr40YSI9LuGWKw2GoqOYHy7QOPPDBerm2rJl4CgpieROWLS4aUu26QcnNC8zaf6SpEdkwpyCpEXMbbYsXwWwh0UXjjqWImXzrGWnO87/8sC+n49uTxhX/tWs9w41zCzHDxeom2vLloEjxX1Mxhk8un1Z5JkVO26QerOKH941c3ANBMatO7qAPr4WrwLYo+UDK/vwt7/1fmPFi9E+1BQ/YNSCVdMrtm29qKbbPh+sSnghdtr6CzkG7SDjgwmu2bRzOT1c4PKddxoOF9hoiEODubes3TJoNt69B/VUpKbRI0DmHk94hRr8uW5EaKqttGTVBxNi4+K/XLAkCaUm/m1R0g195ecXVKj4wiZ6yOjYCVMXbb1Br0ZaWPlJC3WrMLctBa1CiweW7Prph48N62dwczxuSO++/OMpzMn72/zhW47unDeQR09hJgcTvJwqnkcPF5i9dVf94QI9Gg9xaDDXj6xPb/mr/DGfNbVl0GyKL5w+L46JlCJN6qa31+ZP2HD08K5l4YeXJBzXHYtU/qhdR39ZsTBxTRyKWfD9OnrYZ6byrYHK42tXpA779wHcVlv3jGLnFv1amDTuS90qgaQKtAJO6BIiJBZ7kBLDt30IKaGI7l1FyPBW6yYHE4wYPcTEcIFGhzhsLPvGmaLh0yeE6LZ8KqWMmWF6y8ARkpYyZ7BiJ7y2SfH8muk9EMpKOVM4evqkMGbw57ALx1JKmWUju3cT13s9UHSV3qPij66bGooPtILv62vyQAMnWVofqbWPUwJLoaj/DUVVhZyUUESYvgXEMDmYYKMl6xgZ4tAIuTwf8fnMH0NQeAyq0P1WZrYMHEB/DuvA7i3LJkVS4+cUFeUjHjkWwZExda+QyDCqSdWAvlKRum3JtLjY2MkzVv2SyVQB1/Hxxx+TUv2yPVo8sAJ6Dut4/jQ91hahyT6TLB/VuyuZbMCGUQiNDXFohEQiRSoVc7I/LyMViRq0+0DL8fOTIjU5FrlpqY3a4Mbd2rHiv75z/oOT75cNf4fPUVwRk1OOSius5VtYIWNfeTLli/idd0qoKZXseOLKHaKZLw/Qn7Wqz7pRCOnhAo0OcUipP5hgSI+hfqd2HMimhsnZty+z3/DeMMKzs4T2Hup/bMfeTKRRXNj9U+bA0b2NDOpV3HAsyGqVSiigDnRp2o7dx/G7D6mv02gV0OIcmFaYE7qE4t6ztyQMe/jVQuo6rBnLDrWbv+XDcdKG5yl0rBiFUDdcoL+xIQ71c/UXauEtx8+XHnk79tlZCQ9Hx78xzJfMAC2OGzPns8XSA3Njx05LyBgb/86oRscirM8YtOPVRUmFZJrS87nFva6umhw74c2fpDMX9L6fSR9oPd0q8Clhq4HQ/wPbszAQ/vfIbAAAAABJRU5ErkJggg==",this.options.images["Gui.Office2013LightGrayPurple.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013LightGrayTeal.png"]="data:image/png;base64, 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",
this.options.images["Gui.Office2013LightGrayViolet.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayBlue.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayCarmine.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAZAAAAFACAIAAAAd4720AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAQlhJREFUeF7t3QlgE1X6APCXo0l6JG3Tll60tFCuVqTiUlRQAUVElkNFEFQQReuBsAvLAuvBImC9cP8iqCgughwKKFi2csmhtCpFoYAtUFpaeh80vdK0uf9vZl5C2iZpriYZ+v02G9+8eTM0meTL914m8zgf3jIUAQAAG3DJfwEAwOtBwAIAsAYELAAAa0DAAgCwBgQsAABrQMACALAGBCwAAGtAwAIAsAYELAAAa7jmTPcFF3JIqSvrhiSTkhOC+vQJjuuDC/XF1xquXWMqu5X7/0UAQGeuDFjWg5EtbWzhqdgBMQsAj2NZl9CDUQP/c/gfxQX8B+A/g6kEALgTmzIsY7TqTKfVqpqbmyorW2pqSZVz/HuFSSIjBWIxl8cjVe1BngWA+90kg+44rIiCgnoNHhw2aCCpcgLeCd4V3qGlaAUA8AiWjWGZ7xJyOD4ikX+vXkF9YjkczvUrV5orKskq+4mjIkP799fr9Q3XSlpqatRtbUivZ1bBMBYAnuXKDIsJSWZZWWUX8wNJer26tRWvaiwpxUviiAim2jHM5o2lZXiHeLcQrQDwHjfVaQ0+fn69h/9Fp9Fcy/qFVNmvz8i7uHx+2enf1QoFqYJoBYB3YOUYFg4ZRT/9jG8dYocGd9+ofIvkRI5hNmd2ZWTpXwQAuJOLMyxLCVSXDVyCy+P1GTUSZ0Y4PyJV9sM5Gs7UrmVm6bRaUgUA8A431U9z/MPC8H1bUxOz6Bhmc7/QUGYRAOA9uiVg4XzKVaPsNuIJBJLoaGlCP1xuqalhKh3DbB7SPwHvEO+WqQQAeAPWZ1jx996Db7F33hGS0A93CZvKK1rrG8g6h+DN8U7wrvAO8W6Z/ZN1AACPcs0Y1oiXXhjx4gtkwbJTn3x66uNPyYKLMNFEr9OpWlpwoJFXVzP1TgoID5dERwn8/TlcKqYX/fQzUw8A8CDXBCwAAHCDm2rQHQBwc4OABQBgDQhYAADWgIAFAGANCFgAANaAgAUAYA0IWAAA1oCABQBgDQhYAADWgIAFAGANCFgAANaAgAUAYA0IWAAA1oCABQBgDQhYAADWgIAFAGANFl/AL/6tVaTEckX/ep2UAABWQYYFAGANCFgAANaAgAUAYA0IWAAA1oCABQBgDQhYAADWgIAFAGANCFgAANaAgAXMipbEkhLwbj3rSDl/pvuKJy88LCVlWnN25qdo+JKwgiEPH539WSpTIOtcyaEz3auDtx1D982sjyTLwstHJI231qaEk2VPcPpMd3wI7le8d/d3W8my0+Y98svj6NP7XbdD27V/OWmVykv7Dj2eVkyWWYR6IGhf8rbu/RXDTXGk7IkSrsmwZPuS1w0x3O56/szW5zd2T5ACbhHtJxaSoicYX05f/mtfU/yMO5dHkxWgo5viSNkTLrqnS4hD5oW995EFQjJ3/dOnchZcyFnw89ejR5NKr8JpviZN3xW2bVfY4fP+KrpKfiV0W3bg1czQnTvD9mVK6q4HHaAahP5R7UOvN7OJB1FP+48zvz5JPck5Jx9bkkJVxs6YmM7UnEr9enkc3dDMsaC3nfcjbnbs2VP4k1Pce8nJR2bTqzyn6Ye0mmokScAvpehb39qbmkP/zTknZy4fxTSIW/41VYlrdv+44JfPhtGVXvxK6/woUsZn5Mz7aAKzeviWU0zZwgEyvKdW7aUf7OxHfvG+I3XjhbT3vls7P5CUiYdyUr8gf+6d208t2L1cYvLQOrWfMPl4ztNv0XFwxd4FF/a6awwrdtHEl0ehX9O+nLj8ckP8rSvWJ5EVXkN/PfDIKU7/B+uemNoaVOiXeU1AVhT6tN0qe/xRZXCp8PBZ/cjp1/+ahC6e91Uwm/yObp18veMmHhQqadmyc8j8y+XiyIdmD8QVcx/vJ754YmLyuie+aYqfOny+lWMRqjk3f93kp3aP2CtDzWWu7GM6KGxqWmQUaio4iiYtT5kUKvvk8XVDHj9zSRA2YfatePWdaaNnxbf8sPzLJ7ZookOZTbz6lWbmUWTn/lnud8tE6kih2TH9m2uOHmAegvDP9Tu7eAhbv7vL+44UhXkhzT/d0PlYZJ/7s1zYN4V+RLMj44WyS1ub6G0oZo7dgbKrzf59HsYrh8WKlc1i1wQs6VQ6KFK3jokVMSMljH+p4G/fNJUcOLT3nDI0Pu5Ossb9+Ed3hm0jN8np66S2sZqviFMOkug4AvngwfqKYpGSWRGqiqMqVb2CUVxSkwTpg0K1OLfSIVRXytf2bYsT6ckm5UINs4kHNdce3VSLMg+dKUJCgT+uUCiRUBL2wKiw3A92jhixe72VY9Hc9EcmKim/8QLyEOPLaea/R/HPbf01rRztn79pyN27N16SpEQrm5oRH/8PoYcGSRSXC/91oCl306+/ljPbetUrrSNzj6JsQ7YsND4B/5GzR4UpLxXuQ2hyslRYXrxyUy15CIP6TSI78DZmjhTF8EIydyzKThQpmEeEH6+4qPJzw4HDzLU/c6mcFzVoIEqJ7K0sy1a6fAzLQl9UIkS8QcOYoLYoRYiX+5M17qe5b2btk+TWNNzwydzaysEdZA5dFgdrkYqjpssoWOdH/UfP5SEeT09XEWotR3nJn4l935/loBZuG1njOdcbd5AS8d76M+eECS+sn5lz6ukvFlFdQovHotO2HnLj5ZR895fPfkCP444a/fXJl3Nynv5i7bChYroVGhYVirRtzMdKmcLQIfemV1onZh4FKtlUWRQdNi1l2L2D0dXsXFwTLuYhlaaEXru5vAUJ+cF02fuYO1KY4YVk9ljsP1pzPVQ6OmXg8L7CopzTzMNkmG3/zUUc0ONiR0kE5ZXZ5e7qEuLUozk7k3ls1M3zSWxHvr56pENMQGqu5yGBnhmmsgI/ecG3NRtiX+2T4xoDyBpvkpn54sMb/5K8898/aG6ZfecSNhyLzpbMvzWpqfjfuDOVnJFJkuIzFdcRT8SMOff2M3THvfnRmXsUCJWf/vWSf//Zvfui2p/ov7W6WYsEfOZkhbnR/kipqafLSCCis8WBQYZg5+XMH4u9uJcn6T8jYUCo7Nymdum82fYlB+orQiULB0kays/suOSugLU5u9ZvaOJbEyRo0PAvTi7I+Xq0t508Ehiu8SsWXmri6lUBFy9youLauvz6pVecWnHRt0KF0zLfi0fCdp/1b5eAeYVh+NnOSBsYi5RUCqLU4BeITcdCwJOQklfwEyIt0jRckjy06O47DV9F/XCpyW9gP/xAkualDDdUevMrzeyjQKhp+zlZ+Kg44cViJram58iU0XEr5oXFThj/8FDh9UuF+xGqV2lRdNikUShpXtJQQ7eA4mVHypSFY3Emu0gbOyouvH1/EDPfPrsgv1l652BtWTZOt9wVsErSfvzkNP++tKcvfH3nLU1lW9efME0FvQEntHHcCP2VgyHb9/k29FOM7NP1l36c0Kbxt3J+3xe6bWfAFX/V2KQWpkfpTc6s/LyYP3Z8Rs7Tbz3Ez95waKMtx+J8bQmKTPX8d083bN5bXB068KOcp1fc13IoWyGODsMv5V+Xn9hXEfhQ2tPbH0dXDC99b3qlmYzt5jy5ysKjwEq2yq4j5cXMM/QSKvkgY0Om8pb5M/EnTVDR+ffSqH7i/rQzv16XTFq/YMvDGuOD9cIjZcrSsdiYXaMU8kra9wcxC+0vn76KxILGywdwNgqXSPY8uESys3Am8knaQO3eLyev9Pg3Bo4Ynfb0/w2X/fv+9H2kAljirgwLAJebmvbkL3T+kpGWwM8+8wE7o9X8rS9/NIGfvfUERCsbQIbleZBhAWAjyLAAAKwBAQsAwBoQsAAArAEBCwDAGhCwAACsAQELAMAaELAAAKwBAQsAwBrUiaM3zRmYAICbG2RYAADWgIAFAGANCFgAANaAgOUme/bsISVwE4HD6jy7nkMIWAAA1mBZwKrrRCLx2gvEAgBcjH0ZVqIJvFhaWgoxC4AegmXnYeGUiolTHVRXV5OSNVzf4MheEl8fHKX1OlWrrKa6wW3zcuGO+rRp05jy0KFsvWiip5w7dw7fe8/zxvw9mOlh7Qm64/HatU9WBqzsy1R4ShkYju/z8vLoNTfEx8c3NZm5WK5IGhMdyG+rr65qUOh9AiMiw0Tq68WVDTqyvnt1CFh+fjym3AMpFNrYWDumsikpKTEGrO543hz+ezAIWM6za5+u6RLy+fxGE3iRrOgeOFQx0YpB9w4JvGihkxgYIhbqWqrLGxRahHTqxgqZXMMTMBMJcsXhsX0SEuITEmJ7hzCzewVE9Y2PjQqPpyr7xIZTU2QLwnon9AnzpVejwIi+xjIAwD1cE7Bw4kNKtA6LLoczLOZGltuLiooyE7P8fQVcnVKhIIuYvKqkrIbKxLjBUSFinrK26Fp5o1YY3CucnukZE/jy5eXXimqVfLE0MhCpGltVPiIJHaXE/gK9sqWVbgZAz4Xf7FaQRq7jykH3ATSy0J2YDMs0yTKNXzhj12g0RUVFzCLB4XKQWiUnS+2I/YQclbymUatrrW1q1fFFYpI56Vqbalt12sbGFjVX6B+AVPUKJV4rwPmXWKRvbTKJfgCYMr5XbSnYrvMm3bQTu3ZLejedkNWOOm6OfQFLKpJLhY34Fh4ebtoNJKtNkBV09xA3ZraSCpvCggxTijuhc4ZljF/kqer8ZGm1WuRDeoAEl8enHz4PxzK9nhnKalapEY9HxknUqmb6v61aMs6lk+Ecy1ciEPuLkKoF4hUADONb0vQm50mvNeiNN9LUOXZmWHotKZiLwfk0smDQvple23qdFJ1gKcMy3kitqdY2jY4r9DP09jBhaO+YmF44fmp1esThMM+EWOBDxzaaIcD58rhIjxtREUvRxhcG+wtQWwsTzADodi7PiVzO+JY0vQVoZX2COMYbaWqnte25sktoG9cE2g46PFOktp3GumYl1z88Ooj6nokrCo7uJeErm66rcFalUOoFAb0CeVzfMIkvV9PWTMamuKKAQB7iBQb6+2iVLS1Ula6xVckP8Oe0NZvtXQLQ8+RZEBISQlq4jvsDlrPIk0EjVbZkWAi1ycqrmzSCoKj4+IS+EcF8dX1FVT3V19PVV9Q1a4Vh8X2iA3nK+tpaQ19PreKExMfHhwnUjderSEKlq1dqOHplM+RXgO1ckqbhqGQJaWGirMnBPMvIwYClbshnhthtgRuTzZxGngkD4/miNmRYmE5eV1pUXFBQVFBQfPVaVV2r4RQsXXN1yTW6vqSsrs14YpaurfIqXVlaqzBUCkN8fbQKiFcA2MY4gMURijnOxisnMiwchmy8kQ1uAoHR/aICea11NTDe7lIX2yO1nkP+DgNSC8zBSZkleC0TqvoEcXC0alVqfPjOnvfLvi5hZ6R/2B5Z5zB5xdWi0o5fEDSWFxYVFFU3GXMw4BKDBw8mpfZlT/G2v8fLkS/mOzF+M4gLxTXNCqWmTy8xU+Mw1wcsn6AB1m+knYuQzqE5pAVgAyYueE908La/x8tlX67qcMOVKQMjmLXUt4SBSCpUtzbXMzUO65YMizm/wazWVjg7HJjnbdEBopXtcGzqcMOVuKPDnM1gTLWc111dQjLe3h6ur6yshKvBgJ6jc6Z/U+b+HdIrfCMrmPTK0ZOwOnP3GFZkZCTELABuMh3SK3wjK1zN3QHL19cXYhYAdrElTbtZB20Xt+fugIVBzALgZsJ8L98ZWe1S7g5YzNB7aWmpRqPB96QWgJtLN+VErt2JLYUu4ZZWkEYOGWNOtwQsjoUTWsnYuwGpBQAA27g1YAEAgDM8MIYFAACOsW8SCqnQzLX6OvAJGlBQUJCQkECWLcvPzw8MDCQL9quvrxeLxabXj9fr9Q0NDXifXK7XBeIOk1AwBWAjmDXHS3h8EgoWB6za2loejxccHGzsgba0tDQ3N+MaoZCZScKL9LRXdg8Bh9V5dj2HLO4S4txKpVIpDPNKaDQauVyOg5dA4IKrMNO8MFEDoEdj8TvS398f3+MghUMV7gw2NTXhe5FIZHnIn+sbHN2Hmc4rrm9seJCI1JsVGBXbJ8LkisoAAI9jccDCmZSPjw8TqlpbW3G2hUMVE8XMEkmjo4IEmsaKoqKCq+V1GmFoVGSQ5cfvw+PBd50AeBd293kCAwNxkMKhqpm+BCiOVpbncLU8kSo1Z2pMKNNKGpMQGyVG4qjYICHi+oX1jWo30Q4AwJPYHbBweGJSKpxn4XJAgOXoYmUiVTOaK0oalEinqL1aAZNNAOA17A1YNvWSLI8iuR4OVaTUvtyRlYlUAQAsYV/AkiklMmWg9Vt1dbXbvl3TaDTMt4Q4RDLfEjL1ZliZSBUAwBLd8o5Vq9X0b5y7QFrbT6vnyjW8ZjW3sUWJsyrcK5RKpThmtWpQs4rXouFp9Z1SPCsTqVK4XLpATZkKAPBW3fL+DLQZ2cAeKh2nQcVTarkqHQ+JgoQBwWKx2MfHxzcwjOcnVem5bVpuo5qv6RizLE+kSiVffJFYhPiBwb4+pDmFw3F2jg8AgCuxL6Fo1VJRRMTT+fHpGeUFAXo90iOOmkOd3e7P1wp5Olyj0HQMNhYnUm2trVfoBJLeCdFBWhUOYAxFmwr5SuFbQgC8CPsClkZHpU44MPnydDyOXqdHOsTR0qPtfI4eBzJ/PhWFmGbtWZpIVddUXURVXrtWXVVSUFJBz5KqqC0vLCiCbwkB8CLsC1jM6Zy4Y4iDlFZPfSHJQXouzrFw4EEcHL9UWqoFj+uyiToAAF6CfQFLyKN6gs1qfoOKGm8ScPVcDsI3H44OR6t6lY+c7gwKuTDbKQA3G/YFLNzpwzecVeHcCkclP56GqRcLdAIelVXhbMuXp8VtmHpwE9izZw8pgZ7NnQHLNadn4f6eP18rFWqkAnWAjxbnVoZ6vZivCRGqg4UaP3oYCwBwk7ErhITGxNOXOmBucf3iI0OsXvDAFFz8AADgLLtzHmUj/S1bUcHVqga1ICg02MY9wMUPAADOcryTpmura9NwBAJ/vJOAkJj4OCbtiu8dLMIVvaL7mmRh7S5+wBWHxzIXpYrtHeJ1VwYFbKWhJ47DamtrSRVgs+PmOB6weL5hvj56laoF+YaFSHxUsqKCoqLrSo5IHBQQFCzhKqquFRSU1akEQSGBJhc/UARHhQRwWqquXitv1AqDe4VDNxG4RGtrK1Noa2vDwYspA1Zb2wlvQq+I4PvGkvVd8AsMFglFUmkwdQv2F+haZbXXWzWalsaG+malnusj9BEF+PN1LW0cfxFXq1Uq21oaG/EqZluhXlHf7BsaJtI2VFxv1WsUyDcoQIgUjS30Kes3t7y8vMTERLJgAc4OmgwUCgWXy3Xycs+mO8Qc+y0Ug9mVcQ8dFrubLc8e/ntwnBKJRPgeP29OPnU2svSH1dXV4QBqCz/T37dacHPvzdJzWFxcPH78eLJg4PgYVkHx1ZLqhjaqThQSGd8vLqFv796hInqHDdfr2rhiqp/Y6UrEXA6HIwphhu1D/biIx3fH64p98LtOJpM5mSnExMRIpVJc8PHxwWWm0kvU1NS48Koe+InCiRWfz2feFcYr/XsKmfjYBmQDq0hTG5ANrCJNbUA2sIo0tQHZwDmueMUEhQaJdHL61y1lLcwbrK2hpqSouKCoukkvCgkNouuMtIoaJuRRN/jtS0c4skRGRjLXFFOr1Uylw5g9uCfd8CD8AY7vhUKhr68vfuqUSqVOB6e23IRcEbBw0qTX63Rarig4zI86+9w3vG+/6DBfLqIvqIfX0c2Yix80KNq4voEheCUvMCI+Ia53iMs+ZW8eOF/Q66mfHTk/XxkTsHCGxSx6Cv6AraiowB1JzJhY4TyIqWxspKaPw7EGp11MG6aB7XB6he/xHvDO8ZOGnz0mhHkK7ihZQRrZiWxsAWlkJ7KxBaSRVaSpDcgGznFFtGhobNb4BEYl9A0Xa+VyLY+vr7su54ij+yT0jZBwFNcrqesQGy5+4FdXKWvhBET3jY8PE2oV9dfr4IOwPfx2ra2txb2b8PBw5ztNONfA9x4PWPj1GhUVhZPHPn36lJWVMZUtLS1DaLiAFwsLC8PCwnAbjGlgI5xMMQ/z+vXr+Nljgpf1gIW726ZIreswnSBLSCM7kY0tII3sRDa2gDSyijS1AdnAOXa9H66XFhWUdj64uqbqskKqf3etpEpWVVRUUqvBNVfJOFdtEx2Rblz8QNtUVXKN7g9eK6lopAfB7OHT2ux3vcy/5pqooYan9OSnaLfCSRZ++zk5hsVkarjg8S4hfr3iOILzqWvXrlHXH6NJpVIcyBoaGiQSSX19Pa5hOsL2wrGp89WxmbBlCTO0xzAtAy9n17eEXsFXVsnRaXFHk6tR89vkuDeqFYjwK52spnE0ah8cy6jLOHTfJfhw9tP5bWKRjd9z4XucXwQGBqpo+B/A3RxmrQPwOxnDyRqOCKTKUczfZvxasMNil/Lz83EH0Ph84c1x2ML3DBxcmAdLljt9/2j92cM9Shyag4KCcIKGN8Sam5vx3vADtxKp8ROLnxwnoxV8S+j83rr3W0KPU0lCcawgCzjhamkUNdYwo2UYV6kQ1VcLFI0akZ+u3ReQHX5XFB8TEmDtwZvO/WVGt//SyJiGOIMZeHbhxP34ZYfvmUnV7MqGcCjBQRPHYlzAi7iA/yr8Ck5OTmZerPHx8fgedxipDqE9XUJjf9C028u8N5h6K7ovt2I6QbYgG1hFmtqAbGAVaWoDsoFVpKkNyAbOYV/AUvsGKEKiNX4SY1bFa1MIm+t8FE1+deWihlqNr1gpCdVzzDw0wzkZV0tkSr4kPFrqcEepG39pRA86lzKD5c6kVxjTLXLJAJZIRJ2dwgwS4U4cLlubVK0THKdwEoS3NQ0iOAPKycnBH7DMWhytcIcRt8E9R9LCMrwfBn6i8Oa9evVivhxk+Pv74xp8T5a7ilyALTgf3jI0/q1VZIlVuBqVsLkep1RkGX/Y8gVtweF6ntm5VHGGFYQab4zB+fWKjxIqykurcc7AFYf3looFOMRp2+qry+rwyxtnWGG8pqLS62bWiqNiw6krw9Pn7ldxOm1rzp49e6ZNm0YWLMDvVVKi8xfctRGLxWTZfqZ7w+xKW8ySyWTM6DiG+1/O/G326vzs4RjU5fNphDd3YZppytJhxR0lUjLHsXTDO/dpfQ+mLO3N0nN4/PjxtWvXkgUDFgcsDMcsUUMNR0MlI/gd3hocQY1nmdcxYKHA6H5SbiMOSdzg3rFSnry6VKYNiYwK5MorSqsVxoBldi21N4mW/qWRubVm2BKwgCWsC1jAdlYCFimZYHHA4rfKcU8QMecH8nhIq9XzfRTSKNMRLhOdApYxJAX17heEZMVl1NdU4qi+oT7y8ms1AqtrVYaAxTe7ltp9B6x+ZXdI1kw5n7jZwmzAIiXbQMDyWtafQ9WNeWEoZt/bLCBolgkba5lopfGTtITGaHzFONUStFCnINqEb7j2n/VfCzmz9mZBj4ObR1q4HQ5AdiGbAbahfhRqgpUBy0fR5GMITFrfAKUkBHcIlYGhaj+Jj6KR6SF2SSwUcDQqMiRj/ddCzqwFALgO+wIWV6PC6RVT1vkI2iQ3zj1QSUJwniXA/cQu8PyCokP9OMqWeupbeuu/FrK4Fn5pBIC7se/tJWyuJ79R5HLbgsKNJzcwqGyLy+epzJ/lLAxkzsOKjwrkq5uqy2V091hn9ddC5tfCL40A8AC2BSydjqsiP8dRiaVmz2DAfUN+q9x4KqkB9bsiQ8eNmjO1rE5ujC1mfi0kr7hKn9Ngfq3rfmkEALAdywIWV6dhIpFG5I97f0xlZ6qAIEtJFmAj+CYOMFgWsPRcvp7P1/hJlIHULzwswZmXztPXJwAAuBzrAhZXERrDfC1IqizAoY2UAAA3C/YNugMAeiwIWAAA1oCABQBgDQhYAADWgIAFAGANCFgAANaAgAUAYA0IWAAA1vBQwNI1FZ/8btMn69at27BxT2Yxc0mWkhPrdp1vYu7pinYs1Tui6fyudSdKyAKwW9P53fjQmbD1yVRXnvk+w1VHsadQ5H63bsONZ9j628TlvOyQeSRgKS7v/+rH1qTpzy9YsODlp27X/Lgrs9L4Q+TY0Qum3+rspFSg20WOfhofPmJ0LKntQmtt4TWzV5AGFjVdyeMPTaq8VNhuGiW3vU287JB5Yl7Cupz//eJ777QRkfSPZ3yCY+KkWr5I6qsoPlXmmyy+uPFQ02DqvtL3+tE96Vl5ssC+/UKFTcWnrsl1hQfSD5++Uh8Y1zdUyEGKa5l7du47np1TootIiJLwOcrK39K/2X8k89dTv+erowbFSipOrPuhsPXygYyKXrf39a04+fVX35/Mk3H4rZXc2BFxts6q5wK2zEvIGsrqvJy60OSk8PYX8ux4OEqpJ19d9vP+A1lnq0QDBvheTt/3p1xeXOU7uOOmbNX9h1WWe7Qi8v7hkj/+kPcfGOqDUKPJ2yQpqJZ+SZ+tUjSeTS8JHBHX2OE5Dxfio3CoMqA5c/d3P5+t8u/jl793x76TufKQAX2lPkiWd+jbPT+coA5ZdEJvMR8nbm4/ZHY9hx7IsJS1lU1hkWE3fpvMk/bpJ+08nVVVrixu5svzZ97afOjQBTolrb2kTJy3YP7MxKZDP15S4FT54PfFcY8uWDBvcmTh9z8WKJFWiXqPfip1AW4zTH+moJreT22l/5iXXx4bhwpPfH+l98TnXn76Dj9ZLb0KOK7yxJekP7juOD31fOfDgdVWoqEzX059MK7s5JkKya0Pjo7EqdmDkEHbrL44LyQpwVc66DZNblHHTEeLX9KXIvFLOvUeyY2XdLvnnK6pOl8V/ghdc/S7/N6PpT59t1/umUIFqsr87qw/lSm/+Fi/ku9OMDmcdx8yDwQsPs+2SB02bFgfIeJKEwZGVsqYPnRCQjypKauWoeu1ZWGJSb0QEkYm9vcvLK9FPEmkRFlw5sTRjEPnqbk+Gb0jQ6gHWlNZrI1PiMORMThhYARZBxxl0iUc05uq6Hw4KL3jooRIiD+gtAgubWg/2ZXzYf3ieAj5xQ1EZy8ZZ1BhyPBLOmFgp5d05+d84ED8xqFq0MABcUKuRBqGkE7TVF2pqDvz3efr1q3fllmlLSirpBt79SHzQMDihYZJaytrTS68Xpm988Q1WyY65vOszzzfejnjq4xibuTAO0YP6645fQFwm8q8c02XD2yg0thNR8vq8oqp2ZlcasDEl8nHzoKX76U/eLybJwbdgwcN711w/PjlJjpGKUoyT/wZmRDVKRTV5uXW4M8BWcHlyt7hTPi5dBl3NIw1oWG9mTbKyrwrLf2iw5BaqdBGJiQN7M2vKa5F2vbXHO0VGccruFzcitPsgstVpBK4TOfDAZxUUZjba3wqiScL5t3vd/pPJgkipM69pCVhkcLCM+dwENTJzuzakJHPgvmxPfItod/ASTPv5p/f+Sn+4NjwVTa6c/ro3mYutxesvPjlhvU78yTj7x/kR9fECSt33qjxS3pwSlzxt/jDJ70yduKYBCEKiBvYp+zHjRu+/E2YeJtfDelIErx+ox8ZUpPxOV6rDIMuoct1PhydSSLjJDUnMs54zbfkXq2yMFcaF2l8Hv16J0jPXy4z+RjGL+kpgyrpl7SC6uXZK2r4I6MkeV+vW/fJ7sLYKfez4ZB560SqJSfW7UOPLBjNgiTVNjDj5k3JWw5r/ZndO/L6zXpyWDCpYBG7nkMIWACwlbbq9Pf/yy5TaJGPdOC9D41PvPkHblk8VT0AoKfxyBgWAAA4AgIWAIA1qC7hH8OGkiUAAPBiVMBacCGHLLnanDlztmzZQhYAAMA50CUEALAGBCwAAGtAwAIAsIbFMay2trbp7/1EFixIf308KVkAY1gAABeCgAWAW2lPZpGSo3h3jySlnge6hAAA1rCWYa1atWrNmjVkuZPFixevXbuWLFgAGRYAHUCG5QzIsAAArNF1huXMYBZkWAB04M4MS69TN5x5X69tI8sICcOG+fedQhZYCAIWAG7VIWCtPvYjKVn22tj7SYlme8BS1vzeUrSfLCDE94+SJM1DHOsXGremtrb2448/ZsovvfRSWJi7ryvrwYCVe2HGmhZSxny4SRMj/z49RkyW3Yj+S/o/nbD6gVBSA0B36RywVqxYQRbMWblypcMBq/HCJ1oFuXYyh+8beEsqV+jgJf5OnTo1YMCA8+fPnzhxgqm59957hw4dmp+fP2LECKbGAcuWLSMl2ttvv01KFlgbw8KhavHixa+++uqQtp9xSLJ0699wmGzgABwmvtlxxzc7hr4/nZe/r/ydw9fJim7XWpVz4bMTbvvnALBi508F+GYsGG/MWsdomkuM0QpxuAH9pjkcrdLT0w8ePLh+/frMzExShVBWVhauwfV4LalyCA5SXcYpI4sBSyQSraVZ+aLQhXxjHghOQehKTsON6bm6VW7BwndbSlR0OWkIDpqQXgHPmXlvAr4ZC8Ybs9YxbdWnSAm/v6Lu8QlycG84tzp79iwu6HQ6jUbDVGK4jGtwAa/FbZjK7uad3xLiPtqs35Z+dmHFnN9m/KegBX9W5Oa9u+S3J2f9NmPO7+sOl5OgRprlrlvyGy7MezfvKplpsvnq4XOL8Lazfktdk5uroJ9j032+feZfdG/0ypcFM1ZcqqVXvUaSO3PbopqfN/w+j66ct+Tcz7U3DhoArmDMp4y5lbHGMTq1XCW7SBZwf6L8hOzUCln2m+qGfFJlM9wT5HJJoAgPD589e/Zrr72G73GZqcRr+/fvz5S7m7cErNbSwzLctU8eGWocwyou93lxy192/D1OdOXy0jVNNcnRn+z4y6Z/+pZ8Wbp0e7lxGsPiK+iBlXfseE8SkdP0xuaiNoQasgre+FLZ/++JO3bET1Q1v7kiv5y0Nexz2a1vveqPF6kO6cpBpuOGZretO1y6IUt338q/fLMjemR964Z3b+wQAFcw5lPG3MpY4xhlzRmkbz/XJ9UrfMQnaABZtFlwcPCtt94qEAhw+cEHH4yPj+fxePh+/Hhq5BrX47VSqZsuJ+/pgEXlODhvmnVu+V408uk+C0YGkRUIRdwWGIH4PKQ+fbi5DgmnUePxfHFS32kjUV1GzWnDRKxxo8MG+SFedMQ9/ZE6S56Pms5nKdXId2SyhIfC7xzJR+Xy3wwBxrBPPlnuyPy2OqTHH1kZq899dlg34ZO/fPNeYjRpD4BLGPMpY25lrHGMtqWM7x+Fb8bvBP3jJwtCbmHK9rrnnnu0Wir8xcTEMDVYbGwsvsf1eC1T4wY2BSxm9N0S0sgxhkH3O7Zt+suCByKptMdA7MfMVdjSUIPv+WQJ+fpRjbQNDcwi8vFhHoM0Ih7fKytqVQqqt9eyhoqDv83/EnffdMbGhn1aYn7bsFHhj8YhtUJ99MvKhXN+X76r1OTbTQCcZ8ynjLmVscYxAQNmSW5JpU65ovMsv7iHhGG3Masc8PPPP+OsChdKS0uZGqykpATf43q8lqmxF/MVIb43fldoLFjSdcAyjr5bQZp2D/+gXvheoyApVSsVU3x8pIZUTK2mxv0QklUV4XthVBjT3fZ/lY6DzO3ZJKrKBha29YuZ/tYdOz7u88bz4qQgdHVf5b4rdHMAXMOYTxlzK2ONM1rLqROS/GIfEIU7fuZBfX39+fPnVSrqG6qDBw8WFRXhrArfHzp0CNfgerwWt6Hb2of5fhDrULbCpgzLs3yTR/uHIOWeXaXN1Oj71T1ZKOSB0NsNqVJxRnWOQqMtr/r5ChI/IBmApCkPCH1Qa1ZOkxbVZKz4bca8C+cN/ccbevnEIdTcoNYijUlP3+y2mivbs2fM+j2jJTRp9IAnR+OnjBtyo+cKgPOM+ZQxtzLWOEzbWquqv+QbfY8o0qnfHubn5zPfBmLV1dVbt25dvXo1vsdlphKvxW2YcnezeOKoS3R94qj50zU7rsJxKv+TL5vOl+NPC37K9Ohnmc4j3SxuqvT2HNm3xShseNCi1EF9qUntm68evrp+e2u5GomjfZ/8W+LoaJ9O+6w5/O7VrTlIHSZ553nt0hurzG2Lan77rHRzlrpBjURBPvc9H/9EstTxs4VBj+a2M91bru7j8IR+fSaQZUfp9fr9+/efPXuWSzOe2cDn83Gowm677bZJkyZxOBym3gG4J9hlbsXwYMBynpWQB4CXcs9vCXWqxtbyn/3jJ5Fl5+CYlZ2dbelM95SUFGeiFWZ7wGJBlxAAYC+dstE/biJZcBqORyNGjAgODk5MTCRVCCUlJeEaXO9ktMJsjFaYfQGryzF8AIA34ItjEcf16UhYWNgKA/f/8hmz+yF5U8yCn9QA0LM4EoMhzwIAeIQjAcv2DicAALiQ3QELohUAwFNYfVoDAKBncf33CAAA0E0gYAEAWAMCFgCANSBgAQBYAwIWAIA1LAastra2yasOWb+RplbNmTMH7uEe7uHeJffW5iV0eDpCI/xvwGkNAABXgS4hAIA1rAUsZv7UhXfxjXOmmpadmj8VAADsBxkWAIA1rI1hrVq1auzYsRqNZkM2qbQEJ1yk1B6MYQEAXKiLgLVmzZpDhw45E7BeeOEFsgAAAM7p9oD18ah7yQIAADjH2hgW7gwuXbr02LFjzOg7vpkdgIfRdwCAe1gMWCKR6B3aypUrSRUAAHiUrd8SHqUZC5hpJQAAuIGtAes+mrGAmVYCAIAbwHlYAADW6PoSyW1tba+++iqfzyfLnWg0mrVr15KF9lz0LWH1Z7uO/UDKCPEl99x+76I+AWQRANBjdB2wnOHKgNVv7L7bw5Fe9ceZjFWFgrkTJk4Rk9UAgB6CbV1CjuD2hAHhqOmXKjleqr72y/zvdk7dtXN6+k/fy1RME1L53cHtOZl41WfVVGVLzfml3++aumvX3BPnL6vpdgAAtvFYwFpVmN/5RtbZgstHzZdW/Y6mT5y577Gx9+srNudcq8f1bYUbTl1r6TN2+8NjY9oqmLao5cqbJ3LR4If2PfbgVG3u67/RLQEAbOOxgPV6vwGkZNC5xgzcJSzIr0aSu3qJkHjQ+omD/UvOf3A880clXoVwitVSXXYeCe6JC/fnCO6I7s1sVF1eeBmF3hsdgDiSO2KCVZXllzTMGgAAm3iyS2gaobqOVoXHcP9u6u5v3ykPnHL3fdQAVt3ZuekH19cI7r197BMhpJVchaOWJFxElQUCAV2HqptxRnX9swyq85iag8st9TjAAQDYxr6AtWzZMlJyESZO2ZRb9Ru7b/pMfNs1eezcSCogXS67Wo/6PD9i0O2BPJUhAAVQQaqpuo0qq6jgRQkXByMUtWgKtTl9G/eQP7MGAMAmdmdY3RSzHOAvwmGr7moT7gbm/0ANwdOV4b1vRaqfi6tb9PIfr5QxleGRcb1RdUaJHOnl3x/dOfXQJbICAMAqjnQJXR6zHNO774jHpK27f9z1fK7uzkgBaqi9qkFI1O/lETGC4mNz03+tl0aRpuJBq+7uj/J+mLr7h12cQa/fM4gMbgEAWMW+87CYUPX2228zi13ywOVl5JcW/XC2JfHBjbcE1xcem/sHb9GUe+8RkpUAAFazO8OyPVp5RkDf1MRwVf5Banz9z9Z7RtwO0QqAmwYrznQHAACKJ09rAAAAu0DAAgCwBgQsAABrQMACALAGBCwAAGtYm+br1VdfJQsWWLpun9EcmJcQAOA61gIWMy8hWe5k8eLFtgSsL97vog0AANjIpi7hchouTF51iLkx9QAA4E5dBywcqlQ0nFL1bzjM3HAZr8L3DKYlAAB0K5syLJFIhHt/lpBGAADQzez7lhD6hgAAD+p60B1HKC6XyxTS0tKYe9KIhruElvIsGHTv4fb9dIKUAOhk6r2jSclmXQcs08hlDFjG3Cr99fEQsIAlOGBNmzaNLICb2p49e+w61ri9AwGr6y7h9Pd+IiW6S8gUcJxibswiAAC4QdcBa9eSG9eHMXYGYQwLAOB+1gIW7gzi7p7xfHcmWjH3kGEBT9KS/4KexmLAMp7KYDzZ3ZhVmd6YVfbI/XjWzAnG2zMvLtt9pYWs6gaynE2rX5yC/6E5z85dve10LV1Ze3jRrM3n6CJwP3nOjlefe3jiuHHjJj+btq/AMH+IjUrSX16Sfp0sgJ7GjtMajFmV6Y2ss9Ok5TsP7KBvH85P+P3tnZdJvasVb3njg7xhr+3+aueB/3765rD81f9Yn9WGUNgDH+yYO5S0AW4l/+OjZ189lbToi4wjR47sWdH/p4ULt5WQdTaRXcsns7eBHsimgMX0DS0hjRwjTho+UJFXXIOL9TnbFqXOxmnXlNQ3tlxWUGupVOizb398Z9qcmVP+sf54NVVHqc569x+45expK3ddpBvSLVev/s/sCc98dlpN12Cy/HOy6JG3Rwt4CPF8Yh56apIo6/SlGxlW1aE3buR6s2YuOkT9GWZ2Dlym5OCn6bELVswaLKWWBLHTls1PKi+gIlZ1+sJxH5Gvq//4aNyC9Cpc0Moy//MslYxNnrFkS54cVaUvWJKO8j56cmE6fjFUHEt7Bq+b+PDfN+N1FGonH+z5ceVTE8dNfHLlsfy8zS9TDZ79NMfOPA54qa4DlvXT3BmkqQMacrLO+CXG9ULNWf95N3/kiq047frgfsXXX2fWkxbHvy0Zv+W/O9ePrnn3g4xSXKG9smnVf9Ej6w589enSmOPL1mcZWuYL7vr0wOfPD/chy0iaMim5fOtb72z5KbewAYex/vM27vxbMlmJRYx/kyR6m16bFNZ/ZGKw5Z0DV6jNOVmceHcyHa0Y4RMWLR0bSxY6ubA9rXrKF+lHjuxdk5iZll4cMXnde5NR4ivbPpwcmrfxH2urJn5y5OA3y+MPLkk7JiPbHDgpm/tV+t7FCZlpf98oXpZx5PMn0LebjzGjAYDl7OgSutD+NJLUTFm6TT7p9ZkDcao18s0dbz4ahZBaIQgOQlpkmMs57tGJyf48FHPv+OGlp3Lwy67o1EH1mEl3BSGe3/CJf43JOZtHz/OMWw7u74dwMnVD0JjFn66fMaD65PpFL83GidumnAayxpQi9+N/rkfzlj0a42N558AVdPj/CbHhzIINhAKBorKkQoV4CXM//2pWHKmmlOZk1t73xNRYxAtImfZYbPbRnEZmReJ9Y6jKxCEJaMwT02Lw6yKR+pCi/mngVsvaI7XO8UzAMo5hfb/x/X+Oj6PnjVdc3L161jMzJ8x7ZdXBcroVY0AC8/oWB0XQ/0Wt6pbmjEVMP+7v2wpRjayZWREfa/LJTfD8Yu56+J+vffL9V1u/XHJL3rurv60gawhtzf73PiiZuvKlIX7UosWdA1cQBQSgghJj155h5Su/wU+8N7Fl+z8eNjM8X1dXhXyozj4WlZCI5HLy0ZIQG0b/lydAAgFdAp5hOiWgq6YH9EzAMqPgu9f/F/TcBzsPbPli/WNJpJJSVMIk880N1KAGNRqFBH2e3Mx05ajbm5OYF2gnqlPrJ6zPJiO0PJ/ghNEj+5RX1zHLNG1D1mdrjt+R9vb9vUiNzTsHjghMuC0u72SOofeGyY+tfDAts5UsyOmCvJ461LSAhPGL3vsm48iXqQF7l2y/SGopISERSK1igl1FQR4KCBDRZeBNmDjlwslMvSZgqdRqkSAAfyI2F+/MyEJq48j5leOnqISr9KdDpxNGDcc51MBRk2T/+y6HGg8v/eGNKanbLlr4iBYMHTPp0ub/+6WGellr1VW/7Pq2Inkw7iMQ6nPblm8QPr9qvCFaYTbvHDgk9sEXJpesW7njIh2zGgv2rF6bN33KKF8m+crOviBH2pKDGWTwvWrfwoffz5bjQ4DTJSQNCWCqZVRci0keFXZ0+74SpJVn79ldknJfciCzFngX1069bF/AclVH1IyBE/+WmLt63swpK/8X8djcodfKS0mkSElsXT9l1sz5vw14828PUL1CXv95K6bLt72Ae23zj/Wat/SRwe3GrUyIkl56M1V6bMVjT82c8NSz879HM1e8MiaIrESovqSwof7H1dOYDiC+/TfXjp0DhwTc/sonKxLP/vupcdhTaWeHrvnimURqReDYVxYknlz58MQ5m6Wj7qPboohJy19RbZzxIG75kfypNdSAFIq9bTza/tzC9OuJqe8vjsh4cdyDM9KKHlzzz7GdxwPAzce+mZ+ZgGV7yHT2x8+1hxctLJ8D50yxFvz4uefwlh8/d9aNeRYAAFjmSMBybafUGjglHQBgwu6A5b5oBQAA7dkXsCBaAQA8yL5Bd3vBFUd7OLhEMrDClZdIdgkIWAAAF3Jk0B0AADwCAhYAgDUgYAEAWMPaNF/Gq7l3ydIlsWAMq4frgYPuDgwkA9t1PS8hWbZsMcxLCCzoaT/NceznJsB2XXcJl379qdkbWQ0AAO4CY1gAANawO2A9fc8EUrqJwTWwAPBK9gUsHK3CS//rXMzq1nkJ1VnrDZPfYM1Zb8yaOXev4YLL1OI7x4vNTUp4YfMEUlm+/7XV+2U3ZtYBLiXP27JkxuRx7aa6Majat3Diuu46hxncHOwIWEy0wgWnY1b3zUvokzw0+eKVYnJZ5MLcvOTk4LO55IK7pfnnEm4bHGf9ChANpVdh2rvuosr6aEnB2A/3Hjly8KvF0elLNmQanmt5wa4lz27Ig6ceWGdrwDJGK4Zp2SnW5yVEqOXyrvnP4ERs+ZZt/5nwxmESeixPHeg/6LbBF/IL6fLFvFOjHngksfrsRXoiiarifOltSREmqVPL1Yw38L/4zD82nWZm06nZ/8bq/ejKxwvfoJIspC5gpkRMfefbUuMlm4HjBCOXZ6yaEEFdmF86asxYVVZuAV2f9+lTKy+PXfEcfelRACyzKWB1iFYM2akVpOQM6/MStmVveOt44oIvDnw+PyA/m9mii6kDw5JS/HLzqHlZys+dHjC0X//hI3JP5+Fwo7j4Z83IIdFMK4r2ys4PvpE/8v6Bz98civLpql6T3nxtEur/0odvTqIuuJuZpXpyz5YvXhuWv2lndjfOp98jlRTmoCH9mRkJE5/55qvXJ8TCHDegK10HLLPRiuFwzLJ1XsIrucelD0xK9kO86EkTRzLbdjV1YPTQ4TXn8hWouThPfNtgMRqclJKVi+NR0cVLo4bHk0aUij+zZKNm3t+L2s84+mrxHSVNuhsHOL/hd41C8haY7suVKtLXbgt45eWxZFoJmI8L2KbrgGW99+dYzLJxXsKqiiIk9mcmchb40a2wrqYOHDxk1LkrRS15Z0txBxBvmHjb0Av5pdXFeYMGJJjOKNHQcGNiO5F/MP3f9npJxaQEXKl0z8IXdiesWDMZfz4BYI+uA5Z0xErrN9LOSebmJYyIikfNLczokUph6JN1OXVg/6SRF/IPXsoenkB3AMVxiai8oLBcMLS/IebRgoJuTGynU8Nwr3vI/9z44ssnR7z/ySu3k+wKANvZOuje7czOS9g/aYzs8P4cBdKW7z9oGMPqcupA0S3DI89mFacM7c8s405iw7kLqpREk/kHsZiUv8Zk7jxUjrSK0xn/Y8bpaY0tMD19N5EdS/tX3oRPP5w1AKIVcIS1gNXW1rbYBqS1k8zOSyhKefkfI3PWPTvhuc2C4aNIy66nDvRLuTO4UHJbsmEq4MFDoo+fCRp6YwpVRvSji1Ijji2f8Mwr+2P/Ot5QOfRetHMp8y0hcLGSHzZnt+Z9NIeak5D2EZx2BezCkiuO4iRo0yurfRZ9/4zpLPbA28GPn4FreU2X0KyG7P9b+uyUWTMnPPXC5+oZHzwO0QqAHs27A1ZQyt/e+eJ7amR962fzH+jnR6oBAD2TdwcsAAAwAQELAMAa9g26L1u2zK65VOGKoz0cXCIZuJbdAQvf2x6zIGABAFzIkS4hE7YAAMDNHAlYdvUKAQDAVewOWBCtAACewpIz3QE7waA7cC0IWKAbwU9zgGvBeVgAANaAgAUAYA0IWI6CuQsBcDv3B6xunZcQo/b/8QWygFUdemPCf3PJQmfW5x80v9YwdyGwm/l5CeV/bl44bSKufPatY1XtPwmq9i1kLp1lsDC9lqwCPZBnMqxum5fQfmHWpyk0C+YudJD5eQllx9KWHkz45zdHDn6TGrBx4X/zmMaMiKkfHjH4cLpUOj11cocrYoOepN23hHPmzGEKTtqyZQtTMPctIc6AVqPlO18aQpbP/XfmlugPPxjfqz5n26pPDl9sVgvE/R9ZtGzOQOpqMi2Xdy19Z28hint8bK+v85M2v0lPb1Od9e57G49XIP+Bf121ZPrgdped6bh/nGHNLZ9xgLnyX+cNcQ61sHwOHbPM/FvU2uKRz9Tv/CpHLUqe/dqiR2Pq97+x8GNqOj16NjB481hl7VvCPz4at1LwYXpqws9pE7/o88WWWdSUXxV7XnyuMjXjlWSmjaniHc/+q3nxV6mJHS8w60XgW8Lu1i7DwoHGJcjubOHyeQmtsL6h2X+L0mF2QpO5CyFaOcF0XkLka5jniycQqApKzHT6VJnfbI945jFvjlbADTzTJezOeQkpxv3j29wtV0it9Q3N/lsUmJ2wG5jMSyi4JTm5cPfubDnSynPSv6c6hDqmkQnZ0e9PT35iDDW9LejJPDyG1R3zEmI3xsh27Nw8h0yeY31D8/8WBWYndLUO8xJKJyxempyz+uFxDy85GzsqEUVIJXS9iaqfDxbcfzekV8AzAcsMF85LaInVDc3/W8DVzM5LGHH/8i/SjxxJ/2RuqLwgqk+sL6k3kOedLhg7PJEsgR7MawKWC+cltMT6hmb/LYtg7kKHmJ2XsHTPs9M+yG5ESFuyZ9vBiImjyMDWDQW5OclJCWQB9GReE7BcOS+hBdY3NPtvmWeYuxBOCLKT+XkJY6ateUG58alx4yYvPDlwxXuPMvEq56NxC9Or6WJtSYEqQhpIl0HPxpIfP7tzXkKYA9F14MfPwLWsBaxxqeNIqStHNh4hpfacDVgN2f+XtvF4qUKFfGLuenLpM90505c7/60eAwIWcK0uAtawMY+SBcvOHP+2uwIWYDkIWMC1bBrDOnNlu9kbWQ0AAG5h66D7sP5PdLiRFQAA4C42dQlxMtU5QhkroUsILMFdQlLqMaBL2K1sDVhMTQcQsAAA7mRTl5DpA3a+kdUAAOAWXZ3W0NuGE7rLRJBhAQDcoIuAtW7FJrJgwYEz3x3Y/wMELACAG3QdsHBIIssWQMAClvTAQXdgOwe+oIAMC3SjnnbiaE+2Z88eu461YyfZdj3oToUkyzfSCAAAul8XAWvBynm/n7mEcygr96QpAAB0sy4CFu7r1ZZf7fKetPYG1q+NZeOVs4B3cuDwwRG/uVgLWEwksuXeXi1XD7+79Nkps+h5CbfldJiKjmJ9ukDzrE8XaFjryJ6Bq+R8RK6ERZs8Y8kW4+SE1pWkv7wk/TpZsKY6fSFzmS3bNwHsYdOJo67VcmHzcyszY59b+/2OnQc2rhzfvDF19eGOMcv10wUa1jqyZ+BKk98m8wwe+Wp5Quar2/8k9VbJruXbNhdk+OQPjzCzhNm8CWAP9wes8oPbjie/tOzxhCBqyafXmOdfm6nYtvWMms59Vq/+z+wJz3x2utIkD6rOevcfsyfMmj1t5a6L1PWNmSzpP5t2vzFtzswpqW98XaBGqGb/G6v3oysfL6QuBFqfs21RKt6EWrvlMt7GZO1le/cMuk1g8ogh8ryCKqpccSztGWry5xszQlO50pKV/544bvKada8sSUd5Hz25MP1PY+UH2Soky95ITxk9buK0hZv/pDcjGVZV+gLDJsxlS8FNwe0BqzY3qzRl5FCTi+PxoocO9Tl+IZ9eyBfc9emBz58fzqeXMIuTCZ7N80+lpwss3/Jd++kCRZ2nODRZa5wpitrzxqqxaV3tGXQbWfbJ3wISEyKQNm/jP9ZWTfzkyMFvlscfXJJ2zNCzzxOM/ebI3lcXfPTeZJT4yrYP6WmfmcpFKa3H1r6ad/d/MnCu9uEk+Y4vjFthEZPXGTYJJ1XgJuCBLiFC/gEiUmIEh0STEoob3N8PmV5q3eJkgnFj7rAwXaDZKQ47q/gzSzZq5vhow54zc8heLO8ZuEL6MmYEa9zE5zfKp7/3xC0IleZk1t73xNRYxAtImfZYbPbRnEambULS4IB2rweKoTJw7JojH06LQUglF0il+EBDD9CrLGuP1DrHIwGrRd7+F4pqBXl5IhQf22GuTIuTCXZqeYOZKQ7NaGioQj4C5s0QHpd446+ysmfgAsYxrIw9XyyfmkDNn1NXd+NYRCUkIrnhWCTEmpnDzVgpz9uyZMbkceMefmrl3hKmCniPt99+m5Tal53h9oAVljQyJjvrHDNiRNOWZ/1WP2bIALLYgQOzEJqb4tCMoKAIpFYxg/3VxXmd8j7gPiEhN45FRUEeCrDpWFzc/uouaeqXOPLt/eRpepwdeBkmTrkqWmHuz7CiH3xyTM7Hb39d0EAtqWuOf7Z6p9+Ts4cxky53Yt8shPR0gWanOKS0n0ww6paR0sydh8qpaXIy/leaPCoZZnj2lJjkUWFHt+8rQVp59p7dJSn3JZuZ1EsmbyUlQqlS+QqpA91YsH3PMaTq3CPstAlwOxdGK8wDXUL/IXM/XzGq5PPF1HlYqSsOiVM3vvZARMdxCgM7ZiE0TBcYYm6KQ+Na48As3vPrqRHHlk946oV3Sse8+eLIYLICuB0vMfX9xREZL457cEZa0YNr/jm2U6c89rbxaPtzC9NN54Ic8tjioWdXPjxu4t93R8x5JbmwpKTdh5lhE/iW8KaB0P8DIkSOWvlYEDAAAAAASUVORK5CYII=",this.options.images["Gui.Office2013VeryDarkGrayGreen.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayOrange.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayPurple.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayTeal.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013VeryDarkGrayViolet.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhiteBlue.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhiteCarmine.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhiteGreen.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhiteOrange.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhitePurple.png"]="data:image/png;base64, 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",
this.options.images["Gui.Office2013WhiteTeal.png"]="data:image/png;base64, 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",this.options.images["Gui.Office2013WhiteViolet.png"]="data:image/png;base64, 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",this.options.images["Gui.OptionsGui.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAAK/INwWK6QAAAI1JREFUeNpi/P//P8NAAiZsgjdTXP/TUpygAwY8BAaVA/yad/6npTgjKBESE1fUAupzdjOiCIAcgI5vJLv8h7F9m3b8p7Y4Mh7wNMCIXg6A4qr7YQ9DqXwJhmJqicPAplp3xtEoGM0Fo7lgNApGc8FoLhiNgtFcMJoLBmcUYCQUKouPds3wJkJ6A4AAAwA70maafaaHLwAAAABJRU5ErkJggg==",this.options.images["LocalizationBackground.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAAAPUlEQVR42uzOAQ0AIAwDsIHiy7s8bCykVdCT2TS5KSMkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCT0c+gJMACixAGIASS4OwAAAABJRU5ErkJggg==",this.options.images["LocalizationBackgroundSelected.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAABfElEQVR42mJkKNjBMJgAE8MgA6MOQgIi3GwqIlyDyEHVrkrXK23mR+ooCHEOvIO8tERTLWVYmBi9tUQHhYNc1YS52ZiBjKsvvhy4826AHQQJHiDj9ZdfjTvvDnwaCtUXhwTP6gsvkINnYBwEDJ5QAwlI8Ky++JJ+uQyYVNcnGUrwshOZemjrIB52ZqBrAnTFzpdaWsgLwMWB7suwloWw0VIPbR0EdISOJA/EBYfzzFIsZCDi5c6KHCwgS4Fhgxk8QMDMYBFDCwfde/v98L33HpoiPOzAsobRT0cMGIMXn31eEKUL5AMVJC6/8uDdd0yNjDSt7WUEOIARZyLLB+F++fkXGJWQ4HGcenoA6rInH37YTjq54NRTeMLCk3rolO1//PkHjJ3CDTf+/PsPEcGVeuhaDk04+NBz5tk3X3/hDx4aJmqsyXz1BVAxOPPYYzzKGEebsKMOGnXQqINGHTTqoFEHjTpo1EGjDhp10KiDRh006qBRB406iJoAIMAA1yp6sGiWdMwAAAAASUVORK5CYII=",this.options.images["LogIn.Blue.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPUlEQVR42pSTMU7DQBBFN+7xBXyBuEehTOOKLrmA6RHUiPQRdUzS+wKmo4qQKInofQJfIDmA+RP9QT8bOVJWGq13duf9mdn1qO/7oGP6/FlgmsDm4XTUsJ/v1f1OnSMHIDDF9MbgS2MLyMsJgMFrWC5qDQ52Ap/BnmKIA16ZsgXYxg1sActgFfcy7tlZAy4BaRIEZ1KvHdjDNgwIVD1+I2DL7IKXmsAKOizlFnMpad4yg0Dw0R8DvG7vrgOrKODALDquUwekrsBybL2PD7I/3tD/jJKBqzrIdx7tjRWYSG25qGZQmlDNe+JNfdDSDNDScefN5Gw38WWvT6C/bF4LsdoBH8zCFE3tXRq647qSEkzgMX6JBZ+xB9kVNvJ/5LydTv3xv1DIKxsay0GAqJVU0+63zKqOiWeAa8efAAMArfGIvPnoaQIAAAAASUVORK5CYII=",this.options.images["LogIn.Blue.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mK0y93KgAU4A3EZEAtD+R+AeBIQb0JXyIJFswUQd6KJCQBxHRCzA/FqZAkmLAaUM+AGMegC2AyQxmMAMyED2HEYCgM8hAz4CcW4wDdivHAHjwG3iDFgMx4DVhFjwDogPodFfBsQHyPGgH9AnAvEy4H4NxTPA+IGbE5CT0gqQJwJxL+A+DQQT4Ua+AOIW4FYGeq6RUD8DNkAViAuBOIwJMNccYSDEhD7AnEpyEtMUG90omkmBEDppQOIxZigptkxkA64gDgCZEAIA/nAngkacOQCeYAAAwBlWyOF1zGOxwAAAABJRU5ErkJggg==",this.options.images["LogIn.Blue.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA+0lEQVR42mK0y93KAAXaQJwMxBpAzAHEN4F4ORAfYsADWKB0EhBnocmZQvFsIJ6JywAmILZB0wwyLBuJnwrEBvgMiMYi/h2NH4LPC+imz8OiTh6fC1gZKAAgA54Roe4hPgPmEmGAIxDr4TJgIxDvJ2AAOxBPAmJNbAaAQCkQtwHxezyG8ADxVCBWwZaQQGAdFAtDDbIHYksgFoR6AQT4gHg6EKfAwoUJi01vgfgf1FsgV1UBcT+SvCDUEClcBqCD30C8GWooDIgB8SwQzSxvHk1MdP8E4ldALALVDAsTCSYS0gwotoqg4QQDNiwkJjxQ+HRAUy8okC8ABBgAivUoPny6fO0AAAAASUVORK5CYII=",this.options.images["LogIn.Carmine.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPUlEQVR42pSTMW7CQBBFF/f4Ar4A7hHJAXwBaCLRkB6lj5Ie0Tukd4OUxlwApU4QvU/gC8ABnD/oT/RZ5EhZabTe2Z33Z2bXg67rgo6vh3mBaQKbhetRwb7vP7YHdQ4cgMAU05rBf409IM9XAAZvYLmo1TjYCnwKe4ohDnhhyhZgG0PYKyyDldzLuGdnDbgCpE4QnEm9duAEe2dAoOrlGwF7Zhe81ARW0GEpN5gXkuaYGQSCL/4Y4HV7dx1YRgFnZtFynTogdQWWY+tTfJD98Yb+ZpT0XNVZvvNob6TARGrLRTWD0oRq3hNv6qOWZoCGjjtvJme7iU97fQI9snkNxCoH7JiFKZramzT0wHUpJZjAMn6JBZ+xB9kV1vJ/5LydVv3xv1DIK+sbq16AqC2opt1vmFUVE28A/x0/AgwAjQeIvLyn06AAAAAASUVORK5CYII=",this.options.images["LogIn.Carmine.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mI8HhbJgAU4A3EZEAtD+R+AeBIQb0JXyIJFswUQd6KJCQBxHRCzA/FqZAkmLAaUM+AGMegC2AyQxmMAMyED2HEYCgM8hAz4CcW4wDdivHAHjwG3iDFgMx4DVhFjwDogPodFfBsQHyPGgH9AnAvEy4H4NxTPA+IGbE5CT0gqQJwJxL+A+DQQT4Ua+AOIW4FYGeq6RUD8DNkAViAuBOIwJMNccYSDEhD7AnEpyEtMUG90omkmBEDppQOIxZigptkxkA64gDgCZEAIA/nAngkacOQCeYAAAwC/dCObvh9UwwAAAABJRU5ErkJggg==",this.options.images["LogIn.Carmine.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA+ElEQVR42mI8HhbJAAXaQJwMxBpAzAHEN4F4ORAfYsADWKB0EhBnocmZQvFsIJ6JywAmILZB0wwyLBuJnwrEBvgMiMYi/h2NH4LPC+imz8OiTh6fC1gZKAAgA54Roe4hPgPmEmGAIxDr4TJgIxDvJ2AAOxBPAmJNbAaAQCkQtwHxezyG8ADxVCBWwZaQQGAdFAtDDbIHYksgFoR6AQT4gHg6EKfAwoUJi01vgfgf1FsgV1UBcT+SvCDUEClcBqCD30C8GWooDIgB8SwQzURkdH8C4lYgvookJgHExUwkpBlQbBVBwwkGbFhITHig8OmApl5QIF8ACDAAtrQoSFymj+oAAAAASUVORK5CYII=",this.options.images["LogIn.CloudBigIcon.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAKgAAABuCAYAAACz+lgdAAAABGdBTUEAAK/INwWK6QAAJXdJREFUeNrsfQmUHNV57l9b7z37vkuakTQzmtGOBQIsA8aGYDDPCl4IjiHHSexwEux4S8A57504sRM7eAsvxu/Zx2F5YF5igm2wzWIwSIAkZElIg6TRaGaY0exrT/dM71X5/1pmqquqpRmpe7ob+p5z1a2unq669373+5f73/8ykiRBvuRLthY23wX5kgdovuTLRRZGL+L37duX75EU96/hPaP7zPgqWbxKuv+D4f27ovB5DKUNlKz6nlPfGytjALAGQFH3Gldf9VV6N4H1kgG6e/eVmUcEs7zvpcMe3L9/n54JNfARKLmWlvU1NputUhCEBp7n1rEsVaYGn0NkWbYCv2NTnkvyY50jQIqieC4Wi/VFIpEerGOBgH9oZGRkBq/FdFUPWBqDnAUr9l+eQdPUsRowOR0o+aampiqvt6AVgdkhCPxuhmFbGYYpwurE6/blzCMEdMjpdIYQrONFRUXHKioqDgeDoZPDw8MnELDz+J2IDqxxfJZ3BFjzAE0dMBkdKIXGxqaK4uLi99jt9r3IjNuwNq2E2U0CQQGzExm3GJl3A4L9No/HGyopKemLxaIH5ub8T42Pj3XNzs76VLBGVHWAwBp/JwE1D9CLAyb1m9DW1r7Z4/F8nOf5DyGo6leqcqxQhXFwHNdKtbzc8amSkuLjoVD4l6OjIz8bHR0dwuthFajRdxJQL9mKf6froFbA7OjovMLlct2FYPkgArMg1YBcSVtIDQiHw/81OTnx+MDAQDd+FFLBGtVYNZuBeiEdNA/QC+uYi8BsbW3bWFBQ8EVkzP9Bn13oviLeL4icNo91HE2giYAEUwGAmQWyhhTUzyGcBFQUHAKAC00mjwNlO76vLQKoKWLAi/+38xduF47jdDC48FhfX9//RdE/jh8HDUCVshGkeSPp0sW5UF1dXVxXV/9ZNF4+i4xZfL5JMTAN0D0qQd8UQM84VQlmCZCSAkqtaoU+l2/EKL/JqpVH0AqsBA2lABurGGivAWirYaCpNNkEZUpcLvdfbNzYer3fP/dgV1fXk/hhQMeoOSn28wxqDU7NALJt2rTpMrTK/wkNnx3J7tM3CfBqrwQHsPZNIFP6URlEKNhw+vOs8nyLf8qYnZ+Lz2d4I4ECZvotAm25l8AKsHMNAxsqGNjakLyNoVDo5/39fd+YmpoaxP8uqEDNOjbNi/gVAFQFJ6dWx44dOz5js9m/zLJMkZX4frlbgudPAryGwJwLKiDi2CVQplTnJGQhtGKi4k8isf/+Vgb+aBfAunLGsq3xeLx/enrqG93d3c+pbKqJfXkBIBtAmgfoMgGqA6dQVlZWuG5d8z+jrnmH1e+/3gvwyAERjgwgu8UU/ZFdZUOJ2hJEPixyAfzx5Qx8dCcj67IWumnY5/Pd39V14iH8iNxS8ypIY9kA0gsBNB8skghOW0NDY11zc8tPCJwMkwjOczMAX31Kgr9+QoRDffgHjGLYsExmJiXdewENsO+9IMFfPS7BqRHzd5D97UVFRV/ZvHnLlzmOK8OPC7A6VfuD1RmDWVnYPDiXwIms2VRbW/sEDuQHjKz53FsSfPZREX51XMJBV1iTyYKhJXXCgUA91CfB3Y+J8PSbkhWYGY/H86nNmzf/vQpSrwpSIdtByubBqYCzvr6+uqKi4idoDG3RA4+MlB++LMH/+oUkGz9ue2YY87xsitVlV1xa//grCf4PPq9RnaE2OZ2uWzo6Ou/D/5aqTOrIdiZl8+AEoa6urqq2tu7fEZw79eAkQ+j+5yT44SvKaNuy3ClHrimaPD9AgP7zbyRTuBO1ze12fwTF/ZfwvyU6Js1akLLvYnDKDnin0+lGcH4bRd9uo8gm3e6JNyRwCYp1nguFAOpGkf/EIQm+9ay1/UPLs21t7XfhW/LpekAJYqHJymQbSN9VACUA6pzwxBqO9vZNn0eD6GYjOAmYj+MgO7NE11xpO0kVeeKgBA/+TrL0eKDh9GdNTWuuobdY3TqQ5hk0C4qsd6LRcKPdbv9rIwC7hiX4t5ekxdWdXJ2MTmTSH++X4KljkpV1b6uqqvpSaWnpRvyoUGc0cdnEou8qgO7bl6B3Vrtc7n8ENWhYK9E4wP9+CWA+DCa/Yi6ClFSTB34rQfe4xSzluOrGxsa/1OmjmtGUNaKefwcBT2/UWm2n0CYktdlVXV1zLxpFjUaG/E2XBIf7JdmN9E4oNMl8CwDf+JUI3/sYCx67ybK/srm55aaenjP/CUuB0HH1NQ/QSzR0NNDpt1poBhBjISFk0d7a2vo+m832cSM4ac37meOK9Zurot2qkJ/02CDAQ69J8Nk9poYxKObvGh8f+/3cHMVWLYJUouCSTK808TkOSnmbRUNDQ0lxcXEHMmI51hIUXciMjEfCQv/Hl3lRFGkLxXQ8Ho/Y7Y5bVX0rUfccAnn50vYOjPEiY+//o+F3zUZGDjjRsygaiZX19Q0f6eo68X1Q1usXI/TzDLpyYMqgrKmpKSwpKelAEXWjIPB/gEBcc6lWaM+EItppjZsc9JlYY0+bVcgqevWDL4vwrb1sgtuMQOr1em8oLCx6xuebTYh8yjSL8jkCzkXjpqCgwL1+/fpPCILtTgTlZkihOL55MwMdtQCnRgGODkhwqB9gMqBco+ihXBf7NOFe7QF48TTAda0mg6kQDcdbEaBvw1JASTTTLMrnADg1w8a2deu2WxwOxxcImOkAC4GQgoNJBH54CyMvbf6uW5L1UgrEoDA3Ev+5ilMt+OWxgxJc2cyYDEFk0T1IAE+iLootl2NIw5lmUT7LwSmLc5vN7tq8efO9aNj8FX1mBc6IHCspyaJZ60k5PpPRBoeRAyv4FTjWKEB473YGPtTJwL4eCR5+XYKTI4plzOWog44m4YkhCV48BXBDB5PokuK44qqqqvchQIlF/ao+mlEW5bMcnOSvLK+rq/8Bdt4NRmAuRCQ4MipC13gc3p4VYS4kgT+iAFWSDQMGPIKypi4gWoscAAVOFspcDNR6GajwsFBbwECh/fycaMffuLaVgcvXMfDTQxI8ckCCQAhy1hVFkuAXb0pwbRsDNi6RYQsKCq/Ctz/DOquK+pAqxeJ5gBrEOlrmqBfV/wjBeZ0enMSWz/VE4dmzMTjnkyCKCCQAais/2lfn4hLMBpX/E2T7ZgmsIlZaJULw2nBAEJwE0m01HGyu4qDGm5waKf7yzt0MbG9k4DvPi/DmOSWKKNdEPln0RwcBjuPzb29MvCYIQn1FRUXr+Pj4NHWh6u2I0LhkQszzWQjOxXXylpb1XzeCc3xeggcPReDQUFwW1wJVzhoi2mY0qyvU02EE+lhAghG/BAfPicikUdhay8GeJh62IFiT6bmddQDfvo2Fb78gyfGhpJfmkrVPj0orZrQoQZNNX1C/t6M1vwUBehSUlSVBlWZ5BtUMSrJFtmzZ8hGczZ/Ug2QSwfnNfWE4PSnKEUaXOkicrHctfRbCIXipLw6vDcShtYyFW1oFmVmtSqEL4O9uYqDAIaHRkXsuKRLth/olmFlgoNiVeM3jcXeAEkBC6/M2WFoAWXUGzRpVXyfahZqa2mqn0/U3+ucjsf7AwdSAM2ln0NKfaqW/OSbC118Ow7++HoHRgJj0+/dcx8InL2fk58ulFB5k5I2hAD/YZw4ksdsdTQ6Ho0wHUD5TWMk2W1RmT7QkP4qiZp2ePX99JgqHh0VZf1oNd4zm93wO9dz7ng/DC72xpCC9+xoGbt3KyA7+XMmoTm2jDX9HBswPjGqVp6ioqEkFqB0yuDUkmwAqG0YFWGw220f14CTL/NdnYrK+uZo9JDMqDs1sSIIHDkTgR4cjEI5ZqwtfuJ6BazYw8ia2XHI5HX5byW5ibJLH41mr6qCaiH/3MqhevNfW1l2GM3hDwvWBmGzI8BkKf9P8pz8/FYP7Xw3BXFiy/M6XPsDAhiqwBHE2FurPYZ+yW9UEXru9VmVPm8agkAGHRbYxqIC6zw698UapYd4YiikRRpl8OJVNXxsU4V/2h8FvAdJSj8Kk9L24mBsgFUUKkrGYcLxQrBPvvM5QelcCdHF3Jc/z7foLs0EJuielBIdyJgsZaEdHRfg+Gk8hC6bc2sDAHbtyx2iiifTWiIUxwLEuhmFsOjcT+64HqCAIDjSO6vT659CciMaHlFUuHAfyyYFzcVknFS1Q+In3MLClHkV9NBesJRTzs2bGx3FwIlm4YCkVUEawsup+UENOd71j3i6KooPybeq/3zcryiDgsmtMZb/ns2ej8irUh1sTXQt07dNXMfC5J5T96dkcBUW+4JkFCabnGTn2QNdKVpIkm6qDakwqqOnG5Wm5GitL/CoD0njShTwz0Siyu1yuMgRnhWo5LpauMVFeW0+2WpRJkNLy6hMnotBSykF7RSLB7Gxi4Po2gF8ek+TNa1kLUFbJVzo1DwkARQZ1oCVf6fP5BhGo5LSnwJG4Om7yCSS63PhpAyyfZmDqUxnKtaKioqCysmoTHTKAndCginQ504VEqibHVep/Z10pCweGstQKxpYFUQ/9MYr6/3mtHby2xElEuuj+HkkOFM7W6CdK40OZ+XzBJTOUGB/VraINGzb+WSwW+wME6AhKNzp55PWpqak3xsZGJ0HZFhKFpT1MGmBTmtqRTxNb6hlSaGlZv8br9V6Fjb4eAXiZmgTW8sQLozj8QDMPL/fHYNQvZeUuSzLezs6I8PNTUbi9M5Eq15QBfLCdgUcPSPI+9SxVQeV1edpYZxwHQeBLUA+lHZ+d9Jnb7f50UVGRv6mp6WgoFHpubs63v6+vj9KOawc56PPjp4RV+TQwphzDiSLb2dzcchW+3qmklGFqLkYXK3IwcPtmG9z/alh2OXFZmBeJQPr06RjsrOVhfWkiVX5oMwNPH5cgFM1iFmWIQZO0jzGorPKROvweFP97ELBTZWXlb/j9/od7e8/uR4bVbxfRjsi5JJCm4ihE4yEDtq1bt95ktzv+BNnymmTMuNLy8LEo/AfqezTItixkUlrmvLyBg69cZabKe5+U4Nm3JDlcLxsLrX59Zg8Dd+1e2SDpl3Wj0ej+ubm5H506dfK3sJTROWHznRVQ050fVA9MSiOzbdeuXf/ucrkfInBqWwxSYcXe3inAPZfboNrLyHqfmGVORlo2PDIch6Mj5qi0mzcrW0Wy1S9KwxMMX8Tf6cYX1bfdpaWlD+7YseO7dXX1pBJQthIt7xN5AC4qGQR7CW1ajHonf9mOHTs/h/rJMxzHfxgfmEu1a4XE0PvW8vC1ax3w4VZeNlDC8ewZZHo+cs4/haLeOHm2N5FflJGDM7IVocFL9NmqQBVQct5SX1//OJLVp2ApOdliXOlKQcpfKjhbWlrWlZaWfdMq6etyymREgqGQKL9OUA2LUGFn4Q+rBUvnfLGTgTu32uCyWg4eezMqh8U5siRgmFiyaywu144qLsHav3YjwBv9kPEl22QDOm8R5DITluAkGoBuhFahjYFiOyO/XgioaHOUIVn9/bZt27d1d5/+h0AgMAZKjvywKtaXfdoIfwngtHV0dOz2eLwP4AM1LwecFBB8Zj4OR3xxeGUaxeFcHMZDkrw1Yx5rVFarJRltD1bw8Lfr7XBdmfUjtldw8NU9HDz6ZgSe6VZYi2czP9BhfH7aitJeySVMGtrPVOElhzhkLOjlfCVqIY2mcGye6o/JBODglBU0F1qptW4G1hVwUI2vRRaA1bDgdDpvbW1tq0ZL/77JyYkeWDrIIaIaUBcMguYvEpz2zs7N16Al9yOWZcrO90cEnCMIxJ8ORWH/VBwO+mIQi0hLyoXWGu3XBUZ+5BfHovDSVAzuqBfgb5odsNHDWup9d22zQXMJCz85EoXpoCR3YmbdTgwcRl100CdCY9HSM1ejRtZey8CLp6SsAygD1nGsWgA3GaZROg4HYeXDLw4vSHBwXIQi1C6bEagd2P9rClhLoNpstl3Nzet+KAj8PSMjI106AaIZUCnRQfUn+9qROa8mcDJMcnBGsEGPISjf/9o8XPFKAL55OgSvTkXlY1RkEHJqtTo9XV78ZOROe6gvAlfuC8B38TXZVLu6iYf73muXXTzBDK9/06CSuDxwzqxwkpiPZ6OlxCzDElaHS9sHRp4UP/b1oYk4PNoThZ+ejcLgvGgJUrRL1jY0NP4LqoIbVOOJ1vj1W0lSYiTJYr2trX2H11vwYwKnlVinR3z0XAR2I6g+cWgBfjselcFKgJNbyKyw4/DvplAXuudYEPYemkcVwTqObS3O4nsRpDtrWcsoo9UsNIivDsRNz0GRTg3F1uI0k4WIwMpHG7tAyCANp51TZHQX6qoPnY7C8zgxjcarmv+pZd26dd8qKCigFEXaSSPChUDKLhMmMjibmprqCgsLUedkKq3AeTogIogW4I/eWIA3pmPqWhJz6VaByrI/OxeFPQj8R4esabLQwcDnd9uRUTmZxTJFVrQRb8gvwfGxxJEqQ3t2U212WvNWakdUWj6P2FhFOryE6s0jZyIwGTLvdRIEoa25ufnLkJiP9LyhfOwy7i37OdFKd1ZWVn0dDaI2qy+SON+zPwBPInsuiu9Umqsqmw5jw2kCfL4rBEELeelC9eHu99jhg+t5mcEyAVLqsEhMsvSJ0vGFQpb5RIlBvY6VM6iVekM2wNsBCf7fmSics9hs6HS6rkPDyeiC4i4WoIuiHY2i25Gmb7Vizq/3hOGOwwswGhQVUZ7u0cdbfBt12o8gUEcsIttJP/rzHTa4oYWDcEzKCBhs2A9HEKCBSOLdt6GYpxWlbNpcR49iBdCIeHF9R2w6iePyRG8MhnUqmebULyoq+lR1dfV2gz5qyaLsMkQ7jwpuvdPp/IrVl/7hTBj+9kRQUf5Xa6FctfZ/hax944F5WbUwzSps2Z1b7bCrjs+I4URsQkkmeqYTn62mCKCxJLu2hEgAllu5Q5dg0RFIZ8OKm2rBoNKgFHbX1NR+BgmvDJZWm3grkC4HoI7KysrPo1FUbWTPHw9G4KtvhdQzpDPQswjSo9NxuOXgPHT545ZuqD/faYO2cnbVN7Ixqog8ZhDzFJG1uS679FBic6s4gUs1NkmSDQcleOFcLIGJCUcOh2MbEt/1Kou6dSy6LAbVdE9bc3NLKyq3f2gE54GZOPwFWtayEMjk0gh2wmlfHG4+uADH58wgLXIqhlNDobJPaLULMahRl9tYrcRhZouYp+cocJo/X0iBekRMengyDqdmzCKjtLT0NsRWuc5gMu0eZS9kuRcXF/8psqfX6OP8wltBCEWl7FhjRH2vd06UdVIrN1SFm4FPI5OSS2Q1RSv5Cwd9EowGEod5bRkDpe7s8IlKoCzRWsWrzqeA5bWlolfH4qa+t9ls6+rq6t+rAtSlA+h5GXRxjzr+cT0i3JT28IH+MOybiKffIFoRSAHOIEg/9sY8jFoYTpsqONjbLsgrIqtG7tiL02g4Dswm3rQedVAZoFmgh9K2YzKQyEWXahG/ODTYD+eQOEjS6cW8LOGKivRiXtNFL8igMnuWlZUhOJly/QUK6PhObwSyMngMn/r3U3H402MLELYYfNrctquew45fvWenNI+nJhN1C9pUV1eSHSKelqK9CIsCQwIxcraH8WIqTAtCG03Go1NiQpuVY3Cc7aWlZetVY8lpFPPsecS7HYvpiMD/Go3CABkkXJZuVUTD6Rdo3X/xraC1Zb/NBuUudtVWc6ibzk6bZ8v6yuzoP1IzKFNfqQGg5GOWV4RS9JiyuhMQYS5idOAztvLy8qsNAOWSMeiiY76pqamZ47iNxhvRMmbWZ2xFVHz/bAQeOmf2L1WiPrp3kyAnsV1Nd9OMYWWluYLJDgYVaYWLkbNI60sA7QtyM6XKOUNEF0TAd/vMk9XlcrWyLKstfy4ebJuMQeU4T4/H20n7T/QXyAA5SjfI9uMuGEX9/+KJoKXR9L41PHRWcauyZi8PDA72OcPA1BUpol7Kgq6qKbQwkPCZaedCKm1gEvP9ftHUP2gsNXi9BXWwlO5x0ViyAqhsIOEfmZY090/HwReRciPnNfbsOBoodx8PKsEqBv/cxzttsnM63VtHaABoz8/QXOKNSKxWITDiGQ4cIbWnsdT8uS+aei8DgX0mIpmCSVBSe10uZ42OQRed9mwS/ZPW3jcYiVL2M8al3EnKjqL+WdSZf/C2OVx8Yxkrh+lF0uzrkR32FENpYA4yTCq9K1/vTrWLiQDaWm0eUApWTrUHkfRx0kH9FlEoLpe7yQKgJgbVojMFBGitsTFnF8TcOjGAUSjsa90h6F8wI+HG9bx8iEK63T20QWskICXch3yPFQVMRl1NpH9SRr5qCxFPAE3HvjLyrQYtvCh2u61KJ96TMqgGUt4YjEwK7lhYyr0jLbA1E6iHfu1M2KTvNRSycJXMoukXoxNowRoHhsCRyUI+4XU4yh6Dk55UoomQmJZ8WHTPkGW8qFAIFukek4l42qCf4Hggi24yIubmeYA8A48ORuCIz4pFBdlJnU5dlABKB0AsGJwKFV5FH86UNR9DNmuuZEyxoNNhxUBKx1AzqgvLxCMs6zKAM6kOanWMtbx5ZD4u5eY5gPjMtCz73V7z5m860Gt7DZfWYBJGlUDTwcSBqSygIN7MWPI0ISmp2YYq87URlDjpXHGLxa2MSUbzfyYEMCcDqAmGNMslCXK3oIb+n8NReUep2e3EKS6fdLYPf3vEYChpDJop/bPYDdBebb5Gm+Ji6TQ3mOQ2Gxh2qLHn+XPJICXByTG5ddaKoVXzYRF+OGC26DsqOWgpZdPKGsRYY4agkXJkbyFDUU0kDBtKyNWViBYC5mRQTKug9ApWE0aMWpAjk3ShQJKkhHxntODv4XL8PGp8/p8hixqj8EnXurqRw0FLL1KMq0lknGQqJQ6J2SvWmceTVpAmQulJdEbd6+QIoIyFPhwLWhEjm4RqIR6PT+o/dLAMVNChq7ks57G14wsi/HTIzKJbqniocKePRUWQ5EzGRuOpxL36XUps7rYpu0yNRU6kgSBNBxfJ6/6IoQJDsgdqfyQSmQVdMlz1VWItwElVRIAO6y9Q4GmdM4dFvK48jixq9BVXeBhoKWFl3Sw9GgYj70/SewsIoMWu1V+Tp2j+teUMNFmsIJ31pU/PIYCWORhwWYRpBoPBSVjKhCcmY9BFgCKie40dt97N5T46URKcwEE4YRF9v7OOS+dtZddN0DAzilyrn6mPxpUOxDVu86DnGAikT/8kVm70MlbqpDg/H5gAXbZmjU2tACp/ARHdbdQHOgs44PgcZ1FWMZaemzD7lSjfE60spYPRWDVoJGDwhZIeupoMSveiyKU9G81AoV25s5H0iHdqIu1ooFQ5FuJ9ZmFhgRg0ogOpJUBBvRCbnp46hWJ+Vn/hihJOzjyX82Iem/D0uBmgJajCtJQyaUvrSL9rZFD3KgOUrPSmMoA2C/dSv1+S09mkYxcP6faNXhZK7JbifSQcDtPZ9OSo1rIzWwJUVNGLAJ0ejUaj3QkDiNbXnlIuxx2iCp2RP9S4Pk+eimZsn5SG9tGg0x594xZoGaCrqX/i6L63hZF3vBrFe/esmJZdPJKqS1KSMSvwz87OUua7oApQPYta6qCiiuIw/uGzxrH6ZL3NwhmQY4VR3CkUPmgs67ATnULqlz4ZFRzhmNnVtFo6KLEnnQ1/9XozSihVzdC8mBb3Et23Co3BDYVmHR9JcG5sbPSUClANpBqDWrqZ4hpA8Q8PxuOxMf3Fq5BhtpfyWZqmbQWzGoFy2GcW82uLGXDbUq+HysdfY58Zg6RXM10k+T5bq2m7ifnayZm4rIKkw0CiCbijnDOtmlEfIwl2x2IxUiXnYSl3aCyZmwn0DBoIBCb8/sDv9IPlRg36njV2yKqzCS+S0k6ixWqcZ6UuVt6mnA5Wo980btgTVhGgdOcbN7EWurEEp31iWoJDSPes9zAo3s3GEdo4RILHQElsG1gOg2oinr5ApzQsDAwMPGk0lj5eK8AHKgWKxM1dgOJEOxUQlQgtQ1lTzKVFQNCcNgGUUzLLpVutJ98nhdZd0Wy+NhiQYHheSnmGaklNm/Deal624I3F5/P1YB3At34wZF/WlMhkK0lxFckLfv/cEP7Ir/UdSG6I+9sdUIZsA2LuYvRcUIRpi9zsdQWQtk11xvlAoFiNFWSacNe2MlBgkSTs6FQ8Lbnzqa1byjjYUGSGGa29nzs3+Dq+Jevdp4I0qErvpI56ox5K6/H+3t6z/xGJRAb1Y9bmZeHfOp2KUp2LIGVo/VeCwZD54WsLWGwXk3I7kFGZLIHIWTUNTjrBqUbO39hp4ftckKBnTkz5JCFwVqNhdH0tb8msKNoP+f3+QTLiVYDOw9IhYBdkUE3ME4sGwuHw+OjoyMNGKO6tFuA7mxzKHXOUSXsttoJQALM3TSkSIxbR5OmOAadT7vag5W61e5PYcyHVuzcpGRni8qYmXs5xbywLCwvj/f39r+HbaawzKosugEXe+vNpHZqYJ2T7BgcH96HF9RvjoN2NBtP9nS45bCzrTtdaRhkOmgHqERj5YNh4yi15xuRmSrtop9Q2TgRLp/kaRc6/iQAVUgxOAvtNDTw0uFkTc8Zi8XBfX+8LKOKnVIBO68R7BBIDRpICVNNDY+of0g/MdHeffgTRf8II0s+ttcEj211QquWBzqEyFjE/r9fOyDUdgSORVZY0pFLsbmagvcaMwgNjcfCncGuHBs4b63nYZGG108vAwNsvq475KbX6VAMppBfty2FQUAEaUVl0NhqNDp85c+bBSCR8zgjS22oEeHqXGy4jH2ksd0S+z2ILLK2yONIUp7na6+60U+C27WChe4pwDNkzVStH5IwnMBE4t5dbB90MDw8fxPp7fDuh1mkVoEFYWj1aNkD1q0pBVU+YDgT8Z7q7u7+HRtOIsbPfU8zB85e74WubnFBNoXkE1CwnVH8SkausJklpB2g6u4eWVa9eD9BRZ0bhKyOK7pkK44gc/IWos+9dK1iCk9o8Ojp6BEX7Kyowx9XXGZX8NN+n2TW3HOZWWXRBRfukz+c7ieL++2g8DRk73ItT8t4WO7x6pQe+tMEBJRScqp0gl4VgTXaShS0Nvh/5bHaDZKHMIvE0rOCQ7knLqB/byZp+m5zyJ2dF2Qd7qaxJKktzIQufXC9Aa7FZ56Q6MjJy+OzZnhdVUI6SZqWy55zBtSStFKBafKjmuPerqB9HkHadPPnWd+bn509bEU2Ti4V/anPAsT0e+EaHQxH9SpoNXTBV5gGaDIe0LLcaO6xpkOXkDSm+F1nu729jYFOtwYLGkfztkHJ05MXcUlK5hva2F6Ge/iE0hu5oEaDUYe3rfPvt/pd7e8++pIJyWAXopOpeWjC6lYyFX+Yz6VeXfGp3MghOOHHi+L82N7fsLSkpuZJlGdOcrMMH/3KzHf4SDaljOHOfn4zBL8ei0D8vwjgaKFJU0u0lTeHRNcsB/3nyXyrRR0szmMS9dAF2lC7gyKDfmzcYZSSG/eHUTgZKLUlnMt1+mXlD3DMDUTmsjs7e1Nh8ubfWjCCKit9axsHmUtZyfxERVjAYnEZw7puamjqlivRRtU6o4JyHpXX3pIVfycRRf1DfJikWi4mnTp18uKam5mxtbd3NNputTPPvJeh02LJdqKNSvQ9VgMGgCId9cXk9vAfrcFiEgaAEsygzfMiypCqwF4lLcn6X21i4UGx1LM7BtkLrLmguVXI3aQEOHlRVbFzy36NBoeve85wGTMKj3nCmZYmLgRvaJXmPeqpKWLbcWWg0HFRJR8PQM2wrYxO27hKrno9RJXXCliAw690MtOEYOjjrPpCwTE9Pne7t7duPxrQGyDGD3ulXyS6mk9LWE18f+7hv377lqFFy9mVQEj2R65cOZKKuqLDb7fWNjU3XI5teRgd/rYQVqOPm8R/SaSL4TALDXLQIkk+RYJVOlS5gsNjxSzY2CQEbsgGny9JOR7E8plKyuCYtz5aVT/5hz9+OQCAwOjw89PuJiYnTqo45qTOKplXmDOjAeUFF72IACjqQ0squVwVqqQpUOit8fVVV1eX42slxvDOdA5wvmSsqY4qo6o2Pj4+dQGPoLdXwmVF9nJPqq7ZaFNCJdZHOi9+///yY4y+CoPSWvajTTyPqzJifnZ0NYO1zu92vVFdX7ywoKGhxOl01eZC+c4AZiUTmkTGHJicnz0xMjJ9VwedTwTgDS8uY+kCQxVhPAudy7nWx0YiSzvLS3kd17ihSgOdwZs329PQMorgvKSwsaigtLd3o8bgbBMFWyPM8qgBmoyoP4uwCovIqxdHWiMRiURzShfHZ2Zm3fT7fSCgUmlbH268y5CwsBX9oK0San3NxGXO54LwUgOqte82HFdex6IL6wCT6Z+Lx+BQqzqNY6UB7t9PpLEF2rbDZ7IWot8pgFQTeRZlOBEFwGQzLPGRXGZdqn4vIkGNojc+Gw2F/KBT0ITqndWMcVMc5oI61X/caUK+FYCkARA4CWQk4L0YHvZBeKue3ByXPI+mnBDa3rnrUz1zqd+yqLsvr/l7LrpcHZmaLXn3TVLiICkyNhDRpGdC9129+0zvgL8oc5FM04zS9VNSJ+7D6sAHV4nfoXh06gAqwdPSIEaR5Fs0Mg+rHUw/OiDquIUM1gjKqAzjAJSzJ8ClumKQT/RpQtQYIKlvqKw8WSUvzDJpVDKqNY0xnZ0R1gI3qajxVwEwHQK2AGlfBFlVfeV3lDMA05obM66GZY1ArsonpahzMaWouSZSvJkCTiQpQG6UxpL4yScCZB2Z2gVQ0eHBEi/GGXAFoMrCCBTvmGTO79VHJwI6rFubDZ7jhq9rYfMm9wkhSHh/5kr2FzXdBvmRz+W8BBgDytoBBCrKRwAAAAABJRU5ErkJggg==",this.options.images["LogIn.facebook.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAIAAADZrBkAAAAABGdBTUEAAK/INwWK6QAAAHhJREFUeNpitImcz0A6YGIgC9BXGwt+aT8ntWg/XSkxXgh3xvKzSzdfJqAt2lc3I9KYZNscLRQgjP0nH9RNPECs33i52SCMM5efUSdIGLFGd2mKFTAw0ASfvfocXrCWBrZBwMoJwZCg755zbNO+W0MucQ0JbQABBgBJOB8AcJ9FswAAAABJRU5ErkJggg==",this.options.images["LogIn.google.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAABWzo5XAAAABGdBTUEAAK/INwWK6QAAARVJREFUeNqMVLENgzAQNFEWCF1autQwAiskE0QwAhkBRgBlA0aAEeI6VWjThRGct3SWXuYNvHQyMu/z//3JkTFG2Tjf38qLinAlpGoZncX3edFu4yAknQgvrBkhIvT4Zw/GhBLfao2oJSSEB9u7ESZUVwtnFkQp2tFCboO12Evk2vNj9NpfJZoZoZ88MZ3mLSJ+axGottzT2sy0qGEBBfErTFHvIVKYVglSS2aN9gGBSBIicoaL4SF3+BoYwiqRpFuKyiSnq2PA2QXzlOT6bMvZVtAfM2XE0Hh5wYpyiKtxozQE2+YgtecT+V6S9Bq3xJ7ZdNYiwVSDRB3aSiCo5OwBef1WRRl7PlqY0WAAOYzaSGX+BRgA/QZA1AEVaq0AAAAASUVORK5CYII=",this.options.images["LogIn.Green.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABOklEQVR42pSTwW3CQBBFF9/jBtxAfI9IA6YA0gC5JhF3RO6Iu4Gc3YApICj3oNxdgRuAAswf9Ad9FhkpK43WO7vz/szsetB1XdAx2rwVmIawl3A9Ktjv9/vXXp0DByAwxbRk8L2xA2R2BWDwGpaLWo2DrcDHsGkMccCcKVuAbTzAPmEZrORexj07a8AFIHWC4EzqtQMH2IYBgarnbwTsmF3wUhNYQYel3GCeSJpPzCAQfPbHAK/bu+vAMgo4MouW69QBqSuwHFsf4oPsjzf0klHSc1VH+c6jvUcFJlJbLqoZlIZU8554U1+1NAM0dDx7MznbTfzY6xPoH5vXQKxywJZZmKKpraShe65LKcEEPuKXWPAZe5BdYS3/R87badUf/wuFvLK+segFiNqEatr9hllVMfEG8N9xEmAA3FKIvDC4AKkAAAAASUVORK5CYII=",this.options.images["LogIn.Green.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mJ0mZrBgAU4A3EZEAtD+R+AeBIQb0JXyIJFswUQd6KJCQBxHRCzA/FqZAkmLAaUM+AGMegC2AyQxmMAMyED2HEYCgM8hAz4CcW4wDdivHAHjwG3iDFgMx4DVhFjwDogPodFfBsQHyPGgH9AnAvEy4H4NxTPA+IGbE5CT0gqQJwJxL+A+DQQT4Ua+AOIW4FYGeq6RUD8DNkAViAuBOIwJMNccYSDEhD7AnEpyEtMUG90omkmBEDppQOIxZigptkxkA64gDgCZEAIA/nAngkacOQCeYAAAwDn7SNmMIj/KgAAAABJRU5ErkJggg==",this.options.images["LogIn.Green.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA/klEQVR42mJ0mZrBAAXaQJwMxBpAzAHEN4F4ORAfYsADWKB0EhBnocmZQvFsIJ6JywAmILZB0wwyLBuJnwrEBvgMiMYi/h2NH4LPC+imz8OiTh6fC1gZKAAgA54Roe4hPgPmEmGAIxDr4TJgIxDvJ2AAOxBPAmJNbAaAQCkQtwHxezyG8ADxVCBWQRZkREqJMCAMNcgeiC2BWBDqBRgAyaXAwoVZydsEWxr4D8QPgPgwEB8A4s9Qw0CAE2ogyNufmYgIwN9AvBmI/yGJiQHxLBCNzQXYwE8gfgXEIlDNsDCRINYABmjuBHmJGyk2pFlITHhvgbgDmnpBgXwBIMAAEi4r47GSkIgAAAAASUVORK5CYII=",this.options.images["LogIn.Orange.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPklEQVR42pSTMW7CQBBFF/eYA/gCcR9BSeMLhAsQiRLRR6FH6U3SpfAFnAugSCmD6H0CHwA4gPMH/Yk+ixwpK43WO7vz/szsetB1XdBxXEwLTGPYLFyPCvY9ev/aq3PgAASmmF4Y/NfYAfJ0BWDwKywXtRoHW4E/wFYxxAHPTNkCbGMIW8MyWMm9jHt21oAbQOoEwZnUawdOsDcGBKpevhGwY3bBS01gBR2WcoN5LmneM4NA8MUfA7xu764DyyjgzCxarlMHpK7Acmx9ig+yP97Q34ySnqs6y3ce7d0pMJHaclHNoDSmmvfEm/qopRmgoWPizeRsN/Fpr0+gBzavgVjlgA9mYYqmtpWG7rkupQQTWMYvseAz9iC7wlr+j5y306o//hcKeWV9Y9MLELU51bT7DbOqYuIN4L/jR4ABAGYhiLzdvkt2AAAAAElFTkSuQmCC",this.options.images["LogIn.Orange.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mL8kGTHgAU4A3EZEAtD+R+AeBIQb0JXyIJFswUQd6KJCQBxHRCzA/FqZAkmLAaUM+AGMegC2AyQxmMAMyED2HEYCgM8hAz4CcW4wDdivHAHjwG3iDFgMx4DVhFjwDogPodFfBsQHyPGgH9AnAvEy4H4NxTPA+IGbE5CT0gqQJwJxL+A+DQQT4Ua+AOIW4FYGeq6RUD8DNkAViAuBOIwJMNccYSDEhD7AnEpyEtMUG90omkmBEDppQOIxZigptkxkA64gDgCZEAIA/nAngkacOQCeYAAAwApMyO16P/duAAAAABJRU5ErkJggg==",this.options.images["LogIn.Orange.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA8klEQVR42mL8kGTHAAXaQJwMxBpAzAHEN4F4ORAfYsADWKB0EhBnocmZQvFsIJ6JywAmILZB0wwyLBuJnwrEBvgMiMYi/h2NH4LPC+imz8OiTh6fC1gZKAAgA54Roe4hPgPmEmGAIxDr4TJgIxDvJ2AAOxBPAmJNbAaAQCkQtwHxezyG8ADxVCBWQRZkREqJMCAMNcgeiC2BWBDqBRgAyaXAwgWbAegAFEthQFyIJPYKasgzJiIC8DcQbwbif0hiYkA8C0QzERndn4C4FYivIolJAHExEwlpBhRbRUC8DknMhoXEhPcWiDug4QIK5AsAAQYATgEocUkayKoAAAAASUVORK5CYII=",this.options.images["LogIn.Purple.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPklEQVR42pSTMW7CQBBFF/f4Ar5AXNEguIAvkHSpSB+lS4GgRynonKR3RedcAKUPoqHyCXwBOID5g/5En0WOlJVG653deX9mdj3oui7oeBy9FpgmsIdwPSrYz+aw3qlz4AAEppjeGPzX2AIyvwIw+AOWi1qNg63A72EvMcQBC6ZsAbYxhC1hGazkXsY9O2vAFSB1guBM6rUDR9gnAwJVL98I2DK74KUmsIIOS7nBPJM0x8wgEHzxxwCv27vrwDIKODGLluvUAakrsBxbH+OD7I839DejpOeqTvKdR3t3CkyktlxUMyhNqOY98aY+aWkGaOiYejM520182+sT6J7NayBWOeCLWZiiqb1LQ3dcl1KCCTzHL7HgM/Ygu8Ja/o+ct9OqP/4XCnllfWPVCxC1GdW0+w2zqmLiDeC/4yzAAEgZiLwB6XohAAAAAElFTkSuQmCC",this.options.images["LogIn.Purple.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mKM0CtmwAKcgbgMiIWh/A9APAmIN6ErZMGi2QKIO9HEBIC4DojZgXg1sgQTFgPKGXCDGHQBbAZI4zGAmZAB7DgMhQEeQgb8hGJc4BsxXriDx4BbxBiwGY8Bq4gxYB0Qn8Mivg2IjxFjwD8gzgXi5UD8G4rnAXEDNiehJyQVIM4E4l9AfBqIp0IN/AHErUCsDHXdIiB+hmwAKxAXAnEYkmGuOMJBCYh9gbgU5CUmqDc60TQTAqD00gHEYkxQ0+wYSAdcQBwBMiCEgXxgzwQNOHKBPECAAQDD9yMeuC0a+AAAAABJRU5ErkJggg==",this.options.images["LogIn.Purple.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABAUlEQVR42mKM0CtmgAJtIE4GYg0g5gDim0C8HIgPMeABLFA6CYiz0ORMoXg2EM/EZQATENugaQYZlo3ETwViA3wGRGMR/47GD8HnBXTT52FRJ4/PBawMFACQAc+IUPcQnwFziTDAEYj1cBmwEYj3EzCAHYgnAbEmNgNAoBSI24D4PR5DeIB4KhCrYEtIILAOioWhBtkDsSUQC0K9AAJ8QDwdiFNg4cKsI26FLQ38B+IHQHwYiA8A8WeoYSDACTUQ5O3PTEQE4G8g3gzE/5DExIB4FojG5gJs4CcQvwJiEahmWJhIMJGQZkCxVQQNJxiwYSEx4b0F4g5o6gUF8gWAAAMAF3cqp11H0kQAAAAASUVORK5CYII=",this.options.images["LogIn.Teal.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPElEQVR42pSTMW7CQBBFF/f4Ar5A3CPSpfIFkguQnqRFiPQI0Zqk9wXMBVAKuqD0PoEvAAcwf9Cf6LPISFlptN7ZnfdnZteDruuCjqfNusA0hr2E61HBfvZvs4M6Bw5AYIppxeB7YwfI/ArA4E9YLmo1DrYCf4a9xxAHLJiyBdjGEPYBy2Al9zLu2VkDLgGpEwRnUq8dOMK+GBCoevlGwI7ZBS81gRV0WMoN5omkOWIGgeCLPwZ43d5dB5ZRwIlZtFynDkhdgeXY+hgfZH+8oX8ZJT1XdZLvPNp7UGAiteWimkFpTDXviTf1VUszQEPHozeTs93Et70+gf6yeQ3EKgdsmYUpmtpGGnrgupQSTGAav8SCz9iD7Apr+T9y3k6r/vhfKOSV9Y1lL0DUJlTT7jfMqoqJN4D/jrMAAwC4aoi8NxQfAAAAAABJRU5ErkJggg==",this.options.images["LogIn.Teal.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA20lEQVR42mK0ndzJgAU4A3EZEAtD+R+AeBIQb0JXyIJFswUQo5sqAMR1QMwOxKuRJZiwGFDOgBvEoAtgM0AajwHMhAxgx2EoDPAQMuAnFOMC34jxwh08BtwixoDNeAxYRYwB64D4HBbxbUB8jBgD/gFxLhAvB+LfUDwPiBuwOQk9IakAcSYQ/wLi00A8FWrgDyBuBWJlqOsWAfEzZANYgbgQiMOQDHPFEQ5KQOwLxKUgLzFBvdGJppkQAKWXDiAWY4KaZsdAOuAC4giQASEM5AN7JmjAkQvkAQIMAEkkI35zMI3OAAAAAElFTkSuQmCC",this.options.images["LogIn.Teal.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA+0lEQVR42mK0ndzJAAXaQJwMxBpAzAHEN4F4ORAfYsADWKB0EhBnocmZQvFsIJ6JywAmILZB0wwyLBuJnwrEBvgMiMYi/h2NH4LPC+imz8OiTh6fC1gZKAAgA54Roe4hPgPmEmGAIxDr4TJgIxDvJ2AAOxBPAmJNbAaAQCkQtwHxezyG8ADxVCBWwZaQQGAdFAtDDbIHYksgFoR6AQT4gHg6EKfAwoUJi01vgfgf1FsgV1UBcT+SvCDUEClcBqCD30C8GWooDIgB8SwQzSzv5UpMdP8E4ldALALVDAsTCSYS0gwotoqg4QQDNiwkJjxQ+HRAUy8okC8ABBgAbJEoNOBJwH8AAAAASUVORK5CYII=",this.options.images["LogIn.twitter.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAIAAADZrBkAAAAABGdBTUEAAK/INwWK6QAAAO5JREFUeNpi9DnxhYF0wMRAFkDR5irKssyYq1ubk5eFkVhtTIwMiXJsQA0aPEw6vEwk2Aa3hI2JgG0scNa//whRU0FmTmYUdSff/33/+z8WbcjAXpgFiJBF3MX+FV75TnJISnIwkhwBv/4xrHn2G7vfkEHPnZ8H3/4hNiThocLCREp0v/z5D8LQ52MmNgKA4NbXf5IcIIMcRVgEWRlf/ITa/uPv/00vfr/+hSMCgHLwcDfgR7FQj585/zKOCLj15d/8R7+wukqcnRFfSK57/hvoVD8JVmN+ZjaYmUBHLkA1DksEXPn0F4hokt8AAgwAiAVLPhHU2kYAAAAASUVORK5CYII=",this.options.images["LogIn.Violet.email.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABPUlEQVR42pSTMW7CQBBFF/fxBXyBuEfkAr5AUqRDRLSIHoUepTdJGcmio3AugNIHpfcJfAE4gPmD/qDPIkfKSqP1zu68PzO7HnRdF3Rsnj8LTCPYU7geFexnvJ3u1TlwAAJTTG8M/mvsAFlcARj8DstFrcbBVuCPsHkMccArU7YA27iDLWEZrORexj07a8AVIHWC4EzqtQMH2AcDAlXP3wjYMbvgpSawgg5LucE8kTSHzCAQfPbHAK/bu+vAMgo4MouW69QBqSuwHFsf4oPsjzf0klHSc1VH+c6jvXsFJlJbLqoZlEZU8554U1+0NAM0dDx4MznbTXzb6xPoL5vXQKxywBezMEVTW0tD91yXUoIJzOKXWPAZe5BdYS3/R87badUf/wuFvLK+seoFiNqEatr9hllVMfEG8N9xEmAAYCWIvGulQ6IAAAAASUVORK5CYII=",this.options.images["LogIn.Violet.login.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVR42mJcFDqXAQtwBuIyIBaG8j8A8SQg3oSukAWLZgsg7kQTEwDiOiBmB+LVyBJMWAwoZ8ANYtAFsBkgjccAZkIGsOMwFAZ4CBnwE4pxgW/EeOEOHgNuEWPAZjwGrCLGgHVAfA6L+DYgPkaMAf+AOBeIlwPxbyieB8QN2JyEnpBUgDgTiH8B8Wkgngo18AcQtwKxMtR1i4D4GbIBrEBcCMRhSIa54ggHJSD2BeJSkJeYoN7oRNNMCIDSSwcQizFBTbNjIB1wAXEEyIAQBvKBPRM04MgF8gABBgA4viO5kfd91wAAAABJRU5ErkJggg==",this.options.images["LogIn.Violet.password.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA+ElEQVR42mJcFDqXAQq0gTgZiDWAmAOIbwLxciA+xIAHsEDpJCDOQpMzheLZQDwTlwFMQGyDphlkWDYSPxWIDfAZEI1F/DsaPwSfF9BNn4dFnTw+F7AyUABABjwjQt1DfAbMJcIARyDWw2XARiDeT8AAdiCeBMSa2AwAgVIgbgPi93gM4QHiqUCsgi0hgcA6KBaGGmQPxJZALAj1AgjwAfF0IE6BhQsTFpveAvE/qLdArqoC4n4keUGoIVK4DEAHv4F4M9RQGBAD4lkgmonI6P4ExK1AfBVJTAKIi5lISDOg2CqChhMM2LCQmPBA4dMBTb2gQL4AEGAAL/4oZk0x3zYAAAAASUVORK5CYII=",this.options.images["LogoStimulsoftReports.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAFcAAAAVCAYAAAAzWHILAAADg0lEQVR42uxYQa7TQAxNq16gV0iPECQWLGmO0B4hXcMmkVgjNRtYJ0dIjpCwAwmk5gg/R2COUGY+z2AsT5p80n6QaslqGk08njdvPLYX7eevgZXE6tHqOvgprdXMamd1a7UJdHHjYjyf8dzifwqbG6u9+K6B3QX+0xz8e9/7Bs+5xye3hgrfOjEYK8en0PXAmIbZ4bK4hMvrVy/jlX0IrRYMTDfZjgHdMQB32IiYOX5JCjaeANsG15Mj1kRzRlA5JsGae4wncmVibGm1Vua5iAuBS0YILG7MMNZEjLFjpGdgckZfU0L433p8DeHDXllnBRx6sQZtvQYMDT59+faIi33+Y9ySAVoJxs4hPZxNBWvLK4JrwKJUYSyxzChsrPF+N5cjS9B7jx11AH/H71wg5wzUVGHG3HIAUO6Yn6w+AGx5pAPPUdfCzJnpdgq4tGsbaAYD1czsLWA3H7koaWMKcw+4dPb4thCgRJ5vtfcZbJG2U8BdM5b27Nac89LJcTJyD1CGxWe5WDMR3FAc9VgAV2O9ks0J3tdzLXoFownYxbOFdkZwe3ZcfVLiCBr4EeF/5gFw62H/iV1ohoHaCQJRdkBzpQOb/2RwS3aDyjx3TilHsDsQuWfmCSOJwjzKhQ+wkbBTkQmyZHh/Kc/9K1mcz+fgLteR5R2CO7j/paxuNdG7Dx9lnU6xsBT1/lH5nOKpVs+3SLmMyDKObD7eK5F9iyFbQzFzweaqWJbiLsTs/ds39erGm8nr9Aj5pywvO+Uy7RSwqUlTAMgDyyQa0VRK8O6Fkg3EomCo2LtYbFam+FLh3YFtWnhT5tKu2h39VfNbNidwvPX0MoKBbpzsFRwY+3swkI8/iXGaLSp2Ak9fovP0KjK+rn855q5ZubwVRYFvvBFpmpZP10r6Nlcv4+iIYjV8lphLR8Y6wOOiVhFFIhZquW4qwMxHlNO+EjsVz1Nz3Rgho8Dd8hgiLJO7W4MbMjaGnhjYijiobpIoPnJlg9oRfQNua4uNnlQ8ORCdvxZUqmzdBjX2/+bWYaG0zsQMvKf2L2KmuXJpJp6qrhywVbLTNCULCgGysVoipjsb0a2ZS7vdW6ey4HcL0igxVx5pM9J8DgY1DExqygwdeefPgyfMDJ2gyq6lZCclof7Ic15oBGrhiblco4lNopilSRVjaH/hYqKGztj5WrGZ5KuLueaHAAMA8ycyKxDeGCUAAAAASUVORK5CYII=",this.options.images["MessageError.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAACz0lEQVR42ryXTUvjUBiFzzVJY1PbIS4sfiDGfolt1VrpQlAKgharWBBRRBBRKqirwZ2Caxf+Af+CP0F3unQhVQQXdkqaKW60Mjjj1Dq+sxj86NjUtlYPZHHfcO95n3vCTcKICOXoam2NOFnGl9VVVtYCRFTypXV3U+boiLKJBKWCQSpnDb6cZo2DgzB4vQBjkCIRfApxsquLbg8O6FGZWIy+9/WVTF1VaqNSOAwxEHgaG9rbYZqYKBm4JGPN6yUpFAIThOcix8EYDCLV20sfZiyNjeXQPkpoa4NpaupjMk663XS7v096ysRipAUCVPGMpUgEYk+P7n3B5ULN9HRliVWXqyBtDrXPRxUjNo2PQ/T7n8a3e3uIM4ZEbS2y8fgztdOJmtnZyjxcSYeDpOFhMKPxqfZjexsA8JBO4+fOzlOdiSKMAwPQOjro3camyUmIPl9O7SGd1s/a4YB5YeF9xEmbjaRwGEySchdvbdWdw0QR0uAgNK+XyjaumZmB2NlZuHNZflXjFQWWxcXyiFVFyUsLAPwLYi6PMRNFGIeGClLrGpvn5mDweN7OKo8xAPDNzbAsLZVGrCoKSSMjeWn/N+N18maiCCkUgubxUNHG5vl5GNradLt9ub2cDjEAcI2NsCwvF0esNjeTaXRUl/YlcZUs6241ADCDAdLwMDS3m940NkejEOz2grmKfj+qZDnnNNOlrq+HZWWl8FmdaGigzPExVVrZZJJUp5N0z2pLNApBUVBpcVbr66xfdpE5OSmK4NfuLp0DpLa20t35eXHUmkaq3U6viNMbGyS0tBRFcL25CQDIxuM5L4mC1HV1udSPHdydnhad2SPxN1mm34eHRc+7T6VItdmIiP4ZX62v08PNDX20HrJZut7aeja+Ozujz9L9xQWpTidxX61WMvb3g/E8PkOsuhpMFMELNhv+XF6CcRzK/YEr8bMWfFMT/g4AfS4O58MBTL0AAAAASUVORK5CYII=",this.options.images["MessageInfo.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAACvUlEQVR42sSXX0hTcRTHv7/rHM65dDK5ODa1HpajcG4kJITJUiEGkRU99efVByuG9BY+DCp6UqGEegt7EHrwoUyIEu2hP6is+dKYuEpnuja6zm3O7jZ/PayWY3O7d8554L5czvl9fuece/5cQilFLgmEeTrpWIbLs45v3g0s+YJpOnU1CjSwh6DTVMFs0KJSLiXZziTZwPZFH309t4T3X1YRi29DqDAMQYuOxdkT9WjRsUQwmAv9pgNjdswt/MReRadRwtrdjLoaBckK9vhD9M7TD/AFIlkPNByuQq9FBwB4OO6C4+v6rrrS0hL0XTDi1DF1Es7sVAhGeNo/8jEnFAB6LTqoq2VQV8tgPdeYVZePxvHg+Rwcbj/NCB4Y+wwvtykohCUM2ZHT3Prb2xR3R2fw41eYpoCn5j30k3NNcO4evVoAF+LBhXgMvXAJsglvRXF/dDY1xzeGp6l7LYBiSN9FEyT/ykYMdLz/dNo7i21asP2zSWci1PZFn6gbW2zTSVCMKER77OU2E2CH25932CQ0mFI2gpsMAKz4QwXJXTQWFweO8LGCgAW0fWSs42IKAwDystL8T5BUJp58wA2s4mA8Pt6gOhiw2aApKlRaWpIAa1QVpFVfWzRwp1H7v1d7uU1qffIOgTCfV8sU2jplUgke3zSnLwKX703Q8FZ037y1dhvRYdSStDq2XT0JVlm+L9Ar5qPoMGrJrjtXhI/RkbdOTMx+Bx+N7xmorpbjeqc+ZfXJumUGIzydml/BjMsL5zIHMSlgGAK9VokuU33SS8HrbaaLuFc3MPxyHp5dBsu1M41ob9KAVZaTgvVqhUxKDEdUZLCnDe1NmWufVZbnhOY9JGRSCbl9yURunW8WNYMLNp26THVkqKcNGlVFccF//5nIYE8bOoxaUXaiPq5c8sa+TOVlErTqa3Pm+M8AZycIyqgTMDUAAAAASUVORK5CYII=",this.options.images["Notifications.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAArElEQVR42mL8//8/Ax5wFYhBCnRwKWAkYABMkhGXAiYc4pJAvBiJvwgqhsUKoAvQsBAQ3/+PCe4BsTC6emwG9P3HDfqIMeABHgMeEjKg6j9hUImsBz0QJRgIAwl8sWBEhAHGuNKBCBA/A2JWAgb8BmIpIH6D7oJ4IjQzQNUkoKeDQiD++J948BGqB27Asf+kA5AegnmBIGAhII9sOiMpmQkG1kMN2YBLAUCAAQAX1G79/xWGZAAAAABJRU5ErkJggg==",this.options.images["NotificationsBlack.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAAAsklEQVR42pSTyxHCMAxEHxnSAHAIbUBB0EKOUESKCAVAFakArnxKyDUXcbFnnBDJYmfW489qJdljRAQDD+CuHYpIGHRIoGpQKGdb4JKs27CnlDHGCngl2SOfwNrTQjMTHNl4DN6GwSdncDaCI0/WJVbkMdJMDXYOg732ChtgcLQwBO1PCwegdFRQAsdpBTXQO7JH9kCdvkL3R3Bk5/kLJkSEZU6TzBdzgiJjcA0mN03wHQBX64eVMGd4PAAAAABJRU5ErkJggg==",this.options.images["Products.DbsJs.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAfUlEQVR42uyWgQqAIAxEt+i/pS9fCAUSjTSV07rBcA6F53aKamaCtEXARgACDA1gh+da6fq5WuCdrjT/DRE21QavIQHgADryh8QyPVpI5sHZ36UCcbMmo1xiiAYUIcLtpgXdRPhUbkgLXgtprSj3GXu5+d8BAhDgHwC7AAMAXX48DzrGvLkAAAAASUVORK5CYII=",this.options.images["Products.DbsWeb.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAzElEQVR42mL8//8/w0ACJoYBBqMOGHXAoHbAfygmFpCqfmhFAS7fkSo+PBIhVdPGaDYcdcCAO4BxMDdI/iPht0AsBMTKUCwEFcOmFplfTygbsuALHST2CSBWBWJzJP4dPOph/P9YxIl2ADIAWaYCxG5QA0G+v02NKCDWASDLNIFYCcrXxBIC6L4F8RuolQtAllkB8WkgPgll3yYiCqjmAJBlWkC8H4gP4AgBmkYByDJRqOUgIIYlBP6jhQSI3ziky4FRB4w6YGQ4ACDAAIdtPFjzscztAAAAAElFTkSuQmCC",this.options.images["Products.DbsWin.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAA5klEQVR42mL8//8/w0ACJoYBBqMOGHXAoHbAfygmFpCqfmhFAS7fkSo+PBIhVdPGaDYcdcCAO4BxMDdI/iPht0AsBMTKUCwEFUNWC6O9cZhBsgMYkfBtIFaFGg7CKkB8B4e+yUDMgcUcitLAHailbkDsDnXMbRxqrwFxObFRwEKkOpBlmkCsBOVr4gmBXCA+B8SLqJkLQJZZAfFpID4JZeMKgftAPBEaFVRzAMgyLSDeD8QHCIQACHRA1RNRUwCzIRFYCIj/ArECFP+FisHk/6PRIOyNxseKGUc7JqMOGHXAQDsAIMAAuyScCQbYy+QAAAAASUVORK5CYII=",this.options.images["Products.Flex.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABM0lEQVR42uxW7RGCMAy1yAKswAqsgCO4go6AI+gIzuAIOAIrwAiygBBfuOj16hXK8fWnuXuXkpbmkSah6t20uy0lFE0b+Veh/rCy8+6jg93G4gl4AqFtYh+4FUXT0jIEHPuDWiwCa/UHn4STCSBZI4ZlLrbNzRmBE1DCUWI47+xA2ptg8jsmM9mkDGkoCbkMsbbAsMb48I0KFNuesJ17Kky5RIAs0IWdJPLVLJnoy+DuHAGARP9ARAwSbYW2/gqUQAq8gKO5p4HO5yxHYISd9aMn9KOPwLUl11CVEKhW7wOIAJ87V8KNc4BL0OnFOXIAOpZzz+S5AHKXHJiLQK47xDjRCS1KgJ2Is8R4/y72eEoVuEikJeFfK4a96qsCK4GVruXK/449gXDEBXRRAmqrCHwEGACJxeVDYoutDwAAAABJRU5ErkJggg==",this.options.images["Products.Java.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADN0lEQVR42sTXWUhUURzHca9bUGpmlhnqQ6ugWEahlZQoWD1ZGAitUG/RqtSDFSEtBJEQZPQQPVT4UhAERZtFlBVYRi5hRQRq5ZKlRoahM31P/YSbzNjcccwLH2bm3rnn/Oec//2fM5bb7Q4ayyM4wO1FY42TG6wAj0AoXmHOWI3AekxwdIcZgQDJQBe2O7kvEB2Howg/cNzp/SPpeDx2oRkdWOdPO/50HI39aMdPlCPGdn0q8lGITEwJVAChKEY3elGGRF1Lw2FUahpSAj0C8ah2/znqkKzzy/AQX7BP0zIqU1Cvzp8jUuf2wqUcmO5vLvlaB6L0ehHf9P6AKWRoxafRLsWb0YsltnOP9boQFYj1JwBfSnEEcpCPtfiOMERinO17/XiqwKpw3zZafo3AJJRreLfiNTbgKs7purm/GANaB96iU9//iDOI8bcU1+AoIjxcS0KO7XMDbmKi7Zy574jacZaEAy53GNJNfPp1Q48m3EMIsjQKK9Ftb0ZtpSNmuOXTYwxwKbHMkN7BI9Sr8zbNbx+qlQ8pSEIqliIPFywrqD3YsswS/RV3scOnJCRq0/HskGDLJFe2fmmqOomzJWGfgmlTcPW2JOyhnUYCOEgg5glahWRfRsAcjebLNGCy+pr4dBD0XzWEalUVYlltqhs+PwWVyB3J7oTgo7RBadWUznASwGWUeorawbEcDxiRWCXqAl8CmKthrOPlOvaYIXXCdmxh/mt4vaSELhmuDsShQgvMbnOuf8A1C10ocLrIcE+Jy/V7o/IGpzEfYbqeN3Q1TEALDsEa0lAuerDTQeeleI8ED9dXYwAbzefBx7AMn3HMSzKZR+esHrsreKKy26ViNRkzsQIFeIEipqPDS24sVkmfNvgY9mrR8fZYmUcym0AytSCdMDVCf0QsFat3uIVCvt/wj+SMU59B9n1eLU7qfdAo2qYddJ59LTBDmaGq9gGntASHB+gPi5nCIlVJ89dtEW57K8VmWDdp/c/S+v4SZlhb0Kyya0p0j9aNKC1MJhfiVa7NFKVpw2L2EDdwXu34vCGJUAPztNgkIFFzGGrreDCQTu0fmpSktXimoP/Ln1PHxy8BBgCXnf8wCrH/JgAAAABJRU5ErkJggg==",this.options.images["Products.Js.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACJklEQVR42sSXzUoDMRSFOyL+glDRtuJGBgQX7salgkIFFbe+gj6CPoI+gj5C3RZ10YWCS927cXChtrVqQUGqCPUEz0BIk/lJO/TCh07SJGdu7r3JOO12O9NPG1SeW2A45TW/wHjwMKB01sAccFJiHjzLC6oCXkAuxbefBo0wAXWQT1FAgV7um4BID9SoMi2bAdUwAQ2qDLMd4GnaXba7IWNzjLOuPHAIdpW2ErgHN/y7bxib5zYb64BNFpT45nt8zibxgCqgyn2Kax63ZAnc9iILXsFUQgF+zMW1W6ATMAGGYk7YZNC5MX47wnk/wgTEzYTAKhSxa/P2JgFJaoFY/IBRX4oIwNgCknhA2AkzoMg0dOMGoElA0kwIRKzzf5OIjjJsEmB7It5ShNiW42480M2B5DMmPE08dBShbgT4EZ7IagR0HEQ2AoKJ/Yji1CSyTbHOhN4JTQKCoNqX8j/D/Bel+IiiXB5WpxoBWg9kxK1YIQfqSttx+9/eQVFq99gmW0kzp+ANTKrtjuZaLrblG4yCX8mtHt/c12xLUdqaisarogR/am/cBrVVUDD02TALHnV9A4ZA6vXVTFsDTFlgU46tDiJTFgh7YkFZBOfgznLhBbANNsGD7geO4dtQBM2yNFic5WWKueTnlc7GwKo0riWNuwY/cQWoNidNKha4Amfggv0b7F+hwGDRh6iJHYuvY+GNNbDFhTMUUqawVpLJnH5/nv8JMAAHTU3kVfhdvAAAAABJRU5ErkJggg==",this.options.images["Products.Net.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABQ0lEQVR42uzWP0vDQBjH8UQFF5cMXR2C4CoUnepWXEQ3RcQ5U/e+hbwFO7p26Cw4GQcHB99A/LNIwaKDWCkO5/fKEziOJAZEb/Ae+FB6vV5/Se9JEiqlApe1EDguH8AH8AH+OsAiWi4DnGHLZYBje2DJwd++gRluMQn0vaCErh6u8IkJRlivmH+qmtcbXrAzvw/VBBgjwSb2cI0nrBjzItwgRyqKMP2KdXfNsboAJ9ZYCzN0jbFUjia25iayRvxdgLpN+GC9f8YYy8bYAYa4s+YO8Cqf/+p1IEICVSIStfXTLtBHeYFDV1dCffq7iK3xNtImCxRnIJPX7QbfWZMf0HWOfVxihHcZTyScXR84kv11j2mxGzPpeXO3dkq647FBn+cVLagNjHnzbggdPJSuypnXHTUN/VOxD+AD+AD/PsCXAAMA3WLa1xOc/OMAAAAASUVORK5CYII=",this.options.images["Products.NetCore.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAAHMAAABzCAYAAACrQz3mAAADyklEQVR42uyc25GbMBRA2Z1tgBZICbRASuAzv7gEuwS7BLuEuARTgilh+c2fKYGFiciwBOsBMg9xzozGs2uDhQ66ugiZt7IsPXCDd5oAmYBMQCYgE5mATEAmIBOQiUxAJiATkAnIRCYgE5AJyEQmIBOQCcgEZCITkAnIBGQCMpEJyARkAjKRCcgEZML/nKtSdooRbzygYjE8quJ3/dAz10fcI5Iwu1IixkxkInNhhFUJkOnOeGmFj4UcUCBCjd8JOVlVCvGaThjywp7wl4n//6lKbum76uP9Za3m9aWJ5dLH/clnE/GeLueqBC+ocyD2/SjXx745jqnCbNjz911cKIcG+0mq8lmVvcWecRT7TGxcHmxlBihqibwZSuxyFCfC2BPsZvHEmJ0px8xQjH83Sz0gEePYZYRI33OIqXvm2XIDHgfsz39BPTbXM2UXxpkoeavnRBoN7oseejKoh844fRHZc97KYpuMO1Fsu5NEi2Pnu31FXXQy+GLqbFaWicmy00Qjw/w0qFuk2FedWYeKfYSKOtXv+ZbqY9T2c8l8aDSabuOVBpcrN8VJ4VuqUzKHzLlmgHYifOmQaYRRnbnNUPG53beQNa5OyRyNOofMehy4Gm5z1Rg7dbJfWZ1MZ5hOEvnW5luXLnPIpUSu6Mk6MmPLdVKdZJHrMosBvbId2nRnmPre90f0fNlJNuYEW7XMbMS2Yya3x6b/Q47H+Z6ZevPga12nMWmwCiKNqT3bJ4nzMrMFig7myDxdyWYBmS8Ls8gEEqC5yCXjYu7ZW9Mza36AzL+zPycXDpIw69BN6q3IHDMViMyFUSDTHVJFmI2Qua4wK+udMTLXhew2V+JCuH3vCTn16rX6V7yleD17bsxdqm5Az7H8UnUtGg+VWR9Id5l+s5Tx7oBQ1Y+PbCyMrsfe3wZjsOr2WzJU5l5yIL7nxjL+g+L9sHVCmwhsfq9yGzD+pop9qyLGv+Hho7OhqsvvHOidB9H4suz2LD6TPgmFzW0zG1lwqthPItq+HvPbi8QD8Vpv/7MrU5UALHmmJPIGPGpF43jjCTLdq+Lkag93ZLMLJ/eGrw58KlO1Pqeg3V86lmdTyrzS5lrZ6RAxhRj3MlsyL5Kd5RqZ4JYFXkVy+MOTr3TXEXow2D5vd8Lu49aaS5BYZEvNhw/etsJs+yEV7QVf7WnB5qZ2NkEdok70bL732011np3nEGSzyARkAjIBmcgEZAIyAZmATGQCMgGZgExAJjIBmYBMQCYyAZmATEAmIBOZgExAJiATkIlMQCYgE5C5Wb4EGACzZUSmcCb+jwAAAABJRU5ErkJggg==",this.options.images["Products.Php.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACm0lEQVR42uyXT0hUQRjA99mCFYJhISEqKKSlCBUJkoSHFiGhqOhQULcwrIMWQXTpEoGe2kpct3MUWNCpDtUhKDHqYERFFltUFBH+KQhNa91+n31vmR5v3752N97BBn58s9/MfPPNfN/M7LNSqVQoyFIUCriEk/OLfAeCD8GSIisvA/mGMPwXE21CdMEuGIUYbIQaKIMv8BxuwQPw5ZnlPIZMVIXogGpYpepiaIPTcB02wDEYhjcwCSugAdqhBXrgQjZH/nCAyaOI3XAT3sG4Ns3CEOGa8blbaxGnYC+cdDSvhoju4EDaAQbtQRyEHUw0V4gEw2YrYrtD/QnuwBVoMnNA4nvG5+QnoFd20KsTtoZxYkxWaqjLNFzX0seQTksRm+G+i524xtEmbrQlVDdk1G061QkJYz1cVR5pe2zBgoTgZ3K+BUak7kI89bvUQqfWzxu6Xq0nFHvMpG0D21HohpAT+yJaD49zCPNrmPLR7z1Ued0DkrUvshhJqLwIHzL0qTWO3SFDXwlvXUfoFt2AjiwhCGVBtv+2Wxu2n0KjWwjsDmNQ5xhUDWEfE3ti55fb5GYOVMBH4/zKDXZPszvfcjSd8R45UMJx+aaTRzQnJJ4/+F1O2+c8HKjQZPX9HO+HS0yaRN6Fxn/6HLvo5NIY1Po0LM9wzUqYRjR0y2ArTh8vhANfodTH2AN6rcoWyyO1DXJ2YIIVrWQFE/q81qheYl/uMf6wOizlOzaKsTGby18yydIoBpqQa+CVoT+Lvs/tKXe89dJ3lL790AwNsA9dHbzM6IFxXrvgiUjHOS6FOdgJJVAPA4K2m6yDI/AQnsFl2JLpDhAsPx8mrKRdn+uIXsMxtvpcIf4TWgvX4f/vggCLteg/TgN34JcAAwAgL1hM3p2f9QAAAABJRU5ErkJggg==",this.options.images["Products.Server.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACAklEQVR42uzXUUhTURjA8a1kA5FZmxODfBCDbAt8E5KgmY8FPhoUPQWCExaRPQQ9BPogezH22EuBEL5E4B4jSxmK9FCkJZgQCgXTUQ0266Hd/he+5HY999wrQyS6B35wdu45d9+++52zLWgYRuAw25HAITc/AD+AfzqAY7iLJVRQxSpy6DroAHrxAU1II44YBrCGNxj2dCfzINqnBMq4pplzFjVcd7uf1wxEMSWpfiuffkczf1myNCmZqSsDDVgw1G3EZe0E7ujmeAnghqFvVzRre1GoN4B5lwC+ocVhbQTf662Bqsv1ZtxyuFZGxGsNtOIBPqGCRdxGI1Iy7tRKOKr4hGH8kP5nzMrOCNozcAKv8RUXZF9n0CZ7egvnUdTskpRivNGWwfvox1OErBl4jHsOzymNL+jAgCYL44q1SSxLfwPt0p/ETWsRbiOmKZZRPJP+nEMALxXrLmNG+maxNlsOqnfWR2AeFiVNqWTlMfXgkcOcTsVYEisISzGWZfwjTlm/C9Zx2qXapzGIvMP1uGLMrKdXSEgt/fkBelzqbTeAnBRdVBPAAs5pCrHB9jokBVfARbywXMtIIf61DcfwC0M4qXiecRSlr2o123zzhHwiR/l7nMFV5PFcDqk9J2E3HmLT4U1+agJQtT5kpQBXMYVL1nMg6P8v8APwA/jvA/gtwABT//Sd2InooAAAAABJRU5ErkJggg==",this.options.images["Products.Silverlight.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADtElEQVR42sTXWWxNQRzH8d5SS4oS1L5TpJYHlNhpELQRgiae6kGQkqCJtbbwQEgQgvDgyRKiSGMNsUW0agliS5FUo3a19kFofUd+t5lMzrnObTQm+eScO3fumTmz/m/o56+KmP+ZakdRthaGYLiu3dFOzyhHCR7jGnLxLMhDYwOUaY0NeIl1qIttSEV9hNAck7BP90W4hJF/fboZAh/1sA7lyEGLCGVdIUzHRRxBM7+yfj3QDdcRr25ejzeIs970PsrwQ99dwGI0QyUOYxQe4Qa6Bu2BZLzCQic/A89xHJnohcaIQyJGYyPKVNb+7SKUoI1bn1t5cxXMsvLicRCHMCJA95syFRjv5K/AVdSK1IBTWGt9TkA+NkUx/kY6bnnkb0e2nRey9oGJmIs0fa6D0xq/ZVEu73jNiwZOfhfcQkd8cpfhcuyyPq/VRFtWjf1lGh545Ju9YSfmuZMwCU+srhmMnxqCoN1eB/2wCu+R4lOuM55pqVbthOnI073ZWLYjE0kYiF5oixZoojIx1lDFi+mxkyr/2qd3nuMj+uFmuAEpOKr7qeoqs9bvoEDXPI1rmdZ5OJl94LvGtDLgEJ3DWLsBfbBa9yO0qZgJ+aGGziAzsWfak7CN9voYTRDTGyvUXRX6bre6/1+kp+GdMdyAhviqe3OYFOKbDhxzCg5Qb5zXmEebzPJbgP14iHy0/zPhtA9UWhNrhypb7fGgPWrc3oAVZ2go22oOFWo+legFqxrwWYfOF3W3eeNSjwdOQJY2rUhpnCo2vbURV/wmaHgSlurc/6Jrqc+DzeaS/JfKs5GjZXwiaEByF311b3ojwaf8O80Rv7QUc9DfqTxRwUkH99mx1rJI0b1ZglN8KihXr3lNxEwNT6oVjnVWFDUIl1GsF6xK4TlgApAnmvH9FYyYH7/wqMhsRr3x1sproN1tqF4mTr3RGKu0UUUcgiJVmqaZmqMHNPX4zSc92E6m/FZV3hKnNNuzI1XuRkTjFQ+EP5t48ACGOYdJgXPQmHjvHRqhB+5hYNBDzD6OT+u60rrmyRKrXJmzI87RLpmoN8/S+REsOS1qpZBsrpXXAWeQizHYjdlW9GvCryF44YRygXhl9sYbN3TCZDxUbLhZeaarC1GkuDEmWl5huTnTB2MGtqhrTTqmc/6YNTnHWsMxq1rHUoTW1cUa/TExUU5rjzJ3UYnU6ry9G5T6JbOs5mujKda+fk2bzW2c1Z+VaqVQFP+OYxWehf+cmiO2JzqpYTXegBpJvwUYAE8gOcZJwROoAAAAAElFTkSuQmCC",this.options.images["Products.Ultimate.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACB0lEQVR42uyXOy8EURTHZ5ZQEBJaIRGCRqPwiChE1qKhkXjUEgURjcoHEIl2qVSikVjZeDcKz0Kh1ElUXh+A4PoduZOM2bVzxw4b4SS/3E3mzL3/e+6Zc8/azy+vVi4t8gNrFEEHzMAG3MAhjMhD+xsiUA3N0AptUA/ncALHcAq1MAftjoBRGIdKSEICDuApwML9eo4aOHMteJEXsZ+9zi+vSkkALBEAR9AGFTAOu/AIqzAIJdovE/JOVDGvCfgqec+JgEKl7VFYytADAxDTu5HIrMFDmgikzJHJvBFQPmoLIAaLcA+TaSKgTHdvFIEMyiWp1qEhjAgEFvAhfCEIiFg5toih2m5IiGqt/H3HHiznOSShN8xKKN/3soTYFWbbg+V6vqTf8TWjHGA34pSHjzLNAfHxmTNQDtjO4r/xMvoX8HcEPJDZ5bkUEJceAhFTUJMLAbMwBFWwrb/1BeiCgmwLUUqRSVOIUvoDmAYpyS2wp4VtgRzVCjR+twDHpxiiusHp1Q2NHFk8sAB+lzBcQ2kAAZ9afoD7u4yhE8a0+lAsP8OCkqBNuh8Uu9Wd0Dzshy3gkAXbGS9dZyXjFexon0LRFXYhcnJgWN/fda5slfHO7zzJDaPE9RNgfTWhshVgWog2oS9AwvY4xSgsAXF9RN4+ULn6QOXqGSdMv5Ss/5x+dgSm9ibAAKJ43DFXJqXnAAAAAElFTkSuQmCC",this.options.images["Products.Uwp.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACjklEQVR42sTXb2jNURzH8ftbY4yx5g5pbpEnzJ/SJIRp9kBKxGLNA/9KrOWBFMqDUVOa5s8i+U8eoj0YLQ/EPJPaH5Sarkv+ZIZotGa73qc+t37p+v3OtrN26tXv/u45v3u+955zvudcL5lMRkayZAyg7To0IIHPeIZq5A4lgEyLNtm4hixcRgt+Yzo24RXK8HhQEZghCODhNmqRiZ24i/s4iii2oBtzQz4rrbAhWA8Ph9GEJbiO06pvRysO4MJgfgAvZBKaTk9iqcb6LPbgJ85jM7ahSIFUKChnAfzCJLxACSrxETlm9DQJ29TxLrzGGVerYBz6NeFmII48fMUV7FC7t4ihS8E6W4bdvkDiCuILouo0oo5jus9Hp+s80Ixi3MA+fMA0X91yzMdzrMJD1wHUa9LVoBDvtP5NeYBSdVqmyfjSdR4wbqFOeaAIT/X+ZLSgGHG934985NnmAZtGWbiKR8jBDyUoU7df1xJdq1XfhSpXARgxfVPzOqF783qxL0hznYKVmI0ejHYRwDF12oe9uIc1qhsV8NxNbB1qKo5oEi7EAuzWRJujut6A5xqx1sV2bFLuRS211djoCyCodGCWiwCOoACLlGhMPphg8dwnTHWxDI3taPBt0eUWz0zE97B2nuWRzGzJfZinjcnTZhRUxuAbxro4kpnOqnDQdx9WzAmqx9UQRJQJezFzALkj4WIZpsofHNKhxLMctqSLVeAvtXijQMLKe23lUVdDkFKgTafSMovWudgL/lWIc6hBRshG1qaTs9MAjFzUo1Fr/n/tVmgndR5AynE0IztN3QZ0Dtcv4Gf+uDT5tt/xuIQ7KB2OOZDOKXW4DB044fJAYqsCT3S1esYb6b/nfwUYAIEyyaaCTx6BAAAAAElFTkSuQmCC",this.options.images["Products.Web.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACUklEQVR42uyXwU7bQBCG7dIDoqDKyRvkUBWuOaNQZMGxvYSoD1DzApVy4JgIgpTeAzxByAXUU6GqqvTSg3ttEFJ4A1whpNxa86/4V5qsbMcG03BgpU/yrmdmd2fGu2M7DENrmu2ZNeU29QU8zyj/CrwDa2AJFDl+CX6DE3AEzvP2QAX0wWdOugPKYIGUOVakTJ86k5tKwgRmQQf8A7UJspIadTq0ESub5IEC+AZGYAZ0M4SqS50RbRSyemAO/ATNDLuOo0lbc1Hv7Zhz4ABcgY85JXsbvAQf0nigwvjZ99x5HZzy2abNSpocaIL3am05fu4hbTbTnAPLD3TmdKMSWXvAAwFw2D8ELfbVuMvxOhgKuRZ3p9mLmNijjpapx+VAADw+u6LvCxmfsVXPh4yxw77Dvi9yIGC/ZNjVNqy4pFEMiRYuh7fNEYaikk/pVMUCHOO9J8dlEvbo6hL7X/ncE67cB3949DqG+zUlYeMX5S1jHoc2xhZwwZdV9l2OuVSoisVo43YMu+m/j3H3aNe6wpV+RC64DIdr6KtYt0RIhxEhGgtBXAxlopi5YIkkHDI39OS+sYDASFQvKQllMoZCKS6ZpKxudePdniETmBuxH2NN+APUHmCuDdr+b5eRRF9GK2mvY3WkXud8HavSbTNrQdLIYfeNpIIkSbFIxU93DIfSadNG8S41oSq134AX4G/GxNygzjxYpa3IlvYzVCX2NovLY/AFDIRhVY4vgnXwllf4Fvg+yXDWc+A1J1jnhPLHZMCFqQWepTVoP/2cTnsBNwIMADUAx2g800puAAAAAElFTkSuQmCC",this.options.images["Products.Wpf.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABXElEQVR42uxWwXGDMBA8Z9yAvnmSEmiBlEBKoAVSQvLL15QQSjAlhBJMCVYJ+JisPOfzIfALP6SZHZvTStq7WzTsxnGkLccLbTySgCQgCUgCnkZAxZju5EzNH424Y5wZP5izUIFbRji1VQF5UM4oDNEVRPR4/mDsBL4ZB3DCfm+KE3hXAX7mIG8Im+Id4xXPg1rX4rdAEt7g3LVAC3A4qFHxAmIacEhUQq6VFR0eMWEmsiQhwKmqtMiuN/YMWXf430VdOH0PMPLxf1QMxzgzfjF3QjwDp0ZccgJqwQl7WuO6bm+0oETGuvyl6LEDgstJ+OETBgv891gV9kb/SpS2MzzR4pBCvAHtzN7ZjEdMDwzKuY3KSpov9JkWDBa84Nd4gER/TqqvRyP+hRhF8Ie1Mc7NW+CV8/VoVHb9wi27hnMnwBsCBiOeryg/LZZ/uhLTZ3kSkAQkAVsLuAgwAKP5KBJcD+pgAAAAAElFTkSuQmCC",this.options.images["Update.BigSettings.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACLUlEQVRYR8VX0VXDMAy8dAHYADoBMAGMABPQTkAnaC4TUCYAJgAmgE5AmYCyASxQ847n8hLHjhz6SvVePtrY1lk6nZQCO7Zix/7RGwDJ/cFgcBQDvlqt3kh+9rnUXwCcA3hIOLkg+bhtAARQJpxUJPU+23pHoCzLWVEUV1sHQPIMwKKeU+UfwDOA4wQArT+pv1tzZjqdzmN7ohHwYVSYRag7ADcAlHv9JxBdtgQwFnhFyjk38XvGJHVWw1oA/C3fMxxZeRb4Olj9HoZVEgMglJfW6X983yJpAwBJ5fY18/APAAq37BDAQeY+RWG9rylEJF8AnBoHfQEYhfVOUhxR9PaM/fckR+s1YQSs8Mv5YUrtPH90uyQI59xTVVUC+2MxDoi114lbmErnI5FSym4OrJ0muPBBUrk2zec45MQJyYVZhjUQLlg89+KUA6DFJZJRzUlKMcndAfA3leTWbUlyaF4fwEYpqMlwzNdGJCyKYlKWpWT918IyFEmiw4bfEZXTgLyKXLJfOOduqqpSpbXL0DcLS4YFQo2lMXj48ru1ekinDvgyUyPKMQlOXYqzShRAoxxjQtQ18eQA61rTkGEtTLXjUE4lwZbGh47DPVEZTw0kahbKpzbN/KNOqV5hdT11Se0XoUU2PQIfnRe7hOjMd8fGzbycpipFY3lrXJOuxM6KpsBK8r8NpSkghlBtfyw32q2plNndsCMCUrmusXy7n2YWR/q+7/1l1NeBtf4bLvD1IdIsYTsAAAAASUVORK5CYII=",this.options.images["Update.CircleCheckGreen.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAABWzo5XAAABmUlEQVR42mJk6LFhoAZgwiGuBcR9QHwdiH9A8TWomBY2DYxoLmKDKs7EY8k/IJ4NxIVA/B0myIJmyFYgdiHCF+lArArEnkD8C91r/UQYggycoK5HCSNtqC2kggyoXrhBKUDMTFAbCzvDxcQlDLsjp8NEmKF64QZ5EGN9kVUqg56QPIManwSysAeyQUoETZHSZeg0CWX48/8fg/zmOmQZJazpCOTse6lrGRiElVG95F7OwMLIxFB+ZjUDw7PLyFpQYu0eTFSck49BkU+M4Wv0TAZFHV8UL11+94ih79hsdLsfQgLLTQ5EqwCxBYgx/co2BiEeCQYbCXWGfBVrBm1JbYZcLVdgKvzPILWxioHh4zN0g5YD8Q6Yi+YC8V8w6/cPhvwdzQxKO7sYvv3+yRCqaI7LSwxQPXOQvXYFiGciq7h/ZTMD97IMhvufX+HyEgNUzxX0vEZsFoGBfbiyCEjAG4inQjMmA55MC3KJD8wQ5MBG9vM2IF4LCi0gFgRifmgxchsasGlAPA+I/6Akehy2XgXiAlIyHUCAAQDb6W4SCFDxZwAAAABJRU5ErkJggg==",this.options.images["Update.Products.Flex.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAAA8klEQVR42mJkCJvHQCXAxEA9QE2zWOCsP8sTyDQicgG6WciixANkFwz+8EIG/1cmInMZw+eTbxbx+gc6fRnLCmBlk2xWvLn80Q5/XQleIBtIAtlAERLMAgY/BAHZC08+vPrg7c56LyB7R4MXkA0UIT/sjVt2fJ4RcX9SCD8Hq3TLDsrC/vuf6VuuyoryTNt6FcimzCxOlkwf7cevv2R5awPZFJl1tsbj87ffinlrPv74DWRTFI/aCsLujduAbI+GbUA21nhkISbggbF2pWLj5RefgWwgaV2x8ezjDxT4EUkzVoNoWU6QXbRCQ2YE1EMAAQYAPadex120dAMAAAAASUVORK5CYII=",this.options.images["Update.Products.Java.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAAC1klEQVR42mJkCJvHQCXAxEA9QIJZaTZKVDKLhSnNQ5OAEqIMYmValmy5+/wTytzFypTnqHqjw//mk4+Vay+S6y5WpioXjUxfnbM3XwV27b7+/nuwgbQAJ+v1F59Ovf7y58svYs2yVBBclO/48etPn5YdyqI8fbHmLz58m7H7+toLH0h215Zqj2dvv5o0bp8XZ5bgqulWt2XPrddkpoltpx++//qT4fc/DxN5RkYGRVEeYmKIEUu6Z2QI1pUqDdaXEOLm5WAV5OUAGvf33/83H78/fPX58v23W88+Xn/5GcN/IszaW+nGxsq48+yTF++//fz7b//t13uqgCLMjs07dcS4DRVF3I1lfv3+79y+i7AfpUW4geT//wxPP3w7cOfNt7//5uy8blW/jeHfv39gcRUpAXUZgY4QA8Jhv/nUg2PXX/qYyPpbyMuJ8QrysAMd1Rpv/v7rr0cvP11+8PbyvbfuUw+uTbIibJaqBH/p2ovrLz3DGsDcPOwr0qz+//nPxsZMyI+sTMzMTH6a4rgiK0pf6uuP35uybE/efInbLGZGYHa50x0gIciZ76PDyM2GaZAYP2e0g5qaFD8wHOx1pIpd1YG6EAYwaPtDWBMjjfQUhKuWna5Ze1GQnaUpQO/52y/33nyFK/XQFOuNMVt+6Hb6wlPnHn948OJjiIWijYrI9svP0dPEo6mhyqUbf3+DZrQgfak0N00WZqY3n34w/v8vzM/55++/qduvbr7yAuFOLtaX/cHi6SvQzZoYZSQtxDNpx9VDd94Sk8rtVITzPLSfvf+at/QsRlplZsx3UM3y1v7/7/+ei08u3H179dmH+x9+vAC69NdfBjZmMU42RQF2XWlBA2VhF30ZRibGaVuvTjxwm+HvfxzpnpnRVl7QQ19GT1FYRYpfhI+Th4uVg5X5x++/X7//evPp5+2nHy7df7vj4pPDD9/DTcGdH4dYPUQQAAQYAF8JJf0QFgnGAAAAAElFTkSuQmCC",this.options.images["Update.Products.Js.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAACYklEQVR42mJkCJvHQCXAxEA9QE2zWJA5XxfGcHGwEq/5x88/nHGLsZv18uP3wMpNF599IsYgHSnezRXuOP345sN3KQFOIh0lxcf59tN33GZ9/CHBj2JWX6A2nJ1rKVvnqoIwS4Dz9YcfOMPrxYdvkgJcyCJp/gZnbr9aduX1pRZPJRkhoIiVtpTHhENAhrgA16sP33Ca9fbzT2F+dkzvAF3Hw8XOk7AUyI7SEYUIiglwvPr0A6cfn79DdxcE8HOz3nr0DsIGuhHCEOfnevn+G06zXn38LsKPJewfvvyiJieEJijCx/Eaj7uefvgmhi0em3bf+fLt572+ABd5PriguCDX4/dfcZr1+MN3UX7saUKvZvvZG8+XVnrAjRPm53j24SdOs+58/AF0Oa4EFTrr5JYjt/pSrSFcoK03PuAOL4Zff7/9/MPLy47LuL0XnkJSBgsP2+9ff4Hq8eXtt59/qPBDnQbxDjDigAxVAZCgiiT/q3egMNIW4HiDGvDo6QuUXN9/kxfkOv/kIzCkxYS4V+65ChT0MpIFJlqIgsqZoIQqJ8D1EtWDWMx69+mnKDjI+lefFeRhB8YgkF20/iow9Zuoik3ff/c2ON+I8XO+/UjIXcDkJyEISq6Tjz9GFgf6FJ5KgQCYpF9guAs9vIDJz1JdvMhFXVGYG2vwA8WBslYa4q8xwosRvbznYk3Ul3bVl3Y0kPny/ff+i092Xni68c5rfxVRdwNpez1pPi62/Ree7L74dP7FpwzffuM1CwkYy/L76Ms6GUgbKomcv/dm34Wn2y89OfXoAy71jCOgHgIIMABBxOk6+i8sBAAAAABJRU5ErkJggg==",this.options.images["Update.Products.Net.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAABFUlEQVR42mJhCJvHQCXAxEA9MGrWUDSrJ9yQamYVBxmgibCg8f+vTDx544WRitj7Lz/n7bpeufYiUDDXUrYm3lJMkBtTMZBkDJ+P010L991SyFkd0bMn3kXDUkHQRZ5vUoHLliO3gHryJuz5+v1X/4pTEP1AEm4QdrNmnHn87P23/bffPHn9WYCLLd1d8/LtF8lLLgClJh9/vHLP1QBbVay+ZiEYLlKivLqqEhDvQMCr91/JNOvZ68/3n75XKtpAbJo41eQFRJjSfBysyw/dVZQWXJJgzMDGHKUj+nJGWF+gNtZkgXAXIyMjplkryl0hjGhPPSACMuZtPl+0/iqQ0bvuIjBZABE8+BlHy69Rs4aIWQABBgC2B2LY/xHe7wAAAABJRU5ErkJggg==",this.options.images["Update.Products.Php.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAACGklEQVR42mJkCJvHQCXAxEA9MGoWaYAFuzAXKzcTU5mzWpyL+oMXn1+8/6okwQcUvvrw3ZLDd/fdeo1VEyNymrBXFUl30fA2k///n+Hvv3/bTj1s3XBZS5JXWpD75ouPQAUG8sJhtkrvv/xafugOI1ARA4OGrGDvrhsvPnxHNYuR4ffShOLZRyedeMDw/Tcev4QbyUTZqTAwMgLZN59+AFKlq86jhJeLquiFe68n7b+N3yAgWHnuSdPa8/zcbECkIS1w7fF79PCyVBM7iyMgMMHZZ58MlUUS+vcLcLPNP/4A3SxtOaEj154TG2d//7/78vP6i883Xn3GkibkxXjuIkngBxzcbFKCXDfefcWevqREeG6//gJkuKqL2ikL4zer0E5l8d6bDH/+YTdLQoDzzvvvOlJ866s9FuQ74jfLUU9qz6VnONM9MzMT0J4YK6WZ266I8HEwcMCCkp0FEv0MbMxIyZLxP8N/Aumeh5Pl7aeff//+Y2Rmgqj1UBJeWeby4v03Pi52yYwVROXHBy8/AT344t13oGfP330TpCoKl7r+6F1E3z5eLlYTOQGYJxj//MXtroV7bu6r9wYl2qatelICK8pcwzp2rb/z2ttYdtf5J+effGxedmZxnsOff+CsIyPo1L4LX34U4ucAku8+/gCS8ebyia4aBkoiC/fdKFx76R8sM1gqCALJ4w/fYwQXqlmj5SpdzQIIMACe18nLni8znAAAAABJRU5ErkJggg==",this.options.images["Update.Products.Server.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAABz0lEQVR42mJkCJvHQCXAxEA9MGrWwJnFgl/aWkmoMtDATE2Mn5vt4avPyw/eqd96leHPP5LdFWYos7/Z98ClpwYVm9iTlkZN2C8jzLW31IWBmRGrekYsaZWZcW68eYS9Chsr86PXXwK7dl96+gkuuTjV6tKjd907bxDlrvYAvSR3TS4OVhZmJiUJvuNtfmL8nHDZuftvxTiqEuvHaCc1ZC7Q0FMt3nDugccf1KUFCJglwMexPt/++6JYJgbGC3deIyuSF+P11BKH6WD8++//tFiTW32B9T46DIyMWMxakmwJjCnOtOXerTsu3H9788l7ZONqQgyh5nKyfv7x59uvf5tOPlCQ4O0NN8BilqOBdMGGyww//lx89ilxzvEX77+//vAdLqsmIwhh6EjwPnz5iYed+euPP8Wrzye6aGAx6+/f/1IcrHDuyoN33n7+AecK8rJDGOZqYuduv5YT5X3w6vO7H3+42FmwmDVzx7WecEM7ZWEGcAjsvP5cXJALkU6YoOHiqCd14NpzK22JVx+/L0kwX3XoDrb0xchQ5Kye5qEJ9A4kQP/9+8/EhJ4s77/8tPvsoxBblTvPPq4+fLdnzy2G//9xp9XRMmdkmwUQYADSIKZE6hdeRgAAAABJRU5ErkJggg==",this.options.images["Update.Products.Ultimate.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAAB4klEQVR42mJkCJvHQCXAxEA9QE2zWEjVICHA6aUlYa0hbqUlIcjLsWjvzbJV5yFSjPDw6ggxiHNWf/flx4FLT3ddeLrpxkuG3//gRqiIcue5abgby/Fzs5+8/uLYjZd7rz1/8unnhU5/ifQV6O4CGmRWvVmal93LQKYkQG+FmvjRq8/3XXiy5tyT268+V/vrPXn7NaJv3/knH5GdKcLHgcWPYgKcT959A6KTD9/Xb7zMwMESriXhaiCz21t73bF7sc7qLJELyA2vH39WnnsCRLy87Pf7gigK++ZAPaCvpYW54SJ/licAycdvvizacxPkcOLNAhrk3LjtzuuvcFMgftQQ491e647VLJzpC+giiEFo4Marz7IiPEMq3Q91s758/83AxUqdvL1w341H3YHbTt5fd+ohBe5iY/7x+2/+krMO9VuevvveHGUCMjrFMlBPCpjWgEmXKHeZyws6a0t6msgt2XMTyL335lvzlitABEy6lx+9z/fTlRfnXQSWQjfr5ftvssLcYlwszlpS1loSQJG5OXbHr77oWndh85UXaNb07LoBRDjDC1iqnWj2/vz997FrzzeduG+kKhrQtQcz6WuK8zx6/QWrPxhx1R2YeRsCgAYt3HujceMVEswaRukeIMAAp3/OgDSE+PwAAAAASUVORK5CYII=",this.options.images["Update.Products.Web.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAAC6UlEQVR42mJhCJvHQCXAxEA9QE2zWHBJqItyx9koOxtIK0jwC/Gwv/vy8+HLT3vOP1l05O7N11+JNoudZVakUaKb5sztV1tWnb/8/NPDzz/keTl0JHg9jWWvTAxZsOtG6oqzDD/+oOljRAt7IX6Og9Xux64+T19+luHXXyw2sTHPiDCy1pGyb9357uMP3OHFyrSn3GXXuUfpC09hNwgIfv3NWHQaqAaoEmguTrNmR5ueu/26eMV5/GG8o8CO8eevs7dez44ywRleqQtOEh9rmIoRZr2cERbdvkNTij/CSX3nqQdW2lIeEw5davHcc/bR/RefvM0VgWpyF5y6/QEaRqvTzHm52Bftub7symt0Px469zDSVmny8ccqskLuZgrHrj5TFeBQkhH68OVnYagx0JRrD9/urPOAKI521378+gtQZFaJm4s8H0SQmUHbHxruP38le+lN3HnDXIrHxkDOve9gjaf69x+/nU3k0ybuO/Py684br23k+TWFOGXFeM/eeJa96jJQRJmHWVdecNOlFyh+BDq1n4sN6JZP335CRMy1JFfsu+luqby7Kxiu7NNmUMx8/Pobwn348gswNLCEPdCbFT4ajkYK9568q3NV0VcVt27d057+y7BgLTyYIPEIZ8uL83yG2Y2SJtYfu+djo/b87Zc1B29nBxttP3YHKLhyz1WgBUAG0MnA+AGSECdDtAAtPnT5GRazIDFy8trzpt13uDlYIYqSl1ww1ZAERigw4JfuvApx4Oevv4DmflkQvf/cA2B0Yc9DVCtzZieYz0k0J1InpmIUs1KXnjZSFe2NMCRoEFCNsZpoytIzuPP2738unXvcjORmxJkysOAoJlmYgLJANUCVaPkfkVYh4PvPP9MP3w3Ul15X7CzKycLw59/PP/8//fkry89prSSU766xucz18oO3HpMOfv/6i0D5BQcaYrxxNkouBtLy4nxCvOzvPoPL1QtPFx25d+PVZ6xaGEdAPQQQYAAwXURrJYg5GwAAAABJRU5ErkJggg==",this.options.images["Update.Products.Wpf.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABkAAAAZCAIAAABLixI0AAABmklEQVR42mJhCJvHQCXAxEA9MGrW8DCLAZS+wua5lK75//8/kISzc/t3A9mqacu+fPt55PzD/zBw78k7oGDd7EP/kQBEMQum4ZG2SnB2pqPy1x+/pUR5520+n7zkAlDk5YwwoKCsKM/9p++VijZg8eOeh5+ApKYUP5AMd9EGkooSfEAywFZ1z8l7itKCey88haj8+u0XkFSXEzp74zmB8OoLBBn06v1XIJlrKSsmxP309Rcg+/STzxBZoLnbzj1WkhG6fP8tml50P7oYy63cc9XHRg3I9jZXPHLhsSLYsbdmRoIc9f1X/4pTYrzs3JxsjSm2QAQU3Hn8rseEQyhmAd1ioCysqypRNPso0Cx+blZ3S+Xo5i0tSdZr9l4LnXUSrnJujAFmYKH7ERhSxy49BoYdMFCA7Mu3Xyy78hroTTTvaMiLYAYWillA/UCXr9h3E8gGpgMge8/ZR1E6okDG8tNPkPXoq4o/BgciTrOA+oHenHz8MdTo77+K1l91NpAGeuf2hx9wZRDTz9x+hWkW42hZOGoWDc0CCDAAUM/HbEbs+cQAAAAASUVORK5CYII=",this.options.images["Update.StimulsoftLogo64.png"]="data:image/png;base64, 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",this.options.images["Window.CloseWhite.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAVklEQVR42sSTQQ4AIAjDwP//ed4JGxhC5ChYwxodgE3q2LBWAGonVAAISNqLACevgcykK0QIvaxC9ObZnkZ07VQaXQQrNcadKYRpVCE+aSx7/z/TFWAA0YYTHQSAJTUAAAAASUVORK5CYII=",this.options.images["Window.MaximizeWhite.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAN0lEQVR42mL8//8/AyWAiYFCQLEBLGh8Yv3DOHi9gOI8HOD/4IqFYWAAC6FQJtUAxqEXBgABBgD16wYlrMrFzgAAAABJRU5ErkJggg==",this.options.images["Window.MinimizeToWindow.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAARklEQVR42mL8//8/AyWAiYFCQLEBLDjECfmLkeYuQLEFn+tY8Ej+J8ZQmniBkZSAJdUF/0kJRIYBC4P/lBjAOPQyE0CAAQCUbQoqWZArVgAAAABJRU5ErkJggg==",this.options.images["Window.MinimizeWhite.png"]="data:image/png;base64, iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAKklEQVR42mL8//8/AyWAiYFCMGrAsDCABYsYMSmLkaYuYByNRtIAQIABAB3dBCLNdQfHAAAAAElFTkSuQmCC"},StiJsDesigner.prototype.AddLocalizations=function(){var A,e=navigator.defaultLocalization||navigator.language||navigator.browserLanguage;A=e?e.substring(0,2):"en",this.options.defaultLocalization=A,this.loc.Navigator={ButtonSettings:this.loc.Export.Settings,ButtonChangePassword:this.loc.Cloud.ButtonChangePassword,ButtonAbout:this.loc.MainMenu.menuHelpAboutProgramm.replace("&","").replace("...",""),ButtonLogout:this.loc.Cloud.ButtonLogout,TextProfile:this.loc.Cloud.TextProfile},this.loc.Administration={LabelNewPassword:this.loc.Cloud.LabelNewPassword,LabelCurrentPassword:this.loc.Cloud.LabelCurrentPassword,LabelPicture:"Picture:",LabelRole:this.loc.Cloud.TextRole+":",TextRole:this.loc.Cloud.TextRole,TextUser:this.loc.Cloud.TextUser,TextDate:this.loc.FormFormatEditor.Date,LabelFirstName:this.loc.Cloud.TextFirstName+":",LabelLastName:this.loc.Cloud.TextLastName+":",LabelUserName:this.loc.Cloud.TextUserName+":",LabelLastLogin:this.loc.Cloud.LabelLastLogin},this.loc.File={MessageFailedAddFollowingFiles:"Failed to add the following files. Exceeded the size {0} MB."},this.loc.Common={ButtonBack:this.loc.Wizards.ButtonBack.replace("&",""),LabelDescription:this.loc.PropertyMain.Description,LabelCreated:this.loc.Cloud.LabelCreated,LabelModified:this.loc.Cloud.LabelModified,ButtonOK:this.loc.Buttons.Ok.replace("&",""),ButtonCancel:this.loc.Buttons.Cancel.replace("&","")},this.loc.Authorization={ButtonLogin:this.loc.Cloud.Login,ButtonResendEmail:this.loc.Cloud.ButtonResendEmail,ButtonResetPassword:this.loc.Cloud.ButtonResetPassword,ButtonSignUp:this.loc.Cloud.ButtonSignUp,ButtonSendEmail:this.loc.FormViewer.SendEMail.replace("...",""),CheckBoxEnabled:this.loc.PropertyMain.Enabled,CheckBoxRememberMe:this.loc.Cloud.CheckBoxRememberMe,HyperlinkBack:this.loc.Wizards.ButtonBack.replace("&",""),HyperlinkAgreeToTerms:this.loc.Cloud.HyperlinkAgreeToTerms,HyperlinkAlreadyHaveAccount:this.loc.Cloud.HyperlinkAlreadyHaveAccount,HyperlinkForgotPassword:this.loc.Cloud.HyperlinkForgotPassword,HyperlinkHavePassword:this.loc.Cloud.HyperlinkHavePassword,HyperlinkRegisterAccount:this.loc.Cloud.HyperlinkRegisterAccount,TextCreate:this.loc.Cloud.Create,TextView:this.loc.Cloud.ButtonView,TextModify:this.loc.Cloud.TextModify,TextDelete:this.loc.Buttons.Delete,TextRegistrationSuccessfully:this.loc.Messages.TextRegistrationSuccessfully,TextRun:this.loc.Cloud.ButtonRun,TextVerifyEmail:"Verify your email address at {0} to ensure your account can be recovered.",TextFirstName:this.loc.Cloud.TextFirstName,TextLastName:this.loc.Cloud.TextLastName,TextPassword:this.loc.Password.StiSavePasswordForm,TextUserName:this.loc.Cloud.TextUserName,LabelFirstName:this.loc.Cloud.TextFirstName+":",LabelLastName:this.loc.Cloud.TextLastName+":",LabelUserName:this.loc.Cloud.TextUserName+":",WindowTitleForgotPassword:this.loc.Cloud.WindowTitleForgotPassword,WindowTitleLogin:this.loc.Cloud.WindowTitleLogin,WindowTitleSignUp:this.loc.Cloud.WindowTitleSignUp},this.loc.Options={TabInterface:"Interface",TabLanguage:this.loc.PropertyMain.Language,LabelBackground:this.loc.Report.LabelBackground,LabelForeground:this.loc.Cloud.LabelForeground},this.loc.License={WindowTitleLicense:this.loc.NuGet.License.replace(":","")},this.loc.Update={ButtonIAgree:"I Agree"}},StiJsDesigner.prototype.InitializeAuthForm=function(){var authForm=this.BaseForm("authForm",this.loc.Authorization.WindowTitleLogin,2,null,null,!0);authForm.container.style.overflowX="hidden",authForm.container.style.overflowY="hidden",authForm.onkeyup=null,authForm.controls={},authForm.formWidth=380,authForm.style.width=authForm.formWidth+"px",authForm.style.backgroundColor="white",authForm.buttonsPanel.style.display="none",authForm.buttonsSeparator.style.display="none",authForm.showCaptions=!1,authForm.mode="login",authForm.result={},authForm.className="stiCloudReportsWebClientForm",authForm.container.className="stiCloudReportsWebClientFormContainer",authForm.header.className="stiCloudReportsWebClientFormHeader",authForm.caption.className="stiLoginFormCaption",authForm.container.style.padding="0px",authForm.caption.style.padding="45px 133px 45px 33px";var imgLogo=document.createElement("img");imgLogo.style.position="absolute",imgLogo.style.top="50px",imgLogo.style.right="42px",imgLogo.src=this.options.images["LogoStimulsoftReports.png"],authForm.header.style.position="relative",authForm.header.appendChild(imgLogo),authForm.this_=this,authForm.panels={},authForm.panels.login=this.AuthFormLoginPanel(authForm),authForm.panels.signUp=this.AuthFormSignUpPanel(authForm),authForm.panels.forgotPassword=this.AuthFormForgotPasswordPanel(authForm),authForm.panels.registerSuccessfully=this.AuthFormRegisterSuccessfullyPanel(authForm),authForm.panels.resetPassword=this.AuthFormResetPasswordPanel(authForm),authForm.panels.wheelPanel=this.AddWheelPanel();for(var i in authForm.panels)authForm.container.appendChild(authForm.panels[i]);authForm.onhide=function(){this.jsObject.SetCookie("lastDateShowingAuthForm",this.jsObject.DateToJSONDateFormat(new Date))},authForm.cancelAction=function(){this.jsObject.options.forms.shareForm&&this.jsObject.options.forms.shareForm.visible&&this.jsObject.options.forms.shareForm.changeVisibleState(!1)},authForm.onshow=function(){authForm.controls.buttonSignUp.setEnabled(!1),authForm.controls.agreeCheckbox.setChecked(!1),authForm.controls.buttonSignUp.agreeTermsAndPolicy=!1,authForm.jsObject.options.previewMode&&(authForm.jsObject.options.workPanel.showPanel(authForm.jsObject.options.homePanel),authForm.jsObject.options.buttons.homeToolButton.setSelected(!0))},authForm.changeMode=function(A){switch(this.mode=A,this.mode){case"login":this.caption.innerHTML=this.jsObject.loc.Authorization.WindowTitleLogin;break;case"signUp":case"registerSuccessfully":this.caption.innerHTML=this.jsObject.loc.Authorization.WindowTitleSignUp;break;case"forgotPassword":authForm.controls.resetInfoText&&authForm.controls.resetInfoText.parentNode.removeChild(authForm.controls.resetInfoText),this.caption.innerHTML=this.jsObject.loc.Authorization.WindowTitleForgotPassword;break;case"resetPassword":this.caption.innerHTML=this.jsObject.loc.Authorization.WindowTitleForgotPassword;break}this.caption.innerHTML&&(this.caption.innerHTML=this.caption.innerHTML.toUpperCase());for(var e in this.panels)this.panels[e].style.display=e==A?"":"none";this.focusFirstControl()},authForm.focusFirstControl=function(){if(!this.jsObject.isTouchDevice){if("login"==this.mode)return void this.controls.loginUserName.focus();if("signUp"==this.mode)return void this.controls.signUpFirstName.focus();if("forgotPassword"==this.mode)return void this.controls.forgotPasswordUserName.focus();if("resetPassword"==this.mode)return void this.controls.buttonSetPassword.focus()}},authForm.resetControls=function(){for(var A in this.controls)"value"in this.controls[A]&&this.controls[A]!=this.controls.loginUserName&&(this.controls[A].value="")},authForm.hideAllProgressMarkers=function(){var A=["buttonLogin","buttonResetPassword","buttonSignUp"];for(var e in A)this.controls[A[e]].progressMarker.changeVisibleState(!1)},authForm.show=function(chh,runFromCloud){this.jsObject.options.forms.changePasswordForm&&this.jsObject.options.forms.changePasswordForm.changeVisibleState(!1),this.jsObject.options.forms.settingsForm&&this.jsObject.options.forms.settingsForm.changeVisibleState(!1),this.jsObject.options.forms.updateForm&&this.jsObject.options.forms.updateForm.changeVisibleState(!1),!runFromCloud&&this.jsObject.options.menus.fileMenu&&""==this.jsObject.options.menus.fileMenu.style.display&&this.jsObject.options.menus.fileMenu.changeVisibleState(!1),this.jsObject.options.logins=[];try{this.jsObject.options.logins=eval(this.jsObject.GetCookie("logins"))||[]}catch(A){}this.resetControls(),this.hideAllProgressMarkers(),chh||this.changeMode("login"),this.changeVisibleState(!0),this.focusFirstControl(),runFromCloud||(this.jsObject.options.toolBar.style.display="")},authForm.start=function(){authForm.show(!0)},authForm.startLogin=function(A,e,t,s){var n=this,o={};o.UserName=A,o.Password=e,o.Device={Ident:"WebDevice"},this.controls.buttonLogin.progressMarker.changeVisibleState(!0),o.Localization=n.jsObject.options.defaultLocalization,o.Ident="UserLogin",s&&(o.md5=s),o.LoginAndActivateLicense=!0;var i=t||n.controls.rememberMe.checked;n.jsObject.SetCookie("loginRememberMe",i),n.jsObject.options.controller.exec("service/login",o,function(A){n.hideAllProgressMarkers(),n.changeVisibleState(!1),n.ready=!0;var e=n.jsObject.options.forms;e.onlineOpenReport&&e.onlineOpenReport.visible&&(n.jsObject.options.ignoreSessionDate=!0,e.onlineOpenReport.setToTreeMode()),e.onlineSaveAsReport&&e.onlineSaveAsReport.visible&&(n.jsObject.options.ignoreSessionDate=!0,e.onlineSaveAsReport.setToTreeMode()),e.shareForm&&e.shareForm.visible&&(n.jsObject.options.ignoreSessionDate=!0,e.shareForm.checkReportSavingToCloud()),n.jsObject.options.ignoreSessionDate=!1},function(A,e){if(n.ready=!0,n.hideAllProgressMarkers(),A.ResultNotice&&"AuthAccountIsNotActivated"==A.ResultNotice.Ident){var t=n.jsObject.loc.Authorization.TextRegistrationSuccessfully.replace("{0}",n.controls.loginUserName.value);t=t.substring(t.indexOf("\n")+1),n.controls.registerSuccessfullyText.innerHTML=t,n.changeMode("registerSuccessfully")}else n.visible&&n.jsObject.ShowMessagesTooltip(e,n.controls.loginUserName)})},authForm.apply=function(){var A={};A.typeResult=this.mode;var e=this;switch(this.mode){case"login":this.controls.loginUserName.checkEmpty(this.jsObject.loc.Messages.ThisFieldIsNotSpecified)&&this.controls.loginPassword.checkEmpty(this.jsObject.loc.Messages.ThisFieldIsNotSpecified)&&this.startLogin(this.controls.loginUserName.value,this.controls.loginPassword.value);break;case"signUp":this.controls.signUpFirstName.checkEmpty(this.jsObject.loc.Notices.AuthFirstNameIsNotSpecified,null,null,!0)&&this.controls.signUpLastName.checkEmpty(this.jsObject.loc.Notices.AuthLastNameIsNotSpecified,null,null,!0)&&this.controls.signUpUserName.checkEmpty(this.jsObject.loc.Notices.AuthUserNameIsNotSpecified,null,null,!0)&&this.controls.signUpUserName.checkEmail(this.jsObject.loc.Notices.AuthUserNameShouldLookLikeAnEmailAddress)&&this.controls.signUpPassword.checkEmpty(this.jsObject.loc.Notices.AuthPasswordIsNotSpecified,null,null,!0)&&this.controls.signUpPassword.checkLength(6,this.jsObject.loc.Notices.AuthPasswordIsTooShort)&&(this.controls.buttonSignUp.progressMarker.changeVisibleState(!0),A.FirstName=this.controls.signUpFirstName.value,A.LastName=this.controls.signUpLastName.value,A.UserName=this.controls.signUpUserName.value,A.Password=this.controls.signUpPassword.value,A.Localization=this.jsObject.options.defaultLocalization,A.Module="Reports",this.jsObject.SendCommand("UserSignUp",A,function(t){t.ResultActivationByEmail?(e.controls.registerSuccessfullyText.innerHTML=e.jsObject.loc.Authorization.TextRegistrationSuccessfully.replace("{0}",e.controls.signUpUserName.value),e.controls.loginUserName.value=A.UserName,e.controls.loginPassword.value=A.Password,e.changeMode("registerSuccessfully")):(e.changeMode("login"),e.controls.rememberMe.checked=!0,e.startLogin(A.UserName,A.Password))},function(A,t){e.jsObject.ShowMessagesTooltip(t,e.controls.signUpUserName),e.hideAllProgressMarkers()}));break;case"forgotPassword":this.controls.forgotPasswordUserName.checkEmpty(this.jsObject.loc.Messages.ThisFieldIsNotSpecified)&&this.controls.forgotPasswordUserName.checkEmail(this.jsObject.loc.Notices.AuthUserNameShouldLookLikeAnEmailAddress)&&(A.UserName=this.controls.forgotPasswordUserName.value,this.controls.buttonResetPassword.progressMarker.changeVisibleState(!0),this.jsObject.SendCommand("UserResetPassword",A,function(t){e.hideAllProgressMarkers(),e.controls.resetInfoText&&e.controls.resetInfoText.remove();var s=$("<div style='text-align:left; white-space:normal; width:230px;overflow:hidden;' class='stiCloudReportsWebClientAuthFormTextCell'>"+e.jsObject.formatString(e.jsObject.loc.Notices.AuthSendMessageWithInstructions,A.UserName)+"</div>");$(e.controls.buttonResetPassword).after(s);var n=s.height();s.height(0),s.animate({height:n}),e.controls.resetInfoText=s},function(A,t){e.jsObject.ShowMessagesTooltip(t,e.controls.forgotPasswordUserName),e.hideAllProgressMarkers()}));break}return(null==A.userName||""!=A.userName)&&A},authForm.action=function(){this.apply()};var this_=this;window.location.search.indexOf("reset=")>=0?(authForm.resetId=window.location.search.substring(window.location.search.indexOf("reset=")+6),authForm.changeMode("resetPassword"),authForm.ready=!0):(authForm.changeMode("wheelPanel"),this_.options.userAny?(authForm.changeMode("login"),this_.GetCookie("loginPassword")&&this_.GetCookie("loginLogin")&&"true"===this_.GetCookie("loginRememberMe")?authForm.startLogin(this_.GetCookie("loginLogin"),"",!0,this_.GetCookie("loginPassword")):authForm.ready=!0):(authForm.changeMode("signUp"),authForm.ready=!0))},StiJsDesigner.prototype.AuthFormLoginPanel=function(A){var e=document.createElement("div"),t=this.CreateHTMLTable(),s=this.CreateHTMLTable();s.style.margin="0 auto 0 auto",e.appendChild(t),t.style.width="100%",t.addCell(s).style.width="50%";var n="true"===this.GetCookie("loginRememberMe"),o=$("<div style='width: "+A.formWidth+"px;margin:0 auto;border-top:'></div>")[0],i=t.addCellInNextRow(o);i.style.textAlign="center",i.colSpan=2,A.showCaptions&&(A.loginCaption=s.addCell(),A.loginCaption.className="stiCloudReportsWebClientAuthFormTextCell",A.loginCaption.innerHTML=this.loc.Authorization.TextUserName);var r=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextUserName,this.loc.Authorization.TextUserName,"login.png");A.controls.loginUserName=r,s.addCellInNextRow(r.table),r.action=function(){A.action()},r.value=this.GetCookie("loginLogin")||"",A.showCaptions&&(A.passwordCaption=s.addCellInNextRow(),A.passwordCaption.style.paddingTop="17px",A.passwordCaption.className="stiCloudReportsWebClientAuthFormTextCell",A.passwordCaption.innerHTML=this.loc.Authorization.TextPassword);var a=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextPassword,this.loc.Authorization.TextPassword,"password.png");a.setAttribute("type","password"),A.controls.loginPassword=a;var l=s.addCellInNextRow(a.table);A.showCaptions||(l.style.paddingTop="17px"),a.action=function(){A.action()},a.value=this.GetCookie("loginPassword")||"";var p=document.createElement("label"),u=document.createElement("input");u.style.marginTop="15px",A.controls.rememberMe=u,u.setAttribute("type","checkbox"),s.addCellInNextRow(p),p.appendChild(u);var c=document.createElement("span");c.style.margin="0 0 3px 4px",p.appendChild(c),c.className="stiCloudReportsWebClientAuthFormTextCell",c.innerHTML=this.loc.Authorization.CheckBoxRememberMe,u.checked=n;var d=this.CreateHTMLTable();s.addCellInNextRow(d),d.style.width="100%";var g=this.LoginButton(null,this.loc.Authorization.ButtonLogin,null);A.controls.buttonLogin=g,g.style.margin="8px 0 8px 0",g.style.display="inline-block",d.addCellInLastRow(g).style.paddingTop="10px",g.action=function(){A.action()},this.AddSmallProgressMarkerToControl(g,!0);var h=this.CreateHTMLTable();h.style.width="100%",s.addCellInNextRow(h).style.padding="5px 0 20px 0";var m=this.HiperLinkButtonForAuthForm(null,this.loc.Authorization.HyperlinkForgotPassword,!0);A.controls.buttonForgotPassword=m,m.style.display="inline-block",h.addCell(m,null,"vertical-align: top; text-align: left; padding-bottom: 25px;"),m.action=function(){A.changeMode("forgotPassword")};var f=this.HiperLinkButtonForAuthForm(null,this.loc.Authorization.HyperlinkRegisterAccount,!0);A.controls.buttonRegisterAccount=f,f.style.display="inline-block";var v=h.addCellInNextRow(f);return v.style.textAlign="center",v.style.borderTop="1px solid #f2f1f1",v.style.paddingTop="20px",f.action=function(){A.changeMode("signUp")},$(this).on("eventLocalization",function(){A.showCaptions?(A.loginCaption.innerHTML=this.loc.Authorization.TextUserName,A.passwordCaption.innerHTML=this.loc.Authorization.TextPassword):(A.controls.loginUserName.setAttribute("placeholder",this.loc.Authorization.TextUserName),A.controls.loginPassword.setAttribute("placeholder",this.loc.Authorization.TextPassword)),c.innerHTML=this.loc.Authorization.CheckBoxRememberMe,A.controls.buttonLogin.caption.innerHTML=this.loc.Authorization.ButtonLogin,A.controls.buttonRegisterAccount.caption.innerHTML=this.loc.Authorization.HyperlinkRegisterAccount,A.controls.buttonForgotPassword.caption.innerHTML=this.loc.Authorization.HyperlinkForgotPassword}),e},StiJsDesigner.prototype.AuthFormSignUpPanel=function(A){var e=document.createElement("div"),t=this.CreateHTMLTable(),s=this.CreateHTMLTable();s.style.margin="0 auto 0 auto",e.appendChild(t),t.style.width="100%",t.addCell(s).style.width="50%";var n=$("<div style='width: "+A.formWidth+"px;margin:0 auto;'></div>")[0],o=t.addCellInNextRow(n);o.style.textAlign="center",o.colSpan=2,A.showCaptions&&(A.firstNameCaption=s.addCell(),A.firstNameCaption.className="stiCloudReportsWebClientAuthFormTextCell",A.firstNameCaption.innerHTML=this.loc.Authorization.TextFirstName);var i=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextFirstName,this.loc.Authorization.TextFirstName,"login.png");A.controls.signUpFirstName=i,s.addCellInNextRow(i.table),i.action=function(){A.action()},A.showCaptions&&(A.lastNameCaption=s.addCellInNextRow(),A.lastNameCaption.className="stiCloudReportsWebClientAuthFormTextCell",A.lastNameCaption.innerHTML=this.loc.Authorization.TextLastName,A.lastNameCaption.style.paddingTop="17px");var r=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextLastName,this.loc.Authorization.TextLastName,"login.png");A.controls.signUpLastName=r;var a=s.addCellInNextRow(r.table);A.showCaptions||(a.style.paddingTop="17px"),r.action=function(){A.action()},A.showCaptions&&(A.loginCaption2=s.addCellInNextRow(),A.loginCaption2.className="stiCloudReportsWebClientAuthFormTextCell",A.loginCaption2.innerHTML=this.loc.Authorization.TextUserName,A.loginCaption2.style.paddingTop="17px");var l=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextUserName,this.loc.Authorization.TextUserName,"email.png");A.controls.signUpUserName=l;var p=s.addCellInNextRow(l.table);A.showCaptions||(p.style.paddingTop="17px"),l.action=function(){A.action()},A.showCaptions&&(A.passwordCaption2=s.addCellInNextRow(),A.passwordCaption2.className="stiCloudReportsWebClientAuthFormTextCell",A.passwordCaption2.innerHTML=this.loc.Authorization.TextPassword,A.passwordCaption2.style.paddingTop="17px");var u=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextPassword,this.loc.Authorization.TextPassword,"password.png");u.setAttribute("type","password"),A.controls.signUpPassword=u;var c=s.addCellInNextRow(u.table);A.showCaptions||(c.style.paddingTop="17px"),u.action=function(){A.action()};var d=document.createElement("div");d.style.width="300px",s.addCellInNextRow(d).style.padding="30px 0 7px 0";var g=this.CheckBox();g.id="sti_authform_agreecheckbox",A.controls.agreeCheckbox=g,g.style.display="inline-block",g.style.marginRight="6px",d.appendChild(g),g.action=function(){A.controls.buttonSignUp.agreeTermsAndPolicy=this.isChecked,A.controls.buttonSignUp.setEnabled(this.isChecked)};var h=this.loc.Cloud.AcceptTermsAndPrivacyPolicy,m=this.CreateHTMLTable();m.className="stiDesignerTextContainer",m.style.fontSize="14px",m.style.display="inline-block",m.addTextCell(h?h.substring(0,h.indexOf("{0}")):"I accept the"),d.appendChild(m);var f=this.HiperLinkButton(null,this.loc.Cloud.PrivacyPolicy||"Privacy");f.style.margin="0 4px 0 4px",f.caption.style.padding="0px",f.caption.style.whiteSpace="normal",f.style.display="inline-block",f.action=function(){A.this_.openNewWindow("https://www.stimulsoft.com/en/privacy-policy")},d.appendChild(f);var v=this.CreateHTMLTable();v.className="stiDesignerTextContainer",v.style.fontSize="14px",v.style.display="inline-block",v.addTextCell(h?h.substring(h.indexOf("{0}")+3,h.indexOf("{1}")):"and"),d.appendChild(v);var w=this.HiperLinkButton(null,this.loc.Cloud.TermsOfUse||"Terms");w.style.margin="0 4px 0 4px",w.caption.style.padding="0px",w.caption.style.whiteSpace="normal",w.style.display="inline-block",w.action=function(){var e=A.this_.InitializeLicenseForm();e.buttonSave.caption.innerHTML=A.this_.loc.Common.ButtonOK,e.buttonCancel.style.display="none"},d.appendChild(w);var C=this.CreateHTMLTable();C.className="stiDesignerTextContainer",C.style.fontSize="14px",C.style.display="inline-block",C.addTextCell(h?h.substring(h.indexOf("{1}")+3):""),d.appendChild(C);var L=this.LoginButton(null,this.loc.Authorization.ButtonSignUp,null);A.controls.buttonSignUp=L,L.style.margin="3px 0 8px 0",L.style.display="inline-block",s.addCellInNextRow(L).style.textAlign="right",L.action=function(){A.action()},this.AddSmallProgressMarkerToControl(L,!0);var B=this.HiperLinkButton(null,this.loc.Authorization.HyperlinkAlreadyHaveAccount,23);return A.controls.buttonAlreadyHaveAccount=B,B.style.margin="8px 0 45px 0",B.style.display="inline-block",n.appendChild(B),B.action=function(){A.changeMode("login")},$(this).on("eventLocalization",function(){A.showCaptions?(A.firstNameCaption.innerHTML=this.loc.Authorization.TextFirstName,A.lastNameCaption.innerHTML=this.loc.Authorization.TextLastName,A.loginCaption2.innerHTML=this.loc.Authorization.TextUserName,A.passwordCaption2.innerHTML=this.loc.Authorization.TextPassword):(A.controls.signUpFirstName.setAttribute("placeholder",this.loc.Authorization.TextFirstName),A.controls.signUpLastName.setAttribute("placeholder",this.loc.Authorization.TextLastName),A.controls.signUpUserName.setAttribute("placeholder",this.loc.Authorization.TextUserName),A.controls.signUpPassword.setAttribute("placeholder",this.loc.Authorization.TextPassword)),A.controls.buttonAgreeToTerms.caption.innerHTML=this.loc.Authorization.HyperlinkAgreeToTerms,A.controls.buttonSignUp.caption.innerHTML=this.loc.Authorization.ButtonSignUp,A.controls.buttonAlreadyHaveAccount.caption.innerHTML=this.loc.Authorization.HyperlinkAlreadyHaveAccount}),e},StiJsDesigner.prototype.AuthFormResetPasswordPanel=function(A){var e=document.createElement("div"),t=this.CreateHTMLTable(),s=this.CreateHTMLTable();s.style.margin="0 auto 0 auto",e.appendChild(t),t.style.width="100%",t.addCell(s).style.width="50%";var n=$("<div style='width: "+A.formWidth+"px;margin:0 auto;'></div>")[0],o=t.addCellInNextRow(n);o.style.textAlign="center",o.colSpan=2,A.showCaptions&&(A.loginCaption13=s.addCell(),A.loginCaption13.className="stiCloudReportsWebClientAuthFormTextCell",A.loginCaption13.innerHTML=this.loc.Authorization.TextPassword);var i=this.loc.Administration.LabelNewPassword?this.loc.Administration.LabelNewPassword.replace(":",""):"",r=this.TextBoxWithHintText(null,230,A.showCaptions?"":i,i,"password.png");r.setAttribute("type","password"),A.controls.resetPasswordPassword=r,s.addCellInNextRow(r.table),r.action=function(){this.jsObject.options.forms.authForm.action()};var a=this.LoginButton(null,this.loc.Authorization.ButtonResetPassword,null);A.controls.buttonSetPassword=a,a.style.margin="8px 0 45px 0",a.style.display="inline-block",s.addCellInNextRow(a).style.paddingTop="10px";var l=A.jsObject;return a.action=function(){A.jsObject.SendCommand("UserResetPasswordComplete",{NewPassword:r.value,ResetKey:A.resetId},function(e){A.startLogin(e.ResultUserName,r.value,"true"===l.GetCookie("loginRememberMe"))})},this.AddSmallProgressMarkerToControl(a,!0),$(this).on("eventLocalization",function(){A.showCaptions?A.loginCaption13.innerHTML=this.loc.Authorization.TextPassword:A.controls.forgotPasswordUserName.setAttribute("placeholder",this.loc.Authorization.TextPassword),A.controls.buttonSetPassword.caption.innerHTML=this.loc.Authorization.ButtonResetPassword}),e},StiJsDesigner.prototype.AuthFormForgotPasswordPanel=function(A){var e=document.createElement("div"),t=this.CreateHTMLTable(),s=this.CreateHTMLTable();s.style.margin="0 auto 0 auto",e.appendChild(t),t.style.width="100%",t.addCell(s).style.width="50%";var n=$("<div style='width: "+A.formWidth+"px;margin:0 auto;'></div>")[0],o=t.addCellInNextRow(n);o.style.textAlign="center",o.colSpan=2,A.showCaptions&&(A.loginCaption3=s.addCell(),A.loginCaption3.className="stiCloudReportsWebClientAuthFormTextCell",A.loginCaption3.innerHTML=this.loc.Authorization.TextUserName);var i=this.TextBoxWithHintText(null,230,A.showCaptions?"":this.loc.Authorization.TextUserName,this.loc.Authorization.TextUserName,"email.png");A.controls.forgotPasswordUserName=i,s.addCellInNextRow(i.table),i.action=function(){this.jsObject.options.forms.authForm.action()};var r=this.LoginButton(null,this.loc.Authorization.ButtonResetPassword,null);A.controls.buttonResetPassword=r,r.style.margin="8px 0 8px 0",r.style.display="inline-block",s.addCellInNextRow(r).style.paddingTop="10px",r.action=function(){this.jsObject.options.forms.authForm.action()},this.AddSmallProgressMarkerToControl(r,!0);var a=this.CreateHTMLTable();a.style.width="100%",s.addCellInNextRow(a).style.padding="5px 0 20px 0";var l=this.HiperLinkButtonForAuthForm(null,this.loc.Authorization.HyperlinkHavePassword,!0);A.controls.buttonHavePassword=l,l.style.display="inline-block",a.addCell(l,null,"vertical-align: top; text-align: left; padding-bottom: 25px;"),l.action=function(){this.jsObject.options.forms.authForm.changeMode("login")};var p=this.HiperLinkButtonForAuthForm(null,this.loc.Authorization.HyperlinkRegisterAccount,!0);A.controls.buttonRegisterAccountForgotPassword=p,p.style.display="inline-block";var u=a.addCellInNextRow(p);return u.style.textAlign="center",u.style.borderTop="1px solid #f2f1f1",u.style.paddingTop="20px",p.action=function(){this.jsObject.options.forms.authForm.changeMode("signUp")},$(this).on("eventLocalization",function(){A.showCaptions?A.loginCaption3.innerHTML=this.loc.Authorization.TextUserName:A.controls.forgotPasswordUserName.setAttribute("placeholder",this.loc.Authorization.TextUserName),A.controls.buttonResetPassword.caption.innerHTML=this.loc.Authorization.ButtonResetPassword,A.controls.buttonRegisterAccountForgotPassword.caption.innerHTML=this.loc.Authorization.HyperlinkRegisterAccount,A.controls.buttonHavePassword.caption.innerHTML=this.loc.Authorization.HyperlinkHavePassword}),e},StiJsDesigner.prototype.AuthFormRegisterSuccessfullyPanel=function(A){var e=document.createElement("div"),t=this.CreateHTMLTable(),s=this.CreateHTMLTable();s.style.margin="0 auto 0 auto",e.appendChild(t),t.style.width="100%",t.addCell(s).style.width="50%";var n=$("<div style='width: "+A.formWidth+"px;margin:0 auto;'></div>")[0],o=t.addCellInNextRow(n);o.style.textAlign="center",o.colSpan=2;var i=document.createElement("div");i.className="stiCloudReportsWebClientAuthFormSuccessfullyText",A.controls.registerSuccessfullyText=i;var r=s.addCellInNextRow(i);r.className="stiCloudReportsWebClientAuthFormTextCell",r.style.padding="0px 30px 0px 30px",r.colSpan=2,r.style.width="250px";var a=this.LoginButton(null,this.loc.Authorization.ButtonResendEmail,null);A.controls.buttonResendEmail=a,a.style.margin="8px 0 8px 0",a.style.display="inline-block",a.style.minWidth="315px",s.addCellInNextRow(a).style.textAlign="left",a.action=function(){this.jsObject.SendCommand("UserActivate",{UserName:A.controls.loginUserName.value,ResultSuccess:!0},function(){A.resetControls(),i.innerHTML=""},function(){A.resetControls(),i.innerHTML=""})};var l=this.HiperLinkButton(null,this.loc.Common.ButtonBack,23);return A.controls.buttonContinue=l,l.style.margin="8px 0 45px 0",l.style.display="inline-block",n.appendChild(l),l.action=function(){A.resetControls(),A.changeMode("login")},$(this).on("eventLocalization",function(){}),e},StiJsDesigner.prototype.LoginButton=function(A,e,t,s,n){var o=this.SmallButton(A,null,e||"",t,n,null,this.GetStyles("LoginButton"));return o.setEnabled=function(A){this.style.opacity=A?"1":"0.3",this.style.cursor=A?"pointer":"default",this.isEnabled=A,A||this.isOver||(this.isOver=!1),this.className=(A?this.isOver?this.styles.over:this.isSelected?this.styles.selected:this.styles.default:this.styles.disabled)+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse")},o.innerTable.style.width="100%",o.style.minWidth=(s||80)+"px",o.caption.style.textAlign="center",o.style.cursor="pointer",o},StiJsDesigner.prototype.AddWheelPanel=function(A){var e=document.createElement("div");return this.AddBigProgressMarkerToControl(e),e.progressMarker.changeVisibleState(!0,460,350),e},StiJsDesigner.prototype.OverrideCloudMethods=function(){var A=this;this.OpenReportFromCloud=function(e,t){var s={SessionKey:this.options.SessionKey,ItemKey:e.Key},n=this.options.processImage||this.InitializeProcessImage();n.show(),this.SendCommand("ItemResourceGet",s,function(s){s.ResultSuccess&&null!=s.ResultResource&&(n.show(),A.OpenReport(e.Name,"base64,"+s.ResultResource),A.options.cloudParameters.reportTemplateItemKey=e.Key,A.options.cloudParameters.reportName=e.Name,t||A.SaveFileToRecentArray(e.Name,e.Key,"StimulsoftMobileDesignerRecentArray"))},function(e,t){n.hide(),(A.options.forms.errorMessageForm||A.InitializeErrorMessageForm()).show(t)})},this.SendCommandItemResourceSave=function(e,t){if(!this.options.report)return;var s=this.options.processImage||this.InitializeProcessImage();s.show();var n={ItemKey:e,SessionKey:this.options.SessionKey,Resource:StiBase64.encode(A.designer.report.saveToJsonString())};t&&(n.VersionInfo={CustomMessage:StiBase64.decode(t),Ident:"CustomMessage"}),this.SendCommand("ItemResourceSave",n,function(e){s.hide(),A.options.forms.shareForm&&A.options.forms.shareForm.visible&&A.options.forms.shareForm.fillShareInfo()},function(e,t){s.hide(),A.options.forms.shareForm&&A.options.forms.shareForm.visible&&A.options.forms.shareForm.fillShareInfo(),(A.options.forms.errorMessageForm||A.InitializeErrorMessageForm()).show(t)})}},StiJsDesigner.prototype.InitializeController=function(){var A=new Object;this.options.controller=A,A.queue=[],A.uploadQueue=[],A.isExecuting=!1,A.jsObject=this,A.listeners={},A.signals={};var e=700,t=3e3;A.delayTime=0,A.shortDelayTime=10,A.longDelayTime=50,A.switchToLongDelayTime=600,A.time=0,A.isResetting=!1,A.isLongTime=!1;var s=this;A.resetSingals=function(){A.isResetting=!0,A.time=0,A.isLongTime=!1},A.processSignals=function(e){for(var t in e.ResultSignals){var s=e.ResultSignals[t];if(A.listeners[s.Ident]){s.UserKey==s.OwnerUserKey&&s.UserKey&&""!=s.UserKey&&A.resetSingals();for(var n in A.listeners[s.Ident])A.listeners[s.Ident][n](s)}}A.updateSignals()},A.updateSignals=function(){setTimeout(function(){A.isResetting||(A.isLongTime?A.delayTime>=A.longDelayTime:A.delayTime>=A.shortDelayTime)?(A.isResetting=!1,A.delayTime=0,s.options.sessionKey&&A.exec("1/runcommand",{Ident:"SignalFetchAll"},A.processSignals,function(e,t){console.error(t),A.updateSignals()})):(A.delayTime++,A.time++,A.time>A.switchToLongDelayTime&&(A.isLongTime=!0),A.updateSignals())},100)},A.exec=function(A,e,t,s,n,o){if(e&&"SignalFetchAll"==e.Ident&&this.queue.length>0&&this.queue[this.queue.length-1].param==e)return;this.queue[this.queue.length]={command:A,param:e,success:t,failure:s,allowSignal:o,dataType:n||"json"},this.isExecuting||this.run()},A.run=function(){this.queue.length>0&&(this.isExecuting=!0,this.selfExec(this.queue[0],this.next))},A.selfExec=function(e,t){var s=e.param;this.jsObject.options.SessionKey&&(s.SessionKey=this.jsObject.options.SessionKey);var n=e.success,o=e.failure,i=s.UserName,r=e.progress,a=e.allowSignal,l=e.self,p=e.id,u=e.obj,c=this;this.jsObject.SetWindowTitle(document.title),A.xhr=$.ajax({type:"POST",url:this.jsObject.options.restUrl+e.command+"/"+this.jsObject.generateKey(),data:JSON.stringify(s,null,2),contentType:"text"==e.dataType?"text/plain; charset=utf-8":"application/json; charset=utf-8",dataType:e.dataType?e.dataType:"json",success:function(s,r,d){try{if("text"==e.dataType)n(s,l,p);else if(s.ResultSuccess){if(s.ResultSignals)for(var g=0;g<s.ResultSignals.length;g++)if(s.ResultSignals[g].ResultNotice&&s.ResultSignals[g].ResultNotice.CustomMessage){var h=c.jsObject.options.forms.errorMessageForm||c.jsObject.InitializeErrorMessageForm();h.show(s.ResultSignals[g].ResultNotice.CustomMessage)}"UserLogin"==s.Ident&&(c.jsObject.options.licenseKey=null,c.jsObject.options.accountSettings=null,c.jsObject.RemoveAccountSettings(),Stimulsoft.Report.Engine.StiEngine.setEngine&&Stimulsoft.Report.Engine.StiEngine.setEngine(),c.jsObject.SetWindowTitle(document.title),s.ResultLicenseKey&&("true"===c.jsObject.GetCookie("loginRememberMe")?c.jsObject.SaveLicenseKey(s.ResultLicenseKey):c.jsObject.options.licenseKey=s.ResultLicenseKey),c.jsObject.options.SessionKey=s.ResultSessionKey,c.jsObject.options.UserKey=s.ResultUserKey,c.jsObject.options.UserName=i,c.jsObject.options.Password=s.md5,c.jsObject.options.ProductInfo=s.ResultProductInfo,c.jsObject.options.IsRootAdmin=s.ResultRootAdmin,c.jsObject.CheckActivation(),c.jsObject.setUserInfo(!0)),n(s,l,p),a&&A.resetSingals()}else{var m=A.formatResultMsg(s);if(s.ResultNotice&&"AuthUserHasLoggedOut"==s.ResultNotice.Ident&&"UserLogout"!=s.Ident&&(c.jsObject.options.accountSettings=null,c.jsObject.options.SessionKey=null,c.jsObject.RemoveAccountSettings(),c.jsObject.options.forms.authForm.show()),o)o(s,m,u);else if("UserLogout"!=s.Ident){m=m||"Unknown error";var h=c.jsObject.options.forms.errorMessageForm||c.jsObject.InitializeErrorMessageForm();h.show(m)}}}finally{t(c)}},error:function(e){if(!e||!e.responseText)return;if(A.aborted)A.aborted=!1;else{var s="Error: "+e.responseText;try{(c.jsObject.options.forms.errorMessageForm||c.jsObject.InitializeErrorMessageForm()).show(s)}catch(A){}t(c)}},progress:function(A){A.lengthComputable&&r&&r(A,l,p)}})},A.formatResultMsg=function(e){var t="";if(e.ResultNotice){var s=e.ResultNotice.Argument?e.ResultNotice.Argument:"";if(e.ResultNotice.Arguments)for(var n in e.ResultNotice.Arguments)s+=(""!=s?", ":"")+e.ResultNotice.Arguments[n];if(A.jsObject.loc.Notices&&A.jsObject.loc.Notices[e.ResultNotice.Ident])return A.jsObject.formatString(A.jsObject.loc.Notices[e.ResultNotice.Ident],e.ResultNotice.Arguments?e.ResultNotice.Arguments:s);e.ResultNotice.Arguments||""!=s?t=A.jsObject.formatString(e.ResultNotice.Ident,e.ResultNotice.Arguments?e.ResultNotice.Arguments:s):(t=e.ResultNotice[e.ResultNotice.Ident])||(t=e.ResultNotice.Ident,e.ResultNotice.CustomMessage&&(t+=". "+e.ResultNotice.CustomMessage))}return t},A.next=function(A){A.queue.splice(0,1),A.queue.length>0?A.run():A.isExecuting=!1},A.addListener=function(e,t){for(var s=1;s<arguments.length;s++){var n=arguments[s];A.listeners[n]||(A.listeners[n]=[]),A.listeners[n][A.listeners[n].length]=e}},A.postForm=function(A,e,t,s){t||(t=document);var n=t.createElement("FORM");n.setAttribute("method","POST"),n.setAttribute("action",s||this.jsObject.options.restUrl+A+"/"+this.jsObject.generateKey());for(var o in e){var i=t.createElement("INPUT");i.setAttribute("type","hidden"),i.setAttribute("name",o),i.setAttribute("value",e[o]),n.appendChild(i)}t.body.appendChild(n),n.submit(),t.body.removeChild(n)}},StiJsDesigner.prototype.SendCommand=function(A,e,t,s,n,o){var i=this;e.Ident=A,"UserLogin"!=A&&"UserIdle"!=A&&"UserSignUp"!=A&&"UserResetPassword"!=A&&"UserResetPasswordComplete"!=A&&"UserActivate"!=A&&"SoftwareGetLicense"!=A&&!n&&i.SessionIsOld()?(this.options.accountSettings=null,this.options.SessionKey=null,this.RemoveAccountSettings(),this.options.forms.authForm.show()):i.options.controller.exec(o||"1/runcommand",e,function(A){t&&t(A)},s,null,!0)},StiJsDesigner.prototype.formatString=function(A,e){if(A){for(var t=A,s=1;s<arguments.length;s++)t=t.replace("{"+(s-1)+"}",arguments[s]);return arguments.length>1?t:A.replace("{0}","")}return""},StiJsDesigner.prototype.AddSmallProgressMarkerToControl=function(A,e){var t=document.createElement("div");t.className="stiCloudReportsSmallProgressMarker";var s=this.options.IsTouchDevice?"-22px":"-20px";t.style.left=s,t.style.top=s,t.style.display="none";var n=this,o=document.createElement("div");t.appendChild(o),o.className="client_navigator_loader_mini",t.changeVisibleState=function(A){e&&(this.style.left=$(this.control).width()+5+"px",this.style.top=-($(this.control).height()/2+8)+"px"),t.style.display=A?"":"none"},t.control=A,A.appendChild(t),A.progressMarker=t},StiJsDesigner.prototype.AddBigProgressMarkerToControl=function(A){var e=document.createElement("div");e.className="stiCloudReportsBigProgressMarker",e.style.display="none",e.style.overflow="hidden";var t=this,s=document.createElement("div");e.appendChild(s),s.className="client_navigator_loader",e.changeVisibleState=function(t,s,n){e.style.display=t?"":"none",t&&(e.style.left=(s||A.offsetWidth/2-32)+"px",e.style.top=(n||$(A).height()/2-32)+"px")},A.appendChild(e),A.progressMarker=e},StiJsDesigner.prototype.StartNewSession=function(){if(this.SetCookie("lastDateShowingAuthForm",""),this.options.toolBar.userNameButton.style.display="",this.options.toolBar.loginButton.style.display="none",this.options.menus.fileMenu&&""==this.options.menus.fileMenu.style.display)return;this.ChangeVisibleStateAllPanels(!0)},StiJsDesigner.prototype.FinishSession=function(){this.SetCookie("lastDateShowingAuthForm",""),this.SetCookie("loginPassword",""),this.SetCookie("loginSessionKey",""),this.options.SessionKey=null,this.options.UserKey=null,this.options.UserName="",this.options.toolBar.userNameButton.style.display="none",this.options.toolBar.loginButton.style.display="",this.options.licenseKey=null,Stimulsoft.Base.StiLicense.licenseKey=null,this.RemoveLicenseKey(),this.RemoveAccountSettings(),this.CheckActivation()},StiJsDesigner.prototype.GetThemeName=function(A,e){return A+e},StiJsDesigner.prototype.SetTheme=function(A){if(!A.Theme||!A.Style)return;this.options.themeIdent=A.Theme,this.options.themeStyle=A.Style;var e=this.GetThemeName(A.Theme,A.Style),t=this,s="Office2013."+e.substring("Office2013".length),n=document.getElementById("stidesigner_stylesheet");n&&n.setAttribute("href","styles/Stimulsoft.Designer."+s+".css");var o=document.getElementById("stidesignerruntime_stylesheet");o&&o.setAttribute("href","styles/Stimulsoft.Designer.runtime."+s+".css");var i=document.getElementById("stiviewer_stylesheet");i&&i.setAttribute("href","styles/Stimulsoft.Viewer."+s+".css"),$(this).trigger("eventTheme")},StiJsDesigner.prototype.UpdateUserNameButton=function(A){var e=this.getUserImage(A,!0),t=this.getUserImage(A,!1);$(this.options.userImgSmall).replaceWith(e),this.options.userImgSmall=e,$(this.options.userMenu.items.userInfo.img).replaceWith(t),this.options.userMenu.items.userInfo.img=t;var s=A.FirstName&&A.FirstName.length>0?A.FirstName:"",n=A.LastName&&A.LastName.length>0?A.LastName:"";this.options.userMenu.items.userInfo.userName.innerHTML="<div style='font-weight:bold;font-size:17px;padding-bottom:5px'>"+s+" "+n+"</div>"+A.UserName,this.options.toolBar.userNameButton.nameCell.innerHTML=A.FirstName&&A.LastName?A.FirstName+" "+A.LastName:A.UserName,this.options.toolBar.userNameButton.userImageCell.innerHTML="";var o=this.getUserImage(A,!1);o&&(o.className="stiCloudReportsToolbarUserImage",this.options.toolBar.userNameButton.userImageCell.appendChild(o))},StiJsDesigner.prototype.setUserInfo=function(A){var e=this,t={Commands:[],ResultSuccess:!0};t.Commands.push({Ident:"UserGet",UserKey:this.options.UserKey}),t.Commands.push({Ident:"RoleDefault"}),t.Commands.push({Ident:"WorkspaceGet"}),t.Commands.push({Ident:"LicenseGet"}),this.SendCommand("CommandListRun",t,function(A){var t=A.ResultCommands[0];e.options.roles={},e.options.roles.permissions=A.ResultCommands[1],e.options.user=t.ResultUser,e.options.UserName=t.ResultUser.UserName,e.options.workspace=A.ResultCommands[2],e.UpdateUserNameButton(t.ResultUser),e.SaveAccountSettings(t.ResultUser),e.StartNewSession()},null,A)},StiJsDesigner.prototype.getUserImage=function(A,e){var t;if(A.Picture)t=$("<img style='max-width:28px;max-height:28px;' src='data:image/jpeg;base64, "+A.Picture+"'/>")[0];else{var s=this.getUserImgColor(A.Key),n=this.getUserSign(A);t=e?$("<div style='line-height:1.5;width:28px;height:28px;text-align:center;color:white;font-family:Arial;font-size:14px;overflow:hidden;background-color:"+s+"'><div style='margin-top: 7px;'>"+n+"</div></div>")[0]:$("<div style='width:28px;height:28px;text-align:center;color:white;font-family:Arial;font-size:15px;overflow:hidden;background-color:"+s+"'><div style='margin-top: 7px;'>"+n+"</div></div>")[0]}return t},StiJsDesigner.prototype.getUserSign=function(A){var e="";return null!=A.FirstName&&""!=A.FirstName&&(e+=A.FirstName.substring(0,1)),null!=A.LastName&&""!=A.LastName&&(e+=A.LastName.substring(0,1)),0==e.length&&(e=A.UserName.substring(0,1)),e},StiJsDesigner.prototype.getUserImgColor=function(A){for(var e=0,t=0,s=0,n=0;n<A.length/3;n+=3)e+=A.charCodeAt(n),t+=A.charCodeAt(n+1),s+=A.charCodeAt(n+2);return e=e%100+100,t=t%100+100,s=s%100+100,this.rgb(e,t,s)},StiJsDesigner.prototype.dec2hex=function(A){return A>15?A.toString(16):"0"+A.toString(16)},StiJsDesigner.prototype.rgb=function(A,e,t){return"#"+this.dec2hex(A)+this.dec2hex(e)+this.dec2hex(t)},StiJsDesigner.prototype.ChangeVisibleStateAllPanels=function(A){this.options.viewerContainer&&this.options.viewerContainer.changeVisibleState(!!this.options.previewMode&&A),this.options.toolBar.changeVisibleState(A),this.options.workPanel.changeVisibleState(!!this.options.workPanel.visibleState&&A),this.options.statusPanel.changeVisibleState(A),this.options.pagesPanel.changeVisibleState(!this.options.previewMode&&A),this.options.paintPanel.changeVisibleState(A),this.options.showPanelPropertiesAndDictionary&&(this.options.propertiesPanel.changeVisibleState(!this.options.propertiesPanel.fixedViewMode&&A),this.options.propertiesPanel.showButtonsPanel.changeVisibleState(!!this.options.propertiesPanel.fixedViewMode&&!!A)),this.options.menus.fileMenu&&(this.options.menus.fileMenu.style.display=A&&this.options.menus.fileMenu.visible?"":"none"),this.options.newReportPanel&&(this.options.newReportPanel.style.display=A&&this.options.menus.fileMenu.visible?"":"none"),this.options.toolbox&&this.options.showToolbox&&this.options.toolbox.changeVisibleState(A)},StiJsDesigner.prototype.GetThemeBackgroundItems=function(){var A=[];return A.push({name:"Office2013White",color:"white"}),A.push({name:"Office2013LightGray",color:"#f6f6f6"}),A.push({name:"Office2013DarkGray",color:"#e5e5e5"}),A.push({name:"Office2013VeryDarkGray",color:"#6a6a6a"}),A},StiJsDesigner.prototype.GetThemeForegroundItems=function(){var A=[];return A.push({name:"Blue",color:"#2b579a"}),A.push({name:"Carmine",color:"#a4373a"}),A.push({name:"Green",color:"#207245"}),A.push({name:"Orange",color:"#d14625"}),A.push({name:"Purple",color:"#8653a5"}),A.push({name:"Teal",color:"#077568"}),A.push({name:"Violet",color:"#6d3069"}),A},StiJsDesigner.prototype.getSelectedButton=function(A){for(var e in this.options.buttons)if(this.options.buttons[e].groupName==A&&this.options.buttons[e].isSelected)return this.options.buttons[e]},StiJsDesigner.prototype.JSONDateFormatToDate=function(A,e){if("/Date("==A.substring(0,6)){var t=A.replace("/Date(","").replace(")/","");return"boolean"==typeof e?this.formatDate(new Date(parseInt(t)),this.options.STI_DATE_TIME_FORMAT):e?this.formatDate(new Date(parseInt(t)),e):new Date(parseInt(t))}return A},StiJsDesigner.prototype.DateToJSONDateFormat=function(A){var e=-1*A.getTimezoneOffset();return hoursOffset=Math.abs(parseInt(e/60)),minutesOffset=Math.abs(e%60),1==hoursOffset.toString().length&&(hoursOffset="0"+hoursOffset),1==minutesOffset.toString().length&&(minutesOffset="0"+minutesOffset),"/Date("+Date.parse(A).toString()+")/"},StiJsDesigner.prototype.formatDate=function(A,e){var t=A.getFullYear(),s=t.toString().substring(2),n=A.getMonth()+1,o=n<10?"0"+n:n,i=A.getDate(),r=i<10?"0"+i:i,a=A.getHours(),l=a<10?"0"+a:a,p=A.getMinutes(),u=p<10?"0"+p:p,c=A.getSeconds(),d=c<10?"0"+c:c;return e=e.replace(/yyyy/i,t),e=e.replace(/yy/i,s),e=e.replace(/mm/i,o),e=e.replace(/m/i,n),e=e.replace(/dd/i,r),e=e.replace(/d/i,i),e=e.replace(/hh/i,l),e=e.replace(/h/i,a),e=e.replace(/nn/i,u),e=e.replace(/n/i,p),e=e.replace(/ss/i,d),e=e.replace(/s/i,c)},StiJsDesigner.prototype.plainOpenFile=function(A,e){var t=$("<form method='post' enctype='multipart/form-data' runat='server' style='display:none; width:0px;height:0px'>"+"<br><input type='submit'>"+"</form>")[0],s=this.generateKey(),n=$("<iframe id='"+s+"' name='"+s+"' src='' style='width:0;height:0;border:0px'></iframe>");t.appendChild(n[0]),t.targetFrame=n[0];var o=$("<INPUT type='file' name='file'>");t.appendChild(o[0]);var i=$("<INPUT name='param'>");t.appendChild(i[0]),t.param=i,t.onsubmit=function(){t.target=s},A.appendChild(t),t.key=this.generateKey(),o.change(function(A){if(o[0].files)e(o[0].files,o[0]);else{var t=o[0].value;while(t.indexOf("\\")>=0)t=t.substring(t.indexOf("\\")+1);e([{name:t,size:1}],o[0])}}),o.click()},StiJsDesigner.prototype.formUpload=function(form,onUploaded,command){var this_=this,checkResult=function(){var cd=form.targetFrame.contentDocument,res="";if(cd&&cd.childNodes&&cd.childNodes[0]&&cd.childNodes[0].childNodes&&cd.childNodes[0].childNodes[1]?res=cd.childNodes[0].childNodes[1].innerHTML:cd&&cd.childNodes&&cd.childNodes[1]&&(res=cd.childNodes[1].innerText),""!=(res=res.replace(/(<|<\/)pre([^>]*)>/g,""))){try{res=eval("("+res+")")}catch(A){}var result=this_.options.controller.formatResultMsg(res);""!=result&&(command&&command.failure?command.failure(res,result,command.obj):this_.options.forms.messageForm.show("Error",result))}return res};form.targetFrame.addEventListener?form.targetFrame.addEventListener("load",function(arguments){onUploaded(arguments,checkResult())},!1):form.targetFrame.attachEvent("onload",function(arguments){onUploaded(arguments,checkResult())}),form.onsubmit(),form.submit()},StiJsDesigner.prototype.convertToMB=function(A){return this.round(A/1024/1024,3)},StiJsDesigner.prototype.round=function(A,e){return e=e||0,Math.round(A*Math.pow(10,e))/Math.pow(10,e)},StiJsDesigner.prototype.ActionImportFile=function(A){if(!this.options.SessionKey){return void(this.options.forms.errorMessageForm||this.InitializeErrorMessageForm()).show("Please login to your account to continue!",!0)}var e=this,t="",s={Ident:"ReportImport",SessionKey:this.options.SessionKey,ReportFormat:A};switch(A){case"ActiveReports":t=".rpx";break;case"ComponentOneReports":t=".xml";break;case"CrystalReports":t=".rpt";break;case"FastReports":t=".frx";break;case"ReportSharpShooter":t=".rst";break;case"RichText":t=".rtf";break;case"ReportingServices":t=".rdlc";break;case"TelerikReports":t=".trdx";break;case"VisualFoxPro":var n=e.OpenFormForVisualFoxPro();return n.changeVisibleState(!0),void(n.action=function(){s.InputReport=this.InputReport,s.InputMemo=this.InputMemo,(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){e.GetImportReportResult(s,n.fileName),n.changeVisibleState(!1)},200)})}this.InitializeOpenDialog("importReport",function(A){for(var t=A.target.files,n=t[0]?t[0].name:"Report",o=0,i;i=t[o];o++){var r=new FileReader;r.onload=function(A){return function(A){e.ResetOpenDialogs(),s.InputReport=A.target.result.substring(A.target.result.indexOf("base64,")+"base64,".length),n.lastIndexOf(".")>0&&(n=n.substring(0,n.lastIndexOf("."))),e.GetImportReportResult(s,n)}}(i),r.readAsDataURL(i)}},t),this.options.openDialogs.importReport.action()},StiJsDesigner.prototype.GetImportReportResult=function(A,e){var t=this,s=this.options.processImage||this.InitializeProcessImage();s.show(),this.SendCommand("ReportImport",A,function(A){if(A.ResultReport)if(null!=t.options.report&&t.options.reportIsModified){var n=t.options.forms.messageForm||t.MessageFormForSave();n.changeVisibleState(!0),n.action=function(s){s?t.ActionSaveReport(function(){t.OpenReport(e,"base64,"+A.ResultReport)}):t.OpenReport(e,"base64,"+A.ResultReport)}}else t.OpenReport(e,"base64,"+A.ResultReport);else if(A.ResultUrl)try{var o=gui.Window.open(A.ResultUrl,{position:"center",width:1e3,height:800})}catch(e){window.open(A.ResultUrl)}if(A.ResultMessages){var i="";for(var r in A.ResultMessages)i+=A.ResultMessages[r]+"\r\n";(t.options.forms.errorMessageForm||t.InitializeErrorMessageForm()).show(i,!0)}s.hide()},function(A,e){s.hide(),(t.options.forms.errorMessageForm||t.InitializeErrorMessageForm()).show(t.options.controller.formatResultMsg(A)||"Unknown error")})},StiJsDesigner.prototype.InitializeVisibleOpenDialog=function(A,e){var t=document.createElement("input");return t.jsObject=this,t.className=this.options.isTouchDevice?"stiDesignerTextBox_Touch":"stiDesignerTextBox_Mouse",t.style.border="0px",t.setAttribute("type","file"),t.setAttribute("name","files[]"),t.setAttribute("multiple",""),e&&t.setAttribute("accept",e),t.addEventListener("change",function(e){for(var s=e.target.files,n=s[0]?s[0].name:"Report",o=0,i;i=s[o];o++){var r=new FileReader;r.onload=function(e){return function(e){t.reset(),n.lastIndexOf(".")>0&&(n=n.substring(0,n.lastIndexOf(".")));var s=e.target.result.substring(e.target.result.indexOf("base64,")+"base64,".length);A(n,s)}}(i),r.readAsDataURL(i)}}),t.action=function(){this.style.display="",this.focus(),this.click(),this.style.display="none"},t.reset=function(){t.setAttribute("name","files[]"),t.setAttribute("multiple",""),t.setAttribute("value","")},t},StiJsDesigner.prototype.OpenFormForVisualFoxPro=function(){var A=this.BaseForm("openFormForVisualFoxPro",this.loc.MainMenu.menuFileOpen.replace("&","").replace("...",""),2),e=this.CreateHTMLTable();e.style.margin="8px 0 8px 0",A.container.appendChild(e),A.buttonOk.setEnabled(!1),e.addTextCell("Memo file:").className="stiDesignerCaptionControlsBigIntervals";var t=this.InitializeVisibleOpenDialog(function(e,t){A.InputMemo=t,A.buttonOk.setEnabled(A.InputMemo&&A.InputReport)},".frt");e.addCellInLastRow(t).className="stiDesignerControlCellsBigIntervals",e.addTextCellInNextRow("Report file:").className="stiDesignerCaptionControlsBigIntervals";var s=this.InitializeVisibleOpenDialog(function(e,t){A.InputReport=t,A.fileName=e,A.buttonOk.setEnabled(A.InputMemo&&A.InputReport)},".frx");return e.addCellInLastRow(s).className="stiDesignerControlCellsBigIntervals",A},StiJsDesigner.prototype.BaseFormPanel2=function(A,e,t,s){var n=this.BaseForm(null,s,1,!1,!1);n.buttonOk.parentNode.removeChild(n.buttonOk),n.buttonCancel.parentNode.removeChild(n.buttonCancel),t||(t="max-height"),n.rhomb=$("<div class='stiCloudReportsWebClientFormArrow'></div>")[0],n.appendChild(n.rhomb),this.options.paintPanel.appendChild(n),n.formButtons={},n.wizardButtons=[],n.style.display="none",n.id=n.name,n.visible=!1,n.isEnabled=!0,n.className="stiCloudReportsWebClientFormPanel",n.disabledPanel=document.createElement("div"),n.disabledPanel.className="stiCloudReportsWebClientFormPanelDisabled",n.header.className="stiCloudReportsFormHeader",n.topSeparator=$("<div class='stiCloudReportsWebClientFormSeparator'></div>")[0],$(n.container).before($(n.topSeparator)),n.caption.style.padding="13px 10px 10px 8px",n.autoHeight=t,t&&$(window).resize(function(){n.updateHeight()}),null!=arguments[0]&&(n.caption.innerHTML="");for(var o in arguments){if(o>1)continue;for(var i in arguments[o]){if(0==arguments[o][i][0].indexOf("separator")||0==o&&i>0){var r=this.HeaderFormButtonsSeparator();if(0!=o){n.buttonsTable.addCell(r),n.formButtons[arguments[o][i][0]]=r;continue}n.caption.appendChild(r),n.formButtons["separator"+i]=r}var a=null;0==o?(a=this.HeaderButton(arguments[o][i][0],arguments[o][i][1]),n.caption.appendChild(a),arguments[o][i].length>2&&(a.helpUrlKey=arguments[o][i][2])):(a=this.FormButton(null,arguments[o][i][0],arguments[o][i][1]),arguments[o][i][2]&&"left"==arguments[o][i][2]?(n.leftPanel||(n.leftPanel=$("<div style='float:left;padding: 3px'>")[0],$(n.floatPanel).prepend(n.leftPanel)),n.leftPanel.appendChild(a)):n.buttonsTable.addCell(a),a.style.margin="5px"),0==o?n.wizardButtons.push(a):n.formButtons[a.name]=a}}return n.formButtons.ok&&(n.formButtons.ok.action=function(){n.action()}),n.formButtons.cancel&&(n.formButtons.cancel.action=function(){n.changeVisibleState(!1),n.oncancel()}),n.getDownFormPanel=function(A){var A=A||n.jsObject.options.paintPanel.getFormPanels(),e=null;for(var t in A){if(A[t]==n)return e;e=A[t]}return e},n.updateHeight=function(){this.autoHeight&&$(n.container).css(this.autoHeight,$(n.jsObject.options.paintPanel).height()-$(n.header).height()-$(n.buttonsPanel).height()-25+"px")},n.changeVisibleState=function(A,e,t){A&&n.jsObject.options.currentTree==n.jsObject.options.mainTree&&n.jsObject.options.treePanel.minimize();var s=n.jsObject.options.paintPanel.getFormPanels(),o=n.getDownFormPanel(s),i=this.jsObject.options.treePanel.offsetWidth||this.jsObject.options.usersContainer.offsetWidth||this.jsObject.options.systemContainer.offsetWidth,r=A?n.minLeft+i:$(n).position().left+200,a=A?350:150,l=A?1:0;if(A){n.jsObject.options.infoPanel.hide(),n.style.left=i+200+"px",n.style.top=n.minTop+"px",n.style.display="",n.style.opacity=0,n.onshow(),n.controls&&n.controls.labelName&&n.controls.labelName.focus(),n.container.style.top=n.header.offsetHeight+"px",n.updateHeight(),o&&o.setEnabled(!1);var p=function(){n.visible=!0}}else{if(!n.visible)return;n.visible=!1,o&&o.setEnabled(!0);var p=function(){if(n.onhide(e),this.jsObject.options.paintPanel.removeChild(n),0==n.jsObject.options.paintPanel.getFormPanels().length&&this.jsObject.options.currentTree){var A=n.jsObject.options.currentTree.getSelectedItem();A&&A.setSelected(null,!0),n.jsObject.options.currentTree==n.jsObject.options.mainTree&&n.jsObject.options.treePanel.maximize()}}}t||$(n).animate({left:r,opacity:l},{complete:p,duration:a})},n.focusForm=function(){var A=this.style.left,e=this.style.top;this.changeVisibleState(!0,null,!0),this.style.opacity=1,this.style.left=A,this.style.top=e,this.setEnabled(!0);var t=this.parentNode;t?(t.removeChild(this),t.appendChild(this)):(this.jsObject.options.paintPanel.appendChild(this),this.changeVisibleState(!0))},n.changeVisibleStateHeaderAndStatusBar=function(A){this.header.style.visibility=A?"visible":"hidden",this.container.style.visibility=A?"visible":"hidden"},n.setEnabled=function(A){this.isEnabled!=A&&(this.isEnabled=A,A?this.removeChild(this.disabledPanel):(this.disabledPanel.style.width=this.offsetWidth-2+"px",this.disabledPanel.style.height=$(this).height()+"px",this.disabledPanel.style.top=0,this.appendChild(this.disabledPanel)))},n.action=function(){},n.onshow=function(){},n.onhide=function(){},n.oncancel=function(){},n.onkeyup=function(A){A&&27==A.keyCode&&(n.changeVisibleState(!1),n.oncancel())},n},StiJsDesigner.prototype.BaseFormPanelForEditItems=function(A,e,t,s){var n=this.BaseFormPanel2(A,e,t,s);n.controls={},n.mode="create",n.addControlRow=function(A,e,t,s,n,o,i,r){if(this.controls[t]=s,this.controls[t+"Row"]=A.addRow(),null!=e){var a=A.addCellInLastRow();this.controls[t+"Text"]=a,a.innerHTML=e,a.className=o||this.textClass||"stiCloudReportsWebClientTextBeforeControl",(i||r)&&this.jsObject.appendTooltipInfo(a,null,i,this.jsObject,null,r)}if(s){s.form=this,s.style.margin=n;var l=A.addCellInLastRow(s);null==e&&l.setAttribute("colspan",2)}return l},n.superhide=function(){},n.onhide=function(){var A=[];for(var e in this.jsObject.options.containers)0==e.indexOf(this.name)&&delete this.jsObject.options.containers[e];n.superhide()};var o=this.CreateHTMLTable();n.controls.labelsTable=o,n.container.appendChild(o);var i=[["labelName",this.loc.Common.LabelName,250],["labelDescription",this.loc.Common.LabelDescription,420]];for(var r in i){var a=this.TextBox(null,i[r][2]);n.addControlRow(o,i[r][1],i[r][0],a,"4px 0px 4px 30px")}return n.sendCommand=function(A){var e={};e.Items=[n[A]],e.AllowSignalsReturn=!0,"create"==n.mode&&(e.Items[0].Key=n.jsObject.generateKey(),n.folderKey&&(e.Items[0].FolderKey=n.folderKey)),n.jsObject.options.mainTree.wasClicked=!1,n.changeVisibleState(!1),n.jsObject.SendCommand("ItemSave",e,function(A){n.jsObject.options.controller.processSignals(A)})},n.checkNameField=function(){if(n.controls.labelName&&!n.controls.labelName.checkEmpty(n.jsObject.loc.Messages.ThisFieldIsNotSpecified))return!1;return!0},n},StiJsDesigner.prototype.EasyBaseFormPanel=function(A,e,t){var s=[["ok",this.loc.Common.ButtonOK],["cancel",this.loc.Common.ButtonCancel]];return this.BaseFormPanelForEditItems(e,s,A,t)},StiJsDesigner.prototype.MultiWizardBaseFormPanel=function(A,e,t){var s=[["ok",this.loc.Common.ButtonOK],["cancel",this.loc.Common.ButtonCancel]],n=this.BaseFormPanelForEditItems(A,t||s,e);n.container.removeChild(n.controls.labelsTable),n.currentPanelIndex=0,n.wizardPanels={};for(var o in n.wizardButtons){var i=n.wizardButtons[o];i.action=function(){n.showPanel(this.name)};var r=document.createElement("div");r.wizardButton=i,r.name=i.name,n.wizardPanels[i.name]=r,n.container.appendChild(r)}return n.showPanel=function(A){for(var e in this.wizardButtons){var t=this.wizardButtons[e];t.isEnabled&&t.setSelected(A==t.name),this.wizardPanels[t.name].style.display=A==t.name?"":"none",A==t.name&&(this.wizardPanels[t.name].onshow&&this.wizardPanels[t.name].onshow(),this.currentPanelIndex=parseInt(e),t.helpUrlKey&&(n.helpUrlKey=t.helpUrlKey))}this.updateHeaderControls()},n.updateHeaderControls=function(){this.wizardButtons[0].style.display="edit"==this.mode?"none":"","edit"==this.mode&&this.formButtons.separator1&&(this.formButtons.separator1.style.display="none"),this.formButtons.ok&&this.formButtons.ok.setEnabled("startWizard"!=this.mode)},n.showControlsByMode=function(A){for(this.mode=A,o=1;o<this.wizardButtons.length;o++)this.wizardButtons[o].setEnabled("startWizard"!=this.mode);this.showPanel(this.wizardButtons["startWizard"==A?0:1].name)},n},StiJsDesigner.prototype.SimpleWizardBaseFormPanel=function(A){var e=[["back",this.loc.Common.ButtonBack,"left"],["ok",this.loc.Common.ButtonOK],["cancel",this.loc.Common.ButtonCancel]],t=this.BaseFormPanelForEditItems(null,e,A);return t.onshow=function(){t.formButtons.back.style.display="edit"==t.mode?"none":""},t},StiJsDesigner.prototype.InitializeChangePasswordForm=function(){var A=this.BaseForm("changePasswordForm",this.loc.Navigator.ButtonChangePassword,3,null,!0),e=this;A.caption.style.padding="0 10px 0 15px",A.container.style.padding="7px";var t=[["currentPassword",this.loc.Administration.LabelCurrentPassword,250],["newPassword",this.loc.Administration.LabelNewPassword,250]];for(var s in t){var n=this.TextBox(null,t[s][2]);n.setAttribute("type","password"),A.addControlRow(t[s][1],t[s][0],n,"4px 4px 4px 30px")}this.options.changePasswordForm=A,A.show=function(){A.buttonSave.setEnabled(!0),this.changeVisibleState(!0),A.controls.currentPassword.value="",A.controls.newPassword.value="",A.controls.currentPassword.focus()},A.action=function(){if(A.controls.currentPassword.checkEmpty(e.loc.Notices.AuthPasswordIsNotSpecified)&&A.controls.newPassword.checkEmpty(e.loc.Notices.AuthPasswordIsNotSpecified)&&A.controls.newPassword.checkLength(6,e.loc.Notices.AuthPasswordIsTooShort)){var t={};A.buttonSave.setEnabled(!1),e.SendCommand("UserChangePassword",{CurrentPassword:A.controls.currentPassword.value,NewPassword:A.controls.newPassword.value},function(){A.changeVisibleState(!1)},function(t,s){A.buttonSave.setEnabled(!0),e.ShowMessagesTooltip(s,A.controls.currentPassword)})}}},StiJsDesigner.prototype.ColorButton=function(A,e,t,s,n){var o=$("<div class='stiColorButton' style='background-color:"+A+"'><div class='stiColorButtonIn'></div></div>")[0];return o.jsObject=this,o.name=null!=e?e:this.generateKey(),o.id=o.name,null!=e&&(this.options.buttons[e]=o),o.groupName=t,o.isSelected=!1,o.action=n,o.value=s,o.options=this.options,o.color=A,o.onclick=function(){if(o.groupName)for(var A in this.options.buttons)this.options.buttons[A].groupName==o.groupName&&this.options.buttons[A].setSelected(!1);this.setSelected(!0),this.action&&this.action()},o.setSelected=function(A){o.isSelected=A,o.style.borderColor=A?"#f29436":"",o.firstChild.style.border=A?"1px solid #ffe294":""},o},StiJsDesigner.prototype.EditUserPictureControl=function(){var A=document.createElement("table");A.jsObject=this,A.imgSource=$("<div style='width:100px;height:100px;border:dashed 1px #ababab;background-color:#f6f6f6' class='stiTextStyle'>")[0];var e=A.appendChild(document.createElement("tr")),t=e.appendChild(document.createElement("td"));t.appendChild(A.imgSource),A.noImage=$("<div style='text-align:center;padding-top:40px'>100 x 100</div>")[0],A.imgSource.appendChild(A.noImage),A.image=$("<img style='max-width: 100px; max-height:100px'/>")[0],t=e.appendChild($("<td style='vertical-align:top'></td>")[0]);var s=this.SmallButton(null,null,null,"Open.png",this.loc.MainMenu.menuFileOpen.replace("&","").replace("...",""),null,this.GetStyles("SmallButtonWithBorders"));t.appendChild(s);var n=this.SmallButton(null,null,null,"Remove.png",this.loc.MainMenu.menuEditDelete.replace("&",""),null,this.GetStyles("SmallButtonWithBorders"));t.appendChild(n),n.style.marginTop="2px",n.setEnabled(!1);var o=this;return n.action=function(){A.setImage("")},s.action=function(){var e=this.jsObject;if(e.options.canOpenFiles){e.InitializeOpenDialog("userPictureImageDialog",function(t){var s=t.target.files;if(s[0].size>e.options.maxUploadFileSize){var n=e.loc.File.MessageFailedAddFollowingFiles.replace("{0}",e.convertToMB(e.options.maxUploadFileSize));return void(e.options.forms.errorMessageForm||e.InitializeErrorMessageForm()).show(n)}for(var o=0,i;i=s[o];o++){var r=new FileReader;r.onload=function(t){return function(t){e.ResetOpenDialogs(),A.setImage(t.target.result.substring(t.target.result.indexOf("base64,")+7))}}(i),r.readAsDataURL(i)}},".bmp,.gif,.jpeg,.jpg,.png,.tiff,.ico,.emf,.wmf").action()}},A.setImage=function(e){null!=A.noImage.parentElement&&A.noImage.parentElement.removeChild(A.noImage),null!=A.image.parentElement&&A.image.parentElement.removeChild(A.image),A.img=e,e&&""!=e?(A.imgSource.style.borderStyle="none",A.image.src="data:image/png;base64, "+e,A.imgSource.appendChild(A.image),n.setEnabled(!0)):(A.imgSource.style.borderStyle="dashed",A.imgSource.appendChild(A.noImage),n.setEnabled(!1)),A.action()},A.action=function(){},A},StiJsDesigner.prototype.HeaderButton=function(A,e,t){var s=this.SmallButton(A,null,e,null,null,null,this.GetStyles("HeaderButton"));return null!=t&&(s.style.height=this.options.isTouchDevice?t+5+"px":t+"px"),s},StiJsDesigner.prototype.HeaderFormButtonsSeparator=function(){var A=document.createElement("div");return A.className="stiCloudReportsWebClientHeaderFormButtonsSeparator",A},StiJsDesigner.prototype.HiperLinkButton=function(A,e,t){var s=this.SmallButton(A,null,e,null,null,null,this.GetStyles("AuthHyperlinkButton"));return null!=t&&(s.style.height=this.options.isTouchDevice?t+5+"px":t+"px"),s.caption.style.padding="",s},StiJsDesigner.prototype.HiperLinkButtonForAuthForm=function(A,e,t){var s=this.SmallButton(A,null,e,null,null,null,this.GetStyles("AuthHyperlinkButton"));return s.style.maxWidth="300px",s.caption&&(s.caption.style.padding="",s.caption.style.whiteSpace=t?"nowrap":"normal"),s},StiJsDesigner.prototype.InitializeLicenseForm=function(A){var e=this.BaseForm(null,this.loc.License.WindowTitleLicense,3,null,!0,!0),t=$("<div style='width: 76px; height: 76px; overflow: hidden; margin-left: 312px; margin-top: 162px;'></div>")[0],s=document.createElement("div");return s.className="client_navigator_loader",t.appendChild(s),e.container.appendChild(t),e.container.style.width="700px",e.container.style.maxHeight="400px",e.container.style.height="400px",e.container.style.textAlign="justify",e.container.style.overflow="auto",e.container.style.padding="10px",e.header.style.fontSize="15px",e.container.parentElement.insertBefore(this.FormSeparator(),e.container),e.buttonSave.caption.innerHTML=this.loc.Update.ButtonIAgree,e.buttonSave.setEnabled(!1),e.buttonSave.action=function(){e.changeVisibleState(!1),A&&A.update()},this.SendCommand("SoftwareGetLicense",{Type:"Developer"},function(A){A.ResultLicense&&(e.container.innerHTML=StiBase64.decode(A.ResultLicense),e.buttonSave.setEnabled(!0))}),e.changeVisibleState(!0),e},StiJsDesigner.prototype.InitMessagesTooltip=function(){var A=this.options;$(window).mouseup(function(){if(A.messagesTooltip)try{A.messagesTooltip.close()}catch(A){console.log(A)}}),$(window).keydown(function(){if(A.messagesTooltip)try{A.messagesTooltip.close()}catch(A){console.log(A)}})},StiJsDesigner.prototype.ShowMessagesTooltip=function(A,e,t){if(null!=this.options.messagesTooltip)try{$(this.options.messagesTooltip).remove()}catch(A){console.log(A)}return this.options.messagesTooltip=this.createMessageTooltip(A,e,t,!0,!0),this.options.messagesTooltip},StiJsDesigner.prototype.createMessageTooltip=function(A,e,t,s,n){var o=A&&"string"!=typeof A?A.text:A,i=A.type||"Error",r=A.arrowSide||"Left",a=A.tooltipSide||r,l={},p=$("<div class='stiMessagesTooltip sti"+i+"MessagesTooltip'></div>").appendTo(s&&n?"body":$(this.options.paintPanel)).css({opacity:0}),u=this.CreateHTMLTable();p.append(u),p.append("<div class='stiMessagesTooltipArrow stiMessagesTooltipArrow"+r+" sti"+i+"MessagesTooltipArrow'></div>"),p.hideFunc=t;var c=$("<img style='margin: 10px;' src='"+this.options.images["Message"+i+".png"]+"'></img>"),d=s||n?"0px 25px 10px 0px":"5px 15px 7px 15px",g=$("<div style='padding: "+d+"; max-width: 300px;min-height:24px;pointer-events: none;'>"+o+"</div>")[0],h=this.CreateHTMLTable(),m=$("<img src='"+this.options.images["CloseFormWhite.png"]+"' style='padding:2px 0 1px;'>");m.mouseover(function(){m.css("background-color","#ee8080")}).mousedown(function(){m.css("background-color","#f1e1e1")}).mouseout(function(){m.css("background-color","#ff0000")}).click(function(){p.close()}),s&&h.addCell(m[0],null,"height:17px;float:right"),h.addCellInNextRow(g),n&&u.addCell(c[0]),u.addCell(h);var f;f="Left"==a?$(e).offset().left+$(e).width()+15:"Right"==a?$(e).offset().left-p.width()-30:$(e).offset().left+($(e).width()/2-p.width()/2)+2;var v;return s&&n?v="Bottom"==a?$(e).offset().top-p.height()-20:"Top"==a?$(e).offset().top+$(e).height()+20:$(e).offset().top+($(e).height()/2-p.height()/2):(f="-9999px",v="Bottom"==a?$(e).offset().top-p.height()-20:"Top"==a?(0==$(e).position().top?10:$(e).position().top)+$(e).height()+10:$(e).offset().top+($(e).height()/2-p.height()/2)),p.css({left:f,top:v-40}).animate({top:v,opacity:1},{duration:120}),p.close=function(){var A=p.hideFunc;$.when(p.fadeOut(200).remove()).then(function(){A&&A()})},p},StiJsDesigner.prototype.InitializeModificationsForm=function(){var A=this.BaseForm("modificationsForm",this.loc.Report.WhatsNewInVersion,4,null,!0);A.buttonCancel.style.display="none",A.container.style.padding="0px",A.container.style.width="600px",A.productsButtons={},A.modifications=null;var e=this,t=this.StandartSmallButton(null,null,null,"Update.BigSettings.png");t.style.margin="8px",t.style.width=t.style.height="32px",t.image.style.width=t.image.style.height="20px",t.innerTable.style.width="100%",t.setEnabled(!1),A.buttonsPanel.style.width="100%",A.buttonsPanel.firstChild.style.width="100%",A.buttonsPanel.firstChild.tr[0].insertCell(0).appendChild(t),A.buttonOk.parentElement.style.width="1px",A.buttonCancel.parentElement.style.width="1px",this.AddProgressToControl(A);var s=document.createElement("div");s.className="stiUpdateFormItemHeader",A.container.appendChild(s);var n=document.createElement("div");n.className="stiUpdateFormItemDate",A.container.appendChild(n);var o=document.createElement("div");o.style.marginBottom="15px",o.className="stiUpdateFormItemDescription",A.container.appendChild(o);var i=this.EasyContainer(600,400);i.className="stiModificationsFormContainer",A.container.appendChild(i),i.addHeader=function(A){var e=document.createElement("div");e.className="stiModificationsFormContainerHeaderItem",e.innerHTML=A,i.appendChild(e)},i.addItem=function(A,e){var t=document.createElement("div");t.className="stiModificationsFormContainerItem",t.style.borderLeft="2px solid "+e,t.innerHTML=A,i.appendChild(t)};var r=document.createElement("div");A.container.appendChild(r),r.style.display="none",r.style.height="50px",r.className="stiModificationsFormContainer";var a=this.CreateHTMLTable();a.style.margin="8px 0 0 6px",r.appendChild(a);var l=["Ultimate","Web","Net","Wpf","Js","Php","Java","Flex","Server"];a.addTextCell(this.loc.Cloud.Products+":").className="stiDesignerCaptionControls";for(var p=0;p<l.length;p++){var u=this.ModificationsFormProductsButton(l[p],"Update.Products."+l[p]+".png");u.style.marginRight="6px",a.addCell(u),A.productsButtons[l[p]]=u,u.setSelected(!0),u.action=function(){if(this.setSelected(!this.isSelected),"Ultimate"==this.productName)for(var e=1;e<l.length;e++)A.productsButtons[l[e]].setSelected(this.isSelected);else{for(var t=!0,e=1;e<l.length;e++)A.productsButtons[l[e]].isSelected||(t=!1);A.productsButtons.Ultimate.setSelected(t)}A.buildModificationsList()}}return r.getChoosedProducts=function(){for(var e=[],t=0;t<l.length;t++)A.productsButtons[l[t]]&&A.productsButtons[l[t]].isSelected&&e.push(l[t]);return e},t.action=function(){this.setSelected(!this.isSelected),r.style.display=this.isSelected?"":"none",i.style.height=this.isSelected?"349px":"400px"},A.show=function(i){this.changeVisibleState(!0),A.caption.innerHTML=e.loc.Report.WhatsNewInVersion.replace("{0}",i.Version),A.progress.show(),s.innerHTML="Stimulsoft Reports "+i.Version,n.innerHTML=e.JSONDateFormatToDate(i.Date,"dd.MM.yyyy"),o.innerHTML=i.Description,e.SendCommand("DeveloperBuildGetModifications",{BuildVersion:i.Version},function(e){A.progress.hide(),e.ResultModifications&&(t.setEnabled(!0),A.modifications=e.ResultModifications,A.buildModificationsList())},function(e,t){A.progress.hide()})},A.buildModificationsList=function(){i.clear();var t=r.getChoosedProducts();if(!A.modifications||0==t.length)return;for(var s={},n=function(A){for(var e=0;e<t.length;e++)if(A.indexOf(t[e])>=0)return!0;return!1},o=!0,a=0;a<A.modifications.length;a++){var l=A.modifications[a];s[l.Type]||(s[l.Type]=[]),n(l.Product)&&(s[l.Type].push(l.Description),o=!1)}if(o){var p=e.CreateHTMLTable();return p.className="stiUpdateFormEmptyItem",p.addTextCell(e.loc.Report.NoFixes).style.textAlign="center",p.style.width="100%",p.style.height="100%",void i.appendChild(p)}for(var u=[["Add",e.loc.Report.NewFeatures,"#fe8f00"],["Upd",e.loc.Report.Enhancements,"#b9b9b9"],["Fix",e.loc.Report.FixedBugs,"#5ca5ff"]],a=0;a<u.length;a++){var c=s[u[a][0]];if(c&&c.length>0){i.addHeader(u[a][1]);for(var d=0;d<c.length;d++)i.addItem(c[d],u[a][2])}}},A.action=function(){this.changeVisibleState(!1)},A},StiJsDesigner.prototype.ModificationsFormProductsButton=function(A,e){var t=this.StandartSmallButton(null,null,null,e);t.style.width=t.style.height="32px",t.image.style.width=t.image.style.height="25px",t.image.style.background="#2980b9",t.imageCell.style.padding="0",t.innerTable.style.width="100%",t.productName=A;var s=document.createElement("img");return s.style.position="absolute",s.style.display="none",s.style.margin="16px 0 0 -10px",s.src=this.options.images["Update.CircleCheckGreen.png"],t.imageCell.appendChild(s),t.setSelected=function(A){this.isSelected=A,s.style.display=A?"":"none"},t.onmouseenter=function(){if(!this.isEnabled||this.jsObject.options.isTouchClick)return;this.className=this.styles.over+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse"),this.isOver=!0},t.onmouseleave=function(){if(this.isOver=!1,!this.isEnabled)return;this.className=this.styles.default+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse")},t},StiJsDesigner.prototype.InitializeSettingsForm=function(){function A(A,e){function t(t,o,i,r){n.addRow();for(var a in i){n.addRow().style.height="32px";var l=n.addCellInLastRow();l.style.padding="7px 10px 7px 0px",l.innerHTML=i[a][1],s.labels[i[a][0]]=l;var p=r||i[a][3]?n.addCellInLastRow():e.TextBox(i[a][0],i[a][2]);s.controls[i[a][0]]=p,r?n.className="stiCloudReportsWebClientTextBeforeControl":(n.addCellInLastRow(p),p.oninput=function(){A.options.container.data[this.name]=this.value})}}var s=document.createElement("div");s.style.width="450px",s.style.minHeight="350px",s.style.position="relative",A.options={},A.options.container=s,s.jsObject=e,s.className="",s.controls={},s.labels={},e.AddProgressToControl(s);var n=e.CreateHTMLTable();s.appendChild(n),n.style.paddingTop="0px",n.style.marginTop="7px";var o=250;t(e.loc.Administration.TextUser,"textUser",[["FirstName",e.loc.Administration.LabelFirstName,o],["LastName",e.loc.Administration.LabelLastName,o],["UserName",e.loc.Administration.LabelUserName,o,!0]],!1,this),n.addRow();var i=n.addCellInLastRow();i.colSpan=2,i.appendChild(e.InfoPanelSeparator("-30px")),n.addRow();var r=n.addCellInLastRow();r.style.padding="10px 10px 10px 0px",r.innerHTML=e.loc.Administration.LabelPicture,s.labels.picture=r;var a=e.EditUserPictureControl();return a.style.margin="7px 0 7px 0",s.controls.userPicture=a,n.addCellInLastRow(a),n.className="stiDesignerTextContainer",A.options.container.data={},a.action=function(){a.img&&""!=a.img?A.options.container.data.Picture=a.img:delete A.options.container.data.Picture},s.populateFields=function(A,t){for(var s in A)s in t&&(t[s]instanceof HTMLInputElement?t[s].value=A[s]:t[s].innerHTML=e.JSONDateFormatToDate(A[s],!0))},s}var e=[["Profile",this.loc.Navigator.TextProfile]],t=this.MultiWizardBaseFormPanel(e,"max-height");this.options.mainPanel.appendChild(t),this.options.forms.settingsForm=t,t.className="stiCloudReportsWebClientForm",t.container.className="stiCloudReportsWebClientFormContainer",t.header.className="stiCloudReportsWebClientFormHeader",t.level=3,t.style.zIndex=10*t.level+1,t.container.style.padding="0px 10px 0px 10px",t.helpUrlKey="WindowOptions",t.rhomb.style.display="none";var s=A(t,this);t.wizardPanels.Profile.appendChild(s),t.showPanel("Profile");var n=this;return t.show=function(){t.populated||t.formButtons.ok.setEnabled(!1),this.changeVisibleState(!0),s.progress.show(),n.SendCommand("UserGet",{UserKey:n.options.UserKey},function(A){s.populateFields(A.ResultUser,s.controls),s.controls.userPicture.setImage(A.ResultUser.Picture),s.data=$.extend({},A.ResultUser),s.progress.hide(),t.formButtons.ok.setEnabled(!0),t.populated=!0})},t.changeVisibleState=function(A){if(A){this.style.display="",this.jsObject.options.disabledPanels[this.level].style.display="",this.onshow(),this.jsObject.SetObjectToCenter(this),this.visible=!0,this.jsObject.options.currentForm=this,d=new Date;var e=d.getTime()+this.jsObject.options.formAnimDuration;this.flag=!1,this.jsObject.ShowAnimationForm(this,e)}else clearTimeout(this.animationTimer),this.visible=!1,this.jsObject.options.currentForm=null,this.style.display="none",this.jsObject.options.disabledPanels[this.level].style.display="none",this.onhide()},t.action=function(){var A=t.options.container;("demo"==A.data.UserName||A.controls.FirstName.checkEmpty(this.jsObject.loc.Notices.AuthFirstNameIsNotSpecified,function(){t.showPanel("Profile")})&&A.controls.LastName.checkEmpty(this.jsObject.loc.Notices.AuthLastNameIsNotSpecified,function(){t.showPanel("Profile")}))&&(n.SendCommand("UserSave",{User:A.data},function(A){n.setUserInfo()}),t.changeVisibleState(!1))},t},StiJsDesigner.prototype.InfoPanelSeparator=function(A){var e=document.createElement("div");return e.className="stiCloudReportsWebClientInfoPanelSeparator",A&&(e.style.marginLeft=A,e.style.width="150%"),e},StiJsDesigner.prototype.InitializeSubscriptionsForm=function(){var A=this.BaseForm("subscriptionsForm",this.loc.Cloud.Subscriptions,3,null,!0);A.container.style.padding="0px",A.controls={};var e=550,t=document.createElement("div");t.innerHTML=this.loc.Cloud.LicenseInformation,t.className="stiBlockHeader",t.style.boxSizing="border-box",A.container.appendChild(t);var s=[["owner",this.loc.Cloud.TextOwner+":"],["userName",this.loc.Cloud.labelUserName]],n=this.CreateHTMLTable();n.style.margin="7px 0 7px 0",A.container.appendChild(n);for(var o=0;o<s.length;o++){var i=n.addTextCellInLastRow(s[o][1]);i.className="stiDesignerTextContainer",i.style.padding="7px 25px 7px 14px";var r=n.addCellInLastRow();r.className="stiDesignerTextContainer",A.controls[s[o][0]+"Cell"]=r,n.addRow()}var a=document.createElement("div");a.innerHTML=this.loc.Cloud.Products,a.className="stiBlockHeader",a.style.boxSizing="border-box",A.container.appendChild(a);var l=this.EasyContainer(e);return l.style.padding="4px 4px 0 4px",l.style.maxHeight="380px",A.container.appendChild(l),l.sortProducts=function(){if(l.childNodes.length<=1)return;for(var A=["Silverlight","NetCore","Flex","Php","Java","Js","Uwp","Wpf","Net","Web","Ultimate"],e=0;e<A.length;e++)for(var t=0;t<l.childNodes.length;t++)if(A[e]==l.childNodes[t].productName){l.insertBefore(l.childNodes[t],l.childNodes[0]);break}},l.addItem=function(A,e,t,s,n){var o=this.jsObject.StandartSmallButton(null,null,e,t);o.style.height="52px",o.style.marginBottom="4px",o.style.lineHeight="1.6 ",o.productName=A;var i=document.createElement("div");i.style.background=s||"#2980b9",i.style.margin="0 6px 0 4px",o.imageCell.appendChild(i),o.imageCell.style.padding="0",i.appendChild(o.image),o.image.style.width="32px",o.image.style.height="32px",o.image.style.margin="6px";var r=this.jsObject.StandartSmallButton(null,null,n?this.jsObject.loc.Cloud.ButtonPurchase:this.jsObject.loc.Cloud.ButtonRenew);r.isTrial=n,r.productName=A,o.innerTable.addCell().style.width="100%",o.innerTable.addCell(r).style.width="1px",r.style.margin="0 15px 0 0",r.style.background="#d7634a",r.style.color="#ffffff",r.style.display="none",r.caption&&(r.caption.style.padding="0 10px 0 10px"),o.onmouseenter=function(){if(!this.isEnabled||this.haveMenu&&this.isSelected||this.jsObject.options.isTouchClick)return;this.className=this.styles.over+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse"),this.isOver=!0,r.style.display=""},o.onmouseleave=function(){if(this.isOver=!1,!this.isEnabled)return;this.className=(this.isSelected?this.styles.selected:this.styles.default)+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse"),r.style.display="none"},r.onmouseenter=function(){r.style.background="#c4462b"},r.onmouseleave=function(){r.style.background="#d7634a"},r.onmousedown=function(A){r.style.background="#d7634a"},r.onmouseup=function(A){r.style.background="#c4462b"},r.action=function(){var A="Russian"==Stimulsoft.Base.Localization.StiLocalization.cultureName?"ru":"en",e=this.productName?this.productName.toLowerCase():"ultimate";"dbsweb"!=e&&"dbsweb"!=e&&"dbsweb"!=e||(e=e.replace("dbs","dashboards-"));var t=this.isTrial?"":"?type=renewal",s=this.jsObject.options.SessionKey?(this.isTrial?"?sessionKey=":"&sessionKey=")+this.jsObject.options.SessionKey:"",n=String.stiFormat("https://www.stimulsoft.com/{0}/online-store/purchase/{1}{2}{3}",A,e,t,s);this.jsObject.openNewWindow(n)},this.appendChild(o)},A.show=function(){A.buttonCancel.style.display="none",this.changeVisibleState(!0),l.clear();var e=Stimulsoft.Base.StiLicense.licenseKey;if(e){if(A.controls.ownerCell.innerHTML=e.owner,A.controls.userNameCell.innerHTML=e.userName,e.products&&e.products.length>0){for(var t=0;t<e.products.length;t++){var s=e.products[t].expirationDate.innerDate<new Date?"#fbd597":null,n=Stimulsoft.System.Enum.getName(Stimulsoft.Base.Licenses.StiProductIdent,e.products[t].ident),o="<font style='font-size: 15px'>"+this.jsObject.GetProductFullName(n)+"</font><br>"+this.jsObject.loc.Cloud.ExpiredDate+": "+e.products[t].expirationDate.innerDate.toLocaleDateString();l.addItem(n,o,"Products."+n+".png",s,!1)}this.jsObject.SetObjectToCenter(this)}else{var n="Ultimate",o="<font style='font-size: 15px'>"+this.jsObject.GetProductFullName(n)+"</font><br>"+"Trial";l.addItem("Ultimate",o,"Products.Ultimate.png","#d8d8d8",!0)}l.sortProducts()}},A.action=function(){this.changeVisibleState(!1)},A},StiJsDesigner.prototype.GetProductFullName=function(A){if("Js"!=A&&"Php"!=A||(A=A.toUpperCase()),"DbsJs"==A||"DbsWeb"==A||"DbsWin"==A)return"Stimulsoft Dashboards."+A.replace("Dbs","").toUpperCase();return"Stimulsoft Reports."+A},StiJsDesigner.prototype.TextBoxWithHintText=function(A,e,t,s,n){var o=this,i=this.CreateHTMLTable(),r=function(A){return o.options.images["LogIn."+o.options.themeStyle+"."+A]},a=this.TextBox(A,e,s);a.setAttribute("placeholder",t),a.style.backgroundColor="#f2f1f1",a.style.border="none",a.style.width="280px",a.style.height="30px";var l=$("<img src='"+r(n)+"' style='vertical-align: middle;opacity: 0.8'></img>")[0],p=i.addCell(l);return p.style.lineHeight="0",p.style.backgroundColor="#f2f1f1",p.fileName=n,p.style.width="30px",p.style.textAlign="center",i.addCell(a),a.table=i,a.onkeypress=function(A){if(this.readOnly)return!1;if(A&&13==A.keyCode)return this.blur(),this.readOnly||this.action(),!1},a.onblur=function(){this.isFocused=!1,this.setSelected(!1),this.jsObject.options.controlsIsFocused=!1},$(this).on("eventTheme",function(){l.src=r(p.fileName)}),a},StiJsDesigner.prototype.InitializeUpdateForm=function(){var A=this.BaseForm("updateForm",this.loc.Permissions.SystemUpdate,3,null,!0);A.buttonCancel.style.display="none",A.container.style.padding="0px",A.controls={},this.AddProgressToControl(A);var e=this.HiperLinkButton(null,this.loc.Report.WhatsNewInVersion,23);e.style.margin="8px",e.style.fontSize="12px",e.style.display="none",A.buttonsPanel.style.width="100%",A.buttonsPanel.firstChild.style.width="100%",A.buttonsPanel.firstChild.tr[0].insertCell(0).appendChild(e),A.buttonOk.parentElement.style.width="1px",A.buttonCancel.parentElement.style.width="1px";var t=this,s=this.EasyContainer(600,400);return A.container.appendChild(s),A.show=function(){this.changeVisibleState(!0),s.clear(),A.progress.show(),t.SendCommand("DeveloperBuildGet",{},function(n){A.progress.hide();var o=!0;if(n.ResultBuilds&&n.ResultBuilds.All&&n.ResultBuilds.All.length>0){for(var i=Stimulsoft.StiVersion.version,r=0;r<n.ResultBuilds.All.length;r++)if(i&&A.allowBuild(i,n.ResultBuilds.All[r].Version)&&(s.appendChild(t.UpdateFormItem(n.ResultBuilds.All[r])),o=!1),i==n.ResultBuilds.All[r].Version){e.style.display="",e.caption.innerHTML=t.loc.Report.WhatsNewInVersion.replace("{0}",i);var a=n.ResultBuilds.All[r];e.action=function(){this.jsObject.InitializeModificationsForm().show(a)}}if(o){var l=t.CreateHTMLTable();l.className="stiUpdateFormEmptyItem",l.addTextCell(t.loc.Report.NoNewVersions).style.textAlign="center",l.style.width="100%",l.style.height="100%",s.appendChild(l)}}},function(e,t){A.progress.hide()})},A.action=function(){this.changeVisibleState(!1)},A.allowBuild=function(e,t){var s=A.decodeVersion(e),n=A.decodeVersion(t);return s.major<n.major||s.major==n.major&&s.minor<n.minor||s.major==n.major&&s.minor==n.minor&&s.build<n.build},A.decodeVersion=function(A){if(!A||0==A.trim().length)return!1;var e=A.split(".");if(e.length<3)return!1;var t=parseInt(e[0]),s=parseInt(e[1]),n=parseInt(e[2]);if(null==t||null==s||null==n)return!1;return{major:t,minor:s,build:n}},A},StiJsDesigner.prototype.UpdateFormItem=function(A){var e=document.createElement("div");e.className="stiUpdateFormItem",e.developerBuild=A;var t=this.CreateHTMLTable();t.style.width="100%",e.appendChild(t);var s=document.createElement("img");s.style.margin="10px 30px 0px 30px",s.src=this.options.images["Update.StimulsoftLogo64.png"];var n=t.addCell(s);n.style.verticalAlign="top",n.style.width="1px";var o=t.addCell();o.style.verticalAlign="top";var i=document.createElement("div");i.className="stiUpdateFormItemHeader",i.innerHTML="Stimulsoft Reports "+A.Version,o.appendChild(i);var r=document.createElement("div");r.className="stiUpdateFormItemDate",r.innerHTML=this.JSONDateFormatToDate(A.Date,"dd.MM.yyyy"),o.appendChild(r);var a=document.createElement("div");a.className="stiUpdateFormItemDescription",a.innerHTML=A.Description,o.appendChild(a);var l=this.HiperLinkButton(null,this.loc.Buttons.ShowMore,23);l.style.fontSize="12px",l.style.margin="4px 0 0 13px",l.style.display="inline-block",o.appendChild(l),l.action=function(){this.jsObject.InitializeModificationsForm().show(A)};var p=this.FormButton(null,null,this.loc.NuGet.DownloadAndInstall);p.style.margin="8px",p.style.display="inline-block",p.caption.style.padding="0 10px 0 10px";var u=t.addCellInNextRow();return u.style.textAlign="right",u.setAttribute("colspan","2"),u.appendChild(p),p.action=function(){this.jsObject.openNewWindow(A.Url)},e},StiJsDesigner.prototype.InitializeUserMenu=function(){var A=[];A.push(this.Item("userInfo","",null,"")),A.push("separator"),A.push(this.Item("subscriptions",this.loc.Cloud.Subscriptions,null,"accountMenuSubscriptions")),A.push(this.Item("profile",this.loc.Navigator.TextProfile,null,"accountMenuProfile")),A.push(this.Item("changePassword",this.loc.Navigator.ButtonChangePassword,null,"changePassword")),A.push(this.Item("update",this.loc.Permissions.SystemUpdate,null,"update")),A.push("separator2"),A.push(this.Item("logout",this.loc.Navigator.ButtonLogout,null,"accountMenuLogout"));var e=this.VerticalMenu("userMenu",this.options.toolBar.userNameButton,"Down",A,this.GetStyles("MenuStandartItem"));this.options.userMenu=e,e.style.top=this.options.toolBar.offsetHeight+"px",e.style.right="0px",e.innerContent.className="stiCloudReportsWebClientUserMenu",e.innerContent.style.borderTop="0px",e.innerContent.style.borderRight="0px",e.items.userInfo.caption.style.padding="5px 20px 5px 5px",e.items.userInfo.style.height="65px",e.items.userInfo.isEnabled=!1;for(var t=["subscriptions","profile","changePassword","update","logout"],s=0;s<t.length;s++)e.items[t[s]].caption&&(e.items[t[s]].caption.style.paddingLeft="15px"),e.items[t[s]].style.height="35px";var n=document.createElement("table");e.items.userInfo.caption.appendChild(n);var o=document.createElement("tr");n.appendChild(o);var i=document.createElement("td");o.appendChild(i),e.items.userInfo.userName=document.createElement("td"),o.appendChild(e.items.userInfo.userName),e.items.userInfo.userName.style.verticalAlign="bottom",e.items.userInfo.userName.style.paddingLeft="5px",e.items.userInfo.userName.style.width="200px",e.items.userInfo.userName.innerHTML=this.options.UserName;var r=this;return this.options.toolBar.userNameButton.action=function(){r.options.menus.userMenu.changeVisibleState(!r.options.menus.userMenu.visible,null,null,null)},e.changeVisibleState=function(A){A?(this.onshow(),this.style.opacity=0,this.style.display="",this.visible=!0,this.parentButton&&this.parentButton.setSelected(!0),this.jsObject.options.currentMenu=this,this.style.width=this.innerContent.offsetWidth+"px",this.style.height=this.innerContent.offsetHeight+"px",$(this).animate({opacity:1},{duration:this.jsObject.options.formAnimDuration})):(this.visible=!1,this.parentButton&&this.parentButton.setSelected(!1),this.style.display="none",this.jsObject.options.currentMenu==this&&(this.jsObject.options.currentMenu=null))},e.action=function(A){var e=this.jsObject;if(this.changeVisibleState(!1),("changePassword"==A.key||"accountMenuProfile"==A.key)&&(!e.options.SessionKey||e.SessionIsOld()))return e.options.accountSettings=null,e.options.SessionKey=null,e.RemoveAccountSettings(),void e.options.forms.authForm.show(null);switch(A.key){case"accountMenuLogout":e.FinishSession();break;case"changePassword":e.options.forms.changePasswordForm.show();break;case"accountMenuProfile":e.InitializeSettingsForm().show();break;case"accountMenuSubscriptions":e.InitializeSubscriptionsForm().show();break;case"update":e.InitializeUpdateForm().show();break}},e},StiJsDesigner.prototype.SaveLicenseKey=function(A){this.SetCookie("StiLicenseKey",A)},StiJsDesigner.prototype.LoadLicenseKey=function(){return this.GetCookie("StiLicenseKey")},StiJsDesigner.prototype.RemoveLicenseKey=function(){this.SetCookie("StiLicenseKey","")},StiJsDesigner.prototype.SaveAccountSettings=function(A){var e={FirstName:A.FirstName,LastName:A.LastName,UserName:A.UserName,UserKey:this.options.UserKey,SessionKey:this.options.SessionKey,SessionDate:this.DateToJSONDateFormat(new Date)};this.options.licenseKey?this.options.accountSettings=e:this.SetCookie("StiAccountSettings",Stimulsoft.Base.StiEncryption.encryptS(JSON.stringify(e),this.options.encriptKey))},StiJsDesigner.prototype.RemoveAccountSettings=function(){this.SetCookie("StiAccountSettings","")},StiJsDesigner.prototype.LoadAccountSettings=function(){var A=this.GetCookie("StiAccountSettings");if(A)return JSON.parse(Stimulsoft.Base.StiEncryption.decryptS(A,this.options.encriptKey))},StiJsDesigner.prototype.SaveThemeSettings=function(A){this.SetCookie("StiThemeSettings",JSON.stringify(A))},StiJsDesigner.prototype.LoadThemeSettings=function(){var A={Theme:"Office2013White",Style:"Blue"};return this.GetCookie("StiThemeSettings")&&(A=JSON.parse(this.GetCookie("StiThemeSettings"))),A},StiJsDesigner.prototype.CheckActivation=function(){var A=this.options.licenseKey||this.LoadLicenseKey();A&&(Stimulsoft.Base.StiLicense.loadFromString(A),Stimulsoft.Base.StiLicense.licenseKey&&this.SetUserSettings(Stimulsoft.Base.StiLicense.licenseKey));var e=null;if(this.options.report){var t=this.options.report.properties.reportFile;null!=t&&(t=t.substring(t.lastIndexOf("/")).substring(t.lastIndexOf("\\")));var e=t||StiBase64.decode(this.options.report.properties.reportName.replace("Base64Code;",""))}this.SetWindowTitle(e?e+" - "+this.loc.FormDesigner.title:this.loc.FormDesigner.title),this.UpdateTrialWatermarksOnPages()},StiJsDesigner.prototype.SetUserSettings=function(A){var e=this.options.accountSettings||this.LoadAccountSettings();if(e)this.options.user={FirstName:e.FirstName,LastName:e.LastName,UserName:e.UserName,Key:e.UserKey},this.options.UserName=e.UserName,this.options.UserKey=e.UserKey,this.options.SessionKey=e.SessionKey,this.UpdateUserNameButton(this.options.user),this.StartNewSession();else if(A&&!this.options.SessionKey){var t="",s="";if(A.owner){var n=A.owner.split(" ");t=n[0].trim(),n.length>1&&(s=n[1].trim())}var o={Key:this.generateKey(),FirstName:t,LastName:s,UserName:A.userName};this.options.UserKey=o.Key,this.UpdateUserNameButton(o),this.StartNewSession()}},StiJsDesigner.prototype.UpdateTrialWatermarksOnPages=function(){if(this.options.productVersion=this.options.productVersion.trim(),Stimulsoft.Base.Licenses.StiLicenseKeyValidator.isValidOnAnyPlatform()&&(this.options.productVersion+=" "),this.options.report)for(var A in this.options.report.pages){var e=this.options.report.pages[A];e.controls.waterMarkBackParent&&(e.removeChild(e.controls.waterMarkBackParent),e.controls.waterMarkBackParent=null),this.options.productVersion==this.options.productVersion.trim()&&(this.CreatePageWaterMarkBack(e),this.RepaintWaterMarkBack(e))}},StiJsDesigner.prototype.SessionIsOld=function(){var A=this.options.accountSettings||this.LoadAccountSettings(),e=A&&A.SessionDate?this.JSONDateFormatToDate(A.SessionDate):null,t=e?Math.floor(((new Date).getTime()-new Date(e).getTime())/1e3/60/60/24):null;return null==t||t>15},StiJsDesigner.prototype.InitializeLoginControls=function(){this.options.restUrl="https://reports.stimulsoft.com/",this.options.cloudParameters={},this.options.imagesPath="Images/",this.options.themeStyle="Blue",this.options.STI_DATE_TIME_FORMAT="dd.MM.yyyy h:nn",this.options.STI_DATE_TIME_FORMAT_SEC="dd.MM.yyyy h:nn:ss",this.options.STI_DATE_FORMAT="dd.MM.yyyy",this.options.maxUploadFileSize="10000000",this.options.mobileDesigner.className="stiDesignerForm",this.options.encriptKey="8pAP5T29MuKEDcRw7";var A=this.GetCookie("StimulsoftMobileDesignerRequestChangesWhenSaving");this.options.requestChangesWhenSaving=null==A||"true"==A,this.AddLocalizations(),this.AddImages(),this.OverrideCreateHTMLTable(),this.OverrideExecuteAction(),this.OverrideStyles(),this.OverrideTextbox(),this.OverrideFileMenu(),this.OverrideToolbar(),this.OverrideBaseForm(),this.OverrideEditConnectionForm(),this.OverrideOptionsForm(),this.OverrideSubReportForm(),this.OverrideSaveActions(),this.OverrideOpenPanel(),this.OverrideSaveAsPanel(),this.OverrideCloudMethods(),this.OverrideOpenDialog(),this.InitMessagesTooltip(),this.InitializeChangePasswordForm(),this.InitializeController(),this.InitializeAuthForm(),this.SetTheme(this.LoadThemeSettings()),this.CheckActivation();var e=this.options.viewerContainer.firstChild.jsObject.controls.forms.exportForm.controls.OpenAfterExport.parentRow;e.parentNode.removeChild(e),StiJsDesigner.prototype.openNewWindow=function(A){var e=gui.Window.open(A,{position:"center",width:1e3,height:800});return null},StiJsViewer.prototype.openNewWindow=StiJsDesigner.prototype.openNewWindow,this.SendCloudCommand=function(A,e,t,s,n,o){this.SendCommand(A,e,t,s,n||this.options.ignoreSessionDate,o)};var t=this;setInterval(function(){t.options.SessionKey&&t.SendCommand("UserIdle",{},function(A){A.ResultSuccess&&t.options.user&&t.SaveAccountSettings(t.options.user)},function(A){})},1e3*60*5)},StiJsDesigner.prototype.ActionOpenRecentFile=function(A){try{var e=Stimulsoft.System.IO.File.getFile(A.path+A.name,!0);this.OpenReport(A.name,e,A.path)}catch(A){var t=this.options.forms.errorMessageForm||this.InitializeErrorMessageForm();t.show(A.message)}},StiJsDesigner.prototype.OverrideBaseForm=function(){this.OldBaseForm=this.BaseForm,this.BaseForm=function(A,e,t,s,n,o){var i=this.OldBaseForm(A,e,t,s);return i.buttonSave=i.buttonOk,i.buttonsTable=i.buttonsPanel.firstChild,i.addControlRow=function(A,e,t,s){null==i.controlsTable&&(i.controlsTable=i.jsObject.CreateHTMLTable(),i.controlsTable.style.width="100%",i.container.appendChild(i.controlsTable)),i.controlsTable.addRow();var n=i.controlsTable.addCellInLastRow();n.innerHTML=A,n.className="stiCloudReportsWebClientSchedulerFormTextBeforeControlInActions",i.controls||(i.controls={}),i.controls[e]=t,t.style.margin=s;var o=i.controlsTable.addCellInLastRow(t);return o.style.width="1px",o},n&&$(window).resize(function(){i.jsObject.SetObjectToCenter(i)}),i.changeVisibleState=function(A){if(A){this.style.display="",this.onshow(),this.jsObject.SetObjectToCenter(this),this.jsObject.options.disabledPanels||this.jsObject.InitializeDisabledPanels(),this.jsObject.options.disabledPanels[this.level].changeVisibleState(!0),this.visible=!0,this.jsObject.options.currentForm=this,d=new Date;var e=d.getTime()+this.jsObject.options.formAnimDuration;this.flag=!1,this.jsObject.ShowAnimationForm(this,e),o&&(i.jsObject.options.modalIndex||(i.jsObject.options.modalIndex=100),i.modalDiv=$("<div style='position:absolute; left:0px; top:0px; width:100%; height:100%;opacity:0;z-index:"+i.jsObject.options.modalIndex+";'></div>")[0],i.jsObject.options.mainPanel.appendChild(i.modalDiv),i.style.zIndex=i.jsObject.options.modalIndex+1,i.jsObject.options.modalIndex+=2)}else clearTimeout(this.animationTimer),this.visible=!1,this.jsObject.options.currentForm=null,this.style.display="none",this.jsObject.options.forms[this.name]||this.jsObject.options.mainPanel.removeChild(this),this.onhide(),o&&(i.modalDiv.style.display="none",i.jsObject.options.modalIndex-=2),this.jsObject.options.disabledPanels||this.jsObject.InitializeDisabledPanels(),this.jsObject.options.disabledPanels[this.level].changeVisibleState(!1)},i}},StiJsDesigner.prototype.OverrideEditConnectionForm=function(){var A=this;this.InitializeEditConnectionForm(function(A){A.pathSchemaControl.openButton.style.display="",A.pathDataControl.openButton.style.display=""})},StiJsDesigner.prototype.OverrideExecuteAction=function(){var A=this;this.OldExecuteAction=this.ExecuteAction,this.ExecuteAction=function(e){if("openReport"==e){return void(this.options.openPanel||this.InitializeOpenPanel()).changeVisibleState(!0)}if("saveReport"==e){var t=this.options.menus.fileMenu||this.InitializeFileMenu();return void(this.options.cloudParameters.reportTemplateItemKey||this.options.report.properties.reportFile?(t.changeVisibleState(!1),setTimeout(function(){A.ActionSaveReport()},200)):(t.action(t.items.saveAsReport),t.items.saveReport.setSelected(!0),this.options.saveAsPanel&&(this.options.saveAsPanel.header.innerHTML=this.loc.A_WebViewer.SaveReport)))}if("saveAsReport"==e){return void(this.options.saveAsPanel||this.InitializeSaveAsPanel()).changeVisibleState(!0)}this.OldExecuteAction(e)}},StiJsDesigner.prototype.OverrideFileMenu=function(){var A=this.options.menus.fileMenu||this.InitializeFileMenu();A.style.minHeight="500px";var e=this.FileMenuItem("help",this.loc.Buttons.Help);e.style.position="absolute",e.style.bottom="0px",e.style.width="100%",A.appendChild(e),A.oldChangeVisibleState=A.changeVisibleState,A.changeVisibleState=function(e){A.oldChangeVisibleState(e),e&&this.jsObject.options.showFileMenuOpen&&this.items.openReport.action()},e.action=function(){A.closeAllPanels(this.name),A.changeVisibleState(!1),this.jsObject.openNewWindow("https://www.stimulsoft.com/en/documentation/online/user-manual/index.html?introduction.htm")}},StiJsDesigner.prototype.OverrideCreateHTMLTable=function(){this.OldCreateHTMLTable=this.CreateHTMLTable,this.CreateHTMLTable=function(A,e){var t=this.OldCreateHTMLTable(A,e);return t.addCell=function(A,e,t){var s=$("<td"+(t?" style='"+t+"'":"")+"></td>")[0];return e?this.tr[this.tr.length-1].appendChild(s):this.tr[0].appendChild(s),A&&s.appendChild(A),s},t}},StiJsDesigner.prototype.OverrideOpenDialog=function(){var A=this;this.StiHandleOpenReport=function(A){var e=A.target.files,t=e[0]?e[0].name:"Report",s=A.target.value;if(this.jsObject.options.jsMode){var n=s;s&&this.jsObject.EndsWith(A.target.value,t)&&(n=s.substring(0,s.length-t.length)),this.jsObject.SaveFileToRecentArray(t,n)}for(var o=0,i;i=e[o];o++){var r=new FileReader;r.jsObject=this.jsObject,r.onload=function(A){return function(A){r.jsObject.ResetOpenDialogs(),r.jsObject.OpenReport(t,r.jsObject.options.mvcMode?encodeURIComponent(A.target.result):A.target.result,s),r.jsObject.ReturnFocusToDesigner(),r.jsObject.options.cloudParameters&&(r.jsObject.options.cloudParameters.reportTemplateItemKey=null)}}(i),r.readAsDataURL(i)}}},StiJsDesigner.prototype.OverrideOpenPanel=function(){this.InitializeOpenPanel=function(){var A=document.createElement("div");A.jsObject=this,this.options.openPanel=A,this.options.mainPanel.appendChild(A),A.style.display="none",A.className="stiDesignerNewReportPanel",A.style.overflow="auto";var e=this,t=this.FileMenuPanelHeader(this.loc.MainMenu.menuFileOpen.replace("&","").replace("...",""));A.appendChild(t);var s=this.CreateHTMLTable();A.appendChild(s),s.style.margin="10px 30px 0px 30px",s.style.height="calc(100% - 130px)";var n=this.CreateHTMLTable();s.addCell(n).className="wizardFormStepsPanel";var o=s.addCell();o.style.verticalAlign="top",A.additionalCell=o;var i=this.CreateHTMLTable();i.style.display="none",o.appendChild(i);var r=[];r.push(["ActiveReports","Active Reports","Open.ImportFiles.png"]),r.push(["ComponentOneReports","ComponentOne Reports","Open.ImportFiles.png"]),r.push(["CrystalReports","Crystal Reports","Open.ImportFiles.png"]),r.push(["FastReports","FastReport.Net","Open.ImportFiles.png"]),r.push(["ReportSharpShooter","Report SharpShooter","Open.ImportFiles.png"]),r.push(["RichText","Rich Text Format","Open.ImportFiles.png"]),r.push(["ReportingServices","Reporting Services","Open.ImportFiles.png"]),r.push(["TelerikReports","Telerik Reporting","Open.ImportFiles.png"]),r.push(["VisualFoxPro","Visual FoxPro","Open.ImportFiles.png"]);for(var a=0;a<r.length;a++){var l=this.RecentPanelButton(r[a][0],null,r[a][1],r[a][2]);l.style.margin="0px 10px 3px 10px",i.addCellInNextRow(l),l.action=function(){if("VisualFoxPro"==this.name)e.ActionImportFile(this.name);else{var A=this;(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){e.ActionImportFile(A.name)},200)}}}A.openReportFromCloudItem=function(A,t){(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){if(null!=e.options.report&&e.options.reportIsModified){var s=e.MessageFormForSave();s.changeVisibleState(!0),s.action=function(s){s?e.ActionSaveReport(function(){e.OpenReportFromCloud(A,t)}):e.OpenReportFromCloud(A,t)}}else e.OpenReportFromCloud(A,t)})};var p=this.InitializeOnlineOpenReportPanel();e.options.mainPanel.appendChild(p);var u=[];u.push(["recentFilesOpen",this.loc.FormDatabaseEdit.RecentConnections,"Open.RecentFiles.png"]),u.push(["onlineItemsOpen",this.getCloudName(),"Open.Online.png"]),u.push(["browseFilesOpen",this.loc.ReportOpen.Browse,"Open.OpenFiles.png"]);for(var a=0;a<u.length;a++){var l=this.RecentPanelButton(u[a][0],"OpenPanelMainButtons",u[a][1],u[a][2]);l.style.marginBottom="3px",n.addCellInNextRow(l),l.action=function(t){if(this.isSelected&&!t)return;switch(this.setSelected(!0),this.name){case"recentFilesOpen":i.style.display="none",p.style.display="none",A.recentButtonsTable&&(A.recentButtonsTable.style.display="");break;case"importFilesOpen":i.style.display="",p.style.display="none",A.recentButtonsTable&&(A.recentButtonsTable.style.display="none");break;case"onlineItemsOpen":i.style.display="none",p.show(),A.recentButtonsTable&&(A.recentButtonsTable.style.display="none");break;case"browseFilesOpen":p.style.display="none";(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){e.ActionOpenReport()},200);break}}}return A.changeVisibleState=function(t){if(this.style.display=t?"":"none",t){e.options.buttons.recentFilesOpen.action(!0),A.recentButtonsTable&&o.removeChild(A.recentButtonsTable),A.recentButtonsTable=e.CreateHTMLTable(),o.appendChild(A.recentButtonsTable);var s=e.GetRecentArray("StimulsoftMobileDesignerRecentArray");0==s.length&&e.options.buttons.onlineItemsOpen.action(!0);for(var n=0;n<s.length;n++){var i=s[n].path&&(s[n].path.indexOf("/")>=0||s[n].path.indexOf("\\")>=0),r=i?"Open.ReportFile.png":"Open.ReportCloud.png",a=i?s[n].name+"<br>"+s[n].path:s[n].name,l=e.RecentPanelButton(null,null,a,r);l.style.margin="0px 10px 3px 10px",l.style.cursor="pointer",l.fileObject=s[n],A.recentButtonsTable.addCellInNextRow(l),l.action=function(){var t=this;(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){t.fileObject.path&&(t.fileObject.path.indexOf("/")>=0||t.fileObject.path.indexOf("\\")>=0)?e.ActionOpenRecentFile(t.fileObject):A.openReportFromCloudItem({Name:t.fileObject.name,Key:t.fileObject.path},!0)},200)}}}else p.style.display="none"},A},this.RecentPanelButton=function(A,e,t,s){var n=this.SmallButton(A,e,t,s,t,null,this.GetStyles("StandartSmallButton"),!0);return n.imageCell&&(n.imageCell.style.padding="0 10px 0 10px"),n.caption&&(n.caption.style.padding="0 20px 0 10px",n.caption.style.lineHeight="1.4"),n.style.minWidth="250px",n.style.height="50px",n},this.InitializeOnlineOpenReportPanel=function(){var A=this.BaseForm("onlineOpenReport",this.loc.MainMenu.menuFileOpen.replace("&","").replace("...",""),1,this.HelpLinks.onlineOpenReport),e=this;A.buttonOk.caption.innerHTML=this.loc.MainMenu.menuFileOpen.replace("&","").replace("...",""),A.buttonOk.style.margin="15px 15px 15px 0px",A.buttonCancel.style.margin="15px 15px 15px 0px",A.buttonCancel.action=function(){(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1)},A.cancelAction=function(){A.buttonCancel.action()};var t=e.CloudTree();A.onlineTree=t,t.style.padding="10px 0 10px 0",t.style.width="550px",t.style.height="450px",t.progress=e.AddProgressToControl(A.container),A.container.appendChild(t),t.action=function(e){A.buttonOk.setEnabled(e&&"ReportTemplateItem"==e.itemObject.Ident)},t.ondblClickAction=function(e){A.action()};var s="You can open your report from <a style='text-decoration: none;' href='https://cloud.stimulsoft.com/' target='_blank'>Stimulsoft Cloud.</a><br>"+"Please login using your Stimulsoft account credentials or register a new account",n=e.CloudDemoPanel(s);return A.demoPanel=n,A.container.appendChild(n),A.setToLoginMode=function(){t.style.display="none",n.style.display="",A.buttonOk.style.display="none",A.buttonCancel.style.display="none",A.buttonsSeparator.style.display="none"},A.setToTreeMode=function(){t.style.display="",n.style.display="none",A.buttonOk.style.display="",A.buttonCancel.style.display="",A.buttonsSeparator.style.display="",t.build()},A.show=function(t){A.style.display="",A.visible=!0,A.buttonOk.setEnabled(!1),A.style.left=e.FindPosX(e.options.openPanel.additionalCell,"stiDesignerMainPanel")+10+"px",A.style.top=e.FindPosY(e.options.openPanel.additionalCell,"stiDesignerMainPanel")+"px",this.jsObject.options.SessionKey?A.setToTreeMode():A.setToLoginMode()},A.action=function(){if(t.selectedItem&&"ReportTemplateItem"==t.selectedItem.itemObject.Ident){var s=e.options.menus.fileMenu||e.InitializeFileMenu();A.changeVisibleState(!1),setTimeout(function(){e.options.openPanel.openReportFromCloudItem(t.selectedItem.itemObject)},200)}},A},this.CloudDemoPanel=function(A){var e=document.createElement("div");e.className="stiCloudDemoPanel";var t=document.createElement("img");t.style.margin="25px 0 25px 0",t.src=this.options.images["LogIn.CloudBigIcon.png"],e.appendChild(t);var s=document.createElement("div");s.style.padding="0px 45px 40px 45px",s.style.lineHeight="1.3",s.innerHTML=A,e.appendChild(s);var n=this.LoginButton(null,this.loc.Authorization.ButtonLogin,null);n.innerTable.style.width="100%",n.allwaysEnabled=!0,n.style.width="200px",n.style.margin="0 auto",n.action=function(){this.jsObject.options.forms.authForm.show(null,!0)},e.appendChild(n);var o=this.HiperLinkButtonForAuthForm(null,this.loc.Authorization.HyperlinkRegisterAccount,!0);return o.style.display="inline-block",o.style.marginTop="25px",e.appendChild(o),o.action=function(){this.jsObject.options.forms.authForm.changeMode("signUp"),this.jsObject.options.forms.authForm.show(!0,!0)},e}},StiJsDesigner.prototype.OverrideOptionsForm=function(){var A=this;this.OldInitializeOptionsForm=this.InitializeOptionsForm,this.InitializeOptionsForm=function(){this.OldInitializeOptionsForm(function(e){var t="Gui",s=e.container.firstChild.rows[0].firstChild,n=e.container.firstChild.rows[0].childNodes[1],o=A.StandartFormBigButton(null,null,"GUI","Gui.OptionsGui.png","GUI",80);o.style.margin="2px",e.mainButtons[t]=o,n.appendChild(o),o.panelName=t,o.action=function(){e.setMode(this.panelName)};var i=document.createElement("Div");i.className="stiDesignerEditFormPanel",i.style.display="none",i.style.overflow="hidden",s.appendChild(i),e.panels[t]=i;var r=A.CreateHTMLTable();r.style.margin="10px 15px 10px 15px",i.appendChild(r);var a=r.addTextCellInLastRow(A.loc.Options.LabelBackground);a.className="stiCloudReportsWebClientSchedulerFormTextBeforeControlInActions",a.style.width="150px",a.style.padding="10px 0px 10px 0px";var l=$("<div></div>")[0],p=A.GetThemeBackgroundItems();for(var u in p){var o=A.ColorButton(p[u].color,"themeBackground"+p[u].color,"themeBackground",p[u].name,function(){m.setThemeImage(A.GetThemeName(A.getSelectedButton("themeBackground").value,A.getSelectedButton("themeForeground").value))});A.options.themeIdent==p[u].name&&o.setSelected(!0),l.appendChild(o)}r.addCellInLastRow(l);var c=r.addTextCellInNextRow(A.loc.Options.LabelForeground);c.className="stiCloudReportsWebClientSchedulerFormTextBeforeControlInActions",c.style.width="150px",c.style.padding="10px 0px 10px 0px";var d=$("<div></div>")[0],g=A.GetThemeForegroundItems();for(var u in g){var o=A.ColorButton(g[u].color,"themeForeground"+g[u].name,"themeForeground",g[u].name,function(){m.setThemeImage(A.GetThemeName(A.getSelectedButton("themeBackground").value,A.getSelectedButton("themeForeground").value))});A.options.themeStyle==g[u].name&&o.setSelected(!0),d.appendChild(o)}r.addCellInLastRow(d),i.appendChild($("<div style='width:100%' class='stiCloudReportsWebClientFormSeparator'></div>")[0]);var h=$("<div style='width:100%; text-align:center; padding-top:20px'><img style='border-right: 1px solid #c6c6c6;border-bottom: 1px solid #c6c6c6;'></img></div>")[0];i.appendChild(h);var m=h.childNodes[0];m.setThemeImage=function(e){m.src=A.options.images["Gui."+e+".png"]},m.setThemeImage(A.GetThemeName(A.getSelectedButton("themeBackground").value,A.getSelectedButton("themeForeground").value)),e.restoreDefaults.action=function(){e.fill(A.options.defaultDesignerOptions);for(var t=0;t<l.childNodes.length;t++){var s=l.childNodes[t];"Office2013White"==s.value&&s.onclick()}for(var t=0;t<d.childNodes.length;t++){var s=d.childNodes[t];"Blue"==s.value&&s.onclick()}},e.oldAction=e.action,e.action=function(){if(e.oldAction(),A.options.themeIdent!=A.getSelectedButton("themeBackground").value||A.options.themeStyle!=A.getSelectedButton("themeForeground").value){var t={Theme:A.getSelectedButton("themeBackground").value,Style:A.getSelectedButton("themeForeground").value};A.SetTheme(t),A.SaveThemeSettings(t)}},e.controls.requestChangesWhenSaving&&(e.controls.requestChangesWhenSaving.style.display=""),e.show()})}},StiJsDesigner.prototype.OverrideSaveActions=function(){this.ActionSaveReport=function(A){if(this.options.reportIsModified=!1,this.options.report){if(this.options.report.properties.reportFile||this.options.cloudParameters.reportTemplateItemKey)if(this.options.cloudParameters.reportTemplateItemKey)this.InitializeSaveDescriptionForm(function(e){e.nextFunc=A||null,e.jsObject.options.requestChangesWhenSaving?(e.changeVisibleState(!0),e.textArea.focus()):e.action(!0)});else{var e=this.options.report.properties.reportFile||"Report.mrt";if(this.options.report.encryptedPassword&&(e.toLowerCase().endsWith(".mrt")||e.toLowerCase().endsWith(".mrz"))&&(e=e.substring(0,e.length-3)),this.options.report.properties.reportFile&&this.options.report.properties.reportFilePath){var t=this.options.report.properties.reportFilePath,s=this.options.report.jsObject.designer.report,n=s.saveToJsonString(),o=require("fs"),i=require("path");o.writeFileSync(i.join(t,e),n,"utf8")}else this.ActionSaveAsReport()}else{(this.options.saveAsPanel||this.InitializeSaveAsPanel()).nextFunc=A,this.options.buttons.browseFilesSaveAs&&this.options.buttons.browseFilesSaveAs.action()}A&&A()}},this.ActionSaveAsReport=function(){if(this.options.report){this.options.reportIsModified=!1;var A=this.options.report.properties.reportFile||"Report.mrt";this.options.report.encryptedPassword&&(A.toLowerCase().endsWith(".mrt")||A.toLowerCase().endsWith(".mrz"))&&(A=A.substring(0,A.length-4)+".mrx"),this.options.report.properties.reportFile=A,this.options.report.properties.reportFilePath=null,this.SendCommandSaveAsReport()}}},StiJsDesigner.prototype.OverrideSaveAsPanel=function(){this.InitializeSaveAsPanel=function(){var A=document.createElement("div");A.jsObject=this,this.options.saveAsPanel=A,this.options.mainPanel.appendChild(A),A.style.display="none",A.className="stiDesignerNewReportPanel",A.style.overflow="auto";var e=this;A.header=this.FileMenuPanelHeader(this.loc.MainMenu.menuFileSaveAs.replace("...","")),A.appendChild(A.header);var t=this.CreateHTMLTable();A.appendChild(t),t.style.margin="10px 30px 0px 30px",t.style.height="calc(100% - 130px)";var s=this.CreateHTMLTable();t.addCell(s).className="wizardFormStepsPanel";var n=t.addCell();n.className="wizardFormStepsPanel",n.style.border="0",A.rightCell=n;var o=this.InitializeOnlineSaveAsReportPanel();e.options.mainPanel.appendChild(o);var i=this.InitializeBrowseSaveAsReportPanel();e.options.mainPanel.appendChild(i),A.getFileName=function(A){var t=A?"Report.mrt":"Report";return e.options.cloudMode&&this.jsObject.options.cloudParameters&&this.jsObject.options.cloudParameters.reportTemplateItemKey?(t=e.options.cloudParameters.reportName,A&&(t+=".mrt")):e.options.report.properties.reportFile&&(t=e.options.report.properties.reportFile,!A&&(t.toLowerCase().endsWith(".mrt")||t.toLowerCase().endsWith(".mrz")||t.toLowerCase().endsWith(".mrx"))&&(t=t.substring(0,t.length-4))),e.options.report.encryptedPassword&&A&&(t.toLowerCase().endsWith(".mrt")||t.toLowerCase().endsWith(".mrz"))&&(t=t.substring(0,t.length-4)+".mrx"),t};var r=[];r.push(["onlineItemsSaveAs",this.getCloudName(),"Open.Online.png"]),r.push(["browseFilesSaveAs",this.loc.ReportOpen.Browse,"Open.OpenFiles.png"]);for(var a=0;a<r.length;a++){var l=this.RecentPanelButton(r[a][0],"SaveAsPanelMainButtons",r[a][1],r[a][2]);l.style.marginBottom="3px",s.addCellInNextRow(l),l.action=function(e){if(this.isSelected&&!e)return;switch(this.setSelected(!0),A.mode=this.name,o.style.display="none",i.style.display="none",this.name){case"onlineItemsSaveAs":o.show(A.getFileName(!1),A.nextFunc);break;case"browseFilesSaveAs":i.show(A.getFileName(!0),A.nextFunc),i.action();break}}}return A.changeVisibleState=function(t){this.style.display=t?"":"none",e.options.buttons.onlineItemsSaveAs.setSelected(!1),e.options.buttons.browseFilesSaveAs.setSelected(!1),t?(e.options.buttons.onlineItemsSaveAs.action(),A.header.innerHTML=e.loc.MainMenu.menuFileSaveAs.replace("...",""),A.nextFunc=null):(o.style.display="none",i.style.display="none")},A},this.InitializeOnlineSaveAsReportPanel=function(){var A=this.BaseForm("onlineSaveAsReport",this.loc.MainMenu.menuFileSaveAs.replace("...",""),1,this.HelpLinks.onlineSaveReport),e=this,t=e.StandartSmallButton(null,null,this.loc.Cloud.FolderWindowTitleNew,"Folder.png");t.style.margin="10px 10px 10px 7px",t.style.height="30px",t.style.display="inline-block",t.imageCell.style.padding="0 7px 0 9px",t.caption.style.padding="0px 15px 0 0px",A.container.appendChild(t),A.newFolderButton=t;var s=this.FormSeparator();A.container.appendChild(s);var n=e.CloudTree();A.onlineTree=n,n.style.padding="10px 0 10px 0",n.style.width="100%",n.style.minWidth="550px",n.style.height="400px",n.progress=e.AddProgressToControl(A.container),A.container.appendChild(n);var o="You can save your report in <a style='text-decoration: none;' href='https://cloud.stimulsoft.com/' target='_blank'>Stimulsoft Cloud.</a><br>"+"Please login using your Stimulsoft account credentials or register a new account",i=e.CloudDemoPanel(o);A.demoPanel=i,A.container.appendChild(i),t.action=function(){this.jsObject.InitializeNewFolderForm(function(A){A.show(function(){if(A.nameTextBox.value){var e=A.jsObject.generateKey(),t={};t.AllowSignalsReturn=!0,t.Items=[{Ident:"FolderItem",Name:A.nameTextBox.value,Description:"",Type:"Common",Key:e}],n.rootItem&&"root"!=n.rootItem.itemObject.Key&&(t.Items[0].FolderKey=n.rootItem.itemObject.Key),n.progress.show(),A.changeVisibleState(!1),A.jsObject.SendCloudCommand("ItemSave",t,function(A){n.progress.hide(),A.ResultItems&&A.ResultItems.length>0&&n.build(n.rootItem.itemObject,n.returnItems[n.rootItem.itemObject.Key],e)},function(e){(A.jsObject.options.forms.errorMessageForm||A.jsObject.InitializeErrorMessageForm()).show(A.jsObject.formatResultMsg(e))})}else{n.progress.hide();(A.jsObject.options.forms.errorMessageForm||A.jsObject.InitializeErrorMessageForm()).show(A.jsObject.loc.Errors.FieldRequire.replace("{0}",A.jsObject.loc.PropertyMain.Name))}})})};var r=this.CreateHTMLTable();r.style.marginTop="15px",r.style.width="100%";var a=r.addTextCell(this.loc.PropertyMain.Name+":");a.className="stiDesignerCaptionControls",a.style.paddingLeft="15px";var l=e.TextBox(null,450);return A.nameControl=l,l.style.marginRight="15px",r.addCell(l).style.textAlign="right",A.buttonOk.caption.innerHTML=this.loc.A_WebViewer.SaveReport,A.buttonOk.style.margin="15px 15px 15px 0px",A.insertBefore(r,A.buttonsPanel),A.buttonCancel.style.margin="15px 15px 15px 0px",A.buttonCancel.action=function(){(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1)},A.cancelAction=function(){A.buttonCancel.action()},n.action=function(A){"ReportTemplateItem"==A.itemObject.Ident&&(l.value=A.itemObject.Name)},n.ondblClickAction=function(e){"ReportTemplateItem"==e.itemObject.Ident&&A.action()},n.onbuildcomplete=function(e){A.buttonOk.setEnabled(!0),t.setEnabled(!0),l.setEnabled(!0);var s=n.getNewFreeName(l.value);l.value=s},n.getNewFreeName=function(A){if(!n.checkExistItem(A,"ReportTemplateItem"))return A;var e=2;while(n.checkExistItem(A+e,"ReportTemplateItem"))e++;return A+e},n.checkExistItem=function(A,e){for(var t=0;t<this.innerContainer.childNodes.length;t++){var s=this.innerContainer.childNodes[t];if(s.itemObject&&s.itemObject.Ident==e&&s.itemObject.Name==A)return s.itemObject}return!1},A.setToLoginMode=function(){n.style.display="none",i.style.display="",A.buttonOk.style.display="none",t.style.display="none",r.style.display="none",s.style.display="none",A.buttonCancel.style.display="none",A.buttonsSeparator.style.display="none"},A.setToTreeMode=function(){n.style.display="",i.style.display="none",A.buttonOk.style.display="",t.style.display="inline-block",r.style.display="",s.style.display="",A.buttonCancel.style.display="",A.buttonsSeparator.style.display="",l.setEnabled(!1),n.build()},A.show=function(s,n){A.style.display="",A.visible=!0,A.style.left=e.FindPosX(e.options.saveAsPanel.rightCell,"stiDesignerMainPanel")+10+"px",A.style.top=e.FindPosY(e.options.saveAsPanel.rightCell,"stiDesignerMainPanel")+"px",l.value=s,l.focus(),A.buttonOk.setEnabled(!1),t.setEnabled(!1),A.nextFunc=n,this.jsObject.options.SessionKey?A.setToTreeMode():A.setToLoginMode()},A.action=function(){var t=e.options.menus.fileMenu||e.InitializeFileMenu(),s=n.checkExistItem(l.value,"ReportTemplateItem");if(s){var o=e.MessageFormForReplaceItem(l.value);o.changeVisibleState(!0),o.action=function(n){n&&(A.changeVisibleState(!1),t.changeVisibleState(!1),setTimeout(function(){e.options.cloudParameters.reportTemplateItemKey=s.Key,e.options.cloudParameters.reportName=l.value,e.SetWindowTitle(l.value+" - "+e.loc.FormDesigner.title),e.SendCommandItemResourceSave(s.Key),A.nextFunc&&A.nextFunc()},200))}}else A.changeVisibleState(!1),t.changeVisibleState(!1),setTimeout(function(){var t=n.rootItem&&"root"!=n.rootItem.itemObject.Key?n.rootItem.itemObject.Key:null;e.AddNewReportItemToCloud(l.value,t),A.nextFunc&&A.nextFunc()},200)},l.actionOnKeyEnter=function(){A.action()},A},this.InitializeBrowseSaveAsReportPanel=function(){var A=this.BaseForm("browseSaveAsReport",this.loc.MainMenu.menuFileSaveAs.replace("...",""),1),e=this;A.buttonOk.caption.innerHTML=this.loc.A_WebViewer.SaveReport,A.buttonOk.style.margin="15px 15px 15px 0px",A.buttonCancel.style.margin="15px 15px 15px 0px",A.buttonCancel.action=function(){(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1)},A.cancelAction=function(){A.buttonCancel.action()};var t=this.CreateHTMLTable();A.container.appendChild(t),t.addTextCell(this.loc.PropertyMain.Name+":").className="stiDesignerCaptionControls";var s=this.TextBox(null,400);return t.addCell(s),t.style.margin="15px",A.show=function(t,n){A.style.display="",A.style.left=e.FindPosX(e.options.saveAsPanel.rightCell,"stiDesignerMainPanel")+10+"px",A.style.top=e.FindPosY(e.options.saveAsPanel.rightCell,"stiDesignerMainPanel")+"px",s.value=t,s.focus(),A.nextFunc=n},A.action=function(){(e.options.menus.fileMenu||e.InitializeFileMenu()).changeVisibleState(!1),setTimeout(function(){e.options.report.properties.reportFile=s.value,e.options.cloudParameters.reportTemplateItemKey=null;var t=e.options.report.properties.reportFile;null!=t&&(t=t.substring(t.lastIndexOf("/")).substring(t.lastIndexOf("\\")));var n=t||StiBase64.decode(e.options.report.properties.reportName.replace("Base64Code;",""));e.SetWindowTitle(n?n+" - "+e.loc.FormDesigner.title:e.loc.FormDesigner.title),e.SendCommandSaveAsReport(),A.nextFunc&&(A.nextFunc(),A.nextFunc=null)},200)},s.actionOnKeyEnter=function(){A.action()},A}},StiJsDesigner.prototype.OverrideStyles=function(){this.OldGetStyles=this.GetStyles,this.GetStyles=function(A){if(this.OldGetStyles(A))return this.OldGetStyles(A);switch(A){case"LoginButton":return{default:"stiCloudReportsWebClientLoginButton",over:"stiCloudReportsWebClientLoginButtonOver",selected:"stiCloudReportsWebClientLoginButtonSelected",disabled:"stiCloudReportsWebClientLoginButtonDisabled"};case"AuthHyperlinkButton":return{default:"stiCloudReportsWebClientHyperlinkButton",over:"stiCloudReportsWebClientHyperlinkButtonOver",selected:"stiCloudReportsWebClientHyperlinkButtonSelected",disabled:"stiCloudReportsWebClientHyperlinkButtonDisabled"};case"LoginToolButton":return{default:"stiCloudReportsWebClientToolButton",over:"stiCloudReportsWebClientToolButtonOver",selected:"stiCloudReportsWebClientToolButtonSelected",disabled:"stiCloudReportsWebClientToolButtonDisabled"};case"HeaderButton":return{default:"stiCloudReportsWebClientHeaderButton",over:"stiCloudReportsWebClientHeaderButtonOver",selected:"stiCloudReportsWebClientHeaderButtonSelected",disabled:"stiCloudReportsWebClientHeaderButtonDisabled"};case"SmallButtonWithBorders":return{default:"stiCloudReportsWebClientSmallButtonWithBorders",over:"stiCloudReportsWebClientSmallButtonWithBordersOver",selected:"stiCloudReportsWebClientSmallButtonWithBordersSelected",disabled:"stiCloudReportsWebClientSmallButtonWithBordersDisabled"}}}},StiJsDesigner.prototype.OverrideSubReportForm=function(){var A=this;this.InitializeSubReportForm(function(A){A.fileNameTextBox.openButton.style.display=""})},StiJsDesigner.prototype.OverrideTextbox=function(){this.OldTextBox=this.TextBox,this.TextBox=function(A,e,t){var s=this.OldTextBox(A,e,t);return s.checkEmpty=function(A,e,t,s){var n=s?this.value.trim():this.value;if(null!=n&&""!=n)return!0;if(A){e&&e();var o=this;t?setTimeout(function(){o.jsObject.ShowMessagesTooltip(A,o)},t):this.jsObject.ShowMessagesTooltip(A,this)}return!1},s.checkLength=function(A,e,t){if(null!=this.value&&this.value.length>=A)return!0;if(e){var s=this;t?setTimeout(function(){s.jsObject.ShowMessagesTooltip(e,s)},t):this.jsObject.ShowMessagesTooltip(e,this)}return!1},s.checkEmail=function(A,e){var t=/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,s=this.value.trim(),n=this.checkEmpty()&&t.test(s),o=this;return!n&&A&&(e?setTimeout(function(){o.jsObject.ShowMessagesTooltip(A,o)},e):this.jsObject.ShowMessagesTooltip(A,this)),n},s}},StiJsDesigner.prototype.SetWindowTitle=function(A){var e=("".constructor+[]).replace(/\n/g,"").replace("    "," ");s2=e[19]+e[20]+e[23].toUpperCase()+e[11]+e[12]+e[22]+"l"+e[32],StiJsDesigner.dt+s2===A&&(A=StiJsDesigner.dt),Stimulsoft.Base.Licenses.StiLicenseKeyValidator.isValidOnAnyPlatform()||(StiJsDesigner.dt=A,A+=s2),document[e[23]+e[12]+e[23]+"le"]=A,this.options.toolBar&&this.options.toolBar["designerT"+e[12]+e[23]+"le"]&&(this.options.toolBar["designerT"+e[12]+e[23]+"le"].innerHTML=A)},StiJsDesigner.prototype.OverrideToolbar=function(){var A=this.options.toolBar,e="stiDesignerToolButtonCell",t=A.firstChild;t.style.height="37px",this.options.buttons.aboutButton&&(this.options.buttons.aboutButton.style.display="none"),this.options.buttons.showToolBarButton&&(this.options.buttons.showToolBarButton.style.display="none"),A.style.height="70px",A.style.webkitAppRegion="drag",A.changeToHeader=function(e){t.style.display=e?"none":"",A.style.height=e?"35px":"70px",A.designerTitle.style.visibility=e?"hidden":"visible",this.jsObject.options.buttons.saveReportHotButton.style.display=e?"none":"",this.jsObject.options.buttons.undoButton.style.display=e?"none":"",this.jsObject.options.buttons.redoButton.style.display=e?"none":""};var s=this.CreateHTMLTable();s.style.height="33px",s.style.width="100%",s.style.zIndex="1000",A.insertBefore(s,A.firstChild),this.options.buttons.saveReportHotButton&&(s.addCell(this.options.buttons.saveReportHotButton).style.paddingLeft="10px"),this.options.buttons.undoButton&&s.addCell(this.options.buttons.undoButton),this.options.buttons.redoButton&&s.addCell(this.options.buttons.redoButton),A.designerTitle=s.addCell(),A.designerTitle.style.width="100%",A.designerTitle.style.textAlign="center",this.SetWindowTitle(document.title);for(var n=[["minimizeButton","Window.MinimizeWhite.png"],["maximizeButton","Window.MaximizeWhite.png"],["minimizeToWindowButton","Window.MinimizeToWindow.png"],["closeButton","Window.CloseWhite.png"]],o=0;o<n.length;o++){var i=this.WindowButton(null,null,n[o][1],31,46);i.imageCell&&(i.imageCell.style.padding="0px"),A[n[o][0]]=i,s.addCell(i).style.verticalAlign="top",i.style.webkitAppRegion="no-drag"}var r=-1;A.minimizeButton.action=function(){r=2,win.minimize()},A.maximizeButton.action=function(){win.maximize()},A.minimizeToWindowButton.action=function(){win.restore()},A.closeButton.action=function(){null!=StiDesigner.asyncPromise&&StiDesigner.asyncPromise.abort();var e=A.jsObject;if(e.options.report&&e.options.reportIsModified){var t=e.MessageFormForSave();t.changeVisibleState(!0),t.action=function(A){A?e.options.report.properties.reportFile&&e.options.report.properties.reportFilePath?e.ActionSaveReport(setTimeout(function(){gui.App.quit()},500)):e.ActionSaveReport():gui.App.quit()}}else gui.App.quit()},"undefined"!=typeof win&&(win.on("maximize",function(){r--,A.minimizeToWindowButton.style.display="",A.maximizeButton.style.display="none"}),win.on("restore",function(){r<0?(A.minimizeToWindowButton.style.display="none",A.maximizeButton.style.display="",r=-1):r--})),this.addEvent(A.closeButton,"mouseenter",function(e){A.closeButton.style.background="#e81123"}),this.addEvent(A.closeButton,"mouseleave",function(e){A.closeButton.style.background=""}),this.addEvent(A.closeButton,"mousedown",function(e){A.closeButton.style.background="#f1707a"}),this.addEvent(A.closeButton,"mouseup",function(e){A.closeButton.style.background=A.closeButton.isOver?"#e81123":""});for(var a=["saveReportHotButton","undoButton","redoButton","fileButton","homeToolButton","insertToolButton","layoutToolButton","pageToolButton","previewToolButton","showToolBarButton"],o=0;o<a.length;o++){var i=this.options.buttons[a[o]];i&&(i.style.height="30px",i.style.webkitAppRegion="no-drag",i.innerTable.style.width="100%",i.parentNode.style.verticalAlign="bottom","saveReportHotButton"!=a[o]&&"undoButton"!=a[o]&&"redoButton"!=a[o]||(i.parentNode.style.verticalAlign="top",i.style.marginTop="1px",i.style.minWidth="31px",i.style.height="31px"))}if(this.options.paintPanel&&(this.options.paintPanel.style.top=A.offsetHeight+this.options.workPanel.offsetHeight+"px"),this.options.viewerContainer&&(this.options.viewerContainer.style.top=A.offsetHeight+"px"),this.options.propertiesPanel&&(this.options.propertiesPanel.style.top=A.offsetHeight+this.options.workPanel.offsetHeight+"px"),this.options.toolbox&&(this.options.toolbox.style.top=A.offsetHeight+this.options.workPanel.offsetHeight+"px"),this.localizationControl){this.localizationControl.style.webkitAppRegion="no-drag",this.localizationControl.removeChild(this.options.buttons.localizationButton);var l=Stimulsoft.Base.Localization.StiLocalization[this.localizationControl.locName]["@cultureName"].toUpperCase(),p=this.LoginToolButton("localizationButton",l,null,35,35);p.allwaysEnabled=!0,p.caption.style.textAlign="center";var u=this.options.menus.localizationMenu;u&&(u.style.top=A.offsetHeight+"px",u.style.right="1px",u.innerContent.className="stiCloudReportsWebClientUserMenu",u.innerContent.style.borderTop="0px",p.action=function(){u.parentButton=this,u.changeVisibleState(!u.visible)},u.changeVisibleState=function(A){A?(this.onshow(),this.style.opacity=0,this.style.display="",this.visible=!0,this.parentButton&&this.parentButton.setSelected(!0),this.jsObject.options.currentMenu=this,this.style.width=this.innerContent.offsetWidth+"px",this.style.height=this.innerContent.offsetHeight+"px",this.style.left=this.jsObject.FindPosX(this.parentButton,"stiDesignerMainPanel")-3+"px",this.jsObject.FindPosX(this.parentButton,"stiDesignerMainPanel")+$(this).width()>$(window).width()&&(this.style.left=this.jsObject.FindPosX(this.parentButton,"stiDesignerMainPanel")+$(this.parentButton).width()-$(this).width()+1+"px"),$(this).animate({opacity:1},{duration:this.jsObject.options.formAnimDuration})):(this.visible=!1,this.parentButton&&this.parentButton.setSelected(!1),this.style.display="none",this.jsObject.options.currentMenu==this&&(this.jsObject.options.currentMenu=null))}),this.localizationControl.appendChild(p)}var c=this.LoginToolButton("notificationsButton",null,"Notifications.png",35,35);c.style.webkitAppRegion="no-drag",c.setSelected=function(A){if(this.groupName&&A)for(var e in this.jsObject.options.buttons)this.groupName==this.jsObject.options.buttons[e].groupName&&this.jsObject.options.buttons[e].setSelected(!1);this.isSelected=A,this.image.src=this.jsObject.options.images[A?"NotificationsBlack.png":"Notifications.png"],this.className=(A?this.styles.selected:this.isEnabled?this.isOver?this.styles.over:this.styles.default:this.styles.disabled)+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse")},c.action=function(){};var d=this.LoginToolButton("login",this.loc.Authorization.ButtonLogin,null,35,35);d.allwaysEnabled=!0,d.style.webkitAppRegion="no-drag",d.caption.style.textAlign="center",d.caption.style.padding="0 8px 0 8px",t.addCell(d).style.verticalAlign="bottom",A.loginButton=d,d.action=function(){this.jsObject.options.forms.authForm.show()};var g=this.LoginToolButton("userName","",null,35,35);g.allwaysEnabled=!0,g.style.webkitAppRegion="no-drag",g.style.display="none",t.addCell(g).style.verticalAlign="bottom",A.userNameButton=g;var h=this.CreateHTMLTable();h.style.webkitAppRegion="no-drag",g.nameCell=h.addCell(),g.nameCell.className="stiCloudReportsToolbarUserNameCell",g.caption.appendChild(h),g.userImageCell=g.innerTable.addCell(),this.InitializeUserMenu();var m=this.options.buttons.buttonPublish;m&&(m.style.display="",m.style.height="35px",m.style.webkitAppRegion="no-drag",m.style.margin="0 0 0 10px",m.action=function(){var A=this.jsObject,e=function(){if((!A.options.SessionKey||A.SessionIsOld())&&A.options.UserKey)return A.options.accountSettings=null,A.options.SessionKey=null,A.RemoveAccountSettings(),void A.options.forms.authForm.show(null);gui.Window.open("about:blank",{position:"center",width:1e3,height:800},function(e){var t=e.window;A.options.report?A.SendCommandToDesignerServer("GetReportString",{},function(e){A.InitializePublishForm(function(A){A.show(e.reportString,t)})}):A.InitializePublishForm(function(A){A.show(null,t)})})};if("false"==A.GetCookie("StimulsoftMobileDesignerShowPublishMessage"))e();else{var t=A.MessageFormForPublish();t.changeVisibleState(!0),t.action=function(A){A&&e()}}})},StiJsDesigner.prototype.LoginToolButton=function(A,e,t,s,n){var o=this.SmallButton(A,null,e,t,null,null,this.GetStyles("LoginToolButton"));return o.innerTable.style.width="100%",o.style.cursor="default",s&&(o.style.height=s+"px"),n&&(o.style.minWidth=n+"px"),o.style.marginLeft="4px",o},StiJsDesigner.prototype.WindowButton=function(A,e,t,s,n){var o=this.SmallButton(A,null,e,t,null,null,this.GetStyles("StatusPanelButton"));return o.innerTable.style.width="100%",o.style.cursor="default",s&&(o.style.height=s+"px"),n&&(o.style.minWidth=n+"px"),o.style.marginLeft="1px",o.onmousedown=function(){if(this.isTouchStartFlag||!this.isEnabled)return;this.jsObject.options.buttonPressed=this,this.className=this.styles.selected+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse")},o.onmouseup=function(){if(this.isTouchStartFlag||!this.isEnabled)return;this.className=(this.isOver?this.styles.over:this.styles.default)+(this.jsObject.options.isTouchDevice?"_Touch":"_Mouse")},o},StiJsDesigner.prototype.MessageFormForPublish=function(){var A=this.InitializeMessageForm();return A.messageImage="ReportChecker.Warning32.png",A.messageText=this.loc.Questions.qnRemove,A.caption.innerHTML=this.loc.FormDesigner.title.toUpperCase(),A.messageText=this.loc.Cloud.PublishMessage||"In order to publish this report you should submit it to our service publish.stimulsoft.com",A.buttonYes.caption.innerHTML=this.loc.DesignerFx.Continue,A.oldonshow=A.onshow,A.buttonNo.parentElement.style.padding="8px 0 8px 8px",A.buttonNo.style.display="none",A.onshow=function(){A.oldonshow();var e=this.jsObject.CheckBox(null,this.jsObject.loc.Cloud.DoNotAskMe||"Do not ask me again");e.style.margin="20px 0px 0px 50px",A.container.appendChild(e),e.action=function(){this.jsObject.SetCookie("StimulsoftMobileDesignerShowPublishMessage",this.isChecked?"false":"true")}},A};