﻿;
//browerType = images|other|media
//options - от tinymce
//windowZIndexOptions: {open:int,close:int}
function ShowFileBrowser(browserType, options, windowZIndexOptions) {

    if (!window.kendo) return;

    if ($("#window").length == 0 || $("#browser").length == 0) {
        $("body").append('<div id="window"><div id="browser"></div></div>');
    }

    windowZIndexOptions = windowZIndexOptions || { open: "10004", close: "10005" };

    var i18n = {
        "ru-RU": {
            alert_Messages_invalidFileType: "Недопустимый тип файла! Поддерживаемые типы: {1}",
            alert_Messages_emptyFolder: "Папка пуста",
            alert_Messages_uploadFile: "Загрузить файл",
            alert_Messages_orderByName: "Имя",
            alert_Messages_orderBySize: "Размер",
            alert_Messages_overwriteFile: "Перезаписать файл '{0}'?",
            alert_Messages_deleteFile: "Подтвердите удаление '{0}'",
            alert_Max16: "Максимальный размер загружаемого файла - 32 Мб!",
            alert_Max10: "Максимальный размер загружаемого файла - 32 Мб!",
            label_Search: "Поиск",
            label_OrderBy: "Сортировать по",
            label_DoubleckickToPickUp: "* Двойной щелчок для выбора файла",
            window_Title_file: "Загрузка файла",
            window_Title_image: "Загрузка изображения",
            window_Title_media: "Загрузка видео",
            //alert_directoryNotFound: "Каталог с таким именем не найден.",
            alert_directoryNotFound: "Недопустимый формат файла.",
            label_dropFilesHere: "для загрузки перетащите файлы сюда",
            tooltip_Messages_createFolder: "Создать папку",
            tooltip_Messages_removeElement: "Удалить",
        },
        "en-US": {
            alert_Messages_invalidFileType: "Incorrect file type! Allowed types: {1}",
            alert_Messages_emptyFolder: "Folder is empty",
            alert_Messages_uploadFile: "Upload file",
            alert_Messages_orderByName: "Name",
            alert_Messages_orderBySize: "Size",
            alert_Messages_overwriteFile: "Overwrite '{0}'?",
            alert_Messages_deleteFile: "Are you sure you want to remove '{0}'",
            alert_Max16: "Max file size - 32 Mb!",
            alert_Max10: "Max file size - 32 Mb!",
            label_Search: "Search",
            label_OrderBy: "Arrange by",
            label_DoubleckickToPickUp: "* Double-click to pick up",
            window_Title_file: "File upload",
            window_Title_image: "Image upload",
            window_Title_media: "Media upload",
            //alert_directoryNotFound: "A directory with this name was not found.",
            alert_directoryNotFound: "Incorrect file type!",
            label_dropFilesHere: "drop file here to upload",
            tooltip_Messages_createFolder: "Create folder",
            tooltip_Messages_removeElement: "Remove",
        }
    };

    var browserMessages = {
        invalidFileType: i18n[eqspCulture].alert_Messages_invalidFileType,
        emptyFolder: i18n[eqspCulture].alert_Messages_emptyFolder,
        uploadFile: i18n[eqspCulture].alert_Messages_uploadFile,
        orderByName: i18n[eqspCulture].alert_Messages_orderByName,
        orderBySize: i18n[eqspCulture].alert_Messages_orderBySize,
        overwriteFile: i18n[eqspCulture].alert_Messages_overwriteFile,
        deleteFile: i18n[eqspCulture].alert_Messages_deleteFile,
        orderBy: i18n[eqspCulture].label_OrderBy,
        search: i18n[eqspCulture].label_Search,
        directoryNotFound: i18n[eqspCulture].alert_directoryNotFound,
        dropFilesHere: i18n[eqspCulture].label_dropFilesHere,
        qspCreateFolder: i18n[eqspCulture].tooltip_Messages_createFolder,
        qspRemoveElement: i18n[eqspCulture].tooltip_Messages_removeElement,
    };

    var browserTitles = {
        "files": i18n[eqspCulture].window_Title_file,
        "other": i18n[eqspCulture].window_Title_file,
        "images": i18n[eqspCulture].window_Title_image,
        "media": i18n[eqspCulture].window_Title_media,
    };

    options.userFolder = options.isCommonFolder ? "common" : options.userFolder;

    function getUrl(url) {
        var appendToUrl = "user";

        if (options.isCommonFolder) {
            appendToUrl = "common";
        }

        if (options.isNews) {
            appendToUrl = "news&specifiedFolder=" + options.userFolder;
        }

        return url + "?resourceType=" + appendToUrl;
    }

    function GetFileBrowser() {
        var types = "";

        $.ajax({
            url: window.location.origin + "/api/fileformat/getfilebrowserextentions",
            async: false,
            success: function (data) {
                types = data;
            }
        });

        return $("#browser").kendoFileBrowser({
            fileTypes: types,
            transport: {
                read: getUrl("/api/filebrowser/readfiles/"),
                destroy: {
                    url: getUrl("/api/filebrowser/destroy/"),
                    type: "POST"
                },
                create: {
                    url: getUrl("/api/filebrowser/createfiledir/"),
                    type: "POST"
                },
                uploadUrl: getUrl("/api/filebrowser/uploadfile/"),
            },
            messages: browserMessages,
        }).data("kendoFileBrowser");
    }

    function GetImagesBrowser() {
        var types = "";

        $.ajax({
            url: window.location.origin + "/api/fileformat/getfilebrowserimageextentions",
            async: false,
            success: function (data) {
                data = data + "," + data.toUpperCase();
                types = data;
            }
        });

        return $("#browser").kendoImageBrowser({
            fileTypes: types,
            //fileTypes: ".jpg,.jpeg,.png,.bmp",
            transport: {
                read: getUrl("/api/imagebrowser/readimages/"),
                destroy: {
                    url: getUrl("/api/imagebrowser/destroy"),
                    type: "POST"
                },
                create: {
                    url: getUrl("/api/imagebrowser/createimagedir/"),
                    type: "POST"
                },
                uploadUrl: getUrl("/api/imagebrowser/uploadimage/"),
                thumbnailUrl: getUrl("/api/imagebrowser/thumbnail/"),
            },
            messages: browserMessages
        }).data("kendoImageBrowser");
    }

    function GetMediaBrowser() {
        var types = "";

        $.ajax({
            url: window.location.origin + "/api/fileformat/getfilebrowsermediaextentions",
            async: false,
            success: function (data) {
                types = data;
            }
        });

        return $("#browser").kendoFileBrowser({
            fileTypes: types,
            //fileTypes: ".3gp,.mov,.mp4,.mp3,.wav,.ogg",
            transport: {
                read: getUrl("/api/mediabrowser/readmedia/"),
                destroy: {
                    url: getUrl("/api/mediabrowser/destroy/"),
                    type: "POST"
                },
                create: {
                    url: getUrl("/api/mediabrowser/createmediadir/"),
                    type: "POST"
                },
                uploadUrl: getUrl("/api/mediabrowser/uploadmedia/"),
            },
            messages: browserMessages,
        }).data("kendoFileBrowser");
    }

    var browser = null;
    let uploader;
    switch (browserType) {
        case "images":
            browser = GetImagesBrowser();

            uploader = $(".k-imagebrowser .k-upload input").data("kendoUpload");

            uploader.bind("select", function (e) {
                if (!browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {
                    kendo.confirm(browserMessages.invalidFileType.replace('{1}', browser.options.fileTypes));
                    e.preventDefault();
                    return false;
                }
                if (e.files[0].size > 33554432) {
                    kendo.confirm(i18n[eqspCulture].alert_Max10);
                    e.preventDefault();
                    return false;
                }
                if (browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {
                    uploader.disable();
                    kendo.ui.progress(browser.element, true);
                }
            });

            uploader.bind("complete", function (e) {
                uploader.enable();
                kendo.ui.progress(browser.element, false);
            });

            break;
        case "media":
            browser = GetMediaBrowser();

            uploader = $(".k-filebrowser .k-upload input").data("kendoUpload");

            uploader.bind("select", function (e) {
                if (!browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {

                    kendo.confirm(browserMessages.invalidFileType.replace('{1}', browser.options.fileTypes));
                    e.preventDefault();
                    return false;
                }
                if (e.files[0].size > 33554432) {
                    kendo.confirm(i18n[eqspCulture].alert_Max16);
                    e.preventDefault();
                    return false;
                }
                if (browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {
                    uploader.disable();
                    kendo.ui.progress(browser.element, true);
                }
            });

            uploader.bind("complete", function (e) {
                uploader.enable();
                kendo.ui.progress(browser.element, false);
            });

            break;
        case "other":
        case "files":
            browser = GetFileBrowser();

            uploader = $(".k-filebrowser .k-upload input").data("kendoUpload");
            uploader.bind("select", function (e) {
                if (!browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {

                    kendo.confirm(browserMessages.invalidFileType.replace('{1}', browser.options.fileTypes));
                    e.preventDefault();
                    return false;
                }
                if (e.files[0].size > 33554432) {
                    kendo.confirm(i18n[eqspCulture].alert_Max16);
                    e.preventDefault();
                    return false;
                }
                if (browser.options.fileTypes.includes(e.files[0].extension.slice(1))) {
                    uploader.disable();
                    kendo.ui.progress(browser.element, true);
                }
            });

            uploader.bind("complete", function (e) {
                uploader.enable();
                kendo.ui.progress(browser.element, false);
            });
    };

    var _kendoWindow = $("#window").kendoWindow({
        modal: true,
        width: 600,
        resizable: false,
        title: browserTitles[browserType],
        open: function () {
            //$(".k-window").css("z-index", windowZIndexOptions.open); //у заура было 70000
        },
        close: function () {
            _kendoWindow.destroy();
            $("body").append('<div id="window"><div id="browser"></div></div>');
            //$(".k-window").css("z-index", windowZIndexOptions.close);
        }
    }).data("kendoWindow");

    $("#browser").append('<div class="fs--1 text-primary font-weight-bold">' + i18n[eqspCulture].label_DoubleckickToPickUp + '</div>');

    _kendoWindow.center();

    return {
        browser: browser,
        window: _kendoWindow
    };

}
