   ;

   //требует кендо и джейкуареи

   var Notification = (function(culture) {

    if (!window.kendo) return;

     var returnObject = Object.create(null);
     var notificationCentered = null,
         notificationRightBottom = null,
         notificationRight = null,

     culture = culture || "ru-RU";

     var messages = {
       "ru-RU": {
         error: "Ошибка!",
         success: "Успешно!"
       },
       "en-US": {
         error: "Error!",
         success: "Success!"
       }
     };

     function init(timeout) {
         if ($("#notification").length == 0 && !notificationCentered && !notificationRightBottom && !notificationRight) {
         $("body").append('<span id="notification" style="display:none;"></span>');

         notificationCentered = $("#notification").kendoNotification({
           show: onShow,
           autoHideAfter: timeout || 3500,
           button: true,
           stacking: "up",
           templates: [{
             type: "error",
             template: '<div class="alert p-0 m-0">' +
               '<h4 class="alert-heading">#= header #</h4>' +
               '<p class="mb-2">#= message #</p>' +
               '</div>'
           }]
         }).data("kendoNotification");

         notificationRightBottom = $("#notification").kendoNotification({
           position: {
             pinned: true,
             top: null,
             left: null,
             bottom: 50,
             right: 50
           },
           autoHideAfter: timeout || 1500,
           button: true,
           stacking: "up",
           templates: [{
             type: "success",
             template: '<div class="alert p-0 m-0">' +
               '<h4 class="alert-heading">#= header #</h4>' +
               '<p class="mb-2">#= message #</p>' +
               '</div>'
           }]
         }).data("kendoNotification");

         notificationRight = $("#notification").kendoNotification({
             autoHideAfter: timeout || 1500,
             button: true,
             stacking: "up",
             templates: [{
                 type: "info",
                 template: '<div class="alert p-0 m-0">' +
                 '<h4 class="alert-heading">#= header #</h4>' +
                 '<p class="mb-2">#= message #</p>' +
                 '</div>'
             }]
         }).data("kendoNotification");
       }
     }

     function onShow(e) {
       if (e.sender.getNotifications().length == 1) {
         var element = e.element.parent(),
           eWidth = element.width(),
           eHeight = element.height(),
           wWidth = $(window).width(),
           wHeight = $(window).height(),
           newTop, newLeft;

         newLeft = Math.floor(wWidth / 2 - eWidth / 2);
         newTop = Math.floor(wHeight / 2 - eHeight / 2);

         e.element.parent().css({
           top: newTop,
           left: newLeft
         });

         e.element.parent().css("z-index", "10004");
       }
     }

     returnObject.ShowError = function(message, header, timeout) {
         init(timeout);
         if (header === undefined) {
             notificationCentered.show({
                 message: message,
                 header: messages[culture].error
             }, "error");
         }
         else
         {
             notificationCentered.show({
                 message: message,
                 header: header
             }, "error");
         }

     }

     returnObject.ShowSuccess = function (message, header, timeout) {
         init(timeout);
         if (header === undefined) {
            notificationRightBottom.show({
                 message: message,
                 header: messages[culture].success
             }, "success");
         }
         else
         {
            notificationRightBottom.show({
                 message: message,
                 header: header
             }, "success");
         }
     }

     returnObject.ShowInfo = function (message, header, timeout) {
         init(timeout);
         if (header === undefined) {
             notificationRight.show({
                 message: message,
                 header: messages[culture].success
             }, "info");
         }
         else {
             notificationRight.show({
                 message: message,
                 header: header
             }, "info");
         }
     }

     return returnObject;

   })(eqspCulture)
