﻿function dropfilter(viewLogic) {
    resetFilterClass();

    viewLogic('01.01.0001', '01.01.0001', null, null);

    $("#startCalendar").val(new Date().toLocaleDateString());
    $("#endCalendar").val(new Date().toLocaleDateString());
}

function onShow(container) {
    //ClearFilterWindow();
    if ($("#cases").children().length === 0) {
        ConfigureFilterWindow(container);
    }

    let filterWindow = $("#" + container).kendoWindow({
        modal: true
    });
    filterWindow.data("kendoWindow").open().center();
}

function onClose(container) {
    $("#" + container).data("kendoWindow").close();
}

function getQuestionsTypes() {
    let types =
    {
        tables: ["questionnaire_table", "test_table"],
        matrix: ["questionnaire_matrix"],
        dropdowns: ["questionnaire_autocomplete", "questionnaire_single", "questionnaire_dropdown", "test_single", "test_single_undefined", "extended_dropdown"],
        multiselects: ["test_multy_undefined", "questionnaire_multy", "extended_multy", "test_multy"],
        nps: ["questionnaire_nps"],
        oneSliderScales: ["questionnaire_scale", "questionnaire_rating", "test_scale"],
        twoSliderScales: ["questionnaire_scale_two_slide"],
        dates: ["questionnaire_date"],
    };

    return types;
}

function Filter(windowId, clicked_id, viewLogic) {
    addActiveToClicked(clicked_id);

    let questionTypes = getQuestionsTypes();
    let questions = [];
    let answers = [];
    let cases = $(".cases").toArray();

    if (cases.length > 0) {
        cases.forEach(x => {

            let questionId = $(x).attr("id").split("_")[1];
            let questionType = $(x).attr("class").split(" ")[1];
            let answer;

            if (questionTypes.tables.includes(questionType) ||
                questionTypes.matrix.includes(questionType)) {

                let answer1 = $("#filter_for_1_" + questionId).data("kendoDropDownList").value();
                let answer2 = $("#filter_for_2_" + questionId).data("kendoDropDownList").value();
                answer = answer1 && answer2 ? answer1 + "-" + answer2 : answer1 + answer2;
            }
            else if (questionTypes.multiselects.includes(questionType)) {
                answer = $("#filter_for_" + questionId).data("kendoMultiSelect").value();
            }
            else if (questionTypes.dropdowns.includes(questionType)) {
                answer = $("#filter_for_" + questionId).data("kendoDropDownList").value();
            }
            else if (questionTypes.dates.includes(questionType)) {
                let answer1 = $("#filter_for_" + questionId).val();
                answer = answer1 == "" ? undefined : new Date(answer1).toLocaleDateString();
            }
            else if (questionTypes.twoSliderScales.includes(questionType)) {
                let answer1 = $("#filter_for_1_" + questionId).val();
                let answer2 = $("#filter_for_2_" + questionId).val();
                answer = answer1 && answer2 ? answer1 + "-" + answer2 : answer1 + answer2;
            }
            else {
                answer = $("#filter_for_" + questionId).val();
            }

            if (answer != "" && answer != undefined) {
                answers.push(answer);
                questions.push(questionId);
            }
        })
    }

    var starts = new Date($("#startCalendar").data("kendoDatePicker").value()).toLocaleDateString();
    var ends = new Date($("#endCalendar").data("kendoDatePicker").value()).toLocaleDateString();

    viewLogic(starts, ends, questions, answers);
    onClose(windowId);
}

function addQuestionCase(mainContainer, question, answersOpts) {
    if (question.Type == "questionnaire_textblock") {
        return;
    }

    let questionTypes = getQuestionsTypes();

    //let template = "<div id='case_" + question.Id + "' class='cases " + (question.Type == "questionnaire_extended" ? question.InputType : question.Type) + "'><h6>" + question.Text.replace(/<[^>]*>?/gm, '') + "</h6>";

    let template = `
        <div id="case_${question.Id}" class="cases ${question.Type === "questionnaire_extended" ? question.InputType : question.Type}">
            <h6>${question.Text.replace(/<[^>]*>?/gm, '')}</h6>
        `;

    if (questionTypes.tables.includes(question.Type)) {

        template += `
            <input id="filter_for_1_${question.Id}"/>
            <input id="filter_for_2_${question.Id}"/>
        </div>`;

        $("#cases").append(template);

        $("#filter_for_1_" + question.Id).kendoDropDownList({
            dataSource: {
                data: answersOpts,
                schema: {
                    model: {
                        id: "Id",
                        fields: {
                            TextA: { type: "string" },
                        }
                    }
                },
            },
            optionLabel: "Выберите значение",
            dataTextField: "TextA",
            dataValueField: "TextA"
        })

        $("#filter_for_2_" + question.Id).kendoDropDownList({
            dataSource: {
                data: answersOpts,
                schema: {
                    model: {
                        id: "Id",
                        fields: {
                            TextB: { type: "string" },
                        }
                    }
                },
            },
            optionLabel: "Выберите значение",
            dataTextField: "TextB",
            dataValueField: "TextB"
        })
    }
    else if (questionTypes.matrix.includes(question.Type)) {

        template += `
            <input id="filter_for_1_${question.Id}" class="${question.Type}"/>
            <input id="filter_for_2_${question.Id}" class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);

        $("#filter_for_1_" + question.Id).kendoDropDownList({
            dataSource: {
                data: answersOpts.filter(x => x.TextA != null).sort(x => x.TextA),
                schema: {
                    model: {
                        id: "Id",
                        fields: {
                            TextA: { type: "string" },
                        }
                    }
                },
            },
            optionLabel: "Выберите значение",
            dataTextField: "TextA",
            dataValueField: "TextA"
        })

        $("#filter_for_2_" + question.Id).kendoDropDownList({
            dataSource: {
                data: answersOpts.filter(x => x.TextB != null).sort(x => x.TextB),
                schema: {
                    model: {
                        id: "Id",
                        fields: {
                            TextB: { type: "string" },
                        }
                    }
                },
            },
            optionLabel: "Выберите значение",
            dataTextField: "TextB",
            dataValueField: "TextB"
        })
    }
    else if (questionTypes.dropdowns.includes(question.Type) || questionTypes.dropdowns.includes(question.InputType)) {

        template += `
            <input id="filter_for_${question.Id}" class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);

        $("#filter_for_" + question.Id).kendoDropDownList({
            dataSource: {
                data: answersOpts,
                schema: {
                    model: {
                        id: "Id",
                        fields: {
                            Text: { type: "string" },
                        }
                    }
                },
            },
            optionLabel: "Выберите значение",
            dataTextField: "Text",
            dataValueField: "Text"
        })
    }
    else if (questionTypes.multiselects.includes(question.Type) || questionTypes.multiselects.includes(question.InputType)) {

        template += `
            <input id="filter_for_${question.Id}" class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);

        $("#filter_for_" + question.Id).kendoMultiSelect({
            dataSource: {
                data: answersOpts,
                schema: {
                    model: {
                        id: "QuestionId",
                        fields: {
                            Text: { type: "string" }
                        }
                    }
                }
            },
            placeholder: "Выберите значения",
            dataTextField: "Text",
            dataValueField: "Text"
        })
    }
    else if (questionTypes.nps.includes(question.Type)) {

        template += `
            <input type="number" min="0" max="10" step="1" id="filter_for_${question.Id}" class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);
    }
    else if (questionTypes.oneSliderScales.includes(question.Type)) {

        template += `
            <input type="number" 
                   min="${question.ScaleMin}" 
                   max="${question.ScaleMax}" 
                   step="${question.ScaleStep === 0 ? 0 : question.ScaleStep}" 
                   id="filter_for_${question.Id}" 
                   class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);
    }
    else if (questionTypes.twoSliderScales.includes(question.Type)) {

        template += `
            <input type="number" 
                   min="${question.ScaleMin}" 
                   max="${question.ScaleMax}" 
                   step="${question.ScaleStep === 0 ? 0 : question.ScaleStep}" 
                   id="filter_for_1_${question.Id}" 
                   class="${question.Type}"/>
           
            <input type="number" 
                   min="${question.ScaleMin}" 
                   max="${question.ScaleMax}" 
                   step="${question.ScaleStep === 0 ? 0 : question.ScaleStep}" 
                   id="filter_for_2_${question.Id}" 
                   class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);
    }
    else if (questionTypes.dates.includes(question.Type)) {

        template += `
            <input type="date" 
                   id="filter_for_${question.Id}" 
                   class="${question.Type}"/>
        </div>`;

        $("#cases").append(template);

        let datePicker = $("#filter_for_" + question.Id).kendoDatePicker({}).data("kendoDatePicker");

        question.MaxDate != null ? datePicker.max(question.MaxDate) : undefined;
        question.MinDate != null ? datePicker.min(question.MinDate) : undefined;
        question.MaxDateScale != null ? datePicker.max(question.MaxDateScale) : undefined;
        question.MinDateScale != null ? datePicker.min(question.MinDateScale) : undefined;
    }
    else {

        template += `
            <input id="filter_for_${question.Id}" 
                   class="${question.Type}" 
                   placeholder="Введите значение"/>
        </div>`;

        $("#cases").append(template);
    }

    $("#" + mainContainer).data("kendoWindow").center();
}

function getQuestions(start, end, questions, answers) {
    return $.ajax({
        url: '/api/reports/GetQuestionsByQuestionnarieId?qId=' + qID + "&start=" + start + "&end=" + end + "&questions=" + questions + "&answers=" + answers + "&take=20",
        type: 'GET',
        dataType: "json",
    })
}

function ConfigureFilterWindow(container) {
    getQuestions("01.01.0001", "01.01.0001", null, null).then(questions => {
        questions.forEach(question => {
            // для этих типов вопросов не нужны answerOptions.
            if (["questionnaire_scale", "questionnaire_scale_two_slide", "questionnaire_rating", "questionnaire_nps", "questionnaire_date"].includes(question.Type)) {
                addQuestionCase(container, question, null);
            }
            else {
                $.ajax({
                    url: "/api/reports/GetAnswerOptions?questionId=" + question.Id + "&questionType=" + question.Type,
                    type: "GET",
                    dataType: "json",
                    async: false
                }).then(answersOpts => {
                    addQuestionCase(container, question, answersOpts);
                })
            }
        })
    });
}

function ClearFilterWindow() {
    $("#cases").empty();
}

function getMonday(date) {
    var day = date.getDay() || 7;
    if (day !== 1)
        date.setHours(-24 * (day - 1));
    return date;
}

function getSunday(date) {
    var day = date.getDay() || 7;
    if (day !== 7)
        date.setHours(24 * (7 - day));
    return date;
}

function addActiveToClicked(clicked_id) {
    if (clicked_id == "Accept") {
        $(".diagram-property .filter-holder.btn-group input").removeClass("active");
        $("#filter").addClass("active");
    } else {
        var clickedEl = $("#" + clicked_id);
        $(clickedEl).parent().find("input").removeClass("active");
        $(clickedEl).addClass("active");
    }
}

function resetFilterClass() {
    $("#filter").removeClass("active");
}

var Today = function (clicked_id, viewLogic) {

    addActiveToClicked(clicked_id);

    var today = new Date().toLocaleDateString();
    viewLogic(today, today, null, null)
}

var Week = function (clicked_id, viewLogic) {

    addActiveToClicked(clicked_id);

    var starts = getMonday(new Date()).toLocaleDateString();
    var ends = getSunday(new Date()).toLocaleDateString();

    viewLogic(starts, ends, null, null);
}

var Month = function (clicked_id, viewLogic) {

    addActiveToClicked(clicked_id);

    var date = new Date();
    var firstDay = new Date(date.getFullYear(), date.getMonth(), 1).toLocaleDateString();
    var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0).toLocaleDateString();

    viewLogic(firstDay, lastDay, null, null);
}

const pdfModes = {
    answers: {
        savingName: "Answers.pdf",
        sliceIndex: 1,
        landscape: false
    },
    attendance:
    {
        savingName: "Attendance.pdf",
        sliceIndex: 0,
        landscape: true
    },
}

function getPDF(selector, mode) {
    //ширина 1800px графика нужна для корректной отрисовки графика в версии для печати
    $(".empty_textblock").addClass("col-lg-6 col-xxl-4");

    let options = {
        multiPage: true,
        paperSize: "a4",
        margin: {
            left: "1cm",
            right: "1cm",
            top: "1cm",
            bottom: "1cm",
        },
        landscape: mode.landscape
    };

    let rootGroup = new kendo.drawing.Group();

    kendo.drawing.drawDOM($(".card.mb-3")[0]).then(group => {
        rootGroup.append(group);

        kendo.drawing.drawDOM(
            $(selector), {
            forcePageBreak: ".divBreak"
        }).then(function (group) {
            group.children.slice(mode.sliceIndex).forEach(x => {
                rootGroup.children.push(x);
            })
            rootGroup.options.set("pdf", options);
            kendo.drawing.pdf.saveAs(rootGroup, mode.savingName);
            $(".empty_textblock").removeClass("col-lg-6 col-xxl-4");
        });
    })
    return false;
}


