"use strict";

var _this = this;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*-----------------------------------------------
|   Theme Configuration
-----------------------------------------------*/
var storage = {
  isDark: false
};
"use strict";
/*-----------------------------------------------
|   Utilities
-----------------------------------------------*/


var utils = function ($) {
  var grays = function grays() {
    var colors = {
      white: "#fff",
      "100": "#f9fafd",
      "200": "#edf2f9",
      "300": "#d8e2ef",
      "400": "#b6c1d2",
      "500": "#9da9bb",
      "600": "#748194",
      "700": "#5e6e82",
      "800": "#4d5969",
      "900": "#344050",
      "1000": "#232e3c",
      "1100": "#0b1727",
      black: "#000"
    };

    if (storage.isDark) {
      colors = {
        white: "#0e1c2f",
        "100": "#132238",
        "200": "#061325",
        "300": "#344050",
        "400": "#4d5969",
        "500": "#5e6e82",
        "600": "#748194",
        "700": "#9da9bb",
        "800": "#b6c1d2",
        "900": "#d8e2ef",
        "1000": "#edf2f9",
        "1100": "#f9fafd",
        black: "#fff"
      };
    }

    return colors;
  };

  var themeColors = function themeColors() {
    var colors = {
      primary: "#2c7be5",
      secondary: "#748194",
      success: "#00d27a",
      info: "#27bcfd",
      warning: "#f5803e",
      danger: "#e63757",
      light: "#f9fafd",
      dark: "#0b1727"
    };

    if (storage.isDark) {
      colors.light = grays()["100"];
      colors.dark = grays()["1100"];
    }

    return colors;
  };

  var pluginSettings = function pluginSettings() {
    var settings = {
      tinymce: {
        theme: "oxide"
      },
      chart: {
        borderColor: "rgba(255, 255, 255, 0.8)"
      }
    };

    if (storage.isDark) {
      settings.tinymce.theme = "oxide-dark";
      settings.chart.borderColor = themeColors().primary;
    }

    return settings;
  };

  var Utils = {
    $window: $(window),
    $document: $(document),
    $html: $("html"),
    $body: $("body"),
    $main: $("main"),
    isRTL: function isRTL() {
      return this.$html.attr("dir") === "rtl";
    },
    location: window.location,
    nua: navigator.userAgent,
    breakpoints: {
      xs: 0,
      sm: 576,
      md: 768,
      lg: 992,
      xl: 1200,
      xxl: 1540
    },
    colors: themeColors(),
    grays: grays(),
    offset: function offset(element) {
      var rect = element.getBoundingClientRect();
      var scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
      var scrollTop = window.pageYOffset || document.documentElement.scrollTop;
      return {
        top: rect.top + scrollTop,
        left: rect.left + scrollLeft
      };
    },
    isScrolledIntoViewJS: function isScrolledIntoViewJS(element) {
      var windowHeight = window.innerHeight;
      var elemTop = this.offset(element).top;
      var elemHeight = element.offsetHeight;
      var windowScrollTop = window.scrollY;
      return elemTop <= windowScrollTop + windowHeight && windowScrollTop <= elemTop + elemHeight;
    },
    isScrolledIntoView: function isScrolledIntoView(el) {
      var $el = $(el);
      var windowHeight = this.$window.height();
      var elemTop = $el.offset().top;
      var elemHeight = $el.height();
      var windowScrollTop = this.$window.scrollTop();
      return elemTop <= windowScrollTop + windowHeight && windowScrollTop <= elemTop + elemHeight;
    },
    getCurrentScreanBreakpoint: function getCurrentScreanBreakpoint() {
      var _this2 = this;

      var currentScrean = "";
      var windowWidth = this.$window.width();
      $.each(this.breakpoints, function (index, value) {
        if (windowWidth >= value) {
          currentScrean = index;
        } else if (windowWidth >= _this2.breakpoints.xl) {
          currentScrean = "xl";
        }
      });
      return {
        currentScrean: currentScrean,
        currentBreakpoint: this.breakpoints[currentScrean]
      };
    },
    hexToRgb: function hexToRgb(hexValue) {
      var hex;
      hexValue.indexOf("#") === 0 ? hex = hexValue.substring(1) : hex = hexValue; // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")

      var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
      var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
      }));
      return result ? [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16)] : null;
    },
    rgbColor: function rgbColor(color) {
      if (color === void 0) {
        color = "#fff";
      }

      return "rgb(" + this.hexToRgb(color) + ")";
    },
    rgbaColor: function rgbaColor(color, alpha) {
      if (color === void 0) {
        color = "#fff";
      }

      if (alpha === void 0) {
        alpha = 0.5;
      }

      return "rgba(" + this.hexToRgb(color) + ", " + alpha + ")";
    },
    rgbColors: function rgbColors() {
      var _this3 = this;

      return Object.keys(this.colors).map(function (color) {
        return _this3.rgbColor(_this3.colors[color]);
      });
    },
    rgbaColors: function rgbaColors() {
      var _this4 = this;

      return Object.keys(this.colors).map(function (color) {
        return _this4.rgbaColor(_this4.colors[color]);
      });
    },
    settings: pluginSettings(_this),
    isIterableArray: function isIterableArray(array) {
      return Array.isArray(array) && !!array.length;
    },
    setCookie: function setCookie(name, value, expire) {
      var expires = new Date();
      expires.setTime(expires.getTime() + expire);
      document.cookie = name + "=" + value + ";expires=" + expires.toUTCString();
    },
    getCookie: function getCookie(name) {
      var keyValue = document.cookie.match("(^|;) ?" + name + "=([^;]*)(;|$)");
      return keyValue ? keyValue[2] : keyValue;
    },
    getBreakpoint: function getBreakpoint($element) {
      var classes = $element.attr("class");
      var breakpoint;

      if (classes) {
        breakpoint = this.breakpoints[classes.split(" ").filter(function (cls) {
          return cls.indexOf("navbar-expand-") === 0;
        }).pop().split("-").pop()];
      }

      return breakpoint;
    }
  };
  return Utils;
}(jQuery);

'use strict';
/*-----------------------------------------------
|   Top navigation opacity on scroll
-----------------------------------------------*/


utils.$document.ready(function () {
  var $navbar = $('.navbar-theme');

  if ($navbar.length) {
    var windowHeight = utils.$window.height();
    utils.$window.scroll(function () {
      var scrollTop = utils.$window.scrollTop();
      var alpha = scrollTop / windowHeight * 2;
      alpha >= 1 && (alpha = 1);
      $navbar.css({
        'background-color': "rgba(11, 23, 39, " + alpha + ")"
      });
    }); // Fix navbar background color [after and before expand]

    var classList = $navbar.attr('class').split(' ');
    var breakpoint = classList.filter(function (c) {
      return c.indexOf('navbar-expand-') >= 0;
    })[0].split('navbar-expand-')[1];
    utils.$window.resize(function () {
      if (utils.$window.width() > utils.breakpoints[breakpoint]) {
        return $navbar.removeClass('bg-dark');
      } else if (!$navbar.find('.navbar-toggler').hasClass('collapsed')) {
        return $navbar.addClass('bg-dark');
      }

      return null;
    }); // Top navigation background toggle on mobile

    $navbar.on('show.bs.collapse hide.bs.collapse', function (e) {
      $(e.currentTarget).toggleClass('bg-dark');
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Select menu [bootstrap 4]
-----------------------------------------------*/


utils.$document.ready(function () {
  // https://getbootstrap.com/docs/4.0/getting-started/browsers-devices/#select-menu
  // https://github.com/twbs/bootstrap/issues/26183
  window.is.android() && $('select.form-control').removeClass('form-control').css('width', '100%');
});
"use strict";
/*-----------------------------------------------
|   Detector
-----------------------------------------------*/


utils.$document.ready(function () {
  if (window.is.opera()) utils.$html.addClass("opera");
  if (window.is.mobile()) utils.$html.addClass("mobile");
  if (window.is.firefox()) utils.$html.addClass("firefox");
  if (window.is.safari()) utils.$html.addClass("safari");
  if (window.is.ios()) utils.$html.addClass("ios");
  if (window.is.iphone()) utils.$html.addClass("iphone");
  if (window.is.ipad()) utils.$html.addClass("ipad");
  if (window.is.ie()) utils.$html.addClass("ie");
  if (window.is.edge()) utils.$html.addClass("edge");
  if (window.is.chrome()) utils.$html.addClass("chrome");
  if (utils.nua.match(/puppeteer/i)) utils.$html.addClass("puppeteer");
  if (window.is.mac()) utils.$html.addClass("osx");
  if (window.is.windows()) utils.$html.addClass("windows");
  if (navigator.userAgent.match("CriOS")) utils.$html.addClass("chrome");
});
'use strict';
/*-----------------------------------------------
|   Bootstrap validation
-----------------------------------------------*/


utils.$document.ready(function () {
  window.addEventListener('load', function () {
    // Fetch all the forms we want to apply theme Bootstrap validation styles to
    var forms = document.getElementsByClassName('needs-validation'); // Loop over them and prevent submission

    Array.prototype.filter.call(forms, function (form) {
      form.addEventListener('submit', function (event) {
        if (form.checkValidity() === false) {
          event.preventDefault();
          event.stopPropagation();
        }

        form.classList.add('was-validated');
      }, false);
    });
  }, false);
});
'use strict';
/*
  global Stickyfill
*/

/*-----------------------------------------------
|   Sticky fill
-----------------------------------------------*/


utils.$document.ready(function () {
  Stickyfill.add($('.sticky-top'));
  Stickyfill.add($('.sticky-bottom'));
});
"use strict";
/*-----------------------------------------------
|   Sticky Kit
-----------------------------------------------*/


utils.$document.ready(function () {
  if (window.is.ie()) {
    var stickyKits = $(".sticky-kit");

    if (stickyKits.length) {
      stickyKits.each(function (index, value) {
        var $this = $(value);

        var options = _objectSpread({}, $this.data("options"));

        $this.stick_in_parent(options);
      });
    }
  }
});
"use strict";
/*-----------------------------------------------
|   Tootltip [bootstrap 4]
-----------------------------------------------*/


utils.$document.ready(function () {
  // https://getbootstrap.com/docs/4.0/components/tooltips/#example-enable-tooltips-everywhere
  $('[data-toggle="tooltip"]').tooltip();
  $('[data-toggle="popover"]').popover();
});
'use strict';
/*-----------------------------------------------
|   Navbar
-----------------------------------------------*/


utils.$document.ready(function () {
  var $window = utils.$window;
  var navDropShadowFlag = true;
  var ClassName = {
    SHOW: 'show',
    NAVBAR_GLASS_SHADOW: 'navbar-glass-shadow',
    NAVBAR_VERTICAL_COLLAPSED: 'navbar-vertical-collapsed',
    NAVBAR_VERTICAL_COLLAPSE_HOVER: 'navbar-vertical-collapsed-hover'
  };
  var Selector = {
    HTML: 'html',
    NAVBAR: '.navbar:not(.navbar-vertical)',
    NAVBAR_VERTICAL: '.navbar-vertical',
    NAVBAR_VERTICAL_TOGGLE: '.navbar-vertical-toggle',
    NAVBAR_VERTICAL_COLLAPSE: '#navbarVerticalCollapse',
    NAVBAR_VERTICAL_CONTENT: '.navbar-vertical-content',
    NAVBAR_VERTICAL_COLLAPSED: '.navbar-vertical-collapsed',
    NAVBAR_VERTICAL_DROPDOWN_NAV: '.navbar-vertical .navbar-collapse .nav',
    NAVBAR_VERTICAL_COLLAPSED_DROPDOWN_NAV: '.navbar-vertical-collapsed .navbar-vertical .navbar-collapse .nav',
    MAIN_CONTENT: '.main .content',
    NAVBAR_TOP: '.navbar-top',
    OWL_CAROUSEL: '.owl-carousel',
    ECHART_RESPONSIVE: '[data-echart-responsive]'
  };
  var Events = {
    LOAD_SCROLL: 'load scroll',
    SCROLL: 'scroll',
    CLICK: 'click',
    RESIZE: 'resize',
    SHOW_BS_COLLAPSE: 'show.bs.collapse',
    HIDDEN_BS_COLLAPSE: 'hidden.bs.collapse'
  };
  var $html = $(Selector.HTML);
  var $navbar = $(Selector.NAVBAR);
  var $navbarVerticalCollapse = $(Selector.NAVBAR_VERTICAL_COLLAPSE);
  var $navbarVerticalContent = $(Selector.NAVBAR_VERTICAL_CONTENT);
  var navbarVertical = $(Selector.NAVBAR_VERTICAL);
  var breakPoint = utils.getBreakpoint(navbarVertical);

  var setDropShadow = function setDropShadow($elem) {
    if ($elem.scrollTop() > 0 && navDropShadowFlag) {
      $navbar.addClass(ClassName.NAVBAR_GLASS_SHADOW);
    } else {
      $navbar.removeClass(ClassName.NAVBAR_GLASS_SHADOW);
    }
  };

  $window.on(Events.LOAD_SCROLL, function () {
    return setDropShadow($window);
  });
  $navbarVerticalContent.on('scroll', function () {
    if ($window.width() < breakPoint) {
      navDropShadowFlag = true;
      setDropShadow($navbarVerticalContent);
    }
  });
  $navbarVerticalCollapse.on(Events.SHOW_BS_COLLAPSE, function () {
    if ($window.width() < breakPoint) {
      navDropShadowFlag = false;
      setDropShadow($window);
    }
  });
  $navbarVerticalCollapse.on(Events.HIDDEN_BS_COLLAPSE, function () {
    if ($navbarVerticalCollapse.hasClass(ClassName.SHOW) && $window.width() < breakPoint) {
      navDropShadowFlag = false;
    } else {
      navDropShadowFlag = true;
    }

    setDropShadow($window);
  }); // Expand or Collapse vertical navbar on mouse over and out

  $navbarVerticalCollapse.hover(function (e) {
    setTimeout(function () {
      if ($(e.currentTarget).is(':hover')) {
        $(Selector.NAVBAR_VERTICAL_COLLAPSED).addClass(ClassName.NAVBAR_VERTICAL_COLLAPSE_HOVER);
      }
    }, 100);
  }, function () {
    $(Selector.NAVBAR_VERTICAL_COLLAPSED).removeClass(ClassName.NAVBAR_VERTICAL_COLLAPSE_HOVER);
  }); // Set navbar top width from content

  var setNavbarWidth = function setNavbarWidth() {
    var contentWidth = $(Selector.MAIN_CONTENT).width() + 30;
    $(Selector.NAVBAR_TOP).outerWidth(contentWidth);
  }; // Toggle navbar vertical collapse on click


  utils.$document.on(Events.CLICK, Selector.NAVBAR_VERTICAL_TOGGLE, function (e) {
    // Set collapse state on localStorage
    var isNavbarVerticalCollapsed = JSON.parse(localStorage.getItem('isNavbarVerticalCollapsed'));
    localStorage.setItem('isNavbarVerticalCollapsed', !isNavbarVerticalCollapsed); // Toggle class

    $html.toggleClass(ClassName.NAVBAR_VERTICAL_COLLAPSED); // Set navbar top width

    setNavbarWidth(); // Refresh Echarts

    var $echarts = document.querySelectorAll(Selector.ECHART_RESPONSIVE);

    if (!!$echarts.length) {
      $.each($echarts, function (item, value) {
        if (!!$(value).data('echart-responsive')) {
          window.echarts.init(value).resize();
        }
      });
    }

    $(e.currentTarget).trigger('navbar.vertical.toggle');
  }); // Set navbar top width on window resize

  $window.on(Events.RESIZE, function () {
    setNavbarWidth();
  });
});
'use strict';
/*-----------------------------------------------
|   Emoji Picker
-----------------------------------------------*/


utils.$document.ready(function () {
  var Event = {
    FOCUS: 'focus'
  };
  var Selector = {
    EMOJIAREA: '.emojiarea'
  };
  var DATA_KEY = {
    OPTIONS: 'options'
  };
  var emojioneareas = $(Selector.EMOJIAREA); // Place the Blinking Text Cursor at the end of the editor text

  var placeCaretAtEnd = function placeCaretAtEnd(el) {
    if (!!window.getSelection && !!document.createRange) {
      var range = document.createRange();
      range.selectNodeContents(el);
      range.collapse(false);
      var sel = window.getSelection();
      sel.removeAllRanges();
      sel.addRange(range);
    } else if (!!document.body.createTextRange) {
      var textRange = document.body.createTextRange();
      textRange.moveToElementText(el);
      textRange.collapse(false);
      textRange.select();
    }
  }; // EmojioneArea plugin call


  if (emojioneareas.length) {
    emojioneareas.each(function (item, value) {
      var $this = $(value);
      var options = $.extend({}, $this.data(DATA_KEY.OPTIONS));
      $this.emojioneArea(options); // // Call the caret position function on focus

      emojioneareas[item].emojioneArea.on(Event.FOCUS, function ($editor) {
        placeCaretAtEnd($editor.get(0));
      });
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Animated progressbar
-----------------------------------------------*/


utils.$document.ready(function () {
  var toggle = $('#progress-toggle-animation');
  toggle.on('click', function () {
    return $('#progress-toggle').toggleClass('progress-bar-animated');
  });
});
"use strict";
/*-----------------------------------------------
|   Bootstrap Wizard
-----------------------------------------------*/


utils.$document.ready(function () {
  var Selector = {
    DATA_WIZARD: "[data-wizard]",
    PREVIOUS_BUTTON: ".previous .btn",
    TAB_PANE: ".tab-pane",
    FORM_VALIDATION: ".form-validation",
    NAV_ITEM_CIRCLE: ".nav-item-circle",
    NAV_ITEM: ".nav-item",
    NAV_LINK: ".nav-link",
    WIZARD_LOTTIE: ".wizard-lottie"
  };
  var ClassName = {
    ACTIVE: "active",
    DONE: "done",
    NAV: "nav"
  };
  var DATA_KEY = {
    OPTIONS: "options",
    WIZARD_STATE: "wizard-state",
    CONTROLLER: "controller",
    ERROR_MODAL: "error-modal"
  };
  var wizards = $(Selector.DATA_WIZARD);

  var isFormValidate = function isFormValidate($currentTab) {
    var $currentTabForms = $currentTab.find(Selector.FORM_VALIDATION);
    var isValidate = true;
    $currentTabForms.each(function (i, v) {
      isValidate = $(v).valid();
      return isValidate;
    });
    return isValidate;
  };

  !!wizards.length && wizards.each(function (index, value) {
    var $this = $(value);
    var controller = $this.data(DATA_KEY.CONTROLLER);
    var $controller = $(controller);
    var $buttonPrev = $controller.find(Selector.PREVIOUS_BUTTON);
    var $modal = $($this.data(DATA_KEY.ERROR_MODAL));
    var $lottie = $(value).find(Selector.WIZARD_LOTTIE);
    var options = $.extend({
      container: value.querySelector(Selector.WIZARD_LOTTIE),
      renderer: "svg",
      loop: true,
      autoplay: false,
      name: "Hello World"
    }, $lottie.data(DATA_KEY.OPTIONS));
    var animation = window.bodymovin.loadAnimation(options);
    $this.bootstrapWizard({
      tabClass: ClassName.NAV,
      onNext: function onNext(tab, navigation, idx) {
        var $currentTab = $this.find(Selector.TAB_PANE).eq(idx - 1);
        return isFormValidate($currentTab);
      },
      onTabClick: function onTabClick(tab, navigation, idx, clickedIndex) {
        var stepDone = $this.find(".nav-item:nth-child(" + (clickedIndex + 1) + ") .nav-link").data(DATA_KEY.WIZARD_STATE);

        if (stepDone === "done") {
          $modal.modal("show");
          return false;
        }

        if (clickedIndex <= idx) {
          return true;
        }

        var isValid = true;
        $this.find(Selector.TAB_PANE).each(function (tabIndex, tabValue) {
          if (tabIndex < clickedIndex) {
            $this.bootstrapWizard("show", tabIndex);
            isValid = isFormValidate($(tabValue));
          }

          return isValid;
        });
        return isValid;
      },
      onTabShow: function onTabShow(tab, navigation, idx) {
        var length = navigation.find("li").length - 1;
        idx === 0 ? $buttonPrev.hide() : $buttonPrev.show();
        idx === length && setTimeout(function () {
          return animation.play();
        }, 300);
        $this.find(Selector.NAV_LINK).removeClass(ClassName.DONE);
        $this.find(Selector.NAV_ITEM).each(function (i, v) {
          var link = $(v).find(Selector.NAV_LINK);

          if (idx === length && !link.hasClass(ClassName.ACTIVE)) {
            link.attr("data-wizard-state", "done");
          }

          if (!link.hasClass(ClassName.ACTIVE)) {
            link.addClass(ClassName.DONE);
            return true;
          }

          if (idx === length) {
            link.addClass(ClassName.DONE);
            $controller.hide();
          }

          return false;
        });
      }
    });
  });
});
'use strict';
/*-----------------------------------------------
|   Bulk Actions
-----------------------------------------------*/


utils.$document.ready(function () {
  var checkboxBulkSelects = $('.checkbox-bulk-select');

  if (checkboxBulkSelects.length) {
    var Event = {
      CLICK: 'click'
    };
    var Selector = {
      CHECKBOX_BULK_SELECT_CHECKBOX: '.checkbox-bulk-select-target'
    };
    var ClassName = {
      D_NONE: 'd-none'
    };
    var DATA_KEY = {
      CHECKBOX_BODY: 'checkbox-body',
      CHECKBOX_ACTIONS: 'checkbox-actions',
      CHECKBOX_REPLACED_ELEMENT: 'checkbox-replaced-element'
    };
    var Attribute = {
      CHECKED: 'checked',
      INDETERMINATE: 'indeterminate'
    };
    checkboxBulkSelects.each(function (index, value) {
      var checkboxBulkAction = $(value);
      var bulkActions = $(checkboxBulkAction.data(DATA_KEY.CHECKBOX_ACTIONS));
      var replacedElement = $(checkboxBulkAction.data(DATA_KEY.CHECKBOX_REPLACED_ELEMENT));
      var rowCheckboxes = $(checkboxBulkAction.data(DATA_KEY.CHECKBOX_BODY)).find(Selector.CHECKBOX_BULK_SELECT_CHECKBOX);
      checkboxBulkAction.on(Event.CLICK, function () {
        if (checkboxBulkAction.attr(Attribute.INDETERMINATE) === Attribute.INDETERMINATE) {
          bulkActions.addClass(ClassName.D_NONE);
          replacedElement.removeClass(ClassName.D_NONE);
          checkboxBulkAction.prop(Attribute.INDETERMINATE, false).attr(Attribute.INDETERMINATE, false);
          checkboxBulkAction.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
          rowCheckboxes.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
        } else {
          bulkActions.toggleClass(ClassName.D_NONE);
          replacedElement.toggleClass(ClassName.D_NONE);

          if (checkboxBulkAction.attr(Attribute.CHECKED)) {
            checkboxBulkAction.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
          } else {
            checkboxBulkAction.prop(Attribute.CHECKED, true).attr(Attribute.CHECKED, true);
          }

          rowCheckboxes.each(function (i, v) {
            var $this = $(v);

            if ($this.attr(Attribute.CHECKED)) {
              $this.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
            } else {
              $this.prop(Attribute.CHECKED, true).attr(Attribute.CHECKED, true);
            }
          });
        }
      });
      rowCheckboxes.on(Event.CLICK, function (e) {
        var $this = $(e.target);

        if ($this.attr(Attribute.CHECKED)) {
          $this.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
        } else {
          $this.prop(Attribute.CHECKED, true).attr(Attribute.CHECKED, true);
        }

        rowCheckboxes.each(function (i, v) {
          var $elem = $(v);

          if ($elem.attr(Attribute.CHECKED)) {
            checkboxBulkAction.prop(Attribute.INDETERMINATE, true).attr(Attribute.INDETERMINATE, Attribute.INDETERMINATE);
            bulkActions.removeClass(ClassName.D_NONE);
            replacedElement.addClass(ClassName.D_NONE);
            return false;
          }

          if (i === checkboxBulkAction.length) {
            checkboxBulkAction.prop(Attribute.INDETERMINATE, false).attr(Attribute.INDETERMINATE, false);
            checkboxBulkAction.prop(Attribute.CHECKED, false).attr(Attribute.CHECKED, false);
            bulkActions.addClass(ClassName.D_NONE);
            replacedElement.removeClass(ClassName.D_NONE);
          }

          return true;
        });
      });
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Chart
-----------------------------------------------*/


utils.$document.ready(function () {
  /*-----------------------------------------------
  |   Helper functions and Data
  -----------------------------------------------*/
  var chartData = [3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8, 9, 7, 9, 3, 2, 3, 8, 4, 6, 2, 6, 4, 3, 3, 8, 3, 2, 7, 9, 5, 0, 2, 8, 8, 4, 1, 9, 7];
  var labels = ["9:00 AM", "10:00 AM", "11:00 AM", "12:00 PM", "1:00 PM", "2:00 PM", "3:00 PM", "4:00 PM", "5:00 PM", "6:00 PM", "7:00 PM", "8:00 PM"];
  /*-----------------------------------------------
  |   Chart Initialization
  -----------------------------------------------*/

  var newChart = function newChart(chart, config) {
    var ctx = chart.getContext("2d");
    return new window.Chart(ctx, config);
  };
  /*-----------------------------------------------
  |   Line Chart
  -----------------------------------------------*/


  var chartLine = document.getElementById("chart-line");

  if (chartLine) {
    var getChartBackground = function getChartBackground(chart) {
      var ctx = chart.getContext("2d");

      if (storage.isDark) {
        var gradientFill = ctx.createLinearGradient(0, 0, 0, ctx.canvas.height);
        gradientFill.addColorStop(0, utils.rgbaColor(utils.colors.primary, 0.5));
        gradientFill.addColorStop(1, "transparent");
        return gradientFill;
      } else {
        var _gradientFill = ctx.createLinearGradient(0, 0, 0, 250);

        _gradientFill.addColorStop(0, "rgba(255, 255, 255, 0.3)");

        _gradientFill.addColorStop(1, "rgba(255, 255, 255, 0)");

        return _gradientFill;
      }
    };

    var dashboardLineChart = newChart(chartLine, {
      type: "line",
      data: {
        labels: labels.map(function (label) {
          return label.substring(0, label.length - 3);
        }),
        datasets: [{
          borderWidth: 2,
          data: chartData.map(function (d) {
            return (d * 3.14).toFixed(2);
          }),
          borderColor: utils.settings.chart.borderColor,
          backgroundColor: getChartBackground(chartLine)
        }]
      },
      options: {
        legend: {
          display: false
        },
        tooltips: {
          mode: "x-axis",
          xPadding: 20,
          yPadding: 10,
          displayColors: false,
          callbacks: {
            label: function label(tooltipItem) {
              return labels[tooltipItem.index] + " - " + tooltipItem.yLabel + " USD";
            },
            title: function title() {
              return null;
            }
          }
        },
        hover: {
          mode: "label"
        },
        scales: {
          xAxes: [{
            scaleLabel: {
              show: true,
              labelString: "Month"
            },
            ticks: {
              fontColor: utils.rgbaColor("#fff", 0.7),
              fontStyle: 600
            },
            gridLines: {
              color: utils.rgbaColor("#fff", 0.1),
              zeroLineColor: utils.rgbaColor("#fff", 0.1),
              lineWidth: 1
            }
          }],
          yAxes: [{
            display: false
          }]
        }
      }
    });
    $("#dashboard-chart-select").on("change", function (e) {
      var LineDB = {
        all: [4, 1, 6, 2, 7, 12, 4, 6, 5, 4, 5, 10].map(function (d) {
          return (d * 3.14).toFixed(2);
        }),
        successful: [3, 1, 4, 1, 5, 9, 2, 6, 5, 3, 5, 8].map(function (d) {
          return (d * 3.14).toFixed(2);
        }),
        failed: [1, 0, 2, 1, 2, 1, 1, 0, 0, 1, 0, 2].map(function (d) {
          return (d * 3.14).toFixed(2);
        })
      };
      dashboardLineChart.data.datasets[0].data = LineDB[e.target.value];
      dashboardLineChart.update();
    });
  }
  /*-----------------------------------------------
  |   Bar Chart
  -----------------------------------------------*/


  var chartBar = document.getElementById("chart-bar");

  if (chartBar) {
    newChart(chartBar, {
      type: "bar",
      data: {
        labels: labels.slice(0, 2),
        datasets: [{
          label: "First dataset",
          backgroundColor: [utils.rgbaColor(utils.colors.info), utils.rgbaColor(utils.colors.warning)],
          borderColor: [utils.rgbColor(utils.colors.info), utils.rgbColor(utils.colors.warning)],
          borderWidth: 2,
          data: [6, 10]
        }, {
          label: "Second dataset",
          backgroundColor: [utils.rgbaColor(utils.colors.success), utils.rgbaColor(utils.colors.danger)],
          borderColor: [utils.rgbColor(utils.colors.success), utils.rgbColor(utils.colors.danger)],
          borderWidth: 2,
          data: [3, 7]
        }]
      },
      options: {
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true
            }
          }]
        }
      }
    });
  }
  /*-----------------------------------------------
  |   Radar Chart
  -----------------------------------------------*/


  var chartRadar = document.getElementById("chart-radar");

  if (chartRadar) {
    newChart(chartRadar, {
      type: "radar",
      data: {
        labels: labels,
        datasets: [{
          label: "First dataset",
          backgroundColor: utils.rgbaColor(utils.colors.warning),
          borderColor: utils.rgbColor(utils.colors.warning),
          borderWidth: 2,
          data: chartData.slice(0, 12),
          fill: 1
        }, {
          label: "Second dataset",
          backgroundColor: utils.rgbaColor(utils.colors.danger),
          borderColor: utils.rgbColor(utils.colors.danger),
          borderWidth: 2,
          data: chartData.slice(12, 24),
          fill: 1
        }]
      },
      options: {
        maintainAspectRatio: true,
        spanGaps: false,
        elements: {
          line: {
            tension: 0.000001
          }
        }
      }
    });
  }
  /*-----------------------------------------------
  |   Pie Chart
  -----------------------------------------------*/


  var chartPie = document.getElementById("chart-pie");

  if (chartPie) {
    newChart(chartPie, {
      type: "pie",
      data: {
        labels: labels.slice(0, 3),
        datasets: [{
          backgroundColor: utils.rgbaColors(),
          borderColor: utils.rgbColors(),
          data: chartData.slice(0, 3)
        }]
      },
      options: {
        responsive: true
      }
    });
  }
  /*-----------------------------------------------
  |   Doughnut Chart
  -----------------------------------------------*/


  var chartDoughnut = document.getElementById("chart-doughnut");

  if (chartDoughnut) {
    newChart(chartDoughnut, {
      type: "doughnut",
      data: {
        labels: labels.slice(0, 3),
        datasets: [{
          backgroundColor: utils.rgbColors(),
          borderColor: utils.rgbColors(),
          data: chartData.slice(0, 3)
        }]
      },
      options: {
        responsive: true
      }
    });
  }
  /*-----------------------------------------------
  |   Polar Area Chart
  -----------------------------------------------*/


  var chartPolarArea = document.getElementById("chart-polar-area");

  if (chartPolarArea) {
    newChart(chartPolarArea, {
      type: "polarArea",
      data: {
        labels: labels.slice(0, 3),
        datasets: [{
          backgroundColor: utils.rgbaColors(),
          borderColor: utils.rgbaColors(),
          data: chartData.slice(0, 3)
        }]
      },
      options: {
        responsive: true
      }
    });
  }
  /* eslint-disable */

  /*-----------------------------------------------
  |   Polar Bubble
  -----------------------------------------------*/


  var colorize = function colorize(opaque, context) {
    var value = context.dataset.data[context.dataIndex];
    var x = value.x / 100;
    var y = value.y / 100;
    var r = x < 0 && y < 0 ? 250 : x < 0 ? 150 : y < 0 ? 50 : 0;
    var g = x < 0 && y < 0 ? 0 : x < 0 ? 50 : y < 0 ? 150 : 250;
    var b = x < 0 && y < 0 ? 0 : x > 0 && y > 0 ? 250 : 150;
    var a = opaque ? 1 : 0.5 * value.v / 1000;
    return "rgba(" + r + ", " + g + ", " + b + ", " + a + ")";
  };

  var rand = function rand(min, max) {
    var seed = _this._seed;
    min = min === undefined ? 0 : min;
    max = max === undefined ? 1 : max;
    _this._seed = (seed * 9301 + 49297) % 233280;
    return min + _this._seed / 233280 * (max - min);
  };

  var generateData = function generateData() {
    var data = [];
    var DATA_COUNT = 16;
    var MIN_XY = -150;
    var MAX_XY = 100;

    for (var i = 0; i < DATA_COUNT; i += 1) {
      data.push({
        x: rand(MIN_XY, MAX_XY),
        y: rand(MIN_XY, MAX_XY),
        v: rand(0, 1000)
      });
    }

    return data;
  };

  var chartBubble = document.getElementById("chart-bubble");

  if (chartBubble) {
    newChart(chartBubble, {
      type: "bubble",
      data: {
        datasets: [{
          label: ["Deer Population"],
          data: [{
            x: -10,
            y: -20,
            r: 20
          }, {
            x: 100,
            y: 0,
            r: 10
          }, {
            x: 60,
            y: 30,
            r: 20
          }, {
            x: 40,
            y: 60,
            r: 25
          }, {
            x: 80,
            y: 80,
            r: 30
          }, {
            x: 20,
            y: 30,
            r: 25
          }, {
            x: 0,
            y: 100,
            r: 5
          }],
          backgroundColor: "#2C7BE5"
        }]
      }
    });
  }
  /*-----------------------------------------------
  |   Component Line Chart
  -----------------------------------------------*/


  var componentChartLine = document.getElementById("component-chart-line");

  if (componentChartLine) {
    newChart(componentChartLine, {
      type: "line",
      data: {
        labels: labels,
        datasets: [{
          borderWidth: 2,
          data: chartData.slice(2, 14).map(function (d) {
            return (d * 3.14).toFixed(2);
          }),
          borderColor: utils.rgbaColor(utils.colors.primary, 0.4),
          backgroundColor: utils.rgbaColor(utils.colors.primary)
        }, {
          borderWidth: 2,
          borderColor: "#fff",
          data: chartData.slice(3, 15).map(function (d) {
            return (d * 3.14).toFixed(2);
          }),
          backgroundColor: utils.rgbaColor(utils.colors.primary)
        }]
      },
      options: {
        legend: {
          display: false
        },
        tooltips: {
          mode: "x-axis",
          xPadding: 20,
          yPadding: 10,
          displayColors: false,
          callbacks: {
            label: function label(tooltipItem) {
              return labels[tooltipItem.index] + " - " + tooltipItem.yLabel + " USD";
            },
            title: function title() {
              return null;
            }
          }
        },
        hover: {
          mode: "label"
        },
        scales: {
          xAxes: [{
            scaleLabel: {
              show: true,
              labelString: "Month"
            },
            ticks: {
              fontColor: utils.rgbaColor("#000", 0.7),
              fontStyle: 600
            },
            gridLines: {
              // color: utils.rgbaColor('#000', 0.1),
              color: utils.rgbaColor("#000", 0.1),
              zeroLineColor: utils.rgbaColor("#000", 0.1),
              lineWidth: 1
            }
          }],
          yAxes: [{
            display: false
          }]
        }
      }
    });
  }
  /*-----------------------------------------------
  |   Real time user
  -----------------------------------------------*/

  /*-----------------------------------------------
  |   Bar Chart
  -----------------------------------------------*/


  var realTimeUser = document.getElementById("real-time-user");

  if (realTimeUser) {
    var realTimeUserChart = newChart(realTimeUser, {
      type: "bar",
      data: {
        labels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
        datasets: [{
          label: "Users",
          backgroundColor: utils.rgbaColor("#fff", 0.3),
          data: [183, 163, 176, 172, 166, 161, 164, 159, 172, 173, 184, 163, 99, 173, 183, 167, 160, 183, 163, 176, 172, 166, 173, 188, 175],
          barPercentage: 0.9,
          categoryPercentage: 1.0
        }]
      },
      options: {
        legend: {
          display: false
        },
        scales: {
          yAxes: [{
            display: false,
            stacked: true
          }],
          xAxes: [{
            stacked: false,
            ticks: {
              display: false
            },
            gridLines: {
              color: utils.rgbaColor("#fff", 0.1),
              display: false
            }
          }]
        }
      }
    });
    var userCounterDom = $(".real-time-user");
    setInterval(function () {
      var userCounter = Math.floor(Math.random() * (120 - 60) + 60);
      /*-----------------------------------------------
      |   Remove data
      -----------------------------------------------*/

      realTimeUserChart.data.datasets.forEach(function (dataset) {
        dataset.data.shift();
      });
      realTimeUserChart.update();
      /*-----------------------------------------------
      |   Add data
      -----------------------------------------------*/

      setTimeout(function () {
        realTimeUserChart.data.datasets.forEach(function (dataset) {
          dataset.data.push(userCounter);
        });
        realTimeUserChart.update();
        userCounterDom.text(userCounter);
      }, 500);
    }, 2000);
  }
});
'use strict';
/*-----------------------------------------------
|   Chat
-----------------------------------------------*/


utils.$document.ready(function () {
  var Event = {
    CLICK: 'click',
    SHOWN_BS_TAB: 'shown.bs.tab',
    RESIZE: 'resize',
    KEYUP: 'keyup',
    EMOJI_BTN_CLIK: 'emojibtn.click'
  };
  var Selector = {
    CHAT_SIDEBAR: '.chat-sidebar',
    CHAT_CONTACT: '.chat-contact',
    CHAT_CONTENT_SCROLL_AREA: '.chat-content-scroll-area',
    CHAT_CONTENT_HEADER_ACTIVE: '.card-chat-pane.active .chat-content-header',
    CHAT_CONTENT_SCROLL_AREA_ACTIVE: '.card-chat-pane.active .chat-content-scroll-area',
    CARD_CHAT_PANE_ACTIVE: '.card-chat-pane.active',
    CHAT_EMOJIAREA: '.chat-editor-area .emojiarea',
    BTN_SEND: '.btn-send',
    CHAT_FILE_UPLOAD: '.chat-file-upload',
    CARD_CHAT_CONTENT: '.card-chat-content',
    EMOJIONEAREA_EDITOR: '.emojionearea-editor',
    BTN_INFO: '.btn-info',
    CONVERSATION_INFO: '.conversation-info',
    CONTACTS_LIST_SHOW: '.contacts-list-show',
    CHAT_EDITOR_AREA: '.chat-editor-area'
  };
  var ClassName = {
    UNREAD_MESSAGE: 'unread-message',
    TEXT_PRIMARY: 'text-primary',
    SHOW: 'show',
    LEFT_0: 'l-0'
  };
  var DATA_KEY = {
    TARGET: 'target',
    INDEX: 'index'
  };
  var Attribute = {
    STYLE: 'style'
  };
  var $chatSidebar = $(Selector.CHAT_SIDEBAR);
  var $chatContact = $(Selector.CHAT_CONTACT);
  var $chatEmojiarea = $(Selector.CHAT_EMOJIAREA);
  var $chatIcons = $(Selector.BTN_SEND + ',' + Selector.CHAT_FILE_UPLOAD);
  var $btnSend = $(Selector.BTN_SEND);
  var initialEditorHeight = $(Selector.EMOJIONEAREA_EDITOR).outerHeight();
  var $chatContent = $(Selector.CARD_CHAT_CONTENT);
  var $scrollArea = $(Selector.CHAT_CONTENT_SCROLL_AREA);
  var $currentChatArea = document.querySelector(Selector.CHAT_CONTENT_SCROLL_AREA); // Set chat scrollbar area height

  var setChatAreaHeight = function setChatAreaHeight(chatContentArea, editorAreaHeight) {
    var chatContentHeight = chatContentArea.height();
    var calculated = chatContentHeight - editorAreaHeight;
    var chatContentHeaderHeight = $(Selector.CHAT_CONTENT_HEADER_ACTIVE).outerHeight();
    var chatArea = chatContentArea.find(Selector.CHAT_CONTENT_SCROLL_AREA_ACTIVE);
    chatArea.css({
      height: calculated - chatContentHeaderHeight
    });
  }; // Set scrollbar position


  var setScrollbarPosition = function setScrollbarPosition($chatArea) {
    if ($chatArea) {
      var scrollArea = $chatArea;
      scrollArea.scrollTop = $chatArea.scrollHeight;
    }
  };

  setTimeout(function () {
    setScrollbarPosition($currentChatArea);
  }, 700);
  utils.$document.on(Event.CLICK, Selector.CHAT_CONTACT, function (e) {
    var $this = $(e.currentTarget); // Hide contact list sidebar on responsive

    utils.$window.width() < 768 && $chatSidebar.removeClass(ClassName.LEFT_0); // Remove unread-message class when read

    $this.hasClass(ClassName.UNREAD_MESSAGE) && $this.removeClass(ClassName.UNREAD_MESSAGE);
  });
  $chatContact.on(Event.SHOWN_BS_TAB, function (e) {
    var $this = $(e.currentTarget);
    var $tab = $this.data(DATA_KEY.TARGET);
    $chatEmojiarea.length && $chatEmojiarea[0].emojioneArea.setText('');
    var editorHeight = $(Selector.EMOJIONEAREA_EDITOR).outerHeight();
    setChatAreaHeight($chatContent, editorHeight);
    $chatIcons.removeAttr(Attribute.STYLE);
    $btnSend.removeClass(ClassName.TEXT_PRIMARY); // Set scrollbar position on bottom

    var $chatArea = document.querySelector($tab + " " + Selector.CHAT_CONTENT_SCROLL_AREA);
    setScrollbarPosition($chatArea);
  }); // Detect keyup event on EmojioneArea Editor

  if ($chatEmojiarea.length) {
    $chatEmojiarea[0].emojioneArea.on(Event.KEYUP + " " + Event.EMOJI_BTN_CLIK, function ($editor) {
      var textLength = $editor.text().trim().length;
      var _$editor$ = $editor[0],
          offsetWidth = _$editor$.offsetWidth,
          clientWidth = _$editor$.clientWidth;
      var currentEditorHeight = $editor.outerHeight();
      var emojiLength = $editor.find('img').length; // Change color of submit button on keyup

      textLength || emojiLength ? $btnSend.addClass(ClassName.TEXT_PRIMARY) : $btnSend.removeClass(ClassName.TEXT_PRIMARY);

      if (currentEditorHeight !== initialEditorHeight) {
        setChatAreaHeight($chatContent, currentEditorHeight); // Set scrollbar position on bottom

        var tabContentId = $chatContent.find(Selector.CARD_CHAT_PANE_ACTIVE).attr('id');
        var $chatArea = document.querySelector("#" + tabContentId + " " + Selector.CHAT_CONTENT_SCROLL_AREA);
        setScrollbarPosition($chatArea);
      } // Align file upload and send icons when editor overflow scroll


      $chatIcons.css({
        marginRight: offsetWidth === clientWidth ? 0 : '1rem'
      });
      initialEditorHeight = currentEditorHeight;
    });
  } // Open conversation info sidebar


  utils.$document.on(Event.CLICK, Selector.BTN_INFO, function (e) {
    var $this = $(e.currentTarget);
    var dataIndex = $this.data(DATA_KEY.INDEX);
    var $info = $(Selector.CONVERSATION_INFO + "[data-" + DATA_KEY.INDEX + "='" + dataIndex + "']");
    $info.toggleClass(ClassName.SHOW);
  }); // Show contact list sidebar on responsive

  utils.$document.on(Event.CLICK, Selector.CONTACTS_LIST_SHOW, function () {
    $chatSidebar.addClass(ClassName.LEFT_0);
  }); // Set scrollbar area height on resize

  utils.$window.on(Event.RESIZE, function () {
    if ($scrollArea.length) {
      var editorCurrentHeight = $(Selector.EMOJIONEAREA_EDITOR).outerHeight();
      setChatAreaHeight($chatContent, editorCurrentHeight);
      var chatArea = document.querySelector(Selector.CHAT_CONTENT_SCROLL_AREA_ACTIVE);
      setScrollbarPosition(chatArea);
    }
  });
});
"use strict";
/*-----------------------------------------------
|   Copy link
-----------------------------------------------*/


utils.$document.ready(function () {
  $("#copyLinkModal").on("shown.bs.modal", function () {
    $(".invitation-link").focus().select();
  });
  utils.$document.on("click", "[data-copy]", function (e) {
    var $this = $(e.currentTarget);
    var targetID = $this.data("copy");
    $(targetID).focus().select();
    document.execCommand("copy");
    $this.attr("title", "Copied!").tooltip("_fixTitle").tooltip("show").attr("title", "Copy to clipboard").tooltip("_fixTitle");
  });
});
'use strict';
/*-----------------------------------------------
|   Count Up
-----------------------------------------------*/


utils.$document.ready(function () {
  var $counters = $('[data-countup]');

  if ($counters.length) {
    $counters.each(function (index, value) {
      var $counter = $(value);
      var counter = $counter.data('countup');

      var toAlphanumeric = function toAlphanumeric(num) {
        var number = num;
        var abbreviations = {
          k: 1000,
          m: 1000000,
          b: 1000000000,
          t: 1000000000000
        };

        if (num < abbreviations.m) {
          number = (num / abbreviations.k).toFixed(2) + "k";
        } else if (num < abbreviations.b) {
          number = (num / abbreviations.m).toFixed(2) + "m";
        } else if (num < abbreviations.t) {
          number = (num / abbreviations.b).toFixed(2) + "b";
        } else {
          number = (num / abbreviations.t).toFixed(2) + "t";
        }

        return number;
      };

      var toComma = function toComma(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
      };

      var toSpace = function toSpace(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
      };

      var playCountUpTriggered = false;

      var countUP = function countUP() {
        if (utils.isScrolledIntoView(value) && !playCountUpTriggered) {
          if (!playCountUpTriggered) {
            $({
              countNum: 0
            }).animate({
              countNum: counter.count
            }, {
              duration: counter.duration || 1000,
              easing: 'linear',
              step: function step() {
                $counter.text((counter.prefix ? counter.prefix : '') + Math.floor(this.countNum));
              },
              complete: function complete() {
                switch (counter.format) {
                  case 'comma':
                    $counter.text((counter.prefix ? counter.prefix : '') + toComma(this.countNum));
                    break;

                  case 'space':
                    $counter.text((counter.prefix ? counter.prefix : '') + toSpace(this.countNum));
                    break;

                  case 'alphanumeric':
                    $counter.text((counter.prefix ? counter.prefix : '') + toAlphanumeric(this.countNum));
                    break;

                  default:
                    $counter.text((counter.prefix ? counter.prefix : '') + this.countNum);
                }
              }
            });
            playCountUpTriggered = true;
          }
        }

        return playCountUpTriggered;
      };

      countUP();
      utils.$window.scroll(function () {
        countUP();
      });
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Data table
-----------------------------------------------*/


utils.$document.ready(function () {
  var dataTables = $('.data-table');

  var customDataTable = function customDataTable(elem) {
    elem.find('.pagination').addClass('pagination-sm');
  };

  dataTables.length && dataTables.each(function (index, value) {
    var $this = $(value);
    var options = $.extend({
      responsive: true,
      dom: "<'row mx-1'<'col-sm-12 col-md-6 px-3'l><'col-sm-12 col-md-6 px-3'f>>" + "<'table-responsive'tr>" + "<'row mx-1 align-items-center justify-content-center justify-content-md-between'<'col-auto mb-2 mb-sm-0'i><'col-auto'p>>"
    }, $this.data('options'));
    $this.DataTable(options);
    var $wrpper = $this.closest('.dataTables_wrapper');
    customDataTable($wrpper);
    $this.on('draw.dt', function () {
      return customDataTable($wrpper);
    });
  });
});
'use strict';
/*-----------------------------------------------
|   Countdown
-----------------------------------------------*/


utils.$document.ready(function () {
  var $dataCountdowns = $('[data-countdown]');
  var DATA_KEY = {
    FALLBACK: 'countdown-fallback',
    COUNTDOWN: 'countdown'
  };

  if ($dataCountdowns.length) {
    $dataCountdowns.each(function (index, value) {
      var $dateCountdown = $(value);
      var date = $dateCountdown.data(DATA_KEY.COUNTDOWN);
      var fallback;

      if (typeof $dateCountdown.data(DATA_KEY.FALLBACK) !== typeof undefined) {
        fallback = $dateCountdown.data(DATA_KEY.FALLBACK);
      }

      $dateCountdown.countdown(date, function (event) {
        if (event.elapsed) {
          $dateCountdown.text(fallback);
        } else {
          $dateCountdown.text(event.strftime('%D days %H:%M:%S'));
        }
      });
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Documentation and Component Navigation
-----------------------------------------------*/


utils.$document.ready(function () {
  var $componentNav = $('#components-nav');

  if ($componentNav.length) {
    var loc = window.location.href;

    var _loc$split = loc.split('#');

    loc = _loc$split[0];
    var location = loc.split('/');
    var url = location[location.length - 2] + "/" + location.pop();
    var urls = $componentNav.children('li').children('a');

    for (var i = 0, max = urls.length; i < max; i += 1) {
      var dom = urls[i].href.split('/');
      var domURL = dom[dom.length - 2] + "/" + dom.pop();

      if (domURL === url) {
        var $targetedElement = $(urls[i]);
        $targetedElement.removeClass('text-800');
        $targetedElement.addClass('font-weight-medium');
        break;
      }
    }
  }
});
'use strict';
/*-----------------------------------------------
|   Dashboard Table dropdown
-----------------------------------------------*/


utils.$document.ready(function () {
  // Only for ios
  if (window.is.ios()) {
    var Event = {
      SHOWN_BS_DROPDOWN: 'shown.bs.dropdown',
      HIDDEN_BS_DROPDOWN: 'hidden.bs.dropdown'
    };
    var Selector = {
      TABLE_RESPONSIVE: '.table-responsive',
      DROPDOWN_MENU: '.dropdown-menu'
    };
    $(Selector.TABLE_RESPONSIVE).on(Event.SHOWN_BS_DROPDOWN, function dashboardTableDropdown(e) {
      var t = $(this),
          m = $(e.target).find(Selector.DROPDOWN_MENU),
          tb = t.offset().top + t.height(),
          mb = m.offset().top + m.outerHeight(true),
          d = 20; // Space for shadow + scrollbar.

      if (t[0].scrollWidth > t.innerWidth()) {
        if (mb + d > tb) {
          t.css('padding-bottom', mb + d - tb);
        }
      } else {
        t.css('overflow', 'visible');
      }
    }).on(Event.HIDDEN_BS_DROPDOWN, function (e) {
      var $this = $(e.currentTarget);
      $this.css({
        'padding-bottom': '',
        overflow: ''
      });
    });
  }
}); // Reference
// https://github.com/twbs/bootstrap/issues/11037#issuecomment-274870381

'use strict';
/*-----------------------------------------------
|   Documentation and Component Navigation
-----------------------------------------------*/


utils.$document.ready(function () {
  var Selector = {
    NAVBAR_THEME_DROPDOWN: '.navbar-theme .dropdown',
    DROPDOWN_ON_HOVER: '.dropdown-on-hover',
    DATA_TOGGLE_DROPDOWN: '[data-toggle="dropdown"]',
    BODY: 'body'
  };
  var ClassName = {
    DROPDOWN_ON_HOVER: 'dropdown-on-hover'
  };
  var Event = {
    CLICK: 'click',
    MOUSE_LEAVE: 'mouseleave',
    MOUSE_EVENT: 'mouseenter mouseleave'
  };
  var $navbarDropdown = $(Selector.NAVBAR_THEME_DROPDOWN);
  !window.is.mobile() ? $navbarDropdown.addClass(ClassName.DROPDOWN_ON_HOVER) : $navbarDropdown.removeClass(ClassName.DROPDOWN_ON_HOVER);

  var toggleDropdown = function toggleDropdown(e) {
    var $el = $(e.target);
    var dropdown = $el.closest(Selector.DROPDOWN_ON_HOVER);
    var btnDropdown = dropdown.find(Selector.DATA_TOGGLE_DROPDOWN);
    setTimeout(function () {
      var shouldOpen = e.type !== Event.CLICK && dropdown.is(':hover');
      shouldOpen ? btnDropdown.dropdown('show') : btnDropdown.dropdown('hide');
    }, e.type === Event.MOUSE_LEAVE ? 100 : 0);
  };

  $(Selector.BODY).on(Event.MOUSE_EVENT, Selector.DROPDOWN_ON_HOVER, toggleDropdown);
});
'use strict';
/*-----------------------------------------------
|   Dropzone
-----------------------------------------------*/


window.Dropzone ? window.Dropzone.autoDiscover = false : '';
utils.$document.ready(function () {
  var Selector = {
    DROPZONE: '[data-dropzone]',
    DZ_ERROR_MESSAGE: '.dz-error-message',
    DZ_PREVIEW: '.dz-preview',
    DZ_PROGRESS: '.dz-preview .dz-preview-cover .dz-progress',
    DZ_PREVIEW_COVER: '.dz-preview .dz-preview-cover'
  };
  var ClassName = {
    DZ_FILE_PROCESSING: 'dz-file-processing',
    DZ_FILE_COMPLETE: 'dz-file-complete',
    DZ_COMPLETE: 'dz-complete',
    DZ_PROCESSING: 'dz-processing'
  };
  var DATA_KEY = {
    OPTIONS: 'options'
  };
  var Events = {
    ADDED_FILE: 'addedfile',
    COMPLETE: 'complete'
  };
  var dropzones = $(Selector.DROPZONE);
  !!dropzones.length && dropzones.each(function (index, value) {
    var element = value;
    var $this = $(element);
    var userOptions = $this.data(DATA_KEY.OPTIONS);
    userOptions = userOptions ? userOptions : {};
    var data = userOptions.data ? userOptions.data : {};
    var options = $.extend({
      url: '/assets/php/',
      addRemoveLinks: false,
      previewsContainer: element.querySelector(Selector.DZ_PREVIEW),
      previewTemplate: element.querySelector(Selector.DZ_PREVIEW).innerHTML,
      thumbnailWidth: null,
      thumbnailHeight: null,
      init: function init() {
        var thisDropzone = this;

        if (data.length) {
          $.each(data, function (i, v) {
            var mockFile = {
              name: v.name,
              size: v.size
            };
            thisDropzone.options.addedfile.call(thisDropzone, mockFile);
            thisDropzone.options.thumbnail.call(thisDropzone, mockFile, v.url + "/" + v.name);
          });
        }

        thisDropzone.on(Events.ADDED_FILE, function addedfile() {
          if ('maxFiles' in userOptions) {
            if (userOptions.maxFiles === 1 && $this.find(Selector.DZ_PREVIEW_COVER).length > 1) {
              $this.find(Selector.DZ_PREVIEW_COVER).first().remove();
            }

            if (userOptions.maxFiles === 1 && this.files.length > 1) {
              this.removeFile(this.files[0]);
            }
          }
        });
      }
    }, userOptions);
    element.querySelector(Selector.DZ_PREVIEW).innerHTML = '';
    var dropzone = new window.Dropzone(value, options);
    dropzone.on(Events.ADDED_FILE, function () {
      $this.find(Selector.DZ_PREVIEW_COVER).removeClass(ClassName.DZ_FILE_COMPLETE);
      $this.addClass(ClassName.DZ_FILE_PROCESSING);
    });
    dropzone.on(Events.COMPLETE, function () {
      $this.find(Selector.DZ_PREVIEW_COVER).removeClass(ClassName.DZ_PROCESSING);
      $this.addClass(ClassName.DZ_FILE_COMPLETE);
    });
  });
});
'use strict';
/*-----------------------------------------------
|   On page scroll for #id targets
-----------------------------------------------*/


utils.$document.ready(function ($) {
  $('a[data-fancyscroll]').click(function scrollTo(e) {
    // const $this = $(e.currentTarget);
    var $this = $(this);

    if (utils.location.pathname === $this[0].pathname && utils.location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '') && utils.location.hostname === this.hostname) {
      e.preventDefault();
      var target = $(this.hash);
      target = target.length ? target : $("[name=" + this.hash.slice(1) + "]");

      if (target.length) {
        $('html,body').animate({
          scrollTop: target.offset().top - ($this.data('offset') || 0)
        }, 400, 'swing', function () {
          var hash = $this.attr('href');
          window.history.pushState ? window.history.pushState(null, null, hash) : window.location.hash = hash;
        });
        return false;
      }
    }

    return true;
  });
  var hash = window.location.hash;

  if (hash && document.getElementById(hash.slice(1))) {
    var $this = $(hash);
    $('html,body').animate({
      scrollTop: $this.offset().top - $("a[href='" + hash + "']").data('offset')
    }, 400, 'swing', function () {
      window.history.pushState ? window.history.pushState(null, null, hash) : window.location.hash = hash;
    });
  }
});
"use strict";
/*-----------------------------------------------
|   File Input
-----------------------------------------------*/


utils.$document.ready(function () {
  $(".custom-file-input").on("change", function (e) {
    var $this = $(e.currentTarget);
    var fileName = $this.val().split("\\").pop();
    $this.next(".custom-file-label").addClass("selected").html(fileName);
  });
});
'use strict'; // /*-----------------------------------------------
// |   Full Calendar
// -----------------------------------------------*/


var merge = window._.merge;

var renderCalendar = function renderCalendar(el, option) {
  var options = merge({
    themeSystem: 'bootstrap',
    initialView: 'dayGridMonth',
    editable: true,
    direction: $('html').attr('dir'),
    headerToolbar: {
      left: 'prev,next today',
      center: 'title',
      right: 'dayGridMonth,timeGridWeek,timeGridDay'
    },
    buttonText: {
      month: 'Month',
      week: 'Week',
      day: 'Day'
    }
  }, option);
  var calendar = window.FullCalendar && new window.FullCalendar.Calendar(el, options);
  calendar.render();
  $('.navbar-vertical-toggle').on('navbar.vertical.toggle', function () {
    return calendar.updateSize();
  });
  return calendar;
};

utils.$document.ready(function () {
  var calendars = $('[data-calendar]');

  if (calendars.length) {
    calendars.each(function (index, calendar) {
      renderCalendar(calendar, JSON.parse(calendar.dataset['calendar']));
    });
  }

  window.FontAwesome.config.autoReplaceSvg = 'nest';
});
'use strict';
/*-----------------------------------------------
|   Jquery Validation
-----------------------------------------------*/


utils.$document.ready(function () {
  var forms = $('.form-validation');
  forms.length && forms.each(function (index, value) {
    var $this = $(value);
    var options = $.extend({}, $this.data('options'));
    $this.validate(options);
  });
});
'use strict';
/*-----------------------------------------------
|   Lightbox
-----------------------------------------------*/

/*
  global lightbox
*/


utils.$document.ready(function () {
  if ($('[data-lightbox]').length) {
    lightbox.option({
      resizeDuration: 400,
      wrapAround: true,
      fadeDuration: 300,
      imageFadeDuration: 300
    });
  }
});
"use strict";
/*-----------------------------------------------
|   Lottie
-----------------------------------------------*/


utils.$document.ready(function () {
  var lotties = $(".lottie");

  if (lotties.length) {
    lotties.each(function (index, value) {
      var $this = $(value);
      var options = $.extend({
        container: value,
        path: "../img/animated-icons/warning-light.json",
        renderer: "svg",
        loop: true,
        autoplay: true,
        name: "Hello World"
      }, $this.data("options"));
      window.bodymovin.loadAnimation(options);
    });
  }
});
"use strict";
/*-----------------------------------------------
|   Modal
-----------------------------------------------*/


utils.$document.ready(function () {
  var Selector = {
    MODAL_THEME: ".modal-theme"
  };
  var DataKey = {
    OPTIONS: "options"
  };
  var Events = {
    HIDDEN_BS_MODAL: "hidden.bs.modal"
  };
  var modals = $(Selector.MODAL_THEME);
  var showModal = true;

  if (!!modals.length) {
    modals.each(function (index, value) {
      var $this = $(value);
      var userOptions = $this.data(DataKey.OPTIONS);
      var options = $.extend({
        autoShow: false,
        autoShowDelay: 0,
        showOnce: false
      }, userOptions);

      if (options.showOnce) {
        var modal = utils.getCookie("modal");
        showModal = modal === null ? true : false;
      }

      if (options.autoShow && showModal) {
        setTimeout(function () {
          $this.modal("show");
        }, options.autoShowDelay);
      }
    });
  }

  $(Selector.MODAL_THEME).on(Events.HIDDEN_BS_MODAL, function (e) {
    var $this = $(e.currentTarget);
    var userOptions = $this.data(DataKey.OPTIONS);
    var options = $.extend({
      cookieExpireTime: 7200000,
      showOnce: false
    }, userOptions);
    options.showOnce && utils.setCookie("modal", false, options.cookieExpireTime);
  });
});
"use strict";
/*-----------------------------------------------
|   Navbar Top
-----------------------------------------------*/


utils.$document.ready(function () {
  var Selectors = {
    COLLAPSE: ".collapse",
    NAVBAR_NAV: ".navbar-nav",
    NAVBAR_TOP_COMBO: ".navbar-top-combo",
    NAVBAR_VERTICAL: ".navbar-vertical",
    NAVBAR_VERTICAL_DIVIDER: ".navbar-vertical-divider",
    NAVBAR_TOP_COMBO_COLLAPSE: ".navbar-top-combo .collapse",
    MOVEABLE_CONTENT: "[data-move-container]"
  };
  var CLASS_NAME = {
    FLEX_COLUMN: "flex-column"
  };
  var DATA_KEYS = {
    MOVE_TARGET: "move-target"
  };
  var $navbarTop = $(Selectors.NAVBAR_TOP_COMBO);
  var $navbarVertical = $(Selectors.NAVBAR_VERTICAL);
  var navbarTopBreakpoint = utils.getBreakpoint($navbarTop);
  var navbarVertcicalBreakpoint = utils.getBreakpoint($navbarVertical);

  var moveNavContent = function moveNavContent(width) {
    if (width < navbarTopBreakpoint) {
      var $navbarTopCollapse = $navbarTop.find(Selectors.COLLAPSE);
      var navbarTopContent = $navbarTopCollapse.html();

      if (navbarTopContent) {
        $navbarTopCollapse.html("");
        var divider = "<div class='navbar-vertical-divider'><hr class='navbar-vertical-hr' /></div>";
        navbarTopContent = "<div data-move-container>" + divider + navbarTopContent + "</div>";
        var targetID = $navbarTop.data(DATA_KEYS.MOVE_TARGET);
        $(navbarTopContent).insertAfter(targetID);
        navbarTopBreakpoint > navbarVertcicalBreakpoint && $(Selectors.MOVEABLE_CONTENT).find(Selectors.NAVBAR_NAV).addClass(CLASS_NAME.FLEX_COLUMN);
      }
    } else {
      var $container = $(Selectors.MOVEABLE_CONTENT);
      var $navbarNav = $container.find(Selectors.NAVBAR_NAV);
      $navbarNav.hasClass(CLASS_NAME.FLEX_COLUMN) && $navbarNav.removeClass(CLASS_NAME.FLEX_COLUMN);
      $container.find(Selectors.NAVBAR_VERTICAL_DIVIDER).remove();
      var content = $container.html();
      $container.remove();
      $(Selectors.NAVBAR_TOP_COMBO_COLLAPSE).html(content);
    }
  };

  moveNavContent(utils.$window.outerWidth());
  utils.$window.on("resize", function () {
    moveNavContent(utils.$window.outerWidth());
  });
});
'use strict';
/*-----------------------------------------------
|   Cookie Notice
-----------------------------------------------*/


utils.$document.ready(function () {
  var Selector = {
    NOTICE: '.notice',
    DATA_TOGGLE_NOTICE: "[data-toggle='notice']"
  };
  var DataKeys = {
    OPTIONS: 'options'
  };
  var CookieNames = {
    COOKIE_NOTICE: 'cookieNotice'
  };
  var Events = {
    CLICK: 'click',
    HIDDEN_BS_TOAST: 'hidden.bs.toast'
  };
  var $notices = $(Selector.NOTICE);
  var defaultOptions = {
    autoShow: false,
    autoShowDelay: 0,
    showOnce: false,
    cookieExpireTime: 3600000
  };
  $notices.each(function (index, value) {
    var $this = $(value);
    var options = $.extend(defaultOptions, $this.data(DataKeys.OPTIONS));
    var cookieNotice;

    if (options.showOnce) {
      cookieNotice = utils.getCookie(CookieNames.COOKIE_NOTICE);
    }

    if (options.autoShow && cookieNotice === null) {
      setTimeout(function () {
        return $this.toast('show');
      }, options.autoShowDelay);
    }
  });
  $(Selector.NOTICE).on(Events.HIDDEN_BS_TOAST, function (e) {
    var $this = $(e.currentTarget);
    var options = $.extend(defaultOptions, $this.data(DataKeys.OPTIONS));
    options.showOnce && utils.setCookie(CookieNames.COOKIE_NOTICE, false, options.cookieExpireTime);
  });
  utils.$document.on(Events.CLICK, Selector.DATA_TOGGLE_NOTICE, function (e) {
    e.preventDefault();
    var $this = $(e.currentTarget);
    var $target = $($this.attr('href'));
    $target.hasClass('show') ? $target.toast('hide') : $target.toast('show');
  });
});
'use strict';
/*-----------------------------------------------
|   Owl Carousel
-----------------------------------------------*/


var $carousel = $('.owl-carousel');
utils.$document.ready(function () {
  if ($carousel.length) {
    var Selector = {
      ALL_TIMELINE: '*[data-zanim-timeline]',
      ACTIVE_ITEM: '.owl-item.active'
    };
    var owlZanim = {
      zanimTimeline: function zanimTimeline($el) {
        return $el.find(Selector.ALL_TIMELINE);
      },
      play: function play($el) {
        if (this.zanimTimeline($el).length === 0) return;
        $el.find(Selector.ACTIVE_ITEM + " > " + Selector.ALL_TIMELINE).zanimation(function (animation) {
          animation.play();
        });
      },
      kill: function kill($el) {
        if (this.zanimTimeline($el).length === 0) return;
        this.zanimTimeline($el).zanimation(function (animation) {
          animation.kill();
        });
      }
    };
    $carousel.each(function (index, value) {
      var $this = $(value);
      var options = $this.data('options') || {};
      utils.isRTL() && (options.rtl = true);
      options.navText || (options.navText = ['<span class="fas fa-angle-left"></span>', '<span class="fas fa-angle-right"></span>']);
      options.touchDrag = true;
      $this.owlCarousel($.extend(options || {}, {
        onInitialized: function onInitialized(event) {
          owlZanim.play($(event.target));
        },
        onTranslate: function onTranslate(event) {
          owlZanim.kill($(event.target));
        },
        onTranslated: function onTranslated(event) {
          owlZanim.play($(event.target));
        }
      }));
    });
  }

  var $controllers = $('[data-owl-carousel-controller]');

  if ($controllers.length) {
    $controllers.each(function (index, value) {
      var $this = $(value);
      var $thumbs = $($this.data('owl-carousel-controller'));
      $thumbs.find('.owl-item:first-child').addClass('current');
      $thumbs.on('click', '.item', function (e) {
        var thumbIndex = $(e.target).parents('.owl-item').index();
        $('.owl-item').removeClass('current');
        $(e.target).parents('.owl-item').addClass('current');
        $this.trigger('to.owl.carousel', thumbIndex, 500);
      });
      $this.on('changed.owl.carousel', function (e) {
        var itemIndex = e.item.index;
        var item = itemIndex + 1;
        $('.owl-item').removeClass('current');
        $thumbs.find(".owl-item:nth-child(" + item + ")").addClass('current');
        $thumbs.trigger('to.owl.carousel', itemIndex, 500);
      });
    });
  } // Refresh owlCarousel


  $('.navbar-vertical-toggle').on('navbar.vertical.toggle', function () {
    $carousel.length && $carousel.owlCarousel('refresh');
  });
});
'use strict';
/*-----------------------------------------------
|   Perfect Scrollbar
-----------------------------------------------*/


utils.$document.ready(function () {
  if (window.is.ie() || window.is.edge()) {
    var scrollbars = document.querySelectorAll('.perfect-scrollbar');

    if (scrollbars.length) {
      $.each(scrollbars, function (item, value) {
        var $this = $(value);
        var userOptions = $this.data('options');
        var options = $.extend({
          wheelPropagation: true,
          suppressScrollX: true,
          suppressScrollY: false
        }, userOptions);
        var ps = new PerfectScrollbar(value, options);
        ps.update();
      });
    }
  }
});
'use strict';
/*-----------------------------------------------
|   Inline Player [plyr]
-----------------------------------------------*/

/*
  global Plyr
*/


utils.$document.ready(function () {
  var $players = $('.player');

  if ($players.length) {
    $players.each(function (index, value) {
      return new Plyr($(value), {
        captions: {
          active: true
        }
      });
    });
  }

  return false;
});
'use strict';
/* -------------------------------------------------------------------------- */

/*                             Autocomplete Search                            */

/* -------------------------------------------------------------------------- */


utils.$document.ready(function () {
  var Selectors = {
    DROPDOWN: '.dropdown',
    SEARCH_DISMISS: '[data-dismiss="search"]',
    DROPDOWN_TOGGLE: '[data-toggle="dropdown"]',
    SEARCH_BOX: '.search-box',
    SEARCH_INPUT: '.search-input',
    SEARCH_TOGGLE: '[data-toggle="search"]'
  };
  var Events = {
    CLICK: 'click',
    FOCUS: 'focus',
    SHOW_BS_DROPDOWN: 'show.bs.dropdown'
  };
  var $searchAreas = $(Selectors.SEARCH_BOX);

  var hideSearchSuggestion = function hideSearchSuggestion(searchArea) {
    var el = searchArea.querySelector(Selectors.SEARCH_TOGGLE);
    var dropdown = $(el).dropdown();
    dropdown == null ? void 0 : dropdown.dropdown('hide');
  };

  var hideAllSearchAreas = function hideAllSearchAreas() {
    $searchAreas.each(function (index, value) {
      return hideSearchSuggestion(value);
    });
  };

  $searchAreas.each(function (index, value) {
    var input = value.querySelector(Selectors.SEARCH_INPUT);
    var btnDropdownClose = value.querySelector(Selectors.SEARCH_DISMISS);
    input.addEventListener(Events.FOCUS, function () {
      hideAllSearchAreas();
      var el = value.querySelector(Selectors.SEARCH_TOGGLE);
      var dropdown = $(el).dropdown();
      dropdown.dropdown('show');
    });
    document.addEventListener(Events.CLICK, function (_ref) {
      var target = _ref.target;
      !value.contains(target) && hideSearchSuggestion(value);
    });
    btnDropdownClose && btnDropdownClose.addEventListener(Events.CLICK, function () {
      hideSearchSuggestion(value);
      input.value = '';
    });
  });
  $(Selectors.DROPDOWN).on(Events.SHOW_BS_DROPDOWN, function () {
    return hideAllSearchAreas();
  });
});
'use strict';
/*-----------------------------------------------
|   Select2
-----------------------------------------------*/


utils.$document.ready(function () {
  var select2 = $('.selectpicker');
  select2.length && select2.each(function (index, value) {
    var $this = $(value);
    var options = $.extend({
      theme: 'bootstrap4'
    }, $this.data('options'));
    $this.select2(options);
  });
});
'use strict';
/*-----------------------------------------------
|   Tabs
-----------------------------------------------*/


utils.$document.ready(function () {
  var $fancyTabs = $('.fancy-tab');

  if ($fancyTabs.length) {
    var Selector = {
      TAB_BAR: '.nav-bar',
      TAB_BAR_ITEM: '.nav-bar-item',
      TAB_CONTENTS: '.tab-contents'
    };
    var ClassName = {
      ACTIVE: 'active',
      TRANSITION_REVERSE: 'transition-reverse',
      TAB_INDICATOR: 'tab-indicator'
    };
    /*-----------------------------------------------
    |   Function for active tab indicator change
    -----------------------------------------------*/

    var updateIncicator = function updateIncicator($indicator, $tabs, $tabnavCurrentItem) {
      var _$tabnavCurrentItem$p = $tabnavCurrentItem.position(),
          left = _$tabnavCurrentItem$p.left;

      var right = $tabs.children(Selector.TAB_BAR).outerWidth() - (left + $tabnavCurrentItem.outerWidth());
      $indicator.css({
        left: left,
        right: right
      });
    };

    $fancyTabs.each(function (index, value) {
      var $tabs = $(value);
      var $navBar = $tabs.children(Selector.TAB_BAR);
      var $tabnavCurrentItem = $navBar.children(Selector.TAB_BAR_ITEM + "." + ClassName.ACTIVE);
      $navBar.append("\n        <div class=" + ClassName.TAB_INDICATOR + "></div>\n      ");
      var $indicator = $navBar.children("." + ClassName.TAB_INDICATOR);
      var $preIndex = $tabnavCurrentItem.index();
      updateIncicator($indicator, $tabs, $tabnavCurrentItem);
      $navBar.children(Selector.TAB_BAR_ITEM).click(function (e) {
        $tabnavCurrentItem = $(e.currentTarget);
        var $currentIndex = $tabnavCurrentItem.index();
        var $tabContent = $tabs.children(Selector.TAB_CONTENTS).children().eq($currentIndex);
        $tabnavCurrentItem.siblings().removeClass(ClassName.ACTIVE);
        $tabnavCurrentItem.addClass(ClassName.ACTIVE);
        $tabContent.siblings().removeClass(ClassName.ACTIVE);
        $tabContent.addClass(ClassName.ACTIVE);
        /*-----------------------------------------------
        |   Indicator Transition
        -----------------------------------------------*/

        updateIncicator($indicator, $tabs, $tabnavCurrentItem);

        if ($currentIndex - $preIndex <= 0) {
          $indicator.addClass(ClassName.TRANSITION_REVERSE);
        } else {
          $indicator.removeClass(ClassName.TRANSITION_REVERSE);
        }

        $preIndex = $currentIndex;
      });
      utils.$window.on('resize', function () {
        updateIncicator($indicator, $tabs, $tabnavCurrentItem);
      });
    });
  }
  /*-----------------------------------------------
  |   Product Review Tab
  -----------------------------------------------*/


  var $review = $("[data-tab-target]");
  $review.click(function (e) {
    var $this = $(e.currentTarget);
    var $reviewTab = $($this.data('tab-target'));
    $reviewTab.trigger('click');
  });
});
/*-----------------------------------------------
|   TINYMCE
-----------------------------------------------*/

utils.$document.ready(function () {
  var tinymces = $('.tinymce');

  if (tinymces.length) {
    window.tinymce.init({
      selector: '.tinymce',
      height: '50vh',
      menubar: false,
      skin: utils.settings.tinymce.theme,
      content_style: ".mce-content-body { color: " + utils.grays.black + " }",
      mobile: {
        theme: 'mobile',
        toolbar: ['undo', 'bold']
      },
      statusbar: false,
      plugins: 'link,image,lists,table,media',
      toolbar: 'styleselect | bold italic link bullist numlist image blockquote table media undo redo'
    });
  }
});
'use strict';
/*-----------------------------------------------
|   Toast [bootstrap 4]
-----------------------------------------------*/


utils.$document.ready(function () {
  return $('.toast').toast();
});
'use strict';
/*-----------------------------------------------
|   Toastr
-----------------------------------------------*/


utils.$document.ready(function () {
  var $notifications = $('[data-notification]');
  $notifications.each(function (index, value) {
    var _window = window,
        toastr = _window.toastr;
    var $this = $(value);
    var config = $this.data('notification');
    var defaultOptions = {
      closeButton: true,
      newestOnTop: false,
      positionClass: 'toast-bottom-right'
    };
    $this.on('click', function () {
      var type = config.type,
          title = config.title,
          message = config.message;
      var mergedOptions = $.extend(defaultOptions, config);
      toastr.options.positionClass !== mergedOptions.positionClass && toastr.remove();
      toastr.options = mergedOptions;

      switch (type) {
        case 'success':
          toastr.success(message, title);
          break;

        case 'warning':
          toastr.warning(message, title);
          break;

        case 'error':
          toastr.error(message, title);
          break;

        default:
          toastr.info(message, title);
          break;
      }
    });
  });
});
'use strict';
/*-----------------------------------------------
|   Typed Text
-----------------------------------------------*/

/*
  global Typed
 */


utils.$document.ready(function () {
  var typedText = $('.typed-text');

  if (typedText.length) {
    typedText.each(function (index, value) {
      return new Typed(value, {
        strings: $(value).data('typed-text'),
        typeSpeed: 100,
        loop: true,
        backDelay: 1500
      });
    });
  }
});